// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelClusterError {
    /// Kind of error that occurred.
    pub kind: CancelClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelClusterErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelClusterErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            CancelClusterErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CancelClusterErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            CancelClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelClusterError {
    fn code(&self) -> Option<&str> {
        CancelClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelClusterError {
    /// Creates a new `CancelClusterError`.
    pub fn new(kind: CancelClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelClusterErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelClusterErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelClusterErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelClusterErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelClusterErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelClusterErrorKind::KmsRequestFailedException(_)
        )
    }
}
impl std::error::Error for CancelClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelClusterErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            CancelClusterErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CancelClusterErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            CancelClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::InvalidJobStateException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::InvalidResourceException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::KmsRequestFailedException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            CancelJobErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CancelJobErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAddressError {
    /// Kind of error that occurred.
    pub kind: CreateAddressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAddressErrorKind {
    /// <p>The address provided was invalid. Check the address with your region's carrier, and try again.</p>
    InvalidAddressException(crate::error::InvalidAddressException),
    /// <p>The address is either outside the serviceable area for your region, or an error occurred. Check the address with your region's carrier and try again. If the issue persists, contact Amazon Web Services Support.</p>
    UnsupportedAddressException(crate::error::UnsupportedAddressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAddressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAddressErrorKind::InvalidAddressException(_inner) => _inner.fmt(f),
            CreateAddressErrorKind::UnsupportedAddressException(_inner) => _inner.fmt(f),
            CreateAddressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAddressError {
    fn code(&self) -> Option<&str> {
        CreateAddressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAddressError {
    /// Creates a new `CreateAddressError`.
    pub fn new(kind: CreateAddressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAddressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAddressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAddressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAddressErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAddressErrorKind::InvalidAddressException`.
    pub fn is_invalid_address_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddressErrorKind::InvalidAddressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAddressErrorKind::UnsupportedAddressException`.
    pub fn is_unsupported_address_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddressErrorKind::UnsupportedAddressException(_)
        )
    }
}
impl std::error::Error for CreateAddressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAddressErrorKind::InvalidAddressException(_inner) => Some(_inner),
            CreateAddressErrorKind::UnsupportedAddressException(_inner) => Some(_inner),
            CreateAddressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
    Ec2RequestFailedException(crate::error::Ec2RequestFailedException),
    /// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
    InvalidInputCombinationException(crate::error::InvalidInputCombinationException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::Ec2RequestFailedException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidInputCombinationException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::Ec2RequestFailedException`.
    pub fn is_ec2_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::Ec2RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidInputCombinationException`.
    pub fn is_invalid_input_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidInputCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::KmsRequestFailedException(_)
        )
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::Ec2RequestFailedException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidInputCombinationException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CreateClusterErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// <p>Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster has exactly five nodes.</p>
    ClusterLimitExceededException(crate::error::ClusterLimitExceededException),
    /// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
    Ec2RequestFailedException(crate::error::Ec2RequestFailedException),
    /// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
    InvalidInputCombinationException(crate::error::InvalidInputCombinationException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::ClusterLimitExceededException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Ec2RequestFailedException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InvalidInputCombinationException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ClusterLimitExceededException`.
    pub fn is_cluster_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::ClusterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::Ec2RequestFailedException`.
    pub fn is_ec2_request_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::Ec2RequestFailedException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InvalidInputCombinationException`.
    pub fn is_invalid_input_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::InvalidInputCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InvalidResourceException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::KmsRequestFailedException(_))
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::ClusterLimitExceededException(_inner) => Some(_inner),
            CreateJobErrorKind::Ec2RequestFailedException(_inner) => Some(_inner),
            CreateJobErrorKind::InvalidInputCombinationException(_inner) => Some(_inner),
            CreateJobErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CreateJobErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLongTermPricingError {
    /// Kind of error that occurred.
    pub kind: CreateLongTermPricingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLongTermPricingErrorKind {
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLongTermPricingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLongTermPricingErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CreateLongTermPricingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLongTermPricingError {
    fn code(&self) -> Option<&str> {
        CreateLongTermPricingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLongTermPricingError {
    /// Creates a new `CreateLongTermPricingError`.
    pub fn new(kind: CreateLongTermPricingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLongTermPricingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLongTermPricingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLongTermPricingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLongTermPricingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLongTermPricingErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLongTermPricingErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for CreateLongTermPricingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLongTermPricingErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CreateLongTermPricingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReturnShippingLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReturnShippingLabelError {
    /// Kind of error that occurred.
    pub kind: CreateReturnShippingLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReturnShippingLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReturnShippingLabelErrorKind {
    /// <p>You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
    InvalidInputCombinationException(crate::error::InvalidInputCombinationException),
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>You get this exception if you call <code>CreateReturnShippingLabel</code> and a valid return shipping label already exists. In this case, use <code>DescribeReturnShippingLabel</code> to get the URL.</p>
    ReturnShippingLabelAlreadyExistsException(
        crate::error::ReturnShippingLabelAlreadyExistsException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReturnShippingLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReturnShippingLabelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateReturnShippingLabelErrorKind::InvalidInputCombinationException(_inner) => {
                _inner.fmt(f)
            }
            CreateReturnShippingLabelErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            CreateReturnShippingLabelErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CreateReturnShippingLabelErrorKind::ReturnShippingLabelAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            CreateReturnShippingLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReturnShippingLabelError {
    fn code(&self) -> Option<&str> {
        CreateReturnShippingLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReturnShippingLabelError {
    /// Creates a new `CreateReturnShippingLabelError`.
    pub fn new(kind: CreateReturnShippingLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReturnShippingLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReturnShippingLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReturnShippingLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReturnShippingLabelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReturnShippingLabelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReturnShippingLabelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReturnShippingLabelErrorKind::InvalidInputCombinationException`.
    pub fn is_invalid_input_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReturnShippingLabelErrorKind::InvalidInputCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReturnShippingLabelErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReturnShippingLabelErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReturnShippingLabelErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReturnShippingLabelErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReturnShippingLabelErrorKind::ReturnShippingLabelAlreadyExistsException`.
    pub fn is_return_shipping_label_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReturnShippingLabelErrorKind::ReturnShippingLabelAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateReturnShippingLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReturnShippingLabelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateReturnShippingLabelErrorKind::InvalidInputCombinationException(_inner) => {
                Some(_inner)
            }
            CreateReturnShippingLabelErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            CreateReturnShippingLabelErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CreateReturnShippingLabelErrorKind::ReturnShippingLabelAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            CreateReturnShippingLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAddressError {
    /// Kind of error that occurred.
    pub kind: DescribeAddressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAddressErrorKind {
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAddressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAddressErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            DescribeAddressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAddressError {
    fn code(&self) -> Option<&str> {
        DescribeAddressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAddressError {
    /// Creates a new `DescribeAddressError`.
    pub fn new(kind: DescribeAddressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAddressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAddressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAddressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAddressErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAddressErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddressErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for DescribeAddressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAddressErrorKind::InvalidResourceException(_inner) => Some(_inner),
            DescribeAddressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAddresses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAddressesError {
    /// Kind of error that occurred.
    pub kind: DescribeAddressesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAddresses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAddressesErrorKind {
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAddressesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAddressesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            DescribeAddressesErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            DescribeAddressesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAddressesError {
    fn code(&self) -> Option<&str> {
        DescribeAddressesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAddressesError {
    /// Creates a new `DescribeAddressesError`.
    pub fn new(kind: DescribeAddressesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAddressesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAddressesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAddressesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAddressesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAddressesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddressesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddressesErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddressesErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for DescribeAddressesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAddressesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            DescribeAddressesErrorKind::InvalidResourceException(_inner) => Some(_inner),
            DescribeAddressesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterErrorKind {
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterError {
    fn code(&self) -> Option<&str> {
        DescribeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterError {
    /// Creates a new `DescribeClusterError`.
    pub fn new(kind: DescribeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for DescribeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterErrorKind::InvalidResourceException(_inner) => Some(_inner),
            DescribeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobError {
    /// Kind of error that occurred.
    pub kind: DescribeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobErrorKind {
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobError {
    fn code(&self) -> Option<&str> {
        DescribeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobError {
    /// Creates a new `DescribeJobError`.
    pub fn new(kind: DescribeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for DescribeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobErrorKind::InvalidResourceException(_inner) => Some(_inner),
            DescribeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReturnShippingLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReturnShippingLabelError {
    /// Kind of error that occurred.
    pub kind: DescribeReturnShippingLabelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReturnShippingLabel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReturnShippingLabelErrorKind {
    /// <p>You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReturnShippingLabelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReturnShippingLabelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeReturnShippingLabelErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            DescribeReturnShippingLabelErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            DescribeReturnShippingLabelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReturnShippingLabelError {
    fn code(&self) -> Option<&str> {
        DescribeReturnShippingLabelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReturnShippingLabelError {
    /// Creates a new `DescribeReturnShippingLabelError`.
    pub fn new(kind: DescribeReturnShippingLabelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReturnShippingLabelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReturnShippingLabelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReturnShippingLabelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReturnShippingLabelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReturnShippingLabelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReturnShippingLabelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReturnShippingLabelErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReturnShippingLabelErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReturnShippingLabelErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReturnShippingLabelErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for DescribeReturnShippingLabelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReturnShippingLabelErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeReturnShippingLabelErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            DescribeReturnShippingLabelErrorKind::InvalidResourceException(_inner) => Some(_inner),
            DescribeReturnShippingLabelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobManifest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobManifestError {
    /// Kind of error that occurred.
    pub kind: GetJobManifestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobManifest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobManifestErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobManifestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobManifestErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            GetJobManifestErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            GetJobManifestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobManifestError {
    fn code(&self) -> Option<&str> {
        GetJobManifestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobManifestError {
    /// Creates a new `GetJobManifestError`.
    pub fn new(kind: GetJobManifestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobManifestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobManifestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobManifestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobManifestErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobManifestErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobManifestErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobManifestErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobManifestErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for GetJobManifestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobManifestErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            GetJobManifestErrorKind::InvalidResourceException(_inner) => Some(_inner),
            GetJobManifestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobUnlockCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobUnlockCodeError {
    /// Kind of error that occurred.
    pub kind: GetJobUnlockCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobUnlockCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobUnlockCodeErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobUnlockCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobUnlockCodeErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            GetJobUnlockCodeErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            GetJobUnlockCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobUnlockCodeError {
    fn code(&self) -> Option<&str> {
        GetJobUnlockCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobUnlockCodeError {
    /// Creates a new `GetJobUnlockCodeError`.
    pub fn new(kind: GetJobUnlockCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobUnlockCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobUnlockCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobUnlockCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobUnlockCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobUnlockCodeErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobUnlockCodeErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobUnlockCodeErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobUnlockCodeErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for GetJobUnlockCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobUnlockCodeErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            GetJobUnlockCodeErrorKind::InvalidResourceException(_inner) => Some(_inner),
            GetJobUnlockCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSnowballUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSnowballUsageError {
    /// Kind of error that occurred.
    pub kind: GetSnowballUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSnowballUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSnowballUsageErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSnowballUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSnowballUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSnowballUsageError {
    fn code(&self) -> Option<&str> {
        GetSnowballUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSnowballUsageError {
    /// Creates a new `GetSnowballUsageError`.
    pub fn new(kind: GetSnowballUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSnowballUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSnowballUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSnowballUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSnowballUsageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetSnowballUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSnowballUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSoftwareUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSoftwareUpdatesError {
    /// Kind of error that occurred.
    pub kind: GetSoftwareUpdatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSoftwareUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSoftwareUpdatesErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSoftwareUpdatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSoftwareUpdatesErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            GetSoftwareUpdatesErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            GetSoftwareUpdatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSoftwareUpdatesError {
    fn code(&self) -> Option<&str> {
        GetSoftwareUpdatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSoftwareUpdatesError {
    /// Creates a new `GetSoftwareUpdatesError`.
    pub fn new(kind: GetSoftwareUpdatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSoftwareUpdatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSoftwareUpdatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSoftwareUpdatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSoftwareUpdatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSoftwareUpdatesErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSoftwareUpdatesErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSoftwareUpdatesErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSoftwareUpdatesErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for GetSoftwareUpdatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSoftwareUpdatesErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            GetSoftwareUpdatesErrorKind::InvalidResourceException(_inner) => Some(_inner),
            GetSoftwareUpdatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusterJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClusterJobsError {
    /// Kind of error that occurred.
    pub kind: ListClusterJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusterJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClusterJobsErrorKind {
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClusterJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClusterJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListClusterJobsErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            ListClusterJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClusterJobsError {
    fn code(&self) -> Option<&str> {
        ListClusterJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClusterJobsError {
    /// Creates a new `ListClusterJobsError`.
    pub fn new(kind: ListClusterJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClusterJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClusterJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClusterJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClusterJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClusterJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClusterJobsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClusterJobsErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClusterJobsErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for ListClusterJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClusterJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListClusterJobsErrorKind::InvalidResourceException(_inner) => Some(_inner),
            ListClusterJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClustersError {
    /// Kind of error that occurred.
    pub kind: ListClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClustersErrorKind {
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClustersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClustersError {
    fn code(&self) -> Option<&str> {
        ListClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClustersError {
    /// Creates a new `ListClustersError`.
    pub fn new(kind: ListClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClustersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCompatibleImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCompatibleImagesError {
    /// Kind of error that occurred.
    pub kind: ListCompatibleImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCompatibleImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCompatibleImagesErrorKind {
    /// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
    Ec2RequestFailedException(crate::error::Ec2RequestFailedException),
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCompatibleImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCompatibleImagesErrorKind::Ec2RequestFailedException(_inner) => _inner.fmt(f),
            ListCompatibleImagesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListCompatibleImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCompatibleImagesError {
    fn code(&self) -> Option<&str> {
        ListCompatibleImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCompatibleImagesError {
    /// Creates a new `ListCompatibleImagesError`.
    pub fn new(kind: ListCompatibleImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCompatibleImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCompatibleImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCompatibleImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCompatibleImagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCompatibleImagesErrorKind::Ec2RequestFailedException`.
    pub fn is_ec2_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCompatibleImagesErrorKind::Ec2RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCompatibleImagesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCompatibleImagesErrorKind::InvalidNextTokenException(_)
        )
    }
}
impl std::error::Error for ListCompatibleImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCompatibleImagesErrorKind::Ec2RequestFailedException(_inner) => Some(_inner),
            ListCompatibleImagesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListCompatibleImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InvalidNextTokenException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLongTermPricingError {
    /// Kind of error that occurred.
    pub kind: ListLongTermPricingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLongTermPricingErrorKind {
    /// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLongTermPricingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLongTermPricingErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListLongTermPricingErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            ListLongTermPricingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLongTermPricingError {
    fn code(&self) -> Option<&str> {
        ListLongTermPricingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLongTermPricingError {
    /// Creates a new `ListLongTermPricingError`.
    pub fn new(kind: ListLongTermPricingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLongTermPricingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLongTermPricingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLongTermPricingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLongTermPricingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLongTermPricingErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLongTermPricingErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLongTermPricingErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLongTermPricingErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for ListLongTermPricingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLongTermPricingErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListLongTermPricingErrorKind::InvalidResourceException(_inner) => Some(_inner),
            ListLongTermPricingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterErrorKind {
    /// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
    Ec2RequestFailedException(crate::error::Ec2RequestFailedException),
    /// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
    InvalidInputCombinationException(crate::error::InvalidInputCombinationException),
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterErrorKind::Ec2RequestFailedException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidInputCombinationException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterError {
    fn code(&self) -> Option<&str> {
        UpdateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterError {
    /// Creates a new `UpdateClusterError`.
    pub fn new(kind: UpdateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::Ec2RequestFailedException`.
    pub fn is_ec2_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::Ec2RequestFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidInputCombinationException`.
    pub fn is_invalid_input_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidInputCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::KmsRequestFailedException(_)
        )
    }
}
impl std::error::Error for UpdateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterErrorKind::Ec2RequestFailedException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidInputCombinationException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidResourceException(_inner) => Some(_inner),
            UpdateClusterErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            UpdateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobError {
    /// Kind of error that occurred.
    pub kind: UpdateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobErrorKind {
    /// <p>Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster has exactly five nodes.</p>
    ClusterLimitExceededException(crate::error::ClusterLimitExceededException),
    /// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
    Ec2RequestFailedException(crate::error::Ec2RequestFailedException),
    /// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
    InvalidInputCombinationException(crate::error::InvalidInputCombinationException),
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
    KmsRequestFailedException(crate::error::KmsRequestFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobErrorKind::ClusterLimitExceededException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::Ec2RequestFailedException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::InvalidInputCombinationException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::KmsRequestFailedException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobError {
    fn code(&self) -> Option<&str> {
        UpdateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobError {
    /// Creates a new `UpdateJobError`.
    pub fn new(kind: UpdateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::ClusterLimitExceededException`.
    pub fn is_cluster_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobErrorKind::ClusterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::Ec2RequestFailedException`.
    pub fn is_ec2_request_failed_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::Ec2RequestFailedException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::InvalidInputCombinationException`.
    pub fn is_invalid_input_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobErrorKind::InvalidInputCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::InvalidJobStateException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::InvalidResourceException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::KmsRequestFailedException`.
    pub fn is_kms_request_failed_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::KmsRequestFailedException(_))
    }
}
impl std::error::Error for UpdateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobErrorKind::ClusterLimitExceededException(_inner) => Some(_inner),
            UpdateJobErrorKind::Ec2RequestFailedException(_inner) => Some(_inner),
            UpdateJobErrorKind::InvalidInputCombinationException(_inner) => Some(_inner),
            UpdateJobErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            UpdateJobErrorKind::InvalidResourceException(_inner) => Some(_inner),
            UpdateJobErrorKind::KmsRequestFailedException(_inner) => Some(_inner),
            UpdateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJobShipmentState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobShipmentStateError {
    /// Kind of error that occurred.
    pub kind: UpdateJobShipmentStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJobShipmentState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobShipmentStateErrorKind {
    /// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
    InvalidJobStateException(crate::error::InvalidJobStateException),
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobShipmentStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobShipmentStateErrorKind::InvalidJobStateException(_inner) => _inner.fmt(f),
            UpdateJobShipmentStateErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            UpdateJobShipmentStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobShipmentStateError {
    fn code(&self) -> Option<&str> {
        UpdateJobShipmentStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobShipmentStateError {
    /// Creates a new `UpdateJobShipmentStateError`.
    pub fn new(kind: UpdateJobShipmentStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobShipmentStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobShipmentStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobShipmentStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobShipmentStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobShipmentStateErrorKind::InvalidJobStateException`.
    pub fn is_invalid_job_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobShipmentStateErrorKind::InvalidJobStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobShipmentStateErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobShipmentStateErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for UpdateJobShipmentStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobShipmentStateErrorKind::InvalidJobStateException(_inner) => Some(_inner),
            UpdateJobShipmentStateErrorKind::InvalidResourceException(_inner) => Some(_inner),
            UpdateJobShipmentStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLongTermPricingError {
    /// Kind of error that occurred.
    pub kind: UpdateLongTermPricingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLongTermPricing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLongTermPricingErrorKind {
    /// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLongTermPricingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLongTermPricingErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            UpdateLongTermPricingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLongTermPricingError {
    fn code(&self) -> Option<&str> {
        UpdateLongTermPricingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLongTermPricingError {
    /// Creates a new `UpdateLongTermPricingError`.
    pub fn new(kind: UpdateLongTermPricingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLongTermPricingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLongTermPricingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLongTermPricingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLongTermPricingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLongTermPricingErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLongTermPricingErrorKind::InvalidResourceException(_)
        )
    }
}
impl std::error::Error for UpdateLongTermPricingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLongTermPricingErrorKind::InvalidResourceException(_inner) => Some(_inner),
            UpdateLongTermPricingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource can't be found. Check the information you provided in your last request, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The provided resource value is invalid.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl InvalidResourceException {
    /// <p>The provided resource value is invalid.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for InvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl InvalidResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceException {}
/// See [`InvalidResourceException`](crate::error::InvalidResourceException)
pub mod invalid_resource_exception {
    /// A builder for [`InvalidResourceException`](crate::error::InvalidResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The provided resource value is invalid.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The provided resource value is invalid.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceException`](crate::error::InvalidResourceException)
        pub fn build(self) -> crate::error::InvalidResourceException {
            crate::error::InvalidResourceException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl InvalidResourceException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceException`](crate::error::InvalidResourceException)
    pub fn builder() -> crate::error::invalid_resource_exception::Builder {
        crate::error::invalid_resource_exception::Builder::default()
    }
}

/// <p>The action can't be performed because the job's current state doesn't allow that action to be performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidJobStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidJobStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidJobStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidJobStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidJobStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidJobStateException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidJobStateException {}
/// See [`InvalidJobStateException`](crate::error::InvalidJobStateException)
pub mod invalid_job_state_exception {
    /// A builder for [`InvalidJobStateException`](crate::error::InvalidJobStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidJobStateException`](crate::error::InvalidJobStateException)
        pub fn build(self) -> crate::error::InvalidJobStateException {
            crate::error::InvalidJobStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidJobStateException {
    /// Creates a new builder-style object to manufacture [`InvalidJobStateException`](crate::error::InvalidJobStateException)
    pub fn builder() -> crate::error::invalid_job_state_exception::Builder {
        crate::error::invalid_job_state_exception::Builder::default()
    }
}

/// <p>The provided Key Management Service key lacks the permissions to perform the specified <code>CreateJob</code> or <code>UpdateJob</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsRequestFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsRequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsRequestFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsRequestFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsRequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsRequestFailedException [KMSRequestFailedException]")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsRequestFailedException {}
/// See [`KmsRequestFailedException`](crate::error::KmsRequestFailedException)
pub mod kms_request_failed_exception {
    /// A builder for [`KmsRequestFailedException`](crate::error::KmsRequestFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsRequestFailedException`](crate::error::KmsRequestFailedException)
        pub fn build(self) -> crate::error::KmsRequestFailedException {
            crate::error::KmsRequestFailedException {
                message: self.message,
            }
        }
    }
}
impl KmsRequestFailedException {
    /// Creates a new builder-style object to manufacture [`KmsRequestFailedException`](crate::error::KmsRequestFailedException)
    pub fn builder() -> crate::error::kms_request_failed_exception::Builder {
        crate::error::kms_request_failed_exception::Builder::default()
    }
}

/// <p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <code>CreateClusterRequest$SnowballType</code> value supports your <code>CreateJobRequest$JobType</code>, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputCombinationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputCombinationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputCombinationException {}
/// See [`InvalidInputCombinationException`](crate::error::InvalidInputCombinationException)
pub mod invalid_input_combination_exception {
    /// A builder for [`InvalidInputCombinationException`](crate::error::InvalidInputCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputCombinationException`](crate::error::InvalidInputCombinationException)
        pub fn build(self) -> crate::error::InvalidInputCombinationException {
            crate::error::InvalidInputCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidInputCombinationException`](crate::error::InvalidInputCombinationException)
    pub fn builder() -> crate::error::invalid_input_combination_exception::Builder {
        crate::error::invalid_input_combination_exception::Builder::default()
    }
}

/// <p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2RequestFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Ec2RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2RequestFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl Ec2RequestFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2RequestFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "Ec2RequestFailedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2RequestFailedException {}
/// See [`Ec2RequestFailedException`](crate::error::Ec2RequestFailedException)
pub mod ec2_request_failed_exception {
    /// A builder for [`Ec2RequestFailedException`](crate::error::Ec2RequestFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2RequestFailedException`](crate::error::Ec2RequestFailedException)
        pub fn build(self) -> crate::error::Ec2RequestFailedException {
            crate::error::Ec2RequestFailedException {
                message: self.message,
            }
        }
    }
}
impl Ec2RequestFailedException {
    /// Creates a new builder-style object to manufacture [`Ec2RequestFailedException`](crate::error::Ec2RequestFailedException)
    pub fn builder() -> crate::error::ec2_request_failed_exception::Builder {
        crate::error::ec2_request_failed_exception::Builder::default()
    }
}

/// <p>Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster has exactly five nodes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterLimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterLimitExceededException {}
/// See [`ClusterLimitExceededException`](crate::error::ClusterLimitExceededException)
pub mod cluster_limit_exceeded_exception {
    /// A builder for [`ClusterLimitExceededException`](crate::error::ClusterLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterLimitExceededException`](crate::error::ClusterLimitExceededException)
        pub fn build(self) -> crate::error::ClusterLimitExceededException {
            crate::error::ClusterLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ClusterLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ClusterLimitExceededException`](crate::error::ClusterLimitExceededException)
    pub fn builder() -> crate::error::cluster_limit_exceeded_exception::Builder {
        crate::error::cluster_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>You get this resource when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed. .</p>
    pub conflict_resource: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>You get this resource when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed. .</p>
    pub fn conflict_resource(&self) -> std::option::Option<&str> {
        self.conflict_resource.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("conflict_resource", &self.conflict_resource);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflict_resource: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You get this resource when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed. .</p>
        pub fn conflict_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.conflict_resource = Some(input.into());
            self
        }
        /// <p>You get this resource when you call <code>CreateReturnShippingLabel</code> more than once when other requests are not completed. .</p>
        pub fn set_conflict_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conflict_resource = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                conflict_resource: self.conflict_resource,
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You get this exception if you call <code>CreateReturnShippingLabel</code> and a valid return shipping label already exists. In this case, use <code>DescribeReturnShippingLabel</code> to get the URL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReturnShippingLabelAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReturnShippingLabelAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReturnShippingLabelAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReturnShippingLabelAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReturnShippingLabelAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReturnShippingLabelAlreadyExistsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReturnShippingLabelAlreadyExistsException {}
/// See [`ReturnShippingLabelAlreadyExistsException`](crate::error::ReturnShippingLabelAlreadyExistsException)
pub mod return_shipping_label_already_exists_exception {
    /// A builder for [`ReturnShippingLabelAlreadyExistsException`](crate::error::ReturnShippingLabelAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReturnShippingLabelAlreadyExistsException`](crate::error::ReturnShippingLabelAlreadyExistsException)
        pub fn build(self) -> crate::error::ReturnShippingLabelAlreadyExistsException {
            crate::error::ReturnShippingLabelAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ReturnShippingLabelAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ReturnShippingLabelAlreadyExistsException`](crate::error::ReturnShippingLabelAlreadyExistsException)
    pub fn builder() -> crate::error::return_shipping_label_already_exists_exception::Builder {
        crate::error::return_shipping_label_already_exists_exception::Builder::default()
    }
}

/// <p>The address is either outside the serviceable area for your region, or an error occurred. Check the address with your region's carrier and try again. If the issue persists, contact Amazon Web Services Support.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedAddressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedAddressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedAddressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedAddressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedAddressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedAddressException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedAddressException {}
/// See [`UnsupportedAddressException`](crate::error::UnsupportedAddressException)
pub mod unsupported_address_exception {
    /// A builder for [`UnsupportedAddressException`](crate::error::UnsupportedAddressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedAddressException`](crate::error::UnsupportedAddressException)
        pub fn build(self) -> crate::error::UnsupportedAddressException {
            crate::error::UnsupportedAddressException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedAddressException {
    /// Creates a new builder-style object to manufacture [`UnsupportedAddressException`](crate::error::UnsupportedAddressException)
    pub fn builder() -> crate::error::unsupported_address_exception::Builder {
        crate::error::unsupported_address_exception::Builder::default()
    }
}

/// <p>The address provided was invalid. Check the address with your region's carrier, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAddressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAddressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAddressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAddressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAddressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAddressException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAddressException {}
/// See [`InvalidAddressException`](crate::error::InvalidAddressException)
pub mod invalid_address_exception {
    /// A builder for [`InvalidAddressException`](crate::error::InvalidAddressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAddressException`](crate::error::InvalidAddressException)
        pub fn build(self) -> crate::error::InvalidAddressException {
            crate::error::InvalidAddressException {
                message: self.message,
            }
        }
    }
}
impl InvalidAddressException {
    /// Creates a new builder-style object to manufacture [`InvalidAddressException`](crate::error::InvalidAddressException)
    pub fn builder() -> crate::error::invalid_address_exception::Builder {
        crate::error::invalid_address_exception::Builder::default()
    }
}
