// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShipmentState {
    #[allow(missing_docs)] // documentation missing in model
    Received,
    #[allow(missing_docs)] // documentation missing in model
    Returned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShipmentState {
    fn from(s: &str) -> Self {
        match s {
            "RECEIVED" => ShipmentState::Received,
            "RETURNED" => ShipmentState::Returned,
            other => ShipmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShipmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShipmentState::from(s))
    }
}
impl ShipmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShipmentState::Received => "RECEIVED",
            ShipmentState::Returned => "RETURNED",
            ShipmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RECEIVED", "RETURNED"]
    }
}
impl AsRef<str> for ShipmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnowballCapacity {
    #[allow(missing_docs)] // documentation missing in model
    NoPreference,
    #[allow(missing_docs)] // documentation missing in model
    T100,
    #[allow(missing_docs)] // documentation missing in model
    T14,
    #[allow(missing_docs)] // documentation missing in model
    T42,
    #[allow(missing_docs)] // documentation missing in model
    T50,
    #[allow(missing_docs)] // documentation missing in model
    T8,
    #[allow(missing_docs)] // documentation missing in model
    T80,
    #[allow(missing_docs)] // documentation missing in model
    T98,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnowballCapacity {
    fn from(s: &str) -> Self {
        match s {
            "NoPreference" => SnowballCapacity::NoPreference,
            "T100" => SnowballCapacity::T100,
            "T14" => SnowballCapacity::T14,
            "T42" => SnowballCapacity::T42,
            "T50" => SnowballCapacity::T50,
            "T8" => SnowballCapacity::T8,
            "T80" => SnowballCapacity::T80,
            "T98" => SnowballCapacity::T98,
            other => SnowballCapacity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnowballCapacity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnowballCapacity::from(s))
    }
}
impl SnowballCapacity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnowballCapacity::NoPreference => "NoPreference",
            SnowballCapacity::T100 => "T100",
            SnowballCapacity::T14 => "T14",
            SnowballCapacity::T42 => "T42",
            SnowballCapacity::T50 => "T50",
            SnowballCapacity::T8 => "T8",
            SnowballCapacity::T80 => "T80",
            SnowballCapacity::T98 => "T98",
            SnowballCapacity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "NoPreference",
            "T100",
            "T14",
            "T42",
            "T50",
            "T8",
            "T80",
            "T98",
        ]
    }
}
impl AsRef<str> for SnowballCapacity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShippingOption {
    #[allow(missing_docs)] // documentation missing in model
    Express,
    #[allow(missing_docs)] // documentation missing in model
    NextDay,
    #[allow(missing_docs)] // documentation missing in model
    SecondDay,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShippingOption {
    fn from(s: &str) -> Self {
        match s {
            "EXPRESS" => ShippingOption::Express,
            "NEXT_DAY" => ShippingOption::NextDay,
            "SECOND_DAY" => ShippingOption::SecondDay,
            "STANDARD" => ShippingOption::Standard,
            other => ShippingOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShippingOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShippingOption::from(s))
    }
}
impl ShippingOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShippingOption::Express => "EXPRESS",
            ShippingOption::NextDay => "NEXT_DAY",
            ShippingOption::SecondDay => "SECOND_DAY",
            ShippingOption::Standard => "STANDARD",
            ShippingOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPRESS", "NEXT_DAY", "SECOND_DAY", "STANDARD"]
    }
}
impl AsRef<str> for ShippingOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnDeviceServiceConfiguration {
    /// <p>Represents the NFS (Network File System) service on a Snow Family device.</p>
    pub nfs_on_device_service: std::option::Option<crate::model::NfsOnDeviceServiceConfiguration>,
    /// <p>Represents the Storage Gateway service Tape Gateway type on a Snow Family device.</p>
    pub tgw_on_device_service: std::option::Option<crate::model::TgwOnDeviceServiceConfiguration>,
}
impl OnDeviceServiceConfiguration {
    /// <p>Represents the NFS (Network File System) service on a Snow Family device.</p>
    pub fn nfs_on_device_service(
        &self,
    ) -> std::option::Option<&crate::model::NfsOnDeviceServiceConfiguration> {
        self.nfs_on_device_service.as_ref()
    }
    /// <p>Represents the Storage Gateway service Tape Gateway type on a Snow Family device.</p>
    pub fn tgw_on_device_service(
        &self,
    ) -> std::option::Option<&crate::model::TgwOnDeviceServiceConfiguration> {
        self.tgw_on_device_service.as_ref()
    }
}
impl std::fmt::Debug for OnDeviceServiceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnDeviceServiceConfiguration");
        formatter.field("nfs_on_device_service", &self.nfs_on_device_service);
        formatter.field("tgw_on_device_service", &self.tgw_on_device_service);
        formatter.finish()
    }
}
/// See [`OnDeviceServiceConfiguration`](crate::model::OnDeviceServiceConfiguration)
pub mod on_device_service_configuration {
    /// A builder for [`OnDeviceServiceConfiguration`](crate::model::OnDeviceServiceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nfs_on_device_service:
            std::option::Option<crate::model::NfsOnDeviceServiceConfiguration>,
        pub(crate) tgw_on_device_service:
            std::option::Option<crate::model::TgwOnDeviceServiceConfiguration>,
    }
    impl Builder {
        /// <p>Represents the NFS (Network File System) service on a Snow Family device.</p>
        pub fn nfs_on_device_service(
            mut self,
            input: crate::model::NfsOnDeviceServiceConfiguration,
        ) -> Self {
            self.nfs_on_device_service = Some(input);
            self
        }
        /// <p>Represents the NFS (Network File System) service on a Snow Family device.</p>
        pub fn set_nfs_on_device_service(
            mut self,
            input: std::option::Option<crate::model::NfsOnDeviceServiceConfiguration>,
        ) -> Self {
            self.nfs_on_device_service = input;
            self
        }
        /// <p>Represents the Storage Gateway service Tape Gateway type on a Snow Family device.</p>
        pub fn tgw_on_device_service(
            mut self,
            input: crate::model::TgwOnDeviceServiceConfiguration,
        ) -> Self {
            self.tgw_on_device_service = Some(input);
            self
        }
        /// <p>Represents the Storage Gateway service Tape Gateway type on a Snow Family device.</p>
        pub fn set_tgw_on_device_service(
            mut self,
            input: std::option::Option<crate::model::TgwOnDeviceServiceConfiguration>,
        ) -> Self {
            self.tgw_on_device_service = input;
            self
        }
        /// Consumes the builder and constructs a [`OnDeviceServiceConfiguration`](crate::model::OnDeviceServiceConfiguration)
        pub fn build(self) -> crate::model::OnDeviceServiceConfiguration {
            crate::model::OnDeviceServiceConfiguration {
                nfs_on_device_service: self.nfs_on_device_service,
                tgw_on_device_service: self.tgw_on_device_service,
            }
        }
    }
}
impl OnDeviceServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`OnDeviceServiceConfiguration`](crate::model::OnDeviceServiceConfiguration)
    pub fn builder() -> crate::model::on_device_service_configuration::Builder {
        crate::model::on_device_service_configuration::Builder::default()
    }
}

/// <p>An object that represents the metadata and configuration settings for the Storage Gateway service Tape Gateway type on an Amazon Web Services Snow Family device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TgwOnDeviceServiceConfiguration {
    /// <p>The maximum number of virtual tapes to store on one Snow Family device. Due to physical resource limitations, this value must be set to 80 for Snowball Edge.</p>
    pub storage_limit: i32,
    /// <p>The scale unit of the virtual tapes on the device.</p>
    pub storage_unit: std::option::Option<crate::model::StorageUnit>,
}
impl TgwOnDeviceServiceConfiguration {
    /// <p>The maximum number of virtual tapes to store on one Snow Family device. Due to physical resource limitations, this value must be set to 80 for Snowball Edge.</p>
    pub fn storage_limit(&self) -> i32 {
        self.storage_limit
    }
    /// <p>The scale unit of the virtual tapes on the device.</p>
    pub fn storage_unit(&self) -> std::option::Option<&crate::model::StorageUnit> {
        self.storage_unit.as_ref()
    }
}
impl std::fmt::Debug for TgwOnDeviceServiceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TgwOnDeviceServiceConfiguration");
        formatter.field("storage_limit", &self.storage_limit);
        formatter.field("storage_unit", &self.storage_unit);
        formatter.finish()
    }
}
/// See [`TgwOnDeviceServiceConfiguration`](crate::model::TgwOnDeviceServiceConfiguration)
pub mod tgw_on_device_service_configuration {
    /// A builder for [`TgwOnDeviceServiceConfiguration`](crate::model::TgwOnDeviceServiceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_limit: std::option::Option<i32>,
        pub(crate) storage_unit: std::option::Option<crate::model::StorageUnit>,
    }
    impl Builder {
        /// <p>The maximum number of virtual tapes to store on one Snow Family device. Due to physical resource limitations, this value must be set to 80 for Snowball Edge.</p>
        pub fn storage_limit(mut self, input: i32) -> Self {
            self.storage_limit = Some(input);
            self
        }
        /// <p>The maximum number of virtual tapes to store on one Snow Family device. Due to physical resource limitations, this value must be set to 80 for Snowball Edge.</p>
        pub fn set_storage_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_limit = input;
            self
        }
        /// <p>The scale unit of the virtual tapes on the device.</p>
        pub fn storage_unit(mut self, input: crate::model::StorageUnit) -> Self {
            self.storage_unit = Some(input);
            self
        }
        /// <p>The scale unit of the virtual tapes on the device.</p>
        pub fn set_storage_unit(
            mut self,
            input: std::option::Option<crate::model::StorageUnit>,
        ) -> Self {
            self.storage_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`TgwOnDeviceServiceConfiguration`](crate::model::TgwOnDeviceServiceConfiguration)
        pub fn build(self) -> crate::model::TgwOnDeviceServiceConfiguration {
            crate::model::TgwOnDeviceServiceConfiguration {
                storage_limit: self.storage_limit.unwrap_or_default(),
                storage_unit: self.storage_unit,
            }
        }
    }
}
impl TgwOnDeviceServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`TgwOnDeviceServiceConfiguration`](crate::model::TgwOnDeviceServiceConfiguration)
    pub fn builder() -> crate::model::tgw_on_device_service_configuration::Builder {
        crate::model::tgw_on_device_service_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageUnit {
    #[allow(missing_docs)] // documentation missing in model
    Tb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageUnit {
    fn from(s: &str) -> Self {
        match s {
            "TB" => StorageUnit::Tb,
            other => StorageUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageUnit::from(s))
    }
}
impl StorageUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageUnit::Tb => "TB",
            StorageUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TB"]
    }
}
impl AsRef<str> for StorageUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that represents the metadata and configuration settings for the NFS (Network File System) service on an Amazon Web Services Snow Family device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NfsOnDeviceServiceConfiguration {
    /// <p>The maximum NFS storage for one Snow Family device.</p>
    pub storage_limit: i32,
    /// <p>The scale unit of the NFS storage on the device.</p>
    /// <p>Valid values: TB.</p>
    pub storage_unit: std::option::Option<crate::model::StorageUnit>,
}
impl NfsOnDeviceServiceConfiguration {
    /// <p>The maximum NFS storage for one Snow Family device.</p>
    pub fn storage_limit(&self) -> i32 {
        self.storage_limit
    }
    /// <p>The scale unit of the NFS storage on the device.</p>
    /// <p>Valid values: TB.</p>
    pub fn storage_unit(&self) -> std::option::Option<&crate::model::StorageUnit> {
        self.storage_unit.as_ref()
    }
}
impl std::fmt::Debug for NfsOnDeviceServiceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NfsOnDeviceServiceConfiguration");
        formatter.field("storage_limit", &self.storage_limit);
        formatter.field("storage_unit", &self.storage_unit);
        formatter.finish()
    }
}
/// See [`NfsOnDeviceServiceConfiguration`](crate::model::NfsOnDeviceServiceConfiguration)
pub mod nfs_on_device_service_configuration {
    /// A builder for [`NfsOnDeviceServiceConfiguration`](crate::model::NfsOnDeviceServiceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_limit: std::option::Option<i32>,
        pub(crate) storage_unit: std::option::Option<crate::model::StorageUnit>,
    }
    impl Builder {
        /// <p>The maximum NFS storage for one Snow Family device.</p>
        pub fn storage_limit(mut self, input: i32) -> Self {
            self.storage_limit = Some(input);
            self
        }
        /// <p>The maximum NFS storage for one Snow Family device.</p>
        pub fn set_storage_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_limit = input;
            self
        }
        /// <p>The scale unit of the NFS storage on the device.</p>
        /// <p>Valid values: TB.</p>
        pub fn storage_unit(mut self, input: crate::model::StorageUnit) -> Self {
            self.storage_unit = Some(input);
            self
        }
        /// <p>The scale unit of the NFS storage on the device.</p>
        /// <p>Valid values: TB.</p>
        pub fn set_storage_unit(
            mut self,
            input: std::option::Option<crate::model::StorageUnit>,
        ) -> Self {
            self.storage_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`NfsOnDeviceServiceConfiguration`](crate::model::NfsOnDeviceServiceConfiguration)
        pub fn build(self) -> crate::model::NfsOnDeviceServiceConfiguration {
            crate::model::NfsOnDeviceServiceConfiguration {
                storage_limit: self.storage_limit.unwrap_or_default(),
                storage_unit: self.storage_unit,
            }
        }
    }
}
impl NfsOnDeviceServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`NfsOnDeviceServiceConfiguration`](crate::model::NfsOnDeviceServiceConfiguration)
    pub fn builder() -> crate::model::nfs_on_device_service_configuration::Builder {
        crate::model::nfs_on_device_service_configuration::Builder::default()
    }
}

/// <p>Contains an array of Amazon Web Services resource objects. Each object represents an Amazon S3 bucket, an Lambda function, or an Amazon Machine Image (AMI) based on Amazon EC2 that is associated with a particular job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobResource {
    /// <p>An array of <code>S3Resource</code> objects.</p>
    pub s3_resources: std::option::Option<std::vec::Vec<crate::model::S3Resource>>,
    /// <p>The Python-language Lambda functions for this job.</p>
    pub lambda_resources: std::option::Option<std::vec::Vec<crate::model::LambdaResource>>,
    /// <p>The Amazon Machine Images (AMIs) associated with this job.</p>
    pub ec2_ami_resources: std::option::Option<std::vec::Vec<crate::model::Ec2AmiResource>>,
}
impl JobResource {
    /// <p>An array of <code>S3Resource</code> objects.</p>
    pub fn s3_resources(&self) -> std::option::Option<&[crate::model::S3Resource]> {
        self.s3_resources.as_deref()
    }
    /// <p>The Python-language Lambda functions for this job.</p>
    pub fn lambda_resources(&self) -> std::option::Option<&[crate::model::LambdaResource]> {
        self.lambda_resources.as_deref()
    }
    /// <p>The Amazon Machine Images (AMIs) associated with this job.</p>
    pub fn ec2_ami_resources(&self) -> std::option::Option<&[crate::model::Ec2AmiResource]> {
        self.ec2_ami_resources.as_deref()
    }
}
impl std::fmt::Debug for JobResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobResource");
        formatter.field("s3_resources", &self.s3_resources);
        formatter.field("lambda_resources", &self.lambda_resources);
        formatter.field("ec2_ami_resources", &self.ec2_ami_resources);
        formatter.finish()
    }
}
/// See [`JobResource`](crate::model::JobResource)
pub mod job_resource {
    /// A builder for [`JobResource`](crate::model::JobResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_resources: std::option::Option<std::vec::Vec<crate::model::S3Resource>>,
        pub(crate) lambda_resources:
            std::option::Option<std::vec::Vec<crate::model::LambdaResource>>,
        pub(crate) ec2_ami_resources:
            std::option::Option<std::vec::Vec<crate::model::Ec2AmiResource>>,
    }
    impl Builder {
        /// Appends an item to `s3_resources`.
        ///
        /// To override the contents of this collection use [`set_s3_resources`](Self::set_s3_resources).
        ///
        /// <p>An array of <code>S3Resource</code> objects.</p>
        pub fn s3_resources(mut self, input: crate::model::S3Resource) -> Self {
            let mut v = self.s3_resources.unwrap_or_default();
            v.push(input);
            self.s3_resources = Some(v);
            self
        }
        /// <p>An array of <code>S3Resource</code> objects.</p>
        pub fn set_s3_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Resource>>,
        ) -> Self {
            self.s3_resources = input;
            self
        }
        /// Appends an item to `lambda_resources`.
        ///
        /// To override the contents of this collection use [`set_lambda_resources`](Self::set_lambda_resources).
        ///
        /// <p>The Python-language Lambda functions for this job.</p>
        pub fn lambda_resources(mut self, input: crate::model::LambdaResource) -> Self {
            let mut v = self.lambda_resources.unwrap_or_default();
            v.push(input);
            self.lambda_resources = Some(v);
            self
        }
        /// <p>The Python-language Lambda functions for this job.</p>
        pub fn set_lambda_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaResource>>,
        ) -> Self {
            self.lambda_resources = input;
            self
        }
        /// Appends an item to `ec2_ami_resources`.
        ///
        /// To override the contents of this collection use [`set_ec2_ami_resources`](Self::set_ec2_ami_resources).
        ///
        /// <p>The Amazon Machine Images (AMIs) associated with this job.</p>
        pub fn ec2_ami_resources(mut self, input: crate::model::Ec2AmiResource) -> Self {
            let mut v = self.ec2_ami_resources.unwrap_or_default();
            v.push(input);
            self.ec2_ami_resources = Some(v);
            self
        }
        /// <p>The Amazon Machine Images (AMIs) associated with this job.</p>
        pub fn set_ec2_ami_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2AmiResource>>,
        ) -> Self {
            self.ec2_ami_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`JobResource`](crate::model::JobResource)
        pub fn build(self) -> crate::model::JobResource {
            crate::model::JobResource {
                s3_resources: self.s3_resources,
                lambda_resources: self.lambda_resources,
                ec2_ami_resources: self.ec2_ami_resources,
            }
        }
    }
}
impl JobResource {
    /// Creates a new builder-style object to manufacture [`JobResource`](crate::model::JobResource)
    pub fn builder() -> crate::model::job_resource::Builder {
        crate::model::job_resource::Builder::default()
    }
}

/// <p>A JSON-formatted object that contains the IDs for an Amazon Machine Image (AMI), including the Amazon EC2 AMI ID and the Snow device AMI ID. Each AMI has these two IDs to simplify identifying the AMI in both the Amazon Web Services Cloud and on the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2AmiResource {
    /// <p>The ID of the AMI in Amazon EC2.</p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The ID of the AMI on the Snow device.</p>
    pub snowball_ami_id: std::option::Option<std::string::String>,
}
impl Ec2AmiResource {
    /// <p>The ID of the AMI in Amazon EC2.</p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The ID of the AMI on the Snow device.</p>
    pub fn snowball_ami_id(&self) -> std::option::Option<&str> {
        self.snowball_ami_id.as_deref()
    }
}
impl std::fmt::Debug for Ec2AmiResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2AmiResource");
        formatter.field("ami_id", &self.ami_id);
        formatter.field("snowball_ami_id", &self.snowball_ami_id);
        formatter.finish()
    }
}
/// See [`Ec2AmiResource`](crate::model::Ec2AmiResource)
pub mod ec2_ami_resource {
    /// A builder for [`Ec2AmiResource`](crate::model::Ec2AmiResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) snowball_ami_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the AMI in Amazon EC2.</p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI in Amazon EC2.</p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The ID of the AMI on the Snow device.</p>
        pub fn snowball_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snowball_ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI on the Snow device.</p>
        pub fn set_snowball_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snowball_ami_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2AmiResource`](crate::model::Ec2AmiResource)
        pub fn build(self) -> crate::model::Ec2AmiResource {
            crate::model::Ec2AmiResource {
                ami_id: self.ami_id,
                snowball_ami_id: self.snowball_ami_id,
            }
        }
    }
}
impl Ec2AmiResource {
    /// Creates a new builder-style object to manufacture [`Ec2AmiResource`](crate::model::Ec2AmiResource)
    pub fn builder() -> crate::model::ec2_ami_resource::Builder {
        crate::model::ec2_ami_resource::Builder::default()
    }
}

/// <p>Identifies </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaResource {
    /// <p>An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the associated local Amazon S3 resource.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
    /// <p>The array of ARNs for <code>S3Resource</code> objects to trigger the <code>LambdaResource</code> objects associated with this job.</p>
    pub event_triggers: std::option::Option<std::vec::Vec<crate::model::EventTriggerDefinition>>,
}
impl LambdaResource {
    /// <p>An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the associated local Amazon S3 resource.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
    /// <p>The array of ARNs for <code>S3Resource</code> objects to trigger the <code>LambdaResource</code> objects associated with this job.</p>
    pub fn event_triggers(&self) -> std::option::Option<&[crate::model::EventTriggerDefinition]> {
        self.event_triggers.as_deref()
    }
}
impl std::fmt::Debug for LambdaResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaResource");
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.field("event_triggers", &self.event_triggers);
        formatter.finish()
    }
}
/// See [`LambdaResource`](crate::model::LambdaResource)
pub mod lambda_resource {
    /// A builder for [`LambdaResource`](crate::model::LambdaResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
        pub(crate) event_triggers:
            std::option::Option<std::vec::Vec<crate::model::EventTriggerDefinition>>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the associated local Amazon S3 resource.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the associated local Amazon S3 resource.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Appends an item to `event_triggers`.
        ///
        /// To override the contents of this collection use [`set_event_triggers`](Self::set_event_triggers).
        ///
        /// <p>The array of ARNs for <code>S3Resource</code> objects to trigger the <code>LambdaResource</code> objects associated with this job.</p>
        pub fn event_triggers(mut self, input: crate::model::EventTriggerDefinition) -> Self {
            let mut v = self.event_triggers.unwrap_or_default();
            v.push(input);
            self.event_triggers = Some(v);
            self
        }
        /// <p>The array of ARNs for <code>S3Resource</code> objects to trigger the <code>LambdaResource</code> objects associated with this job.</p>
        pub fn set_event_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTriggerDefinition>>,
        ) -> Self {
            self.event_triggers = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaResource`](crate::model::LambdaResource)
        pub fn build(self) -> crate::model::LambdaResource {
            crate::model::LambdaResource {
                lambda_arn: self.lambda_arn,
                event_triggers: self.event_triggers,
            }
        }
    }
}
impl LambdaResource {
    /// Creates a new builder-style object to manufacture [`LambdaResource`](crate::model::LambdaResource)
    pub fn builder() -> crate::model::lambda_resource::Builder {
        crate::model::lambda_resource::Builder::default()
    }
}

/// <p>The container for the <code>EventTriggerDefinition$EventResourceARN</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTriggerDefinition {
    /// <p>The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an Lambda function's event trigger associated with this job.</p>
    pub event_resource_arn: std::option::Option<std::string::String>,
}
impl EventTriggerDefinition {
    /// <p>The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an Lambda function's event trigger associated with this job.</p>
    pub fn event_resource_arn(&self) -> std::option::Option<&str> {
        self.event_resource_arn.as_deref()
    }
}
impl std::fmt::Debug for EventTriggerDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTriggerDefinition");
        formatter.field("event_resource_arn", &self.event_resource_arn);
        formatter.finish()
    }
}
/// See [`EventTriggerDefinition`](crate::model::EventTriggerDefinition)
pub mod event_trigger_definition {
    /// A builder for [`EventTriggerDefinition`](crate::model::EventTriggerDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an Lambda function's event trigger associated with this job.</p>
        pub fn event_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an Lambda function's event trigger associated with this job.</p>
        pub fn set_event_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTriggerDefinition`](crate::model::EventTriggerDefinition)
        pub fn build(self) -> crate::model::EventTriggerDefinition {
            crate::model::EventTriggerDefinition {
                event_resource_arn: self.event_resource_arn,
            }
        }
    }
}
impl EventTriggerDefinition {
    /// Creates a new builder-style object to manufacture [`EventTriggerDefinition`](crate::model::EventTriggerDefinition)
    pub fn builder() -> crate::model::event_trigger_definition::Builder {
        crate::model::event_trigger_definition::Builder::default()
    }
}

/// <p>Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into. For export jobs, this object can have an optional <code>KeyRange</code> value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Resource {
    /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
    pub key_range: std::option::Option<crate::model::KeyRange>,
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).</p>
    pub target_on_device_services:
        std::option::Option<std::vec::Vec<crate::model::TargetOnDeviceService>>,
}
impl S3Resource {
    /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
    pub fn key_range(&self) -> std::option::Option<&crate::model::KeyRange> {
        self.key_range.as_ref()
    }
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).</p>
    pub fn target_on_device_services(
        &self,
    ) -> std::option::Option<&[crate::model::TargetOnDeviceService]> {
        self.target_on_device_services.as_deref()
    }
}
impl std::fmt::Debug for S3Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Resource");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("key_range", &self.key_range);
        formatter.field("target_on_device_services", &self.target_on_device_services);
        formatter.finish()
    }
}
/// See [`S3Resource`](crate::model::S3Resource)
pub mod s3_resource {
    /// A builder for [`S3Resource`](crate::model::S3Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) key_range: std::option::Option<crate::model::KeyRange>,
        pub(crate) target_on_device_services:
            std::option::Option<std::vec::Vec<crate::model::TargetOnDeviceService>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn key_range(mut self, input: crate::model::KeyRange) -> Self {
            self.key_range = Some(input);
            self
        }
        /// <p>For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn set_key_range(mut self, input: std::option::Option<crate::model::KeyRange>) -> Self {
            self.key_range = input;
            self
        }
        /// Appends an item to `target_on_device_services`.
        ///
        /// To override the contents of this collection use [`set_target_on_device_services`](Self::set_target_on_device_services).
        ///
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).</p>
        pub fn target_on_device_services(
            mut self,
            input: crate::model::TargetOnDeviceService,
        ) -> Self {
            let mut v = self.target_on_device_services.unwrap_or_default();
            v.push(input);
            self.target_on_device_services = Some(v);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).</p>
        pub fn set_target_on_device_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetOnDeviceService>>,
        ) -> Self {
            self.target_on_device_services = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Resource`](crate::model::S3Resource)
        pub fn build(self) -> crate::model::S3Resource {
            crate::model::S3Resource {
                bucket_arn: self.bucket_arn,
                key_range: self.key_range,
                target_on_device_services: self.target_on_device_services,
            }
        }
    }
}
impl S3Resource {
    /// Creates a new builder-style object to manufacture [`S3Resource`](crate::model::S3Resource)
    pub fn builder() -> crate::model::s3_resource::Builder {
        crate::model::s3_resource::Builder::default()
    }
}

/// <p>An object that represents the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetOnDeviceService {
    /// <p>Specifies the name of the service on the Snow Family device that your transferred data will be exported from or imported into.</p>
    pub service_name: std::option::Option<crate::model::DeviceServiceName>,
    /// <p>Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on the device.</p>
    pub transfer_option: std::option::Option<crate::model::TransferOption>,
}
impl TargetOnDeviceService {
    /// <p>Specifies the name of the service on the Snow Family device that your transferred data will be exported from or imported into.</p>
    pub fn service_name(&self) -> std::option::Option<&crate::model::DeviceServiceName> {
        self.service_name.as_ref()
    }
    /// <p>Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on the device.</p>
    pub fn transfer_option(&self) -> std::option::Option<&crate::model::TransferOption> {
        self.transfer_option.as_ref()
    }
}
impl std::fmt::Debug for TargetOnDeviceService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetOnDeviceService");
        formatter.field("service_name", &self.service_name);
        formatter.field("transfer_option", &self.transfer_option);
        formatter.finish()
    }
}
/// See [`TargetOnDeviceService`](crate::model::TargetOnDeviceService)
pub mod target_on_device_service {
    /// A builder for [`TargetOnDeviceService`](crate::model::TargetOnDeviceService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<crate::model::DeviceServiceName>,
        pub(crate) transfer_option: std::option::Option<crate::model::TransferOption>,
    }
    impl Builder {
        /// <p>Specifies the name of the service on the Snow Family device that your transferred data will be exported from or imported into.</p>
        pub fn service_name(mut self, input: crate::model::DeviceServiceName) -> Self {
            self.service_name = Some(input);
            self
        }
        /// <p>Specifies the name of the service on the Snow Family device that your transferred data will be exported from or imported into.</p>
        pub fn set_service_name(
            mut self,
            input: std::option::Option<crate::model::DeviceServiceName>,
        ) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on the device.</p>
        pub fn transfer_option(mut self, input: crate::model::TransferOption) -> Self {
            self.transfer_option = Some(input);
            self
        }
        /// <p>Specifies whether the data is being imported or exported. You can import or export the data, or use it locally on the device.</p>
        pub fn set_transfer_option(
            mut self,
            input: std::option::Option<crate::model::TransferOption>,
        ) -> Self {
            self.transfer_option = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetOnDeviceService`](crate::model::TargetOnDeviceService)
        pub fn build(self) -> crate::model::TargetOnDeviceService {
            crate::model::TargetOnDeviceService {
                service_name: self.service_name,
                transfer_option: self.transfer_option,
            }
        }
    }
}
impl TargetOnDeviceService {
    /// Creates a new builder-style object to manufacture [`TargetOnDeviceService`](crate::model::TargetOnDeviceService)
    pub fn builder() -> crate::model::target_on_device_service::Builder {
        crate::model::target_on_device_service::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransferOption {
    #[allow(missing_docs)] // documentation missing in model
    Export,
    #[allow(missing_docs)] // documentation missing in model
    Import,
    #[allow(missing_docs)] // documentation missing in model
    LocalUse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransferOption {
    fn from(s: &str) -> Self {
        match s {
            "EXPORT" => TransferOption::Export,
            "IMPORT" => TransferOption::Import,
            "LOCAL_USE" => TransferOption::LocalUse,
            other => TransferOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransferOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransferOption::from(s))
    }
}
impl TransferOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransferOption::Export => "EXPORT",
            TransferOption::Import => "IMPORT",
            TransferOption::LocalUse => "LOCAL_USE",
            TransferOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPORT", "IMPORT", "LOCAL_USE"]
    }
}
impl AsRef<str> for TransferOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceServiceName {
    #[allow(missing_docs)] // documentation missing in model
    NfsOnDeviceService,
    #[allow(missing_docs)] // documentation missing in model
    S3OnDeviceService,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceServiceName {
    fn from(s: &str) -> Self {
        match s {
            "NFS_ON_DEVICE_SERVICE" => DeviceServiceName::NfsOnDeviceService,
            "S3_ON_DEVICE_SERVICE" => DeviceServiceName::S3OnDeviceService,
            other => DeviceServiceName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceServiceName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceServiceName::from(s))
    }
}
impl DeviceServiceName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceServiceName::NfsOnDeviceService => "NFS_ON_DEVICE_SERVICE",
            DeviceServiceName::S3OnDeviceService => "S3_ON_DEVICE_SERVICE",
            DeviceServiceName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NFS_ON_DEVICE_SERVICE", "S3_ON_DEVICE_SERVICE"]
    }
}
impl AsRef<str> for DeviceServiceName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a key range. For export jobs, a <code>S3Resource</code> object can have an optional <code>KeyRange</code> value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyRange {
    /// <p>The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
    pub begin_marker: std::option::Option<std::string::String>,
    /// <p>The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
    pub end_marker: std::option::Option<std::string::String>,
}
impl KeyRange {
    /// <p>The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
    pub fn begin_marker(&self) -> std::option::Option<&str> {
        self.begin_marker.as_deref()
    }
    /// <p>The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
    pub fn end_marker(&self) -> std::option::Option<&str> {
        self.end_marker.as_deref()
    }
}
impl std::fmt::Debug for KeyRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyRange");
        formatter.field("begin_marker", &self.begin_marker);
        formatter.field("end_marker", &self.end_marker);
        formatter.finish()
    }
}
/// See [`KeyRange`](crate::model::KeyRange)
pub mod key_range {
    /// A builder for [`KeyRange`](crate::model::KeyRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_marker: std::option::Option<std::string::String>,
        pub(crate) end_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
        pub fn begin_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.begin_marker = Some(input.into());
            self
        }
        /// <p>The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
        pub fn set_begin_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.begin_marker = input;
            self
        }
        /// <p>The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
        pub fn end_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_marker = Some(input.into());
            self
        }
        /// <p>The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>
        pub fn set_end_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyRange`](crate::model::KeyRange)
        pub fn build(self) -> crate::model::KeyRange {
            crate::model::KeyRange {
                begin_marker: self.begin_marker,
                end_marker: self.end_marker,
            }
        }
    }
}
impl KeyRange {
    /// Creates a new builder-style object to manufacture [`KeyRange`](crate::model::KeyRange)
    pub fn builder() -> crate::model::key_range::Builder {
        crate::model::key_range::Builder::default()
    }
}

/// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>
/// <p>When the notification settings are defined during job creation, you can choose to notify based on a specific set of job states using the <code>JobStatesToNotify</code> array of strings, or you can specify that you want to have Amazon SNS notifications sent out for all job states with <code>NotifyAll</code> set to true.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Notification {
    /// <p>The new SNS <code>TopicArn</code> that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html">CreateTopic</a> Amazon SNS API action.</p>
    /// <p>You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html">Subscribe</a> Amazon Simple Notification Service (Amazon SNS) API action.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The list of job states that will trigger a notification for this job.</p>
    pub job_states_to_notify: std::option::Option<std::vec::Vec<crate::model::JobState>>,
    /// <p>Any change in job state will trigger a notification for this job.</p>
    pub notify_all: bool,
}
impl Notification {
    /// <p>The new SNS <code>TopicArn</code> that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html">CreateTopic</a> Amazon SNS API action.</p>
    /// <p>You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html">Subscribe</a> Amazon Simple Notification Service (Amazon SNS) API action.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The list of job states that will trigger a notification for this job.</p>
    pub fn job_states_to_notify(&self) -> std::option::Option<&[crate::model::JobState]> {
        self.job_states_to_notify.as_deref()
    }
    /// <p>Any change in job state will trigger a notification for this job.</p>
    pub fn notify_all(&self) -> bool {
        self.notify_all
    }
}
impl std::fmt::Debug for Notification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Notification");
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("job_states_to_notify", &self.job_states_to_notify);
        formatter.field("notify_all", &self.notify_all);
        formatter.finish()
    }
}
/// See [`Notification`](crate::model::Notification)
pub mod notification {
    /// A builder for [`Notification`](crate::model::Notification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) job_states_to_notify: std::option::Option<std::vec::Vec<crate::model::JobState>>,
        pub(crate) notify_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The new SNS <code>TopicArn</code> that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html">CreateTopic</a> Amazon SNS API action.</p>
        /// <p>You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html">Subscribe</a> Amazon Simple Notification Service (Amazon SNS) API action.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The new SNS <code>TopicArn</code> that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html">CreateTopic</a> Amazon SNS API action.</p>
        /// <p>You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html">Subscribe</a> Amazon Simple Notification Service (Amazon SNS) API action.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Appends an item to `job_states_to_notify`.
        ///
        /// To override the contents of this collection use [`set_job_states_to_notify`](Self::set_job_states_to_notify).
        ///
        /// <p>The list of job states that will trigger a notification for this job.</p>
        pub fn job_states_to_notify(mut self, input: crate::model::JobState) -> Self {
            let mut v = self.job_states_to_notify.unwrap_or_default();
            v.push(input);
            self.job_states_to_notify = Some(v);
            self
        }
        /// <p>The list of job states that will trigger a notification for this job.</p>
        pub fn set_job_states_to_notify(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobState>>,
        ) -> Self {
            self.job_states_to_notify = input;
            self
        }
        /// <p>Any change in job state will trigger a notification for this job.</p>
        pub fn notify_all(mut self, input: bool) -> Self {
            self.notify_all = Some(input);
            self
        }
        /// <p>Any change in job state will trigger a notification for this job.</p>
        pub fn set_notify_all(mut self, input: std::option::Option<bool>) -> Self {
            self.notify_all = input;
            self
        }
        /// Consumes the builder and constructs a [`Notification`](crate::model::Notification)
        pub fn build(self) -> crate::model::Notification {
            crate::model::Notification {
                sns_topic_arn: self.sns_topic_arn,
                job_states_to_notify: self.job_states_to_notify,
                notify_all: self.notify_all.unwrap_or_default(),
            }
        }
    }
}
impl Notification {
    /// Creates a new builder-style object to manufacture [`Notification`](crate::model::Notification)
    pub fn builder() -> crate::model::notification::Builder {
        crate::model::notification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    InTransitToAws,
    #[allow(missing_docs)] // documentation missing in model
    InTransitToCustomer,
    #[allow(missing_docs)] // documentation missing in model
    Listing,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PreparingAppliance,
    #[allow(missing_docs)] // documentation missing in model
    PreparingShipment,
    #[allow(missing_docs)] // documentation missing in model
    WithAws,
    #[allow(missing_docs)] // documentation missing in model
    WithAwsSortingFacility,
    #[allow(missing_docs)] // documentation missing in model
    WithCustomer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobState {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => JobState::Cancelled,
            "Complete" => JobState::Complete,
            "InProgress" => JobState::InProgress,
            "InTransitToAWS" => JobState::InTransitToAws,
            "InTransitToCustomer" => JobState::InTransitToCustomer,
            "Listing" => JobState::Listing,
            "New" => JobState::New,
            "Pending" => JobState::Pending,
            "PreparingAppliance" => JobState::PreparingAppliance,
            "PreparingShipment" => JobState::PreparingShipment,
            "WithAWS" => JobState::WithAws,
            "WithAWSSortingFacility" => JobState::WithAwsSortingFacility,
            "WithCustomer" => JobState::WithCustomer,
            other => JobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobState::from(s))
    }
}
impl JobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobState::Cancelled => "Cancelled",
            JobState::Complete => "Complete",
            JobState::InProgress => "InProgress",
            JobState::InTransitToAws => "InTransitToAWS",
            JobState::InTransitToCustomer => "InTransitToCustomer",
            JobState::Listing => "Listing",
            JobState::New => "New",
            JobState::Pending => "Pending",
            JobState::PreparingAppliance => "PreparingAppliance",
            JobState::PreparingShipment => "PreparingShipment",
            JobState::WithAws => "WithAWS",
            JobState::WithAwsSortingFacility => "WithAWSSortingFacility",
            JobState::WithCustomer => "WithCustomer",
            JobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Complete",
            "InProgress",
            "InTransitToAWS",
            "InTransitToCustomer",
            "Listing",
            "New",
            "Pending",
            "PreparingAppliance",
            "PreparingShipment",
            "WithAWS",
            "WithAWSSortingFacility",
            "WithCustomer",
        ]
    }
}
impl AsRef<str> for JobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Each <code>LongTermPricingListEntry</code> object contains information about a long-term pricing type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LongTermPricingListEntry {
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub long_term_pricing_id: std::option::Option<std::string::String>,
    /// <p>The end date the long-term pricing contract.</p>
    pub long_term_pricing_end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The start date of the long-term pricing contract.</p>
    pub long_term_pricing_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of long-term pricing that was selected for the device.</p>
    pub long_term_pricing_type: std::option::Option<crate::model::LongTermPricingType>,
    /// <p>The current active jobs on the device the long-term pricing type.</p>
    pub current_active_job: std::option::Option<std::string::String>,
    /// <p>A new device that replaces a device that is ordered with long-term pricing.</p>
    pub replacement_job: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
    pub is_long_term_pricing_auto_renew: std::option::Option<bool>,
    /// <p>The status of the long-term pricing type.</p>
    pub long_term_pricing_status: std::option::Option<std::string::String>,
    /// <p>The type of Snow Family Devices associated with this long-term pricing job.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The IDs of the jobs that are associated with a long-term pricing type.</p>
    pub job_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LongTermPricingListEntry {
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub fn long_term_pricing_id(&self) -> std::option::Option<&str> {
        self.long_term_pricing_id.as_deref()
    }
    /// <p>The end date the long-term pricing contract.</p>
    pub fn long_term_pricing_end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.long_term_pricing_end_date.as_ref()
    }
    /// <p>The start date of the long-term pricing contract.</p>
    pub fn long_term_pricing_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.long_term_pricing_start_date.as_ref()
    }
    /// <p>The type of long-term pricing that was selected for the device.</p>
    pub fn long_term_pricing_type(
        &self,
    ) -> std::option::Option<&crate::model::LongTermPricingType> {
        self.long_term_pricing_type.as_ref()
    }
    /// <p>The current active jobs on the device the long-term pricing type.</p>
    pub fn current_active_job(&self) -> std::option::Option<&str> {
        self.current_active_job.as_deref()
    }
    /// <p>A new device that replaces a device that is ordered with long-term pricing.</p>
    pub fn replacement_job(&self) -> std::option::Option<&str> {
        self.replacement_job.as_deref()
    }
    /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
    pub fn is_long_term_pricing_auto_renew(&self) -> std::option::Option<bool> {
        self.is_long_term_pricing_auto_renew
    }
    /// <p>The status of the long-term pricing type.</p>
    pub fn long_term_pricing_status(&self) -> std::option::Option<&str> {
        self.long_term_pricing_status.as_deref()
    }
    /// <p>The type of Snow Family Devices associated with this long-term pricing job.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The IDs of the jobs that are associated with a long-term pricing type.</p>
    pub fn job_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.job_ids.as_deref()
    }
}
impl std::fmt::Debug for LongTermPricingListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LongTermPricingListEntry");
        formatter.field("long_term_pricing_id", &self.long_term_pricing_id);
        formatter.field(
            "long_term_pricing_end_date",
            &self.long_term_pricing_end_date,
        );
        formatter.field(
            "long_term_pricing_start_date",
            &self.long_term_pricing_start_date,
        );
        formatter.field("long_term_pricing_type", &self.long_term_pricing_type);
        formatter.field("current_active_job", &self.current_active_job);
        formatter.field("replacement_job", &self.replacement_job);
        formatter.field(
            "is_long_term_pricing_auto_renew",
            &self.is_long_term_pricing_auto_renew,
        );
        formatter.field("long_term_pricing_status", &self.long_term_pricing_status);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("job_ids", &self.job_ids);
        formatter.finish()
    }
}
/// See [`LongTermPricingListEntry`](crate::model::LongTermPricingListEntry)
pub mod long_term_pricing_list_entry {
    /// A builder for [`LongTermPricingListEntry`](crate::model::LongTermPricingListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) long_term_pricing_id: std::option::Option<std::string::String>,
        pub(crate) long_term_pricing_end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) long_term_pricing_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) long_term_pricing_type: std::option::Option<crate::model::LongTermPricingType>,
        pub(crate) current_active_job: std::option::Option<std::string::String>,
        pub(crate) replacement_job: std::option::Option<std::string::String>,
        pub(crate) is_long_term_pricing_auto_renew: std::option::Option<bool>,
        pub(crate) long_term_pricing_status: std::option::Option<std::string::String>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) job_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_term_pricing_id = Some(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_term_pricing_id = input;
            self
        }
        /// <p>The end date the long-term pricing contract.</p>
        pub fn long_term_pricing_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.long_term_pricing_end_date = Some(input);
            self
        }
        /// <p>The end date the long-term pricing contract.</p>
        pub fn set_long_term_pricing_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.long_term_pricing_end_date = input;
            self
        }
        /// <p>The start date of the long-term pricing contract.</p>
        pub fn long_term_pricing_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.long_term_pricing_start_date = Some(input);
            self
        }
        /// <p>The start date of the long-term pricing contract.</p>
        pub fn set_long_term_pricing_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.long_term_pricing_start_date = input;
            self
        }
        /// <p>The type of long-term pricing that was selected for the device.</p>
        pub fn long_term_pricing_type(mut self, input: crate::model::LongTermPricingType) -> Self {
            self.long_term_pricing_type = Some(input);
            self
        }
        /// <p>The type of long-term pricing that was selected for the device.</p>
        pub fn set_long_term_pricing_type(
            mut self,
            input: std::option::Option<crate::model::LongTermPricingType>,
        ) -> Self {
            self.long_term_pricing_type = input;
            self
        }
        /// <p>The current active jobs on the device the long-term pricing type.</p>
        pub fn current_active_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_active_job = Some(input.into());
            self
        }
        /// <p>The current active jobs on the device the long-term pricing type.</p>
        pub fn set_current_active_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_active_job = input;
            self
        }
        /// <p>A new device that replaces a device that is ordered with long-term pricing.</p>
        pub fn replacement_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.replacement_job = Some(input.into());
            self
        }
        /// <p>A new device that replaces a device that is ordered with long-term pricing.</p>
        pub fn set_replacement_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replacement_job = input;
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn is_long_term_pricing_auto_renew(mut self, input: bool) -> Self {
            self.is_long_term_pricing_auto_renew = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn set_is_long_term_pricing_auto_renew(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_long_term_pricing_auto_renew = input;
            self
        }
        /// <p>The status of the long-term pricing type.</p>
        pub fn long_term_pricing_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_term_pricing_status = Some(input.into());
            self
        }
        /// <p>The status of the long-term pricing type.</p>
        pub fn set_long_term_pricing_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_term_pricing_status = input;
            self
        }
        /// <p>The type of Snow Family Devices associated with this long-term pricing job.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of Snow Family Devices associated with this long-term pricing job.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// Appends an item to `job_ids`.
        ///
        /// To override the contents of this collection use [`set_job_ids`](Self::set_job_ids).
        ///
        /// <p>The IDs of the jobs that are associated with a long-term pricing type.</p>
        pub fn job_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_ids.unwrap_or_default();
            v.push(input.into());
            self.job_ids = Some(v);
            self
        }
        /// <p>The IDs of the jobs that are associated with a long-term pricing type.</p>
        pub fn set_job_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`LongTermPricingListEntry`](crate::model::LongTermPricingListEntry)
        pub fn build(self) -> crate::model::LongTermPricingListEntry {
            crate::model::LongTermPricingListEntry {
                long_term_pricing_id: self.long_term_pricing_id,
                long_term_pricing_end_date: self.long_term_pricing_end_date,
                long_term_pricing_start_date: self.long_term_pricing_start_date,
                long_term_pricing_type: self.long_term_pricing_type,
                current_active_job: self.current_active_job,
                replacement_job: self.replacement_job,
                is_long_term_pricing_auto_renew: self.is_long_term_pricing_auto_renew,
                long_term_pricing_status: self.long_term_pricing_status,
                snowball_type: self.snowball_type,
                job_ids: self.job_ids,
            }
        }
    }
}
impl LongTermPricingListEntry {
    /// Creates a new builder-style object to manufacture [`LongTermPricingListEntry`](crate::model::LongTermPricingListEntry)
    pub fn builder() -> crate::model::long_term_pricing_list_entry::Builder {
        crate::model::long_term_pricing_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnowballType {
    #[allow(missing_docs)] // documentation missing in model
    Edge,
    #[allow(missing_docs)] // documentation missing in model
    EdgeC,
    #[allow(missing_docs)] // documentation missing in model
    EdgeCg,
    #[allow(missing_docs)] // documentation missing in model
    EdgeS,
    #[allow(missing_docs)] // documentation missing in model
    Snc1Hdd,
    #[allow(missing_docs)] // documentation missing in model
    Snc1Ssd,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnowballType {
    fn from(s: &str) -> Self {
        match s {
            "EDGE" => SnowballType::Edge,
            "EDGE_C" => SnowballType::EdgeC,
            "EDGE_CG" => SnowballType::EdgeCg,
            "EDGE_S" => SnowballType::EdgeS,
            "SNC1_HDD" => SnowballType::Snc1Hdd,
            "SNC1_SSD" => SnowballType::Snc1Ssd,
            "STANDARD" => SnowballType::Standard,
            other => SnowballType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnowballType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnowballType::from(s))
    }
}
impl SnowballType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnowballType::Edge => "EDGE",
            SnowballType::EdgeC => "EDGE_C",
            SnowballType::EdgeCg => "EDGE_CG",
            SnowballType::EdgeS => "EDGE_S",
            SnowballType::Snc1Hdd => "SNC1_HDD",
            SnowballType::Snc1Ssd => "SNC1_SSD",
            SnowballType::Standard => "STANDARD",
            SnowballType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EDGE", "EDGE_C", "EDGE_CG", "EDGE_S", "SNC1_HDD", "SNC1_SSD", "STANDARD",
        ]
    }
}
impl AsRef<str> for SnowballType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LongTermPricingType {
    #[allow(missing_docs)] // documentation missing in model
    OneYear,
    #[allow(missing_docs)] // documentation missing in model
    ThreeYear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LongTermPricingType {
    fn from(s: &str) -> Self {
        match s {
            "OneYear" => LongTermPricingType::OneYear,
            "ThreeYear" => LongTermPricingType::ThreeYear,
            other => LongTermPricingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LongTermPricingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LongTermPricingType::from(s))
    }
}
impl LongTermPricingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LongTermPricingType::OneYear => "OneYear",
            LongTermPricingType::ThreeYear => "ThreeYear",
            LongTermPricingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OneYear", "ThreeYear"]
    }
}
impl AsRef<str> for LongTermPricingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of an export job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobListEntry {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current state of this job.</p>
    pub job_state: std::option::Option<crate::model::JobState>,
    /// <p>A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.</p>
    pub is_master: bool,
    /// <p>The type of job.</p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>The type of device used with this job.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The creation date for this job.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
    pub description: std::option::Option<std::string::String>,
}
impl JobListEntry {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The current state of this job.</p>
    pub fn job_state(&self) -> std::option::Option<&crate::model::JobState> {
        self.job_state.as_ref()
    }
    /// <p>A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.</p>
    pub fn is_master(&self) -> bool {
        self.is_master
    }
    /// <p>The type of job.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>The type of device used with this job.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The creation date for this job.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for JobListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobListEntry");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_state", &self.job_state);
        formatter.field("is_master", &self.is_master);
        formatter.field("job_type", &self.job_type);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`JobListEntry`](crate::model::JobListEntry)
pub mod job_list_entry {
    /// A builder for [`JobListEntry`](crate::model::JobListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_state: std::option::Option<crate::model::JobState>,
        pub(crate) is_master: std::option::Option<bool>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current state of this job.</p>
        pub fn job_state(mut self, input: crate::model::JobState) -> Self {
            self.job_state = Some(input);
            self
        }
        /// <p>The current state of this job.</p>
        pub fn set_job_state(mut self, input: std::option::Option<crate::model::JobState>) -> Self {
            self.job_state = input;
            self
        }
        /// <p>A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.</p>
        pub fn is_master(mut self, input: bool) -> Self {
            self.is_master = Some(input);
            self
        }
        /// <p>A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.</p>
        pub fn set_is_master(mut self, input: std::option::Option<bool>) -> Self {
            self.is_master = input;
            self
        }
        /// <p>The type of job.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The type of device used with this job.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of device used with this job.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// <p>The creation date for this job.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date for this job.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`JobListEntry`](crate::model::JobListEntry)
        pub fn build(self) -> crate::model::JobListEntry {
            crate::model::JobListEntry {
                job_id: self.job_id,
                job_state: self.job_state,
                is_master: self.is_master.unwrap_or_default(),
                job_type: self.job_type,
                snowball_type: self.snowball_type,
                creation_date: self.creation_date,
                description: self.description,
            }
        }
    }
}
impl JobListEntry {
    /// Creates a new builder-style object to manufacture [`JobListEntry`](crate::model::JobListEntry)
    pub fn builder() -> crate::model::job_list_entry::Builder {
        crate::model::job_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    Export,
    #[allow(missing_docs)] // documentation missing in model
    Import,
    #[allow(missing_docs)] // documentation missing in model
    LocalUse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "EXPORT" => JobType::Export,
            "IMPORT" => JobType::Import,
            "LOCAL_USE" => JobType::LocalUse,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::Export => "EXPORT",
            JobType::Import => "IMPORT",
            JobType::LocalUse => "LOCAL_USE",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPORT", "IMPORT", "LOCAL_USE"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A JSON-formatted object that describes a compatible Amazon Machine Image (AMI), including the ID and name for a Snow device AMI. This AMI is compatible with the device's physical hardware requirements, and it should be able to be run in an SBE1 instance on the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompatibleImage {
    /// <p>The unique identifier for an individual Snow device AMI.</p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The optional name of a compatible image.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CompatibleImage {
    /// <p>The unique identifier for an individual Snow device AMI.</p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The optional name of a compatible image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CompatibleImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompatibleImage");
        formatter.field("ami_id", &self.ami_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CompatibleImage`](crate::model::CompatibleImage)
pub mod compatible_image {
    /// A builder for [`CompatibleImage`](crate::model::CompatibleImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for an individual Snow device AMI.</p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for an individual Snow device AMI.</p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The optional name of a compatible image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The optional name of a compatible image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CompatibleImage`](crate::model::CompatibleImage)
        pub fn build(self) -> crate::model::CompatibleImage {
            crate::model::CompatibleImage {
                ami_id: self.ami_id,
                name: self.name,
            }
        }
    }
}
impl CompatibleImage {
    /// Creates a new builder-style object to manufacture [`CompatibleImage`](crate::model::CompatibleImage)
    pub fn builder() -> crate::model::compatible_image::Builder {
        crate::model::compatible_image::Builder::default()
    }
}

/// <p>Contains a cluster's state, a cluster's ID, and other important information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterListEntry {
    /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The current state of this cluster. For information about the state of a specific node, see <code>JobListEntry$JobState</code>.</p>
    pub cluster_state: std::option::Option<crate::model::ClusterState>,
    /// <p>The creation date for this cluster.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ClusterListEntry {
    /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The current state of this cluster. For information about the state of a specific node, see <code>JobListEntry$JobState</code>.</p>
    pub fn cluster_state(&self) -> std::option::Option<&crate::model::ClusterState> {
        self.cluster_state.as_ref()
    }
    /// <p>The creation date for this cluster.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ClusterListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterListEntry");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("cluster_state", &self.cluster_state);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ClusterListEntry`](crate::model::ClusterListEntry)
pub mod cluster_list_entry {
    /// A builder for [`ClusterListEntry`](crate::model::ClusterListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) cluster_state: std::option::Option<crate::model::ClusterState>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The current state of this cluster. For information about the state of a specific node, see <code>JobListEntry$JobState</code>.</p>
        pub fn cluster_state(mut self, input: crate::model::ClusterState) -> Self {
            self.cluster_state = Some(input);
            self
        }
        /// <p>The current state of this cluster. For information about the state of a specific node, see <code>JobListEntry$JobState</code>.</p>
        pub fn set_cluster_state(
            mut self,
            input: std::option::Option<crate::model::ClusterState>,
        ) -> Self {
            self.cluster_state = input;
            self
        }
        /// <p>The creation date for this cluster.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date for this cluster.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterListEntry`](crate::model::ClusterListEntry)
        pub fn build(self) -> crate::model::ClusterListEntry {
            crate::model::ClusterListEntry {
                cluster_id: self.cluster_id,
                cluster_state: self.cluster_state,
                creation_date: self.creation_date,
                description: self.description,
            }
        }
    }
}
impl ClusterListEntry {
    /// Creates a new builder-style object to manufacture [`ClusterListEntry`](crate::model::ClusterListEntry)
    pub fn builder() -> crate::model::cluster_list_entry::Builder {
        crate::model::cluster_list_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterState {
    #[allow(missing_docs)] // documentation missing in model
    AwaitingQuorum,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InUse,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterState {
    fn from(s: &str) -> Self {
        match s {
            "AwaitingQuorum" => ClusterState::AwaitingQuorum,
            "Cancelled" => ClusterState::Cancelled,
            "Complete" => ClusterState::Complete,
            "InUse" => ClusterState::InUse,
            "Pending" => ClusterState::Pending,
            other => ClusterState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterState::from(s))
    }
}
impl ClusterState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterState::AwaitingQuorum => "AwaitingQuorum",
            ClusterState::Cancelled => "Cancelled",
            ClusterState::Complete => "Complete",
            ClusterState::InUse => "InUse",
            ClusterState::Pending => "Pending",
            ClusterState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AwaitingQuorum",
            "Cancelled",
            "Complete",
            "InUse",
            "Pending",
        ]
    }
}
impl AsRef<str> for ClusterState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShippingLabelStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShippingLabelStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => ShippingLabelStatus::Failed,
            "InProgress" => ShippingLabelStatus::InProgress,
            "Succeeded" => ShippingLabelStatus::Succeeded,
            "TimedOut" => ShippingLabelStatus::TimedOut,
            other => ShippingLabelStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShippingLabelStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShippingLabelStatus::from(s))
    }
}
impl ShippingLabelStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShippingLabelStatus::Failed => "Failed",
            ShippingLabelStatus::InProgress => "InProgress",
            ShippingLabelStatus::Succeeded => "Succeeded",
            ShippingLabelStatus::TimedOut => "TimedOut",
            ShippingLabelStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Succeeded", "TimedOut"]
    }
}
impl AsRef<str> for ShippingLabelStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a specific job including shipping information, job status, and other important metadata. This information is returned as a part of the response syntax of the <code>DescribeJob</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobMetadata {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the jobs.</p>
    pub job_state: std::option::Option<crate::model::JobState>,
    /// <p>The type of job.</p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>The type of device used with this job.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The creation date for this job.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.</p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>The description of the job, provided at job creation.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in KMS.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The role ARN associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the address that you want the Snow device shipped to.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>
    pub shipping_details: std::option::Option<crate::model::ShippingDetails>,
    /// <p>The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub snowball_capacity_preference: std::option::Option<crate::model::SnowballCapacity>,
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>
    pub data_transfer_progress: std::option::Option<crate::model::DataTransfer>,
    /// <p>Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.</p>
    pub job_log_info: std::option::Option<crate::model::JobLogs>,
    /// <p>The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
    /// <p>The metadata associated with the tax documents required in your Amazon Web Services Region.</p>
    pub tax_documents: std::option::Option<crate::model::TaxDocuments>,
    /// <p>The container for <code>SnowconeDeviceConfiguration</code>. </p>
    pub device_configuration: std::option::Option<crate::model::DeviceConfiguration>,
    /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub remote_management: std::option::Option<crate::model::RemoteManagement>,
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub long_term_pricing_id: std::option::Option<std::string::String>,
    /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
}
impl JobMetadata {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The current status of the jobs.</p>
    pub fn job_state(&self) -> std::option::Option<&crate::model::JobState> {
        self.job_state.as_ref()
    }
    /// <p>The type of job.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>The type of device used with this job.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The creation date for this job.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>The description of the job, provided at job creation.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in KMS.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The role ARN associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ID for the address that you want the Snow device shipped to.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>
    pub fn shipping_details(&self) -> std::option::Option<&crate::model::ShippingDetails> {
        self.shipping_details.as_ref()
    }
    /// <p>The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn snowball_capacity_preference(
        &self,
    ) -> std::option::Option<&crate::model::SnowballCapacity> {
        self.snowball_capacity_preference.as_ref()
    }
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>
    pub fn data_transfer_progress(&self) -> std::option::Option<&crate::model::DataTransfer> {
        self.data_transfer_progress.as_ref()
    }
    /// <p>Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.</p>
    pub fn job_log_info(&self) -> std::option::Option<&crate::model::JobLogs> {
        self.job_log_info.as_ref()
    }
    /// <p>The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
    /// <p>The metadata associated with the tax documents required in your Amazon Web Services Region.</p>
    pub fn tax_documents(&self) -> std::option::Option<&crate::model::TaxDocuments> {
        self.tax_documents.as_ref()
    }
    /// <p>The container for <code>SnowconeDeviceConfiguration</code>. </p>
    pub fn device_configuration(&self) -> std::option::Option<&crate::model::DeviceConfiguration> {
        self.device_configuration.as_ref()
    }
    /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub fn remote_management(&self) -> std::option::Option<&crate::model::RemoteManagement> {
        self.remote_management.as_ref()
    }
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub fn long_term_pricing_id(&self) -> std::option::Option<&str> {
        self.long_term_pricing_id.as_deref()
    }
    /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
}
impl std::fmt::Debug for JobMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobMetadata");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_state", &self.job_state);
        formatter.field("job_type", &self.job_type);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("resources", &self.resources);
        formatter.field("description", &self.description);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("address_id", &self.address_id);
        formatter.field("shipping_details", &self.shipping_details);
        formatter.field(
            "snowball_capacity_preference",
            &self.snowball_capacity_preference,
        );
        formatter.field("notification", &self.notification);
        formatter.field("data_transfer_progress", &self.data_transfer_progress);
        formatter.field("job_log_info", &self.job_log_info);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.field("tax_documents", &self.tax_documents);
        formatter.field("device_configuration", &self.device_configuration);
        formatter.field("remote_management", &self.remote_management);
        formatter.field("long_term_pricing_id", &self.long_term_pricing_id);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.finish()
    }
}
/// See [`JobMetadata`](crate::model::JobMetadata)
pub mod job_metadata {
    /// A builder for [`JobMetadata`](crate::model::JobMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_state: std::option::Option<crate::model::JobState>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) shipping_details: std::option::Option<crate::model::ShippingDetails>,
        pub(crate) snowball_capacity_preference:
            std::option::Option<crate::model::SnowballCapacity>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) data_transfer_progress: std::option::Option<crate::model::DataTransfer>,
        pub(crate) job_log_info: std::option::Option<crate::model::JobLogs>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
        pub(crate) tax_documents: std::option::Option<crate::model::TaxDocuments>,
        pub(crate) device_configuration: std::option::Option<crate::model::DeviceConfiguration>,
        pub(crate) remote_management: std::option::Option<crate::model::RemoteManagement>,
        pub(crate) long_term_pricing_id: std::option::Option<std::string::String>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the jobs.</p>
        pub fn job_state(mut self, input: crate::model::JobState) -> Self {
            self.job_state = Some(input);
            self
        }
        /// <p>The current status of the jobs.</p>
        pub fn set_job_state(mut self, input: std::option::Option<crate::model::JobState>) -> Self {
            self.job_state = input;
            self
        }
        /// <p>The type of job.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The type of device used with this job.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of device used with this job.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// <p>The creation date for this job.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date for this job.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The description of the job, provided at job creation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the job, provided at job creation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in KMS.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in KMS.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The role ARN associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>
        pub fn shipping_details(mut self, input: crate::model::ShippingDetails) -> Self {
            self.shipping_details = Some(input);
            self
        }
        /// <p>A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>
        pub fn set_shipping_details(
            mut self,
            input: std::option::Option<crate::model::ShippingDetails>,
        ) -> Self {
            self.shipping_details = input;
            self
        }
        /// <p>The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_capacity_preference(
            mut self,
            input: crate::model::SnowballCapacity,
        ) -> Self {
            self.snowball_capacity_preference = Some(input);
            self
        }
        /// <p>The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_capacity_preference(
            mut self,
            input: std::option::Option<crate::model::SnowballCapacity>,
        ) -> Self {
            self.snowball_capacity_preference = input;
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>
        pub fn data_transfer_progress(mut self, input: crate::model::DataTransfer) -> Self {
            self.data_transfer_progress = Some(input);
            self
        }
        /// <p>A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>
        pub fn set_data_transfer_progress(
            mut self,
            input: std::option::Option<crate::model::DataTransfer>,
        ) -> Self {
            self.data_transfer_progress = input;
            self
        }
        /// <p>Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.</p>
        pub fn job_log_info(mut self, input: crate::model::JobLogs) -> Self {
            self.job_log_info = Some(input);
            self
        }
        /// <p>Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.</p>
        pub fn set_job_log_info(
            mut self,
            input: std::option::Option<crate::model::JobLogs>,
        ) -> Self {
            self.job_log_info = input;
            self
        }
        /// <p>The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// <p>The metadata associated with the tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.tax_documents = Some(input);
            self
        }
        /// <p>The metadata associated with the tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.tax_documents = input;
            self
        }
        /// <p>The container for <code>SnowconeDeviceConfiguration</code>. </p>
        pub fn device_configuration(mut self, input: crate::model::DeviceConfiguration) -> Self {
            self.device_configuration = Some(input);
            self
        }
        /// <p>The container for <code>SnowconeDeviceConfiguration</code>. </p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfiguration>,
        ) -> Self {
            self.device_configuration = input;
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn remote_management(mut self, input: crate::model::RemoteManagement) -> Self {
            self.remote_management = Some(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn set_remote_management(
            mut self,
            input: std::option::Option<crate::model::RemoteManagement>,
        ) -> Self {
            self.remote_management = input;
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_term_pricing_id = Some(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_term_pricing_id = input;
            self
        }
        /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`JobMetadata`](crate::model::JobMetadata)
        pub fn build(self) -> crate::model::JobMetadata {
            crate::model::JobMetadata {
                job_id: self.job_id,
                job_state: self.job_state,
                job_type: self.job_type,
                snowball_type: self.snowball_type,
                creation_date: self.creation_date,
                resources: self.resources,
                description: self.description,
                kms_key_arn: self.kms_key_arn,
                role_arn: self.role_arn,
                address_id: self.address_id,
                shipping_details: self.shipping_details,
                snowball_capacity_preference: self.snowball_capacity_preference,
                notification: self.notification,
                data_transfer_progress: self.data_transfer_progress,
                job_log_info: self.job_log_info,
                cluster_id: self.cluster_id,
                forwarding_address_id: self.forwarding_address_id,
                tax_documents: self.tax_documents,
                device_configuration: self.device_configuration,
                remote_management: self.remote_management,
                long_term_pricing_id: self.long_term_pricing_id,
                on_device_service_configuration: self.on_device_service_configuration,
            }
        }
    }
}
impl JobMetadata {
    /// Creates a new builder-style object to manufacture [`JobMetadata`](crate::model::JobMetadata)
    pub fn builder() -> crate::model::job_metadata::Builder {
        crate::model::job_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RemoteManagement {
    #[allow(missing_docs)] // documentation missing in model
    InstalledAutostart,
    #[allow(missing_docs)] // documentation missing in model
    InstalledOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RemoteManagement {
    fn from(s: &str) -> Self {
        match s {
            "INSTALLED_AUTOSTART" => RemoteManagement::InstalledAutostart,
            "INSTALLED_ONLY" => RemoteManagement::InstalledOnly,
            other => RemoteManagement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RemoteManagement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RemoteManagement::from(s))
    }
}
impl RemoteManagement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RemoteManagement::InstalledAutostart => "INSTALLED_AUTOSTART",
            RemoteManagement::InstalledOnly => "INSTALLED_ONLY",
            RemoteManagement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTALLED_AUTOSTART", "INSTALLED_ONLY"]
    }
}
impl AsRef<str> for RemoteManagement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container for <code>SnowconeDeviceConfiguration</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceConfiguration {
    /// <p>Returns information about the device configuration for an Snowcone job.</p>
    pub snowcone_device_configuration:
        std::option::Option<crate::model::SnowconeDeviceConfiguration>,
}
impl DeviceConfiguration {
    /// <p>Returns information about the device configuration for an Snowcone job.</p>
    pub fn snowcone_device_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SnowconeDeviceConfiguration> {
        self.snowcone_device_configuration.as_ref()
    }
}
impl std::fmt::Debug for DeviceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceConfiguration");
        formatter.field(
            "snowcone_device_configuration",
            &self.snowcone_device_configuration,
        );
        formatter.finish()
    }
}
/// See [`DeviceConfiguration`](crate::model::DeviceConfiguration)
pub mod device_configuration {
    /// A builder for [`DeviceConfiguration`](crate::model::DeviceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snowcone_device_configuration:
            std::option::Option<crate::model::SnowconeDeviceConfiguration>,
    }
    impl Builder {
        /// <p>Returns information about the device configuration for an Snowcone job.</p>
        pub fn snowcone_device_configuration(
            mut self,
            input: crate::model::SnowconeDeviceConfiguration,
        ) -> Self {
            self.snowcone_device_configuration = Some(input);
            self
        }
        /// <p>Returns information about the device configuration for an Snowcone job.</p>
        pub fn set_snowcone_device_configuration(
            mut self,
            input: std::option::Option<crate::model::SnowconeDeviceConfiguration>,
        ) -> Self {
            self.snowcone_device_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceConfiguration`](crate::model::DeviceConfiguration)
        pub fn build(self) -> crate::model::DeviceConfiguration {
            crate::model::DeviceConfiguration {
                snowcone_device_configuration: self.snowcone_device_configuration,
            }
        }
    }
}
impl DeviceConfiguration {
    /// Creates a new builder-style object to manufacture [`DeviceConfiguration`](crate::model::DeviceConfiguration)
    pub fn builder() -> crate::model::device_configuration::Builder {
        crate::model::device_configuration::Builder::default()
    }
}

/// <p>Specifies the device configuration for an Snowcone job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnowconeDeviceConfiguration {
    /// <p>Configures the wireless connection for the Snowcone device.</p>
    pub wireless_connection: std::option::Option<crate::model::WirelessConnection>,
}
impl SnowconeDeviceConfiguration {
    /// <p>Configures the wireless connection for the Snowcone device.</p>
    pub fn wireless_connection(&self) -> std::option::Option<&crate::model::WirelessConnection> {
        self.wireless_connection.as_ref()
    }
}
impl std::fmt::Debug for SnowconeDeviceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnowconeDeviceConfiguration");
        formatter.field("wireless_connection", &self.wireless_connection);
        formatter.finish()
    }
}
/// See [`SnowconeDeviceConfiguration`](crate::model::SnowconeDeviceConfiguration)
pub mod snowcone_device_configuration {
    /// A builder for [`SnowconeDeviceConfiguration`](crate::model::SnowconeDeviceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) wireless_connection: std::option::Option<crate::model::WirelessConnection>,
    }
    impl Builder {
        /// <p>Configures the wireless connection for the Snowcone device.</p>
        pub fn wireless_connection(mut self, input: crate::model::WirelessConnection) -> Self {
            self.wireless_connection = Some(input);
            self
        }
        /// <p>Configures the wireless connection for the Snowcone device.</p>
        pub fn set_wireless_connection(
            mut self,
            input: std::option::Option<crate::model::WirelessConnection>,
        ) -> Self {
            self.wireless_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`SnowconeDeviceConfiguration`](crate::model::SnowconeDeviceConfiguration)
        pub fn build(self) -> crate::model::SnowconeDeviceConfiguration {
            crate::model::SnowconeDeviceConfiguration {
                wireless_connection: self.wireless_connection,
            }
        }
    }
}
impl SnowconeDeviceConfiguration {
    /// Creates a new builder-style object to manufacture [`SnowconeDeviceConfiguration`](crate::model::SnowconeDeviceConfiguration)
    pub fn builder() -> crate::model::snowcone_device_configuration::Builder {
        crate::model::snowcone_device_configuration::Builder::default()
    }
}

/// <p>Configures the wireless connection on an Snowcone device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WirelessConnection {
    /// <p>Enables the Wi-Fi adapter on an Snowcone device.</p>
    pub is_wifi_enabled: bool,
}
impl WirelessConnection {
    /// <p>Enables the Wi-Fi adapter on an Snowcone device.</p>
    pub fn is_wifi_enabled(&self) -> bool {
        self.is_wifi_enabled
    }
}
impl std::fmt::Debug for WirelessConnection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WirelessConnection");
        formatter.field("is_wifi_enabled", &self.is_wifi_enabled);
        formatter.finish()
    }
}
/// See [`WirelessConnection`](crate::model::WirelessConnection)
pub mod wireless_connection {
    /// A builder for [`WirelessConnection`](crate::model::WirelessConnection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_wifi_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables the Wi-Fi adapter on an Snowcone device.</p>
        pub fn is_wifi_enabled(mut self, input: bool) -> Self {
            self.is_wifi_enabled = Some(input);
            self
        }
        /// <p>Enables the Wi-Fi adapter on an Snowcone device.</p>
        pub fn set_is_wifi_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_wifi_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`WirelessConnection`](crate::model::WirelessConnection)
        pub fn build(self) -> crate::model::WirelessConnection {
            crate::model::WirelessConnection {
                is_wifi_enabled: self.is_wifi_enabled.unwrap_or_default(),
            }
        }
    }
}
impl WirelessConnection {
    /// Creates a new builder-style object to manufacture [`WirelessConnection`](crate::model::WirelessConnection)
    pub fn builder() -> crate::model::wireless_connection::Builder {
        crate::model::wireless_connection::Builder::default()
    }
}

/// <p>The tax documents required in your Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaxDocuments {
    /// <p>The tax documents required in Amazon Web Services Region in India.</p>
    pub ind: std::option::Option<crate::model::IndTaxDocuments>,
}
impl TaxDocuments {
    /// <p>The tax documents required in Amazon Web Services Region in India.</p>
    pub fn ind(&self) -> std::option::Option<&crate::model::IndTaxDocuments> {
        self.ind.as_ref()
    }
}
impl std::fmt::Debug for TaxDocuments {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaxDocuments");
        formatter.field("ind", &self.ind);
        formatter.finish()
    }
}
/// See [`TaxDocuments`](crate::model::TaxDocuments)
pub mod tax_documents {
    /// A builder for [`TaxDocuments`](crate::model::TaxDocuments)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ind: std::option::Option<crate::model::IndTaxDocuments>,
    }
    impl Builder {
        /// <p>The tax documents required in Amazon Web Services Region in India.</p>
        pub fn ind(mut self, input: crate::model::IndTaxDocuments) -> Self {
            self.ind = Some(input);
            self
        }
        /// <p>The tax documents required in Amazon Web Services Region in India.</p>
        pub fn set_ind(
            mut self,
            input: std::option::Option<crate::model::IndTaxDocuments>,
        ) -> Self {
            self.ind = input;
            self
        }
        /// Consumes the builder and constructs a [`TaxDocuments`](crate::model::TaxDocuments)
        pub fn build(self) -> crate::model::TaxDocuments {
            crate::model::TaxDocuments { ind: self.ind }
        }
    }
}
impl TaxDocuments {
    /// Creates a new builder-style object to manufacture [`TaxDocuments`](crate::model::TaxDocuments)
    pub fn builder() -> crate::model::tax_documents::Builder {
        crate::model::tax_documents::Builder::default()
    }
}

/// <p>The tax documents required in Amazon Web Services Region in India.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndTaxDocuments {
    /// <p>The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.</p>
    pub gstin: std::option::Option<std::string::String>,
}
impl IndTaxDocuments {
    /// <p>The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.</p>
    pub fn gstin(&self) -> std::option::Option<&str> {
        self.gstin.as_deref()
    }
}
impl std::fmt::Debug for IndTaxDocuments {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndTaxDocuments");
        formatter.field("gstin", &self.gstin);
        formatter.finish()
    }
}
/// See [`IndTaxDocuments`](crate::model::IndTaxDocuments)
pub mod ind_tax_documents {
    /// A builder for [`IndTaxDocuments`](crate::model::IndTaxDocuments)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gstin: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.</p>
        pub fn gstin(mut self, input: impl Into<std::string::String>) -> Self {
            self.gstin = Some(input.into());
            self
        }
        /// <p>The Goods and Services Tax (GST) documents required in Amazon Web Services Region in India.</p>
        pub fn set_gstin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gstin = input;
            self
        }
        /// Consumes the builder and constructs a [`IndTaxDocuments`](crate::model::IndTaxDocuments)
        pub fn build(self) -> crate::model::IndTaxDocuments {
            crate::model::IndTaxDocuments { gstin: self.gstin }
        }
    }
}
impl IndTaxDocuments {
    /// Creates a new builder-style object to manufacture [`IndTaxDocuments`](crate::model::IndTaxDocuments)
    pub fn builder() -> crate::model::ind_tax_documents::Builder {
        crate::model::ind_tax_documents::Builder::default()
    }
}

/// <p>Contains job logs. Whenever a Snow device is used to import data into or export data out of Amazon S3, you'll have the option of downloading a PDF job report. Job logs are returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type. The job logs can be accessed for up to 60 minutes after this request has been made. To access any of the job logs after 60 minutes have passed, you'll have to make another call to the <code>DescribeJob</code> action.</p>
/// <p>For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.</p>
/// <p>The job report provides you insight into the state of your Amazon S3 data transfer. The report includes details about your job or job part for your records.</p>
/// <p>For deeper visibility into the status of your transferred objects, you can look at the two associated logs: a success log and a failure log. The logs are saved in comma-separated value (CSV) format, and the name of each log includes the ID of the job or job part that the log describes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobLogs {
    /// <p>A link to an Amazon S3 presigned URL where the job completion report is located.</p>
    pub job_completion_report_uri: std::option::Option<std::string::String>,
    /// <p>A link to an Amazon S3 presigned URL where the job success log is located.</p>
    pub job_success_log_uri: std::option::Option<std::string::String>,
    /// <p>A link to an Amazon S3 presigned URL where the job failure log is located.</p>
    pub job_failure_log_uri: std::option::Option<std::string::String>,
}
impl JobLogs {
    /// <p>A link to an Amazon S3 presigned URL where the job completion report is located.</p>
    pub fn job_completion_report_uri(&self) -> std::option::Option<&str> {
        self.job_completion_report_uri.as_deref()
    }
    /// <p>A link to an Amazon S3 presigned URL where the job success log is located.</p>
    pub fn job_success_log_uri(&self) -> std::option::Option<&str> {
        self.job_success_log_uri.as_deref()
    }
    /// <p>A link to an Amazon S3 presigned URL where the job failure log is located.</p>
    pub fn job_failure_log_uri(&self) -> std::option::Option<&str> {
        self.job_failure_log_uri.as_deref()
    }
}
impl std::fmt::Debug for JobLogs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobLogs");
        formatter.field("job_completion_report_uri", &self.job_completion_report_uri);
        formatter.field("job_success_log_uri", &self.job_success_log_uri);
        formatter.field("job_failure_log_uri", &self.job_failure_log_uri);
        formatter.finish()
    }
}
/// See [`JobLogs`](crate::model::JobLogs)
pub mod job_logs {
    /// A builder for [`JobLogs`](crate::model::JobLogs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_completion_report_uri: std::option::Option<std::string::String>,
        pub(crate) job_success_log_uri: std::option::Option<std::string::String>,
        pub(crate) job_failure_log_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A link to an Amazon S3 presigned URL where the job completion report is located.</p>
        pub fn job_completion_report_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_completion_report_uri = Some(input.into());
            self
        }
        /// <p>A link to an Amazon S3 presigned URL where the job completion report is located.</p>
        pub fn set_job_completion_report_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_completion_report_uri = input;
            self
        }
        /// <p>A link to an Amazon S3 presigned URL where the job success log is located.</p>
        pub fn job_success_log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_success_log_uri = Some(input.into());
            self
        }
        /// <p>A link to an Amazon S3 presigned URL where the job success log is located.</p>
        pub fn set_job_success_log_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_success_log_uri = input;
            self
        }
        /// <p>A link to an Amazon S3 presigned URL where the job failure log is located.</p>
        pub fn job_failure_log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_failure_log_uri = Some(input.into());
            self
        }
        /// <p>A link to an Amazon S3 presigned URL where the job failure log is located.</p>
        pub fn set_job_failure_log_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_failure_log_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`JobLogs`](crate::model::JobLogs)
        pub fn build(self) -> crate::model::JobLogs {
            crate::model::JobLogs {
                job_completion_report_uri: self.job_completion_report_uri,
                job_success_log_uri: self.job_success_log_uri,
                job_failure_log_uri: self.job_failure_log_uri,
            }
        }
    }
}
impl JobLogs {
    /// Creates a new builder-style object to manufacture [`JobLogs`](crate::model::JobLogs)
    pub fn builder() -> crate::model::job_logs::Builder {
        crate::model::job_logs::Builder::default()
    }
}

/// <p>Defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataTransfer {
    /// <p>The number of bytes transferred between a Snow device and Amazon S3.</p>
    pub bytes_transferred: i64,
    /// <p>The number of objects transferred between a Snow device and Amazon S3.</p>
    pub objects_transferred: i64,
    /// <p>The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
    pub total_bytes: i64,
    /// <p>The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
    pub total_objects: i64,
}
impl DataTransfer {
    /// <p>The number of bytes transferred between a Snow device and Amazon S3.</p>
    pub fn bytes_transferred(&self) -> i64 {
        self.bytes_transferred
    }
    /// <p>The number of objects transferred between a Snow device and Amazon S3.</p>
    pub fn objects_transferred(&self) -> i64 {
        self.objects_transferred
    }
    /// <p>The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
    pub fn total_bytes(&self) -> i64 {
        self.total_bytes
    }
    /// <p>The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
    pub fn total_objects(&self) -> i64 {
        self.total_objects
    }
}
impl std::fmt::Debug for DataTransfer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataTransfer");
        formatter.field("bytes_transferred", &self.bytes_transferred);
        formatter.field("objects_transferred", &self.objects_transferred);
        formatter.field("total_bytes", &self.total_bytes);
        formatter.field("total_objects", &self.total_objects);
        formatter.finish()
    }
}
/// See [`DataTransfer`](crate::model::DataTransfer)
pub mod data_transfer {
    /// A builder for [`DataTransfer`](crate::model::DataTransfer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bytes_transferred: std::option::Option<i64>,
        pub(crate) objects_transferred: std::option::Option<i64>,
        pub(crate) total_bytes: std::option::Option<i64>,
        pub(crate) total_objects: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of bytes transferred between a Snow device and Amazon S3.</p>
        pub fn bytes_transferred(mut self, input: i64) -> Self {
            self.bytes_transferred = Some(input);
            self
        }
        /// <p>The number of bytes transferred between a Snow device and Amazon S3.</p>
        pub fn set_bytes_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_transferred = input;
            self
        }
        /// <p>The number of objects transferred between a Snow device and Amazon S3.</p>
        pub fn objects_transferred(mut self, input: i64) -> Self {
            self.objects_transferred = Some(input);
            self
        }
        /// <p>The number of objects transferred between a Snow device and Amazon S3.</p>
        pub fn set_objects_transferred(mut self, input: std::option::Option<i64>) -> Self {
            self.objects_transferred = input;
            self
        }
        /// <p>The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
        pub fn total_bytes(mut self, input: i64) -> Self {
            self.total_bytes = Some(input);
            self
        }
        /// <p>The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
        pub fn set_total_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_bytes = input;
            self
        }
        /// <p>The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
        pub fn total_objects(mut self, input: i64) -> Self {
            self.total_objects = Some(input);
            self
        }
        /// <p>The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>
        pub fn set_total_objects(mut self, input: std::option::Option<i64>) -> Self {
            self.total_objects = input;
            self
        }
        /// Consumes the builder and constructs a [`DataTransfer`](crate::model::DataTransfer)
        pub fn build(self) -> crate::model::DataTransfer {
            crate::model::DataTransfer {
                bytes_transferred: self.bytes_transferred.unwrap_or_default(),
                objects_transferred: self.objects_transferred.unwrap_or_default(),
                total_bytes: self.total_bytes.unwrap_or_default(),
                total_objects: self.total_objects.unwrap_or_default(),
            }
        }
    }
}
impl DataTransfer {
    /// Creates a new builder-style object to manufacture [`DataTransfer`](crate::model::DataTransfer)
    pub fn builder() -> crate::model::data_transfer::Builder {
        crate::model::data_transfer::Builder::default()
    }
}

/// <p>A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShippingDetails {
    /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to Amazon Web Services for a particular job.</p>
    pub inbound_shipment: std::option::Option<crate::model::Shipment>,
    /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the address that you specified for a particular job.</p>
    pub outbound_shipment: std::option::Option<crate::model::Shipment>,
}
impl ShippingDetails {
    /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to Amazon Web Services for a particular job.</p>
    pub fn inbound_shipment(&self) -> std::option::Option<&crate::model::Shipment> {
        self.inbound_shipment.as_ref()
    }
    /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the address that you specified for a particular job.</p>
    pub fn outbound_shipment(&self) -> std::option::Option<&crate::model::Shipment> {
        self.outbound_shipment.as_ref()
    }
}
impl std::fmt::Debug for ShippingDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShippingDetails");
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("inbound_shipment", &self.inbound_shipment);
        formatter.field("outbound_shipment", &self.outbound_shipment);
        formatter.finish()
    }
}
/// See [`ShippingDetails`](crate::model::ShippingDetails)
pub mod shipping_details {
    /// A builder for [`ShippingDetails`](crate::model::ShippingDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) inbound_shipment: std::option::Option<crate::model::Shipment>,
        pub(crate) outbound_shipment: std::option::Option<crate::model::Shipment>,
    }
    impl Builder {
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to Amazon Web Services for a particular job.</p>
        pub fn inbound_shipment(mut self, input: crate::model::Shipment) -> Self {
            self.inbound_shipment = Some(input);
            self
        }
        /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being returned to Amazon Web Services for a particular job.</p>
        pub fn set_inbound_shipment(
            mut self,
            input: std::option::Option<crate::model::Shipment>,
        ) -> Self {
            self.inbound_shipment = input;
            self
        }
        /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the address that you specified for a particular job.</p>
        pub fn outbound_shipment(mut self, input: crate::model::Shipment) -> Self {
            self.outbound_shipment = Some(input);
            self
        }
        /// <p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snow device being delivered to the address that you specified for a particular job.</p>
        pub fn set_outbound_shipment(
            mut self,
            input: std::option::Option<crate::model::Shipment>,
        ) -> Self {
            self.outbound_shipment = input;
            self
        }
        /// Consumes the builder and constructs a [`ShippingDetails`](crate::model::ShippingDetails)
        pub fn build(self) -> crate::model::ShippingDetails {
            crate::model::ShippingDetails {
                shipping_option: self.shipping_option,
                inbound_shipment: self.inbound_shipment,
                outbound_shipment: self.outbound_shipment,
            }
        }
    }
}
impl ShippingDetails {
    /// Creates a new builder-style object to manufacture [`ShippingDetails`](crate::model::ShippingDetails)
    pub fn builder() -> crate::model::shipping_details::Builder {
        crate::model::shipping_details::Builder::default()
    }
}

/// <p>The <code>Status</code> and <code>TrackingNumber</code> information for an inbound or outbound shipment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Shipment {
    /// <p>Status information for a shipment.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The tracking number for this job. Using this tracking number with your region's carrier's website, you can track a Snow device as the carrier transports it.</p>
    /// <p>For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.</p>
    pub tracking_number: std::option::Option<std::string::String>,
}
impl Shipment {
    /// <p>Status information for a shipment.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The tracking number for this job. Using this tracking number with your region's carrier's website, you can track a Snow device as the carrier transports it.</p>
    /// <p>For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.</p>
    pub fn tracking_number(&self) -> std::option::Option<&str> {
        self.tracking_number.as_deref()
    }
}
impl std::fmt::Debug for Shipment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Shipment");
        formatter.field("status", &self.status);
        formatter.field("tracking_number", &self.tracking_number);
        formatter.finish()
    }
}
/// See [`Shipment`](crate::model::Shipment)
pub mod shipment {
    /// A builder for [`Shipment`](crate::model::Shipment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) tracking_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Status information for a shipment.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Status information for a shipment.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The tracking number for this job. Using this tracking number with your region's carrier's website, you can track a Snow device as the carrier transports it.</p>
        /// <p>For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.</p>
        pub fn tracking_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_number = Some(input.into());
            self
        }
        /// <p>The tracking number for this job. Using this tracking number with your region's carrier's website, you can track a Snow device as the carrier transports it.</p>
        /// <p>For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.</p>
        pub fn set_tracking_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracking_number = input;
            self
        }
        /// Consumes the builder and constructs a [`Shipment`](crate::model::Shipment)
        pub fn build(self) -> crate::model::Shipment {
            crate::model::Shipment {
                status: self.status,
                tracking_number: self.tracking_number,
            }
        }
    }
}
impl Shipment {
    /// Creates a new builder-style object to manufacture [`Shipment`](crate::model::Shipment)
    pub fn builder() -> crate::model::shipment::Builder {
        crate::model::shipment::Builder::default()
    }
}

/// <p>Contains metadata about a specific cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterMetadata {
    /// <p>The automatically generated ID for a cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The optional description of the cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The role ARN associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the cluster.</p>
    pub cluster_state: std::option::Option<crate::model::ClusterState>,
    /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>The type of Snowcone device to use for this cluster. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The creation date for this cluster.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>The automatically generated ID for a specific address.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub tax_documents: std::option::Option<crate::model::TaxDocuments>,
    /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
}
impl ClusterMetadata {
    /// <p>The automatically generated ID for a cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The optional description of the cluster.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The role ARN associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The current status of the cluster.</p>
    pub fn cluster_state(&self) -> std::option::Option<&crate::model::ClusterState> {
        self.cluster_state.as_ref()
    }
    /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>The type of Snowcone device to use for this cluster. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The creation date for this cluster.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>The automatically generated ID for a specific address.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub fn tax_documents(&self) -> std::option::Option<&crate::model::TaxDocuments> {
        self.tax_documents.as_ref()
    }
    /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
}
impl std::fmt::Debug for ClusterMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterMetadata");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("description", &self.description);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("cluster_state", &self.cluster_state);
        formatter.field("job_type", &self.job_type);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("resources", &self.resources);
        formatter.field("address_id", &self.address_id);
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("notification", &self.notification);
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.field("tax_documents", &self.tax_documents);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.finish()
    }
}
/// See [`ClusterMetadata`](crate::model::ClusterMetadata)
pub mod cluster_metadata {
    /// A builder for [`ClusterMetadata`](crate::model::ClusterMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_state: std::option::Option<crate::model::ClusterState>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
        pub(crate) tax_documents: std::option::Option<crate::model::TaxDocuments>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The optional description of the cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description of the cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The role ARN associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn cluster_state(mut self, input: crate::model::ClusterState) -> Self {
            self.cluster_state = Some(input);
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn set_cluster_state(
            mut self,
            input: std::option::Option<crate::model::ClusterState>,
        ) -> Self {
            self.cluster_state = input;
            self
        }
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The type of Snowcone device to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of Snowcone device to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// <p>The creation date for this cluster.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date for this cluster.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.tax_documents = Some(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.tax_documents = input;
            self
        }
        /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterMetadata`](crate::model::ClusterMetadata)
        pub fn build(self) -> crate::model::ClusterMetadata {
            crate::model::ClusterMetadata {
                cluster_id: self.cluster_id,
                description: self.description,
                kms_key_arn: self.kms_key_arn,
                role_arn: self.role_arn,
                cluster_state: self.cluster_state,
                job_type: self.job_type,
                snowball_type: self.snowball_type,
                creation_date: self.creation_date,
                resources: self.resources,
                address_id: self.address_id,
                shipping_option: self.shipping_option,
                notification: self.notification,
                forwarding_address_id: self.forwarding_address_id,
                tax_documents: self.tax_documents,
                on_device_service_configuration: self.on_device_service_configuration,
            }
        }
    }
}
impl ClusterMetadata {
    /// Creates a new builder-style object to manufacture [`ClusterMetadata`](crate::model::ClusterMetadata)
    pub fn builder() -> crate::model::cluster_metadata::Builder {
        crate::model::cluster_metadata::Builder::default()
    }
}

/// <p>The address that you want the Snow device(s) associated with a specific job to be shipped to. Addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. Although no individual elements of the <code>Address</code> are required, if the address is invalid or unsupported, then an exception is thrown.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Address {
    /// <p>The unique ID for an address.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The name of a person to receive a Snow device at an address.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the company to receive a Snow device at an address.</p>
    pub company: std::option::Option<std::string::String>,
    /// <p>The first line in a street address that a Snow device is to be delivered to.</p>
    pub street1: std::option::Option<std::string::String>,
    /// <p>The second line in a street address that a Snow device is to be delivered to.</p>
    pub street2: std::option::Option<std::string::String>,
    /// <p>The third line in a street address that a Snow device is to be delivered to.</p>
    pub street3: std::option::Option<std::string::String>,
    /// <p>The city in an address that a Snow device is to be delivered to.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The state or province in an address that a Snow device is to be delivered to.</p>
    pub state_or_province: std::option::Option<std::string::String>,
    /// <p>This field is no longer used and the value is ignored.</p>
    pub prefecture_or_district: std::option::Option<std::string::String>,
    /// <p>This field is no longer used and the value is ignored.</p>
    pub landmark: std::option::Option<std::string::String>,
    /// <p>The country in an address that a Snow device is to be delivered to.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The postal code in an address that a Snow device is to be delivered to.</p>
    pub postal_code: std::option::Option<std::string::String>,
    /// <p>The phone number associated with an address that a Snow device is to be delivered to.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.</p>
    pub is_restricted: bool,
}
impl Address {
    /// <p>The unique ID for an address.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The name of a person to receive a Snow device at an address.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the company to receive a Snow device at an address.</p>
    pub fn company(&self) -> std::option::Option<&str> {
        self.company.as_deref()
    }
    /// <p>The first line in a street address that a Snow device is to be delivered to.</p>
    pub fn street1(&self) -> std::option::Option<&str> {
        self.street1.as_deref()
    }
    /// <p>The second line in a street address that a Snow device is to be delivered to.</p>
    pub fn street2(&self) -> std::option::Option<&str> {
        self.street2.as_deref()
    }
    /// <p>The third line in a street address that a Snow device is to be delivered to.</p>
    pub fn street3(&self) -> std::option::Option<&str> {
        self.street3.as_deref()
    }
    /// <p>The city in an address that a Snow device is to be delivered to.</p>
    pub fn city(&self) -> std::option::Option<&str> {
        self.city.as_deref()
    }
    /// <p>The state or province in an address that a Snow device is to be delivered to.</p>
    pub fn state_or_province(&self) -> std::option::Option<&str> {
        self.state_or_province.as_deref()
    }
    /// <p>This field is no longer used and the value is ignored.</p>
    pub fn prefecture_or_district(&self) -> std::option::Option<&str> {
        self.prefecture_or_district.as_deref()
    }
    /// <p>This field is no longer used and the value is ignored.</p>
    pub fn landmark(&self) -> std::option::Option<&str> {
        self.landmark.as_deref()
    }
    /// <p>The country in an address that a Snow device is to be delivered to.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The postal code in an address that a Snow device is to be delivered to.</p>
    pub fn postal_code(&self) -> std::option::Option<&str> {
        self.postal_code.as_deref()
    }
    /// <p>The phone number associated with an address that a Snow device is to be delivered to.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.</p>
    pub fn is_restricted(&self) -> bool {
        self.is_restricted
    }
}
impl std::fmt::Debug for Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Address");
        formatter.field("address_id", &self.address_id);
        formatter.field("name", &self.name);
        formatter.field("company", &self.company);
        formatter.field("street1", &self.street1);
        formatter.field("street2", &self.street2);
        formatter.field("street3", &self.street3);
        formatter.field("city", &self.city);
        formatter.field("state_or_province", &self.state_or_province);
        formatter.field("prefecture_or_district", &self.prefecture_or_district);
        formatter.field("landmark", &self.landmark);
        formatter.field("country", &self.country);
        formatter.field("postal_code", &self.postal_code);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("is_restricted", &self.is_restricted);
        formatter.finish()
    }
}
/// See [`Address`](crate::model::Address)
pub mod address {
    /// A builder for [`Address`](crate::model::Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) company: std::option::Option<std::string::String>,
        pub(crate) street1: std::option::Option<std::string::String>,
        pub(crate) street2: std::option::Option<std::string::String>,
        pub(crate) street3: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) state_or_province: std::option::Option<std::string::String>,
        pub(crate) prefecture_or_district: std::option::Option<std::string::String>,
        pub(crate) landmark: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) is_restricted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique ID for an address.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The unique ID for an address.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The name of a person to receive a Snow device at an address.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a person to receive a Snow device at an address.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the company to receive a Snow device at an address.</p>
        pub fn company(mut self, input: impl Into<std::string::String>) -> Self {
            self.company = Some(input.into());
            self
        }
        /// <p>The name of the company to receive a Snow device at an address.</p>
        pub fn set_company(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.company = input;
            self
        }
        /// <p>The first line in a street address that a Snow device is to be delivered to.</p>
        pub fn street1(mut self, input: impl Into<std::string::String>) -> Self {
            self.street1 = Some(input.into());
            self
        }
        /// <p>The first line in a street address that a Snow device is to be delivered to.</p>
        pub fn set_street1(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.street1 = input;
            self
        }
        /// <p>The second line in a street address that a Snow device is to be delivered to.</p>
        pub fn street2(mut self, input: impl Into<std::string::String>) -> Self {
            self.street2 = Some(input.into());
            self
        }
        /// <p>The second line in a street address that a Snow device is to be delivered to.</p>
        pub fn set_street2(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.street2 = input;
            self
        }
        /// <p>The third line in a street address that a Snow device is to be delivered to.</p>
        pub fn street3(mut self, input: impl Into<std::string::String>) -> Self {
            self.street3 = Some(input.into());
            self
        }
        /// <p>The third line in a street address that a Snow device is to be delivered to.</p>
        pub fn set_street3(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.street3 = input;
            self
        }
        /// <p>The city in an address that a Snow device is to be delivered to.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The city in an address that a Snow device is to be delivered to.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The state or province in an address that a Snow device is to be delivered to.</p>
        pub fn state_or_province(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_or_province = Some(input.into());
            self
        }
        /// <p>The state or province in an address that a Snow device is to be delivered to.</p>
        pub fn set_state_or_province(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_or_province = input;
            self
        }
        /// <p>This field is no longer used and the value is ignored.</p>
        pub fn prefecture_or_district(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefecture_or_district = Some(input.into());
            self
        }
        /// <p>This field is no longer used and the value is ignored.</p>
        pub fn set_prefecture_or_district(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefecture_or_district = input;
            self
        }
        /// <p>This field is no longer used and the value is ignored.</p>
        pub fn landmark(mut self, input: impl Into<std::string::String>) -> Self {
            self.landmark = Some(input.into());
            self
        }
        /// <p>This field is no longer used and the value is ignored.</p>
        pub fn set_landmark(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.landmark = input;
            self
        }
        /// <p>The country in an address that a Snow device is to be delivered to.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The country in an address that a Snow device is to be delivered to.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The postal code in an address that a Snow device is to be delivered to.</p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>The postal code in an address that a Snow device is to be delivered to.</p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// <p>The phone number associated with an address that a Snow device is to be delivered to.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number associated with an address that a Snow device is to be delivered to.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.</p>
        pub fn is_restricted(mut self, input: bool) -> Self {
            self.is_restricted = Some(input);
            self
        }
        /// <p>If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.</p>
        pub fn set_is_restricted(mut self, input: std::option::Option<bool>) -> Self {
            self.is_restricted = input;
            self
        }
        /// Consumes the builder and constructs a [`Address`](crate::model::Address)
        pub fn build(self) -> crate::model::Address {
            crate::model::Address {
                address_id: self.address_id,
                name: self.name,
                company: self.company,
                street1: self.street1,
                street2: self.street2,
                street3: self.street3,
                city: self.city,
                state_or_province: self.state_or_province,
                prefecture_or_district: self.prefecture_or_district,
                landmark: self.landmark,
                country: self.country,
                postal_code: self.postal_code,
                phone_number: self.phone_number,
                is_restricted: self.is_restricted.unwrap_or_default(),
            }
        }
    }
}
impl Address {
    /// Creates a new builder-style object to manufacture [`Address`](crate::model::Address)
    pub fn builder() -> crate::model::address::Builder {
        crate::model::address::Builder::default()
    }
}
