// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The user has the required permissions, so the request would have succeeded, but a dry run was performed.</p>
    DryRunOperationException(crate::error::DryRunOperationException),
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>There are no connectors available.</p>
    NoConnectorsAvailableException(crate::error::NoConnectorsAvailableException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified replication job already exists.</p>
    ReplicationJobAlreadyExistsException(crate::error::ReplicationJobAlreadyExistsException),
    /// <p>The specified replication job does not exist.</p>
    ReplicationJobNotFoundException(crate::error::ReplicationJobNotFoundException),
    /// <p>You have exceeded the number of on-demand replication runs you can request in a 24-hour period.</p>
    ReplicationRunLimitExceededException(crate::error::ReplicationRunLimitExceededException),
    /// <p>The specified server cannot be replicated.</p>
    ServerCannotBeReplicatedException(crate::error::ServerCannotBeReplicatedException),
    /// <p>The service is temporarily unavailable.</p>
    TemporarilyUnavailableException(crate::error::TemporarilyUnavailableException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies, and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::DryRunOperationException(inner) => inner.fmt(f),
            Error::InternalError(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::MissingRequiredParameterException(inner) => inner.fmt(f),
            Error::NoConnectorsAvailableException(inner) => inner.fmt(f),
            Error::OperationNotPermittedException(inner) => inner.fmt(f),
            Error::ReplicationJobAlreadyExistsException(inner) => inner.fmt(f),
            Error::ReplicationJobNotFoundException(inner) => inner.fmt(f),
            Error::ReplicationRunLimitExceededException(inner) => inner.fmt(f),
            Error::ServerCannotBeReplicatedException(inner) => inner.fmt(f),
            Error::TemporarilyUnavailableException(inner) => inner.fmt(f),
            Error::UnauthorizedOperationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAppErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::CreateAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::CreateAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::CreateAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::CreateAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReplicationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReplicationJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateReplicationJobErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::CreateReplicationJobErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateReplicationJobErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::CreateReplicationJobErrorKind::NoConnectorsAvailableException(inner) => Error::NoConnectorsAvailableException(inner),
                crate::error::CreateReplicationJobErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException(inner) => Error::ReplicationJobAlreadyExistsException(inner),
                crate::error::CreateReplicationJobErrorKind::ServerCannotBeReplicatedException(inner) => Error::ServerCannotBeReplicatedException(inner),
                crate::error::CreateReplicationJobErrorKind::TemporarilyUnavailableException(inner) => Error::TemporarilyUnavailableException(inner),
                crate::error::CreateReplicationJobErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::CreateReplicationJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAppErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::DeleteAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::DeleteAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::DeleteAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::DeleteAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAppLaunchConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAppLaunchConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAppLaunchConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::DeleteAppLaunchConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteAppLaunchConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteAppReplicationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteAppReplicationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAppReplicationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::DeleteAppReplicationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteAppReplicationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteAppValidationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteAppValidationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAppValidationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::DeleteAppValidationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteAppValidationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReplicationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReplicationJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteReplicationJobErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteReplicationJobErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::DeleteReplicationJobErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteReplicationJobErrorKind::ReplicationJobNotFoundException(
                    inner,
                ) => Error::ReplicationJobNotFoundException(inner),
                crate::error::DeleteReplicationJobErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteReplicationJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteServerCatalogError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteServerCatalogError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteServerCatalogErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteServerCatalogErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::DeleteServerCatalogErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::DeleteServerCatalogErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::DeleteServerCatalogErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateConnectorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateConnectorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateConnectorErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DisassociateConnectorErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::DisassociateConnectorErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::DisassociateConnectorErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::DisassociateConnectorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GenerateChangeSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GenerateChangeSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GenerateChangeSetErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::GenerateChangeSetErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GenerateChangeSetErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::GenerateChangeSetErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::GenerateChangeSetErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GenerateChangeSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GenerateTemplateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GenerateTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GenerateTemplateErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::GenerateTemplateErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GenerateTemplateErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::GenerateTemplateErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::GenerateTemplateErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GenerateTemplateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAppErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::GetAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::GetAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::GetAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAppLaunchConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAppLaunchConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAppLaunchConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::GetAppLaunchConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::GetAppLaunchConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::GetAppLaunchConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetAppReplicationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetAppReplicationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAppReplicationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::GetAppReplicationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::GetAppReplicationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::GetAppReplicationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAppValidationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAppValidationConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAppValidationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::GetAppValidationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetAppValidationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::GetAppValidationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::GetAppValidationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::GetAppValidationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAppValidationOutputError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAppValidationOutputError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAppValidationOutputErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::GetAppValidationOutputErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetAppValidationOutputErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::GetAppValidationOutputErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::GetAppValidationOutputErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::GetAppValidationOutputErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetConnectorsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetConnectorsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetConnectorsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetConnectorsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetReplicationJobsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetReplicationJobsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetReplicationJobsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetReplicationJobsErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::GetReplicationJobsErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::GetReplicationJobsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetReplicationRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetReplicationRunsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetReplicationRunsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetReplicationRunsErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::GetReplicationRunsErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::GetReplicationRunsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetServersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetServersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetServersErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::GetServersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetServersErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::GetServersErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::GetServersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportAppCatalogError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportAppCatalogError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportAppCatalogErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::ImportAppCatalogErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ImportAppCatalogErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::ImportAppCatalogErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::ImportAppCatalogErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::ImportAppCatalogErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportServerCatalogError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportServerCatalogError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportServerCatalogErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ImportServerCatalogErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::ImportServerCatalogErrorKind::NoConnectorsAvailableException(
                    inner,
                ) => Error::NoConnectorsAvailableException(inner),
                crate::error::ImportServerCatalogErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::ImportServerCatalogErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::ImportServerCatalogErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::LaunchAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::LaunchAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::LaunchAppErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::LaunchAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::LaunchAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::LaunchAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::LaunchAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::LaunchAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAppsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListAppsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAppsErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::ListAppsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListAppsErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::ListAppsErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::ListAppsErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::ListAppsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::NotifyAppValidationOutputError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::NotifyAppValidationOutputError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::NotifyAppValidationOutputErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::NotifyAppValidationOutputErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::NotifyAppValidationOutputErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::NotifyAppValidationOutputErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::NotifyAppValidationOutputErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::NotifyAppValidationOutputErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAppLaunchConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAppLaunchConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutAppLaunchConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::PutAppLaunchConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::PutAppLaunchConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::PutAppLaunchConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::PutAppReplicationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutAppReplicationConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutAppReplicationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::PutAppReplicationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::PutAppReplicationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::PutAppReplicationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAppValidationConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAppValidationConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutAppValidationConfigurationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::PutAppValidationConfigurationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PutAppValidationConfigurationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::PutAppValidationConfigurationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::PutAppValidationConfigurationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::PutAppValidationConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAppReplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAppReplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartAppReplicationErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::StartAppReplicationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartAppReplicationErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::StartAppReplicationErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::StartAppReplicationErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::StartAppReplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartOnDemandAppReplicationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartOnDemandAppReplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartOnDemandAppReplicationErrorKind::InternalError(inner) => Error::InternalError(inner),
                crate::error::StartOnDemandAppReplicationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::StartOnDemandAppReplicationErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::StartOnDemandAppReplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartOnDemandReplicationRunError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartOnDemandReplicationRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartOnDemandReplicationRunErrorKind::DryRunOperationException(inner) => Error::DryRunOperationException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException(inner) => Error::MissingRequiredParameterException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::OperationNotPermittedException(inner) => Error::OperationNotPermittedException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException(inner) => Error::ReplicationRunLimitExceededException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException(inner) => Error::UnauthorizedOperationException(inner),
                crate::error::StartOnDemandReplicationRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopAppReplicationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopAppReplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopAppReplicationErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::StopAppReplicationErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StopAppReplicationErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::StopAppReplicationErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::StopAppReplicationErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::StopAppReplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TerminateAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TerminateAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TerminateAppErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::TerminateAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TerminateAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::TerminateAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::TerminateAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::TerminateAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAppError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateAppError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAppErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::UpdateAppErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateAppErrorKind::MissingRequiredParameterException(inner) => {
                    Error::MissingRequiredParameterException(inner)
                }
                crate::error::UpdateAppErrorKind::OperationNotPermittedException(inner) => {
                    Error::OperationNotPermittedException(inner)
                }
                crate::error::UpdateAppErrorKind::UnauthorizedOperationException(inner) => {
                    Error::UnauthorizedOperationException(inner)
                }
                crate::error::UpdateAppErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateReplicationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateReplicationJobError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateReplicationJobErrorKind::InternalError(inner) => {
                    Error::InternalError(inner)
                }
                crate::error::UpdateReplicationJobErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateReplicationJobErrorKind::MissingRequiredParameterException(
                    inner,
                ) => Error::MissingRequiredParameterException(inner),
                crate::error::UpdateReplicationJobErrorKind::OperationNotPermittedException(
                    inner,
                ) => Error::OperationNotPermittedException(inner),
                crate::error::UpdateReplicationJobErrorKind::ReplicationJobNotFoundException(
                    inner,
                ) => Error::ReplicationJobNotFoundException(inner),
                crate::error::UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException(
                    inner,
                ) => Error::ServerCannotBeReplicatedException(inner),
                crate::error::UpdateReplicationJobErrorKind::TemporarilyUnavailableException(
                    inner,
                ) => Error::TemporarilyUnavailableException(inner),
                crate::error::UpdateReplicationJobErrorKind::UnauthorizedOperationException(
                    inner,
                ) => Error::UnauthorizedOperationException(inner),
                crate::error::UpdateReplicationJobErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
