// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the new application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the new application</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the new application</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the service role in the customer's account to be used by Server Migration Service.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service role in the customer's account to be used by Server Migration Service.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `server_groups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups to include in the application.</p>
        pub fn server_groups(mut self, input: crate::model::ServerGroup) -> Self {
            let mut v = self.server_groups.unwrap_or_default();
            v.push(input);
            self.server_groups = Some(v);
            self
        }
        /// <p>The server groups to include in the application.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.server_groups = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the application.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                name: self.name,
                description: self.description,
                role_name: self.role_name,
                client_token: self.client_token,
                server_groups: self.server_groups,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.CreateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "sms",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateReplicationJobInput`](crate::input::CreateReplicationJobInput)
pub mod create_replication_job_input {
    /// A builder for [`CreateReplicationJobInput`](crate::input::CreateReplicationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) seed_replication_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) frequency: std::option::Option<i32>,
        pub(crate) run_once: std::option::Option<bool>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) number_of_recent_amis_to_keep: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The seed replication time.</p>
        pub fn seed_replication_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.seed_replication_time = Some(input);
            self
        }
        /// <p>The seed replication time.</p>
        pub fn set_seed_replication_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.seed_replication_time = input;
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn frequency(mut self, input: i32) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn run_once(mut self, input: bool) -> Self {
            self.run_once = Some(input);
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn set_run_once(mut self, input: std::option::Option<bool>) -> Self {
            self.run_once = input;
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication run.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication run.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The name of the IAM role to be used by the Server Migration Service.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to be used by the Server Migration Service.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
        pub fn number_of_recent_amis_to_keep(mut self, input: i32) -> Self {
            self.number_of_recent_amis_to_keep = Some(input);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_recent_amis_to_keep = input;
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
        /// <ul>
        /// <li> <p>KMS key ID</p> </li>
        /// <li> <p>KMS key alias</p> </li>
        /// <li> <p>ARN referring to the KMS key ID</p> </li>
        /// <li> <p>ARN referring to the KMS key alias</p> </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
        /// <ul>
        /// <li> <p>KMS key ID</p> </li>
        /// <li> <p>KMS key alias</p> </li>
        /// <li> <p>ARN referring to the KMS key ID</p> </li>
        /// <li> <p>ARN referring to the KMS key alias</p> </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationJobInput`](crate::input::CreateReplicationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationJobInput {
                server_id: self.server_id,
                seed_replication_time: self.seed_replication_time,
                frequency: self.frequency,
                run_once: self.run_once,
                license_type: self.license_type,
                role_name: self.role_name,
                description: self.description,
                number_of_recent_amis_to_keep: self.number_of_recent_amis_to_keep,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationJobInputOperationOutputAlias = crate::operation::CreateReplicationJob;
#[doc(hidden)]
pub type CreateReplicationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateReplicationJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationJob`](crate::operation::CreateReplicationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.CreateReplicationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationJob",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationJobInput`](crate::input::CreateReplicationJobInput)
    pub fn builder() -> crate::input::create_replication_job_input::Builder {
        crate::input::create_replication_job_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) force_stop_app_replication: std::option::Option<bool>,
        pub(crate) force_terminate_app: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application.</p>
        pub fn force_stop_app_replication(mut self, input: bool) -> Self {
            self.force_stop_app_replication = Some(input);
            self
        }
        /// <p>Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application.</p>
        pub fn set_force_stop_app_replication(mut self, input: std::option::Option<bool>) -> Self {
            self.force_stop_app_replication = input;
            self
        }
        /// <p>Indicates whether to terminate the stack corresponding to the application while deleting the application.</p>
        pub fn force_terminate_app(mut self, input: bool) -> Self {
            self.force_terminate_app = Some(input);
            self
        }
        /// <p>Indicates whether to terminate the stack corresponding to the application while deleting the application.</p>
        pub fn set_force_terminate_app(mut self, input: std::option::Option<bool>) -> Self {
            self.force_terminate_app = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                app_id: self.app_id,
                force_stop_app_replication: self.force_stop_app_replication,
                force_terminate_app: self.force_terminate_app,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "sms",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteAppLaunchConfigurationInput`](crate::input::DeleteAppLaunchConfigurationInput)
pub mod delete_app_launch_configuration_input {
    /// A builder for [`DeleteAppLaunchConfigurationInput`](crate::input::DeleteAppLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppLaunchConfigurationInput`](crate::input::DeleteAppLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppLaunchConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppLaunchConfigurationInputOperationOutputAlias =
    crate::operation::DeleteAppLaunchConfiguration;
#[doc(hidden)]
pub type DeleteAppLaunchConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppLaunchConfiguration`](crate::operation::DeleteAppLaunchConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppLaunchConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppLaunchConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppLaunchConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteAppLaunchConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_app_launch_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppLaunchConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppLaunchConfigurationInput`](crate::input::DeleteAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::delete_app_launch_configuration_input::Builder {
        crate::input::delete_app_launch_configuration_input::Builder::default()
    }
}

/// See [`DeleteAppReplicationConfigurationInput`](crate::input::DeleteAppReplicationConfigurationInput)
pub mod delete_app_replication_configuration_input {
    /// A builder for [`DeleteAppReplicationConfigurationInput`](crate::input::DeleteAppReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppReplicationConfigurationInput`](crate::input::DeleteAppReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppReplicationConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppReplicationConfigurationInputOperationOutputAlias =
    crate::operation::DeleteAppReplicationConfiguration;
#[doc(hidden)]
pub type DeleteAppReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppReplicationConfiguration`](crate::operation::DeleteAppReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteAppReplicationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_app_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppReplicationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppReplicationConfigurationInput`](crate::input::DeleteAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::delete_app_replication_configuration_input::Builder {
        crate::input::delete_app_replication_configuration_input::Builder::default()
    }
}

/// See [`DeleteAppValidationConfigurationInput`](crate::input::DeleteAppValidationConfigurationInput)
pub mod delete_app_validation_configuration_input {
    /// A builder for [`DeleteAppValidationConfigurationInput`](crate::input::DeleteAppValidationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppValidationConfigurationInput`](crate::input::DeleteAppValidationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppValidationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppValidationConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppValidationConfigurationInputOperationOutputAlias =
    crate::operation::DeleteAppValidationConfiguration;
#[doc(hidden)]
pub type DeleteAppValidationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppValidationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppValidationConfiguration`](crate::operation::DeleteAppValidationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppValidationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppValidationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppValidationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppValidationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteAppValidationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_app_validation_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppValidationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppValidationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppValidationConfigurationInput`](crate::input::DeleteAppValidationConfigurationInput)
    pub fn builder() -> crate::input::delete_app_validation_configuration_input::Builder {
        crate::input::delete_app_validation_configuration_input::Builder::default()
    }
}

/// See [`DeleteReplicationJobInput`](crate::input::DeleteReplicationJobInput)
pub mod delete_replication_job_input {
    /// A builder for [`DeleteReplicationJobInput`](crate::input::DeleteReplicationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationJobInput`](crate::input::DeleteReplicationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationJobInput {
                replication_job_id: self.replication_job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationJobInputOperationOutputAlias = crate::operation::DeleteReplicationJob;
#[doc(hidden)]
pub type DeleteReplicationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteReplicationJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationJob`](crate::operation::DeleteReplicationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteReplicationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationJob",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationJobInput`](crate::input::DeleteReplicationJobInput)
    pub fn builder() -> crate::input::delete_replication_job_input::Builder {
        crate::input::delete_replication_job_input::Builder::default()
    }
}

/// See [`DeleteServerCatalogInput`](crate::input::DeleteServerCatalogInput)
pub mod delete_server_catalog_input {
    /// A builder for [`DeleteServerCatalogInput`](crate::input::DeleteServerCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServerCatalogInput`](crate::input::DeleteServerCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServerCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServerCatalogInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteServerCatalogInputOperationOutputAlias = crate::operation::DeleteServerCatalog;
#[doc(hidden)]
pub type DeleteServerCatalogInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteServerCatalogInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServerCatalog`](crate::operation::DeleteServerCatalog)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServerCatalog,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServerCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServerCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServerCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DeleteServerCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_server_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServerCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServerCatalog",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServerCatalogInput`](crate::input::DeleteServerCatalogInput)
    pub fn builder() -> crate::input::delete_server_catalog_input::Builder {
        crate::input::delete_server_catalog_input::Builder::default()
    }
}

/// See [`DisassociateConnectorInput`](crate::input::DisassociateConnectorInput)
pub mod disassociate_connector_input {
    /// A builder for [`DisassociateConnectorInput`](crate::input::DisassociateConnectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the connector.</p>
        pub fn connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_id = Some(input.into());
            self
        }
        /// <p>The ID of the connector.</p>
        pub fn set_connector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.connector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateConnectorInput`](crate::input::DisassociateConnectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateConnectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateConnectorInput {
                connector_id: self.connector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateConnectorInputOperationOutputAlias = crate::operation::DisassociateConnector;
#[doc(hidden)]
pub type DisassociateConnectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateConnectorInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateConnector`](crate::operation::DisassociateConnector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateConnector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateConnectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateConnectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateConnectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.DisassociateConnector",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_connector(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateConnector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateConnector",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateConnectorInput`](crate::input::DisassociateConnectorInput)
    pub fn builder() -> crate::input::disassociate_connector_input::Builder {
        crate::input::disassociate_connector_input::Builder::default()
    }
}

/// See [`GenerateChangeSetInput`](crate::input::GenerateChangeSetInput)
pub mod generate_change_set_input {
    /// A builder for [`GenerateChangeSetInput`](crate::input::GenerateChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) changeset_format: std::option::Option<crate::model::OutputFormat>,
    }
    impl Builder {
        /// <p>The ID of the application associated with the change set.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application associated with the change set.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The format for the change set.</p>
        pub fn changeset_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.changeset_format = Some(input);
            self
        }
        /// <p>The format for the change set.</p>
        pub fn set_changeset_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.changeset_format = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateChangeSetInput`](crate::input::GenerateChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateChangeSetInput {
                app_id: self.app_id,
                changeset_format: self.changeset_format,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateChangeSetInputOperationOutputAlias = crate::operation::GenerateChangeSet;
#[doc(hidden)]
pub type GenerateChangeSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GenerateChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`GenerateChangeSet`](crate::operation::GenerateChangeSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateChangeSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GenerateChangeSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateChangeSet",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateChangeSetInput`](crate::input::GenerateChangeSetInput)
    pub fn builder() -> crate::input::generate_change_set_input::Builder {
        crate::input::generate_change_set_input::Builder::default()
    }
}

/// See [`GenerateTemplateInput`](crate::input::GenerateTemplateInput)
pub mod generate_template_input {
    /// A builder for [`GenerateTemplateInput`](crate::input::GenerateTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) template_format: std::option::Option<crate::model::OutputFormat>,
    }
    impl Builder {
        /// <p>The ID of the application associated with the CloudFormation template.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application associated with the CloudFormation template.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The format for generating the CloudFormation template.</p>
        pub fn template_format(mut self, input: crate::model::OutputFormat) -> Self {
            self.template_format = Some(input);
            self
        }
        /// <p>The format for generating the CloudFormation template.</p>
        pub fn set_template_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.template_format = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateTemplateInput`](crate::input::GenerateTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateTemplateInput {
                app_id: self.app_id,
                template_format: self.template_format,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateTemplateInputOperationOutputAlias = crate::operation::GenerateTemplate;
#[doc(hidden)]
pub type GenerateTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GenerateTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GenerateTemplate`](crate::operation::GenerateTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GenerateTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateTemplate",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateTemplateInput`](crate::input::GenerateTemplateInput)
    pub fn builder() -> crate::input::generate_template_input::Builder {
        crate::input::generate_template_input::Builder::default()
    }
}

/// See [`GetAppInput`](crate::input::GetAppInput)
pub mod get_app_input {
    /// A builder for [`GetAppInput`](crate::input::GetAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppInput`](crate::input::GetAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppInputOperationOutputAlias = crate::operation::GetApp;
#[doc(hidden)]
pub type GetAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppInput {
    /// Consumes the builder and constructs an Operation<[`GetApp`](crate::operation::GetApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetApp", "sms"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
}

/// See [`GetAppLaunchConfigurationInput`](crate::input::GetAppLaunchConfigurationInput)
pub mod get_app_launch_configuration_input {
    /// A builder for [`GetAppLaunchConfigurationInput`](crate::input::GetAppLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppLaunchConfigurationInput`](crate::input::GetAppLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppLaunchConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppLaunchConfigurationInputOperationOutputAlias =
    crate::operation::GetAppLaunchConfiguration;
#[doc(hidden)]
pub type GetAppLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetAppLaunchConfiguration`](crate::operation::GetAppLaunchConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppLaunchConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppLaunchConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppLaunchConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetAppLaunchConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_app_launch_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppLaunchConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppLaunchConfigurationInput`](crate::input::GetAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::get_app_launch_configuration_input::Builder {
        crate::input::get_app_launch_configuration_input::Builder::default()
    }
}

/// See [`GetAppReplicationConfigurationInput`](crate::input::GetAppReplicationConfigurationInput)
pub mod get_app_replication_configuration_input {
    /// A builder for [`GetAppReplicationConfigurationInput`](crate::input::GetAppReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppReplicationConfigurationInput`](crate::input::GetAppReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppReplicationConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppReplicationConfigurationInputOperationOutputAlias =
    crate::operation::GetAppReplicationConfiguration;
#[doc(hidden)]
pub type GetAppReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAppReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetAppReplicationConfiguration`](crate::operation::GetAppReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetAppReplicationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_app_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppReplicationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppReplicationConfigurationInput`](crate::input::GetAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_app_replication_configuration_input::Builder {
        crate::input::get_app_replication_configuration_input::Builder::default()
    }
}

/// See [`GetAppValidationConfigurationInput`](crate::input::GetAppValidationConfigurationInput)
pub mod get_app_validation_configuration_input {
    /// A builder for [`GetAppValidationConfigurationInput`](crate::input::GetAppValidationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppValidationConfigurationInput`](crate::input::GetAppValidationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppValidationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppValidationConfigurationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppValidationConfigurationInputOperationOutputAlias =
    crate::operation::GetAppValidationConfiguration;
#[doc(hidden)]
pub type GetAppValidationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAppValidationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetAppValidationConfiguration`](crate::operation::GetAppValidationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppValidationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppValidationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppValidationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppValidationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetAppValidationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_app_validation_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppValidationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppValidationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppValidationConfigurationInput`](crate::input::GetAppValidationConfigurationInput)
    pub fn builder() -> crate::input::get_app_validation_configuration_input::Builder {
        crate::input::get_app_validation_configuration_input::Builder::default()
    }
}

/// See [`GetAppValidationOutputInput`](crate::input::GetAppValidationOutputInput)
pub mod get_app_validation_output_input {
    /// A builder for [`GetAppValidationOutputInput`](crate::input::GetAppValidationOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppValidationOutputInput`](crate::input::GetAppValidationOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAppValidationOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAppValidationOutputInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAppValidationOutputInputOperationOutputAlias = crate::operation::GetAppValidationOutput;
#[doc(hidden)]
pub type GetAppValidationOutputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAppValidationOutputInput {
    /// Consumes the builder and constructs an Operation<[`GetAppValidationOutput`](crate::operation::GetAppValidationOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAppValidationOutput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAppValidationOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAppValidationOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAppValidationOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetAppValidationOutput",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_app_validation_output(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAppValidationOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAppValidationOutput",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAppValidationOutputInput`](crate::input::GetAppValidationOutputInput)
    pub fn builder() -> crate::input::get_app_validation_output_input::Builder {
        crate::input::get_app_validation_output_input::Builder::default()
    }
}

/// See [`GetConnectorsInput`](crate::input::GetConnectorsInput)
pub mod get_connectors_input {
    /// A builder for [`GetConnectorsInput`](crate::input::GetConnectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectorsInput`](crate::input::GetConnectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectorsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectorsInputOperationOutputAlias = crate::operation::GetConnectors;
#[doc(hidden)]
pub type GetConnectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetConnectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetConnectors`](crate::operation::GetConnectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetConnectors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_connectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnectors",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectorsInput`](crate::input::GetConnectorsInput)
    pub fn builder() -> crate::input::get_connectors_input::Builder {
        crate::input::get_connectors_input::Builder::default()
    }
}

/// See [`GetReplicationJobsInput`](crate::input::GetReplicationJobsInput)
pub mod get_replication_jobs_input {
    /// A builder for [`GetReplicationJobsInput`](crate::input::GetReplicationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationJobsInput`](crate::input::GetReplicationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReplicationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReplicationJobsInput {
                replication_job_id: self.replication_job_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReplicationJobsInputOperationOutputAlias = crate::operation::GetReplicationJobs;
#[doc(hidden)]
pub type GetReplicationJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReplicationJobsInput {
    /// Consumes the builder and constructs an Operation<[`GetReplicationJobs`](crate::operation::GetReplicationJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReplicationJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReplicationJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReplicationJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReplicationJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetReplicationJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_replication_jobs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReplicationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReplicationJobs",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReplicationJobsInput`](crate::input::GetReplicationJobsInput)
    pub fn builder() -> crate::input::get_replication_jobs_input::Builder {
        crate::input::get_replication_jobs_input::Builder::default()
    }
}

/// See [`GetReplicationRunsInput`](crate::input::GetReplicationRunsInput)
pub mod get_replication_runs_input {
    /// A builder for [`GetReplicationRunsInput`](crate::input::GetReplicationRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationRunsInput`](crate::input::GetReplicationRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReplicationRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReplicationRunsInput {
                replication_job_id: self.replication_job_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReplicationRunsInputOperationOutputAlias = crate::operation::GetReplicationRuns;
#[doc(hidden)]
pub type GetReplicationRunsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReplicationRunsInput {
    /// Consumes the builder and constructs an Operation<[`GetReplicationRuns`](crate::operation::GetReplicationRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReplicationRuns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReplicationRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReplicationRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReplicationRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetReplicationRuns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_replication_runs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReplicationRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReplicationRuns",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReplicationRunsInput`](crate::input::GetReplicationRunsInput)
    pub fn builder() -> crate::input::get_replication_runs_input::Builder {
        crate::input::get_replication_runs_input::Builder::default()
    }
}

/// See [`GetServersInput`](crate::input::GetServersInput)
pub mod get_servers_input {
    /// A builder for [`GetServersInput`](crate::input::GetServersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) vm_server_address_list:
            std::option::Option<std::vec::Vec<crate::model::VmServerAddress>>,
    }
    impl Builder {
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `vm_server_address_list`.
        ///
        /// To override the contents of this collection use [`set_vm_server_address_list`](Self::set_vm_server_address_list).
        ///
        /// <p>The server addresses.</p>
        pub fn vm_server_address_list(mut self, input: crate::model::VmServerAddress) -> Self {
            let mut v = self.vm_server_address_list.unwrap_or_default();
            v.push(input);
            self.vm_server_address_list = Some(v);
            self
        }
        /// <p>The server addresses.</p>
        pub fn set_vm_server_address_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VmServerAddress>>,
        ) -> Self {
            self.vm_server_address_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServersInput`](crate::input::GetServersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServersInput {
                next_token: self.next_token,
                max_results: self.max_results,
                vm_server_address_list: self.vm_server_address_list,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServersInputOperationOutputAlias = crate::operation::GetServers;
#[doc(hidden)]
pub type GetServersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetServersInput {
    /// Consumes the builder and constructs an Operation<[`GetServers`](crate::operation::GetServers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.GetServers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_servers(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServers",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServersInput`](crate::input::GetServersInput)
    pub fn builder() -> crate::input::get_servers_input::Builder {
        crate::input::get_servers_input::Builder::default()
    }
}

/// See [`ImportAppCatalogInput`](crate::input::ImportAppCatalogInput)
pub mod import_app_catalog_input {
    /// A builder for [`ImportAppCatalogInput`](crate::input::ImportAppCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service role. If you omit this parameter, we create a service-linked role for Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy and trust policy</a> described in the <i>Migration Hub User Guide</i>.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service role. If you omit this parameter, we create a service-linked role for Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy and trust policy</a> described in the <i>Migration Hub User Guide</i>.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportAppCatalogInput`](crate::input::ImportAppCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportAppCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportAppCatalogInput {
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportAppCatalogInputOperationOutputAlias = crate::operation::ImportAppCatalog;
#[doc(hidden)]
pub type ImportAppCatalogInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportAppCatalogInput {
    /// Consumes the builder and constructs an Operation<[`ImportAppCatalog`](crate::operation::ImportAppCatalog)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportAppCatalog,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportAppCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportAppCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportAppCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.ImportAppCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_app_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportAppCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportAppCatalog",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportAppCatalogInput`](crate::input::ImportAppCatalogInput)
    pub fn builder() -> crate::input::import_app_catalog_input::Builder {
        crate::input::import_app_catalog_input::Builder::default()
    }
}

/// See [`ImportServerCatalogInput`](crate::input::ImportServerCatalogInput)
pub mod import_server_catalog_input {
    /// A builder for [`ImportServerCatalogInput`](crate::input::ImportServerCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ImportServerCatalogInput`](crate::input::ImportServerCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportServerCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportServerCatalogInput {})
        }
    }
}
#[doc(hidden)]
pub type ImportServerCatalogInputOperationOutputAlias = crate::operation::ImportServerCatalog;
#[doc(hidden)]
pub type ImportServerCatalogInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportServerCatalogInput {
    /// Consumes the builder and constructs an Operation<[`ImportServerCatalog`](crate::operation::ImportServerCatalog)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportServerCatalog,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportServerCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportServerCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportServerCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.ImportServerCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_server_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportServerCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportServerCatalog",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportServerCatalogInput`](crate::input::ImportServerCatalogInput)
    pub fn builder() -> crate::input::import_server_catalog_input::Builder {
        crate::input::import_server_catalog_input::Builder::default()
    }
}

/// See [`LaunchAppInput`](crate::input::LaunchAppInput)
pub mod launch_app_input {
    /// A builder for [`LaunchAppInput`](crate::input::LaunchAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchAppInput`](crate::input::LaunchAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::LaunchAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::LaunchAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type LaunchAppInputOperationOutputAlias = crate::operation::LaunchApp;
#[doc(hidden)]
pub type LaunchAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl LaunchAppInput {
    /// Consumes the builder and constructs an Operation<[`LaunchApp`](crate::operation::LaunchApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LaunchApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LaunchAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LaunchAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LaunchAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.LaunchApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_launch_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::LaunchApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "LaunchApp",
                    "sms",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LaunchAppInput`](crate::input::LaunchAppInput)
    pub fn builder() -> crate::input::launch_app_input::Builder {
        crate::input::launch_app_input::Builder::default()
    }
}

/// See [`ListAppsInput`](crate::input::ListAppsInput)
pub mod list_apps_input {
    /// A builder for [`ListAppsInput`](crate::input::ListAppsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `app_ids`.
        ///
        /// To override the contents of this collection use [`set_app_ids`](Self::set_app_ids).
        ///
        /// <p>The unique application IDs.</p>
        pub fn app_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.app_ids.unwrap_or_default();
            v.push(input.into());
            self.app_ids = Some(v);
            self
        }
        /// <p>The unique application IDs.</p>
        pub fn set_app_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.app_ids = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsInput`](crate::input::ListAppsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListAppsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListAppsInput {
                app_ids: self.app_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppsInputOperationOutputAlias = crate::operation::ListApps;
#[doc(hidden)]
pub type ListAppsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAppsInput {
    /// Consumes the builder and constructs an Operation<[`ListApps`](crate::operation::ListApps)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.ListApps",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_apps(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListApps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListApps", "sms"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
}

/// See [`NotifyAppValidationOutputInput`](crate::input::NotifyAppValidationOutputInput)
pub mod notify_app_validation_output_input {
    /// A builder for [`NotifyAppValidationOutputInput`](crate::input::NotifyAppValidationOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) notification_context: std::option::Option<crate::model::NotificationContext>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The notification information.</p>
        pub fn notification_context(mut self, input: crate::model::NotificationContext) -> Self {
            self.notification_context = Some(input);
            self
        }
        /// <p>The notification information.</p>
        pub fn set_notification_context(
            mut self,
            input: std::option::Option<crate::model::NotificationContext>,
        ) -> Self {
            self.notification_context = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyAppValidationOutputInput`](crate::input::NotifyAppValidationOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::NotifyAppValidationOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::NotifyAppValidationOutputInput {
                app_id: self.app_id,
                notification_context: self.notification_context,
            })
        }
    }
}
#[doc(hidden)]
pub type NotifyAppValidationOutputInputOperationOutputAlias =
    crate::operation::NotifyAppValidationOutput;
#[doc(hidden)]
pub type NotifyAppValidationOutputInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl NotifyAppValidationOutputInput {
    /// Consumes the builder and constructs an Operation<[`NotifyAppValidationOutput`](crate::operation::NotifyAppValidationOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::NotifyAppValidationOutput,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::NotifyAppValidationOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::NotifyAppValidationOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::NotifyAppValidationOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.NotifyAppValidationOutput",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_notify_app_validation_output(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::NotifyAppValidationOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "NotifyAppValidationOutput",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`NotifyAppValidationOutputInput`](crate::input::NotifyAppValidationOutputInput)
    pub fn builder() -> crate::input::notify_app_validation_output_input::Builder {
        crate::input::notify_app_validation_output_input::Builder::default()
    }
}

/// See [`PutAppLaunchConfigurationInput`](crate::input::PutAppLaunchConfigurationInput)
pub mod put_app_launch_configuration_input {
    /// A builder for [`PutAppLaunchConfigurationInput`](crate::input::PutAppLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) auto_launch: std::option::Option<bool>,
        pub(crate) server_group_launch_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of service role in the customer's account that CloudFormation uses to launch the application.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of service role in the customer's account that CloudFormation uses to launch the application.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn auto_launch(mut self, input: bool) -> Self {
            self.auto_launch = Some(input);
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn set_auto_launch(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_launch = input;
            self
        }
        /// Appends an item to `server_group_launch_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_launch_configurations`](Self::set_server_group_launch_configurations).
        ///
        /// <p>Information about the launch configurations for server groups in the application.</p>
        pub fn server_group_launch_configurations(
            mut self,
            input: crate::model::ServerGroupLaunchConfiguration,
        ) -> Self {
            let mut v = self.server_group_launch_configurations.unwrap_or_default();
            v.push(input);
            self.server_group_launch_configurations = Some(v);
            self
        }
        /// <p>Information about the launch configurations for server groups in the application.</p>
        pub fn set_server_group_launch_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
        ) -> Self {
            self.server_group_launch_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAppLaunchConfigurationInput`](crate::input::PutAppLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAppLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAppLaunchConfigurationInput {
                app_id: self.app_id,
                role_name: self.role_name,
                auto_launch: self.auto_launch,
                server_group_launch_configurations: self.server_group_launch_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAppLaunchConfigurationInputOperationOutputAlias =
    crate::operation::PutAppLaunchConfiguration;
#[doc(hidden)]
pub type PutAppLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAppLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutAppLaunchConfiguration`](crate::operation::PutAppLaunchConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAppLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAppLaunchConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAppLaunchConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAppLaunchConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.PutAppLaunchConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_app_launch_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAppLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAppLaunchConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAppLaunchConfigurationInput`](crate::input::PutAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::put_app_launch_configuration_input::Builder {
        crate::input::put_app_launch_configuration_input::Builder::default()
    }
}

/// See [`PutAppReplicationConfigurationInput`](crate::input::PutAppReplicationConfigurationInput)
pub mod put_app_replication_configuration_input {
    /// A builder for [`PutAppReplicationConfigurationInput`](crate::input::PutAppReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) server_group_replication_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Appends an item to `server_group_replication_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_replication_configurations`](Self::set_server_group_replication_configurations).
        ///
        /// <p>Information about the replication configurations for server groups in the application.</p>
        pub fn server_group_replication_configurations(
            mut self,
            input: crate::model::ServerGroupReplicationConfiguration,
        ) -> Self {
            let mut v = self
                .server_group_replication_configurations
                .unwrap_or_default();
            v.push(input);
            self.server_group_replication_configurations = Some(v);
            self
        }
        /// <p>Information about the replication configurations for server groups in the application.</p>
        pub fn set_server_group_replication_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>,
            >,
        ) -> Self {
            self.server_group_replication_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAppReplicationConfigurationInput`](crate::input::PutAppReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAppReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAppReplicationConfigurationInput {
                app_id: self.app_id,
                server_group_replication_configurations: self
                    .server_group_replication_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAppReplicationConfigurationInputOperationOutputAlias =
    crate::operation::PutAppReplicationConfiguration;
#[doc(hidden)]
pub type PutAppReplicationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAppReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutAppReplicationConfiguration`](crate::operation::PutAppReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAppReplicationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAppReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAppReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAppReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.PutAppReplicationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_app_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAppReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAppReplicationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAppReplicationConfigurationInput`](crate::input::PutAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::put_app_replication_configuration_input::Builder {
        crate::input::put_app_replication_configuration_input::Builder::default()
    }
}

/// See [`PutAppValidationConfigurationInput`](crate::input::PutAppValidationConfigurationInput)
pub mod put_app_validation_configuration_input {
    /// A builder for [`PutAppValidationConfigurationInput`](crate::input::PutAppValidationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) app_validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
        pub(crate) server_group_validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupValidationConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Appends an item to `app_validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_app_validation_configurations`](Self::set_app_validation_configurations).
        ///
        /// <p>The configuration for application validation.</p>
        pub fn app_validation_configurations(
            mut self,
            input: crate::model::AppValidationConfiguration,
        ) -> Self {
            let mut v = self.app_validation_configurations.unwrap_or_default();
            v.push(input);
            self.app_validation_configurations = Some(v);
            self
        }
        /// <p>The configuration for application validation.</p>
        pub fn set_app_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
        ) -> Self {
            self.app_validation_configurations = input;
            self
        }
        /// Appends an item to `server_group_validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_validation_configurations`](Self::set_server_group_validation_configurations).
        ///
        /// <p>The configuration for instance validation.</p>
        pub fn server_group_validation_configurations(
            mut self,
            input: crate::model::ServerGroupValidationConfiguration,
        ) -> Self {
            let mut v = self
                .server_group_validation_configurations
                .unwrap_or_default();
            v.push(input);
            self.server_group_validation_configurations = Some(v);
            self
        }
        /// <p>The configuration for instance validation.</p>
        pub fn set_server_group_validation_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupValidationConfiguration>,
            >,
        ) -> Self {
            self.server_group_validation_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAppValidationConfigurationInput`](crate::input::PutAppValidationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAppValidationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAppValidationConfigurationInput {
                app_id: self.app_id,
                app_validation_configurations: self.app_validation_configurations,
                server_group_validation_configurations: self.server_group_validation_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAppValidationConfigurationInputOperationOutputAlias =
    crate::operation::PutAppValidationConfiguration;
#[doc(hidden)]
pub type PutAppValidationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAppValidationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutAppValidationConfiguration`](crate::operation::PutAppValidationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAppValidationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAppValidationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAppValidationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAppValidationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.PutAppValidationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_app_validation_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAppValidationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAppValidationConfiguration",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAppValidationConfigurationInput`](crate::input::PutAppValidationConfigurationInput)
    pub fn builder() -> crate::input::put_app_validation_configuration_input::Builder {
        crate::input::put_app_validation_configuration_input::Builder::default()
    }
}

/// See [`StartAppReplicationInput`](crate::input::StartAppReplicationInput)
pub mod start_app_replication_input {
    /// A builder for [`StartAppReplicationInput`](crate::input::StartAppReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAppReplicationInput`](crate::input::StartAppReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartAppReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartAppReplicationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartAppReplicationInputOperationOutputAlias = crate::operation::StartAppReplication;
#[doc(hidden)]
pub type StartAppReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartAppReplicationInput {
    /// Consumes the builder and constructs an Operation<[`StartAppReplication`](crate::operation::StartAppReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartAppReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartAppReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartAppReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartAppReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.StartAppReplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_app_replication(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartAppReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartAppReplication",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartAppReplicationInput`](crate::input::StartAppReplicationInput)
    pub fn builder() -> crate::input::start_app_replication_input::Builder {
        crate::input::start_app_replication_input::Builder::default()
    }
}

/// See [`StartOnDemandAppReplicationInput`](crate::input::StartOnDemandAppReplicationInput)
pub mod start_on_demand_app_replication_input {
    /// A builder for [`StartOnDemandAppReplicationInput`](crate::input::StartOnDemandAppReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOnDemandAppReplicationInput`](crate::input::StartOnDemandAppReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartOnDemandAppReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartOnDemandAppReplicationInput {
                app_id: self.app_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type StartOnDemandAppReplicationInputOperationOutputAlias =
    crate::operation::StartOnDemandAppReplication;
#[doc(hidden)]
pub type StartOnDemandAppReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartOnDemandAppReplicationInput {
    /// Consumes the builder and constructs an Operation<[`StartOnDemandAppReplication`](crate::operation::StartOnDemandAppReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartOnDemandAppReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartOnDemandAppReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartOnDemandAppReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartOnDemandAppReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.StartOnDemandAppReplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_on_demand_app_replication(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartOnDemandAppReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartOnDemandAppReplication",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartOnDemandAppReplicationInput`](crate::input::StartOnDemandAppReplicationInput)
    pub fn builder() -> crate::input::start_on_demand_app_replication_input::Builder {
        crate::input::start_on_demand_app_replication_input::Builder::default()
    }
}

/// See [`StartOnDemandReplicationRunInput`](crate::input::StartOnDemandReplicationRunInput)
pub mod start_on_demand_replication_run_input {
    /// A builder for [`StartOnDemandReplicationRunInput`](crate::input::StartOnDemandReplicationRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOnDemandReplicationRunInput`](crate::input::StartOnDemandReplicationRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartOnDemandReplicationRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartOnDemandReplicationRunInput {
                replication_job_id: self.replication_job_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type StartOnDemandReplicationRunInputOperationOutputAlias =
    crate::operation::StartOnDemandReplicationRun;
#[doc(hidden)]
pub type StartOnDemandReplicationRunInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartOnDemandReplicationRunInput {
    /// Consumes the builder and constructs an Operation<[`StartOnDemandReplicationRun`](crate::operation::StartOnDemandReplicationRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartOnDemandReplicationRun,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartOnDemandReplicationRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartOnDemandReplicationRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartOnDemandReplicationRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.StartOnDemandReplicationRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_on_demand_replication_run(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartOnDemandReplicationRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartOnDemandReplicationRun",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartOnDemandReplicationRunInput`](crate::input::StartOnDemandReplicationRunInput)
    pub fn builder() -> crate::input::start_on_demand_replication_run_input::Builder {
        crate::input::start_on_demand_replication_run_input::Builder::default()
    }
}

/// See [`StopAppReplicationInput`](crate::input::StopAppReplicationInput)
pub mod stop_app_replication_input {
    /// A builder for [`StopAppReplicationInput`](crate::input::StopAppReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopAppReplicationInput`](crate::input::StopAppReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopAppReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopAppReplicationInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopAppReplicationInputOperationOutputAlias = crate::operation::StopAppReplication;
#[doc(hidden)]
pub type StopAppReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopAppReplicationInput {
    /// Consumes the builder and constructs an Operation<[`StopAppReplication`](crate::operation::StopAppReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopAppReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopAppReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopAppReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopAppReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.StopAppReplication",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_app_replication(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopAppReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopAppReplication",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopAppReplicationInput`](crate::input::StopAppReplicationInput)
    pub fn builder() -> crate::input::stop_app_replication_input::Builder {
        crate::input::stop_app_replication_input::Builder::default()
    }
}

/// See [`TerminateAppInput`](crate::input::TerminateAppInput)
pub mod terminate_app_input {
    /// A builder for [`TerminateAppInput`](crate::input::TerminateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateAppInput`](crate::input::TerminateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateAppInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateAppInput {
                app_id: self.app_id,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateAppInputOperationOutputAlias = crate::operation::TerminateApp;
#[doc(hidden)]
pub type TerminateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TerminateAppInput {
    /// Consumes the builder and constructs an Operation<[`TerminateApp`](crate::operation::TerminateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TerminateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TerminateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TerminateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.TerminateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_terminate_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateApp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateApp",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TerminateAppInput`](crate::input::TerminateAppInput)
    pub fn builder() -> crate::input::terminate_app_input::Builder {
        crate::input::terminate_app_input::Builder::default()
    }
}

/// See [`UpdateAppInput`](crate::input::UpdateAppInput)
pub mod update_app_input {
    /// A builder for [`UpdateAppInput`](crate::input::UpdateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The new name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the service role in the customer's account used by Server Migration Service.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service role in the customer's account used by Server Migration Service.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Appends an item to `server_groups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups in the application to update.</p>
        pub fn server_groups(mut self, input: crate::model::ServerGroup) -> Self {
            let mut v = self.server_groups.unwrap_or_default();
            v.push(input);
            self.server_groups = Some(v);
            self
        }
        /// <p>The server groups in the application to update.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.server_groups = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the application.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to associate with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInput`](crate::input::UpdateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateAppInput {
                app_id: self.app_id,
                name: self.name,
                description: self.description,
                role_name: self.role_name,
                server_groups: self.server_groups,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAppInputOperationOutputAlias = crate::operation::UpdateApp;
#[doc(hidden)]
pub type UpdateAppInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAppInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApp`](crate::operation::UpdateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.UpdateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateApp",
                    "sms",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
}

/// See [`UpdateReplicationJobInput`](crate::input::UpdateReplicationJobInput)
pub mod update_replication_job_input {
    /// A builder for [`UpdateReplicationJobInput`](crate::input::UpdateReplicationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) frequency: std::option::Option<i32>,
        pub(crate) next_replication_run_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) number_of_recent_amis_to_keep: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn frequency(mut self, input: i32) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn next_replication_run_start_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.next_replication_run_start_time = Some(input);
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn set_next_replication_run_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.next_replication_run_start_time = input;
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication run.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication run.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The name of the IAM role to be used by Server Migration Service.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to be used by Server Migration Service.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
        pub fn number_of_recent_amis_to_keep(mut self, input: i32) -> Self {
            self.number_of_recent_amis_to_keep = Some(input);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_recent_amis_to_keep = input;
            self
        }
        /// <p>When true, the replication job produces encrypted AMIs. For more information, <code>KmsKeyId</code>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>When true, the replication job produces encrypted AMIs. For more information, <code>KmsKeyId</code>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
        /// <ul>
        /// <li> <p>KMS key ID</p> </li>
        /// <li> <p>KMS key alias</p> </li>
        /// <li> <p>ARN referring to the KMS key ID</p> </li>
        /// <li> <p>ARN referring to the KMS key alias</p> </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
        /// <ul>
        /// <li> <p>KMS key ID</p> </li>
        /// <li> <p>KMS key alias</p> </li>
        /// <li> <p>ARN referring to the KMS key ID</p> </li>
        /// <li> <p>ARN referring to the KMS key alias</p> </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationJobInput`](crate::input::UpdateReplicationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReplicationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReplicationJobInput {
                replication_job_id: self.replication_job_id,
                frequency: self.frequency,
                next_replication_run_start_time: self.next_replication_run_start_time,
                license_type: self.license_type,
                role_name: self.role_name,
                description: self.description,
                number_of_recent_amis_to_keep: self.number_of_recent_amis_to_keep,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReplicationJobInputOperationOutputAlias = crate::operation::UpdateReplicationJob;
#[doc(hidden)]
pub type UpdateReplicationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateReplicationJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReplicationJob`](crate::operation::UpdateReplicationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReplicationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReplicationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReplicationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReplicationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSServerMigrationService_V2016_10_24.UpdateReplicationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_replication_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReplicationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReplicationJob",
            "sms",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReplicationJobInput`](crate::input::UpdateReplicationJobInput)
    pub fn builder() -> crate::input::update_replication_job_input::Builder {
        crate::input::update_replication_job_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationJobInput {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub frequency: std::option::Option<i32>,
    /// <p>The start time of the next replication run.</p>
    pub next_replication_run_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The license type to be used for the AMI created by a successful replication run.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
    /// <p>The name of the IAM role to be used by Server Migration Service.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The description of the replication job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
    pub number_of_recent_amis_to_keep: std::option::Option<i32>,
    /// <p>When true, the replication job produces encrypted AMIs. For more information, <code>KmsKeyId</code>.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
    /// <ul>
    /// <li> <p>KMS key ID</p> </li>
    /// <li> <p>KMS key alias</p> </li>
    /// <li> <p>ARN referring to the KMS key ID</p> </li>
    /// <li> <p>ARN referring to the KMS key alias</p> </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl UpdateReplicationJobInput {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub fn frequency(&self) -> std::option::Option<i32> {
        self.frequency
    }
    /// <p>The start time of the next replication run.</p>
    pub fn next_replication_run_start_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.next_replication_run_start_time.as_ref()
    }
    /// <p>The license type to be used for the AMI created by a successful replication run.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
    /// <p>The name of the IAM role to be used by Server Migration Service.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The description of the replication job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
    pub fn number_of_recent_amis_to_keep(&self) -> std::option::Option<i32> {
        self.number_of_recent_amis_to_keep
    }
    /// <p>When true, the replication job produces encrypted AMIs. For more information, <code>KmsKeyId</code>.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
    /// <ul>
    /// <li> <p>KMS key ID</p> </li>
    /// <li> <p>KMS key alias</p> </li>
    /// <li> <p>ARN referring to the KMS key ID</p> </li>
    /// <li> <p>ARN referring to the KMS key alias</p> </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateReplicationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationJobInput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field("frequency", &self.frequency);
        formatter.field(
            "next_replication_run_start_time",
            &self.next_replication_run_start_time,
        );
        formatter.field("license_type", &self.license_type);
        formatter.field("role_name", &self.role_name);
        formatter.field("description", &self.description);
        formatter.field(
            "number_of_recent_amis_to_keep",
            &self.number_of_recent_amis_to_keep,
        );
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The new name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the service role in the customer's account used by Server Migration Service.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The server groups in the application to update.</p>
    pub server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
    /// <p>The tags to associate with the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UpdateAppInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The new name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The new description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the service role in the customer's account used by Server Migration Service.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The server groups in the application to update.</p>
    pub fn server_groups(&self) -> std::option::Option<&[crate::model::ServerGroup]> {
        self.server_groups.as_deref()
    }
    /// <p>The tags to associate with the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("role_name", &self.role_name);
        formatter.field("server_groups", &self.server_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateAppInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl TerminateAppInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for TerminateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl StopAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for StopAppReplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAppReplicationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOnDemandReplicationRunInput {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>The description of the replication run.</p>
    pub description: std::option::Option<std::string::String>,
}
impl StartOnDemandReplicationRunInput {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>The description of the replication run.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for StartOnDemandReplicationRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOnDemandReplicationRunInput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOnDemandAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The description of the replication run.</p>
    pub description: std::option::Option<std::string::String>,
}
impl StartOnDemandAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The description of the replication run.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for StartOnDemandAppReplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOnDemandAppReplicationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl StartAppReplicationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for StartAppReplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAppReplicationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The configuration for application validation.</p>
    pub app_validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
    /// <p>The configuration for instance validation.</p>
    pub server_group_validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupValidationConfiguration>>,
}
impl PutAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The configuration for application validation.</p>
    pub fn app_validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::AppValidationConfiguration]> {
        self.app_validation_configurations.as_deref()
    }
    /// <p>The configuration for instance validation.</p>
    pub fn server_group_validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupValidationConfiguration]> {
        self.server_group_validation_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutAppValidationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppValidationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field(
            "app_validation_configurations",
            &self.app_validation_configurations,
        );
        formatter.field(
            "server_group_validation_configurations",
            &self.server_group_validation_configurations,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>Information about the replication configurations for server groups in the application.</p>
    pub server_group_replication_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>>,
}
impl PutAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>Information about the replication configurations for server groups in the application.</p>
    pub fn server_group_replication_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupReplicationConfiguration]> {
        self.server_group_replication_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutAppReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppReplicationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field(
            "server_group_replication_configurations",
            &self.server_group_replication_configurations,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of service role in the customer's account that CloudFormation uses to launch the application.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
    pub auto_launch: std::option::Option<bool>,
    /// <p>Information about the launch configurations for server groups in the application.</p>
    pub server_group_launch_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
}
impl PutAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of service role in the customer's account that CloudFormation uses to launch the application.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
    pub fn auto_launch(&self) -> std::option::Option<bool> {
        self.auto_launch
    }
    /// <p>Information about the launch configurations for server groups in the application.</p>
    pub fn server_group_launch_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupLaunchConfiguration]> {
        self.server_group_launch_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutAppLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppLaunchConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("role_name", &self.role_name);
        formatter.field("auto_launch", &self.auto_launch);
        formatter.field(
            "server_group_launch_configurations",
            &self.server_group_launch_configurations,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyAppValidationOutputInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The notification information.</p>
    pub notification_context: std::option::Option<crate::model::NotificationContext>,
}
impl NotifyAppValidationOutputInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The notification information.</p>
    pub fn notification_context(&self) -> std::option::Option<&crate::model::NotificationContext> {
        self.notification_context.as_ref()
    }
}
impl std::fmt::Debug for NotifyAppValidationOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyAppValidationOutputInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("notification_context", &self.notification_context);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsInput {
    /// <p>The unique application IDs.</p>
    pub app_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppsInput {
    /// <p>The unique application IDs.</p>
    pub fn app_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.app_ids.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsInput");
        formatter.field("app_ids", &self.app_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchAppInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl LaunchAppInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for LaunchAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportServerCatalogInput {}
impl std::fmt::Debug for ImportServerCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportServerCatalogInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAppCatalogInput {
    /// <p>The name of the service role. If you omit this parameter, we create a service-linked role for Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy and trust policy</a> described in the <i>Migration Hub User Guide</i>.</p>
    pub role_name: std::option::Option<std::string::String>,
}
impl ImportAppCatalogInput {
    /// <p>The name of the service role. If you omit this parameter, we create a service-linked role for Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy and trust policy</a> described in the <i>Migration Hub User Guide</i>.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
}
impl std::fmt::Debug for ImportAppCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAppCatalogInput");
        formatter.field("role_name", &self.role_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServersInput {
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The server addresses.</p>
    pub vm_server_address_list: std::option::Option<std::vec::Vec<crate::model::VmServerAddress>>,
}
impl GetServersInput {
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The server addresses.</p>
    pub fn vm_server_address_list(&self) -> std::option::Option<&[crate::model::VmServerAddress]> {
        self.vm_server_address_list.as_deref()
    }
}
impl std::fmt::Debug for GetServersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("vm_server_address_list", &self.vm_server_address_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationRunsInput {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetReplicationRunsInput {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetReplicationRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationRunsInput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationJobsInput {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetReplicationJobsInput {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetReplicationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationJobsInput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectorsInput {
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetConnectorsInput {
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetConnectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectorsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppValidationOutputInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppValidationOutputInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppValidationOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppValidationOutputInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppValidationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppValidationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppReplicationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppLaunchConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl GetAppInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for GetAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateTemplateInput {
    /// <p>The ID of the application associated with the CloudFormation template.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The format for generating the CloudFormation template.</p>
    pub template_format: std::option::Option<crate::model::OutputFormat>,
}
impl GenerateTemplateInput {
    /// <p>The ID of the application associated with the CloudFormation template.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The format for generating the CloudFormation template.</p>
    pub fn template_format(&self) -> std::option::Option<&crate::model::OutputFormat> {
        self.template_format.as_ref()
    }
}
impl std::fmt::Debug for GenerateTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateTemplateInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("template_format", &self.template_format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateChangeSetInput {
    /// <p>The ID of the application associated with the change set.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The format for the change set.</p>
    pub changeset_format: std::option::Option<crate::model::OutputFormat>,
}
impl GenerateChangeSetInput {
    /// <p>The ID of the application associated with the change set.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The format for the change set.</p>
    pub fn changeset_format(&self) -> std::option::Option<&crate::model::OutputFormat> {
        self.changeset_format.as_ref()
    }
}
impl std::fmt::Debug for GenerateChangeSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateChangeSetInput");
        formatter.field("app_id", &self.app_id);
        formatter.field("changeset_format", &self.changeset_format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectorInput {
    /// <p>The ID of the connector.</p>
    pub connector_id: std::option::Option<std::string::String>,
}
impl DisassociateConnectorInput {
    /// <p>The ID of the connector.</p>
    pub fn connector_id(&self) -> std::option::Option<&str> {
        self.connector_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateConnectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectorInput");
        formatter.field("connector_id", &self.connector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerCatalogInput {}
impl std::fmt::Debug for DeleteServerCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerCatalogInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationJobInput {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
}
impl DeleteReplicationJobInput {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteReplicationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationJobInput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl DeleteAppValidationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppValidationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppValidationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl DeleteAppReplicationConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppReplicationConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
}
impl DeleteAppLaunchConfigurationInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppLaunchConfigurationInput");
        formatter.field("app_id", &self.app_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application.</p>
    pub force_stop_app_replication: std::option::Option<bool>,
    /// <p>Indicates whether to terminate the stack corresponding to the application while deleting the application.</p>
    pub force_terminate_app: std::option::Option<bool>,
}
impl DeleteAppInput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application.</p>
    pub fn force_stop_app_replication(&self) -> std::option::Option<bool> {
        self.force_stop_app_replication
    }
    /// <p>Indicates whether to terminate the stack corresponding to the application while deleting the application.</p>
    pub fn force_terminate_app(&self) -> std::option::Option<bool> {
        self.force_terminate_app
    }
}
impl std::fmt::Debug for DeleteAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInput");
        formatter.field("app_id", &self.app_id);
        formatter.field(
            "force_stop_app_replication",
            &self.force_stop_app_replication,
        );
        formatter.field("force_terminate_app", &self.force_terminate_app);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationJobInput {
    /// <p>The ID of the server.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The seed replication time.</p>
    pub seed_replication_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub frequency: std::option::Option<i32>,
    /// <p>Indicates whether to run the replication job one time.</p>
    pub run_once: std::option::Option<bool>,
    /// <p>The license type to be used for the AMI created by a successful replication run.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
    /// <p>The name of the IAM role to be used by the Server Migration Service.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The description of the replication job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
    pub number_of_recent_amis_to_keep: std::option::Option<i32>,
    /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
    /// <ul>
    /// <li> <p>KMS key ID</p> </li>
    /// <li> <p>KMS key alias</p> </li>
    /// <li> <p>ARN referring to the KMS key ID</p> </li>
    /// <li> <p>ARN referring to the KMS key alias</p> </li>
    /// </ul>
    /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl CreateReplicationJobInput {
    /// <p>The ID of the server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The seed replication time.</p>
    pub fn seed_replication_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.seed_replication_time.as_ref()
    }
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub fn frequency(&self) -> std::option::Option<i32> {
        self.frequency
    }
    /// <p>Indicates whether to run the replication job one time.</p>
    pub fn run_once(&self) -> std::option::Option<bool> {
        self.run_once
    }
    /// <p>The license type to be used for the AMI created by a successful replication run.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
    /// <p>The name of the IAM role to be used by the Server Migration Service.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The description of the replication job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.</p>
    pub fn number_of_recent_amis_to_keep(&self) -> std::option::Option<i32> {
        self.number_of_recent_amis_to_keep
    }
    /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:</p>
    /// <ul>
    /// <li> <p>KMS key ID</p> </li>
    /// <li> <p>KMS key alias</p> </li>
    /// <li> <p>ARN referring to the KMS key ID</p> </li>
    /// <li> <p>ARN referring to the KMS key alias</p> </li>
    /// </ul>
    /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for CreateReplicationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationJobInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("seed_replication_time", &self.seed_replication_time);
        formatter.field("frequency", &self.frequency);
        formatter.field("run_once", &self.run_once);
        formatter.field("license_type", &self.license_type);
        formatter.field("role_name", &self.role_name);
        formatter.field("description", &self.description);
        formatter.field(
            "number_of_recent_amis_to_keep",
            &self.number_of_recent_amis_to_keep,
        );
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInput {
    /// <p>The name of the new application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the new application</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the service role in the customer's account to be used by Server Migration Service.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The server groups to include in the application.</p>
    pub server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
    /// <p>The tags to be associated with the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateAppInput {
    /// <p>The name of the new application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the new application</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the service role in the customer's account to be used by Server Migration Service.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The server groups to include in the application.</p>
    pub fn server_groups(&self) -> std::option::Option<&[crate::model::ServerGroup]> {
        self.server_groups.as_deref()
    }
    /// <p>The tags to be associated with the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("role_name", &self.role_name);
        formatter.field("client_token", &self.client_token);
        formatter.field("server_groups", &self.server_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
