// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::CreateAppError {
            meta: generic,
            kind: crate::error::CreateAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_app_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_app(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAppError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationJobOutput,
    crate::error::CreateReplicationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReplicationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateReplicationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoConnectorsAvailableException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::NoConnectorsAvailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_connectors_available_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_no_connectors_available_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationJobAlreadyExistsException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::replication_job_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_replication_job_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServerCannotBeReplicatedException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::ServerCannotBeReplicatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_cannot_be_replicated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_cannot_be_replicated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TemporarilyUnavailableException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::TemporarilyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::temporarily_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_temporarily_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::CreateReplicationJobError {
            meta: generic,
            kind: crate::error::CreateReplicationJobErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateReplicationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_replication_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReplicationJobOutput,
    crate::error::CreateReplicationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_replication_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_replication_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateReplicationJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::DeleteAppError {
            meta: generic,
            kind: crate::error::DeleteAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::DeleteAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteAppError {
            meta: generic,
            kind: crate::error::DeleteAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::DeleteAppError {
            meta: generic,
            kind: crate::error::DeleteAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::DeleteAppError {
            meta: generic,
            kind: crate::error::DeleteAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::DeleteAppError {
            meta: generic,
            kind: crate::error::DeleteAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_app_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_launch_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppLaunchConfigurationOutput,
    crate::error::DeleteAppLaunchConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAppLaunchConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::DeleteAppLaunchConfigurationError { meta: generic, kind: crate::error::DeleteAppLaunchConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DeleteAppLaunchConfigurationError { meta: generic, kind: crate::error::DeleteAppLaunchConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::DeleteAppLaunchConfigurationError { meta: generic, kind: crate::error::DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::DeleteAppLaunchConfigurationError { meta: generic, kind: crate::error::DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::DeleteAppLaunchConfigurationError { meta: generic, kind: crate::error::DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppLaunchConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteAppLaunchConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_launch_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppLaunchConfigurationOutput,
    crate::error::DeleteAppLaunchConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_app_launch_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_replication_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppReplicationConfigurationOutput,
    crate::error::DeleteAppReplicationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAppReplicationConfigurationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::DeleteAppReplicationConfigurationError { meta: generic, kind: crate::error::DeleteAppReplicationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DeleteAppReplicationConfigurationError { meta: generic, kind: crate::error::DeleteAppReplicationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::DeleteAppReplicationConfigurationError { meta: generic, kind: crate::error::DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::DeleteAppReplicationConfigurationError { meta: generic, kind: crate::error::DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::DeleteAppReplicationConfigurationError { meta: generic, kind: crate::error::DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteAppReplicationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_replication_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppReplicationConfigurationOutput,
    crate::error::DeleteAppReplicationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_app_replication_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_validation_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppValidationConfigurationOutput,
    crate::error::DeleteAppValidationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAppValidationConfigurationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::DeleteAppValidationConfigurationError { meta: generic, kind: crate::error::DeleteAppValidationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::DeleteAppValidationConfigurationError { meta: generic, kind: crate::error::DeleteAppValidationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::DeleteAppValidationConfigurationError { meta: generic, kind: crate::error::DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::DeleteAppValidationConfigurationError { meta: generic, kind: crate::error::DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::DeleteAppValidationConfigurationError { meta: generic, kind: crate::error::DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteAppValidationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_app_validation_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAppValidationConfigurationOutput,
    crate::error::DeleteAppValidationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_app_validation_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationJobOutput,
    crate::error::DeleteReplicationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReplicationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteReplicationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteReplicationJobError {
            meta: generic,
            kind: crate::error::DeleteReplicationJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::DeleteReplicationJobError {
            meta: generic,
            kind: crate::error::DeleteReplicationJobErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::DeleteReplicationJobError {
            meta: generic,
            kind: crate::error::DeleteReplicationJobErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationJobNotFoundException" => crate::error::DeleteReplicationJobError {
            meta: generic,
            kind: crate::error::DeleteReplicationJobErrorKind::ReplicationJobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::DeleteReplicationJobError {
            meta: generic,
            kind: crate::error::DeleteReplicationJobErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReplicationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_replication_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReplicationJobOutput,
    crate::error::DeleteReplicationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_replication_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_server_catalog_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServerCatalogOutput,
    crate::error::DeleteServerCatalogError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServerCatalogError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteServerCatalogError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteServerCatalogError {
            meta: generic,
            kind: crate::error::DeleteServerCatalogErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::DeleteServerCatalogError {
            meta: generic,
            kind: crate::error::DeleteServerCatalogErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::DeleteServerCatalogError {
            meta: generic,
            kind: crate::error::DeleteServerCatalogErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::DeleteServerCatalogError {
            meta: generic,
            kind: crate::error::DeleteServerCatalogErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServerCatalogError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_server_catalog_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServerCatalogOutput,
    crate::error::DeleteServerCatalogError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_server_catalog_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_connector_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConnectorOutput,
    crate::error::DisassociateConnectorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateConnectorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateConnectorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DisassociateConnectorError {
            meta: generic,
            kind: crate::error::DisassociateConnectorErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::DisassociateConnectorError {
            meta: generic,
            kind: crate::error::DisassociateConnectorErrorKind::MissingRequiredParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::missing_required_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectorError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotPermittedException" => crate::error::DisassociateConnectorError {
            meta: generic,
            kind: crate::error::DisassociateConnectorErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::DisassociateConnectorError {
            meta: generic,
            kind: crate::error::DisassociateConnectorErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateConnectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateConnectorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_connector_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateConnectorOutput,
    crate::error::DisassociateConnectorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_connector_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_change_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateChangeSetOutput, crate::error::GenerateChangeSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateChangeSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateChangeSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GenerateChangeSetError {
            meta: generic,
            kind: crate::error::GenerateChangeSetErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GenerateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GenerateChangeSetError {
            meta: generic,
            kind: crate::error::GenerateChangeSetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GenerateChangeSetError {
            meta: generic,
            kind: crate::error::GenerateChangeSetErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GenerateChangeSetError {
            meta: generic,
            kind: crate::error::GenerateChangeSetErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GenerateChangeSetError {
            meta: generic,
            kind: crate::error::GenerateChangeSetErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateChangeSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateChangeSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_change_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateChangeSetOutput, crate::error::GenerateChangeSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_change_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_change_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateChangeSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateTemplateOutput, crate::error::GenerateTemplateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GenerateTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GenerateTemplateError {
            meta: generic,
            kind: crate::error::GenerateTemplateErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GenerateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GenerateTemplateError {
            meta: generic,
            kind: crate::error::GenerateTemplateErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GenerateTemplateError {
            meta: generic,
            kind: crate::error::GenerateTemplateErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GenerateTemplateError {
            meta: generic,
            kind: crate::error::GenerateTemplateErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GenerateTemplateError {
            meta: generic,
            kind: crate::error::GenerateTemplateErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GenerateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GenerateTemplateOutput, crate::error::GenerateTemplateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_template_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_generate_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAppOutput, crate::error::GetAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetAppError {
            meta: generic,
            kind: crate::error::GetAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetAppError {
            meta: generic,
            kind: crate::error::GetAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetAppError {
            meta: generic,
            kind: crate::error::GetAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::GetAppError {
            meta: generic,
            kind: crate::error::GetAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GetAppError {
            meta: generic,
            kind: crate::error::GetAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAppOutput, crate::error::GetAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_app_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_app(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAppError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_launch_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppLaunchConfigurationOutput,
    crate::error::GetAppLaunchConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetAppLaunchConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::GetAppLaunchConfigurationErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::GetAppLaunchConfigurationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetAppLaunchConfigurationError {
            meta: generic,
            kind:
                crate::error::GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "OperationNotPermittedException" => crate::error::GetAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::GetAppLaunchConfigurationErrorKind::OperationNotPermittedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_permitted_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedOperationException" => crate::error::GetAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthorized_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetAppLaunchConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_launch_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppLaunchConfigurationOutput,
    crate::error::GetAppLaunchConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_app_launch_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_app_launch_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAppLaunchConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_replication_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppReplicationConfigurationOutput,
    crate::error::GetAppReplicationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAppReplicationConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetAppReplicationConfigurationError { meta: generic, kind: crate::error::GetAppReplicationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::GetAppReplicationConfigurationError { meta: generic, kind: crate::error::GetAppReplicationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::GetAppReplicationConfigurationError { meta: generic, kind: crate::error::GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::GetAppReplicationConfigurationError { meta: generic, kind: crate::error::GetAppReplicationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::GetAppReplicationConfigurationError { meta: generic, kind: crate::error::GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetAppReplicationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_replication_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppReplicationConfigurationOutput,
    crate::error::GetAppReplicationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_app_replication_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_app_replication_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetAppReplicationConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_validation_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppValidationConfigurationOutput,
    crate::error::GetAppValidationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetAppValidationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetAppValidationConfigurationError { meta: generic, kind: crate::error::GetAppValidationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::GetAppValidationConfigurationError { meta: generic, kind: crate::error::GetAppValidationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::GetAppValidationConfigurationError { meta: generic, kind: crate::error::GetAppValidationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::GetAppValidationConfigurationError { meta: generic, kind: crate::error::GetAppValidationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::GetAppValidationConfigurationError { meta: generic, kind: crate::error::GetAppValidationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetAppValidationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_validation_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppValidationConfigurationOutput,
    crate::error::GetAppValidationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_app_validation_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_app_validation_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetAppValidationConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_validation_output_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppValidationOutputOutput,
    crate::error::GetAppValidationOutputError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAppValidationOutputError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetAppValidationOutputError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetAppValidationOutputError {
            meta: generic,
            kind: crate::error::GetAppValidationOutputErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetAppValidationOutputError {
            meta: generic,
            kind: crate::error::GetAppValidationOutputErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetAppValidationOutputError {
            meta: generic,
            kind: crate::error::GetAppValidationOutputErrorKind::MissingRequiredParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::missing_required_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationOutputError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "OperationNotPermittedException" => crate::error::GetAppValidationOutputError {
            meta: generic,
            kind: crate::error::GetAppValidationOutputErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GetAppValidationOutputError {
            meta: generic,
            kind: crate::error::GetAppValidationOutputErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAppValidationOutputError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_app_validation_output_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAppValidationOutputOutput,
    crate::error::GetAppValidationOutputError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_app_validation_output_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_app_validation_output(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAppValidationOutputError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_connectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetConnectorsOutput, crate::error::GetConnectorsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetConnectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetConnectorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "UnauthorizedOperationException" => crate::error::GetConnectorsError {
            meta: generic,
            kind: crate::error::GetConnectorsErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetConnectorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetConnectorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_connectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetConnectorsOutput, crate::error::GetConnectorsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_connectors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_connectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetConnectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_replication_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReplicationJobsOutput,
    crate::error::GetReplicationJobsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReplicationJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetReplicationJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetReplicationJobsError {
            meta: generic,
            kind: crate::error::GetReplicationJobsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetReplicationJobsError {
            meta: generic,
            kind: crate::error::GetReplicationJobsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GetReplicationJobsError {
            meta: generic,
            kind: crate::error::GetReplicationJobsErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetReplicationJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_replication_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReplicationJobsOutput,
    crate::error::GetReplicationJobsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_replication_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_replication_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetReplicationJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_replication_runs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReplicationRunsOutput,
    crate::error::GetReplicationRunsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReplicationRunsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetReplicationRunsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetReplicationRunsError {
            meta: generic,
            kind: crate::error::GetReplicationRunsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationRunsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetReplicationRunsError {
            meta: generic,
            kind: crate::error::GetReplicationRunsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationRunsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GetReplicationRunsError {
            meta: generic,
            kind: crate::error::GetReplicationRunsErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReplicationRunsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetReplicationRunsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_replication_runs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReplicationRunsOutput,
    crate::error::GetReplicationRunsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_replication_runs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_replication_runs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetReplicationRunsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_servers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetServersOutput, crate::error::GetServersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetServersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::GetServersError {
            meta: generic,
            kind: crate::error::GetServersErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::GetServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::GetServersError {
            meta: generic,
            kind: crate::error::GetServersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::GetServersError {
            meta: generic,
            kind: crate::error::GetServersErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::GetServersError {
            meta: generic,
            kind: crate::error::GetServersErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetServersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetServersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_servers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetServersOutput, crate::error::GetServersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_servers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_servers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetServersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_app_catalog_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportAppCatalogOutput, crate::error::ImportAppCatalogError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportAppCatalogError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportAppCatalogError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::ImportAppCatalogError {
            meta: generic,
            kind: crate::error::ImportAppCatalogErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ImportAppCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ImportAppCatalogError {
            meta: generic,
            kind: crate::error::ImportAppCatalogErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAppCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::ImportAppCatalogError {
            meta: generic,
            kind: crate::error::ImportAppCatalogErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAppCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ImportAppCatalogError {
            meta: generic,
            kind: crate::error::ImportAppCatalogErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAppCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::ImportAppCatalogError {
            meta: generic,
            kind: crate::error::ImportAppCatalogErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportAppCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportAppCatalogError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_app_catalog_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportAppCatalogOutput, crate::error::ImportAppCatalogError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_app_catalog_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_server_catalog_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportServerCatalogOutput,
    crate::error::ImportServerCatalogError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportServerCatalogError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportServerCatalogError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::ImportServerCatalogError {
            meta: generic,
            kind: crate::error::ImportServerCatalogErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::ImportServerCatalogError {
            meta: generic,
            kind: crate::error::ImportServerCatalogErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoConnectorsAvailableException" => crate::error::ImportServerCatalogError {
            meta: generic,
            kind: crate::error::ImportServerCatalogErrorKind::NoConnectorsAvailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_connectors_available_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_no_connectors_available_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ImportServerCatalogError {
            meta: generic,
            kind: crate::error::ImportServerCatalogErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::ImportServerCatalogError {
            meta: generic,
            kind: crate::error::ImportServerCatalogErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportServerCatalogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportServerCatalogError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_server_catalog_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ImportServerCatalogOutput,
    crate::error::ImportServerCatalogError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_server_catalog_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_launch_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LaunchAppOutput, crate::error::LaunchAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::LaunchAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::LaunchAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::LaunchAppError {
            meta: generic,
            kind: crate::error::LaunchAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::LaunchAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::LaunchAppError {
            meta: generic,
            kind: crate::error::LaunchAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LaunchAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::LaunchAppError {
            meta: generic,
            kind: crate::error::LaunchAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LaunchAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::LaunchAppError {
            meta: generic,
            kind: crate::error::LaunchAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LaunchAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::LaunchAppError {
            meta: generic,
            kind: crate::error::LaunchAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::LaunchAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::LaunchAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_launch_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::LaunchAppOutput, crate::error::LaunchAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::launch_app_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_apps_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAppsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAppsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::ListAppsError {
            meta: generic,
            kind: crate::error::ListAppsErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::ListAppsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListAppsError {
            meta: generic,
            kind: crate::error::ListAppsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAppsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::ListAppsError {
            meta: generic,
            kind: crate::error::ListAppsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAppsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::ListAppsError {
            meta: generic,
            kind: crate::error::ListAppsErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAppsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::ListAppsError {
            meta: generic,
            kind: crate::error::ListAppsErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAppsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAppsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_apps_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_apps_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_apps(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAppsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_app_validation_output_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::NotifyAppValidationOutputOutput,
    crate::error::NotifyAppValidationOutputError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::NotifyAppValidationOutputError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::NotifyAppValidationOutputError {
            meta: generic,
            kind: crate::error::NotifyAppValidationOutputErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::NotifyAppValidationOutputError {
            meta: generic,
            kind: crate::error::NotifyAppValidationOutputErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::NotifyAppValidationOutputError {
            meta: generic,
            kind:
                crate::error::NotifyAppValidationOutputErrorKind::MissingRequiredParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "OperationNotPermittedException" => crate::error::NotifyAppValidationOutputError {
            meta: generic,
            kind: crate::error::NotifyAppValidationOutputErrorKind::OperationNotPermittedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_permitted_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedOperationException" => crate::error::NotifyAppValidationOutputError {
            meta: generic,
            kind: crate::error::NotifyAppValidationOutputErrorKind::UnauthorizedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthorized_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::NotifyAppValidationOutputError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::NotifyAppValidationOutputError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_notify_app_validation_output_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::NotifyAppValidationOutputOutput,
    crate::error::NotifyAppValidationOutputError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::notify_app_validation_output_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_launch_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppLaunchConfigurationOutput,
    crate::error::PutAppLaunchConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutAppLaunchConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::PutAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::PutAppLaunchConfigurationErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::PutAppLaunchConfigurationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::PutAppLaunchConfigurationError {
            meta: generic,
            kind:
                crate::error::PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "OperationNotPermittedException" => crate::error::PutAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::PutAppLaunchConfigurationErrorKind::OperationNotPermittedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_not_permitted_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedOperationException" => crate::error::PutAppLaunchConfigurationError {
            meta: generic,
            kind: crate::error::PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthorized_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppLaunchConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::PutAppLaunchConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_launch_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppLaunchConfigurationOutput,
    crate::error::PutAppLaunchConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_app_launch_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_replication_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppReplicationConfigurationOutput,
    crate::error::PutAppReplicationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAppReplicationConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::PutAppReplicationConfigurationError { meta: generic, kind: crate::error::PutAppReplicationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::PutAppReplicationConfigurationError { meta: generic, kind: crate::error::PutAppReplicationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::PutAppReplicationConfigurationError { meta: generic, kind: crate::error::PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::PutAppReplicationConfigurationError { meta: generic, kind: crate::error::PutAppReplicationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::PutAppReplicationConfigurationError { meta: generic, kind: crate::error::PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppReplicationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutAppReplicationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_replication_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppReplicationConfigurationOutput,
    crate::error::PutAppReplicationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_app_replication_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_validation_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppValidationConfigurationOutput,
    crate::error::PutAppValidationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutAppValidationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::PutAppValidationConfigurationError { meta: generic, kind: crate::error::PutAppValidationConfigurationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::PutAppValidationConfigurationError { meta: generic, kind: crate::error::PutAppValidationConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::PutAppValidationConfigurationError { meta: generic, kind: crate::error::PutAppValidationConfigurationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::PutAppValidationConfigurationError { meta: generic, kind: crate::error::PutAppValidationConfigurationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::PutAppValidationConfigurationError { meta: generic, kind: crate::error::PutAppValidationConfigurationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAppValidationConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutAppValidationConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_app_validation_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAppValidationConfigurationOutput,
    crate::error::PutAppValidationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_app_validation_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_app_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAppReplicationOutput,
    crate::error::StartAppReplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartAppReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartAppReplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::StartAppReplicationError {
            meta: generic,
            kind: crate::error::StartAppReplicationErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::StartAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartAppReplicationError {
            meta: generic,
            kind: crate::error::StartAppReplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::StartAppReplicationError {
            meta: generic,
            kind: crate::error::StartAppReplicationErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StartAppReplicationError {
            meta: generic,
            kind: crate::error::StartAppReplicationErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::StartAppReplicationError {
            meta: generic,
            kind: crate::error::StartAppReplicationErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartAppReplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_app_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAppReplicationOutput,
    crate::error::StartAppReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_app_replication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_on_demand_app_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartOnDemandAppReplicationOutput,
    crate::error::StartOnDemandAppReplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartOnDemandAppReplicationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::StartOnDemandAppReplicationError { meta: generic, kind: crate::error::StartOnDemandAppReplicationErrorKind::InternalError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_error_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::StartOnDemandAppReplicationError { meta: generic, kind: crate::error::StartOnDemandAppReplicationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::StartOnDemandAppReplicationError { meta: generic, kind: crate::error::StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::StartOnDemandAppReplicationError { meta: generic, kind: crate::error::StartOnDemandAppReplicationErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::StartOnDemandAppReplicationError { meta: generic, kind: crate::error::StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandAppReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartOnDemandAppReplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_on_demand_app_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartOnDemandAppReplicationOutput,
    crate::error::StartOnDemandAppReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_on_demand_app_replication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_on_demand_replication_run_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartOnDemandReplicationRunOutput,
    crate::error::StartOnDemandReplicationRunError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartOnDemandReplicationRunError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DryRunOperationException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::DryRunOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dry_run_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dry_run_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MissingRequiredParameterException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationNotPermittedException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::OperationNotPermittedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReplicationRunLimitExceededException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::replication_run_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_run_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperationException" => crate::error::StartOnDemandReplicationRunError { meta: generic, kind: crate::error::StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartOnDemandReplicationRunError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_on_demand_replication_run_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartOnDemandReplicationRunOutput,
    crate::error::StartOnDemandReplicationRunError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_on_demand_replication_run_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_start_on_demand_replication_run(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::StartOnDemandReplicationRunError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_app_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopAppReplicationOutput,
    crate::error::StopAppReplicationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopAppReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopAppReplicationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::StopAppReplicationError {
            meta: generic,
            kind: crate::error::StopAppReplicationErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::StopAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopAppReplicationError {
            meta: generic,
            kind: crate::error::StopAppReplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::StopAppReplicationError {
            meta: generic,
            kind: crate::error::StopAppReplicationErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::StopAppReplicationError {
            meta: generic,
            kind: crate::error::StopAppReplicationErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::StopAppReplicationError {
            meta: generic,
            kind: crate::error::StopAppReplicationErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopAppReplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopAppReplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_app_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopAppReplicationOutput,
    crate::error::StopAppReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_app_replication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TerminateAppOutput, crate::error::TerminateAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TerminateAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TerminateAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::TerminateAppError {
            meta: generic,
            kind: crate::error::TerminateAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::TerminateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::TerminateAppError {
            meta: generic,
            kind: crate::error::TerminateAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::TerminateAppError {
            meta: generic,
            kind: crate::error::TerminateAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::TerminateAppError {
            meta: generic,
            kind: crate::error::TerminateAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::TerminateAppError {
            meta: generic,
            kind: crate::error::TerminateAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TerminateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TerminateAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_terminate_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TerminateAppOutput, crate::error::TerminateAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::terminate_app_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_app_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAppError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAppError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::UpdateAppError {
            meta: generic,
            kind: crate::error::UpdateAppErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateAppError {
            meta: generic,
            kind: crate::error::UpdateAppErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::UpdateAppError {
            meta: generic,
            kind: crate::error::UpdateAppErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::UpdateAppError {
            meta: generic,
            kind: crate::error::UpdateAppErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::UpdateAppError {
            meta: generic,
            kind: crate::error::UpdateAppErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAppError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAppError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_app_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_app_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_app(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAppError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_replication_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateReplicationJobOutput,
    crate::error::UpdateReplicationJobError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateReplicationJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateReplicationJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalError" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::InternalError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_internal_error_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameterException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationNotPermittedException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::OperationNotPermittedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::operation_not_permitted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_not_permitted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicationJobNotFoundException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::ReplicationJobNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replication_job_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replication_job_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerCannotBeReplicatedException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::server_cannot_be_replicated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_cannot_be_replicated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TemporarilyUnavailableException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::TemporarilyUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::temporarily_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_temporarily_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperationException" => crate::error::UpdateReplicationJobError {
            meta: generic,
            kind: crate::error::UpdateReplicationJobErrorKind::UnauthorizedOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthorized_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateReplicationJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateReplicationJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_replication_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateReplicationJobOutput,
    crate::error::UpdateReplicationJobError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_replication_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}
