// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_job`](crate::client::Client::create_replication_job).
///
/// See [`crate::client::fluent_builders::CreateReplicationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationJob {
    _private: (),
}
impl CreateReplicationJob {
    /// Creates a new builder-style object to manufacture [`CreateReplicationJobInput`](crate::input::CreateReplicationJobInput)
    pub fn builder() -> crate::input::create_replication_job_input::Builder {
        crate::input::create_replication_job_input::Builder::default()
    }
    /// Creates a new `CreateReplicationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationJob {
    type Output = std::result::Result<
        crate::output::CreateReplicationJobOutput,
        crate::error::CreateReplicationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_job_error(response)
        } else {
            crate::operation_deser::parse_create_replication_job_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteAppLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_launch_configuration`](crate::client::Client::delete_app_launch_configuration).
///
/// See [`crate::client::fluent_builders::DeleteAppLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppLaunchConfiguration {
    _private: (),
}
impl DeleteAppLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteAppLaunchConfigurationInput`](crate::input::DeleteAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::delete_app_launch_configuration_input::Builder {
        crate::input::delete_app_launch_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteAppLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteAppLaunchConfigurationOutput,
        crate::error::DeleteAppLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_app_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteAppReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_replication_configuration`](crate::client::Client::delete_app_replication_configuration).
///
/// See [`crate::client::fluent_builders::DeleteAppReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppReplicationConfiguration {
    _private: (),
}
impl DeleteAppReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteAppReplicationConfigurationInput`](crate::input::DeleteAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::delete_app_replication_configuration_input::Builder {
        crate::input::delete_app_replication_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteAppReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteAppReplicationConfigurationOutput,
        crate::error::DeleteAppReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_app_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteAppValidationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_validation_configuration`](crate::client::Client::delete_app_validation_configuration).
///
/// See [`crate::client::fluent_builders::DeleteAppValidationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppValidationConfiguration {
    _private: (),
}
impl DeleteAppValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteAppValidationConfigurationInput`](crate::input::DeleteAppValidationConfigurationInput)
    pub fn builder() -> crate::input::delete_app_validation_configuration_input::Builder {
        crate::input::delete_app_validation_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteAppValidationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppValidationConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteAppValidationConfigurationOutput,
        crate::error::DeleteAppValidationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_validation_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_app_validation_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_job`](crate::client::Client::delete_replication_job).
///
/// See [`crate::client::fluent_builders::DeleteReplicationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationJob {
    _private: (),
}
impl DeleteReplicationJob {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationJobInput`](crate::input::DeleteReplicationJobInput)
    pub fn builder() -> crate::input::delete_replication_job_input::Builder {
        crate::input::delete_replication_job_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationJob {
    type Output = std::result::Result<
        crate::output::DeleteReplicationJobOutput,
        crate::error::DeleteReplicationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_job_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_job_response(response)
        }
    }
}

/// Operation shape for `DeleteServerCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_server_catalog`](crate::client::Client::delete_server_catalog).
///
/// See [`crate::client::fluent_builders::DeleteServerCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServerCatalog {
    _private: (),
}
impl DeleteServerCatalog {
    /// Creates a new builder-style object to manufacture [`DeleteServerCatalogInput`](crate::input::DeleteServerCatalogInput)
    pub fn builder() -> crate::input::delete_server_catalog_input::Builder {
        crate::input::delete_server_catalog_input::Builder::default()
    }
    /// Creates a new `DeleteServerCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServerCatalog {
    type Output = std::result::Result<
        crate::output::DeleteServerCatalogOutput,
        crate::error::DeleteServerCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_server_catalog_error(response)
        } else {
            crate::operation_deser::parse_delete_server_catalog_response(response)
        }
    }
}

/// Operation shape for `DisassociateConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_connector`](crate::client::Client::disassociate_connector).
///
/// See [`crate::client::fluent_builders::DisassociateConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateConnector {
    _private: (),
}
impl DisassociateConnector {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectorInput`](crate::input::DisassociateConnectorInput)
    pub fn builder() -> crate::input::disassociate_connector_input::Builder {
        crate::input::disassociate_connector_input::Builder::default()
    }
    /// Creates a new `DisassociateConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateConnector {
    type Output = std::result::Result<
        crate::output::DisassociateConnectorOutput,
        crate::error::DisassociateConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_connector_error(response)
        } else {
            crate::operation_deser::parse_disassociate_connector_response(response)
        }
    }
}

/// Operation shape for `GenerateChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_change_set`](crate::client::Client::generate_change_set).
///
/// See [`crate::client::fluent_builders::GenerateChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateChangeSet {
    _private: (),
}
impl GenerateChangeSet {
    /// Creates a new builder-style object to manufacture [`GenerateChangeSetInput`](crate::input::GenerateChangeSetInput)
    pub fn builder() -> crate::input::generate_change_set_input::Builder {
        crate::input::generate_change_set_input::Builder::default()
    }
    /// Creates a new `GenerateChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateChangeSet {
    type Output = std::result::Result<
        crate::output::GenerateChangeSetOutput,
        crate::error::GenerateChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_change_set_error(response)
        } else {
            crate::operation_deser::parse_generate_change_set_response(response)
        }
    }
}

/// Operation shape for `GenerateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`generate_template`](crate::client::Client::generate_template).
///
/// See [`crate::client::fluent_builders::GenerateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GenerateTemplate {
    _private: (),
}
impl GenerateTemplate {
    /// Creates a new builder-style object to manufacture [`GenerateTemplateInput`](crate::input::GenerateTemplateInput)
    pub fn builder() -> crate::input::generate_template_input::Builder {
        crate::input::generate_template_input::Builder::default()
    }
    /// Creates a new `GenerateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GenerateTemplate {
    type Output = std::result::Result<
        crate::output::GenerateTemplateOutput,
        crate::error::GenerateTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_generate_template_error(response)
        } else {
            crate::operation_deser::parse_generate_template_response(response)
        }
    }
}

/// Operation shape for `GetApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app`](crate::client::Client::get_app).
///
/// See [`crate::client::fluent_builders::GetApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApp {
    _private: (),
}
impl GetApp {
    /// Creates a new builder-style object to manufacture [`GetAppInput`](crate::input::GetAppInput)
    pub fn builder() -> crate::input::get_app_input::Builder {
        crate::input::get_app_input::Builder::default()
    }
    /// Creates a new `GetApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApp {
    type Output = std::result::Result<crate::output::GetAppOutput, crate::error::GetAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_error(response)
        } else {
            crate::operation_deser::parse_get_app_response(response)
        }
    }
}

/// Operation shape for `GetAppLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_launch_configuration`](crate::client::Client::get_app_launch_configuration).
///
/// See [`crate::client::fluent_builders::GetAppLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppLaunchConfiguration {
    _private: (),
}
impl GetAppLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`GetAppLaunchConfigurationInput`](crate::input::GetAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::get_app_launch_configuration_input::Builder {
        crate::input::get_app_launch_configuration_input::Builder::default()
    }
    /// Creates a new `GetAppLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::GetAppLaunchConfigurationOutput,
        crate::error::GetAppLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_app_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `GetAppReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_replication_configuration`](crate::client::Client::get_app_replication_configuration).
///
/// See [`crate::client::fluent_builders::GetAppReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppReplicationConfiguration {
    _private: (),
}
impl GetAppReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetAppReplicationConfigurationInput`](crate::input::GetAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::get_app_replication_configuration_input::Builder {
        crate::input::get_app_replication_configuration_input::Builder::default()
    }
    /// Creates a new `GetAppReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::GetAppReplicationConfigurationOutput,
        crate::error::GetAppReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_app_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `GetAppValidationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_validation_configuration`](crate::client::Client::get_app_validation_configuration).
///
/// See [`crate::client::fluent_builders::GetAppValidationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppValidationConfiguration {
    _private: (),
}
impl GetAppValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetAppValidationConfigurationInput`](crate::input::GetAppValidationConfigurationInput)
    pub fn builder() -> crate::input::get_app_validation_configuration_input::Builder {
        crate::input::get_app_validation_configuration_input::Builder::default()
    }
    /// Creates a new `GetAppValidationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppValidationConfiguration {
    type Output = std::result::Result<
        crate::output::GetAppValidationConfigurationOutput,
        crate::error::GetAppValidationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_validation_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_app_validation_configuration_response(response)
        }
    }
}

/// Operation shape for `GetAppValidationOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_app_validation_output`](crate::client::Client::get_app_validation_output).
///
/// See [`crate::client::fluent_builders::GetAppValidationOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAppValidationOutput {
    _private: (),
}
impl GetAppValidationOutput {
    /// Creates a new builder-style object to manufacture [`GetAppValidationOutputInput`](crate::input::GetAppValidationOutputInput)
    pub fn builder() -> crate::input::get_app_validation_output_input::Builder {
        crate::input::get_app_validation_output_input::Builder::default()
    }
    /// Creates a new `GetAppValidationOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAppValidationOutput {
    type Output = std::result::Result<
        crate::output::GetAppValidationOutputOutput,
        crate::error::GetAppValidationOutputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_app_validation_output_error(response)
        } else {
            crate::operation_deser::parse_get_app_validation_output_response(response)
        }
    }
}

/// Operation shape for `GetConnectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connectors`](crate::client::Client::get_connectors).
///
/// See [`crate::client::fluent_builders::GetConnectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectors {
    _private: (),
}
impl GetConnectors {
    /// Creates a new builder-style object to manufacture [`GetConnectorsInput`](crate::input::GetConnectorsInput)
    pub fn builder() -> crate::input::get_connectors_input::Builder {
        crate::input::get_connectors_input::Builder::default()
    }
    /// Creates a new `GetConnectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectors {
    type Output =
        std::result::Result<crate::output::GetConnectorsOutput, crate::error::GetConnectorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connectors_error(response)
        } else {
            crate::operation_deser::parse_get_connectors_response(response)
        }
    }
}

/// Operation shape for `GetReplicationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_replication_jobs`](crate::client::Client::get_replication_jobs).
///
/// See [`crate::client::fluent_builders::GetReplicationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReplicationJobs {
    _private: (),
}
impl GetReplicationJobs {
    /// Creates a new builder-style object to manufacture [`GetReplicationJobsInput`](crate::input::GetReplicationJobsInput)
    pub fn builder() -> crate::input::get_replication_jobs_input::Builder {
        crate::input::get_replication_jobs_input::Builder::default()
    }
    /// Creates a new `GetReplicationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReplicationJobs {
    type Output = std::result::Result<
        crate::output::GetReplicationJobsOutput,
        crate::error::GetReplicationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_replication_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_replication_jobs_response(response)
        }
    }
}

/// Operation shape for `GetReplicationRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_replication_runs`](crate::client::Client::get_replication_runs).
///
/// See [`crate::client::fluent_builders::GetReplicationRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReplicationRuns {
    _private: (),
}
impl GetReplicationRuns {
    /// Creates a new builder-style object to manufacture [`GetReplicationRunsInput`](crate::input::GetReplicationRunsInput)
    pub fn builder() -> crate::input::get_replication_runs_input::Builder {
        crate::input::get_replication_runs_input::Builder::default()
    }
    /// Creates a new `GetReplicationRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReplicationRuns {
    type Output = std::result::Result<
        crate::output::GetReplicationRunsOutput,
        crate::error::GetReplicationRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_replication_runs_error(response)
        } else {
            crate::operation_deser::parse_get_replication_runs_response(response)
        }
    }
}

/// Operation shape for `GetServers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_servers`](crate::client::Client::get_servers).
///
/// See [`crate::client::fluent_builders::GetServers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServers {
    _private: (),
}
impl GetServers {
    /// Creates a new builder-style object to manufacture [`GetServersInput`](crate::input::GetServersInput)
    pub fn builder() -> crate::input::get_servers_input::Builder {
        crate::input::get_servers_input::Builder::default()
    }
    /// Creates a new `GetServers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServers {
    type Output =
        std::result::Result<crate::output::GetServersOutput, crate::error::GetServersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_servers_error(response)
        } else {
            crate::operation_deser::parse_get_servers_response(response)
        }
    }
}

/// Operation shape for `ImportAppCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_app_catalog`](crate::client::Client::import_app_catalog).
///
/// See [`crate::client::fluent_builders::ImportAppCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportAppCatalog {
    _private: (),
}
impl ImportAppCatalog {
    /// Creates a new builder-style object to manufacture [`ImportAppCatalogInput`](crate::input::ImportAppCatalogInput)
    pub fn builder() -> crate::input::import_app_catalog_input::Builder {
        crate::input::import_app_catalog_input::Builder::default()
    }
    /// Creates a new `ImportAppCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportAppCatalog {
    type Output = std::result::Result<
        crate::output::ImportAppCatalogOutput,
        crate::error::ImportAppCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_app_catalog_error(response)
        } else {
            crate::operation_deser::parse_import_app_catalog_response(response)
        }
    }
}

/// Operation shape for `ImportServerCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_server_catalog`](crate::client::Client::import_server_catalog).
///
/// See [`crate::client::fluent_builders::ImportServerCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportServerCatalog {
    _private: (),
}
impl ImportServerCatalog {
    /// Creates a new builder-style object to manufacture [`ImportServerCatalogInput`](crate::input::ImportServerCatalogInput)
    pub fn builder() -> crate::input::import_server_catalog_input::Builder {
        crate::input::import_server_catalog_input::Builder::default()
    }
    /// Creates a new `ImportServerCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportServerCatalog {
    type Output = std::result::Result<
        crate::output::ImportServerCatalogOutput,
        crate::error::ImportServerCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_server_catalog_error(response)
        } else {
            crate::operation_deser::parse_import_server_catalog_response(response)
        }
    }
}

/// Operation shape for `LaunchApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`launch_app`](crate::client::Client::launch_app).
///
/// See [`crate::client::fluent_builders::LaunchApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct LaunchApp {
    _private: (),
}
impl LaunchApp {
    /// Creates a new builder-style object to manufacture [`LaunchAppInput`](crate::input::LaunchAppInput)
    pub fn builder() -> crate::input::launch_app_input::Builder {
        crate::input::launch_app_input::Builder::default()
    }
    /// Creates a new `LaunchApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for LaunchApp {
    type Output = std::result::Result<crate::output::LaunchAppOutput, crate::error::LaunchAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_launch_app_error(response)
        } else {
            crate::operation_deser::parse_launch_app_response(response)
        }
    }
}

/// Operation shape for `ListApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_apps`](crate::client::Client::list_apps).
///
/// See [`crate::client::fluent_builders::ListApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApps {
    _private: (),
}
impl ListApps {
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
    /// Creates a new `ListApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApps {
    type Output = std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_apps_error(response)
        } else {
            crate::operation_deser::parse_list_apps_response(response)
        }
    }
}

/// Operation shape for `NotifyAppValidationOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`notify_app_validation_output`](crate::client::Client::notify_app_validation_output).
///
/// See [`crate::client::fluent_builders::NotifyAppValidationOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct NotifyAppValidationOutput {
    _private: (),
}
impl NotifyAppValidationOutput {
    /// Creates a new builder-style object to manufacture [`NotifyAppValidationOutputInput`](crate::input::NotifyAppValidationOutputInput)
    pub fn builder() -> crate::input::notify_app_validation_output_input::Builder {
        crate::input::notify_app_validation_output_input::Builder::default()
    }
    /// Creates a new `NotifyAppValidationOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for NotifyAppValidationOutput {
    type Output = std::result::Result<
        crate::output::NotifyAppValidationOutputOutput,
        crate::error::NotifyAppValidationOutputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_notify_app_validation_output_error(response)
        } else {
            crate::operation_deser::parse_notify_app_validation_output_response(response)
        }
    }
}

/// Operation shape for `PutAppLaunchConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_app_launch_configuration`](crate::client::Client::put_app_launch_configuration).
///
/// See [`crate::client::fluent_builders::PutAppLaunchConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppLaunchConfiguration {
    _private: (),
}
impl PutAppLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`PutAppLaunchConfigurationInput`](crate::input::PutAppLaunchConfigurationInput)
    pub fn builder() -> crate::input::put_app_launch_configuration_input::Builder {
        crate::input::put_app_launch_configuration_input::Builder::default()
    }
    /// Creates a new `PutAppLaunchConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppLaunchConfiguration {
    type Output = std::result::Result<
        crate::output::PutAppLaunchConfigurationOutput,
        crate::error::PutAppLaunchConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_app_launch_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_app_launch_configuration_response(response)
        }
    }
}

/// Operation shape for `PutAppReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_app_replication_configuration`](crate::client::Client::put_app_replication_configuration).
///
/// See [`crate::client::fluent_builders::PutAppReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppReplicationConfiguration {
    _private: (),
}
impl PutAppReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutAppReplicationConfigurationInput`](crate::input::PutAppReplicationConfigurationInput)
    pub fn builder() -> crate::input::put_app_replication_configuration_input::Builder {
        crate::input::put_app_replication_configuration_input::Builder::default()
    }
    /// Creates a new `PutAppReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::PutAppReplicationConfigurationOutput,
        crate::error::PutAppReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_app_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_app_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `PutAppValidationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_app_validation_configuration`](crate::client::Client::put_app_validation_configuration).
///
/// See [`crate::client::fluent_builders::PutAppValidationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAppValidationConfiguration {
    _private: (),
}
impl PutAppValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutAppValidationConfigurationInput`](crate::input::PutAppValidationConfigurationInput)
    pub fn builder() -> crate::input::put_app_validation_configuration_input::Builder {
        crate::input::put_app_validation_configuration_input::Builder::default()
    }
    /// Creates a new `PutAppValidationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAppValidationConfiguration {
    type Output = std::result::Result<
        crate::output::PutAppValidationConfigurationOutput,
        crate::error::PutAppValidationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_app_validation_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_app_validation_configuration_response(response)
        }
    }
}

/// Operation shape for `StartAppReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_app_replication`](crate::client::Client::start_app_replication).
///
/// See [`crate::client::fluent_builders::StartAppReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAppReplication {
    _private: (),
}
impl StartAppReplication {
    /// Creates a new builder-style object to manufacture [`StartAppReplicationInput`](crate::input::StartAppReplicationInput)
    pub fn builder() -> crate::input::start_app_replication_input::Builder {
        crate::input::start_app_replication_input::Builder::default()
    }
    /// Creates a new `StartAppReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAppReplication {
    type Output = std::result::Result<
        crate::output::StartAppReplicationOutput,
        crate::error::StartAppReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_app_replication_error(response)
        } else {
            crate::operation_deser::parse_start_app_replication_response(response)
        }
    }
}

/// Operation shape for `StartOnDemandAppReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_on_demand_app_replication`](crate::client::Client::start_on_demand_app_replication).
///
/// See [`crate::client::fluent_builders::StartOnDemandAppReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartOnDemandAppReplication {
    _private: (),
}
impl StartOnDemandAppReplication {
    /// Creates a new builder-style object to manufacture [`StartOnDemandAppReplicationInput`](crate::input::StartOnDemandAppReplicationInput)
    pub fn builder() -> crate::input::start_on_demand_app_replication_input::Builder {
        crate::input::start_on_demand_app_replication_input::Builder::default()
    }
    /// Creates a new `StartOnDemandAppReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartOnDemandAppReplication {
    type Output = std::result::Result<
        crate::output::StartOnDemandAppReplicationOutput,
        crate::error::StartOnDemandAppReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_on_demand_app_replication_error(response)
        } else {
            crate::operation_deser::parse_start_on_demand_app_replication_response(response)
        }
    }
}

/// Operation shape for `StartOnDemandReplicationRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_on_demand_replication_run`](crate::client::Client::start_on_demand_replication_run).
///
/// See [`crate::client::fluent_builders::StartOnDemandReplicationRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartOnDemandReplicationRun {
    _private: (),
}
impl StartOnDemandReplicationRun {
    /// Creates a new builder-style object to manufacture [`StartOnDemandReplicationRunInput`](crate::input::StartOnDemandReplicationRunInput)
    pub fn builder() -> crate::input::start_on_demand_replication_run_input::Builder {
        crate::input::start_on_demand_replication_run_input::Builder::default()
    }
    /// Creates a new `StartOnDemandReplicationRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartOnDemandReplicationRun {
    type Output = std::result::Result<
        crate::output::StartOnDemandReplicationRunOutput,
        crate::error::StartOnDemandReplicationRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_on_demand_replication_run_error(response)
        } else {
            crate::operation_deser::parse_start_on_demand_replication_run_response(response)
        }
    }
}

/// Operation shape for `StopAppReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_app_replication`](crate::client::Client::stop_app_replication).
///
/// See [`crate::client::fluent_builders::StopAppReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopAppReplication {
    _private: (),
}
impl StopAppReplication {
    /// Creates a new builder-style object to manufacture [`StopAppReplicationInput`](crate::input::StopAppReplicationInput)
    pub fn builder() -> crate::input::stop_app_replication_input::Builder {
        crate::input::stop_app_replication_input::Builder::default()
    }
    /// Creates a new `StopAppReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopAppReplication {
    type Output = std::result::Result<
        crate::output::StopAppReplicationOutput,
        crate::error::StopAppReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_app_replication_error(response)
        } else {
            crate::operation_deser::parse_stop_app_replication_response(response)
        }
    }
}

/// Operation shape for `TerminateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_app`](crate::client::Client::terminate_app).
///
/// See [`crate::client::fluent_builders::TerminateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateApp {
    _private: (),
}
impl TerminateApp {
    /// Creates a new builder-style object to manufacture [`TerminateAppInput`](crate::input::TerminateAppInput)
    pub fn builder() -> crate::input::terminate_app_input::Builder {
        crate::input::terminate_app_input::Builder::default()
    }
    /// Creates a new `TerminateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateApp {
    type Output =
        std::result::Result<crate::output::TerminateAppOutput, crate::error::TerminateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_app_error(response)
        } else {
            crate::operation_deser::parse_terminate_app_response(response)
        }
    }
}

/// Operation shape for `UpdateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app`](crate::client::Client::update_app).
///
/// See [`crate::client::fluent_builders::UpdateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApp {
    _private: (),
}
impl UpdateApp {
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
    /// Creates a new `UpdateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApp {
    type Output = std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_error(response)
        } else {
            crate::operation_deser::parse_update_app_response(response)
        }
    }
}

/// Operation shape for `UpdateReplicationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_replication_job`](crate::client::Client::update_replication_job).
///
/// See [`crate::client::fluent_builders::UpdateReplicationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReplicationJob {
    _private: (),
}
impl UpdateReplicationJob {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationJobInput`](crate::input::UpdateReplicationJobInput)
    pub fn builder() -> crate::input::update_replication_job_input::Builder {
        crate::input::update_replication_job_input::Builder::default()
    }
    /// Creates a new `UpdateReplicationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReplicationJob {
    type Output = std::result::Result<
        crate::output::UpdateReplicationJobOutput,
        crate::error::UpdateReplicationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_replication_job_error(response)
        } else {
            crate::operation_deser::parse_update_replication_job_response(response)
        }
    }
}
