// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Server Migration Service
///
/// Client for invoking operations on AWS Server Migration Service. Each operation on AWS Server Migration Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_sms::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_sms::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_sms::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApp` operation.
    ///
    /// See [`CreateApp`](crate::client::fluent_builders::CreateApp) for more information about the
    /// operation and its arguments.
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplicationJob` operation.
    ///
    /// See [`CreateReplicationJob`](crate::client::fluent_builders::CreateReplicationJob) for more information about the
    /// operation and its arguments.
    pub fn create_replication_job(&self) -> fluent_builders::CreateReplicationJob<C, M, R> {
        fluent_builders::CreateReplicationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApp` operation.
    ///
    /// See [`DeleteApp`](crate::client::fluent_builders::DeleteApp) for more information about the
    /// operation and its arguments.
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppLaunchConfiguration` operation.
    ///
    /// See [`DeleteAppLaunchConfiguration`](crate::client::fluent_builders::DeleteAppLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_app_launch_configuration(
        &self,
    ) -> fluent_builders::DeleteAppLaunchConfiguration<C, M, R> {
        fluent_builders::DeleteAppLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppReplicationConfiguration` operation.
    ///
    /// See [`DeleteAppReplicationConfiguration`](crate::client::fluent_builders::DeleteAppReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_app_replication_configuration(
        &self,
    ) -> fluent_builders::DeleteAppReplicationConfiguration<C, M, R> {
        fluent_builders::DeleteAppReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppValidationConfiguration` operation.
    ///
    /// See [`DeleteAppValidationConfiguration`](crate::client::fluent_builders::DeleteAppValidationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_app_validation_configuration(
        &self,
    ) -> fluent_builders::DeleteAppValidationConfiguration<C, M, R> {
        fluent_builders::DeleteAppValidationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationJob` operation.
    ///
    /// See [`DeleteReplicationJob`](crate::client::fluent_builders::DeleteReplicationJob) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_job(&self) -> fluent_builders::DeleteReplicationJob<C, M, R> {
        fluent_builders::DeleteReplicationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServerCatalog` operation.
    ///
    /// See [`DeleteServerCatalog`](crate::client::fluent_builders::DeleteServerCatalog) for more information about the
    /// operation and its arguments.
    pub fn delete_server_catalog(&self) -> fluent_builders::DeleteServerCatalog<C, M, R> {
        fluent_builders::DeleteServerCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateConnector` operation.
    ///
    /// See [`DisassociateConnector`](crate::client::fluent_builders::DisassociateConnector) for more information about the
    /// operation and its arguments.
    pub fn disassociate_connector(&self) -> fluent_builders::DisassociateConnector<C, M, R> {
        fluent_builders::DisassociateConnector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateChangeSet` operation.
    ///
    /// See [`GenerateChangeSet`](crate::client::fluent_builders::GenerateChangeSet) for more information about the
    /// operation and its arguments.
    pub fn generate_change_set(&self) -> fluent_builders::GenerateChangeSet<C, M, R> {
        fluent_builders::GenerateChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateTemplate` operation.
    ///
    /// See [`GenerateTemplate`](crate::client::fluent_builders::GenerateTemplate) for more information about the
    /// operation and its arguments.
    pub fn generate_template(&self) -> fluent_builders::GenerateTemplate<C, M, R> {
        fluent_builders::GenerateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApp` operation.
    ///
    /// See [`GetApp`](crate::client::fluent_builders::GetApp) for more information about the
    /// operation and its arguments.
    pub fn get_app(&self) -> fluent_builders::GetApp<C, M, R> {
        fluent_builders::GetApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppLaunchConfiguration` operation.
    ///
    /// See [`GetAppLaunchConfiguration`](crate::client::fluent_builders::GetAppLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_app_launch_configuration(
        &self,
    ) -> fluent_builders::GetAppLaunchConfiguration<C, M, R> {
        fluent_builders::GetAppLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppReplicationConfiguration` operation.
    ///
    /// See [`GetAppReplicationConfiguration`](crate::client::fluent_builders::GetAppReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_app_replication_configuration(
        &self,
    ) -> fluent_builders::GetAppReplicationConfiguration<C, M, R> {
        fluent_builders::GetAppReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppValidationConfiguration` operation.
    ///
    /// See [`GetAppValidationConfiguration`](crate::client::fluent_builders::GetAppValidationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_app_validation_configuration(
        &self,
    ) -> fluent_builders::GetAppValidationConfiguration<C, M, R> {
        fluent_builders::GetAppValidationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAppValidationOutput` operation.
    ///
    /// See [`GetAppValidationOutput`](crate::client::fluent_builders::GetAppValidationOutput) for more information about the
    /// operation and its arguments.
    pub fn get_app_validation_output(&self) -> fluent_builders::GetAppValidationOutput<C, M, R> {
        fluent_builders::GetAppValidationOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectors` operation.
    ///
    /// See [`GetConnectors`](crate::client::fluent_builders::GetConnectors) for more information about the
    /// operation and its arguments.
    pub fn get_connectors(&self) -> fluent_builders::GetConnectors<C, M, R> {
        fluent_builders::GetConnectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReplicationJobs` operation.
    ///
    /// See [`GetReplicationJobs`](crate::client::fluent_builders::GetReplicationJobs) for more information about the
    /// operation and its arguments.
    pub fn get_replication_jobs(&self) -> fluent_builders::GetReplicationJobs<C, M, R> {
        fluent_builders::GetReplicationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReplicationRuns` operation.
    ///
    /// See [`GetReplicationRuns`](crate::client::fluent_builders::GetReplicationRuns) for more information about the
    /// operation and its arguments.
    pub fn get_replication_runs(&self) -> fluent_builders::GetReplicationRuns<C, M, R> {
        fluent_builders::GetReplicationRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServers` operation.
    ///
    /// See [`GetServers`](crate::client::fluent_builders::GetServers) for more information about the
    /// operation and its arguments.
    pub fn get_servers(&self) -> fluent_builders::GetServers<C, M, R> {
        fluent_builders::GetServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportAppCatalog` operation.
    ///
    /// See [`ImportAppCatalog`](crate::client::fluent_builders::ImportAppCatalog) for more information about the
    /// operation and its arguments.
    pub fn import_app_catalog(&self) -> fluent_builders::ImportAppCatalog<C, M, R> {
        fluent_builders::ImportAppCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportServerCatalog` operation.
    ///
    /// See [`ImportServerCatalog`](crate::client::fluent_builders::ImportServerCatalog) for more information about the
    /// operation and its arguments.
    pub fn import_server_catalog(&self) -> fluent_builders::ImportServerCatalog<C, M, R> {
        fluent_builders::ImportServerCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LaunchApp` operation.
    ///
    /// See [`LaunchApp`](crate::client::fluent_builders::LaunchApp) for more information about the
    /// operation and its arguments.
    pub fn launch_app(&self) -> fluent_builders::LaunchApp<C, M, R> {
        fluent_builders::LaunchApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApps` operation.
    ///
    /// See [`ListApps`](crate::client::fluent_builders::ListApps) for more information about the
    /// operation and its arguments.
    pub fn list_apps(&self) -> fluent_builders::ListApps<C, M, R> {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `NotifyAppValidationOutput` operation.
    ///
    /// See [`NotifyAppValidationOutput`](crate::client::fluent_builders::NotifyAppValidationOutput) for more information about the
    /// operation and its arguments.
    pub fn notify_app_validation_output(
        &self,
    ) -> fluent_builders::NotifyAppValidationOutput<C, M, R> {
        fluent_builders::NotifyAppValidationOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppLaunchConfiguration` operation.
    ///
    /// See [`PutAppLaunchConfiguration`](crate::client::fluent_builders::PutAppLaunchConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_app_launch_configuration(
        &self,
    ) -> fluent_builders::PutAppLaunchConfiguration<C, M, R> {
        fluent_builders::PutAppLaunchConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppReplicationConfiguration` operation.
    ///
    /// See [`PutAppReplicationConfiguration`](crate::client::fluent_builders::PutAppReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_app_replication_configuration(
        &self,
    ) -> fluent_builders::PutAppReplicationConfiguration<C, M, R> {
        fluent_builders::PutAppReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAppValidationConfiguration` operation.
    ///
    /// See [`PutAppValidationConfiguration`](crate::client::fluent_builders::PutAppValidationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_app_validation_configuration(
        &self,
    ) -> fluent_builders::PutAppValidationConfiguration<C, M, R> {
        fluent_builders::PutAppValidationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAppReplication` operation.
    ///
    /// See [`StartAppReplication`](crate::client::fluent_builders::StartAppReplication) for more information about the
    /// operation and its arguments.
    pub fn start_app_replication(&self) -> fluent_builders::StartAppReplication<C, M, R> {
        fluent_builders::StartAppReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartOnDemandAppReplication` operation.
    ///
    /// See [`StartOnDemandAppReplication`](crate::client::fluent_builders::StartOnDemandAppReplication) for more information about the
    /// operation and its arguments.
    pub fn start_on_demand_app_replication(
        &self,
    ) -> fluent_builders::StartOnDemandAppReplication<C, M, R> {
        fluent_builders::StartOnDemandAppReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartOnDemandReplicationRun` operation.
    ///
    /// See [`StartOnDemandReplicationRun`](crate::client::fluent_builders::StartOnDemandReplicationRun) for more information about the
    /// operation and its arguments.
    pub fn start_on_demand_replication_run(
        &self,
    ) -> fluent_builders::StartOnDemandReplicationRun<C, M, R> {
        fluent_builders::StartOnDemandReplicationRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopAppReplication` operation.
    ///
    /// See [`StopAppReplication`](crate::client::fluent_builders::StopAppReplication) for more information about the
    /// operation and its arguments.
    pub fn stop_app_replication(&self) -> fluent_builders::StopAppReplication<C, M, R> {
        fluent_builders::StopAppReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateApp` operation.
    ///
    /// See [`TerminateApp`](crate::client::fluent_builders::TerminateApp) for more information about the
    /// operation and its arguments.
    pub fn terminate_app(&self) -> fluent_builders::TerminateApp<C, M, R> {
        fluent_builders::TerminateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApp` operation.
    ///
    /// See [`UpdateApp`](crate::client::fluent_builders::UpdateApp) for more information about the
    /// operation and its arguments.
    pub fn update_app(&self) -> fluent_builders::UpdateApp<C, M, R> {
        fluent_builders::UpdateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReplicationJob` operation.
    ///
    /// See [`UpdateReplicationJob`](crate::client::fluent_builders::UpdateReplicationJob) for more information about the
    /// operation and its arguments.
    pub fn update_replication_job(&self) -> fluent_builders::UpdateReplicationJob<C, M, R> {
        fluent_builders::UpdateReplicationJob::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates an application. An application consists of one or more server groups. Each
    /// server group contain one or more servers.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new application.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the new application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the new application</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the new application</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the service role in the customer's account to be used by AWS SMS.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the service role in the customer's account to be used by AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of
        /// application creation.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of
        /// application creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `serverGroups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups to include in the application.</p>
        pub fn server_groups(mut self, inp: impl Into<crate::model::ServerGroup>) -> Self {
            self.inner = self.inner.server_groups(inp);
            self
        }
        /// <p>The server groups to include in the application.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.inner = self.inner.set_server_groups(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the application.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to be associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationJob`.
    ///
    /// <p>Creates a replication job. The replication job schedules periodic replication runs
    /// to replicate your server to AWS. Each replication run creates an Amazon Machine Image
    /// (AMI).</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_job_input::Builder,
    }
    impl<C, M, R> CreateReplicationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationJobInputOperationOutputAlias,
                crate::output::CreateReplicationJobOutput,
                crate::error::CreateReplicationJobError,
                crate::input::CreateReplicationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the server.</p>
        pub fn server_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(inp);
            self
        }
        /// <p>The ID of the server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>The seed replication time.</p>
        pub fn seed_replication_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.seed_replication_time(inp);
            self
        }
        /// <p>The seed replication time.</p>
        pub fn set_seed_replication_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_seed_replication_time(input);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn frequency(mut self, inp: i32) -> Self {
            self.inner = self.inner.frequency(inp);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_frequency(input);
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn run_once(mut self, inp: bool) -> Self {
            self.inner = self.inner.run_once(inp);
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn set_run_once(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_run_once(input);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn license_type(mut self, inp: crate::model::LicenseType) -> Self {
            self.inner = self.inner.license_type(inp);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.inner = self.inner.set_license_type(input);
            self
        }
        /// <p>The name of the IAM role to be used by the AWS SMS.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role to be used by the AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the
        /// maximum number is reached and a new AMI is created.</p>
        pub fn number_of_recent_amis_to_keep(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_recent_amis_to_keep(inp);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the
        /// maximum number is reached and a new AMI is created.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_number_of_recent_amis_to_keep(input);
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.encrypted(inp);
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used. </p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Deletes the specified application. Optionally deletes the launched stack associated with
    /// the application and all AWS SMS replication jobs for servers in the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>Indicates whether to stop all replication jobs corresponding to the servers
        /// in the application while deleting the application.</p>
        pub fn force_stop_app_replication(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_stop_app_replication(inp);
            self
        }
        /// <p>Indicates whether to stop all replication jobs corresponding to the servers
        /// in the application while deleting the application.</p>
        pub fn set_force_stop_app_replication(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_stop_app_replication(input);
            self
        }
        /// <p>Indicates whether to terminate the stack corresponding to the
        /// application while deleting the application.</p>
        pub fn force_terminate_app(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_terminate_app(inp);
            self
        }
        /// <p>Indicates whether to terminate the stack corresponding to the
        /// application while deleting the application.</p>
        pub fn set_force_terminate_app(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_terminate_app(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppLaunchConfiguration`.
    ///
    /// <p>Deletes the launch configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_launch_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAppLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppLaunchConfigurationInputOperationOutputAlias,
                crate::output::DeleteAppLaunchConfigurationOutput,
                crate::error::DeleteAppLaunchConfigurationError,
                crate::input::DeleteAppLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppReplicationConfiguration`.
    ///
    /// <p>Deletes the replication configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_replication_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAppReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppReplicationConfigurationInputOperationOutputAlias,
                crate::output::DeleteAppReplicationConfigurationOutput,
                crate::error::DeleteAppReplicationConfigurationError,
                crate::input::DeleteAppReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppValidationConfiguration`.
    ///
    /// <p>Deletes the validation configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAppValidationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_validation_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAppValidationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppValidationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppValidationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppValidationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppValidationConfigurationInputOperationOutputAlias,
                crate::output::DeleteAppValidationConfigurationOutput,
                crate::error::DeleteAppValidationConfigurationError,
                crate::input::DeleteAppValidationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationJob`.
    ///
    /// <p>Deletes the specified replication job.</p>
    /// <p>After you delete a replication job, there are no further replication runs. AWS
    /// deletes the contents of the Amazon S3 bucket used to store AWS SMS artifacts. The AMIs created
    /// by the replication runs are not deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_job_input::Builder,
    }
    impl<C, M, R> DeleteReplicationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationJobInputOperationOutputAlias,
                crate::output::DeleteReplicationJobOutput,
                crate::error::DeleteReplicationJobError,
                crate::input::DeleteReplicationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_job_id(inp);
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServerCatalog`.
    ///
    /// <p>Deletes all servers from your server catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServerCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_server_catalog_input::Builder,
    }
    impl<C, M, R> DeleteServerCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServerCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServerCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServerCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServerCatalogInputOperationOutputAlias,
                crate::output::DeleteServerCatalogOutput,
                crate::error::DeleteServerCatalogError,
                crate::input::DeleteServerCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateConnector`.
    ///
    /// <p>Disassociates the specified connector from AWS SMS.</p>
    /// <p>After you disassociate a connector, it is no longer available to support
    /// replication jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateConnector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_connector_input::Builder,
    }
    impl<C, M, R> DisassociateConnector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateConnector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateConnectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateConnectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateConnectorInputOperationOutputAlias,
                crate::output::DisassociateConnectorOutput,
                crate::error::DisassociateConnectorError,
                crate::input::DisassociateConnectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the connector.</p>
        pub fn connector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_id(inp);
            self
        }
        /// <p>The ID of the connector.</p>
        pub fn set_connector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_connector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateChangeSet`.
    ///
    /// <p>Generates a target change set for a currently launched stack and writes it to an Amazon S3
    /// object in the customer’s Amazon S3 bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_change_set_input::Builder,
    }
    impl<C, M, R> GenerateChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateChangeSetInputOperationOutputAlias,
                crate::output::GenerateChangeSetOutput,
                crate::error::GenerateChangeSetError,
                crate::input::GenerateChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application associated with the change set.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application associated with the change set.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The format for the change set.</p>
        pub fn changeset_format(mut self, inp: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.changeset_format(inp);
            self
        }
        /// <p>The format for the change set.</p>
        pub fn set_changeset_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_changeset_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateTemplate`.
    ///
    /// <p>Generates an AWS CloudFormation template based on the current launch configuration and writes it to
    /// an Amazon S3 object in the customer’s Amazon S3 bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_template_input::Builder,
    }
    impl<C, M, R> GenerateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateTemplateInputOperationOutputAlias,
                crate::output::GenerateTemplateOutput,
                crate::error::GenerateTemplateError,
                crate::input::GenerateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application associated with the AWS CloudFormation template.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application associated with the AWS CloudFormation template.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The format for generating the AWS CloudFormation template.</p>
        pub fn template_format(mut self, inp: crate::model::OutputFormat) -> Self {
            self.inner = self.inner.template_format(inp);
            self
        }
        /// <p>The format for generating the AWS CloudFormation template.</p>
        pub fn set_template_format(
            mut self,
            input: std::option::Option<crate::model::OutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_template_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApp`.
    ///
    /// <p>Retrieve information about the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_input::Builder,
    }
    impl<C, M, R> GetApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppInputOperationOutputAlias,
                crate::output::GetAppOutput,
                crate::error::GetAppError,
                crate::input::GetAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppLaunchConfiguration`.
    ///
    /// <p>Retrieves the application launch configuration associated with the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_launch_configuration_input::Builder,
    }
    impl<C, M, R> GetAppLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppLaunchConfigurationInputOperationOutputAlias,
                crate::output::GetAppLaunchConfigurationOutput,
                crate::error::GetAppLaunchConfigurationError,
                crate::input::GetAppLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppReplicationConfiguration`.
    ///
    /// <p>Retrieves the application replication configuration associated with the specified
    /// application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_replication_configuration_input::Builder,
    }
    impl<C, M, R> GetAppReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppReplicationConfigurationInputOperationOutputAlias,
                crate::output::GetAppReplicationConfigurationOutput,
                crate::error::GetAppReplicationConfigurationError,
                crate::input::GetAppReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppValidationConfiguration`.
    ///
    /// <p>Retrieves information about a configuration for validating an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppValidationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_validation_configuration_input::Builder,
    }
    impl<C, M, R> GetAppValidationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppValidationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppValidationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppValidationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppValidationConfigurationInputOperationOutputAlias,
                crate::output::GetAppValidationConfigurationOutput,
                crate::error::GetAppValidationConfigurationError,
                crate::input::GetAppValidationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppValidationOutput`.
    ///
    /// <p>Retrieves output from validating an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAppValidationOutput<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_app_validation_output_input::Builder,
    }
    impl<C, M, R> GetAppValidationOutput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAppValidationOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppValidationOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppValidationOutputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAppValidationOutputInputOperationOutputAlias,
                crate::output::GetAppValidationOutputOutput,
                crate::error::GetAppValidationOutputError,
                crate::input::GetAppValidationOutputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectors`.
    ///
    /// <p>Describes the connectors registered with the AWS SMS.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConnectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connectors_input::Builder,
    }
    impl<C, M, R> GetConnectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectorsInputOperationOutputAlias,
                crate::output::GetConnectorsOutput,
                crate::error::GetConnectorsError,
                crate::input::GetConnectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationJobs`.
    ///
    /// <p>Describes the specified replication job or all of your replication jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReplicationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_replication_jobs_input::Builder,
    }
    impl<C, M, R> GetReplicationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReplicationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReplicationJobsInputOperationOutputAlias,
                crate::output::GetReplicationJobsOutput,
                crate::error::GetReplicationJobsError,
                crate::input::GetReplicationJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_job_id(inp);
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_job_id(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReplicationRuns`.
    ///
    /// <p>Describes the replication runs for the specified replication job.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReplicationRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_replication_runs_input::Builder,
    }
    impl<C, M, R> GetReplicationRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReplicationRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReplicationRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReplicationRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReplicationRunsInputOperationOutputAlias,
                crate::output::GetReplicationRunsOutput,
                crate::error::GetReplicationRunsError,
                crate::input::GetReplicationRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_job_id(inp);
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_job_id(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServers`.
    ///
    /// <p>Describes the servers in your server catalog.</p>
    /// <p>Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_servers_input::Builder,
    }
    impl<C, M, R> GetServers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServersInputOperationOutputAlias,
                crate::output::GetServersOutput,
                crate::error::GetServersError,
                crate::input::GetServersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 50.
        /// To retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `vmServerAddressList`.
        ///
        /// To override the contents of this collection use [`set_vm_server_address_list`](Self::set_vm_server_address_list).
        ///
        /// <p>The server addresses.</p>
        pub fn vm_server_address_list(
            mut self,
            inp: impl Into<crate::model::VmServerAddress>,
        ) -> Self {
            self.inner = self.inner.vm_server_address_list(inp);
            self
        }
        /// <p>The server addresses.</p>
        pub fn set_vm_server_address_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VmServerAddress>>,
        ) -> Self {
            self.inner = self.inner.set_vm_server_address_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportAppCatalog`.
    ///
    /// <p>Allows application import from AWS Migration Hub.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportAppCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_app_catalog_input::Builder,
    }
    impl<C, M, R> ImportAppCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportAppCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportAppCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportAppCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportAppCatalogInputOperationOutputAlias,
                crate::output::ImportAppCatalogOutput,
                crate::error::ImportAppCatalogError,
                crate::input::ImportAppCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service role. If you omit this parameter, we create a service-linked role
        /// for AWS Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy
        /// and trust policy</a> described in the <i>AWS Migration Hub User Guide</i>.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the service role. If you omit this parameter, we create a service-linked role
        /// for AWS Migration Hub in your account. Otherwise, the role that you provide must have the <a href="https://docs.aws.amazon.com/migrationhub/latest/ug/new-customer-setup.html#sms-managed">policy
        /// and trust policy</a> described in the <i>AWS Migration Hub User Guide</i>.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportServerCatalog`.
    ///
    /// <p>Gathers a complete list of on-premises servers. Connectors must be installed and
    /// monitoring all servers to import.</p>
    /// <p>This call returns immediately, but might take additional time to retrieve all the
    /// servers.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportServerCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_server_catalog_input::Builder,
    }
    impl<C, M, R> ImportServerCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportServerCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportServerCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportServerCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportServerCatalogInputOperationOutputAlias,
                crate::output::ImportServerCatalogOutput,
                crate::error::ImportServerCatalogError,
                crate::input::ImportServerCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `LaunchApp`.
    ///
    /// <p>Launches the specified application as a stack in AWS CloudFormation.</p>
    #[derive(std::fmt::Debug)]
    pub struct LaunchApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::launch_app_input::Builder,
    }
    impl<C, M, R> LaunchApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LaunchApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LaunchAppOutput,
            aws_smithy_http::result::SdkError<crate::error::LaunchAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LaunchAppInputOperationOutputAlias,
                crate::output::LaunchAppOutput,
                crate::error::LaunchAppError,
                crate::input::LaunchAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p>Retrieves summaries for all applications.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl<C, M, R> ListApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppsInputOperationOutputAlias,
                crate::output::ListAppsOutput,
                crate::error::ListAppsError,
                crate::input::ListAppsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `appIds`.
        ///
        /// To override the contents of this collection use [`set_app_ids`](Self::set_app_ids).
        ///
        /// <p>The unique application IDs.</p>
        pub fn app_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_ids(inp);
            self
        }
        /// <p>The unique application IDs.</p>
        pub fn set_app_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_app_ids(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 100. To
        /// retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in a single call. The default value is 100. To
        /// retrieve the remaining results, make another call with the returned
        /// <code>NextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyAppValidationOutput`.
    ///
    /// <p>Provides information to AWS SMS about whether application validation is successful.</p>
    #[derive(std::fmt::Debug)]
    pub struct NotifyAppValidationOutput<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::notify_app_validation_output_input::Builder,
    }
    impl<C, M, R> NotifyAppValidationOutput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `NotifyAppValidationOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyAppValidationOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyAppValidationOutputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::NotifyAppValidationOutputInputOperationOutputAlias,
                crate::output::NotifyAppValidationOutputOutput,
                crate::error::NotifyAppValidationOutputError,
                crate::input::NotifyAppValidationOutputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The notification information.</p>
        pub fn notification_context(mut self, inp: crate::model::NotificationContext) -> Self {
            self.inner = self.inner.notification_context(inp);
            self
        }
        /// <p>The notification information.</p>
        pub fn set_notification_context(
            mut self,
            input: std::option::Option<crate::model::NotificationContext>,
        ) -> Self {
            self.inner = self.inner.set_notification_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppLaunchConfiguration`.
    ///
    /// <p>Creates or updates the launch configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppLaunchConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_launch_configuration_input::Builder,
    }
    impl<C, M, R> PutAppLaunchConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppLaunchConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppLaunchConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppLaunchConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppLaunchConfigurationInputOperationOutputAlias,
                crate::output::PutAppLaunchConfigurationOutput,
                crate::error::PutAppLaunchConfigurationError,
                crate::input::PutAppLaunchConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The name of service role in the customer's account that AWS CloudFormation uses to launch the
        /// application.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of service role in the customer's account that AWS CloudFormation uses to launch the
        /// application.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn auto_launch(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_launch(inp);
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn set_auto_launch(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_launch(input);
            self
        }
        /// Appends an item to `serverGroupLaunchConfigurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_launch_configurations`](Self::set_server_group_launch_configurations).
        ///
        /// <p>Information about the launch configurations for server groups in the application.</p>
        pub fn server_group_launch_configurations(
            mut self,
            inp: impl Into<crate::model::ServerGroupLaunchConfiguration>,
        ) -> Self {
            self.inner = self.inner.server_group_launch_configurations(inp);
            self
        }
        /// <p>Information about the launch configurations for server groups in the application.</p>
        pub fn set_server_group_launch_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_server_group_launch_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppReplicationConfiguration`.
    ///
    /// <p>Creates or updates the replication configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_replication_configuration_input::Builder,
    }
    impl<C, M, R> PutAppReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppReplicationConfigurationInputOperationOutputAlias,
                crate::output::PutAppReplicationConfigurationOutput,
                crate::error::PutAppReplicationConfigurationError,
                crate::input::PutAppReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// Appends an item to `serverGroupReplicationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_replication_configurations`](Self::set_server_group_replication_configurations).
        ///
        /// <p>Information about the replication configurations for server groups in the application.</p>
        pub fn server_group_replication_configurations(
            mut self,
            inp: impl Into<crate::model::ServerGroupReplicationConfiguration>,
        ) -> Self {
            self.inner = self.inner.server_group_replication_configurations(inp);
            self
        }
        /// <p>Information about the replication configurations for server groups in the application.</p>
        pub fn set_server_group_replication_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_server_group_replication_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAppValidationConfiguration`.
    ///
    /// <p>Creates or updates a validation configuration for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAppValidationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_app_validation_configuration_input::Builder,
    }
    impl<C, M, R> PutAppValidationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAppValidationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAppValidationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAppValidationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAppValidationConfigurationInputOperationOutputAlias,
                crate::output::PutAppValidationConfigurationOutput,
                crate::error::PutAppValidationConfigurationError,
                crate::input::PutAppValidationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// Appends an item to `appValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_app_validation_configurations`](Self::set_app_validation_configurations).
        ///
        /// <p>The configuration for application validation.</p>
        pub fn app_validation_configurations(
            mut self,
            inp: impl Into<crate::model::AppValidationConfiguration>,
        ) -> Self {
            self.inner = self.inner.app_validation_configurations(inp);
            self
        }
        /// <p>The configuration for application validation.</p>
        pub fn set_app_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_app_validation_configurations(input);
            self
        }
        /// Appends an item to `serverGroupValidationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_validation_configurations`](Self::set_server_group_validation_configurations).
        ///
        /// <p>The configuration for instance validation.</p>
        pub fn server_group_validation_configurations(
            mut self,
            inp: impl Into<crate::model::ServerGroupValidationConfiguration>,
        ) -> Self {
            self.inner = self.inner.server_group_validation_configurations(inp);
            self
        }
        /// <p>The configuration for instance validation.</p>
        pub fn set_server_group_validation_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupValidationConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_server_group_validation_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAppReplication`.
    ///
    /// <p>Starts replicating the specified application by creating replication jobs for each server in the
    /// application.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartAppReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_app_replication_input::Builder,
    }
    impl<C, M, R> StartAppReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAppReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAppReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAppReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAppReplicationInputOperationOutputAlias,
                crate::output::StartAppReplicationOutput,
                crate::error::StartAppReplicationError,
                crate::input::StartAppReplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartOnDemandAppReplication`.
    ///
    /// <p>Starts an on-demand replication run for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartOnDemandAppReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_on_demand_app_replication_input::Builder,
    }
    impl<C, M, R> StartOnDemandAppReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartOnDemandAppReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartOnDemandAppReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartOnDemandAppReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartOnDemandAppReplicationInputOperationOutputAlias,
                crate::output::StartOnDemandAppReplicationOutput,
                crate::error::StartOnDemandAppReplicationError,
                crate::input::StartOnDemandAppReplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartOnDemandReplicationRun`.
    ///
    /// <p>Starts an on-demand replication run for the specified replication job. This
    /// replication run starts immediately. This replication run is in addition to the ones
    /// already scheduled.</p>
    /// <p>There is a limit on the number of on-demand replications runs that you can request
    /// in a 24-hour period.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartOnDemandReplicationRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_on_demand_replication_run_input::Builder,
    }
    impl<C, M, R> StartOnDemandReplicationRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartOnDemandReplicationRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartOnDemandReplicationRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartOnDemandReplicationRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartOnDemandReplicationRunInputOperationOutputAlias,
                crate::output::StartOnDemandReplicationRunOutput,
                crate::error::StartOnDemandReplicationRunError,
                crate::input::StartOnDemandReplicationRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_job_id(inp);
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_job_id(input);
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAppReplication`.
    ///
    /// <p>Stops replicating the specified application by deleting the replication job for each server in
    /// the application.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopAppReplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_app_replication_input::Builder,
    }
    impl<C, M, R> StopAppReplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopAppReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAppReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAppReplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopAppReplicationInputOperationOutputAlias,
                crate::output::StopAppReplicationOutput,
                crate::error::StopAppReplicationError,
                crate::input::StopAppReplicationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateApp`.
    ///
    /// <p>Terminates the stack for the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_app_input::Builder,
    }
    impl<C, M, R> TerminateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateAppInputOperationOutputAlias,
                crate::output::TerminateAppOutput,
                crate::error::TerminateAppError,
                crate::input::TerminateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApp`.
    ///
    /// <p>Updates the specified application.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_input::Builder,
    }
    impl<C, M, R> UpdateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInputOperationOutputAlias,
                crate::output::UpdateAppOutput,
                crate::error::UpdateAppError,
                crate::input::UpdateAppInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The new name of the application.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new description of the application.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// Appends an item to `serverGroups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups in the application to update.</p>
        pub fn server_groups(mut self, inp: impl Into<crate::model::ServerGroup>) -> Self {
            self.inner = self.inner.server_groups(inp);
            self
        }
        /// <p>The server groups in the application to update.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.inner = self.inner.set_server_groups(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the application.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to associate with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReplicationJob`.
    ///
    /// <p>Updates the specified settings for the specified replication job.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReplicationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_replication_job_input::Builder,
    }
    impl<C, M, R> UpdateReplicationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReplicationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReplicationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReplicationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReplicationJobInputOperationOutputAlias,
                crate::output::UpdateReplicationJobOutput,
                crate::error::UpdateReplicationJobError,
                crate::input::UpdateReplicationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_job_id(inp);
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_job_id(input);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn frequency(mut self, inp: i32) -> Self {
            self.inner = self.inner.frequency(inp);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_frequency(input);
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn next_replication_run_start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.next_replication_run_start_time(inp);
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn set_next_replication_run_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_next_replication_run_start_time(input);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn license_type(mut self, inp: crate::model::LicenseType) -> Self {
            self.inner = self.inner.license_type(inp);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.inner = self.inner.set_license_type(input);
            self
        }
        /// <p>The name of the IAM role to be used by AWS SMS.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role to be used by AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the
        /// maximum number is reached and a new AMI is created.</p>
        pub fn number_of_recent_amis_to_keep(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_recent_amis_to_keep(inp);
            self
        }
        /// <p>The maximum number of SMS-created AMIs to retain. The oldest is deleted after the
        /// maximum number is reached and a new AMI is created.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_number_of_recent_amis_to_keep(input);
            self
        }
        /// <p>When true, the replication job produces encrypted AMIs. For more information,
        /// <code>KmsKeyId</code>.</p>
        pub fn encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.encrypted(inp);
            self
        }
        /// <p>When true, the replication job produces encrypted AMIs. For more information,
        /// <code>KmsKeyId</code>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
