// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationJobOutput {}
impl std::fmt::Debug for UpdateReplicationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationJobOutput");
        formatter.finish()
    }
}
/// See [`UpdateReplicationJobOutput`](crate::output::UpdateReplicationJobOutput)
pub mod update_replication_job_output {
    /// A builder for [`UpdateReplicationJobOutput`](crate::output::UpdateReplicationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateReplicationJobOutput`](crate::output::UpdateReplicationJobOutput)
        pub fn build(self) -> crate::output::UpdateReplicationJobOutput {
            crate::output::UpdateReplicationJobOutput {}
        }
    }
}
impl UpdateReplicationJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationJobOutput`](crate::output::UpdateReplicationJobOutput)
    pub fn builder() -> crate::output::update_replication_job_output::Builder {
        crate::output::update_replication_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppOutput {
    /// <p>A summary description of the application.</p>
    pub app_summary: std::option::Option<crate::model::AppSummary>,
    /// <p>The updated server groups in the application.</p>
    pub server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
    /// <p>The tags associated with the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UpdateAppOutput {
    /// <p>A summary description of the application.</p>
    pub fn app_summary(&self) -> std::option::Option<&crate::model::AppSummary> {
        self.app_summary.as_ref()
    }
    /// <p>The updated server groups in the application.</p>
    pub fn server_groups(&self) -> std::option::Option<&[crate::model::ServerGroup]> {
        self.server_groups.as_deref()
    }
    /// <p>The tags associated with the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppOutput");
        formatter.field("app_summary", &self.app_summary);
        formatter.field("server_groups", &self.server_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateAppOutput`](crate::output::UpdateAppOutput)
pub mod update_app_output {
    /// A builder for [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_summary: std::option::Option<crate::model::AppSummary>,
        pub(crate) server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A summary description of the application.</p>
        pub fn app_summary(mut self, input: crate::model::AppSummary) -> Self {
            self.app_summary = Some(input);
            self
        }
        /// <p>A summary description of the application.</p>
        pub fn set_app_summary(
            mut self,
            input: std::option::Option<crate::model::AppSummary>,
        ) -> Self {
            self.app_summary = input;
            self
        }
        /// Appends an item to `server_groups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The updated server groups in the application.</p>
        pub fn server_groups(mut self, input: impl Into<crate::model::ServerGroup>) -> Self {
            let mut v = self.server_groups.unwrap_or_default();
            v.push(input.into());
            self.server_groups = Some(v);
            self
        }
        /// <p>The updated server groups in the application.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.server_groups = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the application.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppOutput`](crate::output::UpdateAppOutput)
        pub fn build(self) -> crate::output::UpdateAppOutput {
            crate::output::UpdateAppOutput {
                app_summary: self.app_summary,
                server_groups: self.server_groups,
                tags: self.tags,
            }
        }
    }
}
impl UpdateAppOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    pub fn builder() -> crate::output::update_app_output::Builder {
        crate::output::update_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateAppOutput {}
impl std::fmt::Debug for TerminateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateAppOutput");
        formatter.finish()
    }
}
/// See [`TerminateAppOutput`](crate::output::TerminateAppOutput)
pub mod terminate_app_output {
    /// A builder for [`TerminateAppOutput`](crate::output::TerminateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TerminateAppOutput`](crate::output::TerminateAppOutput)
        pub fn build(self) -> crate::output::TerminateAppOutput {
            crate::output::TerminateAppOutput {}
        }
    }
}
impl TerminateAppOutput {
    /// Creates a new builder-style object to manufacture [`TerminateAppOutput`](crate::output::TerminateAppOutput)
    pub fn builder() -> crate::output::terminate_app_output::Builder {
        crate::output::terminate_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAppReplicationOutput {}
impl std::fmt::Debug for StopAppReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAppReplicationOutput");
        formatter.finish()
    }
}
/// See [`StopAppReplicationOutput`](crate::output::StopAppReplicationOutput)
pub mod stop_app_replication_output {
    /// A builder for [`StopAppReplicationOutput`](crate::output::StopAppReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopAppReplicationOutput`](crate::output::StopAppReplicationOutput)
        pub fn build(self) -> crate::output::StopAppReplicationOutput {
            crate::output::StopAppReplicationOutput {}
        }
    }
}
impl StopAppReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StopAppReplicationOutput`](crate::output::StopAppReplicationOutput)
    pub fn builder() -> crate::output::stop_app_replication_output::Builder {
        crate::output::stop_app_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOnDemandReplicationRunOutput {
    /// <p>The ID of the replication run.</p>
    pub replication_run_id: std::option::Option<std::string::String>,
}
impl StartOnDemandReplicationRunOutput {
    /// <p>The ID of the replication run.</p>
    pub fn replication_run_id(&self) -> std::option::Option<&str> {
        self.replication_run_id.as_deref()
    }
}
impl std::fmt::Debug for StartOnDemandReplicationRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOnDemandReplicationRunOutput");
        formatter.field("replication_run_id", &self.replication_run_id);
        formatter.finish()
    }
}
/// See [`StartOnDemandReplicationRunOutput`](crate::output::StartOnDemandReplicationRunOutput)
pub mod start_on_demand_replication_run_output {
    /// A builder for [`StartOnDemandReplicationRunOutput`](crate::output::StartOnDemandReplicationRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication run.</p>
        pub fn replication_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_run_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication run.</p>
        pub fn set_replication_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOnDemandReplicationRunOutput`](crate::output::StartOnDemandReplicationRunOutput)
        pub fn build(self) -> crate::output::StartOnDemandReplicationRunOutput {
            crate::output::StartOnDemandReplicationRunOutput {
                replication_run_id: self.replication_run_id,
            }
        }
    }
}
impl StartOnDemandReplicationRunOutput {
    /// Creates a new builder-style object to manufacture [`StartOnDemandReplicationRunOutput`](crate::output::StartOnDemandReplicationRunOutput)
    pub fn builder() -> crate::output::start_on_demand_replication_run_output::Builder {
        crate::output::start_on_demand_replication_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOnDemandAppReplicationOutput {}
impl std::fmt::Debug for StartOnDemandAppReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOnDemandAppReplicationOutput");
        formatter.finish()
    }
}
/// See [`StartOnDemandAppReplicationOutput`](crate::output::StartOnDemandAppReplicationOutput)
pub mod start_on_demand_app_replication_output {
    /// A builder for [`StartOnDemandAppReplicationOutput`](crate::output::StartOnDemandAppReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartOnDemandAppReplicationOutput`](crate::output::StartOnDemandAppReplicationOutput)
        pub fn build(self) -> crate::output::StartOnDemandAppReplicationOutput {
            crate::output::StartOnDemandAppReplicationOutput {}
        }
    }
}
impl StartOnDemandAppReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StartOnDemandAppReplicationOutput`](crate::output::StartOnDemandAppReplicationOutput)
    pub fn builder() -> crate::output::start_on_demand_app_replication_output::Builder {
        crate::output::start_on_demand_app_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAppReplicationOutput {}
impl std::fmt::Debug for StartAppReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAppReplicationOutput");
        formatter.finish()
    }
}
/// See [`StartAppReplicationOutput`](crate::output::StartAppReplicationOutput)
pub mod start_app_replication_output {
    /// A builder for [`StartAppReplicationOutput`](crate::output::StartAppReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartAppReplicationOutput`](crate::output::StartAppReplicationOutput)
        pub fn build(self) -> crate::output::StartAppReplicationOutput {
            crate::output::StartAppReplicationOutput {}
        }
    }
}
impl StartAppReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StartAppReplicationOutput`](crate::output::StartAppReplicationOutput)
    pub fn builder() -> crate::output::start_app_replication_output::Builder {
        crate::output::start_app_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppValidationConfigurationOutput {}
impl std::fmt::Debug for PutAppValidationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppValidationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutAppValidationConfigurationOutput`](crate::output::PutAppValidationConfigurationOutput)
pub mod put_app_validation_configuration_output {
    /// A builder for [`PutAppValidationConfigurationOutput`](crate::output::PutAppValidationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAppValidationConfigurationOutput`](crate::output::PutAppValidationConfigurationOutput)
        pub fn build(self) -> crate::output::PutAppValidationConfigurationOutput {
            crate::output::PutAppValidationConfigurationOutput {}
        }
    }
}
impl PutAppValidationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutAppValidationConfigurationOutput`](crate::output::PutAppValidationConfigurationOutput)
    pub fn builder() -> crate::output::put_app_validation_configuration_output::Builder {
        crate::output::put_app_validation_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppReplicationConfigurationOutput {}
impl std::fmt::Debug for PutAppReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppReplicationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutAppReplicationConfigurationOutput`](crate::output::PutAppReplicationConfigurationOutput)
pub mod put_app_replication_configuration_output {
    /// A builder for [`PutAppReplicationConfigurationOutput`](crate::output::PutAppReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAppReplicationConfigurationOutput`](crate::output::PutAppReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::PutAppReplicationConfigurationOutput {
            crate::output::PutAppReplicationConfigurationOutput {}
        }
    }
}
impl PutAppReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutAppReplicationConfigurationOutput`](crate::output::PutAppReplicationConfigurationOutput)
    pub fn builder() -> crate::output::put_app_replication_configuration_output::Builder {
        crate::output::put_app_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAppLaunchConfigurationOutput {}
impl std::fmt::Debug for PutAppLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAppLaunchConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutAppLaunchConfigurationOutput`](crate::output::PutAppLaunchConfigurationOutput)
pub mod put_app_launch_configuration_output {
    /// A builder for [`PutAppLaunchConfigurationOutput`](crate::output::PutAppLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAppLaunchConfigurationOutput`](crate::output::PutAppLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::PutAppLaunchConfigurationOutput {
            crate::output::PutAppLaunchConfigurationOutput {}
        }
    }
}
impl PutAppLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutAppLaunchConfigurationOutput`](crate::output::PutAppLaunchConfigurationOutput)
    pub fn builder() -> crate::output::put_app_launch_configuration_output::Builder {
        crate::output::put_app_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyAppValidationOutputOutput {}
impl std::fmt::Debug for NotifyAppValidationOutputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyAppValidationOutputOutput");
        formatter.finish()
    }
}
/// See [`NotifyAppValidationOutputOutput`](crate::output::NotifyAppValidationOutputOutput)
pub mod notify_app_validation_output_output {
    /// A builder for [`NotifyAppValidationOutputOutput`](crate::output::NotifyAppValidationOutputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`NotifyAppValidationOutputOutput`](crate::output::NotifyAppValidationOutputOutput)
        pub fn build(self) -> crate::output::NotifyAppValidationOutputOutput {
            crate::output::NotifyAppValidationOutputOutput {}
        }
    }
}
impl NotifyAppValidationOutputOutput {
    /// Creates a new builder-style object to manufacture [`NotifyAppValidationOutputOutput`](crate::output::NotifyAppValidationOutputOutput)
    pub fn builder() -> crate::output::notify_app_validation_output_output::Builder {
        crate::output::notify_app_validation_output_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsOutput {
    /// <p>The application summaries.</p>
    pub apps: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
    /// <p>The token required to retrieve the next set of results. This value is null when there
    /// are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppsOutput {
    /// <p>The application summaries.</p>
    pub fn apps(&self) -> std::option::Option<&[crate::model::AppSummary]> {
        self.apps.as_deref()
    }
    /// <p>The token required to retrieve the next set of results. This value is null when there
    /// are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsOutput");
        formatter.field("apps", &self.apps);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppsOutput`](crate::output::ListAppsOutput)
pub mod list_apps_output {
    /// A builder for [`ListAppsOutput`](crate::output::ListAppsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apps: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `apps`.
        ///
        /// To override the contents of this collection use [`set_apps`](Self::set_apps).
        ///
        /// <p>The application summaries.</p>
        pub fn apps(mut self, input: impl Into<crate::model::AppSummary>) -> Self {
            let mut v = self.apps.unwrap_or_default();
            v.push(input.into());
            self.apps = Some(v);
            self
        }
        /// <p>The application summaries.</p>
        pub fn set_apps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
        ) -> Self {
            self.apps = input;
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when there
        /// are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when there
        /// are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsOutput`](crate::output::ListAppsOutput)
        pub fn build(self) -> crate::output::ListAppsOutput {
            crate::output::ListAppsOutput {
                apps: self.apps,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppsOutput`](crate::output::ListAppsOutput)
    pub fn builder() -> crate::output::list_apps_output::Builder {
        crate::output::list_apps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchAppOutput {}
impl std::fmt::Debug for LaunchAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchAppOutput");
        formatter.finish()
    }
}
/// See [`LaunchAppOutput`](crate::output::LaunchAppOutput)
pub mod launch_app_output {
    /// A builder for [`LaunchAppOutput`](crate::output::LaunchAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`LaunchAppOutput`](crate::output::LaunchAppOutput)
        pub fn build(self) -> crate::output::LaunchAppOutput {
            crate::output::LaunchAppOutput {}
        }
    }
}
impl LaunchAppOutput {
    /// Creates a new builder-style object to manufacture [`LaunchAppOutput`](crate::output::LaunchAppOutput)
    pub fn builder() -> crate::output::launch_app_output::Builder {
        crate::output::launch_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportServerCatalogOutput {}
impl std::fmt::Debug for ImportServerCatalogOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportServerCatalogOutput");
        formatter.finish()
    }
}
/// See [`ImportServerCatalogOutput`](crate::output::ImportServerCatalogOutput)
pub mod import_server_catalog_output {
    /// A builder for [`ImportServerCatalogOutput`](crate::output::ImportServerCatalogOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ImportServerCatalogOutput`](crate::output::ImportServerCatalogOutput)
        pub fn build(self) -> crate::output::ImportServerCatalogOutput {
            crate::output::ImportServerCatalogOutput {}
        }
    }
}
impl ImportServerCatalogOutput {
    /// Creates a new builder-style object to manufacture [`ImportServerCatalogOutput`](crate::output::ImportServerCatalogOutput)
    pub fn builder() -> crate::output::import_server_catalog_output::Builder {
        crate::output::import_server_catalog_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportAppCatalogOutput {}
impl std::fmt::Debug for ImportAppCatalogOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportAppCatalogOutput");
        formatter.finish()
    }
}
/// See [`ImportAppCatalogOutput`](crate::output::ImportAppCatalogOutput)
pub mod import_app_catalog_output {
    /// A builder for [`ImportAppCatalogOutput`](crate::output::ImportAppCatalogOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ImportAppCatalogOutput`](crate::output::ImportAppCatalogOutput)
        pub fn build(self) -> crate::output::ImportAppCatalogOutput {
            crate::output::ImportAppCatalogOutput {}
        }
    }
}
impl ImportAppCatalogOutput {
    /// Creates a new builder-style object to manufacture [`ImportAppCatalogOutput`](crate::output::ImportAppCatalogOutput)
    pub fn builder() -> crate::output::import_app_catalog_output::Builder {
        crate::output::import_app_catalog_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServersOutput {
    /// <p>The time when the server was last modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the server catalog.</p>
    pub server_catalog_status: std::option::Option<crate::model::ServerCatalogStatus>,
    /// <p>Information about the servers.</p>
    pub server_list: std::option::Option<std::vec::Vec<crate::model::Server>>,
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetServersOutput {
    /// <p>The time when the server was last modified.</p>
    pub fn last_modified_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_on.as_ref()
    }
    /// <p>The status of the server catalog.</p>
    pub fn server_catalog_status(&self) -> std::option::Option<&crate::model::ServerCatalogStatus> {
        self.server_catalog_status.as_ref()
    }
    /// <p>Information about the servers.</p>
    pub fn server_list(&self) -> std::option::Option<&[crate::model::Server]> {
        self.server_list.as_deref()
    }
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServersOutput");
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("server_catalog_status", &self.server_catalog_status);
        formatter.field("server_list", &self.server_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetServersOutput`](crate::output::GetServersOutput)
pub mod get_servers_output {
    /// A builder for [`GetServersOutput`](crate::output::GetServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) server_catalog_status: std::option::Option<crate::model::ServerCatalogStatus>,
        pub(crate) server_list: std::option::Option<std::vec::Vec<crate::model::Server>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time when the server was last modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The time when the server was last modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>The status of the server catalog.</p>
        pub fn server_catalog_status(mut self, input: crate::model::ServerCatalogStatus) -> Self {
            self.server_catalog_status = Some(input);
            self
        }
        /// <p>The status of the server catalog.</p>
        pub fn set_server_catalog_status(
            mut self,
            input: std::option::Option<crate::model::ServerCatalogStatus>,
        ) -> Self {
            self.server_catalog_status = input;
            self
        }
        /// Appends an item to `server_list`.
        ///
        /// To override the contents of this collection use [`set_server_list`](Self::set_server_list).
        ///
        /// <p>Information about the servers.</p>
        pub fn server_list(mut self, input: impl Into<crate::model::Server>) -> Self {
            let mut v = self.server_list.unwrap_or_default();
            v.push(input.into());
            self.server_list = Some(v);
            self
        }
        /// <p>Information about the servers.</p>
        pub fn set_server_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Server>>,
        ) -> Self {
            self.server_list = input;
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServersOutput`](crate::output::GetServersOutput)
        pub fn build(self) -> crate::output::GetServersOutput {
            crate::output::GetServersOutput {
                last_modified_on: self.last_modified_on,
                server_catalog_status: self.server_catalog_status,
                server_list: self.server_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetServersOutput {
    /// Creates a new builder-style object to manufacture [`GetServersOutput`](crate::output::GetServersOutput)
    pub fn builder() -> crate::output::get_servers_output::Builder {
        crate::output::get_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationRunsOutput {
    /// <p>Information about the replication job.</p>
    pub replication_job: std::option::Option<crate::model::ReplicationJob>,
    /// <p>Information about the replication runs.</p>
    pub replication_run_list: std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetReplicationRunsOutput {
    /// <p>Information about the replication job.</p>
    pub fn replication_job(&self) -> std::option::Option<&crate::model::ReplicationJob> {
        self.replication_job.as_ref()
    }
    /// <p>Information about the replication runs.</p>
    pub fn replication_run_list(&self) -> std::option::Option<&[crate::model::ReplicationRun]> {
        self.replication_run_list.as_deref()
    }
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetReplicationRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationRunsOutput");
        formatter.field("replication_job", &self.replication_job);
        formatter.field("replication_run_list", &self.replication_run_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetReplicationRunsOutput`](crate::output::GetReplicationRunsOutput)
pub mod get_replication_runs_output {
    /// A builder for [`GetReplicationRunsOutput`](crate::output::GetReplicationRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job: std::option::Option<crate::model::ReplicationJob>,
        pub(crate) replication_run_list:
            std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the replication job.</p>
        pub fn replication_job(mut self, input: crate::model::ReplicationJob) -> Self {
            self.replication_job = Some(input);
            self
        }
        /// <p>Information about the replication job.</p>
        pub fn set_replication_job(
            mut self,
            input: std::option::Option<crate::model::ReplicationJob>,
        ) -> Self {
            self.replication_job = input;
            self
        }
        /// Appends an item to `replication_run_list`.
        ///
        /// To override the contents of this collection use [`set_replication_run_list`](Self::set_replication_run_list).
        ///
        /// <p>Information about the replication runs.</p>
        pub fn replication_run_list(
            mut self,
            input: impl Into<crate::model::ReplicationRun>,
        ) -> Self {
            let mut v = self.replication_run_list.unwrap_or_default();
            v.push(input.into());
            self.replication_run_list = Some(v);
            self
        }
        /// <p>Information about the replication runs.</p>
        pub fn set_replication_run_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
        ) -> Self {
            self.replication_run_list = input;
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationRunsOutput`](crate::output::GetReplicationRunsOutput)
        pub fn build(self) -> crate::output::GetReplicationRunsOutput {
            crate::output::GetReplicationRunsOutput {
                replication_job: self.replication_job,
                replication_run_list: self.replication_run_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetReplicationRunsOutput {
    /// Creates a new builder-style object to manufacture [`GetReplicationRunsOutput`](crate::output::GetReplicationRunsOutput)
    pub fn builder() -> crate::output::get_replication_runs_output::Builder {
        crate::output::get_replication_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationJobsOutput {
    /// <p>Information about the replication jobs.</p>
    pub replication_job_list: std::option::Option<std::vec::Vec<crate::model::ReplicationJob>>,
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetReplicationJobsOutput {
    /// <p>Information about the replication jobs.</p>
    pub fn replication_job_list(&self) -> std::option::Option<&[crate::model::ReplicationJob]> {
        self.replication_job_list.as_deref()
    }
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetReplicationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationJobsOutput");
        formatter.field("replication_job_list", &self.replication_job_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetReplicationJobsOutput`](crate::output::GetReplicationJobsOutput)
pub mod get_replication_jobs_output {
    /// A builder for [`GetReplicationJobsOutput`](crate::output::GetReplicationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_list:
            std::option::Option<std::vec::Vec<crate::model::ReplicationJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replication_job_list`.
        ///
        /// To override the contents of this collection use [`set_replication_job_list`](Self::set_replication_job_list).
        ///
        /// <p>Information about the replication jobs.</p>
        pub fn replication_job_list(
            mut self,
            input: impl Into<crate::model::ReplicationJob>,
        ) -> Self {
            let mut v = self.replication_job_list.unwrap_or_default();
            v.push(input.into());
            self.replication_job_list = Some(v);
            self
        }
        /// <p>Information about the replication jobs.</p>
        pub fn set_replication_job_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationJob>>,
        ) -> Self {
            self.replication_job_list = input;
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationJobsOutput`](crate::output::GetReplicationJobsOutput)
        pub fn build(self) -> crate::output::GetReplicationJobsOutput {
            crate::output::GetReplicationJobsOutput {
                replication_job_list: self.replication_job_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetReplicationJobsOutput {
    /// Creates a new builder-style object to manufacture [`GetReplicationJobsOutput`](crate::output::GetReplicationJobsOutput)
    pub fn builder() -> crate::output::get_replication_jobs_output::Builder {
        crate::output::get_replication_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectorsOutput {
    /// <p>Information about the registered connectors.</p>
    pub connector_list: std::option::Option<std::vec::Vec<crate::model::Connector>>,
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetConnectorsOutput {
    /// <p>Information about the registered connectors.</p>
    pub fn connector_list(&self) -> std::option::Option<&[crate::model::Connector]> {
        self.connector_list.as_deref()
    }
    /// <p>The token required to retrieve the next set of results. This value is null when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetConnectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectorsOutput");
        formatter.field("connector_list", &self.connector_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetConnectorsOutput`](crate::output::GetConnectorsOutput)
pub mod get_connectors_output {
    /// A builder for [`GetConnectorsOutput`](crate::output::GetConnectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_list: std::option::Option<std::vec::Vec<crate::model::Connector>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connector_list`.
        ///
        /// To override the contents of this collection use [`set_connector_list`](Self::set_connector_list).
        ///
        /// <p>Information about the registered connectors.</p>
        pub fn connector_list(mut self, input: impl Into<crate::model::Connector>) -> Self {
            let mut v = self.connector_list.unwrap_or_default();
            v.push(input.into());
            self.connector_list = Some(v);
            self
        }
        /// <p>Information about the registered connectors.</p>
        pub fn set_connector_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connector>>,
        ) -> Self {
            self.connector_list = input;
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token required to retrieve the next set of results. This value is null when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectorsOutput`](crate::output::GetConnectorsOutput)
        pub fn build(self) -> crate::output::GetConnectorsOutput {
            crate::output::GetConnectorsOutput {
                connector_list: self.connector_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetConnectorsOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectorsOutput`](crate::output::GetConnectorsOutput)
    pub fn builder() -> crate::output::get_connectors_output::Builder {
        crate::output::get_connectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppValidationOutputOutput {
    /// <p>The validation output.</p>
    pub validation_output_list: std::option::Option<std::vec::Vec<crate::model::ValidationOutput>>,
}
impl GetAppValidationOutputOutput {
    /// <p>The validation output.</p>
    pub fn validation_output_list(&self) -> std::option::Option<&[crate::model::ValidationOutput]> {
        self.validation_output_list.as_deref()
    }
}
impl std::fmt::Debug for GetAppValidationOutputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppValidationOutputOutput");
        formatter.field("validation_output_list", &self.validation_output_list);
        formatter.finish()
    }
}
/// See [`GetAppValidationOutputOutput`](crate::output::GetAppValidationOutputOutput)
pub mod get_app_validation_output_output {
    /// A builder for [`GetAppValidationOutputOutput`](crate::output::GetAppValidationOutputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_output_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationOutput>>,
    }
    impl Builder {
        /// Appends an item to `validation_output_list`.
        ///
        /// To override the contents of this collection use [`set_validation_output_list`](Self::set_validation_output_list).
        ///
        /// <p>The validation output.</p>
        pub fn validation_output_list(
            mut self,
            input: impl Into<crate::model::ValidationOutput>,
        ) -> Self {
            let mut v = self.validation_output_list.unwrap_or_default();
            v.push(input.into());
            self.validation_output_list = Some(v);
            self
        }
        /// <p>The validation output.</p>
        pub fn set_validation_output_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationOutput>>,
        ) -> Self {
            self.validation_output_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppValidationOutputOutput`](crate::output::GetAppValidationOutputOutput)
        pub fn build(self) -> crate::output::GetAppValidationOutputOutput {
            crate::output::GetAppValidationOutputOutput {
                validation_output_list: self.validation_output_list,
            }
        }
    }
}
impl GetAppValidationOutputOutput {
    /// Creates a new builder-style object to manufacture [`GetAppValidationOutputOutput`](crate::output::GetAppValidationOutputOutput)
    pub fn builder() -> crate::output::get_app_validation_output_output::Builder {
        crate::output::get_app_validation_output_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppValidationConfigurationOutput {
    /// <p>The configuration for application validation.</p>
    pub app_validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
    /// <p>The configuration for instance validation.</p>
    pub server_group_validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupValidationConfiguration>>,
}
impl GetAppValidationConfigurationOutput {
    /// <p>The configuration for application validation.</p>
    pub fn app_validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::AppValidationConfiguration]> {
        self.app_validation_configurations.as_deref()
    }
    /// <p>The configuration for instance validation.</p>
    pub fn server_group_validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupValidationConfiguration]> {
        self.server_group_validation_configurations.as_deref()
    }
}
impl std::fmt::Debug for GetAppValidationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppValidationConfigurationOutput");
        formatter.field(
            "app_validation_configurations",
            &self.app_validation_configurations,
        );
        formatter.field(
            "server_group_validation_configurations",
            &self.server_group_validation_configurations,
        );
        formatter.finish()
    }
}
/// See [`GetAppValidationConfigurationOutput`](crate::output::GetAppValidationConfigurationOutput)
pub mod get_app_validation_configuration_output {
    /// A builder for [`GetAppValidationConfigurationOutput`](crate::output::GetAppValidationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
        pub(crate) server_group_validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupValidationConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `app_validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_app_validation_configurations`](Self::set_app_validation_configurations).
        ///
        /// <p>The configuration for application validation.</p>
        pub fn app_validation_configurations(
            mut self,
            input: impl Into<crate::model::AppValidationConfiguration>,
        ) -> Self {
            let mut v = self.app_validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.app_validation_configurations = Some(v);
            self
        }
        /// <p>The configuration for application validation.</p>
        pub fn set_app_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppValidationConfiguration>>,
        ) -> Self {
            self.app_validation_configurations = input;
            self
        }
        /// Appends an item to `server_group_validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_validation_configurations`](Self::set_server_group_validation_configurations).
        ///
        /// <p>The configuration for instance validation.</p>
        pub fn server_group_validation_configurations(
            mut self,
            input: impl Into<crate::model::ServerGroupValidationConfiguration>,
        ) -> Self {
            let mut v = self
                .server_group_validation_configurations
                .unwrap_or_default();
            v.push(input.into());
            self.server_group_validation_configurations = Some(v);
            self
        }
        /// <p>The configuration for instance validation.</p>
        pub fn set_server_group_validation_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupValidationConfiguration>,
            >,
        ) -> Self {
            self.server_group_validation_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppValidationConfigurationOutput`](crate::output::GetAppValidationConfigurationOutput)
        pub fn build(self) -> crate::output::GetAppValidationConfigurationOutput {
            crate::output::GetAppValidationConfigurationOutput {
                app_validation_configurations: self.app_validation_configurations,
                server_group_validation_configurations: self.server_group_validation_configurations,
            }
        }
    }
}
impl GetAppValidationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetAppValidationConfigurationOutput`](crate::output::GetAppValidationConfigurationOutput)
    pub fn builder() -> crate::output::get_app_validation_configuration_output::Builder {
        crate::output::get_app_validation_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppReplicationConfigurationOutput {
    /// <p>The replication configurations associated with server groups in this application.</p>
    pub server_group_replication_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>>,
}
impl GetAppReplicationConfigurationOutput {
    /// <p>The replication configurations associated with server groups in this application.</p>
    pub fn server_group_replication_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupReplicationConfiguration]> {
        self.server_group_replication_configurations.as_deref()
    }
}
impl std::fmt::Debug for GetAppReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppReplicationConfigurationOutput");
        formatter.field(
            "server_group_replication_configurations",
            &self.server_group_replication_configurations,
        );
        formatter.finish()
    }
}
/// See [`GetAppReplicationConfigurationOutput`](crate::output::GetAppReplicationConfigurationOutput)
pub mod get_app_replication_configuration_output {
    /// A builder for [`GetAppReplicationConfigurationOutput`](crate::output::GetAppReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_group_replication_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `server_group_replication_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_replication_configurations`](Self::set_server_group_replication_configurations).
        ///
        /// <p>The replication configurations associated with server groups in this application.</p>
        pub fn server_group_replication_configurations(
            mut self,
            input: impl Into<crate::model::ServerGroupReplicationConfiguration>,
        ) -> Self {
            let mut v = self
                .server_group_replication_configurations
                .unwrap_or_default();
            v.push(input.into());
            self.server_group_replication_configurations = Some(v);
            self
        }
        /// <p>The replication configurations associated with server groups in this application.</p>
        pub fn set_server_group_replication_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServerGroupReplicationConfiguration>,
            >,
        ) -> Self {
            self.server_group_replication_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppReplicationConfigurationOutput`](crate::output::GetAppReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::GetAppReplicationConfigurationOutput {
            crate::output::GetAppReplicationConfigurationOutput {
                server_group_replication_configurations: self
                    .server_group_replication_configurations,
            }
        }
    }
}
impl GetAppReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetAppReplicationConfigurationOutput`](crate::output::GetAppReplicationConfigurationOutput)
    pub fn builder() -> crate::output::get_app_replication_configuration_output::Builder {
        crate::output::get_app_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppLaunchConfigurationOutput {
    /// <p>The ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The name of the service role in the customer's account that AWS CloudFormation uses to launch the
    /// application.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
    pub auto_launch: std::option::Option<bool>,
    /// <p>The launch configurations for server groups in this application.</p>
    pub server_group_launch_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
}
impl GetAppLaunchConfigurationOutput {
    /// <p>The ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The name of the service role in the customer's account that AWS CloudFormation uses to launch the
    /// application.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
    pub fn auto_launch(&self) -> std::option::Option<bool> {
        self.auto_launch
    }
    /// <p>The launch configurations for server groups in this application.</p>
    pub fn server_group_launch_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerGroupLaunchConfiguration]> {
        self.server_group_launch_configurations.as_deref()
    }
}
impl std::fmt::Debug for GetAppLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppLaunchConfigurationOutput");
        formatter.field("app_id", &self.app_id);
        formatter.field("role_name", &self.role_name);
        formatter.field("auto_launch", &self.auto_launch);
        formatter.field(
            "server_group_launch_configurations",
            &self.server_group_launch_configurations,
        );
        formatter.finish()
    }
}
/// See [`GetAppLaunchConfigurationOutput`](crate::output::GetAppLaunchConfigurationOutput)
pub mod get_app_launch_configuration_output {
    /// A builder for [`GetAppLaunchConfigurationOutput`](crate::output::GetAppLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) auto_launch: std::option::Option<bool>,
        pub(crate) server_group_launch_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The name of the service role in the customer's account that AWS CloudFormation uses to launch the
        /// application.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service role in the customer's account that AWS CloudFormation uses to launch the
        /// application.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn auto_launch(mut self, input: bool) -> Self {
            self.auto_launch = Some(input);
            self
        }
        /// <p>Indicates whether the application is configured to launch automatically after replication is complete.</p>
        pub fn set_auto_launch(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_launch = input;
            self
        }
        /// Appends an item to `server_group_launch_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_group_launch_configurations`](Self::set_server_group_launch_configurations).
        ///
        /// <p>The launch configurations for server groups in this application.</p>
        pub fn server_group_launch_configurations(
            mut self,
            input: impl Into<crate::model::ServerGroupLaunchConfiguration>,
        ) -> Self {
            let mut v = self.server_group_launch_configurations.unwrap_or_default();
            v.push(input.into());
            self.server_group_launch_configurations = Some(v);
            self
        }
        /// <p>The launch configurations for server groups in this application.</p>
        pub fn set_server_group_launch_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroupLaunchConfiguration>>,
        ) -> Self {
            self.server_group_launch_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppLaunchConfigurationOutput`](crate::output::GetAppLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::GetAppLaunchConfigurationOutput {
            crate::output::GetAppLaunchConfigurationOutput {
                app_id: self.app_id,
                role_name: self.role_name,
                auto_launch: self.auto_launch,
                server_group_launch_configurations: self.server_group_launch_configurations,
            }
        }
    }
}
impl GetAppLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetAppLaunchConfigurationOutput`](crate::output::GetAppLaunchConfigurationOutput)
    pub fn builder() -> crate::output::get_app_launch_configuration_output::Builder {
        crate::output::get_app_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppOutput {
    /// <p>Information about the application.</p>
    pub app_summary: std::option::Option<crate::model::AppSummary>,
    /// <p>The server groups that belong to the application.</p>
    pub server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
    /// <p>The tags associated with the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GetAppOutput {
    /// <p>Information about the application.</p>
    pub fn app_summary(&self) -> std::option::Option<&crate::model::AppSummary> {
        self.app_summary.as_ref()
    }
    /// <p>The server groups that belong to the application.</p>
    pub fn server_groups(&self) -> std::option::Option<&[crate::model::ServerGroup]> {
        self.server_groups.as_deref()
    }
    /// <p>The tags associated with the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GetAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppOutput");
        formatter.field("app_summary", &self.app_summary);
        formatter.field("server_groups", &self.server_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetAppOutput`](crate::output::GetAppOutput)
pub mod get_app_output {
    /// A builder for [`GetAppOutput`](crate::output::GetAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_summary: std::option::Option<crate::model::AppSummary>,
        pub(crate) server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Information about the application.</p>
        pub fn app_summary(mut self, input: crate::model::AppSummary) -> Self {
            self.app_summary = Some(input);
            self
        }
        /// <p>Information about the application.</p>
        pub fn set_app_summary(
            mut self,
            input: std::option::Option<crate::model::AppSummary>,
        ) -> Self {
            self.app_summary = input;
            self
        }
        /// Appends an item to `server_groups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups that belong to the application.</p>
        pub fn server_groups(mut self, input: impl Into<crate::model::ServerGroup>) -> Self {
            let mut v = self.server_groups.unwrap_or_default();
            v.push(input.into());
            self.server_groups = Some(v);
            self
        }
        /// <p>The server groups that belong to the application.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.server_groups = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the application.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppOutput`](crate::output::GetAppOutput)
        pub fn build(self) -> crate::output::GetAppOutput {
            crate::output::GetAppOutput {
                app_summary: self.app_summary,
                server_groups: self.server_groups,
                tags: self.tags,
            }
        }
    }
}
impl GetAppOutput {
    /// Creates a new builder-style object to manufacture [`GetAppOutput`](crate::output::GetAppOutput)
    pub fn builder() -> crate::output::get_app_output::Builder {
        crate::output::get_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateTemplateOutput {
    /// <p>The location of the Amazon S3 object.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl GenerateTemplateOutput {
    /// <p>The location of the Amazon S3 object.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for GenerateTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateTemplateOutput");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`GenerateTemplateOutput`](crate::output::GenerateTemplateOutput)
pub mod generate_template_output {
    /// A builder for [`GenerateTemplateOutput`](crate::output::GenerateTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The location of the Amazon S3 object.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The location of the Amazon S3 object.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateTemplateOutput`](crate::output::GenerateTemplateOutput)
        pub fn build(self) -> crate::output::GenerateTemplateOutput {
            crate::output::GenerateTemplateOutput {
                s3_location: self.s3_location,
            }
        }
    }
}
impl GenerateTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GenerateTemplateOutput`](crate::output::GenerateTemplateOutput)
    pub fn builder() -> crate::output::generate_template_output::Builder {
        crate::output::generate_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateChangeSetOutput {
    /// <p>The location of the Amazon S3 object.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl GenerateChangeSetOutput {
    /// <p>The location of the Amazon S3 object.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for GenerateChangeSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateChangeSetOutput");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`GenerateChangeSetOutput`](crate::output::GenerateChangeSetOutput)
pub mod generate_change_set_output {
    /// A builder for [`GenerateChangeSetOutput`](crate::output::GenerateChangeSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The location of the Amazon S3 object.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The location of the Amazon S3 object.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateChangeSetOutput`](crate::output::GenerateChangeSetOutput)
        pub fn build(self) -> crate::output::GenerateChangeSetOutput {
            crate::output::GenerateChangeSetOutput {
                s3_location: self.s3_location,
            }
        }
    }
}
impl GenerateChangeSetOutput {
    /// Creates a new builder-style object to manufacture [`GenerateChangeSetOutput`](crate::output::GenerateChangeSetOutput)
    pub fn builder() -> crate::output::generate_change_set_output::Builder {
        crate::output::generate_change_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateConnectorOutput {}
impl std::fmt::Debug for DisassociateConnectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateConnectorOutput");
        formatter.finish()
    }
}
/// See [`DisassociateConnectorOutput`](crate::output::DisassociateConnectorOutput)
pub mod disassociate_connector_output {
    /// A builder for [`DisassociateConnectorOutput`](crate::output::DisassociateConnectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateConnectorOutput`](crate::output::DisassociateConnectorOutput)
        pub fn build(self) -> crate::output::DisassociateConnectorOutput {
            crate::output::DisassociateConnectorOutput {}
        }
    }
}
impl DisassociateConnectorOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateConnectorOutput`](crate::output::DisassociateConnectorOutput)
    pub fn builder() -> crate::output::disassociate_connector_output::Builder {
        crate::output::disassociate_connector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerCatalogOutput {}
impl std::fmt::Debug for DeleteServerCatalogOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerCatalogOutput");
        formatter.finish()
    }
}
/// See [`DeleteServerCatalogOutput`](crate::output::DeleteServerCatalogOutput)
pub mod delete_server_catalog_output {
    /// A builder for [`DeleteServerCatalogOutput`](crate::output::DeleteServerCatalogOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServerCatalogOutput`](crate::output::DeleteServerCatalogOutput)
        pub fn build(self) -> crate::output::DeleteServerCatalogOutput {
            crate::output::DeleteServerCatalogOutput {}
        }
    }
}
impl DeleteServerCatalogOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServerCatalogOutput`](crate::output::DeleteServerCatalogOutput)
    pub fn builder() -> crate::output::delete_server_catalog_output::Builder {
        crate::output::delete_server_catalog_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationJobOutput {}
impl std::fmt::Debug for DeleteReplicationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteReplicationJobOutput`](crate::output::DeleteReplicationJobOutput)
pub mod delete_replication_job_output {
    /// A builder for [`DeleteReplicationJobOutput`](crate::output::DeleteReplicationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReplicationJobOutput`](crate::output::DeleteReplicationJobOutput)
        pub fn build(self) -> crate::output::DeleteReplicationJobOutput {
            crate::output::DeleteReplicationJobOutput {}
        }
    }
}
impl DeleteReplicationJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationJobOutput`](crate::output::DeleteReplicationJobOutput)
    pub fn builder() -> crate::output::delete_replication_job_output::Builder {
        crate::output::delete_replication_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppValidationConfigurationOutput {}
impl std::fmt::Debug for DeleteAppValidationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppValidationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppValidationConfigurationOutput`](crate::output::DeleteAppValidationConfigurationOutput)
pub mod delete_app_validation_configuration_output {
    /// A builder for [`DeleteAppValidationConfigurationOutput`](crate::output::DeleteAppValidationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppValidationConfigurationOutput`](crate::output::DeleteAppValidationConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteAppValidationConfigurationOutput {
            crate::output::DeleteAppValidationConfigurationOutput {}
        }
    }
}
impl DeleteAppValidationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppValidationConfigurationOutput`](crate::output::DeleteAppValidationConfigurationOutput)
    pub fn builder() -> crate::output::delete_app_validation_configuration_output::Builder {
        crate::output::delete_app_validation_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppReplicationConfigurationOutput {}
impl std::fmt::Debug for DeleteAppReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppReplicationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppReplicationConfigurationOutput`](crate::output::DeleteAppReplicationConfigurationOutput)
pub mod delete_app_replication_configuration_output {
    /// A builder for [`DeleteAppReplicationConfigurationOutput`](crate::output::DeleteAppReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppReplicationConfigurationOutput`](crate::output::DeleteAppReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteAppReplicationConfigurationOutput {
            crate::output::DeleteAppReplicationConfigurationOutput {}
        }
    }
}
impl DeleteAppReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppReplicationConfigurationOutput`](crate::output::DeleteAppReplicationConfigurationOutput)
    pub fn builder() -> crate::output::delete_app_replication_configuration_output::Builder {
        crate::output::delete_app_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppLaunchConfigurationOutput {}
impl std::fmt::Debug for DeleteAppLaunchConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppLaunchConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppLaunchConfigurationOutput`](crate::output::DeleteAppLaunchConfigurationOutput)
pub mod delete_app_launch_configuration_output {
    /// A builder for [`DeleteAppLaunchConfigurationOutput`](crate::output::DeleteAppLaunchConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppLaunchConfigurationOutput`](crate::output::DeleteAppLaunchConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteAppLaunchConfigurationOutput {
            crate::output::DeleteAppLaunchConfigurationOutput {}
        }
    }
}
impl DeleteAppLaunchConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppLaunchConfigurationOutput`](crate::output::DeleteAppLaunchConfigurationOutput)
    pub fn builder() -> crate::output::delete_app_launch_configuration_output::Builder {
        crate::output::delete_app_launch_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppOutput {}
impl std::fmt::Debug for DeleteAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppOutput`](crate::output::DeleteAppOutput)
pub mod delete_app_output {
    /// A builder for [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppOutput`](crate::output::DeleteAppOutput)
        pub fn build(self) -> crate::output::DeleteAppOutput {
            crate::output::DeleteAppOutput {}
        }
    }
}
impl DeleteAppOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    pub fn builder() -> crate::output::delete_app_output::Builder {
        crate::output::delete_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationJobOutput {
    /// <p>The unique identifier of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
}
impl CreateReplicationJobOutput {
    /// <p>The unique identifier of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
}
impl std::fmt::Debug for CreateReplicationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationJobOutput");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.finish()
    }
}
/// See [`CreateReplicationJobOutput`](crate::output::CreateReplicationJobOutput)
pub mod create_replication_job_output {
    /// A builder for [`CreateReplicationJobOutput`](crate::output::CreateReplicationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationJobOutput`](crate::output::CreateReplicationJobOutput)
        pub fn build(self) -> crate::output::CreateReplicationJobOutput {
            crate::output::CreateReplicationJobOutput {
                replication_job_id: self.replication_job_id,
            }
        }
    }
}
impl CreateReplicationJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateReplicationJobOutput`](crate::output::CreateReplicationJobOutput)
    pub fn builder() -> crate::output::create_replication_job_output::Builder {
        crate::output::create_replication_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppOutput {
    /// <p>A summary description of the application.</p>
    pub app_summary: std::option::Option<crate::model::AppSummary>,
    /// <p>The server groups included in the application.</p>
    pub server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
    /// <p>The tags associated with the application.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateAppOutput {
    /// <p>A summary description of the application.</p>
    pub fn app_summary(&self) -> std::option::Option<&crate::model::AppSummary> {
        self.app_summary.as_ref()
    }
    /// <p>The server groups included in the application.</p>
    pub fn server_groups(&self) -> std::option::Option<&[crate::model::ServerGroup]> {
        self.server_groups.as_deref()
    }
    /// <p>The tags associated with the application.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppOutput");
        formatter.field("app_summary", &self.app_summary);
        formatter.field("server_groups", &self.server_groups);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateAppOutput`](crate::output::CreateAppOutput)
pub mod create_app_output {
    /// A builder for [`CreateAppOutput`](crate::output::CreateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_summary: std::option::Option<crate::model::AppSummary>,
        pub(crate) server_groups: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A summary description of the application.</p>
        pub fn app_summary(mut self, input: crate::model::AppSummary) -> Self {
            self.app_summary = Some(input);
            self
        }
        /// <p>A summary description of the application.</p>
        pub fn set_app_summary(
            mut self,
            input: std::option::Option<crate::model::AppSummary>,
        ) -> Self {
            self.app_summary = input;
            self
        }
        /// Appends an item to `server_groups`.
        ///
        /// To override the contents of this collection use [`set_server_groups`](Self::set_server_groups).
        ///
        /// <p>The server groups included in the application.</p>
        pub fn server_groups(mut self, input: impl Into<crate::model::ServerGroup>) -> Self {
            let mut v = self.server_groups.unwrap_or_default();
            v.push(input.into());
            self.server_groups = Some(v);
            self
        }
        /// <p>The server groups included in the application.</p>
        pub fn set_server_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerGroup>>,
        ) -> Self {
            self.server_groups = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the application.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppOutput`](crate::output::CreateAppOutput)
        pub fn build(self) -> crate::output::CreateAppOutput {
            crate::output::CreateAppOutput {
                app_summary: self.app_summary,
                server_groups: self.server_groups,
                tags: self.tags,
            }
        }
    }
}
impl CreateAppOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppOutput`](crate::output::CreateAppOutput)
    pub fn builder() -> crate::output::create_app_output::Builder {
        crate::output::create_app_output::Builder::default()
    }
}
