// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseType {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    Byol,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseType {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => LicenseType::Aws,
            "BYOL" => LicenseType::Byol,
            other => LicenseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseType::from(s))
    }
}
impl LicenseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseType::Aws => "AWS",
            LicenseType::Byol => "BYOL",
            LicenseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "BYOL"]
    }
}
impl AsRef<str> for LicenseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Key/value pair that can be assigned to an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Logical grouping of servers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerGroup {
    /// <p>The ID of a server group.</p>
    pub server_group_id: std::option::Option<std::string::String>,
    /// <p>The name of a server group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The servers that belong to a server group.</p>
    pub server_list: std::option::Option<std::vec::Vec<crate::model::Server>>,
}
impl ServerGroup {
    /// <p>The ID of a server group.</p>
    pub fn server_group_id(&self) -> std::option::Option<&str> {
        self.server_group_id.as_deref()
    }
    /// <p>The name of a server group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The servers that belong to a server group.</p>
    pub fn server_list(&self) -> std::option::Option<&[crate::model::Server]> {
        self.server_list.as_deref()
    }
}
impl std::fmt::Debug for ServerGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerGroup");
        formatter.field("server_group_id", &self.server_group_id);
        formatter.field("name", &self.name);
        formatter.field("server_list", &self.server_list);
        formatter.finish()
    }
}
/// See [`ServerGroup`](crate::model::ServerGroup)
pub mod server_group {
    /// A builder for [`ServerGroup`](crate::model::ServerGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) server_list: std::option::Option<std::vec::Vec<crate::model::Server>>,
    }
    impl Builder {
        /// <p>The ID of a server group.</p>
        pub fn server_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_group_id = Some(input.into());
            self
        }
        /// <p>The ID of a server group.</p>
        pub fn set_server_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_group_id = input;
            self
        }
        /// <p>The name of a server group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a server group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `server_list`.
        ///
        /// To override the contents of this collection use [`set_server_list`](Self::set_server_list).
        ///
        /// <p>The servers that belong to a server group.</p>
        pub fn server_list(mut self, input: impl Into<crate::model::Server>) -> Self {
            let mut v = self.server_list.unwrap_or_default();
            v.push(input.into());
            self.server_list = Some(v);
            self
        }
        /// <p>The servers that belong to a server group.</p>
        pub fn set_server_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Server>>,
        ) -> Self {
            self.server_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerGroup`](crate::model::ServerGroup)
        pub fn build(self) -> crate::model::ServerGroup {
            crate::model::ServerGroup {
                server_group_id: self.server_group_id,
                name: self.name,
                server_list: self.server_list,
            }
        }
    }
}
impl ServerGroup {
    /// Creates a new builder-style object to manufacture [`ServerGroup`](crate::model::ServerGroup)
    pub fn builder() -> crate::model::server_group::Builder {
        crate::model::server_group::Builder::default()
    }
}

/// <p>Represents a server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Server {
    /// <p>The ID of the server.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The type of server.</p>
    pub server_type: std::option::Option<crate::model::ServerType>,
    /// <p>Information about the VM server.</p>
    pub vm_server: std::option::Option<crate::model::VmServer>,
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the replication job is deleted or failed.</p>
    pub replication_job_terminated: std::option::Option<bool>,
}
impl Server {
    /// <p>The ID of the server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The type of server.</p>
    pub fn server_type(&self) -> std::option::Option<&crate::model::ServerType> {
        self.server_type.as_ref()
    }
    /// <p>Information about the VM server.</p>
    pub fn vm_server(&self) -> std::option::Option<&crate::model::VmServer> {
        self.vm_server.as_ref()
    }
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>Indicates whether the replication job is deleted or failed.</p>
    pub fn replication_job_terminated(&self) -> std::option::Option<bool> {
        self.replication_job_terminated
    }
}
impl std::fmt::Debug for Server {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Server");
        formatter.field("server_id", &self.server_id);
        formatter.field("server_type", &self.server_type);
        formatter.field("vm_server", &self.vm_server);
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field(
            "replication_job_terminated",
            &self.replication_job_terminated,
        );
        formatter.finish()
    }
}
/// See [`Server`](crate::model::Server)
pub mod server {
    /// A builder for [`Server`](crate::model::Server)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) server_type: std::option::Option<crate::model::ServerType>,
        pub(crate) vm_server: std::option::Option<crate::model::VmServer>,
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) replication_job_terminated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The type of server.</p>
        pub fn server_type(mut self, input: crate::model::ServerType) -> Self {
            self.server_type = Some(input);
            self
        }
        /// <p>The type of server.</p>
        pub fn set_server_type(
            mut self,
            input: std::option::Option<crate::model::ServerType>,
        ) -> Self {
            self.server_type = input;
            self
        }
        /// <p>Information about the VM server.</p>
        pub fn vm_server(mut self, input: crate::model::VmServer) -> Self {
            self.vm_server = Some(input);
            self
        }
        /// <p>Information about the VM server.</p>
        pub fn set_vm_server(mut self, input: std::option::Option<crate::model::VmServer>) -> Self {
            self.vm_server = input;
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>Indicates whether the replication job is deleted or failed.</p>
        pub fn replication_job_terminated(mut self, input: bool) -> Self {
            self.replication_job_terminated = Some(input);
            self
        }
        /// <p>Indicates whether the replication job is deleted or failed.</p>
        pub fn set_replication_job_terminated(mut self, input: std::option::Option<bool>) -> Self {
            self.replication_job_terminated = input;
            self
        }
        /// Consumes the builder and constructs a [`Server`](crate::model::Server)
        pub fn build(self) -> crate::model::Server {
            crate::model::Server {
                server_id: self.server_id,
                server_type: self.server_type,
                vm_server: self.vm_server,
                replication_job_id: self.replication_job_id,
                replication_job_terminated: self.replication_job_terminated,
            }
        }
    }
}
impl Server {
    /// Creates a new builder-style object to manufacture [`Server`](crate::model::Server)
    pub fn builder() -> crate::model::server::Builder {
        crate::model::server::Builder::default()
    }
}

/// <p>Represents a VM server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VmServer {
    /// <p>The VM server location.</p>
    pub vm_server_address: std::option::Option<crate::model::VmServerAddress>,
    /// <p>The name of the VM.</p>
    pub vm_name: std::option::Option<std::string::String>,
    /// <p>The name of the VM manager.</p>
    pub vm_manager_name: std::option::Option<std::string::String>,
    /// <p>The type of VM management product.</p>
    pub vm_manager_type: std::option::Option<crate::model::VmManagerType>,
    /// <p>The VM folder path in the vCenter Server virtual machine inventory tree.</p>
    pub vm_path: std::option::Option<std::string::String>,
}
impl VmServer {
    /// <p>The VM server location.</p>
    pub fn vm_server_address(&self) -> std::option::Option<&crate::model::VmServerAddress> {
        self.vm_server_address.as_ref()
    }
    /// <p>The name of the VM.</p>
    pub fn vm_name(&self) -> std::option::Option<&str> {
        self.vm_name.as_deref()
    }
    /// <p>The name of the VM manager.</p>
    pub fn vm_manager_name(&self) -> std::option::Option<&str> {
        self.vm_manager_name.as_deref()
    }
    /// <p>The type of VM management product.</p>
    pub fn vm_manager_type(&self) -> std::option::Option<&crate::model::VmManagerType> {
        self.vm_manager_type.as_ref()
    }
    /// <p>The VM folder path in the vCenter Server virtual machine inventory tree.</p>
    pub fn vm_path(&self) -> std::option::Option<&str> {
        self.vm_path.as_deref()
    }
}
impl std::fmt::Debug for VmServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VmServer");
        formatter.field("vm_server_address", &self.vm_server_address);
        formatter.field("vm_name", &self.vm_name);
        formatter.field("vm_manager_name", &self.vm_manager_name);
        formatter.field("vm_manager_type", &self.vm_manager_type);
        formatter.field("vm_path", &self.vm_path);
        formatter.finish()
    }
}
/// See [`VmServer`](crate::model::VmServer)
pub mod vm_server {
    /// A builder for [`VmServer`](crate::model::VmServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vm_server_address: std::option::Option<crate::model::VmServerAddress>,
        pub(crate) vm_name: std::option::Option<std::string::String>,
        pub(crate) vm_manager_name: std::option::Option<std::string::String>,
        pub(crate) vm_manager_type: std::option::Option<crate::model::VmManagerType>,
        pub(crate) vm_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The VM server location.</p>
        pub fn vm_server_address(mut self, input: crate::model::VmServerAddress) -> Self {
            self.vm_server_address = Some(input);
            self
        }
        /// <p>The VM server location.</p>
        pub fn set_vm_server_address(
            mut self,
            input: std::option::Option<crate::model::VmServerAddress>,
        ) -> Self {
            self.vm_server_address = input;
            self
        }
        /// <p>The name of the VM.</p>
        pub fn vm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_name = Some(input.into());
            self
        }
        /// <p>The name of the VM.</p>
        pub fn set_vm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_name = input;
            self
        }
        /// <p>The name of the VM manager.</p>
        pub fn vm_manager_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_manager_name = Some(input.into());
            self
        }
        /// <p>The name of the VM manager.</p>
        pub fn set_vm_manager_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vm_manager_name = input;
            self
        }
        /// <p>The type of VM management product.</p>
        pub fn vm_manager_type(mut self, input: crate::model::VmManagerType) -> Self {
            self.vm_manager_type = Some(input);
            self
        }
        /// <p>The type of VM management product.</p>
        pub fn set_vm_manager_type(
            mut self,
            input: std::option::Option<crate::model::VmManagerType>,
        ) -> Self {
            self.vm_manager_type = input;
            self
        }
        /// <p>The VM folder path in the vCenter Server virtual machine inventory tree.</p>
        pub fn vm_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_path = Some(input.into());
            self
        }
        /// <p>The VM folder path in the vCenter Server virtual machine inventory tree.</p>
        pub fn set_vm_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_path = input;
            self
        }
        /// Consumes the builder and constructs a [`VmServer`](crate::model::VmServer)
        pub fn build(self) -> crate::model::VmServer {
            crate::model::VmServer {
                vm_server_address: self.vm_server_address,
                vm_name: self.vm_name,
                vm_manager_name: self.vm_manager_name,
                vm_manager_type: self.vm_manager_type,
                vm_path: self.vm_path,
            }
        }
    }
}
impl VmServer {
    /// Creates a new builder-style object to manufacture [`VmServer`](crate::model::VmServer)
    pub fn builder() -> crate::model::vm_server::Builder {
        crate::model::vm_server::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VmManagerType {
    #[allow(missing_docs)] // documentation missing in model
    HyperVManager,
    #[allow(missing_docs)] // documentation missing in model
    Scvmm,
    #[allow(missing_docs)] // documentation missing in model
    VSphere,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VmManagerType {
    fn from(s: &str) -> Self {
        match s {
            "HYPERV-MANAGER" => VmManagerType::HyperVManager,
            "SCVMM" => VmManagerType::Scvmm,
            "VSPHERE" => VmManagerType::VSphere,
            other => VmManagerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VmManagerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VmManagerType::from(s))
    }
}
impl VmManagerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VmManagerType::HyperVManager => "HYPERV-MANAGER",
            VmManagerType::Scvmm => "SCVMM",
            VmManagerType::VSphere => "VSPHERE",
            VmManagerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HYPERV-MANAGER", "SCVMM", "VSPHERE"]
    }
}
impl AsRef<str> for VmManagerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a VM server location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VmServerAddress {
    /// <p>The ID of the VM manager.</p>
    pub vm_manager_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VM.</p>
    pub vm_id: std::option::Option<std::string::String>,
}
impl VmServerAddress {
    /// <p>The ID of the VM manager.</p>
    pub fn vm_manager_id(&self) -> std::option::Option<&str> {
        self.vm_manager_id.as_deref()
    }
    /// <p>The ID of the VM.</p>
    pub fn vm_id(&self) -> std::option::Option<&str> {
        self.vm_id.as_deref()
    }
}
impl std::fmt::Debug for VmServerAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VmServerAddress");
        formatter.field("vm_manager_id", &self.vm_manager_id);
        formatter.field("vm_id", &self.vm_id);
        formatter.finish()
    }
}
/// See [`VmServerAddress`](crate::model::VmServerAddress)
pub mod vm_server_address {
    /// A builder for [`VmServerAddress`](crate::model::VmServerAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vm_manager_id: std::option::Option<std::string::String>,
        pub(crate) vm_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VM manager.</p>
        pub fn vm_manager_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_manager_id = Some(input.into());
            self
        }
        /// <p>The ID of the VM manager.</p>
        pub fn set_vm_manager_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vm_manager_id = input;
            self
        }
        /// <p>The ID of the VM.</p>
        pub fn vm_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_id = Some(input.into());
            self
        }
        /// <p>The ID of the VM.</p>
        pub fn set_vm_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vm_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VmServerAddress`](crate::model::VmServerAddress)
        pub fn build(self) -> crate::model::VmServerAddress {
            crate::model::VmServerAddress {
                vm_manager_id: self.vm_manager_id,
                vm_id: self.vm_id,
            }
        }
    }
}
impl VmServerAddress {
    /// Creates a new builder-style object to manufacture [`VmServerAddress`](crate::model::VmServerAddress)
    pub fn builder() -> crate::model::vm_server_address::Builder {
        crate::model::vm_server_address::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerType {
    #[allow(missing_docs)] // documentation missing in model
    VirtualMachine,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerType {
    fn from(s: &str) -> Self {
        match s {
            "VIRTUAL_MACHINE" => ServerType::VirtualMachine,
            other => ServerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerType::from(s))
    }
}
impl ServerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerType::VirtualMachine => "VIRTUAL_MACHINE",
            ServerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VIRTUAL_MACHINE"]
    }
}
impl AsRef<str> for ServerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppSummary {
    /// <p>The unique ID of the application.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The ID of the application.</p>
    pub imported_app_id: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Status of the application.</p>
    pub status: std::option::Option<crate::model::AppStatus>,
    /// <p>A message related to the status of the application</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>Status of the replication configuration.</p>
    pub replication_configuration_status:
        std::option::Option<crate::model::AppReplicationConfigurationStatus>,
    /// <p>The replication status of the application.</p>
    pub replication_status: std::option::Option<crate::model::AppReplicationStatus>,
    /// <p>A message related to the replication status of the application.</p>
    pub replication_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of the application's most recent successful replication.</p>
    pub latest_replication_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Status of the launch configuration.</p>
    pub launch_configuration_status:
        std::option::Option<crate::model::AppLaunchConfigurationStatus>,
    /// <p>The launch status of the application.</p>
    pub launch_status: std::option::Option<crate::model::AppLaunchStatus>,
    /// <p>A message related to the launch status of the application.</p>
    pub launch_status_message: std::option::Option<std::string::String>,
    /// <p>Details about the latest launch of the application.</p>
    pub launch_details: std::option::Option<crate::model::LaunchDetails>,
    /// <p>The creation time of the application.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last modified time of the application.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The number of server groups present in the application.</p>
    pub total_server_groups: std::option::Option<i32>,
    /// <p>The number of servers present in the application.</p>
    pub total_servers: std::option::Option<i32>,
}
impl AppSummary {
    /// <p>The unique ID of the application.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The ID of the application.</p>
    pub fn imported_app_id(&self) -> std::option::Option<&str> {
        self.imported_app_id.as_deref()
    }
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Status of the application.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AppStatus> {
        self.status.as_ref()
    }
    /// <p>A message related to the status of the application</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>Status of the replication configuration.</p>
    pub fn replication_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::AppReplicationConfigurationStatus> {
        self.replication_configuration_status.as_ref()
    }
    /// <p>The replication status of the application.</p>
    pub fn replication_status(&self) -> std::option::Option<&crate::model::AppReplicationStatus> {
        self.replication_status.as_ref()
    }
    /// <p>A message related to the replication status of the application.</p>
    pub fn replication_status_message(&self) -> std::option::Option<&str> {
        self.replication_status_message.as_deref()
    }
    /// <p>The timestamp of the application's most recent successful replication.</p>
    pub fn latest_replication_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_replication_time.as_ref()
    }
    /// <p>Status of the launch configuration.</p>
    pub fn launch_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::AppLaunchConfigurationStatus> {
        self.launch_configuration_status.as_ref()
    }
    /// <p>The launch status of the application.</p>
    pub fn launch_status(&self) -> std::option::Option<&crate::model::AppLaunchStatus> {
        self.launch_status.as_ref()
    }
    /// <p>A message related to the launch status of the application.</p>
    pub fn launch_status_message(&self) -> std::option::Option<&str> {
        self.launch_status_message.as_deref()
    }
    /// <p>Details about the latest launch of the application.</p>
    pub fn launch_details(&self) -> std::option::Option<&crate::model::LaunchDetails> {
        self.launch_details.as_ref()
    }
    /// <p>The creation time of the application.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last modified time of the application.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The number of server groups present in the application.</p>
    pub fn total_server_groups(&self) -> std::option::Option<i32> {
        self.total_server_groups
    }
    /// <p>The number of servers present in the application.</p>
    pub fn total_servers(&self) -> std::option::Option<i32> {
        self.total_servers
    }
}
impl std::fmt::Debug for AppSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppSummary");
        formatter.field("app_id", &self.app_id);
        formatter.field("imported_app_id", &self.imported_app_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "replication_configuration_status",
            &self.replication_configuration_status,
        );
        formatter.field("replication_status", &self.replication_status);
        formatter.field(
            "replication_status_message",
            &self.replication_status_message,
        );
        formatter.field("latest_replication_time", &self.latest_replication_time);
        formatter.field(
            "launch_configuration_status",
            &self.launch_configuration_status,
        );
        formatter.field("launch_status", &self.launch_status);
        formatter.field("launch_status_message", &self.launch_status_message);
        formatter.field("launch_details", &self.launch_details);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("role_name", &self.role_name);
        formatter.field("total_server_groups", &self.total_server_groups);
        formatter.field("total_servers", &self.total_servers);
        formatter.finish()
    }
}
/// See [`AppSummary`](crate::model::AppSummary)
pub mod app_summary {
    /// A builder for [`AppSummary`](crate::model::AppSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) imported_app_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AppStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) replication_configuration_status:
            std::option::Option<crate::model::AppReplicationConfigurationStatus>,
        pub(crate) replication_status: std::option::Option<crate::model::AppReplicationStatus>,
        pub(crate) replication_status_message: std::option::Option<std::string::String>,
        pub(crate) latest_replication_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) launch_configuration_status:
            std::option::Option<crate::model::AppLaunchConfigurationStatus>,
        pub(crate) launch_status: std::option::Option<crate::model::AppLaunchStatus>,
        pub(crate) launch_status_message: std::option::Option<std::string::String>,
        pub(crate) launch_details: std::option::Option<crate::model::LaunchDetails>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) total_server_groups: std::option::Option<i32>,
        pub(crate) total_servers: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique ID of the application.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the application.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The ID of the application.</p>
        pub fn imported_app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_app_id = Some(input.into());
            self
        }
        /// <p>The ID of the application.</p>
        pub fn set_imported_app_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_app_id = input;
            self
        }
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Status of the application.</p>
        pub fn status(mut self, input: crate::model::AppStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the application.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AppStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>A message related to the status of the application</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message related to the status of the application</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>Status of the replication configuration.</p>
        pub fn replication_configuration_status(
            mut self,
            input: crate::model::AppReplicationConfigurationStatus,
        ) -> Self {
            self.replication_configuration_status = Some(input);
            self
        }
        /// <p>Status of the replication configuration.</p>
        pub fn set_replication_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AppReplicationConfigurationStatus>,
        ) -> Self {
            self.replication_configuration_status = input;
            self
        }
        /// <p>The replication status of the application.</p>
        pub fn replication_status(mut self, input: crate::model::AppReplicationStatus) -> Self {
            self.replication_status = Some(input);
            self
        }
        /// <p>The replication status of the application.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<crate::model::AppReplicationStatus>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// <p>A message related to the replication status of the application.</p>
        pub fn replication_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_status_message = Some(input.into());
            self
        }
        /// <p>A message related to the replication status of the application.</p>
        pub fn set_replication_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_status_message = input;
            self
        }
        /// <p>The timestamp of the application's most recent successful replication.</p>
        pub fn latest_replication_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_replication_time = Some(input);
            self
        }
        /// <p>The timestamp of the application's most recent successful replication.</p>
        pub fn set_latest_replication_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_replication_time = input;
            self
        }
        /// <p>Status of the launch configuration.</p>
        pub fn launch_configuration_status(
            mut self,
            input: crate::model::AppLaunchConfigurationStatus,
        ) -> Self {
            self.launch_configuration_status = Some(input);
            self
        }
        /// <p>Status of the launch configuration.</p>
        pub fn set_launch_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AppLaunchConfigurationStatus>,
        ) -> Self {
            self.launch_configuration_status = input;
            self
        }
        /// <p>The launch status of the application.</p>
        pub fn launch_status(mut self, input: crate::model::AppLaunchStatus) -> Self {
            self.launch_status = Some(input);
            self
        }
        /// <p>The launch status of the application.</p>
        pub fn set_launch_status(
            mut self,
            input: std::option::Option<crate::model::AppLaunchStatus>,
        ) -> Self {
            self.launch_status = input;
            self
        }
        /// <p>A message related to the launch status of the application.</p>
        pub fn launch_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_status_message = Some(input.into());
            self
        }
        /// <p>A message related to the launch status of the application.</p>
        pub fn set_launch_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_status_message = input;
            self
        }
        /// <p>Details about the latest launch of the application.</p>
        pub fn launch_details(mut self, input: crate::model::LaunchDetails) -> Self {
            self.launch_details = Some(input);
            self
        }
        /// <p>Details about the latest launch of the application.</p>
        pub fn set_launch_details(
            mut self,
            input: std::option::Option<crate::model::LaunchDetails>,
        ) -> Self {
            self.launch_details = input;
            self
        }
        /// <p>The creation time of the application.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the application.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last modified time of the application.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The last modified time of the application.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service role in the customer's account used by AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The number of server groups present in the application.</p>
        pub fn total_server_groups(mut self, input: i32) -> Self {
            self.total_server_groups = Some(input);
            self
        }
        /// <p>The number of server groups present in the application.</p>
        pub fn set_total_server_groups(mut self, input: std::option::Option<i32>) -> Self {
            self.total_server_groups = input;
            self
        }
        /// <p>The number of servers present in the application.</p>
        pub fn total_servers(mut self, input: i32) -> Self {
            self.total_servers = Some(input);
            self
        }
        /// <p>The number of servers present in the application.</p>
        pub fn set_total_servers(mut self, input: std::option::Option<i32>) -> Self {
            self.total_servers = input;
            self
        }
        /// Consumes the builder and constructs a [`AppSummary`](crate::model::AppSummary)
        pub fn build(self) -> crate::model::AppSummary {
            crate::model::AppSummary {
                app_id: self.app_id,
                imported_app_id: self.imported_app_id,
                name: self.name,
                description: self.description,
                status: self.status,
                status_message: self.status_message,
                replication_configuration_status: self.replication_configuration_status,
                replication_status: self.replication_status,
                replication_status_message: self.replication_status_message,
                latest_replication_time: self.latest_replication_time,
                launch_configuration_status: self.launch_configuration_status,
                launch_status: self.launch_status,
                launch_status_message: self.launch_status_message,
                launch_details: self.launch_details,
                creation_time: self.creation_time,
                last_modified: self.last_modified,
                role_name: self.role_name,
                total_server_groups: self.total_server_groups,
                total_servers: self.total_servers,
            }
        }
    }
}
impl AppSummary {
    /// Creates a new builder-style object to manufacture [`AppSummary`](crate::model::AppSummary)
    pub fn builder() -> crate::model::app_summary::Builder {
        crate::model::app_summary::Builder::default()
    }
}

/// <p>Details about the latest launch of an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchDetails {
    /// <p>The latest time that this application was launched successfully.</p>
    pub latest_launch_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the latest stack launched for this application.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The ID of the latest stack launched for this application.</p>
    pub stack_id: std::option::Option<std::string::String>,
}
impl LaunchDetails {
    /// <p>The latest time that this application was launched successfully.</p>
    pub fn latest_launch_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_launch_time.as_ref()
    }
    /// <p>The name of the latest stack launched for this application.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The ID of the latest stack launched for this application.</p>
    pub fn stack_id(&self) -> std::option::Option<&str> {
        self.stack_id.as_deref()
    }
}
impl std::fmt::Debug for LaunchDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchDetails");
        formatter.field("latest_launch_time", &self.latest_launch_time);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("stack_id", &self.stack_id);
        formatter.finish()
    }
}
/// See [`LaunchDetails`](crate::model::LaunchDetails)
pub mod launch_details {
    /// A builder for [`LaunchDetails`](crate::model::LaunchDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latest_launch_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) stack_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The latest time that this application was launched successfully.</p>
        pub fn latest_launch_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_launch_time = Some(input);
            self
        }
        /// <p>The latest time that this application was launched successfully.</p>
        pub fn set_latest_launch_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_launch_time = input;
            self
        }
        /// <p>The name of the latest stack launched for this application.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the latest stack launched for this application.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The ID of the latest stack launched for this application.</p>
        pub fn stack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_id = Some(input.into());
            self
        }
        /// <p>The ID of the latest stack launched for this application.</p>
        pub fn set_stack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchDetails`](crate::model::LaunchDetails)
        pub fn build(self) -> crate::model::LaunchDetails {
            crate::model::LaunchDetails {
                latest_launch_time: self.latest_launch_time,
                stack_name: self.stack_name,
                stack_id: self.stack_id,
            }
        }
    }
}
impl LaunchDetails {
    /// Creates a new builder-style object to manufacture [`LaunchDetails`](crate::model::LaunchDetails)
    pub fn builder() -> crate::model::launch_details::Builder {
        crate::model::launch_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppLaunchStatus {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeltaLaunchFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeltaLaunchInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Launched,
    #[allow(missing_docs)] // documentation missing in model
    LaunchFailed,
    #[allow(missing_docs)] // documentation missing in model
    LaunchInProgress,
    #[allow(missing_docs)] // documentation missing in model
    LaunchPending,
    #[allow(missing_docs)] // documentation missing in model
    PartiallyLaunched,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForLaunch,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    TerminateFailed,
    #[allow(missing_docs)] // documentation missing in model
    TerminateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ValidationInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppLaunchStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURATION_INVALID" => AppLaunchStatus::ConfigurationInvalid,
            "CONFIGURATION_IN_PROGRESS" => AppLaunchStatus::ConfigurationInProgress,
            "DELTA_LAUNCH_FAILED" => AppLaunchStatus::DeltaLaunchFailed,
            "DELTA_LAUNCH_IN_PROGRESS" => AppLaunchStatus::DeltaLaunchInProgress,
            "LAUNCHED" => AppLaunchStatus::Launched,
            "LAUNCH_FAILED" => AppLaunchStatus::LaunchFailed,
            "LAUNCH_IN_PROGRESS" => AppLaunchStatus::LaunchInProgress,
            "LAUNCH_PENDING" => AppLaunchStatus::LaunchPending,
            "PARTIALLY_LAUNCHED" => AppLaunchStatus::PartiallyLaunched,
            "READY_FOR_CONFIGURATION" => AppLaunchStatus::ReadyForConfiguration,
            "READY_FOR_LAUNCH" => AppLaunchStatus::ReadyForLaunch,
            "TERMINATED" => AppLaunchStatus::Terminated,
            "TERMINATE_FAILED" => AppLaunchStatus::TerminateFailed,
            "TERMINATE_IN_PROGRESS" => AppLaunchStatus::TerminateInProgress,
            "VALIDATION_IN_PROGRESS" => AppLaunchStatus::ValidationInProgress,
            other => AppLaunchStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppLaunchStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppLaunchStatus::from(s))
    }
}
impl AppLaunchStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppLaunchStatus::ConfigurationInvalid => "CONFIGURATION_INVALID",
            AppLaunchStatus::ConfigurationInProgress => "CONFIGURATION_IN_PROGRESS",
            AppLaunchStatus::DeltaLaunchFailed => "DELTA_LAUNCH_FAILED",
            AppLaunchStatus::DeltaLaunchInProgress => "DELTA_LAUNCH_IN_PROGRESS",
            AppLaunchStatus::Launched => "LAUNCHED",
            AppLaunchStatus::LaunchFailed => "LAUNCH_FAILED",
            AppLaunchStatus::LaunchInProgress => "LAUNCH_IN_PROGRESS",
            AppLaunchStatus::LaunchPending => "LAUNCH_PENDING",
            AppLaunchStatus::PartiallyLaunched => "PARTIALLY_LAUNCHED",
            AppLaunchStatus::ReadyForConfiguration => "READY_FOR_CONFIGURATION",
            AppLaunchStatus::ReadyForLaunch => "READY_FOR_LAUNCH",
            AppLaunchStatus::Terminated => "TERMINATED",
            AppLaunchStatus::TerminateFailed => "TERMINATE_FAILED",
            AppLaunchStatus::TerminateInProgress => "TERMINATE_IN_PROGRESS",
            AppLaunchStatus::ValidationInProgress => "VALIDATION_IN_PROGRESS",
            AppLaunchStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIGURATION_INVALID",
            "CONFIGURATION_IN_PROGRESS",
            "DELTA_LAUNCH_FAILED",
            "DELTA_LAUNCH_IN_PROGRESS",
            "LAUNCHED",
            "LAUNCH_FAILED",
            "LAUNCH_IN_PROGRESS",
            "LAUNCH_PENDING",
            "PARTIALLY_LAUNCHED",
            "READY_FOR_CONFIGURATION",
            "READY_FOR_LAUNCH",
            "TERMINATED",
            "TERMINATE_FAILED",
            "TERMINATE_IN_PROGRESS",
            "VALIDATION_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for AppLaunchStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppLaunchConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Configured,
    #[allow(missing_docs)] // documentation missing in model
    NotConfigured,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppLaunchConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURED" => AppLaunchConfigurationStatus::Configured,
            "NOT_CONFIGURED" => AppLaunchConfigurationStatus::NotConfigured,
            other => AppLaunchConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppLaunchConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppLaunchConfigurationStatus::from(s))
    }
}
impl AppLaunchConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppLaunchConfigurationStatus::Configured => "CONFIGURED",
            AppLaunchConfigurationStatus::NotConfigured => "NOT_CONFIGURED",
            AppLaunchConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIGURED", "NOT_CONFIGURED"]
    }
}
impl AsRef<str> for AppLaunchConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppReplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationInvalid,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeltaReplicated,
    #[allow(missing_docs)] // documentation missing in model
    DeltaReplicationFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeltaReplicationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    PartiallyReplicated,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForReplication,
    #[allow(missing_docs)] // documentation missing in model
    Replicated,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationFailed,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationPending,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationStopped,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationStopping,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationStopFailed,
    #[allow(missing_docs)] // documentation missing in model
    ValidationInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppReplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURATION_INVALID" => AppReplicationStatus::ConfigurationInvalid,
            "CONFIGURATION_IN_PROGRESS" => AppReplicationStatus::ConfigurationInProgress,
            "DELTA_REPLICATED" => AppReplicationStatus::DeltaReplicated,
            "DELTA_REPLICATION_FAILED" => AppReplicationStatus::DeltaReplicationFailed,
            "DELTA_REPLICATION_IN_PROGRESS" => AppReplicationStatus::DeltaReplicationInProgress,
            "PARTIALLY_REPLICATED" => AppReplicationStatus::PartiallyReplicated,
            "READY_FOR_CONFIGURATION" => AppReplicationStatus::ReadyForConfiguration,
            "READY_FOR_REPLICATION" => AppReplicationStatus::ReadyForReplication,
            "REPLICATED" => AppReplicationStatus::Replicated,
            "REPLICATION_FAILED" => AppReplicationStatus::ReplicationFailed,
            "REPLICATION_IN_PROGRESS" => AppReplicationStatus::ReplicationInProgress,
            "REPLICATION_PENDING" => AppReplicationStatus::ReplicationPending,
            "REPLICATION_STOPPED" => AppReplicationStatus::ReplicationStopped,
            "REPLICATION_STOPPING" => AppReplicationStatus::ReplicationStopping,
            "REPLICATION_STOP_FAILED" => AppReplicationStatus::ReplicationStopFailed,
            "VALIDATION_IN_PROGRESS" => AppReplicationStatus::ValidationInProgress,
            other => AppReplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppReplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppReplicationStatus::from(s))
    }
}
impl AppReplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppReplicationStatus::ConfigurationInvalid => "CONFIGURATION_INVALID",
            AppReplicationStatus::ConfigurationInProgress => "CONFIGURATION_IN_PROGRESS",
            AppReplicationStatus::DeltaReplicated => "DELTA_REPLICATED",
            AppReplicationStatus::DeltaReplicationFailed => "DELTA_REPLICATION_FAILED",
            AppReplicationStatus::DeltaReplicationInProgress => "DELTA_REPLICATION_IN_PROGRESS",
            AppReplicationStatus::PartiallyReplicated => "PARTIALLY_REPLICATED",
            AppReplicationStatus::ReadyForConfiguration => "READY_FOR_CONFIGURATION",
            AppReplicationStatus::ReadyForReplication => "READY_FOR_REPLICATION",
            AppReplicationStatus::Replicated => "REPLICATED",
            AppReplicationStatus::ReplicationFailed => "REPLICATION_FAILED",
            AppReplicationStatus::ReplicationInProgress => "REPLICATION_IN_PROGRESS",
            AppReplicationStatus::ReplicationPending => "REPLICATION_PENDING",
            AppReplicationStatus::ReplicationStopped => "REPLICATION_STOPPED",
            AppReplicationStatus::ReplicationStopping => "REPLICATION_STOPPING",
            AppReplicationStatus::ReplicationStopFailed => "REPLICATION_STOP_FAILED",
            AppReplicationStatus::ValidationInProgress => "VALIDATION_IN_PROGRESS",
            AppReplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIGURATION_INVALID",
            "CONFIGURATION_IN_PROGRESS",
            "DELTA_REPLICATED",
            "DELTA_REPLICATION_FAILED",
            "DELTA_REPLICATION_IN_PROGRESS",
            "PARTIALLY_REPLICATED",
            "READY_FOR_CONFIGURATION",
            "READY_FOR_REPLICATION",
            "REPLICATED",
            "REPLICATION_FAILED",
            "REPLICATION_IN_PROGRESS",
            "REPLICATION_PENDING",
            "REPLICATION_STOPPED",
            "REPLICATION_STOPPING",
            "REPLICATION_STOP_FAILED",
            "VALIDATION_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for AppReplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppReplicationConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Configured,
    #[allow(missing_docs)] // documentation missing in model
    NotConfigured,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppReplicationConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURED" => AppReplicationConfigurationStatus::Configured,
            "NOT_CONFIGURED" => AppReplicationConfigurationStatus::NotConfigured,
            other => AppReplicationConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppReplicationConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppReplicationConfigurationStatus::from(s))
    }
}
impl AppReplicationConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppReplicationConfigurationStatus::Configured => "CONFIGURED",
            AppReplicationConfigurationStatus::NotConfigured => "NOT_CONFIGURED",
            AppReplicationConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIGURED", "NOT_CONFIGURED"]
    }
}
impl AsRef<str> for AppReplicationConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AppStatus::Active,
            "CREATING" => AppStatus::Creating,
            "DELETED" => AppStatus::Deleted,
            "DELETE_FAILED" => AppStatus::DeleteFailed,
            "DELETING" => AppStatus::Deleting,
            "UPDATING" => AppStatus::Updating,
            other => AppStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppStatus::from(s))
    }
}
impl AppStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppStatus::Active => "ACTIVE",
            AppStatus::Creating => "CREATING",
            AppStatus::Deleted => "DELETED",
            AppStatus::DeleteFailed => "DELETE_FAILED",
            AppStatus::Deleting => "DELETING",
            AppStatus::Updating => "UPDATING",
            AppStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "DELETED",
            "DELETE_FAILED",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for AppStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for validating an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerGroupValidationConfiguration {
    /// <p>The ID of the server group.</p>
    pub server_group_id: std::option::Option<std::string::String>,
    /// <p>The validation configuration.</p>
    pub server_validation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerValidationConfiguration>>,
}
impl ServerGroupValidationConfiguration {
    /// <p>The ID of the server group.</p>
    pub fn server_group_id(&self) -> std::option::Option<&str> {
        self.server_group_id.as_deref()
    }
    /// <p>The validation configuration.</p>
    pub fn server_validation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerValidationConfiguration]> {
        self.server_validation_configurations.as_deref()
    }
}
impl std::fmt::Debug for ServerGroupValidationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerGroupValidationConfiguration");
        formatter.field("server_group_id", &self.server_group_id);
        formatter.field(
            "server_validation_configurations",
            &self.server_validation_configurations,
        );
        formatter.finish()
    }
}
/// See [`ServerGroupValidationConfiguration`](crate::model::ServerGroupValidationConfiguration)
pub mod server_group_validation_configuration {
    /// A builder for [`ServerGroupValidationConfiguration`](crate::model::ServerGroupValidationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_group_id: std::option::Option<std::string::String>,
        pub(crate) server_validation_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerValidationConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the server group.</p>
        pub fn server_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the server group.</p>
        pub fn set_server_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_group_id = input;
            self
        }
        /// Appends an item to `server_validation_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_validation_configurations`](Self::set_server_validation_configurations).
        ///
        /// <p>The validation configuration.</p>
        pub fn server_validation_configurations(
            mut self,
            input: impl Into<crate::model::ServerValidationConfiguration>,
        ) -> Self {
            let mut v = self.server_validation_configurations.unwrap_or_default();
            v.push(input.into());
            self.server_validation_configurations = Some(v);
            self
        }
        /// <p>The validation configuration.</p>
        pub fn set_server_validation_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerValidationConfiguration>>,
        ) -> Self {
            self.server_validation_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerGroupValidationConfiguration`](crate::model::ServerGroupValidationConfiguration)
        pub fn build(self) -> crate::model::ServerGroupValidationConfiguration {
            crate::model::ServerGroupValidationConfiguration {
                server_group_id: self.server_group_id,
                server_validation_configurations: self.server_validation_configurations,
            }
        }
    }
}
impl ServerGroupValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerGroupValidationConfiguration`](crate::model::ServerGroupValidationConfiguration)
    pub fn builder() -> crate::model::server_group_validation_configuration::Builder {
        crate::model::server_group_validation_configuration::Builder::default()
    }
}

/// <p>Configuration for validating an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerValidationConfiguration {
    /// <p>Represents a server.</p>
    pub server: std::option::Option<crate::model::Server>,
    /// <p>The ID of the validation.</p>
    pub validation_id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The validation strategy.</p>
    pub server_validation_strategy: std::option::Option<crate::model::ServerValidationStrategy>,
    /// <p>The validation parameters.</p>
    pub user_data_validation_parameters:
        std::option::Option<crate::model::UserDataValidationParameters>,
}
impl ServerValidationConfiguration {
    /// <p>Represents a server.</p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
    /// <p>The ID of the validation.</p>
    pub fn validation_id(&self) -> std::option::Option<&str> {
        self.validation_id.as_deref()
    }
    /// <p>The name of the configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The validation strategy.</p>
    pub fn server_validation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ServerValidationStrategy> {
        self.server_validation_strategy.as_ref()
    }
    /// <p>The validation parameters.</p>
    pub fn user_data_validation_parameters(
        &self,
    ) -> std::option::Option<&crate::model::UserDataValidationParameters> {
        self.user_data_validation_parameters.as_ref()
    }
}
impl std::fmt::Debug for ServerValidationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerValidationConfiguration");
        formatter.field("server", &self.server);
        formatter.field("validation_id", &self.validation_id);
        formatter.field("name", &self.name);
        formatter.field(
            "server_validation_strategy",
            &self.server_validation_strategy,
        );
        formatter.field(
            "user_data_validation_parameters",
            &self.user_data_validation_parameters,
        );
        formatter.finish()
    }
}
/// See [`ServerValidationConfiguration`](crate::model::ServerValidationConfiguration)
pub mod server_validation_configuration {
    /// A builder for [`ServerValidationConfiguration`](crate::model::ServerValidationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
        pub(crate) validation_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) server_validation_strategy:
            std::option::Option<crate::model::ServerValidationStrategy>,
        pub(crate) user_data_validation_parameters:
            std::option::Option<crate::model::UserDataValidationParameters>,
    }
    impl Builder {
        /// <p>Represents a server.</p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Represents a server.</p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// <p>The ID of the validation.</p>
        pub fn validation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_id = Some(input.into());
            self
        }
        /// <p>The ID of the validation.</p>
        pub fn set_validation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_id = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The validation strategy.</p>
        pub fn server_validation_strategy(
            mut self,
            input: crate::model::ServerValidationStrategy,
        ) -> Self {
            self.server_validation_strategy = Some(input);
            self
        }
        /// <p>The validation strategy.</p>
        pub fn set_server_validation_strategy(
            mut self,
            input: std::option::Option<crate::model::ServerValidationStrategy>,
        ) -> Self {
            self.server_validation_strategy = input;
            self
        }
        /// <p>The validation parameters.</p>
        pub fn user_data_validation_parameters(
            mut self,
            input: crate::model::UserDataValidationParameters,
        ) -> Self {
            self.user_data_validation_parameters = Some(input);
            self
        }
        /// <p>The validation parameters.</p>
        pub fn set_user_data_validation_parameters(
            mut self,
            input: std::option::Option<crate::model::UserDataValidationParameters>,
        ) -> Self {
            self.user_data_validation_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerValidationConfiguration`](crate::model::ServerValidationConfiguration)
        pub fn build(self) -> crate::model::ServerValidationConfiguration {
            crate::model::ServerValidationConfiguration {
                server: self.server,
                validation_id: self.validation_id,
                name: self.name,
                server_validation_strategy: self.server_validation_strategy,
                user_data_validation_parameters: self.user_data_validation_parameters,
            }
        }
    }
}
impl ServerValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerValidationConfiguration`](crate::model::ServerValidationConfiguration)
    pub fn builder() -> crate::model::server_validation_configuration::Builder {
        crate::model::server_validation_configuration::Builder::default()
    }
}

/// <p>Contains validation parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDataValidationParameters {
    /// <p>The location of the validation script.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>The type of validation script.</p>
    pub script_type: std::option::Option<crate::model::ScriptType>,
}
impl UserDataValidationParameters {
    /// <p>The location of the validation script.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
    /// <p>The type of validation script.</p>
    pub fn script_type(&self) -> std::option::Option<&crate::model::ScriptType> {
        self.script_type.as_ref()
    }
}
impl std::fmt::Debug for UserDataValidationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDataValidationParameters");
        formatter.field("source", &self.source);
        formatter.field("script_type", &self.script_type);
        formatter.finish()
    }
}
/// See [`UserDataValidationParameters`](crate::model::UserDataValidationParameters)
pub mod user_data_validation_parameters {
    /// A builder for [`UserDataValidationParameters`](crate::model::UserDataValidationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) script_type: std::option::Option<crate::model::ScriptType>,
    }
    impl Builder {
        /// <p>The location of the validation script.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The location of the validation script.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>The type of validation script.</p>
        pub fn script_type(mut self, input: crate::model::ScriptType) -> Self {
            self.script_type = Some(input);
            self
        }
        /// <p>The type of validation script.</p>
        pub fn set_script_type(
            mut self,
            input: std::option::Option<crate::model::ScriptType>,
        ) -> Self {
            self.script_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDataValidationParameters`](crate::model::UserDataValidationParameters)
        pub fn build(self) -> crate::model::UserDataValidationParameters {
            crate::model::UserDataValidationParameters {
                source: self.source,
                script_type: self.script_type,
            }
        }
    }
}
impl UserDataValidationParameters {
    /// Creates a new builder-style object to manufacture [`UserDataValidationParameters`](crate::model::UserDataValidationParameters)
    pub fn builder() -> crate::model::user_data_validation_parameters::Builder {
        crate::model::user_data_validation_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScriptType {
    #[allow(missing_docs)] // documentation missing in model
    PowershellScript,
    #[allow(missing_docs)] // documentation missing in model
    ShellScript,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScriptType {
    fn from(s: &str) -> Self {
        match s {
            "POWERSHELL_SCRIPT" => ScriptType::PowershellScript,
            "SHELL_SCRIPT" => ScriptType::ShellScript,
            other => ScriptType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScriptType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScriptType::from(s))
    }
}
impl ScriptType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScriptType::PowershellScript => "POWERSHELL_SCRIPT",
            ScriptType::ShellScript => "SHELL_SCRIPT",
            ScriptType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["POWERSHELL_SCRIPT", "SHELL_SCRIPT"]
    }
}
impl AsRef<str> for ScriptType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the location of a validation script.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>Location of an Amazon S3 object.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl Source {
    /// <p>Location of an Amazon S3 object.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Location of an Amazon S3 object.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>Location of an Amazon S3 object.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                s3_location: self.s3_location,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

/// <p>Location of an Amazon S3 object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The Amazon S3 bucket name.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket key.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The Amazon S3 bucket name.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerValidationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Userdata,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerValidationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "USERDATA" => ServerValidationStrategy::Userdata,
            other => ServerValidationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerValidationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerValidationStrategy::from(s))
    }
}
impl ServerValidationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerValidationStrategy::Userdata => "USERDATA",
            ServerValidationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USERDATA"]
    }
}
impl AsRef<str> for ServerValidationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for validating an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppValidationConfiguration {
    /// <p>The ID of the validation.</p>
    pub validation_id: std::option::Option<std::string::String>,
    /// <p>The name of the configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The validation strategy.</p>
    pub app_validation_strategy: std::option::Option<crate::model::AppValidationStrategy>,
    /// <p>The validation parameters.</p>
    pub ssm_validation_parameters: std::option::Option<crate::model::SsmValidationParameters>,
}
impl AppValidationConfiguration {
    /// <p>The ID of the validation.</p>
    pub fn validation_id(&self) -> std::option::Option<&str> {
        self.validation_id.as_deref()
    }
    /// <p>The name of the configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The validation strategy.</p>
    pub fn app_validation_strategy(
        &self,
    ) -> std::option::Option<&crate::model::AppValidationStrategy> {
        self.app_validation_strategy.as_ref()
    }
    /// <p>The validation parameters.</p>
    pub fn ssm_validation_parameters(
        &self,
    ) -> std::option::Option<&crate::model::SsmValidationParameters> {
        self.ssm_validation_parameters.as_ref()
    }
}
impl std::fmt::Debug for AppValidationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppValidationConfiguration");
        formatter.field("validation_id", &self.validation_id);
        formatter.field("name", &self.name);
        formatter.field("app_validation_strategy", &self.app_validation_strategy);
        formatter.field("ssm_validation_parameters", &self.ssm_validation_parameters);
        formatter.finish()
    }
}
/// See [`AppValidationConfiguration`](crate::model::AppValidationConfiguration)
pub mod app_validation_configuration {
    /// A builder for [`AppValidationConfiguration`](crate::model::AppValidationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) app_validation_strategy:
            std::option::Option<crate::model::AppValidationStrategy>,
        pub(crate) ssm_validation_parameters:
            std::option::Option<crate::model::SsmValidationParameters>,
    }
    impl Builder {
        /// <p>The ID of the validation.</p>
        pub fn validation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_id = Some(input.into());
            self
        }
        /// <p>The ID of the validation.</p>
        pub fn set_validation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_id = input;
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The validation strategy.</p>
        pub fn app_validation_strategy(
            mut self,
            input: crate::model::AppValidationStrategy,
        ) -> Self {
            self.app_validation_strategy = Some(input);
            self
        }
        /// <p>The validation strategy.</p>
        pub fn set_app_validation_strategy(
            mut self,
            input: std::option::Option<crate::model::AppValidationStrategy>,
        ) -> Self {
            self.app_validation_strategy = input;
            self
        }
        /// <p>The validation parameters.</p>
        pub fn ssm_validation_parameters(
            mut self,
            input: crate::model::SsmValidationParameters,
        ) -> Self {
            self.ssm_validation_parameters = Some(input);
            self
        }
        /// <p>The validation parameters.</p>
        pub fn set_ssm_validation_parameters(
            mut self,
            input: std::option::Option<crate::model::SsmValidationParameters>,
        ) -> Self {
            self.ssm_validation_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`AppValidationConfiguration`](crate::model::AppValidationConfiguration)
        pub fn build(self) -> crate::model::AppValidationConfiguration {
            crate::model::AppValidationConfiguration {
                validation_id: self.validation_id,
                name: self.name,
                app_validation_strategy: self.app_validation_strategy,
                ssm_validation_parameters: self.ssm_validation_parameters,
            }
        }
    }
}
impl AppValidationConfiguration {
    /// Creates a new builder-style object to manufacture [`AppValidationConfiguration`](crate::model::AppValidationConfiguration)
    pub fn builder() -> crate::model::app_validation_configuration::Builder {
        crate::model::app_validation_configuration::Builder::default()
    }
}

/// <p>Contains validation parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmValidationParameters {
    /// <p>The location of the validation script.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The type of validation script.</p>
    pub script_type: std::option::Option<crate::model::ScriptType>,
    /// <p>The command to run the validation script</p>
    pub command: std::option::Option<std::string::String>,
    /// <p>The timeout interval, in seconds.</p>
    pub execution_timeout_seconds: i32,
    /// <p>The name of the S3 bucket for output.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
}
impl SsmValidationParameters {
    /// <p>The location of the validation script.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
    /// <p>The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The type of validation script.</p>
    pub fn script_type(&self) -> std::option::Option<&crate::model::ScriptType> {
        self.script_type.as_ref()
    }
    /// <p>The command to run the validation script</p>
    pub fn command(&self) -> std::option::Option<&str> {
        self.command.as_deref()
    }
    /// <p>The timeout interval, in seconds.</p>
    pub fn execution_timeout_seconds(&self) -> i32 {
        self.execution_timeout_seconds
    }
    /// <p>The name of the S3 bucket for output.</p>
    pub fn output_s3_bucket_name(&self) -> std::option::Option<&str> {
        self.output_s3_bucket_name.as_deref()
    }
}
impl std::fmt::Debug for SsmValidationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmValidationParameters");
        formatter.field("source", &self.source);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("script_type", &self.script_type);
        formatter.field("command", &self.command);
        formatter.field("execution_timeout_seconds", &self.execution_timeout_seconds);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.finish()
    }
}
/// See [`SsmValidationParameters`](crate::model::SsmValidationParameters)
pub mod ssm_validation_parameters {
    /// A builder for [`SsmValidationParameters`](crate::model::SsmValidationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) script_type: std::option::Option<crate::model::ScriptType>,
        pub(crate) command: std::option::Option<std::string::String>,
        pub(crate) execution_timeout_seconds: std::option::Option<i32>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the validation script.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The location of the validation script.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance. The instance must have the following tag: UserForSMSApplicationValidation=true.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The type of validation script.</p>
        pub fn script_type(mut self, input: crate::model::ScriptType) -> Self {
            self.script_type = Some(input);
            self
        }
        /// <p>The type of validation script.</p>
        pub fn set_script_type(
            mut self,
            input: std::option::Option<crate::model::ScriptType>,
        ) -> Self {
            self.script_type = input;
            self
        }
        /// <p>The command to run the validation script</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            self.command = Some(input.into());
            self
        }
        /// <p>The command to run the validation script</p>
        pub fn set_command(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command = input;
            self
        }
        /// <p>The timeout interval, in seconds.</p>
        pub fn execution_timeout_seconds(mut self, input: i32) -> Self {
            self.execution_timeout_seconds = Some(input);
            self
        }
        /// <p>The timeout interval, in seconds.</p>
        pub fn set_execution_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_timeout_seconds = input;
            self
        }
        /// <p>The name of the S3 bucket for output.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket for output.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmValidationParameters`](crate::model::SsmValidationParameters)
        pub fn build(self) -> crate::model::SsmValidationParameters {
            crate::model::SsmValidationParameters {
                source: self.source,
                instance_id: self.instance_id,
                script_type: self.script_type,
                command: self.command,
                execution_timeout_seconds: self.execution_timeout_seconds.unwrap_or_default(),
                output_s3_bucket_name: self.output_s3_bucket_name,
            }
        }
    }
}
impl SsmValidationParameters {
    /// Creates a new builder-style object to manufacture [`SsmValidationParameters`](crate::model::SsmValidationParameters)
    pub fn builder() -> crate::model::ssm_validation_parameters::Builder {
        crate::model::ssm_validation_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppValidationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Ssm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppValidationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "SSM" => AppValidationStrategy::Ssm,
            other => AppValidationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppValidationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppValidationStrategy::from(s))
    }
}
impl AppValidationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppValidationStrategy::Ssm => "SSM",
            AppValidationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSM"]
    }
}
impl AsRef<str> for AppValidationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Replication configuration for a server group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerGroupReplicationConfiguration {
    /// <p>The ID of the server group with which this replication configuration is
    /// associated.</p>
    pub server_group_id: std::option::Option<std::string::String>,
    /// <p>The replication configuration for servers in the server group.</p>
    pub server_replication_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerReplicationConfiguration>>,
}
impl ServerGroupReplicationConfiguration {
    /// <p>The ID of the server group with which this replication configuration is
    /// associated.</p>
    pub fn server_group_id(&self) -> std::option::Option<&str> {
        self.server_group_id.as_deref()
    }
    /// <p>The replication configuration for servers in the server group.</p>
    pub fn server_replication_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerReplicationConfiguration]> {
        self.server_replication_configurations.as_deref()
    }
}
impl std::fmt::Debug for ServerGroupReplicationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerGroupReplicationConfiguration");
        formatter.field("server_group_id", &self.server_group_id);
        formatter.field(
            "server_replication_configurations",
            &self.server_replication_configurations,
        );
        formatter.finish()
    }
}
/// See [`ServerGroupReplicationConfiguration`](crate::model::ServerGroupReplicationConfiguration)
pub mod server_group_replication_configuration {
    /// A builder for [`ServerGroupReplicationConfiguration`](crate::model::ServerGroupReplicationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_group_id: std::option::Option<std::string::String>,
        pub(crate) server_replication_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerReplicationConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the server group with which this replication configuration is
        /// associated.</p>
        pub fn server_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the server group with which this replication configuration is
        /// associated.</p>
        pub fn set_server_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_group_id = input;
            self
        }
        /// Appends an item to `server_replication_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_replication_configurations`](Self::set_server_replication_configurations).
        ///
        /// <p>The replication configuration for servers in the server group.</p>
        pub fn server_replication_configurations(
            mut self,
            input: impl Into<crate::model::ServerReplicationConfiguration>,
        ) -> Self {
            let mut v = self.server_replication_configurations.unwrap_or_default();
            v.push(input.into());
            self.server_replication_configurations = Some(v);
            self
        }
        /// <p>The replication configuration for servers in the server group.</p>
        pub fn set_server_replication_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerReplicationConfiguration>>,
        ) -> Self {
            self.server_replication_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerGroupReplicationConfiguration`](crate::model::ServerGroupReplicationConfiguration)
        pub fn build(self) -> crate::model::ServerGroupReplicationConfiguration {
            crate::model::ServerGroupReplicationConfiguration {
                server_group_id: self.server_group_id,
                server_replication_configurations: self.server_replication_configurations,
            }
        }
    }
}
impl ServerGroupReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerGroupReplicationConfiguration`](crate::model::ServerGroupReplicationConfiguration)
    pub fn builder() -> crate::model::server_group_replication_configuration::Builder {
        crate::model::server_group_replication_configuration::Builder::default()
    }
}

/// <p>Replication configuration of a server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerReplicationConfiguration {
    /// <p>The ID of the server with which this replication configuration is
    /// associated.</p>
    pub server: std::option::Option<crate::model::Server>,
    /// <p>The parameters for replicating the server.</p>
    pub server_replication_parameters:
        std::option::Option<crate::model::ServerReplicationParameters>,
}
impl ServerReplicationConfiguration {
    /// <p>The ID of the server with which this replication configuration is
    /// associated.</p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
    /// <p>The parameters for replicating the server.</p>
    pub fn server_replication_parameters(
        &self,
    ) -> std::option::Option<&crate::model::ServerReplicationParameters> {
        self.server_replication_parameters.as_ref()
    }
}
impl std::fmt::Debug for ServerReplicationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerReplicationConfiguration");
        formatter.field("server", &self.server);
        formatter.field(
            "server_replication_parameters",
            &self.server_replication_parameters,
        );
        formatter.finish()
    }
}
/// See [`ServerReplicationConfiguration`](crate::model::ServerReplicationConfiguration)
pub mod server_replication_configuration {
    /// A builder for [`ServerReplicationConfiguration`](crate::model::ServerReplicationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
        pub(crate) server_replication_parameters:
            std::option::Option<crate::model::ServerReplicationParameters>,
    }
    impl Builder {
        /// <p>The ID of the server with which this replication configuration is
        /// associated.</p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>The ID of the server with which this replication configuration is
        /// associated.</p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// <p>The parameters for replicating the server.</p>
        pub fn server_replication_parameters(
            mut self,
            input: crate::model::ServerReplicationParameters,
        ) -> Self {
            self.server_replication_parameters = Some(input);
            self
        }
        /// <p>The parameters for replicating the server.</p>
        pub fn set_server_replication_parameters(
            mut self,
            input: std::option::Option<crate::model::ServerReplicationParameters>,
        ) -> Self {
            self.server_replication_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerReplicationConfiguration`](crate::model::ServerReplicationConfiguration)
        pub fn build(self) -> crate::model::ServerReplicationConfiguration {
            crate::model::ServerReplicationConfiguration {
                server: self.server,
                server_replication_parameters: self.server_replication_parameters,
            }
        }
    }
}
impl ServerReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerReplicationConfiguration`](crate::model::ServerReplicationConfiguration)
    pub fn builder() -> crate::model::server_replication_configuration::Builder {
        crate::model::server_replication_configuration::Builder::default()
    }
}

/// <p>The replication parameters for replicating a server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerReplicationParameters {
    /// <p>The seed time for creating a replication job for the server.</p>
    pub seed_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The frequency of creating replication jobs for the server.</p>
    pub frequency: std::option::Option<i32>,
    /// <p>Indicates whether to run the replication job one time.</p>
    pub run_once: std::option::Option<bool>,
    /// <p>The license type for creating a replication job for the server.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
    /// <p>The number of recent AMIs to keep when creating a replication job for this server.</p>
    pub number_of_recent_amis_to_keep: std::option::Option<i32>,
    /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl ServerReplicationParameters {
    /// <p>The seed time for creating a replication job for the server.</p>
    pub fn seed_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.seed_time.as_ref()
    }
    /// <p>The frequency of creating replication jobs for the server.</p>
    pub fn frequency(&self) -> std::option::Option<i32> {
        self.frequency
    }
    /// <p>Indicates whether to run the replication job one time.</p>
    pub fn run_once(&self) -> std::option::Option<bool> {
        self.run_once
    }
    /// <p>The license type for creating a replication job for the server.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
    /// <p>The number of recent AMIs to keep when creating a replication job for this server.</p>
    pub fn number_of_recent_amis_to_keep(&self) -> std::option::Option<i32> {
        self.number_of_recent_amis_to_keep
    }
    /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for ServerReplicationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerReplicationParameters");
        formatter.field("seed_time", &self.seed_time);
        formatter.field("frequency", &self.frequency);
        formatter.field("run_once", &self.run_once);
        formatter.field("license_type", &self.license_type);
        formatter.field(
            "number_of_recent_amis_to_keep",
            &self.number_of_recent_amis_to_keep,
        );
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ServerReplicationParameters`](crate::model::ServerReplicationParameters)
pub mod server_replication_parameters {
    /// A builder for [`ServerReplicationParameters`](crate::model::ServerReplicationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) seed_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) frequency: std::option::Option<i32>,
        pub(crate) run_once: std::option::Option<bool>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
        pub(crate) number_of_recent_amis_to_keep: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The seed time for creating a replication job for the server.</p>
        pub fn seed_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.seed_time = Some(input);
            self
        }
        /// <p>The seed time for creating a replication job for the server.</p>
        pub fn set_seed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.seed_time = input;
            self
        }
        /// <p>The frequency of creating replication jobs for the server.</p>
        pub fn frequency(mut self, input: i32) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The frequency of creating replication jobs for the server.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn run_once(mut self, input: bool) -> Self {
            self.run_once = Some(input);
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn set_run_once(mut self, input: std::option::Option<bool>) -> Self {
            self.run_once = input;
            self
        }
        /// <p>The license type for creating a replication job for the server.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The license type for creating a replication job for the server.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The number of recent AMIs to keep when creating a replication job for this server.</p>
        pub fn number_of_recent_amis_to_keep(mut self, input: i32) -> Self {
            self.number_of_recent_amis_to_keep = Some(input);
            self
        }
        /// <p>The number of recent AMIs to keep when creating a replication job for this server.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_recent_amis_to_keep = input;
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the replication job produces encrypted AMIs.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerReplicationParameters`](crate::model::ServerReplicationParameters)
        pub fn build(self) -> crate::model::ServerReplicationParameters {
            crate::model::ServerReplicationParameters {
                seed_time: self.seed_time,
                frequency: self.frequency,
                run_once: self.run_once,
                license_type: self.license_type,
                number_of_recent_amis_to_keep: self.number_of_recent_amis_to_keep,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ServerReplicationParameters {
    /// Creates a new builder-style object to manufacture [`ServerReplicationParameters`](crate::model::ServerReplicationParameters)
    pub fn builder() -> crate::model::server_replication_parameters::Builder {
        crate::model::server_replication_parameters::Builder::default()
    }
}

/// <p>Launch configuration for a server group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerGroupLaunchConfiguration {
    /// <p>The ID of the server group with which the launch configuration is
    /// associated.</p>
    pub server_group_id: std::option::Option<std::string::String>,
    /// <p>The launch order of servers in the server group.</p>
    pub launch_order: std::option::Option<i32>,
    /// <p>The launch configuration for servers in the server group.</p>
    pub server_launch_configurations:
        std::option::Option<std::vec::Vec<crate::model::ServerLaunchConfiguration>>,
}
impl ServerGroupLaunchConfiguration {
    /// <p>The ID of the server group with which the launch configuration is
    /// associated.</p>
    pub fn server_group_id(&self) -> std::option::Option<&str> {
        self.server_group_id.as_deref()
    }
    /// <p>The launch order of servers in the server group.</p>
    pub fn launch_order(&self) -> std::option::Option<i32> {
        self.launch_order
    }
    /// <p>The launch configuration for servers in the server group.</p>
    pub fn server_launch_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ServerLaunchConfiguration]> {
        self.server_launch_configurations.as_deref()
    }
}
impl std::fmt::Debug for ServerGroupLaunchConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerGroupLaunchConfiguration");
        formatter.field("server_group_id", &self.server_group_id);
        formatter.field("launch_order", &self.launch_order);
        formatter.field(
            "server_launch_configurations",
            &self.server_launch_configurations,
        );
        formatter.finish()
    }
}
/// See [`ServerGroupLaunchConfiguration`](crate::model::ServerGroupLaunchConfiguration)
pub mod server_group_launch_configuration {
    /// A builder for [`ServerGroupLaunchConfiguration`](crate::model::ServerGroupLaunchConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_group_id: std::option::Option<std::string::String>,
        pub(crate) launch_order: std::option::Option<i32>,
        pub(crate) server_launch_configurations:
            std::option::Option<std::vec::Vec<crate::model::ServerLaunchConfiguration>>,
    }
    impl Builder {
        /// <p>The ID of the server group with which the launch configuration is
        /// associated.</p>
        pub fn server_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the server group with which the launch configuration is
        /// associated.</p>
        pub fn set_server_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_group_id = input;
            self
        }
        /// <p>The launch order of servers in the server group.</p>
        pub fn launch_order(mut self, input: i32) -> Self {
            self.launch_order = Some(input);
            self
        }
        /// <p>The launch order of servers in the server group.</p>
        pub fn set_launch_order(mut self, input: std::option::Option<i32>) -> Self {
            self.launch_order = input;
            self
        }
        /// Appends an item to `server_launch_configurations`.
        ///
        /// To override the contents of this collection use [`set_server_launch_configurations`](Self::set_server_launch_configurations).
        ///
        /// <p>The launch configuration for servers in the server group.</p>
        pub fn server_launch_configurations(
            mut self,
            input: impl Into<crate::model::ServerLaunchConfiguration>,
        ) -> Self {
            let mut v = self.server_launch_configurations.unwrap_or_default();
            v.push(input.into());
            self.server_launch_configurations = Some(v);
            self
        }
        /// <p>The launch configuration for servers in the server group.</p>
        pub fn set_server_launch_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerLaunchConfiguration>>,
        ) -> Self {
            self.server_launch_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerGroupLaunchConfiguration`](crate::model::ServerGroupLaunchConfiguration)
        pub fn build(self) -> crate::model::ServerGroupLaunchConfiguration {
            crate::model::ServerGroupLaunchConfiguration {
                server_group_id: self.server_group_id,
                launch_order: self.launch_order,
                server_launch_configurations: self.server_launch_configurations,
            }
        }
    }
}
impl ServerGroupLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerGroupLaunchConfiguration`](crate::model::ServerGroupLaunchConfiguration)
    pub fn builder() -> crate::model::server_group_launch_configuration::Builder {
        crate::model::server_group_launch_configuration::Builder::default()
    }
}

/// <p>Launch configuration for a server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerLaunchConfiguration {
    /// <p>The ID of the server with which the launch configuration is associated.</p>
    pub server: std::option::Option<crate::model::Server>,
    /// <p>The logical ID of the server in the AWS CloudFormation template.</p>
    pub logical_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC into which the server should be launched.</p>
    pub vpc: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet the server should be launched into.</p>
    pub subnet: std::option::Option<std::string::String>,
    /// <p>The ID of the security group that applies to the launched server.</p>
    pub security_group: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EC2 SSH key to be used for connecting to the launched server.</p>
    pub ec2_key_name: std::option::Option<std::string::String>,
    /// <p>Location of the user-data script to be executed when launching the server.</p>
    pub user_data: std::option::Option<crate::model::UserData>,
    /// <p>The instance type to use when launching the server.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>Indicates whether a publicly accessible IP address is created when launching the server.</p>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>The name of the IAM instance profile.</p>
    pub iam_instance_profile_name: std::option::Option<std::string::String>,
    /// <p>Location of an Amazon S3 object.</p>
    pub configure_script: std::option::Option<crate::model::S3Location>,
    /// <p>The type of configuration script.</p>
    pub configure_script_type: std::option::Option<crate::model::ScriptType>,
}
impl ServerLaunchConfiguration {
    /// <p>The ID of the server with which the launch configuration is associated.</p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
    /// <p>The logical ID of the server in the AWS CloudFormation template.</p>
    pub fn logical_id(&self) -> std::option::Option<&str> {
        self.logical_id.as_deref()
    }
    /// <p>The ID of the VPC into which the server should be launched.</p>
    pub fn vpc(&self) -> std::option::Option<&str> {
        self.vpc.as_deref()
    }
    /// <p>The ID of the subnet the server should be launched into.</p>
    pub fn subnet(&self) -> std::option::Option<&str> {
        self.subnet.as_deref()
    }
    /// <p>The ID of the security group that applies to the launched server.</p>
    pub fn security_group(&self) -> std::option::Option<&str> {
        self.security_group.as_deref()
    }
    /// <p>The name of the Amazon EC2 SSH key to be used for connecting to the launched server.</p>
    pub fn ec2_key_name(&self) -> std::option::Option<&str> {
        self.ec2_key_name.as_deref()
    }
    /// <p>Location of the user-data script to be executed when launching the server.</p>
    pub fn user_data(&self) -> std::option::Option<&crate::model::UserData> {
        self.user_data.as_ref()
    }
    /// <p>The instance type to use when launching the server.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>Indicates whether a publicly accessible IP address is created when launching the server.</p>
    pub fn associate_public_ip_address(&self) -> std::option::Option<bool> {
        self.associate_public_ip_address
    }
    /// <p>The name of the IAM instance profile.</p>
    pub fn iam_instance_profile_name(&self) -> std::option::Option<&str> {
        self.iam_instance_profile_name.as_deref()
    }
    /// <p>Location of an Amazon S3 object.</p>
    pub fn configure_script(&self) -> std::option::Option<&crate::model::S3Location> {
        self.configure_script.as_ref()
    }
    /// <p>The type of configuration script.</p>
    pub fn configure_script_type(&self) -> std::option::Option<&crate::model::ScriptType> {
        self.configure_script_type.as_ref()
    }
}
impl std::fmt::Debug for ServerLaunchConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerLaunchConfiguration");
        formatter.field("server", &self.server);
        formatter.field("logical_id", &self.logical_id);
        formatter.field("vpc", &self.vpc);
        formatter.field("subnet", &self.subnet);
        formatter.field("security_group", &self.security_group);
        formatter.field("ec2_key_name", &self.ec2_key_name);
        formatter.field("user_data", &self.user_data);
        formatter.field("instance_type", &self.instance_type);
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("iam_instance_profile_name", &self.iam_instance_profile_name);
        formatter.field("configure_script", &self.configure_script);
        formatter.field("configure_script_type", &self.configure_script_type);
        formatter.finish()
    }
}
/// See [`ServerLaunchConfiguration`](crate::model::ServerLaunchConfiguration)
pub mod server_launch_configuration {
    /// A builder for [`ServerLaunchConfiguration`](crate::model::ServerLaunchConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
        pub(crate) logical_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<std::string::String>,
        pub(crate) subnet: std::option::Option<std::string::String>,
        pub(crate) security_group: std::option::Option<std::string::String>,
        pub(crate) ec2_key_name: std::option::Option<std::string::String>,
        pub(crate) user_data: std::option::Option<crate::model::UserData>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) iam_instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) configure_script: std::option::Option<crate::model::S3Location>,
        pub(crate) configure_script_type: std::option::Option<crate::model::ScriptType>,
    }
    impl Builder {
        /// <p>The ID of the server with which the launch configuration is associated.</p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>The ID of the server with which the launch configuration is associated.</p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// <p>The logical ID of the server in the AWS CloudFormation template.</p>
        pub fn logical_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_id = Some(input.into());
            self
        }
        /// <p>The logical ID of the server in the AWS CloudFormation template.</p>
        pub fn set_logical_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logical_id = input;
            self
        }
        /// <p>The ID of the VPC into which the server should be launched.</p>
        pub fn vpc(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc = Some(input.into());
            self
        }
        /// <p>The ID of the VPC into which the server should be launched.</p>
        pub fn set_vpc(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The ID of the subnet the server should be launched into.</p>
        pub fn subnet(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet = Some(input.into());
            self
        }
        /// <p>The ID of the subnet the server should be launched into.</p>
        pub fn set_subnet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet = input;
            self
        }
        /// <p>The ID of the security group that applies to the launched server.</p>
        pub fn security_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group = Some(input.into());
            self
        }
        /// <p>The ID of the security group that applies to the launched server.</p>
        pub fn set_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// <p>The name of the Amazon EC2 SSH key to be used for connecting to the launched server.</p>
        pub fn ec2_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_key_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 SSH key to be used for connecting to the launched server.</p>
        pub fn set_ec2_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_key_name = input;
            self
        }
        /// <p>Location of the user-data script to be executed when launching the server.</p>
        pub fn user_data(mut self, input: crate::model::UserData) -> Self {
            self.user_data = Some(input);
            self
        }
        /// <p>Location of the user-data script to be executed when launching the server.</p>
        pub fn set_user_data(mut self, input: std::option::Option<crate::model::UserData>) -> Self {
            self.user_data = input;
            self
        }
        /// <p>The instance type to use when launching the server.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to use when launching the server.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>Indicates whether a publicly accessible IP address is created when launching the server.</p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>Indicates whether a publicly accessible IP address is created when launching the server.</p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>The name of the IAM instance profile.</p>
        pub fn iam_instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM instance profile.</p>
        pub fn set_iam_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile_name = input;
            self
        }
        /// <p>Location of an Amazon S3 object.</p>
        pub fn configure_script(mut self, input: crate::model::S3Location) -> Self {
            self.configure_script = Some(input);
            self
        }
        /// <p>Location of an Amazon S3 object.</p>
        pub fn set_configure_script(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.configure_script = input;
            self
        }
        /// <p>The type of configuration script.</p>
        pub fn configure_script_type(mut self, input: crate::model::ScriptType) -> Self {
            self.configure_script_type = Some(input);
            self
        }
        /// <p>The type of configuration script.</p>
        pub fn set_configure_script_type(
            mut self,
            input: std::option::Option<crate::model::ScriptType>,
        ) -> Self {
            self.configure_script_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerLaunchConfiguration`](crate::model::ServerLaunchConfiguration)
        pub fn build(self) -> crate::model::ServerLaunchConfiguration {
            crate::model::ServerLaunchConfiguration {
                server: self.server,
                logical_id: self.logical_id,
                vpc: self.vpc,
                subnet: self.subnet,
                security_group: self.security_group,
                ec2_key_name: self.ec2_key_name,
                user_data: self.user_data,
                instance_type: self.instance_type,
                associate_public_ip_address: self.associate_public_ip_address,
                iam_instance_profile_name: self.iam_instance_profile_name,
                configure_script: self.configure_script,
                configure_script_type: self.configure_script_type,
            }
        }
    }
}
impl ServerLaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerLaunchConfiguration`](crate::model::ServerLaunchConfiguration)
    pub fn builder() -> crate::model::server_launch_configuration::Builder {
        crate::model::server_launch_configuration::Builder::default()
    }
}

/// <p>A script that runs on first launch of an Amazon EC2 instance. Used for configuring the
/// server during launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserData {
    /// <p>Amazon S3 location of the user-data script.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl UserData {
    /// <p>Amazon S3 location of the user-data script.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for UserData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserData");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`UserData`](crate::model::UserData)
pub mod user_data {
    /// A builder for [`UserData`](crate::model::UserData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Amazon S3 location of the user-data script.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>Amazon S3 location of the user-data script.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`UserData`](crate::model::UserData)
        pub fn build(self) -> crate::model::UserData {
            crate::model::UserData {
                s3_location: self.s3_location,
            }
        }
    }
}
impl UserData {
    /// Creates a new builder-style object to manufacture [`UserData`](crate::model::UserData)
    pub fn builder() -> crate::model::user_data::Builder {
        crate::model::user_data::Builder::default()
    }
}

/// <p>Contains the status of validating an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationContext {
    /// <p>The ID of the validation.</p>
    pub validation_id: std::option::Option<std::string::String>,
    /// <p>The status of the validation.</p>
    pub status: std::option::Option<crate::model::ValidationStatus>,
    /// <p>The status message.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl NotificationContext {
    /// <p>The ID of the validation.</p>
    pub fn validation_id(&self) -> std::option::Option<&str> {
        self.validation_id.as_deref()
    }
    /// <p>The status of the validation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ValidationStatus> {
        self.status.as_ref()
    }
    /// <p>The status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
}
impl std::fmt::Debug for NotificationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationContext");
        formatter.field("validation_id", &self.validation_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`NotificationContext`](crate::model::NotificationContext)
pub mod notification_context {
    /// A builder for [`NotificationContext`](crate::model::NotificationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ValidationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the validation.</p>
        pub fn validation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_id = Some(input.into());
            self
        }
        /// <p>The ID of the validation.</p>
        pub fn set_validation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_id = input;
            self
        }
        /// <p>The status of the validation.</p>
        pub fn status(mut self, input: crate::model::ValidationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the validation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ValidationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationContext`](crate::model::NotificationContext)
        pub fn build(self) -> crate::model::NotificationContext {
            crate::model::NotificationContext {
                validation_id: self.validation_id,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl NotificationContext {
    /// Creates a new builder-style object to manufacture [`NotificationContext`](crate::model::NotificationContext)
    pub fn builder() -> crate::model::notification_context::Builder {
        crate::model::notification_context::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForValidation,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ValidationStatus::Failed,
            "IN_PROGRESS" => ValidationStatus::InProgress,
            "PENDING" => ValidationStatus::Pending,
            "READY_FOR_VALIDATION" => ValidationStatus::ReadyForValidation,
            "SUCCEEDED" => ValidationStatus::Succeeded,
            other => ValidationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationStatus::from(s))
    }
}
impl ValidationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationStatus::Failed => "FAILED",
            ValidationStatus::InProgress => "IN_PROGRESS",
            ValidationStatus::Pending => "PENDING",
            ValidationStatus::ReadyForValidation => "READY_FOR_VALIDATION",
            ValidationStatus::Succeeded => "SUCCEEDED",
            ValidationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "READY_FOR_VALIDATION",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for ValidationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerCatalogStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Importing,
    #[allow(missing_docs)] // documentation missing in model
    NotImported,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerCatalogStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ServerCatalogStatus::Available,
            "DELETED" => ServerCatalogStatus::Deleted,
            "EXPIRED" => ServerCatalogStatus::Expired,
            "IMPORTING" => ServerCatalogStatus::Importing,
            "NOT_IMPORTED" => ServerCatalogStatus::NotImported,
            other => ServerCatalogStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerCatalogStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerCatalogStatus::from(s))
    }
}
impl ServerCatalogStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerCatalogStatus::Available => "AVAILABLE",
            ServerCatalogStatus::Deleted => "DELETED",
            ServerCatalogStatus::Expired => "EXPIRED",
            ServerCatalogStatus::Importing => "IMPORTING",
            ServerCatalogStatus::NotImported => "NOT_IMPORTED",
            ServerCatalogStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "DELETED",
            "EXPIRED",
            "IMPORTING",
            "NOT_IMPORTED",
        ]
    }
}
impl AsRef<str> for ServerCatalogStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a replication run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationRun {
    /// <p>The ID of the replication run.</p>
    pub replication_run_id: std::option::Option<std::string::String>,
    /// <p>The state of the replication run.</p>
    pub state: std::option::Option<crate::model::ReplicationRunState>,
    /// <p>The type of replication run.</p>
    pub r#type: std::option::Option<crate::model::ReplicationRunType>,
    /// <p>Details about the current stage of the replication run.</p>
    pub stage_details: std::option::Option<crate::model::ReplicationRunStageDetails>,
    /// <p>The description of the current status of the replication job.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Machine Image (AMI) from the replication
    /// run.</p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The start time of the next replication run.</p>
    pub scheduled_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The completion time of the last replication run.</p>
    pub completed_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the replication run.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates whether the replication run should produce an encrypted AMI.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl ReplicationRun {
    /// <p>The ID of the replication run.</p>
    pub fn replication_run_id(&self) -> std::option::Option<&str> {
        self.replication_run_id.as_deref()
    }
    /// <p>The state of the replication run.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplicationRunState> {
        self.state.as_ref()
    }
    /// <p>The type of replication run.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ReplicationRunType> {
        self.r#type.as_ref()
    }
    /// <p>Details about the current stage of the replication run.</p>
    pub fn stage_details(&self) -> std::option::Option<&crate::model::ReplicationRunStageDetails> {
        self.stage_details.as_ref()
    }
    /// <p>The description of the current status of the replication job.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI) from the replication
    /// run.</p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The start time of the next replication run.</p>
    pub fn scheduled_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.scheduled_start_time.as_ref()
    }
    /// <p>The completion time of the last replication run.</p>
    pub fn completed_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completed_time.as_ref()
    }
    /// <p>The description of the replication run.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates whether the replication run should produce an encrypted AMI.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for ReplicationRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationRun");
        formatter.field("replication_run_id", &self.replication_run_id);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.field("stage_details", &self.stage_details);
        formatter.field("status_message", &self.status_message);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("scheduled_start_time", &self.scheduled_start_time);
        formatter.field("completed_time", &self.completed_time);
        formatter.field("description", &self.description);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ReplicationRun`](crate::model::ReplicationRun)
pub mod replication_run {
    /// A builder for [`ReplicationRun`](crate::model::ReplicationRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_run_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplicationRunState>,
        pub(crate) r#type: std::option::Option<crate::model::ReplicationRunType>,
        pub(crate) stage_details: std::option::Option<crate::model::ReplicationRunStageDetails>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) scheduled_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completed_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the replication run.</p>
        pub fn replication_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_run_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication run.</p>
        pub fn set_replication_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_run_id = input;
            self
        }
        /// <p>The state of the replication run.</p>
        pub fn state(mut self, input: crate::model::ReplicationRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the replication run.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReplicationRunState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The type of replication run.</p>
        pub fn r#type(mut self, input: crate::model::ReplicationRunType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of replication run.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationRunType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Details about the current stage of the replication run.</p>
        pub fn stage_details(mut self, input: crate::model::ReplicationRunStageDetails) -> Self {
            self.stage_details = Some(input);
            self
        }
        /// <p>Details about the current stage of the replication run.</p>
        pub fn set_stage_details(
            mut self,
            input: std::option::Option<crate::model::ReplicationRunStageDetails>,
        ) -> Self {
            self.stage_details = input;
            self
        }
        /// <p>The description of the current status of the replication job.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The description of the current status of the replication job.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) from the replication
        /// run.</p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) from the replication
        /// run.</p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn scheduled_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.scheduled_start_time = Some(input);
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn set_scheduled_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.scheduled_start_time = input;
            self
        }
        /// <p>The completion time of the last replication run.</p>
        pub fn completed_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completed_time = Some(input);
            self
        }
        /// <p>The completion time of the last replication run.</p>
        pub fn set_completed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completed_time = input;
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication run.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether the replication run should produce an encrypted AMI.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the replication run should produce an encrypted AMI.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p> If encrypted is <i>true</i> but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationRun`](crate::model::ReplicationRun)
        pub fn build(self) -> crate::model::ReplicationRun {
            crate::model::ReplicationRun {
                replication_run_id: self.replication_run_id,
                state: self.state,
                r#type: self.r#type,
                stage_details: self.stage_details,
                status_message: self.status_message,
                ami_id: self.ami_id,
                scheduled_start_time: self.scheduled_start_time,
                completed_time: self.completed_time,
                description: self.description,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ReplicationRun {
    /// Creates a new builder-style object to manufacture [`ReplicationRun`](crate::model::ReplicationRun)
    pub fn builder() -> crate::model::replication_run::Builder {
        crate::model::replication_run::Builder::default()
    }
}

/// <p>Details of the current stage of a replication run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationRunStageDetails {
    /// <p>The current stage of a replication run.</p>
    pub stage: std::option::Option<std::string::String>,
    /// <p>The progress of the current stage of a replication run.</p>
    pub stage_progress: std::option::Option<std::string::String>,
}
impl ReplicationRunStageDetails {
    /// <p>The current stage of a replication run.</p>
    pub fn stage(&self) -> std::option::Option<&str> {
        self.stage.as_deref()
    }
    /// <p>The progress of the current stage of a replication run.</p>
    pub fn stage_progress(&self) -> std::option::Option<&str> {
        self.stage_progress.as_deref()
    }
}
impl std::fmt::Debug for ReplicationRunStageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationRunStageDetails");
        formatter.field("stage", &self.stage);
        formatter.field("stage_progress", &self.stage_progress);
        formatter.finish()
    }
}
/// See [`ReplicationRunStageDetails`](crate::model::ReplicationRunStageDetails)
pub mod replication_run_stage_details {
    /// A builder for [`ReplicationRunStageDetails`](crate::model::ReplicationRunStageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stage: std::option::Option<std::string::String>,
        pub(crate) stage_progress: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current stage of a replication run.</p>
        pub fn stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage = Some(input.into());
            self
        }
        /// <p>The current stage of a replication run.</p>
        pub fn set_stage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stage = input;
            self
        }
        /// <p>The progress of the current stage of a replication run.</p>
        pub fn stage_progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.stage_progress = Some(input.into());
            self
        }
        /// <p>The progress of the current stage of a replication run.</p>
        pub fn set_stage_progress(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stage_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationRunStageDetails`](crate::model::ReplicationRunStageDetails)
        pub fn build(self) -> crate::model::ReplicationRunStageDetails {
            crate::model::ReplicationRunStageDetails {
                stage: self.stage,
                stage_progress: self.stage_progress,
            }
        }
    }
}
impl ReplicationRunStageDetails {
    /// Creates a new builder-style object to manufacture [`ReplicationRunStageDetails`](crate::model::ReplicationRunStageDetails)
    pub fn builder() -> crate::model::replication_run_stage_details::Builder {
        crate::model::replication_run_stage_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationRunType {
    #[allow(missing_docs)] // documentation missing in model
    Automatic,
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationRunType {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATIC" => ReplicationRunType::Automatic,
            "ON_DEMAND" => ReplicationRunType::OnDemand,
            other => ReplicationRunType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationRunType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationRunType::from(s))
    }
}
impl ReplicationRunType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationRunType::Automatic => "AUTOMATIC",
            ReplicationRunType::OnDemand => "ON_DEMAND",
            ReplicationRunType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATIC", "ON_DEMAND"]
    }
}
impl AsRef<str> for ReplicationRunType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationRunState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Missed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationRunState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReplicationRunState::Active,
            "COMPLETED" => ReplicationRunState::Completed,
            "DELETED" => ReplicationRunState::Deleted,
            "DELETING" => ReplicationRunState::Deleting,
            "FAILED" => ReplicationRunState::Failed,
            "MISSED" => ReplicationRunState::Missed,
            "PENDING" => ReplicationRunState::Pending,
            other => ReplicationRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationRunState::from(s))
    }
}
impl ReplicationRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationRunState::Active => "ACTIVE",
            ReplicationRunState::Completed => "COMPLETED",
            ReplicationRunState::Deleted => "DELETED",
            ReplicationRunState::Deleting => "DELETING",
            ReplicationRunState::Failed => "FAILED",
            ReplicationRunState::Missed => "MISSED",
            ReplicationRunState::Pending => "PENDING",
            ReplicationRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "COMPLETED",
            "DELETED",
            "DELETING",
            "FAILED",
            "MISSED",
            "PENDING",
        ]
    }
}
impl AsRef<str> for ReplicationRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a replication job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationJob {
    /// <p>The ID of the replication job.</p>
    pub replication_job_id: std::option::Option<std::string::String>,
    /// <p>The ID of the server.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The type of server.</p>
    pub server_type: std::option::Option<crate::model::ServerType>,
    /// <p>Information about the VM server.</p>
    pub vm_server: std::option::Option<crate::model::VmServer>,
    /// <p>The seed replication time.</p>
    pub seed_replication_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub frequency: std::option::Option<i32>,
    /// <p>Indicates whether to run the replication job one time.</p>
    pub run_once: std::option::Option<bool>,
    /// <p>The start time of the next replication run.</p>
    pub next_replication_run_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The license type to be used for the AMI created by a successful replication
    /// run.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
    /// <p>The name of the IAM role to be used by AWS SMS.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The ID of the latest Amazon Machine Image (AMI).</p>
    pub latest_ami_id: std::option::Option<std::string::String>,
    /// <p>The state of the replication job.</p>
    pub state: std::option::Option<crate::model::ReplicationJobState>,
    /// <p>The description of the current status of the replication job.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The description of the replication job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The number of recent AMIs to keep in the customer's account for a replication job. By
    /// default, the value is set to zero, meaning that all AMIs are kept.</p>
    pub number_of_recent_amis_to_keep: std::option::Option<i32>,
    /// <p>Indicates whether the replication job should produce encrypted AMIs.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following: </p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Information about the replication runs.</p>
    pub replication_run_list: std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
}
impl ReplicationJob {
    /// <p>The ID of the replication job.</p>
    pub fn replication_job_id(&self) -> std::option::Option<&str> {
        self.replication_job_id.as_deref()
    }
    /// <p>The ID of the server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The type of server.</p>
    pub fn server_type(&self) -> std::option::Option<&crate::model::ServerType> {
        self.server_type.as_ref()
    }
    /// <p>Information about the VM server.</p>
    pub fn vm_server(&self) -> std::option::Option<&crate::model::VmServer> {
        self.vm_server.as_ref()
    }
    /// <p>The seed replication time.</p>
    pub fn seed_replication_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.seed_replication_time.as_ref()
    }
    /// <p>The time between consecutive replication runs, in hours.</p>
    pub fn frequency(&self) -> std::option::Option<i32> {
        self.frequency
    }
    /// <p>Indicates whether to run the replication job one time.</p>
    pub fn run_once(&self) -> std::option::Option<bool> {
        self.run_once
    }
    /// <p>The start time of the next replication run.</p>
    pub fn next_replication_run_start_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.next_replication_run_start_time.as_ref()
    }
    /// <p>The license type to be used for the AMI created by a successful replication
    /// run.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
    /// <p>The name of the IAM role to be used by AWS SMS.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The ID of the latest Amazon Machine Image (AMI).</p>
    pub fn latest_ami_id(&self) -> std::option::Option<&str> {
        self.latest_ami_id.as_deref()
    }
    /// <p>The state of the replication job.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReplicationJobState> {
        self.state.as_ref()
    }
    /// <p>The description of the current status of the replication job.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The description of the replication job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The number of recent AMIs to keep in the customer's account for a replication job. By
    /// default, the value is set to zero, meaning that all AMIs are kept.</p>
    pub fn number_of_recent_amis_to_keep(&self) -> std::option::Option<i32> {
        self.number_of_recent_amis_to_keep
    }
    /// <p>Indicates whether the replication job should produce encrypted AMIs.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
    /// This value can be any of the following: </p>
    /// <ul>
    /// <li>
    /// <p>KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>KMS key alias</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key ID</p>
    /// </li>
    /// <li>
    /// <p>ARN referring to the KMS key alias</p>
    /// </li>
    /// </ul>
    /// <p>If encrypted is enabled but a KMS key ID is not specified, the
    /// customer's default KMS key for Amazon EBS is used.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Information about the replication runs.</p>
    pub fn replication_run_list(&self) -> std::option::Option<&[crate::model::ReplicationRun]> {
        self.replication_run_list.as_deref()
    }
}
impl std::fmt::Debug for ReplicationJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationJob");
        formatter.field("replication_job_id", &self.replication_job_id);
        formatter.field("server_id", &self.server_id);
        formatter.field("server_type", &self.server_type);
        formatter.field("vm_server", &self.vm_server);
        formatter.field("seed_replication_time", &self.seed_replication_time);
        formatter.field("frequency", &self.frequency);
        formatter.field("run_once", &self.run_once);
        formatter.field(
            "next_replication_run_start_time",
            &self.next_replication_run_start_time,
        );
        formatter.field("license_type", &self.license_type);
        formatter.field("role_name", &self.role_name);
        formatter.field("latest_ami_id", &self.latest_ami_id);
        formatter.field("state", &self.state);
        formatter.field("status_message", &self.status_message);
        formatter.field("description", &self.description);
        formatter.field(
            "number_of_recent_amis_to_keep",
            &self.number_of_recent_amis_to_keep,
        );
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("replication_run_list", &self.replication_run_list);
        formatter.finish()
    }
}
/// See [`ReplicationJob`](crate::model::ReplicationJob)
pub mod replication_job {
    /// A builder for [`ReplicationJob`](crate::model::ReplicationJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_job_id: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) server_type: std::option::Option<crate::model::ServerType>,
        pub(crate) vm_server: std::option::Option<crate::model::VmServer>,
        pub(crate) seed_replication_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) frequency: std::option::Option<i32>,
        pub(crate) run_once: std::option::Option<bool>,
        pub(crate) next_replication_run_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) latest_ami_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplicationJobState>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) number_of_recent_amis_to_keep: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) replication_run_list:
            std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
    }
    impl Builder {
        /// <p>The ID of the replication job.</p>
        pub fn replication_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the replication job.</p>
        pub fn set_replication_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_job_id = input;
            self
        }
        /// <p>The ID of the server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The type of server.</p>
        pub fn server_type(mut self, input: crate::model::ServerType) -> Self {
            self.server_type = Some(input);
            self
        }
        /// <p>The type of server.</p>
        pub fn set_server_type(
            mut self,
            input: std::option::Option<crate::model::ServerType>,
        ) -> Self {
            self.server_type = input;
            self
        }
        /// <p>Information about the VM server.</p>
        pub fn vm_server(mut self, input: crate::model::VmServer) -> Self {
            self.vm_server = Some(input);
            self
        }
        /// <p>Information about the VM server.</p>
        pub fn set_vm_server(mut self, input: std::option::Option<crate::model::VmServer>) -> Self {
            self.vm_server = input;
            self
        }
        /// <p>The seed replication time.</p>
        pub fn seed_replication_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.seed_replication_time = Some(input);
            self
        }
        /// <p>The seed replication time.</p>
        pub fn set_seed_replication_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.seed_replication_time = input;
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn frequency(mut self, input: i32) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The time between consecutive replication runs, in hours.</p>
        pub fn set_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency = input;
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn run_once(mut self, input: bool) -> Self {
            self.run_once = Some(input);
            self
        }
        /// <p>Indicates whether to run the replication job one time.</p>
        pub fn set_run_once(mut self, input: std::option::Option<bool>) -> Self {
            self.run_once = input;
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn next_replication_run_start_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.next_replication_run_start_time = Some(input);
            self
        }
        /// <p>The start time of the next replication run.</p>
        pub fn set_next_replication_run_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.next_replication_run_start_time = input;
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The license type to be used for the AMI created by a successful replication
        /// run.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>The name of the IAM role to be used by AWS SMS.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to be used by AWS SMS.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The ID of the latest Amazon Machine Image (AMI).</p>
        pub fn latest_ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the latest Amazon Machine Image (AMI).</p>
        pub fn set_latest_ami_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_ami_id = input;
            self
        }
        /// <p>The state of the replication job.</p>
        pub fn state(mut self, input: crate::model::ReplicationJobState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the replication job.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReplicationJobState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The description of the current status of the replication job.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The description of the current status of the replication job.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the replication job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The number of recent AMIs to keep in the customer's account for a replication job. By
        /// default, the value is set to zero, meaning that all AMIs are kept.</p>
        pub fn number_of_recent_amis_to_keep(mut self, input: i32) -> Self {
            self.number_of_recent_amis_to_keep = Some(input);
            self
        }
        /// <p>The number of recent AMIs to keep in the customer's account for a replication job. By
        /// default, the value is set to zero, meaning that all AMIs are kept.</p>
        pub fn set_number_of_recent_amis_to_keep(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_recent_amis_to_keep = input;
            self
        }
        /// <p>Indicates whether the replication job should produce encrypted AMIs.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the replication job should produce encrypted AMIs.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following: </p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key for replication jobs that produce encrypted AMIs.
        /// This value can be any of the following: </p>
        /// <ul>
        /// <li>
        /// <p>KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>KMS key alias</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key ID</p>
        /// </li>
        /// <li>
        /// <p>ARN referring to the KMS key alias</p>
        /// </li>
        /// </ul>
        /// <p>If encrypted is enabled but a KMS key ID is not specified, the
        /// customer's default KMS key for Amazon EBS is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `replication_run_list`.
        ///
        /// To override the contents of this collection use [`set_replication_run_list`](Self::set_replication_run_list).
        ///
        /// <p>Information about the replication runs.</p>
        pub fn replication_run_list(
            mut self,
            input: impl Into<crate::model::ReplicationRun>,
        ) -> Self {
            let mut v = self.replication_run_list.unwrap_or_default();
            v.push(input.into());
            self.replication_run_list = Some(v);
            self
        }
        /// <p>Information about the replication runs.</p>
        pub fn set_replication_run_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationRun>>,
        ) -> Self {
            self.replication_run_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationJob`](crate::model::ReplicationJob)
        pub fn build(self) -> crate::model::ReplicationJob {
            crate::model::ReplicationJob {
                replication_job_id: self.replication_job_id,
                server_id: self.server_id,
                server_type: self.server_type,
                vm_server: self.vm_server,
                seed_replication_time: self.seed_replication_time,
                frequency: self.frequency,
                run_once: self.run_once,
                next_replication_run_start_time: self.next_replication_run_start_time,
                license_type: self.license_type,
                role_name: self.role_name,
                latest_ami_id: self.latest_ami_id,
                state: self.state,
                status_message: self.status_message,
                description: self.description,
                number_of_recent_amis_to_keep: self.number_of_recent_amis_to_keep,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                replication_run_list: self.replication_run_list,
            }
        }
    }
}
impl ReplicationJob {
    /// Creates a new builder-style object to manufacture [`ReplicationJob`](crate::model::ReplicationJob)
    pub fn builder() -> crate::model::replication_job::Builder {
        crate::model::replication_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationJobState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Failing,
    #[allow(missing_docs)] // documentation missing in model
    PausedOnFailure,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationJobState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReplicationJobState::Active,
            "COMPLETED" => ReplicationJobState::Completed,
            "DELETED" => ReplicationJobState::Deleted,
            "DELETING" => ReplicationJobState::Deleting,
            "FAILED" => ReplicationJobState::Failed,
            "FAILING" => ReplicationJobState::Failing,
            "PAUSED_ON_FAILURE" => ReplicationJobState::PausedOnFailure,
            "PENDING" => ReplicationJobState::Pending,
            other => ReplicationJobState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationJobState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationJobState::from(s))
    }
}
impl ReplicationJobState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationJobState::Active => "ACTIVE",
            ReplicationJobState::Completed => "COMPLETED",
            ReplicationJobState::Deleted => "DELETED",
            ReplicationJobState::Deleting => "DELETING",
            ReplicationJobState::Failed => "FAILED",
            ReplicationJobState::Failing => "FAILING",
            ReplicationJobState::PausedOnFailure => "PAUSED_ON_FAILURE",
            ReplicationJobState::Pending => "PENDING",
            ReplicationJobState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "COMPLETED",
            "DELETED",
            "DELETING",
            "FAILED",
            "FAILING",
            "PAUSED_ON_FAILURE",
            "PENDING",
        ]
    }
}
impl AsRef<str> for ReplicationJobState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a connector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connector {
    /// <p>The ID of the connector.</p>
    pub connector_id: std::option::Option<std::string::String>,
    /// <p>The connector version.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The status of the connector.</p>
    pub status: std::option::Option<crate::model::ConnectorStatus>,
    /// <p>The capabilities of the connector.</p>
    pub capability_list: std::option::Option<std::vec::Vec<crate::model::ConnectorCapability>>,
    /// <p>The name of the VM manager.</p>
    pub vm_manager_name: std::option::Option<std::string::String>,
    /// <p>The VM management product.</p>
    pub vm_manager_type: std::option::Option<crate::model::VmManagerType>,
    /// <p>The ID of the VM manager.</p>
    pub vm_manager_id: std::option::Option<std::string::String>,
    /// <p>The IP address of the connector.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The MAC address of the connector.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>The time the connector was associated.</p>
    pub associated_on: std::option::Option<aws_smithy_types::DateTime>,
}
impl Connector {
    /// <p>The ID of the connector.</p>
    pub fn connector_id(&self) -> std::option::Option<&str> {
        self.connector_id.as_deref()
    }
    /// <p>The connector version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The status of the connector.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ConnectorStatus> {
        self.status.as_ref()
    }
    /// <p>The capabilities of the connector.</p>
    pub fn capability_list(&self) -> std::option::Option<&[crate::model::ConnectorCapability]> {
        self.capability_list.as_deref()
    }
    /// <p>The name of the VM manager.</p>
    pub fn vm_manager_name(&self) -> std::option::Option<&str> {
        self.vm_manager_name.as_deref()
    }
    /// <p>The VM management product.</p>
    pub fn vm_manager_type(&self) -> std::option::Option<&crate::model::VmManagerType> {
        self.vm_manager_type.as_ref()
    }
    /// <p>The ID of the VM manager.</p>
    pub fn vm_manager_id(&self) -> std::option::Option<&str> {
        self.vm_manager_id.as_deref()
    }
    /// <p>The IP address of the connector.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The MAC address of the connector.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// <p>The time the connector was associated.</p>
    pub fn associated_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.associated_on.as_ref()
    }
}
impl std::fmt::Debug for Connector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connector");
        formatter.field("connector_id", &self.connector_id);
        formatter.field("version", &self.version);
        formatter.field("status", &self.status);
        formatter.field("capability_list", &self.capability_list);
        formatter.field("vm_manager_name", &self.vm_manager_name);
        formatter.field("vm_manager_type", &self.vm_manager_type);
        formatter.field("vm_manager_id", &self.vm_manager_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("associated_on", &self.associated_on);
        formatter.finish()
    }
}
/// See [`Connector`](crate::model::Connector)
pub mod connector {
    /// A builder for [`Connector`](crate::model::Connector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ConnectorStatus>,
        pub(crate) capability_list:
            std::option::Option<std::vec::Vec<crate::model::ConnectorCapability>>,
        pub(crate) vm_manager_name: std::option::Option<std::string::String>,
        pub(crate) vm_manager_type: std::option::Option<crate::model::VmManagerType>,
        pub(crate) vm_manager_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) associated_on: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the connector.</p>
        pub fn connector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_id = Some(input.into());
            self
        }
        /// <p>The ID of the connector.</p>
        pub fn set_connector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.connector_id = input;
            self
        }
        /// <p>The connector version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The connector version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The status of the connector.</p>
        pub fn status(mut self, input: crate::model::ConnectorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the connector.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConnectorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `capability_list`.
        ///
        /// To override the contents of this collection use [`set_capability_list`](Self::set_capability_list).
        ///
        /// <p>The capabilities of the connector.</p>
        pub fn capability_list(
            mut self,
            input: impl Into<crate::model::ConnectorCapability>,
        ) -> Self {
            let mut v = self.capability_list.unwrap_or_default();
            v.push(input.into());
            self.capability_list = Some(v);
            self
        }
        /// <p>The capabilities of the connector.</p>
        pub fn set_capability_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectorCapability>>,
        ) -> Self {
            self.capability_list = input;
            self
        }
        /// <p>The name of the VM manager.</p>
        pub fn vm_manager_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_manager_name = Some(input.into());
            self
        }
        /// <p>The name of the VM manager.</p>
        pub fn set_vm_manager_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vm_manager_name = input;
            self
        }
        /// <p>The VM management product.</p>
        pub fn vm_manager_type(mut self, input: crate::model::VmManagerType) -> Self {
            self.vm_manager_type = Some(input);
            self
        }
        /// <p>The VM management product.</p>
        pub fn set_vm_manager_type(
            mut self,
            input: std::option::Option<crate::model::VmManagerType>,
        ) -> Self {
            self.vm_manager_type = input;
            self
        }
        /// <p>The ID of the VM manager.</p>
        pub fn vm_manager_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_manager_id = Some(input.into());
            self
        }
        /// <p>The ID of the VM manager.</p>
        pub fn set_vm_manager_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vm_manager_id = input;
            self
        }
        /// <p>The IP address of the connector.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the connector.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The MAC address of the connector.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address of the connector.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>The time the connector was associated.</p>
        pub fn associated_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.associated_on = Some(input);
            self
        }
        /// <p>The time the connector was associated.</p>
        pub fn set_associated_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.associated_on = input;
            self
        }
        /// Consumes the builder and constructs a [`Connector`](crate::model::Connector)
        pub fn build(self) -> crate::model::Connector {
            crate::model::Connector {
                connector_id: self.connector_id,
                version: self.version,
                status: self.status,
                capability_list: self.capability_list,
                vm_manager_name: self.vm_manager_name,
                vm_manager_type: self.vm_manager_type,
                vm_manager_id: self.vm_manager_id,
                ip_address: self.ip_address,
                mac_address: self.mac_address,
                associated_on: self.associated_on,
            }
        }
    }
}
impl Connector {
    /// Creates a new builder-style object to manufacture [`Connector`](crate::model::Connector)
    pub fn builder() -> crate::model::connector::Builder {
        crate::model::connector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorCapability {
    #[allow(missing_docs)] // documentation missing in model
    HyperVManager,
    #[allow(missing_docs)] // documentation missing in model
    Scvmm,
    #[allow(missing_docs)] // documentation missing in model
    SmsOptimized,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotBatching,
    #[allow(missing_docs)] // documentation missing in model
    VSphere,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorCapability {
    fn from(s: &str) -> Self {
        match s {
            "HYPERV-MANAGER" => ConnectorCapability::HyperVManager,
            "SCVMM" => ConnectorCapability::Scvmm,
            "SMS_OPTIMIZED" => ConnectorCapability::SmsOptimized,
            "SNAPSHOT_BATCHING" => ConnectorCapability::SnapshotBatching,
            "VSPHERE" => ConnectorCapability::VSphere,
            other => ConnectorCapability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorCapability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorCapability::from(s))
    }
}
impl ConnectorCapability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorCapability::HyperVManager => "HYPERV-MANAGER",
            ConnectorCapability::Scvmm => "SCVMM",
            ConnectorCapability::SmsOptimized => "SMS_OPTIMIZED",
            ConnectorCapability::SnapshotBatching => "SNAPSHOT_BATCHING",
            ConnectorCapability::VSphere => "VSPHERE",
            ConnectorCapability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "HYPERV-MANAGER",
            "SCVMM",
            "SMS_OPTIMIZED",
            "SNAPSHOT_BATCHING",
            "VSPHERE",
        ]
    }
}
impl AsRef<str> for ConnectorCapability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorStatus {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => ConnectorStatus::Healthy,
            "UNHEALTHY" => ConnectorStatus::Unhealthy,
            other => ConnectorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorStatus::from(s))
    }
}
impl ConnectorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorStatus::Healthy => "HEALTHY",
            ConnectorStatus::Unhealthy => "UNHEALTHY",
            ConnectorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY"]
    }
}
impl AsRef<str> for ConnectorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains validation output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationOutput {
    /// <p>The ID of the validation.</p>
    pub validation_id: std::option::Option<std::string::String>,
    /// <p>The name of the validation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the validation.</p>
    pub status: std::option::Option<crate::model::ValidationStatus>,
    /// <p>The status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The latest time that the validation was performed.</p>
    pub latest_validation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The output from validating an application.</p>
    pub app_validation_output: std::option::Option<crate::model::AppValidationOutput>,
    /// <p>The output from validation an instance.</p>
    pub server_validation_output: std::option::Option<crate::model::ServerValidationOutput>,
}
impl ValidationOutput {
    /// <p>The ID of the validation.</p>
    pub fn validation_id(&self) -> std::option::Option<&str> {
        self.validation_id.as_deref()
    }
    /// <p>The name of the validation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the validation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ValidationStatus> {
        self.status.as_ref()
    }
    /// <p>The status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The latest time that the validation was performed.</p>
    pub fn latest_validation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_validation_time.as_ref()
    }
    /// <p>The output from validating an application.</p>
    pub fn app_validation_output(&self) -> std::option::Option<&crate::model::AppValidationOutput> {
        self.app_validation_output.as_ref()
    }
    /// <p>The output from validation an instance.</p>
    pub fn server_validation_output(
        &self,
    ) -> std::option::Option<&crate::model::ServerValidationOutput> {
        self.server_validation_output.as_ref()
    }
}
impl std::fmt::Debug for ValidationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationOutput");
        formatter.field("validation_id", &self.validation_id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("latest_validation_time", &self.latest_validation_time);
        formatter.field("app_validation_output", &self.app_validation_output);
        formatter.field("server_validation_output", &self.server_validation_output);
        formatter.finish()
    }
}
/// See [`ValidationOutput`](crate::model::ValidationOutput)
pub mod validation_output {
    /// A builder for [`ValidationOutput`](crate::model::ValidationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ValidationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) latest_validation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) app_validation_output: std::option::Option<crate::model::AppValidationOutput>,
        pub(crate) server_validation_output:
            std::option::Option<crate::model::ServerValidationOutput>,
    }
    impl Builder {
        /// <p>The ID of the validation.</p>
        pub fn validation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_id = Some(input.into());
            self
        }
        /// <p>The ID of the validation.</p>
        pub fn set_validation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_id = input;
            self
        }
        /// <p>The name of the validation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the validation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the validation.</p>
        pub fn status(mut self, input: crate::model::ValidationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the validation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ValidationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The latest time that the validation was performed.</p>
        pub fn latest_validation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_validation_time = Some(input);
            self
        }
        /// <p>The latest time that the validation was performed.</p>
        pub fn set_latest_validation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_validation_time = input;
            self
        }
        /// <p>The output from validating an application.</p>
        pub fn app_validation_output(mut self, input: crate::model::AppValidationOutput) -> Self {
            self.app_validation_output = Some(input);
            self
        }
        /// <p>The output from validating an application.</p>
        pub fn set_app_validation_output(
            mut self,
            input: std::option::Option<crate::model::AppValidationOutput>,
        ) -> Self {
            self.app_validation_output = input;
            self
        }
        /// <p>The output from validation an instance.</p>
        pub fn server_validation_output(
            mut self,
            input: crate::model::ServerValidationOutput,
        ) -> Self {
            self.server_validation_output = Some(input);
            self
        }
        /// <p>The output from validation an instance.</p>
        pub fn set_server_validation_output(
            mut self,
            input: std::option::Option<crate::model::ServerValidationOutput>,
        ) -> Self {
            self.server_validation_output = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationOutput`](crate::model::ValidationOutput)
        pub fn build(self) -> crate::model::ValidationOutput {
            crate::model::ValidationOutput {
                validation_id: self.validation_id,
                name: self.name,
                status: self.status,
                status_message: self.status_message,
                latest_validation_time: self.latest_validation_time,
                app_validation_output: self.app_validation_output,
                server_validation_output: self.server_validation_output,
            }
        }
    }
}
impl ValidationOutput {
    /// Creates a new builder-style object to manufacture [`ValidationOutput`](crate::model::ValidationOutput)
    pub fn builder() -> crate::model::validation_output::Builder {
        crate::model::validation_output::Builder::default()
    }
}

/// <p>Contains output from validating an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerValidationOutput {
    /// <p>Represents a server.</p>
    pub server: std::option::Option<crate::model::Server>,
}
impl ServerValidationOutput {
    /// <p>Represents a server.</p>
    pub fn server(&self) -> std::option::Option<&crate::model::Server> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for ServerValidationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerValidationOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`ServerValidationOutput`](crate::model::ServerValidationOutput)
pub mod server_validation_output {
    /// A builder for [`ServerValidationOutput`](crate::model::ServerValidationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::Server>,
    }
    impl Builder {
        /// <p>Represents a server.</p>
        pub fn server(mut self, input: crate::model::Server) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>Represents a server.</p>
        pub fn set_server(mut self, input: std::option::Option<crate::model::Server>) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerValidationOutput`](crate::model::ServerValidationOutput)
        pub fn build(self) -> crate::model::ServerValidationOutput {
            crate::model::ServerValidationOutput {
                server: self.server,
            }
        }
    }
}
impl ServerValidationOutput {
    /// Creates a new builder-style object to manufacture [`ServerValidationOutput`](crate::model::ServerValidationOutput)
    pub fn builder() -> crate::model::server_validation_output::Builder {
        crate::model::server_validation_output::Builder::default()
    }
}

/// <p>Output from validating an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppValidationOutput {
    /// <p>Output from using SSM to validate the application.</p>
    pub ssm_output: std::option::Option<crate::model::SsmOutput>,
}
impl AppValidationOutput {
    /// <p>Output from using SSM to validate the application.</p>
    pub fn ssm_output(&self) -> std::option::Option<&crate::model::SsmOutput> {
        self.ssm_output.as_ref()
    }
}
impl std::fmt::Debug for AppValidationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppValidationOutput");
        formatter.field("ssm_output", &self.ssm_output);
        formatter.finish()
    }
}
/// See [`AppValidationOutput`](crate::model::AppValidationOutput)
pub mod app_validation_output {
    /// A builder for [`AppValidationOutput`](crate::model::AppValidationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssm_output: std::option::Option<crate::model::SsmOutput>,
    }
    impl Builder {
        /// <p>Output from using SSM to validate the application.</p>
        pub fn ssm_output(mut self, input: crate::model::SsmOutput) -> Self {
            self.ssm_output = Some(input);
            self
        }
        /// <p>Output from using SSM to validate the application.</p>
        pub fn set_ssm_output(
            mut self,
            input: std::option::Option<crate::model::SsmOutput>,
        ) -> Self {
            self.ssm_output = input;
            self
        }
        /// Consumes the builder and constructs a [`AppValidationOutput`](crate::model::AppValidationOutput)
        pub fn build(self) -> crate::model::AppValidationOutput {
            crate::model::AppValidationOutput {
                ssm_output: self.ssm_output,
            }
        }
    }
}
impl AppValidationOutput {
    /// Creates a new builder-style object to manufacture [`AppValidationOutput`](crate::model::AppValidationOutput)
    pub fn builder() -> crate::model::app_validation_output::Builder {
        crate::model::app_validation_output::Builder::default()
    }
}

/// <p>Contains the location of validation output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmOutput {
    /// <p>Location of an Amazon S3 object.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl SsmOutput {
    /// <p>Location of an Amazon S3 object.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for SsmOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmOutput");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`SsmOutput`](crate::model::SsmOutput)
pub mod ssm_output {
    /// A builder for [`SsmOutput`](crate::model::SsmOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Location of an Amazon S3 object.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>Location of an Amazon S3 object.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmOutput`](crate::model::SsmOutput)
        pub fn build(self) -> crate::model::SsmOutput {
            crate::model::SsmOutput {
                s3_location: self.s3_location,
            }
        }
    }
}
impl SsmOutput {
    /// Creates a new builder-style object to manufacture [`SsmOutput`](crate::model::SsmOutput)
    pub fn builder() -> crate::model::ssm_output::Builder {
        crate::model::ssm_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Yaml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutputFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => OutputFormat::Json,
            "YAML" => OutputFormat::Yaml,
            other => OutputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutputFormat::from(s))
    }
}
impl OutputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutputFormat::Json => "JSON",
            OutputFormat::Yaml => "YAML",
            OutputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "YAML"]
    }
}
impl AsRef<str> for OutputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
