// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppError {
    /// Kind of error that occurred.
    pub kind: CreateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            CreateAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            CreateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppError {
    fn code(&self) -> Option<&str> {
        CreateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppError {
    /// Creates a new `CreateAppError`.
    pub fn new(kind: CreateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `CreateAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, CreateAppErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `CreateAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreateAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `CreateAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for CreateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppErrorKind::InternalError(_inner) => Some(_inner),
            CreateAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            CreateAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            CreateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationJobError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationJobErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>There are no connectors available.</p>
    NoConnectorsAvailableException(crate::error::NoConnectorsAvailableException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified replication job already exists.</p>
    ReplicationJobAlreadyExistsException(crate::error::ReplicationJobAlreadyExistsException),
    /// <p>The specified server cannot be replicated.</p>
    ServerCannotBeReplicatedException(crate::error::ServerCannotBeReplicatedException),
    /// <p>The service is temporarily unavailable.</p>
    TemporarilyUnavailableException(crate::error::TemporarilyUnavailableException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationJobErrorKind::InternalError(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationJobErrorKind::NoConnectorsAvailableException(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationJobErrorKind::ServerCannotBeReplicatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationJobErrorKind::TemporarilyUnavailableException(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            CreateReplicationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationJobError {
    fn code(&self) -> Option<&str> {
        CreateReplicationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationJobError {
    /// Creates a new `CreateReplicationJobError`.
    pub fn new(kind: CreateReplicationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, CreateReplicationJobErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::NoConnectorsAvailableException`.
    pub fn is_no_connectors_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::NoConnectorsAvailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException`.
    pub fn is_replication_job_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::ServerCannotBeReplicatedException`.
    pub fn is_server_cannot_be_replicated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::ServerCannotBeReplicatedException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::TemporarilyUnavailableException`.
    pub fn is_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::TemporarilyUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `CreateReplicationJobErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationJobErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for CreateReplicationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationJobErrorKind::InternalError(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            CreateReplicationJobErrorKind::NoConnectorsAvailableException(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::ReplicationJobAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateReplicationJobErrorKind::ServerCannotBeReplicatedException(_inner) => {
                Some(_inner)
            }
            CreateReplicationJobErrorKind::TemporarilyUnavailableException(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            CreateReplicationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppError {
    /// Kind of error that occurred.
    pub kind: DeleteAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            DeleteAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppError {
    fn code(&self) -> Option<&str> {
        DeleteAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppError {
    /// Creates a new `DeleteAppError`.
    pub fn new(kind: DeleteAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `DeleteAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, DeleteAppErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `DeleteAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppErrorKind::InternalError(_inner) => Some(_inner),
            DeleteAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            DeleteAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            DeleteAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteAppLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppLaunchConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppLaunchConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            DeleteAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteAppLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppLaunchConfigurationError {
    /// Creates a new `DeleteAppLaunchConfigurationError`.
    pub fn new(kind: DeleteAppLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAppLaunchConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppLaunchConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppLaunchConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppLaunchConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteAppLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppLaunchConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            DeleteAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            DeleteAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DeleteAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            DeleteAppLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteAppReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppReplicationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppReplicationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            DeleteAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException(
                _inner,
            ) => _inner.fmt(f),
            DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteAppReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppReplicationConfigurationError {
    /// Creates a new `DeleteAppReplicationConfigurationError`.
    pub fn new(
        kind: DeleteAppReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAppReplicationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppReplicationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppReplicationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppReplicationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteAppReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppReplicationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            DeleteAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteAppReplicationConfigurationErrorKind::MissingRequiredParameterException(
                _inner,
            ) => Some(_inner),
            DeleteAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DeleteAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            DeleteAppReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppValidationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteAppValidationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppValidationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppValidationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppValidationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            DeleteAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException(
                _inner,
            ) => _inner.fmt(f),
            DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAppValidationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppValidationConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteAppValidationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppValidationConfigurationError {
    /// Creates a new `DeleteAppValidationConfigurationError`.
    pub fn new(
        kind: DeleteAppValidationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppValidationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppValidationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppValidationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppValidationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAppValidationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppValidationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppValidationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppValidationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteAppValidationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppValidationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            DeleteAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteAppValidationConfigurationErrorKind::MissingRequiredParameterException(
                _inner,
            ) => Some(_inner),
            DeleteAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DeleteAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            DeleteAppValidationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationJobError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationJobErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified replication job does not exist.</p>
    ReplicationJobNotFoundException(crate::error::ReplicationJobNotFoundException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationJobErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteReplicationJobErrorKind::ReplicationJobNotFoundException(_inner) => _inner.fmt(f),
            DeleteReplicationJobErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            DeleteReplicationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationJobError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationJobError {
    /// Creates a new `DeleteReplicationJobError`.
    pub fn new(kind: DeleteReplicationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteReplicationJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteReplicationJobErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationJobErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteReplicationJobErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationJobErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteReplicationJobErrorKind::ReplicationJobNotFoundException`.
    pub fn is_replication_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationJobErrorKind::ReplicationJobNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteReplicationJobErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationJobErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteReplicationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            DeleteReplicationJobErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteReplicationJobErrorKind::ReplicationJobNotFoundException(_inner) => Some(_inner),
            DeleteReplicationJobErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            DeleteReplicationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServerCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServerCatalogError {
    /// Kind of error that occurred.
    pub kind: DeleteServerCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServerCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServerCatalogErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServerCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServerCatalogErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteServerCatalogErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteServerCatalogErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteServerCatalogErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            DeleteServerCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServerCatalogError {
    fn code(&self) -> Option<&str> {
        DeleteServerCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServerCatalogError {
    /// Creates a new `DeleteServerCatalogError`.
    pub fn new(kind: DeleteServerCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServerCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServerCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServerCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServerCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteServerCatalogErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCatalogErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServerCatalogErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCatalogErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServerCatalogErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCatalogErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServerCatalogErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCatalogErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DeleteServerCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServerCatalogErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteServerCatalogErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            DeleteServerCatalogErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteServerCatalogErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            DeleteServerCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateConnectorError {
    /// Kind of error that occurred.
    pub kind: DisassociateConnectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateConnector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateConnectorErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateConnectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateConnectorErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateConnectorErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateConnectorErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DisassociateConnectorErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            DisassociateConnectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateConnectorError {
    fn code(&self) -> Option<&str> {
        DisassociateConnectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateConnectorError {
    /// Creates a new `DisassociateConnectorError`.
    pub fn new(kind: DisassociateConnectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateConnectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateConnectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateConnectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateConnectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateConnectorErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectorErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateConnectorErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectorErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateConnectorErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectorErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateConnectorErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateConnectorErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for DisassociateConnectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateConnectorErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateConnectorErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateConnectorErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DisassociateConnectorErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            DisassociateConnectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateChangeSetError {
    /// Kind of error that occurred.
    pub kind: GenerateChangeSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateChangeSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateChangeSetErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateChangeSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateChangeSetErrorKind::InternalError(_inner) => _inner.fmt(f),
            GenerateChangeSetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GenerateChangeSetErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GenerateChangeSetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GenerateChangeSetErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GenerateChangeSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateChangeSetError {
    fn code(&self) -> Option<&str> {
        GenerateChangeSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateChangeSetError {
    /// Creates a new `GenerateChangeSetError`.
    pub fn new(kind: GenerateChangeSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateChangeSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateChangeSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateChangeSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateChangeSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GenerateChangeSetErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, GenerateChangeSetErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `GenerateChangeSetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateChangeSetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GenerateChangeSetErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateChangeSetErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GenerateChangeSetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateChangeSetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GenerateChangeSetErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateChangeSetErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GenerateChangeSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateChangeSetErrorKind::InternalError(_inner) => Some(_inner),
            GenerateChangeSetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GenerateChangeSetErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GenerateChangeSetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GenerateChangeSetErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GenerateChangeSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateTemplateError {
    /// Kind of error that occurred.
    pub kind: GenerateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateTemplateErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateTemplateErrorKind::InternalError(_inner) => _inner.fmt(f),
            GenerateTemplateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GenerateTemplateErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GenerateTemplateErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GenerateTemplateErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GenerateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateTemplateError {
    fn code(&self) -> Option<&str> {
        GenerateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateTemplateError {
    /// Creates a new `GenerateTemplateError`.
    pub fn new(kind: GenerateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GenerateTemplateErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, GenerateTemplateErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `GenerateTemplateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateTemplateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GenerateTemplateErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateTemplateErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GenerateTemplateErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateTemplateErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GenerateTemplateErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateTemplateErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GenerateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateTemplateErrorKind::InternalError(_inner) => Some(_inner),
            GenerateTemplateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GenerateTemplateErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GenerateTemplateErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GenerateTemplateErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GenerateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppError {
    /// Kind of error that occurred.
    pub kind: GetAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GetAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            GetAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GetAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppError {
    fn code(&self) -> Option<&str> {
        GetAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppError {
    /// Creates a new `GetAppError`.
    pub fn new(kind: GetAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `GetAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, GetAppErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `GetAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppErrorKind::InternalError(_inner) => Some(_inner),
            GetAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetAppLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppLaunchConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppLaunchConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetAppLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        GetAppLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppLaunchConfigurationError {
    /// Creates a new `GetAppLaunchConfigurationError`.
    pub fn new(kind: GetAppLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppLaunchConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            GetAppLaunchConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `GetAppLaunchConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppLaunchConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppLaunchConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppLaunchConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetAppLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppLaunchConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            GetAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            GetAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            GetAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            GetAppLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetAppReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppReplicationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppReplicationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetAppReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetAppReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppReplicationConfigurationError {
    /// Creates a new `GetAppReplicationConfigurationError`.
    pub fn new(
        kind: GetAppReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppReplicationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            GetAppReplicationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `GetAppReplicationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppReplicationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppReplicationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppReplicationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetAppReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppReplicationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            GetAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            GetAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            GetAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            GetAppReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppValidationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetAppValidationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppValidationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppValidationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppValidationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppValidationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetAppValidationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppValidationConfigurationError {
    /// Creates a new `GetAppValidationConfigurationError`.
    pub fn new(
        kind: GetAppValidationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppValidationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppValidationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppValidationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppValidationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppValidationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetAppValidationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppValidationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            GetAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetAppValidationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            GetAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            GetAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            GetAppValidationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAppValidationOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAppValidationOutputError {
    /// Kind of error that occurred.
    pub kind: GetAppValidationOutputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAppValidationOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAppValidationOutputErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAppValidationOutputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAppValidationOutputErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetAppValidationOutputErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAppValidationOutputErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationOutputErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationOutputErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetAppValidationOutputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAppValidationOutputError {
    fn code(&self) -> Option<&str> {
        GetAppValidationOutputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAppValidationOutputError {
    /// Creates a new `GetAppValidationOutputError`.
    pub fn new(kind: GetAppValidationOutputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAppValidationOutputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAppValidationOutputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAppValidationOutputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAppValidationOutputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAppValidationOutputErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationOutputErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationOutputErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationOutputErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationOutputErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationOutputErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationOutputErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationOutputErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `GetAppValidationOutputErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAppValidationOutputErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetAppValidationOutputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAppValidationOutputErrorKind::InternalError(_inner) => Some(_inner),
            GetAppValidationOutputErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAppValidationOutputErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            GetAppValidationOutputErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            GetAppValidationOutputErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetAppValidationOutputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectorsError {
    /// Kind of error that occurred.
    pub kind: GetConnectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectorsErrorKind {
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectorsErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GetConnectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectorsError {
    fn code(&self) -> Option<&str> {
        GetConnectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectorsError {
    /// Creates a new `GetConnectorsError`.
    pub fn new(kind: GetConnectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetConnectorsErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectorsErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetConnectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectorsErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetConnectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReplicationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReplicationJobsError {
    /// Kind of error that occurred.
    pub kind: GetReplicationJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReplicationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReplicationJobsErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReplicationJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReplicationJobsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetReplicationJobsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GetReplicationJobsErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GetReplicationJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReplicationJobsError {
    fn code(&self) -> Option<&str> {
        GetReplicationJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReplicationJobsError {
    /// Creates a new `GetReplicationJobsError`.
    pub fn new(kind: GetReplicationJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReplicationJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReplicationJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReplicationJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReplicationJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetReplicationJobsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationJobsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetReplicationJobsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationJobsErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetReplicationJobsErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationJobsErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetReplicationJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReplicationJobsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetReplicationJobsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetReplicationJobsErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetReplicationJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReplicationRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReplicationRunsError {
    /// Kind of error that occurred.
    pub kind: GetReplicationRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReplicationRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReplicationRunsErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReplicationRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReplicationRunsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetReplicationRunsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GetReplicationRunsErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GetReplicationRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReplicationRunsError {
    fn code(&self) -> Option<&str> {
        GetReplicationRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReplicationRunsError {
    /// Creates a new `GetReplicationRunsError`.
    pub fn new(kind: GetReplicationRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReplicationRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReplicationRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReplicationRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReplicationRunsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetReplicationRunsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationRunsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetReplicationRunsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationRunsErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetReplicationRunsErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReplicationRunsErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetReplicationRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReplicationRunsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetReplicationRunsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetReplicationRunsErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetReplicationRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServersError {
    /// Kind of error that occurred.
    pub kind: GetServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServersErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServersErrorKind::InternalError(_inner) => _inner.fmt(f),
            GetServersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetServersErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GetServersErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            GetServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServersError {
    fn code(&self) -> Option<&str> {
        GetServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServersError {
    /// Creates a new `GetServersError`.
    pub fn new(kind: GetServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetServersErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, GetServersErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `GetServersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetServersErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServersErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetServersErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServersErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for GetServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServersErrorKind::InternalError(_inner) => Some(_inner),
            GetServersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetServersErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetServersErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            GetServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportAppCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportAppCatalogError {
    /// Kind of error that occurred.
    pub kind: ImportAppCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportAppCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportAppCatalogErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportAppCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportAppCatalogErrorKind::InternalError(_inner) => _inner.fmt(f),
            ImportAppCatalogErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ImportAppCatalogErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            ImportAppCatalogErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ImportAppCatalogErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            ImportAppCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportAppCatalogError {
    fn code(&self) -> Option<&str> {
        ImportAppCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportAppCatalogError {
    /// Creates a new `ImportAppCatalogError`.
    pub fn new(kind: ImportAppCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportAppCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportAppCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportAppCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportAppCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportAppCatalogErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, ImportAppCatalogErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `ImportAppCatalogErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAppCatalogErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ImportAppCatalogErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAppCatalogErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `ImportAppCatalogErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAppCatalogErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `ImportAppCatalogErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportAppCatalogErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for ImportAppCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportAppCatalogErrorKind::InternalError(_inner) => Some(_inner),
            ImportAppCatalogErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ImportAppCatalogErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            ImportAppCatalogErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ImportAppCatalogErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            ImportAppCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportServerCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportServerCatalogError {
    /// Kind of error that occurred.
    pub kind: ImportServerCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportServerCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportServerCatalogErrorKind {
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>There are no connectors available.</p>
    NoConnectorsAvailableException(crate::error::NoConnectorsAvailableException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportServerCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportServerCatalogErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ImportServerCatalogErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            ImportServerCatalogErrorKind::NoConnectorsAvailableException(_inner) => _inner.fmt(f),
            ImportServerCatalogErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ImportServerCatalogErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            ImportServerCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportServerCatalogError {
    fn code(&self) -> Option<&str> {
        ImportServerCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportServerCatalogError {
    /// Creates a new `ImportServerCatalogError`.
    pub fn new(kind: ImportServerCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportServerCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportServerCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportServerCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportServerCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ImportServerCatalogErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportServerCatalogErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ImportServerCatalogErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportServerCatalogErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `ImportServerCatalogErrorKind::NoConnectorsAvailableException`.
    pub fn is_no_connectors_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportServerCatalogErrorKind::NoConnectorsAvailableException(_)
        )
    }
    /// Returns true if the error kind is `ImportServerCatalogErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportServerCatalogErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `ImportServerCatalogErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportServerCatalogErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for ImportServerCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportServerCatalogErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ImportServerCatalogErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            ImportServerCatalogErrorKind::NoConnectorsAvailableException(_inner) => Some(_inner),
            ImportServerCatalogErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ImportServerCatalogErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            ImportServerCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `LaunchApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct LaunchAppError {
    /// Kind of error that occurred.
    pub kind: LaunchAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `LaunchApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum LaunchAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for LaunchAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            LaunchAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            LaunchAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            LaunchAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            LaunchAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            LaunchAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            LaunchAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for LaunchAppError {
    fn code(&self) -> Option<&str> {
        LaunchAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl LaunchAppError {
    /// Creates a new `LaunchAppError`.
    pub fn new(kind: LaunchAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `LaunchAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: LaunchAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `LaunchAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: LaunchAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `LaunchAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, LaunchAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `LaunchAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, LaunchAppErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `LaunchAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            LaunchAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `LaunchAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            LaunchAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `LaunchAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            LaunchAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for LaunchAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            LaunchAppErrorKind::InternalError(_inner) => Some(_inner),
            LaunchAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            LaunchAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            LaunchAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            LaunchAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            LaunchAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAppsError {
    /// Kind of error that occurred.
    pub kind: ListAppsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAppsErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAppsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAppsErrorKind::InternalError(_inner) => _inner.fmt(f),
            ListAppsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            ListAppsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAppsError {
    fn code(&self) -> Option<&str> {
        ListAppsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAppsError {
    /// Creates a new `ListAppsError`.
    pub fn new(kind: ListAppsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAppsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAppsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAppsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAppsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAppsErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, ListAppsErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `ListAppsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, ListAppsErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `ListAppsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListAppsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `ListAppsErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAppsErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for ListAppsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAppsErrorKind::InternalError(_inner) => Some(_inner),
            ListAppsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAppsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            ListAppsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            ListAppsErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            ListAppsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `NotifyAppValidationOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct NotifyAppValidationOutputError {
    /// Kind of error that occurred.
    pub kind: NotifyAppValidationOutputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `NotifyAppValidationOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum NotifyAppValidationOutputErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for NotifyAppValidationOutputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            NotifyAppValidationOutputErrorKind::InternalError(_inner) => _inner.fmt(f),
            NotifyAppValidationOutputErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            NotifyAppValidationOutputErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            NotifyAppValidationOutputErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            NotifyAppValidationOutputErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            NotifyAppValidationOutputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for NotifyAppValidationOutputError {
    fn code(&self) -> Option<&str> {
        NotifyAppValidationOutputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl NotifyAppValidationOutputError {
    /// Creates a new `NotifyAppValidationOutputError`.
    pub fn new(kind: NotifyAppValidationOutputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `NotifyAppValidationOutputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: NotifyAppValidationOutputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `NotifyAppValidationOutputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: NotifyAppValidationOutputErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `NotifyAppValidationOutputErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            NotifyAppValidationOutputErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `NotifyAppValidationOutputErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyAppValidationOutputErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `NotifyAppValidationOutputErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyAppValidationOutputErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `NotifyAppValidationOutputErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyAppValidationOutputErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `NotifyAppValidationOutputErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            NotifyAppValidationOutputErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for NotifyAppValidationOutputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            NotifyAppValidationOutputErrorKind::InternalError(_inner) => Some(_inner),
            NotifyAppValidationOutputErrorKind::InvalidParameterException(_inner) => Some(_inner),
            NotifyAppValidationOutputErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            NotifyAppValidationOutputErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            NotifyAppValidationOutputErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            NotifyAppValidationOutputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAppLaunchConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutAppLaunchConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAppLaunchConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAppLaunchConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAppLaunchConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAppLaunchConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            PutAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutAppLaunchConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAppLaunchConfigurationError {
    fn code(&self) -> Option<&str> {
        PutAppLaunchConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAppLaunchConfigurationError {
    /// Creates a new `PutAppLaunchConfigurationError`.
    pub fn new(kind: PutAppLaunchConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAppLaunchConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAppLaunchConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAppLaunchConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAppLaunchConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutAppLaunchConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            PutAppLaunchConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `PutAppLaunchConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppLaunchConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppLaunchConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppLaunchConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for PutAppLaunchConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAppLaunchConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            PutAppLaunchConfigurationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutAppLaunchConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            PutAppLaunchConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            PutAppLaunchConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            PutAppLaunchConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAppReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutAppReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAppReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAppReplicationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAppReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAppReplicationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            PutAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutAppReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAppReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutAppReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAppReplicationConfigurationError {
    /// Creates a new `PutAppReplicationConfigurationError`.
    pub fn new(
        kind: PutAppReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAppReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAppReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAppReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAppReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutAppReplicationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            PutAppReplicationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `PutAppReplicationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppReplicationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppReplicationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppReplicationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for PutAppReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAppReplicationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            PutAppReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutAppReplicationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            PutAppReplicationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            PutAppReplicationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            PutAppReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAppValidationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutAppValidationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAppValidationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAppValidationConfigurationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAppValidationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAppValidationConfigurationErrorKind::InternalError(_inner) => _inner.fmt(f),
            PutAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutAppValidationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            PutAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutAppValidationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAppValidationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutAppValidationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAppValidationConfigurationError {
    /// Creates a new `PutAppValidationConfigurationError`.
    pub fn new(
        kind: PutAppValidationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAppValidationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAppValidationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAppValidationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAppValidationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutAppValidationConfigurationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            PutAppValidationConfigurationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `PutAppValidationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppValidationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppValidationConfigurationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppValidationConfigurationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `PutAppValidationConfigurationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppValidationConfigurationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `PutAppValidationConfigurationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAppValidationConfigurationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for PutAppValidationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAppValidationConfigurationErrorKind::InternalError(_inner) => Some(_inner),
            PutAppValidationConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutAppValidationConfigurationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            PutAppValidationConfigurationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            PutAppValidationConfigurationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            PutAppValidationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAppReplicationError {
    /// Kind of error that occurred.
    pub kind: StartAppReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAppReplicationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAppReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAppReplicationErrorKind::InternalError(_inner) => _inner.fmt(f),
            StartAppReplicationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartAppReplicationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartAppReplicationErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StartAppReplicationErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            StartAppReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAppReplicationError {
    fn code(&self) -> Option<&str> {
        StartAppReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAppReplicationError {
    /// Creates a new `StartAppReplicationError`.
    pub fn new(kind: StartAppReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAppReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAppReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAppReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAppReplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartAppReplicationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, StartAppReplicationErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `StartAppReplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAppReplicationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartAppReplicationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAppReplicationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartAppReplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAppReplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `StartAppReplicationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAppReplicationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for StartAppReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAppReplicationErrorKind::InternalError(_inner) => Some(_inner),
            StartAppReplicationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartAppReplicationErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            StartAppReplicationErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StartAppReplicationErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            StartAppReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartOnDemandAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartOnDemandAppReplicationError {
    /// Kind of error that occurred.
    pub kind: StartOnDemandAppReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartOnDemandAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartOnDemandAppReplicationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartOnDemandAppReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartOnDemandAppReplicationErrorKind::InternalError(_inner) => _inner.fmt(f),
            StartOnDemandAppReplicationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandAppReplicationErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandAppReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartOnDemandAppReplicationError {
    fn code(&self) -> Option<&str> {
        StartOnDemandAppReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartOnDemandAppReplicationError {
    /// Creates a new `StartOnDemandAppReplicationError`.
    pub fn new(kind: StartOnDemandAppReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartOnDemandAppReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartOnDemandAppReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartOnDemandAppReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartOnDemandAppReplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartOnDemandAppReplicationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandAppReplicationErrorKind::InternalError(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandAppReplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandAppReplicationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandAppReplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandAppReplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for StartOnDemandAppReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartOnDemandAppReplicationErrorKind::InternalError(_inner) => Some(_inner),
            StartOnDemandAppReplicationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartOnDemandAppReplicationErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            StartOnDemandAppReplicationErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            StartOnDemandAppReplicationErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            StartOnDemandAppReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartOnDemandReplicationRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartOnDemandReplicationRunError {
    /// Kind of error that occurred.
    pub kind: StartOnDemandReplicationRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartOnDemandReplicationRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartOnDemandReplicationRunErrorKind {
    /// <p>The user has the required permissions, so the request would have succeeded,
    /// but a dry run was performed.</p>
    DryRunOperationException(crate::error::DryRunOperationException),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You have exceeded the number of on-demand replication runs you can request in a
    /// 24-hour period.</p>
    ReplicationRunLimitExceededException(crate::error::ReplicationRunLimitExceededException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartOnDemandReplicationRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartOnDemandReplicationRunErrorKind::DryRunOperationException(_inner) => _inner.fmt(f),
            StartOnDemandReplicationRunErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandReplicationRunErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException(_inner) => {
                _inner.fmt(f)
            }
            StartOnDemandReplicationRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartOnDemandReplicationRunError {
    fn code(&self) -> Option<&str> {
        StartOnDemandReplicationRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartOnDemandReplicationRunError {
    /// Creates a new `StartOnDemandReplicationRunError`.
    pub fn new(kind: StartOnDemandReplicationRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartOnDemandReplicationRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartOnDemandReplicationRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartOnDemandReplicationRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartOnDemandReplicationRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::DryRunOperationException`.
    pub fn is_dry_run_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::DryRunOperationException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException`.
    pub fn is_replication_run_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for StartOnDemandReplicationRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartOnDemandReplicationRunErrorKind::DryRunOperationException(_inner) => Some(_inner),
            StartOnDemandReplicationRunErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartOnDemandReplicationRunErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            StartOnDemandReplicationRunErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            StartOnDemandReplicationRunErrorKind::ReplicationRunLimitExceededException(_inner) => {
                Some(_inner)
            }
            StartOnDemandReplicationRunErrorKind::UnauthorizedOperationException(_inner) => {
                Some(_inner)
            }
            StartOnDemandReplicationRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopAppReplicationError {
    /// Kind of error that occurred.
    pub kind: StopAppReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopAppReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopAppReplicationErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopAppReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopAppReplicationErrorKind::InternalError(_inner) => _inner.fmt(f),
            StopAppReplicationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopAppReplicationErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            StopAppReplicationErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StopAppReplicationErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            StopAppReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopAppReplicationError {
    fn code(&self) -> Option<&str> {
        StopAppReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopAppReplicationError {
    /// Creates a new `StopAppReplicationError`.
    pub fn new(kind: StopAppReplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopAppReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopAppReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopAppReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopAppReplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopAppReplicationErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, StopAppReplicationErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `StopAppReplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAppReplicationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `StopAppReplicationErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAppReplicationErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `StopAppReplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAppReplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `StopAppReplicationErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAppReplicationErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for StopAppReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopAppReplicationErrorKind::InternalError(_inner) => Some(_inner),
            StopAppReplicationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopAppReplicationErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            StopAppReplicationErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StopAppReplicationErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            StopAppReplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateAppError {
    /// Kind of error that occurred.
    pub kind: TerminateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            TerminateAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TerminateAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            TerminateAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            TerminateAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            TerminateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateAppError {
    fn code(&self) -> Option<&str> {
        TerminateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateAppError {
    /// Creates a new `TerminateAppError`.
    pub fn new(kind: TerminateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TerminateAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, TerminateAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `TerminateAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateAppErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `TerminateAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `TerminateAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `TerminateAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for TerminateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateAppErrorKind::InternalError(_inner) => Some(_inner),
            TerminateAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TerminateAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            TerminateAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            TerminateAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            TerminateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAppError {
    /// Kind of error that occurred.
    pub kind: UpdateAppErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAppErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAppError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAppErrorKind::InternalError(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            UpdateAppErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAppError {
    fn code(&self) -> Option<&str> {
        UpdateAppError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAppError {
    /// Creates a new `UpdateAppError`.
    pub fn new(kind: UpdateAppErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAppError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAppErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAppError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAppErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAppErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `UpdateAppErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, UpdateAppErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `UpdateAppErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAppErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAppErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAppErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAppErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAppErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateAppError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAppErrorKind::InternalError(_inner) => Some(_inner),
            UpdateAppErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateAppErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            UpdateAppErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateAppErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            UpdateAppErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReplicationJobError {
    /// Kind of error that occurred.
    pub kind: UpdateReplicationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReplicationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReplicationJobErrorKind {
    /// <p>An internal error occurred.</p>
    InternalError(crate::error::InternalError),
    /// <p>A specified parameter is not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>A required parameter is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>This operation is not allowed.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified replication job does not exist.</p>
    ReplicationJobNotFoundException(crate::error::ReplicationJobNotFoundException),
    /// <p>The specified server cannot be replicated.</p>
    ServerCannotBeReplicatedException(crate::error::ServerCannotBeReplicatedException),
    /// <p>The service is temporarily unavailable.</p>
    TemporarilyUnavailableException(crate::error::TemporarilyUnavailableException),
    /// <p>You lack permissions needed to perform this operation. Check your IAM policies,
    /// and ensure that you are using the correct access keys.</p>
    UnauthorizedOperationException(crate::error::UnauthorizedOperationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReplicationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReplicationJobErrorKind::InternalError(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationJobErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::ReplicationJobNotFoundException(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateReplicationJobErrorKind::TemporarilyUnavailableException(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::UnauthorizedOperationException(_inner) => _inner.fmt(f),
            UpdateReplicationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReplicationJobError {
    fn code(&self) -> Option<&str> {
        UpdateReplicationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReplicationJobError {
    /// Creates a new `UpdateReplicationJobError`.
    pub fn new(kind: UpdateReplicationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReplicationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReplicationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReplicationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReplicationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::InternalError`.
    pub fn is_internal_error(&self) -> bool {
        matches!(&self.kind, UpdateReplicationJobErrorKind::InternalError(_))
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::ReplicationJobNotFoundException`.
    pub fn is_replication_job_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::ReplicationJobNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException`.
    pub fn is_server_cannot_be_replicated_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::TemporarilyUnavailableException`.
    pub fn is_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::TemporarilyUnavailableException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReplicationJobErrorKind::UnauthorizedOperationException`.
    pub fn is_unauthorized_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReplicationJobErrorKind::UnauthorizedOperationException(_)
        )
    }
}
impl std::error::Error for UpdateReplicationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReplicationJobErrorKind::InternalError(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationJobErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::ReplicationJobNotFoundException(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::ServerCannotBeReplicatedException(_inner) => {
                Some(_inner)
            }
            UpdateReplicationJobErrorKind::TemporarilyUnavailableException(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::UnauthorizedOperationException(_inner) => Some(_inner),
            UpdateReplicationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>You lack permissions needed to perform this operation. Check your IAM policies,
/// and ensure that you are using the correct access keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedOperationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedOperationException {}
/// See [`UnauthorizedOperationException`](crate::error::UnauthorizedOperationException)
pub mod unauthorized_operation_exception {
    /// A builder for [`UnauthorizedOperationException`](crate::error::UnauthorizedOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedOperationException`](crate::error::UnauthorizedOperationException)
        pub fn build(self) -> crate::error::UnauthorizedOperationException {
            crate::error::UnauthorizedOperationException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedOperationException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedOperationException`](crate::error::UnauthorizedOperationException)
    pub fn builder() -> crate::error::unauthorized_operation_exception::Builder {
        crate::error::unauthorized_operation_exception::Builder::default()
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemporarilyUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemporarilyUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TemporarilyUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TemporarilyUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TemporarilyUnavailableException {}
/// See [`TemporarilyUnavailableException`](crate::error::TemporarilyUnavailableException)
pub mod temporarily_unavailable_exception {
    /// A builder for [`TemporarilyUnavailableException`](crate::error::TemporarilyUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TemporarilyUnavailableException`](crate::error::TemporarilyUnavailableException)
        pub fn build(self) -> crate::error::TemporarilyUnavailableException {
            crate::error::TemporarilyUnavailableException {
                message: self.message,
            }
        }
    }
}
impl TemporarilyUnavailableException {
    /// Creates a new builder-style object to manufacture [`TemporarilyUnavailableException`](crate::error::TemporarilyUnavailableException)
    pub fn builder() -> crate::error::temporarily_unavailable_exception::Builder {
        crate::error::temporarily_unavailable_exception::Builder::default()
    }
}

/// <p>The specified server cannot be replicated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerCannotBeReplicatedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerCannotBeReplicatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerCannotBeReplicatedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerCannotBeReplicatedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerCannotBeReplicatedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerCannotBeReplicatedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerCannotBeReplicatedException {}
/// See [`ServerCannotBeReplicatedException`](crate::error::ServerCannotBeReplicatedException)
pub mod server_cannot_be_replicated_exception {
    /// A builder for [`ServerCannotBeReplicatedException`](crate::error::ServerCannotBeReplicatedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerCannotBeReplicatedException`](crate::error::ServerCannotBeReplicatedException)
        pub fn build(self) -> crate::error::ServerCannotBeReplicatedException {
            crate::error::ServerCannotBeReplicatedException {
                message: self.message,
            }
        }
    }
}
impl ServerCannotBeReplicatedException {
    /// Creates a new builder-style object to manufacture [`ServerCannotBeReplicatedException`](crate::error::ServerCannotBeReplicatedException)
    pub fn builder() -> crate::error::server_cannot_be_replicated_exception::Builder {
        crate::error::server_cannot_be_replicated_exception::Builder::default()
    }
}

/// <p>The specified replication job does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationJobNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicationJobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationJobNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicationJobNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicationJobNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicationJobNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicationJobNotFoundException {}
/// See [`ReplicationJobNotFoundException`](crate::error::ReplicationJobNotFoundException)
pub mod replication_job_not_found_exception {
    /// A builder for [`ReplicationJobNotFoundException`](crate::error::ReplicationJobNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationJobNotFoundException`](crate::error::ReplicationJobNotFoundException)
        pub fn build(self) -> crate::error::ReplicationJobNotFoundException {
            crate::error::ReplicationJobNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ReplicationJobNotFoundException {
    /// Creates a new builder-style object to manufacture [`ReplicationJobNotFoundException`](crate::error::ReplicationJobNotFoundException)
    pub fn builder() -> crate::error::replication_job_not_found_exception::Builder {
        crate::error::replication_job_not_found_exception::Builder::default()
    }
}

/// <p>This operation is not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>A required parameter is missing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingRequiredParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingRequiredParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingRequiredParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingRequiredParameterException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingRequiredParameterException {}
/// See [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
pub mod missing_required_parameter_exception {
    /// A builder for [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
        pub fn build(self) -> crate::error::MissingRequiredParameterException {
            crate::error::MissingRequiredParameterException {
                message: self.message,
            }
        }
    }
}
impl MissingRequiredParameterException {
    /// Creates a new builder-style object to manufacture [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    pub fn builder() -> crate::error::missing_required_parameter_exception::Builder {
        crate::error::missing_required_parameter_exception::Builder::default()
    }
}

/// <p>A specified parameter is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>An internal error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalError")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalError {}
/// See [`InternalError`](crate::error::InternalError)
pub mod internal_error {
    /// A builder for [`InternalError`](crate::error::InternalError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalError`](crate::error::InternalError)
        pub fn build(self) -> crate::error::InternalError {
            crate::error::InternalError {
                message: self.message,
            }
        }
    }
}
impl InternalError {
    /// Creates a new builder-style object to manufacture [`InternalError`](crate::error::InternalError)
    pub fn builder() -> crate::error::internal_error::Builder {
        crate::error::internal_error::Builder::default()
    }
}

/// <p>You have exceeded the number of on-demand replication runs you can request in a
/// 24-hour period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationRunLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicationRunLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationRunLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicationRunLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicationRunLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicationRunLimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicationRunLimitExceededException {}
/// See [`ReplicationRunLimitExceededException`](crate::error::ReplicationRunLimitExceededException)
pub mod replication_run_limit_exceeded_exception {
    /// A builder for [`ReplicationRunLimitExceededException`](crate::error::ReplicationRunLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationRunLimitExceededException`](crate::error::ReplicationRunLimitExceededException)
        pub fn build(self) -> crate::error::ReplicationRunLimitExceededException {
            crate::error::ReplicationRunLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ReplicationRunLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ReplicationRunLimitExceededException`](crate::error::ReplicationRunLimitExceededException)
    pub fn builder() -> crate::error::replication_run_limit_exceeded_exception::Builder {
        crate::error::replication_run_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The user has the required permissions, so the request would have succeeded,
/// but a dry run was performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DryRunOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DryRunOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DryRunOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DryRunOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DryRunOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DryRunOperationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DryRunOperationException {}
/// See [`DryRunOperationException`](crate::error::DryRunOperationException)
pub mod dry_run_operation_exception {
    /// A builder for [`DryRunOperationException`](crate::error::DryRunOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DryRunOperationException`](crate::error::DryRunOperationException)
        pub fn build(self) -> crate::error::DryRunOperationException {
            crate::error::DryRunOperationException {
                message: self.message,
            }
        }
    }
}
impl DryRunOperationException {
    /// Creates a new builder-style object to manufacture [`DryRunOperationException`](crate::error::DryRunOperationException)
    pub fn builder() -> crate::error::dry_run_operation_exception::Builder {
        crate::error::dry_run_operation_exception::Builder::default()
    }
}

/// <p>There are no connectors available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoConnectorsAvailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoConnectorsAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoConnectorsAvailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoConnectorsAvailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoConnectorsAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoConnectorsAvailableException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoConnectorsAvailableException {}
/// See [`NoConnectorsAvailableException`](crate::error::NoConnectorsAvailableException)
pub mod no_connectors_available_exception {
    /// A builder for [`NoConnectorsAvailableException`](crate::error::NoConnectorsAvailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoConnectorsAvailableException`](crate::error::NoConnectorsAvailableException)
        pub fn build(self) -> crate::error::NoConnectorsAvailableException {
            crate::error::NoConnectorsAvailableException {
                message: self.message,
            }
        }
    }
}
impl NoConnectorsAvailableException {
    /// Creates a new builder-style object to manufacture [`NoConnectorsAvailableException`](crate::error::NoConnectorsAvailableException)
    pub fn builder() -> crate::error::no_connectors_available_exception::Builder {
        crate::error::no_connectors_available_exception::Builder::default()
    }
}

/// <p>The specified replication job already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationJobAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicationJobAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationJobAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicationJobAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicationJobAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicationJobAlreadyExistsException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicationJobAlreadyExistsException {}
/// See [`ReplicationJobAlreadyExistsException`](crate::error::ReplicationJobAlreadyExistsException)
pub mod replication_job_already_exists_exception {
    /// A builder for [`ReplicationJobAlreadyExistsException`](crate::error::ReplicationJobAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationJobAlreadyExistsException`](crate::error::ReplicationJobAlreadyExistsException)
        pub fn build(self) -> crate::error::ReplicationJobAlreadyExistsException {
            crate::error::ReplicationJobAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ReplicationJobAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ReplicationJobAlreadyExistsException`](crate::error::ReplicationJobAlreadyExistsException)
    pub fn builder() -> crate::error::replication_job_already_exists_exception::Builder {
        crate::error::replication_job_already_exists_exception::Builder::default()
    }
}
