// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Signer
///
/// Client for invoking operations on AWS Signer. Each operation on AWS Signer is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_signer::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_signer::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_signer::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddProfilePermission`](crate::client::fluent_builders::AddProfilePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_profile_name): <p>The human-readable name of the signing profile.</p>
    ///   - [`profile_version(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::profile_version) / [`set_profile_version(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_profile_version): <p>The version of the signing profile.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_action): <p>The AWS Signer action permitted as part of cross-account permissions.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_principal): <p>The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_revision_id): <p>A unique identifier for the current profile revision.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::AddProfilePermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::AddProfilePermission::set_statement_id): <p>A unique identifier for the cross-account permission statement.</p>
    /// - On success, responds with [`AddProfilePermissionOutput`](crate::output::AddProfilePermissionOutput) with field(s):
    ///   - [`revision_id(Option<String>)`](crate::output::AddProfilePermissionOutput::revision_id): <p>A unique identifier for the current profile revision.</p>
    /// - On failure, responds with [`SdkError<AddProfilePermissionError>`](crate::error::AddProfilePermissionError)
    pub fn add_profile_permission(&self) -> fluent_builders::AddProfilePermission {
        fluent_builders::AddProfilePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelSigningProfile`](crate::client::fluent_builders::CancelSigningProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::CancelSigningProfile::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::CancelSigningProfile::set_profile_name): <p>The name of the signing profile to be canceled.</p>
    /// - On success, responds with [`CancelSigningProfileOutput`](crate::output::CancelSigningProfileOutput)

    /// - On failure, responds with [`SdkError<CancelSigningProfileError>`](crate::error::CancelSigningProfileError)
    pub fn cancel_signing_profile(&self) -> fluent_builders::CancelSigningProfile {
        fluent_builders::CancelSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSigningJob`](crate::client::fluent_builders::DescribeSigningJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSigningJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeSigningJob::set_job_id): <p>The ID of the signing job on input.</p>
    /// - On success, responds with [`DescribeSigningJobOutput`](crate::output::DescribeSigningJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::DescribeSigningJobOutput::job_id): <p>The ID of the signing job on output.</p>
    ///   - [`source(Option<Source>)`](crate::output::DescribeSigningJobOutput::source): <p>The object that contains the name of your S3 bucket or your raw code.</p>
    ///   - [`signing_material(Option<SigningMaterial>)`](crate::output::DescribeSigningJobOutput::signing_material): <p>The Amazon Resource Name (ARN) of your code signing certificate.</p>
    ///   - [`platform_id(Option<String>)`](crate::output::DescribeSigningJobOutput::platform_id): <p>The microcontroller platform to which your signed code image will be distributed.</p>
    ///   - [`platform_display_name(Option<String>)`](crate::output::DescribeSigningJobOutput::platform_display_name): <p>A human-readable name for the signing platform associated with the signing job.</p>
    ///   - [`profile_name(Option<String>)`](crate::output::DescribeSigningJobOutput::profile_name): <p>The name of the profile that initiated the signing operation.</p>
    ///   - [`profile_version(Option<String>)`](crate::output::DescribeSigningJobOutput::profile_version): <p>The version of the signing profile used to initiate the signing job.</p>
    ///   - [`overrides(Option<SigningPlatformOverrides>)`](crate::output::DescribeSigningJobOutput::overrides): <p>A list of any overrides that were applied to the signing operation.</p>
    ///   - [`signing_parameters(Option<HashMap<String, String>>)`](crate::output::DescribeSigningJobOutput::signing_parameters): <p>Map of user-assigned key-value pairs used during signing. These values contain any information that you specified for use in your signing job. </p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeSigningJobOutput::created_at): <p>Date and time that the signing job was created.</p>
    ///   - [`completed_at(Option<DateTime>)`](crate::output::DescribeSigningJobOutput::completed_at): <p>Date and time that the signing job was completed.</p>
    ///   - [`signature_expires_at(Option<DateTime>)`](crate::output::DescribeSigningJobOutput::signature_expires_at): <p>Thr expiration timestamp for the signature generated by the signing job.</p>
    ///   - [`requested_by(Option<String>)`](crate::output::DescribeSigningJobOutput::requested_by): <p>The IAM principal that requested the signing job.</p>
    ///   - [`status(Option<SigningStatus>)`](crate::output::DescribeSigningJobOutput::status): <p>Status of the signing job.</p>
    ///   - [`status_reason(Option<String>)`](crate::output::DescribeSigningJobOutput::status_reason): <p>String value that contains the status reason.</p>
    ///   - [`revocation_record(Option<SigningJobRevocationRecord>)`](crate::output::DescribeSigningJobOutput::revocation_record): <p>A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the ID of the IAM entity that revoked the signature.</p>
    ///   - [`signed_object(Option<SignedObject>)`](crate::output::DescribeSigningJobOutput::signed_object): <p>Name of the S3 bucket where the signed code image is saved by code signing.</p>
    ///   - [`job_owner(Option<String>)`](crate::output::DescribeSigningJobOutput::job_owner): <p>The AWS account ID of the job owner.</p>
    ///   - [`job_invoker(Option<String>)`](crate::output::DescribeSigningJobOutput::job_invoker): <p>The IAM entity that initiated the signing job.</p>
    /// - On failure, responds with [`SdkError<DescribeSigningJobError>`](crate::error::DescribeSigningJobError)
    pub fn describe_signing_job(&self) -> fluent_builders::DescribeSigningJob {
        fluent_builders::DescribeSigningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSigningPlatform`](crate::client::fluent_builders::GetSigningPlatform) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform_id(impl Into<String>)`](crate::client::fluent_builders::GetSigningPlatform::platform_id) / [`set_platform_id(Option<String>)`](crate::client::fluent_builders::GetSigningPlatform::set_platform_id): <p>The ID of the target signing platform.</p>
    /// - On success, responds with [`GetSigningPlatformOutput`](crate::output::GetSigningPlatformOutput) with field(s):
    ///   - [`platform_id(Option<String>)`](crate::output::GetSigningPlatformOutput::platform_id): <p>The ID of the target signing platform.</p>
    ///   - [`display_name(Option<String>)`](crate::output::GetSigningPlatformOutput::display_name): <p>The display name of the target signing platform.</p>
    ///   - [`partner(Option<String>)`](crate::output::GetSigningPlatformOutput::partner): <p>A list of partner entities that use the target signing platform.</p>
    ///   - [`target(Option<String>)`](crate::output::GetSigningPlatformOutput::target): <p>The validation template that is used by the target signing platform.</p>
    ///   - [`category(Option<Category>)`](crate::output::GetSigningPlatformOutput::category): <p>The category type of the target signing platform.</p>
    ///   - [`signing_configuration(Option<SigningConfiguration>)`](crate::output::GetSigningPlatformOutput::signing_configuration): <p>A list of configurations applied to the target platform at signing.</p>
    ///   - [`signing_image_format(Option<SigningImageFormat>)`](crate::output::GetSigningPlatformOutput::signing_image_format): <p>The format of the target platform's signing image.</p>
    ///   - [`max_size_in_mb(i32)`](crate::output::GetSigningPlatformOutput::max_size_in_mb): <p>The maximum size (in MB) of the payload that can be signed by the target platform.</p>
    ///   - [`revocation_supported(bool)`](crate::output::GetSigningPlatformOutput::revocation_supported): <p>A flag indicating whether signatures generated for the signing platform can be revoked.</p>
    /// - On failure, responds with [`SdkError<GetSigningPlatformError>`](crate::error::GetSigningPlatformError)
    pub fn get_signing_platform(&self) -> fluent_builders::GetSigningPlatform {
        fluent_builders::GetSigningPlatform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSigningProfile`](crate::client::fluent_builders::GetSigningProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::GetSigningProfile::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::GetSigningProfile::set_profile_name): <p>The name of the target signing profile.</p>
    ///   - [`profile_owner(impl Into<String>)`](crate::client::fluent_builders::GetSigningProfile::profile_owner) / [`set_profile_owner(Option<String>)`](crate::client::fluent_builders::GetSigningProfile::set_profile_owner): <p>The AWS account ID of the profile owner.</p>
    /// - On success, responds with [`GetSigningProfileOutput`](crate::output::GetSigningProfileOutput) with field(s):
    ///   - [`profile_name(Option<String>)`](crate::output::GetSigningProfileOutput::profile_name): <p>The name of the target signing profile.</p>
    ///   - [`profile_version(Option<String>)`](crate::output::GetSigningProfileOutput::profile_version): <p>The current version of the signing profile.</p>
    ///   - [`profile_version_arn(Option<String>)`](crate::output::GetSigningProfileOutput::profile_version_arn): <p>The signing profile ARN, including the profile version.</p>
    ///   - [`revocation_record(Option<SigningProfileRevocationRecord>)`](crate::output::GetSigningProfileOutput::revocation_record): <p>Revocation information for a signing profile.</p>
    ///   - [`signing_material(Option<SigningMaterial>)`](crate::output::GetSigningProfileOutput::signing_material): <p>The ARN of the certificate that the target profile uses for signing operations.</p>
    ///   - [`platform_id(Option<String>)`](crate::output::GetSigningProfileOutput::platform_id): <p>The ID of the platform that is used by the target signing profile.</p>
    ///   - [`platform_display_name(Option<String>)`](crate::output::GetSigningProfileOutput::platform_display_name): <p>A human-readable name for the signing platform associated with the signing profile.</p>
    ///   - [`signature_validity_period(Option<SignatureValidityPeriod>)`](crate::output::GetSigningProfileOutput::signature_validity_period): <p>The validity period for a signing job.</p>
    ///   - [`overrides(Option<SigningPlatformOverrides>)`](crate::output::GetSigningProfileOutput::overrides): <p>A list of overrides applied by the target signing profile for signing operations.</p>
    ///   - [`signing_parameters(Option<HashMap<String, String>>)`](crate::output::GetSigningProfileOutput::signing_parameters): <p>A map of key-value pairs for signing operations that is attached to the target signing profile.</p>
    ///   - [`status(Option<SigningProfileStatus>)`](crate::output::GetSigningProfileOutput::status): <p>The status of the target signing profile.</p>
    ///   - [`status_reason(Option<String>)`](crate::output::GetSigningProfileOutput::status_reason): <p>Reason for the status of the target signing profile.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetSigningProfileOutput::arn): <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetSigningProfileOutput::tags): <p>A list of tags associated with the signing profile.</p>
    /// - On failure, responds with [`SdkError<GetSigningProfileError>`](crate::error::GetSigningProfileError)
    pub fn get_signing_profile(&self) -> fluent_builders::GetSigningProfile {
        fluent_builders::GetSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProfilePermissions`](crate::client::fluent_builders::ListProfilePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::ListProfilePermissions::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::ListProfilePermissions::set_profile_name): <p>Name of the signing profile containing the cross-account permissions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProfilePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProfilePermissions::set_next_token): <p>String for specifying the next set of paginated results.</p>
    /// - On success, responds with [`ListProfilePermissionsOutput`](crate::output::ListProfilePermissionsOutput) with field(s):
    ///   - [`revision_id(Option<String>)`](crate::output::ListProfilePermissionsOutput::revision_id): <p>The identifier for the current revision of profile permissions.</p>
    ///   - [`policy_size_bytes(i32)`](crate::output::ListProfilePermissionsOutput::policy_size_bytes): <p>Total size of the policy associated with the Signing Profile in bytes.</p>
    ///   - [`permissions(Option<Vec<Permission>>)`](crate::output::ListProfilePermissionsOutput::permissions): <p>List of permissions associated with the Signing Profile.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProfilePermissionsOutput::next_token): <p>String for specifying the next set of paginated results.</p>
    /// - On failure, responds with [`SdkError<ListProfilePermissionsError>`](crate::error::ListProfilePermissionsError)
    pub fn list_profile_permissions(&self) -> fluent_builders::ListProfilePermissions {
        fluent_builders::ListProfilePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSigningJobs`](crate::client::fluent_builders::ListSigningJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSigningJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status(SigningStatus)`](crate::client::fluent_builders::ListSigningJobs::status) / [`set_status(Option<SigningStatus>)`](crate::client::fluent_builders::ListSigningJobs::set_status): <p>A status value with which to filter your results.</p>
    ///   - [`platform_id(impl Into<String>)`](crate::client::fluent_builders::ListSigningJobs::platform_id) / [`set_platform_id(Option<String>)`](crate::client::fluent_builders::ListSigningJobs::set_platform_id): <p>The ID of microcontroller platform that you specified for the distribution of your code image.</p>
    ///   - [`requested_by(impl Into<String>)`](crate::client::fluent_builders::ListSigningJobs::requested_by) / [`set_requested_by(Option<String>)`](crate::client::fluent_builders::ListSigningJobs::set_requested_by): <p>The IAM principal that requested the signing job.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSigningJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSigningJobs::set_max_results): <p>Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional items. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSigningJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSigningJobs::set_next_token): <p>String for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
    ///   - [`is_revoked(bool)`](crate::client::fluent_builders::ListSigningJobs::is_revoked) / [`set_is_revoked(bool)`](crate::client::fluent_builders::ListSigningJobs::set_is_revoked): <p>Filters results to return only signing jobs with revoked signatures.</p>
    ///   - [`signature_expires_before(DateTime)`](crate::client::fluent_builders::ListSigningJobs::signature_expires_before) / [`set_signature_expires_before(Option<DateTime>)`](crate::client::fluent_builders::ListSigningJobs::set_signature_expires_before): <p>Filters results to return only signing jobs with signatures expiring before a specified timestamp.</p>
    ///   - [`signature_expires_after(DateTime)`](crate::client::fluent_builders::ListSigningJobs::signature_expires_after) / [`set_signature_expires_after(Option<DateTime>)`](crate::client::fluent_builders::ListSigningJobs::set_signature_expires_after): <p>Filters results to return only signing jobs with signatures expiring after a specified timestamp.</p>
    ///   - [`job_invoker(impl Into<String>)`](crate::client::fluent_builders::ListSigningJobs::job_invoker) / [`set_job_invoker(Option<String>)`](crate::client::fluent_builders::ListSigningJobs::set_job_invoker): <p>Filters results to return only signing jobs initiated by a specified IAM entity.</p>
    /// - On success, responds with [`ListSigningJobsOutput`](crate::output::ListSigningJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<SigningJob>>)`](crate::output::ListSigningJobsOutput::jobs): <p>A list of your signing jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSigningJobsOutput::next_token): <p>String for specifying the next set of paginated results.</p>
    /// - On failure, responds with [`SdkError<ListSigningJobsError>`](crate::error::ListSigningJobsError)
    pub fn list_signing_jobs(&self) -> fluent_builders::ListSigningJobs {
        fluent_builders::ListSigningJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSigningPlatforms`](crate::client::fluent_builders::ListSigningPlatforms) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSigningPlatforms::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`category(impl Into<String>)`](crate::client::fluent_builders::ListSigningPlatforms::category) / [`set_category(Option<String>)`](crate::client::fluent_builders::ListSigningPlatforms::set_category): <p>The category type of a signing platform.</p>
    ///   - [`partner(impl Into<String>)`](crate::client::fluent_builders::ListSigningPlatforms::partner) / [`set_partner(Option<String>)`](crate::client::fluent_builders::ListSigningPlatforms::set_partner): <p>Any partner entities connected to a signing platform.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::ListSigningPlatforms::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::ListSigningPlatforms::set_target): <p>The validation template that is used by the target signing platform.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSigningPlatforms::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSigningPlatforms::set_max_results): <p>The maximum number of results to be returned by this operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSigningPlatforms::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSigningPlatforms::set_next_token): <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
    /// - On success, responds with [`ListSigningPlatformsOutput`](crate::output::ListSigningPlatformsOutput) with field(s):
    ///   - [`platforms(Option<Vec<SigningPlatform>>)`](crate::output::ListSigningPlatformsOutput::platforms): <p>A list of all platforms that match the request parameters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSigningPlatformsOutput::next_token): <p>Value for specifying the next set of paginated results to return.</p>
    /// - On failure, responds with [`SdkError<ListSigningPlatformsError>`](crate::error::ListSigningPlatformsError)
    pub fn list_signing_platforms(&self) -> fluent_builders::ListSigningPlatforms {
        fluent_builders::ListSigningPlatforms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSigningProfiles`](crate::client::fluent_builders::ListSigningProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSigningProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`include_canceled(bool)`](crate::client::fluent_builders::ListSigningProfiles::include_canceled) / [`set_include_canceled(bool)`](crate::client::fluent_builders::ListSigningProfiles::set_include_canceled): <p>Designates whether to include profiles with the status of <code>CANCELED</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSigningProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSigningProfiles::set_max_results): <p>The maximum number of profiles to be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSigningProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSigningProfiles::set_next_token): <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
    ///   - [`platform_id(impl Into<String>)`](crate::client::fluent_builders::ListSigningProfiles::platform_id) / [`set_platform_id(Option<String>)`](crate::client::fluent_builders::ListSigningProfiles::set_platform_id): <p>Filters results to return only signing jobs initiated for a specified signing platform.</p>
    ///   - [`statuses(Vec<SigningProfileStatus>)`](crate::client::fluent_builders::ListSigningProfiles::statuses) / [`set_statuses(Option<Vec<SigningProfileStatus>>)`](crate::client::fluent_builders::ListSigningProfiles::set_statuses): <p>Filters results to return only signing jobs with statuses in the specified list.</p>
    /// - On success, responds with [`ListSigningProfilesOutput`](crate::output::ListSigningProfilesOutput) with field(s):
    ///   - [`profiles(Option<Vec<SigningProfile>>)`](crate::output::ListSigningProfilesOutput::profiles): <p>A list of profiles that are available in the AWS account. This includes profiles with the status of <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set to <code>true</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSigningProfilesOutput::next_token): <p>Value for specifying the next set of paginated results to return.</p>
    /// - On failure, responds with [`SdkError<ListSigningProfilesError>`](crate::error::ListSigningProfilesError)
    pub fn list_signing_profiles(&self) -> fluent_builders::ListSigningProfiles {
        fluent_builders::ListSigningProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tags associated with the signing profile.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSigningProfile`](crate::client::fluent_builders::PutSigningProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::PutSigningProfile::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::PutSigningProfile::set_profile_name): <p>The name of the signing profile to be created.</p>
    ///   - [`signing_material(SigningMaterial)`](crate::client::fluent_builders::PutSigningProfile::signing_material) / [`set_signing_material(Option<SigningMaterial>)`](crate::client::fluent_builders::PutSigningProfile::set_signing_material): <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.</p>
    ///   - [`signature_validity_period(SignatureValidityPeriod)`](crate::client::fluent_builders::PutSigningProfile::signature_validity_period) / [`set_signature_validity_period(Option<SignatureValidityPeriod>)`](crate::client::fluent_builders::PutSigningProfile::set_signature_validity_period): <p>The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.</p>
    ///   - [`platform_id(impl Into<String>)`](crate::client::fluent_builders::PutSigningProfile::platform_id) / [`set_platform_id(Option<String>)`](crate::client::fluent_builders::PutSigningProfile::set_platform_id): <p>The ID of the signing platform to be created.</p>
    ///   - [`overrides(SigningPlatformOverrides)`](crate::client::fluent_builders::PutSigningProfile::overrides) / [`set_overrides(Option<SigningPlatformOverrides>)`](crate::client::fluent_builders::PutSigningProfile::set_overrides): <p>A subfield of <code>platform</code>. This specifies any different configuration options that you want to apply to the chosen platform (such as a different <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
    ///   - [`signing_parameters(HashMap<String, String>)`](crate::client::fluent_builders::PutSigningProfile::signing_parameters) / [`set_signing_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutSigningProfile::set_signing_parameters): <p>Map of key-value pairs for signing. These can include any information that you want to use during signing.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::PutSigningProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutSigningProfile::set_tags): <p>Tags to be associated with the signing profile that is being created.</p>
    /// - On success, responds with [`PutSigningProfileOutput`](crate::output::PutSigningProfileOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::PutSigningProfileOutput::arn): <p>The Amazon Resource Name (ARN) of the signing profile created.</p>
    ///   - [`profile_version(Option<String>)`](crate::output::PutSigningProfileOutput::profile_version): <p>The version of the signing profile being created.</p>
    ///   - [`profile_version_arn(Option<String>)`](crate::output::PutSigningProfileOutput::profile_version_arn): <p>The signing profile ARN, including the profile version.</p>
    /// - On failure, responds with [`SdkError<PutSigningProfileError>`](crate::error::PutSigningProfileError)
    pub fn put_signing_profile(&self) -> fluent_builders::PutSigningProfile {
        fluent_builders::PutSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveProfilePermission`](crate::client::fluent_builders::RemoveProfilePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::RemoveProfilePermission::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::RemoveProfilePermission::set_profile_name): <p>A human-readable name for the signing profile with permissions to be removed.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::RemoveProfilePermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::RemoveProfilePermission::set_revision_id): <p>An identifier for the current revision of the signing profile permissions.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::RemoveProfilePermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::RemoveProfilePermission::set_statement_id): <p>A unique identifier for the cross-account permissions statement.</p>
    /// - On success, responds with [`RemoveProfilePermissionOutput`](crate::output::RemoveProfilePermissionOutput) with field(s):
    ///   - [`revision_id(Option<String>)`](crate::output::RemoveProfilePermissionOutput::revision_id): <p>An identifier for the current revision of the profile permissions.</p>
    /// - On failure, responds with [`SdkError<RemoveProfilePermissionError>`](crate::error::RemoveProfilePermissionError)
    pub fn remove_profile_permission(&self) -> fluent_builders::RemoveProfilePermission {
        fluent_builders::RemoveProfilePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeSignature`](crate::client::fluent_builders::RevokeSignature) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::RevokeSignature::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::RevokeSignature::set_job_id): <p>ID of the signing job to be revoked.</p>
    ///   - [`job_owner(impl Into<String>)`](crate::client::fluent_builders::RevokeSignature::job_owner) / [`set_job_owner(Option<String>)`](crate::client::fluent_builders::RevokeSignature::set_job_owner): <p>AWS account ID of the job owner.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::RevokeSignature::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::RevokeSignature::set_reason): <p>The reason for revoking the signing job.</p>
    /// - On success, responds with [`RevokeSignatureOutput`](crate::output::RevokeSignatureOutput)

    /// - On failure, responds with [`SdkError<RevokeSignatureError>`](crate::error::RevokeSignatureError)
    pub fn revoke_signature(&self) -> fluent_builders::RevokeSignature {
        fluent_builders::RevokeSignature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeSigningProfile`](crate::client::fluent_builders::RevokeSigningProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::RevokeSigningProfile::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::RevokeSigningProfile::set_profile_name): <p>The name of the signing profile to be revoked.</p>
    ///   - [`profile_version(impl Into<String>)`](crate::client::fluent_builders::RevokeSigningProfile::profile_version) / [`set_profile_version(Option<String>)`](crate::client::fluent_builders::RevokeSigningProfile::set_profile_version): <p>The version of the signing profile to be revoked.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::RevokeSigningProfile::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::RevokeSigningProfile::set_reason): <p>The reason for revoking a signing profile.</p>
    ///   - [`effective_time(DateTime)`](crate::client::fluent_builders::RevokeSigningProfile::effective_time) / [`set_effective_time(Option<DateTime>)`](crate::client::fluent_builders::RevokeSigningProfile::set_effective_time): <p>A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the signing profile after this timestamp are not trusted.</p>
    /// - On success, responds with [`RevokeSigningProfileOutput`](crate::output::RevokeSigningProfileOutput)

    /// - On failure, responds with [`SdkError<RevokeSigningProfileError>`](crate::error::RevokeSigningProfileError)
    pub fn revoke_signing_profile(&self) -> fluent_builders::RevokeSigningProfile {
        fluent_builders::RevokeSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSigningJob`](crate::client::fluent_builders::StartSigningJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(Source)`](crate::client::fluent_builders::StartSigningJob::source) / [`set_source(Option<Source>)`](crate::client::fluent_builders::StartSigningJob::set_source): <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw code.</p>
    ///   - [`destination(Destination)`](crate::client::fluent_builders::StartSigningJob::destination) / [`set_destination(Option<Destination>)`](crate::client::fluent_builders::StartSigningJob::set_destination): <p>The S3 bucket in which to save your signed object. The destination contains the name of your bucket and an optional prefix.</p>
    ///   - [`profile_name(impl Into<String>)`](crate::client::fluent_builders::StartSigningJob::profile_name) / [`set_profile_name(Option<String>)`](crate::client::fluent_builders::StartSigningJob::set_profile_name): <p>The name of the signing profile.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartSigningJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartSigningJob::set_client_request_token): <p>String that identifies the signing request. All calls after the first that use this token return the same response as the first call.</p>
    ///   - [`profile_owner(impl Into<String>)`](crate::client::fluent_builders::StartSigningJob::profile_owner) / [`set_profile_owner(Option<String>)`](crate::client::fluent_builders::StartSigningJob::set_profile_owner): <p>The AWS account ID of the signing profile owner.</p>
    /// - On success, responds with [`StartSigningJobOutput`](crate::output::StartSigningJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartSigningJobOutput::job_id): <p>The ID of your signing job.</p>
    ///   - [`job_owner(Option<String>)`](crate::output::StartSigningJobOutput::job_owner): <p>The AWS account ID of the signing job owner.</p>
    /// - On failure, responds with [`SdkError<StartSigningJobError>`](crate::error::StartSigningJobError)
    pub fn start_signing_job(&self) -> fluent_builders::StartSigningJob {
        fluent_builders::StartSigningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags to be associated with the signing profile.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys to be removed from the signing profile.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddProfilePermission`.
    ///
    /// <p>Adds cross-account permissions to a signing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddProfilePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_profile_permission_input::Builder,
    }
    impl AddProfilePermission {
        /// Creates a new `AddProfilePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddProfilePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddProfilePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The human-readable name of the signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The human-readable name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_version(input.into());
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_version(input);
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSigningProfile`.
    ///
    /// <p>Changes the state of an <code>ACTIVE</code> signing profile to <code>CANCELED</code>. A canceled profile is still viewable with the <code>ListSigningProfiles</code> operation, but it cannot perform new signing jobs, and is deleted two years after cancelation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSigningProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_signing_profile_input::Builder,
    }
    impl CancelSigningProfile {
        /// Creates a new `CancelSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSigningProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSigningJob`.
    ///
    /// <p>Returns information about a specific code signing job. You specify the job by using the <code>jobId</code> value that is returned by the <code>StartSigningJob</code> operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSigningJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_signing_job_input::Builder,
    }
    impl DescribeSigningJob {
        /// Creates a new `DescribeSigningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSigningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSigningJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the signing job on input.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the signing job on input.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSigningPlatform`.
    ///
    /// <p>Returns information on a specific signing platform.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSigningPlatform {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_signing_platform_input::Builder,
    }
    impl GetSigningPlatform {
        /// Creates a new `GetSigningPlatform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSigningPlatformOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSigningPlatformError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(input.into());
            self
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSigningProfile`.
    ///
    /// <p>Returns information on a specific signing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSigningProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_signing_profile_input::Builder,
    }
    impl GetSigningProfile {
        /// Creates a new `GetSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSigningProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The name of the target signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn profile_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_owner(input.into());
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfilePermissions`.
    ///
    /// <p>Lists the cross-account permissions associated with a signing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfilePermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_profile_permissions_input::Builder,
    }
    impl ListProfilePermissions {
        /// Creates a new `ListProfilePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfilePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfilePermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningJobs`.
    ///
    /// <p>Lists all your signing jobs. You can use the <code>maxResults</code> parameter to limit the number of signing jobs that are returned in the response. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSigningJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_signing_jobs_input::Builder,
    }
    impl ListSigningJobs {
        /// Creates a new `ListSigningJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSigningJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSigningJobsPaginator {
            crate::paginator::ListSigningJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>A status value with which to filter your results.</p>
        pub fn status(mut self, input: crate::model::SigningStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>A status value with which to filter your results.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your code image.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(input.into());
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your code image.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn requested_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requested_by(input.into());
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn set_requested_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_requested_by(input);
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional items. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional items. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn is_revoked(mut self, input: bool) -> Self {
            self.inner = self.inner.is_revoked(input);
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn set_is_revoked(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_revoked(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a specified timestamp.</p>
        pub fn signature_expires_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.signature_expires_before(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a specified timestamp.</p>
        pub fn set_signature_expires_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_signature_expires_before(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified timestamp.</p>
        pub fn signature_expires_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.signature_expires_after(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified timestamp.</p>
        pub fn set_signature_expires_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_signature_expires_after(input);
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM entity.</p>
        pub fn job_invoker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_invoker(input.into());
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM entity.</p>
        pub fn set_job_invoker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_invoker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningPlatforms`.
    ///
    /// <p>Lists all signing platforms available in code signing that match the request parameters. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSigningPlatforms {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_signing_platforms_input::Builder,
    }
    impl ListSigningPlatforms {
        /// Creates a new `ListSigningPlatforms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningPlatformsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningPlatformsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSigningPlatformsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSigningPlatformsPaginator {
            crate::paginator::ListSigningPlatformsPaginator::new(self.handle, self.inner)
        }
        /// <p>The category type of a signing platform.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(input.into());
            self
        }
        /// <p>The category type of a signing platform.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn partner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner(input.into());
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn set_partner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner(input);
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningProfiles`.
    ///
    /// <p>Lists all available signing profiles in your AWS account. Returns only profiles with an <code>ACTIVE</code> status unless the <code>includeCanceled</code> request field is set to <code>true</code>. If additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with new values that code signing returns in the <code>nextToken</code> parameter until all of your signing jobs have been returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSigningProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_signing_profiles_input::Builder,
    }
    impl ListSigningProfiles {
        /// Creates a new `ListSigningProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSigningProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSigningProfilesPaginator {
            crate::paginator::ListSigningProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>Designates whether to include profiles with the status of <code>CANCELED</code>.</p>
        pub fn include_canceled(mut self, input: bool) -> Self {
            self.inner = self.inner.include_canceled(input);
            self
        }
        /// <p>Designates whether to include profiles with the status of <code>CANCELED</code>.</p>
        pub fn set_include_canceled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_canceled(input);
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(input.into());
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>Filters results to return only signing jobs with statuses in the specified list.</p>
        pub fn statuses(mut self, input: crate::model::SigningProfileStatus) -> Self {
            self.inner = self.inner.statuses(input);
            self
        }
        /// <p>Filters results to return only signing jobs with statuses in the specified list.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningProfileStatus>>,
        ) -> Self {
            self.inner = self.inner.set_statuses(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags associated with a signing profile resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSigningProfile`.
    ///
    /// <p>Creates a signing profile. A signing profile is a code signing template that can be used to carry out a pre-defined signing job. For more information, see <a href="http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html">http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSigningProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_signing_profile_input::Builder,
    }
    impl PutSigningProfile {
        /// Creates a new `PutSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSigningProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be created.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The name of the signing profile to be created.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.inner = self.inner.signing_material(input);
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing profile.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.inner = self.inner.set_signing_material(input);
            self
        }
        /// <p>The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.</p>
        pub fn signature_validity_period(
            mut self,
            input: crate::model::SignatureValidityPeriod,
        ) -> Self {
            self.inner = self.inner.signature_validity_period(input);
            self
        }
        /// <p>The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months.</p>
        pub fn set_signature_validity_period(
            mut self,
            input: std::option::Option<crate::model::SignatureValidityPeriod>,
        ) -> Self {
            self.inner = self.inner.set_signature_validity_period(input);
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(input.into());
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration options that you want to apply to the chosen platform (such as a different <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn overrides(mut self, input: crate::model::SigningPlatformOverrides) -> Self {
            self.inner = self.inner.overrides(input);
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration options that you want to apply to the chosen platform (such as a different <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::SigningPlatformOverrides>,
        ) -> Self {
            self.inner = self.inner.set_overrides(input);
            self
        }
        /// Adds a key-value pair to `signingParameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>Map of key-value pairs for signing. These can include any information that you want to use during signing.</p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.signing_parameters(k.into(), v.into());
            self
        }
        /// <p>Map of key-value pairs for signing. These can include any information that you want to use during signing.</p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_signing_parameters(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveProfilePermission`.
    ///
    /// <p>Removes cross-account permissions from a signing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveProfilePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_profile_permission_input::Builder,
    }
    impl RemoveProfilePermission {
        /// Creates a new `RemoveProfilePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveProfilePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveProfilePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeSignature`.
    ///
    /// <p>Changes the state of a signing job to REVOKED. This indicates that the signature is no longer valid.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeSignature {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_signature_input::Builder,
    }
    impl RevokeSignature {
        /// Creates a new `RevokeSignature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeSignatureOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeSignatureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the signing job to be revoked.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>ID of the signing job to be revoked.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn job_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_owner(input.into());
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_owner(input);
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeSigningProfile`.
    ///
    /// <p>Changes the state of a signing profile to REVOKED. This indicates that signatures generated using the signing profile after an effective start date are no longer valid.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeSigningProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_signing_profile_input::Builder,
    }
    impl RevokeSigningProfile {
        /// Creates a new `RevokeSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeSigningProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_version(input.into());
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_version(input);
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the signing profile after this timestamp are not trusted.</p>
        pub fn effective_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.effective_time(input);
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the signing profile after this timestamp are not trusted.</p>
        pub fn set_effective_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_effective_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSigningJob`.
    ///
    /// <p>Initiates a signing job to be performed on the code provided. Signing jobs are viewable by the <code>ListSigningJobs</code> operation for two years after they are performed. Note the following requirements: </p>
    /// <ul>
    /// <li> <p> You must create an Amazon S3 source bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html">Create a Bucket</a> in the <i>Amazon S3 Getting Started Guide</i>. </p> </li>
    /// <li> <p>Your S3 source bucket must be version enabled.</p> </li>
    /// <li> <p>You must create an S3 destination bucket. Code signing uses your S3 destination bucket to write your signed code.</p> </li>
    /// <li> <p>You specify the name of the source and destination buckets when calling the <code>StartSigningJob</code> operation.</p> </li>
    /// <li> <p>You must also specify a request token that identifies your request to code signing.</p> </li>
    /// </ul>
    /// <p>You can call the <code>DescribeSigningJob</code> and the <code>ListSigningJobs</code> actions after you call <code>StartSigningJob</code>.</p>
    /// <p>For a Java example that shows how to use this action, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/">http://docs.aws.amazon.com/acm/latest/userguide/</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSigningJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_signing_job_input::Builder,
    }
    impl StartSigningJob {
        /// Creates a new `StartSigningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSigningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSigningJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw code.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw code.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name of your bucket and an optional prefix.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name of your bucket and an optional prefix.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(input.into());
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this token return the same response as the first call.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this token return the same response as the first call.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn profile_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_owner(input.into());
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a signing profile. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. To specify the signing profile, use its Amazon Resource Name (ARN). To specify the tag, use a key-value pair.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a signing profile. To remove the tags, specify a list of tag keys.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
