// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Points to an <code>S3Destination</code> object that contains information about your S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>The <code>S3Destination</code> object.</p>
    pub s3: std::option::Option<crate::model::S3Destination>,
}
impl Destination {
    /// <p>The <code>S3Destination</code> object.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Destination> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The <code>S3Destination</code> object.</p>
        pub fn s3(mut self, input: crate::model::S3Destination) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The <code>S3Destination</code> object.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Destination>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination { s3: self.s3 }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p>The name and prefix of the S3 bucket where code signing saves your signed objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// <p>Name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>An Amazon S3 prefix that you can use to limit responses to those that begin with the specified prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3Destination {
    /// <p>Name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>An Amazon S3 prefix that you can use to limit responses to those that begin with the specified prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>An Amazon S3 prefix that you can use to limit responses to those that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An Amazon S3 prefix that you can use to limit responses to those that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

/// <p>An <code>S3Source</code> object that contains information about the S3 bucket where you saved your unsigned code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>The <code>S3Source</code> object.</p>
    pub s3: std::option::Option<crate::model::S3Source>,
}
impl Source {
    /// <p>The <code>S3Source</code> object.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Source> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Source>,
    }
    impl Builder {
        /// <p>The <code>S3Source</code> object.</p>
        pub fn s3(mut self, input: crate::model::S3Source) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The <code>S3Source</code> object.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Source>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source { s3: self.s3 }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

/// <p>Information about the S3 bucket where you saved your unsigned code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Source {
    /// <p>Name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>Key name of the bucket object that contains your unsigned code.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Version of your source image in your version enabled S3 bucket.</p>
    pub version: std::option::Option<std::string::String>,
}
impl S3Source {
    /// <p>Name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>Key name of the bucket object that contains your unsigned code.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Version of your source image in your version enabled S3 bucket.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for S3Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Source");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("key", &self.key);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`S3Source`](crate::model::S3Source)
pub mod s3_source {
    /// A builder for [`S3Source`](crate::model::S3Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>Key name of the bucket object that contains your unsigned code.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key name of the bucket object that contains your unsigned code.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Version of your source image in your version enabled S3 bucket.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version of your source image in your version enabled S3 bucket.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Source`](crate::model::S3Source)
        pub fn build(self) -> crate::model::S3Source {
            crate::model::S3Source {
                bucket_name: self.bucket_name,
                key: self.key,
                version: self.version,
            }
        }
    }
}
impl S3Source {
    /// Creates a new builder-style object to manufacture [`S3Source`](crate::model::S3Source)
    pub fn builder() -> crate::model::s3_source::Builder {
        crate::model::s3_source::Builder::default()
    }
}

/// <p>Any overrides that are applied to the signing configuration of a code signing platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningPlatformOverrides {
    /// <p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>
    pub signing_configuration: std::option::Option<crate::model::SigningConfigurationOverrides>,
    /// <p>A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.</p>
    pub signing_image_format: std::option::Option<crate::model::ImageFormat>,
}
impl SigningPlatformOverrides {
    /// <p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>
    pub fn signing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SigningConfigurationOverrides> {
        self.signing_configuration.as_ref()
    }
    /// <p>A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.</p>
    pub fn signing_image_format(&self) -> std::option::Option<&crate::model::ImageFormat> {
        self.signing_image_format.as_ref()
    }
}
impl std::fmt::Debug for SigningPlatformOverrides {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningPlatformOverrides");
        formatter.field("signing_configuration", &self.signing_configuration);
        formatter.field("signing_image_format", &self.signing_image_format);
        formatter.finish()
    }
}
/// See [`SigningPlatformOverrides`](crate::model::SigningPlatformOverrides)
pub mod signing_platform_overrides {
    /// A builder for [`SigningPlatformOverrides`](crate::model::SigningPlatformOverrides)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_configuration:
            std::option::Option<crate::model::SigningConfigurationOverrides>,
        pub(crate) signing_image_format: std::option::Option<crate::model::ImageFormat>,
    }
    impl Builder {
        /// <p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>
        pub fn signing_configuration(
            mut self,
            input: crate::model::SigningConfigurationOverrides,
        ) -> Self {
            self.signing_configuration = Some(input);
            self
        }
        /// <p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>
        pub fn set_signing_configuration(
            mut self,
            input: std::option::Option<crate::model::SigningConfigurationOverrides>,
        ) -> Self {
            self.signing_configuration = input;
            self
        }
        /// <p>A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.</p>
        pub fn signing_image_format(mut self, input: crate::model::ImageFormat) -> Self {
            self.signing_image_format = Some(input);
            self
        }
        /// <p>A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.</p>
        pub fn set_signing_image_format(
            mut self,
            input: std::option::Option<crate::model::ImageFormat>,
        ) -> Self {
            self.signing_image_format = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningPlatformOverrides`](crate::model::SigningPlatformOverrides)
        pub fn build(self) -> crate::model::SigningPlatformOverrides {
            crate::model::SigningPlatformOverrides {
                signing_configuration: self.signing_configuration,
                signing_image_format: self.signing_image_format,
            }
        }
    }
}
impl SigningPlatformOverrides {
    /// Creates a new builder-style object to manufacture [`SigningPlatformOverrides`](crate::model::SigningPlatformOverrides)
    pub fn builder() -> crate::model::signing_platform_overrides::Builder {
        crate::model::signing_platform_overrides::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    JsonDetached,
    #[allow(missing_docs)] // documentation missing in model
    JsonEmbedded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => ImageFormat::Json,
            "JSONDetached" => ImageFormat::JsonDetached,
            "JSONEmbedded" => ImageFormat::JsonEmbedded,
            other => ImageFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageFormat::from(s))
    }
}
impl ImageFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageFormat::Json => "JSON",
            ImageFormat::JsonDetached => "JSONDetached",
            ImageFormat::JsonEmbedded => "JSONEmbedded",
            ImageFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "JSONDetached", "JSONEmbedded"]
    }
}
impl AsRef<str> for ImageFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A signing configuration that overrides the default encryption or hash algorithm of a signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningConfigurationOverrides {
    /// <p>A specified override of the default encryption algorithm that is used in a code signing job.</p>
    pub encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithm>,
    /// <p>A specified override of the default hash algorithm that is used in a code signing job.</p>
    pub hash_algorithm: std::option::Option<crate::model::HashAlgorithm>,
}
impl SigningConfigurationOverrides {
    /// <p>A specified override of the default encryption algorithm that is used in a code signing job.</p>
    pub fn encryption_algorithm(&self) -> std::option::Option<&crate::model::EncryptionAlgorithm> {
        self.encryption_algorithm.as_ref()
    }
    /// <p>A specified override of the default hash algorithm that is used in a code signing job.</p>
    pub fn hash_algorithm(&self) -> std::option::Option<&crate::model::HashAlgorithm> {
        self.hash_algorithm.as_ref()
    }
}
impl std::fmt::Debug for SigningConfigurationOverrides {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningConfigurationOverrides");
        formatter.field("encryption_algorithm", &self.encryption_algorithm);
        formatter.field("hash_algorithm", &self.hash_algorithm);
        formatter.finish()
    }
}
/// See [`SigningConfigurationOverrides`](crate::model::SigningConfigurationOverrides)
pub mod signing_configuration_overrides {
    /// A builder for [`SigningConfigurationOverrides`](crate::model::SigningConfigurationOverrides)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_algorithm: std::option::Option<crate::model::EncryptionAlgorithm>,
        pub(crate) hash_algorithm: std::option::Option<crate::model::HashAlgorithm>,
    }
    impl Builder {
        /// <p>A specified override of the default encryption algorithm that is used in a code signing job.</p>
        pub fn encryption_algorithm(mut self, input: crate::model::EncryptionAlgorithm) -> Self {
            self.encryption_algorithm = Some(input);
            self
        }
        /// <p>A specified override of the default encryption algorithm that is used in a code signing job.</p>
        pub fn set_encryption_algorithm(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithm>,
        ) -> Self {
            self.encryption_algorithm = input;
            self
        }
        /// <p>A specified override of the default hash algorithm that is used in a code signing job.</p>
        pub fn hash_algorithm(mut self, input: crate::model::HashAlgorithm) -> Self {
            self.hash_algorithm = Some(input);
            self
        }
        /// <p>A specified override of the default hash algorithm that is used in a code signing job.</p>
        pub fn set_hash_algorithm(
            mut self,
            input: std::option::Option<crate::model::HashAlgorithm>,
        ) -> Self {
            self.hash_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningConfigurationOverrides`](crate::model::SigningConfigurationOverrides)
        pub fn build(self) -> crate::model::SigningConfigurationOverrides {
            crate::model::SigningConfigurationOverrides {
                encryption_algorithm: self.encryption_algorithm,
                hash_algorithm: self.hash_algorithm,
            }
        }
    }
}
impl SigningConfigurationOverrides {
    /// Creates a new builder-style object to manufacture [`SigningConfigurationOverrides`](crate::model::SigningConfigurationOverrides)
    pub fn builder() -> crate::model::signing_configuration_overrides::Builder {
        crate::model::signing_configuration_overrides::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HashAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Sha1,
    #[allow(missing_docs)] // documentation missing in model
    Sha256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HashAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "SHA1" => HashAlgorithm::Sha1,
            "SHA256" => HashAlgorithm::Sha256,
            other => HashAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HashAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HashAlgorithm::from(s))
    }
}
impl HashAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HashAlgorithm::Sha1 => "SHA1",
            HashAlgorithm::Sha256 => "SHA256",
            HashAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHA1", "SHA256"]
    }
}
impl AsRef<str> for HashAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Ecdsa,
    #[allow(missing_docs)] // documentation missing in model
    Rsa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "ECDSA" => EncryptionAlgorithm::Ecdsa,
            "RSA" => EncryptionAlgorithm::Rsa,
            other => EncryptionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionAlgorithm::from(s))
    }
}
impl EncryptionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionAlgorithm::Ecdsa => "ECDSA",
            EncryptionAlgorithm::Rsa => "RSA",
            EncryptionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ECDSA", "RSA"]
    }
}
impl AsRef<str> for EncryptionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The validity period for a signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignatureValidityPeriod {
    /// <p>The numerical value of the time unit for signature validity.</p>
    pub value: i32,
    /// <p>The time unit for signature validity.</p>
    pub r#type: std::option::Option<crate::model::ValidityType>,
}
impl SignatureValidityPeriod {
    /// <p>The numerical value of the time unit for signature validity.</p>
    pub fn value(&self) -> i32 {
        self.value
    }
    /// <p>The time unit for signature validity.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ValidityType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for SignatureValidityPeriod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignatureValidityPeriod");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`SignatureValidityPeriod`](crate::model::SignatureValidityPeriod)
pub mod signature_validity_period {
    /// A builder for [`SignatureValidityPeriod`](crate::model::SignatureValidityPeriod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::ValidityType>,
    }
    impl Builder {
        /// <p>The numerical value of the time unit for signature validity.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The numerical value of the time unit for signature validity.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// <p>The time unit for signature validity.</p>
        pub fn r#type(mut self, input: crate::model::ValidityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The time unit for signature validity.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ValidityType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`SignatureValidityPeriod`](crate::model::SignatureValidityPeriod)
        pub fn build(self) -> crate::model::SignatureValidityPeriod {
            crate::model::SignatureValidityPeriod {
                value: self.value.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl SignatureValidityPeriod {
    /// Creates a new builder-style object to manufacture [`SignatureValidityPeriod`](crate::model::SignatureValidityPeriod)
    pub fn builder() -> crate::model::signature_validity_period::Builder {
        crate::model::signature_validity_period::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidityType {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    #[allow(missing_docs)] // documentation missing in model
    Months,
    #[allow(missing_docs)] // documentation missing in model
    Years,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidityType {
    fn from(s: &str) -> Self {
        match s {
            "DAYS" => ValidityType::Days,
            "MONTHS" => ValidityType::Months,
            "YEARS" => ValidityType::Years,
            other => ValidityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidityType::from(s))
    }
}
impl ValidityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidityType::Days => "DAYS",
            ValidityType::Months => "MONTHS",
            ValidityType::Years => "YEARS",
            ValidityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAYS", "MONTHS", "YEARS"]
    }
}
impl AsRef<str> for ValidityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The ACM certificate that is used to sign your code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningMaterial {
    /// <p>The Amazon Resource Name (ARN) of the certificates that is used to sign your code.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl SigningMaterial {
    /// <p>The Amazon Resource Name (ARN) of the certificates that is used to sign your code.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for SigningMaterial {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningMaterial");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}
/// See [`SigningMaterial`](crate::model::SigningMaterial)
pub mod signing_material {
    /// A builder for [`SigningMaterial`](crate::model::SigningMaterial)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the certificates that is used to sign your code.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificates that is used to sign your code.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningMaterial`](crate::model::SigningMaterial)
        pub fn build(self) -> crate::model::SigningMaterial {
            crate::model::SigningMaterial {
                certificate_arn: self.certificate_arn,
            }
        }
    }
}
impl SigningMaterial {
    /// Creates a new builder-style object to manufacture [`SigningMaterial`](crate::model::SigningMaterial)
    pub fn builder() -> crate::model::signing_material::Builder {
        crate::model::signing_material::Builder::default()
    }
}

/// <p>Contains information about the ACM certificates and code signing configuration parameters that can be used by a given code signing user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningProfile {
    /// <p>The name of the signing profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The version of a signing profile.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The ARN of a signing profile, including the profile version.</p>
    pub profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ACM certificate that is available for use by a signing profile.</p>
    pub signing_material: std::option::Option<crate::model::SigningMaterial>,
    /// <p>The validity period for a signing job created using this signing profile.</p>
    pub signature_validity_period: std::option::Option<crate::model::SignatureValidityPeriod>,
    /// <p>The ID of a platform that is available for use by a signing profile.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>The name of the signing platform.</p>
    pub platform_display_name: std::option::Option<std::string::String>,
    /// <p>The parameters that are available for use by a code signing user.</p>
    pub signing_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of a code signing profile.</p>
    pub status: std::option::Option<crate::model::SigningProfileStatus>,
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A list of tags associated with the signing profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SigningProfile {
    /// <p>The name of the signing profile.</p>
    pub fn profile_name(&self) -> std::option::Option<&str> {
        self.profile_name.as_deref()
    }
    /// <p>The version of a signing profile.</p>
    pub fn profile_version(&self) -> std::option::Option<&str> {
        self.profile_version.as_deref()
    }
    /// <p>The ARN of a signing profile, including the profile version.</p>
    pub fn profile_version_arn(&self) -> std::option::Option<&str> {
        self.profile_version_arn.as_deref()
    }
    /// <p>The ACM certificate that is available for use by a signing profile.</p>
    pub fn signing_material(&self) -> std::option::Option<&crate::model::SigningMaterial> {
        self.signing_material.as_ref()
    }
    /// <p>The validity period for a signing job created using this signing profile.</p>
    pub fn signature_validity_period(
        &self,
    ) -> std::option::Option<&crate::model::SignatureValidityPeriod> {
        self.signature_validity_period.as_ref()
    }
    /// <p>The ID of a platform that is available for use by a signing profile.</p>
    pub fn platform_id(&self) -> std::option::Option<&str> {
        self.platform_id.as_deref()
    }
    /// <p>The name of the signing platform.</p>
    pub fn platform_display_name(&self) -> std::option::Option<&str> {
        self.platform_display_name.as_deref()
    }
    /// <p>The parameters that are available for use by a code signing user.</p>
    pub fn signing_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.signing_parameters.as_ref()
    }
    /// <p>The status of a code signing profile.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SigningProfileStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A list of tags associated with the signing profile.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for SigningProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningProfile");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("profile_version_arn", &self.profile_version_arn);
        formatter.field("signing_material", &self.signing_material);
        formatter.field("signature_validity_period", &self.signature_validity_period);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("platform_display_name", &self.platform_display_name);
        formatter.field("signing_parameters", &self.signing_parameters);
        formatter.field("status", &self.status);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`SigningProfile`](crate::model::SigningProfile)
pub mod signing_profile {
    /// A builder for [`SigningProfile`](crate::model::SigningProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_material: std::option::Option<crate::model::SigningMaterial>,
        pub(crate) signature_validity_period:
            std::option::Option<crate::model::SignatureValidityPeriod>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) platform_display_name: std::option::Option<std::string::String>,
        pub(crate) signing_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::SigningProfileStatus>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The version of a signing profile.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of a signing profile.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The ARN of a signing profile, including the profile version.</p>
        pub fn profile_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a signing profile, including the profile version.</p>
        pub fn set_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version_arn = input;
            self
        }
        /// <p>The ACM certificate that is available for use by a signing profile.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.signing_material = Some(input);
            self
        }
        /// <p>The ACM certificate that is available for use by a signing profile.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.signing_material = input;
            self
        }
        /// <p>The validity period for a signing job created using this signing profile.</p>
        pub fn signature_validity_period(
            mut self,
            input: crate::model::SignatureValidityPeriod,
        ) -> Self {
            self.signature_validity_period = Some(input);
            self
        }
        /// <p>The validity period for a signing job created using this signing profile.</p>
        pub fn set_signature_validity_period(
            mut self,
            input: std::option::Option<crate::model::SignatureValidityPeriod>,
        ) -> Self {
            self.signature_validity_period = input;
            self
        }
        /// <p>The ID of a platform that is available for use by a signing profile.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of a platform that is available for use by a signing profile.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>The name of the signing platform.</p>
        pub fn platform_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_display_name = Some(input.into());
            self
        }
        /// <p>The name of the signing platform.</p>
        pub fn set_platform_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_display_name = input;
            self
        }
        /// Adds a key-value pair to `signing_parameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>The parameters that are available for use by a code signing user.</p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.signing_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.signing_parameters = Some(hash_map);
            self
        }
        /// <p>The parameters that are available for use by a code signing user.</p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.signing_parameters = input;
            self
        }
        /// <p>The status of a code signing profile.</p>
        pub fn status(mut self, input: crate::model::SigningProfileStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a code signing profile.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningProfileStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningProfile`](crate::model::SigningProfile)
        pub fn build(self) -> crate::model::SigningProfile {
            crate::model::SigningProfile {
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                profile_version_arn: self.profile_version_arn,
                signing_material: self.signing_material,
                signature_validity_period: self.signature_validity_period,
                platform_id: self.platform_id,
                platform_display_name: self.platform_display_name,
                signing_parameters: self.signing_parameters,
                status: self.status,
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl SigningProfile {
    /// Creates a new builder-style object to manufacture [`SigningProfile`](crate::model::SigningProfile)
    pub fn builder() -> crate::model::signing_profile::Builder {
        crate::model::signing_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SigningProfileStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SigningProfileStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => SigningProfileStatus::Active,
            "Canceled" => SigningProfileStatus::Canceled,
            "Revoked" => SigningProfileStatus::Revoked,
            other => SigningProfileStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SigningProfileStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SigningProfileStatus::from(s))
    }
}
impl SigningProfileStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningProfileStatus::Active => "Active",
            SigningProfileStatus::Canceled => "Canceled",
            SigningProfileStatus::Revoked => "Revoked",
            SigningProfileStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Canceled", "Revoked"]
    }
}
impl AsRef<str> for SigningProfileStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the signing configurations and parameters that are used to perform a code signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningPlatform {
    /// <p>The ID of a code signing; platform.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>The display name of a code signing platform.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Any partner entities linked to a code signing platform.</p>
    pub partner: std::option::Option<std::string::String>,
    /// <p>The types of targets that can be signed by a code signing platform.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The category of a code signing platform.</p>
    pub category: std::option::Option<crate::model::Category>,
    /// <p>The configuration of a code signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.</p>
    pub signing_configuration: std::option::Option<crate::model::SigningConfiguration>,
    /// <p>The image format of a code signing platform or profile.</p>
    pub signing_image_format: std::option::Option<crate::model::SigningImageFormat>,
    /// <p>The maximum size (in MB) of code that can be signed by a code signing platform.</p>
    pub max_size_in_mb: i32,
    /// <p>Indicates whether revocation is supported for the platform.</p>
    pub revocation_supported: bool,
}
impl SigningPlatform {
    /// <p>The ID of a code signing; platform.</p>
    pub fn platform_id(&self) -> std::option::Option<&str> {
        self.platform_id.as_deref()
    }
    /// <p>The display name of a code signing platform.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Any partner entities linked to a code signing platform.</p>
    pub fn partner(&self) -> std::option::Option<&str> {
        self.partner.as_deref()
    }
    /// <p>The types of targets that can be signed by a code signing platform.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>The category of a code signing platform.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::Category> {
        self.category.as_ref()
    }
    /// <p>The configuration of a code signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.</p>
    pub fn signing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SigningConfiguration> {
        self.signing_configuration.as_ref()
    }
    /// <p>The image format of a code signing platform or profile.</p>
    pub fn signing_image_format(&self) -> std::option::Option<&crate::model::SigningImageFormat> {
        self.signing_image_format.as_ref()
    }
    /// <p>The maximum size (in MB) of code that can be signed by a code signing platform.</p>
    pub fn max_size_in_mb(&self) -> i32 {
        self.max_size_in_mb
    }
    /// <p>Indicates whether revocation is supported for the platform.</p>
    pub fn revocation_supported(&self) -> bool {
        self.revocation_supported
    }
}
impl std::fmt::Debug for SigningPlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningPlatform");
        formatter.field("platform_id", &self.platform_id);
        formatter.field("display_name", &self.display_name);
        formatter.field("partner", &self.partner);
        formatter.field("target", &self.target);
        formatter.field("category", &self.category);
        formatter.field("signing_configuration", &self.signing_configuration);
        formatter.field("signing_image_format", &self.signing_image_format);
        formatter.field("max_size_in_mb", &self.max_size_in_mb);
        formatter.field("revocation_supported", &self.revocation_supported);
        formatter.finish()
    }
}
/// See [`SigningPlatform`](crate::model::SigningPlatform)
pub mod signing_platform {
    /// A builder for [`SigningPlatform`](crate::model::SigningPlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) partner: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::Category>,
        pub(crate) signing_configuration: std::option::Option<crate::model::SigningConfiguration>,
        pub(crate) signing_image_format: std::option::Option<crate::model::SigningImageFormat>,
        pub(crate) max_size_in_mb: std::option::Option<i32>,
        pub(crate) revocation_supported: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of a code signing; platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of a code signing; platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>The display name of a code signing platform.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of a code signing platform.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Any partner entities linked to a code signing platform.</p>
        pub fn partner(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner = Some(input.into());
            self
        }
        /// <p>Any partner entities linked to a code signing platform.</p>
        pub fn set_partner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner = input;
            self
        }
        /// <p>The types of targets that can be signed by a code signing platform.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The types of targets that can be signed by a code signing platform.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The category of a code signing platform.</p>
        pub fn category(mut self, input: crate::model::Category) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of a code signing platform.</p>
        pub fn set_category(mut self, input: std::option::Option<crate::model::Category>) -> Self {
            self.category = input;
            self
        }
        /// <p>The configuration of a code signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.</p>
        pub fn signing_configuration(mut self, input: crate::model::SigningConfiguration) -> Self {
            self.signing_configuration = Some(input);
            self
        }
        /// <p>The configuration of a code signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.</p>
        pub fn set_signing_configuration(
            mut self,
            input: std::option::Option<crate::model::SigningConfiguration>,
        ) -> Self {
            self.signing_configuration = input;
            self
        }
        /// <p>The image format of a code signing platform or profile.</p>
        pub fn signing_image_format(mut self, input: crate::model::SigningImageFormat) -> Self {
            self.signing_image_format = Some(input);
            self
        }
        /// <p>The image format of a code signing platform or profile.</p>
        pub fn set_signing_image_format(
            mut self,
            input: std::option::Option<crate::model::SigningImageFormat>,
        ) -> Self {
            self.signing_image_format = input;
            self
        }
        /// <p>The maximum size (in MB) of code that can be signed by a code signing platform.</p>
        pub fn max_size_in_mb(mut self, input: i32) -> Self {
            self.max_size_in_mb = Some(input);
            self
        }
        /// <p>The maximum size (in MB) of code that can be signed by a code signing platform.</p>
        pub fn set_max_size_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size_in_mb = input;
            self
        }
        /// <p>Indicates whether revocation is supported for the platform.</p>
        pub fn revocation_supported(mut self, input: bool) -> Self {
            self.revocation_supported = Some(input);
            self
        }
        /// <p>Indicates whether revocation is supported for the platform.</p>
        pub fn set_revocation_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.revocation_supported = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningPlatform`](crate::model::SigningPlatform)
        pub fn build(self) -> crate::model::SigningPlatform {
            crate::model::SigningPlatform {
                platform_id: self.platform_id,
                display_name: self.display_name,
                partner: self.partner,
                target: self.target,
                category: self.category,
                signing_configuration: self.signing_configuration,
                signing_image_format: self.signing_image_format,
                max_size_in_mb: self.max_size_in_mb.unwrap_or_default(),
                revocation_supported: self.revocation_supported.unwrap_or_default(),
            }
        }
    }
}
impl SigningPlatform {
    /// Creates a new builder-style object to manufacture [`SigningPlatform`](crate::model::SigningPlatform)
    pub fn builder() -> crate::model::signing_platform::Builder {
        crate::model::signing_platform::Builder::default()
    }
}

/// <p>The image format of a code signing platform or profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningImageFormat {
    /// <p>The supported formats of a code signing image.</p>
    pub supported_formats: std::option::Option<std::vec::Vec<crate::model::ImageFormat>>,
    /// <p>The default format of a code signing image.</p>
    pub default_format: std::option::Option<crate::model::ImageFormat>,
}
impl SigningImageFormat {
    /// <p>The supported formats of a code signing image.</p>
    pub fn supported_formats(&self) -> std::option::Option<&[crate::model::ImageFormat]> {
        self.supported_formats.as_deref()
    }
    /// <p>The default format of a code signing image.</p>
    pub fn default_format(&self) -> std::option::Option<&crate::model::ImageFormat> {
        self.default_format.as_ref()
    }
}
impl std::fmt::Debug for SigningImageFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningImageFormat");
        formatter.field("supported_formats", &self.supported_formats);
        formatter.field("default_format", &self.default_format);
        formatter.finish()
    }
}
/// See [`SigningImageFormat`](crate::model::SigningImageFormat)
pub mod signing_image_format {
    /// A builder for [`SigningImageFormat`](crate::model::SigningImageFormat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) supported_formats: std::option::Option<std::vec::Vec<crate::model::ImageFormat>>,
        pub(crate) default_format: std::option::Option<crate::model::ImageFormat>,
    }
    impl Builder {
        /// Appends an item to `supported_formats`.
        ///
        /// To override the contents of this collection use [`set_supported_formats`](Self::set_supported_formats).
        ///
        /// <p>The supported formats of a code signing image.</p>
        pub fn supported_formats(mut self, input: crate::model::ImageFormat) -> Self {
            let mut v = self.supported_formats.unwrap_or_default();
            v.push(input);
            self.supported_formats = Some(v);
            self
        }
        /// <p>The supported formats of a code signing image.</p>
        pub fn set_supported_formats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageFormat>>,
        ) -> Self {
            self.supported_formats = input;
            self
        }
        /// <p>The default format of a code signing image.</p>
        pub fn default_format(mut self, input: crate::model::ImageFormat) -> Self {
            self.default_format = Some(input);
            self
        }
        /// <p>The default format of a code signing image.</p>
        pub fn set_default_format(
            mut self,
            input: std::option::Option<crate::model::ImageFormat>,
        ) -> Self {
            self.default_format = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningImageFormat`](crate::model::SigningImageFormat)
        pub fn build(self) -> crate::model::SigningImageFormat {
            crate::model::SigningImageFormat {
                supported_formats: self.supported_formats,
                default_format: self.default_format,
            }
        }
    }
}
impl SigningImageFormat {
    /// Creates a new builder-style object to manufacture [`SigningImageFormat`](crate::model::SigningImageFormat)
    pub fn builder() -> crate::model::signing_image_format::Builder {
        crate::model::signing_image_format::Builder::default()
    }
}

/// <p>The configuration of a code signing operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningConfiguration {
    /// <p>The encryption algorithm options that are available for a code signing job.</p>
    pub encryption_algorithm_options: std::option::Option<crate::model::EncryptionAlgorithmOptions>,
    /// <p>The hash algorithm options that are available for a code signing job.</p>
    pub hash_algorithm_options: std::option::Option<crate::model::HashAlgorithmOptions>,
}
impl SigningConfiguration {
    /// <p>The encryption algorithm options that are available for a code signing job.</p>
    pub fn encryption_algorithm_options(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionAlgorithmOptions> {
        self.encryption_algorithm_options.as_ref()
    }
    /// <p>The hash algorithm options that are available for a code signing job.</p>
    pub fn hash_algorithm_options(
        &self,
    ) -> std::option::Option<&crate::model::HashAlgorithmOptions> {
        self.hash_algorithm_options.as_ref()
    }
}
impl std::fmt::Debug for SigningConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningConfiguration");
        formatter.field(
            "encryption_algorithm_options",
            &self.encryption_algorithm_options,
        );
        formatter.field("hash_algorithm_options", &self.hash_algorithm_options);
        formatter.finish()
    }
}
/// See [`SigningConfiguration`](crate::model::SigningConfiguration)
pub mod signing_configuration {
    /// A builder for [`SigningConfiguration`](crate::model::SigningConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_algorithm_options:
            std::option::Option<crate::model::EncryptionAlgorithmOptions>,
        pub(crate) hash_algorithm_options: std::option::Option<crate::model::HashAlgorithmOptions>,
    }
    impl Builder {
        /// <p>The encryption algorithm options that are available for a code signing job.</p>
        pub fn encryption_algorithm_options(
            mut self,
            input: crate::model::EncryptionAlgorithmOptions,
        ) -> Self {
            self.encryption_algorithm_options = Some(input);
            self
        }
        /// <p>The encryption algorithm options that are available for a code signing job.</p>
        pub fn set_encryption_algorithm_options(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithmOptions>,
        ) -> Self {
            self.encryption_algorithm_options = input;
            self
        }
        /// <p>The hash algorithm options that are available for a code signing job.</p>
        pub fn hash_algorithm_options(mut self, input: crate::model::HashAlgorithmOptions) -> Self {
            self.hash_algorithm_options = Some(input);
            self
        }
        /// <p>The hash algorithm options that are available for a code signing job.</p>
        pub fn set_hash_algorithm_options(
            mut self,
            input: std::option::Option<crate::model::HashAlgorithmOptions>,
        ) -> Self {
            self.hash_algorithm_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningConfiguration`](crate::model::SigningConfiguration)
        pub fn build(self) -> crate::model::SigningConfiguration {
            crate::model::SigningConfiguration {
                encryption_algorithm_options: self.encryption_algorithm_options,
                hash_algorithm_options: self.hash_algorithm_options,
            }
        }
    }
}
impl SigningConfiguration {
    /// Creates a new builder-style object to manufacture [`SigningConfiguration`](crate::model::SigningConfiguration)
    pub fn builder() -> crate::model::signing_configuration::Builder {
        crate::model::signing_configuration::Builder::default()
    }
}

/// <p>The hash algorithms that are available to a code signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HashAlgorithmOptions {
    /// <p>The set of accepted hash algorithms allowed in a code signing job.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<crate::model::HashAlgorithm>>,
    /// <p>The default hash algorithm that is used in a code signing job.</p>
    pub default_value: std::option::Option<crate::model::HashAlgorithm>,
}
impl HashAlgorithmOptions {
    /// <p>The set of accepted hash algorithms allowed in a code signing job.</p>
    pub fn allowed_values(&self) -> std::option::Option<&[crate::model::HashAlgorithm]> {
        self.allowed_values.as_deref()
    }
    /// <p>The default hash algorithm that is used in a code signing job.</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::HashAlgorithm> {
        self.default_value.as_ref()
    }
}
impl std::fmt::Debug for HashAlgorithmOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HashAlgorithmOptions");
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`HashAlgorithmOptions`](crate::model::HashAlgorithmOptions)
pub mod hash_algorithm_options {
    /// A builder for [`HashAlgorithmOptions`](crate::model::HashAlgorithmOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_values: std::option::Option<std::vec::Vec<crate::model::HashAlgorithm>>,
        pub(crate) default_value: std::option::Option<crate::model::HashAlgorithm>,
    }
    impl Builder {
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>The set of accepted hash algorithms allowed in a code signing job.</p>
        pub fn allowed_values(mut self, input: crate::model::HashAlgorithm) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input);
            self.allowed_values = Some(v);
            self
        }
        /// <p>The set of accepted hash algorithms allowed in a code signing job.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HashAlgorithm>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>The default hash algorithm that is used in a code signing job.</p>
        pub fn default_value(mut self, input: crate::model::HashAlgorithm) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>The default hash algorithm that is used in a code signing job.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::HashAlgorithm>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`HashAlgorithmOptions`](crate::model::HashAlgorithmOptions)
        pub fn build(self) -> crate::model::HashAlgorithmOptions {
            crate::model::HashAlgorithmOptions {
                allowed_values: self.allowed_values,
                default_value: self.default_value,
            }
        }
    }
}
impl HashAlgorithmOptions {
    /// Creates a new builder-style object to manufacture [`HashAlgorithmOptions`](crate::model::HashAlgorithmOptions)
    pub fn builder() -> crate::model::hash_algorithm_options::Builder {
        crate::model::hash_algorithm_options::Builder::default()
    }
}

/// <p>The encryption algorithm options that are available to a code signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionAlgorithmOptions {
    /// <p>The set of accepted encryption algorithms that are allowed in a code signing job.</p>
    pub allowed_values: std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithm>>,
    /// <p>The default encryption algorithm that is used by a code signing job.</p>
    pub default_value: std::option::Option<crate::model::EncryptionAlgorithm>,
}
impl EncryptionAlgorithmOptions {
    /// <p>The set of accepted encryption algorithms that are allowed in a code signing job.</p>
    pub fn allowed_values(&self) -> std::option::Option<&[crate::model::EncryptionAlgorithm]> {
        self.allowed_values.as_deref()
    }
    /// <p>The default encryption algorithm that is used by a code signing job.</p>
    pub fn default_value(&self) -> std::option::Option<&crate::model::EncryptionAlgorithm> {
        self.default_value.as_ref()
    }
}
impl std::fmt::Debug for EncryptionAlgorithmOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionAlgorithmOptions");
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`EncryptionAlgorithmOptions`](crate::model::EncryptionAlgorithmOptions)
pub mod encryption_algorithm_options {
    /// A builder for [`EncryptionAlgorithmOptions`](crate::model::EncryptionAlgorithmOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_values:
            std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithm>>,
        pub(crate) default_value: std::option::Option<crate::model::EncryptionAlgorithm>,
    }
    impl Builder {
        /// Appends an item to `allowed_values`.
        ///
        /// To override the contents of this collection use [`set_allowed_values`](Self::set_allowed_values).
        ///
        /// <p>The set of accepted encryption algorithms that are allowed in a code signing job.</p>
        pub fn allowed_values(mut self, input: crate::model::EncryptionAlgorithm) -> Self {
            let mut v = self.allowed_values.unwrap_or_default();
            v.push(input);
            self.allowed_values = Some(v);
            self
        }
        /// <p>The set of accepted encryption algorithms that are allowed in a code signing job.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionAlgorithm>>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>The default encryption algorithm that is used by a code signing job.</p>
        pub fn default_value(mut self, input: crate::model::EncryptionAlgorithm) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>The default encryption algorithm that is used by a code signing job.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<crate::model::EncryptionAlgorithm>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionAlgorithmOptions`](crate::model::EncryptionAlgorithmOptions)
        pub fn build(self) -> crate::model::EncryptionAlgorithmOptions {
            crate::model::EncryptionAlgorithmOptions {
                allowed_values: self.allowed_values,
                default_value: self.default_value,
            }
        }
    }
}
impl EncryptionAlgorithmOptions {
    /// Creates a new builder-style object to manufacture [`EncryptionAlgorithmOptions`](crate::model::EncryptionAlgorithmOptions)
    pub fn builder() -> crate::model::encryption_algorithm_options::Builder {
        crate::model::encryption_algorithm_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Category {
    #[allow(missing_docs)] // documentation missing in model
    AwsIoT,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Category {
    fn from(s: &str) -> Self {
        match s {
            "AWSIoT" => Category::AwsIoT,
            other => Category::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Category {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Category::from(s))
    }
}
impl Category {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Category::AwsIoT => "AWSIoT",
            Category::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWSIoT"]
    }
}
impl AsRef<str> for Category {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningJob {
    /// <p>The ID of the signing job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>A <code>Source</code> that contains information about a signing job's code image source.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>A <code>SignedObject</code> structure that contains information about a signing job's signed code image.</p>
    pub signed_object: std::option::Option<crate::model::SignedObject>,
    /// <p>A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.</p>
    pub signing_material: std::option::Option<crate::model::SigningMaterial>,
    /// <p>The date and time that the signing job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the signing job.</p>
    pub status: std::option::Option<crate::model::SigningStatus>,
    /// <p>Indicates whether the signing job is revoked.</p>
    pub is_revoked: bool,
    /// <p>The name of the signing profile that created a signing job.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The version of the signing profile that created a signing job.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a signing platform.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>The name of a signing platform.</p>
    pub platform_display_name: std::option::Option<std::string::String>,
    /// <p>The time when the signature of a signing job expires.</p>
    pub signature_expires_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The AWS account ID of the job owner.</p>
    pub job_owner: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the job invoker.</p>
    pub job_invoker: std::option::Option<std::string::String>,
}
impl SigningJob {
    /// <p>The ID of the signing job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>A <code>Source</code> that contains information about a signing job's code image source.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
    /// <p>A <code>SignedObject</code> structure that contains information about a signing job's signed code image.</p>
    pub fn signed_object(&self) -> std::option::Option<&crate::model::SignedObject> {
        self.signed_object.as_ref()
    }
    /// <p>A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.</p>
    pub fn signing_material(&self) -> std::option::Option<&crate::model::SigningMaterial> {
        self.signing_material.as_ref()
    }
    /// <p>The date and time that the signing job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the signing job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SigningStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates whether the signing job is revoked.</p>
    pub fn is_revoked(&self) -> bool {
        self.is_revoked
    }
    /// <p>The name of the signing profile that created a signing job.</p>
    pub fn profile_name(&self) -> std::option::Option<&str> {
        self.profile_name.as_deref()
    }
    /// <p>The version of the signing profile that created a signing job.</p>
    pub fn profile_version(&self) -> std::option::Option<&str> {
        self.profile_version.as_deref()
    }
    /// <p>The unique identifier for a signing platform.</p>
    pub fn platform_id(&self) -> std::option::Option<&str> {
        self.platform_id.as_deref()
    }
    /// <p>The name of a signing platform.</p>
    pub fn platform_display_name(&self) -> std::option::Option<&str> {
        self.platform_display_name.as_deref()
    }
    /// <p>The time when the signature of a signing job expires.</p>
    pub fn signature_expires_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.signature_expires_at.as_ref()
    }
    /// <p>The AWS account ID of the job owner.</p>
    pub fn job_owner(&self) -> std::option::Option<&str> {
        self.job_owner.as_deref()
    }
    /// <p>The AWS account ID of the job invoker.</p>
    pub fn job_invoker(&self) -> std::option::Option<&str> {
        self.job_invoker.as_deref()
    }
}
impl std::fmt::Debug for SigningJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningJob");
        formatter.field("job_id", &self.job_id);
        formatter.field("source", &self.source);
        formatter.field("signed_object", &self.signed_object);
        formatter.field("signing_material", &self.signing_material);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("is_revoked", &self.is_revoked);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("platform_display_name", &self.platform_display_name);
        formatter.field("signature_expires_at", &self.signature_expires_at);
        formatter.field("job_owner", &self.job_owner);
        formatter.field("job_invoker", &self.job_invoker);
        formatter.finish()
    }
}
/// See [`SigningJob`](crate::model::SigningJob)
pub mod signing_job {
    /// A builder for [`SigningJob`](crate::model::SigningJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) signed_object: std::option::Option<crate::model::SignedObject>,
        pub(crate) signing_material: std::option::Option<crate::model::SigningMaterial>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::SigningStatus>,
        pub(crate) is_revoked: std::option::Option<bool>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) platform_display_name: std::option::Option<std::string::String>,
        pub(crate) signature_expires_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_owner: std::option::Option<std::string::String>,
        pub(crate) job_invoker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the signing job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the signing job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>A <code>Source</code> that contains information about a signing job's code image source.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>A <code>Source</code> that contains information about a signing job's code image source.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>A <code>SignedObject</code> structure that contains information about a signing job's signed code image.</p>
        pub fn signed_object(mut self, input: crate::model::SignedObject) -> Self {
            self.signed_object = Some(input);
            self
        }
        /// <p>A <code>SignedObject</code> structure that contains information about a signing job's signed code image.</p>
        pub fn set_signed_object(
            mut self,
            input: std::option::Option<crate::model::SignedObject>,
        ) -> Self {
            self.signed_object = input;
            self
        }
        /// <p>A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.signing_material = Some(input);
            self
        }
        /// <p>A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.signing_material = input;
            self
        }
        /// <p>The date and time that the signing job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the signing job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the signing job.</p>
        pub fn status(mut self, input: crate::model::SigningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the signing job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether the signing job is revoked.</p>
        pub fn is_revoked(mut self, input: bool) -> Self {
            self.is_revoked = Some(input);
            self
        }
        /// <p>Indicates whether the signing job is revoked.</p>
        pub fn set_is_revoked(mut self, input: std::option::Option<bool>) -> Self {
            self.is_revoked = input;
            self
        }
        /// <p>The name of the signing profile that created a signing job.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile that created a signing job.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The version of the signing profile that created a signing job.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of the signing profile that created a signing job.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The unique identifier for a signing platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>The name of a signing platform.</p>
        pub fn platform_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_display_name = Some(input.into());
            self
        }
        /// <p>The name of a signing platform.</p>
        pub fn set_platform_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_display_name = input;
            self
        }
        /// <p>The time when the signature of a signing job expires.</p>
        pub fn signature_expires_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.signature_expires_at = Some(input);
            self
        }
        /// <p>The time when the signature of a signing job expires.</p>
        pub fn set_signature_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.signature_expires_at = input;
            self
        }
        /// <p>The AWS account ID of the job owner.</p>
        pub fn job_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_owner = input;
            self
        }
        /// <p>The AWS account ID of the job invoker.</p>
        pub fn job_invoker(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_invoker = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the job invoker.</p>
        pub fn set_job_invoker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_invoker = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningJob`](crate::model::SigningJob)
        pub fn build(self) -> crate::model::SigningJob {
            crate::model::SigningJob {
                job_id: self.job_id,
                source: self.source,
                signed_object: self.signed_object,
                signing_material: self.signing_material,
                created_at: self.created_at,
                status: self.status,
                is_revoked: self.is_revoked.unwrap_or_default(),
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                platform_id: self.platform_id,
                platform_display_name: self.platform_display_name,
                signature_expires_at: self.signature_expires_at,
                job_owner: self.job_owner,
                job_invoker: self.job_invoker,
            }
        }
    }
}
impl SigningJob {
    /// Creates a new builder-style object to manufacture [`SigningJob`](crate::model::SigningJob)
    pub fn builder() -> crate::model::signing_job::Builder {
        crate::model::signing_job::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SigningStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SigningStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => SigningStatus::Failed,
            "InProgress" => SigningStatus::InProgress,
            "Succeeded" => SigningStatus::Succeeded,
            other => SigningStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SigningStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SigningStatus::from(s))
    }
}
impl SigningStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SigningStatus::Failed => "Failed",
            SigningStatus::InProgress => "InProgress",
            SigningStatus::Succeeded => "Succeeded",
            SigningStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Succeeded"]
    }
}
impl AsRef<str> for SigningStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Points to an <code>S3SignedObject</code> object that contains information about your signed code image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SignedObject {
    /// <p>The <code>S3SignedObject</code>.</p>
    pub s3: std::option::Option<crate::model::S3SignedObject>,
}
impl SignedObject {
    /// <p>The <code>S3SignedObject</code>.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3SignedObject> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for SignedObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SignedObject");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`SignedObject`](crate::model::SignedObject)
pub mod signed_object {
    /// A builder for [`SignedObject`](crate::model::SignedObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3SignedObject>,
    }
    impl Builder {
        /// <p>The <code>S3SignedObject</code>.</p>
        pub fn s3(mut self, input: crate::model::S3SignedObject) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The <code>S3SignedObject</code>.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3SignedObject>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`SignedObject`](crate::model::SignedObject)
        pub fn build(self) -> crate::model::SignedObject {
            crate::model::SignedObject { s3: self.s3 }
        }
    }
}
impl SignedObject {
    /// Creates a new builder-style object to manufacture [`SignedObject`](crate::model::SignedObject)
    pub fn builder() -> crate::model::signed_object::Builder {
        crate::model::signed_object::Builder::default()
    }
}

/// <p>The S3 bucket name and key where code signing saved your signed code image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SignedObject {
    /// <p>Name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>Key name that uniquely identifies a signed code image in your bucket.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3SignedObject {
    /// <p>Name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>Key name that uniquely identifies a signed code image in your bucket.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3SignedObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SignedObject");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3SignedObject`](crate::model::S3SignedObject)
pub mod s3_signed_object {
    /// A builder for [`S3SignedObject`](crate::model::S3SignedObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>Key name that uniquely identifies a signed code image in your bucket.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key name that uniquely identifies a signed code image in your bucket.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SignedObject`](crate::model::S3SignedObject)
        pub fn build(self) -> crate::model::S3SignedObject {
            crate::model::S3SignedObject {
                bucket_name: self.bucket_name,
                key: self.key,
            }
        }
    }
}
impl S3SignedObject {
    /// Creates a new builder-style object to manufacture [`S3SignedObject`](crate::model::S3SignedObject)
    pub fn builder() -> crate::model::s3_signed_object::Builder {
        crate::model::s3_signed_object::Builder::default()
    }
}

/// <p>A cross-account permission for a signing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>An AWS Signer action permitted as part of cross-account permissions.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The AWS principal that has been granted a cross-account permission.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>A unique identifier for a cross-account permission statement.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>The signing profile version that a permission applies to.</p>
    pub profile_version: std::option::Option<std::string::String>,
}
impl Permission {
    /// <p>An AWS Signer action permitted as part of cross-account permissions.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The AWS principal that has been granted a cross-account permission.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>A unique identifier for a cross-account permission statement.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>The signing profile version that a permission applies to.</p>
    pub fn profile_version(&self) -> std::option::Option<&str> {
        self.profile_version.as_deref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("action", &self.action);
        formatter.field("principal", &self.principal);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("profile_version", &self.profile_version);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>An AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The AWS principal that has been granted a cross-account permission.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS principal that has been granted a cross-account permission.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>A unique identifier for a cross-account permission statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a cross-account permission statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>The signing profile version that a permission applies to.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The signing profile version that a permission applies to.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                action: self.action,
                principal: self.principal,
                statement_id: self.statement_id,
                profile_version: self.profile_version,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

/// <p>Revocation information for a signing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningProfileRevocationRecord {
    /// <p>The time when revocation becomes effective.</p>
    pub revocation_effective_from: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the signing profile was revoked.</p>
    pub revoked_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identity of the revoker.</p>
    pub revoked_by: std::option::Option<std::string::String>,
}
impl SigningProfileRevocationRecord {
    /// <p>The time when revocation becomes effective.</p>
    pub fn revocation_effective_from(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.revocation_effective_from.as_ref()
    }
    /// <p>The time when the signing profile was revoked.</p>
    pub fn revoked_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.revoked_at.as_ref()
    }
    /// <p>The identity of the revoker.</p>
    pub fn revoked_by(&self) -> std::option::Option<&str> {
        self.revoked_by.as_deref()
    }
}
impl std::fmt::Debug for SigningProfileRevocationRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningProfileRevocationRecord");
        formatter.field("revocation_effective_from", &self.revocation_effective_from);
        formatter.field("revoked_at", &self.revoked_at);
        formatter.field("revoked_by", &self.revoked_by);
        formatter.finish()
    }
}
/// See [`SigningProfileRevocationRecord`](crate::model::SigningProfileRevocationRecord)
pub mod signing_profile_revocation_record {
    /// A builder for [`SigningProfileRevocationRecord`](crate::model::SigningProfileRevocationRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revocation_effective_from: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revoked_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revoked_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time when revocation becomes effective.</p>
        pub fn revocation_effective_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.revocation_effective_from = Some(input);
            self
        }
        /// <p>The time when revocation becomes effective.</p>
        pub fn set_revocation_effective_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.revocation_effective_from = input;
            self
        }
        /// <p>The time when the signing profile was revoked.</p>
        pub fn revoked_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.revoked_at = Some(input);
            self
        }
        /// <p>The time when the signing profile was revoked.</p>
        pub fn set_revoked_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.revoked_at = input;
            self
        }
        /// <p>The identity of the revoker.</p>
        pub fn revoked_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.revoked_by = Some(input.into());
            self
        }
        /// <p>The identity of the revoker.</p>
        pub fn set_revoked_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revoked_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningProfileRevocationRecord`](crate::model::SigningProfileRevocationRecord)
        pub fn build(self) -> crate::model::SigningProfileRevocationRecord {
            crate::model::SigningProfileRevocationRecord {
                revocation_effective_from: self.revocation_effective_from,
                revoked_at: self.revoked_at,
                revoked_by: self.revoked_by,
            }
        }
    }
}
impl SigningProfileRevocationRecord {
    /// Creates a new builder-style object to manufacture [`SigningProfileRevocationRecord`](crate::model::SigningProfileRevocationRecord)
    pub fn builder() -> crate::model::signing_profile_revocation_record::Builder {
        crate::model::signing_profile_revocation_record::Builder::default()
    }
}

/// <p>Revocation information for a signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningJobRevocationRecord {
    /// <p>A caller-supplied reason for revocation.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The time of revocation.</p>
    pub revoked_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identity of the revoker.</p>
    pub revoked_by: std::option::Option<std::string::String>,
}
impl SigningJobRevocationRecord {
    /// <p>A caller-supplied reason for revocation.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The time of revocation.</p>
    pub fn revoked_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.revoked_at.as_ref()
    }
    /// <p>The identity of the revoker.</p>
    pub fn revoked_by(&self) -> std::option::Option<&str> {
        self.revoked_by.as_deref()
    }
}
impl std::fmt::Debug for SigningJobRevocationRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningJobRevocationRecord");
        formatter.field("reason", &self.reason);
        formatter.field("revoked_at", &self.revoked_at);
        formatter.field("revoked_by", &self.revoked_by);
        formatter.finish()
    }
}
/// See [`SigningJobRevocationRecord`](crate::model::SigningJobRevocationRecord)
pub mod signing_job_revocation_record {
    /// A builder for [`SigningJobRevocationRecord`](crate::model::SigningJobRevocationRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) revoked_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revoked_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A caller-supplied reason for revocation.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A caller-supplied reason for revocation.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The time of revocation.</p>
        pub fn revoked_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.revoked_at = Some(input);
            self
        }
        /// <p>The time of revocation.</p>
        pub fn set_revoked_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.revoked_at = input;
            self
        }
        /// <p>The identity of the revoker.</p>
        pub fn revoked_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.revoked_by = Some(input.into());
            self
        }
        /// <p>The identity of the revoker.</p>
        pub fn set_revoked_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revoked_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningJobRevocationRecord`](crate::model::SigningJobRevocationRecord)
        pub fn build(self) -> crate::model::SigningJobRevocationRecord {
            crate::model::SigningJobRevocationRecord {
                reason: self.reason,
                revoked_at: self.revoked_at,
                revoked_by: self.revoked_by,
            }
        }
    }
}
impl SigningJobRevocationRecord {
    /// Creates a new builder-style object to manufacture [`SigningJobRevocationRecord`](crate::model::SigningJobRevocationRecord)
    pub fn builder() -> crate::model::signing_job_revocation_record::Builder {
        crate::model::signing_job_revocation_record::Builder::default()
    }
}
