// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSigningJobOutput {
    /// <p>The ID of your signing job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the signing job owner.</p>
    pub job_owner: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartSigningJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSigningJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_owner", &self.job_owner);
        formatter.finish()
    }
}
/// See [`StartSigningJobOutput`](crate::output::StartSigningJobOutput)
pub mod start_signing_job_output {
    /// A builder for [`StartSigningJobOutput`](crate::output::StartSigningJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of your signing job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of your signing job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The AWS account ID of the signing job owner.</p>
        pub fn job_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the signing job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSigningJobOutput`](crate::output::StartSigningJobOutput)
        pub fn build(self) -> crate::output::StartSigningJobOutput {
            crate::output::StartSigningJobOutput {
                job_id: self.job_id,
                job_owner: self.job_owner,
            }
        }
    }
}
impl StartSigningJobOutput {
    /// Creates a new builder-style object to manufacture [`StartSigningJobOutput`](crate::output::StartSigningJobOutput)
    pub fn builder() -> crate::output::start_signing_job_output::Builder {
        crate::output::start_signing_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeSigningProfileOutput {}
impl std::fmt::Debug for RevokeSigningProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeSigningProfileOutput");
        formatter.finish()
    }
}
/// See [`RevokeSigningProfileOutput`](crate::output::RevokeSigningProfileOutput)
pub mod revoke_signing_profile_output {
    /// A builder for [`RevokeSigningProfileOutput`](crate::output::RevokeSigningProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RevokeSigningProfileOutput`](crate::output::RevokeSigningProfileOutput)
        pub fn build(self) -> crate::output::RevokeSigningProfileOutput {
            crate::output::RevokeSigningProfileOutput {}
        }
    }
}
impl RevokeSigningProfileOutput {
    /// Creates a new builder-style object to manufacture [`RevokeSigningProfileOutput`](crate::output::RevokeSigningProfileOutput)
    pub fn builder() -> crate::output::revoke_signing_profile_output::Builder {
        crate::output::revoke_signing_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeSignatureOutput {}
impl std::fmt::Debug for RevokeSignatureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeSignatureOutput");
        formatter.finish()
    }
}
/// See [`RevokeSignatureOutput`](crate::output::RevokeSignatureOutput)
pub mod revoke_signature_output {
    /// A builder for [`RevokeSignatureOutput`](crate::output::RevokeSignatureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RevokeSignatureOutput`](crate::output::RevokeSignatureOutput)
        pub fn build(self) -> crate::output::RevokeSignatureOutput {
            crate::output::RevokeSignatureOutput {}
        }
    }
}
impl RevokeSignatureOutput {
    /// Creates a new builder-style object to manufacture [`RevokeSignatureOutput`](crate::output::RevokeSignatureOutput)
    pub fn builder() -> crate::output::revoke_signature_output::Builder {
        crate::output::revoke_signature_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveProfilePermissionOutput {
    /// <p>An identifier for the current revision of the profile permissions.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveProfilePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveProfilePermissionOutput");
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`RemoveProfilePermissionOutput`](crate::output::RemoveProfilePermissionOutput)
pub mod remove_profile_permission_output {
    /// A builder for [`RemoveProfilePermissionOutput`](crate::output::RemoveProfilePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the current revision of the profile permissions.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>An identifier for the current revision of the profile permissions.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveProfilePermissionOutput`](crate::output::RemoveProfilePermissionOutput)
        pub fn build(self) -> crate::output::RemoveProfilePermissionOutput {
            crate::output::RemoveProfilePermissionOutput {
                revision_id: self.revision_id,
            }
        }
    }
}
impl RemoveProfilePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveProfilePermissionOutput`](crate::output::RemoveProfilePermissionOutput)
    pub fn builder() -> crate::output::remove_profile_permission_output::Builder {
        crate::output::remove_profile_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSigningProfileOutput {
    /// <p>The Amazon Resource Name (ARN) of the signing profile created.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the signing profile being created.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The signing profile ARN, including the profile version.</p>
    pub profile_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutSigningProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSigningProfileOutput");
        formatter.field("arn", &self.arn);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("profile_version_arn", &self.profile_version_arn);
        formatter.finish()
    }
}
/// See [`PutSigningProfileOutput`](crate::output::PutSigningProfileOutput)
pub mod put_signing_profile_output {
    /// A builder for [`PutSigningProfileOutput`](crate::output::PutSigningProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) profile_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the signing profile created.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the signing profile created.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the signing profile being created.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of the signing profile being created.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The signing profile ARN, including the profile version.</p>
        pub fn profile_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version_arn = Some(input.into());
            self
        }
        /// <p>The signing profile ARN, including the profile version.</p>
        pub fn set_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSigningProfileOutput`](crate::output::PutSigningProfileOutput)
        pub fn build(self) -> crate::output::PutSigningProfileOutput {
            crate::output::PutSigningProfileOutput {
                arn: self.arn,
                profile_version: self.profile_version,
                profile_version_arn: self.profile_version_arn,
            }
        }
    }
}
impl PutSigningProfileOutput {
    /// Creates a new builder-style object to manufacture [`PutSigningProfileOutput`](crate::output::PutSigningProfileOutput)
    pub fn builder() -> crate::output::put_signing_profile_output::Builder {
        crate::output::put_signing_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags associated with the signing profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningProfilesOutput {
    /// <p>A list of profiles that are available in the AWS account. This includes profiles with
    /// the status of <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set
    /// to <code>true</code>.</p>
    pub profiles: std::option::Option<std::vec::Vec<crate::model::SigningProfile>>,
    /// <p>Value for specifying the next set of paginated results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSigningProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningProfilesOutput");
        formatter.field("profiles", &self.profiles);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSigningProfilesOutput`](crate::output::ListSigningProfilesOutput)
pub mod list_signing_profiles_output {
    /// A builder for [`ListSigningProfilesOutput`](crate::output::ListSigningProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profiles: std::option::Option<std::vec::Vec<crate::model::SigningProfile>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `profiles`.
        ///
        /// To override the contents of this collection use [`set_profiles`](Self::set_profiles).
        ///
        /// <p>A list of profiles that are available in the AWS account. This includes profiles with
        /// the status of <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn profiles(mut self, input: impl Into<crate::model::SigningProfile>) -> Self {
            let mut v = self.profiles.unwrap_or_default();
            v.push(input.into());
            self.profiles = Some(v);
            self
        }
        /// <p>A list of profiles that are available in the AWS account. This includes profiles with
        /// the status of <code>CANCELED</code> if the <code>includeCanceled</code> parameter is set
        /// to <code>true</code>.</p>
        pub fn set_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningProfile>>,
        ) -> Self {
            self.profiles = input;
            self
        }
        /// <p>Value for specifying the next set of paginated results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningProfilesOutput`](crate::output::ListSigningProfilesOutput)
        pub fn build(self) -> crate::output::ListSigningProfilesOutput {
            crate::output::ListSigningProfilesOutput {
                profiles: self.profiles,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSigningProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListSigningProfilesOutput`](crate::output::ListSigningProfilesOutput)
    pub fn builder() -> crate::output::list_signing_profiles_output::Builder {
        crate::output::list_signing_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningPlatformsOutput {
    /// <p>A list of all platforms that match the request parameters.</p>
    pub platforms: std::option::Option<std::vec::Vec<crate::model::SigningPlatform>>,
    /// <p>Value for specifying the next set of paginated results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSigningPlatformsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningPlatformsOutput");
        formatter.field("platforms", &self.platforms);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSigningPlatformsOutput`](crate::output::ListSigningPlatformsOutput)
pub mod list_signing_platforms_output {
    /// A builder for [`ListSigningPlatformsOutput`](crate::output::ListSigningPlatformsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platforms: std::option::Option<std::vec::Vec<crate::model::SigningPlatform>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>A list of all platforms that match the request parameters.</p>
        pub fn platforms(mut self, input: impl Into<crate::model::SigningPlatform>) -> Self {
            let mut v = self.platforms.unwrap_or_default();
            v.push(input.into());
            self.platforms = Some(v);
            self
        }
        /// <p>A list of all platforms that match the request parameters.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningPlatform>>,
        ) -> Self {
            self.platforms = input;
            self
        }
        /// <p>Value for specifying the next set of paginated results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningPlatformsOutput`](crate::output::ListSigningPlatformsOutput)
        pub fn build(self) -> crate::output::ListSigningPlatformsOutput {
            crate::output::ListSigningPlatformsOutput {
                platforms: self.platforms,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSigningPlatformsOutput {
    /// Creates a new builder-style object to manufacture [`ListSigningPlatformsOutput`](crate::output::ListSigningPlatformsOutput)
    pub fn builder() -> crate::output::list_signing_platforms_output::Builder {
        crate::output::list_signing_platforms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningJobsOutput {
    /// <p>A list of your signing jobs.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::SigningJob>>,
    /// <p>String for specifying the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSigningJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSigningJobsOutput`](crate::output::ListSigningJobsOutput)
pub mod list_signing_jobs_output {
    /// A builder for [`ListSigningJobsOutput`](crate::output::ListSigningJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::SigningJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of your signing jobs.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::SigningJob>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of your signing jobs.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningJob>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningJobsOutput`](crate::output::ListSigningJobsOutput)
        pub fn build(self) -> crate::output::ListSigningJobsOutput {
            crate::output::ListSigningJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSigningJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListSigningJobsOutput`](crate::output::ListSigningJobsOutput)
    pub fn builder() -> crate::output::list_signing_jobs_output::Builder {
        crate::output::list_signing_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfilePermissionsOutput {
    /// <p>The identifier for the current revision of profile permissions.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>Total size of the policy associated with the Signing Profile in bytes.</p>
    pub policy_size_bytes: i32,
    /// <p>List of permissions associated with the Signing Profile.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>String for specifying the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProfilePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfilePermissionsOutput");
        formatter.field("revision_id", &self.revision_id);
        formatter.field("policy_size_bytes", &self.policy_size_bytes);
        formatter.field("permissions", &self.permissions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfilePermissionsOutput`](crate::output::ListProfilePermissionsOutput)
pub mod list_profile_permissions_output {
    /// A builder for [`ListProfilePermissionsOutput`](crate::output::ListProfilePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) policy_size_bytes: std::option::Option<i32>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the current revision of profile permissions.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The identifier for the current revision of profile permissions.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>Total size of the policy associated with the Signing Profile in bytes.</p>
        pub fn policy_size_bytes(mut self, input: i32) -> Self {
            self.policy_size_bytes = Some(input);
            self
        }
        /// <p>Total size of the policy associated with the Signing Profile in bytes.</p>
        pub fn set_policy_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.policy_size_bytes = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>List of permissions associated with the Signing Profile.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>List of permissions associated with the Signing Profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfilePermissionsOutput`](crate::output::ListProfilePermissionsOutput)
        pub fn build(self) -> crate::output::ListProfilePermissionsOutput {
            crate::output::ListProfilePermissionsOutput {
                revision_id: self.revision_id,
                policy_size_bytes: self.policy_size_bytes.unwrap_or_default(),
                permissions: self.permissions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfilePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`ListProfilePermissionsOutput`](crate::output::ListProfilePermissionsOutput)
    pub fn builder() -> crate::output::list_profile_permissions_output::Builder {
        crate::output::list_profile_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSigningProfileOutput {
    /// <p>The name of the target signing profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The current version of the signing profile.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The signing profile ARN, including the profile version.</p>
    pub profile_version_arn: std::option::Option<std::string::String>,
    /// <p>Revocation information for a signing profile.</p>
    pub revocation_record: std::option::Option<crate::model::SigningProfileRevocationRecord>,
    /// <p>The ARN of the certificate that the target profile uses for signing operations.</p>
    pub signing_material: std::option::Option<crate::model::SigningMaterial>,
    /// <p>The ID of the platform that is used by the target signing profile.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>A human-readable name for the signing platform associated with the signing
    /// profile.</p>
    pub platform_display_name: std::option::Option<std::string::String>,
    /// <p>The validity period for a signing job.</p>
    pub signature_validity_period: std::option::Option<crate::model::SignatureValidityPeriod>,
    /// <p>A list of overrides applied by the target signing profile for signing
    /// operations.</p>
    pub overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
    /// <p>A map of key-value pairs for signing operations that is attached to the target signing
    /// profile.</p>
    pub signing_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the target signing profile.</p>
    pub status: std::option::Option<crate::model::SigningProfileStatus>,
    /// <p>Reason for the status of the target signing profile.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A list of tags associated with the signing profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetSigningProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSigningProfileOutput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("profile_version_arn", &self.profile_version_arn);
        formatter.field("revocation_record", &self.revocation_record);
        formatter.field("signing_material", &self.signing_material);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("platform_display_name", &self.platform_display_name);
        formatter.field("signature_validity_period", &self.signature_validity_period);
        formatter.field("overrides", &self.overrides);
        formatter.field("signing_parameters", &self.signing_parameters);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetSigningProfileOutput`](crate::output::GetSigningProfileOutput)
pub mod get_signing_profile_output {
    /// A builder for [`GetSigningProfileOutput`](crate::output::GetSigningProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) revocation_record:
            std::option::Option<crate::model::SigningProfileRevocationRecord>,
        pub(crate) signing_material: std::option::Option<crate::model::SigningMaterial>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) platform_display_name: std::option::Option<std::string::String>,
        pub(crate) signature_validity_period:
            std::option::Option<crate::model::SignatureValidityPeriod>,
        pub(crate) overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
        pub(crate) signing_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::SigningProfileStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the target signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the target signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The current version of the signing profile.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The current version of the signing profile.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The signing profile ARN, including the profile version.</p>
        pub fn profile_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version_arn = Some(input.into());
            self
        }
        /// <p>The signing profile ARN, including the profile version.</p>
        pub fn set_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version_arn = input;
            self
        }
        /// <p>Revocation information for a signing profile.</p>
        pub fn revocation_record(
            mut self,
            input: crate::model::SigningProfileRevocationRecord,
        ) -> Self {
            self.revocation_record = Some(input);
            self
        }
        /// <p>Revocation information for a signing profile.</p>
        pub fn set_revocation_record(
            mut self,
            input: std::option::Option<crate::model::SigningProfileRevocationRecord>,
        ) -> Self {
            self.revocation_record = input;
            self
        }
        /// <p>The ARN of the certificate that the target profile uses for signing operations.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.signing_material = Some(input);
            self
        }
        /// <p>The ARN of the certificate that the target profile uses for signing operations.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.signing_material = input;
            self
        }
        /// <p>The ID of the platform that is used by the target signing profile.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of the platform that is used by the target signing profile.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>A human-readable name for the signing platform associated with the signing
        /// profile.</p>
        pub fn platform_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_display_name = Some(input.into());
            self
        }
        /// <p>A human-readable name for the signing platform associated with the signing
        /// profile.</p>
        pub fn set_platform_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_display_name = input;
            self
        }
        /// <p>The validity period for a signing job.</p>
        pub fn signature_validity_period(
            mut self,
            input: crate::model::SignatureValidityPeriod,
        ) -> Self {
            self.signature_validity_period = Some(input);
            self
        }
        /// <p>The validity period for a signing job.</p>
        pub fn set_signature_validity_period(
            mut self,
            input: std::option::Option<crate::model::SignatureValidityPeriod>,
        ) -> Self {
            self.signature_validity_period = input;
            self
        }
        /// <p>A list of overrides applied by the target signing profile for signing
        /// operations.</p>
        pub fn overrides(mut self, input: crate::model::SigningPlatformOverrides) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>A list of overrides applied by the target signing profile for signing
        /// operations.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::SigningPlatformOverrides>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `signing_parameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>A map of key-value pairs for signing operations that is attached to the target signing
        /// profile.</p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.signing_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.signing_parameters = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs for signing operations that is attached to the target signing
        /// profile.</p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.signing_parameters = input;
            self
        }
        /// <p>The status of the target signing profile.</p>
        pub fn status(mut self, input: crate::model::SigningProfileStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the target signing profile.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningProfileStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Reason for the status of the target signing profile.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Reason for the status of the target signing profile.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningProfileOutput`](crate::output::GetSigningProfileOutput)
        pub fn build(self) -> crate::output::GetSigningProfileOutput {
            crate::output::GetSigningProfileOutput {
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                profile_version_arn: self.profile_version_arn,
                revocation_record: self.revocation_record,
                signing_material: self.signing_material,
                platform_id: self.platform_id,
                platform_display_name: self.platform_display_name,
                signature_validity_period: self.signature_validity_period,
                overrides: self.overrides,
                signing_parameters: self.signing_parameters,
                status: self.status,
                status_reason: self.status_reason,
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl GetSigningProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetSigningProfileOutput`](crate::output::GetSigningProfileOutput)
    pub fn builder() -> crate::output::get_signing_profile_output::Builder {
        crate::output::get_signing_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSigningPlatformOutput {
    /// <p>The ID of the target signing platform.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>The display name of the target signing platform.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A list of partner entities that use the target signing platform.</p>
    pub partner: std::option::Option<std::string::String>,
    /// <p>The validation template that is used by the target signing platform.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The category type of the target signing platform.</p>
    pub category: std::option::Option<crate::model::Category>,
    /// <p>A list of configurations applied to the target platform at signing.</p>
    pub signing_configuration: std::option::Option<crate::model::SigningConfiguration>,
    /// <p>The format of the target platform's signing image.</p>
    pub signing_image_format: std::option::Option<crate::model::SigningImageFormat>,
    /// <p>The maximum size (in MB) of the payload that can be signed by the target
    /// platform.</p>
    pub max_size_in_mb: i32,
    /// <p>A flag indicating whether signatures generated for the signing platform can be
    /// revoked.</p>
    pub revocation_supported: bool,
}
impl std::fmt::Debug for GetSigningPlatformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSigningPlatformOutput");
        formatter.field("platform_id", &self.platform_id);
        formatter.field("display_name", &self.display_name);
        formatter.field("partner", &self.partner);
        formatter.field("target", &self.target);
        formatter.field("category", &self.category);
        formatter.field("signing_configuration", &self.signing_configuration);
        formatter.field("signing_image_format", &self.signing_image_format);
        formatter.field("max_size_in_mb", &self.max_size_in_mb);
        formatter.field("revocation_supported", &self.revocation_supported);
        formatter.finish()
    }
}
/// See [`GetSigningPlatformOutput`](crate::output::GetSigningPlatformOutput)
pub mod get_signing_platform_output {
    /// A builder for [`GetSigningPlatformOutput`](crate::output::GetSigningPlatformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) partner: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::Category>,
        pub(crate) signing_configuration: std::option::Option<crate::model::SigningConfiguration>,
        pub(crate) signing_image_format: std::option::Option<crate::model::SigningImageFormat>,
        pub(crate) max_size_in_mb: std::option::Option<i32>,
        pub(crate) revocation_supported: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the target signing platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>The display name of the target signing platform.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the target signing platform.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A list of partner entities that use the target signing platform.</p>
        pub fn partner(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner = Some(input.into());
            self
        }
        /// <p>A list of partner entities that use the target signing platform.</p>
        pub fn set_partner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner = input;
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The category type of the target signing platform.</p>
        pub fn category(mut self, input: crate::model::Category) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category type of the target signing platform.</p>
        pub fn set_category(mut self, input: std::option::Option<crate::model::Category>) -> Self {
            self.category = input;
            self
        }
        /// <p>A list of configurations applied to the target platform at signing.</p>
        pub fn signing_configuration(mut self, input: crate::model::SigningConfiguration) -> Self {
            self.signing_configuration = Some(input);
            self
        }
        /// <p>A list of configurations applied to the target platform at signing.</p>
        pub fn set_signing_configuration(
            mut self,
            input: std::option::Option<crate::model::SigningConfiguration>,
        ) -> Self {
            self.signing_configuration = input;
            self
        }
        /// <p>The format of the target platform's signing image.</p>
        pub fn signing_image_format(mut self, input: crate::model::SigningImageFormat) -> Self {
            self.signing_image_format = Some(input);
            self
        }
        /// <p>The format of the target platform's signing image.</p>
        pub fn set_signing_image_format(
            mut self,
            input: std::option::Option<crate::model::SigningImageFormat>,
        ) -> Self {
            self.signing_image_format = input;
            self
        }
        /// <p>The maximum size (in MB) of the payload that can be signed by the target
        /// platform.</p>
        pub fn max_size_in_mb(mut self, input: i32) -> Self {
            self.max_size_in_mb = Some(input);
            self
        }
        /// <p>The maximum size (in MB) of the payload that can be signed by the target
        /// platform.</p>
        pub fn set_max_size_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size_in_mb = input;
            self
        }
        /// <p>A flag indicating whether signatures generated for the signing platform can be
        /// revoked.</p>
        pub fn revocation_supported(mut self, input: bool) -> Self {
            self.revocation_supported = Some(input);
            self
        }
        /// <p>A flag indicating whether signatures generated for the signing platform can be
        /// revoked.</p>
        pub fn set_revocation_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.revocation_supported = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningPlatformOutput`](crate::output::GetSigningPlatformOutput)
        pub fn build(self) -> crate::output::GetSigningPlatformOutput {
            crate::output::GetSigningPlatformOutput {
                platform_id: self.platform_id,
                display_name: self.display_name,
                partner: self.partner,
                target: self.target,
                category: self.category,
                signing_configuration: self.signing_configuration,
                signing_image_format: self.signing_image_format,
                max_size_in_mb: self.max_size_in_mb.unwrap_or_default(),
                revocation_supported: self.revocation_supported.unwrap_or_default(),
            }
        }
    }
}
impl GetSigningPlatformOutput {
    /// Creates a new builder-style object to manufacture [`GetSigningPlatformOutput`](crate::output::GetSigningPlatformOutput)
    pub fn builder() -> crate::output::get_signing_platform_output::Builder {
        crate::output::get_signing_platform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSigningJobOutput {
    /// <p>The ID of the signing job on output.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the name of your S3 bucket or your raw code.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>The Amazon Resource Name (ARN) of your code signing certificate.</p>
    pub signing_material: std::option::Option<crate::model::SigningMaterial>,
    /// <p>The microcontroller platform to which your signed code image will be
    /// distributed.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>A human-readable name for the signing platform associated with the signing job.</p>
    pub platform_display_name: std::option::Option<std::string::String>,
    /// <p>The name of the profile that initiated the signing operation.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The version of the signing profile used to initiate the signing job.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>A list of any overrides that were applied to the signing operation.</p>
    pub overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
    /// <p>Map of user-assigned key-value pairs used during signing. These values contain any
    /// information that you specified for use in your signing job. </p>
    pub signing_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Date and time that the signing job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Date and time that the signing job was completed.</p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Thr expiration timestamp for the signature generated by the signing job.</p>
    pub signature_expires_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The IAM principal that requested the signing job.</p>
    pub requested_by: std::option::Option<std::string::String>,
    /// <p>Status of the signing job.</p>
    pub status: std::option::Option<crate::model::SigningStatus>,
    /// <p>String value that contains the status reason.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>A revocation record if the signature generated by the signing job has been revoked.
    /// Contains a timestamp and the ID of the IAM entity that revoked the signature.</p>
    pub revocation_record: std::option::Option<crate::model::SigningJobRevocationRecord>,
    /// <p>Name of the S3 bucket where the signed code image is saved by code signing.</p>
    pub signed_object: std::option::Option<crate::model::SignedObject>,
    /// <p>The AWS account ID of the job owner.</p>
    pub job_owner: std::option::Option<std::string::String>,
    /// <p>The IAM entity that initiated the signing job.</p>
    pub job_invoker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSigningJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSigningJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("source", &self.source);
        formatter.field("signing_material", &self.signing_material);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("platform_display_name", &self.platform_display_name);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("overrides", &self.overrides);
        formatter.field("signing_parameters", &self.signing_parameters);
        formatter.field("created_at", &self.created_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.field("signature_expires_at", &self.signature_expires_at);
        formatter.field("requested_by", &self.requested_by);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("revocation_record", &self.revocation_record);
        formatter.field("signed_object", &self.signed_object);
        formatter.field("job_owner", &self.job_owner);
        formatter.field("job_invoker", &self.job_invoker);
        formatter.finish()
    }
}
/// See [`DescribeSigningJobOutput`](crate::output::DescribeSigningJobOutput)
pub mod describe_signing_job_output {
    /// A builder for [`DescribeSigningJobOutput`](crate::output::DescribeSigningJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) signing_material: std::option::Option<crate::model::SigningMaterial>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) platform_display_name: std::option::Option<std::string::String>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
        pub(crate) signing_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) signature_expires_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) requested_by: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SigningStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) revocation_record: std::option::Option<crate::model::SigningJobRevocationRecord>,
        pub(crate) signed_object: std::option::Option<crate::model::SignedObject>,
        pub(crate) job_owner: std::option::Option<std::string::String>,
        pub(crate) job_invoker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the signing job on output.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the signing job on output.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The object that contains the name of your S3 bucket or your raw code.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The object that contains the name of your S3 bucket or your raw code.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your code signing certificate.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.signing_material = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your code signing certificate.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.signing_material = input;
            self
        }
        /// <p>The microcontroller platform to which your signed code image will be
        /// distributed.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The microcontroller platform to which your signed code image will be
        /// distributed.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>A human-readable name for the signing platform associated with the signing job.</p>
        pub fn platform_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_display_name = Some(input.into());
            self
        }
        /// <p>A human-readable name for the signing platform associated with the signing job.</p>
        pub fn set_platform_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_display_name = input;
            self
        }
        /// <p>The name of the profile that initiated the signing operation.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the profile that initiated the signing operation.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The version of the signing profile used to initiate the signing job.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of the signing profile used to initiate the signing job.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>A list of any overrides that were applied to the signing operation.</p>
        pub fn overrides(mut self, input: crate::model::SigningPlatformOverrides) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>A list of any overrides that were applied to the signing operation.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::SigningPlatformOverrides>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `signing_parameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>Map of user-assigned key-value pairs used during signing. These values contain any
        /// information that you specified for use in your signing job. </p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.signing_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.signing_parameters = Some(hash_map);
            self
        }
        /// <p>Map of user-assigned key-value pairs used during signing. These values contain any
        /// information that you specified for use in your signing job. </p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.signing_parameters = input;
            self
        }
        /// <p>Date and time that the signing job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>Date and time that the signing job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Date and time that the signing job was completed.</p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>Date and time that the signing job was completed.</p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// <p>Thr expiration timestamp for the signature generated by the signing job.</p>
        pub fn signature_expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.signature_expires_at = Some(input);
            self
        }
        /// <p>Thr expiration timestamp for the signature generated by the signing job.</p>
        pub fn set_signature_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.signature_expires_at = input;
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn requested_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.requested_by = Some(input.into());
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn set_requested_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.requested_by = input;
            self
        }
        /// <p>Status of the signing job.</p>
        pub fn status(mut self, input: crate::model::SigningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the signing job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>String value that contains the status reason.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>String value that contains the status reason.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>A revocation record if the signature generated by the signing job has been revoked.
        /// Contains a timestamp and the ID of the IAM entity that revoked the signature.</p>
        pub fn revocation_record(
            mut self,
            input: crate::model::SigningJobRevocationRecord,
        ) -> Self {
            self.revocation_record = Some(input);
            self
        }
        /// <p>A revocation record if the signature generated by the signing job has been revoked.
        /// Contains a timestamp and the ID of the IAM entity that revoked the signature.</p>
        pub fn set_revocation_record(
            mut self,
            input: std::option::Option<crate::model::SigningJobRevocationRecord>,
        ) -> Self {
            self.revocation_record = input;
            self
        }
        /// <p>Name of the S3 bucket where the signed code image is saved by code signing.</p>
        pub fn signed_object(mut self, input: crate::model::SignedObject) -> Self {
            self.signed_object = Some(input);
            self
        }
        /// <p>Name of the S3 bucket where the signed code image is saved by code signing.</p>
        pub fn set_signed_object(
            mut self,
            input: std::option::Option<crate::model::SignedObject>,
        ) -> Self {
            self.signed_object = input;
            self
        }
        /// <p>The AWS account ID of the job owner.</p>
        pub fn job_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_owner = input;
            self
        }
        /// <p>The IAM entity that initiated the signing job.</p>
        pub fn job_invoker(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_invoker = Some(input.into());
            self
        }
        /// <p>The IAM entity that initiated the signing job.</p>
        pub fn set_job_invoker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_invoker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSigningJobOutput`](crate::output::DescribeSigningJobOutput)
        pub fn build(self) -> crate::output::DescribeSigningJobOutput {
            crate::output::DescribeSigningJobOutput {
                job_id: self.job_id,
                source: self.source,
                signing_material: self.signing_material,
                platform_id: self.platform_id,
                platform_display_name: self.platform_display_name,
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                overrides: self.overrides,
                signing_parameters: self.signing_parameters,
                created_at: self.created_at,
                completed_at: self.completed_at,
                signature_expires_at: self.signature_expires_at,
                requested_by: self.requested_by,
                status: self.status,
                status_reason: self.status_reason,
                revocation_record: self.revocation_record,
                signed_object: self.signed_object,
                job_owner: self.job_owner,
                job_invoker: self.job_invoker,
            }
        }
    }
}
impl DescribeSigningJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSigningJobOutput`](crate::output::DescribeSigningJobOutput)
    pub fn builder() -> crate::output::describe_signing_job_output::Builder {
        crate::output::describe_signing_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSigningProfileOutput {}
impl std::fmt::Debug for CancelSigningProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSigningProfileOutput");
        formatter.finish()
    }
}
/// See [`CancelSigningProfileOutput`](crate::output::CancelSigningProfileOutput)
pub mod cancel_signing_profile_output {
    /// A builder for [`CancelSigningProfileOutput`](crate::output::CancelSigningProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelSigningProfileOutput`](crate::output::CancelSigningProfileOutput)
        pub fn build(self) -> crate::output::CancelSigningProfileOutput {
            crate::output::CancelSigningProfileOutput {}
        }
    }
}
impl CancelSigningProfileOutput {
    /// Creates a new builder-style object to manufacture [`CancelSigningProfileOutput`](crate::output::CancelSigningProfileOutput)
    pub fn builder() -> crate::output::cancel_signing_profile_output::Builder {
        crate::output::cancel_signing_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddProfilePermissionOutput {
    /// <p>A unique identifier for the current profile revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddProfilePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddProfilePermissionOutput");
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`AddProfilePermissionOutput`](crate::output::AddProfilePermissionOutput)
pub mod add_profile_permission_output {
    /// A builder for [`AddProfilePermissionOutput`](crate::output::AddProfilePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddProfilePermissionOutput`](crate::output::AddProfilePermissionOutput)
        pub fn build(self) -> crate::output::AddProfilePermissionOutput {
            crate::output::AddProfilePermissionOutput {
                revision_id: self.revision_id,
            }
        }
    }
}
impl AddProfilePermissionOutput {
    /// Creates a new builder-style object to manufacture [`AddProfilePermissionOutput`](crate::output::AddProfilePermissionOutput)
    pub fn builder() -> crate::output::add_profile_permission_output::Builder {
        crate::output::add_profile_permission_output::Builder::default()
    }
}
