// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddProfilePermissionInput`](crate::input::AddProfilePermissionInput)
pub mod add_profile_permission_input {
    /// A builder for [`AddProfilePermissionInput`](crate::input::AddProfilePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The human-readable name of the signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The human-readable name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or
        /// another AWS account ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or
        /// another AWS account ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddProfilePermissionInput`](crate::input::AddProfilePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddProfilePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddProfilePermissionInput {
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                action: self.action,
                principal: self.principal,
                revision_id: self.revision_id,
                statement_id: self.statement_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AddProfilePermissionInputOperationOutputAlias = crate::operation::AddProfilePermission;
#[doc(hidden)]
pub type AddProfilePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddProfilePermissionInput {
    /// Consumes the builder and constructs an Operation<[`AddProfilePermission`](crate::operation::AddProfilePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddProfilePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddProfilePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.profile_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_1, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}/permissions",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddProfilePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddProfilePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_profile_permission(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddProfilePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddProfilePermission",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddProfilePermissionInput`](crate::input::AddProfilePermissionInput)
    pub fn builder() -> crate::input::add_profile_permission_input::Builder {
        crate::input::add_profile_permission_input::Builder::default()
    }
}

/// See [`CancelSigningProfileInput`](crate::input::CancelSigningProfileInput)
pub mod cancel_signing_profile_input {
    /// A builder for [`CancelSigningProfileInput`](crate::input::CancelSigningProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSigningProfileInput`](crate::input::CancelSigningProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSigningProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSigningProfileInput {
                profile_name: self.profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelSigningProfileInputOperationOutputAlias = crate::operation::CancelSigningProfile;
#[doc(hidden)]
pub type CancelSigningProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelSigningProfileInput {
    /// Consumes the builder and constructs an Operation<[`CancelSigningProfile`](crate::operation::CancelSigningProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSigningProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelSigningProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.profile_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_2, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelSigningProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelSigningProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSigningProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSigningProfile",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelSigningProfileInput`](crate::input::CancelSigningProfileInput)
    pub fn builder() -> crate::input::cancel_signing_profile_input::Builder {
        crate::input::cancel_signing_profile_input::Builder::default()
    }
}

/// See [`DescribeSigningJobInput`](crate::input::DescribeSigningJobInput)
pub mod describe_signing_job_input {
    /// A builder for [`DescribeSigningJobInput`](crate::input::DescribeSigningJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the signing job on input.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the signing job on input.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSigningJobInput`](crate::input::DescribeSigningJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSigningJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSigningJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSigningJobInputOperationOutputAlias = crate::operation::DescribeSigningJob;
#[doc(hidden)]
pub type DescribeSigningJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSigningJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSigningJob`](crate::operation::DescribeSigningJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSigningJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSigningJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.job_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_3, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/signing-jobs/{jobId}", jobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSigningJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSigningJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSigningJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSigningJob",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSigningJobInput`](crate::input::DescribeSigningJobInput)
    pub fn builder() -> crate::input::describe_signing_job_input::Builder {
        crate::input::describe_signing_job_input::Builder::default()
    }
}

/// See [`GetSigningPlatformInput`](crate::input::GetSigningPlatformInput)
pub mod get_signing_platform_input {
    /// A builder for [`GetSigningPlatformInput`](crate::input::GetSigningPlatformInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target signing platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningPlatformInput`](crate::input::GetSigningPlatformInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSigningPlatformInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSigningPlatformInput {
                platform_id: self.platform_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSigningPlatformInputOperationOutputAlias = crate::operation::GetSigningPlatform;
#[doc(hidden)]
pub type GetSigningPlatformInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSigningPlatformInput {
    /// Consumes the builder and constructs an Operation<[`GetSigningPlatform`](crate::operation::GetSigningPlatform)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSigningPlatform,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSigningPlatformInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.platform_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "platform_id",
                        details: "cannot be empty or unset",
                    })?;
            let platform_id = aws_smithy_http::label::fmt_string(input_4, false);
            if platform_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "platform_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-platforms/{platformId}",
                platformId = platform_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSigningPlatformInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSigningPlatformInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSigningPlatform::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSigningPlatform",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSigningPlatformInput`](crate::input::GetSigningPlatformInput)
    pub fn builder() -> crate::input::get_signing_platform_input::Builder {
        crate::input::get_signing_platform_input::Builder::default()
    }
}

/// See [`GetSigningProfileInput`](crate::input::GetSigningProfileInput)
pub mod get_signing_profile_input {
    /// A builder for [`GetSigningProfileInput`](crate::input::GetSigningProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the target signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the target signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn profile_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSigningProfileInput`](crate::input::GetSigningProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSigningProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSigningProfileInput {
                profile_name: self.profile_name,
                profile_owner: self.profile_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSigningProfileInputOperationOutputAlias = crate::operation::GetSigningProfile;
#[doc(hidden)]
pub type GetSigningProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSigningProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetSigningProfile`](crate::operation::GetSigningProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSigningProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSigningProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.profile_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_5, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSigningProfileInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.profile_owner {
                query.push_kv(
                    "profileOwner",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSigningProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSigningProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSigningProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSigningProfile",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSigningProfileInput`](crate::input::GetSigningProfileInput)
    pub fn builder() -> crate::input::get_signing_profile_input::Builder {
        crate::input::get_signing_profile_input::Builder::default()
    }
}

/// See [`ListProfilePermissionsInput`](crate::input::ListProfilePermissionsInput)
pub mod list_profile_permissions_input {
    /// A builder for [`ListProfilePermissionsInput`](crate::input::ListProfilePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfilePermissionsInput`](crate::input::ListProfilePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfilePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfilePermissionsInput {
                profile_name: self.profile_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfilePermissionsInputOperationOutputAlias = crate::operation::ListProfilePermissions;
#[doc(hidden)]
pub type ListProfilePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListProfilePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListProfilePermissions`](crate::operation::ListProfilePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfilePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProfilePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.profile_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_7, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}/permissions",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListProfilePermissionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProfilePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProfilePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfilePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfilePermissions",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProfilePermissionsInput`](crate::input::ListProfilePermissionsInput)
    pub fn builder() -> crate::input::list_profile_permissions_input::Builder {
        crate::input::list_profile_permissions_input::Builder::default()
    }
}

/// See [`ListSigningJobsInput`](crate::input::ListSigningJobsInput)
pub mod list_signing_jobs_input {
    /// A builder for [`ListSigningJobsInput`](crate::input::ListSigningJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SigningStatus>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) requested_by: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) is_revoked: std::option::Option<bool>,
        pub(crate) signature_expires_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) signature_expires_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_invoker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A status value with which to filter your results.</p>
        pub fn status(mut self, input: crate::model::SigningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status value with which to filter your results.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your
        /// code image.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your
        /// code image.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn requested_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.requested_by = Some(input.into());
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn set_requested_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.requested_by = input;
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter
        /// when paginating results. If additional items exist beyond the number you specify, the
        /// <code>nextToken</code> element is set in the response. Use the
        /// <code>nextToken</code> value in a subsequent request to retrieve additional items.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter
        /// when paginating results. If additional items exist beyond the number you specify, the
        /// <code>nextToken</code> element is set in the response. Use the
        /// <code>nextToken</code> value in a subsequent request to retrieve additional items.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn is_revoked(mut self, input: bool) -> Self {
            self.is_revoked = Some(input);
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn set_is_revoked(mut self, input: std::option::Option<bool>) -> Self {
            self.is_revoked = input;
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a
        /// specified timestamp.</p>
        pub fn signature_expires_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.signature_expires_before = Some(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a
        /// specified timestamp.</p>
        pub fn set_signature_expires_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.signature_expires_before = input;
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified
        /// timestamp.</p>
        pub fn signature_expires_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.signature_expires_after = Some(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified
        /// timestamp.</p>
        pub fn set_signature_expires_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.signature_expires_after = input;
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM
        /// entity.</p>
        pub fn job_invoker(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_invoker = Some(input.into());
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM
        /// entity.</p>
        pub fn set_job_invoker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_invoker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningJobsInput`](crate::input::ListSigningJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSigningJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSigningJobsInput {
                status: self.status,
                platform_id: self.platform_id,
                requested_by: self.requested_by,
                max_results: self.max_results,
                next_token: self.next_token,
                is_revoked: self.is_revoked.unwrap_or_default(),
                signature_expires_before: self.signature_expires_before,
                signature_expires_after: self.signature_expires_after,
                job_invoker: self.job_invoker,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSigningJobsInputOperationOutputAlias = crate::operation::ListSigningJobs;
#[doc(hidden)]
pub type ListSigningJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSigningJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListSigningJobs`](crate::operation::ListSigningJobs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSigningJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSigningJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/signing-jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListSigningJobsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.status {
                query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if let Some(inner_10) = &_input.platform_id {
                query.push_kv("platformId", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            if let Some(inner_11) = &_input.requested_by {
                query.push_kv(
                    "requestedBy",
                    &aws_smithy_http::query::fmt_string(&inner_11),
                );
            }
            if let Some(inner_12) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_12).encode(),
                );
            }
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if _input.is_revoked {
                query.push_kv(
                    "isRevoked",
                    &aws_smithy_types::primitive::Encoder::from(_input.is_revoked).encode(),
                );
            }
            if let Some(inner_14) = &_input.signature_expires_before {
                query.push_kv(
                    "signatureExpiresBefore",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_14,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_15) = &_input.signature_expires_after {
                query.push_kv(
                    "signatureExpiresAfter",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_15,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if let Some(inner_16) = &_input.job_invoker {
                query.push_kv("jobInvoker", &aws_smithy_http::query::fmt_string(&inner_16));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSigningJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSigningJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSigningJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSigningJobs",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSigningJobsInput`](crate::input::ListSigningJobsInput)
    pub fn builder() -> crate::input::list_signing_jobs_input::Builder {
        crate::input::list_signing_jobs_input::Builder::default()
    }
}

/// See [`ListSigningPlatformsInput`](crate::input::ListSigningPlatformsInput)
pub mod list_signing_platforms_input {
    /// A builder for [`ListSigningPlatformsInput`](crate::input::ListSigningPlatformsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) partner: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The category type of a signing platform.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The category type of a signing platform.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn partner(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner = Some(input.into());
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn set_partner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner = input;
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningPlatformsInput`](crate::input::ListSigningPlatformsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSigningPlatformsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSigningPlatformsInput {
                category: self.category,
                partner: self.partner,
                target: self.target,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSigningPlatformsInputOperationOutputAlias = crate::operation::ListSigningPlatforms;
#[doc(hidden)]
pub type ListSigningPlatformsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSigningPlatformsInput {
    /// Consumes the builder and constructs an Operation<[`ListSigningPlatforms`](crate::operation::ListSigningPlatforms)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSigningPlatforms,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSigningPlatformsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/signing-platforms").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListSigningPlatformsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.category {
                query.push_kv("category", &aws_smithy_http::query::fmt_string(&inner_17));
            }
            if let Some(inner_18) = &_input.partner {
                query.push_kv("partner", &aws_smithy_http::query::fmt_string(&inner_18));
            }
            if let Some(inner_19) = &_input.target {
                query.push_kv("target", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            if let Some(inner_20) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_20).encode(),
                );
            }
            if let Some(inner_21) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_21));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSigningPlatformsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSigningPlatformsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSigningPlatforms::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSigningPlatforms",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSigningPlatformsInput`](crate::input::ListSigningPlatformsInput)
    pub fn builder() -> crate::input::list_signing_platforms_input::Builder {
        crate::input::list_signing_platforms_input::Builder::default()
    }
}

/// See [`ListSigningProfilesInput`](crate::input::ListSigningProfilesInput)
pub mod list_signing_profiles_input {
    /// A builder for [`ListSigningProfilesInput`](crate::input::ListSigningProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_canceled: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) statuses: std::option::Option<std::vec::Vec<crate::model::SigningProfileStatus>>,
    }
    impl Builder {
        /// <p>Designates whether to include profiles with the status of
        /// <code>CANCELED</code>.</p>
        pub fn include_canceled(mut self, input: bool) -> Self {
            self.include_canceled = Some(input);
            self
        }
        /// <p>Designates whether to include profiles with the status of
        /// <code>CANCELED</code>.</p>
        pub fn set_include_canceled(mut self, input: std::option::Option<bool>) -> Self {
            self.include_canceled = input;
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing
        /// platform.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing
        /// platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>Filters results to return only signing jobs with statuses in the specified
        /// list.</p>
        pub fn statuses(mut self, input: impl Into<crate::model::SigningProfileStatus>) -> Self {
            let mut v = self.statuses.unwrap_or_default();
            v.push(input.into());
            self.statuses = Some(v);
            self
        }
        /// <p>Filters results to return only signing jobs with statuses in the specified
        /// list.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningProfileStatus>>,
        ) -> Self {
            self.statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningProfilesInput`](crate::input::ListSigningProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSigningProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSigningProfilesInput {
                include_canceled: self.include_canceled.unwrap_or_default(),
                max_results: self.max_results,
                next_token: self.next_token,
                platform_id: self.platform_id,
                statuses: self.statuses,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSigningProfilesInputOperationOutputAlias = crate::operation::ListSigningProfiles;
#[doc(hidden)]
pub type ListSigningProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSigningProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListSigningProfiles`](crate::operation::ListSigningProfiles)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSigningProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSigningProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/signing-profiles").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListSigningProfilesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.include_canceled {
                query.push_kv(
                    "includeCanceled",
                    &aws_smithy_types::primitive::Encoder::from(_input.include_canceled).encode(),
                );
            }
            if let Some(inner_22) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_22).encode(),
                );
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            if let Some(inner_24) = &_input.platform_id {
                query.push_kv("platformId", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.statuses {
                for inner_26 in inner_25 {
                    query.push_kv("statuses", &aws_smithy_http::query::fmt_string(&inner_26));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSigningProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSigningProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSigningProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSigningProfiles",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSigningProfilesInput`](crate::input::ListSigningProfilesInput)
    pub fn builder() -> crate::input::list_signing_profiles_input::Builder {
        crate::input::list_signing_profiles_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.resource_arn;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_27, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutSigningProfileInput`](crate::input::PutSigningProfileInput)
pub mod put_signing_profile_input {
    /// A builder for [`PutSigningProfileInput`](crate::input::PutSigningProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) signing_material: std::option::Option<crate::model::SigningMaterial>,
        pub(crate) signature_validity_period:
            std::option::Option<crate::model::SignatureValidityPeriod>,
        pub(crate) platform_id: std::option::Option<std::string::String>,
        pub(crate) overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
        pub(crate) signing_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the signing profile to be created.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile to be created.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing
        /// profile.</p>
        pub fn signing_material(mut self, input: crate::model::SigningMaterial) -> Self {
            self.signing_material = Some(input);
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing
        /// profile.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.signing_material = input;
            self
        }
        /// <p>The default validity period override for any signature generated using this signing
        /// profile. If unspecified, the default is 135 months.</p>
        pub fn signature_validity_period(
            mut self,
            input: crate::model::SignatureValidityPeriod,
        ) -> Self {
            self.signature_validity_period = Some(input);
            self
        }
        /// <p>The default validity period override for any signature generated using this signing
        /// profile. If unspecified, the default is 135 months.</p>
        pub fn set_signature_validity_period(
            mut self,
            input: std::option::Option<crate::model::SignatureValidityPeriod>,
        ) -> Self {
            self.signature_validity_period = input;
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn platform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_id = Some(input.into());
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform_id = input;
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration
        /// options that you want to apply to the chosen platform (such as a different
        /// <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn overrides(mut self, input: crate::model::SigningPlatformOverrides) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration
        /// options that you want to apply to the chosen platform (such as a different
        /// <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::SigningPlatformOverrides>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Adds a key-value pair to `signing_parameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>Map of key-value pairs for signing. These can include any information that you want to
        /// use during signing.</p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.signing_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.signing_parameters = Some(hash_map);
            self
        }
        /// <p>Map of key-value pairs for signing. These can include any information that you want to
        /// use during signing.</p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.signing_parameters = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSigningProfileInput`](crate::input::PutSigningProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSigningProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSigningProfileInput {
                profile_name: self.profile_name,
                signing_material: self.signing_material,
                signature_validity_period: self.signature_validity_period,
                platform_id: self.platform_id,
                overrides: self.overrides,
                signing_parameters: self.signing_parameters,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSigningProfileInputOperationOutputAlias = crate::operation::PutSigningProfile;
#[doc(hidden)]
pub type PutSigningProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutSigningProfileInput {
    /// Consumes the builder and constructs an Operation<[`PutSigningProfile`](crate::operation::PutSigningProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSigningProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSigningProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.profile_name;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_28, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSigningProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSigningProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_signing_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSigningProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSigningProfile",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSigningProfileInput`](crate::input::PutSigningProfileInput)
    pub fn builder() -> crate::input::put_signing_profile_input::Builder {
        crate::input::put_signing_profile_input::Builder::default()
    }
}

/// See [`RemoveProfilePermissionInput`](crate::input::RemoveProfilePermissionInput)
pub mod remove_profile_permission_input {
    /// A builder for [`RemoveProfilePermissionInput`](crate::input::RemoveProfilePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveProfilePermissionInput`](crate::input::RemoveProfilePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveProfilePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveProfilePermissionInput {
                profile_name: self.profile_name,
                revision_id: self.revision_id,
                statement_id: self.statement_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveProfilePermissionInputOperationOutputAlias =
    crate::operation::RemoveProfilePermission;
#[doc(hidden)]
pub type RemoveProfilePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveProfilePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveProfilePermission`](crate::operation::RemoveProfilePermission)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveProfilePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveProfilePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.profile_name;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_29, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.statement_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    })?;
            let statement_id = aws_smithy_http::label::fmt_string(input_30, false);
            if statement_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "statement_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}/permissions/{statementId}",
                profileName = profile_name,
                statementId = statement_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::RemoveProfilePermissionInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.revision_id {
                query.push_kv("revisionId", &aws_smithy_http::query::fmt_string(&inner_31));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveProfilePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveProfilePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveProfilePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveProfilePermission",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveProfilePermissionInput`](crate::input::RemoveProfilePermissionInput)
    pub fn builder() -> crate::input::remove_profile_permission_input::Builder {
        crate::input::remove_profile_permission_input::Builder::default()
    }
}

/// See [`RevokeSignatureInput`](crate::input::RevokeSignatureInput)
pub mod revoke_signature_input {
    /// A builder for [`RevokeSignatureInput`](crate::input::RevokeSignatureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_owner: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the signing job to be revoked.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>ID of the signing job to be revoked.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn job_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_owner = Some(input.into());
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_owner = input;
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeSignatureInput`](crate::input::RevokeSignatureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeSignatureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeSignatureInput {
                job_id: self.job_id,
                job_owner: self.job_owner,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeSignatureInputOperationOutputAlias = crate::operation::RevokeSignature;
#[doc(hidden)]
pub type RevokeSignatureInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeSignatureInput {
    /// Consumes the builder and constructs an Operation<[`RevokeSignature`](crate::operation::RevokeSignature)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeSignature,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeSignatureInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.job_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_32, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/signing-jobs/{jobId}/revoke", jobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeSignatureInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeSignatureInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_signature(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeSignature::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeSignature",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeSignatureInput`](crate::input::RevokeSignatureInput)
    pub fn builder() -> crate::input::revoke_signature_input::Builder {
        crate::input::revoke_signature_input::Builder::default()
    }
}

/// See [`RevokeSigningProfileInput`](crate::input::RevokeSigningProfileInput)
pub mod revoke_signing_profile_input {
    /// A builder for [`RevokeSigningProfileInput`](crate::input::RevokeSigningProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) profile_version: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) effective_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn profile_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_version = Some(input.into());
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_version = input;
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective.
        /// Signatures generated using the signing profile after this timestamp are not
        /// trusted.</p>
        pub fn effective_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.effective_time = Some(input);
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective.
        /// Signatures generated using the signing profile after this timestamp are not
        /// trusted.</p>
        pub fn set_effective_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.effective_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeSigningProfileInput`](crate::input::RevokeSigningProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeSigningProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeSigningProfileInput {
                profile_name: self.profile_name,
                profile_version: self.profile_version,
                reason: self.reason,
                effective_time: self.effective_time,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeSigningProfileInputOperationOutputAlias = crate::operation::RevokeSigningProfile;
#[doc(hidden)]
pub type RevokeSigningProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeSigningProfileInput {
    /// Consumes the builder and constructs an Operation<[`RevokeSigningProfile`](crate::operation::RevokeSigningProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeSigningProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeSigningProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.profile_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "profile_name",
                        details: "cannot be empty or unset",
                    })?;
            let profile_name = aws_smithy_http::label::fmt_string(input_33, false);
            if profile_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "profile_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/signing-profiles/{profileName}/revoke",
                profileName = profile_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeSigningProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeSigningProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_revoke_signing_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeSigningProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeSigningProfile",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeSigningProfileInput`](crate::input::RevokeSigningProfileInput)
    pub fn builder() -> crate::input::revoke_signing_profile_input::Builder {
        crate::input::revoke_signing_profile_input::Builder::default()
    }
}

/// See [`StartSigningJobInput`](crate::input::StartSigningJobInput)
pub mod start_signing_job_input {
    /// A builder for [`StartSigningJobInput`](crate::input::StartSigningJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) profile_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw
        /// code.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw
        /// code.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name
        /// of your bucket and an optional prefix.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name
        /// of your bucket and an optional prefix.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this
        /// token return the same response as the first call.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this
        /// token return the same response as the first call.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn profile_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_owner = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSigningJobInput`](crate::input::StartSigningJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSigningJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSigningJobInput {
                source: self.source,
                destination: self.destination,
                profile_name: self.profile_name,
                client_request_token: self.client_request_token,
                profile_owner: self.profile_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSigningJobInputOperationOutputAlias = crate::operation::StartSigningJob;
#[doc(hidden)]
pub type StartSigningJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSigningJobInput {
    /// Consumes the builder and constructs an Operation<[`StartSigningJob`](crate::operation::StartSigningJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSigningJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSigningJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/signing-jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSigningJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSigningJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_signing_job(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSigningJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSigningJob",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSigningJobInput`](crate::input::StartSigningJobInput)
    pub fn builder() -> crate::input::start_signing_job_input::Builder {
        crate::input::start_signing_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.resource_arn;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_34, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.resource_arn;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_35, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.tag_keys {
                for inner_37 in inner_36 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_37));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "signer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to be removed from the signing profile.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags to be associated with the signing profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSigningJobInput {
    /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw
    /// code.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>The S3 bucket in which to save your signed object. The destination contains the name
    /// of your bucket and an optional prefix.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The name of the signing profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>String that identifies the signing request. All calls after the first that use this
    /// token return the same response as the first call.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the signing profile owner.</p>
    pub profile_owner: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartSigningJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSigningJobInput");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("profile_name", &self.profile_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("profile_owner", &self.profile_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeSigningProfileInput {
    /// <p>The name of the signing profile to be revoked.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The version of the signing profile to be revoked.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The reason for revoking a signing profile.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>A timestamp for when revocation of a Signing Profile should become effective.
    /// Signatures generated using the signing profile after this timestamp are not
    /// trusted.</p>
    pub effective_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for RevokeSigningProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeSigningProfileInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("reason", &self.reason);
        formatter.field("effective_time", &self.effective_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeSignatureInput {
    /// <p>ID of the signing job to be revoked.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>AWS account ID of the job owner.</p>
    pub job_owner: std::option::Option<std::string::String>,
    /// <p>The reason for revoking the signing job.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RevokeSignatureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeSignatureInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_owner", &self.job_owner);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveProfilePermissionInput {
    /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>An identifier for the current revision of the signing profile permissions.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the cross-account permissions statement.</p>
    pub statement_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveProfilePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveProfilePermissionInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("statement_id", &self.statement_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSigningProfileInput {
    /// <p>The name of the signing profile to be created.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing
    /// profile.</p>
    pub signing_material: std::option::Option<crate::model::SigningMaterial>,
    /// <p>The default validity period override for any signature generated using this signing
    /// profile. If unspecified, the default is 135 months.</p>
    pub signature_validity_period: std::option::Option<crate::model::SignatureValidityPeriod>,
    /// <p>The ID of the signing platform to be created.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>A subfield of <code>platform</code>. This specifies any different configuration
    /// options that you want to apply to the chosen platform (such as a different
    /// <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
    pub overrides: std::option::Option<crate::model::SigningPlatformOverrides>,
    /// <p>Map of key-value pairs for signing. These can include any information that you want to
    /// use during signing.</p>
    pub signing_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Tags to be associated with the signing profile that is being created.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PutSigningProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSigningProfileInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("signing_material", &self.signing_material);
        formatter.field("signature_validity_period", &self.signature_validity_period);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("overrides", &self.overrides);
        formatter.field("signing_parameters", &self.signing_parameters);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningProfilesInput {
    /// <p>Designates whether to include profiles with the status of
    /// <code>CANCELED</code>.</p>
    pub include_canceled: bool,
    /// <p>The maximum number of profiles to be returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Value for specifying the next set of paginated results to return. After you receive a
    /// response with truncated results, use this parameter in a subsequent request. Set it to
    /// the value of <code>nextToken</code> from the response that you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters results to return only signing jobs initiated for a specified signing
    /// platform.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>Filters results to return only signing jobs with statuses in the specified
    /// list.</p>
    pub statuses: std::option::Option<std::vec::Vec<crate::model::SigningProfileStatus>>,
}
impl std::fmt::Debug for ListSigningProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningProfilesInput");
        formatter.field("include_canceled", &self.include_canceled);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("statuses", &self.statuses);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningPlatformsInput {
    /// <p>The category type of a signing platform.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>Any partner entities connected to a signing platform.</p>
    pub partner: std::option::Option<std::string::String>,
    /// <p>The validation template that is used by the target signing platform.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned by this operation.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Value for specifying the next set of paginated results to return. After you receive a
    /// response with truncated results, use this parameter in a subsequent request. Set it to
    /// the value of <code>nextToken</code> from the response that you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSigningPlatformsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningPlatformsInput");
        formatter.field("category", &self.category);
        formatter.field("partner", &self.partner);
        formatter.field("target", &self.target);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningJobsInput {
    /// <p>A status value with which to filter your results.</p>
    pub status: std::option::Option<crate::model::SigningStatus>,
    /// <p>The ID of microcontroller platform that you specified for the distribution of your
    /// code image.</p>
    pub platform_id: std::option::Option<std::string::String>,
    /// <p>The IAM principal that requested the signing job.</p>
    pub requested_by: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of items to return in the response. Use this parameter
    /// when paginating results. If additional items exist beyond the number you specify, the
    /// <code>nextToken</code> element is set in the response. Use the
    /// <code>nextToken</code> value in a subsequent request to retrieve additional items.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>String for specifying the next set of paginated results to return. After you receive a
    /// response with truncated results, use this parameter in a subsequent request. Set it to
    /// the value of <code>nextToken</code> from the response that you just received.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters results to return only signing jobs with revoked signatures.</p>
    pub is_revoked: bool,
    /// <p>Filters results to return only signing jobs with signatures expiring before a
    /// specified timestamp.</p>
    pub signature_expires_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters results to return only signing jobs with signatures expiring after a specified
    /// timestamp.</p>
    pub signature_expires_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters results to return only signing jobs initiated by a specified IAM
    /// entity.</p>
    pub job_invoker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSigningJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningJobsInput");
        formatter.field("status", &self.status);
        formatter.field("platform_id", &self.platform_id);
        formatter.field("requested_by", &self.requested_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("is_revoked", &self.is_revoked);
        formatter.field("signature_expires_before", &self.signature_expires_before);
        formatter.field("signature_expires_after", &self.signature_expires_after);
        formatter.field("job_invoker", &self.job_invoker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfilePermissionsInput {
    /// <p>Name of the signing profile containing the cross-account permissions.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>String for specifying the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProfilePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfilePermissionsInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSigningProfileInput {
    /// <p>The name of the target signing profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The AWS account ID of the profile owner.</p>
    pub profile_owner: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSigningProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSigningProfileInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_owner", &self.profile_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSigningPlatformInput {
    /// <p>The ID of the target signing platform.</p>
    pub platform_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSigningPlatformInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSigningPlatformInput");
        formatter.field("platform_id", &self.platform_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSigningJobInput {
    /// <p>The ID of the signing job on input.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSigningJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSigningJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSigningProfileInput {
    /// <p>The name of the signing profile to be canceled.</p>
    pub profile_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelSigningProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSigningProfileInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddProfilePermissionInput {
    /// <p>The human-readable name of the signing profile.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The version of the signing profile.</p>
    pub profile_version: std::option::Option<std::string::String>,
    /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or
    /// another AWS account ID.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the current profile revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the cross-account permission statement.</p>
    pub statement_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddProfilePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddProfilePermissionInput");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("profile_version", &self.profile_version);
        formatter.field("action", &self.action);
        formatter.field("principal", &self.principal);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("statement_id", &self.statement_id);
        formatter.finish()
    }
}
