// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddProfilePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_profile_permission`](crate::client::Client::add_profile_permission).
///
/// See [`crate::client::fluent_builders::AddProfilePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddProfilePermission {
    _private: (),
}
impl AddProfilePermission {
    /// Creates a new builder-style object to manufacture [`AddProfilePermissionInput`](crate::input::AddProfilePermissionInput)
    pub fn builder() -> crate::input::add_profile_permission_input::Builder {
        crate::input::add_profile_permission_input::Builder::default()
    }
    /// Creates a new `AddProfilePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddProfilePermission {
    type Output = std::result::Result<
        crate::output::AddProfilePermissionOutput,
        crate::error::AddProfilePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_profile_permission_error(response)
        } else {
            crate::operation_deser::parse_add_profile_permission_response(response)
        }
    }
}

/// Operation shape for `CancelSigningProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_signing_profile`](crate::client::Client::cancel_signing_profile).
///
/// See [`crate::client::fluent_builders::CancelSigningProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSigningProfile {
    _private: (),
}
impl CancelSigningProfile {
    /// Creates a new builder-style object to manufacture [`CancelSigningProfileInput`](crate::input::CancelSigningProfileInput)
    pub fn builder() -> crate::input::cancel_signing_profile_input::Builder {
        crate::input::cancel_signing_profile_input::Builder::default()
    }
    /// Creates a new `CancelSigningProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSigningProfile {
    type Output = std::result::Result<
        crate::output::CancelSigningProfileOutput,
        crate::error::CancelSigningProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_signing_profile_error(response)
        } else {
            crate::operation_deser::parse_cancel_signing_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeSigningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_signing_job`](crate::client::Client::describe_signing_job).
///
/// See [`crate::client::fluent_builders::DescribeSigningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSigningJob {
    _private: (),
}
impl DescribeSigningJob {
    /// Creates a new builder-style object to manufacture [`DescribeSigningJobInput`](crate::input::DescribeSigningJobInput)
    pub fn builder() -> crate::input::describe_signing_job_input::Builder {
        crate::input::describe_signing_job_input::Builder::default()
    }
    /// Creates a new `DescribeSigningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSigningJob {
    type Output = std::result::Result<
        crate::output::DescribeSigningJobOutput,
        crate::error::DescribeSigningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_signing_job_error(response)
        } else {
            crate::operation_deser::parse_describe_signing_job_response(response)
        }
    }
}

/// Operation shape for `GetSigningPlatform`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_signing_platform`](crate::client::Client::get_signing_platform).
///
/// See [`crate::client::fluent_builders::GetSigningPlatform`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSigningPlatform {
    _private: (),
}
impl GetSigningPlatform {
    /// Creates a new builder-style object to manufacture [`GetSigningPlatformInput`](crate::input::GetSigningPlatformInput)
    pub fn builder() -> crate::input::get_signing_platform_input::Builder {
        crate::input::get_signing_platform_input::Builder::default()
    }
    /// Creates a new `GetSigningPlatform` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSigningPlatform {
    type Output = std::result::Result<
        crate::output::GetSigningPlatformOutput,
        crate::error::GetSigningPlatformError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_signing_platform_error(response)
        } else {
            crate::operation_deser::parse_get_signing_platform_response(response)
        }
    }
}

/// Operation shape for `GetSigningProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_signing_profile`](crate::client::Client::get_signing_profile).
///
/// See [`crate::client::fluent_builders::GetSigningProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSigningProfile {
    _private: (),
}
impl GetSigningProfile {
    /// Creates a new builder-style object to manufacture [`GetSigningProfileInput`](crate::input::GetSigningProfileInput)
    pub fn builder() -> crate::input::get_signing_profile_input::Builder {
        crate::input::get_signing_profile_input::Builder::default()
    }
    /// Creates a new `GetSigningProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSigningProfile {
    type Output = std::result::Result<
        crate::output::GetSigningProfileOutput,
        crate::error::GetSigningProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_signing_profile_error(response)
        } else {
            crate::operation_deser::parse_get_signing_profile_response(response)
        }
    }
}

/// Operation shape for `ListProfilePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profile_permissions`](crate::client::Client::list_profile_permissions).
///
/// See [`crate::client::fluent_builders::ListProfilePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfilePermissions {
    _private: (),
}
impl ListProfilePermissions {
    /// Creates a new builder-style object to manufacture [`ListProfilePermissionsInput`](crate::input::ListProfilePermissionsInput)
    pub fn builder() -> crate::input::list_profile_permissions_input::Builder {
        crate::input::list_profile_permissions_input::Builder::default()
    }
    /// Creates a new `ListProfilePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfilePermissions {
    type Output = std::result::Result<
        crate::output::ListProfilePermissionsOutput,
        crate::error::ListProfilePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profile_permissions_error(response)
        } else {
            crate::operation_deser::parse_list_profile_permissions_response(response)
        }
    }
}

/// Operation shape for `ListSigningJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_signing_jobs`](crate::client::Client::list_signing_jobs).
///
/// See [`crate::client::fluent_builders::ListSigningJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSigningJobs {
    _private: (),
}
impl ListSigningJobs {
    /// Creates a new builder-style object to manufacture [`ListSigningJobsInput`](crate::input::ListSigningJobsInput)
    pub fn builder() -> crate::input::list_signing_jobs_input::Builder {
        crate::input::list_signing_jobs_input::Builder::default()
    }
    /// Creates a new `ListSigningJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSigningJobs {
    type Output = std::result::Result<
        crate::output::ListSigningJobsOutput,
        crate::error::ListSigningJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_signing_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_signing_jobs_response(response)
        }
    }
}

/// Operation shape for `ListSigningPlatforms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_signing_platforms`](crate::client::Client::list_signing_platforms).
///
/// See [`crate::client::fluent_builders::ListSigningPlatforms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSigningPlatforms {
    _private: (),
}
impl ListSigningPlatforms {
    /// Creates a new builder-style object to manufacture [`ListSigningPlatformsInput`](crate::input::ListSigningPlatformsInput)
    pub fn builder() -> crate::input::list_signing_platforms_input::Builder {
        crate::input::list_signing_platforms_input::Builder::default()
    }
    /// Creates a new `ListSigningPlatforms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSigningPlatforms {
    type Output = std::result::Result<
        crate::output::ListSigningPlatformsOutput,
        crate::error::ListSigningPlatformsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_signing_platforms_error(response)
        } else {
            crate::operation_deser::parse_list_signing_platforms_response(response)
        }
    }
}

/// Operation shape for `ListSigningProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_signing_profiles`](crate::client::Client::list_signing_profiles).
///
/// See [`crate::client::fluent_builders::ListSigningProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSigningProfiles {
    _private: (),
}
impl ListSigningProfiles {
    /// Creates a new builder-style object to manufacture [`ListSigningProfilesInput`](crate::input::ListSigningProfilesInput)
    pub fn builder() -> crate::input::list_signing_profiles_input::Builder {
        crate::input::list_signing_profiles_input::Builder::default()
    }
    /// Creates a new `ListSigningProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSigningProfiles {
    type Output = std::result::Result<
        crate::output::ListSigningProfilesOutput,
        crate::error::ListSigningProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_signing_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_signing_profiles_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutSigningProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_signing_profile`](crate::client::Client::put_signing_profile).
///
/// See [`crate::client::fluent_builders::PutSigningProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSigningProfile {
    _private: (),
}
impl PutSigningProfile {
    /// Creates a new builder-style object to manufacture [`PutSigningProfileInput`](crate::input::PutSigningProfileInput)
    pub fn builder() -> crate::input::put_signing_profile_input::Builder {
        crate::input::put_signing_profile_input::Builder::default()
    }
    /// Creates a new `PutSigningProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSigningProfile {
    type Output = std::result::Result<
        crate::output::PutSigningProfileOutput,
        crate::error::PutSigningProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_signing_profile_error(response)
        } else {
            crate::operation_deser::parse_put_signing_profile_response(response)
        }
    }
}

/// Operation shape for `RemoveProfilePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_profile_permission`](crate::client::Client::remove_profile_permission).
///
/// See [`crate::client::fluent_builders::RemoveProfilePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveProfilePermission {
    _private: (),
}
impl RemoveProfilePermission {
    /// Creates a new builder-style object to manufacture [`RemoveProfilePermissionInput`](crate::input::RemoveProfilePermissionInput)
    pub fn builder() -> crate::input::remove_profile_permission_input::Builder {
        crate::input::remove_profile_permission_input::Builder::default()
    }
    /// Creates a new `RemoveProfilePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveProfilePermission {
    type Output = std::result::Result<
        crate::output::RemoveProfilePermissionOutput,
        crate::error::RemoveProfilePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_profile_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_profile_permission_response(response)
        }
    }
}

/// Operation shape for `RevokeSignature`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_signature`](crate::client::Client::revoke_signature).
///
/// See [`crate::client::fluent_builders::RevokeSignature`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeSignature {
    _private: (),
}
impl RevokeSignature {
    /// Creates a new builder-style object to manufacture [`RevokeSignatureInput`](crate::input::RevokeSignatureInput)
    pub fn builder() -> crate::input::revoke_signature_input::Builder {
        crate::input::revoke_signature_input::Builder::default()
    }
    /// Creates a new `RevokeSignature` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeSignature {
    type Output = std::result::Result<
        crate::output::RevokeSignatureOutput,
        crate::error::RevokeSignatureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_signature_error(response)
        } else {
            crate::operation_deser::parse_revoke_signature_response(response)
        }
    }
}

/// Operation shape for `RevokeSigningProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_signing_profile`](crate::client::Client::revoke_signing_profile).
///
/// See [`crate::client::fluent_builders::RevokeSigningProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeSigningProfile {
    _private: (),
}
impl RevokeSigningProfile {
    /// Creates a new builder-style object to manufacture [`RevokeSigningProfileInput`](crate::input::RevokeSigningProfileInput)
    pub fn builder() -> crate::input::revoke_signing_profile_input::Builder {
        crate::input::revoke_signing_profile_input::Builder::default()
    }
    /// Creates a new `RevokeSigningProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeSigningProfile {
    type Output = std::result::Result<
        crate::output::RevokeSigningProfileOutput,
        crate::error::RevokeSigningProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_signing_profile_error(response)
        } else {
            crate::operation_deser::parse_revoke_signing_profile_response(response)
        }
    }
}

/// Operation shape for `StartSigningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_signing_job`](crate::client::Client::start_signing_job).
///
/// See [`crate::client::fluent_builders::StartSigningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSigningJob {
    _private: (),
}
impl StartSigningJob {
    /// Creates a new builder-style object to manufacture [`StartSigningJobInput`](crate::input::StartSigningJobInput)
    pub fn builder() -> crate::input::start_signing_job_input::Builder {
        crate::input::start_signing_job_input::Builder::default()
    }
    /// Creates a new `StartSigningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSigningJob {
    type Output = std::result::Result<
        crate::output::StartSigningJobOutput,
        crate::error::StartSigningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_signing_job_error(response)
        } else {
            crate::operation_deser::parse_start_signing_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
