// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `WallabyService`.
///
/// This client allows ergonomic access to a `WallabyService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddProfilePermission` operation.
    ///
    /// See [`AddProfilePermission`](crate::client::fluent_builders::AddProfilePermission) for more information about the
    /// operation and its arguments.
    pub fn add_profile_permission(&self) -> fluent_builders::AddProfilePermission<C, M, R> {
        fluent_builders::AddProfilePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSigningProfile` operation.
    ///
    /// See [`CancelSigningProfile`](crate::client::fluent_builders::CancelSigningProfile) for more information about the
    /// operation and its arguments.
    pub fn cancel_signing_profile(&self) -> fluent_builders::CancelSigningProfile<C, M, R> {
        fluent_builders::CancelSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSigningJob` operation.
    ///
    /// See [`DescribeSigningJob`](crate::client::fluent_builders::DescribeSigningJob) for more information about the
    /// operation and its arguments.
    pub fn describe_signing_job(&self) -> fluent_builders::DescribeSigningJob<C, M, R> {
        fluent_builders::DescribeSigningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSigningPlatform` operation.
    ///
    /// See [`GetSigningPlatform`](crate::client::fluent_builders::GetSigningPlatform) for more information about the
    /// operation and its arguments.
    pub fn get_signing_platform(&self) -> fluent_builders::GetSigningPlatform<C, M, R> {
        fluent_builders::GetSigningPlatform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSigningProfile` operation.
    ///
    /// See [`GetSigningProfile`](crate::client::fluent_builders::GetSigningProfile) for more information about the
    /// operation and its arguments.
    pub fn get_signing_profile(&self) -> fluent_builders::GetSigningProfile<C, M, R> {
        fluent_builders::GetSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfilePermissions` operation.
    ///
    /// See [`ListProfilePermissions`](crate::client::fluent_builders::ListProfilePermissions) for more information about the
    /// operation and its arguments.
    pub fn list_profile_permissions(&self) -> fluent_builders::ListProfilePermissions<C, M, R> {
        fluent_builders::ListProfilePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSigningJobs` operation.
    ///
    /// See [`ListSigningJobs`](crate::client::fluent_builders::ListSigningJobs) for more information about the
    /// operation and its arguments.
    pub fn list_signing_jobs(&self) -> fluent_builders::ListSigningJobs<C, M, R> {
        fluent_builders::ListSigningJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSigningPlatforms` operation.
    ///
    /// See [`ListSigningPlatforms`](crate::client::fluent_builders::ListSigningPlatforms) for more information about the
    /// operation and its arguments.
    pub fn list_signing_platforms(&self) -> fluent_builders::ListSigningPlatforms<C, M, R> {
        fluent_builders::ListSigningPlatforms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSigningProfiles` operation.
    ///
    /// See [`ListSigningProfiles`](crate::client::fluent_builders::ListSigningProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_signing_profiles(&self) -> fluent_builders::ListSigningProfiles<C, M, R> {
        fluent_builders::ListSigningProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSigningProfile` operation.
    ///
    /// See [`PutSigningProfile`](crate::client::fluent_builders::PutSigningProfile) for more information about the
    /// operation and its arguments.
    pub fn put_signing_profile(&self) -> fluent_builders::PutSigningProfile<C, M, R> {
        fluent_builders::PutSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveProfilePermission` operation.
    ///
    /// See [`RemoveProfilePermission`](crate::client::fluent_builders::RemoveProfilePermission) for more information about the
    /// operation and its arguments.
    pub fn remove_profile_permission(&self) -> fluent_builders::RemoveProfilePermission<C, M, R> {
        fluent_builders::RemoveProfilePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeSignature` operation.
    ///
    /// See [`RevokeSignature`](crate::client::fluent_builders::RevokeSignature) for more information about the
    /// operation and its arguments.
    pub fn revoke_signature(&self) -> fluent_builders::RevokeSignature<C, M, R> {
        fluent_builders::RevokeSignature::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeSigningProfile` operation.
    ///
    /// See [`RevokeSigningProfile`](crate::client::fluent_builders::RevokeSigningProfile) for more information about the
    /// operation and its arguments.
    pub fn revoke_signing_profile(&self) -> fluent_builders::RevokeSigningProfile<C, M, R> {
        fluent_builders::RevokeSigningProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSigningJob` operation.
    ///
    /// See [`StartSigningJob`](crate::client::fluent_builders::StartSigningJob) for more information about the
    /// operation and its arguments.
    pub fn start_signing_job(&self) -> fluent_builders::StartSigningJob<C, M, R> {
        fluent_builders::StartSigningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddProfilePermission`.
    ///
    /// <p>Adds cross-account permissions to a signing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddProfilePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_profile_permission_input::Builder,
    }
    impl<C, M, R> AddProfilePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddProfilePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddProfilePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddProfilePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddProfilePermissionInputOperationOutputAlias,
                crate::output::AddProfilePermissionOutput,
                crate::error::AddProfilePermissionError,
                crate::input::AddProfilePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The human-readable name of the signing profile.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The human-readable name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn profile_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_version(inp);
            self
        }
        /// <p>The version of the signing profile.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_version(input);
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The AWS Signer action permitted as part of cross-account permissions.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or
        /// another AWS account ID.</p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The AWS principal receiving cross-account permissions. This may be an IAM role or
        /// another AWS account ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>A unique identifier for the current profile revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>A unique identifier for the cross-account permission statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSigningProfile`.
    ///
    /// <p>Changes the state of an <code>ACTIVE</code> signing profile to <code>CANCELED</code>.
    /// A canceled profile is still viewable with the <code>ListSigningProfiles</code>
    /// operation, but it cannot perform new signing jobs, and is deleted two years after
    /// cancelation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelSigningProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_signing_profile_input::Builder,
    }
    impl<C, M, R> CancelSigningProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSigningProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSigningProfileInputOperationOutputAlias,
                crate::output::CancelSigningProfileOutput,
                crate::error::CancelSigningProfileError,
                crate::input::CancelSigningProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of the signing profile to be canceled.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSigningJob`.
    ///
    /// <p>Returns information about a specific code signing job. You specify the job by using
    /// the <code>jobId</code> value that is returned by the <a>StartSigningJob</a>
    /// operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSigningJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_signing_job_input::Builder,
    }
    impl<C, M, R> DescribeSigningJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSigningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSigningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSigningJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSigningJobInputOperationOutputAlias,
                crate::output::DescribeSigningJobOutput,
                crate::error::DescribeSigningJobError,
                crate::input::DescribeSigningJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the signing job on input.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the signing job on input.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSigningPlatform`.
    ///
    /// <p>Returns information on a specific signing platform.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSigningPlatform<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_signing_platform_input::Builder,
    }
    impl<C, M, R> GetSigningPlatform<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSigningPlatform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSigningPlatformOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSigningPlatformError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSigningPlatformInputOperationOutputAlias,
                crate::output::GetSigningPlatformOutput,
                crate::error::GetSigningPlatformError,
                crate::input::GetSigningPlatformInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn platform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(inp);
            self
        }
        /// <p>The ID of the target signing platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSigningProfile`.
    ///
    /// <p>Returns information on a specific signing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSigningProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_signing_profile_input::Builder,
    }
    impl<C, M, R> GetSigningProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSigningProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSigningProfileInputOperationOutputAlias,
                crate::output::GetSigningProfileOutput,
                crate::error::GetSigningProfileError,
                crate::input::GetSigningProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the target signing profile.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of the target signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn profile_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_owner(inp);
            self
        }
        /// <p>The AWS account ID of the profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfilePermissions`.
    ///
    /// <p>Lists the cross-account permissions associated with a signing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProfilePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profile_permissions_input::Builder,
    }
    impl<C, M, R> ListProfilePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfilePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfilePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfilePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfilePermissionsInputOperationOutputAlias,
                crate::output::ListProfilePermissionsOutput,
                crate::error::ListProfilePermissionsError,
                crate::input::ListProfilePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>Name of the signing profile containing the cross-account permissions.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>String for specifying the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningJobs`.
    ///
    /// <p>Lists all your signing jobs. You can use the <code>maxResults</code> parameter to
    /// limit the number of signing jobs that are returned in the response. If additional jobs
    /// remain to be listed, code signing returns a <code>nextToken</code> value. Use this value in
    /// subsequent calls to <code>ListSigningJobs</code> to fetch the remaining values. You can
    /// continue calling <code>ListSigningJobs</code> with your <code>maxResults</code>
    /// parameter and with new values that code signing returns in the <code>nextToken</code>
    /// parameter until all of your signing jobs have been returned. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListSigningJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_signing_jobs_input::Builder,
    }
    impl<C, M, R> ListSigningJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSigningJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSigningJobsInputOperationOutputAlias,
                crate::output::ListSigningJobsOutput,
                crate::error::ListSigningJobsError,
                crate::input::ListSigningJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A status value with which to filter your results.</p>
        pub fn status(mut self, inp: crate::model::SigningStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>A status value with which to filter your results.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SigningStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your
        /// code image.</p>
        pub fn platform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(inp);
            self
        }
        /// <p>The ID of microcontroller platform that you specified for the distribution of your
        /// code image.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn requested_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.requested_by(inp);
            self
        }
        /// <p>The IAM principal that requested the signing job.</p>
        pub fn set_requested_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_requested_by(input);
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter
        /// when paginating results. If additional items exist beyond the number you specify, the
        /// <code>nextToken</code> element is set in the response. Use the
        /// <code>nextToken</code> value in a subsequent request to retrieve additional items.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specifies the maximum number of items to return in the response. Use this parameter
        /// when paginating results. If additional items exist beyond the number you specify, the
        /// <code>nextToken</code> element is set in the response. Use the
        /// <code>nextToken</code> value in a subsequent request to retrieve additional items.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>String for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn is_revoked(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_revoked(inp);
            self
        }
        /// <p>Filters results to return only signing jobs with revoked signatures.</p>
        pub fn set_is_revoked(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_revoked(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a
        /// specified timestamp.</p>
        pub fn signature_expires_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.signature_expires_before(inp);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring before a
        /// specified timestamp.</p>
        pub fn set_signature_expires_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_signature_expires_before(input);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified
        /// timestamp.</p>
        pub fn signature_expires_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.signature_expires_after(inp);
            self
        }
        /// <p>Filters results to return only signing jobs with signatures expiring after a specified
        /// timestamp.</p>
        pub fn set_signature_expires_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_signature_expires_after(input);
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM
        /// entity.</p>
        pub fn job_invoker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_invoker(inp);
            self
        }
        /// <p>Filters results to return only signing jobs initiated by a specified IAM
        /// entity.</p>
        pub fn set_job_invoker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_invoker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningPlatforms`.
    ///
    /// <p>Lists all signing platforms available in code signing that match the request parameters. If
    /// additional jobs remain to be listed, code signing returns a <code>nextToken</code> value. Use
    /// this value in subsequent calls to <code>ListSigningJobs</code> to fetch the remaining
    /// values. You can continue calling <code>ListSigningJobs</code> with your
    /// <code>maxResults</code> parameter and with new values that code signing returns in the
    /// <code>nextToken</code> parameter until all of your signing jobs have been
    /// returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSigningPlatforms<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_signing_platforms_input::Builder,
    }
    impl<C, M, R> ListSigningPlatforms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSigningPlatforms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningPlatformsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningPlatformsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSigningPlatformsInputOperationOutputAlias,
                crate::output::ListSigningPlatformsOutput,
                crate::error::ListSigningPlatformsError,
                crate::input::ListSigningPlatformsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The category type of a signing platform.</p>
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>The category type of a signing platform.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn partner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner(inp);
            self
        }
        /// <p>Any partner entities connected to a signing platform.</p>
        pub fn set_partner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner(input);
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn target(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The validation template that is used by the target signing platform.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned by this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningProfiles`.
    ///
    /// <p>Lists all available signing profiles in your AWS account. Returns only profiles with
    /// an <code>ACTIVE</code> status unless the <code>includeCanceled</code> request field is
    /// set to <code>true</code>. If additional jobs remain to be listed, code signing returns a
    /// <code>nextToken</code> value. Use this value in subsequent calls to
    /// <code>ListSigningJobs</code> to fetch the remaining values. You can continue calling
    /// <code>ListSigningJobs</code> with your <code>maxResults</code> parameter and with
    /// new values that code signing returns in the <code>nextToken</code> parameter until all of your
    /// signing jobs have been returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSigningProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_signing_profiles_input::Builder,
    }
    impl<C, M, R> ListSigningProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSigningProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSigningProfilesInputOperationOutputAlias,
                crate::output::ListSigningProfilesOutput,
                crate::error::ListSigningProfilesError,
                crate::input::ListSigningProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Designates whether to include profiles with the status of
        /// <code>CANCELED</code>.</p>
        pub fn include_canceled(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_canceled(inp);
            self
        }
        /// <p>Designates whether to include profiles with the status of
        /// <code>CANCELED</code>.</p>
        pub fn set_include_canceled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_canceled(input);
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of profiles to be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Value for specifying the next set of paginated results to return. After you receive a
        /// response with truncated results, use this parameter in a subsequent request. Set it to
        /// the value of <code>nextToken</code> from the response that you just received.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing
        /// platform.</p>
        pub fn platform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(inp);
            self
        }
        /// <p>Filters results to return only signing jobs initiated for a specified signing
        /// platform.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// Appends an item to `statuses`.
        ///
        /// To override the contents of this collection use [`set_statuses`](Self::set_statuses).
        ///
        /// <p>Filters results to return only signing jobs with statuses in the specified
        /// list.</p>
        pub fn statuses(mut self, inp: impl Into<crate::model::SigningProfileStatus>) -> Self {
            self.inner = self.inner.statuses(inp);
            self
        }
        /// <p>Filters results to return only signing jobs with statuses in the specified
        /// list.</p>
        pub fn set_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningProfileStatus>>,
        ) -> Self {
            self.inner = self.inner.set_statuses(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags associated with a signing profile resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSigningProfile`.
    ///
    /// <p>Creates a signing profile. A signing profile is a code signing template that can be used to
    /// carry out a pre-defined signing job. For more information, see <a href="http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html">http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct PutSigningProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_signing_profile_input::Builder,
    }
    impl<C, M, R> PutSigningProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSigningProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSigningProfileInputOperationOutputAlias,
                crate::output::PutSigningProfileOutput,
                crate::error::PutSigningProfileError,
                crate::input::PutSigningProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be created.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of the signing profile to be created.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing
        /// profile.</p>
        pub fn signing_material(mut self, inp: crate::model::SigningMaterial) -> Self {
            self.inner = self.inner.signing_material(inp);
            self
        }
        /// <p>The AWS Certificate Manager certificate that will be used to sign code with the new signing
        /// profile.</p>
        pub fn set_signing_material(
            mut self,
            input: std::option::Option<crate::model::SigningMaterial>,
        ) -> Self {
            self.inner = self.inner.set_signing_material(input);
            self
        }
        /// <p>The default validity period override for any signature generated using this signing
        /// profile. If unspecified, the default is 135 months.</p>
        pub fn signature_validity_period(
            mut self,
            inp: crate::model::SignatureValidityPeriod,
        ) -> Self {
            self.inner = self.inner.signature_validity_period(inp);
            self
        }
        /// <p>The default validity period override for any signature generated using this signing
        /// profile. If unspecified, the default is 135 months.</p>
        pub fn set_signature_validity_period(
            mut self,
            input: std::option::Option<crate::model::SignatureValidityPeriod>,
        ) -> Self {
            self.inner = self.inner.set_signature_validity_period(input);
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn platform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_id(inp);
            self
        }
        /// <p>The ID of the signing platform to be created.</p>
        pub fn set_platform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_platform_id(input);
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration
        /// options that you want to apply to the chosen platform (such as a different
        /// <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn overrides(mut self, inp: crate::model::SigningPlatformOverrides) -> Self {
            self.inner = self.inner.overrides(inp);
            self
        }
        /// <p>A subfield of <code>platform</code>. This specifies any different configuration
        /// options that you want to apply to the chosen platform (such as a different
        /// <code>hash-algorithm</code> or <code>signing-algorithm</code>).</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::SigningPlatformOverrides>,
        ) -> Self {
            self.inner = self.inner.set_overrides(input);
            self
        }
        /// Adds a key-value pair to `signingParameters`.
        ///
        /// To override the contents of this collection use [`set_signing_parameters`](Self::set_signing_parameters).
        ///
        /// <p>Map of key-value pairs for signing. These can include any information that you want to
        /// use during signing.</p>
        pub fn signing_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.signing_parameters(k, v);
            self
        }
        /// <p>Map of key-value pairs for signing. These can include any information that you want to
        /// use during signing.</p>
        pub fn set_signing_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_signing_parameters(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags to be associated with the signing profile that is being created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveProfilePermission`.
    ///
    /// <p>Removes cross-account permissions from a signing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveProfilePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_profile_permission_input::Builder,
    }
    impl<C, M, R> RemoveProfilePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveProfilePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveProfilePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveProfilePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveProfilePermissionInputOperationOutputAlias,
                crate::output::RemoveProfilePermissionOutput,
                crate::error::RemoveProfilePermissionError,
                crate::input::RemoveProfilePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>A human-readable name for the signing profile with permissions to be removed.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>An identifier for the current revision of the signing profile permissions.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>A unique identifier for the cross-account permissions statement.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeSignature`.
    ///
    /// <p>Changes the state of a signing job to REVOKED. This indicates that the signature is no
    /// longer valid.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeSignature<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_signature_input::Builder,
    }
    impl<C, M, R> RevokeSignature<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeSignature`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeSignatureOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeSignatureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeSignatureInputOperationOutputAlias,
                crate::output::RevokeSignatureOutput,
                crate::error::RevokeSignatureError,
                crate::input::RevokeSignatureInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the signing job to be revoked.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>ID of the signing job to be revoked.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn job_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_owner(inp);
            self
        }
        /// <p>AWS account ID of the job owner.</p>
        pub fn set_job_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_owner(input);
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The reason for revoking the signing job.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeSigningProfile`.
    ///
    /// <p>Changes the state of a signing profile to REVOKED. This indicates that signatures
    /// generated using the signing profile after an effective start date are no longer
    /// valid.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeSigningProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_signing_profile_input::Builder,
    }
    impl<C, M, R> RevokeSigningProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeSigningProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeSigningProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeSigningProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeSigningProfileInputOperationOutputAlias,
                crate::output::RevokeSigningProfileOutput,
                crate::error::RevokeSigningProfileError,
                crate::input::RevokeSigningProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of the signing profile to be revoked.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn profile_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_version(inp);
            self
        }
        /// <p>The version of the signing profile to be revoked.</p>
        pub fn set_profile_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_version(input);
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The reason for revoking a signing profile.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective.
        /// Signatures generated using the signing profile after this timestamp are not
        /// trusted.</p>
        pub fn effective_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.effective_time(inp);
            self
        }
        /// <p>A timestamp for when revocation of a Signing Profile should become effective.
        /// Signatures generated using the signing profile after this timestamp are not
        /// trusted.</p>
        pub fn set_effective_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_effective_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSigningJob`.
    ///
    /// <p>Initiates a signing job to be performed on the code provided. Signing jobs are
    /// viewable by the <code>ListSigningJobs</code> operation for two years after they are
    /// performed. Note the following requirements: </p>
    /// <ul>
    /// <li>
    /// <p> You must create an Amazon S3 source bucket. For more information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html">Create a Bucket</a> in the
    /// <i>Amazon S3 Getting Started Guide</i>. </p>
    /// </li>
    /// <li>
    /// <p>Your S3 source bucket must be version enabled.</p>
    /// </li>
    /// <li>
    /// <p>You must create an S3 destination bucket. Code signing uses your S3 destination
    /// bucket to write your signed code.</p>
    /// </li>
    /// <li>
    /// <p>You specify the name of the source and destination buckets when calling the
    /// <code>StartSigningJob</code> operation.</p>
    /// </li>
    /// <li>
    /// <p>You must also specify a request token that identifies your request to
    /// code signing.</p>
    /// </li>
    /// </ul>
    /// <p>You can call the <a>DescribeSigningJob</a> and the <a>ListSigningJobs</a> actions after you call
    /// <code>StartSigningJob</code>.</p>
    /// <p>For a Java example that shows how to use this action, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/">http://docs.aws.amazon.com/acm/latest/userguide/</a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct StartSigningJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_signing_job_input::Builder,
    }
    impl<C, M, R> StartSigningJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSigningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSigningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSigningJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSigningJobInputOperationOutputAlias,
                crate::output::StartSigningJobOutput,
                crate::error::StartSigningJobError,
                crate::input::StartSigningJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw
        /// code.</p>
        pub fn source(mut self, inp: crate::model::Source) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The S3 bucket that contains the object to sign or a BLOB that contains your raw
        /// code.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name
        /// of your bucket and an optional prefix.</p>
        pub fn destination(mut self, inp: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>The S3 bucket in which to save your signed object. The destination contains the name
        /// of your bucket and an optional prefix.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_name(inp);
            self
        }
        /// <p>The name of the signing profile.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_name(input);
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this
        /// token return the same response as the first call.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>String that identifies the signing request. All calls after the first that use this
        /// token return the same response as the first call.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn profile_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_owner(inp);
            self
        }
        /// <p>The AWS account ID of the signing profile owner.</p>
        pub fn set_profile_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a signing profile. Tags are labels that you can use to
    /// identify and organize your AWS resources. Each tag consists of a key and an optional
    /// value. To specify the signing profile, use its Amazon Resource Name (ARN). To specify
    /// the tag, use a key-value pair.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags to be associated with the signing profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a signing profile. To remove the tags, specify a list of
    /// tag keys.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the signing profile.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys to be removed from the signing profile.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
