// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Shield
///
/// Client for invoking operations on AWS Shield. Each operation on AWS Shield is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_shield::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_shield::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_shield::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateDRTLogBucket`](crate::client::fluent_builders::AssociateDRTLogBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_bucket(impl Into<String>)`](crate::client::fluent_builders::AssociateDRTLogBucket::log_bucket) / [`set_log_bucket(Option<String>)`](crate::client::fluent_builders::AssociateDRTLogBucket::set_log_bucket): <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
    /// - On success, responds with [`AssociateDrtLogBucketOutput`](crate::output::AssociateDrtLogBucketOutput)

    /// - On failure, responds with [`SdkError<AssociateDRTLogBucketError>`](crate::error::AssociateDRTLogBucketError)
    pub fn associate_drt_log_bucket(&self) -> fluent_builders::AssociateDRTLogBucket {
        fluent_builders::AssociateDRTLogBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateDRTRole`](crate::client::fluent_builders::AssociateDRTRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateDRTRole::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AssociateDRTRole::set_role_arn): <p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p>  <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>
    /// - On success, responds with [`AssociateDrtRoleOutput`](crate::output::AssociateDrtRoleOutput)

    /// - On failure, responds with [`SdkError<AssociateDRTRoleError>`](crate::error::AssociateDRTRoleError)
    pub fn associate_drt_role(&self) -> fluent_builders::AssociateDRTRole {
        fluent_builders::AssociateDRTRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateHealthCheck`](crate::client::fluent_builders::AssociateHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_id(impl Into<String>)`](crate::client::fluent_builders::AssociateHealthCheck::protection_id) / [`set_protection_id(Option<String>)`](crate::client::fluent_builders::AssociateHealthCheck::set_protection_id): <p>The unique identifier (ID) for the <code>Protection</code> object to add the health check association to. </p>
    ///   - [`health_check_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateHealthCheck::health_check_arn) / [`set_health_check_arn(Option<String>)`](crate::client::fluent_builders::AssociateHealthCheck::set_health_check_arn): <p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>
    /// - On success, responds with [`AssociateHealthCheckOutput`](crate::output::AssociateHealthCheckOutput)

    /// - On failure, responds with [`SdkError<AssociateHealthCheckError>`](crate::error::AssociateHealthCheckError)
    pub fn associate_health_check(&self) -> fluent_builders::AssociateHealthCheck {
        fluent_builders::AssociateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateProactiveEngagementDetails`](crate::client::fluent_builders::AssociateProactiveEngagementDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`emergency_contact_list(Vec<EmergencyContact>)`](crate::client::fluent_builders::AssociateProactiveEngagementDetails::emergency_contact_list) / [`set_emergency_contact_list(Option<Vec<EmergencyContact>>)`](crate::client::fluent_builders::AssociateProactiveEngagementDetails::set_emergency_contact_list): <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p>  <p>To enable proactive engagement, the contact list must include at least one phone number.</p> <note>   <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here. </p>  </note>
    /// - On success, responds with [`AssociateProactiveEngagementDetailsOutput`](crate::output::AssociateProactiveEngagementDetailsOutput)

    /// - On failure, responds with [`SdkError<AssociateProactiveEngagementDetailsError>`](crate::error::AssociateProactiveEngagementDetailsError)
    pub fn associate_proactive_engagement_details(
        &self,
    ) -> fluent_builders::AssociateProactiveEngagementDetails {
        fluent_builders::AssociateProactiveEngagementDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProtection`](crate::client::fluent_builders::CreateProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProtection::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProtection::set_name): <p>Friendly name for the <code>Protection</code> you are creating.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProtection::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CreateProtection::set_resource_arn): <p>The ARN (Amazon Resource Name) of the resource to be protected.</p>  <p>The ARN should be in one of the following formats:</p>  <ul>   <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>   <li> <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> </code> </p> </li>   <li> <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> </code> </p> </li>   <li> <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> </code> </p> </li>   <li> <p>For Amazon Route&nbsp;53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> </code> </p> </li>   <li> <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> </code> </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProtection::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProtection::set_tags): <p>One or more tag key-value pairs for the <code>Protection</code> object that is created.</p>
    /// - On success, responds with [`CreateProtectionOutput`](crate::output::CreateProtectionOutput) with field(s):
    ///   - [`protection_id(Option<String>)`](crate::output::CreateProtectionOutput::protection_id): <p>The unique identifier (ID) for the <code>Protection</code> object that is created.</p>
    /// - On failure, responds with [`SdkError<CreateProtectionError>`](crate::error::CreateProtectionError)
    pub fn create_protection(&self) -> fluent_builders::CreateProtection {
        fluent_builders::CreateProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProtectionGroup`](crate::client::fluent_builders::CreateProtectionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateProtectionGroup::protection_group_id) / [`set_protection_group_id(Option<String>)`](crate::client::fluent_builders::CreateProtectionGroup::set_protection_group_id): <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    ///   - [`aggregation(ProtectionGroupAggregation)`](crate::client::fluent_builders::CreateProtectionGroup::aggregation) / [`set_aggregation(Option<ProtectionGroupAggregation>)`](crate::client::fluent_builders::CreateProtectionGroup::set_aggregation): <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>  <ul>   <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>   <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>   <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p> </li>  </ul>
    ///   - [`pattern(ProtectionGroupPattern)`](crate::client::fluent_builders::CreateProtectionGroup::pattern) / [`set_pattern(Option<ProtectionGroupPattern>)`](crate::client::fluent_builders::CreateProtectionGroup::set_pattern): <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>
    ///   - [`resource_type(ProtectedResourceType)`](crate::client::fluent_builders::CreateProtectionGroup::resource_type) / [`set_resource_type(Option<ProtectedResourceType>)`](crate::client::fluent_builders::CreateProtectionGroup::set_resource_type): <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    ///   - [`members(Vec<String>)`](crate::client::fluent_builders::CreateProtectionGroup::members) / [`set_members(Option<Vec<String>>)`](crate::client::fluent_builders::CreateProtectionGroup::set_members): <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProtectionGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProtectionGroup::set_tags): <p>One or more tag key-value pairs for the protection group.</p>
    /// - On success, responds with [`CreateProtectionGroupOutput`](crate::output::CreateProtectionGroupOutput)

    /// - On failure, responds with [`SdkError<CreateProtectionGroupError>`](crate::error::CreateProtectionGroupError)
    pub fn create_protection_group(&self) -> fluent_builders::CreateProtectionGroup {
        fluent_builders::CreateProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSubscription`](crate::client::fluent_builders::CreateSubscription) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::CreateSubscription::send) it.

    /// - On success, responds with [`CreateSubscriptionOutput`](crate::output::CreateSubscriptionOutput)

    /// - On failure, responds with [`SdkError<CreateSubscriptionError>`](crate::error::CreateSubscriptionError)
    pub fn create_subscription(&self) -> fluent_builders::CreateSubscription {
        fluent_builders::CreateSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProtection`](crate::client::fluent_builders::DeleteProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProtection::protection_id) / [`set_protection_id(Option<String>)`](crate::client::fluent_builders::DeleteProtection::set_protection_id): <p>The unique identifier (ID) for the <code>Protection</code> object to be deleted.</p>
    /// - On success, responds with [`DeleteProtectionOutput`](crate::output::DeleteProtectionOutput)

    /// - On failure, responds with [`SdkError<DeleteProtectionError>`](crate::error::DeleteProtectionError)
    pub fn delete_protection(&self) -> fluent_builders::DeleteProtection {
        fluent_builders::DeleteProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProtectionGroup`](crate::client::fluent_builders::DeleteProtectionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProtectionGroup::protection_group_id) / [`set_protection_group_id(Option<String>)`](crate::client::fluent_builders::DeleteProtectionGroup::set_protection_group_id): <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    /// - On success, responds with [`DeleteProtectionGroupOutput`](crate::output::DeleteProtectionGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteProtectionGroupError>`](crate::error::DeleteProtectionGroupError)
    pub fn delete_protection_group(&self) -> fluent_builders::DeleteProtectionGroup {
        fluent_builders::DeleteProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubscription`](crate::client::fluent_builders::DeleteSubscription) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteSubscription::send) it.

    /// - On success, responds with [`DeleteSubscriptionOutput`](crate::output::DeleteSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteSubscriptionError>`](crate::error::DeleteSubscriptionError)
    pub fn delete_subscription(&self) -> fluent_builders::DeleteSubscription {
        fluent_builders::DeleteSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAttack`](crate::client::fluent_builders::DescribeAttack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attack_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAttack::attack_id) / [`set_attack_id(Option<String>)`](crate::client::fluent_builders::DescribeAttack::set_attack_id): <p>The unique identifier (ID) for the attack.</p>
    /// - On success, responds with [`DescribeAttackOutput`](crate::output::DescribeAttackOutput) with field(s):
    ///   - [`attack(Option<AttackDetail>)`](crate::output::DescribeAttackOutput::attack): <p>The attack that is described.</p>
    /// - On failure, responds with [`SdkError<DescribeAttackError>`](crate::error::DescribeAttackError)
    pub fn describe_attack(&self) -> fluent_builders::DescribeAttack {
        fluent_builders::DescribeAttack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAttackStatistics`](crate::client::fluent_builders::DescribeAttackStatistics) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAttackStatistics::send) it.

    /// - On success, responds with [`DescribeAttackStatisticsOutput`](crate::output::DescribeAttackStatisticsOutput) with field(s):
    ///   - [`time_range(Option<TimeRange>)`](crate::output::DescribeAttackStatisticsOutput::time_range): <p>The time range. </p>
    ///   - [`data_items(Option<Vec<AttackStatisticsDataItem>>)`](crate::output::DescribeAttackStatisticsOutput::data_items): <p>The data that describes the attacks detected during the time period.</p>
    /// - On failure, responds with [`SdkError<DescribeAttackStatisticsError>`](crate::error::DescribeAttackStatisticsError)
    pub fn describe_attack_statistics(&self) -> fluent_builders::DescribeAttackStatistics {
        fluent_builders::DescribeAttackStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDRTAccess`](crate::client::fluent_builders::DescribeDRTAccess) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeDRTAccess::send) it.

    /// - On success, responds with [`DescribeDrtAccessOutput`](crate::output::DescribeDrtAccessOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeDrtAccessOutput::role_arn): <p>The Amazon Resource Name (ARN) of the role the SRT used to access your Amazon Web Services account.</p>
    ///   - [`log_bucket_list(Option<Vec<String>>)`](crate::output::DescribeDrtAccessOutput::log_bucket_list): <p>The list of Amazon S3 buckets accessed by the SRT.</p>
    /// - On failure, responds with [`SdkError<DescribeDRTAccessError>`](crate::error::DescribeDRTAccessError)
    pub fn describe_drt_access(&self) -> fluent_builders::DescribeDRTAccess {
        fluent_builders::DescribeDRTAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEmergencyContactSettings`](crate::client::fluent_builders::DescribeEmergencyContactSettings) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeEmergencyContactSettings::send) it.

    /// - On success, responds with [`DescribeEmergencyContactSettingsOutput`](crate::output::DescribeEmergencyContactSettingsOutput) with field(s):
    ///   - [`emergency_contact_list(Option<Vec<EmergencyContact>>)`](crate::output::DescribeEmergencyContactSettingsOutput::emergency_contact_list): <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
    /// - On failure, responds with [`SdkError<DescribeEmergencyContactSettingsError>`](crate::error::DescribeEmergencyContactSettingsError)
    pub fn describe_emergency_contact_settings(
        &self,
    ) -> fluent_builders::DescribeEmergencyContactSettings {
        fluent_builders::DescribeEmergencyContactSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProtection`](crate::client::fluent_builders::DescribeProtection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProtection::protection_id) / [`set_protection_id(Option<String>)`](crate::client::fluent_builders::DescribeProtection::set_protection_id): <p>The unique identifier (ID) for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeProtection::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DescribeProtection::set_resource_arn): <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
    /// - On success, responds with [`DescribeProtectionOutput`](crate::output::DescribeProtectionOutput) with field(s):
    ///   - [`protection(Option<Protection>)`](crate::output::DescribeProtectionOutput::protection): <p>The <code>Protection</code> object that is described.</p>
    /// - On failure, responds with [`SdkError<DescribeProtectionError>`](crate::error::DescribeProtectionError)
    pub fn describe_protection(&self) -> fluent_builders::DescribeProtection {
        fluent_builders::DescribeProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProtectionGroup`](crate::client::fluent_builders::DescribeProtectionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeProtectionGroup::protection_group_id) / [`set_protection_group_id(Option<String>)`](crate::client::fluent_builders::DescribeProtectionGroup::set_protection_group_id): <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    /// - On success, responds with [`DescribeProtectionGroupOutput`](crate::output::DescribeProtectionGroupOutput) with field(s):
    ///   - [`protection_group(Option<ProtectionGroup>)`](crate::output::DescribeProtectionGroupOutput::protection_group): <p>A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
    /// - On failure, responds with [`SdkError<DescribeProtectionGroupError>`](crate::error::DescribeProtectionGroupError)
    pub fn describe_protection_group(&self) -> fluent_builders::DescribeProtectionGroup {
        fluent_builders::DescribeProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSubscription`](crate::client::fluent_builders::DescribeSubscription) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeSubscription::send) it.

    /// - On success, responds with [`DescribeSubscriptionOutput`](crate::output::DescribeSubscriptionOutput) with field(s):
    ///   - [`subscription(Option<Subscription>)`](crate::output::DescribeSubscriptionOutput::subscription): <p>The Shield Advanced subscription details for an account.</p>
    /// - On failure, responds with [`SdkError<DescribeSubscriptionError>`](crate::error::DescribeSubscriptionError)
    pub fn describe_subscription(&self) -> fluent_builders::DescribeSubscription {
        fluent_builders::DescribeSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableApplicationLayerAutomaticResponse`](crate::client::fluent_builders::DisableApplicationLayerAutomaticResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DisableApplicationLayerAutomaticResponse::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DisableApplicationLayerAutomaticResponse::set_resource_arn): <p>The ARN (Amazon Resource Name) of the resource.</p>
    /// - On success, responds with [`DisableApplicationLayerAutomaticResponseOutput`](crate::output::DisableApplicationLayerAutomaticResponseOutput)

    /// - On failure, responds with [`SdkError<DisableApplicationLayerAutomaticResponseError>`](crate::error::DisableApplicationLayerAutomaticResponseError)
    pub fn disable_application_layer_automatic_response(
        &self,
    ) -> fluent_builders::DisableApplicationLayerAutomaticResponse {
        fluent_builders::DisableApplicationLayerAutomaticResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableProactiveEngagement`](crate::client::fluent_builders::DisableProactiveEngagement) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableProactiveEngagement::send) it.

    /// - On success, responds with [`DisableProactiveEngagementOutput`](crate::output::DisableProactiveEngagementOutput)

    /// - On failure, responds with [`SdkError<DisableProactiveEngagementError>`](crate::error::DisableProactiveEngagementError)
    pub fn disable_proactive_engagement(&self) -> fluent_builders::DisableProactiveEngagement {
        fluent_builders::DisableProactiveEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateDRTLogBucket`](crate::client::fluent_builders::DisassociateDRTLogBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_bucket(impl Into<String>)`](crate::client::fluent_builders::DisassociateDRTLogBucket::log_bucket) / [`set_log_bucket(Option<String>)`](crate::client::fluent_builders::DisassociateDRTLogBucket::set_log_bucket): <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
    /// - On success, responds with [`DisassociateDrtLogBucketOutput`](crate::output::DisassociateDrtLogBucketOutput)

    /// - On failure, responds with [`SdkError<DisassociateDRTLogBucketError>`](crate::error::DisassociateDRTLogBucketError)
    pub fn disassociate_drt_log_bucket(&self) -> fluent_builders::DisassociateDRTLogBucket {
        fluent_builders::DisassociateDRTLogBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateDRTRole`](crate::client::fluent_builders::DisassociateDRTRole) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateDRTRole::send) it.

    /// - On success, responds with [`DisassociateDrtRoleOutput`](crate::output::DisassociateDrtRoleOutput)

    /// - On failure, responds with [`SdkError<DisassociateDRTRoleError>`](crate::error::DisassociateDRTRoleError)
    pub fn disassociate_drt_role(&self) -> fluent_builders::DisassociateDRTRole {
        fluent_builders::DisassociateDRTRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateHealthCheck`](crate::client::fluent_builders::DisassociateHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateHealthCheck::protection_id) / [`set_protection_id(Option<String>)`](crate::client::fluent_builders::DisassociateHealthCheck::set_protection_id): <p>The unique identifier (ID) for the <code>Protection</code> object to remove the health check association from. </p>
    ///   - [`health_check_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateHealthCheck::health_check_arn) / [`set_health_check_arn(Option<String>)`](crate::client::fluent_builders::DisassociateHealthCheck::set_health_check_arn): <p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>
    /// - On success, responds with [`DisassociateHealthCheckOutput`](crate::output::DisassociateHealthCheckOutput)

    /// - On failure, responds with [`SdkError<DisassociateHealthCheckError>`](crate::error::DisassociateHealthCheckError)
    pub fn disassociate_health_check(&self) -> fluent_builders::DisassociateHealthCheck {
        fluent_builders::DisassociateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableApplicationLayerAutomaticResponse`](crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse::set_resource_arn): <p>The ARN (Amazon Resource Name) of the resource.</p>
    ///   - [`action(ResponseAction)`](crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse::action) / [`set_action(Option<ResponseAction>)`](crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse::set_action): <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
    /// - On success, responds with [`EnableApplicationLayerAutomaticResponseOutput`](crate::output::EnableApplicationLayerAutomaticResponseOutput)

    /// - On failure, responds with [`SdkError<EnableApplicationLayerAutomaticResponseError>`](crate::error::EnableApplicationLayerAutomaticResponseError)
    pub fn enable_application_layer_automatic_response(
        &self,
    ) -> fluent_builders::EnableApplicationLayerAutomaticResponse {
        fluent_builders::EnableApplicationLayerAutomaticResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableProactiveEngagement`](crate::client::fluent_builders::EnableProactiveEngagement) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::EnableProactiveEngagement::send) it.

    /// - On success, responds with [`EnableProactiveEngagementOutput`](crate::output::EnableProactiveEngagementOutput)

    /// - On failure, responds with [`SdkError<EnableProactiveEngagementError>`](crate::error::EnableProactiveEngagementError)
    pub fn enable_proactive_engagement(&self) -> fluent_builders::EnableProactiveEngagement {
        fluent_builders::EnableProactiveEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSubscriptionState`](crate::client::fluent_builders::GetSubscriptionState) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetSubscriptionState::send) it.

    /// - On success, responds with [`GetSubscriptionStateOutput`](crate::output::GetSubscriptionStateOutput) with field(s):
    ///   - [`subscription_state(Option<SubscriptionState>)`](crate::output::GetSubscriptionStateOutput::subscription_state): <p>The status of the subscription.</p>
    /// - On failure, responds with [`SdkError<GetSubscriptionStateError>`](crate::error::GetSubscriptionStateError)
    pub fn get_subscription_state(&self) -> fluent_builders::GetSubscriptionState {
        fluent_builders::GetSubscriptionState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttacks`](crate::client::fluent_builders::ListAttacks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttacks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::ListAttacks::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListAttacks::set_resource_arns): <p>The ARNs (Amazon Resource Names) of the resources that were attacked. If you leave this blank, all applicable resources for this account will be included.</p>
    ///   - [`start_time(TimeRange)`](crate::client::fluent_builders::ListAttacks::start_time) / [`set_start_time(Option<TimeRange>)`](crate::client::fluent_builders::ListAttacks::set_start_time): <p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
    ///   - [`end_time(TimeRange)`](crate::client::fluent_builders::ListAttacks::end_time) / [`set_end_time(Option<TimeRange>)`](crate::client::fluent_builders::ListAttacks::set_end_time): <p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttacks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttacks::set_next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>  <p>On your first call to a list operation, leave this setting empty.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttacks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttacks::set_max_results): <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>  <p>The default setting is 20.</p>
    /// - On success, responds with [`ListAttacksOutput`](crate::output::ListAttacksOutput) with field(s):
    ///   - [`attack_summaries(Option<Vec<AttackSummary>>)`](crate::output::ListAttacksOutput::attack_summaries): <p>The attack information for the specified time range.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttacksOutput::next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
    /// - On failure, responds with [`SdkError<ListAttacksError>`](crate::error::ListAttacksError)
    pub fn list_attacks(&self) -> fluent_builders::ListAttacks {
        fluent_builders::ListAttacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProtectionGroups`](crate::client::fluent_builders::ListProtectionGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProtectionGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProtectionGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProtectionGroups::set_next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>  <p>On your first call to a list operation, leave this setting empty.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProtectionGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProtectionGroups::set_max_results): <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>  <p>The default setting is 20.</p>
    /// - On success, responds with [`ListProtectionGroupsOutput`](crate::output::ListProtectionGroupsOutput) with field(s):
    ///   - [`protection_groups(Option<Vec<ProtectionGroup>>)`](crate::output::ListProtectionGroupsOutput::protection_groups): <p></p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProtectionGroupsOutput::next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
    /// - On failure, responds with [`SdkError<ListProtectionGroupsError>`](crate::error::ListProtectionGroupsError)
    pub fn list_protection_groups(&self) -> fluent_builders::ListProtectionGroups {
        fluent_builders::ListProtectionGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProtections`](crate::client::fluent_builders::ListProtections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProtections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProtections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProtections::set_next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>  <p>On your first call to a list operation, leave this setting empty.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProtections::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProtections::set_max_results): <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>  <p>The default setting is 20.</p>
    /// - On success, responds with [`ListProtectionsOutput`](crate::output::ListProtectionsOutput) with field(s):
    ///   - [`protections(Option<Vec<Protection>>)`](crate::output::ListProtectionsOutput::protections): <p>The array of enabled <code>Protection</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProtectionsOutput::next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
    /// - On failure, responds with [`SdkError<ListProtectionsError>`](crate::error::ListProtectionsError)
    pub fn list_protections(&self) -> fluent_builders::ListProtections {
        fluent_builders::ListProtections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourcesInProtectionGroup`](crate::client::fluent_builders::ListResourcesInProtectionGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourcesInProtectionGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_group_id(impl Into<String>)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::protection_group_id) / [`set_protection_group_id(Option<String>)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::set_protection_group_id): <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::set_next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>  <p>On your first call to a list operation, leave this setting empty.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourcesInProtectionGroup::set_max_results): <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>  <p>The default setting is 20.</p>
    /// - On success, responds with [`ListResourcesInProtectionGroupOutput`](crate::output::ListResourcesInProtectionGroupOutput) with field(s):
    ///   - [`resource_arns(Option<Vec<String>>)`](crate::output::ListResourcesInProtectionGroupOutput::resource_arns): <p>The Amazon Resource Names (ARNs) of the resources that are included in the protection group.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourcesInProtectionGroupOutput::next_token): <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>  <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>  <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
    /// - On failure, responds with [`SdkError<ListResourcesInProtectionGroupError>`](crate::error::ListResourcesInProtectionGroupError)
    pub fn list_resources_in_protection_group(
        &self,
    ) -> fluent_builders::ListResourcesInProtectionGroup {
        fluent_builders::ListResourcesInProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag key and value pairs associated with the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags that you want to modify or add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag key for each tag that you want to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplicationLayerAutomaticResponse`](crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse::set_resource_arn): <p>The ARN (Amazon Resource Name) of the resource.</p>
    ///   - [`action(ResponseAction)`](crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse::action) / [`set_action(Option<ResponseAction>)`](crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse::set_action): <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
    /// - On success, responds with [`UpdateApplicationLayerAutomaticResponseOutput`](crate::output::UpdateApplicationLayerAutomaticResponseOutput)

    /// - On failure, responds with [`SdkError<UpdateApplicationLayerAutomaticResponseError>`](crate::error::UpdateApplicationLayerAutomaticResponseError)
    pub fn update_application_layer_automatic_response(
        &self,
    ) -> fluent_builders::UpdateApplicationLayerAutomaticResponse {
        fluent_builders::UpdateApplicationLayerAutomaticResponse::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEmergencyContactSettings`](crate::client::fluent_builders::UpdateEmergencyContactSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`emergency_contact_list(Vec<EmergencyContact>)`](crate::client::fluent_builders::UpdateEmergencyContactSettings::emergency_contact_list) / [`set_emergency_contact_list(Option<Vec<EmergencyContact>>)`](crate::client::fluent_builders::UpdateEmergencyContactSettings::set_emergency_contact_list): <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>  <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>
    /// - On success, responds with [`UpdateEmergencyContactSettingsOutput`](crate::output::UpdateEmergencyContactSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateEmergencyContactSettingsError>`](crate::error::UpdateEmergencyContactSettingsError)
    pub fn update_emergency_contact_settings(
        &self,
    ) -> fluent_builders::UpdateEmergencyContactSettings {
        fluent_builders::UpdateEmergencyContactSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProtectionGroup`](crate::client::fluent_builders::UpdateProtectionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`protection_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProtectionGroup::protection_group_id) / [`set_protection_group_id(Option<String>)`](crate::client::fluent_builders::UpdateProtectionGroup::set_protection_group_id): <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    ///   - [`aggregation(ProtectionGroupAggregation)`](crate::client::fluent_builders::UpdateProtectionGroup::aggregation) / [`set_aggregation(Option<ProtectionGroupAggregation>)`](crate::client::fluent_builders::UpdateProtectionGroup::set_aggregation): <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>  <ul>   <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>   <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>   <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>  </ul>
    ///   - [`pattern(ProtectionGroupPattern)`](crate::client::fluent_builders::UpdateProtectionGroup::pattern) / [`set_pattern(Option<ProtectionGroupPattern>)`](crate::client::fluent_builders::UpdateProtectionGroup::set_pattern): <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
    ///   - [`resource_type(ProtectedResourceType)`](crate::client::fluent_builders::UpdateProtectionGroup::resource_type) / [`set_resource_type(Option<ProtectedResourceType>)`](crate::client::fluent_builders::UpdateProtectionGroup::set_resource_type): <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    ///   - [`members(Vec<String>)`](crate::client::fluent_builders::UpdateProtectionGroup::members) / [`set_members(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateProtectionGroup::set_members): <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    /// - On success, responds with [`UpdateProtectionGroupOutput`](crate::output::UpdateProtectionGroupOutput)

    /// - On failure, responds with [`SdkError<UpdateProtectionGroupError>`](crate::error::UpdateProtectionGroupError)
    pub fn update_protection_group(&self) -> fluent_builders::UpdateProtectionGroup {
        fluent_builders::UpdateProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSubscription`](crate::client::fluent_builders::UpdateSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_renew(AutoRenew)`](crate::client::fluent_builders::UpdateSubscription::auto_renew) / [`set_auto_renew(Option<AutoRenew>)`](crate::client::fluent_builders::UpdateSubscription::set_auto_renew): <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
    /// - On success, responds with [`UpdateSubscriptionOutput`](crate::output::UpdateSubscriptionOutput)

    /// - On failure, responds with [`SdkError<UpdateSubscriptionError>`](crate::error::UpdateSubscriptionError)
    pub fn update_subscription(&self) -> fluent_builders::UpdateSubscription {
        fluent_builders::UpdateSubscription::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDRTLogBucket`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.</p>
    /// <p>To use the services of the SRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to the <a href="https://docs.aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://docs.aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDRTLogBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_drt_log_bucket_input::Builder,
    }
    impl AssociateDRTLogBucket {
        /// Creates a new `AssociateDRTLogBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDrtLogBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDRTLogBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn log_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn set_log_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDRTRole`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.</p>
    /// <p>You can associate only one <code>RoleArn</code> with your subscription. If you submit an <code>AssociateDRTRole</code> request for an account that already has an associated role, the new <code>RoleArn</code> will replace the existing <code>RoleArn</code>. </p>
    /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <code>AWSShieldDRTAccessPolicy</code> managed policy to the role that you'll specify in the request. You can access this policy in the IAM console at <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a>. For more information see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Adding and removing IAM identity permissions</a>. The role must also trust the service principal <code>drt.shield.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON policy elements: Principal</a>.</p>
    /// <p>The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT takes these actions only if explicitly authorized by you.</p>
    /// <p>You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a user permissions to pass a role to an Amazon Web Services service</a>. </p>
    /// <p>To use the services of the SRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the <a href="https://docs.aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://docs.aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDRTRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_drt_role_input::Builder,
    }
    impl AssociateDRTRole {
        /// Creates a new `AssociateDRTRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDrtRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDRTRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p>
        /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p>
        /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateHealthCheck`.
    ///
    /// <p>Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response. </p>
    /// <p>You define the health check in Route&nbsp;53 and then associate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_health_check_input::Builder,
    }
    impl AssociateHealthCheck {
        /// Creates a new `AssociateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to add the health check association to. </p>
        pub fn protection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to add the health check association to. </p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>
        pub fn health_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>
        pub fn set_health_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateProactiveEngagementDetails`.
    ///
    /// <p>Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list. </p>
    /// <p>After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>. </p> <note>
    /// <p>This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support.</p>
    /// <p>The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it to this call. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateProactiveEngagementDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_proactive_engagement_details_input::Builder,
    }
    impl AssociateProactiveEngagementDetails {
        /// Creates a new `AssociateProactiveEngagementDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateProactiveEngagementDetailsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateProactiveEngagementDetailsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EmergencyContactList`.
        ///
        /// To override the contents of this collection use [`set_emergency_contact_list`](Self::set_emergency_contact_list).
        ///
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p>
        /// <p>To enable proactive engagement, the contact list must include at least one phone number.</p> <note>
        /// <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here. </p>
        /// </note>
        pub fn emergency_contact_list(mut self, input: crate::model::EmergencyContact) -> Self {
            self.inner = self.inner.emergency_contact_list(input);
            self
        }
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p>
        /// <p>To enable proactive engagement, the contact list must include at least one phone number.</p> <note>
        /// <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here. </p>
        /// </note>
        pub fn set_emergency_contact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EmergencyContact>>,
        ) -> Self {
            self.inner = self.inner.set_emergency_contact_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProtection`.
    ///
    /// <p>Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Elastic Load Balancing load balancer, Global Accelerator accelerator, Elastic IP Address, or an Amazon Route&nbsp;53 hosted zone.</p>
    /// <p>You can add protection to only a single resource with each <code>CreateProtection</code> request. You can add protection to multiple resources at once through the Shield Advanced console at <a href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For more information see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with Shield Advanced</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Adding Shield Advanced protection to Amazon Web Services resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_protection_input::Builder,
    }
    impl CreateProtection {
        /// Creates a new `CreateProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Friendly name for the <code>Protection</code> you are creating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Friendly name for the <code>Protection</code> you are creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource to be protected.</p>
        /// <p>The ARN should be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> </code> </p> </li>
        /// <li> <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> </code> </p> </li>
        /// <li> <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> </code> </p> </li>
        /// <li> <p>For Amazon Route&nbsp;53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> </code> </p> </li>
        /// <li> <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> </code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource to be protected.</p>
        /// <p>The ARN should be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> </code> </p> </li>
        /// <li> <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> </code> </p> </li>
        /// <li> <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> </code> </p> </li>
        /// <li> <p>For Amazon Route&nbsp;53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> </code> </p> </li>
        /// <li> <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the <code>Protection</code> object that is created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tag key-value pairs for the <code>Protection</code> object that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProtectionGroup`.
    ///
    /// <p>Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProtectionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_protection_group_input::Builder,
    }
    impl CreateProtectionGroup {
        /// Creates a new `CreateProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProtectionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn aggregation(mut self, input: crate::model::ProtectionGroupAggregation) -> Self {
            self.inner = self.inner.aggregation(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn set_aggregation(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupAggregation>,
        ) -> Self {
            self.inner = self.inner.set_aggregation(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>
        pub fn pattern(mut self, input: crate::model::ProtectionGroupPattern) -> Self {
            self.inner = self.inner.pattern(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>
        pub fn set_pattern(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPattern>,
        ) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn resource_type(mut self, input: crate::model::ProtectedResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ProtectedResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.members(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the protection group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tag key-value pairs for the protection group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscription`.
    ///
    /// <p>Activates Shield Advanced for an account.</p>
    /// <p>When you initally create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_subscription_input::Builder,
    }
    impl CreateSubscription {
        /// Creates a new `CreateSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteProtection`.
    ///
    /// <p>Deletes an Shield Advanced <code>Protection</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_protection_input::Builder,
    }
    impl DeleteProtection {
        /// Creates a new `DeleteProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to be deleted.</p>
        pub fn protection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to be deleted.</p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProtectionGroup`.
    ///
    /// <p>Removes the specified protection group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProtectionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_protection_group_input::Builder,
    }
    impl DeleteProtectionGroup {
        /// Creates a new `DeleteProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProtectionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscription`.
    ///
    /// <p>Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_subscription_input::Builder,
    }
    impl DeleteSubscription {
        /// Creates a new `DeleteSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAttack`.
    ///
    /// <p>Describes the details of a DDoS attack. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAttack {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_attack_input::Builder,
    }
    impl DescribeAttack {
        /// Creates a new `DescribeAttack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttackOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the attack.</p>
        pub fn attack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attack_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the attack.</p>
        pub fn set_attack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attack_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAttackStatistics`.
    ///
    /// <p>Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.</p>
    /// <p>The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example, if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to <code>2020-10-26 00:00:00 UTC</code>. </p>
    /// <p>The time range indicates the period covered by the attack statistics data items.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAttackStatistics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_attack_statistics_input::Builder,
    }
    impl DescribeAttackStatistics {
        /// Creates a new `DescribeAttackStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttackStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttackStatisticsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDRTAccess`.
    ///
    /// <p>Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDRTAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_drt_access_input::Builder,
    }
    impl DescribeDRTAccess {
        /// Creates a new `DescribeDRTAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDrtAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDRTAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeEmergencyContactSettings`.
    ///
    /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEmergencyContactSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_emergency_contact_settings_input::Builder,
    }
    impl DescribeEmergencyContactSettings {
        /// Creates a new `DescribeEmergencyContactSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEmergencyContactSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEmergencyContactSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeProtection`.
    ///
    /// <p>Lists the details of a <code>Protection</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProtection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_protection_input::Builder,
    }
    impl DescribeProtection {
        /// Creates a new `DescribeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProtectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn protection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <code>Protection</code> object that is described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProtectionGroup`.
    ///
    /// <p>Returns the specification for the specified protection group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProtectionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_protection_group_input::Builder,
    }
    impl DescribeProtectionGroup {
        /// Creates a new `DescribeProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProtectionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscription`.
    ///
    /// <p>Provides details about the Shield Advanced subscription for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_subscription_input::Builder,
    }
    impl DescribeSubscription {
        /// Creates a new `DescribeSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableApplicationLayerAutomaticResponse`.
    ///
    /// <p>Disable the Shield Advanced automatic application layer DDoS mitigation feature for the resource. This stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableApplicationLayerAutomaticResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_application_layer_automatic_response_input::Builder,
    }
    impl DisableApplicationLayerAutomaticResponse {
        /// Creates a new `DisableApplicationLayerAutomaticResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableApplicationLayerAutomaticResponseOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableApplicationLayerAutomaticResponseError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableProactiveEngagement`.
    ///
    /// <p>Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableProactiveEngagement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_proactive_engagement_input::Builder,
    }
    impl DisableProactiveEngagement {
        /// Creates a new `DisableProactiveEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableProactiveEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableProactiveEngagementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateDRTLogBucket`.
    ///
    /// <p>Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDRTLogBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_drt_log_bucket_input::Builder,
    }
    impl DisassociateDRTLogBucket {
        /// Creates a new `DisassociateDRTLogBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDrtLogBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDRTLogBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn log_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn set_log_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDRTRole`.
    ///
    /// <p>Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDRTRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_drt_role_input::Builder,
    }
    impl DisassociateDRTRole {
        /// Creates a new `DisassociateDRTRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDrtRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDRTRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateHealthCheck`.
    ///
    /// <p>Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response. </p>
    /// <p>You define the health check in Route&nbsp;53 and then associate or disassociate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_health_check_input::Builder,
    }
    impl DisassociateHealthCheck {
        /// Creates a new `DisassociateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to remove the health check association from. </p>
        pub fn protection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(input.into());
            self
        }
        /// <p>The unique identifier (ID) for the <code>Protection</code> object to remove the health check association from. </p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>
        pub fn health_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>
        pub fn set_health_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableApplicationLayerAutomaticResponse`.
    ///
    /// <p>Enable the Shield Advanced automatic application layer DDoS mitigation for the resource. </p> <note>
    /// <p>This feature is available for Amazon CloudFront distributions only.</p>
    /// </note>
    /// <p>This causes Shield Advanced to create, verify, and apply WAF rules for DDoS attacks that it detects for the resource. Shield Advanced applies the rules in a Shield rule group inside the web ACL that you've associated with the resource. For information about how automatic mitigation works and the requirements for using it, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-automatic-app-layer-response.html">Shield Advanced automatic application layer DDoS mitigation</a>.</p>
    /// <p>Don't use this action to make changes to automatic mitigation settings when it's already enabled for a resource. Instead, use <code>UpdateApplicationLayerAutomaticResponse</code>.</p>
    /// <p>To use this feature, you must associate a web ACL with the protected resource. The web ACL must be created using the latest version of WAF (v2). You can associate the web ACL through the Shield Advanced console at <a href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with Shield Advanced</a>.</p>
    /// <p>You can also do this through the WAF console or the WAF API, but you must manage Shield Advanced automatic mitigation through Shield Advanced. For information about WAF, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableApplicationLayerAutomaticResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_application_layer_automatic_response_input::Builder,
    }
    impl EnableApplicationLayerAutomaticResponse {
        /// Creates a new `EnableApplicationLayerAutomaticResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableApplicationLayerAutomaticResponseOutput,
            aws_smithy_http::result::SdkError<
                crate::error::EnableApplicationLayerAutomaticResponseError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn action(mut self, input: crate::model::ResponseAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ResponseAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableProactiveEngagement`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableProactiveEngagement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_proactive_engagement_input::Builder,
    }
    impl EnableProactiveEngagement {
        /// Creates a new `EnableProactiveEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableProactiveEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableProactiveEngagementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSubscriptionState`.
    ///
    /// <p>Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSubscriptionState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_subscription_state_input::Builder,
    }
    impl GetSubscriptionState {
        /// Creates a new `GetSubscriptionState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSubscriptionStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSubscriptionStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAttacks`.
    ///
    /// <p>Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttacks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_attacks_input::Builder,
    }
    impl ListAttacks {
        /// Creates a new `ListAttacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttacksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttacksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttacksPaginator {
            crate::paginator::ListAttacksPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs (Amazon Resource Names) of the resources that were attacked. If you leave this blank, all applicable resources for this account will be included.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The ARNs (Amazon Resource Names) of the resources that were attacked. If you leave this blank, all applicable resources for this account will be included.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
        pub fn start_time(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
        pub fn end_time(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The request syntax listing for this call indicates a <code>number</code> type, but you can provide the time in any valid <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp">timestamp format</a> setting. </p>
        pub fn set_end_time(mut self, input: std::option::Option<crate::model::TimeRange>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtectionGroups`.
    ///
    /// <p>Retrieves the <code>ProtectionGroup</code> objects for the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProtectionGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_protection_groups_input::Builder,
    }
    impl ListProtectionGroups {
        /// Creates a new `ListProtectionGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtectionGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtectionGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProtectionGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProtectionGroupsPaginator {
            crate::paginator::ListProtectionGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtections`.
    ///
    /// <p>Lists all <code>Protection</code> objects for the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProtections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_protections_input::Builder,
    }
    impl ListProtections {
        /// Creates a new `ListProtections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProtectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProtectionsPaginator {
            crate::paginator::ListProtectionsPaginator::new(self.handle, self.inner)
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesInProtectionGroup`.
    ///
    /// <p>Retrieves the resources that are included in the protection group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourcesInProtectionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_in_protection_group_input::Builder,
    }
    impl ListResourcesInProtectionGroup {
        /// Creates a new `ListResourcesInProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesInProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesInProtectionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourcesInProtectionGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourcesInProtectionGroupPaginator {
            crate::paginator::ListResourcesInProtectionGroupPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a <code>NextToken</code> value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request. </p>
        /// <p>You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the <code>MaxResults</code> setting. Shield Advanced will not return more than <code>MaxResults</code> objects, but may return fewer, even if more objects are still available.</p>
        /// <p>Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a <code>NextToken</code> value.</p>
        /// <p>On your first call to a list operation, leave this setting empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a <code>NextToken</code> value in the response.</p>
        /// <p>The default setting is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in Shield.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to modify or add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource in Shield.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplicationLayerAutomaticResponse`.
    ///
    /// <p>Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplicationLayerAutomaticResponse {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_application_layer_automatic_response_input::Builder,
    }
    impl UpdateApplicationLayerAutomaticResponse {
        /// Creates a new `UpdateApplicationLayerAutomaticResponse`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationLayerAutomaticResponseOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateApplicationLayerAutomaticResponseError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn action(mut self, input: crate::model::ResponseAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ResponseAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmergencyContactSettings`.
    ///
    /// <p>Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEmergencyContactSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_emergency_contact_settings_input::Builder,
    }
    impl UpdateEmergencyContactSettings {
        /// Creates a new `UpdateEmergencyContactSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmergencyContactSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmergencyContactSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EmergencyContactList`.
        ///
        /// To override the contents of this collection use [`set_emergency_contact_list`](Self::set_emergency_contact_list).
        ///
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>
        pub fn emergency_contact_list(mut self, input: crate::model::EmergencyContact) -> Self {
            self.inner = self.inner.emergency_contact_list(input);
            self
        }
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>
        pub fn set_emergency_contact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EmergencyContact>>,
        ) -> Self {
            self.inner = self.inner.set_emergency_contact_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProtectionGroup`.
    ///
    /// <p>Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProtectionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_protection_group_input::Builder,
    }
    impl UpdateProtectionGroup {
        /// Creates a new `UpdateProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProtectionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn aggregation(mut self, input: crate::model::ProtectionGroupAggregation) -> Self {
            self.inner = self.inner.aggregation(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn set_aggregation(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupAggregation>,
        ) -> Self {
            self.inner = self.inner.set_aggregation(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn pattern(mut self, input: crate::model::ProtectionGroupPattern) -> Self {
            self.inner = self.inner.pattern(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn set_pattern(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPattern>,
        ) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn resource_type(mut self, input: crate::model::ProtectedResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ProtectedResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.members(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubscription`.
    ///
    /// <p>Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_subscription_input::Builder,
    }
    impl UpdateSubscription {
        /// Creates a new `UpdateSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn auto_renew(mut self, input: crate::model::AutoRenew) -> Self {
            self.inner = self.inner.auto_renew(input);
            self
        }
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn set_auto_renew(
            mut self,
            input: std::option::Option<crate::model::AutoRenew>,
        ) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
