// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides information about a particular parameter passed inside a request that resulted in an exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the parameter that failed validation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message describing why the parameter failed validation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the parameter that failed validation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message describing why the parameter failed validation.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter that failed validation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter that failed validation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message describing why the parameter failed validation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message describing why the parameter failed validation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIELD_VALIDATION_FAILED", "OTHER"]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoRenew {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoRenew {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AutoRenew::Disabled,
            "ENABLED" => AutoRenew::Enabled,
            other => AutoRenew::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoRenew {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoRenew::from(s))
    }
}
impl AutoRenew {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoRenew::Disabled => "DISABLED",
            AutoRenew::Enabled => "ENABLED",
            AutoRenew::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for AutoRenew {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtectedResourceType {
    #[allow(missing_docs)] // documentation missing in model
    ApplicationLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    ClassicLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    CloudfrontDistribution,
    #[allow(missing_docs)] // documentation missing in model
    ElasticIpAllocation,
    #[allow(missing_docs)] // documentation missing in model
    GlobalAccelerator,
    #[allow(missing_docs)] // documentation missing in model
    Route53HostedZone,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtectedResourceType {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION_LOAD_BALANCER" => ProtectedResourceType::ApplicationLoadBalancer,
            "CLASSIC_LOAD_BALANCER" => ProtectedResourceType::ClassicLoadBalancer,
            "CLOUDFRONT_DISTRIBUTION" => ProtectedResourceType::CloudfrontDistribution,
            "ELASTIC_IP_ALLOCATION" => ProtectedResourceType::ElasticIpAllocation,
            "GLOBAL_ACCELERATOR" => ProtectedResourceType::GlobalAccelerator,
            "ROUTE_53_HOSTED_ZONE" => ProtectedResourceType::Route53HostedZone,
            other => ProtectedResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtectedResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtectedResourceType::from(s))
    }
}
impl ProtectedResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtectedResourceType::ApplicationLoadBalancer => "APPLICATION_LOAD_BALANCER",
            ProtectedResourceType::ClassicLoadBalancer => "CLASSIC_LOAD_BALANCER",
            ProtectedResourceType::CloudfrontDistribution => "CLOUDFRONT_DISTRIBUTION",
            ProtectedResourceType::ElasticIpAllocation => "ELASTIC_IP_ALLOCATION",
            ProtectedResourceType::GlobalAccelerator => "GLOBAL_ACCELERATOR",
            ProtectedResourceType::Route53HostedZone => "ROUTE_53_HOSTED_ZONE",
            ProtectedResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPLICATION_LOAD_BALANCER",
            "CLASSIC_LOAD_BALANCER",
            "CLOUDFRONT_DISTRIBUTION",
            "ELASTIC_IP_ALLOCATION",
            "GLOBAL_ACCELERATOR",
            "ROUTE_53_HOSTED_ZONE",
        ]
    }
}
impl AsRef<str> for ProtectedResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtectionGroupPattern {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Arbitrary,
    #[allow(missing_docs)] // documentation missing in model
    ByResourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtectionGroupPattern {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ProtectionGroupPattern::All,
            "ARBITRARY" => ProtectionGroupPattern::Arbitrary,
            "BY_RESOURCE_TYPE" => ProtectionGroupPattern::ByResourceType,
            other => ProtectionGroupPattern::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtectionGroupPattern {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtectionGroupPattern::from(s))
    }
}
impl ProtectionGroupPattern {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtectionGroupPattern::All => "ALL",
            ProtectionGroupPattern::Arbitrary => "ARBITRARY",
            ProtectionGroupPattern::ByResourceType => "BY_RESOURCE_TYPE",
            ProtectionGroupPattern::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ARBITRARY", "BY_RESOURCE_TYPE"]
    }
}
impl AsRef<str> for ProtectionGroupPattern {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtectionGroupAggregation {
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Mean,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtectionGroupAggregation {
    fn from(s: &str) -> Self {
        match s {
            "MAX" => ProtectionGroupAggregation::Max,
            "MEAN" => ProtectionGroupAggregation::Mean,
            "SUM" => ProtectionGroupAggregation::Sum,
            other => ProtectionGroupAggregation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtectionGroupAggregation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtectionGroupAggregation::from(s))
    }
}
impl ProtectionGroupAggregation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtectionGroupAggregation::Max => "MAX",
            ProtectionGroupAggregation::Mean => "MEAN",
            ProtectionGroupAggregation::Sum => "SUM",
            ProtectionGroupAggregation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAX", "MEAN", "SUM"]
    }
}
impl AsRef<str> for ProtectionGroupAggregation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contact information that the SRT can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmergencyContact {
    /// <p>The email address for the contact.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The phone number for the contact.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>Additional notes regarding the contact. </p>
    pub contact_notes: std::option::Option<std::string::String>,
}
impl EmergencyContact {
    /// <p>The email address for the contact.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The phone number for the contact.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>Additional notes regarding the contact. </p>
    pub fn contact_notes(&self) -> std::option::Option<&str> {
        self.contact_notes.as_deref()
    }
}
impl std::fmt::Debug for EmergencyContact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmergencyContact");
        formatter.field("email_address", &self.email_address);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("contact_notes", &self.contact_notes);
        formatter.finish()
    }
}
/// See [`EmergencyContact`](crate::model::EmergencyContact)
pub mod emergency_contact {
    /// A builder for [`EmergencyContact`](crate::model::EmergencyContact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) contact_notes: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address for the contact.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address for the contact.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The phone number for the contact.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number for the contact.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>Additional notes regarding the contact. </p>
        pub fn contact_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_notes = Some(input.into());
            self
        }
        /// <p>Additional notes regarding the contact. </p>
        pub fn set_contact_notes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_notes = input;
            self
        }
        /// Consumes the builder and constructs a [`EmergencyContact`](crate::model::EmergencyContact)
        pub fn build(self) -> crate::model::EmergencyContact {
            crate::model::EmergencyContact {
                email_address: self.email_address,
                phone_number: self.phone_number,
                contact_notes: self.contact_notes,
            }
        }
    }
}
impl EmergencyContact {
    /// Creates a new builder-style object to manufacture [`EmergencyContact`](crate::model::EmergencyContact)
    pub fn builder() -> crate::model::emergency_contact::Builder {
        crate::model::emergency_contact::Builder::default()
    }
}

/// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseAction {
    /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action. </p>
    /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
    pub block: std::option::Option<crate::model::BlockAction>,
    /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action. </p>
    /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
    pub count: std::option::Option<crate::model::CountAction>,
}
impl ResponseAction {
    /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action. </p>
    /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
    pub fn block(&self) -> std::option::Option<&crate::model::BlockAction> {
        self.block.as_ref()
    }
    /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action. </p>
    /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
    pub fn count(&self) -> std::option::Option<&crate::model::CountAction> {
        self.count.as_ref()
    }
}
impl std::fmt::Debug for ResponseAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseAction");
        formatter.field("block", &self.block);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`ResponseAction`](crate::model::ResponseAction)
pub mod response_action {
    /// A builder for [`ResponseAction`](crate::model::ResponseAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block: std::option::Option<crate::model::BlockAction>,
        pub(crate) count: std::option::Option<crate::model::CountAction>,
    }
    impl Builder {
        /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action. </p>
        /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
        pub fn block(mut self, input: crate::model::BlockAction) -> Self {
            self.block = Some(input);
            self
        }
        /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action. </p>
        /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
        pub fn set_block(mut self, input: std::option::Option<crate::model::BlockAction>) -> Self {
            self.block = input;
            self
        }
        /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action. </p>
        /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
        pub fn count(mut self, input: crate::model::CountAction) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action. </p>
        /// <p>You must specify exactly one action, either <code>Block</code> or <code>Count</code>.</p>
        pub fn set_count(mut self, input: std::option::Option<crate::model::CountAction>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseAction`](crate::model::ResponseAction)
        pub fn build(self) -> crate::model::ResponseAction {
            crate::model::ResponseAction {
                block: self.block,
                count: self.count,
            }
        }
    }
}
impl ResponseAction {
    /// Creates a new builder-style object to manufacture [`ResponseAction`](crate::model::ResponseAction)
    pub fn builder() -> crate::model::response_action::Builder {
        crate::model::response_action::Builder::default()
    }
}

/// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Count</code> action. </p>
/// <p>This is only used in the context of the <code>ResponseAction</code> setting. </p>
/// <p>JSON specification: <code>"Count": {}</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CountAction {}
impl std::fmt::Debug for CountAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CountAction");
        formatter.finish()
    }
}
/// See [`CountAction`](crate::model::CountAction)
pub mod count_action {
    /// A builder for [`CountAction`](crate::model::CountAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CountAction`](crate::model::CountAction)
        pub fn build(self) -> crate::model::CountAction {
            crate::model::CountAction {}
        }
    }
}
impl CountAction {
    /// Creates a new builder-style object to manufacture [`CountAction`](crate::model::CountAction)
    pub fn builder() -> crate::model::count_action::Builder {
        crate::model::count_action::Builder::default()
    }
}

/// <p>Specifies that Shield Advanced should configure its WAF rules with the WAF <code>Block</code> action. </p>
/// <p>This is only used in the context of the <code>ResponseAction</code> setting. </p>
/// <p>JSON specification: <code>"Block": {}</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockAction {}
impl std::fmt::Debug for BlockAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockAction");
        formatter.finish()
    }
}
/// See [`BlockAction`](crate::model::BlockAction)
pub mod block_action {
    /// A builder for [`BlockAction`](crate::model::BlockAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BlockAction`](crate::model::BlockAction)
        pub fn build(self) -> crate::model::BlockAction {
            crate::model::BlockAction {}
        }
    }
}
impl BlockAction {
    /// Creates a new builder-style object to manufacture [`BlockAction`](crate::model::BlockAction)
    pub fn builder() -> crate::model::block_action::Builder {
        crate::model::block_action::Builder::default()
    }
}

/// <p>A tag associated with an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Part of the key:value pair that defines a tag. You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An object that represents a resource that is under DDoS protection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Protection {
    /// <p>The unique identifier (ID) of the protection.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the protection. For example, <code>My CloudFront distributions</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource that is protected.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier (ID) for the Route&nbsp;53 health check that's associated with the protection. </p>
    pub health_check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN (Amazon Resource Name) of the protection.</p>
    pub protection_arn: std::option::Option<std::string::String>,
    /// <p>The automatic application layer DDoS mitigation settings for the protection. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks. </p>
    pub application_layer_automatic_response_configuration:
        std::option::Option<crate::model::ApplicationLayerAutomaticResponseConfiguration>,
}
impl Protection {
    /// <p>The unique identifier (ID) of the protection.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the protection. For example, <code>My CloudFront distributions</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource that is protected.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The unique identifier (ID) for the Route&nbsp;53 health check that's associated with the protection. </p>
    pub fn health_check_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.health_check_ids.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the protection.</p>
    pub fn protection_arn(&self) -> std::option::Option<&str> {
        self.protection_arn.as_deref()
    }
    /// <p>The automatic application layer DDoS mitigation settings for the protection. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks. </p>
    pub fn application_layer_automatic_response_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationLayerAutomaticResponseConfiguration> {
        self.application_layer_automatic_response_configuration
            .as_ref()
    }
}
impl std::fmt::Debug for Protection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Protection");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("health_check_ids", &self.health_check_ids);
        formatter.field("protection_arn", &self.protection_arn);
        formatter.field(
            "application_layer_automatic_response_configuration",
            &self.application_layer_automatic_response_configuration,
        );
        formatter.finish()
    }
}
/// See [`Protection`](crate::model::Protection)
pub mod protection {
    /// A builder for [`Protection`](crate::model::Protection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) health_check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protection_arn: std::option::Option<std::string::String>,
        pub(crate) application_layer_automatic_response_configuration:
            std::option::Option<crate::model::ApplicationLayerAutomaticResponseConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the protection.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the protection.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the protection. For example, <code>My CloudFront distributions</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the protection. For example, <code>My CloudFront distributions</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource that is protected.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource that is protected.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `health_check_ids`.
        ///
        /// To override the contents of this collection use [`set_health_check_ids`](Self::set_health_check_ids).
        ///
        /// <p>The unique identifier (ID) for the Route&nbsp;53 health check that's associated with the protection. </p>
        pub fn health_check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.health_check_ids.unwrap_or_default();
            v.push(input.into());
            self.health_check_ids = Some(v);
            self
        }
        /// <p>The unique identifier (ID) for the Route&nbsp;53 health check that's associated with the protection. </p>
        pub fn set_health_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.health_check_ids = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the protection.</p>
        pub fn protection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.protection_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the protection.</p>
        pub fn set_protection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.protection_arn = input;
            self
        }
        /// <p>The automatic application layer DDoS mitigation settings for the protection. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks. </p>
        pub fn application_layer_automatic_response_configuration(
            mut self,
            input: crate::model::ApplicationLayerAutomaticResponseConfiguration,
        ) -> Self {
            self.application_layer_automatic_response_configuration = Some(input);
            self
        }
        /// <p>The automatic application layer DDoS mitigation settings for the protection. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks. </p>
        pub fn set_application_layer_automatic_response_configuration(
            mut self,
            input: std::option::Option<
                crate::model::ApplicationLayerAutomaticResponseConfiguration,
            >,
        ) -> Self {
            self.application_layer_automatic_response_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Protection`](crate::model::Protection)
        pub fn build(self) -> crate::model::Protection {
            crate::model::Protection {
                id: self.id,
                name: self.name,
                resource_arn: self.resource_arn,
                health_check_ids: self.health_check_ids,
                protection_arn: self.protection_arn,
                application_layer_automatic_response_configuration: self
                    .application_layer_automatic_response_configuration,
            }
        }
    }
}
impl Protection {
    /// Creates a new builder-style object to manufacture [`Protection`](crate::model::Protection)
    pub fn builder() -> crate::model::protection::Builder {
        crate::model::protection::Builder::default()
    }
}

/// <p>The automatic application layer DDoS mitigation settings for a <code>Protection</code>. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationLayerAutomaticResponseConfiguration {
    /// <p>Indicates whether automatic application layer DDoS mitigation is enabled for the protection. </p>
    pub status: std::option::Option<crate::model::ApplicationLayerAutomaticResponseStatus>,
    /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
    pub action: std::option::Option<crate::model::ResponseAction>,
}
impl ApplicationLayerAutomaticResponseConfiguration {
    /// <p>Indicates whether automatic application layer DDoS mitigation is enabled for the protection. </p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationLayerAutomaticResponseStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
    pub fn action(&self) -> std::option::Option<&crate::model::ResponseAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for ApplicationLayerAutomaticResponseConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationLayerAutomaticResponseConfiguration");
        formatter.field("status", &self.status);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`ApplicationLayerAutomaticResponseConfiguration`](crate::model::ApplicationLayerAutomaticResponseConfiguration)
pub mod application_layer_automatic_response_configuration {
    /// A builder for [`ApplicationLayerAutomaticResponseConfiguration`](crate::model::ApplicationLayerAutomaticResponseConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status:
            std::option::Option<crate::model::ApplicationLayerAutomaticResponseStatus>,
        pub(crate) action: std::option::Option<crate::model::ResponseAction>,
    }
    impl Builder {
        /// <p>Indicates whether automatic application layer DDoS mitigation is enabled for the protection. </p>
        pub fn status(
            mut self,
            input: crate::model::ApplicationLayerAutomaticResponseStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates whether automatic application layer DDoS mitigation is enabled for the protection. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApplicationLayerAutomaticResponseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn action(mut self, input: crate::model::ResponseAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource. </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ResponseAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationLayerAutomaticResponseConfiguration`](crate::model::ApplicationLayerAutomaticResponseConfiguration)
        pub fn build(self) -> crate::model::ApplicationLayerAutomaticResponseConfiguration {
            crate::model::ApplicationLayerAutomaticResponseConfiguration {
                status: self.status,
                action: self.action,
            }
        }
    }
}
impl ApplicationLayerAutomaticResponseConfiguration {
    /// Creates a new builder-style object to manufacture [`ApplicationLayerAutomaticResponseConfiguration`](crate::model::ApplicationLayerAutomaticResponseConfiguration)
    pub fn builder() -> crate::model::application_layer_automatic_response_configuration::Builder {
        crate::model::application_layer_automatic_response_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplicationLayerAutomaticResponseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplicationLayerAutomaticResponseStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ApplicationLayerAutomaticResponseStatus::Disabled,
            "ENABLED" => ApplicationLayerAutomaticResponseStatus::Enabled,
            other => ApplicationLayerAutomaticResponseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplicationLayerAutomaticResponseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplicationLayerAutomaticResponseStatus::from(s))
    }
}
impl ApplicationLayerAutomaticResponseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplicationLayerAutomaticResponseStatus::Disabled => "DISABLED",
            ApplicationLayerAutomaticResponseStatus::Enabled => "ENABLED",
            ApplicationLayerAutomaticResponseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ApplicationLayerAutomaticResponseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A grouping of protected resources that you and Shield Advanced can monitor as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectionGroup {
    /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    pub protection_group_id: std::option::Option<std::string::String>,
    /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
    /// <ul>
    /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
    /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
    /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
    /// </ul>
    pub aggregation: std::option::Option<crate::model::ProtectionGroupAggregation>,
    /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
    pub pattern: std::option::Option<crate::model::ProtectionGroupPattern>,
    /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    pub resource_type: std::option::Option<crate::model::ProtectedResourceType>,
    /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    pub members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARN (Amazon Resource Name) of the protection group.</p>
    pub protection_group_arn: std::option::Option<std::string::String>,
}
impl ProtectionGroup {
    /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
    pub fn protection_group_id(&self) -> std::option::Option<&str> {
        self.protection_group_id.as_deref()
    }
    /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
    /// <ul>
    /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
    /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
    /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
    /// </ul>
    pub fn aggregation(&self) -> std::option::Option<&crate::model::ProtectionGroupAggregation> {
        self.aggregation.as_ref()
    }
    /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
    pub fn pattern(&self) -> std::option::Option<&crate::model::ProtectionGroupPattern> {
        self.pattern.as_ref()
    }
    /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ProtectedResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
    pub fn members(&self) -> std::option::Option<&[std::string::String]> {
        self.members.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the protection group.</p>
    pub fn protection_group_arn(&self) -> std::option::Option<&str> {
        self.protection_group_arn.as_deref()
    }
}
impl std::fmt::Debug for ProtectionGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectionGroup");
        formatter.field("protection_group_id", &self.protection_group_id);
        formatter.field("aggregation", &self.aggregation);
        formatter.field("pattern", &self.pattern);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("members", &self.members);
        formatter.field("protection_group_arn", &self.protection_group_arn);
        formatter.finish()
    }
}
/// See [`ProtectionGroup`](crate::model::ProtectionGroup)
pub mod protection_group {
    /// A builder for [`ProtectionGroup`](crate::model::ProtectionGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protection_group_id: std::option::Option<std::string::String>,
        pub(crate) aggregation: std::option::Option<crate::model::ProtectionGroupAggregation>,
        pub(crate) pattern: std::option::Option<crate::model::ProtectionGroupPattern>,
        pub(crate) resource_type: std::option::Option<crate::model::ProtectedResourceType>,
        pub(crate) members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protection_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.protection_group_id = Some(input.into());
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.protection_group_id = input;
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn aggregation(mut self, input: crate::model::ProtectionGroupAggregation) -> Self {
            self.aggregation = Some(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li> <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p> </li>
        /// <li> <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p> </li>
        /// <li> <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p> </li>
        /// </ul>
        pub fn set_aggregation(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupAggregation>,
        ) -> Self {
            self.aggregation = input;
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn pattern(mut self, input: crate::model::ProtectionGroupPattern) -> Self {
            self.pattern = Some(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn set_pattern(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPattern>,
        ) -> Self {
            self.pattern = input;
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn resource_type(mut self, input: crate::model::ProtectedResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ProtectedResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input.into());
            self.members = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the protection group.</p>
        pub fn protection_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.protection_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the protection group.</p>
        pub fn set_protection_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.protection_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectionGroup`](crate::model::ProtectionGroup)
        pub fn build(self) -> crate::model::ProtectionGroup {
            crate::model::ProtectionGroup {
                protection_group_id: self.protection_group_id,
                aggregation: self.aggregation,
                pattern: self.pattern,
                resource_type: self.resource_type,
                members: self.members,
                protection_group_arn: self.protection_group_arn,
            }
        }
    }
}
impl ProtectionGroup {
    /// Creates a new builder-style object to manufacture [`ProtectionGroup`](crate::model::ProtectionGroup)
    pub fn builder() -> crate::model::protection_group::Builder {
        crate::model::protection_group::Builder::default()
    }
}

/// <p>Summarizes all DDoS attacks for a specified time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackSummary {
    /// <p>The unique identifier (ID) of the attack.</p>
    pub attack_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The start time of the attack, in Unix time in seconds. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time of the attack, in Unix time in seconds. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of attacks for a specified time period.</p>
    pub attack_vectors: std::option::Option<std::vec::Vec<crate::model::AttackVectorDescription>>,
}
impl AttackSummary {
    /// <p>The unique identifier (ID) of the attack.</p>
    pub fn attack_id(&self) -> std::option::Option<&str> {
        self.attack_id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The start time of the attack, in Unix time in seconds. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the attack, in Unix time in seconds. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The list of attacks for a specified time period.</p>
    pub fn attack_vectors(&self) -> std::option::Option<&[crate::model::AttackVectorDescription]> {
        self.attack_vectors.as_deref()
    }
}
impl std::fmt::Debug for AttackSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackSummary");
        formatter.field("attack_id", &self.attack_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("attack_vectors", &self.attack_vectors);
        formatter.finish()
    }
}
/// See [`AttackSummary`](crate::model::AttackSummary)
pub mod attack_summary {
    /// A builder for [`AttackSummary`](crate::model::AttackSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attack_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) attack_vectors:
            std::option::Option<std::vec::Vec<crate::model::AttackVectorDescription>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the attack.</p>
        pub fn attack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attack_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the attack.</p>
        pub fn set_attack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attack_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The start time of the attack, in Unix time in seconds. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the attack, in Unix time in seconds. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the attack, in Unix time in seconds. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the attack, in Unix time in seconds. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `attack_vectors`.
        ///
        /// To override the contents of this collection use [`set_attack_vectors`](Self::set_attack_vectors).
        ///
        /// <p>The list of attacks for a specified time period.</p>
        pub fn attack_vectors(mut self, input: crate::model::AttackVectorDescription) -> Self {
            let mut v = self.attack_vectors.unwrap_or_default();
            v.push(input);
            self.attack_vectors = Some(v);
            self
        }
        /// <p>The list of attacks for a specified time period.</p>
        pub fn set_attack_vectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttackVectorDescription>>,
        ) -> Self {
            self.attack_vectors = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackSummary`](crate::model::AttackSummary)
        pub fn build(self) -> crate::model::AttackSummary {
            crate::model::AttackSummary {
                attack_id: self.attack_id,
                resource_arn: self.resource_arn,
                start_time: self.start_time,
                end_time: self.end_time,
                attack_vectors: self.attack_vectors,
            }
        }
    }
}
impl AttackSummary {
    /// Creates a new builder-style object to manufacture [`AttackSummary`](crate::model::AttackSummary)
    pub fn builder() -> crate::model::attack_summary::Builder {
        crate::model::attack_summary::Builder::default()
    }
}

/// <p>Describes the attack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackVectorDescription {
    /// <p>The attack type. Valid values:</p>
    /// <ul>
    /// <li> <p>UDP_TRAFFIC</p> </li>
    /// <li> <p>UDP_FRAGMENT</p> </li>
    /// <li> <p>GENERIC_UDP_REFLECTION</p> </li>
    /// <li> <p>DNS_REFLECTION</p> </li>
    /// <li> <p>NTP_REFLECTION</p> </li>
    /// <li> <p>CHARGEN_REFLECTION</p> </li>
    /// <li> <p>SSDP_REFLECTION</p> </li>
    /// <li> <p>PORT_MAPPER</p> </li>
    /// <li> <p>RIP_REFLECTION</p> </li>
    /// <li> <p>SNMP_REFLECTION</p> </li>
    /// <li> <p>MSSQL_REFLECTION</p> </li>
    /// <li> <p>NET_BIOS_REFLECTION</p> </li>
    /// <li> <p>SYN_FLOOD</p> </li>
    /// <li> <p>ACK_FLOOD</p> </li>
    /// <li> <p>REQUEST_FLOOD</p> </li>
    /// <li> <p>HTTP_REFLECTION</p> </li>
    /// <li> <p>UDS_REFLECTION</p> </li>
    /// <li> <p>MEMCACHED_REFLECTION</p> </li>
    /// </ul>
    pub vector_type: std::option::Option<std::string::String>,
}
impl AttackVectorDescription {
    /// <p>The attack type. Valid values:</p>
    /// <ul>
    /// <li> <p>UDP_TRAFFIC</p> </li>
    /// <li> <p>UDP_FRAGMENT</p> </li>
    /// <li> <p>GENERIC_UDP_REFLECTION</p> </li>
    /// <li> <p>DNS_REFLECTION</p> </li>
    /// <li> <p>NTP_REFLECTION</p> </li>
    /// <li> <p>CHARGEN_REFLECTION</p> </li>
    /// <li> <p>SSDP_REFLECTION</p> </li>
    /// <li> <p>PORT_MAPPER</p> </li>
    /// <li> <p>RIP_REFLECTION</p> </li>
    /// <li> <p>SNMP_REFLECTION</p> </li>
    /// <li> <p>MSSQL_REFLECTION</p> </li>
    /// <li> <p>NET_BIOS_REFLECTION</p> </li>
    /// <li> <p>SYN_FLOOD</p> </li>
    /// <li> <p>ACK_FLOOD</p> </li>
    /// <li> <p>REQUEST_FLOOD</p> </li>
    /// <li> <p>HTTP_REFLECTION</p> </li>
    /// <li> <p>UDS_REFLECTION</p> </li>
    /// <li> <p>MEMCACHED_REFLECTION</p> </li>
    /// </ul>
    pub fn vector_type(&self) -> std::option::Option<&str> {
        self.vector_type.as_deref()
    }
}
impl std::fmt::Debug for AttackVectorDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackVectorDescription");
        formatter.field("vector_type", &self.vector_type);
        formatter.finish()
    }
}
/// See [`AttackVectorDescription`](crate::model::AttackVectorDescription)
pub mod attack_vector_description {
    /// A builder for [`AttackVectorDescription`](crate::model::AttackVectorDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vector_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attack type. Valid values:</p>
        /// <ul>
        /// <li> <p>UDP_TRAFFIC</p> </li>
        /// <li> <p>UDP_FRAGMENT</p> </li>
        /// <li> <p>GENERIC_UDP_REFLECTION</p> </li>
        /// <li> <p>DNS_REFLECTION</p> </li>
        /// <li> <p>NTP_REFLECTION</p> </li>
        /// <li> <p>CHARGEN_REFLECTION</p> </li>
        /// <li> <p>SSDP_REFLECTION</p> </li>
        /// <li> <p>PORT_MAPPER</p> </li>
        /// <li> <p>RIP_REFLECTION</p> </li>
        /// <li> <p>SNMP_REFLECTION</p> </li>
        /// <li> <p>MSSQL_REFLECTION</p> </li>
        /// <li> <p>NET_BIOS_REFLECTION</p> </li>
        /// <li> <p>SYN_FLOOD</p> </li>
        /// <li> <p>ACK_FLOOD</p> </li>
        /// <li> <p>REQUEST_FLOOD</p> </li>
        /// <li> <p>HTTP_REFLECTION</p> </li>
        /// <li> <p>UDS_REFLECTION</p> </li>
        /// <li> <p>MEMCACHED_REFLECTION</p> </li>
        /// </ul>
        pub fn vector_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.vector_type = Some(input.into());
            self
        }
        /// <p>The attack type. Valid values:</p>
        /// <ul>
        /// <li> <p>UDP_TRAFFIC</p> </li>
        /// <li> <p>UDP_FRAGMENT</p> </li>
        /// <li> <p>GENERIC_UDP_REFLECTION</p> </li>
        /// <li> <p>DNS_REFLECTION</p> </li>
        /// <li> <p>NTP_REFLECTION</p> </li>
        /// <li> <p>CHARGEN_REFLECTION</p> </li>
        /// <li> <p>SSDP_REFLECTION</p> </li>
        /// <li> <p>PORT_MAPPER</p> </li>
        /// <li> <p>RIP_REFLECTION</p> </li>
        /// <li> <p>SNMP_REFLECTION</p> </li>
        /// <li> <p>MSSQL_REFLECTION</p> </li>
        /// <li> <p>NET_BIOS_REFLECTION</p> </li>
        /// <li> <p>SYN_FLOOD</p> </li>
        /// <li> <p>ACK_FLOOD</p> </li>
        /// <li> <p>REQUEST_FLOOD</p> </li>
        /// <li> <p>HTTP_REFLECTION</p> </li>
        /// <li> <p>UDS_REFLECTION</p> </li>
        /// <li> <p>MEMCACHED_REFLECTION</p> </li>
        /// </ul>
        pub fn set_vector_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vector_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackVectorDescription`](crate::model::AttackVectorDescription)
        pub fn build(self) -> crate::model::AttackVectorDescription {
            crate::model::AttackVectorDescription {
                vector_type: self.vector_type,
            }
        }
    }
}
impl AttackVectorDescription {
    /// Creates a new builder-style object to manufacture [`AttackVectorDescription`](crate::model::AttackVectorDescription)
    pub fn builder() -> crate::model::attack_vector_description::Builder {
        crate::model::attack_vector_description::Builder::default()
    }
}

/// <p>The time range. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRange {
    /// <p>The start time, in Unix time in seconds. </p>
    pub from_inclusive: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time, in Unix time in seconds. </p>
    pub to_exclusive: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeRange {
    /// <p>The start time, in Unix time in seconds. </p>
    pub fn from_inclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.from_inclusive.as_ref()
    }
    /// <p>The end time, in Unix time in seconds. </p>
    pub fn to_exclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.to_exclusive.as_ref()
    }
}
impl std::fmt::Debug for TimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRange");
        formatter.field("from_inclusive", &self.from_inclusive);
        formatter.field("to_exclusive", &self.to_exclusive);
        formatter.finish()
    }
}
/// See [`TimeRange`](crate::model::TimeRange)
pub mod time_range {
    /// A builder for [`TimeRange`](crate::model::TimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_inclusive: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) to_exclusive: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The start time, in Unix time in seconds. </p>
        pub fn from_inclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.from_inclusive = Some(input);
            self
        }
        /// <p>The start time, in Unix time in seconds. </p>
        pub fn set_from_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.from_inclusive = input;
            self
        }
        /// <p>The end time, in Unix time in seconds. </p>
        pub fn to_exclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.to_exclusive = Some(input);
            self
        }
        /// <p>The end time, in Unix time in seconds. </p>
        pub fn set_to_exclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.to_exclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRange`](crate::model::TimeRange)
        pub fn build(self) -> crate::model::TimeRange {
            crate::model::TimeRange {
                from_inclusive: self.from_inclusive,
                to_exclusive: self.to_exclusive,
            }
        }
    }
}
impl TimeRange {
    /// Creates a new builder-style object to manufacture [`TimeRange`](crate::model::TimeRange)
    pub fn builder() -> crate::model::time_range::Builder {
        crate::model::time_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriptionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriptionState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => SubscriptionState::Active,
            "INACTIVE" => SubscriptionState::Inactive,
            other => SubscriptionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriptionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriptionState::from(s))
    }
}
impl SubscriptionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriptionState::Active => "ACTIVE",
            SubscriptionState::Inactive => "INACTIVE",
            SubscriptionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for SubscriptionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the Shield Advanced subscription for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscription {
    /// <p>The start time of the subscription, in Unix time in seconds. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time your subscription will end.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The length, in seconds, of the Shield Advanced subscription for the account.</p>
    pub time_commitment_in_seconds: i64,
    /// <p>If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period.</p>
    /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
    pub auto_renew: std::option::Option<crate::model::AutoRenew>,
    /// <p>Specifies how many protections of a given type you can create.</p>
    pub limits: std::option::Option<std::vec::Vec<crate::model::Limit>>,
    /// <p>If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    /// <p>If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes to <code>ENABLED</code> when your request is fully processed.</p>
    /// <p>If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support. </p>
    pub proactive_engagement_status: std::option::Option<crate::model::ProactiveEngagementStatus>,
    /// <p>Limits settings for your subscription. </p>
    pub subscription_limits: std::option::Option<crate::model::SubscriptionLimits>,
    /// <p>The ARN (Amazon Resource Name) of the subscription.</p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl Subscription {
    /// <p>The start time of the subscription, in Unix time in seconds. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time your subscription will end.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The length, in seconds, of the Shield Advanced subscription for the account.</p>
    pub fn time_commitment_in_seconds(&self) -> i64 {
        self.time_commitment_in_seconds
    }
    /// <p>If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period.</p>
    /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
    pub fn auto_renew(&self) -> std::option::Option<&crate::model::AutoRenew> {
        self.auto_renew.as_ref()
    }
    /// <p>Specifies how many protections of a given type you can create.</p>
    pub fn limits(&self) -> std::option::Option<&[crate::model::Limit]> {
        self.limits.as_deref()
    }
    /// <p>If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    /// <p>If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes to <code>ENABLED</code> when your request is fully processed.</p>
    /// <p>If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support. </p>
    pub fn proactive_engagement_status(
        &self,
    ) -> std::option::Option<&crate::model::ProactiveEngagementStatus> {
        self.proactive_engagement_status.as_ref()
    }
    /// <p>Limits settings for your subscription. </p>
    pub fn subscription_limits(&self) -> std::option::Option<&crate::model::SubscriptionLimits> {
        self.subscription_limits.as_ref()
    }
    /// <p>The ARN (Amazon Resource Name) of the subscription.</p>
    pub fn subscription_arn(&self) -> std::option::Option<&str> {
        self.subscription_arn.as_deref()
    }
}
impl std::fmt::Debug for Subscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscription");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field(
            "time_commitment_in_seconds",
            &self.time_commitment_in_seconds,
        );
        formatter.field("auto_renew", &self.auto_renew);
        formatter.field("limits", &self.limits);
        formatter.field(
            "proactive_engagement_status",
            &self.proactive_engagement_status,
        );
        formatter.field("subscription_limits", &self.subscription_limits);
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}
/// See [`Subscription`](crate::model::Subscription)
pub mod subscription {
    /// A builder for [`Subscription`](crate::model::Subscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_commitment_in_seconds: std::option::Option<i64>,
        pub(crate) auto_renew: std::option::Option<crate::model::AutoRenew>,
        pub(crate) limits: std::option::Option<std::vec::Vec<crate::model::Limit>>,
        pub(crate) proactive_engagement_status:
            std::option::Option<crate::model::ProactiveEngagementStatus>,
        pub(crate) subscription_limits: std::option::Option<crate::model::SubscriptionLimits>,
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start time of the subscription, in Unix time in seconds. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the subscription, in Unix time in seconds. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time your subscription will end.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time your subscription will end.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The length, in seconds, of the Shield Advanced subscription for the account.</p>
        pub fn time_commitment_in_seconds(mut self, input: i64) -> Self {
            self.time_commitment_in_seconds = Some(input);
            self
        }
        /// <p>The length, in seconds, of the Shield Advanced subscription for the account.</p>
        pub fn set_time_commitment_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.time_commitment_in_seconds = input;
            self
        }
        /// <p>If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period.</p>
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn auto_renew(mut self, input: crate::model::AutoRenew) -> Self {
            self.auto_renew = Some(input);
            self
        }
        /// <p>If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period.</p>
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn set_auto_renew(
            mut self,
            input: std::option::Option<crate::model::AutoRenew>,
        ) -> Self {
            self.auto_renew = input;
            self
        }
        /// Appends an item to `limits`.
        ///
        /// To override the contents of this collection use [`set_limits`](Self::set_limits).
        ///
        /// <p>Specifies how many protections of a given type you can create.</p>
        pub fn limits(mut self, input: crate::model::Limit) -> Self {
            let mut v = self.limits.unwrap_or_default();
            v.push(input);
            self.limits = Some(v);
            self
        }
        /// <p>Specifies how many protections of a given type you can create.</p>
        pub fn set_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Limit>>,
        ) -> Self {
            self.limits = input;
            self
        }
        /// <p>If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes to <code>ENABLED</code> when your request is fully processed.</p>
        /// <p>If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support. </p>
        pub fn proactive_engagement_status(
            mut self,
            input: crate::model::ProactiveEngagementStatus,
        ) -> Self {
            self.proactive_engagement_status = Some(input);
            self
        }
        /// <p>If <code>ENABLED</code>, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If <code>PENDING</code>, you have requested proactive engagement and the request is pending. The status changes to <code>ENABLED</code> when your request is fully processed.</p>
        /// <p>If <code>DISABLED</code>, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support. </p>
        pub fn set_proactive_engagement_status(
            mut self,
            input: std::option::Option<crate::model::ProactiveEngagementStatus>,
        ) -> Self {
            self.proactive_engagement_status = input;
            self
        }
        /// <p>Limits settings for your subscription. </p>
        pub fn subscription_limits(mut self, input: crate::model::SubscriptionLimits) -> Self {
            self.subscription_limits = Some(input);
            self
        }
        /// <p>Limits settings for your subscription. </p>
        pub fn set_subscription_limits(
            mut self,
            input: std::option::Option<crate::model::SubscriptionLimits>,
        ) -> Self {
            self.subscription_limits = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the subscription.</p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the subscription.</p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscription`](crate::model::Subscription)
        pub fn build(self) -> crate::model::Subscription {
            crate::model::Subscription {
                start_time: self.start_time,
                end_time: self.end_time,
                time_commitment_in_seconds: self.time_commitment_in_seconds.unwrap_or_default(),
                auto_renew: self.auto_renew,
                limits: self.limits,
                proactive_engagement_status: self.proactive_engagement_status,
                subscription_limits: self.subscription_limits,
                subscription_arn: self.subscription_arn,
            }
        }
    }
}
impl Subscription {
    /// Creates a new builder-style object to manufacture [`Subscription`](crate::model::Subscription)
    pub fn builder() -> crate::model::subscription::Builder {
        crate::model::subscription::Builder::default()
    }
}

/// <p>Limits settings for your subscription. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionLimits {
    /// <p>Limits settings on protections for your subscription. </p>
    pub protection_limits: std::option::Option<crate::model::ProtectionLimits>,
    /// <p>Limits settings on protection groups for your subscription. </p>
    pub protection_group_limits: std::option::Option<crate::model::ProtectionGroupLimits>,
}
impl SubscriptionLimits {
    /// <p>Limits settings on protections for your subscription. </p>
    pub fn protection_limits(&self) -> std::option::Option<&crate::model::ProtectionLimits> {
        self.protection_limits.as_ref()
    }
    /// <p>Limits settings on protection groups for your subscription. </p>
    pub fn protection_group_limits(
        &self,
    ) -> std::option::Option<&crate::model::ProtectionGroupLimits> {
        self.protection_group_limits.as_ref()
    }
}
impl std::fmt::Debug for SubscriptionLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionLimits");
        formatter.field("protection_limits", &self.protection_limits);
        formatter.field("protection_group_limits", &self.protection_group_limits);
        formatter.finish()
    }
}
/// See [`SubscriptionLimits`](crate::model::SubscriptionLimits)
pub mod subscription_limits {
    /// A builder for [`SubscriptionLimits`](crate::model::SubscriptionLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protection_limits: std::option::Option<crate::model::ProtectionLimits>,
        pub(crate) protection_group_limits:
            std::option::Option<crate::model::ProtectionGroupLimits>,
    }
    impl Builder {
        /// <p>Limits settings on protections for your subscription. </p>
        pub fn protection_limits(mut self, input: crate::model::ProtectionLimits) -> Self {
            self.protection_limits = Some(input);
            self
        }
        /// <p>Limits settings on protections for your subscription. </p>
        pub fn set_protection_limits(
            mut self,
            input: std::option::Option<crate::model::ProtectionLimits>,
        ) -> Self {
            self.protection_limits = input;
            self
        }
        /// <p>Limits settings on protection groups for your subscription. </p>
        pub fn protection_group_limits(
            mut self,
            input: crate::model::ProtectionGroupLimits,
        ) -> Self {
            self.protection_group_limits = Some(input);
            self
        }
        /// <p>Limits settings on protection groups for your subscription. </p>
        pub fn set_protection_group_limits(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupLimits>,
        ) -> Self {
            self.protection_group_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionLimits`](crate::model::SubscriptionLimits)
        pub fn build(self) -> crate::model::SubscriptionLimits {
            crate::model::SubscriptionLimits {
                protection_limits: self.protection_limits,
                protection_group_limits: self.protection_group_limits,
            }
        }
    }
}
impl SubscriptionLimits {
    /// Creates a new builder-style object to manufacture [`SubscriptionLimits`](crate::model::SubscriptionLimits)
    pub fn builder() -> crate::model::subscription_limits::Builder {
        crate::model::subscription_limits::Builder::default()
    }
}

/// <p>Limits settings on protection groups for your subscription. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectionGroupLimits {
    /// <p>The maximum number of protection groups that you can have at one time. </p>
    pub max_protection_groups: i64,
    /// <p>Limits settings by pattern type in the protection groups for your subscription. </p>
    pub pattern_type_limits: std::option::Option<crate::model::ProtectionGroupPatternTypeLimits>,
}
impl ProtectionGroupLimits {
    /// <p>The maximum number of protection groups that you can have at one time. </p>
    pub fn max_protection_groups(&self) -> i64 {
        self.max_protection_groups
    }
    /// <p>Limits settings by pattern type in the protection groups for your subscription. </p>
    pub fn pattern_type_limits(
        &self,
    ) -> std::option::Option<&crate::model::ProtectionGroupPatternTypeLimits> {
        self.pattern_type_limits.as_ref()
    }
}
impl std::fmt::Debug for ProtectionGroupLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectionGroupLimits");
        formatter.field("max_protection_groups", &self.max_protection_groups);
        formatter.field("pattern_type_limits", &self.pattern_type_limits);
        formatter.finish()
    }
}
/// See [`ProtectionGroupLimits`](crate::model::ProtectionGroupLimits)
pub mod protection_group_limits {
    /// A builder for [`ProtectionGroupLimits`](crate::model::ProtectionGroupLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_protection_groups: std::option::Option<i64>,
        pub(crate) pattern_type_limits:
            std::option::Option<crate::model::ProtectionGroupPatternTypeLimits>,
    }
    impl Builder {
        /// <p>The maximum number of protection groups that you can have at one time. </p>
        pub fn max_protection_groups(mut self, input: i64) -> Self {
            self.max_protection_groups = Some(input);
            self
        }
        /// <p>The maximum number of protection groups that you can have at one time. </p>
        pub fn set_max_protection_groups(mut self, input: std::option::Option<i64>) -> Self {
            self.max_protection_groups = input;
            self
        }
        /// <p>Limits settings by pattern type in the protection groups for your subscription. </p>
        pub fn pattern_type_limits(
            mut self,
            input: crate::model::ProtectionGroupPatternTypeLimits,
        ) -> Self {
            self.pattern_type_limits = Some(input);
            self
        }
        /// <p>Limits settings by pattern type in the protection groups for your subscription. </p>
        pub fn set_pattern_type_limits(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPatternTypeLimits>,
        ) -> Self {
            self.pattern_type_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectionGroupLimits`](crate::model::ProtectionGroupLimits)
        pub fn build(self) -> crate::model::ProtectionGroupLimits {
            crate::model::ProtectionGroupLimits {
                max_protection_groups: self.max_protection_groups.unwrap_or_default(),
                pattern_type_limits: self.pattern_type_limits,
            }
        }
    }
}
impl ProtectionGroupLimits {
    /// Creates a new builder-style object to manufacture [`ProtectionGroupLimits`](crate::model::ProtectionGroupLimits)
    pub fn builder() -> crate::model::protection_group_limits::Builder {
        crate::model::protection_group_limits::Builder::default()
    }
}

/// <p>Limits settings by pattern type in the protection groups for your subscription. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectionGroupPatternTypeLimits {
    /// <p>Limits settings on protection groups with arbitrary pattern type. </p>
    pub arbitrary_pattern_limits:
        std::option::Option<crate::model::ProtectionGroupArbitraryPatternLimits>,
}
impl ProtectionGroupPatternTypeLimits {
    /// <p>Limits settings on protection groups with arbitrary pattern type. </p>
    pub fn arbitrary_pattern_limits(
        &self,
    ) -> std::option::Option<&crate::model::ProtectionGroupArbitraryPatternLimits> {
        self.arbitrary_pattern_limits.as_ref()
    }
}
impl std::fmt::Debug for ProtectionGroupPatternTypeLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectionGroupPatternTypeLimits");
        formatter.field("arbitrary_pattern_limits", &self.arbitrary_pattern_limits);
        formatter.finish()
    }
}
/// See [`ProtectionGroupPatternTypeLimits`](crate::model::ProtectionGroupPatternTypeLimits)
pub mod protection_group_pattern_type_limits {
    /// A builder for [`ProtectionGroupPatternTypeLimits`](crate::model::ProtectionGroupPatternTypeLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arbitrary_pattern_limits:
            std::option::Option<crate::model::ProtectionGroupArbitraryPatternLimits>,
    }
    impl Builder {
        /// <p>Limits settings on protection groups with arbitrary pattern type. </p>
        pub fn arbitrary_pattern_limits(
            mut self,
            input: crate::model::ProtectionGroupArbitraryPatternLimits,
        ) -> Self {
            self.arbitrary_pattern_limits = Some(input);
            self
        }
        /// <p>Limits settings on protection groups with arbitrary pattern type. </p>
        pub fn set_arbitrary_pattern_limits(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupArbitraryPatternLimits>,
        ) -> Self {
            self.arbitrary_pattern_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectionGroupPatternTypeLimits`](crate::model::ProtectionGroupPatternTypeLimits)
        pub fn build(self) -> crate::model::ProtectionGroupPatternTypeLimits {
            crate::model::ProtectionGroupPatternTypeLimits {
                arbitrary_pattern_limits: self.arbitrary_pattern_limits,
            }
        }
    }
}
impl ProtectionGroupPatternTypeLimits {
    /// Creates a new builder-style object to manufacture [`ProtectionGroupPatternTypeLimits`](crate::model::ProtectionGroupPatternTypeLimits)
    pub fn builder() -> crate::model::protection_group_pattern_type_limits::Builder {
        crate::model::protection_group_pattern_type_limits::Builder::default()
    }
}

/// <p>Limits settings on protection groups with arbitrary pattern type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectionGroupArbitraryPatternLimits {
    /// <p>The maximum number of resources you can specify for a single arbitrary pattern in a protection group.</p>
    pub max_members: i64,
}
impl ProtectionGroupArbitraryPatternLimits {
    /// <p>The maximum number of resources you can specify for a single arbitrary pattern in a protection group.</p>
    pub fn max_members(&self) -> i64 {
        self.max_members
    }
}
impl std::fmt::Debug for ProtectionGroupArbitraryPatternLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectionGroupArbitraryPatternLimits");
        formatter.field("max_members", &self.max_members);
        formatter.finish()
    }
}
/// See [`ProtectionGroupArbitraryPatternLimits`](crate::model::ProtectionGroupArbitraryPatternLimits)
pub mod protection_group_arbitrary_pattern_limits {
    /// A builder for [`ProtectionGroupArbitraryPatternLimits`](crate::model::ProtectionGroupArbitraryPatternLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_members: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The maximum number of resources you can specify for a single arbitrary pattern in a protection group.</p>
        pub fn max_members(mut self, input: i64) -> Self {
            self.max_members = Some(input);
            self
        }
        /// <p>The maximum number of resources you can specify for a single arbitrary pattern in a protection group.</p>
        pub fn set_max_members(mut self, input: std::option::Option<i64>) -> Self {
            self.max_members = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectionGroupArbitraryPatternLimits`](crate::model::ProtectionGroupArbitraryPatternLimits)
        pub fn build(self) -> crate::model::ProtectionGroupArbitraryPatternLimits {
            crate::model::ProtectionGroupArbitraryPatternLimits {
                max_members: self.max_members.unwrap_or_default(),
            }
        }
    }
}
impl ProtectionGroupArbitraryPatternLimits {
    /// Creates a new builder-style object to manufacture [`ProtectionGroupArbitraryPatternLimits`](crate::model::ProtectionGroupArbitraryPatternLimits)
    pub fn builder() -> crate::model::protection_group_arbitrary_pattern_limits::Builder {
        crate::model::protection_group_arbitrary_pattern_limits::Builder::default()
    }
}

/// <p>Limits settings on protections for your subscription. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectionLimits {
    /// <p>The maximum number of resource types that you can specify in a protection.</p>
    pub protected_resource_type_limits: std::option::Option<std::vec::Vec<crate::model::Limit>>,
}
impl ProtectionLimits {
    /// <p>The maximum number of resource types that you can specify in a protection.</p>
    pub fn protected_resource_type_limits(&self) -> std::option::Option<&[crate::model::Limit]> {
        self.protected_resource_type_limits.as_deref()
    }
}
impl std::fmt::Debug for ProtectionLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectionLimits");
        formatter.field(
            "protected_resource_type_limits",
            &self.protected_resource_type_limits,
        );
        formatter.finish()
    }
}
/// See [`ProtectionLimits`](crate::model::ProtectionLimits)
pub mod protection_limits {
    /// A builder for [`ProtectionLimits`](crate::model::ProtectionLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protected_resource_type_limits:
            std::option::Option<std::vec::Vec<crate::model::Limit>>,
    }
    impl Builder {
        /// Appends an item to `protected_resource_type_limits`.
        ///
        /// To override the contents of this collection use [`set_protected_resource_type_limits`](Self::set_protected_resource_type_limits).
        ///
        /// <p>The maximum number of resource types that you can specify in a protection.</p>
        pub fn protected_resource_type_limits(mut self, input: crate::model::Limit) -> Self {
            let mut v = self.protected_resource_type_limits.unwrap_or_default();
            v.push(input);
            self.protected_resource_type_limits = Some(v);
            self
        }
        /// <p>The maximum number of resource types that you can specify in a protection.</p>
        pub fn set_protected_resource_type_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Limit>>,
        ) -> Self {
            self.protected_resource_type_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectionLimits`](crate::model::ProtectionLimits)
        pub fn build(self) -> crate::model::ProtectionLimits {
            crate::model::ProtectionLimits {
                protected_resource_type_limits: self.protected_resource_type_limits,
            }
        }
    }
}
impl ProtectionLimits {
    /// Creates a new builder-style object to manufacture [`ProtectionLimits`](crate::model::ProtectionLimits)
    pub fn builder() -> crate::model::protection_limits::Builder {
        crate::model::protection_limits::Builder::default()
    }
}

/// <p>Specifies how many protections of a given type you can create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Limit {
    /// <p>The type of protection.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The maximum number of protections that can be created for the specified <code>Type</code>.</p>
    pub max: i64,
}
impl Limit {
    /// <p>The type of protection.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The maximum number of protections that can be created for the specified <code>Type</code>.</p>
    pub fn max(&self) -> i64 {
        self.max
    }
}
impl std::fmt::Debug for Limit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Limit");
        formatter.field("r#type", &self.r#type);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`Limit`](crate::model::Limit)
pub mod limit {
    /// A builder for [`Limit`](crate::model::Limit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of protection.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of protection.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The maximum number of protections that can be created for the specified <code>Type</code>.</p>
        pub fn max(mut self, input: i64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum number of protections that can be created for the specified <code>Type</code>.</p>
        pub fn set_max(mut self, input: std::option::Option<i64>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`Limit`](crate::model::Limit)
        pub fn build(self) -> crate::model::Limit {
            crate::model::Limit {
                r#type: self.r#type,
                max: self.max.unwrap_or_default(),
            }
        }
    }
}
impl Limit {
    /// Creates a new builder-style object to manufacture [`Limit`](crate::model::Limit)
    pub fn builder() -> crate::model::limit::Builder {
        crate::model::limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProactiveEngagementStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProactiveEngagementStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ProactiveEngagementStatus::Disabled,
            "ENABLED" => ProactiveEngagementStatus::Enabled,
            "PENDING" => ProactiveEngagementStatus::Pending,
            other => ProactiveEngagementStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProactiveEngagementStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProactiveEngagementStatus::from(s))
    }
}
impl ProactiveEngagementStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProactiveEngagementStatus::Disabled => "DISABLED",
            ProactiveEngagementStatus::Enabled => "ENABLED",
            ProactiveEngagementStatus::Pending => "PENDING",
            ProactiveEngagementStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED", "PENDING"]
    }
}
impl AsRef<str> for ProactiveEngagementStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A single attack statistics data record. This is returned by <code>DescribeAttackStatistics</code> along with a time range indicating the time period that the attack statistics apply to. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackStatisticsDataItem {
    /// <p>Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is zero, this setting might be empty.</p>
    pub attack_volume: std::option::Option<crate::model::AttackVolume>,
    /// <p>The number of attacks detected during the time period. This is always present, but might be zero. </p>
    pub attack_count: i64,
}
impl AttackStatisticsDataItem {
    /// <p>Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is zero, this setting might be empty.</p>
    pub fn attack_volume(&self) -> std::option::Option<&crate::model::AttackVolume> {
        self.attack_volume.as_ref()
    }
    /// <p>The number of attacks detected during the time period. This is always present, but might be zero. </p>
    pub fn attack_count(&self) -> i64 {
        self.attack_count
    }
}
impl std::fmt::Debug for AttackStatisticsDataItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackStatisticsDataItem");
        formatter.field("attack_volume", &self.attack_volume);
        formatter.field("attack_count", &self.attack_count);
        formatter.finish()
    }
}
/// See [`AttackStatisticsDataItem`](crate::model::AttackStatisticsDataItem)
pub mod attack_statistics_data_item {
    /// A builder for [`AttackStatisticsDataItem`](crate::model::AttackStatisticsDataItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attack_volume: std::option::Option<crate::model::AttackVolume>,
        pub(crate) attack_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is zero, this setting might be empty.</p>
        pub fn attack_volume(mut self, input: crate::model::AttackVolume) -> Self {
            self.attack_volume = Some(input);
            self
        }
        /// <p>Information about the volume of attacks during the time period. If the accompanying <code>AttackCount</code> is zero, this setting might be empty.</p>
        pub fn set_attack_volume(
            mut self,
            input: std::option::Option<crate::model::AttackVolume>,
        ) -> Self {
            self.attack_volume = input;
            self
        }
        /// <p>The number of attacks detected during the time period. This is always present, but might be zero. </p>
        pub fn attack_count(mut self, input: i64) -> Self {
            self.attack_count = Some(input);
            self
        }
        /// <p>The number of attacks detected during the time period. This is always present, but might be zero. </p>
        pub fn set_attack_count(mut self, input: std::option::Option<i64>) -> Self {
            self.attack_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackStatisticsDataItem`](crate::model::AttackStatisticsDataItem)
        pub fn build(self) -> crate::model::AttackStatisticsDataItem {
            crate::model::AttackStatisticsDataItem {
                attack_volume: self.attack_volume,
                attack_count: self.attack_count.unwrap_or_default(),
            }
        }
    }
}
impl AttackStatisticsDataItem {
    /// Creates a new builder-style object to manufacture [`AttackStatisticsDataItem`](crate::model::AttackStatisticsDataItem)
    pub fn builder() -> crate::model::attack_statistics_data_item::Builder {
        crate::model::attack_statistics_data_item::Builder::default()
    }
}

/// <p>Information about the volume of attacks during the time period, included in an <code>AttackStatisticsDataItem</code>. If the accompanying <code>AttackCount</code> in the statistics object is zero, this setting might be empty.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackVolume {
    /// <p>A statistics object that uses bits per second as the unit. This is included for network level attacks. </p>
    pub bits_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
    /// <p>A statistics object that uses packets per second as the unit. This is included for network level attacks. </p>
    pub packets_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
    /// <p>A statistics object that uses requests per second as the unit. This is included for application level attacks, and is only available for accounts that are subscribed to Shield Advanced.</p>
    pub requests_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
}
impl AttackVolume {
    /// <p>A statistics object that uses bits per second as the unit. This is included for network level attacks. </p>
    pub fn bits_per_second(&self) -> std::option::Option<&crate::model::AttackVolumeStatistics> {
        self.bits_per_second.as_ref()
    }
    /// <p>A statistics object that uses packets per second as the unit. This is included for network level attacks. </p>
    pub fn packets_per_second(&self) -> std::option::Option<&crate::model::AttackVolumeStatistics> {
        self.packets_per_second.as_ref()
    }
    /// <p>A statistics object that uses requests per second as the unit. This is included for application level attacks, and is only available for accounts that are subscribed to Shield Advanced.</p>
    pub fn requests_per_second(
        &self,
    ) -> std::option::Option<&crate::model::AttackVolumeStatistics> {
        self.requests_per_second.as_ref()
    }
}
impl std::fmt::Debug for AttackVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackVolume");
        formatter.field("bits_per_second", &self.bits_per_second);
        formatter.field("packets_per_second", &self.packets_per_second);
        formatter.field("requests_per_second", &self.requests_per_second);
        formatter.finish()
    }
}
/// See [`AttackVolume`](crate::model::AttackVolume)
pub mod attack_volume {
    /// A builder for [`AttackVolume`](crate::model::AttackVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bits_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
        pub(crate) packets_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
        pub(crate) requests_per_second: std::option::Option<crate::model::AttackVolumeStatistics>,
    }
    impl Builder {
        /// <p>A statistics object that uses bits per second as the unit. This is included for network level attacks. </p>
        pub fn bits_per_second(mut self, input: crate::model::AttackVolumeStatistics) -> Self {
            self.bits_per_second = Some(input);
            self
        }
        /// <p>A statistics object that uses bits per second as the unit. This is included for network level attacks. </p>
        pub fn set_bits_per_second(
            mut self,
            input: std::option::Option<crate::model::AttackVolumeStatistics>,
        ) -> Self {
            self.bits_per_second = input;
            self
        }
        /// <p>A statistics object that uses packets per second as the unit. This is included for network level attacks. </p>
        pub fn packets_per_second(mut self, input: crate::model::AttackVolumeStatistics) -> Self {
            self.packets_per_second = Some(input);
            self
        }
        /// <p>A statistics object that uses packets per second as the unit. This is included for network level attacks. </p>
        pub fn set_packets_per_second(
            mut self,
            input: std::option::Option<crate::model::AttackVolumeStatistics>,
        ) -> Self {
            self.packets_per_second = input;
            self
        }
        /// <p>A statistics object that uses requests per second as the unit. This is included for application level attacks, and is only available for accounts that are subscribed to Shield Advanced.</p>
        pub fn requests_per_second(mut self, input: crate::model::AttackVolumeStatistics) -> Self {
            self.requests_per_second = Some(input);
            self
        }
        /// <p>A statistics object that uses requests per second as the unit. This is included for application level attacks, and is only available for accounts that are subscribed to Shield Advanced.</p>
        pub fn set_requests_per_second(
            mut self,
            input: std::option::Option<crate::model::AttackVolumeStatistics>,
        ) -> Self {
            self.requests_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackVolume`](crate::model::AttackVolume)
        pub fn build(self) -> crate::model::AttackVolume {
            crate::model::AttackVolume {
                bits_per_second: self.bits_per_second,
                packets_per_second: self.packets_per_second,
                requests_per_second: self.requests_per_second,
            }
        }
    }
}
impl AttackVolume {
    /// Creates a new builder-style object to manufacture [`AttackVolume`](crate::model::AttackVolume)
    pub fn builder() -> crate::model::attack_volume::Builder {
        crate::model::attack_volume::Builder::default()
    }
}

/// <p>Statistics objects for the various data types in <code>AttackVolume</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackVolumeStatistics {
    /// <p>The maximum attack volume observed for the given unit.</p>
    pub max: f64,
}
impl AttackVolumeStatistics {
    /// <p>The maximum attack volume observed for the given unit.</p>
    pub fn max(&self) -> f64 {
        self.max
    }
}
impl std::fmt::Debug for AttackVolumeStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackVolumeStatistics");
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`AttackVolumeStatistics`](crate::model::AttackVolumeStatistics)
pub mod attack_volume_statistics {
    /// A builder for [`AttackVolumeStatistics`](crate::model::AttackVolumeStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum attack volume observed for the given unit.</p>
        pub fn max(mut self, input: f64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum attack volume observed for the given unit.</p>
        pub fn set_max(mut self, input: std::option::Option<f64>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackVolumeStatistics`](crate::model::AttackVolumeStatistics)
        pub fn build(self) -> crate::model::AttackVolumeStatistics {
            crate::model::AttackVolumeStatistics {
                max: self.max.unwrap_or_default(),
            }
        }
    }
}
impl AttackVolumeStatistics {
    /// Creates a new builder-style object to manufacture [`AttackVolumeStatistics`](crate::model::AttackVolumeStatistics)
    pub fn builder() -> crate::model::attack_volume_statistics::Builder {
        crate::model::attack_volume_statistics::Builder::default()
    }
}

/// <p>The details of a DDoS attack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackDetail {
    /// <p>The unique identifier (ID) of the attack.</p>
    pub attack_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>If applicable, additional detail about the resource being attacked, for example, IP address or URL.</p>
    pub sub_resources: std::option::Option<std::vec::Vec<crate::model::SubResourceSummary>>,
    /// <p>The time the attack started, in Unix time in seconds. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the attack ended, in Unix time in seconds. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>List of counters that describe the attack for the specified time period.</p>
    pub attack_counters: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
    /// <p>The array of objects that provide details of the Shield event. </p>
    /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
    pub attack_properties: std::option::Option<std::vec::Vec<crate::model::AttackProperty>>,
    /// <p>List of mitigation actions taken for the attack.</p>
    pub mitigations: std::option::Option<std::vec::Vec<crate::model::Mitigation>>,
}
impl AttackDetail {
    /// <p>The unique identifier (ID) of the attack.</p>
    pub fn attack_id(&self) -> std::option::Option<&str> {
        self.attack_id.as_deref()
    }
    /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>If applicable, additional detail about the resource being attacked, for example, IP address or URL.</p>
    pub fn sub_resources(&self) -> std::option::Option<&[crate::model::SubResourceSummary]> {
        self.sub_resources.as_deref()
    }
    /// <p>The time the attack started, in Unix time in seconds. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time the attack ended, in Unix time in seconds. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>List of counters that describe the attack for the specified time period.</p>
    pub fn attack_counters(&self) -> std::option::Option<&[crate::model::SummarizedCounter]> {
        self.attack_counters.as_deref()
    }
    /// <p>The array of objects that provide details of the Shield event. </p>
    /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
    pub fn attack_properties(&self) -> std::option::Option<&[crate::model::AttackProperty]> {
        self.attack_properties.as_deref()
    }
    /// <p>List of mitigation actions taken for the attack.</p>
    pub fn mitigations(&self) -> std::option::Option<&[crate::model::Mitigation]> {
        self.mitigations.as_deref()
    }
}
impl std::fmt::Debug for AttackDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackDetail");
        formatter.field("attack_id", &self.attack_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("sub_resources", &self.sub_resources);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("attack_counters", &self.attack_counters);
        formatter.field("attack_properties", &self.attack_properties);
        formatter.field("mitigations", &self.mitigations);
        formatter.finish()
    }
}
/// See [`AttackDetail`](crate::model::AttackDetail)
pub mod attack_detail {
    /// A builder for [`AttackDetail`](crate::model::AttackDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attack_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) sub_resources:
            std::option::Option<std::vec::Vec<crate::model::SubResourceSummary>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) attack_counters:
            std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
        pub(crate) attack_properties:
            std::option::Option<std::vec::Vec<crate::model::AttackProperty>>,
        pub(crate) mitigations: std::option::Option<std::vec::Vec<crate::model::Mitigation>>,
    }
    impl Builder {
        /// <p>The unique identifier (ID) of the attack.</p>
        pub fn attack_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attack_id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the attack.</p>
        pub fn set_attack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attack_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `sub_resources`.
        ///
        /// To override the contents of this collection use [`set_sub_resources`](Self::set_sub_resources).
        ///
        /// <p>If applicable, additional detail about the resource being attacked, for example, IP address or URL.</p>
        pub fn sub_resources(mut self, input: crate::model::SubResourceSummary) -> Self {
            let mut v = self.sub_resources.unwrap_or_default();
            v.push(input);
            self.sub_resources = Some(v);
            self
        }
        /// <p>If applicable, additional detail about the resource being attacked, for example, IP address or URL.</p>
        pub fn set_sub_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubResourceSummary>>,
        ) -> Self {
            self.sub_resources = input;
            self
        }
        /// <p>The time the attack started, in Unix time in seconds. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the attack started, in Unix time in seconds. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time the attack ended, in Unix time in seconds. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time the attack ended, in Unix time in seconds. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Appends an item to `attack_counters`.
        ///
        /// To override the contents of this collection use [`set_attack_counters`](Self::set_attack_counters).
        ///
        /// <p>List of counters that describe the attack for the specified time period.</p>
        pub fn attack_counters(mut self, input: crate::model::SummarizedCounter) -> Self {
            let mut v = self.attack_counters.unwrap_or_default();
            v.push(input);
            self.attack_counters = Some(v);
            self
        }
        /// <p>List of counters that describe the attack for the specified time period.</p>
        pub fn set_attack_counters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
        ) -> Self {
            self.attack_counters = input;
            self
        }
        /// Appends an item to `attack_properties`.
        ///
        /// To override the contents of this collection use [`set_attack_properties`](Self::set_attack_properties).
        ///
        /// <p>The array of objects that provide details of the Shield event. </p>
        /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
        pub fn attack_properties(mut self, input: crate::model::AttackProperty) -> Self {
            let mut v = self.attack_properties.unwrap_or_default();
            v.push(input);
            self.attack_properties = Some(v);
            self
        }
        /// <p>The array of objects that provide details of the Shield event. </p>
        /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
        pub fn set_attack_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttackProperty>>,
        ) -> Self {
            self.attack_properties = input;
            self
        }
        /// Appends an item to `mitigations`.
        ///
        /// To override the contents of this collection use [`set_mitigations`](Self::set_mitigations).
        ///
        /// <p>List of mitigation actions taken for the attack.</p>
        pub fn mitigations(mut self, input: crate::model::Mitigation) -> Self {
            let mut v = self.mitigations.unwrap_or_default();
            v.push(input);
            self.mitigations = Some(v);
            self
        }
        /// <p>List of mitigation actions taken for the attack.</p>
        pub fn set_mitigations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Mitigation>>,
        ) -> Self {
            self.mitigations = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackDetail`](crate::model::AttackDetail)
        pub fn build(self) -> crate::model::AttackDetail {
            crate::model::AttackDetail {
                attack_id: self.attack_id,
                resource_arn: self.resource_arn,
                sub_resources: self.sub_resources,
                start_time: self.start_time,
                end_time: self.end_time,
                attack_counters: self.attack_counters,
                attack_properties: self.attack_properties,
                mitigations: self.mitigations,
            }
        }
    }
}
impl AttackDetail {
    /// Creates a new builder-style object to manufacture [`AttackDetail`](crate::model::AttackDetail)
    pub fn builder() -> crate::model::attack_detail::Builder {
        crate::model::attack_detail::Builder::default()
    }
}

/// <p>The mitigation applied to a DDoS attack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Mitigation {
    /// <p>The name of the mitigation taken for this attack.</p>
    pub mitigation_name: std::option::Option<std::string::String>,
}
impl Mitigation {
    /// <p>The name of the mitigation taken for this attack.</p>
    pub fn mitigation_name(&self) -> std::option::Option<&str> {
        self.mitigation_name.as_deref()
    }
}
impl std::fmt::Debug for Mitigation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Mitigation");
        formatter.field("mitigation_name", &self.mitigation_name);
        formatter.finish()
    }
}
/// See [`Mitigation`](crate::model::Mitigation)
pub mod mitigation {
    /// A builder for [`Mitigation`](crate::model::Mitigation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mitigation_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the mitigation taken for this attack.</p>
        pub fn mitigation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mitigation_name = Some(input.into());
            self
        }
        /// <p>The name of the mitigation taken for this attack.</p>
        pub fn set_mitigation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mitigation_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Mitigation`](crate::model::Mitigation)
        pub fn build(self) -> crate::model::Mitigation {
            crate::model::Mitigation {
                mitigation_name: self.mitigation_name,
            }
        }
    }
}
impl Mitigation {
    /// Creates a new builder-style object to manufacture [`Mitigation`](crate::model::Mitigation)
    pub fn builder() -> crate::model::mitigation::Builder {
        crate::model::mitigation::Builder::default()
    }
}

/// <p>Details of a Shield event. This is provided as part of an <code>AttackDetail</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttackProperty {
    /// <p>The type of Shield event that was observed. <code>NETWORK</code> indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.</p>
    /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
    pub attack_layer: std::option::Option<crate::model::AttackLayer>,
    /// <p>Defines the Shield event property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback events.</p>
    pub attack_property_identifier: std::option::Option<crate::model::AttackPropertyIdentifier>,
    /// <p>Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.</p>
    pub top_contributors: std::option::Option<std::vec::Vec<crate::model::Contributor>>,
    /// <p>The unit used for the <code>Contributor</code> <code>Value</code> property. </p>
    pub unit: std::option::Option<crate::model::Unit>,
    /// <p>The total contributions made to this Shield event by all contributors.</p>
    pub total: i64,
}
impl AttackProperty {
    /// <p>The type of Shield event that was observed. <code>NETWORK</code> indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.</p>
    /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
    pub fn attack_layer(&self) -> std::option::Option<&crate::model::AttackLayer> {
        self.attack_layer.as_ref()
    }
    /// <p>Defines the Shield event property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback events.</p>
    pub fn attack_property_identifier(
        &self,
    ) -> std::option::Option<&crate::model::AttackPropertyIdentifier> {
        self.attack_property_identifier.as_ref()
    }
    /// <p>Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.</p>
    pub fn top_contributors(&self) -> std::option::Option<&[crate::model::Contributor]> {
        self.top_contributors.as_deref()
    }
    /// <p>The unit used for the <code>Contributor</code> <code>Value</code> property. </p>
    pub fn unit(&self) -> std::option::Option<&crate::model::Unit> {
        self.unit.as_ref()
    }
    /// <p>The total contributions made to this Shield event by all contributors.</p>
    pub fn total(&self) -> i64 {
        self.total
    }
}
impl std::fmt::Debug for AttackProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttackProperty");
        formatter.field("attack_layer", &self.attack_layer);
        formatter.field(
            "attack_property_identifier",
            &self.attack_property_identifier,
        );
        formatter.field("top_contributors", &self.top_contributors);
        formatter.field("unit", &self.unit);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`AttackProperty`](crate::model::AttackProperty)
pub mod attack_property {
    /// A builder for [`AttackProperty`](crate::model::AttackProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attack_layer: std::option::Option<crate::model::AttackLayer>,
        pub(crate) attack_property_identifier:
            std::option::Option<crate::model::AttackPropertyIdentifier>,
        pub(crate) top_contributors: std::option::Option<std::vec::Vec<crate::model::Contributor>>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
        pub(crate) total: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of Shield event that was observed. <code>NETWORK</code> indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.</p>
        /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
        pub fn attack_layer(mut self, input: crate::model::AttackLayer) -> Self {
            self.attack_layer = Some(input);
            self
        }
        /// <p>The type of Shield event that was observed. <code>NETWORK</code> indicates layer 3 and layer 4 events and <code>APPLICATION</code> indicates layer 7 events.</p>
        /// <p>For infrastructure layer events (L3 and L4 events), you can view metrics for top contributors in Amazon CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#set-ddos-alarms">Shield metrics and alarms</a> in the <i>WAF Developer Guide</i>. </p>
        pub fn set_attack_layer(
            mut self,
            input: std::option::Option<crate::model::AttackLayer>,
        ) -> Self {
            self.attack_layer = input;
            self
        }
        /// <p>Defines the Shield event property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback events.</p>
        pub fn attack_property_identifier(
            mut self,
            input: crate::model::AttackPropertyIdentifier,
        ) -> Self {
            self.attack_property_identifier = Some(input);
            self
        }
        /// <p>Defines the Shield event property information that is provided. The <code>WORDPRESS_PINGBACK_REFLECTOR</code> and <code>WORDPRESS_PINGBACK_SOURCE</code> values are valid only for WordPress reflective pingback events.</p>
        pub fn set_attack_property_identifier(
            mut self,
            input: std::option::Option<crate::model::AttackPropertyIdentifier>,
        ) -> Self {
            self.attack_property_identifier = input;
            self
        }
        /// Appends an item to `top_contributors`.
        ///
        /// To override the contents of this collection use [`set_top_contributors`](Self::set_top_contributors).
        ///
        /// <p>Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.</p>
        pub fn top_contributors(mut self, input: crate::model::Contributor) -> Self {
            let mut v = self.top_contributors.unwrap_or_default();
            v.push(input);
            self.top_contributors = Some(v);
            self
        }
        /// <p>Contributor objects for the top five contributors to a Shield event. A contributor is a source of traffic that Shield Advanced identifies as responsible for some or all of an event.</p>
        pub fn set_top_contributors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Contributor>>,
        ) -> Self {
            self.top_contributors = input;
            self
        }
        /// <p>The unit used for the <code>Contributor</code> <code>Value</code> property. </p>
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit used for the <code>Contributor</code> <code>Value</code> property. </p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The total contributions made to this Shield event by all contributors.</p>
        pub fn total(mut self, input: i64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total contributions made to this Shield event by all contributors.</p>
        pub fn set_total(mut self, input: std::option::Option<i64>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`AttackProperty`](crate::model::AttackProperty)
        pub fn build(self) -> crate::model::AttackProperty {
            crate::model::AttackProperty {
                attack_layer: self.attack_layer,
                attack_property_identifier: self.attack_property_identifier,
                top_contributors: self.top_contributors,
                unit: self.unit,
                total: self.total.unwrap_or_default(),
            }
        }
    }
}
impl AttackProperty {
    /// Creates a new builder-style object to manufacture [`AttackProperty`](crate::model::AttackProperty)
    pub fn builder() -> crate::model::attack_property::Builder {
        crate::model::attack_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Unit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    Packets,
    #[allow(missing_docs)] // documentation missing in model
    Requests,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Unit {
    fn from(s: &str) -> Self {
        match s {
            "BITS" => Unit::Bits,
            "BYTES" => Unit::Bytes,
            "PACKETS" => Unit::Packets,
            "REQUESTS" => Unit::Requests,
            other => Unit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Unit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Unit::from(s))
    }
}
impl Unit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Unit::Bits => "BITS",
            Unit::Bytes => "BYTES",
            Unit::Packets => "PACKETS",
            Unit::Requests => "REQUESTS",
            Unit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BITS", "BYTES", "PACKETS", "REQUESTS"]
    }
}
impl AsRef<str> for Unit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A contributor to the attack and their contribution. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Contributor {
    /// <p>The name of the contributor. The type of name that you'll find here depends on the <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The contribution of this contributor expressed in <code>Protection</code> units. For example <code>10,000</code>.</p>
    pub value: i64,
}
impl Contributor {
    /// <p>The name of the contributor. The type of name that you'll find here depends on the <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The contribution of this contributor expressed in <code>Protection</code> units. For example <code>10,000</code>.</p>
    pub fn value(&self) -> i64 {
        self.value
    }
}
impl std::fmt::Debug for Contributor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Contributor");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Contributor`](crate::model::Contributor)
pub mod contributor {
    /// A builder for [`Contributor`](crate::model::Contributor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the contributor. The type of name that you'll find here depends on the <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contributor. The type of name that you'll find here depends on the <code>AttackPropertyIdentifier</code> setting in the <code>AttackProperty</code> where this contributor is defined. For example, if the <code>AttackPropertyIdentifier</code> is <code>SOURCE_COUNTRY</code>, the <code>Name</code> could be <code>United States</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The contribution of this contributor expressed in <code>Protection</code> units. For example <code>10,000</code>.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The contribution of this contributor expressed in <code>Protection</code> units. For example <code>10,000</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Contributor`](crate::model::Contributor)
        pub fn build(self) -> crate::model::Contributor {
            crate::model::Contributor {
                name: self.name,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl Contributor {
    /// Creates a new builder-style object to manufacture [`Contributor`](crate::model::Contributor)
    pub fn builder() -> crate::model::contributor::Builder {
        crate::model::contributor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttackPropertyIdentifier {
    #[allow(missing_docs)] // documentation missing in model
    DestinationUrl,
    #[allow(missing_docs)] // documentation missing in model
    Referrer,
    #[allow(missing_docs)] // documentation missing in model
    SourceAsn,
    #[allow(missing_docs)] // documentation missing in model
    SourceCountry,
    #[allow(missing_docs)] // documentation missing in model
    SourceIpAddress,
    #[allow(missing_docs)] // documentation missing in model
    SourceUserAgent,
    #[allow(missing_docs)] // documentation missing in model
    WordpressPingbackReflector,
    #[allow(missing_docs)] // documentation missing in model
    WordpressPingbackSource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttackPropertyIdentifier {
    fn from(s: &str) -> Self {
        match s {
            "DESTINATION_URL" => AttackPropertyIdentifier::DestinationUrl,
            "REFERRER" => AttackPropertyIdentifier::Referrer,
            "SOURCE_ASN" => AttackPropertyIdentifier::SourceAsn,
            "SOURCE_COUNTRY" => AttackPropertyIdentifier::SourceCountry,
            "SOURCE_IP_ADDRESS" => AttackPropertyIdentifier::SourceIpAddress,
            "SOURCE_USER_AGENT" => AttackPropertyIdentifier::SourceUserAgent,
            "WORDPRESS_PINGBACK_REFLECTOR" => AttackPropertyIdentifier::WordpressPingbackReflector,
            "WORDPRESS_PINGBACK_SOURCE" => AttackPropertyIdentifier::WordpressPingbackSource,
            other => AttackPropertyIdentifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttackPropertyIdentifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttackPropertyIdentifier::from(s))
    }
}
impl AttackPropertyIdentifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttackPropertyIdentifier::DestinationUrl => "DESTINATION_URL",
            AttackPropertyIdentifier::Referrer => "REFERRER",
            AttackPropertyIdentifier::SourceAsn => "SOURCE_ASN",
            AttackPropertyIdentifier::SourceCountry => "SOURCE_COUNTRY",
            AttackPropertyIdentifier::SourceIpAddress => "SOURCE_IP_ADDRESS",
            AttackPropertyIdentifier::SourceUserAgent => "SOURCE_USER_AGENT",
            AttackPropertyIdentifier::WordpressPingbackReflector => "WORDPRESS_PINGBACK_REFLECTOR",
            AttackPropertyIdentifier::WordpressPingbackSource => "WORDPRESS_PINGBACK_SOURCE",
            AttackPropertyIdentifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DESTINATION_URL",
            "REFERRER",
            "SOURCE_ASN",
            "SOURCE_COUNTRY",
            "SOURCE_IP_ADDRESS",
            "SOURCE_USER_AGENT",
            "WORDPRESS_PINGBACK_REFLECTOR",
            "WORDPRESS_PINGBACK_SOURCE",
        ]
    }
}
impl AsRef<str> for AttackPropertyIdentifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttackLayer {
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    Network,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttackLayer {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION" => AttackLayer::Application,
            "NETWORK" => AttackLayer::Network,
            other => AttackLayer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttackLayer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttackLayer::from(s))
    }
}
impl AttackLayer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttackLayer::Application => "APPLICATION",
            AttackLayer::Network => "NETWORK",
            AttackLayer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLICATION", "NETWORK"]
    }
}
impl AsRef<str> for AttackLayer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The counter that describes a DDoS attack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SummarizedCounter {
    /// <p>The counter name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum value of the counter for a specified time period.</p>
    pub max: f64,
    /// <p>The average value of the counter for a specified time period.</p>
    pub average: f64,
    /// <p>The total of counter values for a specified time period.</p>
    pub sum: f64,
    /// <p>The number of counters for a specified time period.</p>
    pub n: i32,
    /// <p>The unit of the counters.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl SummarizedCounter {
    /// <p>The counter name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum value of the counter for a specified time period.</p>
    pub fn max(&self) -> f64 {
        self.max
    }
    /// <p>The average value of the counter for a specified time period.</p>
    pub fn average(&self) -> f64 {
        self.average
    }
    /// <p>The total of counter values for a specified time period.</p>
    pub fn sum(&self) -> f64 {
        self.sum
    }
    /// <p>The number of counters for a specified time period.</p>
    pub fn n(&self) -> i32 {
        self.n
    }
    /// <p>The unit of the counters.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for SummarizedCounter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SummarizedCounter");
        formatter.field("name", &self.name);
        formatter.field("max", &self.max);
        formatter.field("average", &self.average);
        formatter.field("sum", &self.sum);
        formatter.field("n", &self.n);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`SummarizedCounter`](crate::model::SummarizedCounter)
pub mod summarized_counter {
    /// A builder for [`SummarizedCounter`](crate::model::SummarizedCounter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<f64>,
        pub(crate) average: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) n: std::option::Option<i32>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The counter name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The counter name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum value of the counter for a specified time period.</p>
        pub fn max(mut self, input: f64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum value of the counter for a specified time period.</p>
        pub fn set_max(mut self, input: std::option::Option<f64>) -> Self {
            self.max = input;
            self
        }
        /// <p>The average value of the counter for a specified time period.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average value of the counter for a specified time period.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The total of counter values for a specified time period.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The total of counter values for a specified time period.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The number of counters for a specified time period.</p>
        pub fn n(mut self, input: i32) -> Self {
            self.n = Some(input);
            self
        }
        /// <p>The number of counters for a specified time period.</p>
        pub fn set_n(mut self, input: std::option::Option<i32>) -> Self {
            self.n = input;
            self
        }
        /// <p>The unit of the counters.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the counters.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`SummarizedCounter`](crate::model::SummarizedCounter)
        pub fn build(self) -> crate::model::SummarizedCounter {
            crate::model::SummarizedCounter {
                name: self.name,
                max: self.max.unwrap_or_default(),
                average: self.average.unwrap_or_default(),
                sum: self.sum.unwrap_or_default(),
                n: self.n.unwrap_or_default(),
                unit: self.unit,
            }
        }
    }
}
impl SummarizedCounter {
    /// Creates a new builder-style object to manufacture [`SummarizedCounter`](crate::model::SummarizedCounter)
    pub fn builder() -> crate::model::summarized_counter::Builder {
        crate::model::summarized_counter::Builder::default()
    }
}

/// <p>The attack information for the specified SubResource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubResourceSummary {
    /// <p>The <code>SubResource</code> type.</p>
    pub r#type: std::option::Option<crate::model::SubResourceType>,
    /// <p>The unique identifier (ID) of the <code>SubResource</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The list of attack types and associated counters.</p>
    pub attack_vectors: std::option::Option<std::vec::Vec<crate::model::SummarizedAttackVector>>,
    /// <p>The counters that describe the details of the attack.</p>
    pub counters: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
}
impl SubResourceSummary {
    /// <p>The <code>SubResource</code> type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SubResourceType> {
        self.r#type.as_ref()
    }
    /// <p>The unique identifier (ID) of the <code>SubResource</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The list of attack types and associated counters.</p>
    pub fn attack_vectors(&self) -> std::option::Option<&[crate::model::SummarizedAttackVector]> {
        self.attack_vectors.as_deref()
    }
    /// <p>The counters that describe the details of the attack.</p>
    pub fn counters(&self) -> std::option::Option<&[crate::model::SummarizedCounter]> {
        self.counters.as_deref()
    }
}
impl std::fmt::Debug for SubResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubResourceSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("attack_vectors", &self.attack_vectors);
        formatter.field("counters", &self.counters);
        formatter.finish()
    }
}
/// See [`SubResourceSummary`](crate::model::SubResourceSummary)
pub mod sub_resource_summary {
    /// A builder for [`SubResourceSummary`](crate::model::SubResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SubResourceType>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) attack_vectors:
            std::option::Option<std::vec::Vec<crate::model::SummarizedAttackVector>>,
        pub(crate) counters: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
    }
    impl Builder {
        /// <p>The <code>SubResource</code> type.</p>
        pub fn r#type(mut self, input: crate::model::SubResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The <code>SubResource</code> type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SubResourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The unique identifier (ID) of the <code>SubResource</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier (ID) of the <code>SubResource</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `attack_vectors`.
        ///
        /// To override the contents of this collection use [`set_attack_vectors`](Self::set_attack_vectors).
        ///
        /// <p>The list of attack types and associated counters.</p>
        pub fn attack_vectors(mut self, input: crate::model::SummarizedAttackVector) -> Self {
            let mut v = self.attack_vectors.unwrap_or_default();
            v.push(input);
            self.attack_vectors = Some(v);
            self
        }
        /// <p>The list of attack types and associated counters.</p>
        pub fn set_attack_vectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SummarizedAttackVector>>,
        ) -> Self {
            self.attack_vectors = input;
            self
        }
        /// Appends an item to `counters`.
        ///
        /// To override the contents of this collection use [`set_counters`](Self::set_counters).
        ///
        /// <p>The counters that describe the details of the attack.</p>
        pub fn counters(mut self, input: crate::model::SummarizedCounter) -> Self {
            let mut v = self.counters.unwrap_or_default();
            v.push(input);
            self.counters = Some(v);
            self
        }
        /// <p>The counters that describe the details of the attack.</p>
        pub fn set_counters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
        ) -> Self {
            self.counters = input;
            self
        }
        /// Consumes the builder and constructs a [`SubResourceSummary`](crate::model::SubResourceSummary)
        pub fn build(self) -> crate::model::SubResourceSummary {
            crate::model::SubResourceSummary {
                r#type: self.r#type,
                id: self.id,
                attack_vectors: self.attack_vectors,
                counters: self.counters,
            }
        }
    }
}
impl SubResourceSummary {
    /// Creates a new builder-style object to manufacture [`SubResourceSummary`](crate::model::SubResourceSummary)
    pub fn builder() -> crate::model::sub_resource_summary::Builder {
        crate::model::sub_resource_summary::Builder::default()
    }
}

/// <p>A summary of information about the attack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SummarizedAttackVector {
    /// <p>The attack type, for example, SNMP reflection or SYN flood.</p>
    pub vector_type: std::option::Option<std::string::String>,
    /// <p>The list of counters that describe the details of the attack.</p>
    pub vector_counters: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
}
impl SummarizedAttackVector {
    /// <p>The attack type, for example, SNMP reflection or SYN flood.</p>
    pub fn vector_type(&self) -> std::option::Option<&str> {
        self.vector_type.as_deref()
    }
    /// <p>The list of counters that describe the details of the attack.</p>
    pub fn vector_counters(&self) -> std::option::Option<&[crate::model::SummarizedCounter]> {
        self.vector_counters.as_deref()
    }
}
impl std::fmt::Debug for SummarizedAttackVector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SummarizedAttackVector");
        formatter.field("vector_type", &self.vector_type);
        formatter.field("vector_counters", &self.vector_counters);
        formatter.finish()
    }
}
/// See [`SummarizedAttackVector`](crate::model::SummarizedAttackVector)
pub mod summarized_attack_vector {
    /// A builder for [`SummarizedAttackVector`](crate::model::SummarizedAttackVector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vector_type: std::option::Option<std::string::String>,
        pub(crate) vector_counters:
            std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
    }
    impl Builder {
        /// <p>The attack type, for example, SNMP reflection or SYN flood.</p>
        pub fn vector_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.vector_type = Some(input.into());
            self
        }
        /// <p>The attack type, for example, SNMP reflection or SYN flood.</p>
        pub fn set_vector_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vector_type = input;
            self
        }
        /// Appends an item to `vector_counters`.
        ///
        /// To override the contents of this collection use [`set_vector_counters`](Self::set_vector_counters).
        ///
        /// <p>The list of counters that describe the details of the attack.</p>
        pub fn vector_counters(mut self, input: crate::model::SummarizedCounter) -> Self {
            let mut v = self.vector_counters.unwrap_or_default();
            v.push(input);
            self.vector_counters = Some(v);
            self
        }
        /// <p>The list of counters that describe the details of the attack.</p>
        pub fn set_vector_counters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SummarizedCounter>>,
        ) -> Self {
            self.vector_counters = input;
            self
        }
        /// Consumes the builder and constructs a [`SummarizedAttackVector`](crate::model::SummarizedAttackVector)
        pub fn build(self) -> crate::model::SummarizedAttackVector {
            crate::model::SummarizedAttackVector {
                vector_type: self.vector_type,
                vector_counters: self.vector_counters,
            }
        }
    }
}
impl SummarizedAttackVector {
    /// Creates a new builder-style object to manufacture [`SummarizedAttackVector`](crate::model::SummarizedAttackVector)
    pub fn builder() -> crate::model::summarized_attack_vector::Builder {
        crate::model::summarized_attack_vector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Ip,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubResourceType {
    fn from(s: &str) -> Self {
        match s {
            "IP" => SubResourceType::Ip,
            "URL" => SubResourceType::Url,
            other => SubResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubResourceType::from(s))
    }
}
impl SubResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubResourceType::Ip => "IP",
            SubResourceType::Url => "URL",
            SubResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IP", "URL"]
    }
}
impl AsRef<str> for SubResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
