// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateDRTLogBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_drt_log_bucket`](crate::client::Client::associate_drt_log_bucket).
///
/// See [`crate::client::fluent_builders::AssociateDRTLogBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDRTLogBucket {
    _private: (),
}
impl AssociateDRTLogBucket {
    /// Creates a new builder-style object to manufacture [`AssociateDrtLogBucketInput`](crate::input::AssociateDrtLogBucketInput)
    pub fn builder() -> crate::input::associate_drt_log_bucket_input::Builder {
        crate::input::associate_drt_log_bucket_input::Builder::default()
    }
    /// Creates a new `AssociateDRTLogBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDRTLogBucket {
    type Output = std::result::Result<
        crate::output::AssociateDrtLogBucketOutput,
        crate::error::AssociateDRTLogBucketError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_drt_log_bucket_error(response)
        } else {
            crate::operation_deser::parse_associate_drt_log_bucket_response(response)
        }
    }
}

/// Operation shape for `AssociateDRTRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_drt_role`](crate::client::Client::associate_drt_role).
///
/// See [`crate::client::fluent_builders::AssociateDRTRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDRTRole {
    _private: (),
}
impl AssociateDRTRole {
    /// Creates a new builder-style object to manufacture [`AssociateDrtRoleInput`](crate::input::AssociateDrtRoleInput)
    pub fn builder() -> crate::input::associate_drt_role_input::Builder {
        crate::input::associate_drt_role_input::Builder::default()
    }
    /// Creates a new `AssociateDRTRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDRTRole {
    type Output = std::result::Result<
        crate::output::AssociateDrtRoleOutput,
        crate::error::AssociateDRTRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_drt_role_error(response)
        } else {
            crate::operation_deser::parse_associate_drt_role_response(response)
        }
    }
}

/// Operation shape for `AssociateHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_health_check`](crate::client::Client::associate_health_check).
///
/// See [`crate::client::fluent_builders::AssociateHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateHealthCheck {
    _private: (),
}
impl AssociateHealthCheck {
    /// Creates a new builder-style object to manufacture [`AssociateHealthCheckInput`](crate::input::AssociateHealthCheckInput)
    pub fn builder() -> crate::input::associate_health_check_input::Builder {
        crate::input::associate_health_check_input::Builder::default()
    }
    /// Creates a new `AssociateHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateHealthCheck {
    type Output = std::result::Result<
        crate::output::AssociateHealthCheckOutput,
        crate::error::AssociateHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_health_check_error(response)
        } else {
            crate::operation_deser::parse_associate_health_check_response(response)
        }
    }
}

/// Operation shape for `AssociateProactiveEngagementDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_proactive_engagement_details`](crate::client::Client::associate_proactive_engagement_details).
///
/// See [`crate::client::fluent_builders::AssociateProactiveEngagementDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateProactiveEngagementDetails {
    _private: (),
}
impl AssociateProactiveEngagementDetails {
    /// Creates a new builder-style object to manufacture [`AssociateProactiveEngagementDetailsInput`](crate::input::AssociateProactiveEngagementDetailsInput)
    pub fn builder() -> crate::input::associate_proactive_engagement_details_input::Builder {
        crate::input::associate_proactive_engagement_details_input::Builder::default()
    }
    /// Creates a new `AssociateProactiveEngagementDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateProactiveEngagementDetails {
    type Output = std::result::Result<
        crate::output::AssociateProactiveEngagementDetailsOutput,
        crate::error::AssociateProactiveEngagementDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_proactive_engagement_details_error(response)
        } else {
            crate::operation_deser::parse_associate_proactive_engagement_details_response(response)
        }
    }
}

/// Operation shape for `CreateProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_protection`](crate::client::Client::create_protection).
///
/// See [`crate::client::fluent_builders::CreateProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProtection {
    _private: (),
}
impl CreateProtection {
    /// Creates a new builder-style object to manufacture [`CreateProtectionInput`](crate::input::CreateProtectionInput)
    pub fn builder() -> crate::input::create_protection_input::Builder {
        crate::input::create_protection_input::Builder::default()
    }
    /// Creates a new `CreateProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProtection {
    type Output = std::result::Result<
        crate::output::CreateProtectionOutput,
        crate::error::CreateProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_protection_error(response)
        } else {
            crate::operation_deser::parse_create_protection_response(response)
        }
    }
}

/// Operation shape for `CreateProtectionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_protection_group`](crate::client::Client::create_protection_group).
///
/// See [`crate::client::fluent_builders::CreateProtectionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProtectionGroup {
    _private: (),
}
impl CreateProtectionGroup {
    /// Creates a new builder-style object to manufacture [`CreateProtectionGroupInput`](crate::input::CreateProtectionGroupInput)
    pub fn builder() -> crate::input::create_protection_group_input::Builder {
        crate::input::create_protection_group_input::Builder::default()
    }
    /// Creates a new `CreateProtectionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProtectionGroup {
    type Output = std::result::Result<
        crate::output::CreateProtectionGroupOutput,
        crate::error::CreateProtectionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_protection_group_error(response)
        } else {
            crate::operation_deser::parse_create_protection_group_response(response)
        }
    }
}

/// Operation shape for `CreateSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subscription`](crate::client::Client::create_subscription).
///
/// See [`crate::client::fluent_builders::CreateSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubscription {
    _private: (),
}
impl CreateSubscription {
    /// Creates a new builder-style object to manufacture [`CreateSubscriptionInput`](crate::input::CreateSubscriptionInput)
    pub fn builder() -> crate::input::create_subscription_input::Builder {
        crate::input::create_subscription_input::Builder::default()
    }
    /// Creates a new `CreateSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubscription {
    type Output = std::result::Result<
        crate::output::CreateSubscriptionOutput,
        crate::error::CreateSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_protection`](crate::client::Client::delete_protection).
///
/// See [`crate::client::fluent_builders::DeleteProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProtection {
    _private: (),
}
impl DeleteProtection {
    /// Creates a new builder-style object to manufacture [`DeleteProtectionInput`](crate::input::DeleteProtectionInput)
    pub fn builder() -> crate::input::delete_protection_input::Builder {
        crate::input::delete_protection_input::Builder::default()
    }
    /// Creates a new `DeleteProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProtection {
    type Output = std::result::Result<
        crate::output::DeleteProtectionOutput,
        crate::error::DeleteProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_protection_error(response)
        } else {
            crate::operation_deser::parse_delete_protection_response(response)
        }
    }
}

/// Operation shape for `DeleteProtectionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_protection_group`](crate::client::Client::delete_protection_group).
///
/// See [`crate::client::fluent_builders::DeleteProtectionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProtectionGroup {
    _private: (),
}
impl DeleteProtectionGroup {
    /// Creates a new builder-style object to manufacture [`DeleteProtectionGroupInput`](crate::input::DeleteProtectionGroupInput)
    pub fn builder() -> crate::input::delete_protection_group_input::Builder {
        crate::input::delete_protection_group_input::Builder::default()
    }
    /// Creates a new `DeleteProtectionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProtectionGroup {
    type Output = std::result::Result<
        crate::output::DeleteProtectionGroupOutput,
        crate::error::DeleteProtectionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_protection_group_error(response)
        } else {
            crate::operation_deser::parse_delete_protection_group_response(response)
        }
    }
}

/// Operation shape for `DeleteSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subscription`](crate::client::Client::delete_subscription).
///
/// See [`crate::client::fluent_builders::DeleteSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubscription {
    _private: (),
}
impl DeleteSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteSubscriptionInput`](crate::input::DeleteSubscriptionInput)
    pub fn builder() -> crate::input::delete_subscription_input::Builder {
        crate::input::delete_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubscription {
    type Output = std::result::Result<
        crate::output::DeleteSubscriptionOutput,
        crate::error::DeleteSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_subscription_response(response)
        }
    }
}

/// Operation shape for `DescribeAttack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_attack`](crate::client::Client::describe_attack).
///
/// See [`crate::client::fluent_builders::DescribeAttack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAttack {
    _private: (),
}
impl DescribeAttack {
    /// Creates a new builder-style object to manufacture [`DescribeAttackInput`](crate::input::DescribeAttackInput)
    pub fn builder() -> crate::input::describe_attack_input::Builder {
        crate::input::describe_attack_input::Builder::default()
    }
    /// Creates a new `DescribeAttack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAttack {
    type Output =
        std::result::Result<crate::output::DescribeAttackOutput, crate::error::DescribeAttackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_attack_error(response)
        } else {
            crate::operation_deser::parse_describe_attack_response(response)
        }
    }
}

/// Operation shape for `DescribeAttackStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_attack_statistics`](crate::client::Client::describe_attack_statistics).
///
/// See [`crate::client::fluent_builders::DescribeAttackStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAttackStatistics {
    _private: (),
}
impl DescribeAttackStatistics {
    /// Creates a new builder-style object to manufacture [`DescribeAttackStatisticsInput`](crate::input::DescribeAttackStatisticsInput)
    pub fn builder() -> crate::input::describe_attack_statistics_input::Builder {
        crate::input::describe_attack_statistics_input::Builder::default()
    }
    /// Creates a new `DescribeAttackStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAttackStatistics {
    type Output = std::result::Result<
        crate::output::DescribeAttackStatisticsOutput,
        crate::error::DescribeAttackStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_attack_statistics_error(response)
        } else {
            crate::operation_deser::parse_describe_attack_statistics_response(response)
        }
    }
}

/// Operation shape for `DescribeDRTAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_drt_access`](crate::client::Client::describe_drt_access).
///
/// See [`crate::client::fluent_builders::DescribeDRTAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDRTAccess {
    _private: (),
}
impl DescribeDRTAccess {
    /// Creates a new builder-style object to manufacture [`DescribeDrtAccessInput`](crate::input::DescribeDrtAccessInput)
    pub fn builder() -> crate::input::describe_drt_access_input::Builder {
        crate::input::describe_drt_access_input::Builder::default()
    }
    /// Creates a new `DescribeDRTAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDRTAccess {
    type Output = std::result::Result<
        crate::output::DescribeDrtAccessOutput,
        crate::error::DescribeDRTAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_drt_access_error(response)
        } else {
            crate::operation_deser::parse_describe_drt_access_response(response)
        }
    }
}

/// Operation shape for `DescribeEmergencyContactSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_emergency_contact_settings`](crate::client::Client::describe_emergency_contact_settings).
///
/// See [`crate::client::fluent_builders::DescribeEmergencyContactSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEmergencyContactSettings {
    _private: (),
}
impl DescribeEmergencyContactSettings {
    /// Creates a new builder-style object to manufacture [`DescribeEmergencyContactSettingsInput`](crate::input::DescribeEmergencyContactSettingsInput)
    pub fn builder() -> crate::input::describe_emergency_contact_settings_input::Builder {
        crate::input::describe_emergency_contact_settings_input::Builder::default()
    }
    /// Creates a new `DescribeEmergencyContactSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEmergencyContactSettings {
    type Output = std::result::Result<
        crate::output::DescribeEmergencyContactSettingsOutput,
        crate::error::DescribeEmergencyContactSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_emergency_contact_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_emergency_contact_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeProtection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_protection`](crate::client::Client::describe_protection).
///
/// See [`crate::client::fluent_builders::DescribeProtection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProtection {
    _private: (),
}
impl DescribeProtection {
    /// Creates a new builder-style object to manufacture [`DescribeProtectionInput`](crate::input::DescribeProtectionInput)
    pub fn builder() -> crate::input::describe_protection_input::Builder {
        crate::input::describe_protection_input::Builder::default()
    }
    /// Creates a new `DescribeProtection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProtection {
    type Output = std::result::Result<
        crate::output::DescribeProtectionOutput,
        crate::error::DescribeProtectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_protection_error(response)
        } else {
            crate::operation_deser::parse_describe_protection_response(response)
        }
    }
}

/// Operation shape for `DescribeProtectionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_protection_group`](crate::client::Client::describe_protection_group).
///
/// See [`crate::client::fluent_builders::DescribeProtectionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProtectionGroup {
    _private: (),
}
impl DescribeProtectionGroup {
    /// Creates a new builder-style object to manufacture [`DescribeProtectionGroupInput`](crate::input::DescribeProtectionGroupInput)
    pub fn builder() -> crate::input::describe_protection_group_input::Builder {
        crate::input::describe_protection_group_input::Builder::default()
    }
    /// Creates a new `DescribeProtectionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProtectionGroup {
    type Output = std::result::Result<
        crate::output::DescribeProtectionGroupOutput,
        crate::error::DescribeProtectionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_protection_group_error(response)
        } else {
            crate::operation_deser::parse_describe_protection_group_response(response)
        }
    }
}

/// Operation shape for `DescribeSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_subscription`](crate::client::Client::describe_subscription).
///
/// See [`crate::client::fluent_builders::DescribeSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSubscription {
    _private: (),
}
impl DescribeSubscription {
    /// Creates a new builder-style object to manufacture [`DescribeSubscriptionInput`](crate::input::DescribeSubscriptionInput)
    pub fn builder() -> crate::input::describe_subscription_input::Builder {
        crate::input::describe_subscription_input::Builder::default()
    }
    /// Creates a new `DescribeSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSubscription {
    type Output = std::result::Result<
        crate::output::DescribeSubscriptionOutput,
        crate::error::DescribeSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_subscription_error(response)
        } else {
            crate::operation_deser::parse_describe_subscription_response(response)
        }
    }
}

/// Operation shape for `DisableApplicationLayerAutomaticResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_application_layer_automatic_response`](crate::client::Client::disable_application_layer_automatic_response).
///
/// See [`crate::client::fluent_builders::DisableApplicationLayerAutomaticResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableApplicationLayerAutomaticResponse {
    _private: (),
}
impl DisableApplicationLayerAutomaticResponse {
    /// Creates a new builder-style object to manufacture [`DisableApplicationLayerAutomaticResponseInput`](crate::input::DisableApplicationLayerAutomaticResponseInput)
    pub fn builder() -> crate::input::disable_application_layer_automatic_response_input::Builder {
        crate::input::disable_application_layer_automatic_response_input::Builder::default()
    }
    /// Creates a new `DisableApplicationLayerAutomaticResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableApplicationLayerAutomaticResponse {
    type Output = std::result::Result<
        crate::output::DisableApplicationLayerAutomaticResponseOutput,
        crate::error::DisableApplicationLayerAutomaticResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_application_layer_automatic_response_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disable_application_layer_automatic_response_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisableProactiveEngagement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_proactive_engagement`](crate::client::Client::disable_proactive_engagement).
///
/// See [`crate::client::fluent_builders::DisableProactiveEngagement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableProactiveEngagement {
    _private: (),
}
impl DisableProactiveEngagement {
    /// Creates a new builder-style object to manufacture [`DisableProactiveEngagementInput`](crate::input::DisableProactiveEngagementInput)
    pub fn builder() -> crate::input::disable_proactive_engagement_input::Builder {
        crate::input::disable_proactive_engagement_input::Builder::default()
    }
    /// Creates a new `DisableProactiveEngagement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableProactiveEngagement {
    type Output = std::result::Result<
        crate::output::DisableProactiveEngagementOutput,
        crate::error::DisableProactiveEngagementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_proactive_engagement_error(response)
        } else {
            crate::operation_deser::parse_disable_proactive_engagement_response(response)
        }
    }
}

/// Operation shape for `DisassociateDRTLogBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_drt_log_bucket`](crate::client::Client::disassociate_drt_log_bucket).
///
/// See [`crate::client::fluent_builders::DisassociateDRTLogBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDRTLogBucket {
    _private: (),
}
impl DisassociateDRTLogBucket {
    /// Creates a new builder-style object to manufacture [`DisassociateDrtLogBucketInput`](crate::input::DisassociateDrtLogBucketInput)
    pub fn builder() -> crate::input::disassociate_drt_log_bucket_input::Builder {
        crate::input::disassociate_drt_log_bucket_input::Builder::default()
    }
    /// Creates a new `DisassociateDRTLogBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDRTLogBucket {
    type Output = std::result::Result<
        crate::output::DisassociateDrtLogBucketOutput,
        crate::error::DisassociateDRTLogBucketError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_drt_log_bucket_error(response)
        } else {
            crate::operation_deser::parse_disassociate_drt_log_bucket_response(response)
        }
    }
}

/// Operation shape for `DisassociateDRTRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_drt_role`](crate::client::Client::disassociate_drt_role).
///
/// See [`crate::client::fluent_builders::DisassociateDRTRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDRTRole {
    _private: (),
}
impl DisassociateDRTRole {
    /// Creates a new builder-style object to manufacture [`DisassociateDrtRoleInput`](crate::input::DisassociateDrtRoleInput)
    pub fn builder() -> crate::input::disassociate_drt_role_input::Builder {
        crate::input::disassociate_drt_role_input::Builder::default()
    }
    /// Creates a new `DisassociateDRTRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDRTRole {
    type Output = std::result::Result<
        crate::output::DisassociateDrtRoleOutput,
        crate::error::DisassociateDRTRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_drt_role_error(response)
        } else {
            crate::operation_deser::parse_disassociate_drt_role_response(response)
        }
    }
}

/// Operation shape for `DisassociateHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_health_check`](crate::client::Client::disassociate_health_check).
///
/// See [`crate::client::fluent_builders::DisassociateHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateHealthCheck {
    _private: (),
}
impl DisassociateHealthCheck {
    /// Creates a new builder-style object to manufacture [`DisassociateHealthCheckInput`](crate::input::DisassociateHealthCheckInput)
    pub fn builder() -> crate::input::disassociate_health_check_input::Builder {
        crate::input::disassociate_health_check_input::Builder::default()
    }
    /// Creates a new `DisassociateHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateHealthCheck {
    type Output = std::result::Result<
        crate::output::DisassociateHealthCheckOutput,
        crate::error::DisassociateHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_health_check_error(response)
        } else {
            crate::operation_deser::parse_disassociate_health_check_response(response)
        }
    }
}

/// Operation shape for `EnableApplicationLayerAutomaticResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_application_layer_automatic_response`](crate::client::Client::enable_application_layer_automatic_response).
///
/// See [`crate::client::fluent_builders::EnableApplicationLayerAutomaticResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableApplicationLayerAutomaticResponse {
    _private: (),
}
impl EnableApplicationLayerAutomaticResponse {
    /// Creates a new builder-style object to manufacture [`EnableApplicationLayerAutomaticResponseInput`](crate::input::EnableApplicationLayerAutomaticResponseInput)
    pub fn builder() -> crate::input::enable_application_layer_automatic_response_input::Builder {
        crate::input::enable_application_layer_automatic_response_input::Builder::default()
    }
    /// Creates a new `EnableApplicationLayerAutomaticResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableApplicationLayerAutomaticResponse {
    type Output = std::result::Result<
        crate::output::EnableApplicationLayerAutomaticResponseOutput,
        crate::error::EnableApplicationLayerAutomaticResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_application_layer_automatic_response_error(
                response,
            )
        } else {
            crate::operation_deser::parse_enable_application_layer_automatic_response_response(
                response,
            )
        }
    }
}

/// Operation shape for `EnableProactiveEngagement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_proactive_engagement`](crate::client::Client::enable_proactive_engagement).
///
/// See [`crate::client::fluent_builders::EnableProactiveEngagement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableProactiveEngagement {
    _private: (),
}
impl EnableProactiveEngagement {
    /// Creates a new builder-style object to manufacture [`EnableProactiveEngagementInput`](crate::input::EnableProactiveEngagementInput)
    pub fn builder() -> crate::input::enable_proactive_engagement_input::Builder {
        crate::input::enable_proactive_engagement_input::Builder::default()
    }
    /// Creates a new `EnableProactiveEngagement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableProactiveEngagement {
    type Output = std::result::Result<
        crate::output::EnableProactiveEngagementOutput,
        crate::error::EnableProactiveEngagementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_proactive_engagement_error(response)
        } else {
            crate::operation_deser::parse_enable_proactive_engagement_response(response)
        }
    }
}

/// Operation shape for `GetSubscriptionState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_subscription_state`](crate::client::Client::get_subscription_state).
///
/// See [`crate::client::fluent_builders::GetSubscriptionState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSubscriptionState {
    _private: (),
}
impl GetSubscriptionState {
    /// Creates a new builder-style object to manufacture [`GetSubscriptionStateInput`](crate::input::GetSubscriptionStateInput)
    pub fn builder() -> crate::input::get_subscription_state_input::Builder {
        crate::input::get_subscription_state_input::Builder::default()
    }
    /// Creates a new `GetSubscriptionState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSubscriptionState {
    type Output = std::result::Result<
        crate::output::GetSubscriptionStateOutput,
        crate::error::GetSubscriptionStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_subscription_state_error(response)
        } else {
            crate::operation_deser::parse_get_subscription_state_response(response)
        }
    }
}

/// Operation shape for `ListAttacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attacks`](crate::client::Client::list_attacks).
///
/// See [`crate::client::fluent_builders::ListAttacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttacks {
    _private: (),
}
impl ListAttacks {
    /// Creates a new builder-style object to manufacture [`ListAttacksInput`](crate::input::ListAttacksInput)
    pub fn builder() -> crate::input::list_attacks_input::Builder {
        crate::input::list_attacks_input::Builder::default()
    }
    /// Creates a new `ListAttacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttacks {
    type Output =
        std::result::Result<crate::output::ListAttacksOutput, crate::error::ListAttacksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attacks_error(response)
        } else {
            crate::operation_deser::parse_list_attacks_response(response)
        }
    }
}

/// Operation shape for `ListProtectionGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_protection_groups`](crate::client::Client::list_protection_groups).
///
/// See [`crate::client::fluent_builders::ListProtectionGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProtectionGroups {
    _private: (),
}
impl ListProtectionGroups {
    /// Creates a new builder-style object to manufacture [`ListProtectionGroupsInput`](crate::input::ListProtectionGroupsInput)
    pub fn builder() -> crate::input::list_protection_groups_input::Builder {
        crate::input::list_protection_groups_input::Builder::default()
    }
    /// Creates a new `ListProtectionGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProtectionGroups {
    type Output = std::result::Result<
        crate::output::ListProtectionGroupsOutput,
        crate::error::ListProtectionGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_protection_groups_error(response)
        } else {
            crate::operation_deser::parse_list_protection_groups_response(response)
        }
    }
}

/// Operation shape for `ListProtections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_protections`](crate::client::Client::list_protections).
///
/// See [`crate::client::fluent_builders::ListProtections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProtections {
    _private: (),
}
impl ListProtections {
    /// Creates a new builder-style object to manufacture [`ListProtectionsInput`](crate::input::ListProtectionsInput)
    pub fn builder() -> crate::input::list_protections_input::Builder {
        crate::input::list_protections_input::Builder::default()
    }
    /// Creates a new `ListProtections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProtections {
    type Output = std::result::Result<
        crate::output::ListProtectionsOutput,
        crate::error::ListProtectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_protections_error(response)
        } else {
            crate::operation_deser::parse_list_protections_response(response)
        }
    }
}

/// Operation shape for `ListResourcesInProtectionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources_in_protection_group`](crate::client::Client::list_resources_in_protection_group).
///
/// See [`crate::client::fluent_builders::ListResourcesInProtectionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourcesInProtectionGroup {
    _private: (),
}
impl ListResourcesInProtectionGroup {
    /// Creates a new builder-style object to manufacture [`ListResourcesInProtectionGroupInput`](crate::input::ListResourcesInProtectionGroupInput)
    pub fn builder() -> crate::input::list_resources_in_protection_group_input::Builder {
        crate::input::list_resources_in_protection_group_input::Builder::default()
    }
    /// Creates a new `ListResourcesInProtectionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourcesInProtectionGroup {
    type Output = std::result::Result<
        crate::output::ListResourcesInProtectionGroupOutput,
        crate::error::ListResourcesInProtectionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_in_protection_group_error(response)
        } else {
            crate::operation_deser::parse_list_resources_in_protection_group_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApplicationLayerAutomaticResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_application_layer_automatic_response`](crate::client::Client::update_application_layer_automatic_response).
///
/// See [`crate::client::fluent_builders::UpdateApplicationLayerAutomaticResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApplicationLayerAutomaticResponse {
    _private: (),
}
impl UpdateApplicationLayerAutomaticResponse {
    /// Creates a new builder-style object to manufacture [`UpdateApplicationLayerAutomaticResponseInput`](crate::input::UpdateApplicationLayerAutomaticResponseInput)
    pub fn builder() -> crate::input::update_application_layer_automatic_response_input::Builder {
        crate::input::update_application_layer_automatic_response_input::Builder::default()
    }
    /// Creates a new `UpdateApplicationLayerAutomaticResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApplicationLayerAutomaticResponse {
    type Output = std::result::Result<
        crate::output::UpdateApplicationLayerAutomaticResponseOutput,
        crate::error::UpdateApplicationLayerAutomaticResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_application_layer_automatic_response_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_application_layer_automatic_response_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateEmergencyContactSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_emergency_contact_settings`](crate::client::Client::update_emergency_contact_settings).
///
/// See [`crate::client::fluent_builders::UpdateEmergencyContactSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEmergencyContactSettings {
    _private: (),
}
impl UpdateEmergencyContactSettings {
    /// Creates a new builder-style object to manufacture [`UpdateEmergencyContactSettingsInput`](crate::input::UpdateEmergencyContactSettingsInput)
    pub fn builder() -> crate::input::update_emergency_contact_settings_input::Builder {
        crate::input::update_emergency_contact_settings_input::Builder::default()
    }
    /// Creates a new `UpdateEmergencyContactSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEmergencyContactSettings {
    type Output = std::result::Result<
        crate::output::UpdateEmergencyContactSettingsOutput,
        crate::error::UpdateEmergencyContactSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_emergency_contact_settings_error(response)
        } else {
            crate::operation_deser::parse_update_emergency_contact_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateProtectionGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_protection_group`](crate::client::Client::update_protection_group).
///
/// See [`crate::client::fluent_builders::UpdateProtectionGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProtectionGroup {
    _private: (),
}
impl UpdateProtectionGroup {
    /// Creates a new builder-style object to manufacture [`UpdateProtectionGroupInput`](crate::input::UpdateProtectionGroupInput)
    pub fn builder() -> crate::input::update_protection_group_input::Builder {
        crate::input::update_protection_group_input::Builder::default()
    }
    /// Creates a new `UpdateProtectionGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProtectionGroup {
    type Output = std::result::Result<
        crate::output::UpdateProtectionGroupOutput,
        crate::error::UpdateProtectionGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_protection_group_error(response)
        } else {
            crate::operation_deser::parse_update_protection_group_response(response)
        }
    }
}

/// Operation shape for `UpdateSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_subscription`](crate::client::Client::update_subscription).
///
/// See [`crate::client::fluent_builders::UpdateSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSubscription {
    _private: (),
}
impl UpdateSubscription {
    /// Creates a new builder-style object to manufacture [`UpdateSubscriptionInput`](crate::input::UpdateSubscriptionInput)
    pub fn builder() -> crate::input::update_subscription_input::Builder {
        crate::input::update_subscription_input::Builder::default()
    }
    /// Creates a new `UpdateSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSubscription {
    type Output = std::result::Result<
        crate::output::UpdateSubscriptionOutput,
        crate::error::UpdateSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_subscription_error(response)
        } else {
            crate::operation_deser::parse_update_subscription_response(response)
        }
    }
}
