// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSShield_20160616`.
///
/// This client allows ergonomic access to a `AWSShield_20160616`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateDRTLogBucket` operation.
    ///
    /// See [`AssociateDRTLogBucket`](crate::client::fluent_builders::AssociateDRTLogBucket) for more information about the
    /// operation and its arguments.
    pub fn associate_drt_log_bucket(&self) -> fluent_builders::AssociateDRTLogBucket<C, M, R> {
        fluent_builders::AssociateDRTLogBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDRTRole` operation.
    ///
    /// See [`AssociateDRTRole`](crate::client::fluent_builders::AssociateDRTRole) for more information about the
    /// operation and its arguments.
    pub fn associate_drt_role(&self) -> fluent_builders::AssociateDRTRole<C, M, R> {
        fluent_builders::AssociateDRTRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateHealthCheck` operation.
    ///
    /// See [`AssociateHealthCheck`](crate::client::fluent_builders::AssociateHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn associate_health_check(&self) -> fluent_builders::AssociateHealthCheck<C, M, R> {
        fluent_builders::AssociateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateProactiveEngagementDetails` operation.
    ///
    /// See [`AssociateProactiveEngagementDetails`](crate::client::fluent_builders::AssociateProactiveEngagementDetails) for more information about the
    /// operation and its arguments.
    pub fn associate_proactive_engagement_details(
        &self,
    ) -> fluent_builders::AssociateProactiveEngagementDetails<C, M, R> {
        fluent_builders::AssociateProactiveEngagementDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProtection` operation.
    ///
    /// See [`CreateProtection`](crate::client::fluent_builders::CreateProtection) for more information about the
    /// operation and its arguments.
    pub fn create_protection(&self) -> fluent_builders::CreateProtection<C, M, R> {
        fluent_builders::CreateProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProtectionGroup` operation.
    ///
    /// See [`CreateProtectionGroup`](crate::client::fluent_builders::CreateProtectionGroup) for more information about the
    /// operation and its arguments.
    pub fn create_protection_group(&self) -> fluent_builders::CreateProtectionGroup<C, M, R> {
        fluent_builders::CreateProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubscription` operation.
    ///
    /// See [`CreateSubscription`](crate::client::fluent_builders::CreateSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_subscription(&self) -> fluent_builders::CreateSubscription<C, M, R> {
        fluent_builders::CreateSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProtection` operation.
    ///
    /// See [`DeleteProtection`](crate::client::fluent_builders::DeleteProtection) for more information about the
    /// operation and its arguments.
    pub fn delete_protection(&self) -> fluent_builders::DeleteProtection<C, M, R> {
        fluent_builders::DeleteProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProtectionGroup` operation.
    ///
    /// See [`DeleteProtectionGroup`](crate::client::fluent_builders::DeleteProtectionGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_protection_group(&self) -> fluent_builders::DeleteProtectionGroup<C, M, R> {
        fluent_builders::DeleteProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubscription` operation.
    ///
    /// See [`DeleteSubscription`](crate::client::fluent_builders::DeleteSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_subscription(&self) -> fluent_builders::DeleteSubscription<C, M, R> {
        fluent_builders::DeleteSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAttack` operation.
    ///
    /// See [`DescribeAttack`](crate::client::fluent_builders::DescribeAttack) for more information about the
    /// operation and its arguments.
    pub fn describe_attack(&self) -> fluent_builders::DescribeAttack<C, M, R> {
        fluent_builders::DescribeAttack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAttackStatistics` operation.
    ///
    /// See [`DescribeAttackStatistics`](crate::client::fluent_builders::DescribeAttackStatistics) for more information about the
    /// operation and its arguments.
    pub fn describe_attack_statistics(&self) -> fluent_builders::DescribeAttackStatistics<C, M, R> {
        fluent_builders::DescribeAttackStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDRTAccess` operation.
    ///
    /// See [`DescribeDRTAccess`](crate::client::fluent_builders::DescribeDRTAccess) for more information about the
    /// operation and its arguments.
    pub fn describe_drt_access(&self) -> fluent_builders::DescribeDRTAccess<C, M, R> {
        fluent_builders::DescribeDRTAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEmergencyContactSettings` operation.
    ///
    /// See [`DescribeEmergencyContactSettings`](crate::client::fluent_builders::DescribeEmergencyContactSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_emergency_contact_settings(
        &self,
    ) -> fluent_builders::DescribeEmergencyContactSettings<C, M, R> {
        fluent_builders::DescribeEmergencyContactSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProtection` operation.
    ///
    /// See [`DescribeProtection`](crate::client::fluent_builders::DescribeProtection) for more information about the
    /// operation and its arguments.
    pub fn describe_protection(&self) -> fluent_builders::DescribeProtection<C, M, R> {
        fluent_builders::DescribeProtection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProtectionGroup` operation.
    ///
    /// See [`DescribeProtectionGroup`](crate::client::fluent_builders::DescribeProtectionGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_protection_group(&self) -> fluent_builders::DescribeProtectionGroup<C, M, R> {
        fluent_builders::DescribeProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubscription` operation.
    ///
    /// See [`DescribeSubscription`](crate::client::fluent_builders::DescribeSubscription) for more information about the
    /// operation and its arguments.
    pub fn describe_subscription(&self) -> fluent_builders::DescribeSubscription<C, M, R> {
        fluent_builders::DescribeSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableProactiveEngagement` operation.
    ///
    /// See [`DisableProactiveEngagement`](crate::client::fluent_builders::DisableProactiveEngagement) for more information about the
    /// operation and its arguments.
    pub fn disable_proactive_engagement(
        &self,
    ) -> fluent_builders::DisableProactiveEngagement<C, M, R> {
        fluent_builders::DisableProactiveEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDRTLogBucket` operation.
    ///
    /// See [`DisassociateDRTLogBucket`](crate::client::fluent_builders::DisassociateDRTLogBucket) for more information about the
    /// operation and its arguments.
    pub fn disassociate_drt_log_bucket(
        &self,
    ) -> fluent_builders::DisassociateDRTLogBucket<C, M, R> {
        fluent_builders::DisassociateDRTLogBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDRTRole` operation.
    ///
    /// See [`DisassociateDRTRole`](crate::client::fluent_builders::DisassociateDRTRole) for more information about the
    /// operation and its arguments.
    pub fn disassociate_drt_role(&self) -> fluent_builders::DisassociateDRTRole<C, M, R> {
        fluent_builders::DisassociateDRTRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateHealthCheck` operation.
    ///
    /// See [`DisassociateHealthCheck`](crate::client::fluent_builders::DisassociateHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn disassociate_health_check(&self) -> fluent_builders::DisassociateHealthCheck<C, M, R> {
        fluent_builders::DisassociateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableProactiveEngagement` operation.
    ///
    /// See [`EnableProactiveEngagement`](crate::client::fluent_builders::EnableProactiveEngagement) for more information about the
    /// operation and its arguments.
    pub fn enable_proactive_engagement(
        &self,
    ) -> fluent_builders::EnableProactiveEngagement<C, M, R> {
        fluent_builders::EnableProactiveEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSubscriptionState` operation.
    ///
    /// See [`GetSubscriptionState`](crate::client::fluent_builders::GetSubscriptionState) for more information about the
    /// operation and its arguments.
    pub fn get_subscription_state(&self) -> fluent_builders::GetSubscriptionState<C, M, R> {
        fluent_builders::GetSubscriptionState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttacks` operation.
    ///
    /// See [`ListAttacks`](crate::client::fluent_builders::ListAttacks) for more information about the
    /// operation and its arguments.
    pub fn list_attacks(&self) -> fluent_builders::ListAttacks<C, M, R> {
        fluent_builders::ListAttacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProtectionGroups` operation.
    ///
    /// See [`ListProtectionGroups`](crate::client::fluent_builders::ListProtectionGroups) for more information about the
    /// operation and its arguments.
    pub fn list_protection_groups(&self) -> fluent_builders::ListProtectionGroups<C, M, R> {
        fluent_builders::ListProtectionGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProtections` operation.
    ///
    /// See [`ListProtections`](crate::client::fluent_builders::ListProtections) for more information about the
    /// operation and its arguments.
    pub fn list_protections(&self) -> fluent_builders::ListProtections<C, M, R> {
        fluent_builders::ListProtections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourcesInProtectionGroup` operation.
    ///
    /// See [`ListResourcesInProtectionGroup`](crate::client::fluent_builders::ListResourcesInProtectionGroup) for more information about the
    /// operation and its arguments.
    pub fn list_resources_in_protection_group(
        &self,
    ) -> fluent_builders::ListResourcesInProtectionGroup<C, M, R> {
        fluent_builders::ListResourcesInProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEmergencyContactSettings` operation.
    ///
    /// See [`UpdateEmergencyContactSettings`](crate::client::fluent_builders::UpdateEmergencyContactSettings) for more information about the
    /// operation and its arguments.
    pub fn update_emergency_contact_settings(
        &self,
    ) -> fluent_builders::UpdateEmergencyContactSettings<C, M, R> {
        fluent_builders::UpdateEmergencyContactSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProtectionGroup` operation.
    ///
    /// See [`UpdateProtectionGroup`](crate::client::fluent_builders::UpdateProtectionGroup) for more information about the
    /// operation and its arguments.
    pub fn update_protection_group(&self) -> fluent_builders::UpdateProtectionGroup<C, M, R> {
        fluent_builders::UpdateProtectionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubscription` operation.
    ///
    /// See [`UpdateSubscription`](crate::client::fluent_builders::UpdateSubscription) for more information about the
    /// operation and its arguments.
    pub fn update_subscription(&self) -> fluent_builders::UpdateSubscription<C, M, R> {
        fluent_builders::UpdateSubscription::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateDRTLogBucket`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.</p>
    /// <p>To use the services of the SRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDRTLogBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_drt_log_bucket_input::Builder,
    }
    impl<C, M, R> AssociateDRTLogBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDRTLogBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDrtLogBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDRTLogBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDrtLogBucketInputOperationOutputAlias,
                crate::output::AssociateDrtLogBucketOutput,
                crate::error::AssociateDRTLogBucketError,
                crate::input::AssociateDrtLogBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn log_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_bucket(inp);
            self
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn set_log_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDRTRole`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.</p>
    /// <p>You can associate only one <code>RoleArn</code> with your subscription. If you submit an <code>AssociateDRTRole</code> request for an account that already has an associated role, the new <code>RoleArn</code> will replace the existing <code>RoleArn</code>. </p>
    /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to the role you will specify in the request. For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>. The role must also trust the service principal <code> drt.shield.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON Policy Elements: Principal</a>.</p>
    ///
    /// <p>The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT takes these actions only if explicitly authorized by you.</p>
    /// <p>You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>
    /// <p>To use the services of the SRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDRTRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_drt_role_input::Builder,
    }
    impl<C, M, R> AssociateDRTRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDRTRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDrtRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDRTRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDrtRoleInputOperationOutputAlias,
                crate::output::AssociateDrtRoleOutput,
                crate::error::AssociateDRTRoleError,
                crate::input::AssociateDrtRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p>
        /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role.  For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role the SRT will use to access your Amazon Web Services account.</p>
        /// <p>Prior to making the <code>AssociateDRTRole</code> request, you must attach the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy">AWSShieldDRTAccessPolicy</a> managed policy to this role.  For more information see <a href=" https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Attaching and Detaching IAM Policies</a>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateHealthCheck`.
    ///
    /// <p>Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation.  </p>
    /// <p>You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_health_check_input::Builder,
    }
    impl<C, M, R> AssociateHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateHealthCheckInputOperationOutputAlias,
                crate::output::AssociateHealthCheckOutput,
                crate::error::AssociateHealthCheckError,
                crate::input::AssociateHealthCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to add the health check association to. </p>
        pub fn protection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to add the health check association to. </p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>
        pub fn health_check_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check to associate with the protection.</p>
        pub fn set_health_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateProactiveEngagementDetails`.
    ///
    /// <p>Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list. </p>
    /// <p>After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>.  </p>
    /// <note>
    /// <p>This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support.</p>
    /// <p>The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it to this call.  </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateProactiveEngagementDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_proactive_engagement_details_input::Builder,
    }
    impl<C, M, R> AssociateProactiveEngagementDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateProactiveEngagementDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateProactiveEngagementDetailsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateProactiveEngagementDetailsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateProactiveEngagementDetailsInputOperationOutputAlias,
                crate::output::AssociateProactiveEngagementDetailsOutput,
                crate::error::AssociateProactiveEngagementDetailsError,
                crate::input::AssociateProactiveEngagementDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EmergencyContactList`.
        ///
        /// To override the contents of this collection use [`set_emergency_contact_list`](Self::set_emergency_contact_list).
        ///
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p>
        /// <p>To enable proactive engagement, the contact list must include at least one phone number.</p>
        /// <note>
        /// <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here.  </p>
        /// </note>
        pub fn emergency_contact_list(
            mut self,
            inp: impl Into<crate::model::EmergencyContact>,
        ) -> Self {
            self.inner = self.inner.emergency_contact_list(inp);
            self
        }
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support. </p>
        /// <p>To enable proactive engagement, the contact list must include at least one phone number.</p>
        /// <note>
        /// <p>The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and then provide it here.  </p>
        /// </note>
        pub fn set_emergency_contact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EmergencyContact>>,
        ) -> Self {
            self.inner = self.inner.set_emergency_contact_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProtection`.
    ///
    /// <p>Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Elastic Load Balancing load balancer, Global Accelerator accelerator, Elastic IP Address, or an Amazon Route 53 hosted zone.</p>
    /// <p>You can add protection to only a single resource with each CreateProtection request. If you want to add protection to multiple resources at once, use the <a href="https://console.aws.amazon.com/waf/">WAF console</a>. For more information see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with Shield Advanced</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Add Shield Advanced Protection to more Amazon Web Services Resources</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_protection_input::Builder,
    }
    impl<C, M, R> CreateProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProtectionInputOperationOutputAlias,
                crate::output::CreateProtectionOutput,
                crate::error::CreateProtectionError,
                crate::input::CreateProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Friendly name for the <code>Protection</code> you are creating.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Friendly name for the <code>Protection</code> you are creating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource to be protected.</p>
        /// <p>The ARN should be in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For Amazon Route 53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource to be protected.</p>
        /// <p>The ARN should be in one of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Elastic Load Balancer (Classic Load Balancer): <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Amazon CloudFront distribution: <code>arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Global Accelerator accelerator: <code>arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For Amazon Route 53: <code>arn:aws:route53:::hostedzone/<i>hosted-zone-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For an Elastic IP address: <code>arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the <a>Protection</a> object that is created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tag key-value pairs for the <a>Protection</a> object that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProtectionGroup`.
    ///
    /// <p>Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProtectionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_protection_group_input::Builder,
    }
    impl<C, M, R> CreateProtectionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProtectionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProtectionGroupInputOperationOutputAlias,
                crate::output::CreateProtectionGroupOutput,
                crate::error::CreateProtectionGroupError,
                crate::input::CreateProtectionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(inp);
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li>
        /// <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p>
        /// </li>
        /// <li>
        /// <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p>
        /// </li>
        /// <li>
        /// <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p>
        /// </li>
        /// </ul>
        pub fn aggregation(mut self, inp: crate::model::ProtectionGroupAggregation) -> Self {
            self.inner = self.inner.aggregation(inp);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li>
        /// <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p>
        /// </li>
        /// <li>
        /// <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p>
        /// </li>
        /// <li>
        /// <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.</p>
        /// </li>
        /// </ul>
        pub fn set_aggregation(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupAggregation>,
        ) -> Self {
            self.inner = self.inner.set_aggregation(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>
        pub fn pattern(mut self, inp: crate::model::ProtectionGroupPattern) -> Self {
            self.inner = self.inner.pattern(inp);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. </p>
        pub fn set_pattern(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPattern>,
        ) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group.
        /// You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn resource_type(mut self, inp: crate::model::ProtectedResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group.
        /// You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ProtectedResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.members(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the protection group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tag key-value pairs for the protection group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscription`.
    ///
    /// <p>Activates Shield Advanced for an account.</p>
    ///
    /// <p>When you initally create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period.  You can change this by submitting an <code>UpdateSubscription</code> request. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subscription_input::Builder,
    }
    impl<C, M, R> CreateSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubscriptionInputOperationOutputAlias,
                crate::output::CreateSubscriptionOutput,
                crate::error::CreateSubscriptionError,
                crate::input::CreateSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteProtection`.
    ///
    /// <p>Deletes an Shield Advanced <a>Protection</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_protection_input::Builder,
    }
    impl<C, M, R> DeleteProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProtectionInputOperationOutputAlias,
                crate::output::DeleteProtectionOutput,
                crate::error::DeleteProtectionError,
                crate::input::DeleteProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to be
        /// deleted.</p>
        pub fn protection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to be
        /// deleted.</p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProtectionGroup`.
    ///
    /// <p>Removes the specified protection group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProtectionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_protection_group_input::Builder,
    }
    impl<C, M, R> DeleteProtectionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProtectionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProtectionGroupInputOperationOutputAlias,
                crate::output::DeleteProtectionGroupOutput,
                crate::error::DeleteProtectionGroupError,
                crate::input::DeleteProtectionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(inp);
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscription`.
    ///
    /// <p>Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_subscription_input::Builder,
    }
    impl<C, M, R> DeleteSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSubscriptionInputOperationOutputAlias,
                crate::output::DeleteSubscriptionOutput,
                crate::error::DeleteSubscriptionError,
                crate::input::DeleteSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAttack`.
    ///
    /// <p>Describes the details of a DDoS attack. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAttack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_attack_input::Builder,
    }
    impl<C, M, R> DescribeAttack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAttack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttackOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAttackInputOperationOutputAlias,
                crate::output::DescribeAttackOutput,
                crate::error::DescribeAttackError,
                crate::input::DescribeAttackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the attack that to be described.</p>
        pub fn attack_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attack_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the attack that to be described.</p>
        pub fn set_attack_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_attack_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAttackStatistics`.
    ///
    /// <p>Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.</p>
    /// <p>The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example, if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to <code>2020-10-26 00:00:00 UTC</code>. </p>
    /// <p>The time range indicates the period covered by the attack statistics data items.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAttackStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_attack_statistics_input::Builder,
    }
    impl<C, M, R> DescribeAttackStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAttackStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAttackStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAttackStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAttackStatisticsInputOperationOutputAlias,
                crate::output::DescribeAttackStatisticsOutput,
                crate::error::DescribeAttackStatisticsError,
                crate::input::DescribeAttackStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDRTAccess`.
    ///
    /// <p>Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDRTAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_drt_access_input::Builder,
    }
    impl<C, M, R> DescribeDRTAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDRTAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDrtAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDRTAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDrtAccessInputOperationOutputAlias,
                crate::output::DescribeDrtAccessOutput,
                crate::error::DescribeDRTAccessError,
                crate::input::DescribeDrtAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeEmergencyContactSettings`.
    ///
    /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEmergencyContactSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_emergency_contact_settings_input::Builder,
    }
    impl<C, M, R> DescribeEmergencyContactSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEmergencyContactSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEmergencyContactSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEmergencyContactSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEmergencyContactSettingsInputOperationOutputAlias,
                crate::output::DescribeEmergencyContactSettingsOutput,
                crate::error::DescribeEmergencyContactSettingsError,
                crate::input::DescribeEmergencyContactSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeProtection`.
    ///
    /// <p>Lists the details of a <a>Protection</a> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProtection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_protection_input::Builder,
    }
    impl<C, M, R> DescribeProtection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProtection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProtectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProtectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProtectionInputOperationOutputAlias,
                crate::output::DescribeProtectionOutput,
                crate::error::DescribeProtectionError,
                crate::input::DescribeProtectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object that is
        /// described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn protection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object that is
        /// described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <a>Protection</a> object that is
        /// described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the Amazon Web Services resource for the <a>Protection</a> object that is
        /// described. When submitting the <code>DescribeProtection</code> request you must provide either the <code>ResourceArn</code> or the <code>ProtectionID</code>, but not both.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProtectionGroup`.
    ///
    /// <p>Returns the specification for the specified protection group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProtectionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_protection_group_input::Builder,
    }
    impl<C, M, R> DescribeProtectionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProtectionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProtectionGroupInputOperationOutputAlias,
                crate::output::DescribeProtectionGroupOutput,
                crate::error::DescribeProtectionGroupError,
                crate::input::DescribeProtectionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(inp);
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscription`.
    ///
    /// <p>Provides details about the Shield Advanced subscription for an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_subscription_input::Builder,
    }
    impl<C, M, R> DescribeSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSubscriptionInputOperationOutputAlias,
                crate::output::DescribeSubscriptionOutput,
                crate::error::DescribeSubscriptionError,
                crate::input::DescribeSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableProactiveEngagement`.
    ///
    /// <p>Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableProactiveEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_proactive_engagement_input::Builder,
    }
    impl<C, M, R> DisableProactiveEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableProactiveEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableProactiveEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableProactiveEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableProactiveEngagementInputOperationOutputAlias,
                crate::output::DisableProactiveEngagementOutput,
                crate::error::DisableProactiveEngagementError,
                crate::input::DisableProactiveEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateDRTLogBucket`.
    ///
    /// <p>Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.</p>
    /// <p>To make a <code>DisassociateDRTLogBucket</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are not subscribed to one of these support plans, but had been previously and had granted the SRT access to your account, you can submit a <code>DisassociateDRTLogBucket</code> request to remove this access.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateDRTLogBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_drt_log_bucket_input::Builder,
    }
    impl<C, M, R> DisassociateDRTLogBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDRTLogBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDrtLogBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDRTLogBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDrtLogBucketInputOperationOutputAlias,
                crate::output::DisassociateDrtLogBucketOutput,
                crate::error::DisassociateDRTLogBucketError,
                crate::input::DisassociateDrtLogBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn log_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_bucket(inp);
            self
        }
        /// <p>The Amazon S3 bucket that contains the logs that you want to share.</p>
        pub fn set_log_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDRTRole`.
    ///
    /// <p>Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.</p>
    /// <p>To make a <code>DisassociateDRTRole</code> request, you must be subscribed to the <a href="https://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a href="https://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>. However, if you are not subscribed to one of these support plans, but had been previously and had granted the SRT access to your account, you can submit a <code>DisassociateDRTRole</code> request to remove this access.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateDRTRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_drt_role_input::Builder,
    }
    impl<C, M, R> DisassociateDRTRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDRTRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDrtRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDRTRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDrtRoleInputOperationOutputAlias,
                crate::output::DisassociateDrtRoleOutput,
                crate::error::DisassociateDRTRoleError,
                crate::input::DisassociateDrtRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateHealthCheck`.
    ///
    /// <p>Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation. </p>
    /// <p>You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced protection. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option">Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_health_check_input::Builder,
    }
    impl<C, M, R> DisassociateHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateHealthCheckInputOperationOutputAlias,
                crate::output::DisassociateHealthCheckOutput,
                crate::error::DisassociateHealthCheckError,
                crate::input::DisassociateHealthCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from. </p>
        pub fn protection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_id(inp);
            self
        }
        /// <p>The unique identifier (ID) for the <a>Protection</a> object to remove the health check association from. </p>
        pub fn set_protection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>
        pub fn health_check_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the health check that is associated with the protection.</p>
        pub fn set_health_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableProactiveEngagement`.
    ///
    /// <p>Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableProactiveEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_proactive_engagement_input::Builder,
    }
    impl<C, M, R> EnableProactiveEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableProactiveEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableProactiveEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableProactiveEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableProactiveEngagementInputOperationOutputAlias,
                crate::output::EnableProactiveEngagementOutput,
                crate::error::EnableProactiveEngagementError,
                crate::input::EnableProactiveEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSubscriptionState`.
    ///
    /// <p>Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSubscriptionState<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_subscription_state_input::Builder,
    }
    impl<C, M, R> GetSubscriptionState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSubscriptionState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSubscriptionStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSubscriptionStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSubscriptionStateInputOperationOutputAlias,
                crate::output::GetSubscriptionStateOutput,
                crate::error::GetSubscriptionStateError,
                crate::input::GetSubscriptionStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAttacks`.
    ///
    /// <p>Returns all ongoing DDoS attacks or all DDoS attacks during a specified time
    /// period.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttacks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attacks_input::Builder,
    }
    impl<C, M, R> ListAttacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttacksInputOperationOutputAlias,
                crate::output::ListAttacksOutput,
                crate::error::ListAttacksError,
                crate::input::ListAttacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked. If this is left
        /// blank, all applicable resources for this account will be included.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource that was attacked. If this is left
        /// blank, all applicable resources for this account will be included.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a>  is allowed.  </p>
        pub fn start_time(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a>  is allowed.  </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a>  is allowed.  </p>
        pub fn end_time(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time period for the attacks. This is a <code>timestamp</code> type. The sample request above indicates a <code>number</code> type because the default used by WAF is Unix time in seconds. However any valid <a href="http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types">timestamp format</a>  is allowed.  </p>
        pub fn set_end_time(mut self, input: std::option::Option<crate::model::TimeRange>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The <code>ListAttacksRequest.NextMarker</code> value from a previous call to <code>ListAttacksRequest</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>ListAttacksRequest.NextMarker</code> value from a previous call to <code>ListAttacksRequest</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of <a>AttackSummary</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtectionGroups`.
    ///
    /// <p>Retrieves the <a>ProtectionGroup</a> objects for the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProtectionGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_protection_groups_input::Builder,
    }
    impl<C, M, R> ListProtectionGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProtectionGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtectionGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtectionGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProtectionGroupsInputOperationOutputAlias,
                crate::output::ListProtectionGroupsOutput,
                crate::error::ListProtectionGroupsError,
                crate::input::ListProtectionGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The next token value from a previous call to <code>ListProtectionGroups</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token value from a previous call to <code>ListProtectionGroups</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of <a>ProtectionGroup</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of <a>ProtectionGroup</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProtections`.
    ///
    /// <p>Lists all <a>Protection</a> objects for the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProtections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_protections_input::Builder,
    }
    impl<C, M, R> ListProtections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProtections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProtectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProtectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProtectionsInputOperationOutputAlias,
                crate::output::ListProtectionsOutput,
                crate::error::ListProtectionsError,
                crate::input::ListProtectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ListProtectionsRequest.NextToken</code> value from a previous call to <code>ListProtections</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>ListProtectionsRequest.NextToken</code> value from a previous call to <code>ListProtections</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of <a>Protection</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of <a>Protection</a> objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesInProtectionGroup`.
    ///
    /// <p>Retrieves the resources that are included in the protection group. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourcesInProtectionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_in_protection_group_input::Builder,
    }
    impl<C, M, R> ListResourcesInProtectionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourcesInProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesInProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesInProtectionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesInProtectionGroupInputOperationOutputAlias,
                crate::output::ListResourcesInProtectionGroupOutput,
                crate::error::ListResourcesInProtectionGroupError,
                crate::input::ListResourcesInProtectionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(inp);
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>The next token value from a previous call to <code>ListResourcesInProtectionGroup</code>. Pass null if this is the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The next token value from a previous call to <code>ListResourcesInProtectionGroup</code>. Pass null if this is the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of resource ARN objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of resource ARN objects to return. If you leave this blank,
        /// Shield Advanced returns the first 20 results.</p>
        /// <p>This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than <code>MaxResults</code>, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in <code>NextToken</code> that you can use in your next request, to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in Shield.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to modify or add to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags that you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource in Shield.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmergencyContactSettings`.
    ///
    /// <p>Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEmergencyContactSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_emergency_contact_settings_input::Builder,
    }
    impl<C, M, R> UpdateEmergencyContactSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmergencyContactSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmergencyContactSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmergencyContactSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmergencyContactSettingsInputOperationOutputAlias,
                crate::output::UpdateEmergencyContactSettingsOutput,
                crate::error::UpdateEmergencyContactSettingsError,
                crate::input::UpdateEmergencyContactSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EmergencyContactList`.
        ///
        /// To override the contents of this collection use [`set_emergency_contact_list`](Self::set_emergency_contact_list).
        ///
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>
        pub fn emergency_contact_list(
            mut self,
            inp: impl Into<crate::model::EmergencyContact>,
        ) -> Self {
            self.inner = self.inner.emergency_contact_list(inp);
            self
        }
        /// <p>A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.</p>
        /// <p>If you have proactive engagement enabled, the contact list must include at least one phone number.</p>
        pub fn set_emergency_contact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EmergencyContact>>,
        ) -> Self {
            self.inner = self.inner.set_emergency_contact_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProtectionGroup`.
    ///
    /// <p>Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProtectionGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_protection_group_input::Builder,
    }
    impl<C, M, R> UpdateProtectionGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProtectionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProtectionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProtectionGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProtectionGroupInputOperationOutputAlias,
                crate::output::UpdateProtectionGroupOutput,
                crate::error::UpdateProtectionGroupError,
                crate::input::UpdateProtectionGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn protection_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protection_group_id(inp);
            self
        }
        /// <p>The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. </p>
        pub fn set_protection_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_protection_group_id(input);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li>
        /// <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p>
        /// </li>
        /// <li>
        /// <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p>
        /// </li>
        /// <li>
        /// <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p>
        /// </li>
        /// </ul>
        pub fn aggregation(mut self, inp: crate::model::ProtectionGroupAggregation) -> Self {
            self.inner = self.inner.aggregation(inp);
            self
        }
        /// <p>Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.</p>
        /// <ul>
        /// <li>
        /// <p>Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.</p>
        /// </li>
        /// <li>
        /// <p>Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.</p>
        /// </li>
        /// <li>
        /// <p>Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.</p>
        /// </li>
        /// </ul>
        pub fn set_aggregation(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupAggregation>,
        ) -> Self {
            self.inner = self.inner.set_aggregation(input);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn pattern(mut self, inp: crate::model::ProtectionGroupPattern) -> Self {
            self.inner = self.inner.pattern(inp);
            self
        }
        /// <p>The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.</p>
        pub fn set_pattern(
            mut self,
            input: std::option::Option<crate::model::ProtectionGroupPattern>,
        ) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group.
        /// You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn resource_type(mut self, inp: crate::model::ProtectedResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type to include in the protection group. All protected resources of this type are included in the protection group.
        /// You must set this when you set <code>Pattern</code> to <code>BY_RESOURCE_TYPE</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ProtectedResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn members(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.members(inp);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set <code>Pattern</code> to <code>ARBITRARY</code> and you must not set it for any other <code>Pattern</code> setting. </p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_members(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubscription`.
    ///
    /// <p>Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subscription_input::Builder,
    }
    impl<C, M, R> UpdateSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubscriptionInputOperationOutputAlias,
                crate::output::UpdateSubscriptionOutput,
                crate::error::UpdateSubscriptionError,
                crate::input::UpdateSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn auto_renew(mut self, inp: crate::model::AutoRenew) -> Self {
            self.inner = self.inner.auto_renew(inp);
            self
        }
        /// <p>When you initally create a subscription, <code>AutoRenew</code> is set to <code>ENABLED</code>. If <code>ENABLED</code>, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request. If the <code>UpdateSubscription</code> request does not included a value for <code>AutoRenew</code>, the existing value for <code>AutoRenew</code> remains unchanged.</p>
        pub fn set_auto_renew(
            mut self,
            input: std::option::Option<crate::model::AutoRenew>,
        ) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
