// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateDRTLogBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDRTLogBucketError {
    /// Kind of error that occurred.
    pub kind: AssociateDRTLogBucketErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDRTLogBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDRTLogBucketErrorKind {
    /// <p>In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>
    AccessDeniedForDependencyException(crate::error::AccessDeniedForDependencyException),
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the operation would exceed a limit.</p>
    LimitsExceededException(crate::error::LimitsExceededException),
    /// <p>The ARN of the role that you specifed does not exist.</p>
    NoAssociatedRoleException(crate::error::NoAssociatedRoleException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDRTLogBucketError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_inner) => {
                _inner.fmt(f)
            }
            AssociateDRTLogBucketErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::LimitsExceededException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::NoAssociatedRoleException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateDRTLogBucketErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDRTLogBucketError {
    fn code(&self) -> Option<&str> {
        AssociateDRTLogBucketError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDRTLogBucketError {
    /// Creates a new `AssociateDRTLogBucketError`.
    pub fn new(kind: AssociateDRTLogBucketErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDRTLogBucketError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDRTLogBucketErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDRTLogBucketError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDRTLogBucketErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::AccessDeniedForDependencyException`.
    pub fn is_access_denied_for_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::LimitsExceededException`.
    pub fn is_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::LimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::NoAssociatedRoleException`.
    pub fn is_no_associated_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::NoAssociatedRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTLogBucketErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTLogBucketErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateDRTLogBucketError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_inner) => {
                Some(_inner)
            }
            AssociateDRTLogBucketErrorKind::InternalErrorException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::InvalidOperationException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::LimitsExceededException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::NoAssociatedRoleException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::OptimisticLockException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateDRTLogBucketErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateDRTRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDRTRoleError {
    /// Kind of error that occurred.
    pub kind: AssociateDRTRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDRTRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDRTRoleErrorKind {
    /// <p>In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>
    AccessDeniedForDependencyException(crate::error::AccessDeniedForDependencyException),
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDRTRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDRTRoleErrorKind::AccessDeniedForDependencyException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateDRTRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDRTRoleError {
    fn code(&self) -> Option<&str> {
        AssociateDRTRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDRTRoleError {
    /// Creates a new `AssociateDRTRoleError`.
    pub fn new(kind: AssociateDRTRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDRTRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDRTRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDRTRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDRTRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::AccessDeniedForDependencyException`.
    pub fn is_access_denied_for_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::AccessDeniedForDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDRTRoleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDRTRoleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateDRTRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDRTRoleErrorKind::AccessDeniedForDependencyException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::InternalErrorException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::InvalidOperationException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::OptimisticLockException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateDRTRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateHealthCheckError {
    /// Kind of error that occurred.
    pub kind: AssociateHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateHealthCheckErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the operation would exceed a limit.</p>
    LimitsExceededException(crate::error::LimitsExceededException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateHealthCheckErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AssociateHealthCheckErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateHealthCheckErrorKind::LimitsExceededException(_inner) => _inner.fmt(f),
            AssociateHealthCheckErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            AssociateHealthCheckErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateHealthCheckError {
    fn code(&self) -> Option<&str> {
        AssociateHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateHealthCheckError {
    /// Creates a new `AssociateHealthCheckError`.
    pub fn new(kind: AssociateHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateHealthCheckErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHealthCheckErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateHealthCheckErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHealthCheckErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateHealthCheckErrorKind::LimitsExceededException`.
    pub fn is_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHealthCheckErrorKind::LimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateHealthCheckErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHealthCheckErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateHealthCheckErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateHealthCheckErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateHealthCheckErrorKind::InternalErrorException(_inner) => Some(_inner),
            AssociateHealthCheckErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateHealthCheckErrorKind::LimitsExceededException(_inner) => Some(_inner),
            AssociateHealthCheckErrorKind::OptimisticLockException(_inner) => Some(_inner),
            AssociateHealthCheckErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateProactiveEngagementDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateProactiveEngagementDetailsError {
    /// Kind of error that occurred.
    pub kind: AssociateProactiveEngagementDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateProactiveEngagementDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateProactiveEngagementDetailsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateProactiveEngagementDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateProactiveEngagementDetailsErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProactiveEngagementDetailsErrorKind::InvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProactiveEngagementDetailsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProactiveEngagementDetailsErrorKind::OptimisticLockException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProactiveEngagementDetailsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateProactiveEngagementDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateProactiveEngagementDetailsError {
    fn code(&self) -> Option<&str> {
        AssociateProactiveEngagementDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateProactiveEngagementDetailsError {
    /// Creates a new `AssociateProactiveEngagementDetailsError`.
    pub fn new(
        kind: AssociateProactiveEngagementDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateProactiveEngagementDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateProactiveEngagementDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateProactiveEngagementDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateProactiveEngagementDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateProactiveEngagementDetailsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProactiveEngagementDetailsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateProactiveEngagementDetailsErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProactiveEngagementDetailsErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateProactiveEngagementDetailsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProactiveEngagementDetailsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateProactiveEngagementDetailsErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProactiveEngagementDetailsErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateProactiveEngagementDetailsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateProactiveEngagementDetailsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateProactiveEngagementDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateProactiveEngagementDetailsErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            AssociateProactiveEngagementDetailsErrorKind::InvalidOperationException(_inner) => {
                Some(_inner)
            }
            AssociateProactiveEngagementDetailsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateProactiveEngagementDetailsErrorKind::OptimisticLockException(_inner) => {
                Some(_inner)
            }
            AssociateProactiveEngagementDetailsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateProactiveEngagementDetailsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProtectionError {
    /// Kind of error that occurred.
    pub kind: CreateProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProtectionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>Exception that indicates that the operation would exceed a limit.</p>
    LimitsExceededException(crate::error::LimitsExceededException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource already exists. If available, this exception includes details in additional properties. </p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProtectionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::LimitsExceededException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProtectionError {
    fn code(&self) -> Option<&str> {
        CreateProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProtectionError {
    /// Creates a new `CreateProtectionError`.
    pub fn new(kind: CreateProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::LimitsExceededException`.
    pub fn is_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::LimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProtectionErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateProtectionErrorKind::InvalidOperationException(_inner) => Some(_inner),
            CreateProtectionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateProtectionErrorKind::InvalidResourceException(_inner) => Some(_inner),
            CreateProtectionErrorKind::LimitsExceededException(_inner) => Some(_inner),
            CreateProtectionErrorKind::OptimisticLockException(_inner) => Some(_inner),
            CreateProtectionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateProtectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProtectionGroupError {
    /// Kind of error that occurred.
    pub kind: CreateProtectionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProtectionGroupErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the operation would exceed a limit.</p>
    LimitsExceededException(crate::error::LimitsExceededException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource already exists. If available, this exception includes details in additional properties. </p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProtectionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProtectionGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::LimitsExceededException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProtectionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProtectionGroupError {
    fn code(&self) -> Option<&str> {
        CreateProtectionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProtectionGroupError {
    /// Creates a new `CreateProtectionGroupError`.
    pub fn new(kind: CreateProtectionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProtectionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProtectionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProtectionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProtectionGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::LimitsExceededException`.
    pub fn is_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::LimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProtectionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProtectionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateProtectionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProtectionGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::LimitsExceededException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::OptimisticLockException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProtectionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSubscriptionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception indicating the specified resource already exists. If available, this exception includes details in additional properties. </p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSubscriptionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateSubscriptionErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSubscriptionError {
    /// Creates a new `CreateSubscriptionError`.
    pub fn new(kind: CreateSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSubscriptionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriptionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSubscriptionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSubscriptionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSubscriptionErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateSubscriptionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProtectionError {
    /// Kind of error that occurred.
    pub kind: DeleteProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProtectionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProtectionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteProtectionErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DeleteProtectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProtectionError {
    fn code(&self) -> Option<&str> {
        DeleteProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProtectionError {
    /// Creates a new `DeleteProtectionError`.
    pub fn new(kind: DeleteProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProtectionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtectionErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProtectionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteProtectionErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DeleteProtectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProtectionGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteProtectionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProtectionGroupErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProtectionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProtectionGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteProtectionGroupErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DeleteProtectionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProtectionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProtectionGroupError {
    fn code(&self) -> Option<&str> {
        DeleteProtectionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProtectionGroupError {
    /// Creates a new `DeleteProtectionGroupError`.
    pub fn new(kind: DeleteProtectionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProtectionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProtectionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProtectionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProtectionGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProtectionGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtectionGroupErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionGroupErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProtectionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProtectionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteProtectionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProtectionGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteProtectionGroupErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DeleteProtectionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProtectionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSubscriptionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>You are trying to update a subscription that has not yet completed the 1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to that period.</p>
    LockedSubscriptionException(crate::error::LockedSubscriptionException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSubscriptionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteSubscriptionErrorKind::LockedSubscriptionException(_inner) => _inner.fmt(f),
            DeleteSubscriptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSubscriptionError {
    /// Creates a new `DeleteSubscriptionError`.
    pub fn new(kind: DeleteSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionErrorKind::LockedSubscriptionException`.
    pub fn is_locked_subscription_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionErrorKind::LockedSubscriptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSubscriptionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteSubscriptionErrorKind::LockedSubscriptionException(_inner) => Some(_inner),
            DeleteSubscriptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAttack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAttackError {
    /// Kind of error that occurred.
    pub kind: DescribeAttackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAttack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAttackErrorKind {
    /// <p>Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not have the appropriate permissions to access the <code>AttackId</code>.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAttackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAttackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAttackErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeAttackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAttackError {
    fn code(&self) -> Option<&str> {
        DescribeAttackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAttackError {
    /// Creates a new `DescribeAttackError`.
    pub fn new(kind: DescribeAttackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAttackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAttackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAttackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAttackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAttackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttackErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAttackErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttackErrorKind::InternalErrorException(_)
        )
    }
}
impl std::error::Error for DescribeAttackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAttackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAttackErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeAttackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAttackStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAttackStatisticsError {
    /// Kind of error that occurred.
    pub kind: DescribeAttackStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAttackStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAttackStatisticsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAttackStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAttackStatisticsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeAttackStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAttackStatisticsError {
    fn code(&self) -> Option<&str> {
        DescribeAttackStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAttackStatisticsError {
    /// Creates a new `DescribeAttackStatisticsError`.
    pub fn new(kind: DescribeAttackStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAttackStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAttackStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAttackStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAttackStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAttackStatisticsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAttackStatisticsErrorKind::InternalErrorException(_)
        )
    }
}
impl std::error::Error for DescribeAttackStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAttackStatisticsErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeAttackStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDRTAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDRTAccessError {
    /// Kind of error that occurred.
    pub kind: DescribeDRTAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDRTAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDRTAccessErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDRTAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDRTAccessErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeDRTAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDRTAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDRTAccessError {
    fn code(&self) -> Option<&str> {
        DescribeDRTAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDRTAccessError {
    /// Creates a new `DescribeDRTAccessError`.
    pub fn new(kind: DescribeDRTAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDRTAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDRTAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDRTAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDRTAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDRTAccessErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDRTAccessErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDRTAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDRTAccessErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDRTAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDRTAccessErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeDRTAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDRTAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEmergencyContactSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEmergencyContactSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeEmergencyContactSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEmergencyContactSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEmergencyContactSettingsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEmergencyContactSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEmergencyContactSettingsErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEmergencyContactSettingsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEmergencyContactSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEmergencyContactSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeEmergencyContactSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEmergencyContactSettingsError {
    /// Creates a new `DescribeEmergencyContactSettingsError`.
    pub fn new(
        kind: DescribeEmergencyContactSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEmergencyContactSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEmergencyContactSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEmergencyContactSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEmergencyContactSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEmergencyContactSettingsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEmergencyContactSettingsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEmergencyContactSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEmergencyContactSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeEmergencyContactSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEmergencyContactSettingsErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            DescribeEmergencyContactSettingsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeEmergencyContactSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProtectionError {
    /// Kind of error that occurred.
    pub kind: DescribeProtectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProtection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProtectionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProtectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProtectionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeProtectionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeProtectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProtectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProtectionError {
    fn code(&self) -> Option<&str> {
        DescribeProtectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProtectionError {
    /// Creates a new `DescribeProtectionError`.
    pub fn new(kind: DescribeProtectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProtectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProtectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProtectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProtectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProtectionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProtectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProtectionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeProtectionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeProtectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProtectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProtectionGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeProtectionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProtectionGroupErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProtectionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProtectionGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeProtectionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProtectionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProtectionGroupError {
    fn code(&self) -> Option<&str> {
        DescribeProtectionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProtectionGroupError {
    /// Creates a new `DescribeProtectionGroupError`.
    pub fn new(kind: DescribeProtectionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProtectionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProtectionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProtectionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProtectionGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProtectionGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectionGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProtectionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProtectionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeProtectionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProtectionGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeProtectionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProtectionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DescribeSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSubscriptionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSubscriptionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DescribeSubscriptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSubscriptionError {
    fn code(&self) -> Option<&str> {
        DescribeSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSubscriptionError {
    /// Creates a new `DescribeSubscriptionError`.
    pub fn new(kind: DescribeSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSubscriptionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscriptionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscriptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscriptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSubscriptionErrorKind::InternalErrorException(_inner) => Some(_inner),
            DescribeSubscriptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableProactiveEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableProactiveEngagementError {
    /// Kind of error that occurred.
    pub kind: DisableProactiveEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableProactiveEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableProactiveEngagementErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableProactiveEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableProactiveEngagementErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DisableProactiveEngagementErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DisableProactiveEngagementErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisableProactiveEngagementErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DisableProactiveEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableProactiveEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableProactiveEngagementError {
    fn code(&self) -> Option<&str> {
        DisableProactiveEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableProactiveEngagementError {
    /// Creates a new `DisableProactiveEngagementError`.
    pub fn new(kind: DisableProactiveEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableProactiveEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableProactiveEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableProactiveEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableProactiveEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableProactiveEngagementErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableProactiveEngagementErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableProactiveEngagementErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableProactiveEngagementErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableProactiveEngagementErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableProactiveEngagementErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableProactiveEngagementErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableProactiveEngagementErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableProactiveEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableProactiveEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableProactiveEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableProactiveEngagementErrorKind::InternalErrorException(_inner) => Some(_inner),
            DisableProactiveEngagementErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DisableProactiveEngagementErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisableProactiveEngagementErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DisableProactiveEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableProactiveEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDRTLogBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDRTLogBucketError {
    /// Kind of error that occurred.
    pub kind: DisassociateDRTLogBucketErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDRTLogBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDRTLogBucketErrorKind {
    /// <p>In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>
    AccessDeniedForDependencyException(crate::error::AccessDeniedForDependencyException),
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>The ARN of the role that you specifed does not exist.</p>
    NoAssociatedRoleException(crate::error::NoAssociatedRoleException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDRTLogBucketError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateDRTLogBucketErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DisassociateDRTLogBucketErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DisassociateDRTLogBucketErrorKind::NoAssociatedRoleException(_inner) => _inner.fmt(f),
            DisassociateDRTLogBucketErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DisassociateDRTLogBucketErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateDRTLogBucketErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDRTLogBucketError {
    fn code(&self) -> Option<&str> {
        DisassociateDRTLogBucketError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDRTLogBucketError {
    /// Creates a new `DisassociateDRTLogBucketError`.
    pub fn new(kind: DisassociateDRTLogBucketErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDRTLogBucketError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDRTLogBucketErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDRTLogBucketError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDRTLogBucketErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::AccessDeniedForDependencyException`.
    pub fn is_access_denied_for_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::NoAssociatedRoleException`.
    pub fn is_no_associated_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::NoAssociatedRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTLogBucketErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTLogBucketErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateDRTLogBucketError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDRTLogBucketErrorKind::AccessDeniedForDependencyException(_inner) => {
                Some(_inner)
            }
            DisassociateDRTLogBucketErrorKind::InternalErrorException(_inner) => Some(_inner),
            DisassociateDRTLogBucketErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DisassociateDRTLogBucketErrorKind::NoAssociatedRoleException(_inner) => Some(_inner),
            DisassociateDRTLogBucketErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DisassociateDRTLogBucketErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateDRTLogBucketErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDRTRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDRTRoleError {
    /// Kind of error that occurred.
    pub kind: DisassociateDRTRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDRTRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDRTRoleErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDRTRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDRTRoleErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DisassociateDRTRoleErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            DisassociateDRTRoleErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DisassociateDRTRoleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateDRTRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDRTRoleError {
    fn code(&self) -> Option<&str> {
        DisassociateDRTRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDRTRoleError {
    /// Creates a new `DisassociateDRTRoleError`.
    pub fn new(kind: DisassociateDRTRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDRTRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDRTRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDRTRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDRTRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDRTRoleErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTRoleErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTRoleErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTRoleErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTRoleErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTRoleErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDRTRoleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDRTRoleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateDRTRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDRTRoleErrorKind::InternalErrorException(_inner) => Some(_inner),
            DisassociateDRTRoleErrorKind::InvalidOperationException(_inner) => Some(_inner),
            DisassociateDRTRoleErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DisassociateDRTRoleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateDRTRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateHealthCheckError {
    /// Kind of error that occurred.
    pub kind: DisassociateHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateHealthCheckErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateHealthCheckErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DisassociateHealthCheckErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateHealthCheckErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            DisassociateHealthCheckErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateHealthCheckError {
    fn code(&self) -> Option<&str> {
        DisassociateHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateHealthCheckError {
    /// Creates a new `DisassociateHealthCheckError`.
    pub fn new(kind: DisassociateHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateHealthCheckErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateHealthCheckErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateHealthCheckErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateHealthCheckErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateHealthCheckErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateHealthCheckErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateHealthCheckErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateHealthCheckErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateHealthCheckErrorKind::InternalErrorException(_inner) => Some(_inner),
            DisassociateHealthCheckErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateHealthCheckErrorKind::OptimisticLockException(_inner) => Some(_inner),
            DisassociateHealthCheckErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableProactiveEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableProactiveEngagementError {
    /// Kind of error that occurred.
    pub kind: EnableProactiveEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableProactiveEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableProactiveEngagementErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableProactiveEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableProactiveEngagementErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            EnableProactiveEngagementErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            EnableProactiveEngagementErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            EnableProactiveEngagementErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            EnableProactiveEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableProactiveEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableProactiveEngagementError {
    fn code(&self) -> Option<&str> {
        EnableProactiveEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableProactiveEngagementError {
    /// Creates a new `EnableProactiveEngagementError`.
    pub fn new(kind: EnableProactiveEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableProactiveEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableProactiveEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableProactiveEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableProactiveEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableProactiveEngagementErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableProactiveEngagementErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableProactiveEngagementErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableProactiveEngagementErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableProactiveEngagementErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableProactiveEngagementErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableProactiveEngagementErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableProactiveEngagementErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableProactiveEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableProactiveEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableProactiveEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableProactiveEngagementErrorKind::InternalErrorException(_inner) => Some(_inner),
            EnableProactiveEngagementErrorKind::InvalidOperationException(_inner) => Some(_inner),
            EnableProactiveEngagementErrorKind::InvalidParameterException(_inner) => Some(_inner),
            EnableProactiveEngagementErrorKind::OptimisticLockException(_inner) => Some(_inner),
            EnableProactiveEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableProactiveEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSubscriptionState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSubscriptionStateError {
    /// Kind of error that occurred.
    pub kind: GetSubscriptionStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSubscriptionState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSubscriptionStateErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSubscriptionStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSubscriptionStateErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetSubscriptionStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSubscriptionStateError {
    fn code(&self) -> Option<&str> {
        GetSubscriptionStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSubscriptionStateError {
    /// Creates a new `GetSubscriptionStateError`.
    pub fn new(kind: GetSubscriptionStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSubscriptionStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSubscriptionStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSubscriptionStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSubscriptionStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSubscriptionStateErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSubscriptionStateErrorKind::InternalErrorException(_)
        )
    }
}
impl std::error::Error for GetSubscriptionStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSubscriptionStateErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetSubscriptionStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttacksError {
    /// Kind of error that occurred.
    pub kind: ListAttacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttacksErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the operation would not cause any change to occur.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttacksErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListAttacksErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            ListAttacksErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAttacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttacksError {
    fn code(&self) -> Option<&str> {
        ListAttacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttacksError {
    /// Creates a new `ListAttacksError`.
    pub fn new(kind: ListAttacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttacksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttacksErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListAttacksErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListAttacksErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttacksErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttacksErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttacksErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListAttacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttacksErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListAttacksErrorKind::InvalidOperationException(_inner) => Some(_inner),
            ListAttacksErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAttacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProtectionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProtectionGroupsError {
    /// Kind of error that occurred.
    pub kind: ListProtectionGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProtectionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProtectionGroupsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the NextToken specified in the request is invalid. Submit the request using the NextToken value that was returned in the response.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProtectionGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProtectionGroupsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListProtectionGroupsErrorKind::InvalidPaginationTokenException(_inner) => _inner.fmt(f),
            ListProtectionGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProtectionGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProtectionGroupsError {
    fn code(&self) -> Option<&str> {
        ListProtectionGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProtectionGroupsError {
    /// Creates a new `ListProtectionGroupsError`.
    pub fn new(kind: ListProtectionGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProtectionGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProtectionGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProtectionGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProtectionGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProtectionGroupsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionGroupsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtectionGroupsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionGroupsErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtectionGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProtectionGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProtectionGroupsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListProtectionGroupsErrorKind::InvalidPaginationTokenException(_inner) => Some(_inner),
            ListProtectionGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProtectionGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProtections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProtectionsError {
    /// Kind of error that occurred.
    pub kind: ListProtectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProtections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProtectionsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the NextToken specified in the request is invalid. Submit the request using the NextToken value that was returned in the response.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProtectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProtectionsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListProtectionsErrorKind::InvalidPaginationTokenException(_inner) => _inner.fmt(f),
            ListProtectionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProtectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProtectionsError {
    fn code(&self) -> Option<&str> {
        ListProtectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProtectionsError {
    /// Creates a new `ListProtectionsError`.
    pub fn new(kind: ListProtectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProtectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProtectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProtectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProtectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProtectionsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtectionsErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionsErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProtectionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProtectionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListProtectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProtectionsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListProtectionsErrorKind::InvalidPaginationTokenException(_inner) => Some(_inner),
            ListProtectionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProtectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourcesInProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesInProtectionGroupError {
    /// Kind of error that occurred.
    pub kind: ListResourcesInProtectionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourcesInProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesInProtectionGroupErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the NextToken specified in the request is invalid. Submit the request using the NextToken value that was returned in the response.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesInProtectionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesInProtectionGroupErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesInProtectionGroupErrorKind::InvalidPaginationTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesInProtectionGroupErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListResourcesInProtectionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesInProtectionGroupError {
    fn code(&self) -> Option<&str> {
        ListResourcesInProtectionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesInProtectionGroupError {
    /// Creates a new `ListResourcesInProtectionGroupError`.
    pub fn new(
        kind: ListResourcesInProtectionGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesInProtectionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesInProtectionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesInProtectionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesInProtectionGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesInProtectionGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesInProtectionGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesInProtectionGroupErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesInProtectionGroupErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesInProtectionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesInProtectionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListResourcesInProtectionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesInProtectionGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListResourcesInProtectionGroupErrorKind::InvalidPaginationTokenException(_inner) => {
                Some(_inner)
            }
            ListResourcesInProtectionGroupErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListResourcesInProtectionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidResourceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalErrorException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidResourceException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>
    InvalidResourceException(crate::error::InvalidResourceException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidResourceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidResourceException`.
    pub fn is_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidResourceException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEmergencyContactSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEmergencyContactSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateEmergencyContactSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEmergencyContactSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEmergencyContactSettingsErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEmergencyContactSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEmergencyContactSettingsErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEmergencyContactSettingsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEmergencyContactSettingsErrorKind::OptimisticLockException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEmergencyContactSettingsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEmergencyContactSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEmergencyContactSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateEmergencyContactSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEmergencyContactSettingsError {
    /// Creates a new `UpdateEmergencyContactSettingsError`.
    pub fn new(
        kind: UpdateEmergencyContactSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEmergencyContactSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEmergencyContactSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEmergencyContactSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEmergencyContactSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEmergencyContactSettingsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmergencyContactSettingsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmergencyContactSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmergencyContactSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmergencyContactSettingsErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmergencyContactSettingsErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEmergencyContactSettingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEmergencyContactSettingsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateEmergencyContactSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEmergencyContactSettingsErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateEmergencyContactSettingsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateEmergencyContactSettingsErrorKind::OptimisticLockException(_inner) => {
                Some(_inner)
            }
            UpdateEmergencyContactSettingsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateEmergencyContactSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProtectionGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateProtectionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProtectionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProtectionGroupErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProtectionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProtectionGroupErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateProtectionGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateProtectionGroupErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            UpdateProtectionGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProtectionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProtectionGroupError {
    fn code(&self) -> Option<&str> {
        UpdateProtectionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProtectionGroupError {
    /// Creates a new `UpdateProtectionGroupError`.
    pub fn new(kind: UpdateProtectionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProtectionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProtectionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProtectionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProtectionGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProtectionGroupErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProtectionGroupErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProtectionGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProtectionGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProtectionGroupErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProtectionGroupErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProtectionGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProtectionGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProtectionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProtectionGroupErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateProtectionGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateProtectionGroupErrorKind::OptimisticLockException(_inner) => Some(_inner),
            UpdateProtectionGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProtectionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSubscriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSubscriptionErrorKind {
    /// <p>Exception that indicates that a problem occurred with the service infrastructure. You
    /// can retry the request.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You are trying to update a subscription that has not yet completed the 1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to that period.</p>
    LockedSubscriptionException(crate::error::LockedSubscriptionException),
    /// <p>Exception that indicates that the resource state has been modified by another
    /// client. Retrieve the resource and then retry your request.</p>
    OptimisticLockException(crate::error::OptimisticLockException),
    /// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSubscriptionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UpdateSubscriptionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateSubscriptionErrorKind::LockedSubscriptionException(_inner) => _inner.fmt(f),
            UpdateSubscriptionErrorKind::OptimisticLockException(_inner) => _inner.fmt(f),
            UpdateSubscriptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSubscriptionError {
    fn code(&self) -> Option<&str> {
        UpdateSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSubscriptionError {
    /// Creates a new `UpdateSubscriptionError`.
    pub fn new(kind: UpdateSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSubscriptionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriptionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriptionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriptionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriptionErrorKind::LockedSubscriptionException`.
    pub fn is_locked_subscription_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriptionErrorKind::LockedSubscriptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriptionErrorKind::OptimisticLockException`.
    pub fn is_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriptionErrorKind::OptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSubscriptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSubscriptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSubscriptionErrorKind::InternalErrorException(_inner) => Some(_inner),
            UpdateSubscriptionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateSubscriptionErrorKind::LockedSubscriptionException(_inner) => Some(_inner),
            UpdateSubscriptionErrorKind::OptimisticLockException(_inner) => Some(_inner),
            UpdateSubscriptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Exception indicating the specified resource does not exist. If available, this exception includes details in additional properties. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Type of resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Type of resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the resource state has been modified by another
/// client. Retrieve the resource and then retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptimisticLockException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptimisticLockException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptimisticLockException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OptimisticLockException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OptimisticLockException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OptimisticLockException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for OptimisticLockException {}
/// See [`OptimisticLockException`](crate::error::OptimisticLockException)
pub mod optimistic_lock_exception {
    /// A builder for [`OptimisticLockException`](crate::error::OptimisticLockException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OptimisticLockException`](crate::error::OptimisticLockException)
        pub fn build(self) -> crate::error::OptimisticLockException {
            crate::error::OptimisticLockException {
                message: self.message,
            }
        }
    }
}
impl OptimisticLockException {
    /// Creates a new builder-style object to manufacture [`OptimisticLockException`](crate::error::OptimisticLockException)
    pub fn builder() -> crate::error::optimistic_lock_exception::Builder {
        crate::error::optimistic_lock_exception::Builder::default()
    }
}

/// <p>You are trying to update a subscription that has not yet completed the 1-year commitment. You can change the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception indicates that you are attempting to change <code>AutoRenew</code> prior to that period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LockedSubscriptionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LockedSubscriptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LockedSubscriptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LockedSubscriptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LockedSubscriptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LockedSubscriptionException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LockedSubscriptionException {}
/// See [`LockedSubscriptionException`](crate::error::LockedSubscriptionException)
pub mod locked_subscription_exception {
    /// A builder for [`LockedSubscriptionException`](crate::error::LockedSubscriptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LockedSubscriptionException`](crate::error::LockedSubscriptionException)
        pub fn build(self) -> crate::error::LockedSubscriptionException {
            crate::error::LockedSubscriptionException {
                message: self.message,
            }
        }
    }
}
impl LockedSubscriptionException {
    /// Creates a new builder-style object to manufacture [`LockedSubscriptionException`](crate::error::LockedSubscriptionException)
    pub fn builder() -> crate::error::locked_subscription_exception::Builder {
        crate::error::locked_subscription_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the parameters passed to the API are invalid. If available, this exception includes details in additional properties. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Additional information about the exception.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>Fields that caused the exception.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Additional information about the exception.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>Additional information about the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>Fields that caused the exception.</p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>Fields that caused the exception.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>Exception that indicates that a problem occurred with the service infrastructure. You
/// can retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalErrorException {}
/// See [`InternalErrorException`](crate::error::InternalErrorException)
pub mod internal_error_exception {
    /// A builder for [`InternalErrorException`](crate::error::InternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalErrorException`](crate::error::InternalErrorException)
        pub fn build(self) -> crate::error::InternalErrorException {
            crate::error::InternalErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalErrorException {
    /// Creates a new builder-style object to manufacture [`InternalErrorException`](crate::error::InternalErrorException)
    pub fn builder() -> crate::error::internal_error_exception::Builder {
        crate::error::internal_error_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the resource is invalid. You might not have access to the resource, or the resource might not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceException {}
/// See [`InvalidResourceException`](crate::error::InvalidResourceException)
pub mod invalid_resource_exception {
    /// A builder for [`InvalidResourceException`](crate::error::InvalidResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceException`](crate::error::InvalidResourceException)
        pub fn build(self) -> crate::error::InvalidResourceException {
            crate::error::InvalidResourceException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceException`](crate::error::InvalidResourceException)
    pub fn builder() -> crate::error::invalid_resource_exception::Builder {
        crate::error::invalid_resource_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the NextToken specified in the request is invalid. Submit the request using the NextToken value that was returned in the response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationTokenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationTokenException {}
/// See [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
pub mod invalid_pagination_token_exception {
    /// A builder for [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
        pub fn build(self) -> crate::error::InvalidPaginationTokenException {
            crate::error::InvalidPaginationTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    pub fn builder() -> crate::error::invalid_pagination_token_exception::Builder {
        crate::error::invalid_pagination_token_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the operation would not cause any change to occur.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}

/// <p>The ARN of the role that you specifed does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAssociatedRoleException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoAssociatedRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAssociatedRoleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoAssociatedRoleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAssociatedRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAssociatedRoleException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAssociatedRoleException {}
/// See [`NoAssociatedRoleException`](crate::error::NoAssociatedRoleException)
pub mod no_associated_role_exception {
    /// A builder for [`NoAssociatedRoleException`](crate::error::NoAssociatedRoleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAssociatedRoleException`](crate::error::NoAssociatedRoleException)
        pub fn build(self) -> crate::error::NoAssociatedRoleException {
            crate::error::NoAssociatedRoleException {
                message: self.message,
            }
        }
    }
}
impl NoAssociatedRoleException {
    /// Creates a new builder-style object to manufacture [`NoAssociatedRoleException`](crate::error::NoAssociatedRoleException)
    pub fn builder() -> crate::error::no_associated_role_exception::Builder {
        crate::error::no_associated_role_exception::Builder::default()
    }
}

/// <p>In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the appropriate permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User Permissions to Pass a Role to an Amazon Web Services Service</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedForDependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedForDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedForDependencyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedForDependencyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedForDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedForDependencyException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedForDependencyException {}
/// See [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
pub mod access_denied_for_dependency_exception {
    /// A builder for [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
        pub fn build(self) -> crate::error::AccessDeniedForDependencyException {
            crate::error::AccessDeniedForDependencyException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedForDependencyException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedForDependencyException`](crate::error::AccessDeniedForDependencyException)
    pub fn builder() -> crate::error::access_denied_for_dependency_exception::Builder {
        crate::error::access_denied_for_dependency_exception::Builder::default()
    }
}

/// <p>Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not have the appropriate permissions to access the <code>AttackId</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Exception indicating the specified resource already exists. If available, this exception includes details in additional properties. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of resource that already exists.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of resource that already exists.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource that already exists.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>Exception that indicates that the operation would exceed a limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitsExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of limit that would be exceeded.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The threshold that would be exceeded.</p>
    pub limit: i64,
}
impl std::fmt::Debug for LimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitsExceededException");
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
impl LimitsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitsExceededException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitsExceededException {}
/// See [`LimitsExceededException`](crate::error::LimitsExceededException)
pub mod limits_exceeded_exception {
    /// A builder for [`LimitsExceededException`](crate::error::LimitsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i64>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of limit that would be exceeded.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of limit that would be exceeded.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The threshold that would be exceeded.</p>
        pub fn limit(mut self, input: i64) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The threshold that would be exceeded.</p>
        pub fn set_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitsExceededException`](crate::error::LimitsExceededException)
        pub fn build(self) -> crate::error::LimitsExceededException {
            crate::error::LimitsExceededException {
                message: self.message,
                r#type: self.r#type,
                limit: self.limit.unwrap_or_default(),
            }
        }
    }
}
impl LimitsExceededException {
    /// Creates a new builder-style object to manufacture [`LimitsExceededException`](crate::error::LimitsExceededException)
    pub fn builder() -> crate::error::limits_exceeded_exception::Builder {
        crate::error::limits_exceeded_exception::Builder::default()
    }
}
