// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateActivity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_activity`](crate::client::Client::create_activity).
///
/// See [`crate::client::fluent_builders::CreateActivity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateActivity {
    _private: (),
}
impl CreateActivity {
    /// Creates a new builder-style object to manufacture [`CreateActivityInput`](crate::input::CreateActivityInput)
    pub fn builder() -> crate::input::create_activity_input::Builder {
        crate::input::create_activity_input::Builder::default()
    }
    /// Creates a new `CreateActivity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateActivity {
    type Output =
        std::result::Result<crate::output::CreateActivityOutput, crate::error::CreateActivityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_activity_error(response)
        } else {
            crate::operation_deser::parse_create_activity_response(response)
        }
    }
}

/// Operation shape for `CreateStateMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_state_machine`](crate::client::Client::create_state_machine).
///
/// See [`crate::client::fluent_builders::CreateStateMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStateMachine {
    _private: (),
}
impl CreateStateMachine {
    /// Creates a new builder-style object to manufacture [`CreateStateMachineInput`](crate::input::CreateStateMachineInput)
    pub fn builder() -> crate::input::create_state_machine_input::Builder {
        crate::input::create_state_machine_input::Builder::default()
    }
    /// Creates a new `CreateStateMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStateMachine {
    type Output = std::result::Result<
        crate::output::CreateStateMachineOutput,
        crate::error::CreateStateMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_state_machine_error(response)
        } else {
            crate::operation_deser::parse_create_state_machine_response(response)
        }
    }
}

/// Operation shape for `DeleteActivity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_activity`](crate::client::Client::delete_activity).
///
/// See [`crate::client::fluent_builders::DeleteActivity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteActivity {
    _private: (),
}
impl DeleteActivity {
    /// Creates a new builder-style object to manufacture [`DeleteActivityInput`](crate::input::DeleteActivityInput)
    pub fn builder() -> crate::input::delete_activity_input::Builder {
        crate::input::delete_activity_input::Builder::default()
    }
    /// Creates a new `DeleteActivity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteActivity {
    type Output =
        std::result::Result<crate::output::DeleteActivityOutput, crate::error::DeleteActivityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_activity_error(response)
        } else {
            crate::operation_deser::parse_delete_activity_response(response)
        }
    }
}

/// Operation shape for `DeleteStateMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_state_machine`](crate::client::Client::delete_state_machine).
///
/// See [`crate::client::fluent_builders::DeleteStateMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStateMachine {
    _private: (),
}
impl DeleteStateMachine {
    /// Creates a new builder-style object to manufacture [`DeleteStateMachineInput`](crate::input::DeleteStateMachineInput)
    pub fn builder() -> crate::input::delete_state_machine_input::Builder {
        crate::input::delete_state_machine_input::Builder::default()
    }
    /// Creates a new `DeleteStateMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStateMachine {
    type Output = std::result::Result<
        crate::output::DeleteStateMachineOutput,
        crate::error::DeleteStateMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_state_machine_error(response)
        } else {
            crate::operation_deser::parse_delete_state_machine_response(response)
        }
    }
}

/// Operation shape for `DescribeActivity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_activity`](crate::client::Client::describe_activity).
///
/// See [`crate::client::fluent_builders::DescribeActivity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActivity {
    _private: (),
}
impl DescribeActivity {
    /// Creates a new builder-style object to manufacture [`DescribeActivityInput`](crate::input::DescribeActivityInput)
    pub fn builder() -> crate::input::describe_activity_input::Builder {
        crate::input::describe_activity_input::Builder::default()
    }
    /// Creates a new `DescribeActivity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActivity {
    type Output = std::result::Result<
        crate::output::DescribeActivityOutput,
        crate::error::DescribeActivityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_activity_error(response)
        } else {
            crate::operation_deser::parse_describe_activity_response(response)
        }
    }
}

/// Operation shape for `DescribeExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_execution`](crate::client::Client::describe_execution).
///
/// See [`crate::client::fluent_builders::DescribeExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExecution {
    _private: (),
}
impl DescribeExecution {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    pub fn builder() -> crate::input::describe_execution_input::Builder {
        crate::input::describe_execution_input::Builder::default()
    }
    /// Creates a new `DescribeExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExecution {
    type Output = std::result::Result<
        crate::output::DescribeExecutionOutput,
        crate::error::DescribeExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeStateMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_state_machine`](crate::client::Client::describe_state_machine).
///
/// See [`crate::client::fluent_builders::DescribeStateMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStateMachine {
    _private: (),
}
impl DescribeStateMachine {
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineInput`](crate::input::DescribeStateMachineInput)
    pub fn builder() -> crate::input::describe_state_machine_input::Builder {
        crate::input::describe_state_machine_input::Builder::default()
    }
    /// Creates a new `DescribeStateMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStateMachine {
    type Output = std::result::Result<
        crate::output::DescribeStateMachineOutput,
        crate::error::DescribeStateMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_state_machine_error(response)
        } else {
            crate::operation_deser::parse_describe_state_machine_response(response)
        }
    }
}

/// Operation shape for `DescribeStateMachineForExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_state_machine_for_execution`](crate::client::Client::describe_state_machine_for_execution).
///
/// See [`crate::client::fluent_builders::DescribeStateMachineForExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStateMachineForExecution {
    _private: (),
}
impl DescribeStateMachineForExecution {
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineForExecutionInput`](crate::input::DescribeStateMachineForExecutionInput)
    pub fn builder() -> crate::input::describe_state_machine_for_execution_input::Builder {
        crate::input::describe_state_machine_for_execution_input::Builder::default()
    }
    /// Creates a new `DescribeStateMachineForExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStateMachineForExecution {
    type Output = std::result::Result<
        crate::output::DescribeStateMachineForExecutionOutput,
        crate::error::DescribeStateMachineForExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_state_machine_for_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_state_machine_for_execution_response(response)
        }
    }
}

/// Operation shape for `GetActivityTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_activity_task`](crate::client::Client::get_activity_task).
///
/// See [`crate::client::fluent_builders::GetActivityTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetActivityTask {
    _private: (),
}
impl GetActivityTask {
    /// Creates a new builder-style object to manufacture [`GetActivityTaskInput`](crate::input::GetActivityTaskInput)
    pub fn builder() -> crate::input::get_activity_task_input::Builder {
        crate::input::get_activity_task_input::Builder::default()
    }
    /// Creates a new `GetActivityTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetActivityTask {
    type Output = std::result::Result<
        crate::output::GetActivityTaskOutput,
        crate::error::GetActivityTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_activity_task_error(response)
        } else {
            crate::operation_deser::parse_get_activity_task_response(response)
        }
    }
}

/// Operation shape for `GetExecutionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_execution_history`](crate::client::Client::get_execution_history).
///
/// See [`crate::client::fluent_builders::GetExecutionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExecutionHistory {
    _private: (),
}
impl GetExecutionHistory {
    /// Creates a new builder-style object to manufacture [`GetExecutionHistoryInput`](crate::input::GetExecutionHistoryInput)
    pub fn builder() -> crate::input::get_execution_history_input::Builder {
        crate::input::get_execution_history_input::Builder::default()
    }
    /// Creates a new `GetExecutionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExecutionHistory {
    type Output = std::result::Result<
        crate::output::GetExecutionHistoryOutput,
        crate::error::GetExecutionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_execution_history_error(response)
        } else {
            crate::operation_deser::parse_get_execution_history_response(response)
        }
    }
}

/// Operation shape for `ListActivities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_activities`](crate::client::Client::list_activities).
///
/// See [`crate::client::fluent_builders::ListActivities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActivities {
    _private: (),
}
impl ListActivities {
    /// Creates a new builder-style object to manufacture [`ListActivitiesInput`](crate::input::ListActivitiesInput)
    pub fn builder() -> crate::input::list_activities_input::Builder {
        crate::input::list_activities_input::Builder::default()
    }
    /// Creates a new `ListActivities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActivities {
    type Output =
        std::result::Result<crate::output::ListActivitiesOutput, crate::error::ListActivitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_activities_error(response)
        } else {
            crate::operation_deser::parse_list_activities_response(response)
        }
    }
}

/// Operation shape for `ListExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_executions`](crate::client::Client::list_executions).
///
/// See [`crate::client::fluent_builders::ListExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExecutions {
    _private: (),
}
impl ListExecutions {
    /// Creates a new builder-style object to manufacture [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    pub fn builder() -> crate::input::list_executions_input::Builder {
        crate::input::list_executions_input::Builder::default()
    }
    /// Creates a new `ListExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExecutions {
    type Output =
        std::result::Result<crate::output::ListExecutionsOutput, crate::error::ListExecutionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_executions_error(response)
        } else {
            crate::operation_deser::parse_list_executions_response(response)
        }
    }
}

/// Operation shape for `ListStateMachines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_state_machines`](crate::client::Client::list_state_machines).
///
/// See [`crate::client::fluent_builders::ListStateMachines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStateMachines {
    _private: (),
}
impl ListStateMachines {
    /// Creates a new builder-style object to manufacture [`ListStateMachinesInput`](crate::input::ListStateMachinesInput)
    pub fn builder() -> crate::input::list_state_machines_input::Builder {
        crate::input::list_state_machines_input::Builder::default()
    }
    /// Creates a new `ListStateMachines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStateMachines {
    type Output = std::result::Result<
        crate::output::ListStateMachinesOutput,
        crate::error::ListStateMachinesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_state_machines_error(response)
        } else {
            crate::operation_deser::parse_list_state_machines_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `SendTaskFailure`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_task_failure`](crate::client::Client::send_task_failure).
///
/// See [`crate::client::fluent_builders::SendTaskFailure`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTaskFailure {
    _private: (),
}
impl SendTaskFailure {
    /// Creates a new builder-style object to manufacture [`SendTaskFailureInput`](crate::input::SendTaskFailureInput)
    pub fn builder() -> crate::input::send_task_failure_input::Builder {
        crate::input::send_task_failure_input::Builder::default()
    }
    /// Creates a new `SendTaskFailure` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTaskFailure {
    type Output = std::result::Result<
        crate::output::SendTaskFailureOutput,
        crate::error::SendTaskFailureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_task_failure_error(response)
        } else {
            crate::operation_deser::parse_send_task_failure_response(response)
        }
    }
}

/// Operation shape for `SendTaskHeartbeat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_task_heartbeat`](crate::client::Client::send_task_heartbeat).
///
/// See [`crate::client::fluent_builders::SendTaskHeartbeat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTaskHeartbeat {
    _private: (),
}
impl SendTaskHeartbeat {
    /// Creates a new builder-style object to manufacture [`SendTaskHeartbeatInput`](crate::input::SendTaskHeartbeatInput)
    pub fn builder() -> crate::input::send_task_heartbeat_input::Builder {
        crate::input::send_task_heartbeat_input::Builder::default()
    }
    /// Creates a new `SendTaskHeartbeat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTaskHeartbeat {
    type Output = std::result::Result<
        crate::output::SendTaskHeartbeatOutput,
        crate::error::SendTaskHeartbeatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_task_heartbeat_error(response)
        } else {
            crate::operation_deser::parse_send_task_heartbeat_response(response)
        }
    }
}

/// Operation shape for `SendTaskSuccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_task_success`](crate::client::Client::send_task_success).
///
/// See [`crate::client::fluent_builders::SendTaskSuccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTaskSuccess {
    _private: (),
}
impl SendTaskSuccess {
    /// Creates a new builder-style object to manufacture [`SendTaskSuccessInput`](crate::input::SendTaskSuccessInput)
    pub fn builder() -> crate::input::send_task_success_input::Builder {
        crate::input::send_task_success_input::Builder::default()
    }
    /// Creates a new `SendTaskSuccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTaskSuccess {
    type Output = std::result::Result<
        crate::output::SendTaskSuccessOutput,
        crate::error::SendTaskSuccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_task_success_error(response)
        } else {
            crate::operation_deser::parse_send_task_success_response(response)
        }
    }
}

/// Operation shape for `StartExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_execution`](crate::client::Client::start_execution).
///
/// See [`crate::client::fluent_builders::StartExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartExecution {
    _private: (),
}
impl StartExecution {
    /// Creates a new builder-style object to manufacture [`StartExecutionInput`](crate::input::StartExecutionInput)
    pub fn builder() -> crate::input::start_execution_input::Builder {
        crate::input::start_execution_input::Builder::default()
    }
    /// Creates a new `StartExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartExecution {
    type Output =
        std::result::Result<crate::output::StartExecutionOutput, crate::error::StartExecutionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_execution_error(response)
        } else {
            crate::operation_deser::parse_start_execution_response(response)
        }
    }
}

/// Operation shape for `StartSyncExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_sync_execution`](crate::client::Client::start_sync_execution).
///
/// See [`crate::client::fluent_builders::StartSyncExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSyncExecution {
    _private: (),
}
impl StartSyncExecution {
    /// Creates a new builder-style object to manufacture [`StartSyncExecutionInput`](crate::input::StartSyncExecutionInput)
    pub fn builder() -> crate::input::start_sync_execution_input::Builder {
        crate::input::start_sync_execution_input::Builder::default()
    }
    /// Creates a new `StartSyncExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSyncExecution {
    type Output = std::result::Result<
        crate::output::StartSyncExecutionOutput,
        crate::error::StartSyncExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_sync_execution_error(response)
        } else {
            crate::operation_deser::parse_start_sync_execution_response(response)
        }
    }
}

/// Operation shape for `StopExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_execution`](crate::client::Client::stop_execution).
///
/// See [`crate::client::fluent_builders::StopExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopExecution {
    _private: (),
}
impl StopExecution {
    /// Creates a new builder-style object to manufacture [`StopExecutionInput`](crate::input::StopExecutionInput)
    pub fn builder() -> crate::input::stop_execution_input::Builder {
        crate::input::stop_execution_input::Builder::default()
    }
    /// Creates a new `StopExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopExecution {
    type Output =
        std::result::Result<crate::output::StopExecutionOutput, crate::error::StopExecutionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateStateMachine`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_state_machine`](crate::client::Client::update_state_machine).
///
/// See [`crate::client::fluent_builders::UpdateStateMachine`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStateMachine {
    _private: (),
}
impl UpdateStateMachine {
    /// Creates a new builder-style object to manufacture [`UpdateStateMachineInput`](crate::input::UpdateStateMachineInput)
    pub fn builder() -> crate::input::update_state_machine_input::Builder {
        crate::input::update_state_machine_input::Builder::default()
    }
    /// Creates a new `UpdateStateMachine` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStateMachine {
    type Output = std::result::Result<
        crate::output::UpdateStateMachineOutput,
        crate::error::UpdateStateMachineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_state_machine_error(response)
        } else {
            crate::operation_deser::parse_update_state_machine_response(response)
        }
    }
}
