// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Step Functions
///
/// Client for invoking operations on AWS Step Functions. Each operation on AWS Step Functions is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_sfn::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_sfn::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_sfn::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateActivity`](crate::client::fluent_builders::CreateActivity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateActivity::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateActivity::set_name): <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateActivity::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateActivity::set_tags): <p>The list of tags to add to a resource.</p>  <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>  <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    /// - On success, responds with [`CreateActivityOutput`](crate::output::CreateActivityOutput) with field(s):
    ///   - [`activity_arn(Option<String>)`](crate::output::CreateActivityOutput::activity_arn): <p>The Amazon Resource Name (ARN) that identifies the created activity.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::CreateActivityOutput::creation_date): <p>The date the activity is created.</p>
    /// - On failure, responds with [`SdkError<CreateActivityError>`](crate::error::CreateActivityError)
    pub fn create_activity(&self) -> fluent_builders::CreateActivity {
        fluent_builders::CreateActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStateMachine`](crate::client::fluent_builders::CreateStateMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStateMachine::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStateMachine::set_name): <p>The name of the state machine. </p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`definition(impl Into<String>)`](crate::client::fluent_builders::CreateStateMachine::definition) / [`set_definition(Option<String>)`](crate::client::fluent_builders::CreateStateMachine::set_definition): <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStateMachine::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateStateMachine::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
    ///   - [`r#type(StateMachineType)`](crate::client::fluent_builders::CreateStateMachine::type) / [`set_type(Option<StateMachineType>)`](crate::client::fluent_builders::CreateStateMachine::set_type): <p>Determines whether a Standard or Express state machine is created. The default is <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it has been created.</p>
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::CreateStateMachine::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::CreateStateMachine::set_logging_configuration): <p>Defines what execution history events are logged and where they are logged.</p> <note>   <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateStateMachine::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateStateMachine::set_tags): <p>Tags to be added when creating a state machine.</p>  <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>  <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    ///   - [`tracing_configuration(TracingConfiguration)`](crate::client::fluent_builders::CreateStateMachine::tracing_configuration) / [`set_tracing_configuration(Option<TracingConfiguration>)`](crate::client::fluent_builders::CreateStateMachine::set_tracing_configuration): <p>Selects whether AWS X-Ray tracing is enabled.</p>
    /// - On success, responds with [`CreateStateMachineOutput`](crate::output::CreateStateMachineOutput) with field(s):
    ///   - [`state_machine_arn(Option<String>)`](crate::output::CreateStateMachineOutput::state_machine_arn): <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::CreateStateMachineOutput::creation_date): <p>The date the state machine is created.</p>
    /// - On failure, responds with [`SdkError<CreateStateMachineError>`](crate::error::CreateStateMachineError)
    pub fn create_state_machine(&self) -> fluent_builders::CreateStateMachine {
        fluent_builders::CreateStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteActivity`](crate::client::fluent_builders::DeleteActivity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activity_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteActivity::activity_arn) / [`set_activity_arn(Option<String>)`](crate::client::fluent_builders::DeleteActivity::set_activity_arn): <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
    /// - On success, responds with [`DeleteActivityOutput`](crate::output::DeleteActivityOutput)

    /// - On failure, responds with [`SdkError<DeleteActivityError>`](crate::error::DeleteActivityError)
    pub fn delete_activity(&self) -> fluent_builders::DeleteActivity {
        fluent_builders::DeleteActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStateMachine`](crate::client::fluent_builders::DeleteStateMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteStateMachine::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::DeleteStateMachine::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
    /// - On success, responds with [`DeleteStateMachineOutput`](crate::output::DeleteStateMachineOutput)

    /// - On failure, responds with [`SdkError<DeleteStateMachineError>`](crate::error::DeleteStateMachineError)
    pub fn delete_state_machine(&self) -> fluent_builders::DeleteStateMachine {
        fluent_builders::DeleteStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActivity`](crate::client::fluent_builders::DescribeActivity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activity_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeActivity::activity_arn) / [`set_activity_arn(Option<String>)`](crate::client::fluent_builders::DescribeActivity::set_activity_arn): <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
    /// - On success, responds with [`DescribeActivityOutput`](crate::output::DescribeActivityOutput) with field(s):
    ///   - [`activity_arn(Option<String>)`](crate::output::DescribeActivityOutput::activity_arn): <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeActivityOutput::name): <p>The name of the activity.</p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeActivityOutput::creation_date): <p>The date the activity is created.</p>
    /// - On failure, responds with [`SdkError<DescribeActivityError>`](crate::error::DescribeActivityError)
    pub fn describe_activity(&self) -> fluent_builders::DescribeActivity {
        fluent_builders::DescribeActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExecution`](crate::client::fluent_builders::DescribeExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`execution_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeExecution::execution_arn) / [`set_execution_arn(Option<String>)`](crate::client::fluent_builders::DescribeExecution::set_execution_arn): <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
    /// - On success, responds with [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput) with field(s):
    ///   - [`execution_arn(Option<String>)`](crate::output::DescribeExecutionOutput::execution_arn): <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    ///   - [`state_machine_arn(Option<String>)`](crate::output::DescribeExecutionOutput::state_machine_arn): <p>The Amazon Resource Name (ARN) of the executed stated machine.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeExecutionOutput::name): <p>The name of the execution.</p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`status(Option<ExecutionStatus>)`](crate::output::DescribeExecutionOutput::status): <p>The current status of the execution.</p>
    ///   - [`start_date(Option<DateTime>)`](crate::output::DescribeExecutionOutput::start_date): <p>The date the execution is started.</p>
    ///   - [`stop_date(Option<DateTime>)`](crate::output::DescribeExecutionOutput::stop_date): <p>If the execution has already ended, the date the execution stopped.</p>
    ///   - [`input(Option<String>)`](crate::output::DescribeExecutionOutput::input): <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    ///   - [`input_details(Option<CloudWatchEventsExecutionDataDetails>)`](crate::output::DescribeExecutionOutput::input_details): <p>Provides details about execution input or output.</p>
    ///   - [`output(Option<String>)`](crate::output::DescribeExecutionOutput::output): <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p> <note>   <p>This field is set only if the execution succeeds. If the execution fails, this field is null.</p>  </note>
    ///   - [`output_details(Option<CloudWatchEventsExecutionDataDetails>)`](crate::output::DescribeExecutionOutput::output_details): <p>Provides details about execution input or output.</p>
    ///   - [`trace_header(Option<String>)`](crate::output::DescribeExecutionOutput::trace_header): <p>The AWS X-Ray trace header that was passed to the execution.</p>
    /// - On failure, responds with [`SdkError<DescribeExecutionError>`](crate::error::DescribeExecutionError)
    pub fn describe_execution(&self) -> fluent_builders::DescribeExecution {
        fluent_builders::DescribeExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStateMachine`](crate::client::fluent_builders::DescribeStateMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeStateMachine::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::DescribeStateMachine::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
    /// - On success, responds with [`DescribeStateMachineOutput`](crate::output::DescribeStateMachineOutput) with field(s):
    ///   - [`state_machine_arn(Option<String>)`](crate::output::DescribeStateMachineOutput::state_machine_arn): <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeStateMachineOutput::name): <p>The name of the state machine.</p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`status(Option<StateMachineStatus>)`](crate::output::DescribeStateMachineOutput::status): <p>The current status of the state machine.</p>
    ///   - [`definition(Option<String>)`](crate::output::DescribeStateMachineOutput::definition): <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeStateMachineOutput::role_arn): <p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to AWS resources.)</p>
    ///   - [`r#type(Option<StateMachineType>)`](crate::output::DescribeStateMachineOutput::type): <p>The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeStateMachineOutput::creation_date): <p>The date the state machine is created.</p>
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::DescribeStateMachineOutput::logging_configuration): <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>
    ///   - [`tracing_configuration(Option<TracingConfiguration>)`](crate::output::DescribeStateMachineOutput::tracing_configuration): <p>Selects whether AWS X-Ray tracing is enabled.</p>
    /// - On failure, responds with [`SdkError<DescribeStateMachineError>`](crate::error::DescribeStateMachineError)
    pub fn describe_state_machine(&self) -> fluent_builders::DescribeStateMachine {
        fluent_builders::DescribeStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStateMachineForExecution`](crate::client::fluent_builders::DescribeStateMachineForExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`execution_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeStateMachineForExecution::execution_arn) / [`set_execution_arn(Option<String>)`](crate::client::fluent_builders::DescribeStateMachineForExecution::set_execution_arn): <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
    /// - On success, responds with [`DescribeStateMachineForExecutionOutput`](crate::output::DescribeStateMachineForExecutionOutput) with field(s):
    ///   - [`state_machine_arn(Option<String>)`](crate::output::DescribeStateMachineForExecutionOutput::state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeStateMachineForExecutionOutput::name): <p>The name of the state machine associated with the execution.</p>
    ///   - [`definition(Option<String>)`](crate::output::DescribeStateMachineForExecutionOutput::definition): <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeStateMachineForExecutionOutput::role_arn): <p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>
    ///   - [`update_date(Option<DateTime>)`](crate::output::DescribeStateMachineForExecutionOutput::update_date): <p>The date and time the state machine associated with an execution was updated. For a newly created state machine, this is the creation date.</p>
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::DescribeStateMachineForExecutionOutput::logging_configuration): <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>
    ///   - [`tracing_configuration(Option<TracingConfiguration>)`](crate::output::DescribeStateMachineForExecutionOutput::tracing_configuration): <p>Selects whether AWS X-Ray tracing is enabled.</p>
    /// - On failure, responds with [`SdkError<DescribeStateMachineForExecutionError>`](crate::error::DescribeStateMachineForExecutionError)
    pub fn describe_state_machine_for_execution(
        &self,
    ) -> fluent_builders::DescribeStateMachineForExecution {
        fluent_builders::DescribeStateMachineForExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetActivityTask`](crate::client::fluent_builders::GetActivityTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activity_arn(impl Into<String>)`](crate::client::fluent_builders::GetActivityTask::activity_arn) / [`set_activity_arn(Option<String>)`](crate::client::fluent_builders::GetActivityTask::set_activity_arn): <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using <code>CreateActivity</code>.)</p>
    ///   - [`worker_name(impl Into<String>)`](crate::client::fluent_builders::GetActivityTask::worker_name) / [`set_worker_name(Option<String>)`](crate::client::fluent_builders::GetActivityTask::set_worker_name): <p>You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history.</p>
    /// - On success, responds with [`GetActivityTaskOutput`](crate::output::GetActivityTaskOutput) with field(s):
    ///   - [`task_token(Option<String>)`](crate::output::GetActivityTaskOutput::task_token): <p>A token that identifies the scheduled task. This token must be copied and included in subsequent calls to <code>SendTaskHeartbeat</code>, <code>SendTaskSuccess</code> or <code>SendTaskFailure</code> in order to report the progress or completion of the task.</p>
    ///   - [`input(Option<String>)`](crate::output::GetActivityTaskOutput::input): <p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// - On failure, responds with [`SdkError<GetActivityTaskError>`](crate::error::GetActivityTaskError)
    pub fn get_activity_task(&self) -> fluent_builders::GetActivityTask {
        fluent_builders::GetActivityTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExecutionHistory`](crate::client::fluent_builders::GetExecutionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetExecutionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`execution_arn(impl Into<String>)`](crate::client::fluent_builders::GetExecutionHistory::execution_arn) / [`set_execution_arn(Option<String>)`](crate::client::fluent_builders::GetExecutionHistory::set_execution_arn): <p>The Amazon Resource Name (ARN) of the execution.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetExecutionHistory::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetExecutionHistory::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>  <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::GetExecutionHistory::reverse_order) / [`set_reverse_order(bool)`](crate::client::fluent_builders::GetExecutionHistory::set_reverse_order): <p>Lists events in descending order of their <code>timeStamp</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetExecutionHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetExecutionHistory::set_next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    ///   - [`include_execution_data(bool)`](crate::client::fluent_builders::GetExecutionHistory::include_execution_data) / [`set_include_execution_data(Option<bool>)`](crate::client::fluent_builders::GetExecutionHistory::set_include_execution_data): <p>You can select whether execution data (input or output of a history event) is returned. The default is <code>true</code>.</p>
    /// - On success, responds with [`GetExecutionHistoryOutput`](crate::output::GetExecutionHistoryOutput) with field(s):
    ///   - [`events(Option<Vec<HistoryEvent>>)`](crate::output::GetExecutionHistoryOutput::events): <p>The list of events that occurred in the execution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetExecutionHistoryOutput::next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On failure, responds with [`SdkError<GetExecutionHistoryError>`](crate::error::GetExecutionHistoryError)
    pub fn get_execution_history(&self) -> fluent_builders::GetExecutionHistory {
        fluent_builders::GetExecutionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListActivities`](crate::client::fluent_builders::ListActivities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListActivities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListActivities::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListActivities::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>  <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListActivities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListActivities::set_next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On success, responds with [`ListActivitiesOutput`](crate::output::ListActivitiesOutput) with field(s):
    ///   - [`activities(Option<Vec<ActivityListItem>>)`](crate::output::ListActivitiesOutput::activities): <p>The list of activities.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListActivitiesOutput::next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On failure, responds with [`SdkError<ListActivitiesError>`](crate::error::ListActivitiesError)
    pub fn list_activities(&self) -> fluent_builders::ListActivities {
        fluent_builders::ListActivities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExecutions`](crate::client::fluent_builders::ListExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
    ///   - [`status_filter(ExecutionStatus)`](crate::client::fluent_builders::ListExecutions::status_filter) / [`set_status_filter(Option<ExecutionStatus>)`](crate::client::fluent_builders::ListExecutions::set_status_filter): <p>If specified, only list the executions whose current execution status matches the given filter.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExecutions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListExecutions::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>  <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On success, responds with [`ListExecutionsOutput`](crate::output::ListExecutionsOutput) with field(s):
    ///   - [`executions(Option<Vec<ExecutionListItem>>)`](crate::output::ListExecutionsOutput::executions): <p>The list of matching executions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExecutionsOutput::next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On failure, responds with [`SdkError<ListExecutionsError>`](crate::error::ListExecutionsError)
    pub fn list_executions(&self) -> fluent_builders::ListExecutions {
        fluent_builders::ListExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStateMachines`](crate::client::fluent_builders::ListStateMachines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStateMachines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStateMachines::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStateMachines::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>  <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStateMachines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStateMachines::set_next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On success, responds with [`ListStateMachinesOutput`](crate::output::ListStateMachinesOutput) with field(s):
    ///   - [`state_machines(Option<Vec<StateMachineListItem>>)`](crate::output::ListStateMachinesOutput::state_machines): (undocumented)
    ///   - [`next_token(Option<String>)`](crate::output::ListStateMachinesOutput::next_token): <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// - On failure, responds with [`SdkError<ListStateMachinesError>`](crate::error::ListStateMachinesError)
    pub fn list_state_machines(&self) -> fluent_builders::ListStateMachines {
        fluent_builders::ListStateMachines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array of tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTaskFailure`](crate::client::fluent_builders::SendTaskFailure) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::SendTaskFailure::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::SendTaskFailure::set_task_token): <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
    ///   - [`error(impl Into<String>)`](crate::client::fluent_builders::SendTaskFailure::error) / [`set_error(Option<String>)`](crate::client::fluent_builders::SendTaskFailure::set_error): <p>The error code of the failure.</p>
    ///   - [`cause(impl Into<String>)`](crate::client::fluent_builders::SendTaskFailure::cause) / [`set_cause(Option<String>)`](crate::client::fluent_builders::SendTaskFailure::set_cause): <p>A more detailed explanation of the cause of the failure.</p>
    /// - On success, responds with [`SendTaskFailureOutput`](crate::output::SendTaskFailureOutput)

    /// - On failure, responds with [`SdkError<SendTaskFailureError>`](crate::error::SendTaskFailureError)
    pub fn send_task_failure(&self) -> fluent_builders::SendTaskFailure {
        fluent_builders::SendTaskFailure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTaskHeartbeat`](crate::client::fluent_builders::SendTaskHeartbeat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::SendTaskHeartbeat::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::SendTaskHeartbeat::set_task_token): <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
    /// - On success, responds with [`SendTaskHeartbeatOutput`](crate::output::SendTaskHeartbeatOutput)

    /// - On failure, responds with [`SdkError<SendTaskHeartbeatError>`](crate::error::SendTaskHeartbeatError)
    pub fn send_task_heartbeat(&self) -> fluent_builders::SendTaskHeartbeat {
        fluent_builders::SendTaskHeartbeat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTaskSuccess`](crate::client::fluent_builders::SendTaskSuccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_token(impl Into<String>)`](crate::client::fluent_builders::SendTaskSuccess::task_token) / [`set_task_token(Option<String>)`](crate::client::fluent_builders::SendTaskSuccess::set_task_token): <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
    ///   - [`output(impl Into<String>)`](crate::client::fluent_builders::SendTaskSuccess::output) / [`set_output(Option<String>)`](crate::client::fluent_builders::SendTaskSuccess::set_output): <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// - On success, responds with [`SendTaskSuccessOutput`](crate::output::SendTaskSuccessOutput)

    /// - On failure, responds with [`SdkError<SendTaskSuccessError>`](crate::error::SendTaskSuccessError)
    pub fn send_task_success(&self) -> fluent_builders::SendTaskSuccess {
        fluent_builders::SendTaskSuccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExecution`](crate::client::fluent_builders::StartExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::StartExecution::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::StartExecution::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartExecution::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartExecution::set_name): <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>  <p>A name must <i>not</i> contain:</p>  <ul>   <li> <p>white space</p> </li>   <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>   <li> <p>wildcard characters <code>? *</code> </p> </li>   <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>   <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>  </ul>  <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
    ///   - [`input(impl Into<String>)`](crate::client::fluent_builders::StartExecution::input) / [`set_input(Option<String>)`](crate::client::fluent_builders::StartExecution::set_input): <p>The string that contains the JSON input data for the execution, for example:</p>  <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>   <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>  </note>  <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    ///   - [`trace_header(impl Into<String>)`](crate::client::fluent_builders::StartExecution::trace_header) / [`set_trace_header(Option<String>)`](crate::client::fluent_builders::StartExecution::set_trace_header): <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    /// - On success, responds with [`StartExecutionOutput`](crate::output::StartExecutionOutput) with field(s):
    ///   - [`execution_arn(Option<String>)`](crate::output::StartExecutionOutput::execution_arn): <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    ///   - [`start_date(Option<DateTime>)`](crate::output::StartExecutionOutput::start_date): <p>The date the execution is started.</p>
    /// - On failure, responds with [`SdkError<StartExecutionError>`](crate::error::StartExecutionError)
    pub fn start_execution(&self) -> fluent_builders::StartExecution {
        fluent_builders::StartExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSyncExecution`](crate::client::fluent_builders::StartSyncExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::StartSyncExecution::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::StartSyncExecution::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartSyncExecution::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartSyncExecution::set_name): <p>The name of the execution.</p>
    ///   - [`input(impl Into<String>)`](crate::client::fluent_builders::StartSyncExecution::input) / [`set_input(Option<String>)`](crate::client::fluent_builders::StartSyncExecution::set_input): <p>The string that contains the JSON input data for the execution, for example:</p>  <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>   <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>  </note>  <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    ///   - [`trace_header(impl Into<String>)`](crate::client::fluent_builders::StartSyncExecution::trace_header) / [`set_trace_header(Option<String>)`](crate::client::fluent_builders::StartSyncExecution::set_trace_header): <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    /// - On success, responds with [`StartSyncExecutionOutput`](crate::output::StartSyncExecutionOutput) with field(s):
    ///   - [`execution_arn(Option<String>)`](crate::output::StartSyncExecutionOutput::execution_arn): <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    ///   - [`state_machine_arn(Option<String>)`](crate::output::StartSyncExecutionOutput::state_machine_arn): <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    ///   - [`name(Option<String>)`](crate::output::StartSyncExecutionOutput::name): <p>The name of the execution.</p>
    ///   - [`start_date(Option<DateTime>)`](crate::output::StartSyncExecutionOutput::start_date): <p>The date the execution is started.</p>
    ///   - [`stop_date(Option<DateTime>)`](crate::output::StartSyncExecutionOutput::stop_date): <p>If the execution has already ended, the date the execution stopped.</p>
    ///   - [`status(Option<SyncExecutionStatus>)`](crate::output::StartSyncExecutionOutput::status): <p>The current status of the execution.</p>
    ///   - [`error(Option<String>)`](crate::output::StartSyncExecutionOutput::error): <p>The error code of the failure.</p>
    ///   - [`cause(Option<String>)`](crate::output::StartSyncExecutionOutput::cause): <p>A more detailed explanation of the cause of the failure.</p>
    ///   - [`input(Option<String>)`](crate::output::StartSyncExecutionOutput::input): <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    ///   - [`input_details(Option<CloudWatchEventsExecutionDataDetails>)`](crate::output::StartSyncExecutionOutput::input_details): <p>Provides details about execution input or output.</p>
    ///   - [`output(Option<String>)`](crate::output::StartSyncExecutionOutput::output): <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p> <note>   <p>This field is set only if the execution succeeds. If the execution fails, this field is null.</p>  </note>
    ///   - [`output_details(Option<CloudWatchEventsExecutionDataDetails>)`](crate::output::StartSyncExecutionOutput::output_details): <p>Provides details about execution input or output.</p>
    ///   - [`trace_header(Option<String>)`](crate::output::StartSyncExecutionOutput::trace_header): <p>The AWS X-Ray trace header that was passed to the execution.</p>
    ///   - [`billing_details(Option<BillingDetails>)`](crate::output::StartSyncExecutionOutput::billing_details): <p>An object that describes workflow billing details, including billed duration and memory use.</p>
    /// - On failure, responds with [`SdkError<StartSyncExecutionError>`](crate::error::StartSyncExecutionError)
    pub fn start_sync_execution(&self) -> fluent_builders::StartSyncExecution {
        fluent_builders::StartSyncExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopExecution`](crate::client::fluent_builders::StopExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`execution_arn(impl Into<String>)`](crate::client::fluent_builders::StopExecution::execution_arn) / [`set_execution_arn(Option<String>)`](crate::client::fluent_builders::StopExecution::set_execution_arn): <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
    ///   - [`error(impl Into<String>)`](crate::client::fluent_builders::StopExecution::error) / [`set_error(Option<String>)`](crate::client::fluent_builders::StopExecution::set_error): <p>The error code of the failure.</p>
    ///   - [`cause(impl Into<String>)`](crate::client::fluent_builders::StopExecution::cause) / [`set_cause(Option<String>)`](crate::client::fluent_builders::StopExecution::set_cause): <p>A more detailed explanation of the cause of the failure.</p>
    /// - On success, responds with [`StopExecutionOutput`](crate::output::StopExecutionOutput) with field(s):
    ///   - [`stop_date(Option<DateTime>)`](crate::output::StopExecutionOutput::stop_date): <p>The date the execution is stopped.</p>
    /// - On failure, responds with [`SdkError<StopExecutionError>`](crate::error::StopExecutionError)
    pub fn stop_execution(&self) -> fluent_builders::StopExecution {
        fluent_builders::StopExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of tags to add to a resource.</p>  <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tags to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStateMachine`](crate::client::fluent_builders::UpdateStateMachine) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`state_machine_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStateMachine::state_machine_arn) / [`set_state_machine_arn(Option<String>)`](crate::client::fluent_builders::UpdateStateMachine::set_state_machine_arn): <p>The Amazon Resource Name (ARN) of the state machine.</p>
    ///   - [`definition(impl Into<String>)`](crate::client::fluent_builders::UpdateStateMachine::definition) / [`set_definition(Option<String>)`](crate::client::fluent_builders::UpdateStateMachine::set_definition): <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStateMachine::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateStateMachine::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::UpdateStateMachine::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::UpdateStateMachine::set_logging_configuration): <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>
    ///   - [`tracing_configuration(TracingConfiguration)`](crate::client::fluent_builders::UpdateStateMachine::tracing_configuration) / [`set_tracing_configuration(Option<TracingConfiguration>)`](crate::client::fluent_builders::UpdateStateMachine::set_tracing_configuration): <p>Selects whether AWS X-Ray tracing is enabled.</p>
    /// - On success, responds with [`UpdateStateMachineOutput`](crate::output::UpdateStateMachineOutput) with field(s):
    ///   - [`update_date(Option<DateTime>)`](crate::output::UpdateStateMachineOutput::update_date): <p>The date and time the state machine was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateStateMachineError>`](crate::error::UpdateStateMachineError)
    pub fn update_state_machine(&self) -> fluent_builders::UpdateStateMachine {
        fluent_builders::UpdateStateMachine::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateActivity`.
    ///
    /// <p>Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to AWS Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note> <note>
    /// <p> <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateActivity</code>'s idempotency check is based on the activity <code>name</code>. If a following request has different <code>tags</code> values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they are different.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateActivity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_activity_input::Builder,
    }
    impl CreateActivity {
        /// Creates a new `CreateActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActivityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStateMachine`.
    ///
    /// <p>Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code> states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured language. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> in the AWS Step Functions User Guide.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note> <note>
    /// <p> <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateStateMachine</code>'s idempotency check is based on the state machine <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code> and <code>TracingConfiguration</code>. If a following request has a different <code>roleArn</code> or <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are different.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStateMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_state_machine_input::Builder,
    }
    impl CreateStateMachine {
        /// Creates a new `CreateStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStateMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it has been created.</p>
        pub fn r#type(mut self, input: crate::model::StateMachineType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it has been created.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StateMachineType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p> <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p> <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.inner = self.inner.tracing_configuration(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_tracing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteActivity`.
    ///
    /// <p>Deletes an activity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteActivity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_activity_input::Builder,
    }
    impl DeleteActivity {
        /// Creates a new `DeleteActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActivityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStateMachine`.
    ///
    /// <p>Deletes a state machine. This is an asynchronous operation: It sets the state machine's status to <code>DELETING</code> and begins the deletion process. </p> <note>
    /// <p>For <code>EXPRESS</code>state machines, the deletion will happen eventually (usually less than a minute). Running executions may emit logs after <code>DeleteStateMachine</code> API is called.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStateMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_state_machine_input::Builder,
    }
    impl DeleteStateMachine {
        /// Creates a new `DeleteStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStateMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivity`.
    ///
    /// <p>Describes an activity.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActivity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_activity_input::Builder,
    }
    impl DescribeActivity {
        /// Creates a new `DescribeActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExecution`.
    ///
    /// <p>Describes an execution.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_execution_input::Builder,
    }
    impl DescribeExecution {
        /// Creates a new `DescribeExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStateMachine`.
    ///
    /// <p>Describes a state machine.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStateMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_state_machine_input::Builder,
    }
    impl DescribeStateMachine {
        /// Creates a new `DescribeStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStateMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStateMachineForExecution`.
    ///
    /// <p>Describes the state machine associated with a specific execution.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStateMachineForExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_state_machine_for_execution_input::Builder,
    }
    impl DescribeStateMachineForExecution {
        /// Creates a new `DescribeStateMachineForExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStateMachineForExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStateMachineForExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetActivityTask`.
    ///
    /// <p>Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a <code>taskToken</code> with a null string.</p> <important>
    /// <p>Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).</p>
    /// <p>Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling for Activity Tasks</a> in the Step Functions Developer Guide.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetActivityTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_activity_task_input::Builder,
    }
    impl GetActivityTask {
        /// Creates a new `GetActivityTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetActivityTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetActivityTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using <code>CreateActivity</code>.)</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using <code>CreateActivity</code>.)</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history.</p>
        pub fn worker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_name(input.into());
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history.</p>
        pub fn set_worker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExecutionHistory`.
    ///
    /// <p>Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get the latest events first.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExecutionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_execution_history_input::Builder,
    }
    impl GetExecutionHistory {
        /// Creates a new `GetExecutionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExecutionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExecutionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetExecutionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetExecutionHistoryPaginator {
            crate::paginator::GetExecutionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned. The default is <code>true</code>.</p>
        pub fn include_execution_data(mut self, input: bool) -> Self {
            self.inner = self.inner.include_execution_data(input);
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned. The default is <code>true</code>.</p>
        pub fn set_include_execution_data(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_execution_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivities`.
    ///
    /// <p>Lists the existing activities.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActivities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_activities_input::Builder,
    }
    impl ListActivities {
        /// Creates a new `ListActivities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListActivitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListActivitiesPaginator {
            crate::paginator::ListActivitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExecutions`.
    ///
    /// <p>Lists the executions of a state machine that meet the filtering criteria. Results are sorted by time, with the most recent execution first.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_executions_input::Builder,
    }
    impl ListExecutions {
        /// Creates a new `ListExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExecutionsPaginator {
            crate::paginator::ListExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given filter.</p>
        pub fn status_filter(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.inner = self.inner.status_filter(input);
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given filter.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStateMachines`.
    ///
    /// <p>Lists the existing state machines.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStateMachines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_state_machines_input::Builder,
    }
    impl ListStateMachines {
        /// Creates a new `ListStateMachines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStateMachinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStateMachinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStateMachinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStateMachinesPaginator {
            crate::paginator::ListStateMachinesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a given resource.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskFailure`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report that the task identified by the <code>taskToken</code> failed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTaskFailure {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_task_failure_input::Builder,
    }
    impl SendTaskFailure {
        /// Creates a new `SendTaskFailure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskFailureOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskFailureError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_error(input);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cause(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cause(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskHeartbeat`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is specified in the state machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for for tasks using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern.</p> <note>
    /// <p>The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is its maximum allowed duration, regardless of the number of <code>SendTaskHeartbeat</code> requests received. Use <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTaskHeartbeat {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_task_heartbeat_input::Builder,
    }
    impl SendTaskHeartbeat {
        /// Creates a new `SendTaskHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskHeartbeatError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskSuccess`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report that the task identified by the <code>taskToken</code> completed successfully.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTaskSuccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_task_success_input::Builder,
    }
    impl SendTaskSuccess {
        /// Creates a new `SendTaskSuccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskSuccessOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskSuccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <code>GetActivityTaskOutput$taskToken</code>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output(input.into());
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExecution`.
    ///
    /// <p>Starts a state machine execution.</p> <note>
    /// <p> <code>StartExecution</code> is idempotent. If <code>StartExecution</code> is called with the same name and input as a running execution, the call will succeed and return the same response as the original request. If the execution is closed or if the input is different, it will return a 400 <code>ExecutionAlreadyExists</code> error. Names can be reused after 90 days. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_execution_input::Builder,
    }
    impl StartExecution {
        /// Creates a new `StartExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li> <p>white space</p> </li>
        /// <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li>
        /// <li> <p>wildcard characters <code>? *</code> </p> </li>
        /// <li> <p>special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code> </p> </li>
        /// <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_header(input.into());
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trace_header(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSyncExecution`.
    ///
    /// <p>Starts a Synchronous Express state machine execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSyncExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_sync_execution_input::Builder,
    }
    impl StartSyncExecution {
        /// Creates a new `StartSyncExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSyncExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSyncExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The name of the execution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p> <code>"input": "{\"first_name\" : \"test\"}"</code> </p> <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_header(input.into());
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trace_header(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopExecution`.
    ///
    /// <p>Stops an execution.</p>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_execution_input::Builder,
    }
    impl StopExecution {
        /// Creates a new `StopExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_error(input);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cause(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cause(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add a tag to a Step Functions resource.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove a tag from a Step Functions resource</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStateMachine`.
    ///
    /// <p>Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code> and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you will receive a <code>MissingRequiredParameter</code> error.</p> <note>
    /// <p>All <code>StartExecution</code> calls within a few seconds will use the updated <code>definition</code> and <code>roleArn</code>. Executions started immediately after calling <code>UpdateStateMachine</code> may use the previous state machine <code>definition</code> and <code>roleArn</code>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStateMachine {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_state_machine_input::Builder,
    }
    impl UpdateStateMachine {
        /// Creates a new `UpdateStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStateMachineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.inner = self.inner.tracing_configuration(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_tracing_configuration(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
