// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateActivityError {
    /// Kind of error that occurred.
    pub kind: CreateActivityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateActivityErrorKind {
    /// <p>The maximum number of activities has been reached. Existing activities must be deleted
    /// before a new activity can be created.</p>
    ActivityLimitExceeded(crate::error::ActivityLimitExceeded),
    /// <p>The provided name is invalid.</p>
    InvalidName(crate::error::InvalidName),
    /// <p>You've exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the
    /// AWS Step Functions Developer Guide.</p>
    TooManyTags(crate::error::TooManyTags),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateActivityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateActivityErrorKind::ActivityLimitExceeded(_inner) => _inner.fmt(f),
            CreateActivityErrorKind::InvalidName(_inner) => _inner.fmt(f),
            CreateActivityErrorKind::TooManyTags(_inner) => _inner.fmt(f),
            CreateActivityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateActivityError {
    fn code(&self) -> Option<&str> {
        CreateActivityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateActivityError {
    /// Creates a new `CreateActivityError`.
    pub fn new(kind: CreateActivityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateActivityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateActivityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateActivityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateActivityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateActivityErrorKind::ActivityLimitExceeded`.
    pub fn is_activity_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateActivityErrorKind::ActivityLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateActivityErrorKind::InvalidName`.
    pub fn is_invalid_name(&self) -> bool {
        matches!(&self.kind, CreateActivityErrorKind::InvalidName(_))
    }
    /// Returns `true` if the error kind is `CreateActivityErrorKind::TooManyTags`.
    pub fn is_too_many_tags(&self) -> bool {
        matches!(&self.kind, CreateActivityErrorKind::TooManyTags(_))
    }
}
impl std::error::Error for CreateActivityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateActivityErrorKind::ActivityLimitExceeded(_inner) => Some(_inner),
            CreateActivityErrorKind::InvalidName(_inner) => Some(_inner),
            CreateActivityErrorKind::TooManyTags(_inner) => Some(_inner),
            CreateActivityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStateMachineError {
    /// Kind of error that occurred.
    pub kind: CreateStateMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStateMachineErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided Amazon States Language definition is invalid.</p>
    InvalidDefinition(crate::error::InvalidDefinition),
    /// <p></p>
    InvalidLoggingConfiguration(crate::error::InvalidLoggingConfiguration),
    /// <p>The provided name is invalid.</p>
    InvalidName(crate::error::InvalidName),
    /// <p>Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</p>
    InvalidTracingConfiguration(crate::error::InvalidTracingConfiguration),
    /// <p>A state machine with the same name but a different definition or role ARN already
    /// exists.</p>
    StateMachineAlreadyExists(crate::error::StateMachineAlreadyExists),
    /// <p>The specified state machine is being deleted.</p>
    StateMachineDeleting(crate::error::StateMachineDeleting),
    /// <p>The maximum number of state machines has been reached. Existing state machines must be
    /// deleted before a new state machine can be created.</p>
    StateMachineLimitExceeded(crate::error::StateMachineLimitExceeded),
    /// <p></p>
    StateMachineTypeNotSupported(crate::error::StateMachineTypeNotSupported),
    /// <p>You've exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the
    /// AWS Step Functions Developer Guide.</p>
    TooManyTags(crate::error::TooManyTags),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStateMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStateMachineErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::InvalidDefinition(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::InvalidLoggingConfiguration(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::InvalidName(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::InvalidTracingConfiguration(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::StateMachineAlreadyExists(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::StateMachineDeleting(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::StateMachineLimitExceeded(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::StateMachineTypeNotSupported(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::TooManyTags(_inner) => _inner.fmt(f),
            CreateStateMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStateMachineError {
    fn code(&self) -> Option<&str> {
        CreateStateMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStateMachineError {
    /// Creates a new `CreateStateMachineError`.
    pub fn new(kind: CreateStateMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStateMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStateMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStateMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStateMachineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, CreateStateMachineErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::InvalidDefinition`.
    pub fn is_invalid_definition(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::InvalidDefinition(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::InvalidLoggingConfiguration`.
    pub fn is_invalid_logging_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::InvalidLoggingConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::InvalidName`.
    pub fn is_invalid_name(&self) -> bool {
        matches!(&self.kind, CreateStateMachineErrorKind::InvalidName(_))
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::InvalidTracingConfiguration`.
    pub fn is_invalid_tracing_configuration(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::InvalidTracingConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::StateMachineAlreadyExists`.
    pub fn is_state_machine_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::StateMachineAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::StateMachineDeleting`.
    pub fn is_state_machine_deleting(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::StateMachineDeleting(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::StateMachineLimitExceeded`.
    pub fn is_state_machine_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::StateMachineLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::StateMachineTypeNotSupported`.
    pub fn is_state_machine_type_not_supported(&self) -> bool {
        matches!(
            &self.kind,
            CreateStateMachineErrorKind::StateMachineTypeNotSupported(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStateMachineErrorKind::TooManyTags`.
    pub fn is_too_many_tags(&self) -> bool {
        matches!(&self.kind, CreateStateMachineErrorKind::TooManyTags(_))
    }
}
impl std::error::Error for CreateStateMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStateMachineErrorKind::InvalidArn(_inner) => Some(_inner),
            CreateStateMachineErrorKind::InvalidDefinition(_inner) => Some(_inner),
            CreateStateMachineErrorKind::InvalidLoggingConfiguration(_inner) => Some(_inner),
            CreateStateMachineErrorKind::InvalidName(_inner) => Some(_inner),
            CreateStateMachineErrorKind::InvalidTracingConfiguration(_inner) => Some(_inner),
            CreateStateMachineErrorKind::StateMachineAlreadyExists(_inner) => Some(_inner),
            CreateStateMachineErrorKind::StateMachineDeleting(_inner) => Some(_inner),
            CreateStateMachineErrorKind::StateMachineLimitExceeded(_inner) => Some(_inner),
            CreateStateMachineErrorKind::StateMachineTypeNotSupported(_inner) => Some(_inner),
            CreateStateMachineErrorKind::TooManyTags(_inner) => Some(_inner),
            CreateStateMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteActivityError {
    /// Kind of error that occurred.
    pub kind: DeleteActivityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteActivityErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteActivityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteActivityErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DeleteActivityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteActivityError {
    fn code(&self) -> Option<&str> {
        DeleteActivityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteActivityError {
    /// Creates a new `DeleteActivityError`.
    pub fn new(kind: DeleteActivityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteActivityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteActivityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteActivityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteActivityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteActivityErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, DeleteActivityErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for DeleteActivityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteActivityErrorKind::InvalidArn(_inner) => Some(_inner),
            DeleteActivityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStateMachineError {
    /// Kind of error that occurred.
    pub kind: DeleteStateMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStateMachineErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStateMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStateMachineErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DeleteStateMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStateMachineError {
    fn code(&self) -> Option<&str> {
        DeleteStateMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStateMachineError {
    /// Creates a new `DeleteStateMachineError`.
    pub fn new(kind: DeleteStateMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStateMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStateMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStateMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStateMachineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStateMachineErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, DeleteStateMachineErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for DeleteStateMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStateMachineErrorKind::InvalidArn(_inner) => Some(_inner),
            DeleteStateMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeActivityError {
    /// Kind of error that occurred.
    pub kind: DescribeActivityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeActivityErrorKind {
    /// <p>The specified activity does not exist.</p>
    ActivityDoesNotExist(crate::error::ActivityDoesNotExist),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeActivityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeActivityErrorKind::ActivityDoesNotExist(_inner) => _inner.fmt(f),
            DescribeActivityErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DescribeActivityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeActivityError {
    fn code(&self) -> Option<&str> {
        DescribeActivityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeActivityError {
    /// Creates a new `DescribeActivityError`.
    pub fn new(kind: DescribeActivityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeActivityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeActivityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeActivityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeActivityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeActivityErrorKind::ActivityDoesNotExist`.
    pub fn is_activity_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeActivityErrorKind::ActivityDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeActivityErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, DescribeActivityErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for DescribeActivityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeActivityErrorKind::ActivityDoesNotExist(_inner) => Some(_inner),
            DescribeActivityErrorKind::InvalidArn(_inner) => Some(_inner),
            DescribeActivityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExecutionErrorKind {
    /// <p>The specified execution does not exist.</p>
    ExecutionDoesNotExist(crate::error::ExecutionDoesNotExist),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExecutionErrorKind::ExecutionDoesNotExist(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExecutionError {
    /// Creates a new `DescribeExecutionError`.
    pub fn new(kind: DescribeExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::ExecutionDoesNotExist`.
    pub fn is_execution_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExecutionErrorKind::ExecutionDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, DescribeExecutionErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for DescribeExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExecutionErrorKind::ExecutionDoesNotExist(_inner) => Some(_inner),
            DescribeExecutionErrorKind::InvalidArn(_inner) => Some(_inner),
            DescribeExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStateMachineError {
    /// Kind of error that occurred.
    pub kind: DescribeStateMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStateMachineErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The specified state machine does not exist.</p>
    StateMachineDoesNotExist(crate::error::StateMachineDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStateMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStateMachineErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DescribeStateMachineErrorKind::StateMachineDoesNotExist(_inner) => _inner.fmt(f),
            DescribeStateMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStateMachineError {
    fn code(&self) -> Option<&str> {
        DescribeStateMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStateMachineError {
    /// Creates a new `DescribeStateMachineError`.
    pub fn new(kind: DescribeStateMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStateMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStateMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStateMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStateMachineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStateMachineErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, DescribeStateMachineErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `DescribeStateMachineErrorKind::StateMachineDoesNotExist`.
    pub fn is_state_machine_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStateMachineErrorKind::StateMachineDoesNotExist(_)
        )
    }
}
impl std::error::Error for DescribeStateMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStateMachineErrorKind::InvalidArn(_inner) => Some(_inner),
            DescribeStateMachineErrorKind::StateMachineDoesNotExist(_inner) => Some(_inner),
            DescribeStateMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStateMachineForExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStateMachineForExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeStateMachineForExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStateMachineForExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStateMachineForExecutionErrorKind {
    /// <p>The specified execution does not exist.</p>
    ExecutionDoesNotExist(crate::error::ExecutionDoesNotExist),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStateMachineForExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStateMachineForExecutionErrorKind::ExecutionDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            DescribeStateMachineForExecutionErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            DescribeStateMachineForExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStateMachineForExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeStateMachineForExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStateMachineForExecutionError {
    /// Creates a new `DescribeStateMachineForExecutionError`.
    pub fn new(
        kind: DescribeStateMachineForExecutionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStateMachineForExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStateMachineForExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStateMachineForExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStateMachineForExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStateMachineForExecutionErrorKind::ExecutionDoesNotExist`.
    pub fn is_execution_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStateMachineForExecutionErrorKind::ExecutionDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStateMachineForExecutionErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStateMachineForExecutionErrorKind::InvalidArn(_)
        )
    }
}
impl std::error::Error for DescribeStateMachineForExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStateMachineForExecutionErrorKind::ExecutionDoesNotExist(_inner) => {
                Some(_inner)
            }
            DescribeStateMachineForExecutionErrorKind::InvalidArn(_inner) => Some(_inner),
            DescribeStateMachineForExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetActivityTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetActivityTaskError {
    /// Kind of error that occurred.
    pub kind: GetActivityTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetActivityTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetActivityTaskErrorKind {
    /// <p>The specified activity does not exist.</p>
    ActivityDoesNotExist(crate::error::ActivityDoesNotExist),
    /// <p>The maximum number of workers concurrently polling for activity tasks has been
    /// reached.</p>
    ActivityWorkerLimitExceeded(crate::error::ActivityWorkerLimitExceeded),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetActivityTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetActivityTaskErrorKind::ActivityDoesNotExist(_inner) => _inner.fmt(f),
            GetActivityTaskErrorKind::ActivityWorkerLimitExceeded(_inner) => _inner.fmt(f),
            GetActivityTaskErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            GetActivityTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetActivityTaskError {
    fn code(&self) -> Option<&str> {
        GetActivityTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetActivityTaskError {
    /// Creates a new `GetActivityTaskError`.
    pub fn new(kind: GetActivityTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetActivityTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetActivityTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetActivityTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetActivityTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetActivityTaskErrorKind::ActivityDoesNotExist`.
    pub fn is_activity_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            GetActivityTaskErrorKind::ActivityDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `GetActivityTaskErrorKind::ActivityWorkerLimitExceeded`.
    pub fn is_activity_worker_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            GetActivityTaskErrorKind::ActivityWorkerLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `GetActivityTaskErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, GetActivityTaskErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for GetActivityTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetActivityTaskErrorKind::ActivityDoesNotExist(_inner) => Some(_inner),
            GetActivityTaskErrorKind::ActivityWorkerLimitExceeded(_inner) => Some(_inner),
            GetActivityTaskErrorKind::InvalidArn(_inner) => Some(_inner),
            GetActivityTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExecutionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExecutionHistoryError {
    /// Kind of error that occurred.
    pub kind: GetExecutionHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExecutionHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExecutionHistoryErrorKind {
    /// <p>The specified execution does not exist.</p>
    ExecutionDoesNotExist(crate::error::ExecutionDoesNotExist),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExecutionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExecutionHistoryErrorKind::ExecutionDoesNotExist(_inner) => _inner.fmt(f),
            GetExecutionHistoryErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            GetExecutionHistoryErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            GetExecutionHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExecutionHistoryError {
    fn code(&self) -> Option<&str> {
        GetExecutionHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExecutionHistoryError {
    /// Creates a new `GetExecutionHistoryError`.
    pub fn new(kind: GetExecutionHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExecutionHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExecutionHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExecutionHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExecutionHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExecutionHistoryErrorKind::ExecutionDoesNotExist`.
    pub fn is_execution_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            GetExecutionHistoryErrorKind::ExecutionDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `GetExecutionHistoryErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, GetExecutionHistoryErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `GetExecutionHistoryErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, GetExecutionHistoryErrorKind::InvalidToken(_))
    }
}
impl std::error::Error for GetExecutionHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExecutionHistoryErrorKind::ExecutionDoesNotExist(_inner) => Some(_inner),
            GetExecutionHistoryErrorKind::InvalidArn(_inner) => Some(_inner),
            GetExecutionHistoryErrorKind::InvalidToken(_inner) => Some(_inner),
            GetExecutionHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActivitiesError {
    /// Kind of error that occurred.
    pub kind: ListActivitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActivities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActivitiesErrorKind {
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActivitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActivitiesErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            ListActivitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActivitiesError {
    fn code(&self) -> Option<&str> {
        ListActivitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActivitiesError {
    /// Creates a new `ListActivitiesError`.
    pub fn new(kind: ListActivitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActivitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActivitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActivitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActivitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActivitiesErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, ListActivitiesErrorKind::InvalidToken(_))
    }
}
impl std::error::Error for ListActivitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActivitiesErrorKind::InvalidToken(_inner) => Some(_inner),
            ListActivitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExecutionsErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    /// <p>The specified state machine does not exist.</p>
    StateMachineDoesNotExist(crate::error::StateMachineDoesNotExist),
    /// <p></p>
    StateMachineTypeNotSupported(crate::error::StateMachineTypeNotSupported),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExecutionsErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::StateMachineDoesNotExist(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::StateMachineTypeNotSupported(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExecutionsError {
    fn code(&self) -> Option<&str> {
        ListExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExecutionsError {
    /// Creates a new `ListExecutionsError`.
    pub fn new(kind: ListExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, ListExecutionsErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, ListExecutionsErrorKind::InvalidToken(_))
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::StateMachineDoesNotExist`.
    pub fn is_state_machine_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::StateMachineDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::StateMachineTypeNotSupported`.
    pub fn is_state_machine_type_not_supported(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::StateMachineTypeNotSupported(_)
        )
    }
}
impl std::error::Error for ListExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExecutionsErrorKind::InvalidArn(_inner) => Some(_inner),
            ListExecutionsErrorKind::InvalidToken(_inner) => Some(_inner),
            ListExecutionsErrorKind::StateMachineDoesNotExist(_inner) => Some(_inner),
            ListExecutionsErrorKind::StateMachineTypeNotSupported(_inner) => Some(_inner),
            ListExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStateMachines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStateMachinesError {
    /// Kind of error that occurred.
    pub kind: ListStateMachinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStateMachines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStateMachinesErrorKind {
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStateMachinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStateMachinesErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            ListStateMachinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStateMachinesError {
    fn code(&self) -> Option<&str> {
        ListStateMachinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStateMachinesError {
    /// Creates a new `ListStateMachinesError`.
    pub fn new(kind: ListStateMachinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStateMachinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStateMachinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStateMachinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStateMachinesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStateMachinesErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, ListStateMachinesErrorKind::InvalidToken(_))
    }
}
impl std::error::Error for ListStateMachinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStateMachinesErrorKind::InvalidToken(_inner) => Some(_inner),
            ListStateMachinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>Could not find the referenced resource. Only state machine and activity ARNs are
    /// supported.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFound(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidArn(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTaskFailure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTaskFailureError {
    /// Kind of error that occurred.
    pub kind: SendTaskFailureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTaskFailure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTaskFailureErrorKind {
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    #[allow(missing_docs)] // documentation missing in model
    TaskDoesNotExist(crate::error::TaskDoesNotExist),
    #[allow(missing_docs)] // documentation missing in model
    TaskTimedOut(crate::error::TaskTimedOut),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTaskFailureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTaskFailureErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            SendTaskFailureErrorKind::TaskDoesNotExist(_inner) => _inner.fmt(f),
            SendTaskFailureErrorKind::TaskTimedOut(_inner) => _inner.fmt(f),
            SendTaskFailureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTaskFailureError {
    fn code(&self) -> Option<&str> {
        SendTaskFailureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendTaskFailureError {
    /// Creates a new `SendTaskFailureError`.
    pub fn new(kind: SendTaskFailureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTaskFailureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTaskFailureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTaskFailureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTaskFailureErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendTaskFailureErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, SendTaskFailureErrorKind::InvalidToken(_))
    }
    /// Returns `true` if the error kind is `SendTaskFailureErrorKind::TaskDoesNotExist`.
    pub fn is_task_does_not_exist(&self) -> bool {
        matches!(&self.kind, SendTaskFailureErrorKind::TaskDoesNotExist(_))
    }
    /// Returns `true` if the error kind is `SendTaskFailureErrorKind::TaskTimedOut`.
    pub fn is_task_timed_out(&self) -> bool {
        matches!(&self.kind, SendTaskFailureErrorKind::TaskTimedOut(_))
    }
}
impl std::error::Error for SendTaskFailureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTaskFailureErrorKind::InvalidToken(_inner) => Some(_inner),
            SendTaskFailureErrorKind::TaskDoesNotExist(_inner) => Some(_inner),
            SendTaskFailureErrorKind::TaskTimedOut(_inner) => Some(_inner),
            SendTaskFailureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTaskHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTaskHeartbeatError {
    /// Kind of error that occurred.
    pub kind: SendTaskHeartbeatErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTaskHeartbeat` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTaskHeartbeatErrorKind {
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    #[allow(missing_docs)] // documentation missing in model
    TaskDoesNotExist(crate::error::TaskDoesNotExist),
    #[allow(missing_docs)] // documentation missing in model
    TaskTimedOut(crate::error::TaskTimedOut),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTaskHeartbeatError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTaskHeartbeatErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            SendTaskHeartbeatErrorKind::TaskDoesNotExist(_inner) => _inner.fmt(f),
            SendTaskHeartbeatErrorKind::TaskTimedOut(_inner) => _inner.fmt(f),
            SendTaskHeartbeatErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTaskHeartbeatError {
    fn code(&self) -> Option<&str> {
        SendTaskHeartbeatError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendTaskHeartbeatError {
    /// Creates a new `SendTaskHeartbeatError`.
    pub fn new(kind: SendTaskHeartbeatErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTaskHeartbeatError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTaskHeartbeatErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTaskHeartbeatError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTaskHeartbeatErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendTaskHeartbeatErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, SendTaskHeartbeatErrorKind::InvalidToken(_))
    }
    /// Returns `true` if the error kind is `SendTaskHeartbeatErrorKind::TaskDoesNotExist`.
    pub fn is_task_does_not_exist(&self) -> bool {
        matches!(&self.kind, SendTaskHeartbeatErrorKind::TaskDoesNotExist(_))
    }
    /// Returns `true` if the error kind is `SendTaskHeartbeatErrorKind::TaskTimedOut`.
    pub fn is_task_timed_out(&self) -> bool {
        matches!(&self.kind, SendTaskHeartbeatErrorKind::TaskTimedOut(_))
    }
}
impl std::error::Error for SendTaskHeartbeatError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTaskHeartbeatErrorKind::InvalidToken(_inner) => Some(_inner),
            SendTaskHeartbeatErrorKind::TaskDoesNotExist(_inner) => Some(_inner),
            SendTaskHeartbeatErrorKind::TaskTimedOut(_inner) => Some(_inner),
            SendTaskHeartbeatErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTaskSuccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTaskSuccessError {
    /// Kind of error that occurred.
    pub kind: SendTaskSuccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTaskSuccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTaskSuccessErrorKind {
    /// <p>The provided JSON output data is invalid.</p>
    InvalidOutput(crate::error::InvalidOutput),
    /// <p>The provided token is invalid.</p>
    InvalidToken(crate::error::InvalidToken),
    #[allow(missing_docs)] // documentation missing in model
    TaskDoesNotExist(crate::error::TaskDoesNotExist),
    #[allow(missing_docs)] // documentation missing in model
    TaskTimedOut(crate::error::TaskTimedOut),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTaskSuccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTaskSuccessErrorKind::InvalidOutput(_inner) => _inner.fmt(f),
            SendTaskSuccessErrorKind::InvalidToken(_inner) => _inner.fmt(f),
            SendTaskSuccessErrorKind::TaskDoesNotExist(_inner) => _inner.fmt(f),
            SendTaskSuccessErrorKind::TaskTimedOut(_inner) => _inner.fmt(f),
            SendTaskSuccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTaskSuccessError {
    fn code(&self) -> Option<&str> {
        SendTaskSuccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendTaskSuccessError {
    /// Creates a new `SendTaskSuccessError`.
    pub fn new(kind: SendTaskSuccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTaskSuccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTaskSuccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTaskSuccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTaskSuccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendTaskSuccessErrorKind::InvalidOutput`.
    pub fn is_invalid_output(&self) -> bool {
        matches!(&self.kind, SendTaskSuccessErrorKind::InvalidOutput(_))
    }
    /// Returns `true` if the error kind is `SendTaskSuccessErrorKind::InvalidToken`.
    pub fn is_invalid_token(&self) -> bool {
        matches!(&self.kind, SendTaskSuccessErrorKind::InvalidToken(_))
    }
    /// Returns `true` if the error kind is `SendTaskSuccessErrorKind::TaskDoesNotExist`.
    pub fn is_task_does_not_exist(&self) -> bool {
        matches!(&self.kind, SendTaskSuccessErrorKind::TaskDoesNotExist(_))
    }
    /// Returns `true` if the error kind is `SendTaskSuccessErrorKind::TaskTimedOut`.
    pub fn is_task_timed_out(&self) -> bool {
        matches!(&self.kind, SendTaskSuccessErrorKind::TaskTimedOut(_))
    }
}
impl std::error::Error for SendTaskSuccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTaskSuccessErrorKind::InvalidOutput(_inner) => Some(_inner),
            SendTaskSuccessErrorKind::InvalidToken(_inner) => Some(_inner),
            SendTaskSuccessErrorKind::TaskDoesNotExist(_inner) => Some(_inner),
            SendTaskSuccessErrorKind::TaskTimedOut(_inner) => Some(_inner),
            SendTaskSuccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartExecutionError {
    /// Kind of error that occurred.
    pub kind: StartExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartExecutionErrorKind {
    /// <p>The execution has the same <code>name</code> as another execution (but a different
    /// <code>input</code>).</p>
    /// <note>
    /// <p>Executions with the same <code>name</code> and <code>input</code> are considered
    /// idempotent.</p>
    /// </note>
    ExecutionAlreadyExists(crate::error::ExecutionAlreadyExists),
    /// <p>The maximum number of running executions has been reached. Running executions must end or
    /// be stopped before a new execution can be started.</p>
    ExecutionLimitExceeded(crate::error::ExecutionLimitExceeded),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided JSON input data is invalid.</p>
    InvalidExecutionInput(crate::error::InvalidExecutionInput),
    /// <p>The provided name is invalid.</p>
    InvalidName(crate::error::InvalidName),
    /// <p>The specified state machine is being deleted.</p>
    StateMachineDeleting(crate::error::StateMachineDeleting),
    /// <p>The specified state machine does not exist.</p>
    StateMachineDoesNotExist(crate::error::StateMachineDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartExecutionErrorKind::ExecutionAlreadyExists(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::ExecutionLimitExceeded(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::InvalidExecutionInput(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::InvalidName(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::StateMachineDeleting(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::StateMachineDoesNotExist(_inner) => _inner.fmt(f),
            StartExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartExecutionError {
    fn code(&self) -> Option<&str> {
        StartExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartExecutionError {
    /// Creates a new `StartExecutionError`.
    pub fn new(kind: StartExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::ExecutionAlreadyExists`.
    pub fn is_execution_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            StartExecutionErrorKind::ExecutionAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::ExecutionLimitExceeded`.
    pub fn is_execution_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            StartExecutionErrorKind::ExecutionLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, StartExecutionErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::InvalidExecutionInput`.
    pub fn is_invalid_execution_input(&self) -> bool {
        matches!(
            &self.kind,
            StartExecutionErrorKind::InvalidExecutionInput(_)
        )
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::InvalidName`.
    pub fn is_invalid_name(&self) -> bool {
        matches!(&self.kind, StartExecutionErrorKind::InvalidName(_))
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::StateMachineDeleting`.
    pub fn is_state_machine_deleting(&self) -> bool {
        matches!(&self.kind, StartExecutionErrorKind::StateMachineDeleting(_))
    }
    /// Returns `true` if the error kind is `StartExecutionErrorKind::StateMachineDoesNotExist`.
    pub fn is_state_machine_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            StartExecutionErrorKind::StateMachineDoesNotExist(_)
        )
    }
}
impl std::error::Error for StartExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartExecutionErrorKind::ExecutionAlreadyExists(_inner) => Some(_inner),
            StartExecutionErrorKind::ExecutionLimitExceeded(_inner) => Some(_inner),
            StartExecutionErrorKind::InvalidArn(_inner) => Some(_inner),
            StartExecutionErrorKind::InvalidExecutionInput(_inner) => Some(_inner),
            StartExecutionErrorKind::InvalidName(_inner) => Some(_inner),
            StartExecutionErrorKind::StateMachineDeleting(_inner) => Some(_inner),
            StartExecutionErrorKind::StateMachineDoesNotExist(_inner) => Some(_inner),
            StartExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSyncExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSyncExecutionError {
    /// Kind of error that occurred.
    pub kind: StartSyncExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSyncExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSyncExecutionErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided JSON input data is invalid.</p>
    InvalidExecutionInput(crate::error::InvalidExecutionInput),
    /// <p>The provided name is invalid.</p>
    InvalidName(crate::error::InvalidName),
    /// <p>The specified state machine is being deleted.</p>
    StateMachineDeleting(crate::error::StateMachineDeleting),
    /// <p>The specified state machine does not exist.</p>
    StateMachineDoesNotExist(crate::error::StateMachineDoesNotExist),
    /// <p></p>
    StateMachineTypeNotSupported(crate::error::StateMachineTypeNotSupported),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSyncExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSyncExecutionErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::InvalidExecutionInput(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::InvalidName(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::StateMachineDeleting(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::StateMachineDoesNotExist(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::StateMachineTypeNotSupported(_inner) => _inner.fmt(f),
            StartSyncExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSyncExecutionError {
    fn code(&self) -> Option<&str> {
        StartSyncExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSyncExecutionError {
    /// Creates a new `StartSyncExecutionError`.
    pub fn new(kind: StartSyncExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSyncExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSyncExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSyncExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSyncExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, StartSyncExecutionErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::InvalidExecutionInput`.
    pub fn is_invalid_execution_input(&self) -> bool {
        matches!(
            &self.kind,
            StartSyncExecutionErrorKind::InvalidExecutionInput(_)
        )
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::InvalidName`.
    pub fn is_invalid_name(&self) -> bool {
        matches!(&self.kind, StartSyncExecutionErrorKind::InvalidName(_))
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::StateMachineDeleting`.
    pub fn is_state_machine_deleting(&self) -> bool {
        matches!(
            &self.kind,
            StartSyncExecutionErrorKind::StateMachineDeleting(_)
        )
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::StateMachineDoesNotExist`.
    pub fn is_state_machine_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            StartSyncExecutionErrorKind::StateMachineDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `StartSyncExecutionErrorKind::StateMachineTypeNotSupported`.
    pub fn is_state_machine_type_not_supported(&self) -> bool {
        matches!(
            &self.kind,
            StartSyncExecutionErrorKind::StateMachineTypeNotSupported(_)
        )
    }
}
impl std::error::Error for StartSyncExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSyncExecutionErrorKind::InvalidArn(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::InvalidExecutionInput(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::InvalidName(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::StateMachineDeleting(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::StateMachineDoesNotExist(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::StateMachineTypeNotSupported(_inner) => Some(_inner),
            StartSyncExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopExecutionError {
    /// Kind of error that occurred.
    pub kind: StopExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopExecutionErrorKind {
    /// <p>The specified execution does not exist.</p>
    ExecutionDoesNotExist(crate::error::ExecutionDoesNotExist),
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopExecutionErrorKind::ExecutionDoesNotExist(_inner) => _inner.fmt(f),
            StopExecutionErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            StopExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopExecutionError {
    fn code(&self) -> Option<&str> {
        StopExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopExecutionError {
    /// Creates a new `StopExecutionError`.
    pub fn new(kind: StopExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopExecutionErrorKind::ExecutionDoesNotExist`.
    pub fn is_execution_does_not_exist(&self) -> bool {
        matches!(&self.kind, StopExecutionErrorKind::ExecutionDoesNotExist(_))
    }
    /// Returns `true` if the error kind is `StopExecutionErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, StopExecutionErrorKind::InvalidArn(_))
    }
}
impl std::error::Error for StopExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopExecutionErrorKind::ExecutionDoesNotExist(_inner) => Some(_inner),
            StopExecutionErrorKind::InvalidArn(_inner) => Some(_inner),
            StopExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>Could not find the referenced resource. Only state machine and activity ARNs are
    /// supported.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// <p>You've exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the
    /// AWS Step Functions Developer Guide.</p>
    TooManyTags(crate::error::TooManyTags),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTags(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ResourceNotFound(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTags`.
    pub fn is_too_many_tags(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTags(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidArn(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTags(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>Could not find the referenced resource. Only state machine and activity ARNs are
    /// supported.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ResourceNotFound(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidArn(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFound(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStateMachineError {
    /// Kind of error that occurred.
    pub kind: UpdateStateMachineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStateMachine` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStateMachineErrorKind {
    /// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
    InvalidArn(crate::error::InvalidArn),
    /// <p>The provided Amazon States Language definition is invalid.</p>
    InvalidDefinition(crate::error::InvalidDefinition),
    /// <p></p>
    InvalidLoggingConfiguration(crate::error::InvalidLoggingConfiguration),
    /// <p>Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</p>
    InvalidTracingConfiguration(crate::error::InvalidTracingConfiguration),
    /// <p>Request is missing a required parameter. This error occurs if both <code>definition</code>
    /// and <code>roleArn</code> are not specified.</p>
    MissingRequiredParameter(crate::error::MissingRequiredParameter),
    /// <p>The specified state machine is being deleted.</p>
    StateMachineDeleting(crate::error::StateMachineDeleting),
    /// <p>The specified state machine does not exist.</p>
    StateMachineDoesNotExist(crate::error::StateMachineDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStateMachineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStateMachineErrorKind::InvalidArn(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::InvalidDefinition(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::InvalidLoggingConfiguration(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::InvalidTracingConfiguration(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::MissingRequiredParameter(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::StateMachineDeleting(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::StateMachineDoesNotExist(_inner) => _inner.fmt(f),
            UpdateStateMachineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStateMachineError {
    fn code(&self) -> Option<&str> {
        UpdateStateMachineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStateMachineError {
    /// Creates a new `UpdateStateMachineError`.
    pub fn new(kind: UpdateStateMachineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStateMachineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStateMachineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStateMachineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStateMachineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::InvalidArn`.
    pub fn is_invalid_arn(&self) -> bool {
        matches!(&self.kind, UpdateStateMachineErrorKind::InvalidArn(_))
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::InvalidDefinition`.
    pub fn is_invalid_definition(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::InvalidDefinition(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::InvalidLoggingConfiguration`.
    pub fn is_invalid_logging_configuration(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::InvalidLoggingConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::InvalidTracingConfiguration`.
    pub fn is_invalid_tracing_configuration(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::InvalidTracingConfiguration(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::MissingRequiredParameter`.
    pub fn is_missing_required_parameter(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::MissingRequiredParameter(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::StateMachineDeleting`.
    pub fn is_state_machine_deleting(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::StateMachineDeleting(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStateMachineErrorKind::StateMachineDoesNotExist`.
    pub fn is_state_machine_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStateMachineErrorKind::StateMachineDoesNotExist(_)
        )
    }
}
impl std::error::Error for UpdateStateMachineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStateMachineErrorKind::InvalidArn(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::InvalidDefinition(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::InvalidLoggingConfiguration(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::InvalidTracingConfiguration(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::MissingRequiredParameter(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::StateMachineDeleting(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::StateMachineDoesNotExist(_inner) => Some(_inner),
            UpdateStateMachineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified state machine does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StateMachineDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StateMachineDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StateMachineDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StateMachineDoesNotExist")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for StateMachineDoesNotExist {}
/// See [`StateMachineDoesNotExist`](crate::error::StateMachineDoesNotExist)
pub mod state_machine_does_not_exist {
    /// A builder for [`StateMachineDoesNotExist`](crate::error::StateMachineDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineDoesNotExist`](crate::error::StateMachineDoesNotExist)
        pub fn build(self) -> crate::error::StateMachineDoesNotExist {
            crate::error::StateMachineDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl StateMachineDoesNotExist {
    /// Creates a new builder-style object to manufacture [`StateMachineDoesNotExist`](crate::error::StateMachineDoesNotExist)
    pub fn builder() -> crate::error::state_machine_does_not_exist::Builder {
        crate::error::state_machine_does_not_exist::Builder::default()
    }
}

/// <p>The specified state machine is being deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineDeleting {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StateMachineDeleting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineDeleting");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StateMachineDeleting {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StateMachineDeleting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StateMachineDeleting")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for StateMachineDeleting {}
/// See [`StateMachineDeleting`](crate::error::StateMachineDeleting)
pub mod state_machine_deleting {
    /// A builder for [`StateMachineDeleting`](crate::error::StateMachineDeleting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineDeleting`](crate::error::StateMachineDeleting)
        pub fn build(self) -> crate::error::StateMachineDeleting {
            crate::error::StateMachineDeleting {
                message: self.message,
            }
        }
    }
}
impl StateMachineDeleting {
    /// Creates a new builder-style object to manufacture [`StateMachineDeleting`](crate::error::StateMachineDeleting)
    pub fn builder() -> crate::error::state_machine_deleting::Builder {
        crate::error::state_machine_deleting::Builder::default()
    }
}

/// <p>Request is missing a required parameter. This error occurs if both <code>definition</code>
/// and <code>roleArn</code> are not specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingRequiredParameter {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingRequiredParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingRequiredParameter");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingRequiredParameter {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingRequiredParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingRequiredParameter")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingRequiredParameter {}
/// See [`MissingRequiredParameter`](crate::error::MissingRequiredParameter)
pub mod missing_required_parameter {
    /// A builder for [`MissingRequiredParameter`](crate::error::MissingRequiredParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingRequiredParameter`](crate::error::MissingRequiredParameter)
        pub fn build(self) -> crate::error::MissingRequiredParameter {
            crate::error::MissingRequiredParameter {
                message: self.message,
            }
        }
    }
}
impl MissingRequiredParameter {
    /// Creates a new builder-style object to manufacture [`MissingRequiredParameter`](crate::error::MissingRequiredParameter)
    pub fn builder() -> crate::error::missing_required_parameter::Builder {
        crate::error::missing_required_parameter::Builder::default()
    }
}

/// <p>Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTracingConfiguration {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTracingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTracingConfiguration");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTracingConfiguration {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTracingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTracingConfiguration")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTracingConfiguration {}
/// See [`InvalidTracingConfiguration`](crate::error::InvalidTracingConfiguration)
pub mod invalid_tracing_configuration {
    /// A builder for [`InvalidTracingConfiguration`](crate::error::InvalidTracingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTracingConfiguration`](crate::error::InvalidTracingConfiguration)
        pub fn build(self) -> crate::error::InvalidTracingConfiguration {
            crate::error::InvalidTracingConfiguration {
                message: self.message,
            }
        }
    }
}
impl InvalidTracingConfiguration {
    /// Creates a new builder-style object to manufacture [`InvalidTracingConfiguration`](crate::error::InvalidTracingConfiguration)
    pub fn builder() -> crate::error::invalid_tracing_configuration::Builder {
        crate::error::invalid_tracing_configuration::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLoggingConfiguration {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLoggingConfiguration");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLoggingConfiguration {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLoggingConfiguration")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLoggingConfiguration {}
/// See [`InvalidLoggingConfiguration`](crate::error::InvalidLoggingConfiguration)
pub mod invalid_logging_configuration {
    /// A builder for [`InvalidLoggingConfiguration`](crate::error::InvalidLoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLoggingConfiguration`](crate::error::InvalidLoggingConfiguration)
        pub fn build(self) -> crate::error::InvalidLoggingConfiguration {
            crate::error::InvalidLoggingConfiguration {
                message: self.message,
            }
        }
    }
}
impl InvalidLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`InvalidLoggingConfiguration`](crate::error::InvalidLoggingConfiguration)
    pub fn builder() -> crate::error::invalid_logging_configuration::Builder {
        crate::error::invalid_logging_configuration::Builder::default()
    }
}

/// <p>The provided Amazon States Language definition is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDefinition {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDefinition");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDefinition {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDefinition")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDefinition {}
/// See [`InvalidDefinition`](crate::error::InvalidDefinition)
pub mod invalid_definition {
    /// A builder for [`InvalidDefinition`](crate::error::InvalidDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDefinition`](crate::error::InvalidDefinition)
        pub fn build(self) -> crate::error::InvalidDefinition {
            crate::error::InvalidDefinition {
                message: self.message,
            }
        }
    }
}
impl InvalidDefinition {
    /// Creates a new builder-style object to manufacture [`InvalidDefinition`](crate::error::InvalidDefinition)
    pub fn builder() -> crate::error::invalid_definition::Builder {
        crate::error::invalid_definition::Builder::default()
    }
}

/// <p>The provided Amazon Resource Name (ARN) is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArn {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArn");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArn {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArn")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArn {}
/// See [`InvalidArn`](crate::error::InvalidArn)
pub mod invalid_arn {
    /// A builder for [`InvalidArn`](crate::error::InvalidArn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArn`](crate::error::InvalidArn)
        pub fn build(self) -> crate::error::InvalidArn {
            crate::error::InvalidArn {
                message: self.message,
            }
        }
    }
}
impl InvalidArn {
    /// Creates a new builder-style object to manufacture [`InvalidArn`](crate::error::InvalidArn)
    pub fn builder() -> crate::error::invalid_arn::Builder {
        crate::error::invalid_arn::Builder::default()
    }
}

/// <p>Could not find the referenced resource. Only state machine and activity ARNs are
/// supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl ResourceNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFound");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl ResourceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFound")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFound {}
/// See [`ResourceNotFound`](crate::error::ResourceNotFound)
pub mod resource_not_found {
    /// A builder for [`ResourceNotFound`](crate::error::ResourceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFound`](crate::error::ResourceNotFound)
        pub fn build(self) -> crate::error::ResourceNotFound {
            crate::error::ResourceNotFound {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl ResourceNotFound {
    /// Creates a new builder-style object to manufacture [`ResourceNotFound`](crate::error::ResourceNotFound)
    pub fn builder() -> crate::error::resource_not_found::Builder {
        crate::error::resource_not_found::Builder::default()
    }
}

/// <p>You've exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the
/// AWS Step Functions Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTags {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTags {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTags {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTags");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTags {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTags {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTags")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTags {}
/// See [`TooManyTags`](crate::error::TooManyTags)
pub mod too_many_tags {
    /// A builder for [`TooManyTags`](crate::error::TooManyTags)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTags`](crate::error::TooManyTags)
        pub fn build(self) -> crate::error::TooManyTags {
            crate::error::TooManyTags {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTags {
    /// Creates a new builder-style object to manufacture [`TooManyTags`](crate::error::TooManyTags)
    pub fn builder() -> crate::error::too_many_tags::Builder {
        crate::error::too_many_tags::Builder::default()
    }
}

/// <p>The specified execution does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecutionDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExecutionDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExecutionDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExecutionDoesNotExist")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExecutionDoesNotExist {}
/// See [`ExecutionDoesNotExist`](crate::error::ExecutionDoesNotExist)
pub mod execution_does_not_exist {
    /// A builder for [`ExecutionDoesNotExist`](crate::error::ExecutionDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionDoesNotExist`](crate::error::ExecutionDoesNotExist)
        pub fn build(self) -> crate::error::ExecutionDoesNotExist {
            crate::error::ExecutionDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl ExecutionDoesNotExist {
    /// Creates a new builder-style object to manufacture [`ExecutionDoesNotExist`](crate::error::ExecutionDoesNotExist)
    pub fn builder() -> crate::error::execution_does_not_exist::Builder {
        crate::error::execution_does_not_exist::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineTypeNotSupported {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StateMachineTypeNotSupported {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineTypeNotSupported");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StateMachineTypeNotSupported {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StateMachineTypeNotSupported {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StateMachineTypeNotSupported")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for StateMachineTypeNotSupported {}
/// See [`StateMachineTypeNotSupported`](crate::error::StateMachineTypeNotSupported)
pub mod state_machine_type_not_supported {
    /// A builder for [`StateMachineTypeNotSupported`](crate::error::StateMachineTypeNotSupported)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineTypeNotSupported`](crate::error::StateMachineTypeNotSupported)
        pub fn build(self) -> crate::error::StateMachineTypeNotSupported {
            crate::error::StateMachineTypeNotSupported {
                message: self.message,
            }
        }
    }
}
impl StateMachineTypeNotSupported {
    /// Creates a new builder-style object to manufacture [`StateMachineTypeNotSupported`](crate::error::StateMachineTypeNotSupported)
    pub fn builder() -> crate::error::state_machine_type_not_supported::Builder {
        crate::error::state_machine_type_not_supported::Builder::default()
    }
}

/// <p>The provided name is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidName {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidName");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidName {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidName")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidName {}
/// See [`InvalidName`](crate::error::InvalidName)
pub mod invalid_name {
    /// A builder for [`InvalidName`](crate::error::InvalidName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidName`](crate::error::InvalidName)
        pub fn build(self) -> crate::error::InvalidName {
            crate::error::InvalidName {
                message: self.message,
            }
        }
    }
}
impl InvalidName {
    /// Creates a new builder-style object to manufacture [`InvalidName`](crate::error::InvalidName)
    pub fn builder() -> crate::error::invalid_name::Builder {
        crate::error::invalid_name::Builder::default()
    }
}

/// <p>The provided JSON input data is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExecutionInput {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExecutionInput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExecutionInput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExecutionInput")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExecutionInput {}
/// See [`InvalidExecutionInput`](crate::error::InvalidExecutionInput)
pub mod invalid_execution_input {
    /// A builder for [`InvalidExecutionInput`](crate::error::InvalidExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExecutionInput`](crate::error::InvalidExecutionInput)
        pub fn build(self) -> crate::error::InvalidExecutionInput {
            crate::error::InvalidExecutionInput {
                message: self.message,
            }
        }
    }
}
impl InvalidExecutionInput {
    /// Creates a new builder-style object to manufacture [`InvalidExecutionInput`](crate::error::InvalidExecutionInput)
    pub fn builder() -> crate::error::invalid_execution_input::Builder {
        crate::error::invalid_execution_input::Builder::default()
    }
}

/// <p>The maximum number of running executions has been reached. Running executions must end or
/// be stopped before a new execution can be started.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecutionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExecutionLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExecutionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExecutionLimitExceeded")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExecutionLimitExceeded {}
/// See [`ExecutionLimitExceeded`](crate::error::ExecutionLimitExceeded)
pub mod execution_limit_exceeded {
    /// A builder for [`ExecutionLimitExceeded`](crate::error::ExecutionLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionLimitExceeded`](crate::error::ExecutionLimitExceeded)
        pub fn build(self) -> crate::error::ExecutionLimitExceeded {
            crate::error::ExecutionLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ExecutionLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ExecutionLimitExceeded`](crate::error::ExecutionLimitExceeded)
    pub fn builder() -> crate::error::execution_limit_exceeded::Builder {
        crate::error::execution_limit_exceeded::Builder::default()
    }
}

/// <p>The execution has the same <code>name</code> as another execution (but a different
/// <code>input</code>).</p>
/// <note>
/// <p>Executions with the same <code>name</code> and <code>input</code> are considered
/// idempotent.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecutionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExecutionAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExecutionAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExecutionAlreadyExists")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExecutionAlreadyExists {}
/// See [`ExecutionAlreadyExists`](crate::error::ExecutionAlreadyExists)
pub mod execution_already_exists {
    /// A builder for [`ExecutionAlreadyExists`](crate::error::ExecutionAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionAlreadyExists`](crate::error::ExecutionAlreadyExists)
        pub fn build(self) -> crate::error::ExecutionAlreadyExists {
            crate::error::ExecutionAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl ExecutionAlreadyExists {
    /// Creates a new builder-style object to manufacture [`ExecutionAlreadyExists`](crate::error::ExecutionAlreadyExists)
    pub fn builder() -> crate::error::execution_already_exists::Builder {
        crate::error::execution_already_exists::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskTimedOut {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TaskTimedOut {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskTimedOut");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TaskTimedOut {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TaskTimedOut {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TaskTimedOut")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for TaskTimedOut {}
/// See [`TaskTimedOut`](crate::error::TaskTimedOut)
pub mod task_timed_out {
    /// A builder for [`TaskTimedOut`](crate::error::TaskTimedOut)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskTimedOut`](crate::error::TaskTimedOut)
        pub fn build(self) -> crate::error::TaskTimedOut {
            crate::error::TaskTimedOut {
                message: self.message,
            }
        }
    }
}
impl TaskTimedOut {
    /// Creates a new builder-style object to manufacture [`TaskTimedOut`](crate::error::TaskTimedOut)
    pub fn builder() -> crate::error::task_timed_out::Builder {
        crate::error::task_timed_out::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TaskDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TaskDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TaskDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TaskDoesNotExist")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for TaskDoesNotExist {}
/// See [`TaskDoesNotExist`](crate::error::TaskDoesNotExist)
pub mod task_does_not_exist {
    /// A builder for [`TaskDoesNotExist`](crate::error::TaskDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskDoesNotExist`](crate::error::TaskDoesNotExist)
        pub fn build(self) -> crate::error::TaskDoesNotExist {
            crate::error::TaskDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl TaskDoesNotExist {
    /// Creates a new builder-style object to manufacture [`TaskDoesNotExist`](crate::error::TaskDoesNotExist)
    pub fn builder() -> crate::error::task_does_not_exist::Builder {
        crate::error::task_does_not_exist::Builder::default()
    }
}

/// <p>The provided token is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidToken {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidToken");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidToken {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidToken")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidToken {}
/// See [`InvalidToken`](crate::error::InvalidToken)
pub mod invalid_token {
    /// A builder for [`InvalidToken`](crate::error::InvalidToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidToken`](crate::error::InvalidToken)
        pub fn build(self) -> crate::error::InvalidToken {
            crate::error::InvalidToken {
                message: self.message,
            }
        }
    }
}
impl InvalidToken {
    /// Creates a new builder-style object to manufacture [`InvalidToken`](crate::error::InvalidToken)
    pub fn builder() -> crate::error::invalid_token::Builder {
        crate::error::invalid_token::Builder::default()
    }
}

/// <p>The provided JSON output data is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOutput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOutput")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOutput {}
/// See [`InvalidOutput`](crate::error::InvalidOutput)
pub mod invalid_output {
    /// A builder for [`InvalidOutput`](crate::error::InvalidOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOutput`](crate::error::InvalidOutput)
        pub fn build(self) -> crate::error::InvalidOutput {
            crate::error::InvalidOutput {
                message: self.message,
            }
        }
    }
}
impl InvalidOutput {
    /// Creates a new builder-style object to manufacture [`InvalidOutput`](crate::error::InvalidOutput)
    pub fn builder() -> crate::error::invalid_output::Builder {
        crate::error::invalid_output::Builder::default()
    }
}

/// <p>The maximum number of workers concurrently polling for activity tasks has been
/// reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityWorkerLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActivityWorkerLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityWorkerLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActivityWorkerLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActivityWorkerLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActivityWorkerLimitExceeded")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActivityWorkerLimitExceeded {}
/// See [`ActivityWorkerLimitExceeded`](crate::error::ActivityWorkerLimitExceeded)
pub mod activity_worker_limit_exceeded {
    /// A builder for [`ActivityWorkerLimitExceeded`](crate::error::ActivityWorkerLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityWorkerLimitExceeded`](crate::error::ActivityWorkerLimitExceeded)
        pub fn build(self) -> crate::error::ActivityWorkerLimitExceeded {
            crate::error::ActivityWorkerLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ActivityWorkerLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ActivityWorkerLimitExceeded`](crate::error::ActivityWorkerLimitExceeded)
    pub fn builder() -> crate::error::activity_worker_limit_exceeded::Builder {
        crate::error::activity_worker_limit_exceeded::Builder::default()
    }
}

/// <p>The specified activity does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActivityDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActivityDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActivityDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActivityDoesNotExist")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActivityDoesNotExist {}
/// See [`ActivityDoesNotExist`](crate::error::ActivityDoesNotExist)
pub mod activity_does_not_exist {
    /// A builder for [`ActivityDoesNotExist`](crate::error::ActivityDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityDoesNotExist`](crate::error::ActivityDoesNotExist)
        pub fn build(self) -> crate::error::ActivityDoesNotExist {
            crate::error::ActivityDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl ActivityDoesNotExist {
    /// Creates a new builder-style object to manufacture [`ActivityDoesNotExist`](crate::error::ActivityDoesNotExist)
    pub fn builder() -> crate::error::activity_does_not_exist::Builder {
        crate::error::activity_does_not_exist::Builder::default()
    }
}

/// <p>The maximum number of state machines has been reached. Existing state machines must be
/// deleted before a new state machine can be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StateMachineLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StateMachineLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StateMachineLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StateMachineLimitExceeded")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for StateMachineLimitExceeded {}
/// See [`StateMachineLimitExceeded`](crate::error::StateMachineLimitExceeded)
pub mod state_machine_limit_exceeded {
    /// A builder for [`StateMachineLimitExceeded`](crate::error::StateMachineLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineLimitExceeded`](crate::error::StateMachineLimitExceeded)
        pub fn build(self) -> crate::error::StateMachineLimitExceeded {
            crate::error::StateMachineLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl StateMachineLimitExceeded {
    /// Creates a new builder-style object to manufacture [`StateMachineLimitExceeded`](crate::error::StateMachineLimitExceeded)
    pub fn builder() -> crate::error::state_machine_limit_exceeded::Builder {
        crate::error::state_machine_limit_exceeded::Builder::default()
    }
}

/// <p>A state machine with the same name but a different definition or role ARN already
/// exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StateMachineAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StateMachineAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StateMachineAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StateMachineAlreadyExists")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for StateMachineAlreadyExists {}
/// See [`StateMachineAlreadyExists`](crate::error::StateMachineAlreadyExists)
pub mod state_machine_already_exists {
    /// A builder for [`StateMachineAlreadyExists`](crate::error::StateMachineAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineAlreadyExists`](crate::error::StateMachineAlreadyExists)
        pub fn build(self) -> crate::error::StateMachineAlreadyExists {
            crate::error::StateMachineAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl StateMachineAlreadyExists {
    /// Creates a new builder-style object to manufacture [`StateMachineAlreadyExists`](crate::error::StateMachineAlreadyExists)
    pub fn builder() -> crate::error::state_machine_already_exists::Builder {
        crate::error::state_machine_already_exists::Builder::default()
    }
}

/// <p>The maximum number of activities has been reached. Existing activities must be deleted
/// before a new activity can be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActivityLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActivityLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActivityLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActivityLimitExceeded")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActivityLimitExceeded {}
/// See [`ActivityLimitExceeded`](crate::error::ActivityLimitExceeded)
pub mod activity_limit_exceeded {
    /// A builder for [`ActivityLimitExceeded`](crate::error::ActivityLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityLimitExceeded`](crate::error::ActivityLimitExceeded)
        pub fn build(self) -> crate::error::ActivityLimitExceeded {
            crate::error::ActivityLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ActivityLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ActivityLimitExceeded`](crate::error::ActivityLimitExceeded)
    pub fn builder() -> crate::error::activity_limit_exceeded::Builder {
        crate::error::activity_limit_exceeded::Builder::default()
    }
}
