// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStateMachineOutput {
    /// <p>The date and time the state machine was updated.</p>
    pub update_date: std::option::Option<aws_smithy_types::Instant>,
}
impl UpdateStateMachineOutput {
    /// <p>The date and time the state machine was updated.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateStateMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStateMachineOutput");
        formatter.field("update_date", &self.update_date);
        formatter.finish()
    }
}
/// See [`UpdateStateMachineOutput`](crate::output::UpdateStateMachineOutput)
pub mod update_state_machine_output {
    /// A builder for [`UpdateStateMachineOutput`](crate::output::UpdateStateMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The date and time the state machine was updated.</p>
        pub fn update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>The date and time the state machine was updated.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStateMachineOutput`](crate::output::UpdateStateMachineOutput)
        pub fn build(self) -> crate::output::UpdateStateMachineOutput {
            crate::output::UpdateStateMachineOutput {
                update_date: self.update_date,
            }
        }
    }
}
impl UpdateStateMachineOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStateMachineOutput`](crate::output::UpdateStateMachineOutput)
    pub fn builder() -> crate::output::update_state_machine_output::Builder {
        crate::output::update_state_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopExecutionOutput {
    /// <p>The date the execution is stopped.</p>
    pub stop_date: std::option::Option<aws_smithy_types::Instant>,
}
impl StopExecutionOutput {
    /// <p>The date the execution is stopped.</p>
    pub fn stop_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_date.as_ref()
    }
}
impl std::fmt::Debug for StopExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopExecutionOutput");
        formatter.field("stop_date", &self.stop_date);
        formatter.finish()
    }
}
/// See [`StopExecutionOutput`](crate::output::StopExecutionOutput)
pub mod stop_execution_output {
    /// A builder for [`StopExecutionOutput`](crate::output::StopExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stop_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The date the execution is stopped.</p>
        pub fn stop_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_date = Some(input);
            self
        }
        /// <p>The date the execution is stopped.</p>
        pub fn set_stop_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StopExecutionOutput`](crate::output::StopExecutionOutput)
        pub fn build(self) -> crate::output::StopExecutionOutput {
            crate::output::StopExecutionOutput {
                stop_date: self.stop_date,
            }
        }
    }
}
impl StopExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StopExecutionOutput`](crate::output::StopExecutionOutput)
    pub fn builder() -> crate::output::stop_execution_output::Builder {
        crate::output::stop_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSyncExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the execution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date the execution is started.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If the execution has already ended, the date the execution stopped.</p>
    pub stop_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the execution.</p>
    pub status: std::option::Option<crate::model::SyncExecutionStatus>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
    /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Provides details about execution input or output.</p>
    pub input_details: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
    /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// <note>
    /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
    /// null.</p>
    /// </note>
    pub output: std::option::Option<std::string::String>,
    /// <p>Provides details about execution input or output.</p>
    pub output_details: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
    /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
    pub trace_header: std::option::Option<std::string::String>,
    /// <p>An object that describes workflow billing details, including billed duration
    /// and memory use.</p>
    pub billing_details: std::option::Option<crate::model::BillingDetails>,
}
impl StartSyncExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the execution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date the execution is started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_date.as_ref()
    }
    /// <p>If the execution has already ended, the date the execution stopped.</p>
    pub fn stop_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_date.as_ref()
    }
    /// <p>The current status of the execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SyncExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
    /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Provides details about execution input or output.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchEventsExecutionDataDetails> {
        self.input_details.as_ref()
    }
    /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// <note>
    /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
    /// null.</p>
    /// </note>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Provides details about execution input or output.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchEventsExecutionDataDetails> {
        self.output_details.as_ref()
    }
    /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
    pub fn trace_header(&self) -> std::option::Option<&str> {
        self.trace_header.as_deref()
    }
    /// <p>An object that describes workflow billing details, including billed duration
    /// and memory use.</p>
    pub fn billing_details(&self) -> std::option::Option<&crate::model::BillingDetails> {
        self.billing_details.as_ref()
    }
}
impl std::fmt::Debug for StartSyncExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSyncExecutionOutput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("start_date", &self.start_date);
        formatter.field("stop_date", &self.stop_date);
        formatter.field("status", &self.status);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.field("trace_header", &self.trace_header);
        formatter.field("billing_details", &self.billing_details);
        formatter.finish()
    }
}
/// See [`StartSyncExecutionOutput`](crate::output::StartSyncExecutionOutput)
pub mod start_sync_execution_output {
    /// A builder for [`StartSyncExecutionOutput`](crate::output::StartSyncExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::SyncExecutionStatus>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        pub(crate) trace_header: std::option::Option<std::string::String>,
        pub(crate) billing_details: std::option::Option<crate::model::BillingDetails>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the execution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>If the execution has already ended, the date the execution stopped.</p>
        pub fn stop_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_date = Some(input);
            self
        }
        /// <p>If the execution has already ended, the date the execution stopped.</p>
        pub fn set_stop_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_date = input;
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn status(mut self, input: crate::model::SyncExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SyncExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn input_details(
            mut self,
            input: crate::model::CloudWatchEventsExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        /// <note>
        /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
        /// null.</p>
        /// </note>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        /// <note>
        /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
        /// null.</p>
        /// </note>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn output_details(
            mut self,
            input: crate::model::CloudWatchEventsExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_header = Some(input.into());
            self
        }
        /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_header = input;
            self
        }
        /// <p>An object that describes workflow billing details, including billed duration
        /// and memory use.</p>
        pub fn billing_details(mut self, input: crate::model::BillingDetails) -> Self {
            self.billing_details = Some(input);
            self
        }
        /// <p>An object that describes workflow billing details, including billed duration
        /// and memory use.</p>
        pub fn set_billing_details(
            mut self,
            input: std::option::Option<crate::model::BillingDetails>,
        ) -> Self {
            self.billing_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSyncExecutionOutput`](crate::output::StartSyncExecutionOutput)
        pub fn build(self) -> crate::output::StartSyncExecutionOutput {
            crate::output::StartSyncExecutionOutput {
                execution_arn: self.execution_arn,
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                start_date: self.start_date,
                stop_date: self.stop_date,
                status: self.status,
                error: self.error,
                cause: self.cause,
                input: self.input,
                input_details: self.input_details,
                output: self.output,
                output_details: self.output_details,
                trace_header: self.trace_header,
                billing_details: self.billing_details,
            }
        }
    }
}
impl StartSyncExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartSyncExecutionOutput`](crate::output::StartSyncExecutionOutput)
    pub fn builder() -> crate::output::start_sync_execution_output::Builder {
        crate::output::start_sync_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The date the execution is started.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
}
impl StartExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The date the execution is started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_date.as_ref()
    }
}
impl std::fmt::Debug for StartExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExecutionOutput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("start_date", &self.start_date);
        formatter.finish()
    }
}
/// See [`StartExecutionOutput`](crate::output::StartExecutionOutput)
pub mod start_execution_output {
    /// A builder for [`StartExecutionOutput`](crate::output::StartExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExecutionOutput`](crate::output::StartExecutionOutput)
        pub fn build(self) -> crate::output::StartExecutionOutput {
            crate::output::StartExecutionOutput {
                execution_arn: self.execution_arn,
                start_date: self.start_date,
            }
        }
    }
}
impl StartExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartExecutionOutput`](crate::output::StartExecutionOutput)
    pub fn builder() -> crate::output::start_execution_output::Builder {
        crate::output::start_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskSuccessOutput {}
impl std::fmt::Debug for SendTaskSuccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskSuccessOutput");
        formatter.finish()
    }
}
/// See [`SendTaskSuccessOutput`](crate::output::SendTaskSuccessOutput)
pub mod send_task_success_output {
    /// A builder for [`SendTaskSuccessOutput`](crate::output::SendTaskSuccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendTaskSuccessOutput`](crate::output::SendTaskSuccessOutput)
        pub fn build(self) -> crate::output::SendTaskSuccessOutput {
            crate::output::SendTaskSuccessOutput {}
        }
    }
}
impl SendTaskSuccessOutput {
    /// Creates a new builder-style object to manufacture [`SendTaskSuccessOutput`](crate::output::SendTaskSuccessOutput)
    pub fn builder() -> crate::output::send_task_success_output::Builder {
        crate::output::send_task_success_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskHeartbeatOutput {}
impl std::fmt::Debug for SendTaskHeartbeatOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskHeartbeatOutput");
        formatter.finish()
    }
}
/// See [`SendTaskHeartbeatOutput`](crate::output::SendTaskHeartbeatOutput)
pub mod send_task_heartbeat_output {
    /// A builder for [`SendTaskHeartbeatOutput`](crate::output::SendTaskHeartbeatOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendTaskHeartbeatOutput`](crate::output::SendTaskHeartbeatOutput)
        pub fn build(self) -> crate::output::SendTaskHeartbeatOutput {
            crate::output::SendTaskHeartbeatOutput {}
        }
    }
}
impl SendTaskHeartbeatOutput {
    /// Creates a new builder-style object to manufacture [`SendTaskHeartbeatOutput`](crate::output::SendTaskHeartbeatOutput)
    pub fn builder() -> crate::output::send_task_heartbeat_output::Builder {
        crate::output::send_task_heartbeat_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskFailureOutput {}
impl std::fmt::Debug for SendTaskFailureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskFailureOutput");
        formatter.finish()
    }
}
/// See [`SendTaskFailureOutput`](crate::output::SendTaskFailureOutput)
pub mod send_task_failure_output {
    /// A builder for [`SendTaskFailureOutput`](crate::output::SendTaskFailureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendTaskFailureOutput`](crate::output::SendTaskFailureOutput)
        pub fn build(self) -> crate::output::SendTaskFailureOutput {
            crate::output::SendTaskFailureOutput {}
        }
    }
}
impl SendTaskFailureOutput {
    /// Creates a new builder-style object to manufacture [`SendTaskFailureOutput`](crate::output::SendTaskFailureOutput)
    pub fn builder() -> crate::output::send_task_failure_output::Builder {
        crate::output::send_task_failure_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>An array of tags associated with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>An array of tags associated with the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags associated with the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStateMachinesOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub state_machines: std::option::Option<std::vec::Vec<crate::model::StateMachineListItem>>,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStateMachinesOutput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn state_machines(&self) -> std::option::Option<&[crate::model::StateMachineListItem]> {
        self.state_machines.as_deref()
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStateMachinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStateMachinesOutput");
        formatter.field("state_machines", &self.state_machines);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStateMachinesOutput`](crate::output::ListStateMachinesOutput)
pub mod list_state_machines_output {
    /// A builder for [`ListStateMachinesOutput`](crate::output::ListStateMachinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machines:
            std::option::Option<std::vec::Vec<crate::model::StateMachineListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `state_machines`.
        ///
        /// To override the contents of this collection use [`set_state_machines`](Self::set_state_machines).
        ///
        pub fn state_machines(
            mut self,
            input: impl Into<crate::model::StateMachineListItem>,
        ) -> Self {
            let mut v = self.state_machines.unwrap_or_default();
            v.push(input.into());
            self.state_machines = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_state_machines(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StateMachineListItem>>,
        ) -> Self {
            self.state_machines = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStateMachinesOutput`](crate::output::ListStateMachinesOutput)
        pub fn build(self) -> crate::output::ListStateMachinesOutput {
            crate::output::ListStateMachinesOutput {
                state_machines: self.state_machines,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStateMachinesOutput {
    /// Creates a new builder-style object to manufacture [`ListStateMachinesOutput`](crate::output::ListStateMachinesOutput)
    pub fn builder() -> crate::output::list_state_machines_output::Builder {
        crate::output::list_state_machines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExecutionsOutput {
    /// <p>The list of matching executions.</p>
    pub executions: std::option::Option<std::vec::Vec<crate::model::ExecutionListItem>>,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExecutionsOutput {
    /// <p>The list of matching executions.</p>
    pub fn executions(&self) -> std::option::Option<&[crate::model::ExecutionListItem]> {
        self.executions.as_deref()
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExecutionsOutput");
        formatter.field("executions", &self.executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
pub mod list_executions_output {
    /// A builder for [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) executions: std::option::Option<std::vec::Vec<crate::model::ExecutionListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `executions`.
        ///
        /// To override the contents of this collection use [`set_executions`](Self::set_executions).
        ///
        /// <p>The list of matching executions.</p>
        pub fn executions(mut self, input: impl Into<crate::model::ExecutionListItem>) -> Self {
            let mut v = self.executions.unwrap_or_default();
            v.push(input.into());
            self.executions = Some(v);
            self
        }
        /// <p>The list of matching executions.</p>
        pub fn set_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionListItem>>,
        ) -> Self {
            self.executions = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
        pub fn build(self) -> crate::output::ListExecutionsOutput {
            crate::output::ListExecutionsOutput {
                executions: self.executions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    pub fn builder() -> crate::output::list_executions_output::Builder {
        crate::output::list_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActivitiesOutput {
    /// <p>The list of activities.</p>
    pub activities: std::option::Option<std::vec::Vec<crate::model::ActivityListItem>>,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActivitiesOutput {
    /// <p>The list of activities.</p>
    pub fn activities(&self) -> std::option::Option<&[crate::model::ActivityListItem]> {
        self.activities.as_deref()
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActivitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActivitiesOutput");
        formatter.field("activities", &self.activities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListActivitiesOutput`](crate::output::ListActivitiesOutput)
pub mod list_activities_output {
    /// A builder for [`ListActivitiesOutput`](crate::output::ListActivitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activities: std::option::Option<std::vec::Vec<crate::model::ActivityListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `activities`.
        ///
        /// To override the contents of this collection use [`set_activities`](Self::set_activities).
        ///
        /// <p>The list of activities.</p>
        pub fn activities(mut self, input: impl Into<crate::model::ActivityListItem>) -> Self {
            let mut v = self.activities.unwrap_or_default();
            v.push(input.into());
            self.activities = Some(v);
            self
        }
        /// <p>The list of activities.</p>
        pub fn set_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActivityListItem>>,
        ) -> Self {
            self.activities = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActivitiesOutput`](crate::output::ListActivitiesOutput)
        pub fn build(self) -> crate::output::ListActivitiesOutput {
            crate::output::ListActivitiesOutput {
                activities: self.activities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListActivitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListActivitiesOutput`](crate::output::ListActivitiesOutput)
    pub fn builder() -> crate::output::list_activities_output::Builder {
        crate::output::list_activities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExecutionHistoryOutput {
    /// <p>The list of events that occurred in the execution.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::HistoryEvent>>,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetExecutionHistoryOutput {
    /// <p>The list of events that occurred in the execution.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::HistoryEvent]> {
        self.events.as_deref()
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetExecutionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExecutionHistoryOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetExecutionHistoryOutput`](crate::output::GetExecutionHistoryOutput)
pub mod get_execution_history_output {
    /// A builder for [`GetExecutionHistoryOutput`](crate::output::GetExecutionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::HistoryEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The list of events that occurred in the execution.</p>
        pub fn events(mut self, input: impl Into<crate::model::HistoryEvent>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The list of events that occurred in the execution.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistoryEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExecutionHistoryOutput`](crate::output::GetExecutionHistoryOutput)
        pub fn build(self) -> crate::output::GetExecutionHistoryOutput {
            crate::output::GetExecutionHistoryOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl GetExecutionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetExecutionHistoryOutput`](crate::output::GetExecutionHistoryOutput)
    pub fn builder() -> crate::output::get_execution_history_output::Builder {
        crate::output::get_execution_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetActivityTaskOutput {
    /// <p>A token that identifies the scheduled task. This token must be copied and included in
    /// subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or
    /// <a>SendTaskFailure</a> in order to report the progress or completion of the
    /// task.</p>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
}
impl GetActivityTaskOutput {
    /// <p>A token that identifies the scheduled task. This token must be copied and included in
    /// subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or
    /// <a>SendTaskFailure</a> in order to report the progress or completion of the
    /// task.</p>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
}
impl std::fmt::Debug for GetActivityTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetActivityTaskOutput");
        formatter.field("task_token", &self.task_token);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetActivityTaskOutput`](crate::output::GetActivityTaskOutput)
pub mod get_activity_task_output {
    /// A builder for [`GetActivityTaskOutput`](crate::output::GetActivityTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token that identifies the scheduled task. This token must be copied and included in
        /// subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or
        /// <a>SendTaskFailure</a> in order to report the progress or completion of the
        /// task.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>A token that identifies the scheduled task. This token must be copied and included in
        /// subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or
        /// <a>SendTaskFailure</a> in order to report the progress or completion of the
        /// task.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// Consumes the builder and constructs a [`GetActivityTaskOutput`](crate::output::GetActivityTaskOutput)
        pub fn build(self) -> crate::output::GetActivityTaskOutput {
            crate::output::GetActivityTaskOutput {
                task_token: self.task_token,
                input: self.input,
            }
        }
    }
}
impl GetActivityTaskOutput {
    /// Creates a new builder-style object to manufacture [`GetActivityTaskOutput`](crate::output::GetActivityTaskOutput)
    pub fn builder() -> crate::output::get_activity_task_output::Builder {
        crate::output::get_activity_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStateMachineForExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the state machine associated with the execution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The date and time the state machine associated with an execution was updated. For a newly
    /// created state machine, this is the creation date.</p>
    pub update_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
}
impl DescribeStateMachineForExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the state machine associated with the execution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The date and time the state machine associated with an execution was updated. For a newly
    /// created state machine, this is the creation date.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_date.as_ref()
    }
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub fn tracing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TracingConfiguration> {
        self.tracing_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeStateMachineForExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStateMachineForExecutionOutput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("definition", &"*** Sensitive Data Redacted ***");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("update_date", &self.update_date);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("tracing_configuration", &self.tracing_configuration);
        formatter.finish()
    }
}
/// See [`DescribeStateMachineForExecutionOutput`](crate::output::DescribeStateMachineForExecutionOutput)
pub mod describe_state_machine_for_execution_output {
    /// A builder for [`DescribeStateMachineForExecutionOutput`](crate::output::DescribeStateMachineForExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the state machine associated with the execution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state machine associated with the execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The date and time the state machine associated with an execution was updated. For a newly
        /// created state machine, this is the creation date.</p>
        pub fn update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>The date and time the state machine associated with an execution was updated. For a newly
        /// created state machine, this is the creation date.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.tracing_configuration = Some(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.tracing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStateMachineForExecutionOutput`](crate::output::DescribeStateMachineForExecutionOutput)
        pub fn build(self) -> crate::output::DescribeStateMachineForExecutionOutput {
            crate::output::DescribeStateMachineForExecutionOutput {
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                definition: self.definition,
                role_arn: self.role_arn,
                update_date: self.update_date,
                logging_configuration: self.logging_configuration,
                tracing_configuration: self.tracing_configuration,
            }
        }
    }
}
impl DescribeStateMachineForExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineForExecutionOutput`](crate::output::DescribeStateMachineForExecutionOutput)
    pub fn builder() -> crate::output::describe_state_machine_for_execution_output::Builder {
        crate::output::describe_state_machine_for_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStateMachineOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the state machine.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the state machine.</p>
    pub status: std::option::Option<crate::model::StateMachineStatus>,
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
    /// maintains security by granting Step Functions access to AWS resources.)</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The <code>type</code> of the state machine (<code>STANDARD</code> or
    /// <code>EXPRESS</code>).</p>
    pub r#type: std::option::Option<crate::model::StateMachineType>,
    /// <p>The date the state machine is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
}
impl DescribeStateMachineOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the state machine.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the state machine.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StateMachineStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
    /// maintains security by granting Step Functions access to AWS resources.)</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The <code>type</code> of the state machine (<code>STANDARD</code> or
    /// <code>EXPRESS</code>).</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StateMachineType> {
        self.r#type.as_ref()
    }
    /// <p>The date the state machine is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub fn tracing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TracingConfiguration> {
        self.tracing_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeStateMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStateMachineOutput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("definition", &"*** Sensitive Data Redacted ***");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("tracing_configuration", &self.tracing_configuration);
        formatter.finish()
    }
}
/// See [`DescribeStateMachineOutput`](crate::output::DescribeStateMachineOutput)
pub mod describe_state_machine_output {
    /// A builder for [`DescribeStateMachineOutput`](crate::output::DescribeStateMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StateMachineStatus>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::StateMachineType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the state machine.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state machine.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the state machine.</p>
        pub fn status(mut self, input: crate::model::StateMachineStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the state machine.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StateMachineStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
        /// maintains security by granting Step Functions access to AWS resources.)</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role
        /// maintains security by granting Step Functions access to AWS resources.)</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The <code>type</code> of the state machine (<code>STANDARD</code> or
        /// <code>EXPRESS</code>).</p>
        pub fn r#type(mut self, input: crate::model::StateMachineType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The <code>type</code> of the state machine (<code>STANDARD</code> or
        /// <code>EXPRESS</code>).</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StateMachineType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.tracing_configuration = Some(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.tracing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStateMachineOutput`](crate::output::DescribeStateMachineOutput)
        pub fn build(self) -> crate::output::DescribeStateMachineOutput {
            crate::output::DescribeStateMachineOutput {
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                status: self.status,
                definition: self.definition,
                role_arn: self.role_arn,
                r#type: self.r#type,
                creation_date: self.creation_date,
                logging_configuration: self.logging_configuration,
                tracing_configuration: self.tracing_configuration,
            }
        }
    }
}
impl DescribeStateMachineOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineOutput`](crate::output::DescribeStateMachineOutput)
    pub fn builder() -> crate::output::describe_state_machine_output::Builder {
        crate::output::describe_state_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the executed stated machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the execution.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the execution.</p>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The date the execution is started.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If the execution has already ended, the date the execution stopped.</p>
    pub stop_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Provides details about execution input or output.</p>
    pub input_details: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
    /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// <note>
    /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
    /// null.</p>
    /// </note>
    pub output: std::option::Option<std::string::String>,
    /// <p>Provides details about execution input or output.</p>
    pub output_details: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
    /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
    pub trace_header: std::option::Option<std::string::String>,
}
impl DescribeExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the executed stated machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the execution.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The date the execution is started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_date.as_ref()
    }
    /// <p>If the execution has already ended, the date the execution stopped.</p>
    pub fn stop_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_date.as_ref()
    }
    /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Provides details about execution input or output.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchEventsExecutionDataDetails> {
        self.input_details.as_ref()
    }
    /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    /// <note>
    /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
    /// null.</p>
    /// </note>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Provides details about execution input or output.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchEventsExecutionDataDetails> {
        self.output_details.as_ref()
    }
    /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
    pub fn trace_header(&self) -> std::option::Option<&str> {
        self.trace_header.as_deref()
    }
}
impl std::fmt::Debug for DescribeExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExecutionOutput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("start_date", &self.start_date);
        formatter.field("stop_date", &self.stop_date);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.field("trace_header", &self.trace_header);
        formatter.finish()
    }
}
/// See [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
pub mod describe_execution_output {
    /// A builder for [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        pub(crate) trace_header: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the executed stated machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the executed stated machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the execution.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date the execution is started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>If the execution has already ended, the date the execution stopped.</p>
        pub fn stop_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_date = Some(input);
            self
        }
        /// <p>If the execution has already ended, the date the execution stopped.</p>
        pub fn set_stop_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_date = input;
            self
        }
        /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn input_details(
            mut self,
            input: crate::model::CloudWatchEventsExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        /// <note>
        /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
        /// null.</p>
        /// </note>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        /// <note>
        /// <p>This field is set only if the execution succeeds. If the execution fails, this field is
        /// null.</p>
        /// </note>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn output_details(
            mut self,
            input: crate::model::CloudWatchEventsExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Provides details about execution input or output.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEventsExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_header = Some(input.into());
            self
        }
        /// <p>The AWS X-Ray trace header that was passed to the execution.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_header = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
        pub fn build(self) -> crate::output::DescribeExecutionOutput {
            crate::output::DescribeExecutionOutput {
                execution_arn: self.execution_arn,
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                status: self.status,
                start_date: self.start_date,
                stop_date: self.stop_date,
                input: self.input,
                input_details: self.input_details,
                output: self.output,
                output_details: self.output_details,
                trace_header: self.trace_header,
            }
        }
    }
}
impl DescribeExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    pub fn builder() -> crate::output::describe_execution_output::Builder {
        crate::output::describe_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivityOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
    pub activity_arn: std::option::Option<std::string::String>,
    /// <p>The name of the activity.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date the activity is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeActivityOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
    /// <p>The name of the activity.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date the activity is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeActivityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivityOutput");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.field("name", &self.name);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`DescribeActivityOutput`](crate::output::DescribeActivityOutput)
pub mod describe_activity_output {
    /// A builder for [`DescribeActivityOutput`](crate::output::DescribeActivityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// <p>The name of the activity.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the activity.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivityOutput`](crate::output::DescribeActivityOutput)
        pub fn build(self) -> crate::output::DescribeActivityOutput {
            crate::output::DescribeActivityOutput {
                activity_arn: self.activity_arn,
                name: self.name,
                creation_date: self.creation_date,
            }
        }
    }
}
impl DescribeActivityOutput {
    /// Creates a new builder-style object to manufacture [`DescribeActivityOutput`](crate::output::DescribeActivityOutput)
    pub fn builder() -> crate::output::describe_activity_output::Builder {
        crate::output::describe_activity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStateMachineOutput {}
impl std::fmt::Debug for DeleteStateMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStateMachineOutput");
        formatter.finish()
    }
}
/// See [`DeleteStateMachineOutput`](crate::output::DeleteStateMachineOutput)
pub mod delete_state_machine_output {
    /// A builder for [`DeleteStateMachineOutput`](crate::output::DeleteStateMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStateMachineOutput`](crate::output::DeleteStateMachineOutput)
        pub fn build(self) -> crate::output::DeleteStateMachineOutput {
            crate::output::DeleteStateMachineOutput {}
        }
    }
}
impl DeleteStateMachineOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStateMachineOutput`](crate::output::DeleteStateMachineOutput)
    pub fn builder() -> crate::output::delete_state_machine_output::Builder {
        crate::output::delete_state_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteActivityOutput {}
impl std::fmt::Debug for DeleteActivityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteActivityOutput");
        formatter.finish()
    }
}
/// See [`DeleteActivityOutput`](crate::output::DeleteActivityOutput)
pub mod delete_activity_output {
    /// A builder for [`DeleteActivityOutput`](crate::output::DeleteActivityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteActivityOutput`](crate::output::DeleteActivityOutput)
        pub fn build(self) -> crate::output::DeleteActivityOutput {
            crate::output::DeleteActivityOutput {}
        }
    }
}
impl DeleteActivityOutput {
    /// Creates a new builder-style object to manufacture [`DeleteActivityOutput`](crate::output::DeleteActivityOutput)
    pub fn builder() -> crate::output::delete_activity_output::Builder {
        crate::output::delete_activity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStateMachineOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The date the state machine is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateStateMachineOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The date the state machine is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CreateStateMachineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStateMachineOutput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CreateStateMachineOutput`](crate::output::CreateStateMachineOutput)
pub mod create_state_machine_output {
    /// A builder for [`CreateStateMachineOutput`](crate::output::CreateStateMachineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStateMachineOutput`](crate::output::CreateStateMachineOutput)
        pub fn build(self) -> crate::output::CreateStateMachineOutput {
            crate::output::CreateStateMachineOutput {
                state_machine_arn: self.state_machine_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CreateStateMachineOutput {
    /// Creates a new builder-style object to manufacture [`CreateStateMachineOutput`](crate::output::CreateStateMachineOutput)
    pub fn builder() -> crate::output::create_state_machine_output::Builder {
        crate::output::create_state_machine_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateActivityOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the created activity.</p>
    pub activity_arn: std::option::Option<std::string::String>,
    /// <p>The date the activity is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateActivityOutput {
    /// <p>The Amazon Resource Name (ARN) that identifies the created activity.</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
    /// <p>The date the activity is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CreateActivityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateActivityOutput");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CreateActivityOutput`](crate::output::CreateActivityOutput)
pub mod create_activity_output {
    /// A builder for [`CreateActivityOutput`](crate::output::CreateActivityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the created activity.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the created activity.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActivityOutput`](crate::output::CreateActivityOutput)
        pub fn build(self) -> crate::output::CreateActivityOutput {
            crate::output::CreateActivityOutput {
                activity_arn: self.activity_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CreateActivityOutput {
    /// Creates a new builder-style object to manufacture [`CreateActivityOutput`](crate::output::CreateActivityOutput)
    pub fn builder() -> crate::output::create_activity_output::Builder {
        crate::output::create_activity_output::Builder::default()
    }
}
