// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_activity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateActivityOutput, crate::error::CreateActivityError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateActivityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateActivityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActivityLimitExceeded" => crate::error::CreateActivityError {
            meta: generic,
            kind: crate::error::CreateActivityErrorKind::ActivityLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::activity_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_activity_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidName" => crate::error::CreateActivityError {
            meta: generic,
            kind: crate::error::CreateActivityErrorKind::InvalidName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_name::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_name_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateActivityError {
            meta: generic,
            kind: crate::error::CreateActivityErrorKind::TooManyTags({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateActivityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_activity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateActivityOutput, crate::error::CreateActivityError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_activity_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_activity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateActivityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_state_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStateMachineOutput,
    crate::error::CreateStateMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateStateMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateStateMachineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDefinition" => {
            crate::error::CreateStateMachineError {
                meta: generic,
                kind: crate::error::CreateStateMachineErrorKind::InvalidDefinition({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_definition::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_definition_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidLoggingConfiguration" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::InvalidLoggingConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_logging_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_logging_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidName" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::InvalidName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_name::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_name_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTracingConfiguration" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::InvalidTracingConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tracing_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tracing_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineAlreadyExists" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::StateMachineAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDeleting" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::StateMachineDeleting({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_deleting::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_deleting_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineLimitExceeded" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::StateMachineLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineTypeNotSupported" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::StateMachineTypeNotSupported({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::state_machine_type_not_supported::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_type_not_supported_json_err(response.body().as_ref(), output).map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTags" => crate::error::CreateStateMachineError {
            meta: generic,
            kind: crate::error::CreateStateMachineErrorKind::TooManyTags({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateStateMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_state_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateStateMachineOutput,
    crate::error::CreateStateMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_state_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_state_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateStateMachineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_activity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteActivityOutput, crate::error::DeleteActivityError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteActivityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteActivityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::DeleteActivityError {
            meta: generic,
            kind: crate::error::DeleteActivityErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteActivityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_activity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteActivityOutput, crate::error::DeleteActivityError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_activity_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_state_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStateMachineOutput,
    crate::error::DeleteStateMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStateMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteStateMachineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::DeleteStateMachineError {
            meta: generic,
            kind: crate::error::DeleteStateMachineErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteStateMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_state_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStateMachineOutput,
    crate::error::DeleteStateMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_state_machine_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_activity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeActivityOutput, crate::error::DescribeActivityError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeActivityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeActivityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActivityDoesNotExist" => crate::error::DescribeActivityError {
            meta: generic,
            kind: crate::error::DescribeActivityErrorKind::ActivityDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::activity_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_activity_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::DescribeActivityError {
            meta: generic,
            kind: crate::error::DescribeActivityErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeActivityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeActivityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_activity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeActivityOutput, crate::error::DescribeActivityError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_activity_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_activity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeActivityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeExecutionOutput, crate::error::DescribeExecutionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExecutionDoesNotExist" => crate::error::DescribeExecutionError {
            meta: generic,
            kind: crate::error::DescribeExecutionErrorKind::ExecutionDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::DescribeExecutionError {
            meta: generic,
            kind: crate::error::DescribeExecutionErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeExecutionOutput, crate::error::DescribeExecutionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_state_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStateMachineOutput,
    crate::error::DescribeStateMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStateMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeStateMachineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::DescribeStateMachineError {
            meta: generic,
            kind: crate::error::DescribeStateMachineErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDoesNotExist" => crate::error::DescribeStateMachineError {
            meta: generic,
            kind: crate::error::DescribeStateMachineErrorKind::StateMachineDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStateMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_state_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStateMachineOutput,
    crate::error::DescribeStateMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_state_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_state_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStateMachineError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_state_machine_for_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStateMachineForExecutionOutput,
    crate::error::DescribeStateMachineForExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStateMachineForExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeStateMachineForExecutionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExecutionDoesNotExist" => crate::error::DescribeStateMachineForExecutionError {
            meta: generic,
            kind: crate::error::DescribeStateMachineForExecutionErrorKind::ExecutionDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStateMachineForExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::DescribeStateMachineForExecutionError {
            meta: generic,
            kind: crate::error::DescribeStateMachineForExecutionErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeStateMachineForExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStateMachineForExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_state_machine_for_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeStateMachineForExecutionOutput,
    crate::error::DescribeStateMachineForExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_state_machine_for_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_state_machine_for_execution(response.body().as_ref(), output).map_err(crate::error::DescribeStateMachineForExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_activity_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActivityTaskOutput, crate::error::GetActivityTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetActivityTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetActivityTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ActivityDoesNotExist" => crate::error::GetActivityTaskError {
            meta: generic,
            kind: crate::error::GetActivityTaskErrorKind::ActivityDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::activity_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_activity_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::GetActivityTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ActivityWorkerLimitExceeded" => crate::error::GetActivityTaskError {
            meta: generic,
            kind: crate::error::GetActivityTaskErrorKind::ActivityWorkerLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::activity_worker_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_activity_worker_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::GetActivityTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::GetActivityTaskError {
            meta: generic,
            kind: crate::error::GetActivityTaskErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetActivityTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetActivityTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_activity_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActivityTaskOutput, crate::error::GetActivityTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_activity_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_activity_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetActivityTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_execution_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetExecutionHistoryOutput,
    crate::error::GetExecutionHistoryError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetExecutionHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetExecutionHistoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExecutionDoesNotExist" => crate::error::GetExecutionHistoryError {
            meta: generic,
            kind: crate::error::GetExecutionHistoryErrorKind::ExecutionDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::GetExecutionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::GetExecutionHistoryError {
            meta: generic,
            kind: crate::error::GetExecutionHistoryErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetExecutionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidToken" => crate::error::GetExecutionHistoryError {
            meta: generic,
            kind: crate::error::GetExecutionHistoryErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetExecutionHistoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetExecutionHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_execution_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetExecutionHistoryOutput,
    crate::error::GetExecutionHistoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_execution_history_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_execution_history(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetExecutionHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_activities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActivitiesOutput, crate::error::ListActivitiesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListActivitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListActivitiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidToken" => crate::error::ListActivitiesError {
            meta: generic,
            kind: crate::error::ListActivitiesErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListActivitiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListActivitiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_activities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListActivitiesOutput, crate::error::ListActivitiesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_activities_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_activities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListActivitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_executions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExecutionsOutput, crate::error::ListExecutionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListExecutionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListExecutionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::ListExecutionsError {
            meta: generic,
            kind: crate::error::ListExecutionsErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidToken" => crate::error::ListExecutionsError {
            meta: generic,
            kind: crate::error::ListExecutionsErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDoesNotExist" => crate::error::ListExecutionsError {
            meta: generic,
            kind: crate::error::ListExecutionsErrorKind::StateMachineDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::ListExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineTypeNotSupported" => crate::error::ListExecutionsError {
            meta: generic,
            kind: crate::error::ListExecutionsErrorKind::StateMachineTypeNotSupported({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::state_machine_type_not_supported::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_type_not_supported_json_err(response.body().as_ref(), output).map_err(crate::error::ListExecutionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListExecutionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_executions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExecutionsOutput, crate::error::ListExecutionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_executions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_executions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListExecutionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_state_machines_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStateMachinesOutput, crate::error::ListStateMachinesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStateMachinesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListStateMachinesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidToken" => crate::error::ListStateMachinesError {
            meta: generic,
            kind: crate::error::ListStateMachinesErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListStateMachinesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStateMachinesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_state_machines_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStateMachinesOutput, crate::error::ListStateMachinesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_state_machines_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_state_machines(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStateMachinesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_failure_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskFailureOutput, crate::error::SendTaskFailureError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendTaskFailureError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendTaskFailureError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidToken" => crate::error::SendTaskFailureError {
            meta: generic,
            kind: crate::error::SendTaskFailureErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendTaskFailureError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskDoesNotExist" => crate::error::SendTaskFailureError {
            meta: generic,
            kind: crate::error::SendTaskFailureErrorKind::TaskDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::SendTaskFailureError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskTimedOut" => crate::error::SendTaskFailureError {
            meta: generic,
            kind: crate::error::SendTaskFailureErrorKind::TaskTimedOut({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_timed_out::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_task_timed_out_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendTaskFailureError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendTaskFailureError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_failure_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskFailureOutput, crate::error::SendTaskFailureError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_task_failure_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_heartbeat_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskHeartbeatOutput, crate::error::SendTaskHeartbeatError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendTaskHeartbeatError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendTaskHeartbeatError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidToken" => crate::error::SendTaskHeartbeatError {
            meta: generic,
            kind: crate::error::SendTaskHeartbeatErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendTaskHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskDoesNotExist" => crate::error::SendTaskHeartbeatError {
            meta: generic,
            kind: crate::error::SendTaskHeartbeatErrorKind::TaskDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::SendTaskHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskTimedOut" => crate::error::SendTaskHeartbeatError {
            meta: generic,
            kind: crate::error::SendTaskHeartbeatErrorKind::TaskTimedOut({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_timed_out::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_task_timed_out_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendTaskHeartbeatError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendTaskHeartbeatError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_heartbeat_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskHeartbeatOutput, crate::error::SendTaskHeartbeatError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_task_heartbeat_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_success_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskSuccessOutput, crate::error::SendTaskSuccessError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendTaskSuccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendTaskSuccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOutput" => crate::error::SendTaskSuccessError {
            meta: generic,
            kind: crate::error::SendTaskSuccessErrorKind::InvalidOutput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_output::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_invalid_output_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendTaskSuccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidToken" => crate::error::SendTaskSuccessError {
            meta: generic,
            kind: crate::error::SendTaskSuccessErrorKind::InvalidToken({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_token::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_token_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::SendTaskSuccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskDoesNotExist" => crate::error::SendTaskSuccessError {
            meta: generic,
            kind: crate::error::SendTaskSuccessErrorKind::TaskDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::SendTaskSuccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskTimedOut" => crate::error::SendTaskSuccessError {
            meta: generic,
            kind: crate::error::SendTaskSuccessErrorKind::TaskTimedOut({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_timed_out::Builder::default();
                    let _ = response;
                    output =
                        crate::json_deser::deser_structure_crate_error_task_timed_out_json_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendTaskSuccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendTaskSuccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_task_success_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendTaskSuccessOutput, crate::error::SendTaskSuccessError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_task_success_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExecutionOutput, crate::error::StartExecutionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExecutionAlreadyExists" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::ExecutionAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExecutionLimitExceeded" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::ExecutionLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExecutionInput" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::InvalidExecutionInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_execution_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_execution_input_json_err(response.body().as_ref(), output).map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidName" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::InvalidName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_name::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_name_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDeleting" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::StateMachineDeleting({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_deleting::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_deleting_json_err(response.body().as_ref(), output).map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDoesNotExist" => crate::error::StartExecutionError {
            meta: generic,
            kind: crate::error::StartExecutionErrorKind::StateMachineDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::StartExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExecutionOutput, crate::error::StartExecutionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_sync_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSyncExecutionOutput,
    crate::error::StartSyncExecutionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSyncExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartSyncExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExecutionInput" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::InvalidExecutionInput({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_execution_input::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_execution_input_json_err(response.body().as_ref(), output).map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidName" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::InvalidName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_name::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_name_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDeleting" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::StateMachineDeleting({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_deleting::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_deleting_json_err(response.body().as_ref(), output).map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDoesNotExist" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::StateMachineDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineTypeNotSupported" => crate::error::StartSyncExecutionError {
            meta: generic,
            kind: crate::error::StartSyncExecutionErrorKind::StateMachineTypeNotSupported({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::state_machine_type_not_supported::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_type_not_supported_json_err(response.body().as_ref(), output).map_err(crate::error::StartSyncExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartSyncExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_sync_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartSyncExecutionOutput,
    crate::error::StartSyncExecutionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_sync_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_sync_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartSyncExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_execution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopExecutionOutput, crate::error::StopExecutionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopExecutionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopExecutionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExecutionDoesNotExist" => crate::error::StopExecutionError {
            meta: generic,
            kind: crate::error::StopExecutionErrorKind::ExecutionDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::execution_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_execution_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::StopExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArn" => crate::error::StopExecutionError {
            meta: generic,
            kind: crate::error::StopExecutionErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StopExecutionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopExecutionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_execution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopExecutionOutput, crate::error::StopExecutionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_execution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_execution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopExecutionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyTags" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTags({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_state_machine_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStateMachineOutput,
    crate::error::UpdateStateMachineError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateStateMachineError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateStateMachineError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidArn" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::InvalidArn({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_arn::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_arn_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDefinition" => {
            crate::error::UpdateStateMachineError {
                meta: generic,
                kind: crate::error::UpdateStateMachineErrorKind::InvalidDefinition({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_definition::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_definition_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidLoggingConfiguration" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::InvalidLoggingConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_logging_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_logging_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTracingConfiguration" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::InvalidTracingConfiguration({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tracing_configuration::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tracing_configuration_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRequiredParameter" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::MissingRequiredParameter({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_required_parameter::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_required_parameter_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDeleting" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::StateMachineDeleting({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_deleting::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_deleting_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StateMachineDoesNotExist" => crate::error::UpdateStateMachineError {
            meta: generic,
            kind: crate::error::UpdateStateMachineErrorKind::StateMachineDoesNotExist({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::state_machine_does_not_exist::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_state_machine_does_not_exist_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateStateMachineError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateStateMachineError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_state_machine_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateStateMachineOutput,
    crate::error::UpdateStateMachineError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_state_machine_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_state_machine(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateStateMachineError::unhandled)?;
        output.build()
    })
}
