// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Selects whether or not the state machine's AWS X-Ray tracing is enabled. Default is <code>false</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TracingConfiguration {
    /// <p>When set to <code>true</code>, AWS X-Ray tracing is enabled.</p>
    pub enabled: bool,
}
impl TracingConfiguration {
    /// <p>When set to <code>true</code>, AWS X-Ray tracing is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for TracingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TracingConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`TracingConfiguration`](crate::model::TracingConfiguration)
pub mod tracing_configuration {
    /// A builder for [`TracingConfiguration`](crate::model::TracingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>When set to <code>true</code>, AWS X-Ray tracing is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, AWS X-Ray tracing is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`TracingConfiguration`](crate::model::TracingConfiguration)
        pub fn build(self) -> crate::model::TracingConfiguration {
            crate::model::TracingConfiguration {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl TracingConfiguration {
    /// Creates a new builder-style object to manufacture [`TracingConfiguration`](crate::model::TracingConfiguration)
    pub fn builder() -> crate::model::tracing_configuration::Builder {
        crate::model::tracing_configuration::Builder::default()
    }
}

/// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
/// options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>Defines which category of execution history events are logged.</p>
    pub level: std::option::Option<crate::model::LogLevel>,
    /// <p>Determines whether execution data is included in your log. When set to <code>false</code>,
    /// data is excluded.</p>
    pub include_execution_data: bool,
    /// <p>An array of objects that describes where your execution history events will be logged.
    /// Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::LogDestination>>,
}
impl LoggingConfiguration {
    /// <p>Defines which category of execution history events are logged.</p>
    pub fn level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.level.as_ref()
    }
    /// <p>Determines whether execution data is included in your log. When set to <code>false</code>,
    /// data is excluded.</p>
    pub fn include_execution_data(&self) -> bool {
        self.include_execution_data
    }
    /// <p>An array of objects that describes where your execution history events will be logged.
    /// Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::LogDestination]> {
        self.destinations.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("level", &self.level);
        formatter.field("include_execution_data", &self.include_execution_data);
        formatter.field("destinations", &self.destinations);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) level: std::option::Option<crate::model::LogLevel>,
        pub(crate) include_execution_data: std::option::Option<bool>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<crate::model::LogDestination>>,
    }
    impl Builder {
        /// <p>Defines which category of execution history events are logged.</p>
        pub fn level(mut self, input: crate::model::LogLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// <p>Defines which category of execution history events are logged.</p>
        pub fn set_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.level = input;
            self
        }
        /// <p>Determines whether execution data is included in your log. When set to <code>false</code>,
        /// data is excluded.</p>
        pub fn include_execution_data(mut self, input: bool) -> Self {
            self.include_execution_data = Some(input);
            self
        }
        /// <p>Determines whether execution data is included in your log. When set to <code>false</code>,
        /// data is excluded.</p>
        pub fn set_include_execution_data(mut self, input: std::option::Option<bool>) -> Self {
            self.include_execution_data = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>An array of objects that describes where your execution history events will be logged.
        /// Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>
        pub fn destinations(mut self, input: impl Into<crate::model::LogDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// <p>An array of objects that describes where your execution history events will be logged.
        /// Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                level: self.level,
                include_execution_data: self.include_execution_data.unwrap_or_default(),
                destinations: self.destinations,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogDestination {
    /// <p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.</p>
    pub cloud_watch_logs_log_group: std::option::Option<crate::model::CloudWatchLogsLogGroup>,
}
impl LogDestination {
    /// <p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.</p>
    pub fn cloud_watch_logs_log_group(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchLogsLogGroup> {
        self.cloud_watch_logs_log_group.as_ref()
    }
}
impl std::fmt::Debug for LogDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogDestination");
        formatter.field(
            "cloud_watch_logs_log_group",
            &self.cloud_watch_logs_log_group,
        );
        formatter.finish()
    }
}
/// See [`LogDestination`](crate::model::LogDestination)
pub mod log_destination {
    /// A builder for [`LogDestination`](crate::model::LogDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs_log_group:
            std::option::Option<crate::model::CloudWatchLogsLogGroup>,
    }
    impl Builder {
        /// <p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.</p>
        pub fn cloud_watch_logs_log_group(
            mut self,
            input: crate::model::CloudWatchLogsLogGroup,
        ) -> Self {
            self.cloud_watch_logs_log_group = Some(input);
            self
        }
        /// <p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.</p>
        pub fn set_cloud_watch_logs_log_group(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsLogGroup>,
        ) -> Self {
            self.cloud_watch_logs_log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`LogDestination`](crate::model::LogDestination)
        pub fn build(self) -> crate::model::LogDestination {
            crate::model::LogDestination {
                cloud_watch_logs_log_group: self.cloud_watch_logs_log_group,
            }
        }
    }
}
impl LogDestination {
    /// Creates a new builder-style object to manufacture [`LogDestination`](crate::model::LogDestination)
    pub fn builder() -> crate::model::log_destination::Builder {
        crate::model::log_destination::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsLogGroup {
    /// <p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN
    /// must end with <code>:*</code>
    /// </p>
    pub log_group_arn: std::option::Option<std::string::String>,
}
impl CloudWatchLogsLogGroup {
    /// <p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN
    /// must end with <code>:*</code>
    /// </p>
    pub fn log_group_arn(&self) -> std::option::Option<&str> {
        self.log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsLogGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsLogGroup");
        formatter.field("log_group_arn", &self.log_group_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsLogGroup`](crate::model::CloudWatchLogsLogGroup)
pub mod cloud_watch_logs_log_group {
    /// A builder for [`CloudWatchLogsLogGroup`](crate::model::CloudWatchLogsLogGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN
        /// must end with <code>:*</code>
        /// </p>
        pub fn log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN
        /// must end with <code>:*</code>
        /// </p>
        pub fn set_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsLogGroup`](crate::model::CloudWatchLogsLogGroup)
        pub fn build(self) -> crate::model::CloudWatchLogsLogGroup {
            crate::model::CloudWatchLogsLogGroup {
                log_group_arn: self.log_group_arn,
            }
        }
    }
}
impl CloudWatchLogsLogGroup {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsLogGroup`](crate::model::CloudWatchLogsLogGroup)
    pub fn builder() -> crate::model::cloud_watch_logs_log_group::Builder {
        crate::model::cloud_watch_logs_log_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogLevel {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fatal,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogLevel {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => LogLevel::All,
            "ERROR" => LogLevel::Error,
            "FATAL" => LogLevel::Fatal,
            "OFF" => LogLevel::Off,
            other => LogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogLevel::from(s))
    }
}
impl LogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogLevel::All => "ALL",
            LogLevel::Error => "ERROR",
            LogLevel::Fatal => "FATAL",
            LogLevel::Off => "OFF",
            LogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ERROR", "FATAL", "OFF"]
    }
}
impl AsRef<str> for LogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Tags are key-value pairs that can be associated with Step Functions state machines and
/// activities.</p>
/// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
/// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
/// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
/// Tags</a>.</p>
/// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of a tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of a tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of a tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of a tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of a tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of a tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of a tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An object that describes workflow billing details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingDetails {
    /// <p>Billed memory consumption of your workflow, in MB.</p>
    pub billed_memory_used_in_mb: i64,
    /// <p>Billed duration of your workflow, in milliseconds.</p>
    pub billed_duration_in_milliseconds: i64,
}
impl BillingDetails {
    /// <p>Billed memory consumption of your workflow, in MB.</p>
    pub fn billed_memory_used_in_mb(&self) -> i64 {
        self.billed_memory_used_in_mb
    }
    /// <p>Billed duration of your workflow, in milliseconds.</p>
    pub fn billed_duration_in_milliseconds(&self) -> i64 {
        self.billed_duration_in_milliseconds
    }
}
impl std::fmt::Debug for BillingDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingDetails");
        formatter.field("billed_memory_used_in_mb", &self.billed_memory_used_in_mb);
        formatter.field(
            "billed_duration_in_milliseconds",
            &self.billed_duration_in_milliseconds,
        );
        formatter.finish()
    }
}
/// See [`BillingDetails`](crate::model::BillingDetails)
pub mod billing_details {
    /// A builder for [`BillingDetails`](crate::model::BillingDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billed_memory_used_in_mb: std::option::Option<i64>,
        pub(crate) billed_duration_in_milliseconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Billed memory consumption of your workflow, in MB.</p>
        pub fn billed_memory_used_in_mb(mut self, input: i64) -> Self {
            self.billed_memory_used_in_mb = Some(input);
            self
        }
        /// <p>Billed memory consumption of your workflow, in MB.</p>
        pub fn set_billed_memory_used_in_mb(mut self, input: std::option::Option<i64>) -> Self {
            self.billed_memory_used_in_mb = input;
            self
        }
        /// <p>Billed duration of your workflow, in milliseconds.</p>
        pub fn billed_duration_in_milliseconds(mut self, input: i64) -> Self {
            self.billed_duration_in_milliseconds = Some(input);
            self
        }
        /// <p>Billed duration of your workflow, in milliseconds.</p>
        pub fn set_billed_duration_in_milliseconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.billed_duration_in_milliseconds = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingDetails`](crate::model::BillingDetails)
        pub fn build(self) -> crate::model::BillingDetails {
            crate::model::BillingDetails {
                billed_memory_used_in_mb: self.billed_memory_used_in_mb.unwrap_or_default(),
                billed_duration_in_milliseconds: self
                    .billed_duration_in_milliseconds
                    .unwrap_or_default(),
            }
        }
    }
}
impl BillingDetails {
    /// Creates a new builder-style object to manufacture [`BillingDetails`](crate::model::BillingDetails)
    pub fn builder() -> crate::model::billing_details::Builder {
        crate::model::billing_details::Builder::default()
    }
}

/// <p>Provides details about execution input or output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchEventsExecutionDataDetails {
    /// <p>Indicates whether input or output was included in the response. Always <code>true</code>
    /// for API calls. </p>
    pub included: bool,
}
impl CloudWatchEventsExecutionDataDetails {
    /// <p>Indicates whether input or output was included in the response. Always <code>true</code>
    /// for API calls. </p>
    pub fn included(&self) -> bool {
        self.included
    }
}
impl std::fmt::Debug for CloudWatchEventsExecutionDataDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchEventsExecutionDataDetails");
        formatter.field("included", &self.included);
        formatter.finish()
    }
}
/// See [`CloudWatchEventsExecutionDataDetails`](crate::model::CloudWatchEventsExecutionDataDetails)
pub mod cloud_watch_events_execution_data_details {
    /// A builder for [`CloudWatchEventsExecutionDataDetails`](crate::model::CloudWatchEventsExecutionDataDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) included: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether input or output was included in the response. Always <code>true</code>
        /// for API calls. </p>
        pub fn included(mut self, input: bool) -> Self {
            self.included = Some(input);
            self
        }
        /// <p>Indicates whether input or output was included in the response. Always <code>true</code>
        /// for API calls. </p>
        pub fn set_included(mut self, input: std::option::Option<bool>) -> Self {
            self.included = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchEventsExecutionDataDetails`](crate::model::CloudWatchEventsExecutionDataDetails)
        pub fn build(self) -> crate::model::CloudWatchEventsExecutionDataDetails {
            crate::model::CloudWatchEventsExecutionDataDetails {
                included: self.included.unwrap_or_default(),
            }
        }
    }
}
impl CloudWatchEventsExecutionDataDetails {
    /// Creates a new builder-style object to manufacture [`CloudWatchEventsExecutionDataDetails`](crate::model::CloudWatchEventsExecutionDataDetails)
    pub fn builder() -> crate::model::cloud_watch_events_execution_data_details::Builder {
        crate::model::cloud_watch_events_execution_data_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SyncExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SyncExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => SyncExecutionStatus::Failed,
            "SUCCEEDED" => SyncExecutionStatus::Succeeded,
            "TIMED_OUT" => SyncExecutionStatus::TimedOut,
            other => SyncExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SyncExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SyncExecutionStatus::from(s))
    }
}
impl SyncExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SyncExecutionStatus::Failed => "FAILED",
            SyncExecutionStatus::Succeeded => "SUCCEEDED",
            SyncExecutionStatus::TimedOut => "TIMED_OUT",
            SyncExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "SUCCEEDED", "TIMED_OUT"]
    }
}
impl AsRef<str> for SyncExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about the state machine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateMachineListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the state machine.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p></p>
    pub r#type: std::option::Option<crate::model::StateMachineType>,
    /// <p>The date the state machine is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl StateMachineListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the state machine.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p></p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StateMachineType> {
        self.r#type.as_ref()
    }
    /// <p>The date the state machine is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for StateMachineListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateMachineListItem");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`StateMachineListItem`](crate::model::StateMachineListItem)
pub mod state_machine_list_item {
    /// A builder for [`StateMachineListItem`](crate::model::StateMachineListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::StateMachineType>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the state machine.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state machine.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p></p>
        pub fn r#type(mut self, input: crate::model::StateMachineType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p></p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StateMachineType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the state machine is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StateMachineListItem`](crate::model::StateMachineListItem)
        pub fn build(self) -> crate::model::StateMachineListItem {
            crate::model::StateMachineListItem {
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                r#type: self.r#type,
                creation_date: self.creation_date,
            }
        }
    }
}
impl StateMachineListItem {
    /// Creates a new builder-style object to manufacture [`StateMachineListItem`](crate::model::StateMachineListItem)
    pub fn builder() -> crate::model::state_machine_list_item::Builder {
        crate::model::state_machine_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateMachineType {
    #[allow(missing_docs)] // documentation missing in model
    Express,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateMachineType {
    fn from(s: &str) -> Self {
        match s {
            "EXPRESS" => StateMachineType::Express,
            "STANDARD" => StateMachineType::Standard,
            other => StateMachineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateMachineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateMachineType::from(s))
    }
}
impl StateMachineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateMachineType::Express => "EXPRESS",
            StateMachineType::Standard => "STANDARD",
            StateMachineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXPRESS", "STANDARD"]
    }
}
impl AsRef<str> for StateMachineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the executed state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the execution.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the execution.</p>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The date the execution started.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If the execution already ended, the date the execution stopped.</p>
    pub stop_date: std::option::Option<aws_smithy_types::Instant>,
}
impl ExecutionListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the executed state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the execution.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The date the execution started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_date.as_ref()
    }
    /// <p>If the execution already ended, the date the execution stopped.</p>
    pub fn stop_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_date.as_ref()
    }
}
impl std::fmt::Debug for ExecutionListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionListItem");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("start_date", &self.start_date);
        formatter.field("stop_date", &self.stop_date);
        formatter.finish()
    }
}
/// See [`ExecutionListItem`](crate::model::ExecutionListItem)
pub mod execution_list_item {
    /// A builder for [`ExecutionListItem`](crate::model::ExecutionListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the executed state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the executed state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the execution.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the execution started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date the execution started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>If the execution already ended, the date the execution stopped.</p>
        pub fn stop_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_date = Some(input);
            self
        }
        /// <p>If the execution already ended, the date the execution stopped.</p>
        pub fn set_stop_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionListItem`](crate::model::ExecutionListItem)
        pub fn build(self) -> crate::model::ExecutionListItem {
            crate::model::ExecutionListItem {
                execution_arn: self.execution_arn,
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                status: self.status,
                start_date: self.start_date,
                stop_date: self.stop_date,
            }
        }
    }
}
impl ExecutionListItem {
    /// Creates a new builder-style object to manufacture [`ExecutionListItem`](crate::model::ExecutionListItem)
    pub fn builder() -> crate::model::execution_list_item::Builder {
        crate::model::execution_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => ExecutionStatus::Aborted,
            "FAILED" => ExecutionStatus::Failed,
            "RUNNING" => ExecutionStatus::Running,
            "SUCCEEDED" => ExecutionStatus::Succeeded,
            "TIMED_OUT" => ExecutionStatus::TimedOut,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Aborted => "ABORTED",
            ExecutionStatus::Failed => "FAILED",
            ExecutionStatus::Running => "RUNNING",
            ExecutionStatus::Succeeded => "SUCCEEDED",
            ExecutionStatus::TimedOut => "TIMED_OUT",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABORTED", "FAILED", "RUNNING", "SUCCEEDED", "TIMED_OUT"]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about an activity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
    pub activity_arn: std::option::Option<std::string::String>,
    /// <p>The name of the activity.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date the activity is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl ActivityListItem {
    /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
    /// <p>The name of the activity.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date the activity is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for ActivityListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityListItem");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.field("name", &self.name);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`ActivityListItem`](crate::model::ActivityListItem)
pub mod activity_list_item {
    /// A builder for [`ActivityListItem`](crate::model::ActivityListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the activity.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// <p>The name of the activity.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the activity.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the activity is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityListItem`](crate::model::ActivityListItem)
        pub fn build(self) -> crate::model::ActivityListItem {
            crate::model::ActivityListItem {
                activity_arn: self.activity_arn,
                name: self.name,
                creation_date: self.creation_date,
            }
        }
    }
}
impl ActivityListItem {
    /// Creates a new builder-style object to manufacture [`ActivityListItem`](crate::model::ActivityListItem)
    pub fn builder() -> crate::model::activity_list_item::Builder {
        crate::model::activity_list_item::Builder::default()
    }
}

/// <p>Contains details about the events of an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoryEvent {
    /// <p>The date and time the event occurred.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of the event.</p>
    pub r#type: std::option::Option<crate::model::HistoryEventType>,
    /// <p>The id of the event. Events are numbered sequentially, starting at one.</p>
    pub id: i64,
    /// <p>The id of the previous event.</p>
    pub previous_event_id: i64,
    /// <p>Contains details about an activity that failed during an execution.</p>
    pub activity_failed_event_details:
        std::option::Option<crate::model::ActivityFailedEventDetails>,
    /// <p>Contains details about an activity schedule event that failed during an execution.</p>
    pub activity_schedule_failed_event_details:
        std::option::Option<crate::model::ActivityScheduleFailedEventDetails>,
    /// <p>Contains details about an activity scheduled during an execution.</p>
    pub activity_scheduled_event_details:
        std::option::Option<crate::model::ActivityScheduledEventDetails>,
    /// <p>Contains details about the start of an activity during an execution.</p>
    pub activity_started_event_details:
        std::option::Option<crate::model::ActivityStartedEventDetails>,
    /// <p>Contains details about an activity that successfully terminated during an
    /// execution.</p>
    pub activity_succeeded_event_details:
        std::option::Option<crate::model::ActivitySucceededEventDetails>,
    /// <p>Contains details about an activity timeout that occurred during an execution.</p>
    pub activity_timed_out_event_details:
        std::option::Option<crate::model::ActivityTimedOutEventDetails>,
    /// <p>Contains details about the failure of a task.</p>
    pub task_failed_event_details: std::option::Option<crate::model::TaskFailedEventDetails>,
    /// <p>Contains details about a task that was scheduled.</p>
    pub task_scheduled_event_details: std::option::Option<crate::model::TaskScheduledEventDetails>,
    /// <p>Contains details about a task that failed to start.</p>
    pub task_start_failed_event_details:
        std::option::Option<crate::model::TaskStartFailedEventDetails>,
    /// <p>Contains details about a task that was started.</p>
    pub task_started_event_details: std::option::Option<crate::model::TaskStartedEventDetails>,
    /// <p>Contains details about a task that where the submit failed.</p>
    pub task_submit_failed_event_details:
        std::option::Option<crate::model::TaskSubmitFailedEventDetails>,
    /// <p>Contains details about a submitted task.</p>
    pub task_submitted_event_details: std::option::Option<crate::model::TaskSubmittedEventDetails>,
    /// <p>Contains details about a task that succeeded.</p>
    pub task_succeeded_event_details: std::option::Option<crate::model::TaskSucceededEventDetails>,
    /// <p>Contains details about a task that timed out.</p>
    pub task_timed_out_event_details: std::option::Option<crate::model::TaskTimedOutEventDetails>,
    /// <p>Contains details about an execution failure event.</p>
    pub execution_failed_event_details:
        std::option::Option<crate::model::ExecutionFailedEventDetails>,
    /// <p>Contains details about the start of the execution.</p>
    pub execution_started_event_details:
        std::option::Option<crate::model::ExecutionStartedEventDetails>,
    /// <p>Contains details about the successful termination of the execution.</p>
    pub execution_succeeded_event_details:
        std::option::Option<crate::model::ExecutionSucceededEventDetails>,
    /// <p>Contains details about an abort of an execution.</p>
    pub execution_aborted_event_details:
        std::option::Option<crate::model::ExecutionAbortedEventDetails>,
    /// <p>Contains details about the execution timeout that occurred during the execution.</p>
    pub execution_timed_out_event_details:
        std::option::Option<crate::model::ExecutionTimedOutEventDetails>,
    /// <p>Contains details about Map state that was started.</p>
    pub map_state_started_event_details:
        std::option::Option<crate::model::MapStateStartedEventDetails>,
    /// <p>Contains details about an iteration of a Map state that was started.</p>
    pub map_iteration_started_event_details:
        std::option::Option<crate::model::MapIterationEventDetails>,
    /// <p>Contains details about an iteration of a Map state that succeeded.</p>
    pub map_iteration_succeeded_event_details:
        std::option::Option<crate::model::MapIterationEventDetails>,
    /// <p>Contains details about an iteration of a Map state that failed.</p>
    pub map_iteration_failed_event_details:
        std::option::Option<crate::model::MapIterationEventDetails>,
    /// <p>Contains details about an iteration of a Map state that was aborted.</p>
    pub map_iteration_aborted_event_details:
        std::option::Option<crate::model::MapIterationEventDetails>,
    /// <p>Contains details about a lambda function that failed during an execution.</p>
    pub lambda_function_failed_event_details:
        std::option::Option<crate::model::LambdaFunctionFailedEventDetails>,
    /// <p>Contains details about a failed lambda function schedule event that occurred during an
    /// execution.</p>
    pub lambda_function_schedule_failed_event_details:
        std::option::Option<crate::model::LambdaFunctionScheduleFailedEventDetails>,
    /// <p>Contains details about a lambda function scheduled during an execution.</p>
    pub lambda_function_scheduled_event_details:
        std::option::Option<crate::model::LambdaFunctionScheduledEventDetails>,
    /// <p>Contains details about a lambda function that failed to start during an execution.</p>
    pub lambda_function_start_failed_event_details:
        std::option::Option<crate::model::LambdaFunctionStartFailedEventDetails>,
    /// <p>Contains details about a lambda function that terminated successfully during an
    /// execution.</p>
    pub lambda_function_succeeded_event_details:
        std::option::Option<crate::model::LambdaFunctionSucceededEventDetails>,
    /// <p>Contains details about a lambda function timeout that occurred during an execution.</p>
    pub lambda_function_timed_out_event_details:
        std::option::Option<crate::model::LambdaFunctionTimedOutEventDetails>,
    /// <p>Contains details about a state entered during an execution.</p>
    pub state_entered_event_details: std::option::Option<crate::model::StateEnteredEventDetails>,
    /// <p>Contains details about an exit from a state during an execution.</p>
    pub state_exited_event_details: std::option::Option<crate::model::StateExitedEventDetails>,
}
impl HistoryEvent {
    /// <p>The date and time the event occurred.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The type of the event.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HistoryEventType> {
        self.r#type.as_ref()
    }
    /// <p>The id of the event. Events are numbered sequentially, starting at one.</p>
    pub fn id(&self) -> i64 {
        self.id
    }
    /// <p>The id of the previous event.</p>
    pub fn previous_event_id(&self) -> i64 {
        self.previous_event_id
    }
    /// <p>Contains details about an activity that failed during an execution.</p>
    pub fn activity_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivityFailedEventDetails> {
        self.activity_failed_event_details.as_ref()
    }
    /// <p>Contains details about an activity schedule event that failed during an execution.</p>
    pub fn activity_schedule_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivityScheduleFailedEventDetails> {
        self.activity_schedule_failed_event_details.as_ref()
    }
    /// <p>Contains details about an activity scheduled during an execution.</p>
    pub fn activity_scheduled_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivityScheduledEventDetails> {
        self.activity_scheduled_event_details.as_ref()
    }
    /// <p>Contains details about the start of an activity during an execution.</p>
    pub fn activity_started_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivityStartedEventDetails> {
        self.activity_started_event_details.as_ref()
    }
    /// <p>Contains details about an activity that successfully terminated during an
    /// execution.</p>
    pub fn activity_succeeded_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivitySucceededEventDetails> {
        self.activity_succeeded_event_details.as_ref()
    }
    /// <p>Contains details about an activity timeout that occurred during an execution.</p>
    pub fn activity_timed_out_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ActivityTimedOutEventDetails> {
        self.activity_timed_out_event_details.as_ref()
    }
    /// <p>Contains details about the failure of a task.</p>
    pub fn task_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskFailedEventDetails> {
        self.task_failed_event_details.as_ref()
    }
    /// <p>Contains details about a task that was scheduled.</p>
    pub fn task_scheduled_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskScheduledEventDetails> {
        self.task_scheduled_event_details.as_ref()
    }
    /// <p>Contains details about a task that failed to start.</p>
    pub fn task_start_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskStartFailedEventDetails> {
        self.task_start_failed_event_details.as_ref()
    }
    /// <p>Contains details about a task that was started.</p>
    pub fn task_started_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskStartedEventDetails> {
        self.task_started_event_details.as_ref()
    }
    /// <p>Contains details about a task that where the submit failed.</p>
    pub fn task_submit_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskSubmitFailedEventDetails> {
        self.task_submit_failed_event_details.as_ref()
    }
    /// <p>Contains details about a submitted task.</p>
    pub fn task_submitted_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskSubmittedEventDetails> {
        self.task_submitted_event_details.as_ref()
    }
    /// <p>Contains details about a task that succeeded.</p>
    pub fn task_succeeded_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskSucceededEventDetails> {
        self.task_succeeded_event_details.as_ref()
    }
    /// <p>Contains details about a task that timed out.</p>
    pub fn task_timed_out_event_details(
        &self,
    ) -> std::option::Option<&crate::model::TaskTimedOutEventDetails> {
        self.task_timed_out_event_details.as_ref()
    }
    /// <p>Contains details about an execution failure event.</p>
    pub fn execution_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionFailedEventDetails> {
        self.execution_failed_event_details.as_ref()
    }
    /// <p>Contains details about the start of the execution.</p>
    pub fn execution_started_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionStartedEventDetails> {
        self.execution_started_event_details.as_ref()
    }
    /// <p>Contains details about the successful termination of the execution.</p>
    pub fn execution_succeeded_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionSucceededEventDetails> {
        self.execution_succeeded_event_details.as_ref()
    }
    /// <p>Contains details about an abort of an execution.</p>
    pub fn execution_aborted_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionAbortedEventDetails> {
        self.execution_aborted_event_details.as_ref()
    }
    /// <p>Contains details about the execution timeout that occurred during the execution.</p>
    pub fn execution_timed_out_event_details(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionTimedOutEventDetails> {
        self.execution_timed_out_event_details.as_ref()
    }
    /// <p>Contains details about Map state that was started.</p>
    pub fn map_state_started_event_details(
        &self,
    ) -> std::option::Option<&crate::model::MapStateStartedEventDetails> {
        self.map_state_started_event_details.as_ref()
    }
    /// <p>Contains details about an iteration of a Map state that was started.</p>
    pub fn map_iteration_started_event_details(
        &self,
    ) -> std::option::Option<&crate::model::MapIterationEventDetails> {
        self.map_iteration_started_event_details.as_ref()
    }
    /// <p>Contains details about an iteration of a Map state that succeeded.</p>
    pub fn map_iteration_succeeded_event_details(
        &self,
    ) -> std::option::Option<&crate::model::MapIterationEventDetails> {
        self.map_iteration_succeeded_event_details.as_ref()
    }
    /// <p>Contains details about an iteration of a Map state that failed.</p>
    pub fn map_iteration_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::MapIterationEventDetails> {
        self.map_iteration_failed_event_details.as_ref()
    }
    /// <p>Contains details about an iteration of a Map state that was aborted.</p>
    pub fn map_iteration_aborted_event_details(
        &self,
    ) -> std::option::Option<&crate::model::MapIterationEventDetails> {
        self.map_iteration_aborted_event_details.as_ref()
    }
    /// <p>Contains details about a lambda function that failed during an execution.</p>
    pub fn lambda_function_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionFailedEventDetails> {
        self.lambda_function_failed_event_details.as_ref()
    }
    /// <p>Contains details about a failed lambda function schedule event that occurred during an
    /// execution.</p>
    pub fn lambda_function_schedule_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionScheduleFailedEventDetails> {
        self.lambda_function_schedule_failed_event_details.as_ref()
    }
    /// <p>Contains details about a lambda function scheduled during an execution.</p>
    pub fn lambda_function_scheduled_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionScheduledEventDetails> {
        self.lambda_function_scheduled_event_details.as_ref()
    }
    /// <p>Contains details about a lambda function that failed to start during an execution.</p>
    pub fn lambda_function_start_failed_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionStartFailedEventDetails> {
        self.lambda_function_start_failed_event_details.as_ref()
    }
    /// <p>Contains details about a lambda function that terminated successfully during an
    /// execution.</p>
    pub fn lambda_function_succeeded_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionSucceededEventDetails> {
        self.lambda_function_succeeded_event_details.as_ref()
    }
    /// <p>Contains details about a lambda function timeout that occurred during an execution.</p>
    pub fn lambda_function_timed_out_event_details(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionTimedOutEventDetails> {
        self.lambda_function_timed_out_event_details.as_ref()
    }
    /// <p>Contains details about a state entered during an execution.</p>
    pub fn state_entered_event_details(
        &self,
    ) -> std::option::Option<&crate::model::StateEnteredEventDetails> {
        self.state_entered_event_details.as_ref()
    }
    /// <p>Contains details about an exit from a state during an execution.</p>
    pub fn state_exited_event_details(
        &self,
    ) -> std::option::Option<&crate::model::StateExitedEventDetails> {
        self.state_exited_event_details.as_ref()
    }
}
impl std::fmt::Debug for HistoryEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoryEvent");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("previous_event_id", &self.previous_event_id);
        formatter.field(
            "activity_failed_event_details",
            &self.activity_failed_event_details,
        );
        formatter.field(
            "activity_schedule_failed_event_details",
            &self.activity_schedule_failed_event_details,
        );
        formatter.field(
            "activity_scheduled_event_details",
            &self.activity_scheduled_event_details,
        );
        formatter.field(
            "activity_started_event_details",
            &self.activity_started_event_details,
        );
        formatter.field(
            "activity_succeeded_event_details",
            &self.activity_succeeded_event_details,
        );
        formatter.field(
            "activity_timed_out_event_details",
            &self.activity_timed_out_event_details,
        );
        formatter.field("task_failed_event_details", &self.task_failed_event_details);
        formatter.field(
            "task_scheduled_event_details",
            &self.task_scheduled_event_details,
        );
        formatter.field(
            "task_start_failed_event_details",
            &self.task_start_failed_event_details,
        );
        formatter.field(
            "task_started_event_details",
            &self.task_started_event_details,
        );
        formatter.field(
            "task_submit_failed_event_details",
            &self.task_submit_failed_event_details,
        );
        formatter.field(
            "task_submitted_event_details",
            &self.task_submitted_event_details,
        );
        formatter.field(
            "task_succeeded_event_details",
            &self.task_succeeded_event_details,
        );
        formatter.field(
            "task_timed_out_event_details",
            &self.task_timed_out_event_details,
        );
        formatter.field(
            "execution_failed_event_details",
            &self.execution_failed_event_details,
        );
        formatter.field(
            "execution_started_event_details",
            &self.execution_started_event_details,
        );
        formatter.field(
            "execution_succeeded_event_details",
            &self.execution_succeeded_event_details,
        );
        formatter.field(
            "execution_aborted_event_details",
            &self.execution_aborted_event_details,
        );
        formatter.field(
            "execution_timed_out_event_details",
            &self.execution_timed_out_event_details,
        );
        formatter.field(
            "map_state_started_event_details",
            &self.map_state_started_event_details,
        );
        formatter.field(
            "map_iteration_started_event_details",
            &self.map_iteration_started_event_details,
        );
        formatter.field(
            "map_iteration_succeeded_event_details",
            &self.map_iteration_succeeded_event_details,
        );
        formatter.field(
            "map_iteration_failed_event_details",
            &self.map_iteration_failed_event_details,
        );
        formatter.field(
            "map_iteration_aborted_event_details",
            &self.map_iteration_aborted_event_details,
        );
        formatter.field(
            "lambda_function_failed_event_details",
            &self.lambda_function_failed_event_details,
        );
        formatter.field(
            "lambda_function_schedule_failed_event_details",
            &self.lambda_function_schedule_failed_event_details,
        );
        formatter.field(
            "lambda_function_scheduled_event_details",
            &self.lambda_function_scheduled_event_details,
        );
        formatter.field(
            "lambda_function_start_failed_event_details",
            &self.lambda_function_start_failed_event_details,
        );
        formatter.field(
            "lambda_function_succeeded_event_details",
            &self.lambda_function_succeeded_event_details,
        );
        formatter.field(
            "lambda_function_timed_out_event_details",
            &self.lambda_function_timed_out_event_details,
        );
        formatter.field(
            "state_entered_event_details",
            &self.state_entered_event_details,
        );
        formatter.field(
            "state_exited_event_details",
            &self.state_exited_event_details,
        );
        formatter.finish()
    }
}
/// See [`HistoryEvent`](crate::model::HistoryEvent)
pub mod history_event {
    /// A builder for [`HistoryEvent`](crate::model::HistoryEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::HistoryEventType>,
        pub(crate) id: std::option::Option<i64>,
        pub(crate) previous_event_id: std::option::Option<i64>,
        pub(crate) activity_failed_event_details:
            std::option::Option<crate::model::ActivityFailedEventDetails>,
        pub(crate) activity_schedule_failed_event_details:
            std::option::Option<crate::model::ActivityScheduleFailedEventDetails>,
        pub(crate) activity_scheduled_event_details:
            std::option::Option<crate::model::ActivityScheduledEventDetails>,
        pub(crate) activity_started_event_details:
            std::option::Option<crate::model::ActivityStartedEventDetails>,
        pub(crate) activity_succeeded_event_details:
            std::option::Option<crate::model::ActivitySucceededEventDetails>,
        pub(crate) activity_timed_out_event_details:
            std::option::Option<crate::model::ActivityTimedOutEventDetails>,
        pub(crate) task_failed_event_details:
            std::option::Option<crate::model::TaskFailedEventDetails>,
        pub(crate) task_scheduled_event_details:
            std::option::Option<crate::model::TaskScheduledEventDetails>,
        pub(crate) task_start_failed_event_details:
            std::option::Option<crate::model::TaskStartFailedEventDetails>,
        pub(crate) task_started_event_details:
            std::option::Option<crate::model::TaskStartedEventDetails>,
        pub(crate) task_submit_failed_event_details:
            std::option::Option<crate::model::TaskSubmitFailedEventDetails>,
        pub(crate) task_submitted_event_details:
            std::option::Option<crate::model::TaskSubmittedEventDetails>,
        pub(crate) task_succeeded_event_details:
            std::option::Option<crate::model::TaskSucceededEventDetails>,
        pub(crate) task_timed_out_event_details:
            std::option::Option<crate::model::TaskTimedOutEventDetails>,
        pub(crate) execution_failed_event_details:
            std::option::Option<crate::model::ExecutionFailedEventDetails>,
        pub(crate) execution_started_event_details:
            std::option::Option<crate::model::ExecutionStartedEventDetails>,
        pub(crate) execution_succeeded_event_details:
            std::option::Option<crate::model::ExecutionSucceededEventDetails>,
        pub(crate) execution_aborted_event_details:
            std::option::Option<crate::model::ExecutionAbortedEventDetails>,
        pub(crate) execution_timed_out_event_details:
            std::option::Option<crate::model::ExecutionTimedOutEventDetails>,
        pub(crate) map_state_started_event_details:
            std::option::Option<crate::model::MapStateStartedEventDetails>,
        pub(crate) map_iteration_started_event_details:
            std::option::Option<crate::model::MapIterationEventDetails>,
        pub(crate) map_iteration_succeeded_event_details:
            std::option::Option<crate::model::MapIterationEventDetails>,
        pub(crate) map_iteration_failed_event_details:
            std::option::Option<crate::model::MapIterationEventDetails>,
        pub(crate) map_iteration_aborted_event_details:
            std::option::Option<crate::model::MapIterationEventDetails>,
        pub(crate) lambda_function_failed_event_details:
            std::option::Option<crate::model::LambdaFunctionFailedEventDetails>,
        pub(crate) lambda_function_schedule_failed_event_details:
            std::option::Option<crate::model::LambdaFunctionScheduleFailedEventDetails>,
        pub(crate) lambda_function_scheduled_event_details:
            std::option::Option<crate::model::LambdaFunctionScheduledEventDetails>,
        pub(crate) lambda_function_start_failed_event_details:
            std::option::Option<crate::model::LambdaFunctionStartFailedEventDetails>,
        pub(crate) lambda_function_succeeded_event_details:
            std::option::Option<crate::model::LambdaFunctionSucceededEventDetails>,
        pub(crate) lambda_function_timed_out_event_details:
            std::option::Option<crate::model::LambdaFunctionTimedOutEventDetails>,
        pub(crate) state_entered_event_details:
            std::option::Option<crate::model::StateEnteredEventDetails>,
        pub(crate) state_exited_event_details:
            std::option::Option<crate::model::StateExitedEventDetails>,
    }
    impl Builder {
        /// <p>The date and time the event occurred.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The date and time the event occurred.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The type of the event.</p>
        pub fn r#type(mut self, input: crate::model::HistoryEventType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the event.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HistoryEventType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The id of the event. Events are numbered sequentially, starting at one.</p>
        pub fn id(mut self, input: i64) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>The id of the event. Events are numbered sequentially, starting at one.</p>
        pub fn set_id(mut self, input: std::option::Option<i64>) -> Self {
            self.id = input;
            self
        }
        /// <p>The id of the previous event.</p>
        pub fn previous_event_id(mut self, input: i64) -> Self {
            self.previous_event_id = Some(input);
            self
        }
        /// <p>The id of the previous event.</p>
        pub fn set_previous_event_id(mut self, input: std::option::Option<i64>) -> Self {
            self.previous_event_id = input;
            self
        }
        /// <p>Contains details about an activity that failed during an execution.</p>
        pub fn activity_failed_event_details(
            mut self,
            input: crate::model::ActivityFailedEventDetails,
        ) -> Self {
            self.activity_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about an activity that failed during an execution.</p>
        pub fn set_activity_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivityFailedEventDetails>,
        ) -> Self {
            self.activity_failed_event_details = input;
            self
        }
        /// <p>Contains details about an activity schedule event that failed during an execution.</p>
        pub fn activity_schedule_failed_event_details(
            mut self,
            input: crate::model::ActivityScheduleFailedEventDetails,
        ) -> Self {
            self.activity_schedule_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about an activity schedule event that failed during an execution.</p>
        pub fn set_activity_schedule_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivityScheduleFailedEventDetails>,
        ) -> Self {
            self.activity_schedule_failed_event_details = input;
            self
        }
        /// <p>Contains details about an activity scheduled during an execution.</p>
        pub fn activity_scheduled_event_details(
            mut self,
            input: crate::model::ActivityScheduledEventDetails,
        ) -> Self {
            self.activity_scheduled_event_details = Some(input);
            self
        }
        /// <p>Contains details about an activity scheduled during an execution.</p>
        pub fn set_activity_scheduled_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivityScheduledEventDetails>,
        ) -> Self {
            self.activity_scheduled_event_details = input;
            self
        }
        /// <p>Contains details about the start of an activity during an execution.</p>
        pub fn activity_started_event_details(
            mut self,
            input: crate::model::ActivityStartedEventDetails,
        ) -> Self {
            self.activity_started_event_details = Some(input);
            self
        }
        /// <p>Contains details about the start of an activity during an execution.</p>
        pub fn set_activity_started_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivityStartedEventDetails>,
        ) -> Self {
            self.activity_started_event_details = input;
            self
        }
        /// <p>Contains details about an activity that successfully terminated during an
        /// execution.</p>
        pub fn activity_succeeded_event_details(
            mut self,
            input: crate::model::ActivitySucceededEventDetails,
        ) -> Self {
            self.activity_succeeded_event_details = Some(input);
            self
        }
        /// <p>Contains details about an activity that successfully terminated during an
        /// execution.</p>
        pub fn set_activity_succeeded_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivitySucceededEventDetails>,
        ) -> Self {
            self.activity_succeeded_event_details = input;
            self
        }
        /// <p>Contains details about an activity timeout that occurred during an execution.</p>
        pub fn activity_timed_out_event_details(
            mut self,
            input: crate::model::ActivityTimedOutEventDetails,
        ) -> Self {
            self.activity_timed_out_event_details = Some(input);
            self
        }
        /// <p>Contains details about an activity timeout that occurred during an execution.</p>
        pub fn set_activity_timed_out_event_details(
            mut self,
            input: std::option::Option<crate::model::ActivityTimedOutEventDetails>,
        ) -> Self {
            self.activity_timed_out_event_details = input;
            self
        }
        /// <p>Contains details about the failure of a task.</p>
        pub fn task_failed_event_details(
            mut self,
            input: crate::model::TaskFailedEventDetails,
        ) -> Self {
            self.task_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about the failure of a task.</p>
        pub fn set_task_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskFailedEventDetails>,
        ) -> Self {
            self.task_failed_event_details = input;
            self
        }
        /// <p>Contains details about a task that was scheduled.</p>
        pub fn task_scheduled_event_details(
            mut self,
            input: crate::model::TaskScheduledEventDetails,
        ) -> Self {
            self.task_scheduled_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that was scheduled.</p>
        pub fn set_task_scheduled_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskScheduledEventDetails>,
        ) -> Self {
            self.task_scheduled_event_details = input;
            self
        }
        /// <p>Contains details about a task that failed to start.</p>
        pub fn task_start_failed_event_details(
            mut self,
            input: crate::model::TaskStartFailedEventDetails,
        ) -> Self {
            self.task_start_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that failed to start.</p>
        pub fn set_task_start_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskStartFailedEventDetails>,
        ) -> Self {
            self.task_start_failed_event_details = input;
            self
        }
        /// <p>Contains details about a task that was started.</p>
        pub fn task_started_event_details(
            mut self,
            input: crate::model::TaskStartedEventDetails,
        ) -> Self {
            self.task_started_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that was started.</p>
        pub fn set_task_started_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskStartedEventDetails>,
        ) -> Self {
            self.task_started_event_details = input;
            self
        }
        /// <p>Contains details about a task that where the submit failed.</p>
        pub fn task_submit_failed_event_details(
            mut self,
            input: crate::model::TaskSubmitFailedEventDetails,
        ) -> Self {
            self.task_submit_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that where the submit failed.</p>
        pub fn set_task_submit_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskSubmitFailedEventDetails>,
        ) -> Self {
            self.task_submit_failed_event_details = input;
            self
        }
        /// <p>Contains details about a submitted task.</p>
        pub fn task_submitted_event_details(
            mut self,
            input: crate::model::TaskSubmittedEventDetails,
        ) -> Self {
            self.task_submitted_event_details = Some(input);
            self
        }
        /// <p>Contains details about a submitted task.</p>
        pub fn set_task_submitted_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskSubmittedEventDetails>,
        ) -> Self {
            self.task_submitted_event_details = input;
            self
        }
        /// <p>Contains details about a task that succeeded.</p>
        pub fn task_succeeded_event_details(
            mut self,
            input: crate::model::TaskSucceededEventDetails,
        ) -> Self {
            self.task_succeeded_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that succeeded.</p>
        pub fn set_task_succeeded_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskSucceededEventDetails>,
        ) -> Self {
            self.task_succeeded_event_details = input;
            self
        }
        /// <p>Contains details about a task that timed out.</p>
        pub fn task_timed_out_event_details(
            mut self,
            input: crate::model::TaskTimedOutEventDetails,
        ) -> Self {
            self.task_timed_out_event_details = Some(input);
            self
        }
        /// <p>Contains details about a task that timed out.</p>
        pub fn set_task_timed_out_event_details(
            mut self,
            input: std::option::Option<crate::model::TaskTimedOutEventDetails>,
        ) -> Self {
            self.task_timed_out_event_details = input;
            self
        }
        /// <p>Contains details about an execution failure event.</p>
        pub fn execution_failed_event_details(
            mut self,
            input: crate::model::ExecutionFailedEventDetails,
        ) -> Self {
            self.execution_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about an execution failure event.</p>
        pub fn set_execution_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionFailedEventDetails>,
        ) -> Self {
            self.execution_failed_event_details = input;
            self
        }
        /// <p>Contains details about the start of the execution.</p>
        pub fn execution_started_event_details(
            mut self,
            input: crate::model::ExecutionStartedEventDetails,
        ) -> Self {
            self.execution_started_event_details = Some(input);
            self
        }
        /// <p>Contains details about the start of the execution.</p>
        pub fn set_execution_started_event_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionStartedEventDetails>,
        ) -> Self {
            self.execution_started_event_details = input;
            self
        }
        /// <p>Contains details about the successful termination of the execution.</p>
        pub fn execution_succeeded_event_details(
            mut self,
            input: crate::model::ExecutionSucceededEventDetails,
        ) -> Self {
            self.execution_succeeded_event_details = Some(input);
            self
        }
        /// <p>Contains details about the successful termination of the execution.</p>
        pub fn set_execution_succeeded_event_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionSucceededEventDetails>,
        ) -> Self {
            self.execution_succeeded_event_details = input;
            self
        }
        /// <p>Contains details about an abort of an execution.</p>
        pub fn execution_aborted_event_details(
            mut self,
            input: crate::model::ExecutionAbortedEventDetails,
        ) -> Self {
            self.execution_aborted_event_details = Some(input);
            self
        }
        /// <p>Contains details about an abort of an execution.</p>
        pub fn set_execution_aborted_event_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionAbortedEventDetails>,
        ) -> Self {
            self.execution_aborted_event_details = input;
            self
        }
        /// <p>Contains details about the execution timeout that occurred during the execution.</p>
        pub fn execution_timed_out_event_details(
            mut self,
            input: crate::model::ExecutionTimedOutEventDetails,
        ) -> Self {
            self.execution_timed_out_event_details = Some(input);
            self
        }
        /// <p>Contains details about the execution timeout that occurred during the execution.</p>
        pub fn set_execution_timed_out_event_details(
            mut self,
            input: std::option::Option<crate::model::ExecutionTimedOutEventDetails>,
        ) -> Self {
            self.execution_timed_out_event_details = input;
            self
        }
        /// <p>Contains details about Map state that was started.</p>
        pub fn map_state_started_event_details(
            mut self,
            input: crate::model::MapStateStartedEventDetails,
        ) -> Self {
            self.map_state_started_event_details = Some(input);
            self
        }
        /// <p>Contains details about Map state that was started.</p>
        pub fn set_map_state_started_event_details(
            mut self,
            input: std::option::Option<crate::model::MapStateStartedEventDetails>,
        ) -> Self {
            self.map_state_started_event_details = input;
            self
        }
        /// <p>Contains details about an iteration of a Map state that was started.</p>
        pub fn map_iteration_started_event_details(
            mut self,
            input: crate::model::MapIterationEventDetails,
        ) -> Self {
            self.map_iteration_started_event_details = Some(input);
            self
        }
        /// <p>Contains details about an iteration of a Map state that was started.</p>
        pub fn set_map_iteration_started_event_details(
            mut self,
            input: std::option::Option<crate::model::MapIterationEventDetails>,
        ) -> Self {
            self.map_iteration_started_event_details = input;
            self
        }
        /// <p>Contains details about an iteration of a Map state that succeeded.</p>
        pub fn map_iteration_succeeded_event_details(
            mut self,
            input: crate::model::MapIterationEventDetails,
        ) -> Self {
            self.map_iteration_succeeded_event_details = Some(input);
            self
        }
        /// <p>Contains details about an iteration of a Map state that succeeded.</p>
        pub fn set_map_iteration_succeeded_event_details(
            mut self,
            input: std::option::Option<crate::model::MapIterationEventDetails>,
        ) -> Self {
            self.map_iteration_succeeded_event_details = input;
            self
        }
        /// <p>Contains details about an iteration of a Map state that failed.</p>
        pub fn map_iteration_failed_event_details(
            mut self,
            input: crate::model::MapIterationEventDetails,
        ) -> Self {
            self.map_iteration_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about an iteration of a Map state that failed.</p>
        pub fn set_map_iteration_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::MapIterationEventDetails>,
        ) -> Self {
            self.map_iteration_failed_event_details = input;
            self
        }
        /// <p>Contains details about an iteration of a Map state that was aborted.</p>
        pub fn map_iteration_aborted_event_details(
            mut self,
            input: crate::model::MapIterationEventDetails,
        ) -> Self {
            self.map_iteration_aborted_event_details = Some(input);
            self
        }
        /// <p>Contains details about an iteration of a Map state that was aborted.</p>
        pub fn set_map_iteration_aborted_event_details(
            mut self,
            input: std::option::Option<crate::model::MapIterationEventDetails>,
        ) -> Self {
            self.map_iteration_aborted_event_details = input;
            self
        }
        /// <p>Contains details about a lambda function that failed during an execution.</p>
        pub fn lambda_function_failed_event_details(
            mut self,
            input: crate::model::LambdaFunctionFailedEventDetails,
        ) -> Self {
            self.lambda_function_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about a lambda function that failed during an execution.</p>
        pub fn set_lambda_function_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionFailedEventDetails>,
        ) -> Self {
            self.lambda_function_failed_event_details = input;
            self
        }
        /// <p>Contains details about a failed lambda function schedule event that occurred during an
        /// execution.</p>
        pub fn lambda_function_schedule_failed_event_details(
            mut self,
            input: crate::model::LambdaFunctionScheduleFailedEventDetails,
        ) -> Self {
            self.lambda_function_schedule_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about a failed lambda function schedule event that occurred during an
        /// execution.</p>
        pub fn set_lambda_function_schedule_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionScheduleFailedEventDetails>,
        ) -> Self {
            self.lambda_function_schedule_failed_event_details = input;
            self
        }
        /// <p>Contains details about a lambda function scheduled during an execution.</p>
        pub fn lambda_function_scheduled_event_details(
            mut self,
            input: crate::model::LambdaFunctionScheduledEventDetails,
        ) -> Self {
            self.lambda_function_scheduled_event_details = Some(input);
            self
        }
        /// <p>Contains details about a lambda function scheduled during an execution.</p>
        pub fn set_lambda_function_scheduled_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionScheduledEventDetails>,
        ) -> Self {
            self.lambda_function_scheduled_event_details = input;
            self
        }
        /// <p>Contains details about a lambda function that failed to start during an execution.</p>
        pub fn lambda_function_start_failed_event_details(
            mut self,
            input: crate::model::LambdaFunctionStartFailedEventDetails,
        ) -> Self {
            self.lambda_function_start_failed_event_details = Some(input);
            self
        }
        /// <p>Contains details about a lambda function that failed to start during an execution.</p>
        pub fn set_lambda_function_start_failed_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionStartFailedEventDetails>,
        ) -> Self {
            self.lambda_function_start_failed_event_details = input;
            self
        }
        /// <p>Contains details about a lambda function that terminated successfully during an
        /// execution.</p>
        pub fn lambda_function_succeeded_event_details(
            mut self,
            input: crate::model::LambdaFunctionSucceededEventDetails,
        ) -> Self {
            self.lambda_function_succeeded_event_details = Some(input);
            self
        }
        /// <p>Contains details about a lambda function that terminated successfully during an
        /// execution.</p>
        pub fn set_lambda_function_succeeded_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionSucceededEventDetails>,
        ) -> Self {
            self.lambda_function_succeeded_event_details = input;
            self
        }
        /// <p>Contains details about a lambda function timeout that occurred during an execution.</p>
        pub fn lambda_function_timed_out_event_details(
            mut self,
            input: crate::model::LambdaFunctionTimedOutEventDetails,
        ) -> Self {
            self.lambda_function_timed_out_event_details = Some(input);
            self
        }
        /// <p>Contains details about a lambda function timeout that occurred during an execution.</p>
        pub fn set_lambda_function_timed_out_event_details(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionTimedOutEventDetails>,
        ) -> Self {
            self.lambda_function_timed_out_event_details = input;
            self
        }
        /// <p>Contains details about a state entered during an execution.</p>
        pub fn state_entered_event_details(
            mut self,
            input: crate::model::StateEnteredEventDetails,
        ) -> Self {
            self.state_entered_event_details = Some(input);
            self
        }
        /// <p>Contains details about a state entered during an execution.</p>
        pub fn set_state_entered_event_details(
            mut self,
            input: std::option::Option<crate::model::StateEnteredEventDetails>,
        ) -> Self {
            self.state_entered_event_details = input;
            self
        }
        /// <p>Contains details about an exit from a state during an execution.</p>
        pub fn state_exited_event_details(
            mut self,
            input: crate::model::StateExitedEventDetails,
        ) -> Self {
            self.state_exited_event_details = Some(input);
            self
        }
        /// <p>Contains details about an exit from a state during an execution.</p>
        pub fn set_state_exited_event_details(
            mut self,
            input: std::option::Option<crate::model::StateExitedEventDetails>,
        ) -> Self {
            self.state_exited_event_details = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoryEvent`](crate::model::HistoryEvent)
        pub fn build(self) -> crate::model::HistoryEvent {
            crate::model::HistoryEvent {
                timestamp: self.timestamp,
                r#type: self.r#type,
                id: self.id.unwrap_or_default(),
                previous_event_id: self.previous_event_id.unwrap_or_default(),
                activity_failed_event_details: self.activity_failed_event_details,
                activity_schedule_failed_event_details: self.activity_schedule_failed_event_details,
                activity_scheduled_event_details: self.activity_scheduled_event_details,
                activity_started_event_details: self.activity_started_event_details,
                activity_succeeded_event_details: self.activity_succeeded_event_details,
                activity_timed_out_event_details: self.activity_timed_out_event_details,
                task_failed_event_details: self.task_failed_event_details,
                task_scheduled_event_details: self.task_scheduled_event_details,
                task_start_failed_event_details: self.task_start_failed_event_details,
                task_started_event_details: self.task_started_event_details,
                task_submit_failed_event_details: self.task_submit_failed_event_details,
                task_submitted_event_details: self.task_submitted_event_details,
                task_succeeded_event_details: self.task_succeeded_event_details,
                task_timed_out_event_details: self.task_timed_out_event_details,
                execution_failed_event_details: self.execution_failed_event_details,
                execution_started_event_details: self.execution_started_event_details,
                execution_succeeded_event_details: self.execution_succeeded_event_details,
                execution_aborted_event_details: self.execution_aborted_event_details,
                execution_timed_out_event_details: self.execution_timed_out_event_details,
                map_state_started_event_details: self.map_state_started_event_details,
                map_iteration_started_event_details: self.map_iteration_started_event_details,
                map_iteration_succeeded_event_details: self.map_iteration_succeeded_event_details,
                map_iteration_failed_event_details: self.map_iteration_failed_event_details,
                map_iteration_aborted_event_details: self.map_iteration_aborted_event_details,
                lambda_function_failed_event_details: self.lambda_function_failed_event_details,
                lambda_function_schedule_failed_event_details: self
                    .lambda_function_schedule_failed_event_details,
                lambda_function_scheduled_event_details: self
                    .lambda_function_scheduled_event_details,
                lambda_function_start_failed_event_details: self
                    .lambda_function_start_failed_event_details,
                lambda_function_succeeded_event_details: self
                    .lambda_function_succeeded_event_details,
                lambda_function_timed_out_event_details: self
                    .lambda_function_timed_out_event_details,
                state_entered_event_details: self.state_entered_event_details,
                state_exited_event_details: self.state_exited_event_details,
            }
        }
    }
}
impl HistoryEvent {
    /// Creates a new builder-style object to manufacture [`HistoryEvent`](crate::model::HistoryEvent)
    pub fn builder() -> crate::model::history_event::Builder {
        crate::model::history_event::Builder::default()
    }
}

/// <p>Contains details about an exit from a state during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateExitedEventDetails {
    /// <p>The name of the state.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl StateExitedEventDetails {
    /// <p>The name of the state.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for StateExitedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateExitedEventDetails");
        formatter.field("name", &self.name);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`StateExitedEventDetails`](crate::model::StateExitedEventDetails)
pub mod state_exited_event_details {
    /// A builder for [`StateExitedEventDetails`](crate::model::StateExitedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The name of the state.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StateExitedEventDetails`](crate::model::StateExitedEventDetails)
        pub fn build(self) -> crate::model::StateExitedEventDetails {
            crate::model::StateExitedEventDetails {
                name: self.name,
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl StateExitedEventDetails {
    /// Creates a new builder-style object to manufacture [`StateExitedEventDetails`](crate::model::StateExitedEventDetails)
    pub fn builder() -> crate::model::state_exited_event_details::Builder {
        crate::model::state_exited_event_details::Builder::default()
    }
}

/// <p>Provides details about input or output in an execution history event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HistoryEventExecutionDataDetails {
    /// <p>Indicates whether input or output was truncated in the response. Always
    /// <code>false</code> for API calls.</p>
    pub truncated: bool,
}
impl HistoryEventExecutionDataDetails {
    /// <p>Indicates whether input or output was truncated in the response. Always
    /// <code>false</code> for API calls.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl std::fmt::Debug for HistoryEventExecutionDataDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HistoryEventExecutionDataDetails");
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`HistoryEventExecutionDataDetails`](crate::model::HistoryEventExecutionDataDetails)
pub mod history_event_execution_data_details {
    /// A builder for [`HistoryEventExecutionDataDetails`](crate::model::HistoryEventExecutionDataDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether input or output was truncated in the response. Always
        /// <code>false</code> for API calls.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>Indicates whether input or output was truncated in the response. Always
        /// <code>false</code> for API calls.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`HistoryEventExecutionDataDetails`](crate::model::HistoryEventExecutionDataDetails)
        pub fn build(self) -> crate::model::HistoryEventExecutionDataDetails {
            crate::model::HistoryEventExecutionDataDetails {
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl HistoryEventExecutionDataDetails {
    /// Creates a new builder-style object to manufacture [`HistoryEventExecutionDataDetails`](crate::model::HistoryEventExecutionDataDetails)
    pub fn builder() -> crate::model::history_event_execution_data_details::Builder {
        crate::model::history_event_execution_data_details::Builder::default()
    }
}

/// <p>Contains details about a state entered during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateEnteredEventDetails {
    /// <p>The name of the state.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Contains details about the input for an execution history event.</p>
    pub input_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl StateEnteredEventDetails {
    /// <p>The name of the state.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Contains details about the input for an execution history event.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.input_details.as_ref()
    }
}
impl std::fmt::Debug for StateEnteredEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateEnteredEventDetails");
        formatter.field("name", &self.name);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.finish()
    }
}
/// See [`StateEnteredEventDetails`](crate::model::StateEnteredEventDetails)
pub mod state_entered_event_details {
    /// A builder for [`StateEnteredEventDetails`](crate::model::StateEnteredEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The name of the state.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn input_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// Consumes the builder and constructs a [`StateEnteredEventDetails`](crate::model::StateEnteredEventDetails)
        pub fn build(self) -> crate::model::StateEnteredEventDetails {
            crate::model::StateEnteredEventDetails {
                name: self.name,
                input: self.input,
                input_details: self.input_details,
            }
        }
    }
}
impl StateEnteredEventDetails {
    /// Creates a new builder-style object to manufacture [`StateEnteredEventDetails`](crate::model::StateEnteredEventDetails)
    pub fn builder() -> crate::model::state_entered_event_details::Builder {
        crate::model::state_entered_event_details::Builder::default()
    }
}

/// <p>Contains details about a lambda function timeout that occurred during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl LambdaFunctionTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionTimedOutEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionTimedOutEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LambdaFunctionTimedOutEventDetails`](crate::model::LambdaFunctionTimedOutEventDetails)
pub mod lambda_function_timed_out_event_details {
    /// A builder for [`LambdaFunctionTimedOutEventDetails`](crate::model::LambdaFunctionTimedOutEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionTimedOutEventDetails`](crate::model::LambdaFunctionTimedOutEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionTimedOutEventDetails {
            crate::model::LambdaFunctionTimedOutEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl LambdaFunctionTimedOutEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionTimedOutEventDetails`](crate::model::LambdaFunctionTimedOutEventDetails)
    pub fn builder() -> crate::model::lambda_function_timed_out_event_details::Builder {
        crate::model::lambda_function_timed_out_event_details::Builder::default()
    }
}

/// <p>Contains details about a lambda function that successfully terminated during an
/// execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionSucceededEventDetails {
    /// <p>The JSON data output by the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl LambdaFunctionSucceededEventDetails {
    /// <p>The JSON data output by the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for LambdaFunctionSucceededEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionSucceededEventDetails");
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`LambdaFunctionSucceededEventDetails`](crate::model::LambdaFunctionSucceededEventDetails)
pub mod lambda_function_succeeded_event_details {
    /// A builder for [`LambdaFunctionSucceededEventDetails`](crate::model::LambdaFunctionSucceededEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The JSON data output by the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON data output by the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionSucceededEventDetails`](crate::model::LambdaFunctionSucceededEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionSucceededEventDetails {
            crate::model::LambdaFunctionSucceededEventDetails {
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl LambdaFunctionSucceededEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionSucceededEventDetails`](crate::model::LambdaFunctionSucceededEventDetails)
    pub fn builder() -> crate::model::lambda_function_succeeded_event_details::Builder {
        crate::model::lambda_function_succeeded_event_details::Builder::default()
    }
}

/// <p>Contains details about a lambda function that failed to start during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionStartFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl LambdaFunctionStartFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionStartFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionStartFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LambdaFunctionStartFailedEventDetails`](crate::model::LambdaFunctionStartFailedEventDetails)
pub mod lambda_function_start_failed_event_details {
    /// A builder for [`LambdaFunctionStartFailedEventDetails`](crate::model::LambdaFunctionStartFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionStartFailedEventDetails`](crate::model::LambdaFunctionStartFailedEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionStartFailedEventDetails {
            crate::model::LambdaFunctionStartFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl LambdaFunctionStartFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionStartFailedEventDetails`](crate::model::LambdaFunctionStartFailedEventDetails)
    pub fn builder() -> crate::model::lambda_function_start_failed_event_details::Builder {
        crate::model::lambda_function_start_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about a lambda function scheduled during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionScheduledEventDetails {
    /// <p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The JSON data input to the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Contains details about input for an execution history event.</p>
    pub input_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    /// <p>The maximum allowed duration of the lambda function.</p>
    pub timeout_in_seconds: std::option::Option<i64>,
}
impl LambdaFunctionScheduledEventDetails {
    /// <p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The JSON data input to the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Contains details about input for an execution history event.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.input_details.as_ref()
    }
    /// <p>The maximum allowed duration of the lambda function.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i64> {
        self.timeout_in_seconds
    }
}
impl std::fmt::Debug for LambdaFunctionScheduledEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionScheduledEventDetails");
        formatter.field("resource", &self.resource);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.finish()
    }
}
/// See [`LambdaFunctionScheduledEventDetails`](crate::model::LambdaFunctionScheduledEventDetails)
pub mod lambda_function_scheduled_event_details {
    /// A builder for [`LambdaFunctionScheduledEventDetails`](crate::model::LambdaFunctionScheduledEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        pub(crate) timeout_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The JSON data input to the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The JSON data input to the lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Contains details about input for an execution history event.</p>
        pub fn input_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Contains details about input for an execution history event.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// <p>The maximum allowed duration of the lambda function.</p>
        pub fn timeout_in_seconds(mut self, input: i64) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum allowed duration of the lambda function.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionScheduledEventDetails`](crate::model::LambdaFunctionScheduledEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionScheduledEventDetails {
            crate::model::LambdaFunctionScheduledEventDetails {
                resource: self.resource,
                input: self.input,
                input_details: self.input_details,
                timeout_in_seconds: self.timeout_in_seconds,
            }
        }
    }
}
impl LambdaFunctionScheduledEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionScheduledEventDetails`](crate::model::LambdaFunctionScheduledEventDetails)
    pub fn builder() -> crate::model::lambda_function_scheduled_event_details::Builder {
        crate::model::lambda_function_scheduled_event_details::Builder::default()
    }
}

/// <p>Contains details about a failed lambda function schedule event that occurred during an
/// execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionScheduleFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl LambdaFunctionScheduleFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionScheduleFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionScheduleFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LambdaFunctionScheduleFailedEventDetails`](crate::model::LambdaFunctionScheduleFailedEventDetails)
pub mod lambda_function_schedule_failed_event_details {
    /// A builder for [`LambdaFunctionScheduleFailedEventDetails`](crate::model::LambdaFunctionScheduleFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionScheduleFailedEventDetails`](crate::model::LambdaFunctionScheduleFailedEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionScheduleFailedEventDetails {
            crate::model::LambdaFunctionScheduleFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl LambdaFunctionScheduleFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionScheduleFailedEventDetails`](crate::model::LambdaFunctionScheduleFailedEventDetails)
    pub fn builder() -> crate::model::lambda_function_schedule_failed_event_details::Builder {
        crate::model::lambda_function_schedule_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about a lambda function that failed during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl LambdaFunctionFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for LambdaFunctionFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`LambdaFunctionFailedEventDetails`](crate::model::LambdaFunctionFailedEventDetails)
pub mod lambda_function_failed_event_details {
    /// A builder for [`LambdaFunctionFailedEventDetails`](crate::model::LambdaFunctionFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionFailedEventDetails`](crate::model::LambdaFunctionFailedEventDetails)
        pub fn build(self) -> crate::model::LambdaFunctionFailedEventDetails {
            crate::model::LambdaFunctionFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl LambdaFunctionFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionFailedEventDetails`](crate::model::LambdaFunctionFailedEventDetails)
    pub fn builder() -> crate::model::lambda_function_failed_event_details::Builder {
        crate::model::lambda_function_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about an iteration of a Map state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MapIterationEventDetails {
    /// <p>The name of the iteration’s parent Map state.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The index of the array belonging to the Map state iteration.</p>
    pub index: i32,
}
impl MapIterationEventDetails {
    /// <p>The name of the iteration’s parent Map state.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The index of the array belonging to the Map state iteration.</p>
    pub fn index(&self) -> i32 {
        self.index
    }
}
impl std::fmt::Debug for MapIterationEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MapIterationEventDetails");
        formatter.field("name", &self.name);
        formatter.field("index", &self.index);
        formatter.finish()
    }
}
/// See [`MapIterationEventDetails`](crate::model::MapIterationEventDetails)
pub mod map_iteration_event_details {
    /// A builder for [`MapIterationEventDetails`](crate::model::MapIterationEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the iteration’s parent Map state.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the iteration’s parent Map state.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The index of the array belonging to the Map state iteration.</p>
        pub fn index(mut self, input: i32) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>The index of the array belonging to the Map state iteration.</p>
        pub fn set_index(mut self, input: std::option::Option<i32>) -> Self {
            self.index = input;
            self
        }
        /// Consumes the builder and constructs a [`MapIterationEventDetails`](crate::model::MapIterationEventDetails)
        pub fn build(self) -> crate::model::MapIterationEventDetails {
            crate::model::MapIterationEventDetails {
                name: self.name,
                index: self.index.unwrap_or_default(),
            }
        }
    }
}
impl MapIterationEventDetails {
    /// Creates a new builder-style object to manufacture [`MapIterationEventDetails`](crate::model::MapIterationEventDetails)
    pub fn builder() -> crate::model::map_iteration_event_details::Builder {
        crate::model::map_iteration_event_details::Builder::default()
    }
}

/// <p>Details about a Map state that was started.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MapStateStartedEventDetails {
    /// <p>The size of the array for Map state iterations.</p>
    pub length: i32,
}
impl MapStateStartedEventDetails {
    /// <p>The size of the array for Map state iterations.</p>
    pub fn length(&self) -> i32 {
        self.length
    }
}
impl std::fmt::Debug for MapStateStartedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MapStateStartedEventDetails");
        formatter.field("length", &self.length);
        formatter.finish()
    }
}
/// See [`MapStateStartedEventDetails`](crate::model::MapStateStartedEventDetails)
pub mod map_state_started_event_details {
    /// A builder for [`MapStateStartedEventDetails`](crate::model::MapStateStartedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) length: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The size of the array for Map state iterations.</p>
        pub fn length(mut self, input: i32) -> Self {
            self.length = Some(input);
            self
        }
        /// <p>The size of the array for Map state iterations.</p>
        pub fn set_length(mut self, input: std::option::Option<i32>) -> Self {
            self.length = input;
            self
        }
        /// Consumes the builder and constructs a [`MapStateStartedEventDetails`](crate::model::MapStateStartedEventDetails)
        pub fn build(self) -> crate::model::MapStateStartedEventDetails {
            crate::model::MapStateStartedEventDetails {
                length: self.length.unwrap_or_default(),
            }
        }
    }
}
impl MapStateStartedEventDetails {
    /// Creates a new builder-style object to manufacture [`MapStateStartedEventDetails`](crate::model::MapStateStartedEventDetails)
    pub fn builder() -> crate::model::map_state_started_event_details::Builder {
        crate::model::map_state_started_event_details::Builder::default()
    }
}

/// <p>Contains details about the execution timeout that occurred during the execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ExecutionTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ExecutionTimedOutEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionTimedOutEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ExecutionTimedOutEventDetails`](crate::model::ExecutionTimedOutEventDetails)
pub mod execution_timed_out_event_details {
    /// A builder for [`ExecutionTimedOutEventDetails`](crate::model::ExecutionTimedOutEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionTimedOutEventDetails`](crate::model::ExecutionTimedOutEventDetails)
        pub fn build(self) -> crate::model::ExecutionTimedOutEventDetails {
            crate::model::ExecutionTimedOutEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ExecutionTimedOutEventDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionTimedOutEventDetails`](crate::model::ExecutionTimedOutEventDetails)
    pub fn builder() -> crate::model::execution_timed_out_event_details::Builder {
        crate::model::execution_timed_out_event_details::Builder::default()
    }
}

/// <p>Contains details about an abort of an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionAbortedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ExecutionAbortedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ExecutionAbortedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionAbortedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ExecutionAbortedEventDetails`](crate::model::ExecutionAbortedEventDetails)
pub mod execution_aborted_event_details {
    /// A builder for [`ExecutionAbortedEventDetails`](crate::model::ExecutionAbortedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionAbortedEventDetails`](crate::model::ExecutionAbortedEventDetails)
        pub fn build(self) -> crate::model::ExecutionAbortedEventDetails {
            crate::model::ExecutionAbortedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ExecutionAbortedEventDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionAbortedEventDetails`](crate::model::ExecutionAbortedEventDetails)
    pub fn builder() -> crate::model::execution_aborted_event_details::Builder {
        crate::model::execution_aborted_event_details::Builder::default()
    }
}

/// <p>Contains details about the successful termination of the execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionSucceededEventDetails {
    /// <p>The JSON data output by the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl ExecutionSucceededEventDetails {
    /// <p>The JSON data output by the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for ExecutionSucceededEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionSucceededEventDetails");
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`ExecutionSucceededEventDetails`](crate::model::ExecutionSucceededEventDetails)
pub mod execution_succeeded_event_details {
    /// A builder for [`ExecutionSucceededEventDetails`](crate::model::ExecutionSucceededEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The JSON data output by the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON data output by the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionSucceededEventDetails`](crate::model::ExecutionSucceededEventDetails)
        pub fn build(self) -> crate::model::ExecutionSucceededEventDetails {
            crate::model::ExecutionSucceededEventDetails {
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl ExecutionSucceededEventDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionSucceededEventDetails`](crate::model::ExecutionSucceededEventDetails)
    pub fn builder() -> crate::model::execution_succeeded_event_details::Builder {
        crate::model::execution_succeeded_event_details::Builder::default()
    }
}

/// <p>Contains details about the start of the execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionStartedEventDetails {
    /// <p>The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Contains details about the input for an execution history event.</p>
    pub input_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl ExecutionStartedEventDetails {
    /// <p>The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Contains details about the input for an execution history event.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.input_details.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for ExecutionStartedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionStartedEventDetails");
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`ExecutionStartedEventDetails`](crate::model::ExecutionStartedEventDetails)
pub mod execution_started_event_details {
    /// A builder for [`ExecutionStartedEventDetails`](crate::model::ExecutionStartedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn input_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionStartedEventDetails`](crate::model::ExecutionStartedEventDetails)
        pub fn build(self) -> crate::model::ExecutionStartedEventDetails {
            crate::model::ExecutionStartedEventDetails {
                input: self.input,
                input_details: self.input_details,
                role_arn: self.role_arn,
            }
        }
    }
}
impl ExecutionStartedEventDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionStartedEventDetails`](crate::model::ExecutionStartedEventDetails)
    pub fn builder() -> crate::model::execution_started_event_details::Builder {
        crate::model::execution_started_event_details::Builder::default()
    }
}

/// <p>Contains details about an execution failure event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ExecutionFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ExecutionFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ExecutionFailedEventDetails`](crate::model::ExecutionFailedEventDetails)
pub mod execution_failed_event_details {
    /// A builder for [`ExecutionFailedEventDetails`](crate::model::ExecutionFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionFailedEventDetails`](crate::model::ExecutionFailedEventDetails)
        pub fn build(self) -> crate::model::ExecutionFailedEventDetails {
            crate::model::ExecutionFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ExecutionFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`ExecutionFailedEventDetails`](crate::model::ExecutionFailedEventDetails)
    pub fn builder() -> crate::model::execution_failed_event_details::Builder {
        crate::model::execution_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about a resource timeout that occurred during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskTimedOutEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl TaskTimedOutEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for TaskTimedOutEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskTimedOutEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TaskTimedOutEventDetails`](crate::model::TaskTimedOutEventDetails)
pub mod task_timed_out_event_details {
    /// A builder for [`TaskTimedOutEventDetails`](crate::model::TaskTimedOutEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskTimedOutEventDetails`](crate::model::TaskTimedOutEventDetails)
        pub fn build(self) -> crate::model::TaskTimedOutEventDetails {
            crate::model::TaskTimedOutEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl TaskTimedOutEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskTimedOutEventDetails`](crate::model::TaskTimedOutEventDetails)
    pub fn builder() -> crate::model::task_timed_out_event_details::Builder {
        crate::model::task_timed_out_event_details::Builder::default()
    }
}

/// <p>Contains details about the successful completion of a task state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSucceededEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The full JSON response from a resource when a task has succeeded. This response becomes
    /// the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl TaskSucceededEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The full JSON response from a resource when a task has succeeded. This response becomes
    /// the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for TaskSucceededEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSucceededEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`TaskSucceededEventDetails`](crate::model::TaskSucceededEventDetails)
pub mod task_succeeded_event_details {
    /// A builder for [`TaskSucceededEventDetails`](crate::model::TaskSucceededEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The full JSON response from a resource when a task has succeeded. This response becomes
        /// the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The full JSON response from a resource when a task has succeeded. This response becomes
        /// the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSucceededEventDetails`](crate::model::TaskSucceededEventDetails)
        pub fn build(self) -> crate::model::TaskSucceededEventDetails {
            crate::model::TaskSucceededEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl TaskSucceededEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskSucceededEventDetails`](crate::model::TaskSucceededEventDetails)
    pub fn builder() -> crate::model::task_succeeded_event_details::Builder {
        crate::model::task_succeeded_event_details::Builder::default()
    }
}

/// <p>Contains details about a task submitted to a resource .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSubmittedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl TaskSubmittedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for TaskSubmittedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSubmittedEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`TaskSubmittedEventDetails`](crate::model::TaskSubmittedEventDetails)
pub mod task_submitted_event_details {
    /// A builder for [`TaskSubmittedEventDetails`](crate::model::TaskSubmittedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSubmittedEventDetails`](crate::model::TaskSubmittedEventDetails)
        pub fn build(self) -> crate::model::TaskSubmittedEventDetails {
            crate::model::TaskSubmittedEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl TaskSubmittedEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskSubmittedEventDetails`](crate::model::TaskSubmittedEventDetails)
    pub fn builder() -> crate::model::task_submitted_event_details::Builder {
        crate::model::task_submitted_event_details::Builder::default()
    }
}

/// <p>Contains details about a task that failed to submit during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSubmitFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl TaskSubmitFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for TaskSubmitFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSubmitFailedEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TaskSubmitFailedEventDetails`](crate::model::TaskSubmitFailedEventDetails)
pub mod task_submit_failed_event_details {
    /// A builder for [`TaskSubmitFailedEventDetails`](crate::model::TaskSubmitFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSubmitFailedEventDetails`](crate::model::TaskSubmitFailedEventDetails)
        pub fn build(self) -> crate::model::TaskSubmitFailedEventDetails {
            crate::model::TaskSubmitFailedEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl TaskSubmitFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskSubmitFailedEventDetails`](crate::model::TaskSubmitFailedEventDetails)
    pub fn builder() -> crate::model::task_submit_failed_event_details::Builder {
        crate::model::task_submit_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about the start of a task during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskStartedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
}
impl TaskStartedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
}
impl std::fmt::Debug for TaskStartedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskStartedEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}
/// See [`TaskStartedEventDetails`](crate::model::TaskStartedEventDetails)
pub mod task_started_event_details {
    /// A builder for [`TaskStartedEventDetails`](crate::model::TaskStartedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskStartedEventDetails`](crate::model::TaskStartedEventDetails)
        pub fn build(self) -> crate::model::TaskStartedEventDetails {
            crate::model::TaskStartedEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
            }
        }
    }
}
impl TaskStartedEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskStartedEventDetails`](crate::model::TaskStartedEventDetails)
    pub fn builder() -> crate::model::task_started_event_details::Builder {
        crate::model::task_started_event_details::Builder::default()
    }
}

/// <p>Contains details about a task that failed to start during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskStartFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl TaskStartFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for TaskStartFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskStartFailedEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TaskStartFailedEventDetails`](crate::model::TaskStartFailedEventDetails)
pub mod task_start_failed_event_details {
    /// A builder for [`TaskStartFailedEventDetails`](crate::model::TaskStartFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskStartFailedEventDetails`](crate::model::TaskStartFailedEventDetails)
        pub fn build(self) -> crate::model::TaskStartFailedEventDetails {
            crate::model::TaskStartFailedEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl TaskStartFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskStartFailedEventDetails`](crate::model::TaskStartFailedEventDetails)
    pub fn builder() -> crate::model::task_start_failed_event_details::Builder {
        crate::model::task_start_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about a task scheduled during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskScheduledEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The region of the scheduled task</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The JSON data passed to the resource referenced in a task state.
    /// Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub parameters: std::option::Option<std::string::String>,
    /// <p>The maximum allowed duration of the task.</p>
    pub timeout_in_seconds: std::option::Option<i64>,
    /// <p>The maximum allowed duration between two heartbeats for the task.</p>
    pub heartbeat_in_seconds: std::option::Option<i64>,
}
impl TaskScheduledEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The region of the scheduled task</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The JSON data passed to the resource referenced in a task state.
    /// Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn parameters(&self) -> std::option::Option<&str> {
        self.parameters.as_deref()
    }
    /// <p>The maximum allowed duration of the task.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i64> {
        self.timeout_in_seconds
    }
    /// <p>The maximum allowed duration between two heartbeats for the task.</p>
    pub fn heartbeat_in_seconds(&self) -> std::option::Option<i64> {
        self.heartbeat_in_seconds
    }
}
impl std::fmt::Debug for TaskScheduledEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskScheduledEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("region", &self.region);
        formatter.field("parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("heartbeat_in_seconds", &self.heartbeat_in_seconds);
        formatter.finish()
    }
}
/// See [`TaskScheduledEventDetails`](crate::model::TaskScheduledEventDetails)
pub mod task_scheduled_event_details {
    /// A builder for [`TaskScheduledEventDetails`](crate::model::TaskScheduledEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::string::String>,
        pub(crate) timeout_in_seconds: std::option::Option<i64>,
        pub(crate) heartbeat_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The region of the scheduled task</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The region of the scheduled task</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The JSON data passed to the resource referenced in a task state.
        /// Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>The JSON data passed to the resource referenced in a task state.
        /// Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The maximum allowed duration of the task.</p>
        pub fn timeout_in_seconds(mut self, input: i64) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum allowed duration of the task.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The maximum allowed duration between two heartbeats for the task.</p>
        pub fn heartbeat_in_seconds(mut self, input: i64) -> Self {
            self.heartbeat_in_seconds = Some(input);
            self
        }
        /// <p>The maximum allowed duration between two heartbeats for the task.</p>
        pub fn set_heartbeat_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.heartbeat_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskScheduledEventDetails`](crate::model::TaskScheduledEventDetails)
        pub fn build(self) -> crate::model::TaskScheduledEventDetails {
            crate::model::TaskScheduledEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                region: self.region,
                parameters: self.parameters,
                timeout_in_seconds: self.timeout_in_seconds,
                heartbeat_in_seconds: self.heartbeat_in_seconds,
            }
        }
    }
}
impl TaskScheduledEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskScheduledEventDetails`](crate::model::TaskScheduledEventDetails)
    pub fn builder() -> crate::model::task_scheduled_event_details::Builder {
        crate::model::task_scheduled_event_details::Builder::default()
    }
}

/// <p>Contains details about a task failure event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The service name of the resource in a task state.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl TaskFailedEventDetails {
    /// <p>The action of the resource called by a task state.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The service name of the resource in a task state.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for TaskFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskFailedEventDetails");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource", &self.resource);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`TaskFailedEventDetails`](crate::model::TaskFailedEventDetails)
pub mod task_failed_event_details {
    /// A builder for [`TaskFailedEventDetails`](crate::model::TaskFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action of the resource called by a task state.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The action of the resource called by a task state.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The service name of the resource in a task state.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskFailedEventDetails`](crate::model::TaskFailedEventDetails)
        pub fn build(self) -> crate::model::TaskFailedEventDetails {
            crate::model::TaskFailedEventDetails {
                resource_type: self.resource_type,
                resource: self.resource,
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl TaskFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`TaskFailedEventDetails`](crate::model::TaskFailedEventDetails)
    pub fn builder() -> crate::model::task_failed_event_details::Builder {
        crate::model::task_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about an activity timeout that occurred during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ActivityTimedOutEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the timeout.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ActivityTimedOutEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityTimedOutEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ActivityTimedOutEventDetails`](crate::model::ActivityTimedOutEventDetails)
pub mod activity_timed_out_event_details {
    /// A builder for [`ActivityTimedOutEventDetails`](crate::model::ActivityTimedOutEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the timeout.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityTimedOutEventDetails`](crate::model::ActivityTimedOutEventDetails)
        pub fn build(self) -> crate::model::ActivityTimedOutEventDetails {
            crate::model::ActivityTimedOutEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ActivityTimedOutEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivityTimedOutEventDetails`](crate::model::ActivityTimedOutEventDetails)
    pub fn builder() -> crate::model::activity_timed_out_event_details::Builder {
        crate::model::activity_timed_out_event_details::Builder::default()
    }
}

/// <p>Contains details about an activity that successfully terminated during an
/// execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivitySucceededEventDetails {
    /// <p>The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>Contains details about the output of an execution history event.</p>
    pub output_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
}
impl ActivitySucceededEventDetails {
    /// <p>The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
    /// <p>Contains details about the output of an execution history event.</p>
    pub fn output_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.output_details.as_ref()
    }
}
impl std::fmt::Debug for ActivitySucceededEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivitySucceededEventDetails");
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.field("output_details", &self.output_details);
        formatter.finish()
    }
}
/// See [`ActivitySucceededEventDetails`](crate::model::ActivitySucceededEventDetails)
pub mod activity_succeeded_event_details {
    /// A builder for [`ActivitySucceededEventDetails`](crate::model::ActivitySucceededEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) output_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    }
    impl Builder {
        /// <p>The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn output_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.output_details = Some(input);
            self
        }
        /// <p>Contains details about the output of an execution history event.</p>
        pub fn set_output_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.output_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivitySucceededEventDetails`](crate::model::ActivitySucceededEventDetails)
        pub fn build(self) -> crate::model::ActivitySucceededEventDetails {
            crate::model::ActivitySucceededEventDetails {
                output: self.output,
                output_details: self.output_details,
            }
        }
    }
}
impl ActivitySucceededEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivitySucceededEventDetails`](crate::model::ActivitySucceededEventDetails)
    pub fn builder() -> crate::model::activity_succeeded_event_details::Builder {
        crate::model::activity_succeeded_event_details::Builder::default()
    }
}

/// <p>Contains details about the start of an activity during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityStartedEventDetails {
    /// <p>The name of the worker that the task is assigned to. These names are provided by the
    /// workers when calling <a>GetActivityTask</a>.</p>
    pub worker_name: std::option::Option<std::string::String>,
}
impl ActivityStartedEventDetails {
    /// <p>The name of the worker that the task is assigned to. These names are provided by the
    /// workers when calling <a>GetActivityTask</a>.</p>
    pub fn worker_name(&self) -> std::option::Option<&str> {
        self.worker_name.as_deref()
    }
}
impl std::fmt::Debug for ActivityStartedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityStartedEventDetails");
        formatter.field("worker_name", &self.worker_name);
        formatter.finish()
    }
}
/// See [`ActivityStartedEventDetails`](crate::model::ActivityStartedEventDetails)
pub mod activity_started_event_details {
    /// A builder for [`ActivityStartedEventDetails`](crate::model::ActivityStartedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worker_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the worker that the task is assigned to. These names are provided by the
        /// workers when calling <a>GetActivityTask</a>.</p>
        pub fn worker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_name = Some(input.into());
            self
        }
        /// <p>The name of the worker that the task is assigned to. These names are provided by the
        /// workers when calling <a>GetActivityTask</a>.</p>
        pub fn set_worker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityStartedEventDetails`](crate::model::ActivityStartedEventDetails)
        pub fn build(self) -> crate::model::ActivityStartedEventDetails {
            crate::model::ActivityStartedEventDetails {
                worker_name: self.worker_name,
            }
        }
    }
}
impl ActivityStartedEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivityStartedEventDetails`](crate::model::ActivityStartedEventDetails)
    pub fn builder() -> crate::model::activity_started_event_details::Builder {
        crate::model::activity_started_event_details::Builder::default()
    }
}

/// <p>Contains details about an activity scheduled during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityScheduledEventDetails {
    /// <p>The Amazon Resource Name (ARN) of the scheduled activity.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Contains details about the input for an execution history event.</p>
    pub input_details: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
    /// <p>The maximum allowed duration of the activity task.</p>
    pub timeout_in_seconds: std::option::Option<i64>,
    /// <p>The maximum allowed duration between two heartbeats for the activity task.</p>
    pub heartbeat_in_seconds: std::option::Option<i64>,
}
impl ActivityScheduledEventDetails {
    /// <p>The Amazon Resource Name (ARN) of the scheduled activity.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Contains details about the input for an execution history event.</p>
    pub fn input_details(
        &self,
    ) -> std::option::Option<&crate::model::HistoryEventExecutionDataDetails> {
        self.input_details.as_ref()
    }
    /// <p>The maximum allowed duration of the activity task.</p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i64> {
        self.timeout_in_seconds
    }
    /// <p>The maximum allowed duration between two heartbeats for the activity task.</p>
    pub fn heartbeat_in_seconds(&self) -> std::option::Option<i64> {
        self.heartbeat_in_seconds
    }
}
impl std::fmt::Debug for ActivityScheduledEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityScheduledEventDetails");
        formatter.field("resource", &self.resource);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("input_details", &self.input_details);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("heartbeat_in_seconds", &self.heartbeat_in_seconds);
        formatter.finish()
    }
}
/// See [`ActivityScheduledEventDetails`](crate::model::ActivityScheduledEventDetails)
pub mod activity_scheduled_event_details {
    /// A builder for [`ActivityScheduledEventDetails`](crate::model::ActivityScheduledEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_details:
            std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        pub(crate) timeout_in_seconds: std::option::Option<i64>,
        pub(crate) heartbeat_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the scheduled activity.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled activity.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn input_details(
            mut self,
            input: crate::model::HistoryEventExecutionDataDetails,
        ) -> Self {
            self.input_details = Some(input);
            self
        }
        /// <p>Contains details about the input for an execution history event.</p>
        pub fn set_input_details(
            mut self,
            input: std::option::Option<crate::model::HistoryEventExecutionDataDetails>,
        ) -> Self {
            self.input_details = input;
            self
        }
        /// <p>The maximum allowed duration of the activity task.</p>
        pub fn timeout_in_seconds(mut self, input: i64) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum allowed duration of the activity task.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The maximum allowed duration between two heartbeats for the activity task.</p>
        pub fn heartbeat_in_seconds(mut self, input: i64) -> Self {
            self.heartbeat_in_seconds = Some(input);
            self
        }
        /// <p>The maximum allowed duration between two heartbeats for the activity task.</p>
        pub fn set_heartbeat_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.heartbeat_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityScheduledEventDetails`](crate::model::ActivityScheduledEventDetails)
        pub fn build(self) -> crate::model::ActivityScheduledEventDetails {
            crate::model::ActivityScheduledEventDetails {
                resource: self.resource,
                input: self.input,
                input_details: self.input_details,
                timeout_in_seconds: self.timeout_in_seconds,
                heartbeat_in_seconds: self.heartbeat_in_seconds,
            }
        }
    }
}
impl ActivityScheduledEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivityScheduledEventDetails`](crate::model::ActivityScheduledEventDetails)
    pub fn builder() -> crate::model::activity_scheduled_event_details::Builder {
        crate::model::activity_scheduled_event_details::Builder::default()
    }
}

/// <p>Contains details about an activity schedule failure that occurred during an
/// execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityScheduleFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ActivityScheduleFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ActivityScheduleFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityScheduleFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ActivityScheduleFailedEventDetails`](crate::model::ActivityScheduleFailedEventDetails)
pub mod activity_schedule_failed_event_details {
    /// A builder for [`ActivityScheduleFailedEventDetails`](crate::model::ActivityScheduleFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityScheduleFailedEventDetails`](crate::model::ActivityScheduleFailedEventDetails)
        pub fn build(self) -> crate::model::ActivityScheduleFailedEventDetails {
            crate::model::ActivityScheduleFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ActivityScheduleFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivityScheduleFailedEventDetails`](crate::model::ActivityScheduleFailedEventDetails)
    pub fn builder() -> crate::model::activity_schedule_failed_event_details::Builder {
        crate::model::activity_schedule_failed_event_details::Builder::default()
    }
}

/// <p>Contains details about an activity that failed during an execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl ActivityFailedEventDetails {
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for ActivityFailedEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityFailedEventDetails");
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ActivityFailedEventDetails`](crate::model::ActivityFailedEventDetails)
pub mod activity_failed_event_details {
    /// A builder for [`ActivityFailedEventDetails`](crate::model::ActivityFailedEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityFailedEventDetails`](crate::model::ActivityFailedEventDetails)
        pub fn build(self) -> crate::model::ActivityFailedEventDetails {
            crate::model::ActivityFailedEventDetails {
                error: self.error,
                cause: self.cause,
            }
        }
    }
}
impl ActivityFailedEventDetails {
    /// Creates a new builder-style object to manufacture [`ActivityFailedEventDetails`](crate::model::ActivityFailedEventDetails)
    pub fn builder() -> crate::model::activity_failed_event_details::Builder {
        crate::model::activity_failed_event_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HistoryEventType {
    #[allow(missing_docs)] // documentation missing in model
    ActivityFailed,
    #[allow(missing_docs)] // documentation missing in model
    ActivityScheduleFailed,
    #[allow(missing_docs)] // documentation missing in model
    ActivityScheduled,
    #[allow(missing_docs)] // documentation missing in model
    ActivityStarted,
    #[allow(missing_docs)] // documentation missing in model
    ActivitySucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ActivityTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    ChoiceStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    ChoiceStateExited,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionAborted,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionFailed,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionStarted,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    FailStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionFailed,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionScheduleFailed,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionScheduled,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionStartFailed,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionStarted,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    LambdaFunctionTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    MapIterationAborted,
    #[allow(missing_docs)] // documentation missing in model
    MapIterationFailed,
    #[allow(missing_docs)] // documentation missing in model
    MapIterationStarted,
    #[allow(missing_docs)] // documentation missing in model
    MapIterationSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    MapStateAborted,
    #[allow(missing_docs)] // documentation missing in model
    MapStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    MapStateExited,
    #[allow(missing_docs)] // documentation missing in model
    MapStateFailed,
    #[allow(missing_docs)] // documentation missing in model
    MapStateStarted,
    #[allow(missing_docs)] // documentation missing in model
    MapStateSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateAborted,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateExited,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateFailed,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateStarted,
    #[allow(missing_docs)] // documentation missing in model
    ParallelStateSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    PassStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    PassStateExited,
    #[allow(missing_docs)] // documentation missing in model
    SucceedStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    SucceedStateExited,
    #[allow(missing_docs)] // documentation missing in model
    TaskFailed,
    #[allow(missing_docs)] // documentation missing in model
    TaskScheduled,
    #[allow(missing_docs)] // documentation missing in model
    TaskStartFailed,
    #[allow(missing_docs)] // documentation missing in model
    TaskStarted,
    #[allow(missing_docs)] // documentation missing in model
    TaskStateAborted,
    #[allow(missing_docs)] // documentation missing in model
    TaskStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    TaskStateExited,
    #[allow(missing_docs)] // documentation missing in model
    TaskSubmitFailed,
    #[allow(missing_docs)] // documentation missing in model
    TaskSubmitted,
    #[allow(missing_docs)] // documentation missing in model
    TaskSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    TaskTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    WaitStateAborted,
    #[allow(missing_docs)] // documentation missing in model
    WaitStateEntered,
    #[allow(missing_docs)] // documentation missing in model
    WaitStateExited,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HistoryEventType {
    fn from(s: &str) -> Self {
        match s {
            "ActivityFailed" => HistoryEventType::ActivityFailed,
            "ActivityScheduleFailed" => HistoryEventType::ActivityScheduleFailed,
            "ActivityScheduled" => HistoryEventType::ActivityScheduled,
            "ActivityStarted" => HistoryEventType::ActivityStarted,
            "ActivitySucceeded" => HistoryEventType::ActivitySucceeded,
            "ActivityTimedOut" => HistoryEventType::ActivityTimedOut,
            "ChoiceStateEntered" => HistoryEventType::ChoiceStateEntered,
            "ChoiceStateExited" => HistoryEventType::ChoiceStateExited,
            "ExecutionAborted" => HistoryEventType::ExecutionAborted,
            "ExecutionFailed" => HistoryEventType::ExecutionFailed,
            "ExecutionStarted" => HistoryEventType::ExecutionStarted,
            "ExecutionSucceeded" => HistoryEventType::ExecutionSucceeded,
            "ExecutionTimedOut" => HistoryEventType::ExecutionTimedOut,
            "FailStateEntered" => HistoryEventType::FailStateEntered,
            "LambdaFunctionFailed" => HistoryEventType::LambdaFunctionFailed,
            "LambdaFunctionScheduleFailed" => HistoryEventType::LambdaFunctionScheduleFailed,
            "LambdaFunctionScheduled" => HistoryEventType::LambdaFunctionScheduled,
            "LambdaFunctionStartFailed" => HistoryEventType::LambdaFunctionStartFailed,
            "LambdaFunctionStarted" => HistoryEventType::LambdaFunctionStarted,
            "LambdaFunctionSucceeded" => HistoryEventType::LambdaFunctionSucceeded,
            "LambdaFunctionTimedOut" => HistoryEventType::LambdaFunctionTimedOut,
            "MapIterationAborted" => HistoryEventType::MapIterationAborted,
            "MapIterationFailed" => HistoryEventType::MapIterationFailed,
            "MapIterationStarted" => HistoryEventType::MapIterationStarted,
            "MapIterationSucceeded" => HistoryEventType::MapIterationSucceeded,
            "MapStateAborted" => HistoryEventType::MapStateAborted,
            "MapStateEntered" => HistoryEventType::MapStateEntered,
            "MapStateExited" => HistoryEventType::MapStateExited,
            "MapStateFailed" => HistoryEventType::MapStateFailed,
            "MapStateStarted" => HistoryEventType::MapStateStarted,
            "MapStateSucceeded" => HistoryEventType::MapStateSucceeded,
            "ParallelStateAborted" => HistoryEventType::ParallelStateAborted,
            "ParallelStateEntered" => HistoryEventType::ParallelStateEntered,
            "ParallelStateExited" => HistoryEventType::ParallelStateExited,
            "ParallelStateFailed" => HistoryEventType::ParallelStateFailed,
            "ParallelStateStarted" => HistoryEventType::ParallelStateStarted,
            "ParallelStateSucceeded" => HistoryEventType::ParallelStateSucceeded,
            "PassStateEntered" => HistoryEventType::PassStateEntered,
            "PassStateExited" => HistoryEventType::PassStateExited,
            "SucceedStateEntered" => HistoryEventType::SucceedStateEntered,
            "SucceedStateExited" => HistoryEventType::SucceedStateExited,
            "TaskFailed" => HistoryEventType::TaskFailed,
            "TaskScheduled" => HistoryEventType::TaskScheduled,
            "TaskStartFailed" => HistoryEventType::TaskStartFailed,
            "TaskStarted" => HistoryEventType::TaskStarted,
            "TaskStateAborted" => HistoryEventType::TaskStateAborted,
            "TaskStateEntered" => HistoryEventType::TaskStateEntered,
            "TaskStateExited" => HistoryEventType::TaskStateExited,
            "TaskSubmitFailed" => HistoryEventType::TaskSubmitFailed,
            "TaskSubmitted" => HistoryEventType::TaskSubmitted,
            "TaskSucceeded" => HistoryEventType::TaskSucceeded,
            "TaskTimedOut" => HistoryEventType::TaskTimedOut,
            "WaitStateAborted" => HistoryEventType::WaitStateAborted,
            "WaitStateEntered" => HistoryEventType::WaitStateEntered,
            "WaitStateExited" => HistoryEventType::WaitStateExited,
            other => HistoryEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HistoryEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HistoryEventType::from(s))
    }
}
impl HistoryEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HistoryEventType::ActivityFailed => "ActivityFailed",
            HistoryEventType::ActivityScheduleFailed => "ActivityScheduleFailed",
            HistoryEventType::ActivityScheduled => "ActivityScheduled",
            HistoryEventType::ActivityStarted => "ActivityStarted",
            HistoryEventType::ActivitySucceeded => "ActivitySucceeded",
            HistoryEventType::ActivityTimedOut => "ActivityTimedOut",
            HistoryEventType::ChoiceStateEntered => "ChoiceStateEntered",
            HistoryEventType::ChoiceStateExited => "ChoiceStateExited",
            HistoryEventType::ExecutionAborted => "ExecutionAborted",
            HistoryEventType::ExecutionFailed => "ExecutionFailed",
            HistoryEventType::ExecutionStarted => "ExecutionStarted",
            HistoryEventType::ExecutionSucceeded => "ExecutionSucceeded",
            HistoryEventType::ExecutionTimedOut => "ExecutionTimedOut",
            HistoryEventType::FailStateEntered => "FailStateEntered",
            HistoryEventType::LambdaFunctionFailed => "LambdaFunctionFailed",
            HistoryEventType::LambdaFunctionScheduleFailed => "LambdaFunctionScheduleFailed",
            HistoryEventType::LambdaFunctionScheduled => "LambdaFunctionScheduled",
            HistoryEventType::LambdaFunctionStartFailed => "LambdaFunctionStartFailed",
            HistoryEventType::LambdaFunctionStarted => "LambdaFunctionStarted",
            HistoryEventType::LambdaFunctionSucceeded => "LambdaFunctionSucceeded",
            HistoryEventType::LambdaFunctionTimedOut => "LambdaFunctionTimedOut",
            HistoryEventType::MapIterationAborted => "MapIterationAborted",
            HistoryEventType::MapIterationFailed => "MapIterationFailed",
            HistoryEventType::MapIterationStarted => "MapIterationStarted",
            HistoryEventType::MapIterationSucceeded => "MapIterationSucceeded",
            HistoryEventType::MapStateAborted => "MapStateAborted",
            HistoryEventType::MapStateEntered => "MapStateEntered",
            HistoryEventType::MapStateExited => "MapStateExited",
            HistoryEventType::MapStateFailed => "MapStateFailed",
            HistoryEventType::MapStateStarted => "MapStateStarted",
            HistoryEventType::MapStateSucceeded => "MapStateSucceeded",
            HistoryEventType::ParallelStateAborted => "ParallelStateAborted",
            HistoryEventType::ParallelStateEntered => "ParallelStateEntered",
            HistoryEventType::ParallelStateExited => "ParallelStateExited",
            HistoryEventType::ParallelStateFailed => "ParallelStateFailed",
            HistoryEventType::ParallelStateStarted => "ParallelStateStarted",
            HistoryEventType::ParallelStateSucceeded => "ParallelStateSucceeded",
            HistoryEventType::PassStateEntered => "PassStateEntered",
            HistoryEventType::PassStateExited => "PassStateExited",
            HistoryEventType::SucceedStateEntered => "SucceedStateEntered",
            HistoryEventType::SucceedStateExited => "SucceedStateExited",
            HistoryEventType::TaskFailed => "TaskFailed",
            HistoryEventType::TaskScheduled => "TaskScheduled",
            HistoryEventType::TaskStartFailed => "TaskStartFailed",
            HistoryEventType::TaskStarted => "TaskStarted",
            HistoryEventType::TaskStateAborted => "TaskStateAborted",
            HistoryEventType::TaskStateEntered => "TaskStateEntered",
            HistoryEventType::TaskStateExited => "TaskStateExited",
            HistoryEventType::TaskSubmitFailed => "TaskSubmitFailed",
            HistoryEventType::TaskSubmitted => "TaskSubmitted",
            HistoryEventType::TaskSucceeded => "TaskSucceeded",
            HistoryEventType::TaskTimedOut => "TaskTimedOut",
            HistoryEventType::WaitStateAborted => "WaitStateAborted",
            HistoryEventType::WaitStateEntered => "WaitStateEntered",
            HistoryEventType::WaitStateExited => "WaitStateExited",
            HistoryEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ActivityFailed",
            "ActivityScheduleFailed",
            "ActivityScheduled",
            "ActivityStarted",
            "ActivitySucceeded",
            "ActivityTimedOut",
            "ChoiceStateEntered",
            "ChoiceStateExited",
            "ExecutionAborted",
            "ExecutionFailed",
            "ExecutionStarted",
            "ExecutionSucceeded",
            "ExecutionTimedOut",
            "FailStateEntered",
            "LambdaFunctionFailed",
            "LambdaFunctionScheduleFailed",
            "LambdaFunctionScheduled",
            "LambdaFunctionStartFailed",
            "LambdaFunctionStarted",
            "LambdaFunctionSucceeded",
            "LambdaFunctionTimedOut",
            "MapIterationAborted",
            "MapIterationFailed",
            "MapIterationStarted",
            "MapIterationSucceeded",
            "MapStateAborted",
            "MapStateEntered",
            "MapStateExited",
            "MapStateFailed",
            "MapStateStarted",
            "MapStateSucceeded",
            "ParallelStateAborted",
            "ParallelStateEntered",
            "ParallelStateExited",
            "ParallelStateFailed",
            "ParallelStateStarted",
            "ParallelStateSucceeded",
            "PassStateEntered",
            "PassStateExited",
            "SucceedStateEntered",
            "SucceedStateExited",
            "TaskFailed",
            "TaskScheduled",
            "TaskStartFailed",
            "TaskStarted",
            "TaskStateAborted",
            "TaskStateEntered",
            "TaskStateExited",
            "TaskSubmitFailed",
            "TaskSubmitted",
            "TaskSucceeded",
            "TaskTimedOut",
            "WaitStateAborted",
            "WaitStateEntered",
            "WaitStateExited",
        ]
    }
}
impl AsRef<str> for HistoryEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateMachineStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateMachineStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StateMachineStatus::Active,
            "DELETING" => StateMachineStatus::Deleting,
            other => StateMachineStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateMachineStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateMachineStatus::from(s))
    }
}
impl StateMachineStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateMachineStatus::Active => "ACTIVE",
            StateMachineStatus::Deleting => "DELETING",
            StateMachineStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING"]
    }
}
impl AsRef<str> for StateMachineStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
