// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateActivityInput`](crate::input::CreateActivityInput)
pub mod create_activity_input {
    /// A builder for [`CreateActivityInput`](crate::input::CreateActivityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActivityInput`](crate::input::CreateActivityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateActivityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateActivityInput {
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateActivityInputOperationOutputAlias = crate::operation::CreateActivity;
#[doc(hidden)]
pub type CreateActivityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateActivityInput {
    /// Consumes the builder and constructs an Operation<[`CreateActivity`](crate::operation::CreateActivity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateActivity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateActivityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateActivityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateActivityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.CreateActivity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_activity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateActivity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateActivity",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateActivityInput`](crate::input::CreateActivityInput)
    pub fn builder() -> crate::input::create_activity_input::Builder {
        crate::input::create_activity_input::Builder::default()
    }
}

/// See [`CreateStateMachineInput`](crate::input::CreateStateMachineInput)
pub mod create_state_machine_input {
    /// A builder for [`CreateStateMachineInput`](crate::input::CreateStateMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::StateMachineType>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
    }
    impl Builder {
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is
        /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
        /// has been created.</p>
        pub fn r#type(mut self, input: crate::model::StateMachineType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is
        /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
        /// has been created.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StateMachineType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p>
        /// <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
        /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
        /// Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p>
        /// <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
        /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
        /// Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.tracing_configuration = Some(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.tracing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStateMachineInput`](crate::input::CreateStateMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStateMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStateMachineInput {
                name: self.name,
                definition: self.definition,
                role_arn: self.role_arn,
                r#type: self.r#type,
                logging_configuration: self.logging_configuration,
                tags: self.tags,
                tracing_configuration: self.tracing_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStateMachineInputOperationOutputAlias = crate::operation::CreateStateMachine;
#[doc(hidden)]
pub type CreateStateMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStateMachineInput {
    /// Consumes the builder and constructs an Operation<[`CreateStateMachine`](crate::operation::CreateStateMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStateMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStateMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStateMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStateMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.CreateStateMachine",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_state_machine(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStateMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStateMachine",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStateMachineInput`](crate::input::CreateStateMachineInput)
    pub fn builder() -> crate::input::create_state_machine_input::Builder {
        crate::input::create_state_machine_input::Builder::default()
    }
}

/// See [`DeleteActivityInput`](crate::input::DeleteActivityInput)
pub mod delete_activity_input {
    /// A builder for [`DeleteActivityInput`](crate::input::DeleteActivityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteActivityInput`](crate::input::DeleteActivityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteActivityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteActivityInput {
                activity_arn: self.activity_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteActivityInputOperationOutputAlias = crate::operation::DeleteActivity;
#[doc(hidden)]
pub type DeleteActivityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteActivityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteActivity`](crate::operation::DeleteActivity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteActivity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteActivityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteActivityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteActivityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DeleteActivity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_activity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteActivity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteActivity",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteActivityInput`](crate::input::DeleteActivityInput)
    pub fn builder() -> crate::input::delete_activity_input::Builder {
        crate::input::delete_activity_input::Builder::default()
    }
}

/// See [`DeleteStateMachineInput`](crate::input::DeleteStateMachineInput)
pub mod delete_state_machine_input {
    /// A builder for [`DeleteStateMachineInput`](crate::input::DeleteStateMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStateMachineInput`](crate::input::DeleteStateMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStateMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStateMachineInput {
                state_machine_arn: self.state_machine_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStateMachineInputOperationOutputAlias = crate::operation::DeleteStateMachine;
#[doc(hidden)]
pub type DeleteStateMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStateMachineInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStateMachine`](crate::operation::DeleteStateMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStateMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStateMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStateMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStateMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DeleteStateMachine",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_state_machine(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStateMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStateMachine",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStateMachineInput`](crate::input::DeleteStateMachineInput)
    pub fn builder() -> crate::input::delete_state_machine_input::Builder {
        crate::input::delete_state_machine_input::Builder::default()
    }
}

/// See [`DescribeActivityInput`](crate::input::DescribeActivityInput)
pub mod describe_activity_input {
    /// A builder for [`DescribeActivityInput`](crate::input::DescribeActivityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivityInput`](crate::input::DescribeActivityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActivityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActivityInput {
                activity_arn: self.activity_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActivityInputOperationOutputAlias = crate::operation::DescribeActivity;
#[doc(hidden)]
pub type DescribeActivityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActivityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActivity`](crate::operation::DescribeActivity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActivity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActivityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActivityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActivityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DescribeActivity",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_activity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActivity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActivity",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActivityInput`](crate::input::DescribeActivityInput)
    pub fn builder() -> crate::input::describe_activity_input::Builder {
        crate::input::describe_activity_input::Builder::default()
    }
}

/// See [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
pub mod describe_execution_input {
    /// A builder for [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExecutionInput {
                execution_arn: self.execution_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExecutionInputOperationOutputAlias = crate::operation::DescribeExecution;
#[doc(hidden)]
pub type DescribeExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExecution`](crate::operation::DescribeExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DescribeExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExecution",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    pub fn builder() -> crate::input::describe_execution_input::Builder {
        crate::input::describe_execution_input::Builder::default()
    }
}

/// See [`DescribeStateMachineInput`](crate::input::DescribeStateMachineInput)
pub mod describe_state_machine_input {
    /// A builder for [`DescribeStateMachineInput`](crate::input::DescribeStateMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStateMachineInput`](crate::input::DescribeStateMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStateMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStateMachineInput {
                state_machine_arn: self.state_machine_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStateMachineInputOperationOutputAlias = crate::operation::DescribeStateMachine;
#[doc(hidden)]
pub type DescribeStateMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStateMachineInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStateMachine`](crate::operation::DescribeStateMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStateMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStateMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStateMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStateMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DescribeStateMachine",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_state_machine(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStateMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStateMachine",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineInput`](crate::input::DescribeStateMachineInput)
    pub fn builder() -> crate::input::describe_state_machine_input::Builder {
        crate::input::describe_state_machine_input::Builder::default()
    }
}

/// See [`DescribeStateMachineForExecutionInput`](crate::input::DescribeStateMachineForExecutionInput)
pub mod describe_state_machine_for_execution_input {
    /// A builder for [`DescribeStateMachineForExecutionInput`](crate::input::DescribeStateMachineForExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStateMachineForExecutionInput`](crate::input::DescribeStateMachineForExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStateMachineForExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStateMachineForExecutionInput {
                execution_arn: self.execution_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStateMachineForExecutionInputOperationOutputAlias =
    crate::operation::DescribeStateMachineForExecution;
#[doc(hidden)]
pub type DescribeStateMachineForExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStateMachineForExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStateMachineForExecution`](crate::operation::DescribeStateMachineForExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStateMachineForExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStateMachineForExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStateMachineForExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStateMachineForExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.DescribeStateMachineForExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_state_machine_for_execution(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStateMachineForExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStateMachineForExecution",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStateMachineForExecutionInput`](crate::input::DescribeStateMachineForExecutionInput)
    pub fn builder() -> crate::input::describe_state_machine_for_execution_input::Builder {
        crate::input::describe_state_machine_for_execution_input::Builder::default()
    }
}

/// See [`GetActivityTaskInput`](crate::input::GetActivityTaskInput)
pub mod get_activity_task_input {
    /// A builder for [`GetActivityTaskInput`](crate::input::GetActivityTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_arn: std::option::Option<std::string::String>,
        pub(crate) worker_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
        /// using <a>CreateActivity</a>.)</p>
        pub fn activity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
        /// using <a>CreateActivity</a>.)</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_arn = input;
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is
        /// assigned to. This name is used when it is logged in the execution history.</p>
        pub fn worker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.worker_name = Some(input.into());
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is
        /// assigned to. This name is used when it is logged in the execution history.</p>
        pub fn set_worker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.worker_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetActivityTaskInput`](crate::input::GetActivityTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetActivityTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetActivityTaskInput {
                activity_arn: self.activity_arn,
                worker_name: self.worker_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetActivityTaskInputOperationOutputAlias = crate::operation::GetActivityTask;
#[doc(hidden)]
pub type GetActivityTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetActivityTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetActivityTask`](crate::operation::GetActivityTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetActivityTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetActivityTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetActivityTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetActivityTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.GetActivityTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_activity_task(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetActivityTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetActivityTask",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetActivityTaskInput`](crate::input::GetActivityTaskInput)
    pub fn builder() -> crate::input::get_activity_task_input::Builder {
        crate::input::get_activity_task_input::Builder::default()
    }
}

/// See [`GetExecutionHistoryInput`](crate::input::GetExecutionHistoryInput)
pub mod get_execution_history_input {
    /// A builder for [`GetExecutionHistoryInput`](crate::input::GetExecutionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) include_execution_data: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned.
        /// The default is <code>true</code>.</p>
        pub fn include_execution_data(mut self, input: bool) -> Self {
            self.include_execution_data = Some(input);
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned.
        /// The default is <code>true</code>.</p>
        pub fn set_include_execution_data(mut self, input: std::option::Option<bool>) -> Self {
            self.include_execution_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExecutionHistoryInput`](crate::input::GetExecutionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExecutionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExecutionHistoryInput {
                execution_arn: self.execution_arn,
                max_results: self.max_results.unwrap_or_default(),
                reverse_order: self.reverse_order.unwrap_or_default(),
                next_token: self.next_token,
                include_execution_data: self.include_execution_data,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExecutionHistoryInputOperationOutputAlias = crate::operation::GetExecutionHistory;
#[doc(hidden)]
pub type GetExecutionHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExecutionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetExecutionHistory`](crate::operation::GetExecutionHistory)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExecutionHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExecutionHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExecutionHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExecutionHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.GetExecutionHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_execution_history(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExecutionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExecutionHistory",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExecutionHistoryInput`](crate::input::GetExecutionHistoryInput)
    pub fn builder() -> crate::input::get_execution_history_input::Builder {
        crate::input::get_execution_history_input::Builder::default()
    }
}

/// See [`ListActivitiesInput`](crate::input::ListActivitiesInput)
pub mod list_activities_input {
    /// A builder for [`ListActivitiesInput`](crate::input::ListActivitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActivitiesInput`](crate::input::ListActivitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListActivitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListActivitiesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListActivitiesInputOperationOutputAlias = crate::operation::ListActivities;
#[doc(hidden)]
pub type ListActivitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListActivitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListActivities`](crate::operation::ListActivities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListActivities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListActivitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListActivitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListActivitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.ListActivities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_activities(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListActivities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListActivities",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListActivitiesInput`](crate::input::ListActivitiesInput)
    pub fn builder() -> crate::input::list_activities_input::Builder {
        crate::input::list_activities_input::Builder::default()
    }
}

/// See [`ListExecutionsInput`](crate::input::ListExecutionsInput)
pub mod list_executions_input {
    /// A builder for [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) status_filter: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given
        /// filter.</p>
        pub fn status_filter(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status_filter = Some(input);
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given
        /// filter.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status_filter = input;
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExecutionsInput`](crate::input::ListExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExecutionsInput {
                state_machine_arn: self.state_machine_arn,
                status_filter: self.status_filter,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExecutionsInputOperationOutputAlias = crate::operation::ListExecutions;
#[doc(hidden)]
pub type ListExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListExecutions`](crate::operation::ListExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.ListExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_executions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExecutions",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    pub fn builder() -> crate::input::list_executions_input::Builder {
        crate::input::list_executions_input::Builder::default()
    }
}

/// See [`ListStateMachinesInput`](crate::input::ListStateMachinesInput)
pub mod list_state_machines_input {
    /// A builder for [`ListStateMachinesInput`](crate::input::ListStateMachinesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStateMachinesInput`](crate::input::ListStateMachinesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStateMachinesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStateMachinesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStateMachinesInputOperationOutputAlias = crate::operation::ListStateMachines;
#[doc(hidden)]
pub type ListStateMachinesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListStateMachinesInput {
    /// Consumes the builder and constructs an Operation<[`ListStateMachines`](crate::operation::ListStateMachines)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStateMachines,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStateMachinesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStateMachinesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStateMachinesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.ListStateMachines",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_state_machines(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStateMachines::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStateMachines",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStateMachinesInput`](crate::input::ListStateMachinesInput)
    pub fn builder() -> crate::input::list_state_machines_input::Builder {
        crate::input::list_state_machines_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`SendTaskFailureInput`](crate::input::SendTaskFailureInput)
pub mod send_task_failure_input {
    /// A builder for [`SendTaskFailureInput`](crate::input::SendTaskFailureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTaskFailureInput`](crate::input::SendTaskFailureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTaskFailureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTaskFailureInput {
                task_token: self.task_token,
                error: self.error,
                cause: self.cause,
            })
        }
    }
}
#[doc(hidden)]
pub type SendTaskFailureInputOperationOutputAlias = crate::operation::SendTaskFailure;
#[doc(hidden)]
pub type SendTaskFailureInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendTaskFailureInput {
    /// Consumes the builder and constructs an Operation<[`SendTaskFailure`](crate::operation::SendTaskFailure)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTaskFailure,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendTaskFailureInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendTaskFailureInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendTaskFailureInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.SendTaskFailure",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_task_failure(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTaskFailure::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTaskFailure",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendTaskFailureInput`](crate::input::SendTaskFailureInput)
    pub fn builder() -> crate::input::send_task_failure_input::Builder {
        crate::input::send_task_failure_input::Builder::default()
    }
}

/// See [`SendTaskHeartbeatInput`](crate::input::SendTaskHeartbeatInput)
pub mod send_task_heartbeat_input {
    /// A builder for [`SendTaskHeartbeatInput`](crate::input::SendTaskHeartbeatInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTaskHeartbeatInput`](crate::input::SendTaskHeartbeatInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTaskHeartbeatInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTaskHeartbeatInput {
                task_token: self.task_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SendTaskHeartbeatInputOperationOutputAlias = crate::operation::SendTaskHeartbeat;
#[doc(hidden)]
pub type SendTaskHeartbeatInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendTaskHeartbeatInput {
    /// Consumes the builder and constructs an Operation<[`SendTaskHeartbeat`](crate::operation::SendTaskHeartbeat)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTaskHeartbeat,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendTaskHeartbeatInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendTaskHeartbeatInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendTaskHeartbeatInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.SendTaskHeartbeat",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_task_heartbeat(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTaskHeartbeat::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTaskHeartbeat",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendTaskHeartbeatInput`](crate::input::SendTaskHeartbeatInput)
    pub fn builder() -> crate::input::send_task_heartbeat_input::Builder {
        crate::input::send_task_heartbeat_input::Builder::default()
    }
}

/// See [`SendTaskSuccessInput`](crate::input::SendTaskSuccessInput)
pub mod send_task_success_input {
    /// A builder for [`SendTaskSuccessInput`](crate::input::SendTaskSuccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_token: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_token = Some(input.into());
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_token = input;
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTaskSuccessInput`](crate::input::SendTaskSuccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTaskSuccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTaskSuccessInput {
                task_token: self.task_token,
                output: self.output,
            })
        }
    }
}
#[doc(hidden)]
pub type SendTaskSuccessInputOperationOutputAlias = crate::operation::SendTaskSuccess;
#[doc(hidden)]
pub type SendTaskSuccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendTaskSuccessInput {
    /// Consumes the builder and constructs an Operation<[`SendTaskSuccess`](crate::operation::SendTaskSuccess)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTaskSuccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendTaskSuccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendTaskSuccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendTaskSuccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.SendTaskSuccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_task_success(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTaskSuccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTaskSuccess",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendTaskSuccessInput`](crate::input::SendTaskSuccessInput)
    pub fn builder() -> crate::input::send_task_success_input::Builder {
        crate::input::send_task_success_input::Builder::default()
    }
}

/// See [`StartExecutionInput`](crate::input::StartExecutionInput)
pub mod start_execution_input {
    /// A builder for [`StartExecutionInput`](crate::input::StartExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) trace_header: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_header = Some(input.into());
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_header = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExecutionInput`](crate::input::StartExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartExecutionInput {
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                input: self.input,
                trace_header: self.trace_header,
            })
        }
    }
}
#[doc(hidden)]
pub type StartExecutionInputOperationOutputAlias = crate::operation::StartExecution;
#[doc(hidden)]
pub type StartExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartExecution`](crate::operation::StartExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.StartExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartExecution",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartExecutionInput`](crate::input::StartExecutionInput)
    pub fn builder() -> crate::input::start_execution_input::Builder {
        crate::input::start_execution_input::Builder::default()
    }
}

/// See [`StartSyncExecutionInput`](crate::input::StartSyncExecutionInput)
pub mod start_sync_execution_input {
    /// A builder for [`StartSyncExecutionInput`](crate::input::StartSyncExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) trace_header: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The name of the execution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_header = Some(input.into());
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_header = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSyncExecutionInput`](crate::input::StartSyncExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSyncExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSyncExecutionInput {
                state_machine_arn: self.state_machine_arn,
                name: self.name,
                input: self.input,
                trace_header: self.trace_header,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSyncExecutionInputOperationOutputAlias = crate::operation::StartSyncExecution;
#[doc(hidden)]
pub type StartSyncExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartSyncExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartSyncExecution`](crate::operation::StartSyncExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSyncExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSyncExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSyncExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSyncExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.StartSyncExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_sync_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("sync-")?;
        request.properties_mut().insert(endpoint_prefix);
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSyncExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSyncExecution",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSyncExecutionInput`](crate::input::StartSyncExecutionInput)
    pub fn builder() -> crate::input::start_sync_execution_input::Builder {
        crate::input::start_sync_execution_input::Builder::default()
    }
}

/// See [`StopExecutionInput`](crate::input::StopExecutionInput)
pub mod stop_execution_input {
    /// A builder for [`StopExecutionInput`](crate::input::StopExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_arn: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_arn = input;
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// Consumes the builder and constructs a [`StopExecutionInput`](crate::input::StopExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopExecutionInput {
                execution_arn: self.execution_arn,
                error: self.error,
                cause: self.cause,
            })
        }
    }
}
#[doc(hidden)]
pub type StopExecutionInputOperationOutputAlias = crate::operation::StopExecution;
#[doc(hidden)]
pub type StopExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StopExecution`](crate::operation::StopExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.StopExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopExecution",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopExecutionInput`](crate::input::StopExecutionInput)
    pub fn builder() -> crate::input::stop_execution_input::Builder {
        crate::input::stop_execution_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateStateMachineInput`](crate::input::UpdateStateMachineInput)
pub mod update_state_machine_input {
    /// A builder for [`UpdateStateMachineInput`](crate::input::UpdateStateMachineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_machine_arn: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn state_machine_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_arn = input;
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, input: crate::model::TracingConfiguration) -> Self {
            self.tracing_configuration = Some(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.tracing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStateMachineInput`](crate::input::UpdateStateMachineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStateMachineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStateMachineInput {
                state_machine_arn: self.state_machine_arn,
                definition: self.definition,
                role_arn: self.role_arn,
                logging_configuration: self.logging_configuration,
                tracing_configuration: self.tracing_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStateMachineInputOperationOutputAlias = crate::operation::UpdateStateMachine;
#[doc(hidden)]
pub type UpdateStateMachineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateStateMachineInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStateMachine`](crate::operation::UpdateStateMachine)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStateMachine,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateStateMachineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateStateMachineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateStateMachineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSStepFunctions.UpdateStateMachine",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_state_machine(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStateMachine::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStateMachine",
            "sfn",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateStateMachineInput`](crate::input::UpdateStateMachineInput)
    pub fn builder() -> crate::input::update_state_machine_input::Builder {
        crate::input::update_state_machine_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
}
impl UpdateStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
    /// options.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub fn tracing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TracingConfiguration> {
        self.tracing_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateStateMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStateMachineInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("definition", &"*** Sensitive Data Redacted ***");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("tracing_configuration", &self.tracing_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tags to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tags to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tags to add to a resource.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tags to add to a resource.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl StopExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for StopExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopExecutionInput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSyncExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the execution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The string that contains the JSON input data for the execution, for example:</p>
    /// <p>
    /// <code>"input": "{\"first_name\" : \"test\"}"</code>
    /// </p>
    /// <note>
    /// <p>If you don't include any JSON input data, you still must include the two braces, for
    /// example: <code>"input": "{}"</code>
    /// </p>
    /// </note>
    /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    pub trace_header: std::option::Option<std::string::String>,
}
impl StartSyncExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the execution.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The string that contains the JSON input data for the execution, for example:</p>
    /// <p>
    /// <code>"input": "{\"first_name\" : \"test\"}"</code>
    /// </p>
    /// <note>
    /// <p>If you don't include any JSON input data, you still must include the two braces, for
    /// example: <code>"input": "{}"</code>
    /// </p>
    /// </note>
    /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    pub fn trace_header(&self) -> std::option::Option<&str> {
        self.trace_header.as_deref()
    }
}
impl std::fmt::Debug for StartSyncExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSyncExecutionInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("trace_header", &self.trace_header);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
    /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
    /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The string that contains the JSON input data for the execution, for example:</p>
    /// <p>
    /// <code>"input": "{\"first_name\" : \"test\"}"</code>
    /// </p>
    /// <note>
    /// <p>If you don't include any JSON input data, you still must include the two braces, for
    /// example: <code>"input": "{}"</code>
    /// </p>
    /// </note>
    /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    pub trace_header: std::option::Option<std::string::String>,
}
impl StartExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
    /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
    /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The string that contains the JSON input data for the execution, for example:</p>
    /// <p>
    /// <code>"input": "{\"first_name\" : \"test\"}"</code>
    /// </p>
    /// <note>
    /// <p>If you don't include any JSON input data, you still must include the two braces, for
    /// example: <code>"input": "{}"</code>
    /// </p>
    /// </note>
    /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn input(&self) -> std::option::Option<&str> {
        self.input.as_deref()
    }
    /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
    pub fn trace_header(&self) -> std::option::Option<&str> {
        self.trace_header.as_deref()
    }
}
impl std::fmt::Debug for StartExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExecutionInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("name", &self.name);
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("trace_header", &self.trace_header);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskSuccessInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub output: std::option::Option<std::string::String>,
}
impl SendTaskSuccessInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
    pub fn output(&self) -> std::option::Option<&str> {
        self.output.as_deref()
    }
}
impl std::fmt::Debug for SendTaskSuccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskSuccessInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("output", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskHeartbeatInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub task_token: std::option::Option<std::string::String>,
}
impl SendTaskHeartbeatInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
}
impl std::fmt::Debug for SendTaskHeartbeatInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskHeartbeatInput");
        formatter.field("task_token", &self.task_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTaskFailureInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub task_token: std::option::Option<std::string::String>,
    /// <p>The error code of the failure.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub cause: std::option::Option<std::string::String>,
}
impl SendTaskFailureInput {
    /// <p>The token that represents this task. Task tokens are generated by Step Functions when
    /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
    /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
    pub fn task_token(&self) -> std::option::Option<&str> {
        self.task_token.as_deref()
    }
    /// <p>The error code of the failure.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>A more detailed explanation of the cause of the failure.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
}
impl std::fmt::Debug for SendTaskFailureInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTaskFailureInput");
        formatter.field("task_token", &self.task_token);
        formatter.field("error", &"*** Sensitive Data Redacted ***");
        formatter.field("cause", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStateMachinesInput {
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub max_results: i32,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStateMachinesInput {
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStateMachinesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStateMachinesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExecutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
    /// <p>If specified, only list the executions whose current execution status matches the given
    /// filter.</p>
    pub status_filter: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub max_results: i32,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExecutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
    /// <p>If specified, only list the executions whose current execution status matches the given
    /// filter.</p>
    pub fn status_filter(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status_filter.as_ref()
    }
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExecutionsInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.field("status_filter", &self.status_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActivitiesInput {
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub max_results: i32,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActivitiesInput {
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActivitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActivitiesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExecutionHistoryInput {
    /// <p>The Amazon Resource Name (ARN) of the execution.</p>
    pub execution_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub max_results: i32,
    /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
    pub reverse_order: bool,
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can select whether execution data (input or output of a history event) is returned.
    /// The default is <code>true</code>.</p>
    pub include_execution_data: std::option::Option<bool>,
}
impl GetExecutionHistoryInput {
    /// <p>The Amazon Resource Name (ARN) of the execution.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
    /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
    /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
    /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
    pub fn reverse_order(&self) -> bool {
        self.reverse_order
    }
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can select whether execution data (input or output of a history event) is returned.
    /// The default is <code>true</code>.</p>
    pub fn include_execution_data(&self) -> std::option::Option<bool> {
        self.include_execution_data
    }
}
impl std::fmt::Debug for GetExecutionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExecutionHistoryInput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("include_execution_data", &self.include_execution_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetActivityTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
    /// using <a>CreateActivity</a>.)</p>
    pub activity_arn: std::option::Option<std::string::String>,
    /// <p>You can provide an arbitrary name in order to identify the worker that the task is
    /// assigned to. This name is used when it is logged in the execution history.</p>
    pub worker_name: std::option::Option<std::string::String>,
}
impl GetActivityTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
    /// using <a>CreateActivity</a>.)</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
    /// <p>You can provide an arbitrary name in order to identify the worker that the task is
    /// assigned to. This name is used when it is logged in the execution history.</p>
    pub fn worker_name(&self) -> std::option::Option<&str> {
        self.worker_name.as_deref()
    }
}
impl std::fmt::Debug for GetActivityTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetActivityTaskInput");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.field("worker_name", &self.worker_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStateMachineForExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
    pub execution_arn: std::option::Option<std::string::String>,
}
impl DescribeStateMachineForExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeStateMachineForExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStateMachineForExecutionInput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
}
impl DescribeStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeStateMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStateMachineInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
    pub execution_arn: std::option::Option<std::string::String>,
}
impl DescribeExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
    pub fn execution_arn(&self) -> std::option::Option<&str> {
        self.execution_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExecutionInput");
        formatter.field("execution_arn", &self.execution_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivityInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
    pub activity_arn: std::option::Option<std::string::String>,
}
impl DescribeActivityInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeActivityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivityInput");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
    pub state_machine_arn: std::option::Option<std::string::String>,
}
impl DeleteStateMachineInput {
    /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
    pub fn state_machine_arn(&self) -> std::option::Option<&str> {
        self.state_machine_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteStateMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStateMachineInput");
        formatter.field("state_machine_arn", &self.state_machine_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteActivityInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
    pub activity_arn: std::option::Option<std::string::String>,
}
impl DeleteActivityInput {
    /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
    pub fn activity_arn(&self) -> std::option::Option<&str> {
        self.activity_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteActivityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteActivityInput");
        formatter.field("activity_arn", &self.activity_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStateMachineInput {
    /// <p>The name of the state machine. </p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Determines whether a Standard or Express state machine is created. The default is
    /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
    /// has been created.</p>
    pub r#type: std::option::Option<crate::model::StateMachineType>,
    /// <p>Defines what execution history events are logged and where they are logged.</p>
    /// <note>
    /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
    /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
    /// Levels</a> in the AWS Step Functions User Guide.</p>
    /// </note>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>Tags to be added when creating a state machine.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
    /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
    /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
    /// Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub tracing_configuration: std::option::Option<crate::model::TracingConfiguration>,
}
impl CreateStateMachineInput {
    /// <p>The name of the state machine. </p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Determines whether a Standard or Express state machine is created. The default is
    /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
    /// has been created.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::StateMachineType> {
        self.r#type.as_ref()
    }
    /// <p>Defines what execution history events are logged and where they are logged.</p>
    /// <note>
    /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
    /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
    /// Levels</a> in the AWS Step Functions User Guide.</p>
    /// </note>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>Tags to be added when creating a state machine.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
    /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
    /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
    /// Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
    pub fn tracing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TracingConfiguration> {
        self.tracing_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateStateMachineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStateMachineInput");
        formatter.field("name", &self.name);
        formatter.field("definition", &"*** Sensitive Data Redacted ***");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("tags", &self.tags);
        formatter.field("tracing_configuration", &self.tracing_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateActivityInput {
    /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
    /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
    /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The list of tags to add to a resource.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
    /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
    /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
    /// Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateActivityInput {
    /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
    /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
    /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
    /// <p>A name must <i>not</i> contain:</p>
    /// <ul>
    /// <li>
    /// <p>white space</p>
    /// </li>
    /// <li>
    /// <p>brackets <code>< > { } [ ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>wildcard characters <code>? *</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
    /// </li>
    /// </ul>
    /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The list of tags to add to a resource.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
    /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
    /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
    /// Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateActivityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateActivityInput");
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
