// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSStepFunctions`.
///
/// This client allows ergonomic access to a `AWSStepFunctions`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateActivity` operation.
    ///
    /// See [`CreateActivity`](crate::client::fluent_builders::CreateActivity) for more information about the
    /// operation and its arguments.
    pub fn create_activity(&self) -> fluent_builders::CreateActivity<C, M, R> {
        fluent_builders::CreateActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStateMachine` operation.
    ///
    /// See [`CreateStateMachine`](crate::client::fluent_builders::CreateStateMachine) for more information about the
    /// operation and its arguments.
    pub fn create_state_machine(&self) -> fluent_builders::CreateStateMachine<C, M, R> {
        fluent_builders::CreateStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteActivity` operation.
    ///
    /// See [`DeleteActivity`](crate::client::fluent_builders::DeleteActivity) for more information about the
    /// operation and its arguments.
    pub fn delete_activity(&self) -> fluent_builders::DeleteActivity<C, M, R> {
        fluent_builders::DeleteActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStateMachine` operation.
    ///
    /// See [`DeleteStateMachine`](crate::client::fluent_builders::DeleteStateMachine) for more information about the
    /// operation and its arguments.
    pub fn delete_state_machine(&self) -> fluent_builders::DeleteStateMachine<C, M, R> {
        fluent_builders::DeleteStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeActivity` operation.
    ///
    /// See [`DescribeActivity`](crate::client::fluent_builders::DescribeActivity) for more information about the
    /// operation and its arguments.
    pub fn describe_activity(&self) -> fluent_builders::DescribeActivity<C, M, R> {
        fluent_builders::DescribeActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExecution` operation.
    ///
    /// See [`DescribeExecution`](crate::client::fluent_builders::DescribeExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_execution(&self) -> fluent_builders::DescribeExecution<C, M, R> {
        fluent_builders::DescribeExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStateMachine` operation.
    ///
    /// See [`DescribeStateMachine`](crate::client::fluent_builders::DescribeStateMachine) for more information about the
    /// operation and its arguments.
    pub fn describe_state_machine(&self) -> fluent_builders::DescribeStateMachine<C, M, R> {
        fluent_builders::DescribeStateMachine::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStateMachineForExecution` operation.
    ///
    /// See [`DescribeStateMachineForExecution`](crate::client::fluent_builders::DescribeStateMachineForExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_state_machine_for_execution(
        &self,
    ) -> fluent_builders::DescribeStateMachineForExecution<C, M, R> {
        fluent_builders::DescribeStateMachineForExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetActivityTask` operation.
    ///
    /// See [`GetActivityTask`](crate::client::fluent_builders::GetActivityTask) for more information about the
    /// operation and its arguments.
    pub fn get_activity_task(&self) -> fluent_builders::GetActivityTask<C, M, R> {
        fluent_builders::GetActivityTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExecutionHistory` operation.
    ///
    /// See [`GetExecutionHistory`](crate::client::fluent_builders::GetExecutionHistory) for more information about the
    /// operation and its arguments.
    pub fn get_execution_history(&self) -> fluent_builders::GetExecutionHistory<C, M, R> {
        fluent_builders::GetExecutionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActivities` operation.
    ///
    /// See [`ListActivities`](crate::client::fluent_builders::ListActivities) for more information about the
    /// operation and its arguments.
    pub fn list_activities(&self) -> fluent_builders::ListActivities<C, M, R> {
        fluent_builders::ListActivities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExecutions` operation.
    ///
    /// See [`ListExecutions`](crate::client::fluent_builders::ListExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_executions(&self) -> fluent_builders::ListExecutions<C, M, R> {
        fluent_builders::ListExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStateMachines` operation.
    ///
    /// See [`ListStateMachines`](crate::client::fluent_builders::ListStateMachines) for more information about the
    /// operation and its arguments.
    pub fn list_state_machines(&self) -> fluent_builders::ListStateMachines<C, M, R> {
        fluent_builders::ListStateMachines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendTaskFailure` operation.
    ///
    /// See [`SendTaskFailure`](crate::client::fluent_builders::SendTaskFailure) for more information about the
    /// operation and its arguments.
    pub fn send_task_failure(&self) -> fluent_builders::SendTaskFailure<C, M, R> {
        fluent_builders::SendTaskFailure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendTaskHeartbeat` operation.
    ///
    /// See [`SendTaskHeartbeat`](crate::client::fluent_builders::SendTaskHeartbeat) for more information about the
    /// operation and its arguments.
    pub fn send_task_heartbeat(&self) -> fluent_builders::SendTaskHeartbeat<C, M, R> {
        fluent_builders::SendTaskHeartbeat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendTaskSuccess` operation.
    ///
    /// See [`SendTaskSuccess`](crate::client::fluent_builders::SendTaskSuccess) for more information about the
    /// operation and its arguments.
    pub fn send_task_success(&self) -> fluent_builders::SendTaskSuccess<C, M, R> {
        fluent_builders::SendTaskSuccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExecution` operation.
    ///
    /// See [`StartExecution`](crate::client::fluent_builders::StartExecution) for more information about the
    /// operation and its arguments.
    pub fn start_execution(&self) -> fluent_builders::StartExecution<C, M, R> {
        fluent_builders::StartExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSyncExecution` operation.
    ///
    /// See [`StartSyncExecution`](crate::client::fluent_builders::StartSyncExecution) for more information about the
    /// operation and its arguments.
    pub fn start_sync_execution(&self) -> fluent_builders::StartSyncExecution<C, M, R> {
        fluent_builders::StartSyncExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopExecution` operation.
    ///
    /// See [`StopExecution`](crate::client::fluent_builders::StopExecution) for more information about the
    /// operation and its arguments.
    pub fn stop_execution(&self) -> fluent_builders::StopExecution<C, M, R> {
        fluent_builders::StopExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStateMachine` operation.
    ///
    /// See [`UpdateStateMachine`](crate::client::fluent_builders::UpdateStateMachine) for more information about the
    /// operation and its arguments.
    pub fn update_state_machine(&self) -> fluent_builders::UpdateStateMachine<C, M, R> {
        fluent_builders::UpdateStateMachine::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateActivity`.
    ///
    /// <p>Creates an activity. An activity is a task that you write in any programming language and
    /// host on any machine that has access to AWS Step Functions. Activities must poll Step Functions using the
    /// <code>GetActivityTask</code> API action and respond using <code>SendTask*</code> API
    /// actions. This function lets Step Functions know the existence of your activity and returns an
    /// identifier for use in a state machine and when polling from the activity.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <note>
    /// <p>
    /// <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a
    /// duplicate resource if it was already created. <code>CreateActivity</code>'s idempotency
    /// check is based on the activity <code>name</code>. If a following request has different
    /// <code>tags</code> values, Step Functions will ignore these differences and treat it as an
    /// idempotent request of the previous. In this case, <code>tags</code> will not be updated,
    /// even if they are different.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateActivity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_activity_input::Builder,
    }
    impl<C, M, R> CreateActivity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActivityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateActivityInputOperationOutputAlias,
                crate::output::CreateActivityOutput,
                crate::error::CreateActivityError,
                crate::input::CreateActivityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStateMachine`.
    ///
    /// <p>Creates a state machine. A state machine consists of a collection of states that can do
    /// work (<code>Task</code> states), determine to which states to transition next
    /// (<code>Choice</code> states), stop an execution with an error (<code>Fail</code> states),
    /// and so on. State machines are specified using a JSON-based, structured language. For more
    /// information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States
    /// Language</a> in the AWS Step Functions User Guide.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <note>
    /// <p>
    /// <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a
    /// duplicate resource if it was already created. <code>CreateStateMachine</code>'s idempotency
    /// check is based on the state machine <code>name</code>, <code>definition</code>,
    /// <code>type</code>, <code>LoggingConfiguration</code> and <code>TracingConfiguration</code>. If a following request has a
    /// different <code>roleArn</code> or <code>tags</code>, Step Functions will ignore these differences and
    /// treat it as an idempotent request of the previous. In this case, <code>roleArn</code> and
    /// <code>tags</code> will not be updated, even if they are different.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateStateMachine<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_state_machine_input::Builder,
    }
    impl<C, M, R> CreateStateMachine<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStateMachineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStateMachineInputOperationOutputAlias,
                crate::output::CreateStateMachineOutput,
                crate::error::CreateStateMachineError,
                crate::input::CreateStateMachineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the state machine. </p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is
        /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
        /// has been created.</p>
        pub fn r#type(mut self, inp: crate::model::StateMachineType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Determines whether a Standard or Express state machine is created. The default is
        /// <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it
        /// has been created.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::StateMachineType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p>
        /// <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
        /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
        /// Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn logging_configuration(mut self, inp: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(inp);
            self
        }
        /// <p>Defines what execution history events are logged and where they are logged.</p>
        /// <note>
        /// <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see
        /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log
        /// Levels</a> in the AWS Step Functions User Guide.</p>
        /// </note>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to be added when creating a state machine.</p>
        /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
        /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
        /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
        /// Tags</a>.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, inp: crate::model::TracingConfiguration) -> Self {
            self.inner = self.inner.tracing_configuration(inp);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_tracing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteActivity`.
    ///
    /// <p>Deletes an activity.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteActivity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_activity_input::Builder,
    }
    impl<C, M, R> DeleteActivity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActivityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteActivityInputOperationOutputAlias,
                crate::output::DeleteActivityOutput,
                crate::error::DeleteActivityError,
                crate::input::DeleteActivityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn activity_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to delete.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStateMachine`.
    ///
    /// <p>Deletes a state machine. This is an asynchronous operation: It sets the state machine's
    /// status to <code>DELETING</code> and begins the deletion process. </p>
    /// <note>
    /// <p>For <code>EXPRESS</code>state machines, the deletion will happen eventually (usually
    /// less than a minute). Running executions may emit logs after <code>DeleteStateMachine</code>
    /// API is called.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStateMachine<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_state_machine_input::Builder,
    }
    impl<C, M, R> DeleteStateMachine<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStateMachineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStateMachineInputOperationOutputAlias,
                crate::output::DeleteStateMachineOutput,
                crate::error::DeleteStateMachineError,
                crate::input::DeleteStateMachineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to delete.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivity`.
    ///
    /// <p>Describes an activity.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeActivity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_activity_input::Builder,
    }
    impl<C, M, R> DescribeActivity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActivityInputOperationOutputAlias,
                crate::output::DescribeActivityOutput,
                crate::error::DescribeActivityError,
                crate::input::DescribeActivityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn activity_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to describe.</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExecution`.
    ///
    /// <p>Describes an execution.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_execution_input::Builder,
    }
    impl<C, M, R> DescribeExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExecutionInputOperationOutputAlias,
                crate::output::DescribeExecutionOutput,
                crate::error::DescribeExecutionError,
                crate::input::DescribeExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to describe.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStateMachine`.
    ///
    /// <p>Describes a state machine.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStateMachine<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_state_machine_input::Builder,
    }
    impl<C, M, R> DescribeStateMachine<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStateMachineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStateMachineInputOperationOutputAlias,
                crate::output::DescribeStateMachineOutput,
                crate::error::DescribeStateMachineError,
                crate::input::DescribeStateMachineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to describe.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStateMachineForExecution`.
    ///
    /// <p>Describes the state machine associated with a specific execution.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStateMachineForExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_state_machine_for_execution_input::Builder,
    }
    impl<C, M, R> DescribeStateMachineForExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStateMachineForExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStateMachineForExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStateMachineForExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStateMachineForExecutionInputOperationOutputAlias,
                crate::output::DescribeStateMachineForExecutionOutput,
                crate::error::DescribeStateMachineForExecutionError,
                crate::input::DescribeStateMachineForExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetActivityTask`.
    ///
    /// <p>Used by workers to retrieve a task (with the specified activity ARN) which has been
    /// scheduled for execution by a running state machine. This initiates a long poll, where the
    /// service holds the HTTP connection open and responds as soon as a task becomes available (i.e.
    /// an execution of a task of this type is needed.) The maximum time the service holds on to the
    /// request before responding is 60 seconds. If no task is available within 60 seconds, the poll
    /// returns a <code>taskToken</code> with a null string.</p>
    /// <important>
    /// <p>Workers should set their client side socket timeout to at least 65 seconds (5 seconds
    /// higher than the maximum time the service may hold the poll request).</p>
    /// <p>Polling with <code>GetActivityTask</code> can cause latency in some implementations. See
    /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid
    /// Latency When Polling for Activity Tasks</a> in the Step Functions Developer Guide.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetActivityTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_activity_task_input::Builder,
    }
    impl<C, M, R> GetActivityTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetActivityTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetActivityTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetActivityTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetActivityTaskInputOperationOutputAlias,
                crate::output::GetActivityTaskOutput,
                crate::error::GetActivityTaskError,
                crate::input::GetActivityTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
        /// using <a>CreateActivity</a>.)</p>
        pub fn activity_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activity_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task
        /// using <a>CreateActivity</a>.)</p>
        pub fn set_activity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_activity_arn(input);
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is
        /// assigned to. This name is used when it is logged in the execution history.</p>
        pub fn worker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worker_name(inp);
            self
        }
        /// <p>You can provide an arbitrary name in order to identify the worker that the task is
        /// assigned to. This name is used when it is logged in the execution history.</p>
        pub fn set_worker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_worker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExecutionHistory`.
    ///
    /// <p>Returns the history of the specified execution as a list of events. By default, the
    /// results are returned in ascending order of the <code>timeStamp</code> of the events. Use the
    /// <code>reverseOrder</code> parameter to get the latest events first.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExecutionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_execution_history_input::Builder,
    }
    impl<C, M, R> GetExecutionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExecutionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExecutionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExecutionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExecutionHistoryInputOperationOutputAlias,
                crate::output::GetExecutionHistoryOutput,
                crate::error::GetExecutionHistoryError,
                crate::input::GetExecutionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>Lists events in descending order of their <code>timeStamp</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned.
        /// The default is <code>true</code>.</p>
        pub fn include_execution_data(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_execution_data(inp);
            self
        }
        /// <p>You can select whether execution data (input or output of a history event) is returned.
        /// The default is <code>true</code>.</p>
        pub fn set_include_execution_data(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_execution_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivities`.
    ///
    /// <p>Lists the existing activities.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListActivities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_activities_input::Builder,
    }
    impl<C, M, R> ListActivities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActivities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActivitiesInputOperationOutputAlias,
                crate::output::ListActivitiesOutput,
                crate::error::ListActivitiesError,
                crate::input::ListActivitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExecutions`.
    ///
    /// <p>Lists the executions of a state machine that meet the filtering criteria. Results are
    /// sorted by time, with the most recent execution first.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_executions_input::Builder,
    }
    impl<C, M, R> ListExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExecutionsInputOperationOutputAlias,
                crate::output::ListExecutionsOutput,
                crate::error::ListExecutionsError,
                crate::input::ListExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given
        /// filter.</p>
        pub fn status_filter(mut self, inp: crate::model::ExecutionStatus) -> Self {
            self.inner = self.inner.status_filter(inp);
            self
        }
        /// <p>If specified, only list the executions whose current execution status matches the given
        /// filter.</p>
        pub fn set_status_filter(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_filter(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStateMachines`.
    ///
    /// <p>Lists the existing state machines.</p>
    /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
    /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
    /// <note>
    /// <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListStateMachines<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_state_machines_input::Builder,
    }
    impl<C, M, R> ListStateMachines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStateMachines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStateMachinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStateMachinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStateMachinesInputOperationOutputAlias,
                crate::output::ListStateMachinesOutput,
                crate::error::ListStateMachinesError,
                crate::input::ListStateMachinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.
        /// The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p>
        /// <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page.
        /// Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags for a given resource.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskFailure`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a>
    /// pattern to report that the task identified by the <code>taskToken</code> failed.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendTaskFailure<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_task_failure_input::Builder,
    }
    impl<C, M, R> SendTaskFailure<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendTaskFailure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskFailureOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskFailureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendTaskFailureInputOperationOutputAlias,
                crate::output::SendTaskFailureOutput,
                crate::error::SendTaskFailureError,
                crate::input::SendTaskFailureInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error(inp);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_error(input);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cause(inp);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cause(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskHeartbeat`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a>
    /// pattern to report to Step Functions that the task represented by the specified
    /// <code>taskToken</code> is still making progress. This action resets the
    /// <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is specified in the state
    /// machine's Amazon States Language definition (<code>HeartbeatSeconds</code>). This action does not in itself
    /// create an event in the execution history. However, if the task times out, the execution
    /// history contains an <code>ActivityTimedOut</code> entry for activities, or a
    /// <code>TaskTimedOut</code> entry for for tasks using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or
    /// <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a>
    /// pattern.</p>
    /// <note>
    /// <p>The <code>Timeout</code> of a task, defined in the state machine's Amazon States Language definition, is
    /// its maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use <code>HeartbeatSeconds</code> to configure the timeout interval
    /// for heartbeats.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SendTaskHeartbeat<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_task_heartbeat_input::Builder,
    }
    impl<C, M, R> SendTaskHeartbeat<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendTaskHeartbeat`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskHeartbeatOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskHeartbeatError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendTaskHeartbeatInputOperationOutputAlias,
                crate::output::SendTaskHeartbeatOutput,
                crate::error::SendTaskHeartbeatError,
                crate::input::SendTaskHeartbeatInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTaskSuccess`.
    ///
    /// <p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a>
    /// pattern to report that the task identified by the <code>taskToken</code> completed
    /// successfully.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendTaskSuccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_task_success_input::Builder,
    }
    impl<C, M, R> SendTaskSuccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendTaskSuccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTaskSuccessOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTaskSuccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendTaskSuccessInputOperationOutputAlias,
                crate::output::SendTaskSuccessOutput,
                crate::error::SendTaskSuccessError,
                crate::input::SendTaskSuccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn task_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_token(inp);
            self
        }
        /// <p>The token that represents this task. Task tokens are generated by Step Functions when
        /// tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a
        /// workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>
        pub fn set_task_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_token(input);
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn output(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output(inp);
            self
        }
        /// <p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExecution`.
    ///
    /// <p>Starts a state machine execution.</p>
    /// <note>
    /// <p>
    /// <code>StartExecution</code> is idempotent. If <code>StartExecution</code> is called with
    /// the same name and input as a running execution, the call will succeed and return the same
    /// response as the original request. If the execution is closed or if the input is different,
    /// it will return a 400 <code>ExecutionAlreadyExists</code> error. Names can be reused after 90
    /// days. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_execution_input::Builder,
    }
    impl<C, M, R> StartExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartExecutionInputOperationOutputAlias,
                crate::output::StartExecutionOutput,
                crate::error::StartExecutionError,
                crate::input::StartExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information,
        /// see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions">
        /// Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p>
        /// <p>A name must <i>not</i> contain:</p>
        /// <ul>
        /// <li>
        /// <p>white space</p>
        /// </li>
        /// <li>
        /// <p>brackets <code>< > { } [ ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>wildcard characters <code>? *</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>special characters <code>" # % \ ^ | ~ ` $ & , ; : /</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p>
        /// </li>
        /// </ul>
        /// <p>To enable logging with CloudWatch Logs, the name should only contain  0-9, A-Z, a-z, - and _.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_header(inp);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trace_header(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSyncExecution`.
    ///
    /// <p>Starts a Synchronous Express state machine execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSyncExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_sync_execution_input::Builder,
    }
    impl<C, M, R> StartSyncExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSyncExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSyncExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSyncExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSyncExecutionInputOperationOutputAlias,
                crate::output::StartSyncExecutionOutput,
                crate::error::StartSyncExecutionError,
                crate::input::StartSyncExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine to execute.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The name of the execution.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the execution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn input(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>The string that contains the JSON input data for the execution, for example:</p>
        /// <p>
        /// <code>"input": "{\"first_name\" : \"test\"}"</code>
        /// </p>
        /// <note>
        /// <p>If you don't include any JSON input data, you still must include the two braces, for
        /// example: <code>"input": "{}"</code>
        /// </p>
        /// </note>
        /// <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn trace_header(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trace_header(inp);
            self
        }
        /// <p>Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trace_header(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopExecution`.
    ///
    /// <p>Stops an execution.</p>
    /// <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_execution_input::Builder,
    }
    impl<C, M, R> StopExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopExecutionInputOperationOutputAlias,
                crate::output::StopExecutionOutput,
                crate::error::StopExecutionError,
                crate::input::StopExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn execution_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the execution to stop.</p>
        pub fn set_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_arn(input);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn error(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.error(inp);
            self
        }
        /// <p>The error code of the failure.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_error(input);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn cause(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cause(inp);
            self
        }
        /// <p>A more detailed explanation of the cause of the failure.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cause(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add a tag to a Step Functions resource.</p>
    /// <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
    /// Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User
    /// Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM
    /// Tags</a>.</p>
    /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags to add to a resource.</p>
        /// <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove a tag from a Step Functions resource</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStateMachine`.
    ///
    /// <p>Updates an existing state machine by modifying its <code>definition</code>,
    /// <code>roleArn</code>, or <code>loggingConfiguration</code>. Running executions will continue
    /// to use the previous <code>definition</code> and <code>roleArn</code>. You must include at
    /// least one of <code>definition</code> or <code>roleArn</code> or you will receive a
    /// <code>MissingRequiredParameter</code> error.</p>
    /// <note>
    /// <p>All <code>StartExecution</code> calls within a few seconds will use the updated
    /// <code>definition</code> and <code>roleArn</code>. Executions started immediately after
    /// calling <code>UpdateStateMachine</code> may use the previous state machine
    /// <code>definition</code> and <code>roleArn</code>. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStateMachine<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_state_machine_input::Builder,
    }
    impl<C, M, R> UpdateStateMachine<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStateMachine`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStateMachineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStateMachineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStateMachineInputOperationOutputAlias,
                crate::output::UpdateStateMachineOutput,
                crate::error::UpdateStateMachineError,
                crate::input::UpdateStateMachineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn state_machine_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.state_machine_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the state machine.</p>
        pub fn set_state_machine_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_state_machine_arn(input);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn logging_configuration(mut self, inp: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(inp);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs
        /// options.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn tracing_configuration(mut self, inp: crate::model::TracingConfiguration) -> Self {
            self.inner = self.inner.tracing_configuration(inp);
            self
        }
        /// <p>Selects whether AWS X-Ray tracing is enabled.</p>
        pub fn set_tracing_configuration(
            mut self,
            input: std::option::Option<crate::model::TracingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_tracing_configuration(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
