// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Simple Email Service
///
/// Client for invoking operations on Amazon Simple Email Service. Each operation on Amazon Simple Email Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_sesv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_sesv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_sesv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSet::set_configuration_set_name): <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
    ///   - [`tracking_options(TrackingOptions)`](crate::client::fluent_builders::CreateConfigurationSet::tracking_options) / [`set_tracking_options(Option<TrackingOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_tracking_options): <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    ///   - [`delivery_options(DeliveryOptions)`](crate::client::fluent_builders::CreateConfigurationSet::delivery_options) / [`set_delivery_options(Option<DeliveryOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_delivery_options): <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    ///   - [`reputation_options(ReputationOptions)`](crate::client::fluent_builders::CreateConfigurationSet::reputation_options) / [`set_reputation_options(Option<ReputationOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_reputation_options): <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
    ///   - [`sending_options(SendingOptions)`](crate::client::fluent_builders::CreateConfigurationSet::sending_options) / [`set_sending_options(Option<SendingOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_sending_options): <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateConfigurationSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateConfigurationSet::set_tags): <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
    ///   - [`suppression_options(SuppressionOptions)`](crate::client::fluent_builders::CreateConfigurationSet::suppression_options) / [`set_suppression_options(Option<SuppressionOptions>)`](crate::client::fluent_builders::CreateConfigurationSet::set_suppression_options): <p>An object that contains information about the suppression list preferences for your account.</p>
    /// - On success, responds with [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetError>`](crate::error::CreateConfigurationSetError)
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set .</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination_name): <p>A name that identifies the event destination within the configuration set.</p>
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination): <p>An object that defines the event destination.</p>
    /// - On success, responds with [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetEventDestinationError>`](crate::error::CreateConfigurationSetEventDestinationError)
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContact`](crate::client::fluent_builders::CreateContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::CreateContact::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::CreateContact::set_contact_list_name): <p>The name of the contact list to which the contact should be added.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::CreateContact::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::CreateContact::set_email_address): <p>The contact's email address.</p>
    ///   - [`topic_preferences(Vec<TopicPreference>)`](crate::client::fluent_builders::CreateContact::topic_preferences) / [`set_topic_preferences(Option<Vec<TopicPreference>>)`](crate::client::fluent_builders::CreateContact::set_topic_preferences): <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
    ///   - [`unsubscribe_all(bool)`](crate::client::fluent_builders::CreateContact::unsubscribe_all) / [`set_unsubscribe_all(bool)`](crate::client::fluent_builders::CreateContact::set_unsubscribe_all): <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    ///   - [`attributes_data(impl Into<String>)`](crate::client::fluent_builders::CreateContact::attributes_data) / [`set_attributes_data(Option<String>)`](crate::client::fluent_builders::CreateContact::set_attributes_data): <p>The attribute data attached to a contact.</p>
    /// - On success, responds with [`CreateContactOutput`](crate::output::CreateContactOutput)

    /// - On failure, responds with [`SdkError<CreateContactError>`](crate::error::CreateContactError)
    pub fn create_contact(&self) -> fluent_builders::CreateContact {
        fluent_builders::CreateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContactList`](crate::client::fluent_builders::CreateContactList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::CreateContactList::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::CreateContactList::set_contact_list_name): <p>The name of the contact list.</p>
    ///   - [`topics(Vec<Topic>)`](crate::client::fluent_builders::CreateContactList::topics) / [`set_topics(Option<Vec<Topic>>)`](crate::client::fluent_builders::CreateContactList::set_topics): <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateContactList::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateContactList::set_description): <p>A description of what the contact list is about.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateContactList::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateContactList::set_tags): <p>The tags associated with a contact list.</p>
    /// - On success, responds with [`CreateContactListOutput`](crate::output::CreateContactListOutput)

    /// - On failure, responds with [`SdkError<CreateContactListError>`](crate::error::CreateContactListError)
    pub fn create_contact_list(&self) -> fluent_builders::CreateContactList {
        fluent_builders::CreateContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomVerificationEmailTemplate`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_subject) / [`set_template_subject(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_content) / [`set_template_content(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_content): <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    ///   - [`success_redirection_url(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::success_redirection_url) / [`set_success_redirection_url(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::failure_redirection_url) / [`set_failure_redirection_url(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On success, responds with [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<CreateCustomVerificationEmailTemplateError>`](crate::error::CreateCustomVerificationEmailTemplateError)
    pub fn create_custom_verification_email_template(
        &self,
    ) -> fluent_builders::CreateCustomVerificationEmailTemplate {
        fluent_builders::CreateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDedicatedIpPool`](crate::client::fluent_builders::CreateDedicatedIpPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::CreateDedicatedIpPool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::CreateDedicatedIpPool::set_pool_name): <p>The name of the dedicated IP pool.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDedicatedIpPool::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDedicatedIpPool::set_tags): <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
    /// - On success, responds with [`CreateDedicatedIpPoolOutput`](crate::output::CreateDedicatedIpPoolOutput)

    /// - On failure, responds with [`SdkError<CreateDedicatedIpPoolError>`](crate::error::CreateDedicatedIpPoolError)
    pub fn create_dedicated_ip_pool(&self) -> fluent_builders::CreateDedicatedIpPool {
        fluent_builders::CreateDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeliverabilityTestReport`](crate::client::fluent_builders::CreateDeliverabilityTestReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::report_name) / [`set_report_name(Option<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_report_name): <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_from_email_address): <p>The email address that the predictive inbox placement test email was sent from.</p>
    ///   - [`content(EmailContent)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::content) / [`set_content(Option<EmailContent>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_content): <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDeliverabilityTestReport::set_tags): <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
    /// - On success, responds with [`CreateDeliverabilityTestReportOutput`](crate::output::CreateDeliverabilityTestReportOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::CreateDeliverabilityTestReportOutput::report_id): <p>A unique string that identifies the predictive inbox placement test.</p>
    ///   - [`deliverability_test_status(Option<DeliverabilityTestStatus>)`](crate::output::CreateDeliverabilityTestReportOutput::deliverability_test_status): <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
    /// - On failure, responds with [`SdkError<CreateDeliverabilityTestReportError>`](crate::error::CreateDeliverabilityTestReportError)
    pub fn create_deliverability_test_report(
        &self,
    ) -> fluent_builders::CreateDeliverabilityTestReport {
        fluent_builders::CreateDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEmailIdentity`](crate::client::fluent_builders::CreateEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentity::set_email_identity): <p>The email address or domain to verify.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEmailIdentity::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEmailIdentity::set_tags): <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
    ///   - [`dkim_signing_attributes(DkimSigningAttributes)`](crate::client::fluent_builders::CreateEmailIdentity::dkim_signing_attributes) / [`set_dkim_signing_attributes(Option<DkimSigningAttributes>)`](crate::client::fluent_builders::CreateEmailIdentity::set_dkim_signing_attributes): <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>  <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentity::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentity::set_configuration_set_name): <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
    /// - On success, responds with [`CreateEmailIdentityOutput`](crate::output::CreateEmailIdentityOutput) with field(s):
    ///   - [`identity_type(Option<IdentityType>)`](crate::output::CreateEmailIdentityOutput::identity_type): <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.</p>
    ///   - [`verified_for_sending_status(bool)`](crate::output::CreateEmailIdentityOutput::verified_for_sending_status): <p>Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>
    ///   - [`dkim_attributes(Option<DkimAttributes>)`](crate::output::CreateEmailIdentityOutput::dkim_attributes): <p>An object that contains information about the DKIM attributes for the identity.</p>
    /// - On failure, responds with [`SdkError<CreateEmailIdentityError>`](crate::error::CreateEmailIdentityError)
    pub fn create_email_identity(&self) -> fluent_builders::CreateEmailIdentity {
        fluent_builders::CreateEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEmailIdentityPolicy`](crate::client::fluent_builders::CreateEmailIdentityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::set_email_identity): <p>The email identity.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::set_policy_name): <p>The name of the policy.</p>  <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateEmailIdentityPolicy::set_policy): <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>  <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    /// - On success, responds with [`CreateEmailIdentityPolicyOutput`](crate::output::CreateEmailIdentityPolicyOutput)

    /// - On failure, responds with [`SdkError<CreateEmailIdentityPolicyError>`](crate::error::CreateEmailIdentityPolicyError)
    pub fn create_email_identity_policy(&self) -> fluent_builders::CreateEmailIdentityPolicy {
        fluent_builders::CreateEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEmailTemplate`](crate::client::fluent_builders::CreateEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateEmailTemplate::set_template_name): <p>The name of the template.</p>
    ///   - [`template_content(EmailTemplateContent)`](crate::client::fluent_builders::CreateEmailTemplate::template_content) / [`set_template_content(Option<EmailTemplateContent>)`](crate::client::fluent_builders::CreateEmailTemplate::set_template_content): <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On success, responds with [`CreateEmailTemplateOutput`](crate::output::CreateEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<CreateEmailTemplateError>`](crate::error::CreateEmailTemplateError)
    pub fn create_email_template(&self) -> fluent_builders::CreateEmailTemplate {
        fluent_builders::CreateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImportJob`](crate::client::fluent_builders::CreateImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_destination(ImportDestination)`](crate::client::fluent_builders::CreateImportJob::import_destination) / [`set_import_destination(Option<ImportDestination>)`](crate::client::fluent_builders::CreateImportJob::set_import_destination): <p>The destination for the import job.</p>
    ///   - [`import_data_source(ImportDataSource)`](crate::client::fluent_builders::CreateImportJob::import_data_source) / [`set_import_data_source(Option<ImportDataSource>)`](crate::client::fluent_builders::CreateImportJob::set_import_data_source): <p>The data source for the import job.</p>
    /// - On success, responds with [`CreateImportJobOutput`](crate::output::CreateImportJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::CreateImportJobOutput::job_id): <p>A string that represents the import job ID.</p>
    /// - On failure, responds with [`SdkError<CreateImportJobError>`](crate::error::CreateImportJobError)
    pub fn create_import_job(&self) -> fluent_builders::CreateImportJob {
        fluent_builders::CreateImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::set_configuration_set_name): <p>The name of the configuration set.</p>
    /// - On success, responds with [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetError>`](crate::error::DeleteConfigurationSetError)
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that contains the event destination to delete.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_event_destination_name): <p>The name of the event destination to delete.</p>
    /// - On success, responds with [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetEventDestinationError>`](crate::error::DeleteConfigurationSetEventDestinationError)
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContact`](crate::client::fluent_builders::DeleteContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::DeleteContact::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::DeleteContact::set_contact_list_name): <p>The name of the contact list from which the contact should be removed.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::DeleteContact::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::DeleteContact::set_email_address): <p>The contact's email address.</p>
    /// - On success, responds with [`DeleteContactOutput`](crate::output::DeleteContactOutput)

    /// - On failure, responds with [`SdkError<DeleteContactError>`](crate::error::DeleteContactError)
    pub fn delete_contact(&self) -> fluent_builders::DeleteContact {
        fluent_builders::DeleteContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContactList`](crate::client::fluent_builders::DeleteContactList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::DeleteContactList::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::DeleteContactList::set_contact_list_name): <p>The name of the contact list.</p>
    /// - On success, responds with [`DeleteContactListOutput`](crate::output::DeleteContactListOutput)

    /// - On failure, responds with [`SdkError<DeleteContactListError>`](crate::error::DeleteContactListError)
    pub fn delete_contact_list(&self) -> fluent_builders::DeleteContactList {
        fluent_builders::DeleteContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomVerificationEmailTemplate`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to delete.</p>
    /// - On success, responds with [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomVerificationEmailTemplateError>`](crate::error::DeleteCustomVerificationEmailTemplateError)
    pub fn delete_custom_verification_email_template(
        &self,
    ) -> fluent_builders::DeleteCustomVerificationEmailTemplate {
        fluent_builders::DeleteCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDedicatedIpPool`](crate::client::fluent_builders::DeleteDedicatedIpPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDedicatedIpPool::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::DeleteDedicatedIpPool::set_pool_name): <p>The name of the dedicated IP pool that you want to delete.</p>
    /// - On success, responds with [`DeleteDedicatedIpPoolOutput`](crate::output::DeleteDedicatedIpPoolOutput)

    /// - On failure, responds with [`SdkError<DeleteDedicatedIpPoolError>`](crate::error::DeleteDedicatedIpPoolError)
    pub fn delete_dedicated_ip_pool(&self) -> fluent_builders::DeleteDedicatedIpPool {
        fluent_builders::DeleteDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailIdentity`](crate::client::fluent_builders::DeleteEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::DeleteEmailIdentity::set_email_identity): <p>The identity (that is, the email address or domain) to delete.</p>
    /// - On success, responds with [`DeleteEmailIdentityOutput`](crate::output::DeleteEmailIdentityOutput)

    /// - On failure, responds with [`SdkError<DeleteEmailIdentityError>`](crate::error::DeleteEmailIdentityError)
    pub fn delete_email_identity(&self) -> fluent_builders::DeleteEmailIdentity {
        fluent_builders::DeleteEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailIdentityPolicy`](crate::client::fluent_builders::DeleteEmailIdentityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailIdentityPolicy::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::DeleteEmailIdentityPolicy::set_email_identity): <p>The email identity.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailIdentityPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DeleteEmailIdentityPolicy::set_policy_name): <p>The name of the policy.</p>  <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    /// - On success, responds with [`DeleteEmailIdentityPolicyOutput`](crate::output::DeleteEmailIdentityPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteEmailIdentityPolicyError>`](crate::error::DeleteEmailIdentityPolicyError)
    pub fn delete_email_identity_policy(&self) -> fluent_builders::DeleteEmailIdentityPolicy {
        fluent_builders::DeleteEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEmailTemplate`](crate::client::fluent_builders::DeleteEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteEmailTemplate::set_template_name): <p>The name of the template to be deleted.</p>
    /// - On success, responds with [`DeleteEmailTemplateOutput`](crate::output::DeleteEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteEmailTemplateError>`](crate::error::DeleteEmailTemplateError)
    pub fn delete_email_template(&self) -> fluent_builders::DeleteEmailTemplate {
        fluent_builders::DeleteEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSuppressedDestination`](crate::client::fluent_builders::DeleteSuppressedDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::DeleteSuppressedDestination::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::DeleteSuppressedDestination::set_email_address): <p>The suppressed email destination to remove from the account suppression list.</p>
    /// - On success, responds with [`DeleteSuppressedDestinationOutput`](crate::output::DeleteSuppressedDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteSuppressedDestinationError>`](crate::error::DeleteSuppressedDestinationError)
    pub fn delete_suppressed_destination(&self) -> fluent_builders::DeleteSuppressedDestination {
        fluent_builders::DeleteSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccount`](crate::client::fluent_builders::GetAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccount::send) it.

    /// - On success, responds with [`GetAccountOutput`](crate::output::GetAccountOutput) with field(s):
    ///   - [`dedicated_ip_auto_warmup_enabled(bool)`](crate::output::GetAccountOutput::dedicated_ip_auto_warmup_enabled): <p>Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.</p>
    ///   - [`enforcement_status(Option<String>)`](crate::output::GetAccountOutput::enforcement_status): <p>The reputation status of your Amazon SES account. The status can be one of the following:</p>  <ul>   <li> <p> <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.</p> </li>   <li> <p> <code>PROBATION</code> – We've identified potential issues with your Amazon SES account. We're placing your account under review while you work on correcting these issues.</p> </li>   <li> <p> <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account's ability to send email is resumed.</p> </li>  </ul>
    ///   - [`production_access_enabled(bool)`](crate::output::GetAccountOutput::production_access_enabled): <p>Indicates whether or not your account has production access in the current Amazon Web Services Region.</p>  <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>  <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
    ///   - [`send_quota(Option<SendQuota>)`](crate::output::GetAccountOutput::send_quota): <p>An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current Amazon Web Services Region.</p>
    ///   - [`sending_enabled(bool)`](crate::output::GetAccountOutput::sending_enabled): <p>Indicates whether or not email sending is enabled for your Amazon SES account in the current Amazon Web Services Region.</p>
    ///   - [`suppression_attributes(Option<SuppressionAttributes>)`](crate::output::GetAccountOutput::suppression_attributes): <p>An object that contains information about the email address suppression preferences for your account in the current Amazon Web Services Region.</p>
    ///   - [`details(Option<AccountDetails>)`](crate::output::GetAccountOutput::details): <p>An object that defines your account details.</p>
    /// - On failure, responds with [`SdkError<GetAccountError>`](crate::error::GetAccountError)
    pub fn get_account(&self) -> fluent_builders::GetAccount {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBlacklistReports`](crate::client::fluent_builders::GetBlacklistReports) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`blacklist_item_names(Vec<String>)`](crate::client::fluent_builders::GetBlacklistReports::blacklist_item_names) / [`set_blacklist_item_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetBlacklistReports::set_blacklist_item_names): <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
    /// - On success, responds with [`GetBlacklistReportsOutput`](crate::output::GetBlacklistReportsOutput) with field(s):
    ///   - [`blacklist_report(Option<HashMap<String, Vec<BlacklistEntry>>>)`](crate::output::GetBlacklistReportsOutput::blacklist_report): <p>An object that contains information about a blacklist that one of your dedicated IP addresses appears on.</p>
    /// - On failure, responds with [`SdkError<GetBlacklistReportsError>`](crate::error::GetBlacklistReportsError)
    pub fn get_blacklist_reports(&self) -> fluent_builders::GetBlacklistReports {
        fluent_builders::GetBlacklistReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationSet`](crate::client::fluent_builders::GetConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::GetConfigurationSet::set_configuration_set_name): <p>The name of the configuration set.</p>
    /// - On success, responds with [`GetConfigurationSetOutput`](crate::output::GetConfigurationSetOutput) with field(s):
    ///   - [`configuration_set_name(Option<String>)`](crate::output::GetConfigurationSetOutput::configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`tracking_options(Option<TrackingOptions>)`](crate::output::GetConfigurationSetOutput::tracking_options): <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    ///   - [`delivery_options(Option<DeliveryOptions>)`](crate::output::GetConfigurationSetOutput::delivery_options): <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    ///   - [`reputation_options(Option<ReputationOptions>)`](crate::output::GetConfigurationSetOutput::reputation_options): <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
    ///   - [`sending_options(Option<SendingOptions>)`](crate::output::GetConfigurationSetOutput::sending_options): <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetConfigurationSetOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the configuration set.</p>
    ///   - [`suppression_options(Option<SuppressionOptions>)`](crate::output::GetConfigurationSetOutput::suppression_options): <p>An object that contains information about the suppression list preferences for your account.</p>
    /// - On failure, responds with [`SdkError<GetConfigurationSetError>`](crate::error::GetConfigurationSetError)
    pub fn get_configuration_set(&self) -> fluent_builders::GetConfigurationSet {
        fluent_builders::GetConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfigurationSetEventDestinations`](crate::client::fluent_builders::GetConfigurationSetEventDestinations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::GetConfigurationSetEventDestinations::set_configuration_set_name): <p>The name of the configuration set that contains the event destination.</p>
    /// - On success, responds with [`GetConfigurationSetEventDestinationsOutput`](crate::output::GetConfigurationSetEventDestinationsOutput) with field(s):
    ///   - [`event_destinations(Option<Vec<EventDestination>>)`](crate::output::GetConfigurationSetEventDestinationsOutput::event_destinations): <p>An array that includes all of the events destinations that have been configured for the configuration set.</p>
    /// - On failure, responds with [`SdkError<GetConfigurationSetEventDestinationsError>`](crate::error::GetConfigurationSetEventDestinationsError)
    pub fn get_configuration_set_event_destinations(
        &self,
    ) -> fluent_builders::GetConfigurationSetEventDestinations {
        fluent_builders::GetConfigurationSetEventDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContact`](crate::client::fluent_builders::GetContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::GetContact::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::GetContact::set_contact_list_name): <p>The name of the contact list to which the contact belongs.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::GetContact::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::GetContact::set_email_address): <p>The contact's email addres.</p>
    /// - On success, responds with [`GetContactOutput`](crate::output::GetContactOutput) with field(s):
    ///   - [`contact_list_name(Option<String>)`](crate::output::GetContactOutput::contact_list_name): <p>The name of the contact list to which the contact belongs.</p>
    ///   - [`email_address(Option<String>)`](crate::output::GetContactOutput::email_address): <p>The contact's email addres.</p>
    ///   - [`topic_preferences(Option<Vec<TopicPreference>>)`](crate::output::GetContactOutput::topic_preferences): <p>The contact's preference for being opted-in to or opted-out of a topic.&gt;</p>
    ///   - [`topic_default_preferences(Option<Vec<TopicPreference>>)`](crate::output::GetContactOutput::topic_default_preferences): <p>The default topic preferences applied to the contact.</p>
    ///   - [`unsubscribe_all(bool)`](crate::output::GetContactOutput::unsubscribe_all): <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    ///   - [`attributes_data(Option<String>)`](crate::output::GetContactOutput::attributes_data): <p>The attribute data attached to a contact.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::GetContactOutput::created_timestamp): <p>A timestamp noting when the contact was created.</p>
    ///   - [`last_updated_timestamp(Option<DateTime>)`](crate::output::GetContactOutput::last_updated_timestamp): <p>A timestamp noting the last time the contact's information was updated.</p>
    /// - On failure, responds with [`SdkError<GetContactError>`](crate::error::GetContactError)
    pub fn get_contact(&self) -> fluent_builders::GetContact {
        fluent_builders::GetContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContactList`](crate::client::fluent_builders::GetContactList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::GetContactList::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::GetContactList::set_contact_list_name): <p>The name of the contact list.</p>
    /// - On success, responds with [`GetContactListOutput`](crate::output::GetContactListOutput) with field(s):
    ///   - [`contact_list_name(Option<String>)`](crate::output::GetContactListOutput::contact_list_name): <p>The name of the contact list.</p>
    ///   - [`topics(Option<Vec<Topic>>)`](crate::output::GetContactListOutput::topics): <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    ///   - [`description(Option<String>)`](crate::output::GetContactListOutput::description): <p>A description of what the contact list is about.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::GetContactListOutput::created_timestamp): <p>A timestamp noting when the contact list was created.</p>
    ///   - [`last_updated_timestamp(Option<DateTime>)`](crate::output::GetContactListOutput::last_updated_timestamp): <p>A timestamp noting the last time the contact list was updated.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetContactListOutput::tags): <p>The tags associated with a contact list.</p>
    /// - On failure, responds with [`SdkError<GetContactListError>`](crate::error::GetContactListError)
    pub fn get_contact_list(&self) -> fluent_builders::GetContactList {
        fluent_builders::GetContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCustomVerificationEmailTemplate`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to retrieve.</p>
    /// - On success, responds with [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput) with field(s):
    ///   - [`template_name(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_name): <p>The name of the custom verification email template.</p>
    ///   - [`from_email_address(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_content): <p>The content of the custom verification email.</p>
    ///   - [`success_redirection_url(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On failure, responds with [`SdkError<GetCustomVerificationEmailTemplateError>`](crate::error::GetCustomVerificationEmailTemplateError)
    pub fn get_custom_verification_email_template(
        &self,
    ) -> fluent_builders::GetCustomVerificationEmailTemplate {
        fluent_builders::GetCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDedicatedIp`](crate::client::fluent_builders::GetDedicatedIp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIp::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::GetDedicatedIp::set_ip): <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
    /// - On success, responds with [`GetDedicatedIpOutput`](crate::output::GetDedicatedIpOutput) with field(s):
    ///   - [`dedicated_ip(Option<DedicatedIp>)`](crate::output::GetDedicatedIpOutput::dedicated_ip): <p>An object that contains information about a dedicated IP address.</p>
    /// - On failure, responds with [`SdkError<GetDedicatedIpError>`](crate::error::GetDedicatedIpError)
    pub fn get_dedicated_ip(&self) -> fluent_builders::GetDedicatedIp {
        fluent_builders::GetDedicatedIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDedicatedIps`](crate::client::fluent_builders::GetDedicatedIps) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDedicatedIps::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_name(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIps::pool_name) / [`set_pool_name(Option<String>)`](crate::client::fluent_builders::GetDedicatedIps::set_pool_name): <p>The name of the IP pool that the dedicated IP address is associated with.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDedicatedIps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDedicatedIps::set_next_token): <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetDedicatedIps::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::GetDedicatedIps::set_page_size): <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`GetDedicatedIpsOutput`](crate::output::GetDedicatedIpsOutput) with field(s):
    ///   - [`dedicated_ips(Option<Vec<DedicatedIp>>)`](crate::output::GetDedicatedIpsOutput::dedicated_ips): <p>A list of dedicated IP addresses that are associated with your Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDedicatedIpsOutput::next_token): <p>A token that indicates that there are additional dedicated IP addresses to list. To view additional addresses, issue another request to <code>GetDedicatedIps</code>, passing this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<GetDedicatedIpsError>`](crate::error::GetDedicatedIpsError)
    pub fn get_dedicated_ips(&self) -> fluent_builders::GetDedicatedIps {
        fluent_builders::GetDedicatedIps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeliverabilityDashboardOptions`](crate::client::fluent_builders::GetDeliverabilityDashboardOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetDeliverabilityDashboardOptions::send) it.

    /// - On success, responds with [`GetDeliverabilityDashboardOptionsOutput`](crate::output::GetDeliverabilityDashboardOptionsOutput) with field(s):
    ///   - [`dashboard_enabled(bool)`](crate::output::GetDeliverabilityDashboardOptionsOutput::dashboard_enabled): <p>Specifies whether the Deliverability dashboard is enabled. If this value is <code>true</code>, the dashboard is enabled.</p>
    ///   - [`subscription_expiry_date(Option<DateTime>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::subscription_expiry_date): <p>The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null if you have an active subscription that isn’t due to expire at the end of the month.</p>
    ///   - [`account_status(Option<DeliverabilityDashboardAccountStatus>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::account_status): <p>The current status of your Deliverability dashboard subscription. If this value is <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar month.</p>
    ///   - [`active_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::active_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.</p>
    ///   - [`pending_expiration_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::output::GetDeliverabilityDashboardOptionsOutput::pending_expiration_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.</p>
    /// - On failure, responds with [`SdkError<GetDeliverabilityDashboardOptionsError>`](crate::error::GetDeliverabilityDashboardOptionsError)
    pub fn get_deliverability_dashboard_options(
        &self,
    ) -> fluent_builders::GetDeliverabilityDashboardOptions {
        fluent_builders::GetDeliverabilityDashboardOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeliverabilityTestReport`](crate::client::fluent_builders::GetDeliverabilityTestReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::GetDeliverabilityTestReport::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::GetDeliverabilityTestReport::set_report_id): <p>A unique string that identifies the predictive inbox placement test.</p>
    /// - On success, responds with [`GetDeliverabilityTestReportOutput`](crate::output::GetDeliverabilityTestReportOutput) with field(s):
    ///   - [`deliverability_test_report(Option<DeliverabilityTestReport>)`](crate::output::GetDeliverabilityTestReportOutput::deliverability_test_report): <p>An object that contains the results of the predictive inbox placement test.</p>
    ///   - [`overall_placement(Option<PlacementStatistics>)`](crate::output::GetDeliverabilityTestReportOutput::overall_placement): <p>An object that specifies how many test messages that were sent during the predictive inbox placement test were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many weren't delivered.</p>
    ///   - [`isp_placements(Option<Vec<IspPlacement>>)`](crate::output::GetDeliverabilityTestReportOutput::isp_placements): <p>An object that describes how the test email was handled by several email providers, including Gmail, Hotmail, Yahoo, AOL, and others.</p>
    ///   - [`message(Option<String>)`](crate::output::GetDeliverabilityTestReportOutput::message): <p>An object that contains the message that you sent when you performed this predictive inbox placement test.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetDeliverabilityTestReportOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the predictive inbox placement test.</p>
    /// - On failure, responds with [`SdkError<GetDeliverabilityTestReportError>`](crate::error::GetDeliverabilityTestReportError)
    pub fn get_deliverability_test_report(&self) -> fluent_builders::GetDeliverabilityTestReport {
        fluent_builders::GetDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainDeliverabilityCampaign`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign::set_campaign_id): <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
    /// - On success, responds with [`GetDomainDeliverabilityCampaignOutput`](crate::output::GetDomainDeliverabilityCampaignOutput) with field(s):
    ///   - [`domain_deliverability_campaign(Option<DomainDeliverabilityCampaign>)`](crate::output::GetDomainDeliverabilityCampaignOutput::domain_deliverability_campaign): <p>An object that contains the deliverability data for the campaign.</p>
    /// - On failure, responds with [`SdkError<GetDomainDeliverabilityCampaignError>`](crate::error::GetDomainDeliverabilityCampaignError)
    pub fn get_domain_deliverability_campaign(
        &self,
    ) -> fluent_builders::GetDomainDeliverabilityCampaign {
        fluent_builders::GetDomainDeliverabilityCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainStatisticsReport`](crate::client::fluent_builders::GetDomainStatisticsReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetDomainStatisticsReport::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_domain): <p>The domain that you want to obtain deliverability metrics for.</p>
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::GetDomainStatisticsReport::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_start_date): <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::GetDomainStatisticsReport::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::GetDomainStatisticsReport::set_end_date): <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
    /// - On success, responds with [`GetDomainStatisticsReportOutput`](crate::output::GetDomainStatisticsReportOutput) with field(s):
    ///   - [`overall_volume(Option<OverallVolume>)`](crate::output::GetDomainStatisticsReportOutput::overall_volume): <p>An object that contains deliverability metrics for the domain that you specified. The data in this object is a summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.</p>
    ///   - [`daily_volumes(Option<Vec<DailyVolume>>)`](crate::output::GetDomainStatisticsReportOutput::daily_volumes): <p>An object that contains deliverability metrics for the domain that you specified. This object contains data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.</p>
    /// - On failure, responds with [`SdkError<GetDomainStatisticsReportError>`](crate::error::GetDomainStatisticsReportError)
    pub fn get_domain_statistics_report(&self) -> fluent_builders::GetDomainStatisticsReport {
        fluent_builders::GetDomainStatisticsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailIdentity`](crate::client::fluent_builders::GetEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::GetEmailIdentity::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::GetEmailIdentity::set_email_identity): <p>The email identity.</p>
    /// - On success, responds with [`GetEmailIdentityOutput`](crate::output::GetEmailIdentityOutput) with field(s):
    ///   - [`identity_type(Option<IdentityType>)`](crate::output::GetEmailIdentityOutput::identity_type): <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> identity type is not supported.</p>
    ///   - [`feedback_forwarding_status(bool)`](crate::output::GetEmailIdentityOutput::feedback_forwarding_status): <p>The feedback forwarding configuration for the identity.</p>  <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>  <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
    ///   - [`verified_for_sending_status(bool)`](crate::output::GetEmailIdentityOutput::verified_for_sending_status): <p>Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>
    ///   - [`dkim_attributes(Option<DkimAttributes>)`](crate::output::GetEmailIdentityOutput::dkim_attributes): <p>An object that contains information about the DKIM attributes for the identity.</p>
    ///   - [`mail_from_attributes(Option<MailFromAttributes>)`](crate::output::GetEmailIdentityOutput::mail_from_attributes): <p>An object that contains information about the Mail-From attributes for the email identity.</p>
    ///   - [`policies(Option<HashMap<String, String>>)`](crate::output::GetEmailIdentityOutput::policies): <p>A map of policy names to policies.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetEmailIdentityOutput::tags): <p>An array of objects that define the tags (keys and values) that are associated with the email identity.</p>
    ///   - [`configuration_set_name(Option<String>)`](crate::output::GetEmailIdentityOutput::configuration_set_name): <p>The configuration set used by default when sending from this identity.</p>
    /// - On failure, responds with [`SdkError<GetEmailIdentityError>`](crate::error::GetEmailIdentityError)
    pub fn get_email_identity(&self) -> fluent_builders::GetEmailIdentity {
        fluent_builders::GetEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailIdentityPolicies`](crate::client::fluent_builders::GetEmailIdentityPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::GetEmailIdentityPolicies::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::GetEmailIdentityPolicies::set_email_identity): <p>The email identity.</p>
    /// - On success, responds with [`GetEmailIdentityPoliciesOutput`](crate::output::GetEmailIdentityPoliciesOutput) with field(s):
    ///   - [`policies(Option<HashMap<String, String>>)`](crate::output::GetEmailIdentityPoliciesOutput::policies): <p>A map of policy names to policies.</p>
    /// - On failure, responds with [`SdkError<GetEmailIdentityPoliciesError>`](crate::error::GetEmailIdentityPoliciesError)
    pub fn get_email_identity_policies(&self) -> fluent_builders::GetEmailIdentityPolicies {
        fluent_builders::GetEmailIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEmailTemplate`](crate::client::fluent_builders::GetEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetEmailTemplate::set_template_name): <p>The name of the template.</p>
    /// - On success, responds with [`GetEmailTemplateOutput`](crate::output::GetEmailTemplateOutput) with field(s):
    ///   - [`template_name(Option<String>)`](crate::output::GetEmailTemplateOutput::template_name): <p>The name of the template.</p>
    ///   - [`template_content(Option<EmailTemplateContent>)`](crate::output::GetEmailTemplateOutput::template_content): <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On failure, responds with [`SdkError<GetEmailTemplateError>`](crate::error::GetEmailTemplateError)
    pub fn get_email_template(&self) -> fluent_builders::GetEmailTemplate {
        fluent_builders::GetEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImportJob`](crate::client::fluent_builders::GetImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetImportJob::set_job_id): <p>The ID of the import job.</p>
    /// - On success, responds with [`GetImportJobOutput`](crate::output::GetImportJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::GetImportJobOutput::job_id): <p>A string that represents the import job ID.</p>
    ///   - [`import_destination(Option<ImportDestination>)`](crate::output::GetImportJobOutput::import_destination): <p>The destination of the import job.</p>
    ///   - [`import_data_source(Option<ImportDataSource>)`](crate::output::GetImportJobOutput::import_data_source): <p>The data source of the import job.</p>
    ///   - [`failure_info(Option<FailureInfo>)`](crate::output::GetImportJobOutput::failure_info): <p>The failure details about an import job.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::GetImportJobOutput::job_status): <p>The status of the import job.</p>
    ///   - [`created_timestamp(Option<DateTime>)`](crate::output::GetImportJobOutput::created_timestamp): <p>The time stamp of when the import job was created.</p>
    ///   - [`completed_timestamp(Option<DateTime>)`](crate::output::GetImportJobOutput::completed_timestamp): <p>The time stamp of when the import job was completed.</p>
    ///   - [`processed_records_count(Option<i32>)`](crate::output::GetImportJobOutput::processed_records_count): <p>The current number of records processed.</p>
    ///   - [`failed_records_count(Option<i32>)`](crate::output::GetImportJobOutput::failed_records_count): <p>The number of records that failed processing because of invalid input or other reasons.</p>
    /// - On failure, responds with [`SdkError<GetImportJobError>`](crate::error::GetImportJobError)
    pub fn get_import_job(&self) -> fluent_builders::GetImportJob {
        fluent_builders::GetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSuppressedDestination`](crate::client::fluent_builders::GetSuppressedDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::GetSuppressedDestination::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::GetSuppressedDestination::set_email_address): <p>The email address that's on the account suppression list.</p>
    /// - On success, responds with [`GetSuppressedDestinationOutput`](crate::output::GetSuppressedDestinationOutput) with field(s):
    ///   - [`suppressed_destination(Option<SuppressedDestination>)`](crate::output::GetSuppressedDestinationOutput::suppressed_destination): <p>An object containing information about the suppressed email address.</p>
    /// - On failure, responds with [`SdkError<GetSuppressedDestinationError>`](crate::error::GetSuppressedDestinationError)
    pub fn get_suppressed_destination(&self) -> fluent_builders::GetSuppressedDestination {
        fluent_builders::GetSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConfigurationSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationSets::set_next_token): <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListConfigurationSets::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListConfigurationSets::set_page_size): <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput) with field(s):
    ///   - [`configuration_sets(Option<Vec<String>>)`](crate::output::ListConfigurationSetsOutput::configuration_sets): <p>An array that contains all of the configuration sets in your Amazon SES account in the current Amazon Web Services Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationSetsOutput::next_token): <p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListConfigurationSetsError>`](crate::error::ListConfigurationSetsError)
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContactLists`](crate::client::fluent_builders::ListContactLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContactLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListContactLists::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListContactLists::set_page_size): <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContactLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContactLists::set_next_token): <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
    /// - On success, responds with [`ListContactListsOutput`](crate::output::ListContactListsOutput) with field(s):
    ///   - [`contact_lists(Option<Vec<ContactList>>)`](crate::output::ListContactListsOutput::contact_lists): <p>The available contact lists.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContactListsOutput::next_token): <p>A string token indicating that there might be additional contact lists available to be listed. Copy this token to a subsequent call to <code>ListContactLists</code> with the same parameters to retrieve the next page of contact lists.</p>
    /// - On failure, responds with [`SdkError<ListContactListsError>`](crate::error::ListContactListsError)
    pub fn list_contact_lists(&self) -> fluent_builders::ListContactLists {
        fluent_builders::ListContactLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContacts`](crate::client::fluent_builders::ListContacts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContacts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::ListContacts::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::ListContacts::set_contact_list_name): <p>The name of the contact list.</p>
    ///   - [`filter(ListContactsFilter)`](crate::client::fluent_builders::ListContacts::filter) / [`set_filter(Option<ListContactsFilter>)`](crate::client::fluent_builders::ListContacts::set_filter): <p>A filter that can be applied to a list of contacts.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListContacts::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListContacts::set_page_size): <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContacts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContacts::set_next_token): <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
    /// - On success, responds with [`ListContactsOutput`](crate::output::ListContactsOutput) with field(s):
    ///   - [`contacts(Option<Vec<Contact>>)`](crate::output::ListContactsOutput::contacts): <p>The contacts present in a specific contact list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContactsOutput::next_token): <p>A string token indicating that there might be additional contacts available to be listed. Copy this token to a subsequent call to <code>ListContacts</code> with the same parameters to retrieve the next page of contacts.</p>
    /// - On failure, responds with [`SdkError<ListContactsError>`](crate::error::ListContactsError)
    pub fn list_contacts(&self) -> fluent_builders::ListContacts {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomVerificationEmailTemplates`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::set_next_token): <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::set_page_size): <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 1, and can be no more than 50.</p>
    /// - On success, responds with [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput) with field(s):
    ///   - [`custom_verification_email_templates(Option<Vec<CustomVerificationEmailTemplateMetadata>>)`](crate::output::ListCustomVerificationEmailTemplatesOutput::custom_verification_email_templates): <p>A list of the custom verification email templates that exist in your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomVerificationEmailTemplatesOutput::next_token): <p>A token indicating that there are additional custom verification email templates available to be listed. Pass this token to a subsequent call to <code>ListCustomVerificationEmailTemplates</code> to retrieve the next 50 custom verification email templates.</p>
    /// - On failure, responds with [`SdkError<ListCustomVerificationEmailTemplatesError>`](crate::error::ListCustomVerificationEmailTemplatesError)
    pub fn list_custom_verification_email_templates(
        &self,
    ) -> fluent_builders::ListCustomVerificationEmailTemplates {
        fluent_builders::ListCustomVerificationEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDedicatedIpPools`](crate::client::fluent_builders::ListDedicatedIpPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDedicatedIpPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDedicatedIpPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDedicatedIpPools::set_next_token): <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDedicatedIpPools::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDedicatedIpPools::set_page_size): <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListDedicatedIpPoolsOutput`](crate::output::ListDedicatedIpPoolsOutput) with field(s):
    ///   - [`dedicated_ip_pools(Option<Vec<String>>)`](crate::output::ListDedicatedIpPoolsOutput::dedicated_ip_pools): <p>A list of all of the dedicated IP pools that are associated with your Amazon Web Services account in the current Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDedicatedIpPoolsOutput::next_token): <p>A token that indicates that there are additional IP pools to list. To view additional IP pools, issue another request to <code>ListDedicatedIpPools</code>, passing this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListDedicatedIpPoolsError>`](crate::error::ListDedicatedIpPoolsError)
    pub fn list_dedicated_ip_pools(&self) -> fluent_builders::ListDedicatedIpPools {
        fluent_builders::ListDedicatedIpPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeliverabilityTestReports`](crate::client::fluent_builders::ListDeliverabilityTestReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeliverabilityTestReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::set_next_token): <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDeliverabilityTestReports::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDeliverabilityTestReports::set_page_size): <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    /// - On success, responds with [`ListDeliverabilityTestReportsOutput`](crate::output::ListDeliverabilityTestReportsOutput) with field(s):
    ///   - [`deliverability_test_reports(Option<Vec<DeliverabilityTestReport>>)`](crate::output::ListDeliverabilityTestReportsOutput::deliverability_test_reports): <p>An object that contains a lists of predictive inbox placement tests that you've performed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeliverabilityTestReportsOutput::next_token): <p>A token that indicates that there are additional predictive inbox placement tests to list. To view additional predictive inbox placement tests, issue another request to <code>ListDeliverabilityTestReports</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListDeliverabilityTestReportsError>`](crate::error::ListDeliverabilityTestReportsError)
    pub fn list_deliverability_test_reports(
        &self,
    ) -> fluent_builders::ListDeliverabilityTestReports {
        fluent_builders::ListDeliverabilityTestReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainDeliverabilityCampaigns`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_start_date): <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_end_date): <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
    ///   - [`subscribed_domain(impl Into<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::subscribed_domain) / [`set_subscribed_domain(Option<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_subscribed_domain): <p>The domain to obtain deliverability data for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_next_token): <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns::set_page_size): <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListDomainDeliverabilityCampaignsOutput`](crate::output::ListDomainDeliverabilityCampaignsOutput) with field(s):
    ///   - [`domain_deliverability_campaigns(Option<Vec<DomainDeliverabilityCampaign>>)`](crate::output::ListDomainDeliverabilityCampaignsOutput::domain_deliverability_campaigns): <p>An array of responses, one for each campaign that used the domain to send email during the specified time range.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainDeliverabilityCampaignsOutput::next_token): <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of the campaign in the list of campaigns.</p>
    /// - On failure, responds with [`SdkError<ListDomainDeliverabilityCampaignsError>`](crate::error::ListDomainDeliverabilityCampaignsError)
    pub fn list_domain_deliverability_campaigns(
        &self,
    ) -> fluent_builders::ListDomainDeliverabilityCampaigns {
        fluent_builders::ListDomainDeliverabilityCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEmailIdentities`](crate::client::fluent_builders::ListEmailIdentities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEmailIdentities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEmailIdentities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEmailIdentities::set_next_token): <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListEmailIdentities::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListEmailIdentities::set_page_size): <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    /// - On success, responds with [`ListEmailIdentitiesOutput`](crate::output::ListEmailIdentitiesOutput) with field(s):
    ///   - [`email_identities(Option<Vec<IdentityInfo>>)`](crate::output::ListEmailIdentitiesOutput::email_identities): <p>An array that includes all of the email identities associated with your Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEmailIdentitiesOutput::next_token): <p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListEmailIdentitiesError>`](crate::error::ListEmailIdentitiesError)
    pub fn list_email_identities(&self) -> fluent_builders::ListEmailIdentities {
        fluent_builders::ListEmailIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEmailTemplates`](crate::client::fluent_builders::ListEmailTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEmailTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEmailTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEmailTemplates::set_next_token): <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListEmailTemplates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListEmailTemplates::set_page_size): <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>  <p>The value you specify has to be at least 1, and can be no more than 10.</p>
    /// - On success, responds with [`ListEmailTemplatesOutput`](crate::output::ListEmailTemplatesOutput) with field(s):
    ///   - [`templates_metadata(Option<Vec<EmailTemplateMetadata>>)`](crate::output::ListEmailTemplatesOutput::templates_metadata): <p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEmailTemplatesOutput::next_token): <p>A token indicating that there are additional email templates available to be listed. Pass this token to a subsequent <code>ListEmailTemplates</code> call to retrieve the next 10 email templates.</p>
    /// - On failure, responds with [`SdkError<ListEmailTemplatesError>`](crate::error::ListEmailTemplatesError)
    pub fn list_email_templates(&self) -> fluent_builders::ListEmailTemplates {
        fluent_builders::ListEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImportJobs`](crate::client::fluent_builders::ListImportJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImportJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_destination_type(ImportDestinationType)`](crate::client::fluent_builders::ListImportJobs::import_destination_type) / [`set_import_destination_type(Option<ImportDestinationType>)`](crate::client::fluent_builders::ListImportJobs::set_import_destination_type): <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImportJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImportJobs::set_next_token): <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListImportJobs::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListImportJobs::set_page_size): <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
    /// - On success, responds with [`ListImportJobsOutput`](crate::output::ListImportJobsOutput) with field(s):
    ///   - [`import_jobs(Option<Vec<ImportJobSummary>>)`](crate::output::ListImportJobsOutput::import_jobs): <p>A list of the import job summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImportJobsOutput::next_token): <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
    /// - On failure, responds with [`SdkError<ListImportJobsError>`](crate::error::ListImportJobsError)
    pub fn list_import_jobs(&self) -> fluent_builders::ListImportJobs {
        fluent_builders::ListImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSuppressedDestinations`](crate::client::fluent_builders::ListSuppressedDestinations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSuppressedDestinations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reasons(Vec<SuppressionListReason>)`](crate::client::fluent_builders::ListSuppressedDestinations::reasons) / [`set_reasons(Option<Vec<SuppressionListReason>>)`](crate::client::fluent_builders::ListSuppressedDestinations::set_reasons): <p>The factors that caused the email address to be added to .</p>
    ///   - [`start_date(DateTime)`](crate::client::fluent_builders::ListSuppressedDestinations::start_date) / [`set_start_date(Option<DateTime>)`](crate::client::fluent_builders::ListSuppressedDestinations::set_start_date): <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::ListSuppressedDestinations::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::ListSuppressedDestinations::set_end_date): <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSuppressedDestinations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSuppressedDestinations::set_next_token): <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListSuppressedDestinations::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListSuppressedDestinations::set_page_size): <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// - On success, responds with [`ListSuppressedDestinationsOutput`](crate::output::ListSuppressedDestinationsOutput) with field(s):
    ///   - [`suppressed_destination_summaries(Option<Vec<SuppressedDestinationSummary>>)`](crate::output::ListSuppressedDestinationsOutput::suppressed_destination_summaries): <p>A list of summaries, each containing a summary for a suppressed email destination.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSuppressedDestinationsOutput::next_token): <p>A token that indicates that there are additional email addresses on the suppression list for your account. To view additional suppressed addresses, issue another request to <code>ListSuppressedDestinations</code>, and pass this token in the <code>NextToken</code> parameter.</p>
    /// - On failure, responds with [`SdkError<ListSuppressedDestinationsError>`](crate::error::ListSuppressedDestinationsError)
    pub fn list_suppressed_destinations(&self) -> fluent_builders::ListSuppressedDestinations {
        fluent_builders::ListSuppressedDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array that lists all the tags that are associated with the resource. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>)</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_warmup_enabled(bool)`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes::auto_warmup_enabled) / [`set_auto_warmup_enabled(bool)`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes::set_auto_warmup_enabled): <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
    /// - On success, responds with [`PutAccountDedicatedIpWarmupAttributesOutput`](crate::output::PutAccountDedicatedIpWarmupAttributesOutput)

    /// - On failure, responds with [`SdkError<PutAccountDedicatedIpWarmupAttributesError>`](crate::error::PutAccountDedicatedIpWarmupAttributesError)
    pub fn put_account_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutAccountDedicatedIpWarmupAttributes {
        fluent_builders::PutAccountDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountDetails`](crate::client::fluent_builders::PutAccountDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mail_type(MailType)`](crate::client::fluent_builders::PutAccountDetails::mail_type) / [`set_mail_type(Option<MailType>)`](crate::client::fluent_builders::PutAccountDetails::set_mail_type): <p>The type of email your account will send.</p>
    ///   - [`website_url(impl Into<String>)`](crate::client::fluent_builders::PutAccountDetails::website_url) / [`set_website_url(Option<String>)`](crate::client::fluent_builders::PutAccountDetails::set_website_url): <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
    ///   - [`contact_language(ContactLanguage)`](crate::client::fluent_builders::PutAccountDetails::contact_language) / [`set_contact_language(Option<ContactLanguage>)`](crate::client::fluent_builders::PutAccountDetails::set_contact_language): <p>The language you would prefer to be contacted with.</p>
    ///   - [`use_case_description(impl Into<String>)`](crate::client::fluent_builders::PutAccountDetails::use_case_description) / [`set_use_case_description(Option<String>)`](crate::client::fluent_builders::PutAccountDetails::set_use_case_description): <p>A description of the types of email that you plan to send.</p>
    ///   - [`additional_contact_email_addresses(Vec<String>)`](crate::client::fluent_builders::PutAccountDetails::additional_contact_email_addresses) / [`set_additional_contact_email_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::PutAccountDetails::set_additional_contact_email_addresses): <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
    ///   - [`production_access_enabled(bool)`](crate::client::fluent_builders::PutAccountDetails::production_access_enabled) / [`set_production_access_enabled(Option<bool>)`](crate::client::fluent_builders::PutAccountDetails::set_production_access_enabled): <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>  <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>  <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
    /// - On success, responds with [`PutAccountDetailsOutput`](crate::output::PutAccountDetailsOutput)

    /// - On failure, responds with [`SdkError<PutAccountDetailsError>`](crate::error::PutAccountDetailsError)
    pub fn put_account_details(&self) -> fluent_builders::PutAccountDetails {
        fluent_builders::PutAccountDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountSendingAttributes`](crate::client::fluent_builders::PutAccountSendingAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sending_enabled(bool)`](crate::client::fluent_builders::PutAccountSendingAttributes::sending_enabled) / [`set_sending_enabled(bool)`](crate::client::fluent_builders::PutAccountSendingAttributes::set_sending_enabled): <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>   <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>  </note>
    /// - On success, responds with [`PutAccountSendingAttributesOutput`](crate::output::PutAccountSendingAttributesOutput)

    /// - On failure, responds with [`SdkError<PutAccountSendingAttributesError>`](crate::error::PutAccountSendingAttributesError)
    pub fn put_account_sending_attributes(&self) -> fluent_builders::PutAccountSendingAttributes {
        fluent_builders::PutAccountSendingAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountSuppressionAttributes`](crate::client::fluent_builders::PutAccountSuppressionAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`suppressed_reasons(Vec<SuppressionListReason>)`](crate::client::fluent_builders::PutAccountSuppressionAttributes::suppressed_reasons) / [`set_suppressed_reasons(Option<Vec<SuppressionListReason>>)`](crate::client::fluent_builders::PutAccountSuppressionAttributes::set_suppressed_reasons): <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>  <ul>   <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>   <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>  </ul>
    /// - On success, responds with [`PutAccountSuppressionAttributesOutput`](crate::output::PutAccountSuppressionAttributesOutput)

    /// - On failure, responds with [`SdkError<PutAccountSuppressionAttributesError>`](crate::error::PutAccountSuppressionAttributesError)
    pub fn put_account_suppression_attributes(
        &self,
    ) -> fluent_builders::PutAccountSuppressionAttributes {
        fluent_builders::PutAccountSuppressionAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetDeliveryOptions`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_configuration_set_name): <p>The name of the configuration set to associate with a dedicated IP pool.</p>
    ///   - [`tls_policy(TlsPolicy)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::tls_policy) / [`set_tls_policy(Option<TlsPolicy>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_tls_policy): <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
    ///   - [`sending_pool_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::sending_pool_name) / [`set_sending_pool_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_sending_pool_name): <p>The name of the dedicated IP pool to associate with the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetDeliveryOptionsError>`](crate::error::PutConfigurationSetDeliveryOptionsError)
    pub fn put_configuration_set_delivery_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetDeliveryOptions {
        fluent_builders::PutConfigurationSetDeliveryOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetReputationOptions`](crate::client::fluent_builders::PutConfigurationSetReputationOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::set_configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`reputation_metrics_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::reputation_metrics_enabled) / [`set_reputation_metrics_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetReputationOptions::set_reputation_metrics_enabled): <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetReputationOptionsOutput`](crate::output::PutConfigurationSetReputationOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetReputationOptionsError>`](crate::error::PutConfigurationSetReputationOptionsError)
    pub fn put_configuration_set_reputation_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetReputationOptions {
        fluent_builders::PutConfigurationSetReputationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetSendingOptions`](crate::client::fluent_builders::PutConfigurationSetSendingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::set_configuration_set_name): <p>The name of the configuration set to enable or disable email sending for.</p>
    ///   - [`sending_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::sending_enabled) / [`set_sending_enabled(bool)`](crate::client::fluent_builders::PutConfigurationSetSendingOptions::set_sending_enabled): <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
    /// - On success, responds with [`PutConfigurationSetSendingOptionsOutput`](crate::output::PutConfigurationSetSendingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetSendingOptionsError>`](crate::error::PutConfigurationSetSendingOptionsError)
    pub fn put_configuration_set_sending_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetSendingOptions {
        fluent_builders::PutConfigurationSetSendingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetSuppressionOptions`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions::set_configuration_set_name): <p>The name of the configuration set to change the suppression list preferences for.</p>
    ///   - [`suppressed_reasons(Vec<SuppressionListReason>)`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions::suppressed_reasons) / [`set_suppressed_reasons(Option<Vec<SuppressionListReason>>)`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions::set_suppressed_reasons): <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>  <ul>   <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>   <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>  </ul>
    /// - On success, responds with [`PutConfigurationSetSuppressionOptionsOutput`](crate::output::PutConfigurationSetSuppressionOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetSuppressionOptionsError>`](crate::error::PutConfigurationSetSuppressionOptionsError)
    pub fn put_configuration_set_suppression_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetSuppressionOptions {
        fluent_builders::PutConfigurationSetSuppressionOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetTrackingOptions`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::set_configuration_set_name): <p>The name of the configuration set.</p>
    ///   - [`custom_redirect_domain(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::custom_redirect_domain) / [`set_custom_redirect_domain(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions::set_custom_redirect_domain): <p>The domain to use to track open and click events.</p>
    /// - On success, responds with [`PutConfigurationSetTrackingOptionsOutput`](crate::output::PutConfigurationSetTrackingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetTrackingOptionsError>`](crate::error::PutConfigurationSetTrackingOptionsError)
    pub fn put_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetTrackingOptions {
        fluent_builders::PutConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDedicatedIpInPool`](crate::client::fluent_builders::PutDedicatedIpInPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::set_ip): <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
    ///   - [`destination_pool_name(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::destination_pool_name) / [`set_destination_pool_name(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpInPool::set_destination_pool_name): <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
    /// - On success, responds with [`PutDedicatedIpInPoolOutput`](crate::output::PutDedicatedIpInPoolOutput)

    /// - On failure, responds with [`SdkError<PutDedicatedIpInPoolError>`](crate::error::PutDedicatedIpInPoolError)
    pub fn put_dedicated_ip_in_pool(&self) -> fluent_builders::PutDedicatedIpInPool {
        fluent_builders::PutDedicatedIpInPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip(impl Into<String>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::ip) / [`set_ip(Option<String>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::set_ip): <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
    ///   - [`warmup_percentage(i32)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::warmup_percentage) / [`set_warmup_percentage(Option<i32>)`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes::set_warmup_percentage): <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
    /// - On success, responds with [`PutDedicatedIpWarmupAttributesOutput`](crate::output::PutDedicatedIpWarmupAttributesOutput)

    /// - On failure, responds with [`SdkError<PutDedicatedIpWarmupAttributesError>`](crate::error::PutDedicatedIpWarmupAttributesError)
    pub fn put_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutDedicatedIpWarmupAttributes {
        fluent_builders::PutDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDeliverabilityDashboardOption`](crate::client::fluent_builders::PutDeliverabilityDashboardOption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dashboard_enabled(bool)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::dashboard_enabled) / [`set_dashboard_enabled(bool)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::set_dashboard_enabled): <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
    ///   - [`subscribed_domains(Vec<DomainDeliverabilityTrackingOption>)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::subscribed_domains) / [`set_subscribed_domains(Option<Vec<DomainDeliverabilityTrackingOption>>)`](crate::client::fluent_builders::PutDeliverabilityDashboardOption::set_subscribed_domains): <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
    /// - On success, responds with [`PutDeliverabilityDashboardOptionOutput`](crate::output::PutDeliverabilityDashboardOptionOutput)

    /// - On failure, responds with [`SdkError<PutDeliverabilityDashboardOptionError>`](crate::error::PutDeliverabilityDashboardOptionError)
    pub fn put_deliverability_dashboard_option(
        &self,
    ) -> fluent_builders::PutDeliverabilityDashboardOption {
        fluent_builders::PutDeliverabilityDashboardOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityConfigurationSetAttributes`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes::set_email_identity): <p>The email address or domain to associate with a configuration set.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes::set_configuration_set_name): <p>The configuration set to associate with an email identity.</p>
    /// - On success, responds with [`PutEmailIdentityConfigurationSetAttributesOutput`](crate::output::PutEmailIdentityConfigurationSetAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityConfigurationSetAttributesError>`](crate::error::PutEmailIdentityConfigurationSetAttributesError)
    pub fn put_email_identity_configuration_set_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityConfigurationSetAttributes {
        fluent_builders::PutEmailIdentityConfigurationSetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityDkimAttributes`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::set_email_identity): <p>The email identity.</p>
    ///   - [`signing_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::signing_enabled) / [`set_signing_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes::set_signing_enabled): <p>Sets the DKIM signing configuration for the identity.</p>  <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
    /// - On success, responds with [`PutEmailIdentityDkimAttributesOutput`](crate::output::PutEmailIdentityDkimAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityDkimAttributesError>`](crate::error::PutEmailIdentityDkimAttributesError)
    pub fn put_email_identity_dkim_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityDkimAttributes {
        fluent_builders::PutEmailIdentityDkimAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityDkimSigningAttributes`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::set_email_identity): <p>The email identity.</p>
    ///   - [`signing_attributes_origin(DkimSigningAttributesOrigin)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::signing_attributes_origin) / [`set_signing_attributes_origin(Option<DkimSigningAttributesOrigin>)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::set_signing_attributes_origin): <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>  <ul>   <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>   <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>  </ul>
    ///   - [`signing_attributes(DkimSigningAttributes)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::signing_attributes) / [`set_signing_attributes(Option<DkimSigningAttributes>)`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes::set_signing_attributes): <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// - On success, responds with [`PutEmailIdentityDkimSigningAttributesOutput`](crate::output::PutEmailIdentityDkimSigningAttributesOutput) with field(s):
    ///   - [`dkim_status(Option<DkimStatus>)`](crate::output::PutEmailIdentityDkimSigningAttributesOutput::dkim_status): <p>The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for specific records in the DNS configuration for your domain. If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.</p>  <p>If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that's paired with the private key that you specified in the process of creating the identity.</p>  <p>The status can be one of the following:</p>  <ul>   <li> <p> <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn't yet detected the DKIM records in the DNS configuration for the domain.</p> </li>   <li> <p> <code>SUCCESS</code> – The verification process completed successfully.</p> </li>   <li> <p> <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.</p> </li>   <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.</p> </li>   <li> <p> <code>NOT_STARTED</code> – The DKIM verification process hasn't been initiated for the domain.</p> </li>  </ul>
    ///   - [`dkim_tokens(Option<Vec<String>>)`](crate::output::PutEmailIdentityDkimSigningAttributesOutput::dkim_tokens): <p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.</p>  <p>If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector that's associated with your public key.</p>  <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.</p>
    /// - On failure, responds with [`SdkError<PutEmailIdentityDkimSigningAttributesError>`](crate::error::PutEmailIdentityDkimSigningAttributesError)
    pub fn put_email_identity_dkim_signing_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityDkimSigningAttributes {
        fluent_builders::PutEmailIdentityDkimSigningAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityFeedbackAttributes`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::set_email_identity): <p>The email identity.</p>
    ///   - [`email_forwarding_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::email_forwarding_enabled) / [`set_email_forwarding_enabled(bool)`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes::set_email_forwarding_enabled): <p>Sets the feedback forwarding configuration for the identity.</p>  <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>  <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
    /// - On success, responds with [`PutEmailIdentityFeedbackAttributesOutput`](crate::output::PutEmailIdentityFeedbackAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityFeedbackAttributesError>`](crate::error::PutEmailIdentityFeedbackAttributesError)
    pub fn put_email_identity_feedback_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityFeedbackAttributes {
        fluent_builders::PutEmailIdentityFeedbackAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutEmailIdentityMailFromAttributes`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_email_identity): <p>The verified email identity.</p>
    ///   - [`mail_from_domain(impl Into<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::mail_from_domain) / [`set_mail_from_domain(Option<String>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_mail_from_domain): <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>  <ul>   <li> <p>It has to be a subdomain of the verified identity.</p> </li>   <li> <p>It can't be used to receive email.</p> </li>   <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>  </ul>
    ///   - [`behavior_on_mx_failure(BehaviorOnMxFailure)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::behavior_on_mx_failure) / [`set_behavior_on_mx_failure(Option<BehaviorOnMxFailure>)`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes::set_behavior_on_mx_failure): <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>  <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
    /// - On success, responds with [`PutEmailIdentityMailFromAttributesOutput`](crate::output::PutEmailIdentityMailFromAttributesOutput)

    /// - On failure, responds with [`SdkError<PutEmailIdentityMailFromAttributesError>`](crate::error::PutEmailIdentityMailFromAttributesError)
    pub fn put_email_identity_mail_from_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityMailFromAttributes {
        fluent_builders::PutEmailIdentityMailFromAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSuppressedDestination`](crate::client::fluent_builders::PutSuppressedDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::PutSuppressedDestination::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::PutSuppressedDestination::set_email_address): <p>The email address that should be added to the suppression list for your account.</p>
    ///   - [`reason(SuppressionListReason)`](crate::client::fluent_builders::PutSuppressedDestination::reason) / [`set_reason(Option<SuppressionListReason>)`](crate::client::fluent_builders::PutSuppressedDestination::set_reason): <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
    /// - On success, responds with [`PutSuppressedDestinationOutput`](crate::output::PutSuppressedDestinationOutput)

    /// - On failure, responds with [`SdkError<PutSuppressedDestinationError>`](crate::error::PutSuppressedDestinationError)
    pub fn put_suppressed_destination(&self) -> fluent_builders::PutSuppressedDestination {
        fluent_builders::PutSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendBulkEmail`](crate::client::fluent_builders::SendBulkEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::SendBulkEmail::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::SendBulkEmail::set_from_email_address): <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
    ///   - [`from_email_address_identity_arn(impl Into<String>)`](crate::client::fluent_builders::SendBulkEmail::from_email_address_identity_arn) / [`set_from_email_address_identity_arn(Option<String>)`](crate::client::fluent_builders::SendBulkEmail::set_from_email_address_identity_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>  <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendBulkEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendBulkEmail::set_reply_to_addresses): <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    ///   - [`feedback_forwarding_email_address(impl Into<String>)`](crate::client::fluent_builders::SendBulkEmail::feedback_forwarding_email_address) / [`set_feedback_forwarding_email_address(Option<String>)`](crate::client::fluent_builders::SendBulkEmail::set_feedback_forwarding_email_address): <p>The address that you want bounce and complaint notifications to be sent to.</p>
    ///   - [`feedback_forwarding_email_address_identity_arn(impl Into<String>)`](crate::client::fluent_builders::SendBulkEmail::feedback_forwarding_email_address_identity_arn) / [`set_feedback_forwarding_email_address_identity_arn(Option<String>)`](crate::client::fluent_builders::SendBulkEmail::set_feedback_forwarding_email_address_identity_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>  <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`default_email_tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendBulkEmail::default_email_tags) / [`set_default_email_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendBulkEmail::set_default_email_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    ///   - [`default_content(BulkEmailContent)`](crate::client::fluent_builders::SendBulkEmail::default_content) / [`set_default_content(Option<BulkEmailContent>)`](crate::client::fluent_builders::SendBulkEmail::set_default_content): <p>An object that contains the body of the message. You can specify a template message.</p>
    ///   - [`bulk_email_entries(Vec<BulkEmailEntry>)`](crate::client::fluent_builders::SendBulkEmail::bulk_email_entries) / [`set_bulk_email_entries(Option<Vec<BulkEmailEntry>>)`](crate::client::fluent_builders::SendBulkEmail::set_bulk_email_entries): <p>The list of bulk email entry objects.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendBulkEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendBulkEmail::set_configuration_set_name): <p>The name of the configuration set to use when sending the email.</p>
    /// - On success, responds with [`SendBulkEmailOutput`](crate::output::SendBulkEmailOutput) with field(s):
    ///   - [`bulk_email_entry_results(Option<Vec<BulkEmailEntryResult>>)`](crate::output::SendBulkEmailOutput::bulk_email_entry_results): <p>One object per intended recipient. Check each response object and retry any messages with a failure status.</p>
    /// - On failure, responds with [`SdkError<SendBulkEmailError>`](crate::error::SendBulkEmailError)
    pub fn send_bulk_email(&self) -> fluent_builders::SendBulkEmail {
        fluent_builders::SendBulkEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendCustomVerificationEmail`](crate::client::fluent_builders::SendCustomVerificationEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_email_address): <p>The email address to verify.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_template_name): <p>The name of the custom verification email template to use when sending the verification email.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_configuration_set_name): <p>Name of a configuration set to use when sending the verification email.</p>
    /// - On success, responds with [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendCustomVerificationEmailOutput::message_id): <p>The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.</p>
    /// - On failure, responds with [`SdkError<SendCustomVerificationEmailError>`](crate::error::SendCustomVerificationEmailError)
    pub fn send_custom_verification_email(&self) -> fluent_builders::SendCustomVerificationEmail {
        fluent_builders::SendCustomVerificationEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendEmail`](crate::client::fluent_builders::SendEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::SendEmail::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::SendEmail::set_from_email_address): <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
    ///   - [`from_email_address_identity_arn(impl Into<String>)`](crate::client::fluent_builders::SendEmail::from_email_address_identity_arn) / [`set_from_email_address_identity_arn(Option<String>)`](crate::client::fluent_builders::SendEmail::set_from_email_address_identity_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>  <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>  <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
    ///   - [`destination(Destination)`](crate::client::fluent_builders::SendEmail::destination) / [`set_destination(Option<Destination>)`](crate::client::fluent_builders::SendEmail::set_destination): <p>An object that contains the recipients of the email message.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendEmail::set_reply_to_addresses): <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    ///   - [`feedback_forwarding_email_address(impl Into<String>)`](crate::client::fluent_builders::SendEmail::feedback_forwarding_email_address) / [`set_feedback_forwarding_email_address(Option<String>)`](crate::client::fluent_builders::SendEmail::set_feedback_forwarding_email_address): <p>The address that you want bounce and complaint notifications to be sent to.</p>
    ///   - [`feedback_forwarding_email_address_identity_arn(impl Into<String>)`](crate::client::fluent_builders::SendEmail::feedback_forwarding_email_address_identity_arn) / [`set_feedback_forwarding_email_address_identity_arn(Option<String>)`](crate::client::fluent_builders::SendEmail::set_feedback_forwarding_email_address_identity_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>  <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`content(EmailContent)`](crate::client::fluent_builders::SendEmail::content) / [`set_content(Option<EmailContent>)`](crate::client::fluent_builders::SendEmail::set_content): <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
    ///   - [`email_tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendEmail::email_tags) / [`set_email_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendEmail::set_email_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendEmail::set_configuration_set_name): <p>The name of the configuration set to use when sending the email.</p>
    ///   - [`list_management_options(ListManagementOptions)`](crate::client::fluent_builders::SendEmail::list_management_options) / [`set_list_management_options(Option<ListManagementOptions>)`](crate::client::fluent_builders::SendEmail::set_list_management_options): <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
    /// - On success, responds with [`SendEmailOutput`](crate::output::SendEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendEmailOutput::message_id): <p>A unique identifier for the message that is generated when the message is accepted.</p> <note>   <p>It's possible for Amazon SES to accept a message without sending it. This can happen when the message that you're trying to send has an attachment contains a virus, or when you send a templated email that contains invalid personalization content, for example.</p>  </note>
    /// - On failure, responds with [`SdkError<SendEmailError>`](crate::error::SendEmailError)
    pub fn send_email(&self) -> fluent_builders::SendEmail {
        fluent_builders::SendEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestRenderEmailTemplate`](crate::client::fluent_builders::TestRenderEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::TestRenderEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::TestRenderEmailTemplate::set_template_name): <p>The name of the template.</p>
    ///   - [`template_data(impl Into<String>)`](crate::client::fluent_builders::TestRenderEmailTemplate::template_data) / [`set_template_data(Option<String>)`](crate::client::fluent_builders::TestRenderEmailTemplate::set_template_data): <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    /// - On success, responds with [`TestRenderEmailTemplateOutput`](crate::output::TestRenderEmailTemplateOutput) with field(s):
    ///   - [`rendered_template(Option<String>)`](crate::output::TestRenderEmailTemplateOutput::rendered_template): <p>The complete MIME message rendered by applying the data in the <code>TemplateData</code> parameter to the template specified in the TemplateName parameter.</p>
    /// - On failure, responds with [`SdkError<TestRenderEmailTemplateError>`](crate::error::TestRenderEmailTemplateError)
    pub fn test_render_email_template(&self) -> fluent_builders::TestRenderEmailTemplate {
        fluent_builders::TestRenderEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>  <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that contains the event destination to modify.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination_name): <p>The name of the event destination.</p>
    ///   - [`event_destination(EventDestinationDefinition)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestinationDefinition>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination): <p>An object that defines the event destination.</p>
    /// - On success, responds with [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetEventDestinationError>`](crate::error::UpdateConfigurationSetEventDestinationError)
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContact`](crate::client::fluent_builders::UpdateContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_contact_list_name): <p>The name of the contact list.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_email_address): <p>The contact's email addres.</p>
    ///   - [`topic_preferences(Vec<TopicPreference>)`](crate::client::fluent_builders::UpdateContact::topic_preferences) / [`set_topic_preferences(Option<Vec<TopicPreference>>)`](crate::client::fluent_builders::UpdateContact::set_topic_preferences): <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
    ///   - [`unsubscribe_all(bool)`](crate::client::fluent_builders::UpdateContact::unsubscribe_all) / [`set_unsubscribe_all(bool)`](crate::client::fluent_builders::UpdateContact::set_unsubscribe_all): <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    ///   - [`attributes_data(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::attributes_data) / [`set_attributes_data(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_attributes_data): <p>The attribute data attached to a contact.</p>
    /// - On success, responds with [`UpdateContactOutput`](crate::output::UpdateContactOutput)

    /// - On failure, responds with [`SdkError<UpdateContactError>`](crate::error::UpdateContactError)
    pub fn update_contact(&self) -> fluent_builders::UpdateContact {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactList`](crate::client::fluent_builders::UpdateContactList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_list_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContactList::contact_list_name) / [`set_contact_list_name(Option<String>)`](crate::client::fluent_builders::UpdateContactList::set_contact_list_name): <p>The name of the contact list.</p>
    ///   - [`topics(Vec<Topic>)`](crate::client::fluent_builders::UpdateContactList::topics) / [`set_topics(Option<Vec<Topic>>)`](crate::client::fluent_builders::UpdateContactList::set_topics): <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateContactList::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateContactList::set_description): <p>A description of what the contact list is about.</p>
    /// - On success, responds with [`UpdateContactListOutput`](crate::output::UpdateContactListOutput)

    /// - On failure, responds with [`SdkError<UpdateContactListError>`](crate::error::UpdateContactListError)
    pub fn update_contact_list(&self) -> fluent_builders::UpdateContactList {
        fluent_builders::UpdateContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomVerificationEmailTemplate`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to update.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_subject) / [`set_template_subject(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_content) / [`set_template_content(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_content): <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    ///   - [`success_redirection_url(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::success_redirection_url) / [`set_success_redirection_url(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::failure_redirection_url) / [`set_failure_redirection_url(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On success, responds with [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<UpdateCustomVerificationEmailTemplateError>`](crate::error::UpdateCustomVerificationEmailTemplateError)
    pub fn update_custom_verification_email_template(
        &self,
    ) -> fluent_builders::UpdateCustomVerificationEmailTemplate {
        fluent_builders::UpdateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEmailIdentityPolicy`](crate::client::fluent_builders::UpdateEmailIdentityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_identity(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::email_identity) / [`set_email_identity(Option<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::set_email_identity): <p>The email identity.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::set_policy_name): <p>The name of the policy.</p>  <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::UpdateEmailIdentityPolicy::set_policy): <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>  <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    /// - On success, responds with [`UpdateEmailIdentityPolicyOutput`](crate::output::UpdateEmailIdentityPolicyOutput)

    /// - On failure, responds with [`SdkError<UpdateEmailIdentityPolicyError>`](crate::error::UpdateEmailIdentityPolicyError)
    pub fn update_email_identity_policy(&self) -> fluent_builders::UpdateEmailIdentityPolicy {
        fluent_builders::UpdateEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEmailTemplate`](crate::client::fluent_builders::UpdateEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateEmailTemplate::set_template_name): <p>The name of the template.</p>
    ///   - [`template_content(EmailTemplateContent)`](crate::client::fluent_builders::UpdateEmailTemplate::template_content) / [`set_template_content(Option<EmailTemplateContent>)`](crate::client::fluent_builders::UpdateEmailTemplate::set_template_content): <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On success, responds with [`UpdateEmailTemplateOutput`](crate::output::UpdateEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<UpdateEmailTemplateError>`](crate::error::UpdateEmailTemplateError)
    pub fn update_email_template(&self) -> fluent_builders::UpdateEmailTemplate {
        fluent_builders::UpdateEmailTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that you send. You apply a configuration set to an email by specifying the name of the configuration set when you call the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl CreateConfigurationSet {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.inner = self.inner.delivery_options(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.inner = self.inner.set_delivery_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn reputation_options(mut self, input: crate::model::ReputationOptions) -> Self {
            self.inner = self.inner.reputation_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn set_reputation_options(
            mut self,
            input: std::option::Option<crate::model::ReputationOptions>,
        ) -> Self {
            self.inner = self.inner.set_reputation_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
        pub fn sending_options(mut self, input: crate::model::SendingOptions) -> Self {
            self.inner = self.inner.sending_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
        pub fn set_sending_options(
            mut self,
            input: std::option::Option<crate::model::SendingOptions>,
        ) -> Self {
            self.inner = self.inner.set_sending_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your account.</p>
        pub fn suppression_options(mut self, input: crate::model::SuppressionOptions) -> Self {
            self.inner = self.inner.suppression_options(input);
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your account.</p>
        pub fn set_suppression_options(
            mut self,
            input: std::option::Option<crate::model::SuppressionOptions>,
        ) -> Self {
            self.inner = self.inner.set_suppression_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// <p>Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    /// <p>A single configuration set can include more than one event destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl CreateConfigurationSetEventDestination {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set .</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set .</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContact`.
    ///
    /// <p>Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_contact_input::Builder,
    }
    impl CreateContact {
        /// Creates a new `CreateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// Appends an item to `TopicPreferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn topic_preferences(mut self, input: crate::model::TopicPreference) -> Self {
            self.inner = self.inner.topic_preferences(input);
            self
        }
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.inner = self.inner.set_topic_preferences(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn unsubscribe_all(mut self, input: bool) -> Self {
            self.inner = self.inner.unsubscribe_all(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unsubscribe_all(input);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_data(input.into());
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attributes_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactList`.
    ///
    /// <p>Creates a contact list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContactList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_contact_list_input::Builder,
    }
    impl CreateContactList {
        /// Creates a new `CreateContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn topics(mut self, input: crate::model::Topic) -> Self {
            self.inner = self.inner.topics(input);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a contact list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags associated with a contact list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomVerificationEmailTemplate`.
    ///
    /// <p>Creates a new custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_verification_email_template_input::Builder,
    }
    impl CreateCustomVerificationEmailTemplate {
        /// Creates a new `CreateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDedicatedIpPool`.
    ///
    /// <p>Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, the message is sent from one of the addresses in the associated pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDedicatedIpPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dedicated_ip_pool_input::Builder,
    }
    impl CreateDedicatedIpPool {
        /// Creates a new `CreateDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDedicatedIpPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeliverabilityTestReport`.
    ///
    /// <p>Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon SES then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeliverabilityTestReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deliverability_test_report_input::Builder,
    }
    impl CreateDeliverabilityTestReport {
        /// Creates a new `CreateDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeliverabilityTestReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn report_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_name(input.into());
            self
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn set_report_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_name(input);
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailIdentity`.
    ///
    /// <p>Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity.</p>
    /// <p>When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as soon as you follow the link in the verification email. </p>
    /// <p>When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. This verification method is known as <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// <p>Alternatively, you can perform the verification process by providing your own public-private key pair. This verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you specify this object, you provide a selector (a component of the DNS record name that identifies the public key to use for DKIM authentication) and a private key.</p>
    /// <p>When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or more to complete the domain verification process.</p>
    /// <p>Additionally, you can associate an existing configuration set with the email identity that you're verifying.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_email_identity_input::Builder,
    }
    impl CreateEmailIdentity {
        /// Creates a new `CreateEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address or domain to verify.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email address or domain to verify.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
        pub fn dkim_signing_attributes(
            mut self,
            input: crate::model::DkimSigningAttributes,
        ) -> Self {
            self.inner = self.inner.dkim_signing_attributes(input);
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
        pub fn set_dkim_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.inner = self.inner.set_dkim_signing_attributes(input);
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailIdentityPolicy`.
    ///
    /// <p>Creates the specified sending authorization policy for the given identity (an email address or a domain).</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEmailIdentityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_email_identity_policy_input::Builder,
    }
    impl CreateEmailIdentityPolicy {
        /// Creates a new `CreateEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailIdentityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailTemplate`.
    ///
    /// <p>Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_email_template_input::Builder,
    }
    impl CreateEmailTemplate {
        /// Creates a new `CreateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template_content(mut self, input: crate::model::EmailTemplateContent) -> Self {
            self.inner = self.inner.template_content(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImportJob`.
    ///
    /// <p>Creates an import job for a data destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_import_job_input::Builder,
    }
    impl CreateImportJob {
        /// Creates a new `CreateImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The destination for the import job.</p>
        pub fn import_destination(mut self, input: crate::model::ImportDestination) -> Self {
            self.inner = self.inner.import_destination(input);
            self
        }
        /// <p>The destination for the import job.</p>
        pub fn set_import_destination(
            mut self,
            input: std::option::Option<crate::model::ImportDestination>,
        ) -> Self {
            self.inner = self.inner.set_import_destination(input);
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn import_data_source(mut self, input: crate::model::ImportDataSource) -> Self {
            self.inner = self.inner.import_data_source(input);
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn set_import_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.inner = self.inner.set_import_data_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Delete an existing configuration set.</p>
    /// <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl DeleteConfigurationSet {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// <p>Delete an event destination.</p>
    /// <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl DeleteConfigurationSetEventDestination {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContact`.
    ///
    /// <p>Removes a contact from a contact list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_contact_input::Builder,
    }
    impl DeleteContact {
        /// Creates a new `DeleteContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactList`.
    ///
    /// <p>Deletes a contact list and all of the contacts on that list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContactList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_contact_list_input::Builder,
    }
    impl DeleteContactList {
        /// Creates a new `DeleteContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomVerificationEmailTemplate`.
    ///
    /// <p>Deletes an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_verification_email_template_input::Builder,
    }
    impl DeleteCustomVerificationEmailTemplate {
        /// Creates a new `DeleteCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDedicatedIpPool`.
    ///
    /// <p>Delete a dedicated IP pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDedicatedIpPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dedicated_ip_pool_input::Builder,
    }
    impl DeleteDedicatedIpPool {
        /// Creates a new `DeleteDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDedicatedIpPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailIdentity`.
    ///
    /// <p>Deletes an email identity. An identity can be either an email address or a domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_email_identity_input::Builder,
    }
    impl DeleteEmailIdentity {
        /// Creates a new `DeleteEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailIdentityPolicy`.
    ///
    /// <p>Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailIdentityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_email_identity_policy_input::Builder,
    }
    impl DeleteEmailIdentityPolicy {
        /// Creates a new `DeleteEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailIdentityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailTemplate`.
    ///
    /// <p>Deletes an email template.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_email_template_input::Builder,
    }
    impl DeleteEmailTemplate {
        /// Creates a new `DeleteEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSuppressedDestination`.
    ///
    /// <p>Removes an email address from the suppression list for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSuppressedDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_suppressed_destination_input::Builder,
    }
    impl DeleteSuppressedDestination {
        /// Creates a new `DeleteSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSuppressedDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Obtain information about the email-sending status and capabilities of your Amazon SES account in the current Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_input::Builder,
    }
    impl GetAccount {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetBlacklistReports`.
    ///
    /// <p>Retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBlacklistReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_blacklist_reports_input::Builder,
    }
    impl GetBlacklistReports {
        /// Creates a new `GetBlacklistReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlacklistReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlacklistReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `BlacklistItemNames`.
        ///
        /// To override the contents of this collection use [`set_blacklist_item_names`](Self::set_blacklist_item_names).
        ///
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
        pub fn blacklist_item_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blacklist_item_names(input.into());
            self
        }
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
        pub fn set_blacklist_item_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_blacklist_item_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSet`.
    ///
    /// <p>Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.</p>
    /// <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_set_input::Builder,
    }
    impl GetConfigurationSet {
        /// Creates a new `GetConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSetEventDestinations`.
    ///
    /// <p>Retrieve a list of event destinations that are associated with a configuration set.</p>
    /// <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfigurationSetEventDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_configuration_set_event_destinations_input::Builder,
    }
    impl GetConfigurationSetEventDestinations {
        /// Creates a new `GetConfigurationSetEventDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetEventDestinationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConfigurationSetEventDestinationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContact`.
    ///
    /// <p>Returns a contact from a contact list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_contact_input::Builder,
    }
    impl GetContact {
        /// Creates a new `GetContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactList`.
    ///
    /// <p>Returns contact list metadata. It does not return any information about the contacts present in the list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContactList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_contact_list_input::Builder,
    }
    impl GetContactList {
        /// Creates a new `GetContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCustomVerificationEmailTemplate`.
    ///
    /// <p>Returns the custom email verification template for the template name you specify.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_custom_verification_email_template_input::Builder,
    }
    impl GetCustomVerificationEmailTemplate {
        /// Creates a new `GetCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIp`.
    ///
    /// <p>Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDedicatedIp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dedicated_ip_input::Builder,
    }
    impl GetDedicatedIp {
        /// Creates a new `GetDedicatedIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIps`.
    ///
    /// <p>List the dedicated IP addresses that are associated with your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDedicatedIps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dedicated_ips_input::Builder,
    }
    impl GetDedicatedIps {
        /// Creates a new `GetDedicatedIps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDedicatedIpsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDedicatedIpsPaginator {
            crate::paginator::GetDedicatedIpsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(input.into());
            self
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityDashboardOptions`.
    ///
    /// <p>Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.</p>
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeliverabilityDashboardOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deliverability_dashboard_options_input::Builder,
    }
    impl GetDeliverabilityDashboardOptions {
        /// Creates a new `GetDeliverabilityDashboardOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityDashboardOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityDashboardOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityTestReport`.
    ///
    /// <p>Retrieve the results of a predictive inbox placement test.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeliverabilityTestReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deliverability_test_report_input::Builder,
    }
    impl GetDeliverabilityTestReport {
        /// Creates a new `GetDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityTestReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainDeliverabilityCampaign`.
    ///
    /// <p>Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainDeliverabilityCampaign {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_deliverability_campaign_input::Builder,
    }
    impl GetDomainDeliverabilityCampaign {
        /// Creates a new `GetDomainDeliverabilityCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainDeliverabilityCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainDeliverabilityCampaignError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainStatisticsReport`.
    ///
    /// <p>Retrieve inbox placement and engagement rates for the domains that you use to send email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainStatisticsReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_statistics_report_input::Builder,
    }
    impl GetDomainStatisticsReport {
        /// Creates a new `GetDomainStatisticsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainStatisticsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainStatisticsReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailIdentity`.
    ///
    /// <p>Provides information about a specific identity, including the identity's verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_email_identity_input::Builder,
    }
    impl GetEmailIdentity {
        /// Creates a new `GetEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailIdentityPolicies`.
    ///
    /// <p>Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailIdentityPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_email_identity_policies_input::Builder,
    }
    impl GetEmailIdentityPolicies {
        /// Creates a new `GetEmailIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailIdentityPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailTemplate`.
    ///
    /// <p>Displays the template object (which includes the subject line, HTML part and text part) for the template you specify.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_email_template_input::Builder,
    }
    impl GetEmailTemplate {
        /// Creates a new `GetEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJob`.
    ///
    /// <p>Provides information about an import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImportJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_import_job_input::Builder,
    }
    impl GetImportJob {
        /// Creates a new `GetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuppressedDestination`.
    ///
    /// <p>Retrieves information about a specific email address that's on the suppression list for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSuppressedDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_suppressed_destination_input::Builder,
    }
    impl GetSuppressedDestination {
        /// Creates a new `GetSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuppressedDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that's on the account suppression list.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address that's on the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// <p>List all of the configuration sets associated with your account in the current region.</p>
    /// <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl ListConfigurationSets {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConfigurationSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConfigurationSetsPaginator {
            crate::paginator::ListConfigurationSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactLists`.
    ///
    /// <p>Lists all of the contact lists available.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContactLists {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_contact_lists_input::Builder,
    }
    impl ListContactLists {
        /// Creates a new `ListContactLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactListsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactListsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactListsPaginator {
            crate::paginator::ListContactListsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Lists the contacts present in a specific contact list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContacts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl ListContacts {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactsPaginator {
            crate::paginator::ListContactsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn filter(mut self, input: crate::model::ListContactsFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListContactsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomVerificationEmailTemplates`.
    ///
    /// <p>Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomVerificationEmailTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_verification_email_templates_input::Builder,
    }
    impl ListCustomVerificationEmailTemplates {
        /// Creates a new `ListCustomVerificationEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomVerificationEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomVerificationEmailTemplatesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomVerificationEmailTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCustomVerificationEmailTemplatesPaginator {
            crate::paginator::ListCustomVerificationEmailTemplatesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDedicatedIpPools`.
    ///
    /// <p>List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDedicatedIpPools {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dedicated_ip_pools_input::Builder,
    }
    impl ListDedicatedIpPools {
        /// Creates a new `ListDedicatedIpPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDedicatedIpPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDedicatedIpPoolsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDedicatedIpPoolsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDedicatedIpPoolsPaginator {
            crate::paginator::ListDedicatedIpPoolsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeliverabilityTestReports`.
    ///
    /// <p>Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeliverabilityTestReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deliverability_test_reports_input::Builder,
    }
    impl ListDeliverabilityTestReports {
        /// Creates a new `ListDeliverabilityTestReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeliverabilityTestReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeliverabilityTestReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeliverabilityTestReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeliverabilityTestReportsPaginator {
            crate::paginator::ListDeliverabilityTestReportsPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainDeliverabilityCampaigns`.
    ///
    /// <p>Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainDeliverabilityCampaigns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_deliverability_campaigns_input::Builder,
    }
    impl ListDomainDeliverabilityCampaigns {
        /// Creates a new `ListDomainDeliverabilityCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainDeliverabilityCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainDeliverabilityCampaignsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainDeliverabilityCampaignsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDomainDeliverabilityCampaignsPaginator {
            crate::paginator::ListDomainDeliverabilityCampaignsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn subscribed_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscribed_domain(input.into());
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn set_subscribed_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domain(input);
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEmailIdentities`.
    ///
    /// <p>Returns a list of all of the email identities that are associated with your Amazon Web Services account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEmailIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_email_identities_input::Builder,
    }
    impl ListEmailIdentities {
        /// Creates a new `ListEmailIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEmailIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEmailIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEmailIdentitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEmailIdentitiesPaginator {
            crate::paginator::ListEmailIdentitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEmailTemplates`.
    ///
    /// <p>Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEmailTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_email_templates_input::Builder,
    }
    impl ListEmailTemplates {
        /// Creates a new `ListEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEmailTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEmailTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEmailTemplatesPaginator {
            crate::paginator::ListEmailTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImportJobs`.
    ///
    /// <p>Lists all of the import jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImportJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_import_jobs_input::Builder,
    }
    impl ListImportJobs {
        /// Creates a new `ListImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImportJobsPaginator {
            crate::paginator::ListImportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
        pub fn import_destination_type(
            mut self,
            input: crate::model::ImportDestinationType,
        ) -> Self {
            self.inner = self.inner.import_destination_type(input);
            self
        }
        /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
        pub fn set_import_destination_type(
            mut self,
            input: std::option::Option<crate::model::ImportDestinationType>,
        ) -> Self {
            self.inner = self.inner.set_import_destination_type(input);
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuppressedDestinations`.
    ///
    /// <p>Retrieves a list of email addresses that are on the suppression list for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSuppressedDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_suppressed_destinations_input::Builder,
    }
    impl ListSuppressedDestinations {
        /// Creates a new `ListSuppressedDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuppressedDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuppressedDestinationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSuppressedDestinationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSuppressedDestinationsPaginator {
            crate::paginator::ListSuppressedDestinationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Reasons`.
        ///
        /// To override the contents of this collection use [`set_reasons`](Self::set_reasons).
        ///
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.inner = self.inner.reasons(input);
            self
        }
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn set_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_reasons(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieve a list of the tags (keys and values) that are associated with a specified resource. A&nbsp;<i>tag</i>&nbsp;is a label that you optionally define and associate with a resource. Each tag consists of a required&nbsp;<i>tag key</i>&nbsp;and an optional associated&nbsp;<i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountDedicatedIpWarmupAttributes`.
    ///
    /// <p>Enable or disable the automatic warm-up feature for dedicated IP addresses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountDedicatedIpWarmupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl PutAccountDedicatedIpWarmupAttributes {
        /// Creates a new `PutAccountDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccountDedicatedIpWarmupAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn auto_warmup_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_warmup_enabled(input);
            self
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn set_auto_warmup_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_warmup_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountDetails`.
    ///
    /// <p>Update your Amazon SES account details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_details_input::Builder,
    }
    impl PutAccountDetails {
        /// Creates a new `PutAccountDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of email your account will send.</p>
        pub fn mail_type(mut self, input: crate::model::MailType) -> Self {
            self.inner = self.inner.mail_type(input);
            self
        }
        /// <p>The type of email your account will send.</p>
        pub fn set_mail_type(mut self, input: std::option::Option<crate::model::MailType>) -> Self {
            self.inner = self.inner.set_mail_type(input);
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
        pub fn website_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_url(input.into());
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
        pub fn set_website_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_website_url(input);
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn contact_language(mut self, input: crate::model::ContactLanguage) -> Self {
            self.inner = self.inner.contact_language(input);
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn set_contact_language(
            mut self,
            input: std::option::Option<crate::model::ContactLanguage>,
        ) -> Self {
            self.inner = self.inner.set_contact_language(input);
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn use_case_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.use_case_description(input.into());
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn set_use_case_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_use_case_description(input);
            self
        }
        /// Appends an item to `AdditionalContactEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_additional_contact_email_addresses`](Self::set_additional_contact_email_addresses).
        ///
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
        pub fn additional_contact_email_addresses(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_contact_email_addresses(input.into());
            self
        }
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
        pub fn set_additional_contact_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_contact_email_addresses(input);
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
        pub fn production_access_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.production_access_enabled(input);
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
        pub fn set_production_access_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_production_access_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSendingAttributes`.
    ///
    /// <p>Enable or disable the ability of your account to send email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountSendingAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_sending_attributes_input::Builder,
    }
    impl PutAccountSendingAttributes {
        /// Creates a new `PutAccountSendingAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSendingAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSendingAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.sending_enabled(input);
            self
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSuppressionAttributes`.
    ///
    /// <p>Change the settings for the account-level suppression list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountSuppressionAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_suppression_attributes_input::Builder,
    }
    impl PutAccountSuppressionAttributes {
        /// Creates a new `PutAccountSuppressionAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSuppressionAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSuppressionAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SuppressedReasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn suppressed_reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.inner = self.inner.suppressed_reasons(input);
            self
        }
        /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_suppressed_reasons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetDeliveryOptions`.
    ///
    /// <p>Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetDeliveryOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_delivery_options_input::Builder,
    }
    impl PutConfigurationSetDeliveryOptions {
        /// Creates a new `PutConfigurationSetDeliveryOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetDeliveryOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetDeliveryOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.inner = self.inner.tls_policy(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.inner = self.inner.set_tls_policy(input);
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn sending_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sending_pool_name(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn set_sending_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sending_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetReputationOptions`.
    ///
    /// <p>Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetReputationOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_reputation_options_input::Builder,
    }
    impl PutConfigurationSetReputationOptions {
        /// Creates a new `PutConfigurationSetReputationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetReputationOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetReputationOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn reputation_metrics_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.reputation_metrics_enabled(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reputation_metrics_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetSendingOptions`.
    ///
    /// <p>Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetSendingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_sending_options_input::Builder,
    }
    impl PutConfigurationSetSendingOptions {
        /// Creates a new `PutConfigurationSetSendingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetSendingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigurationSetSendingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.sending_enabled(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetSuppressionOptions`.
    ///
    /// <p>Specify the account suppression list preferences for a configuration set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetSuppressionOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_suppression_options_input::Builder,
    }
    impl PutConfigurationSetSuppressionOptions {
        /// Creates a new `PutConfigurationSetSuppressionOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetSuppressionOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetSuppressionOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to change the suppression list preferences for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to change the suppression list preferences for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `SuppressedReasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn suppressed_reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.inner = self.inner.suppressed_reasons(input);
            self
        }
        /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_suppressed_reasons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetTrackingOptions`.
    ///
    /// <p>Specify a custom domain to use for open and click tracking elements in email that you send.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetTrackingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_tracking_options_input::Builder,
    }
    impl PutConfigurationSetTrackingOptions {
        /// Creates a new `PutConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetTrackingOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn custom_redirect_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_redirect_domain(input.into());
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_redirect_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpInPool`.
    ///
    /// <p>Move a dedicated IP address to an existing dedicated IP pool.</p> <note>
    /// <p>The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web Services account. </p>
    /// <p>The dedicated IP pool you specify must already exist. You can create a new pool by using the <code>CreateDedicatedIpPool</code> operation.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDedicatedIpInPool {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_dedicated_ip_in_pool_input::Builder,
    }
    impl PutDedicatedIpInPool {
        /// Creates a new `PutDedicatedIpInPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpInPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpInPoolError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn destination_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_pool_name(input.into());
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn set_destination_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpWarmupAttributes`.
    ///
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDedicatedIpWarmupAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl PutDedicatedIpWarmupAttributes {
        /// Creates a new `PutDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpWarmupAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(input.into());
            self
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn warmup_percentage(mut self, input: i32) -> Self {
            self.inner = self.inner.warmup_percentage(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn set_warmup_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_warmup_percentage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDeliverabilityDashboardOption`.
    ///
    /// <p>Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.</p>
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDeliverabilityDashboardOption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_deliverability_dashboard_option_input::Builder,
    }
    impl PutDeliverabilityDashboardOption {
        /// Creates a new `PutDeliverabilityDashboardOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDeliverabilityDashboardOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDeliverabilityDashboardOptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn dashboard_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.dashboard_enabled(input);
            self
        }
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn set_dashboard_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dashboard_enabled(input);
            self
        }
        /// Appends an item to `SubscribedDomains`.
        ///
        /// To override the contents of this collection use [`set_subscribed_domains`](Self::set_subscribed_domains).
        ///
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn subscribed_domains(
            mut self,
            input: crate::model::DomainDeliverabilityTrackingOption,
        ) -> Self {
            self.inner = self.inner.subscribed_domains(input);
            self
        }
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn set_subscribed_domains(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityConfigurationSetAttributes`.
    ///
    /// <p>Used to associate a configuration set with an email identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityConfigurationSetAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_configuration_set_attributes_input::Builder,
    }
    impl PutEmailIdentityConfigurationSetAttributes {
        /// Creates a new `PutEmailIdentityConfigurationSetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityConfigurationSetAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityConfigurationSetAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityDkimAttributes`.
    ///
    /// <p>Used to enable or disable DKIM authentication for an email identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityDkimAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_dkim_attributes_input::Builder,
    }
    impl PutEmailIdentityDkimAttributes {
        /// Creates a new `PutEmailIdentityDkimAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityDkimAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEmailIdentityDkimAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
        pub fn signing_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.signing_enabled(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
        pub fn set_signing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_signing_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityDkimSigningAttributes`.
    ///
    /// <p>Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:</p>
    /// <ul>
    /// <li> <p>Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).</p> </li>
    /// <li> <p>Update the key length that should be used for Easy DKIM.</p> </li>
    /// <li> <p>Change from using no DKIM authentication to using Easy DKIM.</p> </li>
    /// <li> <p>Change from using no DKIM authentication to using BYODKIM.</p> </li>
    /// <li> <p>Change from using Easy DKIM to using BYODKIM.</p> </li>
    /// <li> <p>Change from using BYODKIM to using Easy DKIM.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityDkimSigningAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_dkim_signing_attributes_input::Builder,
    }
    impl PutEmailIdentityDkimSigningAttributes {
        /// Creates a new `PutEmailIdentityDkimSigningAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityDkimSigningAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityDkimSigningAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
        /// <ul>
        /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
        /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
        /// </ul>
        pub fn signing_attributes_origin(
            mut self,
            input: crate::model::DkimSigningAttributesOrigin,
        ) -> Self {
            self.inner = self.inner.signing_attributes_origin(input);
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
        /// <ul>
        /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
        /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
        /// </ul>
        pub fn set_signing_attributes_origin(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        ) -> Self {
            self.inner = self.inner.set_signing_attributes_origin(input);
            self
        }
        /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn signing_attributes(mut self, input: crate::model::DkimSigningAttributes) -> Self {
            self.inner = self.inner.signing_attributes(input);
            self
        }
        /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn set_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.inner = self.inner.set_signing_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityFeedbackAttributes`.
    ///
    /// <p>Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.</p>
    /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
    /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityFeedbackAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_feedback_attributes_input::Builder,
    }
    impl PutEmailIdentityFeedbackAttributes {
        /// Creates a new `PutEmailIdentityFeedbackAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityFeedbackAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityFeedbackAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
        pub fn email_forwarding_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.email_forwarding_enabled(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
        pub fn set_email_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_email_forwarding_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityMailFromAttributes`.
    ///
    /// <p>Used to enable or disable the custom Mail-From domain configuration for an email identity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEmailIdentityMailFromAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_email_identity_mail_from_attributes_input::Builder,
    }
    impl PutEmailIdentityMailFromAttributes {
        /// Creates a new `PutEmailIdentityMailFromAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityMailFromAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityMailFromAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The verified email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The verified email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mail_from_domain(input.into());
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mail_from_domain(input);
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.inner = self.inner.behavior_on_mx_failure(input);
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.inner = self.inner.set_behavior_on_mx_failure(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSuppressedDestination`.
    ///
    /// <p>Adds an email address to the suppression list for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSuppressedDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_suppressed_destination_input::Builder,
    }
    impl PutSuppressedDestination {
        /// Creates a new `PutSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSuppressedDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that should be added to the suppression list for your account.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address that should be added to the suppression list for your account.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
        pub fn reason(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.inner = self.inner.reason(input);
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SuppressionListReason>,
        ) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBulkEmail`.
    ///
    /// <p>Composes an email message to multiple destinations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendBulkEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_bulk_email_input::Builder,
    }
    impl SendBulkEmail {
        /// Creates a new `SendBulkEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBulkEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBulkEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.from_email_address_identity_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address_identity_arn(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.feedback_forwarding_email_address(input.into());
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_forwarding_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .feedback_forwarding_email_address_identity_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_feedback_forwarding_email_address_identity_arn(input);
            self
        }
        /// Appends an item to `DefaultEmailTags`.
        ///
        /// To override the contents of this collection use [`set_default_email_tags`](Self::set_default_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn default_email_tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.default_email_tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn set_default_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_default_email_tags(input);
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template message.</p>
        pub fn default_content(mut self, input: crate::model::BulkEmailContent) -> Self {
            self.inner = self.inner.default_content(input);
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template message.</p>
        pub fn set_default_content(
            mut self,
            input: std::option::Option<crate::model::BulkEmailContent>,
        ) -> Self {
            self.inner = self.inner.set_default_content(input);
            self
        }
        /// Appends an item to `BulkEmailEntries`.
        ///
        /// To override the contents of this collection use [`set_bulk_email_entries`](Self::set_bulk_email_entries).
        ///
        /// <p>The list of bulk email entry objects.</p>
        pub fn bulk_email_entries(mut self, input: crate::model::BulkEmailEntry) -> Self {
            self.inner = self.inner.bulk_email_entries(input);
            self
        }
        /// <p>The list of bulk email entry objects.</p>
        pub fn set_bulk_email_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailEntry>>,
        ) -> Self {
            self.inner = self.inner.set_bulk_email_entries(input);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendCustomVerificationEmail`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.</p>
    /// <p>To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendCustomVerificationEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_custom_verification_email_input::Builder,
    }
    impl SendCustomVerificationEmail {
        /// Creates a new `SendCustomVerificationEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendCustomVerificationEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendCustomVerificationEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEmail`.
    ///
    /// <p>Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:</p>
    /// <ul>
    /// <li> <p> <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon SES assembles the message for you.</p> </li>
    /// <li> <p> <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.</p> </li>
    /// <li> <p> <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API v2 automatically replaces the tags with values that you specify.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_email_input::Builder,
    }
    impl SendEmail {
        /// Creates a new `SendEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.from_email_address_identity_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address_identity_arn(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.feedback_forwarding_email_address(input.into());
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_forwarding_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .feedback_forwarding_email_address_identity_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_feedback_forwarding_email_address_identity_arn(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `EmailTags`.
        ///
        /// To override the contents of this collection use [`set_email_tags`](Self::set_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn email_tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.email_tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn set_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_email_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
        pub fn list_management_options(
            mut self,
            input: crate::model::ListManagementOptions,
        ) -> Self {
            self.inner = self.inner.list_management_options(input);
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
        pub fn set_list_management_options(
            mut self,
            input: std::option::Option<crate::model::ListManagementOptions>,
        ) -> Self {
            self.inner = self.inner.set_list_management_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add one or more tags (keys and values) to a specified resource. A <i>tag</i>&nbsp;is a label that you optionally define and associate with a resource. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.</p>
    /// <p>Each tag consists of a required&nbsp;<i>tag key</i>&nbsp;and an associated&nbsp;<i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRenderEmailTemplate`.
    ///
    /// <p>Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestRenderEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_render_email_template_input::Builder,
    }
    impl TestRenderEmailTemplate {
        /// Creates a new `TestRenderEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRenderEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRenderEmailTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove one or more tags (keys and values) from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// <p>Update the configuration of an event destination for a configuration set.</p>
    /// <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl UpdateConfigurationSetEventDestination {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination to modify.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination to modify.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>Updates a contact's preferences for a list. It is not necessary to specify all existing topic preferences in the TopicPreferences object, just the ones that need updating.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl UpdateContact {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// Appends an item to `TopicPreferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn topic_preferences(mut self, input: crate::model::TopicPreference) -> Self {
            self.inner = self.inner.topic_preferences(input);
            self
        }
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.inner = self.inner.set_topic_preferences(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn unsubscribe_all(mut self, input: bool) -> Self {
            self.inner = self.inner.unsubscribe_all(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unsubscribe_all(input);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_data(input.into());
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attributes_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactList`.
    ///
    /// <p>Updates contact list metadata. This operation does a complete replacement.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_contact_list_input::Builder,
    }
    impl UpdateContactList {
        /// Creates a new `UpdateContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn topics(mut self, input: crate::model::Topic) -> Self {
            self.inner = self.inner.topics(input);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomVerificationEmailTemplate`.
    ///
    /// <p>Updates an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_verification_email_template_input::Builder,
    }
    impl UpdateCustomVerificationEmailTemplate {
        /// Creates a new `UpdateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailIdentityPolicy`.
    ///
    /// <p>Updates the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEmailIdentityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_email_identity_policy_input::Builder,
    }
    impl UpdateEmailIdentityPolicy {
        /// Creates a new `UpdateEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailIdentityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailTemplate`.
    ///
    /// <p>Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_email_template_input::Builder,
    }
    impl UpdateEmailTemplate {
        /// Creates a new `UpdateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template_content(mut self, input: crate::model::EmailTemplateContent) -> Self {
            self.inner = self.inner.template_content(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
