// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
/// part.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailTemplateContent {
    /// <p>The subject line of the email.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The email body that will be visible to recipients whose email clients do not display
    /// HTML.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The HTML body of the email.</p>
    pub html: std::option::Option<std::string::String>,
}
impl EmailTemplateContent {
    /// <p>The subject line of the email.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The email body that will be visible to recipients whose email clients do not display
    /// HTML.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The HTML body of the email.</p>
    pub fn html(&self) -> std::option::Option<&str> {
        self.html.as_deref()
    }
}
impl std::fmt::Debug for EmailTemplateContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailTemplateContent");
        formatter.field("subject", &self.subject);
        formatter.field("text", &self.text);
        formatter.field("html", &self.html);
        formatter.finish()
    }
}
/// See [`EmailTemplateContent`](crate::model::EmailTemplateContent)
pub mod email_template_content {
    /// A builder for [`EmailTemplateContent`](crate::model::EmailTemplateContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) html: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subject line of the email.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line of the email.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The email body that will be visible to recipients whose email clients do not display
        /// HTML.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The email body that will be visible to recipients whose email clients do not display
        /// HTML.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The HTML body of the email.</p>
        pub fn html(mut self, input: impl Into<std::string::String>) -> Self {
            self.html = Some(input.into());
            self
        }
        /// <p>The HTML body of the email.</p>
        pub fn set_html(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.html = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailTemplateContent`](crate::model::EmailTemplateContent)
        pub fn build(self) -> crate::model::EmailTemplateContent {
            crate::model::EmailTemplateContent {
                subject: self.subject,
                text: self.text,
                html: self.html,
            }
        }
    }
}
impl EmailTemplateContent {
    /// Creates a new builder-style object to manufacture [`EmailTemplateContent`](crate::model::EmailTemplateContent)
    pub fn builder() -> crate::model::email_template_content::Builder {
        crate::model::email_template_content::Builder::default()
    }
}

/// <p>An interest group, theme, or label within a list. Lists can have multiple
/// topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Topic {
    /// <p>The name of the topic.</p>
    pub topic_name: std::option::Option<std::string::String>,
    /// <p>The name of the topic the contact will see.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A description of what the topic is about, which the contact will see.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The default subscription status to be applied to a contact if the contact has not
    /// noted their preference for subscribing to a topic.</p>
    pub default_subscription_status: std::option::Option<crate::model::SubscriptionStatus>,
}
impl Topic {
    /// <p>The name of the topic.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
    /// <p>The name of the topic the contact will see.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A description of what the topic is about, which the contact will see.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The default subscription status to be applied to a contact if the contact has not
    /// noted their preference for subscribing to a topic.</p>
    pub fn default_subscription_status(
        &self,
    ) -> std::option::Option<&crate::model::SubscriptionStatus> {
        self.default_subscription_status.as_ref()
    }
}
impl std::fmt::Debug for Topic {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Topic");
        formatter.field("topic_name", &self.topic_name);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field(
            "default_subscription_status",
            &self.default_subscription_status,
        );
        formatter.finish()
    }
}
/// See [`Topic`](crate::model::Topic)
pub mod topic {
    /// A builder for [`Topic`](crate::model::Topic)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_subscription_status:
            std::option::Option<crate::model::SubscriptionStatus>,
    }
    impl Builder {
        /// <p>The name of the topic.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of the topic.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// <p>The name of the topic the contact will see.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the topic the contact will see.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A description of what the topic is about, which the contact will see.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of what the topic is about, which the contact will see.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The default subscription status to be applied to a contact if the contact has not
        /// noted their preference for subscribing to a topic.</p>
        pub fn default_subscription_status(
            mut self,
            input: crate::model::SubscriptionStatus,
        ) -> Self {
            self.default_subscription_status = Some(input);
            self
        }
        /// <p>The default subscription status to be applied to a contact if the contact has not
        /// noted their preference for subscribing to a topic.</p>
        pub fn set_default_subscription_status(
            mut self,
            input: std::option::Option<crate::model::SubscriptionStatus>,
        ) -> Self {
            self.default_subscription_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Topic`](crate::model::Topic)
        pub fn build(self) -> crate::model::Topic {
            crate::model::Topic {
                topic_name: self.topic_name,
                display_name: self.display_name,
                description: self.description,
                default_subscription_status: self.default_subscription_status,
            }
        }
    }
}
impl Topic {
    /// Creates a new builder-style object to manufacture [`Topic`](crate::model::Topic)
    pub fn builder() -> crate::model::topic::Builder {
        crate::model::topic::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriptionStatus {
    #[allow(missing_docs)] // documentation missing in model
    OptIn,
    #[allow(missing_docs)] // documentation missing in model
    OptOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriptionStatus {
    fn from(s: &str) -> Self {
        match s {
            "OPT_IN" => SubscriptionStatus::OptIn,
            "OPT_OUT" => SubscriptionStatus::OptOut,
            other => SubscriptionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriptionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriptionStatus::from(s))
    }
}
impl SubscriptionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriptionStatus::OptIn => "OPT_IN",
            SubscriptionStatus::OptOut => "OPT_OUT",
            SubscriptionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPT_IN", "OPT_OUT"]
    }
}
impl AsRef<str> for SubscriptionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicPreference {
    /// <p>The name of the topic.</p>
    pub topic_name: std::option::Option<std::string::String>,
    /// <p>The contact's subscription status to a topic which is either <code>OPT_IN</code> or
    /// <code>OPT_OUT</code>.</p>
    pub subscription_status: std::option::Option<crate::model::SubscriptionStatus>,
}
impl TopicPreference {
    /// <p>The name of the topic.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
    /// <p>The contact's subscription status to a topic which is either <code>OPT_IN</code> or
    /// <code>OPT_OUT</code>.</p>
    pub fn subscription_status(&self) -> std::option::Option<&crate::model::SubscriptionStatus> {
        self.subscription_status.as_ref()
    }
}
impl std::fmt::Debug for TopicPreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicPreference");
        formatter.field("topic_name", &self.topic_name);
        formatter.field("subscription_status", &self.subscription_status);
        formatter.finish()
    }
}
/// See [`TopicPreference`](crate::model::TopicPreference)
pub mod topic_preference {
    /// A builder for [`TopicPreference`](crate::model::TopicPreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_name: std::option::Option<std::string::String>,
        pub(crate) subscription_status: std::option::Option<crate::model::SubscriptionStatus>,
    }
    impl Builder {
        /// <p>The name of the topic.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of the topic.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// <p>The contact's subscription status to a topic which is either <code>OPT_IN</code> or
        /// <code>OPT_OUT</code>.</p>
        pub fn subscription_status(mut self, input: crate::model::SubscriptionStatus) -> Self {
            self.subscription_status = Some(input);
            self
        }
        /// <p>The contact's subscription status to a topic which is either <code>OPT_IN</code> or
        /// <code>OPT_OUT</code>.</p>
        pub fn set_subscription_status(
            mut self,
            input: std::option::Option<crate::model::SubscriptionStatus>,
        ) -> Self {
            self.subscription_status = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicPreference`](crate::model::TopicPreference)
        pub fn build(self) -> crate::model::TopicPreference {
            crate::model::TopicPreference {
                topic_name: self.topic_name,
                subscription_status: self.subscription_status,
            }
        }
    }
}
impl TopicPreference {
    /// Creates a new builder-style object to manufacture [`TopicPreference`](crate::model::TopicPreference)
    pub fn builder() -> crate::model::topic_preference::Builder {
        crate::model::topic_preference::Builder::default()
    }
}

/// <p>An object that defines the event destination. Specifically, it defines which services
/// receive events from emails sent using the configuration set that the event destination
/// is associated with. Also defines the types of events that are sent to the event
/// destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestinationDefinition {
    /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
    /// enabled, the specified event types are sent to the destinations in this
    /// <code>EventDestinationDefinition</code>.</p>
    /// <p>If <code>false</code>, the event destination is disabled. When the event destination
    /// is disabled, events aren't sent to the specified destinations.</p>
    pub enabled: bool,
    /// <p>An array that specifies which events the Amazon SES API v2 should send to the destinations in
    /// this <code>EventDestinationDefinition</code>.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
    /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
    /// monitor and gain insights on your email sending metrics.</p>
    pub cloud_watch_destination: std::option::Option<crate::model::CloudWatchDestination>,
    /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
    /// send notification when certain email events occur.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
    /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
    /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
    /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
    /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    pub pinpoint_destination: std::option::Option<crate::model::PinpointDestination>,
}
impl EventDestinationDefinition {
    /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
    /// enabled, the specified event types are sent to the destinations in this
    /// <code>EventDestinationDefinition</code>.</p>
    /// <p>If <code>false</code>, the event destination is disabled. When the event destination
    /// is disabled, events aren't sent to the specified destinations.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>An array that specifies which events the Amazon SES API v2 should send to the destinations in
    /// this <code>EventDestinationDefinition</code>.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
    /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
    /// monitor and gain insights on your email sending metrics.</p>
    pub fn cloud_watch_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchDestination> {
        self.cloud_watch_destination.as_ref()
    }
    /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
    /// send notification when certain email events occur.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
    /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
    /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
    /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
    /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    pub fn pinpoint_destination(&self) -> std::option::Option<&crate::model::PinpointDestination> {
        self.pinpoint_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestinationDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestinationDefinition");
        formatter.field("enabled", &self.enabled);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("cloud_watch_destination", &self.cloud_watch_destination);
        formatter.field("sns_destination", &self.sns_destination);
        formatter.field("pinpoint_destination", &self.pinpoint_destination);
        formatter.finish()
    }
}
/// See [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
pub mod event_destination_definition {
    /// A builder for [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) cloud_watch_destination:
            std::option::Option<crate::model::CloudWatchDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
        pub(crate) pinpoint_destination: std::option::Option<crate::model::PinpointDestination>,
    }
    impl Builder {
        /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
        /// enabled, the specified event types are sent to the destinations in this
        /// <code>EventDestinationDefinition</code>.</p>
        /// <p>If <code>false</code>, the event destination is disabled. When the event destination
        /// is disabled, events aren't sent to the specified destinations.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
        /// enabled, the specified event types are sent to the destinations in this
        /// <code>EventDestinationDefinition</code>.</p>
        /// <p>If <code>false</code>, the event destination is disabled. When the event destination
        /// is disabled, events aren't sent to the specified destinations.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>An array that specifies which events the Amazon SES API v2 should send to the destinations in
        /// this <code>EventDestinationDefinition</code>.</p>
        pub fn matching_event_types(mut self, input: impl Into<crate::model::EventType>) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input.into());
            self.matching_event_types = Some(v);
            self
        }
        /// <p>An array that specifies which events the Amazon SES API v2 should send to the destinations in
        /// this <code>EventDestinationDefinition</code>.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
        /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
        /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
        /// monitor and gain insights on your email sending metrics.</p>
        pub fn cloud_watch_destination(
            mut self,
            input: crate::model::CloudWatchDestination,
        ) -> Self {
            self.cloud_watch_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
        /// monitor and gain insights on your email sending metrics.</p>
        pub fn set_cloud_watch_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchDestination>,
        ) -> Self {
            self.cloud_watch_destination = input;
            self
        }
        /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
        /// send notification when certain email events occur.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
        /// send notification when certain email events occur.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
        /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
        /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
        /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
        pub fn pinpoint_destination(mut self, input: crate::model::PinpointDestination) -> Self {
            self.pinpoint_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
        /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
        /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
        /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
        pub fn set_pinpoint_destination(
            mut self,
            input: std::option::Option<crate::model::PinpointDestination>,
        ) -> Self {
            self.pinpoint_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
        pub fn build(self) -> crate::model::EventDestinationDefinition {
            crate::model::EventDestinationDefinition {
                enabled: self.enabled.unwrap_or_default(),
                matching_event_types: self.matching_event_types,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                cloud_watch_destination: self.cloud_watch_destination,
                sns_destination: self.sns_destination,
                pinpoint_destination: self.pinpoint_destination,
            }
        }
    }
}
impl EventDestinationDefinition {
    /// Creates a new builder-style object to manufacture [`EventDestinationDefinition`](crate::model::EventDestinationDefinition)
    pub fn builder() -> crate::model::event_destination_definition::Builder {
        crate::model::event_destination_definition::Builder::default()
    }
}

/// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
/// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
/// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
/// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PinpointDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Pinpoint project to send email events to.</p>
    pub application_arn: std::option::Option<std::string::String>,
}
impl PinpointDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Pinpoint project to send email events to.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
}
impl std::fmt::Debug for PinpointDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PinpointDestination");
        formatter.field("application_arn", &self.application_arn);
        formatter.finish()
    }
}
/// See [`PinpointDestination`](crate::model::PinpointDestination)
pub mod pinpoint_destination {
    /// A builder for [`PinpointDestination`](crate::model::PinpointDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Pinpoint project to send email events to.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Pinpoint project to send email events to.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PinpointDestination`](crate::model::PinpointDestination)
        pub fn build(self) -> crate::model::PinpointDestination {
            crate::model::PinpointDestination {
                application_arn: self.application_arn,
            }
        }
    }
}
impl PinpointDestination {
    /// Creates a new builder-style object to manufacture [`PinpointDestination`](crate::model::PinpointDestination)
    pub fn builder() -> crate::model::pinpoint_destination::Builder {
        crate::model::pinpoint_destination::Builder::default()
    }
}

/// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
/// send notification when certain email events occur.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to. For
    /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SnsDestination {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to. For
    /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsDestination");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsDestination`](crate::model::SnsDestination)
pub mod sns_destination {
    /// A builder for [`SnsDestination`](crate::model::SnsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to. For
        /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to. For
        /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsDestination`](crate::model::SnsDestination)
        pub fn build(self) -> crate::model::SnsDestination {
            crate::model::SnsDestination {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsDestination {
    /// Creates a new builder-style object to manufacture [`SnsDestination`](crate::model::SnsDestination)
    pub fn builder() -> crate::model::sns_destination::Builder {
        crate::model::sns_destination::Builder::default()
    }
}

/// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
/// monitor and gain insights on your email sending metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchDestination {
    /// <p>An array of objects that define the dimensions to use when you send email events to
    /// Amazon CloudWatch.</p>
    pub dimension_configurations:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>>,
}
impl CloudWatchDestination {
    /// <p>An array of objects that define the dimensions to use when you send email events to
    /// Amazon CloudWatch.</p>
    pub fn dimension_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::CloudWatchDimensionConfiguration]> {
        self.dimension_configurations.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchDestination");
        formatter.field("dimension_configurations", &self.dimension_configurations);
        formatter.finish()
    }
}
/// See [`CloudWatchDestination`](crate::model::CloudWatchDestination)
pub mod cloud_watch_destination {
    /// A builder for [`CloudWatchDestination`](crate::model::CloudWatchDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_configurations:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `dimension_configurations`.
        ///
        /// To override the contents of this collection use [`set_dimension_configurations`](Self::set_dimension_configurations).
        ///
        /// <p>An array of objects that define the dimensions to use when you send email events to
        /// Amazon CloudWatch.</p>
        pub fn dimension_configurations(
            mut self,
            input: impl Into<crate::model::CloudWatchDimensionConfiguration>,
        ) -> Self {
            let mut v = self.dimension_configurations.unwrap_or_default();
            v.push(input.into());
            self.dimension_configurations = Some(v);
            self
        }
        /// <p>An array of objects that define the dimensions to use when you send email events to
        /// Amazon CloudWatch.</p>
        pub fn set_dimension_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>,
            >,
        ) -> Self {
            self.dimension_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchDestination`](crate::model::CloudWatchDestination)
        pub fn build(self) -> crate::model::CloudWatchDestination {
            crate::model::CloudWatchDestination {
                dimension_configurations: self.dimension_configurations,
            }
        }
    }
}
impl CloudWatchDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchDestination`](crate::model::CloudWatchDestination)
    pub fn builder() -> crate::model::cloud_watch_destination::Builder {
        crate::model::cloud_watch_destination::Builder::default()
    }
}

/// <p>An object that defines the dimension configuration to use when you send email events
/// to Amazon CloudWatch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchDimensionConfiguration {
    /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to
    /// meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub dimension_name: std::option::Option<std::string::String>,
    /// <p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
    /// use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or
    /// a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
    /// <code>messageTag</code>. To use your own email headers, choose
    /// <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.</p>
    pub dimension_value_source: std::option::Option<crate::model::DimensionValueSource>,
    /// <p>The default value of the dimension that is published to Amazon CloudWatch if you don't provide the
    /// value of the dimension when you send an email. This value has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub default_dimension_value: std::option::Option<std::string::String>,
}
impl CloudWatchDimensionConfiguration {
    /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to
    /// meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn dimension_name(&self) -> std::option::Option<&str> {
        self.dimension_name.as_deref()
    }
    /// <p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
    /// use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or
    /// a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
    /// <code>messageTag</code>. To use your own email headers, choose
    /// <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.</p>
    pub fn dimension_value_source(
        &self,
    ) -> std::option::Option<&crate::model::DimensionValueSource> {
        self.dimension_value_source.as_ref()
    }
    /// <p>The default value of the dimension that is published to Amazon CloudWatch if you don't provide the
    /// value of the dimension when you send an email. This value has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn default_dimension_value(&self) -> std::option::Option<&str> {
        self.default_dimension_value.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchDimensionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchDimensionConfiguration");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field("dimension_value_source", &self.dimension_value_source);
        formatter.field("default_dimension_value", &self.default_dimension_value);
        formatter.finish()
    }
}
/// See [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
pub mod cloud_watch_dimension_configuration {
    /// A builder for [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name: std::option::Option<std::string::String>,
        pub(crate) dimension_value_source: std::option::Option<crate::model::DimensionValueSource>,
        pub(crate) default_dimension_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to
        /// meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to
        /// meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// <p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
        /// use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or
        /// a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
        /// <code>messageTag</code>. To use your own email headers, choose
        /// <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.</p>
        pub fn dimension_value_source(mut self, input: crate::model::DimensionValueSource) -> Self {
            self.dimension_value_source = Some(input);
            self
        }
        /// <p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
        /// use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or
        /// a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
        /// <code>messageTag</code>. To use your own email headers, choose
        /// <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.</p>
        pub fn set_dimension_value_source(
            mut self,
            input: std::option::Option<crate::model::DimensionValueSource>,
        ) -> Self {
            self.dimension_value_source = input;
            self
        }
        /// <p>The default value of the dimension that is published to Amazon CloudWatch if you don't provide the
        /// value of the dimension when you send an email. This value has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn default_dimension_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_dimension_value = Some(input.into());
            self
        }
        /// <p>The default value of the dimension that is published to Amazon CloudWatch if you don't provide the
        /// value of the dimension when you send an email. This value has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_default_dimension_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_dimension_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
        pub fn build(self) -> crate::model::CloudWatchDimensionConfiguration {
            crate::model::CloudWatchDimensionConfiguration {
                dimension_name: self.dimension_name,
                dimension_value_source: self.dimension_value_source,
                default_dimension_value: self.default_dimension_value,
            }
        }
    }
}
impl CloudWatchDimensionConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
    pub fn builder() -> crate::model::cloud_watch_dimension_configuration::Builder {
        crate::model::cloud_watch_dimension_configuration::Builder::default()
    }
}

/// <p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. To
/// use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or
/// a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose
/// <code>messageTag</code>. To use your own email headers, choose
/// <code>emailHeader</code>. To use link tags, choose <code>linkTags</code>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DimensionValueSource {
    #[allow(missing_docs)] // documentation missing in model
    EmailHeader,
    #[allow(missing_docs)] // documentation missing in model
    LinkTag,
    #[allow(missing_docs)] // documentation missing in model
    MessageTag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DimensionValueSource {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL_HEADER" => DimensionValueSource::EmailHeader,
            "LINK_TAG" => DimensionValueSource::LinkTag,
            "MESSAGE_TAG" => DimensionValueSource::MessageTag,
            other => DimensionValueSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DimensionValueSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DimensionValueSource::from(s))
    }
}
impl DimensionValueSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DimensionValueSource::EmailHeader => "EMAIL_HEADER",
            DimensionValueSource::LinkTag => "LINK_TAG",
            DimensionValueSource::MessageTag => "MESSAGE_TAG",
            DimensionValueSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL_HEADER", "LINK_TAG", "MESSAGE_TAG"]
    }
}
impl AsRef<str> for DimensionValueSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
/// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseDestination {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email
    /// events to the Amazon Kinesis Data Firehose stream.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email
    /// events to.</p>
    pub delivery_stream_arn: std::option::Option<std::string::String>,
}
impl KinesisFirehoseDestination {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email
    /// events to the Amazon Kinesis Data Firehose stream.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email
    /// events to.</p>
    pub fn delivery_stream_arn(&self) -> std::option::Option<&str> {
        self.delivery_stream_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisFirehoseDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseDestination");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("delivery_stream_arn", &self.delivery_stream_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
pub mod kinesis_firehose_destination {
    /// A builder for [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email
        /// events to the Amazon Kinesis Data Firehose stream.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email
        /// events to the Amazon Kinesis Data Firehose stream.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email
        /// events to.</p>
        pub fn delivery_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email
        /// events to.</p>
        pub fn set_delivery_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
        pub fn build(self) -> crate::model::KinesisFirehoseDestination {
            crate::model::KinesisFirehoseDestination {
                iam_role_arn: self.iam_role_arn,
                delivery_stream_arn: self.delivery_stream_arn,
            }
        }
    }
}
impl KinesisFirehoseDestination {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    pub fn builder() -> crate::model::kinesis_firehose_destination::Builder {
        crate::model::kinesis_firehose_destination::Builder::default()
    }
}

/// <p>An email sending event type. For example, email sends, opens, and bounces are all
/// email events.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    Bounce,
    #[allow(missing_docs)] // documentation missing in model
    Click,
    #[allow(missing_docs)] // documentation missing in model
    Complaint,
    #[allow(missing_docs)] // documentation missing in model
    Delivery,
    #[allow(missing_docs)] // documentation missing in model
    DeliveryDelay,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    #[allow(missing_docs)] // documentation missing in model
    RenderingFailure,
    #[allow(missing_docs)] // documentation missing in model
    Send,
    #[allow(missing_docs)] // documentation missing in model
    Subscription,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "BOUNCE" => EventType::Bounce,
            "CLICK" => EventType::Click,
            "COMPLAINT" => EventType::Complaint,
            "DELIVERY" => EventType::Delivery,
            "DELIVERY_DELAY" => EventType::DeliveryDelay,
            "OPEN" => EventType::Open,
            "REJECT" => EventType::Reject,
            "RENDERING_FAILURE" => EventType::RenderingFailure,
            "SEND" => EventType::Send,
            "SUBSCRIPTION" => EventType::Subscription,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::Bounce => "BOUNCE",
            EventType::Click => "CLICK",
            EventType::Complaint => "COMPLAINT",
            EventType::Delivery => "DELIVERY",
            EventType::DeliveryDelay => "DELIVERY_DELAY",
            EventType::Open => "OPEN",
            EventType::Reject => "REJECT",
            EventType::RenderingFailure => "RENDERING_FAILURE",
            EventType::Send => "SEND",
            EventType::Subscription => "SUBSCRIPTION",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOUNCE",
            "CLICK",
            "COMPLAINT",
            "DELIVERY",
            "DELIVERY_DELAY",
            "OPEN",
            "REJECT",
            "RENDERING_FAILURE",
            "SEND",
            "SUBSCRIPTION",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that defines the tags that are associated with a resource.
/// A <i>tag</i> is a label that you optionally define and associate with
/// a resource. Tags can help you categorize and manage resources in different ways, such as
/// by purpose, owner, environment, or other criteria. A resource can have as many as 50
/// tags.</p>
/// <p>Each tag consists of a required <i>tag key</i> and an
/// associated <i>tag value</i>, both of which you define. A tag key is a
/// general label that acts as a category for a more specific tag value. A tag value acts as
/// a descriptor within a tag key. A tag key can contain as many as 128 characters. A tag
/// value can contain as many as 256 characters. The characters can be Unicode letters,
/// digits, white space, or one of the following symbols: _ . : / = + -. The following
/// additional restrictions apply to tags:</p>
/// <ul>
/// <li>
/// <p>Tag keys and values are case sensitive.</p>
/// </li>
/// <li>
/// <p>For each associated resource, each tag key must be unique and it can have only
/// one value.</p>
/// </li>
/// <li>
/// <p>The <code>aws:</code> prefix is reserved for use by Amazon Web Services; you can’t use it in
/// any tag keys or values that you define. In addition, you can't edit or remove
/// tag keys or values that use this prefix. Tags that use this prefix don’t count
/// against the limit of 50 tags per resource.</p>
/// </li>
/// <li>
/// <p>You can associate tags with public or shared resources, but the tags are
/// available only for your Amazon Web Services account, not any other accounts that share the
/// resource. In addition, the tags are available only for resources that are
/// located in the specified Amazon Web Services Region for your Amazon Web Services account.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is
    /// 128 characters. The minimum length is 1 character.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag
    /// value is 256 characters. The minimum length is 0 characters. If you don't want a
    /// resource to have a specific tag value, don't specify a value for this parameter. If you
    /// don't specify a value, Amazon SES sets the value to an empty string.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is
    /// 128 characters. The minimum length is 1 character.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag
    /// value is 256 characters. The minimum length is 0 characters. If you don't want a
    /// resource to have a specific tag value, don't specify a value for this parameter. If you
    /// don't specify a value, Amazon SES sets the value to an empty string.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is
        /// 128 characters. The minimum length is 1 character.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that defines a tag. The maximum length of a tag key is
        /// 128 characters. The minimum length is 1 character.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag
        /// value is 256 characters. The minimum length is 0 characters. If you don't want a
        /// resource to have a specific tag value, don't specify a value for this parameter. If you
        /// don't specify a value, Amazon SES sets the value to an empty string.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that defines a tag. The maximum length of a tag
        /// value is 256 characters. The minimum length is 0 characters. If you don't want a
        /// resource to have a specific tag value, don't specify a value for this parameter. If you
        /// don't specify a value, Amazon SES sets the value to an empty string.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>An object used to specify a list or topic to which an email belongs, which will be
/// used when a contact chooses to unsubscribe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagementOptions {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>The name of the topic.</p>
    pub topic_name: std::option::Option<std::string::String>,
}
impl ListManagementOptions {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>The name of the topic.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
}
impl std::fmt::Debug for ListManagementOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagementOptions");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("topic_name", &self.topic_name);
        formatter.finish()
    }
}
/// See [`ListManagementOptions`](crate::model::ListManagementOptions)
pub mod list_management_options {
    /// A builder for [`ListManagementOptions`](crate::model::ListManagementOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) topic_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>The name of the topic.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of the topic.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagementOptions`](crate::model::ListManagementOptions)
        pub fn build(self) -> crate::model::ListManagementOptions {
            crate::model::ListManagementOptions {
                contact_list_name: self.contact_list_name,
                topic_name: self.topic_name,
            }
        }
    }
}
impl ListManagementOptions {
    /// Creates a new builder-style object to manufacture [`ListManagementOptions`](crate::model::ListManagementOptions)
    pub fn builder() -> crate::model::list_management_options::Builder {
        crate::model::list_management_options::Builder::default()
    }
}

/// <p>Contains the name and value of a tag that you apply to an email. You can use message
/// tags when you publish email sending events.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageTag {
    /// <p>The name of the message tag. The message tag name has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the message tag. The message tag value has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl MessageTag {
    /// <p>The name of the message tag. The message tag name has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the message tag. The message tag value has to meet the following
    /// criteria:</p>
    /// <ul>
    /// <li>
    /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>It can contain no more than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MessageTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageTag");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MessageTag`](crate::model::MessageTag)
pub mod message_tag {
    /// A builder for [`MessageTag`](crate::model::MessageTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the message tag. The message tag name has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the message tag. The message tag name has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the message tag. The message tag value has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the message tag. The message tag value has to meet the following
        /// criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>It can contain no more than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageTag`](crate::model::MessageTag)
        pub fn build(self) -> crate::model::MessageTag {
            crate::model::MessageTag {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MessageTag {
    /// Creates a new builder-style object to manufacture [`MessageTag`](crate::model::MessageTag)
    pub fn builder() -> crate::model::message_tag::Builder {
        crate::model::message_tag::Builder::default()
    }
}

/// <p>An object that defines the entire content of the email, including the message headers
/// and the body content. You can create a simple email message, in which you specify the
/// subject and the text and HTML versions of the message body. You can also create raw
/// messages, in which you specify a complete MIME-formatted message. Raw messages can
/// include attachments and custom headers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailContent {
    /// <p>The simple email message. The message consists of a subject and a message body.</p>
    pub simple: std::option::Option<crate::model::Message>,
    /// <p>The raw email message. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by one blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>If you include attachments, they must be in a file format that the Amazon SES API v2
    /// supports.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The entire message must be Base64 encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, you should encode that content to ensure that
    /// recipients' email clients render the message properly.</p>
    /// </li>
    /// <li>
    /// <p>The length of any single line of text in the message can't exceed 1,000
    /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    /// </li>
    /// </ul>
    pub raw: std::option::Option<crate::model::RawMessage>,
    /// <p>The template to use for the email message.</p>
    pub template: std::option::Option<crate::model::Template>,
}
impl EmailContent {
    /// <p>The simple email message. The message consists of a subject and a message body.</p>
    pub fn simple(&self) -> std::option::Option<&crate::model::Message> {
        self.simple.as_ref()
    }
    /// <p>The raw email message. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by one blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>If you include attachments, they must be in a file format that the Amazon SES API v2
    /// supports.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The entire message must be Base64 encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, you should encode that content to ensure that
    /// recipients' email clients render the message properly.</p>
    /// </li>
    /// <li>
    /// <p>The length of any single line of text in the message can't exceed 1,000
    /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    /// </li>
    /// </ul>
    pub fn raw(&self) -> std::option::Option<&crate::model::RawMessage> {
        self.raw.as_ref()
    }
    /// <p>The template to use for the email message.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
}
impl std::fmt::Debug for EmailContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailContent");
        formatter.field("simple", &self.simple);
        formatter.field("raw", &self.raw);
        formatter.field("template", &self.template);
        formatter.finish()
    }
}
/// See [`EmailContent`](crate::model::EmailContent)
pub mod email_content {
    /// A builder for [`EmailContent`](crate::model::EmailContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple: std::option::Option<crate::model::Message>,
        pub(crate) raw: std::option::Option<crate::model::RawMessage>,
        pub(crate) template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The simple email message. The message consists of a subject and a message body.</p>
        pub fn simple(mut self, input: crate::model::Message) -> Self {
            self.simple = Some(input);
            self
        }
        /// <p>The simple email message. The message consists of a subject and a message body.</p>
        pub fn set_simple(mut self, input: std::option::Option<crate::model::Message>) -> Self {
            self.simple = input;
            self
        }
        /// <p>The raw email message. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by one blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>If you include attachments, they must be in a file format that the Amazon SES API v2
        /// supports.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The entire message must be Base64 encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, you should encode that content to ensure that
        /// recipients' email clients render the message properly.</p>
        /// </li>
        /// <li>
        /// <p>The length of any single line of text in the message can't exceed 1,000
        /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        /// </li>
        /// </ul>
        pub fn raw(mut self, input: crate::model::RawMessage) -> Self {
            self.raw = Some(input);
            self
        }
        /// <p>The raw email message. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by one blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>If you include attachments, they must be in a file format that the Amazon SES API v2
        /// supports.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The entire message must be Base64 encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, you should encode that content to ensure that
        /// recipients' email clients render the message properly.</p>
        /// </li>
        /// <li>
        /// <p>The length of any single line of text in the message can't exceed 1,000
        /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_raw(mut self, input: std::option::Option<crate::model::RawMessage>) -> Self {
            self.raw = input;
            self
        }
        /// <p>The template to use for the email message.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The template to use for the email message.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailContent`](crate::model::EmailContent)
        pub fn build(self) -> crate::model::EmailContent {
            crate::model::EmailContent {
                simple: self.simple,
                raw: self.raw,
                template: self.template,
            }
        }
    }
}
impl EmailContent {
    /// Creates a new builder-style object to manufacture [`EmailContent`](crate::model::EmailContent)
    pub fn builder() -> crate::model::email_content::Builder {
        crate::model::email_content::Builder::default()
    }
}

/// <p>An object that defines the email template to use for an email message, and the values
/// to use for any message variables in that template. An <i>email
/// template</i> is a type of message template that contains content that you
/// want to define, save, and reuse in email messages that you send.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Template {
    /// <p>The name of the template. You will refer to this name when you send email using the
    /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
    /// </p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>An object that defines the values to use for message variables in the template. This
    /// object is a set of key-value pairs. Each key defines a message variable in the template.
    /// The corresponding value defines the value to use for that variable.</p>
    pub template_data: std::option::Option<std::string::String>,
}
impl Template {
    /// <p>The name of the template. You will refer to this name when you send email using the
    /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
    /// </p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>An object that defines the values to use for message variables in the template. This
    /// object is a set of key-value pairs. Each key defines a message variable in the template.
    /// The corresponding value defines the value to use for that variable.</p>
    pub fn template_data(&self) -> std::option::Option<&str> {
        self.template_data.as_deref()
    }
}
impl std::fmt::Debug for Template {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Template");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_data", &self.template_data);
        formatter.finish()
    }
}
/// See [`Template`](crate::model::Template)
pub mod template {
    /// A builder for [`Template`](crate::model::Template)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template. You will refer to this name when you send email using the
        /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
        /// </p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template. You will refer to this name when you send email using the
        /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
        /// </p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>An object that defines the values to use for message variables in the template. This
        /// object is a set of key-value pairs. Each key defines a message variable in the template.
        /// The corresponding value defines the value to use for that variable.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_data = Some(input.into());
            self
        }
        /// <p>An object that defines the values to use for message variables in the template. This
        /// object is a set of key-value pairs. Each key defines a message variable in the template.
        /// The corresponding value defines the value to use for that variable.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`Template`](crate::model::Template)
        pub fn build(self) -> crate::model::Template {
            crate::model::Template {
                template_name: self.template_name,
                template_arn: self.template_arn,
                template_data: self.template_data,
            }
        }
    }
}
impl Template {
    /// Creates a new builder-style object to manufacture [`Template`](crate::model::Template)
    pub fn builder() -> crate::model::template::Builder {
        crate::model::template::Builder::default()
    }
}

/// <p>Represents the raw content of an email message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RawMessage {
    /// <p>The raw email message. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by one blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>Attachments must be in a file format that the Amazon SES supports.</p>
    /// </li>
    /// <li>
    /// <p>The entire message must be Base64 encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, you should encode that content to ensure that
    /// recipients' email clients render the message properly.</p>
    /// </li>
    /// <li>
    /// <p>The length of any single line of text in the message can't exceed 1,000
    /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    /// </li>
    /// </ul>
    pub data: std::option::Option<aws_smithy_types::Blob>,
}
impl RawMessage {
    /// <p>The raw email message. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by one blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>Attachments must be in a file format that the Amazon SES supports.</p>
    /// </li>
    /// <li>
    /// <p>The entire message must be Base64 encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, you should encode that content to ensure that
    /// recipients' email clients render the message properly.</p>
    /// </li>
    /// <li>
    /// <p>The length of any single line of text in the message can't exceed 1,000
    /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    /// </li>
    /// </ul>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
}
impl std::fmt::Debug for RawMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RawMessage");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`RawMessage`](crate::model::RawMessage)
pub mod raw_message {
    /// A builder for [`RawMessage`](crate::model::RawMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The raw email message. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by one blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be in a file format that the Amazon SES supports.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be Base64 encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, you should encode that content to ensure that
        /// recipients' email clients render the message properly.</p>
        /// </li>
        /// <li>
        /// <p>The length of any single line of text in the message can't exceed 1,000
        /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        /// </li>
        /// </ul>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The raw email message. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by one blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be in a file format that the Amazon SES supports.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be Base64 encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, you should encode that content to ensure that
        /// recipients' email clients render the message properly.</p>
        /// </li>
        /// <li>
        /// <p>The length of any single line of text in the message can't exceed 1,000
        /// characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`RawMessage`](crate::model::RawMessage)
        pub fn build(self) -> crate::model::RawMessage {
            crate::model::RawMessage { data: self.data }
        }
    }
}
impl RawMessage {
    /// Creates a new builder-style object to manufacture [`RawMessage`](crate::model::RawMessage)
    pub fn builder() -> crate::model::raw_message::Builder {
        crate::model::raw_message::Builder::default()
    }
}

/// <p>Represents the email message that you're sending. The <code>Message</code> object
/// consists of a subject line and a message body.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The subject line of the email. The subject line can only contain 7-bit ASCII
    /// characters. However, you can specify non-ASCII characters in the subject line by using
    /// encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.</p>
    pub subject: std::option::Option<crate::model::Content>,
    /// <p>The body of the message. You can specify an HTML version of the message, a text-only
    /// version of the message, or both.</p>
    pub body: std::option::Option<crate::model::Body>,
}
impl Message {
    /// <p>The subject line of the email. The subject line can only contain 7-bit ASCII
    /// characters. However, you can specify non-ASCII characters in the subject line by using
    /// encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.</p>
    pub fn subject(&self) -> std::option::Option<&crate::model::Content> {
        self.subject.as_ref()
    }
    /// <p>The body of the message. You can specify an HTML version of the message, a text-only
    /// version of the message, or both.</p>
    pub fn body(&self) -> std::option::Option<&crate::model::Body> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("subject", &self.subject);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<crate::model::Content>,
        pub(crate) body: std::option::Option<crate::model::Body>,
    }
    impl Builder {
        /// <p>The subject line of the email. The subject line can only contain 7-bit ASCII
        /// characters. However, you can specify non-ASCII characters in the subject line by using
        /// encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.</p>
        pub fn subject(mut self, input: crate::model::Content) -> Self {
            self.subject = Some(input);
            self
        }
        /// <p>The subject line of the email. The subject line can only contain 7-bit ASCII
        /// characters. However, you can specify non-ASCII characters in the subject line by using
        /// encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.</p>
        pub fn set_subject(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The body of the message. You can specify an HTML version of the message, a text-only
        /// version of the message, or both.</p>
        pub fn body(mut self, input: crate::model::Body) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The body of the message. You can specify an HTML version of the message, a text-only
        /// version of the message, or both.</p>
        pub fn set_body(mut self, input: std::option::Option<crate::model::Body>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                subject: self.subject,
                body: self.body,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>Represents the body of the email message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Body {
    /// <p>An object that represents the version of the message that is displayed in email
    /// clients that don't support HTML, or clients where the recipient has disabled HTML
    /// rendering.</p>
    pub text: std::option::Option<crate::model::Content>,
    /// <p>An object that represents the version of the message that is displayed in email
    /// clients that support HTML. HTML messages can include formatted text, hyperlinks, images,
    /// and more. </p>
    pub html: std::option::Option<crate::model::Content>,
}
impl Body {
    /// <p>An object that represents the version of the message that is displayed in email
    /// clients that don't support HTML, or clients where the recipient has disabled HTML
    /// rendering.</p>
    pub fn text(&self) -> std::option::Option<&crate::model::Content> {
        self.text.as_ref()
    }
    /// <p>An object that represents the version of the message that is displayed in email
    /// clients that support HTML. HTML messages can include formatted text, hyperlinks, images,
    /// and more. </p>
    pub fn html(&self) -> std::option::Option<&crate::model::Content> {
        self.html.as_ref()
    }
}
impl std::fmt::Debug for Body {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Body");
        formatter.field("text", &self.text);
        formatter.field("html", &self.html);
        formatter.finish()
    }
}
/// See [`Body`](crate::model::Body)
pub mod body {
    /// A builder for [`Body`](crate::model::Body)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<crate::model::Content>,
        pub(crate) html: std::option::Option<crate::model::Content>,
    }
    impl Builder {
        /// <p>An object that represents the version of the message that is displayed in email
        /// clients that don't support HTML, or clients where the recipient has disabled HTML
        /// rendering.</p>
        pub fn text(mut self, input: crate::model::Content) -> Self {
            self.text = Some(input);
            self
        }
        /// <p>An object that represents the version of the message that is displayed in email
        /// clients that don't support HTML, or clients where the recipient has disabled HTML
        /// rendering.</p>
        pub fn set_text(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.text = input;
            self
        }
        /// <p>An object that represents the version of the message that is displayed in email
        /// clients that support HTML. HTML messages can include formatted text, hyperlinks, images,
        /// and more. </p>
        pub fn html(mut self, input: crate::model::Content) -> Self {
            self.html = Some(input);
            self
        }
        /// <p>An object that represents the version of the message that is displayed in email
        /// clients that support HTML. HTML messages can include formatted text, hyperlinks, images,
        /// and more. </p>
        pub fn set_html(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.html = input;
            self
        }
        /// Consumes the builder and constructs a [`Body`](crate::model::Body)
        pub fn build(self) -> crate::model::Body {
            crate::model::Body {
                text: self.text,
                html: self.html,
            }
        }
    }
}
impl Body {
    /// Creates a new builder-style object to manufacture [`Body`](crate::model::Body)
    pub fn builder() -> crate::model::body::Builder {
        crate::model::body::Builder::default()
    }
}

/// <p>An object that represents the content of the email, and optionally a character set
/// specification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Content {
    /// <p>The content of the message itself.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The character set for the content. Because of the constraints of the SMTP protocol,
    /// Amazon SES uses 7-bit ASCII by default. If the text includes characters outside of the ASCII
    /// range, you have to specify a character set. For example, you could specify
    /// <code>UTF-8</code>, <code>ISO-8859-1</code>, or <code>Shift_JIS</code>.</p>
    pub charset: std::option::Option<std::string::String>,
}
impl Content {
    /// <p>The content of the message itself.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The character set for the content. Because of the constraints of the SMTP protocol,
    /// Amazon SES uses 7-bit ASCII by default. If the text includes characters outside of the ASCII
    /// range, you have to specify a character set. For example, you could specify
    /// <code>UTF-8</code>, <code>ISO-8859-1</code>, or <code>Shift_JIS</code>.</p>
    pub fn charset(&self) -> std::option::Option<&str> {
        self.charset.as_deref()
    }
}
impl std::fmt::Debug for Content {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Content");
        formatter.field("data", &self.data);
        formatter.field("charset", &self.charset);
        formatter.finish()
    }
}
/// See [`Content`](crate::model::Content)
pub mod content {
    /// A builder for [`Content`](crate::model::Content)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) charset: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The content of the message itself.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The content of the message itself.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The character set for the content. Because of the constraints of the SMTP protocol,
        /// Amazon SES uses 7-bit ASCII by default. If the text includes characters outside of the ASCII
        /// range, you have to specify a character set. For example, you could specify
        /// <code>UTF-8</code>, <code>ISO-8859-1</code>, or <code>Shift_JIS</code>.</p>
        pub fn charset(mut self, input: impl Into<std::string::String>) -> Self {
            self.charset = Some(input.into());
            self
        }
        /// <p>The character set for the content. Because of the constraints of the SMTP protocol,
        /// Amazon SES uses 7-bit ASCII by default. If the text includes characters outside of the ASCII
        /// range, you have to specify a character set. For example, you could specify
        /// <code>UTF-8</code>, <code>ISO-8859-1</code>, or <code>Shift_JIS</code>.</p>
        pub fn set_charset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.charset = input;
            self
        }
        /// Consumes the builder and constructs a [`Content`](crate::model::Content)
        pub fn build(self) -> crate::model::Content {
            crate::model::Content {
                data: self.data,
                charset: self.charset,
            }
        }
    }
}
impl Content {
    /// Creates a new builder-style object to manufacture [`Content`](crate::model::Content)
    pub fn builder() -> crate::model::content::Builder {
        crate::model::content::Builder::default()
    }
}

/// <p>An object that describes the recipients for an email.</p>
/// <note>
/// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
/// <i>local part</i> of a destination email address (the part of the
/// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
/// characters</a>. If the <i>domain part</i> of an address (the
/// part after the @ sign) contains non-ASCII characters, they must be encoded using
/// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>An array that contains the email addresses of the "To" recipients for the
    /// email.</p>
    pub to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array that contains the email addresses of the "CC" (carbon copy) recipients for
    /// the email.</p>
    pub cc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array that contains the email addresses of the "BCC" (blind carbon copy) recipients
    /// for the email.</p>
    pub bcc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Destination {
    /// <p>An array that contains the email addresses of the "To" recipients for the
    /// email.</p>
    pub fn to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.to_addresses.as_deref()
    }
    /// <p>An array that contains the email addresses of the "CC" (carbon copy) recipients for
    /// the email.</p>
    pub fn cc_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.cc_addresses.as_deref()
    }
    /// <p>An array that contains the email addresses of the "BCC" (blind carbon copy) recipients
    /// for the email.</p>
    pub fn bcc_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.bcc_addresses.as_deref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("to_addresses", &self.to_addresses);
        formatter.field("cc_addresses", &self.cc_addresses);
        formatter.field("bcc_addresses", &self.bcc_addresses);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) bcc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `to_addresses`.
        ///
        /// To override the contents of this collection use [`set_to_addresses`](Self::set_to_addresses).
        ///
        /// <p>An array that contains the email addresses of the "To" recipients for the
        /// email.</p>
        pub fn to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.to_addresses.unwrap_or_default();
            v.push(input.into());
            self.to_addresses = Some(v);
            self
        }
        /// <p>An array that contains the email addresses of the "To" recipients for the
        /// email.</p>
        pub fn set_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.to_addresses = input;
            self
        }
        /// Appends an item to `cc_addresses`.
        ///
        /// To override the contents of this collection use [`set_cc_addresses`](Self::set_cc_addresses).
        ///
        /// <p>An array that contains the email addresses of the "CC" (carbon copy) recipients for
        /// the email.</p>
        pub fn cc_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cc_addresses.unwrap_or_default();
            v.push(input.into());
            self.cc_addresses = Some(v);
            self
        }
        /// <p>An array that contains the email addresses of the "CC" (carbon copy) recipients for
        /// the email.</p>
        pub fn set_cc_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cc_addresses = input;
            self
        }
        /// Appends an item to `bcc_addresses`.
        ///
        /// To override the contents of this collection use [`set_bcc_addresses`](Self::set_bcc_addresses).
        ///
        /// <p>An array that contains the email addresses of the "BCC" (blind carbon copy) recipients
        /// for the email.</p>
        pub fn bcc_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bcc_addresses.unwrap_or_default();
            v.push(input.into());
            self.bcc_addresses = Some(v);
            self
        }
        /// <p>An array that contains the email addresses of the "BCC" (blind carbon copy) recipients
        /// for the email.</p>
        pub fn set_bcc_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bcc_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                to_addresses: self.to_addresses,
                cc_addresses: self.cc_addresses,
                bcc_addresses: self.bcc_addresses,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p>The result of the <code>SendBulkEmail</code> operation of each specified
/// <code>BulkEmailEntry</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkEmailEntryResult {
    /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    /// <p>Possible values for this parameter include:</p>
    /// <ul>
    /// <li>
    /// <p>SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to
    /// the recipients.</p>
    /// </li>
    /// <li>
    /// <p>MESSAGE_REJECTED: The message was rejected because it contained a
    /// virus.</p>
    /// </li>
    /// <li>
    /// <p>MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not
    /// verified.</p>
    /// </li>
    /// <li>
    /// <p>CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not
    /// exist.</p>
    /// </li>
    /// <li>
    /// <p>TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_SUSPENDED: Your account has been shut down because of issues related
    /// to your email sending practices.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_THROTTLED: The number of emails you can send has been reduced because
    /// your account has exceeded its allocated sending limit.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number
    /// of emails you can send from your account in a 24-hour period.</p>
    /// </li>
    /// <li>
    /// <p>INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP
    /// pool that does not exist.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled
    /// using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html">UpdateAccountSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was
    /// disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">UpdateConfigurationSetSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>INVALID_PARAMETER_VALUE: One or more of the parameters you specified when
    /// calling this operation was invalid. See the error message for additional
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a
    /// temporary issue.</p>
    /// </li>
    /// <li>
    /// <p>FAILED: Amazon SES was unable to process your request. See the error message
    /// for additional information.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::BulkEmailStatus>,
    /// <p>A description of an error that prevented a message being sent using the
    /// <code>SendBulkTemplatedEmail</code> operation.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl BulkEmailEntryResult {
    /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    /// <p>Possible values for this parameter include:</p>
    /// <ul>
    /// <li>
    /// <p>SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to
    /// the recipients.</p>
    /// </li>
    /// <li>
    /// <p>MESSAGE_REJECTED: The message was rejected because it contained a
    /// virus.</p>
    /// </li>
    /// <li>
    /// <p>MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not
    /// verified.</p>
    /// </li>
    /// <li>
    /// <p>CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not
    /// exist.</p>
    /// </li>
    /// <li>
    /// <p>TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_SUSPENDED: Your account has been shut down because of issues related
    /// to your email sending practices.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_THROTTLED: The number of emails you can send has been reduced because
    /// your account has exceeded its allocated sending limit.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number
    /// of emails you can send from your account in a 24-hour period.</p>
    /// </li>
    /// <li>
    /// <p>INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP
    /// pool that does not exist.</p>
    /// </li>
    /// <li>
    /// <p>ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled
    /// using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html">UpdateAccountSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was
    /// disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">UpdateConfigurationSetSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>INVALID_PARAMETER_VALUE: One or more of the parameters you specified when
    /// calling this operation was invalid. See the error message for additional
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a
    /// temporary issue.</p>
    /// </li>
    /// <li>
    /// <p>FAILED: Amazon SES was unable to process your request. See the error message
    /// for additional information.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::BulkEmailStatus> {
        self.status.as_ref()
    }
    /// <p>A description of an error that prevented a message being sent using the
    /// <code>SendBulkTemplatedEmail</code> operation.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for BulkEmailEntryResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkEmailEntryResult");
        formatter.field("status", &self.status);
        formatter.field("error", &self.error);
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`BulkEmailEntryResult`](crate::model::BulkEmailEntryResult)
pub mod bulk_email_entry_result {
    /// A builder for [`BulkEmailEntryResult`](crate::model::BulkEmailEntryResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BulkEmailStatus>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        /// <p>Possible values for this parameter include:</p>
        /// <ul>
        /// <li>
        /// <p>SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to
        /// the recipients.</p>
        /// </li>
        /// <li>
        /// <p>MESSAGE_REJECTED: The message was rejected because it contained a
        /// virus.</p>
        /// </li>
        /// <li>
        /// <p>MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not
        /// verified.</p>
        /// </li>
        /// <li>
        /// <p>CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not
        /// exist.</p>
        /// </li>
        /// <li>
        /// <p>TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_SUSPENDED: Your account has been shut down because of issues related
        /// to your email sending practices.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_THROTTLED: The number of emails you can send has been reduced because
        /// your account has exceeded its allocated sending limit.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number
        /// of emails you can send from your account in a 24-hour period.</p>
        /// </li>
        /// <li>
        /// <p>INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP
        /// pool that does not exist.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled
        /// using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html">UpdateAccountSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was
        /// disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">UpdateConfigurationSetSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>INVALID_PARAMETER_VALUE: One or more of the parameters you specified when
        /// calling this operation was invalid. See the error message for additional
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a
        /// temporary issue.</p>
        /// </li>
        /// <li>
        /// <p>FAILED: Amazon SES was unable to process your request. See the error message
        /// for additional information.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::BulkEmailStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        /// <p>Possible values for this parameter include:</p>
        /// <ul>
        /// <li>
        /// <p>SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to
        /// the recipients.</p>
        /// </li>
        /// <li>
        /// <p>MESSAGE_REJECTED: The message was rejected because it contained a
        /// virus.</p>
        /// </li>
        /// <li>
        /// <p>MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not
        /// verified.</p>
        /// </li>
        /// <li>
        /// <p>CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not
        /// exist.</p>
        /// </li>
        /// <li>
        /// <p>TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_SUSPENDED: Your account has been shut down because of issues related
        /// to your email sending practices.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_THROTTLED: The number of emails you can send has been reduced because
        /// your account has exceeded its allocated sending limit.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number
        /// of emails you can send from your account in a 24-hour period.</p>
        /// </li>
        /// <li>
        /// <p>INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP
        /// pool that does not exist.</p>
        /// </li>
        /// <li>
        /// <p>ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled
        /// using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html">UpdateAccountSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was
        /// disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">UpdateConfigurationSetSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>INVALID_PARAMETER_VALUE: One or more of the parameters you specified when
        /// calling this operation was invalid. See the error message for additional
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a
        /// temporary issue.</p>
        /// </li>
        /// <li>
        /// <p>FAILED: Amazon SES was unable to process your request. See the error message
        /// for additional information.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BulkEmailStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description of an error that prevented a message being sent using the
        /// <code>SendBulkTemplatedEmail</code> operation.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>A description of an error that prevented a message being sent using the
        /// <code>SendBulkTemplatedEmail</code> operation.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkEmailEntryResult`](crate::model::BulkEmailEntryResult)
        pub fn build(self) -> crate::model::BulkEmailEntryResult {
            crate::model::BulkEmailEntryResult {
                status: self.status,
                error: self.error,
                message_id: self.message_id,
            }
        }
    }
}
impl BulkEmailEntryResult {
    /// Creates a new builder-style object to manufacture [`BulkEmailEntryResult`](crate::model::BulkEmailEntryResult)
    pub fn builder() -> crate::model::bulk_email_entry_result::Builder {
        crate::model::bulk_email_entry_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BulkEmailStatus {
    #[allow(missing_docs)] // documentation missing in model
    AccountDailyQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AccountSendingPaused,
    #[allow(missing_docs)] // documentation missing in model
    AccountSuspended,
    #[allow(missing_docs)] // documentation missing in model
    AccountThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSetSendingPaused,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameter,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSendingPoolName,
    #[allow(missing_docs)] // documentation missing in model
    MailFromDomainNotVerified,
    #[allow(missing_docs)] // documentation missing in model
    MessageRejected,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemplateNotFound,
    #[allow(missing_docs)] // documentation missing in model
    TransientFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BulkEmailStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_DAILY_QUOTA_EXCEEDED" => BulkEmailStatus::AccountDailyQuotaExceeded,
            "ACCOUNT_SENDING_PAUSED" => BulkEmailStatus::AccountSendingPaused,
            "ACCOUNT_SUSPENDED" => BulkEmailStatus::AccountSuspended,
            "ACCOUNT_THROTTLED" => BulkEmailStatus::AccountThrottled,
            "CONFIGURATION_SET_NOT_FOUND" => BulkEmailStatus::ConfigurationSetNotFound,
            "CONFIGURATION_SET_SENDING_PAUSED" => BulkEmailStatus::ConfigurationSetSendingPaused,
            "FAILED" => BulkEmailStatus::Failed,
            "INVALID_PARAMETER" => BulkEmailStatus::InvalidParameter,
            "INVALID_SENDING_POOL_NAME" => BulkEmailStatus::InvalidSendingPoolName,
            "MAIL_FROM_DOMAIN_NOT_VERIFIED" => BulkEmailStatus::MailFromDomainNotVerified,
            "MESSAGE_REJECTED" => BulkEmailStatus::MessageRejected,
            "SUCCESS" => BulkEmailStatus::Success,
            "TEMPLATE_NOT_FOUND" => BulkEmailStatus::TemplateNotFound,
            "TRANSIENT_FAILURE" => BulkEmailStatus::TransientFailure,
            other => BulkEmailStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BulkEmailStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BulkEmailStatus::from(s))
    }
}
impl BulkEmailStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BulkEmailStatus::AccountDailyQuotaExceeded => "ACCOUNT_DAILY_QUOTA_EXCEEDED",
            BulkEmailStatus::AccountSendingPaused => "ACCOUNT_SENDING_PAUSED",
            BulkEmailStatus::AccountSuspended => "ACCOUNT_SUSPENDED",
            BulkEmailStatus::AccountThrottled => "ACCOUNT_THROTTLED",
            BulkEmailStatus::ConfigurationSetNotFound => "CONFIGURATION_SET_NOT_FOUND",
            BulkEmailStatus::ConfigurationSetSendingPaused => "CONFIGURATION_SET_SENDING_PAUSED",
            BulkEmailStatus::Failed => "FAILED",
            BulkEmailStatus::InvalidParameter => "INVALID_PARAMETER",
            BulkEmailStatus::InvalidSendingPoolName => "INVALID_SENDING_POOL_NAME",
            BulkEmailStatus::MailFromDomainNotVerified => "MAIL_FROM_DOMAIN_NOT_VERIFIED",
            BulkEmailStatus::MessageRejected => "MESSAGE_REJECTED",
            BulkEmailStatus::Success => "SUCCESS",
            BulkEmailStatus::TemplateNotFound => "TEMPLATE_NOT_FOUND",
            BulkEmailStatus::TransientFailure => "TRANSIENT_FAILURE",
            BulkEmailStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_DAILY_QUOTA_EXCEEDED",
            "ACCOUNT_SENDING_PAUSED",
            "ACCOUNT_SUSPENDED",
            "ACCOUNT_THROTTLED",
            "CONFIGURATION_SET_NOT_FOUND",
            "CONFIGURATION_SET_SENDING_PAUSED",
            "FAILED",
            "INVALID_PARAMETER",
            "INVALID_SENDING_POOL_NAME",
            "MAIL_FROM_DOMAIN_NOT_VERIFIED",
            "MESSAGE_REJECTED",
            "SUCCESS",
            "TEMPLATE_NOT_FOUND",
            "TRANSIENT_FAILURE",
        ]
    }
}
impl AsRef<str> for BulkEmailStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkEmailEntry {
    /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
    /// fields.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// local part of a destination email address (the part of the email address that
    /// precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the domain part of an address (the part after the @ sign)
    /// contains non-ASCII characters, they must be encoded using Punycode, as described in
    /// <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
    /// </note>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using the <code>SendBulkTemplatedEmail</code> operation. Tags correspond to
    /// characteristics of the email that you define, so that you can publish email sending
    /// events.</p>
    pub replacement_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The <code>ReplacementEmailContent</code> associated with a
    /// <code>BulkEmailEntry</code>.</p>
    pub replacement_email_content: std::option::Option<crate::model::ReplacementEmailContent>,
}
impl BulkEmailEntry {
    /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
    /// fields.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// local part of a destination email address (the part of the email address that
    /// precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the domain part of an address (the part after the @ sign)
    /// contains non-ASCII characters, they must be encoded using Punycode, as described in
    /// <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
    /// </note>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using the <code>SendBulkTemplatedEmail</code> operation. Tags correspond to
    /// characteristics of the email that you define, so that you can publish email sending
    /// events.</p>
    pub fn replacement_tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.replacement_tags.as_deref()
    }
    /// <p>The <code>ReplacementEmailContent</code> associated with a
    /// <code>BulkEmailEntry</code>.</p>
    pub fn replacement_email_content(
        &self,
    ) -> std::option::Option<&crate::model::ReplacementEmailContent> {
        self.replacement_email_content.as_ref()
    }
}
impl std::fmt::Debug for BulkEmailEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkEmailEntry");
        formatter.field("destination", &self.destination);
        formatter.field("replacement_tags", &self.replacement_tags);
        formatter.field("replacement_email_content", &self.replacement_email_content);
        formatter.finish()
    }
}
/// See [`BulkEmailEntry`](crate::model::BulkEmailEntry)
pub mod bulk_email_entry {
    /// A builder for [`BulkEmailEntry`](crate::model::BulkEmailEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) replacement_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) replacement_email_content:
            std::option::Option<crate::model::ReplacementEmailContent>,
    }
    impl Builder {
        /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
        /// fields.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// local part of a destination email address (the part of the email address that
        /// precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the domain part of an address (the part after the @ sign)
        /// contains non-ASCII characters, they must be encoded using Punycode, as described in
        /// <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
        /// </note>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
        /// fields.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// local part of a destination email address (the part of the email address that
        /// precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the domain part of an address (the part after the @ sign)
        /// contains non-ASCII characters, they must be encoded using Punycode, as described in
        /// <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
        /// </note>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Appends an item to `replacement_tags`.
        ///
        /// To override the contents of this collection use [`set_replacement_tags`](Self::set_replacement_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendBulkTemplatedEmail</code> operation. Tags correspond to
        /// characteristics of the email that you define, so that you can publish email sending
        /// events.</p>
        pub fn replacement_tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.replacement_tags.unwrap_or_default();
            v.push(input.into());
            self.replacement_tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendBulkTemplatedEmail</code> operation. Tags correspond to
        /// characteristics of the email that you define, so that you can publish email sending
        /// events.</p>
        pub fn set_replacement_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.replacement_tags = input;
            self
        }
        /// <p>The <code>ReplacementEmailContent</code> associated with a
        /// <code>BulkEmailEntry</code>.</p>
        pub fn replacement_email_content(
            mut self,
            input: crate::model::ReplacementEmailContent,
        ) -> Self {
            self.replacement_email_content = Some(input);
            self
        }
        /// <p>The <code>ReplacementEmailContent</code> associated with a
        /// <code>BulkEmailEntry</code>.</p>
        pub fn set_replacement_email_content(
            mut self,
            input: std::option::Option<crate::model::ReplacementEmailContent>,
        ) -> Self {
            self.replacement_email_content = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkEmailEntry`](crate::model::BulkEmailEntry)
        pub fn build(self) -> crate::model::BulkEmailEntry {
            crate::model::BulkEmailEntry {
                destination: self.destination,
                replacement_tags: self.replacement_tags,
                replacement_email_content: self.replacement_email_content,
            }
        }
    }
}
impl BulkEmailEntry {
    /// Creates a new builder-style object to manufacture [`BulkEmailEntry`](crate::model::BulkEmailEntry)
    pub fn builder() -> crate::model::bulk_email_entry::Builder {
        crate::model::bulk_email_entry::Builder::default()
    }
}

/// <p>The <code>ReplaceEmailContent</code> object to be used for a specific
/// <code>BulkEmailEntry</code>. The <code>ReplacementTemplate</code> can be specified
/// within this object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplacementEmailContent {
    /// <p>The <code>ReplacementTemplate</code> associated with
    /// <code>ReplacementEmailContent</code>.</p>
    pub replacement_template: std::option::Option<crate::model::ReplacementTemplate>,
}
impl ReplacementEmailContent {
    /// <p>The <code>ReplacementTemplate</code> associated with
    /// <code>ReplacementEmailContent</code>.</p>
    pub fn replacement_template(&self) -> std::option::Option<&crate::model::ReplacementTemplate> {
        self.replacement_template.as_ref()
    }
}
impl std::fmt::Debug for ReplacementEmailContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplacementEmailContent");
        formatter.field("replacement_template", &self.replacement_template);
        formatter.finish()
    }
}
/// See [`ReplacementEmailContent`](crate::model::ReplacementEmailContent)
pub mod replacement_email_content {
    /// A builder for [`ReplacementEmailContent`](crate::model::ReplacementEmailContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replacement_template: std::option::Option<crate::model::ReplacementTemplate>,
    }
    impl Builder {
        /// <p>The <code>ReplacementTemplate</code> associated with
        /// <code>ReplacementEmailContent</code>.</p>
        pub fn replacement_template(mut self, input: crate::model::ReplacementTemplate) -> Self {
            self.replacement_template = Some(input);
            self
        }
        /// <p>The <code>ReplacementTemplate</code> associated with
        /// <code>ReplacementEmailContent</code>.</p>
        pub fn set_replacement_template(
            mut self,
            input: std::option::Option<crate::model::ReplacementTemplate>,
        ) -> Self {
            self.replacement_template = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplacementEmailContent`](crate::model::ReplacementEmailContent)
        pub fn build(self) -> crate::model::ReplacementEmailContent {
            crate::model::ReplacementEmailContent {
                replacement_template: self.replacement_template,
            }
        }
    }
}
impl ReplacementEmailContent {
    /// Creates a new builder-style object to manufacture [`ReplacementEmailContent`](crate::model::ReplacementEmailContent)
    pub fn builder() -> crate::model::replacement_email_content::Builder {
        crate::model::replacement_email_content::Builder::default()
    }
}

/// <p>An object which contains <code>ReplacementTemplateData</code> to be used for a
/// specific <code>BulkEmailEntry</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplacementTemplate {
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub replacement_template_data: std::option::Option<std::string::String>,
}
impl ReplacementTemplate {
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub fn replacement_template_data(&self) -> std::option::Option<&str> {
        self.replacement_template_data.as_deref()
    }
}
impl std::fmt::Debug for ReplacementTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplacementTemplate");
        formatter.field("replacement_template_data", &self.replacement_template_data);
        formatter.finish()
    }
}
/// See [`ReplacementTemplate`](crate::model::ReplacementTemplate)
pub mod replacement_template {
    /// A builder for [`ReplacementTemplate`](crate::model::ReplacementTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replacement_template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn replacement_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.replacement_template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_replacement_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replacement_template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplacementTemplate`](crate::model::ReplacementTemplate)
        pub fn build(self) -> crate::model::ReplacementTemplate {
            crate::model::ReplacementTemplate {
                replacement_template_data: self.replacement_template_data,
            }
        }
    }
}
impl ReplacementTemplate {
    /// Creates a new builder-style object to manufacture [`ReplacementTemplate`](crate::model::ReplacementTemplate)
    pub fn builder() -> crate::model::replacement_template::Builder {
        crate::model::replacement_template::Builder::default()
    }
}

/// <p>An object that contains the body of the message. You can specify a template
/// message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkEmailContent {
    /// <p>The template to use for the bulk email message.</p>
    pub template: std::option::Option<crate::model::Template>,
}
impl BulkEmailContent {
    /// <p>The template to use for the bulk email message.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
}
impl std::fmt::Debug for BulkEmailContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkEmailContent");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}
/// See [`BulkEmailContent`](crate::model::BulkEmailContent)
pub mod bulk_email_content {
    /// A builder for [`BulkEmailContent`](crate::model::BulkEmailContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The template to use for the bulk email message.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The template to use for the bulk email message.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkEmailContent`](crate::model::BulkEmailContent)
        pub fn build(self) -> crate::model::BulkEmailContent {
            crate::model::BulkEmailContent {
                template: self.template,
            }
        }
    }
}
impl BulkEmailContent {
    /// Creates a new builder-style object to manufacture [`BulkEmailContent`](crate::model::BulkEmailContent)
    pub fn builder() -> crate::model::bulk_email_content::Builder {
        crate::model::bulk_email_content::Builder::default()
    }
}

/// <p>The reason that the address was added to the suppression list for your account. The
/// value can be one of the following:</p>
/// <ul>
/// <li>
/// <p>
/// <code>COMPLAINT</code> – Amazon SES added an email address to the suppression
/// list for your account because a message sent to that address results in a
/// complaint.</p>
/// </li>
/// <li>
/// <p>
/// <code>BOUNCE</code> – Amazon SES added an email address to the suppression
/// list for your account because a message sent to that address results in a hard
/// bounce.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SuppressionListReason {
    #[allow(missing_docs)] // documentation missing in model
    Bounce,
    #[allow(missing_docs)] // documentation missing in model
    Complaint,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SuppressionListReason {
    fn from(s: &str) -> Self {
        match s {
            "BOUNCE" => SuppressionListReason::Bounce,
            "COMPLAINT" => SuppressionListReason::Complaint,
            other => SuppressionListReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SuppressionListReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SuppressionListReason::from(s))
    }
}
impl SuppressionListReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SuppressionListReason::Bounce => "BOUNCE",
            SuppressionListReason::Complaint => "COMPLAINT",
            SuppressionListReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOUNCE", "COMPLAINT"]
    }
}
impl AsRef<str> for SuppressionListReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The action to take if the required MX record can't be found when you send an email.
/// When you set this value to <code>UseDefaultValue</code>, the mail is sent using
/// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
/// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
/// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
/// email.</p>
/// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
/// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
/// states.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BehaviorOnMxFailure {
    #[allow(missing_docs)] // documentation missing in model
    RejectMessage,
    #[allow(missing_docs)] // documentation missing in model
    UseDefaultValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BehaviorOnMxFailure {
    fn from(s: &str) -> Self {
        match s {
            "REJECT_MESSAGE" => BehaviorOnMxFailure::RejectMessage,
            "USE_DEFAULT_VALUE" => BehaviorOnMxFailure::UseDefaultValue,
            other => BehaviorOnMxFailure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BehaviorOnMxFailure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BehaviorOnMxFailure::from(s))
    }
}
impl BehaviorOnMxFailure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BehaviorOnMxFailure::RejectMessage => "REJECT_MESSAGE",
            BehaviorOnMxFailure::UseDefaultValue => "USE_DEFAULT_VALUE",
            BehaviorOnMxFailure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REJECT_MESSAGE", "USE_DEFAULT_VALUE"]
    }
}
impl AsRef<str> for BehaviorOnMxFailure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The DKIM authentication status of the identity. The status can be one of the
/// following:</p>
/// <ul>
/// <li>
/// <p>
/// <code>PENDING</code> – The verification process was initiated, but Amazon SES
/// hasn't yet detected the DKIM records in the DNS configuration for the
/// domain.</p>
/// </li>
/// <li>
/// <p>
/// <code>SUCCESS</code> – The verification process completed
/// successfully.</p>
/// </li>
/// <li>
/// <p>
/// <code>FAILED</code> – The verification process failed. This typically
/// occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the
/// domain.</p>
/// </li>
/// <li>
/// <p>
/// <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES
/// from determining the DKIM authentication status of the domain.</p>
/// </li>
/// <li>
/// <p>
/// <code>NOT_STARTED</code> – The DKIM verification process hasn't been
/// initiated for the domain.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DkimStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DkimStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DkimStatus::Failed,
            "NOT_STARTED" => DkimStatus::NotStarted,
            "PENDING" => DkimStatus::Pending,
            "SUCCESS" => DkimStatus::Success,
            "TEMPORARY_FAILURE" => DkimStatus::TemporaryFailure,
            other => DkimStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DkimStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DkimStatus::from(s))
    }
}
impl DkimStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DkimStatus::Failed => "FAILED",
            DkimStatus::NotStarted => "NOT_STARTED",
            DkimStatus::Pending => "PENDING",
            DkimStatus::Success => "SUCCESS",
            DkimStatus::TemporaryFailure => "TEMPORARY_FAILURE",
            DkimStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "NOT_STARTED",
            "PENDING",
            "SUCCESS",
            "TEMPORARY_FAILURE",
        ]
    }
}
impl AsRef<str> for DkimStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains configuration for Bring Your Own DKIM (BYODKIM), or, for Easy DKIM</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DkimSigningAttributes {
    /// <p>[Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
    /// domain.</p>
    pub domain_signing_selector: std::option::Option<std::string::String>,
    /// <p>[Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
    /// <p>The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using
    /// base64 encoding.</p>
    pub domain_signing_private_key: std::option::Option<std::string::String>,
    /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
    pub next_signing_key_length: std::option::Option<crate::model::DkimSigningKeyLength>,
}
impl DkimSigningAttributes {
    /// <p>[Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
    /// domain.</p>
    pub fn domain_signing_selector(&self) -> std::option::Option<&str> {
        self.domain_signing_selector.as_deref()
    }
    /// <p>[Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
    /// <p>The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using
    /// base64 encoding.</p>
    pub fn domain_signing_private_key(&self) -> std::option::Option<&str> {
        self.domain_signing_private_key.as_deref()
    }
    /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
    pub fn next_signing_key_length(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningKeyLength> {
        self.next_signing_key_length.as_ref()
    }
}
impl std::fmt::Debug for DkimSigningAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DkimSigningAttributes");
        formatter.field("domain_signing_selector", &self.domain_signing_selector);
        formatter.field(
            "domain_signing_private_key",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("next_signing_key_length", &self.next_signing_key_length);
        formatter.finish()
    }
}
/// See [`DkimSigningAttributes`](crate::model::DkimSigningAttributes)
pub mod dkim_signing_attributes {
    /// A builder for [`DkimSigningAttributes`](crate::model::DkimSigningAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_signing_selector: std::option::Option<std::string::String>,
        pub(crate) domain_signing_private_key: std::option::Option<std::string::String>,
        pub(crate) next_signing_key_length: std::option::Option<crate::model::DkimSigningKeyLength>,
    }
    impl Builder {
        /// <p>[Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
        /// domain.</p>
        pub fn domain_signing_selector(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_signing_selector = Some(input.into());
            self
        }
        /// <p>[Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a
        /// domain.</p>
        pub fn set_domain_signing_selector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_signing_selector = input;
            self
        }
        /// <p>[Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
        /// <p>The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using
        /// base64 encoding.</p>
        pub fn domain_signing_private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_signing_private_key = Some(input.into());
            self
        }
        /// <p>[Bring Your Own DKIM] A private key that's used to generate a DKIM signature.</p>
        /// <p>The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using
        /// base64 encoding.</p>
        pub fn set_domain_signing_private_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_signing_private_key = input;
            self
        }
        /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
        pub fn next_signing_key_length(
            mut self,
            input: crate::model::DkimSigningKeyLength,
        ) -> Self {
            self.next_signing_key_length = Some(input);
            self
        }
        /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
        pub fn set_next_signing_key_length(
            mut self,
            input: std::option::Option<crate::model::DkimSigningKeyLength>,
        ) -> Self {
            self.next_signing_key_length = input;
            self
        }
        /// Consumes the builder and constructs a [`DkimSigningAttributes`](crate::model::DkimSigningAttributes)
        pub fn build(self) -> crate::model::DkimSigningAttributes {
            crate::model::DkimSigningAttributes {
                domain_signing_selector: self.domain_signing_selector,
                domain_signing_private_key: self.domain_signing_private_key,
                next_signing_key_length: self.next_signing_key_length,
            }
        }
    }
}
impl DkimSigningAttributes {
    /// Creates a new builder-style object to manufacture [`DkimSigningAttributes`](crate::model::DkimSigningAttributes)
    pub fn builder() -> crate::model::dkim_signing_attributes::Builder {
        crate::model::dkim_signing_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DkimSigningKeyLength {
    #[allow(missing_docs)] // documentation missing in model
    Rsa1024Bit,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048Bit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DkimSigningKeyLength {
    fn from(s: &str) -> Self {
        match s {
            "RSA_1024_BIT" => DkimSigningKeyLength::Rsa1024Bit,
            "RSA_2048_BIT" => DkimSigningKeyLength::Rsa2048Bit,
            other => DkimSigningKeyLength::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DkimSigningKeyLength {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DkimSigningKeyLength::from(s))
    }
}
impl DkimSigningKeyLength {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DkimSigningKeyLength::Rsa1024Bit => "RSA_1024_BIT",
            DkimSigningKeyLength::Rsa2048Bit => "RSA_2048_BIT",
            DkimSigningKeyLength::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RSA_1024_BIT", "RSA_2048_BIT"]
    }
}
impl AsRef<str> for DkimSigningKeyLength {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DkimSigningAttributesOrigin {
    #[allow(missing_docs)] // documentation missing in model
    AwsSes,
    #[allow(missing_docs)] // documentation missing in model
    External,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DkimSigningAttributesOrigin {
    fn from(s: &str) -> Self {
        match s {
            "AWS_SES" => DkimSigningAttributesOrigin::AwsSes,
            "EXTERNAL" => DkimSigningAttributesOrigin::External,
            other => DkimSigningAttributesOrigin::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DkimSigningAttributesOrigin {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DkimSigningAttributesOrigin::from(s))
    }
}
impl DkimSigningAttributesOrigin {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DkimSigningAttributesOrigin::AwsSes => "AWS_SES",
            DkimSigningAttributesOrigin::External => "EXTERNAL",
            DkimSigningAttributesOrigin::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_SES", "EXTERNAL"]
    }
}
impl AsRef<str> for DkimSigningAttributesOrigin {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about the Deliverability dashboard subscription for a
/// verified domain that you use to send email and currently has an active Deliverability dashboard
/// subscription. If a Deliverability dashboard subscription is active for a domain, you gain access
/// to reputation, inbox placement, and other metrics for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDeliverabilityTrackingOption {
    /// <p>A verified domain that’s associated with your Amazon Web Services account and currently has an
    /// active Deliverability dashboard subscription.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The date, in Unix time format, when you enabled the Deliverability dashboard for the
    /// domain.</p>
    pub subscription_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An object that contains information about the inbox placement data settings for the
    /// domain.</p>
    pub inbox_placement_tracking_option:
        std::option::Option<crate::model::InboxPlacementTrackingOption>,
}
impl DomainDeliverabilityTrackingOption {
    /// <p>A verified domain that’s associated with your Amazon Web Services account and currently has an
    /// active Deliverability dashboard subscription.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The date, in Unix time format, when you enabled the Deliverability dashboard for the
    /// domain.</p>
    pub fn subscription_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.subscription_start_date.as_ref()
    }
    /// <p>An object that contains information about the inbox placement data settings for the
    /// domain.</p>
    pub fn inbox_placement_tracking_option(
        &self,
    ) -> std::option::Option<&crate::model::InboxPlacementTrackingOption> {
        self.inbox_placement_tracking_option.as_ref()
    }
}
impl std::fmt::Debug for DomainDeliverabilityTrackingOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDeliverabilityTrackingOption");
        formatter.field("domain", &self.domain);
        formatter.field("subscription_start_date", &self.subscription_start_date);
        formatter.field(
            "inbox_placement_tracking_option",
            &self.inbox_placement_tracking_option,
        );
        formatter.finish()
    }
}
/// See [`DomainDeliverabilityTrackingOption`](crate::model::DomainDeliverabilityTrackingOption)
pub mod domain_deliverability_tracking_option {
    /// A builder for [`DomainDeliverabilityTrackingOption`](crate::model::DomainDeliverabilityTrackingOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) subscription_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) inbox_placement_tracking_option:
            std::option::Option<crate::model::InboxPlacementTrackingOption>,
    }
    impl Builder {
        /// <p>A verified domain that’s associated with your Amazon Web Services account and currently has an
        /// active Deliverability dashboard subscription.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>A verified domain that’s associated with your Amazon Web Services account and currently has an
        /// active Deliverability dashboard subscription.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The date, in Unix time format, when you enabled the Deliverability dashboard for the
        /// domain.</p>
        pub fn subscription_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.subscription_start_date = Some(input);
            self
        }
        /// <p>The date, in Unix time format, when you enabled the Deliverability dashboard for the
        /// domain.</p>
        pub fn set_subscription_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.subscription_start_date = input;
            self
        }
        /// <p>An object that contains information about the inbox placement data settings for the
        /// domain.</p>
        pub fn inbox_placement_tracking_option(
            mut self,
            input: crate::model::InboxPlacementTrackingOption,
        ) -> Self {
            self.inbox_placement_tracking_option = Some(input);
            self
        }
        /// <p>An object that contains information about the inbox placement data settings for the
        /// domain.</p>
        pub fn set_inbox_placement_tracking_option(
            mut self,
            input: std::option::Option<crate::model::InboxPlacementTrackingOption>,
        ) -> Self {
            self.inbox_placement_tracking_option = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDeliverabilityTrackingOption`](crate::model::DomainDeliverabilityTrackingOption)
        pub fn build(self) -> crate::model::DomainDeliverabilityTrackingOption {
            crate::model::DomainDeliverabilityTrackingOption {
                domain: self.domain,
                subscription_start_date: self.subscription_start_date,
                inbox_placement_tracking_option: self.inbox_placement_tracking_option,
            }
        }
    }
}
impl DomainDeliverabilityTrackingOption {
    /// Creates a new builder-style object to manufacture [`DomainDeliverabilityTrackingOption`](crate::model::DomainDeliverabilityTrackingOption)
    pub fn builder() -> crate::model::domain_deliverability_tracking_option::Builder {
        crate::model::domain_deliverability_tracking_option::Builder::default()
    }
}

/// <p>An object that contains information about the inbox placement data settings for a
/// verified domain that’s associated with your Amazon Web Services account. This data is available only
/// if you enabled the Deliverability dashboard for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InboxPlacementTrackingOption {
    /// <p>Specifies whether inbox placement data is being tracked for the domain.</p>
    pub global: bool,
    /// <p>An array of strings, one for each major email provider that the inbox placement data
    /// applies to.</p>
    pub tracked_isps: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl InboxPlacementTrackingOption {
    /// <p>Specifies whether inbox placement data is being tracked for the domain.</p>
    pub fn global(&self) -> bool {
        self.global
    }
    /// <p>An array of strings, one for each major email provider that the inbox placement data
    /// applies to.</p>
    pub fn tracked_isps(&self) -> std::option::Option<&[std::string::String]> {
        self.tracked_isps.as_deref()
    }
}
impl std::fmt::Debug for InboxPlacementTrackingOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InboxPlacementTrackingOption");
        formatter.field("global", &self.global);
        formatter.field("tracked_isps", &self.tracked_isps);
        formatter.finish()
    }
}
/// See [`InboxPlacementTrackingOption`](crate::model::InboxPlacementTrackingOption)
pub mod inbox_placement_tracking_option {
    /// A builder for [`InboxPlacementTrackingOption`](crate::model::InboxPlacementTrackingOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global: std::option::Option<bool>,
        pub(crate) tracked_isps: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies whether inbox placement data is being tracked for the domain.</p>
        pub fn global(mut self, input: bool) -> Self {
            self.global = Some(input);
            self
        }
        /// <p>Specifies whether inbox placement data is being tracked for the domain.</p>
        pub fn set_global(mut self, input: std::option::Option<bool>) -> Self {
            self.global = input;
            self
        }
        /// Appends an item to `tracked_isps`.
        ///
        /// To override the contents of this collection use [`set_tracked_isps`](Self::set_tracked_isps).
        ///
        /// <p>An array of strings, one for each major email provider that the inbox placement data
        /// applies to.</p>
        pub fn tracked_isps(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tracked_isps.unwrap_or_default();
            v.push(input.into());
            self.tracked_isps = Some(v);
            self
        }
        /// <p>An array of strings, one for each major email provider that the inbox placement data
        /// applies to.</p>
        pub fn set_tracked_isps(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tracked_isps = input;
            self
        }
        /// Consumes the builder and constructs a [`InboxPlacementTrackingOption`](crate::model::InboxPlacementTrackingOption)
        pub fn build(self) -> crate::model::InboxPlacementTrackingOption {
            crate::model::InboxPlacementTrackingOption {
                global: self.global.unwrap_or_default(),
                tracked_isps: self.tracked_isps,
            }
        }
    }
}
impl InboxPlacementTrackingOption {
    /// Creates a new builder-style object to manufacture [`InboxPlacementTrackingOption`](crate::model::InboxPlacementTrackingOption)
    pub fn builder() -> crate::model::inbox_placement_tracking_option::Builder {
        crate::model::inbox_placement_tracking_option::Builder::default()
    }
}

/// <p>Specifies whether messages that use the configuration set are required to use
/// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
/// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
/// messages can be delivered in plain text if a TLS connection can't be established.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TlsPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Require,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TlsPolicy {
    fn from(s: &str) -> Self {
        match s {
            "OPTIONAL" => TlsPolicy::Optional,
            "REQUIRE" => TlsPolicy::Require,
            other => TlsPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TlsPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TlsPolicy::from(s))
    }
}
impl TlsPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TlsPolicy::Optional => "OPTIONAL",
            TlsPolicy::Require => "REQUIRE",
            TlsPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OPTIONAL", "REQUIRE"]
    }
}
impl AsRef<str> for TlsPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactLanguage {
    #[allow(missing_docs)] // documentation missing in model
    En,
    #[allow(missing_docs)] // documentation missing in model
    Ja,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactLanguage {
    fn from(s: &str) -> Self {
        match s {
            "EN" => ContactLanguage::En,
            "JA" => ContactLanguage::Ja,
            other => ContactLanguage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactLanguage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactLanguage::from(s))
    }
}
impl ContactLanguage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactLanguage::En => "EN",
            ContactLanguage::Ja => "JA",
            ContactLanguage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EN", "JA"]
    }
}
impl AsRef<str> for ContactLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MailType {
    #[allow(missing_docs)] // documentation missing in model
    Marketing,
    #[allow(missing_docs)] // documentation missing in model
    Transactional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MailType {
    fn from(s: &str) -> Self {
        match s {
            "MARKETING" => MailType::Marketing,
            "TRANSACTIONAL" => MailType::Transactional,
            other => MailType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MailType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MailType::from(s))
    }
}
impl MailType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MailType::Marketing => "MARKETING",
            MailType::Transactional => "TRANSACTIONAL",
            MailType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MARKETING", "TRANSACTIONAL"]
    }
}
impl AsRef<str> for MailType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary that describes the suppressed email address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressedDestinationSummary {
    /// <p>The email address that's on the suppression list for your account.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The reason that the address was added to the suppression list for your account.</p>
    pub reason: std::option::Option<crate::model::SuppressionListReason>,
    /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
    /// format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SuppressedDestinationSummary {
    /// <p>The email address that's on the suppression list for your account.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The reason that the address was added to the suppression list for your account.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::SuppressionListReason> {
        self.reason.as_ref()
    }
    /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
    /// format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for SuppressedDestinationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressedDestinationSummary");
        formatter.field("email_address", &self.email_address);
        formatter.field("reason", &self.reason);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`SuppressedDestinationSummary`](crate::model::SuppressedDestinationSummary)
pub mod suppressed_destination_summary {
    /// A builder for [`SuppressedDestinationSummary`](crate::model::SuppressedDestinationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::SuppressionListReason>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The email address that's on the suppression list for your account.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that's on the suppression list for your account.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The reason that the address was added to the suppression list for your account.</p>
        pub fn reason(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason that the address was added to the suppression list for your account.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SuppressionListReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
        /// format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
        /// format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressedDestinationSummary`](crate::model::SuppressedDestinationSummary)
        pub fn build(self) -> crate::model::SuppressedDestinationSummary {
            crate::model::SuppressedDestinationSummary {
                email_address: self.email_address,
                reason: self.reason,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl SuppressedDestinationSummary {
    /// Creates a new builder-style object to manufacture [`SuppressedDestinationSummary`](crate::model::SuppressedDestinationSummary)
    pub fn builder() -> crate::model::suppressed_destination_summary::Builder {
        crate::model::suppressed_destination_summary::Builder::default()
    }
}

/// <p>A summary of the import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportJobSummary {
    /// <p>A string that represents the import job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>An object that contains details about the resource destination the import job is going
    /// to target.</p>
    pub import_destination: std::option::Option<crate::model::ImportDestination>,
    /// <p>The status of the import job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The date and time when the import job was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ImportJobSummary {
    /// <p>A string that represents the import job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>An object that contains details about the resource destination the import job is going
    /// to target.</p>
    pub fn import_destination(&self) -> std::option::Option<&crate::model::ImportDestination> {
        self.import_destination.as_ref()
    }
    /// <p>The status of the import job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>The date and time when the import job was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ImportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportJobSummary");
        formatter.field("job_id", &self.job_id);
        formatter.field("import_destination", &self.import_destination);
        formatter.field("job_status", &self.job_status);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`ImportJobSummary`](crate::model::ImportJobSummary)
pub mod import_job_summary {
    /// A builder for [`ImportJobSummary`](crate::model::ImportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) import_destination: std::option::Option<crate::model::ImportDestination>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A string that represents the import job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A string that represents the import job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>An object that contains details about the resource destination the import job is going
        /// to target.</p>
        pub fn import_destination(mut self, input: crate::model::ImportDestination) -> Self {
            self.import_destination = Some(input);
            self
        }
        /// <p>An object that contains details about the resource destination the import job is going
        /// to target.</p>
        pub fn set_import_destination(
            mut self,
            input: std::option::Option<crate::model::ImportDestination>,
        ) -> Self {
            self.import_destination = input;
            self
        }
        /// <p>The status of the import job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the import job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The date and time when the import job was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date and time when the import job was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportJobSummary`](crate::model::ImportJobSummary)
        pub fn build(self) -> crate::model::ImportJobSummary {
            crate::model::ImportJobSummary {
                job_id: self.job_id,
                import_destination: self.import_destination,
                job_status: self.job_status,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl ImportJobSummary {
    /// Creates a new builder-style object to manufacture [`ImportJobSummary`](crate::model::ImportJobSummary)
    pub fn builder() -> crate::model::import_job_summary::Builder {
        crate::model::import_job_summary::Builder::default()
    }
}

/// <p>The status of the import job.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "CREATED" => JobStatus::Created,
            "FAILED" => JobStatus::Failed,
            "PROCESSING" => JobStatus::Processing,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::Created => "CREATED",
            JobStatus::Failed => "FAILED",
            JobStatus::Processing => "PROCESSING",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "CREATED", "FAILED", "PROCESSING"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains details about the resource destination the import job is going
/// to target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportDestination {
    /// <p>An object that contains the action of the import job towards suppression list.</p>
    pub suppression_list_destination: std::option::Option<crate::model::SuppressionListDestination>,
    /// <p>An object that contains the action of the import job towards a contact list.</p>
    pub contact_list_destination: std::option::Option<crate::model::ContactListDestination>,
}
impl ImportDestination {
    /// <p>An object that contains the action of the import job towards suppression list.</p>
    pub fn suppression_list_destination(
        &self,
    ) -> std::option::Option<&crate::model::SuppressionListDestination> {
        self.suppression_list_destination.as_ref()
    }
    /// <p>An object that contains the action of the import job towards a contact list.</p>
    pub fn contact_list_destination(
        &self,
    ) -> std::option::Option<&crate::model::ContactListDestination> {
        self.contact_list_destination.as_ref()
    }
}
impl std::fmt::Debug for ImportDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportDestination");
        formatter.field(
            "suppression_list_destination",
            &self.suppression_list_destination,
        );
        formatter.field("contact_list_destination", &self.contact_list_destination);
        formatter.finish()
    }
}
/// See [`ImportDestination`](crate::model::ImportDestination)
pub mod import_destination {
    /// A builder for [`ImportDestination`](crate::model::ImportDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppression_list_destination:
            std::option::Option<crate::model::SuppressionListDestination>,
        pub(crate) contact_list_destination:
            std::option::Option<crate::model::ContactListDestination>,
    }
    impl Builder {
        /// <p>An object that contains the action of the import job towards suppression list.</p>
        pub fn suppression_list_destination(
            mut self,
            input: crate::model::SuppressionListDestination,
        ) -> Self {
            self.suppression_list_destination = Some(input);
            self
        }
        /// <p>An object that contains the action of the import job towards suppression list.</p>
        pub fn set_suppression_list_destination(
            mut self,
            input: std::option::Option<crate::model::SuppressionListDestination>,
        ) -> Self {
            self.suppression_list_destination = input;
            self
        }
        /// <p>An object that contains the action of the import job towards a contact list.</p>
        pub fn contact_list_destination(
            mut self,
            input: crate::model::ContactListDestination,
        ) -> Self {
            self.contact_list_destination = Some(input);
            self
        }
        /// <p>An object that contains the action of the import job towards a contact list.</p>
        pub fn set_contact_list_destination(
            mut self,
            input: std::option::Option<crate::model::ContactListDestination>,
        ) -> Self {
            self.contact_list_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDestination`](crate::model::ImportDestination)
        pub fn build(self) -> crate::model::ImportDestination {
            crate::model::ImportDestination {
                suppression_list_destination: self.suppression_list_destination,
                contact_list_destination: self.contact_list_destination,
            }
        }
    }
}
impl ImportDestination {
    /// Creates a new builder-style object to manufacture [`ImportDestination`](crate::model::ImportDestination)
    pub fn builder() -> crate::model::import_destination::Builder {
        crate::model::import_destination::Builder::default()
    }
}

/// <p>An object that contains details about the action of a contact list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactListDestination {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>>The type of action to perform on the addresses. The following are the
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>PUT: add the addresses to the contact list. If the record already exists, it
    /// will override it with the new value.</p>
    /// </li>
    /// <li>
    /// <p>DELETE: remove the addresses from the contact list.</p>
    /// </li>
    /// </ul>
    pub contact_list_import_action: std::option::Option<crate::model::ContactListImportAction>,
}
impl ContactListDestination {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>>The type of action to perform on the addresses. The following are the
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>PUT: add the addresses to the contact list. If the record already exists, it
    /// will override it with the new value.</p>
    /// </li>
    /// <li>
    /// <p>DELETE: remove the addresses from the contact list.</p>
    /// </li>
    /// </ul>
    pub fn contact_list_import_action(
        &self,
    ) -> std::option::Option<&crate::model::ContactListImportAction> {
        self.contact_list_import_action.as_ref()
    }
}
impl std::fmt::Debug for ContactListDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactListDestination");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field(
            "contact_list_import_action",
            &self.contact_list_import_action,
        );
        formatter.finish()
    }
}
/// See [`ContactListDestination`](crate::model::ContactListDestination)
pub mod contact_list_destination {
    /// A builder for [`ContactListDestination`](crate::model::ContactListDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) contact_list_import_action:
            std::option::Option<crate::model::ContactListImportAction>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>>The type of action to perform on the addresses. The following are the
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>PUT: add the addresses to the contact list. If the record already exists, it
        /// will override it with the new value.</p>
        /// </li>
        /// <li>
        /// <p>DELETE: remove the addresses from the contact list.</p>
        /// </li>
        /// </ul>
        pub fn contact_list_import_action(
            mut self,
            input: crate::model::ContactListImportAction,
        ) -> Self {
            self.contact_list_import_action = Some(input);
            self
        }
        /// <p>>The type of action to perform on the addresses. The following are the
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>PUT: add the addresses to the contact list. If the record already exists, it
        /// will override it with the new value.</p>
        /// </li>
        /// <li>
        /// <p>DELETE: remove the addresses from the contact list.</p>
        /// </li>
        /// </ul>
        pub fn set_contact_list_import_action(
            mut self,
            input: std::option::Option<crate::model::ContactListImportAction>,
        ) -> Self {
            self.contact_list_import_action = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactListDestination`](crate::model::ContactListDestination)
        pub fn build(self) -> crate::model::ContactListDestination {
            crate::model::ContactListDestination {
                contact_list_name: self.contact_list_name,
                contact_list_import_action: self.contact_list_import_action,
            }
        }
    }
}
impl ContactListDestination {
    /// Creates a new builder-style object to manufacture [`ContactListDestination`](crate::model::ContactListDestination)
    pub fn builder() -> crate::model::contact_list_destination::Builder {
        crate::model::contact_list_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactListImportAction {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactListImportAction {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => ContactListImportAction::Delete,
            "PUT" => ContactListImportAction::Put,
            other => ContactListImportAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactListImportAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactListImportAction::from(s))
    }
}
impl ContactListImportAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactListImportAction::Delete => "DELETE",
            ContactListImportAction::Put => "PUT",
            ContactListImportAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "PUT"]
    }
}
impl AsRef<str> for ContactListImportAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains details about the action of suppression list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressionListDestination {
    /// <p>The type of action to perform on the address. The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>PUT: add the addresses to the suppression list. If the record already exists,
    /// it will override it with the new value.</p>
    /// </li>
    /// <li>
    /// <p>DELETE: remove the addresses from the suppression list.</p>
    /// </li>
    /// </ul>
    pub suppression_list_import_action:
        std::option::Option<crate::model::SuppressionListImportAction>,
}
impl SuppressionListDestination {
    /// <p>The type of action to perform on the address. The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>PUT: add the addresses to the suppression list. If the record already exists,
    /// it will override it with the new value.</p>
    /// </li>
    /// <li>
    /// <p>DELETE: remove the addresses from the suppression list.</p>
    /// </li>
    /// </ul>
    pub fn suppression_list_import_action(
        &self,
    ) -> std::option::Option<&crate::model::SuppressionListImportAction> {
        self.suppression_list_import_action.as_ref()
    }
}
impl std::fmt::Debug for SuppressionListDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressionListDestination");
        formatter.field(
            "suppression_list_import_action",
            &self.suppression_list_import_action,
        );
        formatter.finish()
    }
}
/// See [`SuppressionListDestination`](crate::model::SuppressionListDestination)
pub mod suppression_list_destination {
    /// A builder for [`SuppressionListDestination`](crate::model::SuppressionListDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppression_list_import_action:
            std::option::Option<crate::model::SuppressionListImportAction>,
    }
    impl Builder {
        /// <p>The type of action to perform on the address. The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>PUT: add the addresses to the suppression list. If the record already exists,
        /// it will override it with the new value.</p>
        /// </li>
        /// <li>
        /// <p>DELETE: remove the addresses from the suppression list.</p>
        /// </li>
        /// </ul>
        pub fn suppression_list_import_action(
            mut self,
            input: crate::model::SuppressionListImportAction,
        ) -> Self {
            self.suppression_list_import_action = Some(input);
            self
        }
        /// <p>The type of action to perform on the address. The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>PUT: add the addresses to the suppression list. If the record already exists,
        /// it will override it with the new value.</p>
        /// </li>
        /// <li>
        /// <p>DELETE: remove the addresses from the suppression list.</p>
        /// </li>
        /// </ul>
        pub fn set_suppression_list_import_action(
            mut self,
            input: std::option::Option<crate::model::SuppressionListImportAction>,
        ) -> Self {
            self.suppression_list_import_action = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressionListDestination`](crate::model::SuppressionListDestination)
        pub fn build(self) -> crate::model::SuppressionListDestination {
            crate::model::SuppressionListDestination {
                suppression_list_import_action: self.suppression_list_import_action,
            }
        }
    }
}
impl SuppressionListDestination {
    /// Creates a new builder-style object to manufacture [`SuppressionListDestination`](crate::model::SuppressionListDestination)
    pub fn builder() -> crate::model::suppression_list_destination::Builder {
        crate::model::suppression_list_destination::Builder::default()
    }
}

/// <p>The type of action to perform on the address. The following are possible values:</p>
/// <ul>
/// <li>
/// <p>PUT: add the addresses to the suppression list.</p>
/// </li>
/// <li>
/// <p>DELETE: remove the address from the suppression list.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SuppressionListImportAction {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SuppressionListImportAction {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => SuppressionListImportAction::Delete,
            "PUT" => SuppressionListImportAction::Put,
            other => SuppressionListImportAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SuppressionListImportAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SuppressionListImportAction::from(s))
    }
}
impl SuppressionListImportAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SuppressionListImportAction::Delete => "DELETE",
            SuppressionListImportAction::Put => "PUT",
            SuppressionListImportAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "PUT"]
    }
}
impl AsRef<str> for SuppressionListImportAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The destination of the import job, which can be used to list import jobs that have a
/// certain <code>ImportDestinationType</code>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportDestinationType {
    #[allow(missing_docs)] // documentation missing in model
    ContactList,
    #[allow(missing_docs)] // documentation missing in model
    SuppressionList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportDestinationType {
    fn from(s: &str) -> Self {
        match s {
            "CONTACT_LIST" => ImportDestinationType::ContactList,
            "SUPPRESSION_LIST" => ImportDestinationType::SuppressionList,
            other => ImportDestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportDestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportDestinationType::from(s))
    }
}
impl ImportDestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportDestinationType::ContactList => "CONTACT_LIST",
            ImportDestinationType::SuppressionList => "SUPPRESSION_LIST",
            ImportDestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTACT_LIST", "SUPPRESSION_LIST"]
    }
}
impl AsRef<str> for ImportDestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmailTemplateMetadata {
    /// <p>The name of the template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The time and date the template was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl EmailTemplateMetadata {
    /// <p>The name of the template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The time and date the template was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for EmailTemplateMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmailTemplateMetadata");
        formatter.field("template_name", &self.template_name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`EmailTemplateMetadata`](crate::model::EmailTemplateMetadata)
pub mod email_template_metadata {
    /// A builder for [`EmailTemplateMetadata`](crate::model::EmailTemplateMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The time and date the template was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time and date the template was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`EmailTemplateMetadata`](crate::model::EmailTemplateMetadata)
        pub fn build(self) -> crate::model::EmailTemplateMetadata {
            crate::model::EmailTemplateMetadata {
                template_name: self.template_name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl EmailTemplateMetadata {
    /// Creates a new builder-style object to manufacture [`EmailTemplateMetadata`](crate::model::EmailTemplateMetadata)
    pub fn builder() -> crate::model::email_template_metadata::Builder {
        crate::model::email_template_metadata::Builder::default()
    }
}

/// <p>Information about an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityInfo {
    /// <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported
    /// for email identity types.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The address or domain of the identity.</p>
    pub identity_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether or not you can send email from the identity.</p>
    /// <p>An <i>identity</i> is an email address or domain that you send email
    /// from. Before you can send email from an identity, you have to demostrate that you own
    /// the identity, and that you authorize Amazon SES to send email from that identity.</p>
    pub sending_enabled: bool,
}
impl IdentityInfo {
    /// <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported
    /// for email identity types.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The address or domain of the identity.</p>
    pub fn identity_name(&self) -> std::option::Option<&str> {
        self.identity_name.as_deref()
    }
    /// <p>Indicates whether or not you can send email from the identity.</p>
    /// <p>An <i>identity</i> is an email address or domain that you send email
    /// from. Before you can send email from an identity, you have to demostrate that you own
    /// the identity, and that you authorize Amazon SES to send email from that identity.</p>
    pub fn sending_enabled(&self) -> bool {
        self.sending_enabled
    }
}
impl std::fmt::Debug for IdentityInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityInfo");
        formatter.field("identity_type", &self.identity_type);
        formatter.field("identity_name", &self.identity_name);
        formatter.field("sending_enabled", &self.sending_enabled);
        formatter.finish()
    }
}
/// See [`IdentityInfo`](crate::model::IdentityInfo)
pub mod identity_info {
    /// A builder for [`IdentityInfo`](crate::model::IdentityInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) identity_name: std::option::Option<std::string::String>,
        pub(crate) sending_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported
        /// for email identity types.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>The email identity type. Note: the <code>MANAGED_DOMAIN</code> type is not supported
        /// for email identity types.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The address or domain of the identity.</p>
        pub fn identity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_name = Some(input.into());
            self
        }
        /// <p>The address or domain of the identity.</p>
        pub fn set_identity_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_name = input;
            self
        }
        /// <p>Indicates whether or not you can send email from the identity.</p>
        /// <p>An <i>identity</i> is an email address or domain that you send email
        /// from. Before you can send email from an identity, you have to demostrate that you own
        /// the identity, and that you authorize Amazon SES to send email from that identity.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.sending_enabled = Some(input);
            self
        }
        /// <p>Indicates whether or not you can send email from the identity.</p>
        /// <p>An <i>identity</i> is an email address or domain that you send email
        /// from. Before you can send email from an identity, you have to demostrate that you own
        /// the identity, and that you authorize Amazon SES to send email from that identity.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sending_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityInfo`](crate::model::IdentityInfo)
        pub fn build(self) -> crate::model::IdentityInfo {
            crate::model::IdentityInfo {
                identity_type: self.identity_type,
                identity_name: self.identity_name,
                sending_enabled: self.sending_enabled.unwrap_or_default(),
            }
        }
    }
}
impl IdentityInfo {
    /// Creates a new builder-style object to manufacture [`IdentityInfo`](crate::model::IdentityInfo)
    pub fn builder() -> crate::model::identity_info::Builder {
        crate::model::identity_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    EmailAddress,
    #[allow(missing_docs)] // documentation missing in model
    ManagedDomain,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityType {
    fn from(s: &str) -> Self {
        match s {
            "DOMAIN" => IdentityType::Domain,
            "EMAIL_ADDRESS" => IdentityType::EmailAddress,
            "MANAGED_DOMAIN" => IdentityType::ManagedDomain,
            other => IdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityType::from(s))
    }
}
impl IdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityType::Domain => "DOMAIN",
            IdentityType::EmailAddress => "EMAIL_ADDRESS",
            IdentityType::ManagedDomain => "MANAGED_DOMAIN",
            IdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOMAIN", "EMAIL_ADDRESS", "MANAGED_DOMAIN"]
    }
}
impl AsRef<str> for IdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains the deliverability data for a specific campaign. This data is
/// available for a campaign only if the campaign sent email by using a domain that the
/// Deliverability dashboard is enabled for (<code>PutDeliverabilityDashboardOption</code>
/// operation).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDeliverabilityCampaign {
    /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
    /// and assigns this identifier to a campaign.</p>
    pub campaign_id: std::option::Option<std::string::String>,
    /// <p>The URL of an image that contains a snapshot of the email message that was
    /// sent.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The subject line, or title, of the email message.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The verified email address that the email message was sent from.</p>
    pub from_address: std::option::Option<std::string::String>,
    /// <p>The IP addresses that were used to send the email message.</p>
    pub sending_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The first time, in Unix time format, when the email message was delivered to any
    /// recipient's inbox. This value can help you determine how long it took for a campaign to
    /// deliver an email message.</p>
    pub first_seen_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time, in Unix time format, when the email message was delivered to any
    /// recipient's inbox. This value can help you determine how long it took for a campaign to
    /// deliver an email message.</p>
    pub last_seen_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of email messages that were delivered to recipients’ inboxes.</p>
    pub inbox_count: std::option::Option<i64>,
    /// <p>The number of email messages that were delivered to recipients' spam or junk mail
    /// folders.</p>
    pub spam_count: std::option::Option<i64>,
    /// <p>The percentage of email messages that were opened by recipients. Due to technical
    /// limitations, this value only includes recipients who opened the message by using an
    /// email client that supports images.</p>
    pub read_rate: std::option::Option<f64>,
    /// <p>The percentage of email messages that were deleted by recipients, without being opened
    /// first. Due to technical limitations, this value only includes recipients who opened the
    /// message by using an email client that supports images.</p>
    pub delete_rate: std::option::Option<f64>,
    /// <p>The percentage of email messages that were opened and then deleted by recipients. Due
    /// to technical limitations, this value only includes recipients who opened the message by
    /// using an email client that supports images.</p>
    pub read_delete_rate: std::option::Option<f64>,
    /// <p>The projected number of recipients that the email message was sent to.</p>
    pub projected_volume: std::option::Option<i64>,
    /// <p>The major email providers who handled the email message.</p>
    pub esps: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DomainDeliverabilityCampaign {
    /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
    /// and assigns this identifier to a campaign.</p>
    pub fn campaign_id(&self) -> std::option::Option<&str> {
        self.campaign_id.as_deref()
    }
    /// <p>The URL of an image that contains a snapshot of the email message that was
    /// sent.</p>
    pub fn image_url(&self) -> std::option::Option<&str> {
        self.image_url.as_deref()
    }
    /// <p>The subject line, or title, of the email message.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The verified email address that the email message was sent from.</p>
    pub fn from_address(&self) -> std::option::Option<&str> {
        self.from_address.as_deref()
    }
    /// <p>The IP addresses that were used to send the email message.</p>
    pub fn sending_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.sending_ips.as_deref()
    }
    /// <p>The first time, in Unix time format, when the email message was delivered to any
    /// recipient's inbox. This value can help you determine how long it took for a campaign to
    /// deliver an email message.</p>
    pub fn first_seen_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_seen_date_time.as_ref()
    }
    /// <p>The last time, in Unix time format, when the email message was delivered to any
    /// recipient's inbox. This value can help you determine how long it took for a campaign to
    /// deliver an email message.</p>
    pub fn last_seen_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_seen_date_time.as_ref()
    }
    /// <p>The number of email messages that were delivered to recipients’ inboxes.</p>
    pub fn inbox_count(&self) -> std::option::Option<i64> {
        self.inbox_count
    }
    /// <p>The number of email messages that were delivered to recipients' spam or junk mail
    /// folders.</p>
    pub fn spam_count(&self) -> std::option::Option<i64> {
        self.spam_count
    }
    /// <p>The percentage of email messages that were opened by recipients. Due to technical
    /// limitations, this value only includes recipients who opened the message by using an
    /// email client that supports images.</p>
    pub fn read_rate(&self) -> std::option::Option<f64> {
        self.read_rate
    }
    /// <p>The percentage of email messages that were deleted by recipients, without being opened
    /// first. Due to technical limitations, this value only includes recipients who opened the
    /// message by using an email client that supports images.</p>
    pub fn delete_rate(&self) -> std::option::Option<f64> {
        self.delete_rate
    }
    /// <p>The percentage of email messages that were opened and then deleted by recipients. Due
    /// to technical limitations, this value only includes recipients who opened the message by
    /// using an email client that supports images.</p>
    pub fn read_delete_rate(&self) -> std::option::Option<f64> {
        self.read_delete_rate
    }
    /// <p>The projected number of recipients that the email message was sent to.</p>
    pub fn projected_volume(&self) -> std::option::Option<i64> {
        self.projected_volume
    }
    /// <p>The major email providers who handled the email message.</p>
    pub fn esps(&self) -> std::option::Option<&[std::string::String]> {
        self.esps.as_deref()
    }
}
impl std::fmt::Debug for DomainDeliverabilityCampaign {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDeliverabilityCampaign");
        formatter.field("campaign_id", &self.campaign_id);
        formatter.field("image_url", &self.image_url);
        formatter.field("subject", &self.subject);
        formatter.field("from_address", &self.from_address);
        formatter.field("sending_ips", &self.sending_ips);
        formatter.field("first_seen_date_time", &self.first_seen_date_time);
        formatter.field("last_seen_date_time", &self.last_seen_date_time);
        formatter.field("inbox_count", &self.inbox_count);
        formatter.field("spam_count", &self.spam_count);
        formatter.field("read_rate", &self.read_rate);
        formatter.field("delete_rate", &self.delete_rate);
        formatter.field("read_delete_rate", &self.read_delete_rate);
        formatter.field("projected_volume", &self.projected_volume);
        formatter.field("esps", &self.esps);
        formatter.finish()
    }
}
/// See [`DomainDeliverabilityCampaign`](crate::model::DomainDeliverabilityCampaign)
pub mod domain_deliverability_campaign {
    /// A builder for [`DomainDeliverabilityCampaign`](crate::model::DomainDeliverabilityCampaign)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) from_address: std::option::Option<std::string::String>,
        pub(crate) sending_ips: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) first_seen_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_seen_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) inbox_count: std::option::Option<i64>,
        pub(crate) spam_count: std::option::Option<i64>,
        pub(crate) read_rate: std::option::Option<f64>,
        pub(crate) delete_rate: std::option::Option<f64>,
        pub(crate) read_delete_rate: std::option::Option<f64>,
        pub(crate) projected_volume: std::option::Option<i64>,
        pub(crate) esps: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
        /// and assigns this identifier to a campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
        /// and assigns this identifier to a campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>The URL of an image that contains a snapshot of the email message that was
        /// sent.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image that contains a snapshot of the email message that was
        /// sent.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// <p>The subject line, or title, of the email message.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line, or title, of the email message.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The verified email address that the email message was sent from.</p>
        pub fn from_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_address = Some(input.into());
            self
        }
        /// <p>The verified email address that the email message was sent from.</p>
        pub fn set_from_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_address = input;
            self
        }
        /// Appends an item to `sending_ips`.
        ///
        /// To override the contents of this collection use [`set_sending_ips`](Self::set_sending_ips).
        ///
        /// <p>The IP addresses that were used to send the email message.</p>
        pub fn sending_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sending_ips.unwrap_or_default();
            v.push(input.into());
            self.sending_ips = Some(v);
            self
        }
        /// <p>The IP addresses that were used to send the email message.</p>
        pub fn set_sending_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sending_ips = input;
            self
        }
        /// <p>The first time, in Unix time format, when the email message was delivered to any
        /// recipient's inbox. This value can help you determine how long it took for a campaign to
        /// deliver an email message.</p>
        pub fn first_seen_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_seen_date_time = Some(input);
            self
        }
        /// <p>The first time, in Unix time format, when the email message was delivered to any
        /// recipient's inbox. This value can help you determine how long it took for a campaign to
        /// deliver an email message.</p>
        pub fn set_first_seen_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_seen_date_time = input;
            self
        }
        /// <p>The last time, in Unix time format, when the email message was delivered to any
        /// recipient's inbox. This value can help you determine how long it took for a campaign to
        /// deliver an email message.</p>
        pub fn last_seen_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_seen_date_time = Some(input);
            self
        }
        /// <p>The last time, in Unix time format, when the email message was delivered to any
        /// recipient's inbox. This value can help you determine how long it took for a campaign to
        /// deliver an email message.</p>
        pub fn set_last_seen_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_seen_date_time = input;
            self
        }
        /// <p>The number of email messages that were delivered to recipients’ inboxes.</p>
        pub fn inbox_count(mut self, input: i64) -> Self {
            self.inbox_count = Some(input);
            self
        }
        /// <p>The number of email messages that were delivered to recipients’ inboxes.</p>
        pub fn set_inbox_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inbox_count = input;
            self
        }
        /// <p>The number of email messages that were delivered to recipients' spam or junk mail
        /// folders.</p>
        pub fn spam_count(mut self, input: i64) -> Self {
            self.spam_count = Some(input);
            self
        }
        /// <p>The number of email messages that were delivered to recipients' spam or junk mail
        /// folders.</p>
        pub fn set_spam_count(mut self, input: std::option::Option<i64>) -> Self {
            self.spam_count = input;
            self
        }
        /// <p>The percentage of email messages that were opened by recipients. Due to technical
        /// limitations, this value only includes recipients who opened the message by using an
        /// email client that supports images.</p>
        pub fn read_rate(mut self, input: f64) -> Self {
            self.read_rate = Some(input);
            self
        }
        /// <p>The percentage of email messages that were opened by recipients. Due to technical
        /// limitations, this value only includes recipients who opened the message by using an
        /// email client that supports images.</p>
        pub fn set_read_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.read_rate = input;
            self
        }
        /// <p>The percentage of email messages that were deleted by recipients, without being opened
        /// first. Due to technical limitations, this value only includes recipients who opened the
        /// message by using an email client that supports images.</p>
        pub fn delete_rate(mut self, input: f64) -> Self {
            self.delete_rate = Some(input);
            self
        }
        /// <p>The percentage of email messages that were deleted by recipients, without being opened
        /// first. Due to technical limitations, this value only includes recipients who opened the
        /// message by using an email client that supports images.</p>
        pub fn set_delete_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.delete_rate = input;
            self
        }
        /// <p>The percentage of email messages that were opened and then deleted by recipients. Due
        /// to technical limitations, this value only includes recipients who opened the message by
        /// using an email client that supports images.</p>
        pub fn read_delete_rate(mut self, input: f64) -> Self {
            self.read_delete_rate = Some(input);
            self
        }
        /// <p>The percentage of email messages that were opened and then deleted by recipients. Due
        /// to technical limitations, this value only includes recipients who opened the message by
        /// using an email client that supports images.</p>
        pub fn set_read_delete_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.read_delete_rate = input;
            self
        }
        /// <p>The projected number of recipients that the email message was sent to.</p>
        pub fn projected_volume(mut self, input: i64) -> Self {
            self.projected_volume = Some(input);
            self
        }
        /// <p>The projected number of recipients that the email message was sent to.</p>
        pub fn set_projected_volume(mut self, input: std::option::Option<i64>) -> Self {
            self.projected_volume = input;
            self
        }
        /// Appends an item to `esps`.
        ///
        /// To override the contents of this collection use [`set_esps`](Self::set_esps).
        ///
        /// <p>The major email providers who handled the email message.</p>
        pub fn esps(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.esps.unwrap_or_default();
            v.push(input.into());
            self.esps = Some(v);
            self
        }
        /// <p>The major email providers who handled the email message.</p>
        pub fn set_esps(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.esps = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDeliverabilityCampaign`](crate::model::DomainDeliverabilityCampaign)
        pub fn build(self) -> crate::model::DomainDeliverabilityCampaign {
            crate::model::DomainDeliverabilityCampaign {
                campaign_id: self.campaign_id,
                image_url: self.image_url,
                subject: self.subject,
                from_address: self.from_address,
                sending_ips: self.sending_ips,
                first_seen_date_time: self.first_seen_date_time,
                last_seen_date_time: self.last_seen_date_time,
                inbox_count: self.inbox_count,
                spam_count: self.spam_count,
                read_rate: self.read_rate,
                delete_rate: self.delete_rate,
                read_delete_rate: self.read_delete_rate,
                projected_volume: self.projected_volume,
                esps: self.esps,
            }
        }
    }
}
impl DomainDeliverabilityCampaign {
    /// Creates a new builder-style object to manufacture [`DomainDeliverabilityCampaign`](crate::model::DomainDeliverabilityCampaign)
    pub fn builder() -> crate::model::domain_deliverability_campaign::Builder {
        crate::model::domain_deliverability_campaign::Builder::default()
    }
}

/// <p>An object that contains metadata related to a predictive inbox placement test.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliverabilityTestReport {
    /// <p>A unique string that identifies the predictive inbox placement test.</p>
    pub report_id: std::option::Option<std::string::String>,
    /// <p>A name that helps you identify a predictive inbox placement test report.</p>
    pub report_name: std::option::Option<std::string::String>,
    /// <p>The subject line for an email that you submitted in a predictive inbox placement test.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The sender address that you specified for the predictive inbox placement test.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The date and time when the predictive inbox placement test was created, in Unix time format.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test
    /// is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the
    /// test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use
    /// the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
    pub deliverability_test_status: std::option::Option<crate::model::DeliverabilityTestStatus>,
}
impl DeliverabilityTestReport {
    /// <p>A unique string that identifies the predictive inbox placement test.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
    /// <p>A name that helps you identify a predictive inbox placement test report.</p>
    pub fn report_name(&self) -> std::option::Option<&str> {
        self.report_name.as_deref()
    }
    /// <p>The subject line for an email that you submitted in a predictive inbox placement test.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The sender address that you specified for the predictive inbox placement test.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The date and time when the predictive inbox placement test was created, in Unix time format.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test
    /// is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the
    /// test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use
    /// the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
    pub fn deliverability_test_status(
        &self,
    ) -> std::option::Option<&crate::model::DeliverabilityTestStatus> {
        self.deliverability_test_status.as_ref()
    }
}
impl std::fmt::Debug for DeliverabilityTestReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliverabilityTestReport");
        formatter.field("report_id", &self.report_id);
        formatter.field("report_name", &self.report_name);
        formatter.field("subject", &self.subject);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("create_date", &self.create_date);
        formatter.field(
            "deliverability_test_status",
            &self.deliverability_test_status,
        );
        formatter.finish()
    }
}
/// See [`DeliverabilityTestReport`](crate::model::DeliverabilityTestReport)
pub mod deliverability_test_report {
    /// A builder for [`DeliverabilityTestReport`](crate::model::DeliverabilityTestReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
        pub(crate) report_name: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deliverability_test_status:
            std::option::Option<crate::model::DeliverabilityTestStatus>,
    }
    impl Builder {
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// <p>A name that helps you identify a predictive inbox placement test report.</p>
        pub fn report_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_name = Some(input.into());
            self
        }
        /// <p>A name that helps you identify a predictive inbox placement test report.</p>
        pub fn set_report_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_name = input;
            self
        }
        /// <p>The subject line for an email that you submitted in a predictive inbox placement test.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject line for an email that you submitted in a predictive inbox placement test.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The sender address that you specified for the predictive inbox placement test.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The sender address that you specified for the predictive inbox placement test.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The date and time when the predictive inbox placement test was created, in Unix time format.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time when the predictive inbox placement test was created, in Unix time format.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test
        /// is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the
        /// test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use
        /// the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
        pub fn deliverability_test_status(
            mut self,
            input: crate::model::DeliverabilityTestStatus,
        ) -> Self {
            self.deliverability_test_status = Some(input);
            self
        }
        /// <p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test
        /// is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the
        /// test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use
        /// the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>
        pub fn set_deliverability_test_status(
            mut self,
            input: std::option::Option<crate::model::DeliverabilityTestStatus>,
        ) -> Self {
            self.deliverability_test_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliverabilityTestReport`](crate::model::DeliverabilityTestReport)
        pub fn build(self) -> crate::model::DeliverabilityTestReport {
            crate::model::DeliverabilityTestReport {
                report_id: self.report_id,
                report_name: self.report_name,
                subject: self.subject,
                from_email_address: self.from_email_address,
                create_date: self.create_date,
                deliverability_test_status: self.deliverability_test_status,
            }
        }
    }
}
impl DeliverabilityTestReport {
    /// Creates a new builder-style object to manufacture [`DeliverabilityTestReport`](crate::model::DeliverabilityTestReport)
    pub fn builder() -> crate::model::deliverability_test_report::Builder {
        crate::model::deliverability_test_report::Builder::default()
    }
}

/// <p>The status of a predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is
/// currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test.
/// If the status is <code>COMPLETE</code>, then the test is finished, and you can use the
/// <code>GetDeliverabilityTestReport</code> operation to view the results of the
/// test.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliverabilityTestStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliverabilityTestStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => DeliverabilityTestStatus::Completed,
            "IN_PROGRESS" => DeliverabilityTestStatus::InProgress,
            other => DeliverabilityTestStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliverabilityTestStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliverabilityTestStatus::from(s))
    }
}
impl DeliverabilityTestStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliverabilityTestStatus::Completed => "COMPLETED",
            DeliverabilityTestStatus::InProgress => "IN_PROGRESS",
            DeliverabilityTestStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for DeliverabilityTestStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomVerificationEmailTemplateMetadata {
    /// <p>The name of the custom verification email template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl CustomVerificationEmailTemplateMetadata {
    /// <p>The name of the custom verification email template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for CustomVerificationEmailTemplateMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomVerificationEmailTemplateMetadata");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}
/// See [`CustomVerificationEmailTemplateMetadata`](crate::model::CustomVerificationEmailTemplateMetadata)
pub mod custom_verification_email_template_metadata {
    /// A builder for [`CustomVerificationEmailTemplateMetadata`](crate::model::CustomVerificationEmailTemplateMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomVerificationEmailTemplateMetadata`](crate::model::CustomVerificationEmailTemplateMetadata)
        pub fn build(self) -> crate::model::CustomVerificationEmailTemplateMetadata {
            crate::model::CustomVerificationEmailTemplateMetadata {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            }
        }
    }
}
impl CustomVerificationEmailTemplateMetadata {
    /// Creates a new builder-style object to manufacture [`CustomVerificationEmailTemplateMetadata`](crate::model::CustomVerificationEmailTemplateMetadata)
    pub fn builder() -> crate::model::custom_verification_email_template_metadata::Builder {
        crate::model::custom_verification_email_template_metadata::Builder::default()
    }
}

/// <p>A contact is the end-user who is receiving the email.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Contact {
    /// <p>The contact's email address.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
    pub topic_preferences: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
    /// <p>The default topic preferences applied to the contact.</p>
    pub topic_default_preferences:
        std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
    /// topics.</p>
    pub unsubscribe_all: bool,
    /// <p>A timestamp noting the last time the contact's information was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl Contact {
    /// <p>The contact's email address.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
    pub fn topic_preferences(&self) -> std::option::Option<&[crate::model::TopicPreference]> {
        self.topic_preferences.as_deref()
    }
    /// <p>The default topic preferences applied to the contact.</p>
    pub fn topic_default_preferences(
        &self,
    ) -> std::option::Option<&[crate::model::TopicPreference]> {
        self.topic_default_preferences.as_deref()
    }
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
    /// topics.</p>
    pub fn unsubscribe_all(&self) -> bool {
        self.unsubscribe_all
    }
    /// <p>A timestamp noting the last time the contact's information was updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for Contact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Contact");
        formatter.field("email_address", &self.email_address);
        formatter.field("topic_preferences", &self.topic_preferences);
        formatter.field("topic_default_preferences", &self.topic_default_preferences);
        formatter.field("unsubscribe_all", &self.unsubscribe_all);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`Contact`](crate::model::Contact)
pub mod contact {
    /// A builder for [`Contact`](crate::model::Contact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) topic_preferences:
            std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        pub(crate) topic_default_preferences:
            std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        pub(crate) unsubscribe_all: std::option::Option<bool>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Appends an item to `topic_preferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn topic_preferences(
            mut self,
            input: impl Into<crate::model::TopicPreference>,
        ) -> Self {
            let mut v = self.topic_preferences.unwrap_or_default();
            v.push(input.into());
            self.topic_preferences = Some(v);
            self
        }
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.topic_preferences = input;
            self
        }
        /// Appends an item to `topic_default_preferences`.
        ///
        /// To override the contents of this collection use [`set_topic_default_preferences`](Self::set_topic_default_preferences).
        ///
        /// <p>The default topic preferences applied to the contact.</p>
        pub fn topic_default_preferences(
            mut self,
            input: impl Into<crate::model::TopicPreference>,
        ) -> Self {
            let mut v = self.topic_default_preferences.unwrap_or_default();
            v.push(input.into());
            self.topic_default_preferences = Some(v);
            self
        }
        /// <p>The default topic preferences applied to the contact.</p>
        pub fn set_topic_default_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.topic_default_preferences = input;
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn unsubscribe_all(mut self, input: bool) -> Self {
            self.unsubscribe_all = Some(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.unsubscribe_all = input;
            self
        }
        /// <p>A timestamp noting the last time the contact's information was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>A timestamp noting the last time the contact's information was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`Contact`](crate::model::Contact)
        pub fn build(self) -> crate::model::Contact {
            crate::model::Contact {
                email_address: self.email_address,
                topic_preferences: self.topic_preferences,
                topic_default_preferences: self.topic_default_preferences,
                unsubscribe_all: self.unsubscribe_all.unwrap_or_default(),
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl Contact {
    /// Creates a new builder-style object to manufacture [`Contact`](crate::model::Contact)
    pub fn builder() -> crate::model::contact::Builder {
        crate::model::contact::Builder::default()
    }
}

/// <p>A filter that can be applied to a list of contacts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsFilter {
    /// <p>The status by which you are filtering: <code>OPT_IN</code> or
    /// <code>OPT_OUT</code>.</p>
    pub filtered_status: std::option::Option<crate::model::SubscriptionStatus>,
    /// <p>Used for filtering by a specific topic preference.</p>
    pub topic_filter: std::option::Option<crate::model::TopicFilter>,
}
impl ListContactsFilter {
    /// <p>The status by which you are filtering: <code>OPT_IN</code> or
    /// <code>OPT_OUT</code>.</p>
    pub fn filtered_status(&self) -> std::option::Option<&crate::model::SubscriptionStatus> {
        self.filtered_status.as_ref()
    }
    /// <p>Used for filtering by a specific topic preference.</p>
    pub fn topic_filter(&self) -> std::option::Option<&crate::model::TopicFilter> {
        self.topic_filter.as_ref()
    }
}
impl std::fmt::Debug for ListContactsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsFilter");
        formatter.field("filtered_status", &self.filtered_status);
        formatter.field("topic_filter", &self.topic_filter);
        formatter.finish()
    }
}
/// See [`ListContactsFilter`](crate::model::ListContactsFilter)
pub mod list_contacts_filter {
    /// A builder for [`ListContactsFilter`](crate::model::ListContactsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filtered_status: std::option::Option<crate::model::SubscriptionStatus>,
        pub(crate) topic_filter: std::option::Option<crate::model::TopicFilter>,
    }
    impl Builder {
        /// <p>The status by which you are filtering: <code>OPT_IN</code> or
        /// <code>OPT_OUT</code>.</p>
        pub fn filtered_status(mut self, input: crate::model::SubscriptionStatus) -> Self {
            self.filtered_status = Some(input);
            self
        }
        /// <p>The status by which you are filtering: <code>OPT_IN</code> or
        /// <code>OPT_OUT</code>.</p>
        pub fn set_filtered_status(
            mut self,
            input: std::option::Option<crate::model::SubscriptionStatus>,
        ) -> Self {
            self.filtered_status = input;
            self
        }
        /// <p>Used for filtering by a specific topic preference.</p>
        pub fn topic_filter(mut self, input: crate::model::TopicFilter) -> Self {
            self.topic_filter = Some(input);
            self
        }
        /// <p>Used for filtering by a specific topic preference.</p>
        pub fn set_topic_filter(
            mut self,
            input: std::option::Option<crate::model::TopicFilter>,
        ) -> Self {
            self.topic_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsFilter`](crate::model::ListContactsFilter)
        pub fn build(self) -> crate::model::ListContactsFilter {
            crate::model::ListContactsFilter {
                filtered_status: self.filtered_status,
                topic_filter: self.topic_filter,
            }
        }
    }
}
impl ListContactsFilter {
    /// Creates a new builder-style object to manufacture [`ListContactsFilter`](crate::model::ListContactsFilter)
    pub fn builder() -> crate::model::list_contacts_filter::Builder {
        crate::model::list_contacts_filter::Builder::default()
    }
}

/// <p>Used for filtering by a specific topic preference.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicFilter {
    /// <p>The name of a topic on which you wish to apply the filter.</p>
    pub topic_name: std::option::Option<std::string::String>,
    /// <p>Notes that the default subscription status should be applied to a contact because the
    /// contact has not noted their preference for subscribing to a topic.</p>
    pub use_default_if_preference_unavailable: bool,
}
impl TopicFilter {
    /// <p>The name of a topic on which you wish to apply the filter.</p>
    pub fn topic_name(&self) -> std::option::Option<&str> {
        self.topic_name.as_deref()
    }
    /// <p>Notes that the default subscription status should be applied to a contact because the
    /// contact has not noted their preference for subscribing to a topic.</p>
    pub fn use_default_if_preference_unavailable(&self) -> bool {
        self.use_default_if_preference_unavailable
    }
}
impl std::fmt::Debug for TopicFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicFilter");
        formatter.field("topic_name", &self.topic_name);
        formatter.field(
            "use_default_if_preference_unavailable",
            &self.use_default_if_preference_unavailable,
        );
        formatter.finish()
    }
}
/// See [`TopicFilter`](crate::model::TopicFilter)
pub mod topic_filter {
    /// A builder for [`TopicFilter`](crate::model::TopicFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_name: std::option::Option<std::string::String>,
        pub(crate) use_default_if_preference_unavailable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of a topic on which you wish to apply the filter.</p>
        pub fn topic_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_name = Some(input.into());
            self
        }
        /// <p>The name of a topic on which you wish to apply the filter.</p>
        pub fn set_topic_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_name = input;
            self
        }
        /// <p>Notes that the default subscription status should be applied to a contact because the
        /// contact has not noted their preference for subscribing to a topic.</p>
        pub fn use_default_if_preference_unavailable(mut self, input: bool) -> Self {
            self.use_default_if_preference_unavailable = Some(input);
            self
        }
        /// <p>Notes that the default subscription status should be applied to a contact because the
        /// contact has not noted their preference for subscribing to a topic.</p>
        pub fn set_use_default_if_preference_unavailable(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_default_if_preference_unavailable = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicFilter`](crate::model::TopicFilter)
        pub fn build(self) -> crate::model::TopicFilter {
            crate::model::TopicFilter {
                topic_name: self.topic_name,
                use_default_if_preference_unavailable: self
                    .use_default_if_preference_unavailable
                    .unwrap_or_default(),
            }
        }
    }
}
impl TopicFilter {
    /// Creates a new builder-style object to manufacture [`TopicFilter`](crate::model::TopicFilter)
    pub fn builder() -> crate::model::topic_filter::Builder {
        crate::model::topic_filter::Builder::default()
    }
}

/// <p>A list that contains contacts that have subscribed to a particular topic or
/// topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactList {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>A timestamp noting the last time the contact list was updated.</p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ContactList {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>A timestamp noting the last time the contact list was updated.</p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ContactList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactList");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.finish()
    }
}
/// See [`ContactList`](crate::model::ContactList)
pub mod contact_list {
    /// A builder for [`ContactList`](crate::model::ContactList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>A timestamp noting the last time the contact list was updated.</p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p>A timestamp noting the last time the contact list was updated.</p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactList`](crate::model::ContactList)
        pub fn build(self) -> crate::model::ContactList {
            crate::model::ContactList {
                contact_list_name: self.contact_list_name,
                last_updated_timestamp: self.last_updated_timestamp,
            }
        }
    }
}
impl ContactList {
    /// Creates a new builder-style object to manufacture [`ContactList`](crate::model::ContactList)
    pub fn builder() -> crate::model::contact_list::Builder {
        crate::model::contact_list::Builder::default()
    }
}

/// <p>An object that contains information about an email address that is on the suppression
/// list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressedDestination {
    /// <p>The email address that is on the suppression list for your account.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The reason that the address was added to the suppression list for your account.</p>
    pub reason: std::option::Option<crate::model::SuppressionListReason>,
    /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
    /// format.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An optional value that can contain additional information about the reasons that the
    /// address was added to the suppression list for your account.</p>
    pub attributes: std::option::Option<crate::model::SuppressedDestinationAttributes>,
}
impl SuppressedDestination {
    /// <p>The email address that is on the suppression list for your account.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The reason that the address was added to the suppression list for your account.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::SuppressionListReason> {
        self.reason.as_ref()
    }
    /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
    /// format.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>An optional value that can contain additional information about the reasons that the
    /// address was added to the suppression list for your account.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&crate::model::SuppressedDestinationAttributes> {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for SuppressedDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressedDestination");
        formatter.field("email_address", &self.email_address);
        formatter.field("reason", &self.reason);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`SuppressedDestination`](crate::model::SuppressedDestination)
pub mod suppressed_destination {
    /// A builder for [`SuppressedDestination`](crate::model::SuppressedDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::SuppressionListReason>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) attributes: std::option::Option<crate::model::SuppressedDestinationAttributes>,
    }
    impl Builder {
        /// <p>The email address that is on the suppression list for your account.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that is on the suppression list for your account.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The reason that the address was added to the suppression list for your account.</p>
        pub fn reason(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason that the address was added to the suppression list for your account.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SuppressionListReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
        /// format.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The date and time when the suppressed destination was last updated, shown in Unix time
        /// format.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>An optional value that can contain additional information about the reasons that the
        /// address was added to the suppression list for your account.</p>
        pub fn attributes(mut self, input: crate::model::SuppressedDestinationAttributes) -> Self {
            self.attributes = Some(input);
            self
        }
        /// <p>An optional value that can contain additional information about the reasons that the
        /// address was added to the suppression list for your account.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::SuppressedDestinationAttributes>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressedDestination`](crate::model::SuppressedDestination)
        pub fn build(self) -> crate::model::SuppressedDestination {
            crate::model::SuppressedDestination {
                email_address: self.email_address,
                reason: self.reason,
                last_update_time: self.last_update_time,
                attributes: self.attributes,
            }
        }
    }
}
impl SuppressedDestination {
    /// Creates a new builder-style object to manufacture [`SuppressedDestination`](crate::model::SuppressedDestination)
    pub fn builder() -> crate::model::suppressed_destination::Builder {
        crate::model::suppressed_destination::Builder::default()
    }
}

/// <p>An object that contains additional attributes that are related an email address that
/// is on the suppression list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressedDestinationAttributes {
    /// <p>The unique identifier of the email message that caused the email address to be added
    /// to the suppression list for your account.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that's generated when an email address is added to the suppression
    /// list for your account.</p>
    pub feedback_id: std::option::Option<std::string::String>,
}
impl SuppressedDestinationAttributes {
    /// <p>The unique identifier of the email message that caused the email address to be added
    /// to the suppression list for your account.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>A unique identifier that's generated when an email address is added to the suppression
    /// list for your account.</p>
    pub fn feedback_id(&self) -> std::option::Option<&str> {
        self.feedback_id.as_deref()
    }
}
impl std::fmt::Debug for SuppressedDestinationAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressedDestinationAttributes");
        formatter.field("message_id", &self.message_id);
        formatter.field("feedback_id", &self.feedback_id);
        formatter.finish()
    }
}
/// See [`SuppressedDestinationAttributes`](crate::model::SuppressedDestinationAttributes)
pub mod suppressed_destination_attributes {
    /// A builder for [`SuppressedDestinationAttributes`](crate::model::SuppressedDestinationAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) feedback_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the email message that caused the email address to be added
        /// to the suppression list for your account.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the email message that caused the email address to be added
        /// to the suppression list for your account.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>A unique identifier that's generated when an email address is added to the suppression
        /// list for your account.</p>
        pub fn feedback_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that's generated when an email address is added to the suppression
        /// list for your account.</p>
        pub fn set_feedback_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feedback_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressedDestinationAttributes`](crate::model::SuppressedDestinationAttributes)
        pub fn build(self) -> crate::model::SuppressedDestinationAttributes {
            crate::model::SuppressedDestinationAttributes {
                message_id: self.message_id,
                feedback_id: self.feedback_id,
            }
        }
    }
}
impl SuppressedDestinationAttributes {
    /// Creates a new builder-style object to manufacture [`SuppressedDestinationAttributes`](crate::model::SuppressedDestinationAttributes)
    pub fn builder() -> crate::model::suppressed_destination_attributes::Builder {
        crate::model::suppressed_destination_attributes::Builder::default()
    }
}

/// <p>An object that contains the failure details about an import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureInfo {
    /// <p>An Amazon S3 presigned URL that contains all the failed records and related
    /// information.</p>
    pub failed_records_s3_url: std::option::Option<std::string::String>,
    /// <p>A message about why the import job failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailureInfo {
    /// <p>An Amazon S3 presigned URL that contains all the failed records and related
    /// information.</p>
    pub fn failed_records_s3_url(&self) -> std::option::Option<&str> {
        self.failed_records_s3_url.as_deref()
    }
    /// <p>A message about why the import job failed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailureInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureInfo");
        formatter.field("failed_records_s3_url", &self.failed_records_s3_url);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailureInfo`](crate::model::FailureInfo)
pub mod failure_info {
    /// A builder for [`FailureInfo`](crate::model::FailureInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_records_s3_url: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon S3 presigned URL that contains all the failed records and related
        /// information.</p>
        pub fn failed_records_s3_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failed_records_s3_url = Some(input.into());
            self
        }
        /// <p>An Amazon S3 presigned URL that contains all the failed records and related
        /// information.</p>
        pub fn set_failed_records_s3_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failed_records_s3_url = input;
            self
        }
        /// <p>A message about why the import job failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message about why the import job failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureInfo`](crate::model::FailureInfo)
        pub fn build(self) -> crate::model::FailureInfo {
            crate::model::FailureInfo {
                failed_records_s3_url: self.failed_records_s3_url,
                error_message: self.error_message,
            }
        }
    }
}
impl FailureInfo {
    /// Creates a new builder-style object to manufacture [`FailureInfo`](crate::model::FailureInfo)
    pub fn builder() -> crate::model::failure_info::Builder {
        crate::model::failure_info::Builder::default()
    }
}

/// <p>An object that contains details about the data source of the import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportDataSource {
    /// <p>An Amazon S3 URL in the format
    /// s3://<i><bucket_name></i>/<i><object></i>.</p>
    pub s3_url: std::option::Option<std::string::String>,
    /// <p>The data format of the import job's data source.</p>
    pub data_format: std::option::Option<crate::model::DataFormat>,
}
impl ImportDataSource {
    /// <p>An Amazon S3 URL in the format
    /// s3://<i><bucket_name></i>/<i><object></i>.</p>
    pub fn s3_url(&self) -> std::option::Option<&str> {
        self.s3_url.as_deref()
    }
    /// <p>The data format of the import job's data source.</p>
    pub fn data_format(&self) -> std::option::Option<&crate::model::DataFormat> {
        self.data_format.as_ref()
    }
}
impl std::fmt::Debug for ImportDataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportDataSource");
        formatter.field("s3_url", &self.s3_url);
        formatter.field("data_format", &self.data_format);
        formatter.finish()
    }
}
/// See [`ImportDataSource`](crate::model::ImportDataSource)
pub mod import_data_source {
    /// A builder for [`ImportDataSource`](crate::model::ImportDataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_url: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormat>,
    }
    impl Builder {
        /// <p>An Amazon S3 URL in the format
        /// s3://<i><bucket_name></i>/<i><object></i>.</p>
        pub fn s3_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_url = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URL in the format
        /// s3://<i><bucket_name></i>/<i><object></i>.</p>
        pub fn set_s3_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_url = input;
            self
        }
        /// <p>The data format of the import job's data source.</p>
        pub fn data_format(mut self, input: crate::model::DataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The data format of the import job's data source.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDataSource`](crate::model::ImportDataSource)
        pub fn build(self) -> crate::model::ImportDataSource {
            crate::model::ImportDataSource {
                s3_url: self.s3_url,
                data_format: self.data_format,
            }
        }
    }
}
impl ImportDataSource {
    /// Creates a new builder-style object to manufacture [`ImportDataSource`](crate::model::ImportDataSource)
    pub fn builder() -> crate::model::import_data_source::Builder {
        crate::model::import_data_source::Builder::default()
    }
}

/// <p>The data format of the import job's data source.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => DataFormat::Csv,
            "JSON" => DataFormat::Json,
            other => DataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataFormat::from(s))
    }
}
impl DataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataFormat::Csv => "CSV",
            DataFormat::Json => "JSON",
            DataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for DataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of attributes that are associated with a MAIL FROM domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailFromAttributes {
    /// <p>The name of a domain that an email identity uses as a custom MAIL FROM domain.</p>
    pub mail_from_domain: std::option::Option<std::string::String>,
    /// <p>The status of the MAIL FROM domain. This status can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – Amazon SES hasn't started searching for the MX record
    /// yet.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code> – Amazon SES detected the required MX record for the
    /// MAIL FROM domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – Amazon SES can't find the required MX record, or the
    /// record no longer exists.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which
    /// prevented Amazon SES from determining the status of the MAIL FROM domain.</p>
    /// </li>
    /// </ul>
    pub mail_from_domain_status: std::option::Option<crate::model::MailFromDomainStatus>,
    /// <p>The action to take if the required MX record can't be found when you send an email.
    /// When you set this value to <code>UseDefaultValue</code>, the mail is sent using
    /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
    /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
    /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
    /// email.</p>
    /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
    /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
    /// states.</p>
    pub behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
}
impl MailFromAttributes {
    /// <p>The name of a domain that an email identity uses as a custom MAIL FROM domain.</p>
    pub fn mail_from_domain(&self) -> std::option::Option<&str> {
        self.mail_from_domain.as_deref()
    }
    /// <p>The status of the MAIL FROM domain. This status can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – Amazon SES hasn't started searching for the MX record
    /// yet.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code> – Amazon SES detected the required MX record for the
    /// MAIL FROM domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – Amazon SES can't find the required MX record, or the
    /// record no longer exists.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which
    /// prevented Amazon SES from determining the status of the MAIL FROM domain.</p>
    /// </li>
    /// </ul>
    pub fn mail_from_domain_status(
        &self,
    ) -> std::option::Option<&crate::model::MailFromDomainStatus> {
        self.mail_from_domain_status.as_ref()
    }
    /// <p>The action to take if the required MX record can't be found when you send an email.
    /// When you set this value to <code>UseDefaultValue</code>, the mail is sent using
    /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
    /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
    /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
    /// email.</p>
    /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
    /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
    /// states.</p>
    pub fn behavior_on_mx_failure(
        &self,
    ) -> std::option::Option<&crate::model::BehaviorOnMxFailure> {
        self.behavior_on_mx_failure.as_ref()
    }
}
impl std::fmt::Debug for MailFromAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailFromAttributes");
        formatter.field("mail_from_domain", &self.mail_from_domain);
        formatter.field("mail_from_domain_status", &self.mail_from_domain_status);
        formatter.field("behavior_on_mx_failure", &self.behavior_on_mx_failure);
        formatter.finish()
    }
}
/// See [`MailFromAttributes`](crate::model::MailFromAttributes)
pub mod mail_from_attributes {
    /// A builder for [`MailFromAttributes`](crate::model::MailFromAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mail_from_domain: std::option::Option<std::string::String>,
        pub(crate) mail_from_domain_status: std::option::Option<crate::model::MailFromDomainStatus>,
        pub(crate) behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
    }
    impl Builder {
        /// <p>The name of a domain that an email identity uses as a custom MAIL FROM domain.</p>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.mail_from_domain = Some(input.into());
            self
        }
        /// <p>The name of a domain that an email identity uses as a custom MAIL FROM domain.</p>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mail_from_domain = input;
            self
        }
        /// <p>The status of the MAIL FROM domain. This status can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – Amazon SES hasn't started searching for the MX record
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> – Amazon SES detected the required MX record for the
        /// MAIL FROM domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – Amazon SES can't find the required MX record, or the
        /// record no longer exists.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which
        /// prevented Amazon SES from determining the status of the MAIL FROM domain.</p>
        /// </li>
        /// </ul>
        pub fn mail_from_domain_status(
            mut self,
            input: crate::model::MailFromDomainStatus,
        ) -> Self {
            self.mail_from_domain_status = Some(input);
            self
        }
        /// <p>The status of the MAIL FROM domain. This status can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – Amazon SES hasn't started searching for the MX record
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> – Amazon SES detected the required MX record for the
        /// MAIL FROM domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – Amazon SES can't find the required MX record, or the
        /// record no longer exists.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which
        /// prevented Amazon SES from determining the status of the MAIL FROM domain.</p>
        /// </li>
        /// </ul>
        pub fn set_mail_from_domain_status(
            mut self,
            input: std::option::Option<crate::model::MailFromDomainStatus>,
        ) -> Self {
            self.mail_from_domain_status = input;
            self
        }
        /// <p>The action to take if the required MX record can't be found when you send an email.
        /// When you set this value to <code>UseDefaultValue</code>, the mail is sent using
        /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
        /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
        /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
        /// email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
        /// states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.behavior_on_mx_failure = Some(input);
            self
        }
        /// <p>The action to take if the required MX record can't be found when you send an email.
        /// When you set this value to <code>UseDefaultValue</code>, the mail is sent using
        /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
        /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
        /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
        /// email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
        /// states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.behavior_on_mx_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`MailFromAttributes`](crate::model::MailFromAttributes)
        pub fn build(self) -> crate::model::MailFromAttributes {
            crate::model::MailFromAttributes {
                mail_from_domain: self.mail_from_domain,
                mail_from_domain_status: self.mail_from_domain_status,
                behavior_on_mx_failure: self.behavior_on_mx_failure,
            }
        }
    }
}
impl MailFromAttributes {
    /// Creates a new builder-style object to manufacture [`MailFromAttributes`](crate::model::MailFromAttributes)
    pub fn builder() -> crate::model::mail_from_attributes::Builder {
        crate::model::mail_from_attributes::Builder::default()
    }
}

/// <p>The status of the MAIL FROM domain. This status can have the following values:</p>
/// <ul>
/// <li>
/// <p>
/// <code>PENDING</code> – Amazon SES hasn't started searching for the MX record
/// yet.</p>
/// </li>
/// <li>
/// <p>
/// <code>SUCCESS</code> – Amazon SES detected the required MX record for the
/// MAIL FROM domain.</p>
/// </li>
/// <li>
/// <p>
/// <code>FAILED</code> – Amazon SES can't find the required MX record, or the
/// record no longer exists.</p>
/// </li>
/// <li>
/// <p>
/// <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which
/// prevented Amazon SES from determining the status of the MAIL FROM domain.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MailFromDomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MailFromDomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => MailFromDomainStatus::Failed,
            "PENDING" => MailFromDomainStatus::Pending,
            "SUCCESS" => MailFromDomainStatus::Success,
            "TEMPORARY_FAILURE" => MailFromDomainStatus::TemporaryFailure,
            other => MailFromDomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MailFromDomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MailFromDomainStatus::from(s))
    }
}
impl MailFromDomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MailFromDomainStatus::Failed => "FAILED",
            MailFromDomainStatus::Pending => "PENDING",
            MailFromDomainStatus::Success => "SUCCESS",
            MailFromDomainStatus::TemporaryFailure => "TEMPORARY_FAILURE",
            MailFromDomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING", "SUCCESS", "TEMPORARY_FAILURE"]
    }
}
impl AsRef<str> for MailFromDomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about the DKIM authentication status for an email
/// identity.</p>
/// <p>Amazon SES determines the authentication status by searching for specific records in the
/// DNS configuration for the domain. If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM
/// authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration
/// for your domain. If you provided a public key to perform DKIM authentication, Amazon SES
/// tries to find a TXT record that uses the selector that you specified. The value of the
/// TXT record must be a public key that's paired with the private key that you specified in
/// the process of creating the identity</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DkimAttributes {
    /// <p>If the value is <code>true</code>, then the messages that you send from the identity
    /// are signed using DKIM. If the value is <code>false</code>, then the messages that you
    /// send from the identity aren't DKIM-signed.</p>
    pub signing_enabled: bool,
    /// <p>Describes whether or not Amazon SES has successfully located the DKIM records in the DNS
    /// records for the domain. The status can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – The verification process was initiated, but Amazon SES
    /// hasn't yet detected the DKIM records in the DNS configuration for the
    /// domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code> – The verification process completed
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – The verification process failed. This typically
    /// occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the
    /// domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES
    /// from determining the DKIM authentication status of the domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_STARTED</code> – The DKIM verification process hasn't been
    /// initiated for the domain.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DkimStatus>,
    /// <p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object
    /// contains a set of unique strings that you use to create a set of CNAME records that you
    /// add to the DNS configuration for your domain. When Amazon SES detects these records in the
    /// DNS configuration for your domain, the DKIM authentication process is complete.</p>
    /// <p>If you configured DKIM authentication for the domain by providing your own
    /// public-private key pair, then this object contains the selector for the public
    /// key.</p>
    /// <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the
    /// appropriate records in the DNS configuration of the domain for up to 72 hours.</p>
    pub tokens: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string that indicates how DKIM was configured for the identity. These are the
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AWS_SES</code> – Indicates that DKIM was configured for the
    /// identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXTERNAL</code> – Indicates that DKIM was configured for the
    /// identity by using Bring Your Own DKIM (BYODKIM).</p>
    /// </li>
    /// </ul>
    pub signing_attributes_origin: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
    /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
    pub next_signing_key_length: std::option::Option<crate::model::DkimSigningKeyLength>,
    /// <p>[Easy DKIM] The key length of the DKIM key pair in use.</p>
    pub current_signing_key_length: std::option::Option<crate::model::DkimSigningKeyLength>,
    /// <p>[Easy DKIM] The last time a key pair was generated for this identity.</p>
    pub last_key_generation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl DkimAttributes {
    /// <p>If the value is <code>true</code>, then the messages that you send from the identity
    /// are signed using DKIM. If the value is <code>false</code>, then the messages that you
    /// send from the identity aren't DKIM-signed.</p>
    pub fn signing_enabled(&self) -> bool {
        self.signing_enabled
    }
    /// <p>Describes whether or not Amazon SES has successfully located the DKIM records in the DNS
    /// records for the domain. The status can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – The verification process was initiated, but Amazon SES
    /// hasn't yet detected the DKIM records in the DNS configuration for the
    /// domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code> – The verification process completed
    /// successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – The verification process failed. This typically
    /// occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the
    /// domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES
    /// from determining the DKIM authentication status of the domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_STARTED</code> – The DKIM verification process hasn't been
    /// initiated for the domain.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DkimStatus> {
        self.status.as_ref()
    }
    /// <p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object
    /// contains a set of unique strings that you use to create a set of CNAME records that you
    /// add to the DNS configuration for your domain. When Amazon SES detects these records in the
    /// DNS configuration for your domain, the DKIM authentication process is complete.</p>
    /// <p>If you configured DKIM authentication for the domain by providing your own
    /// public-private key pair, then this object contains the selector for the public
    /// key.</p>
    /// <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the
    /// appropriate records in the DNS configuration of the domain for up to 72 hours.</p>
    pub fn tokens(&self) -> std::option::Option<&[std::string::String]> {
        self.tokens.as_deref()
    }
    /// <p>A string that indicates how DKIM was configured for the identity. These are the
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AWS_SES</code> – Indicates that DKIM was configured for the
    /// identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXTERNAL</code> – Indicates that DKIM was configured for the
    /// identity by using Bring Your Own DKIM (BYODKIM).</p>
    /// </li>
    /// </ul>
    pub fn signing_attributes_origin(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningAttributesOrigin> {
        self.signing_attributes_origin.as_ref()
    }
    /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
    pub fn next_signing_key_length(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningKeyLength> {
        self.next_signing_key_length.as_ref()
    }
    /// <p>[Easy DKIM] The key length of the DKIM key pair in use.</p>
    pub fn current_signing_key_length(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningKeyLength> {
        self.current_signing_key_length.as_ref()
    }
    /// <p>[Easy DKIM] The last time a key pair was generated for this identity.</p>
    pub fn last_key_generation_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_key_generation_timestamp.as_ref()
    }
}
impl std::fmt::Debug for DkimAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DkimAttributes");
        formatter.field("signing_enabled", &self.signing_enabled);
        formatter.field("status", &self.status);
        formatter.field("tokens", &self.tokens);
        formatter.field("signing_attributes_origin", &self.signing_attributes_origin);
        formatter.field("next_signing_key_length", &self.next_signing_key_length);
        formatter.field(
            "current_signing_key_length",
            &self.current_signing_key_length,
        );
        formatter.field(
            "last_key_generation_timestamp",
            &self.last_key_generation_timestamp,
        );
        formatter.finish()
    }
}
/// See [`DkimAttributes`](crate::model::DkimAttributes)
pub mod dkim_attributes {
    /// A builder for [`DkimAttributes`](crate::model::DkimAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_enabled: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::DkimStatus>,
        pub(crate) tokens: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) signing_attributes_origin:
            std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        pub(crate) next_signing_key_length: std::option::Option<crate::model::DkimSigningKeyLength>,
        pub(crate) current_signing_key_length:
            std::option::Option<crate::model::DkimSigningKeyLength>,
        pub(crate) last_key_generation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>If the value is <code>true</code>, then the messages that you send from the identity
        /// are signed using DKIM. If the value is <code>false</code>, then the messages that you
        /// send from the identity aren't DKIM-signed.</p>
        pub fn signing_enabled(mut self, input: bool) -> Self {
            self.signing_enabled = Some(input);
            self
        }
        /// <p>If the value is <code>true</code>, then the messages that you send from the identity
        /// are signed using DKIM. If the value is <code>false</code>, then the messages that you
        /// send from the identity aren't DKIM-signed.</p>
        pub fn set_signing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.signing_enabled = input;
            self
        }
        /// <p>Describes whether or not Amazon SES has successfully located the DKIM records in the DNS
        /// records for the domain. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – The verification process was initiated, but Amazon SES
        /// hasn't yet detected the DKIM records in the DNS configuration for the
        /// domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> – The verification process completed
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – The verification process failed. This typically
        /// occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the
        /// domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES
        /// from determining the DKIM authentication status of the domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_STARTED</code> – The DKIM verification process hasn't been
        /// initiated for the domain.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DkimStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes whether or not Amazon SES has successfully located the DKIM records in the DNS
        /// records for the domain. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – The verification process was initiated, but Amazon SES
        /// hasn't yet detected the DKIM records in the DNS configuration for the
        /// domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> – The verification process completed
        /// successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – The verification process failed. This typically
        /// occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the
        /// domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES
        /// from determining the DKIM authentication status of the domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_STARTED</code> – The DKIM verification process hasn't been
        /// initiated for the domain.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::DkimStatus>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tokens`.
        ///
        /// To override the contents of this collection use [`set_tokens`](Self::set_tokens).
        ///
        /// <p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object
        /// contains a set of unique strings that you use to create a set of CNAME records that you
        /// add to the DNS configuration for your domain. When Amazon SES detects these records in the
        /// DNS configuration for your domain, the DKIM authentication process is complete.</p>
        /// <p>If you configured DKIM authentication for the domain by providing your own
        /// public-private key pair, then this object contains the selector for the public
        /// key.</p>
        /// <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the
        /// appropriate records in the DNS configuration of the domain for up to 72 hours.</p>
        pub fn tokens(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tokens.unwrap_or_default();
            v.push(input.into());
            self.tokens = Some(v);
            self
        }
        /// <p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object
        /// contains a set of unique strings that you use to create a set of CNAME records that you
        /// add to the DNS configuration for your domain. When Amazon SES detects these records in the
        /// DNS configuration for your domain, the DKIM authentication process is complete.</p>
        /// <p>If you configured DKIM authentication for the domain by providing your own
        /// public-private key pair, then this object contains the selector for the public
        /// key.</p>
        /// <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the
        /// appropriate records in the DNS configuration of the domain for up to 72 hours.</p>
        pub fn set_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tokens = input;
            self
        }
        /// <p>A string that indicates how DKIM was configured for the identity. These are the
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_SES</code> – Indicates that DKIM was configured for the
        /// identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXTERNAL</code> – Indicates that DKIM was configured for the
        /// identity by using Bring Your Own DKIM (BYODKIM).</p>
        /// </li>
        /// </ul>
        pub fn signing_attributes_origin(
            mut self,
            input: crate::model::DkimSigningAttributesOrigin,
        ) -> Self {
            self.signing_attributes_origin = Some(input);
            self
        }
        /// <p>A string that indicates how DKIM was configured for the identity. These are the
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_SES</code> – Indicates that DKIM was configured for the
        /// identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXTERNAL</code> – Indicates that DKIM was configured for the
        /// identity by using Bring Your Own DKIM (BYODKIM).</p>
        /// </li>
        /// </ul>
        pub fn set_signing_attributes_origin(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        ) -> Self {
            self.signing_attributes_origin = input;
            self
        }
        /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
        pub fn next_signing_key_length(
            mut self,
            input: crate::model::DkimSigningKeyLength,
        ) -> Self {
            self.next_signing_key_length = Some(input);
            self
        }
        /// <p>[Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.</p>
        pub fn set_next_signing_key_length(
            mut self,
            input: std::option::Option<crate::model::DkimSigningKeyLength>,
        ) -> Self {
            self.next_signing_key_length = input;
            self
        }
        /// <p>[Easy DKIM] The key length of the DKIM key pair in use.</p>
        pub fn current_signing_key_length(
            mut self,
            input: crate::model::DkimSigningKeyLength,
        ) -> Self {
            self.current_signing_key_length = Some(input);
            self
        }
        /// <p>[Easy DKIM] The key length of the DKIM key pair in use.</p>
        pub fn set_current_signing_key_length(
            mut self,
            input: std::option::Option<crate::model::DkimSigningKeyLength>,
        ) -> Self {
            self.current_signing_key_length = input;
            self
        }
        /// <p>[Easy DKIM] The last time a key pair was generated for this identity.</p>
        pub fn last_key_generation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_key_generation_timestamp = Some(input);
            self
        }
        /// <p>[Easy DKIM] The last time a key pair was generated for this identity.</p>
        pub fn set_last_key_generation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_key_generation_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`DkimAttributes`](crate::model::DkimAttributes)
        pub fn build(self) -> crate::model::DkimAttributes {
            crate::model::DkimAttributes {
                signing_enabled: self.signing_enabled.unwrap_or_default(),
                status: self.status,
                tokens: self.tokens,
                signing_attributes_origin: self.signing_attributes_origin,
                next_signing_key_length: self.next_signing_key_length,
                current_signing_key_length: self.current_signing_key_length,
                last_key_generation_timestamp: self.last_key_generation_timestamp,
            }
        }
    }
}
impl DkimAttributes {
    /// Creates a new builder-style object to manufacture [`DkimAttributes`](crate::model::DkimAttributes)
    pub fn builder() -> crate::model::dkim_attributes::Builder {
        crate::model::dkim_attributes::Builder::default()
    }
}

/// <p>An object that contains information about the volume of email sent on each day of the
/// analysis period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DailyVolume {
    /// <p>The date that the DailyVolume metrics apply to, in Unix time.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An object that contains inbox placement metrics for a specific day in the analysis
    /// period.</p>
    pub volume_statistics: std::option::Option<crate::model::VolumeStatistics>,
    /// <p>An object that contains inbox placement metrics for a specified day in the analysis
    /// period, broken out by the recipient's email provider.</p>
    pub domain_isp_placements: std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
}
impl DailyVolume {
    /// <p>The date that the DailyVolume metrics apply to, in Unix time.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>An object that contains inbox placement metrics for a specific day in the analysis
    /// period.</p>
    pub fn volume_statistics(&self) -> std::option::Option<&crate::model::VolumeStatistics> {
        self.volume_statistics.as_ref()
    }
    /// <p>An object that contains inbox placement metrics for a specified day in the analysis
    /// period, broken out by the recipient's email provider.</p>
    pub fn domain_isp_placements(
        &self,
    ) -> std::option::Option<&[crate::model::DomainIspPlacement]> {
        self.domain_isp_placements.as_deref()
    }
}
impl std::fmt::Debug for DailyVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DailyVolume");
        formatter.field("start_date", &self.start_date);
        formatter.field("volume_statistics", &self.volume_statistics);
        formatter.field("domain_isp_placements", &self.domain_isp_placements);
        formatter.finish()
    }
}
/// See [`DailyVolume`](crate::model::DailyVolume)
pub mod daily_volume {
    /// A builder for [`DailyVolume`](crate::model::DailyVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) volume_statistics: std::option::Option<crate::model::VolumeStatistics>,
        pub(crate) domain_isp_placements:
            std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
    }
    impl Builder {
        /// <p>The date that the DailyVolume metrics apply to, in Unix time.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date that the DailyVolume metrics apply to, in Unix time.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>An object that contains inbox placement metrics for a specific day in the analysis
        /// period.</p>
        pub fn volume_statistics(mut self, input: crate::model::VolumeStatistics) -> Self {
            self.volume_statistics = Some(input);
            self
        }
        /// <p>An object that contains inbox placement metrics for a specific day in the analysis
        /// period.</p>
        pub fn set_volume_statistics(
            mut self,
            input: std::option::Option<crate::model::VolumeStatistics>,
        ) -> Self {
            self.volume_statistics = input;
            self
        }
        /// Appends an item to `domain_isp_placements`.
        ///
        /// To override the contents of this collection use [`set_domain_isp_placements`](Self::set_domain_isp_placements).
        ///
        /// <p>An object that contains inbox placement metrics for a specified day in the analysis
        /// period, broken out by the recipient's email provider.</p>
        pub fn domain_isp_placements(
            mut self,
            input: impl Into<crate::model::DomainIspPlacement>,
        ) -> Self {
            let mut v = self.domain_isp_placements.unwrap_or_default();
            v.push(input.into());
            self.domain_isp_placements = Some(v);
            self
        }
        /// <p>An object that contains inbox placement metrics for a specified day in the analysis
        /// period, broken out by the recipient's email provider.</p>
        pub fn set_domain_isp_placements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
        ) -> Self {
            self.domain_isp_placements = input;
            self
        }
        /// Consumes the builder and constructs a [`DailyVolume`](crate::model::DailyVolume)
        pub fn build(self) -> crate::model::DailyVolume {
            crate::model::DailyVolume {
                start_date: self.start_date,
                volume_statistics: self.volume_statistics,
                domain_isp_placements: self.domain_isp_placements,
            }
        }
    }
}
impl DailyVolume {
    /// Creates a new builder-style object to manufacture [`DailyVolume`](crate::model::DailyVolume)
    pub fn builder() -> crate::model::daily_volume::Builder {
        crate::model::daily_volume::Builder::default()
    }
}

/// <p>An object that contains inbox placement data for email sent from one of your email
/// domains to a specific email provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainIspPlacement {
    /// <p>The name of the email provider that the inbox placement data applies to.</p>
    pub isp_name: std::option::Option<std::string::String>,
    /// <p>The total number of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' inboxes.</p>
    pub inbox_raw_count: std::option::Option<i64>,
    /// <p>The total number of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' spam or junk mail folders.</p>
    pub spam_raw_count: std::option::Option<i64>,
    /// <p>The percentage of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' inboxes.</p>
    pub inbox_percentage: std::option::Option<f64>,
    /// <p>The percentage of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' spam or junk mail folders.</p>
    pub spam_percentage: std::option::Option<f64>,
}
impl DomainIspPlacement {
    /// <p>The name of the email provider that the inbox placement data applies to.</p>
    pub fn isp_name(&self) -> std::option::Option<&str> {
        self.isp_name.as_deref()
    }
    /// <p>The total number of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' inboxes.</p>
    pub fn inbox_raw_count(&self) -> std::option::Option<i64> {
        self.inbox_raw_count
    }
    /// <p>The total number of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' spam or junk mail folders.</p>
    pub fn spam_raw_count(&self) -> std::option::Option<i64> {
        self.spam_raw_count
    }
    /// <p>The percentage of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' inboxes.</p>
    pub fn inbox_percentage(&self) -> std::option::Option<f64> {
        self.inbox_percentage
    }
    /// <p>The percentage of messages that were sent from the selected domain to the specified
    /// email provider that arrived in recipients' spam or junk mail folders.</p>
    pub fn spam_percentage(&self) -> std::option::Option<f64> {
        self.spam_percentage
    }
}
impl std::fmt::Debug for DomainIspPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainIspPlacement");
        formatter.field("isp_name", &self.isp_name);
        formatter.field("inbox_raw_count", &self.inbox_raw_count);
        formatter.field("spam_raw_count", &self.spam_raw_count);
        formatter.field("inbox_percentage", &self.inbox_percentage);
        formatter.field("spam_percentage", &self.spam_percentage);
        formatter.finish()
    }
}
/// See [`DomainIspPlacement`](crate::model::DomainIspPlacement)
pub mod domain_isp_placement {
    /// A builder for [`DomainIspPlacement`](crate::model::DomainIspPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) isp_name: std::option::Option<std::string::String>,
        pub(crate) inbox_raw_count: std::option::Option<i64>,
        pub(crate) spam_raw_count: std::option::Option<i64>,
        pub(crate) inbox_percentage: std::option::Option<f64>,
        pub(crate) spam_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the email provider that the inbox placement data applies to.</p>
        pub fn isp_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.isp_name = Some(input.into());
            self
        }
        /// <p>The name of the email provider that the inbox placement data applies to.</p>
        pub fn set_isp_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.isp_name = input;
            self
        }
        /// <p>The total number of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' inboxes.</p>
        pub fn inbox_raw_count(mut self, input: i64) -> Self {
            self.inbox_raw_count = Some(input);
            self
        }
        /// <p>The total number of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' inboxes.</p>
        pub fn set_inbox_raw_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inbox_raw_count = input;
            self
        }
        /// <p>The total number of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' spam or junk mail folders.</p>
        pub fn spam_raw_count(mut self, input: i64) -> Self {
            self.spam_raw_count = Some(input);
            self
        }
        /// <p>The total number of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' spam or junk mail folders.</p>
        pub fn set_spam_raw_count(mut self, input: std::option::Option<i64>) -> Self {
            self.spam_raw_count = input;
            self
        }
        /// <p>The percentage of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' inboxes.</p>
        pub fn inbox_percentage(mut self, input: f64) -> Self {
            self.inbox_percentage = Some(input);
            self
        }
        /// <p>The percentage of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' inboxes.</p>
        pub fn set_inbox_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inbox_percentage = input;
            self
        }
        /// <p>The percentage of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' spam or junk mail folders.</p>
        pub fn spam_percentage(mut self, input: f64) -> Self {
            self.spam_percentage = Some(input);
            self
        }
        /// <p>The percentage of messages that were sent from the selected domain to the specified
        /// email provider that arrived in recipients' spam or junk mail folders.</p>
        pub fn set_spam_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.spam_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainIspPlacement`](crate::model::DomainIspPlacement)
        pub fn build(self) -> crate::model::DomainIspPlacement {
            crate::model::DomainIspPlacement {
                isp_name: self.isp_name,
                inbox_raw_count: self.inbox_raw_count,
                spam_raw_count: self.spam_raw_count,
                inbox_percentage: self.inbox_percentage,
                spam_percentage: self.spam_percentage,
            }
        }
    }
}
impl DomainIspPlacement {
    /// Creates a new builder-style object to manufacture [`DomainIspPlacement`](crate::model::DomainIspPlacement)
    pub fn builder() -> crate::model::domain_isp_placement::Builder {
        crate::model::domain_isp_placement::Builder::default()
    }
}

/// <p>An object that contains information about the amount of email that was delivered to
/// recipients.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeStatistics {
    /// <p>The total number of emails that arrived in recipients' inboxes.</p>
    pub inbox_raw_count: std::option::Option<i64>,
    /// <p>The total number of emails that arrived in recipients' spam or junk mail
    /// folders.</p>
    pub spam_raw_count: std::option::Option<i64>,
    /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
    /// in recipients' inboxes.</p>
    pub projected_inbox: std::option::Option<i64>,
    /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
    /// in recipients' spam or junk mail folders.</p>
    pub projected_spam: std::option::Option<i64>,
}
impl VolumeStatistics {
    /// <p>The total number of emails that arrived in recipients' inboxes.</p>
    pub fn inbox_raw_count(&self) -> std::option::Option<i64> {
        self.inbox_raw_count
    }
    /// <p>The total number of emails that arrived in recipients' spam or junk mail
    /// folders.</p>
    pub fn spam_raw_count(&self) -> std::option::Option<i64> {
        self.spam_raw_count
    }
    /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
    /// in recipients' inboxes.</p>
    pub fn projected_inbox(&self) -> std::option::Option<i64> {
        self.projected_inbox
    }
    /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
    /// in recipients' spam or junk mail folders.</p>
    pub fn projected_spam(&self) -> std::option::Option<i64> {
        self.projected_spam
    }
}
impl std::fmt::Debug for VolumeStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeStatistics");
        formatter.field("inbox_raw_count", &self.inbox_raw_count);
        formatter.field("spam_raw_count", &self.spam_raw_count);
        formatter.field("projected_inbox", &self.projected_inbox);
        formatter.field("projected_spam", &self.projected_spam);
        formatter.finish()
    }
}
/// See [`VolumeStatistics`](crate::model::VolumeStatistics)
pub mod volume_statistics {
    /// A builder for [`VolumeStatistics`](crate::model::VolumeStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inbox_raw_count: std::option::Option<i64>,
        pub(crate) spam_raw_count: std::option::Option<i64>,
        pub(crate) projected_inbox: std::option::Option<i64>,
        pub(crate) projected_spam: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of emails that arrived in recipients' inboxes.</p>
        pub fn inbox_raw_count(mut self, input: i64) -> Self {
            self.inbox_raw_count = Some(input);
            self
        }
        /// <p>The total number of emails that arrived in recipients' inboxes.</p>
        pub fn set_inbox_raw_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inbox_raw_count = input;
            self
        }
        /// <p>The total number of emails that arrived in recipients' spam or junk mail
        /// folders.</p>
        pub fn spam_raw_count(mut self, input: i64) -> Self {
            self.spam_raw_count = Some(input);
            self
        }
        /// <p>The total number of emails that arrived in recipients' spam or junk mail
        /// folders.</p>
        pub fn set_spam_raw_count(mut self, input: std::option::Option<i64>) -> Self {
            self.spam_raw_count = input;
            self
        }
        /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
        /// in recipients' inboxes.</p>
        pub fn projected_inbox(mut self, input: i64) -> Self {
            self.projected_inbox = Some(input);
            self
        }
        /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
        /// in recipients' inboxes.</p>
        pub fn set_projected_inbox(mut self, input: std::option::Option<i64>) -> Self {
            self.projected_inbox = input;
            self
        }
        /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
        /// in recipients' spam or junk mail folders.</p>
        pub fn projected_spam(mut self, input: i64) -> Self {
            self.projected_spam = Some(input);
            self
        }
        /// <p>An estimate of the percentage of emails sent from the current domain that will arrive
        /// in recipients' spam or junk mail folders.</p>
        pub fn set_projected_spam(mut self, input: std::option::Option<i64>) -> Self {
            self.projected_spam = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeStatistics`](crate::model::VolumeStatistics)
        pub fn build(self) -> crate::model::VolumeStatistics {
            crate::model::VolumeStatistics {
                inbox_raw_count: self.inbox_raw_count,
                spam_raw_count: self.spam_raw_count,
                projected_inbox: self.projected_inbox,
                projected_spam: self.projected_spam,
            }
        }
    }
}
impl VolumeStatistics {
    /// Creates a new builder-style object to manufacture [`VolumeStatistics`](crate::model::VolumeStatistics)
    pub fn builder() -> crate::model::volume_statistics::Builder {
        crate::model::volume_statistics::Builder::default()
    }
}

/// <p>An object that contains information about email that was sent from the selected
/// domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OverallVolume {
    /// <p>An object that contains information about the numbers of messages that arrived in
    /// recipients' inboxes and junk mail folders.</p>
    pub volume_statistics: std::option::Option<crate::model::VolumeStatistics>,
    /// <p>The percentage of emails that were sent from the domain that were read by their
    /// recipients.</p>
    pub read_rate_percent: std::option::Option<f64>,
    /// <p>An object that contains inbox and junk mail placement metrics for individual email
    /// providers.</p>
    pub domain_isp_placements: std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
}
impl OverallVolume {
    /// <p>An object that contains information about the numbers of messages that arrived in
    /// recipients' inboxes and junk mail folders.</p>
    pub fn volume_statistics(&self) -> std::option::Option<&crate::model::VolumeStatistics> {
        self.volume_statistics.as_ref()
    }
    /// <p>The percentage of emails that were sent from the domain that were read by their
    /// recipients.</p>
    pub fn read_rate_percent(&self) -> std::option::Option<f64> {
        self.read_rate_percent
    }
    /// <p>An object that contains inbox and junk mail placement metrics for individual email
    /// providers.</p>
    pub fn domain_isp_placements(
        &self,
    ) -> std::option::Option<&[crate::model::DomainIspPlacement]> {
        self.domain_isp_placements.as_deref()
    }
}
impl std::fmt::Debug for OverallVolume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OverallVolume");
        formatter.field("volume_statistics", &self.volume_statistics);
        formatter.field("read_rate_percent", &self.read_rate_percent);
        formatter.field("domain_isp_placements", &self.domain_isp_placements);
        formatter.finish()
    }
}
/// See [`OverallVolume`](crate::model::OverallVolume)
pub mod overall_volume {
    /// A builder for [`OverallVolume`](crate::model::OverallVolume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_statistics: std::option::Option<crate::model::VolumeStatistics>,
        pub(crate) read_rate_percent: std::option::Option<f64>,
        pub(crate) domain_isp_placements:
            std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
    }
    impl Builder {
        /// <p>An object that contains information about the numbers of messages that arrived in
        /// recipients' inboxes and junk mail folders.</p>
        pub fn volume_statistics(mut self, input: crate::model::VolumeStatistics) -> Self {
            self.volume_statistics = Some(input);
            self
        }
        /// <p>An object that contains information about the numbers of messages that arrived in
        /// recipients' inboxes and junk mail folders.</p>
        pub fn set_volume_statistics(
            mut self,
            input: std::option::Option<crate::model::VolumeStatistics>,
        ) -> Self {
            self.volume_statistics = input;
            self
        }
        /// <p>The percentage of emails that were sent from the domain that were read by their
        /// recipients.</p>
        pub fn read_rate_percent(mut self, input: f64) -> Self {
            self.read_rate_percent = Some(input);
            self
        }
        /// <p>The percentage of emails that were sent from the domain that were read by their
        /// recipients.</p>
        pub fn set_read_rate_percent(mut self, input: std::option::Option<f64>) -> Self {
            self.read_rate_percent = input;
            self
        }
        /// Appends an item to `domain_isp_placements`.
        ///
        /// To override the contents of this collection use [`set_domain_isp_placements`](Self::set_domain_isp_placements).
        ///
        /// <p>An object that contains inbox and junk mail placement metrics for individual email
        /// providers.</p>
        pub fn domain_isp_placements(
            mut self,
            input: impl Into<crate::model::DomainIspPlacement>,
        ) -> Self {
            let mut v = self.domain_isp_placements.unwrap_or_default();
            v.push(input.into());
            self.domain_isp_placements = Some(v);
            self
        }
        /// <p>An object that contains inbox and junk mail placement metrics for individual email
        /// providers.</p>
        pub fn set_domain_isp_placements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainIspPlacement>>,
        ) -> Self {
            self.domain_isp_placements = input;
            self
        }
        /// Consumes the builder and constructs a [`OverallVolume`](crate::model::OverallVolume)
        pub fn build(self) -> crate::model::OverallVolume {
            crate::model::OverallVolume {
                volume_statistics: self.volume_statistics,
                read_rate_percent: self.read_rate_percent,
                domain_isp_placements: self.domain_isp_placements,
            }
        }
    }
}
impl OverallVolume {
    /// Creates a new builder-style object to manufacture [`OverallVolume`](crate::model::OverallVolume)
    pub fn builder() -> crate::model::overall_volume::Builder {
        crate::model::overall_volume::Builder::default()
    }
}

/// <p>An object that describes how email sent during the predictive inbox placement test was handled by a certain
/// email provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IspPlacement {
    /// <p>The name of the email provider that the inbox placement data applies to.</p>
    pub isp_name: std::option::Option<std::string::String>,
    /// <p>An object that contains inbox placement metrics for a specific email provider.</p>
    pub placement_statistics: std::option::Option<crate::model::PlacementStatistics>,
}
impl IspPlacement {
    /// <p>The name of the email provider that the inbox placement data applies to.</p>
    pub fn isp_name(&self) -> std::option::Option<&str> {
        self.isp_name.as_deref()
    }
    /// <p>An object that contains inbox placement metrics for a specific email provider.</p>
    pub fn placement_statistics(&self) -> std::option::Option<&crate::model::PlacementStatistics> {
        self.placement_statistics.as_ref()
    }
}
impl std::fmt::Debug for IspPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IspPlacement");
        formatter.field("isp_name", &self.isp_name);
        formatter.field("placement_statistics", &self.placement_statistics);
        formatter.finish()
    }
}
/// See [`IspPlacement`](crate::model::IspPlacement)
pub mod isp_placement {
    /// A builder for [`IspPlacement`](crate::model::IspPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) isp_name: std::option::Option<std::string::String>,
        pub(crate) placement_statistics: std::option::Option<crate::model::PlacementStatistics>,
    }
    impl Builder {
        /// <p>The name of the email provider that the inbox placement data applies to.</p>
        pub fn isp_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.isp_name = Some(input.into());
            self
        }
        /// <p>The name of the email provider that the inbox placement data applies to.</p>
        pub fn set_isp_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.isp_name = input;
            self
        }
        /// <p>An object that contains inbox placement metrics for a specific email provider.</p>
        pub fn placement_statistics(mut self, input: crate::model::PlacementStatistics) -> Self {
            self.placement_statistics = Some(input);
            self
        }
        /// <p>An object that contains inbox placement metrics for a specific email provider.</p>
        pub fn set_placement_statistics(
            mut self,
            input: std::option::Option<crate::model::PlacementStatistics>,
        ) -> Self {
            self.placement_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`IspPlacement`](crate::model::IspPlacement)
        pub fn build(self) -> crate::model::IspPlacement {
            crate::model::IspPlacement {
                isp_name: self.isp_name,
                placement_statistics: self.placement_statistics,
            }
        }
    }
}
impl IspPlacement {
    /// Creates a new builder-style object to manufacture [`IspPlacement`](crate::model::IspPlacement)
    pub fn builder() -> crate::model::isp_placement::Builder {
        crate::model::isp_placement::Builder::default()
    }
}

/// <p>An object that contains inbox placement data for an email provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementStatistics {
    /// <p>The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.</p>
    pub inbox_percentage: std::option::Option<f64>,
    /// <p>The percentage of emails that arrived in recipients' spam or junk mail folders during
    /// the predictive inbox placement test.</p>
    pub spam_percentage: std::option::Option<f64>,
    /// <p>The percentage of emails that didn't arrive in recipients' inboxes at all during the
    /// predictive inbox placement test.</p>
    pub missing_percentage: std::option::Option<f64>,
    /// <p>The percentage of emails that were authenticated by using Sender Policy Framework
    /// (SPF) during the predictive inbox placement test.</p>
    pub spf_percentage: std::option::Option<f64>,
    /// <p>The percentage of emails that were authenticated by using DomainKeys Identified Mail
    /// (DKIM) during the predictive inbox placement test.</p>
    pub dkim_percentage: std::option::Option<f64>,
}
impl PlacementStatistics {
    /// <p>The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.</p>
    pub fn inbox_percentage(&self) -> std::option::Option<f64> {
        self.inbox_percentage
    }
    /// <p>The percentage of emails that arrived in recipients' spam or junk mail folders during
    /// the predictive inbox placement test.</p>
    pub fn spam_percentage(&self) -> std::option::Option<f64> {
        self.spam_percentage
    }
    /// <p>The percentage of emails that didn't arrive in recipients' inboxes at all during the
    /// predictive inbox placement test.</p>
    pub fn missing_percentage(&self) -> std::option::Option<f64> {
        self.missing_percentage
    }
    /// <p>The percentage of emails that were authenticated by using Sender Policy Framework
    /// (SPF) during the predictive inbox placement test.</p>
    pub fn spf_percentage(&self) -> std::option::Option<f64> {
        self.spf_percentage
    }
    /// <p>The percentage of emails that were authenticated by using DomainKeys Identified Mail
    /// (DKIM) during the predictive inbox placement test.</p>
    pub fn dkim_percentage(&self) -> std::option::Option<f64> {
        self.dkim_percentage
    }
}
impl std::fmt::Debug for PlacementStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementStatistics");
        formatter.field("inbox_percentage", &self.inbox_percentage);
        formatter.field("spam_percentage", &self.spam_percentage);
        formatter.field("missing_percentage", &self.missing_percentage);
        formatter.field("spf_percentage", &self.spf_percentage);
        formatter.field("dkim_percentage", &self.dkim_percentage);
        formatter.finish()
    }
}
/// See [`PlacementStatistics`](crate::model::PlacementStatistics)
pub mod placement_statistics {
    /// A builder for [`PlacementStatistics`](crate::model::PlacementStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inbox_percentage: std::option::Option<f64>,
        pub(crate) spam_percentage: std::option::Option<f64>,
        pub(crate) missing_percentage: std::option::Option<f64>,
        pub(crate) spf_percentage: std::option::Option<f64>,
        pub(crate) dkim_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.</p>
        pub fn inbox_percentage(mut self, input: f64) -> Self {
            self.inbox_percentage = Some(input);
            self
        }
        /// <p>The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.</p>
        pub fn set_inbox_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inbox_percentage = input;
            self
        }
        /// <p>The percentage of emails that arrived in recipients' spam or junk mail folders during
        /// the predictive inbox placement test.</p>
        pub fn spam_percentage(mut self, input: f64) -> Self {
            self.spam_percentage = Some(input);
            self
        }
        /// <p>The percentage of emails that arrived in recipients' spam or junk mail folders during
        /// the predictive inbox placement test.</p>
        pub fn set_spam_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.spam_percentage = input;
            self
        }
        /// <p>The percentage of emails that didn't arrive in recipients' inboxes at all during the
        /// predictive inbox placement test.</p>
        pub fn missing_percentage(mut self, input: f64) -> Self {
            self.missing_percentage = Some(input);
            self
        }
        /// <p>The percentage of emails that didn't arrive in recipients' inboxes at all during the
        /// predictive inbox placement test.</p>
        pub fn set_missing_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.missing_percentage = input;
            self
        }
        /// <p>The percentage of emails that were authenticated by using Sender Policy Framework
        /// (SPF) during the predictive inbox placement test.</p>
        pub fn spf_percentage(mut self, input: f64) -> Self {
            self.spf_percentage = Some(input);
            self
        }
        /// <p>The percentage of emails that were authenticated by using Sender Policy Framework
        /// (SPF) during the predictive inbox placement test.</p>
        pub fn set_spf_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.spf_percentage = input;
            self
        }
        /// <p>The percentage of emails that were authenticated by using DomainKeys Identified Mail
        /// (DKIM) during the predictive inbox placement test.</p>
        pub fn dkim_percentage(mut self, input: f64) -> Self {
            self.dkim_percentage = Some(input);
            self
        }
        /// <p>The percentage of emails that were authenticated by using DomainKeys Identified Mail
        /// (DKIM) during the predictive inbox placement test.</p>
        pub fn set_dkim_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.dkim_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementStatistics`](crate::model::PlacementStatistics)
        pub fn build(self) -> crate::model::PlacementStatistics {
            crate::model::PlacementStatistics {
                inbox_percentage: self.inbox_percentage,
                spam_percentage: self.spam_percentage,
                missing_percentage: self.missing_percentage,
                spf_percentage: self.spf_percentage,
                dkim_percentage: self.dkim_percentage,
            }
        }
    }
}
impl PlacementStatistics {
    /// Creates a new builder-style object to manufacture [`PlacementStatistics`](crate::model::PlacementStatistics)
    pub fn builder() -> crate::model::placement_statistics::Builder {
        crate::model::placement_statistics::Builder::default()
    }
}

/// <p>The current status of your Deliverability dashboard subscription. If this value is
/// <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end
/// of the current calendar month.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeliverabilityDashboardAccountStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    PendingExpiration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeliverabilityDashboardAccountStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DeliverabilityDashboardAccountStatus::Active,
            "DISABLED" => DeliverabilityDashboardAccountStatus::Disabled,
            "PENDING_EXPIRATION" => DeliverabilityDashboardAccountStatus::PendingExpiration,
            other => DeliverabilityDashboardAccountStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeliverabilityDashboardAccountStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeliverabilityDashboardAccountStatus::from(s))
    }
}
impl DeliverabilityDashboardAccountStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeliverabilityDashboardAccountStatus::Active => "ACTIVE",
            DeliverabilityDashboardAccountStatus::Disabled => "DISABLED",
            DeliverabilityDashboardAccountStatus::PendingExpiration => "PENDING_EXPIRATION",
            DeliverabilityDashboardAccountStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DISABLED", "PENDING_EXPIRATION"]
    }
}
impl AsRef<str> for DeliverabilityDashboardAccountStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a dedicated IP address that is associated with your Amazon SES
/// account.</p>
/// <p>To learn more about requesting dedicated IP addresses, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/dedicated-ip-case.html">Requesting and Relinquishing
/// Dedicated IP Addresses</a> in the <i>Amazon SES Developer
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DedicatedIp {
    /// <p>An IPv4 address.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>The warm-up status of a dedicated IP address. The status can have one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> – The IP address isn't ready to use because the
    /// dedicated IP warm-up process is ongoing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DONE</code> – The dedicated IP warm-up process is complete, and
    /// the IP address is ready to use.</p>
    /// </li>
    /// </ul>
    pub warmup_status: std::option::Option<crate::model::WarmupStatus>,
    /// <p>Indicates how complete the dedicated IP warm-up process is. When this value equals 1,
    /// the address has completed the warm-up process and is ready for use.</p>
    pub warmup_percentage: std::option::Option<i32>,
    /// <p>The name of the dedicated IP pool that the IP address is associated with.</p>
    pub pool_name: std::option::Option<std::string::String>,
}
impl DedicatedIp {
    /// <p>An IPv4 address.</p>
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
    /// <p>The warm-up status of a dedicated IP address. The status can have one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> – The IP address isn't ready to use because the
    /// dedicated IP warm-up process is ongoing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DONE</code> – The dedicated IP warm-up process is complete, and
    /// the IP address is ready to use.</p>
    /// </li>
    /// </ul>
    pub fn warmup_status(&self) -> std::option::Option<&crate::model::WarmupStatus> {
        self.warmup_status.as_ref()
    }
    /// <p>Indicates how complete the dedicated IP warm-up process is. When this value equals 1,
    /// the address has completed the warm-up process and is ready for use.</p>
    pub fn warmup_percentage(&self) -> std::option::Option<i32> {
        self.warmup_percentage
    }
    /// <p>The name of the dedicated IP pool that the IP address is associated with.</p>
    pub fn pool_name(&self) -> std::option::Option<&str> {
        self.pool_name.as_deref()
    }
}
impl std::fmt::Debug for DedicatedIp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DedicatedIp");
        formatter.field("ip", &self.ip);
        formatter.field("warmup_status", &self.warmup_status);
        formatter.field("warmup_percentage", &self.warmup_percentage);
        formatter.field("pool_name", &self.pool_name);
        formatter.finish()
    }
}
/// See [`DedicatedIp`](crate::model::DedicatedIp)
pub mod dedicated_ip {
    /// A builder for [`DedicatedIp`](crate::model::DedicatedIp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) warmup_status: std::option::Option<crate::model::WarmupStatus>,
        pub(crate) warmup_percentage: std::option::Option<i32>,
        pub(crate) pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An IPv4 address.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>An IPv4 address.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>The warm-up status of a dedicated IP address. The status can have one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> – The IP address isn't ready to use because the
        /// dedicated IP warm-up process is ongoing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DONE</code> – The dedicated IP warm-up process is complete, and
        /// the IP address is ready to use.</p>
        /// </li>
        /// </ul>
        pub fn warmup_status(mut self, input: crate::model::WarmupStatus) -> Self {
            self.warmup_status = Some(input);
            self
        }
        /// <p>The warm-up status of a dedicated IP address. The status can have one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> – The IP address isn't ready to use because the
        /// dedicated IP warm-up process is ongoing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DONE</code> – The dedicated IP warm-up process is complete, and
        /// the IP address is ready to use.</p>
        /// </li>
        /// </ul>
        pub fn set_warmup_status(
            mut self,
            input: std::option::Option<crate::model::WarmupStatus>,
        ) -> Self {
            self.warmup_status = input;
            self
        }
        /// <p>Indicates how complete the dedicated IP warm-up process is. When this value equals 1,
        /// the address has completed the warm-up process and is ready for use.</p>
        pub fn warmup_percentage(mut self, input: i32) -> Self {
            self.warmup_percentage = Some(input);
            self
        }
        /// <p>Indicates how complete the dedicated IP warm-up process is. When this value equals 1,
        /// the address has completed the warm-up process and is ready for use.</p>
        pub fn set_warmup_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.warmup_percentage = input;
            self
        }
        /// <p>The name of the dedicated IP pool that the IP address is associated with.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool that the IP address is associated with.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DedicatedIp`](crate::model::DedicatedIp)
        pub fn build(self) -> crate::model::DedicatedIp {
            crate::model::DedicatedIp {
                ip: self.ip,
                warmup_status: self.warmup_status,
                warmup_percentage: self.warmup_percentage,
                pool_name: self.pool_name,
            }
        }
    }
}
impl DedicatedIp {
    /// Creates a new builder-style object to manufacture [`DedicatedIp`](crate::model::DedicatedIp)
    pub fn builder() -> crate::model::dedicated_ip::Builder {
        crate::model::dedicated_ip::Builder::default()
    }
}

/// <p>The warmup status of a dedicated IP.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WarmupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Done,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WarmupStatus {
    fn from(s: &str) -> Self {
        match s {
            "DONE" => WarmupStatus::Done,
            "IN_PROGRESS" => WarmupStatus::InProgress,
            other => WarmupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WarmupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WarmupStatus::from(s))
    }
}
impl WarmupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WarmupStatus::Done => "DONE",
            WarmupStatus::InProgress => "IN_PROGRESS",
            WarmupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DONE", "IN_PROGRESS"]
    }
}
impl AsRef<str> for WarmupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In the Amazon SES API v2, <i>events</i> include message sends, deliveries, opens,
/// clicks, bounces, complaints and delivery delays. <i>Event destinations</i>
/// are places that you can send information about these events to. For example, you can
/// send event data to Amazon SNS to receive notifications when you receive bounces or
/// complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestination {
    /// <p>A name that identifies the event destination.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
    /// enabled, the specified event types are sent to the destinations in this
    /// <code>EventDestinationDefinition</code>.</p>
    /// <p>If <code>false</code>, the event destination is disabled. When the event destination
    /// is disabled, events aren't sent to the specified destinations.</p>
    pub enabled: bool,
    /// <p>The types of events that Amazon SES sends to the specified event destinations.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
    /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
    /// monitor and gain insights on your email sending metrics.</p>
    pub cloud_watch_destination: std::option::Option<crate::model::CloudWatchDestination>,
    /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
    /// send notification when certain email events occur.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
    /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
    /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
    /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
    /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    pub pinpoint_destination: std::option::Option<crate::model::PinpointDestination>,
}
impl EventDestination {
    /// <p>A name that identifies the event destination.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
    /// enabled, the specified event types are sent to the destinations in this
    /// <code>EventDestinationDefinition</code>.</p>
    /// <p>If <code>false</code>, the event destination is disabled. When the event destination
    /// is disabled, events aren't sent to the specified destinations.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The types of events that Amazon SES sends to the specified event destinations.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
    /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
    /// monitor and gain insights on your email sending metrics.</p>
    pub fn cloud_watch_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchDestination> {
        self.cloud_watch_destination.as_ref()
    }
    /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
    /// send notification when certain email events occur.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
    /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
    /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
    /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
    /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
    pub fn pinpoint_destination(&self) -> std::option::Option<&crate::model::PinpointDestination> {
        self.pinpoint_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestination");
        formatter.field("name", &self.name);
        formatter.field("enabled", &self.enabled);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("cloud_watch_destination", &self.cloud_watch_destination);
        formatter.field("sns_destination", &self.sns_destination);
        formatter.field("pinpoint_destination", &self.pinpoint_destination);
        formatter.finish()
    }
}
/// See [`EventDestination`](crate::model::EventDestination)
pub mod event_destination {
    /// A builder for [`EventDestination`](crate::model::EventDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) cloud_watch_destination:
            std::option::Option<crate::model::CloudWatchDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
        pub(crate) pinpoint_destination: std::option::Option<crate::model::PinpointDestination>,
    }
    impl Builder {
        /// <p>A name that identifies the event destination.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name that identifies the event destination.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
        /// enabled, the specified event types are sent to the destinations in this
        /// <code>EventDestinationDefinition</code>.</p>
        /// <p>If <code>false</code>, the event destination is disabled. When the event destination
        /// is disabled, events aren't sent to the specified destinations.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, the event destination is enabled. When the event destination is
        /// enabled, the specified event types are sent to the destinations in this
        /// <code>EventDestinationDefinition</code>.</p>
        /// <p>If <code>false</code>, the event destination is disabled. When the event destination
        /// is disabled, events aren't sent to the specified destinations.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>The types of events that Amazon SES sends to the specified event destinations.</p>
        pub fn matching_event_types(mut self, input: impl Into<crate::model::EventType>) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input.into());
            self.matching_event_types = Some(v);
            self
        }
        /// <p>The types of events that Amazon SES sends to the specified event destinations.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
        /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to
        /// stream data to other services, such as Amazon S3 and Amazon Redshift.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
        /// monitor and gain insights on your email sending metrics.</p>
        pub fn cloud_watch_destination(
            mut self,
            input: crate::model::CloudWatchDestination,
        ) -> Self {
            self.cloud_watch_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to
        /// monitor and gain insights on your email sending metrics.</p>
        pub fn set_cloud_watch_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchDestination>,
        ) -> Self {
            self.cloud_watch_destination = input;
            self
        }
        /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
        /// send notification when certain email events occur.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to
        /// send notification when certain email events occur.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
        /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
        /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
        /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
        pub fn pinpoint_destination(mut self, input: crate::model::PinpointDestination) -> Self {
            self.pinpoint_destination = Some(input);
            self
        }
        /// <p>An object that defines an Amazon Pinpoint project destination for email events. You can send
        /// email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging
        /// dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional
        /// Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>
        pub fn set_pinpoint_destination(
            mut self,
            input: std::option::Option<crate::model::PinpointDestination>,
        ) -> Self {
            self.pinpoint_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestination`](crate::model::EventDestination)
        pub fn build(self) -> crate::model::EventDestination {
            crate::model::EventDestination {
                name: self.name,
                enabled: self.enabled.unwrap_or_default(),
                matching_event_types: self.matching_event_types,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                cloud_watch_destination: self.cloud_watch_destination,
                sns_destination: self.sns_destination,
                pinpoint_destination: self.pinpoint_destination,
            }
        }
    }
}
impl EventDestination {
    /// Creates a new builder-style object to manufacture [`EventDestination`](crate::model::EventDestination)
    pub fn builder() -> crate::model::event_destination::Builder {
        crate::model::event_destination::Builder::default()
    }
}

/// <p>An object that contains information about the suppression list preferences for your
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressionOptions {
    /// <p>A list that contains the reasons that email addresses are automatically added to the
    /// suppression list for your account. This list can contain any or all of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a
    /// complaint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a hard
    /// bounce.</p>
    /// </li>
    /// </ul>
    pub suppressed_reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
}
impl SuppressionOptions {
    /// <p>A list that contains the reasons that email addresses are automatically added to the
    /// suppression list for your account. This list can contain any or all of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a
    /// complaint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a hard
    /// bounce.</p>
    /// </li>
    /// </ul>
    pub fn suppressed_reasons(
        &self,
    ) -> std::option::Option<&[crate::model::SuppressionListReason]> {
        self.suppressed_reasons.as_deref()
    }
}
impl std::fmt::Debug for SuppressionOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressionOptions");
        formatter.field("suppressed_reasons", &self.suppressed_reasons);
        formatter.finish()
    }
}
/// See [`SuppressionOptions`](crate::model::SuppressionOptions)
pub mod suppression_options {
    /// A builder for [`SuppressionOptions`](crate::model::SuppressionOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppressed_reasons:
            std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
    }
    impl Builder {
        /// Appends an item to `suppressed_reasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses are automatically added to the
        /// suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn suppressed_reasons(
            mut self,
            input: impl Into<crate::model::SuppressionListReason>,
        ) -> Self {
            let mut v = self.suppressed_reasons.unwrap_or_default();
            v.push(input.into());
            self.suppressed_reasons = Some(v);
            self
        }
        /// <p>A list that contains the reasons that email addresses are automatically added to the
        /// suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.suppressed_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressionOptions`](crate::model::SuppressionOptions)
        pub fn build(self) -> crate::model::SuppressionOptions {
            crate::model::SuppressionOptions {
                suppressed_reasons: self.suppressed_reasons,
            }
        }
    }
}
impl SuppressionOptions {
    /// Creates a new builder-style object to manufacture [`SuppressionOptions`](crate::model::SuppressionOptions)
    pub fn builder() -> crate::model::suppression_options::Builder {
        crate::model::suppression_options::Builder::default()
    }
}

/// <p>Used to enable or disable email sending for messages that use this configuration set
/// in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendingOptions {
    /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
    /// <code>false</code>, email sending is disabled for the configuration set.</p>
    pub sending_enabled: bool,
}
impl SendingOptions {
    /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
    /// <code>false</code>, email sending is disabled for the configuration set.</p>
    pub fn sending_enabled(&self) -> bool {
        self.sending_enabled
    }
}
impl std::fmt::Debug for SendingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendingOptions");
        formatter.field("sending_enabled", &self.sending_enabled);
        formatter.finish()
    }
}
/// See [`SendingOptions`](crate::model::SendingOptions)
pub mod sending_options {
    /// A builder for [`SendingOptions`](crate::model::SendingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sending_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
        /// <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.sending_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
        /// <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sending_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SendingOptions`](crate::model::SendingOptions)
        pub fn build(self) -> crate::model::SendingOptions {
            crate::model::SendingOptions {
                sending_enabled: self.sending_enabled.unwrap_or_default(),
            }
        }
    }
}
impl SendingOptions {
    /// Creates a new builder-style object to manufacture [`SendingOptions`](crate::model::SendingOptions)
    pub fn builder() -> crate::model::sending_options::Builder {
        crate::model::sending_options::Builder::default()
    }
}

/// <p>Enable or disable collection of reputation metrics for emails that you send using this
/// configuration set in the current Amazon Web Services Region. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReputationOptions {
    /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
    /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
    /// configuration set.</p>
    pub reputation_metrics_enabled: bool,
    /// <p>The date and time (in Unix time) when the reputation metrics were last given a fresh
    /// start. When your account is given a fresh start, your reputation metrics are calculated
    /// starting from the date of the fresh start.</p>
    pub last_fresh_start: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReputationOptions {
    /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
    /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
    /// configuration set.</p>
    pub fn reputation_metrics_enabled(&self) -> bool {
        self.reputation_metrics_enabled
    }
    /// <p>The date and time (in Unix time) when the reputation metrics were last given a fresh
    /// start. When your account is given a fresh start, your reputation metrics are calculated
    /// starting from the date of the fresh start.</p>
    pub fn last_fresh_start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_fresh_start.as_ref()
    }
}
impl std::fmt::Debug for ReputationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReputationOptions");
        formatter.field(
            "reputation_metrics_enabled",
            &self.reputation_metrics_enabled,
        );
        formatter.field("last_fresh_start", &self.last_fresh_start);
        formatter.finish()
    }
}
/// See [`ReputationOptions`](crate::model::ReputationOptions)
pub mod reputation_options {
    /// A builder for [`ReputationOptions`](crate::model::ReputationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reputation_metrics_enabled: std::option::Option<bool>,
        pub(crate) last_fresh_start: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
        /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
        /// configuration set.</p>
        pub fn reputation_metrics_enabled(mut self, input: bool) -> Self {
            self.reputation_metrics_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
        /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
        /// configuration set.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.reputation_metrics_enabled = input;
            self
        }
        /// <p>The date and time (in Unix time) when the reputation metrics were last given a fresh
        /// start. When your account is given a fresh start, your reputation metrics are calculated
        /// starting from the date of the fresh start.</p>
        pub fn last_fresh_start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_fresh_start = Some(input);
            self
        }
        /// <p>The date and time (in Unix time) when the reputation metrics were last given a fresh
        /// start. When your account is given a fresh start, your reputation metrics are calculated
        /// starting from the date of the fresh start.</p>
        pub fn set_last_fresh_start(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_fresh_start = input;
            self
        }
        /// Consumes the builder and constructs a [`ReputationOptions`](crate::model::ReputationOptions)
        pub fn build(self) -> crate::model::ReputationOptions {
            crate::model::ReputationOptions {
                reputation_metrics_enabled: self.reputation_metrics_enabled.unwrap_or_default(),
                last_fresh_start: self.last_fresh_start,
            }
        }
    }
}
impl ReputationOptions {
    /// Creates a new builder-style object to manufacture [`ReputationOptions`](crate::model::ReputationOptions)
    pub fn builder() -> crate::model::reputation_options::Builder {
        crate::model::reputation_options::Builder::default()
    }
}

/// <p>Used to associate a configuration set with a dedicated IP pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryOptions {
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
    /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
    /// messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub tls_policy: std::option::Option<crate::model::TlsPolicy>,
    /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
    pub sending_pool_name: std::option::Option<std::string::String>,
}
impl DeliveryOptions {
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
    /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
    /// messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub fn tls_policy(&self) -> std::option::Option<&crate::model::TlsPolicy> {
        self.tls_policy.as_ref()
    }
    /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
    pub fn sending_pool_name(&self) -> std::option::Option<&str> {
        self.sending_pool_name.as_deref()
    }
}
impl std::fmt::Debug for DeliveryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryOptions");
        formatter.field("tls_policy", &self.tls_policy);
        formatter.field("sending_pool_name", &self.sending_pool_name);
        formatter.finish()
    }
}
/// See [`DeliveryOptions`](crate::model::DeliveryOptions)
pub mod delivery_options {
    /// A builder for [`DeliveryOptions`](crate::model::DeliveryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tls_policy: std::option::Option<crate::model::TlsPolicy>,
        pub(crate) sending_pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.tls_policy = Some(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.tls_policy = input;
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn sending_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sending_pool_name = Some(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn set_sending_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sending_pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryOptions`](crate::model::DeliveryOptions)
        pub fn build(self) -> crate::model::DeliveryOptions {
            crate::model::DeliveryOptions {
                tls_policy: self.tls_policy,
                sending_pool_name: self.sending_pool_name,
            }
        }
    }
}
impl DeliveryOptions {
    /// Creates a new builder-style object to manufacture [`DeliveryOptions`](crate::model::DeliveryOptions)
    pub fn builder() -> crate::model::delivery_options::Builder {
        crate::model::delivery_options::Builder::default()
    }
}

/// <p>An object that defines the tracking options for a configuration set. When you use the
/// Amazon SES API v2 to send an email, it contains an invisible image that's used to track when
/// recipients open your email. If your email contains links, those links are changed
/// slightly in order to track when recipients click them.</p>
/// <p>These images and links include references to a domain operated by Amazon Web Services. You can
/// optionally configure the Amazon SES to use a domain that you operate for these images and
/// links.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackingOptions {
    /// <p>The domain to use for tracking open and click events.</p>
    pub custom_redirect_domain: std::option::Option<std::string::String>,
}
impl TrackingOptions {
    /// <p>The domain to use for tracking open and click events.</p>
    pub fn custom_redirect_domain(&self) -> std::option::Option<&str> {
        self.custom_redirect_domain.as_deref()
    }
}
impl std::fmt::Debug for TrackingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackingOptions");
        formatter.field("custom_redirect_domain", &self.custom_redirect_domain);
        formatter.finish()
    }
}
/// See [`TrackingOptions`](crate::model::TrackingOptions)
pub mod tracking_options {
    /// A builder for [`TrackingOptions`](crate::model::TrackingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_redirect_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain to use for tracking open and click events.</p>
        pub fn custom_redirect_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_redirect_domain = Some(input.into());
            self
        }
        /// <p>The domain to use for tracking open and click events.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_redirect_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackingOptions`](crate::model::TrackingOptions)
        pub fn build(self) -> crate::model::TrackingOptions {
            crate::model::TrackingOptions {
                custom_redirect_domain: self.custom_redirect_domain,
            }
        }
    }
}
impl TrackingOptions {
    /// Creates a new builder-style object to manufacture [`TrackingOptions`](crate::model::TrackingOptions)
    pub fn builder() -> crate::model::tracking_options::Builder {
        crate::model::tracking_options::Builder::default()
    }
}

/// <p>An object that contains information about a blacklisting event that impacts one of the
/// dedicated IP addresses that is associated with your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlacklistEntry {
    /// <p>The name of the blacklist that the IP address appears on.</p>
    pub rbl_name: std::option::Option<std::string::String>,
    /// <p>The time when the blacklisting event occurred, shown in Unix time format.</p>
    pub listing_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Additional information about the blacklisting event, as provided by the blacklist
    /// maintainer.</p>
    pub description: std::option::Option<std::string::String>,
}
impl BlacklistEntry {
    /// <p>The name of the blacklist that the IP address appears on.</p>
    pub fn rbl_name(&self) -> std::option::Option<&str> {
        self.rbl_name.as_deref()
    }
    /// <p>The time when the blacklisting event occurred, shown in Unix time format.</p>
    pub fn listing_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.listing_time.as_ref()
    }
    /// <p>Additional information about the blacklisting event, as provided by the blacklist
    /// maintainer.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for BlacklistEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlacklistEntry");
        formatter.field("rbl_name", &self.rbl_name);
        formatter.field("listing_time", &self.listing_time);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`BlacklistEntry`](crate::model::BlacklistEntry)
pub mod blacklist_entry {
    /// A builder for [`BlacklistEntry`](crate::model::BlacklistEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rbl_name: std::option::Option<std::string::String>,
        pub(crate) listing_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the blacklist that the IP address appears on.</p>
        pub fn rbl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rbl_name = Some(input.into());
            self
        }
        /// <p>The name of the blacklist that the IP address appears on.</p>
        pub fn set_rbl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rbl_name = input;
            self
        }
        /// <p>The time when the blacklisting event occurred, shown in Unix time format.</p>
        pub fn listing_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.listing_time = Some(input);
            self
        }
        /// <p>The time when the blacklisting event occurred, shown in Unix time format.</p>
        pub fn set_listing_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.listing_time = input;
            self
        }
        /// <p>Additional information about the blacklisting event, as provided by the blacklist
        /// maintainer.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Additional information about the blacklisting event, as provided by the blacklist
        /// maintainer.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`BlacklistEntry`](crate::model::BlacklistEntry)
        pub fn build(self) -> crate::model::BlacklistEntry {
            crate::model::BlacklistEntry {
                rbl_name: self.rbl_name,
                listing_time: self.listing_time,
                description: self.description,
            }
        }
    }
}
impl BlacklistEntry {
    /// Creates a new builder-style object to manufacture [`BlacklistEntry`](crate::model::BlacklistEntry)
    pub fn builder() -> crate::model::blacklist_entry::Builder {
        crate::model::blacklist_entry::Builder::default()
    }
}

/// <p>An object that contains information about your account details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountDetails {
    /// <p>The type of email your account is sending. The mail type can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MARKETING</code> – Most of your sending traffic is to keep your
    /// customers informed of your latest offering.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRANSACTIONAL</code> – Most of your sending traffic is to
    /// communicate during a transaction with a customer.</p>
    /// </li>
    /// </ul>
    pub mail_type: std::option::Option<crate::model::MailType>,
    /// <p>The URL of your website. This information helps us better understand the type of
    /// content that you plan to send.</p>
    pub website_url: std::option::Option<std::string::String>,
    /// <p>The language you would prefer for the case. The contact language can be one of
    /// <code>ENGLISH</code> or <code>JAPANESE</code>.</p>
    pub contact_language: std::option::Option<crate::model::ContactLanguage>,
    /// <p>A description of the types of email that you plan to send.</p>
    pub use_case_description: std::option::Option<std::string::String>,
    /// <p>Additional email addresses where updates are sent about your account review
    /// process.</p>
    pub additional_contact_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about the review of the latest details you submitted.</p>
    pub review_details: std::option::Option<crate::model::ReviewDetails>,
}
impl AccountDetails {
    /// <p>The type of email your account is sending. The mail type can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>MARKETING</code> – Most of your sending traffic is to keep your
    /// customers informed of your latest offering.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRANSACTIONAL</code> – Most of your sending traffic is to
    /// communicate during a transaction with a customer.</p>
    /// </li>
    /// </ul>
    pub fn mail_type(&self) -> std::option::Option<&crate::model::MailType> {
        self.mail_type.as_ref()
    }
    /// <p>The URL of your website. This information helps us better understand the type of
    /// content that you plan to send.</p>
    pub fn website_url(&self) -> std::option::Option<&str> {
        self.website_url.as_deref()
    }
    /// <p>The language you would prefer for the case. The contact language can be one of
    /// <code>ENGLISH</code> or <code>JAPANESE</code>.</p>
    pub fn contact_language(&self) -> std::option::Option<&crate::model::ContactLanguage> {
        self.contact_language.as_ref()
    }
    /// <p>A description of the types of email that you plan to send.</p>
    pub fn use_case_description(&self) -> std::option::Option<&str> {
        self.use_case_description.as_deref()
    }
    /// <p>Additional email addresses where updates are sent about your account review
    /// process.</p>
    pub fn additional_contact_email_addresses(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.additional_contact_email_addresses.as_deref()
    }
    /// <p>Information about the review of the latest details you submitted.</p>
    pub fn review_details(&self) -> std::option::Option<&crate::model::ReviewDetails> {
        self.review_details.as_ref()
    }
}
impl std::fmt::Debug for AccountDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountDetails");
        formatter.field("mail_type", &self.mail_type);
        formatter.field("website_url", &"*** Sensitive Data Redacted ***");
        formatter.field("contact_language", &self.contact_language);
        formatter.field("use_case_description", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "additional_contact_email_addresses",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("review_details", &self.review_details);
        formatter.finish()
    }
}
/// See [`AccountDetails`](crate::model::AccountDetails)
pub mod account_details {
    /// A builder for [`AccountDetails`](crate::model::AccountDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mail_type: std::option::Option<crate::model::MailType>,
        pub(crate) website_url: std::option::Option<std::string::String>,
        pub(crate) contact_language: std::option::Option<crate::model::ContactLanguage>,
        pub(crate) use_case_description: std::option::Option<std::string::String>,
        pub(crate) additional_contact_email_addresses:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) review_details: std::option::Option<crate::model::ReviewDetails>,
    }
    impl Builder {
        /// <p>The type of email your account is sending. The mail type can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MARKETING</code> – Most of your sending traffic is to keep your
        /// customers informed of your latest offering.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRANSACTIONAL</code> – Most of your sending traffic is to
        /// communicate during a transaction with a customer.</p>
        /// </li>
        /// </ul>
        pub fn mail_type(mut self, input: crate::model::MailType) -> Self {
            self.mail_type = Some(input);
            self
        }
        /// <p>The type of email your account is sending. The mail type can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>MARKETING</code> – Most of your sending traffic is to keep your
        /// customers informed of your latest offering.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRANSACTIONAL</code> – Most of your sending traffic is to
        /// communicate during a transaction with a customer.</p>
        /// </li>
        /// </ul>
        pub fn set_mail_type(mut self, input: std::option::Option<crate::model::MailType>) -> Self {
            self.mail_type = input;
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of
        /// content that you plan to send.</p>
        pub fn website_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_url = Some(input.into());
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of
        /// content that you plan to send.</p>
        pub fn set_website_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.website_url = input;
            self
        }
        /// <p>The language you would prefer for the case. The contact language can be one of
        /// <code>ENGLISH</code> or <code>JAPANESE</code>.</p>
        pub fn contact_language(mut self, input: crate::model::ContactLanguage) -> Self {
            self.contact_language = Some(input);
            self
        }
        /// <p>The language you would prefer for the case. The contact language can be one of
        /// <code>ENGLISH</code> or <code>JAPANESE</code>.</p>
        pub fn set_contact_language(
            mut self,
            input: std::option::Option<crate::model::ContactLanguage>,
        ) -> Self {
            self.contact_language = input;
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn use_case_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_case_description = Some(input.into());
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn set_use_case_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.use_case_description = input;
            self
        }
        /// Appends an item to `additional_contact_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_additional_contact_email_addresses`](Self::set_additional_contact_email_addresses).
        ///
        /// <p>Additional email addresses where updates are sent about your account review
        /// process.</p>
        pub fn additional_contact_email_addresses(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_contact_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.additional_contact_email_addresses = Some(v);
            self
        }
        /// <p>Additional email addresses where updates are sent about your account review
        /// process.</p>
        pub fn set_additional_contact_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_contact_email_addresses = input;
            self
        }
        /// <p>Information about the review of the latest details you submitted.</p>
        pub fn review_details(mut self, input: crate::model::ReviewDetails) -> Self {
            self.review_details = Some(input);
            self
        }
        /// <p>Information about the review of the latest details you submitted.</p>
        pub fn set_review_details(
            mut self,
            input: std::option::Option<crate::model::ReviewDetails>,
        ) -> Self {
            self.review_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountDetails`](crate::model::AccountDetails)
        pub fn build(self) -> crate::model::AccountDetails {
            crate::model::AccountDetails {
                mail_type: self.mail_type,
                website_url: self.website_url,
                contact_language: self.contact_language,
                use_case_description: self.use_case_description,
                additional_contact_email_addresses: self.additional_contact_email_addresses,
                review_details: self.review_details,
            }
        }
    }
}
impl AccountDetails {
    /// Creates a new builder-style object to manufacture [`AccountDetails`](crate::model::AccountDetails)
    pub fn builder() -> crate::model::account_details::Builder {
        crate::model::account_details::Builder::default()
    }
}

/// <p>An object that contains information about your account details review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewDetails {
    /// <p>The status of the latest review of your account. The status can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – We have received your appeal and are in the
    /// process of reviewing it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GRANTED</code> – Your appeal has been reviewed and your production
    /// access has been granted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DENIED</code> – Your appeal has been reviewed and your production
    /// access has been denied.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – An internal error occurred and we didn't receive
    /// your appeal. You can submit your appeal again.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ReviewStatus>,
    /// <p>The associated support center case ID (if any).</p>
    pub case_id: std::option::Option<std::string::String>,
}
impl ReviewDetails {
    /// <p>The status of the latest review of your account. The status can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> – We have received your appeal and are in the
    /// process of reviewing it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GRANTED</code> – Your appeal has been reviewed and your production
    /// access has been granted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DENIED</code> – Your appeal has been reviewed and your production
    /// access has been denied.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> – An internal error occurred and we didn't receive
    /// your appeal. You can submit your appeal again.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ReviewStatus> {
        self.status.as_ref()
    }
    /// <p>The associated support center case ID (if any).</p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
}
impl std::fmt::Debug for ReviewDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewDetails");
        formatter.field("status", &self.status);
        formatter.field("case_id", &self.case_id);
        formatter.finish()
    }
}
/// See [`ReviewDetails`](crate::model::ReviewDetails)
pub mod review_details {
    /// A builder for [`ReviewDetails`](crate::model::ReviewDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ReviewStatus>,
        pub(crate) case_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the latest review of your account. The status can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – We have received your appeal and are in the
        /// process of reviewing it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GRANTED</code> – Your appeal has been reviewed and your production
        /// access has been granted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DENIED</code> – Your appeal has been reviewed and your production
        /// access has been denied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – An internal error occurred and we didn't receive
        /// your appeal. You can submit your appeal again.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the latest review of your account. The status can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> – We have received your appeal and are in the
        /// process of reviewing it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GRANTED</code> – Your appeal has been reviewed and your production
        /// access has been granted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DENIED</code> – Your appeal has been reviewed and your production
        /// access has been denied.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> – An internal error occurred and we didn't receive
        /// your appeal. You can submit your appeal again.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The associated support center case ID (if any).</p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The associated support center case ID (if any).</p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewDetails`](crate::model::ReviewDetails)
        pub fn build(self) -> crate::model::ReviewDetails {
            crate::model::ReviewDetails {
                status: self.status,
                case_id: self.case_id,
            }
        }
    }
}
impl ReviewDetails {
    /// Creates a new builder-style object to manufacture [`ReviewDetails`](crate::model::ReviewDetails)
    pub fn builder() -> crate::model::review_details::Builder {
        crate::model::review_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReviewStatus {
    #[allow(missing_docs)] // documentation missing in model
    Denied,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Granted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReviewStatus {
    fn from(s: &str) -> Self {
        match s {
            "DENIED" => ReviewStatus::Denied,
            "FAILED" => ReviewStatus::Failed,
            "GRANTED" => ReviewStatus::Granted,
            "PENDING" => ReviewStatus::Pending,
            other => ReviewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReviewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReviewStatus::from(s))
    }
}
impl ReviewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReviewStatus::Denied => "DENIED",
            ReviewStatus::Failed => "FAILED",
            ReviewStatus::Granted => "GRANTED",
            ReviewStatus::Pending => "PENDING",
            ReviewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DENIED", "FAILED", "GRANTED", "PENDING"]
    }
}
impl AsRef<str> for ReviewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about the email address suppression preferences
/// for your account in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuppressionAttributes {
    /// <p>A list that contains the reasons that email addresses will be automatically added to
    /// the suppression list for your account. This list can contain any or all of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a
    /// complaint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a hard
    /// bounce.</p>
    /// </li>
    /// </ul>
    pub suppressed_reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
}
impl SuppressionAttributes {
    /// <p>A list that contains the reasons that email addresses will be automatically added to
    /// the suppression list for your account. This list can contain any or all of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a
    /// complaint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
    /// list for your account when a message sent to that address results in a hard
    /// bounce.</p>
    /// </li>
    /// </ul>
    pub fn suppressed_reasons(
        &self,
    ) -> std::option::Option<&[crate::model::SuppressionListReason]> {
        self.suppressed_reasons.as_deref()
    }
}
impl std::fmt::Debug for SuppressionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuppressionAttributes");
        formatter.field("suppressed_reasons", &self.suppressed_reasons);
        formatter.finish()
    }
}
/// See [`SuppressionAttributes`](crate::model::SuppressionAttributes)
pub mod suppression_attributes {
    /// A builder for [`SuppressionAttributes`](crate::model::SuppressionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppressed_reasons:
            std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
    }
    impl Builder {
        /// Appends an item to `suppressed_reasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses will be automatically added to
        /// the suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn suppressed_reasons(
            mut self,
            input: impl Into<crate::model::SuppressionListReason>,
        ) -> Self {
            let mut v = self.suppressed_reasons.unwrap_or_default();
            v.push(input.into());
            self.suppressed_reasons = Some(v);
            self
        }
        /// <p>A list that contains the reasons that email addresses will be automatically added to
        /// the suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.suppressed_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`SuppressionAttributes`](crate::model::SuppressionAttributes)
        pub fn build(self) -> crate::model::SuppressionAttributes {
            crate::model::SuppressionAttributes {
                suppressed_reasons: self.suppressed_reasons,
            }
        }
    }
}
impl SuppressionAttributes {
    /// Creates a new builder-style object to manufacture [`SuppressionAttributes`](crate::model::SuppressionAttributes)
    pub fn builder() -> crate::model::suppression_attributes::Builder {
        crate::model::suppression_attributes::Builder::default()
    }
}

/// <p>An object that contains information about the per-day and per-second sending limits
/// for your Amazon SES account in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendQuota {
    /// <p>The maximum number of emails that you can send in the current Amazon Web Services Region over a
    /// 24-hour period. This value is also called your <i>sending
    /// quota</i>.</p>
    pub max24_hour_send: f64,
    /// <p>The maximum number of emails that you can send per second in the current Amazon Web Services Region.
    /// This value is also called your <i>maximum sending rate</i> or your
    /// <i>maximum TPS (transactions per second) rate</i>.</p>
    pub max_send_rate: f64,
    /// <p>The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the
    /// past 24 hours.</p>
    pub sent_last24_hours: f64,
}
impl SendQuota {
    /// <p>The maximum number of emails that you can send in the current Amazon Web Services Region over a
    /// 24-hour period. This value is also called your <i>sending
    /// quota</i>.</p>
    pub fn max24_hour_send(&self) -> f64 {
        self.max24_hour_send
    }
    /// <p>The maximum number of emails that you can send per second in the current Amazon Web Services Region.
    /// This value is also called your <i>maximum sending rate</i> or your
    /// <i>maximum TPS (transactions per second) rate</i>.</p>
    pub fn max_send_rate(&self) -> f64 {
        self.max_send_rate
    }
    /// <p>The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the
    /// past 24 hours.</p>
    pub fn sent_last24_hours(&self) -> f64 {
        self.sent_last24_hours
    }
}
impl std::fmt::Debug for SendQuota {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendQuota");
        formatter.field("max24_hour_send", &self.max24_hour_send);
        formatter.field("max_send_rate", &self.max_send_rate);
        formatter.field("sent_last24_hours", &self.sent_last24_hours);
        formatter.finish()
    }
}
/// See [`SendQuota`](crate::model::SendQuota)
pub mod send_quota {
    /// A builder for [`SendQuota`](crate::model::SendQuota)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max24_hour_send: std::option::Option<f64>,
        pub(crate) max_send_rate: std::option::Option<f64>,
        pub(crate) sent_last24_hours: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum number of emails that you can send in the current Amazon Web Services Region over a
        /// 24-hour period. This value is also called your <i>sending
        /// quota</i>.</p>
        pub fn max24_hour_send(mut self, input: f64) -> Self {
            self.max24_hour_send = Some(input);
            self
        }
        /// <p>The maximum number of emails that you can send in the current Amazon Web Services Region over a
        /// 24-hour period. This value is also called your <i>sending
        /// quota</i>.</p>
        pub fn set_max24_hour_send(mut self, input: std::option::Option<f64>) -> Self {
            self.max24_hour_send = input;
            self
        }
        /// <p>The maximum number of emails that you can send per second in the current Amazon Web Services Region.
        /// This value is also called your <i>maximum sending rate</i> or your
        /// <i>maximum TPS (transactions per second) rate</i>.</p>
        pub fn max_send_rate(mut self, input: f64) -> Self {
            self.max_send_rate = Some(input);
            self
        }
        /// <p>The maximum number of emails that you can send per second in the current Amazon Web Services Region.
        /// This value is also called your <i>maximum sending rate</i> or your
        /// <i>maximum TPS (transactions per second) rate</i>.</p>
        pub fn set_max_send_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.max_send_rate = input;
            self
        }
        /// <p>The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the
        /// past 24 hours.</p>
        pub fn sent_last24_hours(mut self, input: f64) -> Self {
            self.sent_last24_hours = Some(input);
            self
        }
        /// <p>The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the
        /// past 24 hours.</p>
        pub fn set_sent_last24_hours(mut self, input: std::option::Option<f64>) -> Self {
            self.sent_last24_hours = input;
            self
        }
        /// Consumes the builder and constructs a [`SendQuota`](crate::model::SendQuota)
        pub fn build(self) -> crate::model::SendQuota {
            crate::model::SendQuota {
                max24_hour_send: self.max24_hour_send.unwrap_or_default(),
                max_send_rate: self.max_send_rate.unwrap_or_default(),
                sent_last24_hours: self.sent_last24_hours.unwrap_or_default(),
            }
        }
    }
}
impl SendQuota {
    /// Creates a new builder-style object to manufacture [`SendQuota`](crate::model::SendQuota)
    pub fn builder() -> crate::model::send_quota::Builder {
        crate::model::send_quota::Builder::default()
    }
}
