// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
pub mod create_configuration_set_input {
    /// A builder for [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tracking_options: std::option::Option<crate::model::TrackingOptions>,
        pub(crate) delivery_options: std::option::Option<crate::model::DeliveryOptions>,
        pub(crate) reputation_options: std::option::Option<crate::model::ReputationOptions>,
        pub(crate) sending_options: std::option::Option<crate::model::SendingOptions>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) suppression_options: std::option::Option<crate::model::SuppressionOptions>,
    }
    impl Builder {
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.tracking_options = Some(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.tracking_options = input;
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.delivery_options = Some(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.delivery_options = input;
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn reputation_options(mut self, input: crate::model::ReputationOptions) -> Self {
            self.reputation_options = Some(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
        pub fn set_reputation_options(
            mut self,
            input: std::option::Option<crate::model::ReputationOptions>,
        ) -> Self {
            self.reputation_options = input;
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
        pub fn sending_options(mut self, input: crate::model::SendingOptions) -> Self {
            self.sending_options = Some(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
        pub fn set_sending_options(
            mut self,
            input: std::option::Option<crate::model::SendingOptions>,
        ) -> Self {
            self.sending_options = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your account.</p>
        pub fn suppression_options(mut self, input: crate::model::SuppressionOptions) -> Self {
            self.suppression_options = Some(input);
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your account.</p>
        pub fn set_suppression_options(
            mut self,
            input: std::option::Option<crate::model::SuppressionOptions>,
        ) -> Self {
            self.suppression_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
                tracking_options: self.tracking_options,
                delivery_options: self.delivery_options,
                reputation_options: self.reputation_options,
                sending_options: self.sending_options,
                tags: self.tags,
                suppression_options: self.suppression_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationOutputAlias = crate::operation::CreateConfigurationSet;
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSet`](crate::operation::CreateConfigurationSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateConfigurationSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/configuration-sets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateConfigurationSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSet",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
pub mod create_configuration_set_event_destination_input {
    /// A builder for [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
    }
    impl Builder {
        /// <p>The name of the configuration set .</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set .</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                event_destination: self.event_destination,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::CreateConfigurationSetEventDestination;
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSetEventDestination`](crate::operation::CreateConfigurationSetEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSetEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateConfigurationSetEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.configuration_set_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_1, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateConfigurationSetEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set_event_destination(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSetEventDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::create_configuration_set_event_destination_input::Builder {
        crate::input::create_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`CreateContactInput`](crate::input::CreateContactInput)
pub mod create_contact_input {
    /// A builder for [`CreateContactInput`](crate::input::CreateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) topic_preferences:
            std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        pub(crate) unsubscribe_all: std::option::Option<bool>,
        pub(crate) attributes_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Appends an item to `topic_preferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn topic_preferences(mut self, input: crate::model::TopicPreference) -> Self {
            let mut v = self.topic_preferences.unwrap_or_default();
            v.push(input);
            self.topic_preferences = Some(v);
            self
        }
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.topic_preferences = input;
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn unsubscribe_all(mut self, input: bool) -> Self {
            self.unsubscribe_all = Some(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.unsubscribe_all = input;
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.attributes_data = Some(input.into());
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attributes_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactInput`](crate::input::CreateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactInput {
                contact_list_name: self.contact_list_name,
                email_address: self.email_address,
                topic_preferences: self.topic_preferences,
                unsubscribe_all: self.unsubscribe_all.unwrap_or_default(),
                attributes_data: self.attributes_data,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactInputOperationOutputAlias = crate::operation::CreateContact;
#[doc(hidden)]
pub type CreateContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactInput {
    /// Consumes the builder and constructs an Operation<[`CreateContact`](crate::operation::CreateContact)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContactInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.contact_list_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_2, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}/contacts",
                    ContactListName = contact_list_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContactInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_contact(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContact",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContactInput`](crate::input::CreateContactInput)
    pub fn builder() -> crate::input::create_contact_input::Builder {
        crate::input::create_contact_input::Builder::default()
    }
}

/// See [`CreateContactListInput`](crate::input::CreateContactListInput)
pub mod create_contact_list_input {
    /// A builder for [`CreateContactListInput`](crate::input::CreateContactListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) topics: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn topics(mut self, input: crate::model::Topic) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input);
            self.topics = Some(v);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a contact list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with a contact list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactListInput`](crate::input::CreateContactListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactListInput {
                contact_list_name: self.contact_list_name,
                topics: self.topics,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactListInputOperationOutputAlias = crate::operation::CreateContactList;
#[doc(hidden)]
pub type CreateContactListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactListInput {
    /// Consumes the builder and constructs an Operation<[`CreateContactList`](crate::operation::CreateContactList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContactList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContactListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/contact-lists").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContactListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_contact_list(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContactList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContactList",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContactListInput`](crate::input::CreateContactListInput)
    pub fn builder() -> crate::input::create_contact_list_input::Builder {
        crate::input::create_contact_list_input::Builder::default()
    }
}

/// See [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
pub mod create_custom_verification_email_template_input {
    /// A builder for [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_content = Some(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                template_content: self.template_content,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::CreateCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type CreateCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomVerificationEmailTemplate`](crate::operation::CreateCustomVerificationEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomVerificationEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomVerificationEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/custom-verification-email-templates")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomVerificationEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_verification_email_template(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomVerificationEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::create_custom_verification_email_template_input::Builder {
        crate::input::create_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`CreateDedicatedIpPoolInput`](crate::input::CreateDedicatedIpPoolInput)
pub mod create_dedicated_ip_pool_input {
    /// A builder for [`CreateDedicatedIpPoolInput`](crate::input::CreateDedicatedIpPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the dedicated IP pool.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDedicatedIpPoolInput`](crate::input::CreateDedicatedIpPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDedicatedIpPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDedicatedIpPoolInput {
                pool_name: self.pool_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDedicatedIpPoolInputOperationOutputAlias = crate::operation::CreateDedicatedIpPool;
#[doc(hidden)]
pub type CreateDedicatedIpPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDedicatedIpPoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateDedicatedIpPool`](crate::operation::CreateDedicatedIpPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDedicatedIpPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDedicatedIpPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/dedicated-ip-pools").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDedicatedIpPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dedicated_ip_pool(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDedicatedIpPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDedicatedIpPool",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDedicatedIpPoolInput`](crate::input::CreateDedicatedIpPoolInput)
    pub fn builder() -> crate::input::create_dedicated_ip_pool_input::Builder {
        crate::input::create_dedicated_ip_pool_input::Builder::default()
    }
}

/// See [`CreateDeliverabilityTestReportInput`](crate::input::CreateDeliverabilityTestReportInput)
pub mod create_deliverability_test_report_input {
    /// A builder for [`CreateDeliverabilityTestReportInput`](crate::input::CreateDeliverabilityTestReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::EmailContent>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn report_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_name = Some(input.into());
            self
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
        pub fn set_report_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_name = input;
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeliverabilityTestReportInput`](crate::input::CreateDeliverabilityTestReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeliverabilityTestReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeliverabilityTestReportInput {
                report_name: self.report_name,
                from_email_address: self.from_email_address,
                content: self.content,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeliverabilityTestReportInputOperationOutputAlias =
    crate::operation::CreateDeliverabilityTestReport;
#[doc(hidden)]
pub type CreateDeliverabilityTestReportInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeliverabilityTestReportInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeliverabilityTestReport`](crate::operation::CreateDeliverabilityTestReport)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeliverabilityTestReport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDeliverabilityTestReportInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/deliverability-dashboard/test")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDeliverabilityTestReportInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deliverability_test_report(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeliverabilityTestReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeliverabilityTestReport",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDeliverabilityTestReportInput`](crate::input::CreateDeliverabilityTestReportInput)
    pub fn builder() -> crate::input::create_deliverability_test_report_input::Builder {
        crate::input::create_deliverability_test_report_input::Builder::default()
    }
}

/// See [`CreateEmailIdentityInput`](crate::input::CreateEmailIdentityInput)
pub mod create_email_identity_input {
    /// A builder for [`CreateEmailIdentityInput`](crate::input::CreateEmailIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) dkim_signing_attributes:
            std::option::Option<crate::model::DkimSigningAttributes>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address or domain to verify.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email address or domain to verify.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
        pub fn dkim_signing_attributes(
            mut self,
            input: crate::model::DkimSigningAttributes,
        ) -> Self {
            self.dkim_signing_attributes = Some(input);
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
        pub fn set_dkim_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.dkim_signing_attributes = input;
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEmailIdentityInput`](crate::input::CreateEmailIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEmailIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEmailIdentityInput {
                email_identity: self.email_identity,
                tags: self.tags,
                dkim_signing_attributes: self.dkim_signing_attributes,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEmailIdentityInputOperationOutputAlias = crate::operation::CreateEmailIdentity;
#[doc(hidden)]
pub type CreateEmailIdentityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEmailIdentityInput {
    /// Consumes the builder and constructs an Operation<[`CreateEmailIdentity`](crate::operation::CreateEmailIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEmailIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEmailIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/identities").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEmailIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_email_identity(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEmailIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEmailIdentity",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEmailIdentityInput`](crate::input::CreateEmailIdentityInput)
    pub fn builder() -> crate::input::create_email_identity_input::Builder {
        crate::input::create_email_identity_input::Builder::default()
    }
}

/// See [`CreateEmailIdentityPolicyInput`](crate::input::CreateEmailIdentityPolicyInput)
pub mod create_email_identity_policy_input {
    /// A builder for [`CreateEmailIdentityPolicyInput`](crate::input::CreateEmailIdentityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEmailIdentityPolicyInput`](crate::input::CreateEmailIdentityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEmailIdentityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEmailIdentityPolicyInput {
                email_identity: self.email_identity,
                policy_name: self.policy_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEmailIdentityPolicyInputOperationOutputAlias =
    crate::operation::CreateEmailIdentityPolicy;
#[doc(hidden)]
pub type CreateEmailIdentityPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEmailIdentityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateEmailIdentityPolicy`](crate::operation::CreateEmailIdentityPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEmailIdentityPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEmailIdentityPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.email_identity;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_3, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                let input_4 = &_input.policy_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_4, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
                    EmailIdentity = email_identity,
                    PolicyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEmailIdentityPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_email_identity_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEmailIdentityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEmailIdentityPolicy",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEmailIdentityPolicyInput`](crate::input::CreateEmailIdentityPolicyInput)
    pub fn builder() -> crate::input::create_email_identity_policy_input::Builder {
        crate::input::create_email_identity_policy_input::Builder::default()
    }
}

/// See [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
pub mod create_email_template_input {
    /// A builder for [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<crate::model::EmailTemplateContent>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template_content(mut self, input: crate::model::EmailTemplateContent) -> Self {
            self.template_content = Some(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEmailTemplateInput {
                template_name: self.template_name,
                template_content: self.template_content,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEmailTemplateInputOperationOutputAlias = crate::operation::CreateEmailTemplate;
#[doc(hidden)]
pub type CreateEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateEmailTemplate`](crate::operation::CreateEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/templates").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_email_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEmailTemplateInput`](crate::input::CreateEmailTemplateInput)
    pub fn builder() -> crate::input::create_email_template_input::Builder {
        crate::input::create_email_template_input::Builder::default()
    }
}

/// See [`CreateImportJobInput`](crate::input::CreateImportJobInput)
pub mod create_import_job_input {
    /// A builder for [`CreateImportJobInput`](crate::input::CreateImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_destination: std::option::Option<crate::model::ImportDestination>,
        pub(crate) import_data_source: std::option::Option<crate::model::ImportDataSource>,
    }
    impl Builder {
        /// <p>The destination for the import job.</p>
        pub fn import_destination(mut self, input: crate::model::ImportDestination) -> Self {
            self.import_destination = Some(input);
            self
        }
        /// <p>The destination for the import job.</p>
        pub fn set_import_destination(
            mut self,
            input: std::option::Option<crate::model::ImportDestination>,
        ) -> Self {
            self.import_destination = input;
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn import_data_source(mut self, input: crate::model::ImportDataSource) -> Self {
            self.import_data_source = Some(input);
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn set_import_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.import_data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImportJobInput`](crate::input::CreateImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImportJobInput {
                import_destination: self.import_destination,
                import_data_source: self.import_data_source,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImportJobInputOperationOutputAlias = crate::operation::CreateImportJob;
#[doc(hidden)]
pub type CreateImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateImportJob`](crate::operation::CreateImportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/import-jobs").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_import_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImportJob",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImportJobInput`](crate::input::CreateImportJobInput)
    pub fn builder() -> crate::input::create_import_job_input::Builder {
        crate::input::create_import_job_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
pub mod delete_configuration_set_input {
    /// A builder for [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationOutputAlias = crate::operation::DeleteConfigurationSet;
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSet`](crate::operation::DeleteConfigurationSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.configuration_set_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_5, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSet",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
pub mod delete_configuration_set_event_destination_input {
    /// A builder for [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set that contains the event destination to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::DeleteConfigurationSetEventDestination;
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSetEventDestination`](crate::operation::DeleteConfigurationSetEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSetEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteConfigurationSetEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.configuration_set_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_6, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_7 = &_input.event_destination_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let event_destination_name = aws_smithy_http::label::fmt_string(input_7, false);
                if event_destination_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}", ConfigurationSetName = configuration_set_name, EventDestinationName = event_destination_name).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteConfigurationSetEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSetEventDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::delete_configuration_set_event_destination_input::Builder {
        crate::input::delete_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`DeleteContactInput`](crate::input::DeleteContactInput)
pub mod delete_contact_input {
    /// A builder for [`DeleteContactInput`](crate::input::DeleteContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactInput`](crate::input::DeleteContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactInput {
                contact_list_name: self.contact_list_name,
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactInputOperationOutputAlias = crate::operation::DeleteContact;
#[doc(hidden)]
pub type DeleteContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContact`](crate::operation::DeleteContact)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContactInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.contact_list_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_8, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.email_address;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_address = aws_smithy_http::label::fmt_string(input_9, false);
                if email_address.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
                    ContactListName = contact_list_name,
                    EmailAddress = email_address
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContactInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContact",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactInput`](crate::input::DeleteContactInput)
    pub fn builder() -> crate::input::delete_contact_input::Builder {
        crate::input::delete_contact_input::Builder::default()
    }
}

/// See [`DeleteContactListInput`](crate::input::DeleteContactListInput)
pub mod delete_contact_list_input {
    /// A builder for [`DeleteContactListInput`](crate::input::DeleteContactListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactListInput`](crate::input::DeleteContactListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactListInput {
                contact_list_name: self.contact_list_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactListInputOperationOutputAlias = crate::operation::DeleteContactList;
#[doc(hidden)]
pub type DeleteContactListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactListInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContactList`](crate::operation::DeleteContactList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContactList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContactListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.contact_list_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_10, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}",
                    ContactListName = contact_list_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContactListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContactList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContactList",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactListInput`](crate::input::DeleteContactListInput)
    pub fn builder() -> crate::input::delete_contact_list_input::Builder {
        crate::input::delete_contact_list_input::Builder::default()
    }
}

/// See [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
pub mod delete_custom_verification_email_template_input {
    /// A builder for [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::DeleteCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type DeleteCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomVerificationEmailTemplate`](crate::operation::DeleteCustomVerificationEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomVerificationEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomVerificationEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.template_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_11, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/custom-verification-email-templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomVerificationEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomVerificationEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::delete_custom_verification_email_template_input::Builder {
        crate::input::delete_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`DeleteDedicatedIpPoolInput`](crate::input::DeleteDedicatedIpPoolInput)
pub mod delete_dedicated_ip_pool_input {
    /// A builder for [`DeleteDedicatedIpPoolInput`](crate::input::DeleteDedicatedIpPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDedicatedIpPoolInput`](crate::input::DeleteDedicatedIpPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDedicatedIpPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDedicatedIpPoolInput {
                pool_name: self.pool_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDedicatedIpPoolInputOperationOutputAlias = crate::operation::DeleteDedicatedIpPool;
#[doc(hidden)]
pub type DeleteDedicatedIpPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDedicatedIpPoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDedicatedIpPool`](crate::operation::DeleteDedicatedIpPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDedicatedIpPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDedicatedIpPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.pool_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "pool_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let pool_name = aws_smithy_http::label::fmt_string(input_12, false);
                if pool_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "pool_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/dedicated-ip-pools/{PoolName}",
                    PoolName = pool_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDedicatedIpPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDedicatedIpPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDedicatedIpPool",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDedicatedIpPoolInput`](crate::input::DeleteDedicatedIpPoolInput)
    pub fn builder() -> crate::input::delete_dedicated_ip_pool_input::Builder {
        crate::input::delete_dedicated_ip_pool_input::Builder::default()
    }
}

/// See [`DeleteEmailIdentityInput`](crate::input::DeleteEmailIdentityInput)
pub mod delete_email_identity_input {
    /// A builder for [`DeleteEmailIdentityInput`](crate::input::DeleteEmailIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailIdentityInput`](crate::input::DeleteEmailIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailIdentityInput {
                email_identity: self.email_identity,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailIdentityInputOperationOutputAlias = crate::operation::DeleteEmailIdentity;
#[doc(hidden)]
pub type DeleteEmailIdentityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailIdentityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailIdentity`](crate::operation::DeleteEmailIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.email_identity;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_13, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailIdentity",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailIdentityInput`](crate::input::DeleteEmailIdentityInput)
    pub fn builder() -> crate::input::delete_email_identity_input::Builder {
        crate::input::delete_email_identity_input::Builder::default()
    }
}

/// See [`DeleteEmailIdentityPolicyInput`](crate::input::DeleteEmailIdentityPolicyInput)
pub mod delete_email_identity_policy_input {
    /// A builder for [`DeleteEmailIdentityPolicyInput`](crate::input::DeleteEmailIdentityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailIdentityPolicyInput`](crate::input::DeleteEmailIdentityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailIdentityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailIdentityPolicyInput {
                email_identity: self.email_identity,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailIdentityPolicyInputOperationOutputAlias =
    crate::operation::DeleteEmailIdentityPolicy;
#[doc(hidden)]
pub type DeleteEmailIdentityPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailIdentityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailIdentityPolicy`](crate::operation::DeleteEmailIdentityPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailIdentityPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailIdentityPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.email_identity;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_14, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.policy_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_15, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
                    EmailIdentity = email_identity,
                    PolicyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailIdentityPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailIdentityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailIdentityPolicy",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailIdentityPolicyInput`](crate::input::DeleteEmailIdentityPolicyInput)
    pub fn builder() -> crate::input::delete_email_identity_policy_input::Builder {
        crate::input::delete_email_identity_policy_input::Builder::default()
    }
}

/// See [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
pub mod delete_email_template_input {
    /// A builder for [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEmailTemplateInputOperationOutputAlias = crate::operation::DeleteEmailTemplate;
#[doc(hidden)]
pub type DeleteEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEmailTemplate`](crate::operation::DeleteEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.template_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_16, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEmailTemplateInput`](crate::input::DeleteEmailTemplateInput)
    pub fn builder() -> crate::input::delete_email_template_input::Builder {
        crate::input::delete_email_template_input::Builder::default()
    }
}

/// See [`DeleteSuppressedDestinationInput`](crate::input::DeleteSuppressedDestinationInput)
pub mod delete_suppressed_destination_input {
    /// A builder for [`DeleteSuppressedDestinationInput`](crate::input::DeleteSuppressedDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSuppressedDestinationInput`](crate::input::DeleteSuppressedDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSuppressedDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSuppressedDestinationInput {
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSuppressedDestinationInputOperationOutputAlias =
    crate::operation::DeleteSuppressedDestination;
#[doc(hidden)]
pub type DeleteSuppressedDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSuppressedDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSuppressedDestination`](crate::operation::DeleteSuppressedDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSuppressedDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSuppressedDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.email_address;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_address = aws_smithy_http::label::fmt_string(input_17, false);
                if email_address.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/suppression/addresses/{EmailAddress}",
                    EmailAddress = email_address
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSuppressedDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSuppressedDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSuppressedDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSuppressedDestinationInput`](crate::input::DeleteSuppressedDestinationInput)
    pub fn builder() -> crate::input::delete_suppressed_destination_input::Builder {
        crate::input::delete_suppressed_destination_input::Builder::default()
    }
}

/// See [`GetAccountInput`](crate::input::GetAccountInput)
pub mod get_account_input {
    /// A builder for [`GetAccountInput`](crate::input::GetAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountInput`](crate::input::GetAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountInputOperationOutputAlias = crate::operation::GetAccount;
#[doc(hidden)]
pub type GetAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetAccount`](crate::operation::GetAccount)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAccountInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/account").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAccountInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccount",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAccountInput`](crate::input::GetAccountInput)
    pub fn builder() -> crate::input::get_account_input::Builder {
        crate::input::get_account_input::Builder::default()
    }
}

/// See [`GetBlacklistReportsInput`](crate::input::GetBlacklistReportsInput)
pub mod get_blacklist_reports_input {
    /// A builder for [`GetBlacklistReportsInput`](crate::input::GetBlacklistReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blacklist_item_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `blacklist_item_names`.
        ///
        /// To override the contents of this collection use [`set_blacklist_item_names`](Self::set_blacklist_item_names).
        ///
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
        pub fn blacklist_item_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.blacklist_item_names.unwrap_or_default();
            v.push(input.into());
            self.blacklist_item_names = Some(v);
            self
        }
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
        pub fn set_blacklist_item_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.blacklist_item_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlacklistReportsInput`](crate::input::GetBlacklistReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBlacklistReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBlacklistReportsInput {
                blacklist_item_names: self.blacklist_item_names,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBlacklistReportsInputOperationOutputAlias = crate::operation::GetBlacklistReports;
#[doc(hidden)]
pub type GetBlacklistReportsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBlacklistReportsInput {
    /// Consumes the builder and constructs an Operation<[`GetBlacklistReports`](crate::operation::GetBlacklistReports)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBlacklistReports,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBlacklistReportsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(
                    output,
                    "/v2/email/deliverability-dashboard/blacklist-report"
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBlacklistReportsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.blacklist_item_names {
                    for inner_19 in inner_18 {
                        query.push_kv(
                            "BlacklistItemNames",
                            &aws_smithy_http::query::fmt_string(&inner_19),
                        );
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBlacklistReportsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBlacklistReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBlacklistReports",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBlacklistReportsInput`](crate::input::GetBlacklistReportsInput)
    pub fn builder() -> crate::input::get_blacklist_reports_input::Builder {
        crate::input::get_blacklist_reports_input::Builder::default()
    }
}

/// See [`GetConfigurationSetInput`](crate::input::GetConfigurationSetInput)
pub mod get_configuration_set_input {
    /// A builder for [`GetConfigurationSetInput`](crate::input::GetConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationSetInput`](crate::input::GetConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigurationSetInputOperationOutputAlias = crate::operation::GetConfigurationSet;
#[doc(hidden)]
pub type GetConfigurationSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`GetConfigurationSet`](crate::operation::GetConfigurationSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfigurationSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetConfigurationSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.configuration_set_name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_20, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetConfigurationSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConfigurationSet",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetConfigurationSetInput`](crate::input::GetConfigurationSetInput)
    pub fn builder() -> crate::input::get_configuration_set_input::Builder {
        crate::input::get_configuration_set_input::Builder::default()
    }
}

/// See [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
pub mod get_configuration_set_event_destinations_input {
    /// A builder for [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConfigurationSetEventDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConfigurationSetEventDestinationsInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigurationSetEventDestinationsInputOperationOutputAlias =
    crate::operation::GetConfigurationSetEventDestinations;
#[doc(hidden)]
pub type GetConfigurationSetEventDestinationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetConfigurationSetEventDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`GetConfigurationSetEventDestinations`](crate::operation::GetConfigurationSetEventDestinations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfigurationSetEventDestinations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetConfigurationSetEventDestinationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.configuration_set_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_21, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetConfigurationSetEventDestinationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConfigurationSetEventDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConfigurationSetEventDestinations",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetConfigurationSetEventDestinationsInput`](crate::input::GetConfigurationSetEventDestinationsInput)
    pub fn builder() -> crate::input::get_configuration_set_event_destinations_input::Builder {
        crate::input::get_configuration_set_event_destinations_input::Builder::default()
    }
}

/// See [`GetContactInput`](crate::input::GetContactInput)
pub mod get_contact_input {
    /// A builder for [`GetContactInput`](crate::input::GetContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactInput`](crate::input::GetContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactInput {
                contact_list_name: self.contact_list_name,
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactInputOperationOutputAlias = crate::operation::GetContact;
#[doc(hidden)]
pub type GetContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactInput {
    /// Consumes the builder and constructs an Operation<[`GetContact`](crate::operation::GetContact)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContactInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.contact_list_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_22, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_23 = &_input.email_address;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_address = aws_smithy_http::label::fmt_string(input_23, false);
                if email_address.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
                    ContactListName = contact_list_name,
                    EmailAddress = email_address
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContactInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContact",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContactInput`](crate::input::GetContactInput)
    pub fn builder() -> crate::input::get_contact_input::Builder {
        crate::input::get_contact_input::Builder::default()
    }
}

/// See [`GetContactListInput`](crate::input::GetContactListInput)
pub mod get_contact_list_input {
    /// A builder for [`GetContactListInput`](crate::input::GetContactListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactListInput`](crate::input::GetContactListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactListInput {
                contact_list_name: self.contact_list_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactListInputOperationOutputAlias = crate::operation::GetContactList;
#[doc(hidden)]
pub type GetContactListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactListInput {
    /// Consumes the builder and constructs an Operation<[`GetContactList`](crate::operation::GetContactList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContactListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.contact_list_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_24, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}",
                    ContactListName = contact_list_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContactListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactList",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContactListInput`](crate::input::GetContactListInput)
    pub fn builder() -> crate::input::get_contact_list_input::Builder {
        crate::input::get_contact_list_input::Builder::default()
    }
}

/// See [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
pub mod get_custom_verification_email_template_input {
    /// A builder for [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::GetCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type GetCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetCustomVerificationEmailTemplate`](crate::operation::GetCustomVerificationEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCustomVerificationEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCustomVerificationEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.template_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_25, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/custom-verification-email-templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCustomVerificationEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCustomVerificationEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::get_custom_verification_email_template_input::Builder {
        crate::input::get_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`GetDedicatedIpInput`](crate::input::GetDedicatedIpInput)
pub mod get_dedicated_ip_input {
    /// A builder for [`GetDedicatedIpInput`](crate::input::GetDedicatedIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDedicatedIpInput`](crate::input::GetDedicatedIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDedicatedIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDedicatedIpInput { ip: self.ip })
        }
    }
}
#[doc(hidden)]
pub type GetDedicatedIpInputOperationOutputAlias = crate::operation::GetDedicatedIp;
#[doc(hidden)]
pub type GetDedicatedIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDedicatedIpInput {
    /// Consumes the builder and constructs an Operation<[`GetDedicatedIp`](crate::operation::GetDedicatedIp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDedicatedIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDedicatedIpInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.ip;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ip = aws_smithy_http::label::fmt_string(input_26, false);
                if ip.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/dedicated-ips/{Ip}", Ip = ip)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDedicatedIpInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDedicatedIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDedicatedIp",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDedicatedIpInput`](crate::input::GetDedicatedIpInput)
    pub fn builder() -> crate::input::get_dedicated_ip_input::Builder {
        crate::input::get_dedicated_ip_input::Builder::default()
    }
}

/// See [`GetDedicatedIpsInput`](crate::input::GetDedicatedIpsInput)
pub mod get_dedicated_ips_input {
    /// A builder for [`GetDedicatedIpsInput`](crate::input::GetDedicatedIpsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pool_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pool_name = Some(input.into());
            self
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pool_name = input;
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDedicatedIpsInput`](crate::input::GetDedicatedIpsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDedicatedIpsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDedicatedIpsInput {
                pool_name: self.pool_name,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDedicatedIpsInputOperationOutputAlias = crate::operation::GetDedicatedIps;
#[doc(hidden)]
pub type GetDedicatedIpsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDedicatedIpsInput {
    /// Consumes the builder and constructs an Operation<[`GetDedicatedIps`](crate::operation::GetDedicatedIps)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDedicatedIps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDedicatedIpsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/dedicated-ips").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDedicatedIpsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_27) = &_input.pool_name {
                    query.push_kv("PoolName", &aws_smithy_http::query::fmt_string(&inner_27));
                }
                if let Some(inner_28) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_28));
                }
                if let Some(inner_29) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_29).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDedicatedIpsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDedicatedIps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDedicatedIps",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDedicatedIpsInput`](crate::input::GetDedicatedIpsInput)
    pub fn builder() -> crate::input::get_dedicated_ips_input::Builder {
        crate::input::get_dedicated_ips_input::Builder::default()
    }
}

/// See [`GetDeliverabilityDashboardOptionsInput`](crate::input::GetDeliverabilityDashboardOptionsInput)
pub mod get_deliverability_dashboard_options_input {
    /// A builder for [`GetDeliverabilityDashboardOptionsInput`](crate::input::GetDeliverabilityDashboardOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetDeliverabilityDashboardOptionsInput`](crate::input::GetDeliverabilityDashboardOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeliverabilityDashboardOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeliverabilityDashboardOptionsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetDeliverabilityDashboardOptionsInputOperationOutputAlias =
    crate::operation::GetDeliverabilityDashboardOptions;
#[doc(hidden)]
pub type GetDeliverabilityDashboardOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetDeliverabilityDashboardOptionsInput {
    /// Consumes the builder and constructs an Operation<[`GetDeliverabilityDashboardOptions`](crate::operation::GetDeliverabilityDashboardOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeliverabilityDashboardOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDeliverabilityDashboardOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/deliverability-dashboard")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDeliverabilityDashboardOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeliverabilityDashboardOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeliverabilityDashboardOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDeliverabilityDashboardOptionsInput`](crate::input::GetDeliverabilityDashboardOptionsInput)
    pub fn builder() -> crate::input::get_deliverability_dashboard_options_input::Builder {
        crate::input::get_deliverability_dashboard_options_input::Builder::default()
    }
}

/// See [`GetDeliverabilityTestReportInput`](crate::input::GetDeliverabilityTestReportInput)
pub mod get_deliverability_test_report_input {
    /// A builder for [`GetDeliverabilityTestReportInput`](crate::input::GetDeliverabilityTestReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeliverabilityTestReportInput`](crate::input::GetDeliverabilityTestReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeliverabilityTestReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeliverabilityTestReportInput {
                report_id: self.report_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeliverabilityTestReportInputOperationOutputAlias =
    crate::operation::GetDeliverabilityTestReport;
#[doc(hidden)]
pub type GetDeliverabilityTestReportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDeliverabilityTestReportInput {
    /// Consumes the builder and constructs an Operation<[`GetDeliverabilityTestReport`](crate::operation::GetDeliverabilityTestReport)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeliverabilityTestReport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDeliverabilityTestReportInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.report_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let report_id = aws_smithy_http::label::fmt_string(input_30, false);
                if report_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "report_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/deliverability-dashboard/test-reports/{ReportId}",
                    ReportId = report_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDeliverabilityTestReportInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeliverabilityTestReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeliverabilityTestReport",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDeliverabilityTestReportInput`](crate::input::GetDeliverabilityTestReportInput)
    pub fn builder() -> crate::input::get_deliverability_test_report_input::Builder {
        crate::input::get_deliverability_test_report_input::Builder::default()
    }
}

/// See [`GetDomainDeliverabilityCampaignInput`](crate::input::GetDomainDeliverabilityCampaignInput)
pub mod get_domain_deliverability_campaign_input {
    /// A builder for [`GetDomainDeliverabilityCampaignInput`](crate::input::GetDomainDeliverabilityCampaignInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) campaign_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainDeliverabilityCampaignInput`](crate::input::GetDomainDeliverabilityCampaignInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainDeliverabilityCampaignInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainDeliverabilityCampaignInput {
                campaign_id: self.campaign_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainDeliverabilityCampaignInputOperationOutputAlias =
    crate::operation::GetDomainDeliverabilityCampaign;
#[doc(hidden)]
pub type GetDomainDeliverabilityCampaignInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainDeliverabilityCampaignInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainDeliverabilityCampaign`](crate::operation::GetDomainDeliverabilityCampaign)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainDeliverabilityCampaign,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainDeliverabilityCampaignInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.campaign_id;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let campaign_id = aws_smithy_http::label::fmt_string(input_31, false);
                if campaign_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "campaign_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/deliverability-dashboard/campaigns/{CampaignId}",
                    CampaignId = campaign_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainDeliverabilityCampaignInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainDeliverabilityCampaign::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainDeliverabilityCampaign",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainDeliverabilityCampaignInput`](crate::input::GetDomainDeliverabilityCampaignInput)
    pub fn builder() -> crate::input::get_domain_deliverability_campaign_input::Builder {
        crate::input::get_domain_deliverability_campaign_input::Builder::default()
    }
}

/// See [`GetDomainStatisticsReportInput`](crate::input::GetDomainStatisticsReportInput)
pub mod get_domain_statistics_report_input {
    /// A builder for [`GetDomainStatisticsReportInput`](crate::input::GetDomainStatisticsReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainStatisticsReportInput`](crate::input::GetDomainStatisticsReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainStatisticsReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainStatisticsReportInput {
                domain: self.domain,
                start_date: self.start_date,
                end_date: self.end_date,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainStatisticsReportInputOperationOutputAlias =
    crate::operation::GetDomainStatisticsReport;
#[doc(hidden)]
pub type GetDomainStatisticsReportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainStatisticsReportInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainStatisticsReport`](crate::operation::GetDomainStatisticsReport)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainStatisticsReport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainStatisticsReportInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.domain;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain = aws_smithy_http::label::fmt_string(input_32, false);
                if domain.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/deliverability-dashboard/statistics-report/{Domain}",
                    Domain = domain
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDomainStatisticsReportInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_33) = &_input.start_date {
                    query.push_kv(
                        "StartDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_33,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_34) = &_input.end_date {
                    query.push_kv(
                        "EndDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_34,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainStatisticsReportInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainStatisticsReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainStatisticsReport",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainStatisticsReportInput`](crate::input::GetDomainStatisticsReportInput)
    pub fn builder() -> crate::input::get_domain_statistics_report_input::Builder {
        crate::input::get_domain_statistics_report_input::Builder::default()
    }
}

/// See [`GetEmailIdentityInput`](crate::input::GetEmailIdentityInput)
pub mod get_email_identity_input {
    /// A builder for [`GetEmailIdentityInput`](crate::input::GetEmailIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEmailIdentityInput`](crate::input::GetEmailIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEmailIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEmailIdentityInput {
                email_identity: self.email_identity,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEmailIdentityInputOperationOutputAlias = crate::operation::GetEmailIdentity;
#[doc(hidden)]
pub type GetEmailIdentityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEmailIdentityInput {
    /// Consumes the builder and constructs an Operation<[`GetEmailIdentity`](crate::operation::GetEmailIdentity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEmailIdentity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEmailIdentityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.email_identity;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_35, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEmailIdentityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEmailIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEmailIdentity",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEmailIdentityInput`](crate::input::GetEmailIdentityInput)
    pub fn builder() -> crate::input::get_email_identity_input::Builder {
        crate::input::get_email_identity_input::Builder::default()
    }
}

/// See [`GetEmailIdentityPoliciesInput`](crate::input::GetEmailIdentityPoliciesInput)
pub mod get_email_identity_policies_input {
    /// A builder for [`GetEmailIdentityPoliciesInput`](crate::input::GetEmailIdentityPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEmailIdentityPoliciesInput`](crate::input::GetEmailIdentityPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEmailIdentityPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEmailIdentityPoliciesInput {
                email_identity: self.email_identity,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEmailIdentityPoliciesInputOperationOutputAlias =
    crate::operation::GetEmailIdentityPolicies;
#[doc(hidden)]
pub type GetEmailIdentityPoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEmailIdentityPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`GetEmailIdentityPolicies`](crate::operation::GetEmailIdentityPolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEmailIdentityPolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEmailIdentityPoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.email_identity;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_36, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/policies",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEmailIdentityPoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEmailIdentityPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEmailIdentityPolicies",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEmailIdentityPoliciesInput`](crate::input::GetEmailIdentityPoliciesInput)
    pub fn builder() -> crate::input::get_email_identity_policies_input::Builder {
        crate::input::get_email_identity_policies_input::Builder::default()
    }
}

/// See [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
pub mod get_email_template_input {
    /// A builder for [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEmailTemplateInputOperationOutputAlias = crate::operation::GetEmailTemplate;
#[doc(hidden)]
pub type GetEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetEmailTemplate`](crate::operation::GetEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.template_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_37, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEmailTemplateInput`](crate::input::GetEmailTemplateInput)
    pub fn builder() -> crate::input::get_email_template_input::Builder {
        crate::input::get_email_template_input::Builder::default()
    }
}

/// See [`GetImportJobInput`](crate::input::GetImportJobInput)
pub mod get_import_job_input {
    /// A builder for [`GetImportJobInput`](crate::input::GetImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImportJobInput`](crate::input::GetImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImportJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImportJobInputOperationOutputAlias = crate::operation::GetImportJob;
#[doc(hidden)]
pub type GetImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImportJobInput {
    /// Consumes the builder and constructs an Operation<[`GetImportJob`](crate::operation::GetImportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.job_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_38, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/import-jobs/{JobId}", JobId = job_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImportJob",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImportJobInput`](crate::input::GetImportJobInput)
    pub fn builder() -> crate::input::get_import_job_input::Builder {
        crate::input::get_import_job_input::Builder::default()
    }
}

/// See [`GetSuppressedDestinationInput`](crate::input::GetSuppressedDestinationInput)
pub mod get_suppressed_destination_input {
    /// A builder for [`GetSuppressedDestinationInput`](crate::input::GetSuppressedDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address that's on the account suppression list.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that's on the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSuppressedDestinationInput`](crate::input::GetSuppressedDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSuppressedDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSuppressedDestinationInput {
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSuppressedDestinationInputOperationOutputAlias =
    crate::operation::GetSuppressedDestination;
#[doc(hidden)]
pub type GetSuppressedDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSuppressedDestinationInput {
    /// Consumes the builder and constructs an Operation<[`GetSuppressedDestination`](crate::operation::GetSuppressedDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSuppressedDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSuppressedDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.email_address;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_address = aws_smithy_http::label::fmt_string(input_39, false);
                if email_address.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/suppression/addresses/{EmailAddress}",
                    EmailAddress = email_address
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSuppressedDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSuppressedDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSuppressedDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSuppressedDestinationInput`](crate::input::GetSuppressedDestinationInput)
    pub fn builder() -> crate::input::get_suppressed_destination_input::Builder {
        crate::input::get_suppressed_destination_input::Builder::default()
    }
}

/// See [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
pub mod list_configuration_sets_input {
    /// A builder for [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationSetsInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationOutputAlias = crate::operation::ListConfigurationSets;
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListConfigurationSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationSets`](crate::operation::ListConfigurationSets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListConfigurationSetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/configuration-sets").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListConfigurationSetsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_40));
                }
                if let Some(inner_41) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListConfigurationSetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationSets",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    pub fn builder() -> crate::input::list_configuration_sets_input::Builder {
        crate::input::list_configuration_sets_input::Builder::default()
    }
}

/// See [`ListContactListsInput`](crate::input::ListContactListsInput)
pub mod list_contact_lists_input {
    /// A builder for [`ListContactListsInput`](crate::input::ListContactListsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactListsInput`](crate::input::ListContactListsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactListsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactListsInput {
                page_size: self.page_size,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactListsInputOperationOutputAlias = crate::operation::ListContactLists;
#[doc(hidden)]
pub type ListContactListsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactListsInput {
    /// Consumes the builder and constructs an Operation<[`ListContactLists`](crate::operation::ListContactLists)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContactLists,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListContactListsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/contact-lists").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListContactListsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                    );
                }
                if let Some(inner_43) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_43));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListContactListsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContactLists::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContactLists",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListContactListsInput`](crate::input::ListContactListsInput)
    pub fn builder() -> crate::input::list_contact_lists_input::Builder {
        crate::input::list_contact_lists_input::Builder::default()
    }
}

/// See [`ListContactsInput`](crate::input::ListContactsInput)
pub mod list_contacts_input {
    /// A builder for [`ListContactsInput`](crate::input::ListContactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::ListContactsFilter>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn filter(mut self, input: crate::model::ListContactsFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListContactsFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsInput`](crate::input::ListContactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactsInput {
                contact_list_name: self.contact_list_name,
                filter: self.filter,
                page_size: self.page_size,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactsInputOperationOutputAlias = crate::operation::ListContacts;
#[doc(hidden)]
pub type ListContactsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactsInput {
    /// Consumes the builder and constructs an Operation<[`ListContacts`](crate::operation::ListContacts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListContactsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.contact_list_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_44, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}/contacts",
                    ContactListName = contact_list_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListContactsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_45) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_45).encode(),
                    );
                }
                if let Some(inner_46) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_46));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListContactsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_contacts(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContacts",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListContactsInput`](crate::input::ListContactsInput)
    pub fn builder() -> crate::input::list_contacts_input::Builder {
        crate::input::list_contacts_input::Builder::default()
    }
}

/// See [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
pub mod list_custom_verification_email_templates_input {
    /// A builder for [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomVerificationEmailTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomVerificationEmailTemplatesInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomVerificationEmailTemplatesInputOperationOutputAlias =
    crate::operation::ListCustomVerificationEmailTemplates;
#[doc(hidden)]
pub type ListCustomVerificationEmailTemplatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListCustomVerificationEmailTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomVerificationEmailTemplates`](crate::operation::ListCustomVerificationEmailTemplates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomVerificationEmailTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCustomVerificationEmailTemplatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/custom-verification-email-templates")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListCustomVerificationEmailTemplatesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_47) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if let Some(inner_48) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCustomVerificationEmailTemplatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomVerificationEmailTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomVerificationEmailTemplates",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
    pub fn builder() -> crate::input::list_custom_verification_email_templates_input::Builder {
        crate::input::list_custom_verification_email_templates_input::Builder::default()
    }
}

/// See [`ListDedicatedIpPoolsInput`](crate::input::ListDedicatedIpPoolsInput)
pub mod list_dedicated_ip_pools_input {
    /// A builder for [`ListDedicatedIpPoolsInput`](crate::input::ListDedicatedIpPoolsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDedicatedIpPoolsInput`](crate::input::ListDedicatedIpPoolsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDedicatedIpPoolsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDedicatedIpPoolsInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDedicatedIpPoolsInputOperationOutputAlias = crate::operation::ListDedicatedIpPools;
#[doc(hidden)]
pub type ListDedicatedIpPoolsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDedicatedIpPoolsInput {
    /// Consumes the builder and constructs an Operation<[`ListDedicatedIpPools`](crate::operation::ListDedicatedIpPools)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDedicatedIpPools,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDedicatedIpPoolsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/dedicated-ip-pools").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDedicatedIpPoolsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                if let Some(inner_50) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_50).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDedicatedIpPoolsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDedicatedIpPools::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDedicatedIpPools",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDedicatedIpPoolsInput`](crate::input::ListDedicatedIpPoolsInput)
    pub fn builder() -> crate::input::list_dedicated_ip_pools_input::Builder {
        crate::input::list_dedicated_ip_pools_input::Builder::default()
    }
}

/// See [`ListDeliverabilityTestReportsInput`](crate::input::ListDeliverabilityTestReportsInput)
pub mod list_deliverability_test_reports_input {
    /// A builder for [`ListDeliverabilityTestReportsInput`](crate::input::ListDeliverabilityTestReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeliverabilityTestReportsInput`](crate::input::ListDeliverabilityTestReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeliverabilityTestReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeliverabilityTestReportsInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeliverabilityTestReportsInputOperationOutputAlias =
    crate::operation::ListDeliverabilityTestReports;
#[doc(hidden)]
pub type ListDeliverabilityTestReportsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDeliverabilityTestReportsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeliverabilityTestReports`](crate::operation::ListDeliverabilityTestReports)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeliverabilityTestReports,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDeliverabilityTestReportsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/deliverability-dashboard/test-reports")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDeliverabilityTestReportsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_51) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_51));
                }
                if let Some(inner_52) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_52).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDeliverabilityTestReportsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeliverabilityTestReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeliverabilityTestReports",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDeliverabilityTestReportsInput`](crate::input::ListDeliverabilityTestReportsInput)
    pub fn builder() -> crate::input::list_deliverability_test_reports_input::Builder {
        crate::input::list_deliverability_test_reports_input::Builder::default()
    }
}

/// See [`ListDomainDeliverabilityCampaignsInput`](crate::input::ListDomainDeliverabilityCampaignsInput)
pub mod list_domain_deliverability_campaigns_input {
    /// A builder for [`ListDomainDeliverabilityCampaignsInput`](crate::input::ListDomainDeliverabilityCampaignsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) subscribed_domain: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn subscribed_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscribed_domain = Some(input.into());
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn set_subscribed_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscribed_domain = input;
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainDeliverabilityCampaignsInput`](crate::input::ListDomainDeliverabilityCampaignsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainDeliverabilityCampaignsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainDeliverabilityCampaignsInput {
                start_date: self.start_date,
                end_date: self.end_date,
                subscribed_domain: self.subscribed_domain,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainDeliverabilityCampaignsInputOperationOutputAlias =
    crate::operation::ListDomainDeliverabilityCampaigns;
#[doc(hidden)]
pub type ListDomainDeliverabilityCampaignsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainDeliverabilityCampaignsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainDeliverabilityCampaigns`](crate::operation::ListDomainDeliverabilityCampaigns)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainDeliverabilityCampaigns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainDeliverabilityCampaignsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_53 = &_input.subscribed_domain;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscribed_domain",
                        details: "cannot be empty or unset",
                    },
                )?;
                let subscribed_domain = aws_smithy_http::label::fmt_string(input_53, false);
                if subscribed_domain.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscribed_domain",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns",
                    SubscribedDomain = subscribed_domain
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainDeliverabilityCampaignsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_54) = &_input.start_date {
                    query.push_kv(
                        "StartDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_54,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_55) = &_input.end_date {
                    query.push_kv(
                        "EndDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_55,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_56) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_56));
                }
                if let Some(inner_57) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_57).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainDeliverabilityCampaignsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainDeliverabilityCampaigns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainDeliverabilityCampaigns",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainDeliverabilityCampaignsInput`](crate::input::ListDomainDeliverabilityCampaignsInput)
    pub fn builder() -> crate::input::list_domain_deliverability_campaigns_input::Builder {
        crate::input::list_domain_deliverability_campaigns_input::Builder::default()
    }
}

/// See [`ListEmailIdentitiesInput`](crate::input::ListEmailIdentitiesInput)
pub mod list_email_identities_input {
    /// A builder for [`ListEmailIdentitiesInput`](crate::input::ListEmailIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEmailIdentitiesInput`](crate::input::ListEmailIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEmailIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEmailIdentitiesInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEmailIdentitiesInputOperationOutputAlias = crate::operation::ListEmailIdentities;
#[doc(hidden)]
pub type ListEmailIdentitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEmailIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListEmailIdentities`](crate::operation::ListEmailIdentities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEmailIdentities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEmailIdentitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/identities").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListEmailIdentitiesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_58) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_58));
                }
                if let Some(inner_59) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_59).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEmailIdentitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEmailIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEmailIdentities",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEmailIdentitiesInput`](crate::input::ListEmailIdentitiesInput)
    pub fn builder() -> crate::input::list_email_identities_input::Builder {
        crate::input::list_email_identities_input::Builder::default()
    }
}

/// See [`ListEmailTemplatesInput`](crate::input::ListEmailTemplatesInput)
pub mod list_email_templates_input {
    /// A builder for [`ListEmailTemplatesInput`](crate::input::ListEmailTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEmailTemplatesInput`](crate::input::ListEmailTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEmailTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEmailTemplatesInput {
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEmailTemplatesInputOperationOutputAlias = crate::operation::ListEmailTemplates;
#[doc(hidden)]
pub type ListEmailTemplatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEmailTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListEmailTemplates`](crate::operation::ListEmailTemplates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEmailTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEmailTemplatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/templates").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListEmailTemplatesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_60) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_60));
                }
                if let Some(inner_61) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_61).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEmailTemplatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEmailTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEmailTemplates",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEmailTemplatesInput`](crate::input::ListEmailTemplatesInput)
    pub fn builder() -> crate::input::list_email_templates_input::Builder {
        crate::input::list_email_templates_input::Builder::default()
    }
}

/// See [`ListImportJobsInput`](crate::input::ListImportJobsInput)
pub mod list_import_jobs_input {
    /// A builder for [`ListImportJobsInput`](crate::input::ListImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_destination_type:
            std::option::Option<crate::model::ImportDestinationType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
        pub fn import_destination_type(
            mut self,
            input: crate::model::ImportDestinationType,
        ) -> Self {
            self.import_destination_type = Some(input);
            self
        }
        /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
        pub fn set_import_destination_type(
            mut self,
            input: std::option::Option<crate::model::ImportDestinationType>,
        ) -> Self {
            self.import_destination_type = input;
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImportJobsInput`](crate::input::ListImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImportJobsInput {
                import_destination_type: self.import_destination_type,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImportJobsInputOperationOutputAlias = crate::operation::ListImportJobs;
#[doc(hidden)]
pub type ListImportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListImportJobs`](crate::operation::ListImportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/import-jobs").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListImportJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_62) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_62));
                }
                if let Some(inner_63) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_import_jobs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImportJobs",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImportJobsInput`](crate::input::ListImportJobsInput)
    pub fn builder() -> crate::input::list_import_jobs_input::Builder {
        crate::input::list_import_jobs_input::Builder::default()
    }
}

/// See [`ListSuppressedDestinationsInput`](crate::input::ListSuppressedDestinationsInput)
pub mod list_suppressed_destinations_input {
    /// A builder for [`ListSuppressedDestinationsInput`](crate::input::ListSuppressedDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `reasons`.
        ///
        /// To override the contents of this collection use [`set_reasons`](Self::set_reasons).
        ///
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            let mut v = self.reasons.unwrap_or_default();
            v.push(input);
            self.reasons = Some(v);
            self
        }
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn set_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.reasons = input;
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuppressedDestinationsInput`](crate::input::ListSuppressedDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSuppressedDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSuppressedDestinationsInput {
                reasons: self.reasons,
                start_date: self.start_date,
                end_date: self.end_date,
                next_token: self.next_token,
                page_size: self.page_size,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSuppressedDestinationsInputOperationOutputAlias =
    crate::operation::ListSuppressedDestinations;
#[doc(hidden)]
pub type ListSuppressedDestinationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSuppressedDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`ListSuppressedDestinations`](crate::operation::ListSuppressedDestinations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSuppressedDestinations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSuppressedDestinationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/suppression/addresses")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListSuppressedDestinationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_64) = &_input.reasons {
                    for inner_65 in inner_64 {
                        query.push_kv("Reason", &aws_smithy_http::query::fmt_string(&inner_65));
                    }
                }
                if let Some(inner_66) = &_input.start_date {
                    query.push_kv(
                        "StartDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_66,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_67) = &_input.end_date {
                    query.push_kv(
                        "EndDate",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_67,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_68) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_68));
                }
                if let Some(inner_69) = &_input.page_size {
                    query.push_kv(
                        "PageSize",
                        aws_smithy_types::primitive::Encoder::from(*inner_69).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSuppressedDestinationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSuppressedDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSuppressedDestinations",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSuppressedDestinationsInput`](crate::input::ListSuppressedDestinationsInput)
    pub fn builder() -> crate::input::list_suppressed_destinations_input::Builder {
        crate::input::list_suppressed_destinations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/tags").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTagsForResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_70) = &_input.resource_arn {
                    query.push_kv(
                        "ResourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_70),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutAccountDedicatedIpWarmupAttributesInput`](crate::input::PutAccountDedicatedIpWarmupAttributesInput)
pub mod put_account_dedicated_ip_warmup_attributes_input {
    /// A builder for [`PutAccountDedicatedIpWarmupAttributesInput`](crate::input::PutAccountDedicatedIpWarmupAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_warmup_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn auto_warmup_enabled(mut self, input: bool) -> Self {
            self.auto_warmup_enabled = Some(input);
            self
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
        pub fn set_auto_warmup_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_warmup_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountDedicatedIpWarmupAttributesInput`](crate::input::PutAccountDedicatedIpWarmupAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountDedicatedIpWarmupAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountDedicatedIpWarmupAttributesInput {
                auto_warmup_enabled: self.auto_warmup_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountDedicatedIpWarmupAttributesInputOperationOutputAlias =
    crate::operation::PutAccountDedicatedIpWarmupAttributes;
#[doc(hidden)]
pub type PutAccountDedicatedIpWarmupAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAccountDedicatedIpWarmupAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountDedicatedIpWarmupAttributes`](crate::operation::PutAccountDedicatedIpWarmupAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountDedicatedIpWarmupAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAccountDedicatedIpWarmupAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/account/dedicated-ips/warmup")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAccountDedicatedIpWarmupAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_account_dedicated_ip_warmup_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountDedicatedIpWarmupAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountDedicatedIpWarmupAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAccountDedicatedIpWarmupAttributesInput`](crate::input::PutAccountDedicatedIpWarmupAttributesInput)
    pub fn builder() -> crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder {
        crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder::default()
    }
}

/// See [`PutAccountDetailsInput`](crate::input::PutAccountDetailsInput)
pub mod put_account_details_input {
    /// A builder for [`PutAccountDetailsInput`](crate::input::PutAccountDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mail_type: std::option::Option<crate::model::MailType>,
        pub(crate) website_url: std::option::Option<std::string::String>,
        pub(crate) contact_language: std::option::Option<crate::model::ContactLanguage>,
        pub(crate) use_case_description: std::option::Option<std::string::String>,
        pub(crate) additional_contact_email_addresses:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) production_access_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of email your account will send.</p>
        pub fn mail_type(mut self, input: crate::model::MailType) -> Self {
            self.mail_type = Some(input);
            self
        }
        /// <p>The type of email your account will send.</p>
        pub fn set_mail_type(mut self, input: std::option::Option<crate::model::MailType>) -> Self {
            self.mail_type = input;
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
        pub fn website_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_url = Some(input.into());
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
        pub fn set_website_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.website_url = input;
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn contact_language(mut self, input: crate::model::ContactLanguage) -> Self {
            self.contact_language = Some(input);
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn set_contact_language(
            mut self,
            input: std::option::Option<crate::model::ContactLanguage>,
        ) -> Self {
            self.contact_language = input;
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn use_case_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_case_description = Some(input.into());
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn set_use_case_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.use_case_description = input;
            self
        }
        /// Appends an item to `additional_contact_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_additional_contact_email_addresses`](Self::set_additional_contact_email_addresses).
        ///
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
        pub fn additional_contact_email_addresses(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_contact_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.additional_contact_email_addresses = Some(v);
            self
        }
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
        pub fn set_additional_contact_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_contact_email_addresses = input;
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
        pub fn production_access_enabled(mut self, input: bool) -> Self {
            self.production_access_enabled = Some(input);
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
        pub fn set_production_access_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.production_access_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountDetailsInput`](crate::input::PutAccountDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountDetailsInput {
                mail_type: self.mail_type,
                website_url: self.website_url,
                contact_language: self.contact_language,
                use_case_description: self.use_case_description,
                additional_contact_email_addresses: self.additional_contact_email_addresses,
                production_access_enabled: self.production_access_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountDetailsInputOperationOutputAlias = crate::operation::PutAccountDetails;
#[doc(hidden)]
pub type PutAccountDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAccountDetailsInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountDetails`](crate::operation::PutAccountDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAccountDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/account/details").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAccountDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_account_details(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountDetails",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAccountDetailsInput`](crate::input::PutAccountDetailsInput)
    pub fn builder() -> crate::input::put_account_details_input::Builder {
        crate::input::put_account_details_input::Builder::default()
    }
}

/// See [`PutAccountSendingAttributesInput`](crate::input::PutAccountSendingAttributesInput)
pub mod put_account_sending_attributes_input {
    /// A builder for [`PutAccountSendingAttributesInput`](crate::input::PutAccountSendingAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sending_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.sending_enabled = Some(input);
            self
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
        /// </note>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sending_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSendingAttributesInput`](crate::input::PutAccountSendingAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountSendingAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountSendingAttributesInput {
                sending_enabled: self.sending_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountSendingAttributesInputOperationOutputAlias =
    crate::operation::PutAccountSendingAttributes;
#[doc(hidden)]
pub type PutAccountSendingAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAccountSendingAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountSendingAttributes`](crate::operation::PutAccountSendingAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountSendingAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAccountSendingAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/account/sending").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAccountSendingAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_account_sending_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountSendingAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountSendingAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAccountSendingAttributesInput`](crate::input::PutAccountSendingAttributesInput)
    pub fn builder() -> crate::input::put_account_sending_attributes_input::Builder {
        crate::input::put_account_sending_attributes_input::Builder::default()
    }
}

/// See [`PutAccountSuppressionAttributesInput`](crate::input::PutAccountSuppressionAttributesInput)
pub mod put_account_suppression_attributes_input {
    /// A builder for [`PutAccountSuppressionAttributesInput`](crate::input::PutAccountSuppressionAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppressed_reasons:
            std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
    }
    impl Builder {
        /// Appends an item to `suppressed_reasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn suppressed_reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            let mut v = self.suppressed_reasons.unwrap_or_default();
            v.push(input);
            self.suppressed_reasons = Some(v);
            self
        }
        /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.suppressed_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSuppressionAttributesInput`](crate::input::PutAccountSuppressionAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountSuppressionAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountSuppressionAttributesInput {
                suppressed_reasons: self.suppressed_reasons,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountSuppressionAttributesInputOperationOutputAlias =
    crate::operation::PutAccountSuppressionAttributes;
#[doc(hidden)]
pub type PutAccountSuppressionAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAccountSuppressionAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountSuppressionAttributes`](crate::operation::PutAccountSuppressionAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountSuppressionAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutAccountSuppressionAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/account/suppression").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutAccountSuppressionAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_account_suppression_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountSuppressionAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountSuppressionAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutAccountSuppressionAttributesInput`](crate::input::PutAccountSuppressionAttributesInput)
    pub fn builder() -> crate::input::put_account_suppression_attributes_input::Builder {
        crate::input::put_account_suppression_attributes_input::Builder::default()
    }
}

/// See [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
pub mod put_configuration_set_delivery_options_input {
    /// A builder for [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tls_policy: std::option::Option<crate::model::TlsPolicy>,
        pub(crate) sending_pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.tls_policy = Some(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.tls_policy = input;
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn sending_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sending_pool_name = Some(input.into());
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn set_sending_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sending_pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetDeliveryOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetDeliveryOptionsInput {
                configuration_set_name: self.configuration_set_name,
                tls_policy: self.tls_policy,
                sending_pool_name: self.sending_pool_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetDeliveryOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetDeliveryOptions;
#[doc(hidden)]
pub type PutConfigurationSetDeliveryOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationSetDeliveryOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetDeliveryOptions`](crate::operation::PutConfigurationSetDeliveryOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetDeliveryOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationSetDeliveryOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.configuration_set_name;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_71, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/delivery-options",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationSetDeliveryOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_delivery_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetDeliveryOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetDeliveryOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_delivery_options_input::Builder {
        crate::input::put_configuration_set_delivery_options_input::Builder::default()
    }
}

/// See [`PutConfigurationSetReputationOptionsInput`](crate::input::PutConfigurationSetReputationOptionsInput)
pub mod put_configuration_set_reputation_options_input {
    /// A builder for [`PutConfigurationSetReputationOptionsInput`](crate::input::PutConfigurationSetReputationOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) reputation_metrics_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn reputation_metrics_enabled(mut self, input: bool) -> Self {
            self.reputation_metrics_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.reputation_metrics_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetReputationOptionsInput`](crate::input::PutConfigurationSetReputationOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetReputationOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetReputationOptionsInput {
                configuration_set_name: self.configuration_set_name,
                reputation_metrics_enabled: self.reputation_metrics_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetReputationOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetReputationOptions;
#[doc(hidden)]
pub type PutConfigurationSetReputationOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationSetReputationOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetReputationOptions`](crate::operation::PutConfigurationSetReputationOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetReputationOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationSetReputationOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_72 = &_input.configuration_set_name;
                let input_72 = input_72.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_72, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/reputation-options",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationSetReputationOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_reputation_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetReputationOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetReputationOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetReputationOptionsInput`](crate::input::PutConfigurationSetReputationOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_reputation_options_input::Builder {
        crate::input::put_configuration_set_reputation_options_input::Builder::default()
    }
}

/// See [`PutConfigurationSetSendingOptionsInput`](crate::input::PutConfigurationSetSendingOptionsInput)
pub mod put_configuration_set_sending_options_input {
    /// A builder for [`PutConfigurationSetSendingOptionsInput`](crate::input::PutConfigurationSetSendingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) sending_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.sending_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sending_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetSendingOptionsInput`](crate::input::PutConfigurationSetSendingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetSendingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetSendingOptionsInput {
                configuration_set_name: self.configuration_set_name,
                sending_enabled: self.sending_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetSendingOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetSendingOptions;
#[doc(hidden)]
pub type PutConfigurationSetSendingOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationSetSendingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetSendingOptions`](crate::operation::PutConfigurationSetSendingOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetSendingOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationSetSendingOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_73 = &_input.configuration_set_name;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_73, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/sending",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationSetSendingOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_sending_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetSendingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetSendingOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetSendingOptionsInput`](crate::input::PutConfigurationSetSendingOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_sending_options_input::Builder {
        crate::input::put_configuration_set_sending_options_input::Builder::default()
    }
}

/// See [`PutConfigurationSetSuppressionOptionsInput`](crate::input::PutConfigurationSetSuppressionOptionsInput)
pub mod put_configuration_set_suppression_options_input {
    /// A builder for [`PutConfigurationSetSuppressionOptionsInput`](crate::input::PutConfigurationSetSuppressionOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) suppressed_reasons:
            std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
    }
    impl Builder {
        /// <p>The name of the configuration set to change the suppression list preferences for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to change the suppression list preferences for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `suppressed_reasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn suppressed_reasons(mut self, input: crate::model::SuppressionListReason) -> Self {
            let mut v = self.suppressed_reasons.unwrap_or_default();
            v.push(input);
            self.suppressed_reasons = Some(v);
            self
        }
        /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
        /// <ul>
        /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
        /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.suppressed_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetSuppressionOptionsInput`](crate::input::PutConfigurationSetSuppressionOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetSuppressionOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetSuppressionOptionsInput {
                configuration_set_name: self.configuration_set_name,
                suppressed_reasons: self.suppressed_reasons,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetSuppressionOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetSuppressionOptions;
#[doc(hidden)]
pub type PutConfigurationSetSuppressionOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationSetSuppressionOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetSuppressionOptions`](crate::operation::PutConfigurationSetSuppressionOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetSuppressionOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationSetSuppressionOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_74 = &_input.configuration_set_name;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_74, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/suppression-options",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationSetSuppressionOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_suppression_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetSuppressionOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetSuppressionOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetSuppressionOptionsInput`](crate::input::PutConfigurationSetSuppressionOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_suppression_options_input::Builder {
        crate::input::put_configuration_set_suppression_options_input::Builder::default()
    }
}

/// See [`PutConfigurationSetTrackingOptionsInput`](crate::input::PutConfigurationSetTrackingOptionsInput)
pub mod put_configuration_set_tracking_options_input {
    /// A builder for [`PutConfigurationSetTrackingOptionsInput`](crate::input::PutConfigurationSetTrackingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) custom_redirect_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn custom_redirect_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_redirect_domain = Some(input.into());
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_redirect_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetTrackingOptionsInput`](crate::input::PutConfigurationSetTrackingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetTrackingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetTrackingOptionsInput {
                configuration_set_name: self.configuration_set_name,
                custom_redirect_domain: self.custom_redirect_domain,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetTrackingOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetTrackingOptions;
#[doc(hidden)]
pub type PutConfigurationSetTrackingOptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutConfigurationSetTrackingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetTrackingOptions`](crate::operation::PutConfigurationSetTrackingOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetTrackingOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutConfigurationSetTrackingOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_75 = &_input.configuration_set_name;
                let input_75 = input_75.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_75, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/configuration-sets/{ConfigurationSetName}/tracking-options",
                    ConfigurationSetName = configuration_set_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutConfigurationSetTrackingOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_tracking_options(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetTrackingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetTrackingOptions",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetTrackingOptionsInput`](crate::input::PutConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_tracking_options_input::Builder {
        crate::input::put_configuration_set_tracking_options_input::Builder::default()
    }
}

/// See [`PutDedicatedIpInPoolInput`](crate::input::PutDedicatedIpInPoolInput)
pub mod put_dedicated_ip_in_pool_input {
    /// A builder for [`PutDedicatedIpInPoolInput`](crate::input::PutDedicatedIpInPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) destination_pool_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn destination_pool_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_pool_name = Some(input.into());
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
        pub fn set_destination_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_pool_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDedicatedIpInPoolInput`](crate::input::PutDedicatedIpInPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDedicatedIpInPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDedicatedIpInPoolInput {
                ip: self.ip,
                destination_pool_name: self.destination_pool_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDedicatedIpInPoolInputOperationOutputAlias = crate::operation::PutDedicatedIpInPool;
#[doc(hidden)]
pub type PutDedicatedIpInPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutDedicatedIpInPoolInput {
    /// Consumes the builder and constructs an Operation<[`PutDedicatedIpInPool`](crate::operation::PutDedicatedIpInPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDedicatedIpInPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutDedicatedIpInPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_76 = &_input.ip;
                let input_76 = input_76.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ip = aws_smithy_http::label::fmt_string(input_76, false);
                if ip.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/dedicated-ips/{Ip}/pool", Ip = ip)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutDedicatedIpInPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_dedicated_ip_in_pool(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDedicatedIpInPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDedicatedIpInPool",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutDedicatedIpInPoolInput`](crate::input::PutDedicatedIpInPoolInput)
    pub fn builder() -> crate::input::put_dedicated_ip_in_pool_input::Builder {
        crate::input::put_dedicated_ip_in_pool_input::Builder::default()
    }
}

/// See [`PutDedicatedIpWarmupAttributesInput`](crate::input::PutDedicatedIpWarmupAttributesInput)
pub mod put_dedicated_ip_warmup_attributes_input {
    /// A builder for [`PutDedicatedIpWarmupAttributesInput`](crate::input::PutDedicatedIpWarmupAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) warmup_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn warmup_percentage(mut self, input: i32) -> Self {
            self.warmup_percentage = Some(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
        pub fn set_warmup_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.warmup_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDedicatedIpWarmupAttributesInput`](crate::input::PutDedicatedIpWarmupAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDedicatedIpWarmupAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDedicatedIpWarmupAttributesInput {
                ip: self.ip,
                warmup_percentage: self.warmup_percentage,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDedicatedIpWarmupAttributesInputOperationOutputAlias =
    crate::operation::PutDedicatedIpWarmupAttributes;
#[doc(hidden)]
pub type PutDedicatedIpWarmupAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutDedicatedIpWarmupAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutDedicatedIpWarmupAttributes`](crate::operation::PutDedicatedIpWarmupAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDedicatedIpWarmupAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutDedicatedIpWarmupAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_77 = &_input.ip;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ip = aws_smithy_http::label::fmt_string(input_77, false);
                if ip.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/dedicated-ips/{Ip}/warmup", Ip = ip)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutDedicatedIpWarmupAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_dedicated_ip_warmup_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDedicatedIpWarmupAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDedicatedIpWarmupAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutDedicatedIpWarmupAttributesInput`](crate::input::PutDedicatedIpWarmupAttributesInput)
    pub fn builder() -> crate::input::put_dedicated_ip_warmup_attributes_input::Builder {
        crate::input::put_dedicated_ip_warmup_attributes_input::Builder::default()
    }
}

/// See [`PutDeliverabilityDashboardOptionInput`](crate::input::PutDeliverabilityDashboardOptionInput)
pub mod put_deliverability_dashboard_option_input {
    /// A builder for [`PutDeliverabilityDashboardOptionInput`](crate::input::PutDeliverabilityDashboardOptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_enabled: std::option::Option<bool>,
        pub(crate) subscribed_domains:
            std::option::Option<std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>>,
    }
    impl Builder {
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn dashboard_enabled(mut self, input: bool) -> Self {
            self.dashboard_enabled = Some(input);
            self
        }
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
        pub fn set_dashboard_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.dashboard_enabled = input;
            self
        }
        /// Appends an item to `subscribed_domains`.
        ///
        /// To override the contents of this collection use [`set_subscribed_domains`](Self::set_subscribed_domains).
        ///
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn subscribed_domains(
            mut self,
            input: crate::model::DomainDeliverabilityTrackingOption,
        ) -> Self {
            let mut v = self.subscribed_domains.unwrap_or_default();
            v.push(input);
            self.subscribed_domains = Some(v);
            self
        }
        /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
        pub fn set_subscribed_domains(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>,
            >,
        ) -> Self {
            self.subscribed_domains = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDeliverabilityDashboardOptionInput`](crate::input::PutDeliverabilityDashboardOptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDeliverabilityDashboardOptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDeliverabilityDashboardOptionInput {
                dashboard_enabled: self.dashboard_enabled.unwrap_or_default(),
                subscribed_domains: self.subscribed_domains,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDeliverabilityDashboardOptionInputOperationOutputAlias =
    crate::operation::PutDeliverabilityDashboardOption;
#[doc(hidden)]
pub type PutDeliverabilityDashboardOptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutDeliverabilityDashboardOptionInput {
    /// Consumes the builder and constructs an Operation<[`PutDeliverabilityDashboardOption`](crate::operation::PutDeliverabilityDashboardOption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDeliverabilityDashboardOption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutDeliverabilityDashboardOptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/deliverability-dashboard")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutDeliverabilityDashboardOptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_deliverability_dashboard_option(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDeliverabilityDashboardOption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDeliverabilityDashboardOption",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutDeliverabilityDashboardOptionInput`](crate::input::PutDeliverabilityDashboardOptionInput)
    pub fn builder() -> crate::input::put_deliverability_dashboard_option_input::Builder {
        crate::input::put_deliverability_dashboard_option_input::Builder::default()
    }
}

/// See [`PutEmailIdentityConfigurationSetAttributesInput`](crate::input::PutEmailIdentityConfigurationSetAttributesInput)
pub mod put_email_identity_configuration_set_attributes_input {
    /// A builder for [`PutEmailIdentityConfigurationSetAttributesInput`](crate::input::PutEmailIdentityConfigurationSetAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailIdentityConfigurationSetAttributesInput`](crate::input::PutEmailIdentityConfigurationSetAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailIdentityConfigurationSetAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::PutEmailIdentityConfigurationSetAttributesInput {
                    email_identity: self.email_identity,
                    configuration_set_name: self.configuration_set_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type PutEmailIdentityConfigurationSetAttributesInputOperationOutputAlias =
    crate::operation::PutEmailIdentityConfigurationSetAttributes;
#[doc(hidden)]
pub type PutEmailIdentityConfigurationSetAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailIdentityConfigurationSetAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailIdentityConfigurationSetAttributes`](crate::operation::PutEmailIdentityConfigurationSetAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailIdentityConfigurationSetAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailIdentityConfigurationSetAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_78 = &_input.email_identity;
                let input_78 = input_78.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_78, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/configuration-set",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailIdentityConfigurationSetAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_identity_configuration_set_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailIdentityConfigurationSetAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailIdentityConfigurationSetAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityConfigurationSetAttributesInput`](crate::input::PutEmailIdentityConfigurationSetAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_configuration_set_attributes_input::Builder
    {
        crate::input::put_email_identity_configuration_set_attributes_input::Builder::default()
    }
}

/// See [`PutEmailIdentityDkimAttributesInput`](crate::input::PutEmailIdentityDkimAttributesInput)
pub mod put_email_identity_dkim_attributes_input {
    /// A builder for [`PutEmailIdentityDkimAttributesInput`](crate::input::PutEmailIdentityDkimAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) signing_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
        pub fn signing_enabled(mut self, input: bool) -> Self {
            self.signing_enabled = Some(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
        pub fn set_signing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.signing_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailIdentityDkimAttributesInput`](crate::input::PutEmailIdentityDkimAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailIdentityDkimAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEmailIdentityDkimAttributesInput {
                email_identity: self.email_identity,
                signing_enabled: self.signing_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutEmailIdentityDkimAttributesInputOperationOutputAlias =
    crate::operation::PutEmailIdentityDkimAttributes;
#[doc(hidden)]
pub type PutEmailIdentityDkimAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailIdentityDkimAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailIdentityDkimAttributes`](crate::operation::PutEmailIdentityDkimAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailIdentityDkimAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailIdentityDkimAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_79 = &_input.email_identity;
                let input_79 = input_79.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_79, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/dkim",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailIdentityDkimAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_identity_dkim_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailIdentityDkimAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailIdentityDkimAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityDkimAttributesInput`](crate::input::PutEmailIdentityDkimAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_dkim_attributes_input::Builder {
        crate::input::put_email_identity_dkim_attributes_input::Builder::default()
    }
}

/// See [`PutEmailIdentityDkimSigningAttributesInput`](crate::input::PutEmailIdentityDkimSigningAttributesInput)
pub mod put_email_identity_dkim_signing_attributes_input {
    /// A builder for [`PutEmailIdentityDkimSigningAttributesInput`](crate::input::PutEmailIdentityDkimSigningAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) signing_attributes_origin:
            std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        pub(crate) signing_attributes: std::option::Option<crate::model::DkimSigningAttributes>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
        /// <ul>
        /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
        /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
        /// </ul>
        pub fn signing_attributes_origin(
            mut self,
            input: crate::model::DkimSigningAttributesOrigin,
        ) -> Self {
            self.signing_attributes_origin = Some(input);
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
        /// <ul>
        /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
        /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
        /// </ul>
        pub fn set_signing_attributes_origin(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        ) -> Self {
            self.signing_attributes_origin = input;
            self
        }
        /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn signing_attributes(mut self, input: crate::model::DkimSigningAttributes) -> Self {
            self.signing_attributes = Some(input);
            self
        }
        /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn set_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.signing_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailIdentityDkimSigningAttributesInput`](crate::input::PutEmailIdentityDkimSigningAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailIdentityDkimSigningAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEmailIdentityDkimSigningAttributesInput {
                email_identity: self.email_identity,
                signing_attributes_origin: self.signing_attributes_origin,
                signing_attributes: self.signing_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEmailIdentityDkimSigningAttributesInputOperationOutputAlias =
    crate::operation::PutEmailIdentityDkimSigningAttributes;
#[doc(hidden)]
pub type PutEmailIdentityDkimSigningAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailIdentityDkimSigningAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailIdentityDkimSigningAttributes`](crate::operation::PutEmailIdentityDkimSigningAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailIdentityDkimSigningAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailIdentityDkimSigningAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_80 = &_input.email_identity;
                let input_80 = input_80.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_80, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/email/identities/{EmailIdentity}/dkim/signing",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailIdentityDkimSigningAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_identity_dkim_signing_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailIdentityDkimSigningAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailIdentityDkimSigningAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityDkimSigningAttributesInput`](crate::input::PutEmailIdentityDkimSigningAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_dkim_signing_attributes_input::Builder {
        crate::input::put_email_identity_dkim_signing_attributes_input::Builder::default()
    }
}

/// See [`PutEmailIdentityFeedbackAttributesInput`](crate::input::PutEmailIdentityFeedbackAttributesInput)
pub mod put_email_identity_feedback_attributes_input {
    /// A builder for [`PutEmailIdentityFeedbackAttributesInput`](crate::input::PutEmailIdentityFeedbackAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) email_forwarding_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
        pub fn email_forwarding_enabled(mut self, input: bool) -> Self {
            self.email_forwarding_enabled = Some(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
        pub fn set_email_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.email_forwarding_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailIdentityFeedbackAttributesInput`](crate::input::PutEmailIdentityFeedbackAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailIdentityFeedbackAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEmailIdentityFeedbackAttributesInput {
                email_identity: self.email_identity,
                email_forwarding_enabled: self.email_forwarding_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutEmailIdentityFeedbackAttributesInputOperationOutputAlias =
    crate::operation::PutEmailIdentityFeedbackAttributes;
#[doc(hidden)]
pub type PutEmailIdentityFeedbackAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailIdentityFeedbackAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailIdentityFeedbackAttributes`](crate::operation::PutEmailIdentityFeedbackAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailIdentityFeedbackAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailIdentityFeedbackAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_81 = &_input.email_identity;
                let input_81 = input_81.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_81, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/feedback",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailIdentityFeedbackAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_identity_feedback_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailIdentityFeedbackAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailIdentityFeedbackAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityFeedbackAttributesInput`](crate::input::PutEmailIdentityFeedbackAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_feedback_attributes_input::Builder {
        crate::input::put_email_identity_feedback_attributes_input::Builder::default()
    }
}

/// See [`PutEmailIdentityMailFromAttributesInput`](crate::input::PutEmailIdentityMailFromAttributesInput)
pub mod put_email_identity_mail_from_attributes_input {
    /// A builder for [`PutEmailIdentityMailFromAttributesInput`](crate::input::PutEmailIdentityMailFromAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) mail_from_domain: std::option::Option<std::string::String>,
        pub(crate) behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
    }
    impl Builder {
        /// <p>The verified email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The verified email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.mail_from_domain = Some(input.into());
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
        /// <ul>
        /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
        /// <li> <p>It can't be used to receive email.</p> </li>
        /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
        /// </ul>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mail_from_domain = input;
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.behavior_on_mx_failure = Some(input);
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.behavior_on_mx_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEmailIdentityMailFromAttributesInput`](crate::input::PutEmailIdentityMailFromAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutEmailIdentityMailFromAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutEmailIdentityMailFromAttributesInput {
                email_identity: self.email_identity,
                mail_from_domain: self.mail_from_domain,
                behavior_on_mx_failure: self.behavior_on_mx_failure,
            })
        }
    }
}
#[doc(hidden)]
pub type PutEmailIdentityMailFromAttributesInputOperationOutputAlias =
    crate::operation::PutEmailIdentityMailFromAttributes;
#[doc(hidden)]
pub type PutEmailIdentityMailFromAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutEmailIdentityMailFromAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutEmailIdentityMailFromAttributes`](crate::operation::PutEmailIdentityMailFromAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutEmailIdentityMailFromAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutEmailIdentityMailFromAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_82 = &_input.email_identity;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_82, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/mail-from",
                    EmailIdentity = email_identity
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutEmailIdentityMailFromAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_email_identity_mail_from_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutEmailIdentityMailFromAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutEmailIdentityMailFromAttributes",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutEmailIdentityMailFromAttributesInput`](crate::input::PutEmailIdentityMailFromAttributesInput)
    pub fn builder() -> crate::input::put_email_identity_mail_from_attributes_input::Builder {
        crate::input::put_email_identity_mail_from_attributes_input::Builder::default()
    }
}

/// See [`PutSuppressedDestinationInput`](crate::input::PutSuppressedDestinationInput)
pub mod put_suppressed_destination_input {
    /// A builder for [`PutSuppressedDestinationInput`](crate::input::PutSuppressedDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::SuppressionListReason>,
    }
    impl Builder {
        /// <p>The email address that should be added to the suppression list for your account.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address that should be added to the suppression list for your account.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
        pub fn reason(mut self, input: crate::model::SuppressionListReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SuppressionListReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSuppressedDestinationInput`](crate::input::PutSuppressedDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSuppressedDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSuppressedDestinationInput {
                email_address: self.email_address,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSuppressedDestinationInputOperationOutputAlias =
    crate::operation::PutSuppressedDestination;
#[doc(hidden)]
pub type PutSuppressedDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutSuppressedDestinationInput {
    /// Consumes the builder and constructs an Operation<[`PutSuppressedDestination`](crate::operation::PutSuppressedDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSuppressedDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutSuppressedDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/suppression/addresses")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutSuppressedDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_suppressed_destination(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSuppressedDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSuppressedDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutSuppressedDestinationInput`](crate::input::PutSuppressedDestinationInput)
    pub fn builder() -> crate::input::put_suppressed_destination_input::Builder {
        crate::input::put_suppressed_destination_input::Builder::default()
    }
}

/// See [`SendBulkEmailInput`](crate::input::SendBulkEmailInput)
pub mod send_bulk_email_input {
    /// A builder for [`SendBulkEmailInput`](crate::input::SendBulkEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) from_email_address_identity_arn: std::option::Option<std::string::String>,
        pub(crate) reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) feedback_forwarding_email_address: std::option::Option<std::string::String>,
        pub(crate) feedback_forwarding_email_address_identity_arn:
            std::option::Option<std::string::String>,
        pub(crate) default_email_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) default_content: std::option::Option<crate::model::BulkEmailContent>,
        pub(crate) bulk_email_entries:
            std::option::Option<std::vec::Vec<crate::model::BulkEmailEntry>>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_email_address_identity_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address_identity_arn = input;
            self
        }
        /// Appends an item to `reply_to_addresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reply_to_addresses.unwrap_or_default();
            v.push(input.into());
            self.reply_to_addresses = Some(v);
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reply_to_addresses = input;
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address = Some(input.into());
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address_identity_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address_identity_arn = input;
            self
        }
        /// Appends an item to `default_email_tags`.
        ///
        /// To override the contents of this collection use [`set_default_email_tags`](Self::set_default_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn default_email_tags(mut self, input: crate::model::MessageTag) -> Self {
            let mut v = self.default_email_tags.unwrap_or_default();
            v.push(input);
            self.default_email_tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn set_default_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.default_email_tags = input;
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template message.</p>
        pub fn default_content(mut self, input: crate::model::BulkEmailContent) -> Self {
            self.default_content = Some(input);
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template message.</p>
        pub fn set_default_content(
            mut self,
            input: std::option::Option<crate::model::BulkEmailContent>,
        ) -> Self {
            self.default_content = input;
            self
        }
        /// Appends an item to `bulk_email_entries`.
        ///
        /// To override the contents of this collection use [`set_bulk_email_entries`](Self::set_bulk_email_entries).
        ///
        /// <p>The list of bulk email entry objects.</p>
        pub fn bulk_email_entries(mut self, input: crate::model::BulkEmailEntry) -> Self {
            let mut v = self.bulk_email_entries.unwrap_or_default();
            v.push(input);
            self.bulk_email_entries = Some(v);
            self
        }
        /// <p>The list of bulk email entry objects.</p>
        pub fn set_bulk_email_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailEntry>>,
        ) -> Self {
            self.bulk_email_entries = input;
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBulkEmailInput`](crate::input::SendBulkEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendBulkEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendBulkEmailInput {
                from_email_address: self.from_email_address,
                from_email_address_identity_arn: self.from_email_address_identity_arn,
                reply_to_addresses: self.reply_to_addresses,
                feedback_forwarding_email_address: self.feedback_forwarding_email_address,
                feedback_forwarding_email_address_identity_arn: self
                    .feedback_forwarding_email_address_identity_arn,
                default_email_tags: self.default_email_tags,
                default_content: self.default_content,
                bulk_email_entries: self.bulk_email_entries,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SendBulkEmailInputOperationOutputAlias = crate::operation::SendBulkEmail;
#[doc(hidden)]
pub type SendBulkEmailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendBulkEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendBulkEmail`](crate::operation::SendBulkEmail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendBulkEmail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendBulkEmailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/outbound-bulk-emails")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendBulkEmailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_bulk_email(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendBulkEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendBulkEmail",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendBulkEmailInput`](crate::input::SendBulkEmailInput)
    pub fn builder() -> crate::input::send_bulk_email_input::Builder {
        crate::input::send_bulk_email_input::Builder::default()
    }
}

/// See [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
pub mod send_custom_verification_email_input {
    /// A builder for [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendCustomVerificationEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendCustomVerificationEmailInput {
                email_address: self.email_address,
                template_name: self.template_name,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SendCustomVerificationEmailInputOperationOutputAlias =
    crate::operation::SendCustomVerificationEmail;
#[doc(hidden)]
pub type SendCustomVerificationEmailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendCustomVerificationEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendCustomVerificationEmail`](crate::operation::SendCustomVerificationEmail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendCustomVerificationEmail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendCustomVerificationEmailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/outbound-custom-verification-emails")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendCustomVerificationEmailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_custom_verification_email(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendCustomVerificationEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendCustomVerificationEmail",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
    pub fn builder() -> crate::input::send_custom_verification_email_input::Builder {
        crate::input::send_custom_verification_email_input::Builder::default()
    }
}

/// See [`SendEmailInput`](crate::input::SendEmailInput)
pub mod send_email_input {
    /// A builder for [`SendEmailInput`](crate::input::SendEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) from_email_address_identity_arn: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) feedback_forwarding_email_address: std::option::Option<std::string::String>,
        pub(crate) feedback_forwarding_email_address_identity_arn:
            std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::EmailContent>,
        pub(crate) email_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) list_management_options:
            std::option::Option<crate::model::ListManagementOptions>,
    }
    impl Builder {
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_email_address_identity_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address_identity_arn = input;
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Appends an item to `reply_to_addresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reply_to_addresses.unwrap_or_default();
            v.push(input.into());
            self.reply_to_addresses = Some(v);
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reply_to_addresses = input;
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address = Some(input.into());
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address_identity_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feedback_forwarding_email_address_identity_arn = input;
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
        pub fn content(mut self, input: crate::model::EmailContent) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Appends an item to `email_tags`.
        ///
        /// To override the contents of this collection use [`set_email_tags`](Self::set_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn email_tags(mut self, input: crate::model::MessageTag) -> Self {
            let mut v = self.email_tags.unwrap_or_default();
            v.push(input);
            self.email_tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
        pub fn set_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.email_tags = input;
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
        pub fn list_management_options(
            mut self,
            input: crate::model::ListManagementOptions,
        ) -> Self {
            self.list_management_options = Some(input);
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
        pub fn set_list_management_options(
            mut self,
            input: std::option::Option<crate::model::ListManagementOptions>,
        ) -> Self {
            self.list_management_options = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEmailInput`](crate::input::SendEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SendEmailInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SendEmailInput {
                from_email_address: self.from_email_address,
                from_email_address_identity_arn: self.from_email_address_identity_arn,
                destination: self.destination,
                reply_to_addresses: self.reply_to_addresses,
                feedback_forwarding_email_address: self.feedback_forwarding_email_address,
                feedback_forwarding_email_address_identity_arn: self
                    .feedback_forwarding_email_address_identity_arn,
                content: self.content,
                email_tags: self.email_tags,
                configuration_set_name: self.configuration_set_name,
                list_management_options: self.list_management_options,
            })
        }
    }
}
#[doc(hidden)]
pub type SendEmailInputOperationOutputAlias = crate::operation::SendEmail;
#[doc(hidden)]
pub type SendEmailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendEmail`](crate::operation::SendEmail)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendEmail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SendEmailInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/outbound-emails").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SendEmailInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_email(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SendEmail::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SendEmail",
                    "sesv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SendEmailInput`](crate::input::SendEmailInput)
    pub fn builder() -> crate::input::send_email_input::Builder {
        crate::input::send_email_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/tags").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestRenderEmailTemplateInput`](crate::input::TestRenderEmailTemplateInput)
pub mod test_render_email_template_input {
    /// A builder for [`TestRenderEmailTemplateInput`](crate::input::TestRenderEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRenderEmailTemplateInput`](crate::input::TestRenderEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestRenderEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestRenderEmailTemplateInput {
                template_name: self.template_name,
                template_data: self.template_data,
            })
        }
    }
}
#[doc(hidden)]
pub type TestRenderEmailTemplateInputOperationOutputAlias =
    crate::operation::TestRenderEmailTemplate;
#[doc(hidden)]
pub type TestRenderEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TestRenderEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`TestRenderEmailTemplate`](crate::operation::TestRenderEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestRenderEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TestRenderEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.template_name;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_83, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/templates/{TemplateName}/render",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TestRenderEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_test_render_email_template(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestRenderEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestRenderEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TestRenderEmailTemplateInput`](crate::input::TestRenderEmailTemplateInput)
    pub fn builder() -> crate::input::test_render_email_template_input::Builder {
        crate::input::test_render_email_template_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2/email/tags").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_84) = &_input.resource_arn {
                    query.push_kv(
                        "ResourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_84),
                    );
                }
                if let Some(inner_85) = &_input.tag_keys {
                    for inner_86 in inner_85 {
                        query.push_kv("TagKeys", &aws_smithy_http::query::fmt_string(&inner_86));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
pub mod update_configuration_set_event_destination_input {
    /// A builder for [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
    }
    impl Builder {
        /// <p>The name of the configuration set that contains the event destination to modify.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination to modify.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(
            mut self,
            input: crate::model::EventDestinationDefinition,
        ) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                event_destination: self.event_destination,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetEventDestination;
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetEventDestination`](crate::operation::UpdateConfigurationSetEventDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetEventDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateConfigurationSetEventDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.configuration_set_name;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let configuration_set_name = aws_smithy_http::label::fmt_string(input_87, false);
                if configuration_set_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "configuration_set_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_88 = &_input.event_destination_name;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let event_destination_name = aws_smithy_http::label::fmt_string(input_88, false);
                if event_destination_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "event_destination_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}", ConfigurationSetName = configuration_set_name, EventDestinationName = event_destination_name).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateConfigurationSetEventDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_event_destination(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetEventDestination",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::update_configuration_set_event_destination_input::Builder {
        crate::input::update_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`UpdateContactInput`](crate::input::UpdateContactInput)
pub mod update_contact_input {
    /// A builder for [`UpdateContactInput`](crate::input::UpdateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) topic_preferences:
            std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        pub(crate) unsubscribe_all: std::option::Option<bool>,
        pub(crate) attributes_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Appends an item to `topic_preferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn topic_preferences(mut self, input: crate::model::TopicPreference) -> Self {
            let mut v = self.topic_preferences.unwrap_or_default();
            v.push(input);
            self.topic_preferences = Some(v);
            self
        }
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.topic_preferences = input;
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn unsubscribe_all(mut self, input: bool) -> Self {
            self.unsubscribe_all = Some(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.unsubscribe_all = input;
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.attributes_data = Some(input.into());
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attributes_data = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactInput`](crate::input::UpdateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactInput {
                contact_list_name: self.contact_list_name,
                email_address: self.email_address,
                topic_preferences: self.topic_preferences,
                unsubscribe_all: self.unsubscribe_all.unwrap_or_default(),
                attributes_data: self.attributes_data,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactInputOperationOutputAlias = crate::operation::UpdateContact;
#[doc(hidden)]
pub type UpdateContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContact`](crate::operation::UpdateContact)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateContactInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.contact_list_name;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_89, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_90 = &_input.email_address;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_address = aws_smithy_http::label::fmt_string(input_90, false);
                if email_address.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_address",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}/contacts/{EmailAddress}",
                    ContactListName = contact_list_name,
                    EmailAddress = email_address
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateContactInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_contact(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContact",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactInput`](crate::input::UpdateContactInput)
    pub fn builder() -> crate::input::update_contact_input::Builder {
        crate::input::update_contact_input::Builder::default()
    }
}

/// See [`UpdateContactListInput`](crate::input::UpdateContactListInput)
pub mod update_contact_list_input {
    /// A builder for [`UpdateContactListInput`](crate::input::UpdateContactListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_list_name: std::option::Option<std::string::String>,
        pub(crate) topics: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_list_name = Some(input.into());
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_list_name = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn topics(mut self, input: crate::model::Topic) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input);
            self.topics = Some(v);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactListInput`](crate::input::UpdateContactListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactListInput {
                contact_list_name: self.contact_list_name,
                topics: self.topics,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactListInputOperationOutputAlias = crate::operation::UpdateContactList;
#[doc(hidden)]
pub type UpdateContactListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactListInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContactList`](crate::operation::UpdateContactList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContactList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateContactListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.contact_list_name;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let contact_list_name = aws_smithy_http::label::fmt_string(input_91, false);
                if contact_list_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_list_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/contact-lists/{ContactListName}",
                    ContactListName = contact_list_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateContactListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_contact_list(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContactList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContactList",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactListInput`](crate::input::UpdateContactListInput)
    pub fn builder() -> crate::input::update_contact_list_input::Builder {
        crate::input::update_contact_list_input::Builder::default()
    }
}

/// See [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
pub mod update_custom_verification_email_template_input {
    /// A builder for [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_content = Some(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                template_content: self.template_content,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::UpdateCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type UpdateCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomVerificationEmailTemplate`](crate::operation::UpdateCustomVerificationEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomVerificationEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCustomVerificationEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.template_name;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_92, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/custom-verification-email-templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCustomVerificationEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_custom_verification_email_template(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomVerificationEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::update_custom_verification_email_template_input::Builder {
        crate::input::update_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`UpdateEmailIdentityPolicyInput`](crate::input::UpdateEmailIdentityPolicyInput)
pub mod update_email_identity_policy_input {
    /// A builder for [`UpdateEmailIdentityPolicyInput`](crate::input::UpdateEmailIdentityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_identity: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_identity = Some(input.into());
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_identity = input;
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEmailIdentityPolicyInput`](crate::input::UpdateEmailIdentityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEmailIdentityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEmailIdentityPolicyInput {
                email_identity: self.email_identity,
                policy_name: self.policy_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEmailIdentityPolicyInputOperationOutputAlias =
    crate::operation::UpdateEmailIdentityPolicy;
#[doc(hidden)]
pub type UpdateEmailIdentityPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEmailIdentityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEmailIdentityPolicy`](crate::operation::UpdateEmailIdentityPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEmailIdentityPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEmailIdentityPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_93 = &_input.email_identity;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    },
                )?;
                let email_identity = aws_smithy_http::label::fmt_string(input_93, false);
                if email_identity.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "email_identity",
                        details: "cannot be empty or unset",
                    });
                }
                let input_94 = &_input.policy_name;
                let input_94 = input_94.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_94, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
                    EmailIdentity = email_identity,
                    PolicyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEmailIdentityPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_email_identity_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEmailIdentityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEmailIdentityPolicy",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEmailIdentityPolicyInput`](crate::input::UpdateEmailIdentityPolicyInput)
    pub fn builder() -> crate::input::update_email_identity_policy_input::Builder {
        crate::input::update_email_identity_policy_input::Builder::default()
    }
}

/// See [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
pub mod update_email_template_input {
    /// A builder for [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<crate::model::EmailTemplateContent>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template_content(mut self, input: crate::model::EmailTemplateContent) -> Self {
            self.template_content = Some(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEmailTemplateInput {
                template_name: self.template_name,
                template_content: self.template_content,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEmailTemplateInputOperationOutputAlias = crate::operation::UpdateEmailTemplate;
#[doc(hidden)]
pub type UpdateEmailTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEmailTemplate`](crate::operation::UpdateEmailTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEmailTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEmailTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.template_name;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_95, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v2/email/templates/{TemplateName}",
                    TemplateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEmailTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_email_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEmailTemplate",
            "sesv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEmailTemplateInput`](crate::input::UpdateEmailTemplateInput)
    pub fn builder() -> crate::input::update_email_template_input::Builder {
        crate::input::update_email_template_input::Builder::default()
    }
}

/// <p>Represents a request to update an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    pub template_content: std::option::Option<crate::model::EmailTemplateContent>,
}
impl UpdateEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    pub fn template_content(&self) -> std::option::Option<&crate::model::EmailTemplateContent> {
        self.template_content.as_ref()
    }
}
impl std::fmt::Debug for UpdateEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_content", &self.template_content);
        formatter.finish()
    }
}

/// <p>Represents a request to update a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl UpdateEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for UpdateEmailIdentityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEmailIdentityPolicyInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>Represents a request to update an existing custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to update.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    pub template_content: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl UpdateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to update.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    pub fn template_content(&self) -> std::option::Option<&str> {
        self.template_content.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for UpdateCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("template_content", &self.template_content);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactListInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    pub topics: std::option::Option<std::vec::Vec<crate::model::Topic>>,
    /// <p>A description of what the contact list is about.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateContactListInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    pub fn topics(&self) -> std::option::Option<&[crate::model::Topic]> {
        self.topics.as_deref()
    }
    /// <p>A description of what the contact list is about.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateContactListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactListInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("topics", &self.topics);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>The contact's email addres.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
    pub topic_preferences: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    pub unsubscribe_all: bool,
    /// <p>The attribute data attached to a contact.</p>
    pub attributes_data: std::option::Option<std::string::String>,
}
impl UpdateContactInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>The contact's email addres.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
    pub fn topic_preferences(&self) -> std::option::Option<&[crate::model::TopicPreference]> {
        self.topic_preferences.as_deref()
    }
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    pub fn unsubscribe_all(&self) -> bool {
        self.unsubscribe_all
    }
    /// <p>The attribute data attached to a contact.</p>
    pub fn attributes_data(&self) -> std::option::Option<&str> {
        self.attributes_data.as_deref()
    }
}
impl std::fmt::Debug for UpdateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("email_address", &self.email_address);
        formatter.field("topic_preferences", &self.topic_preferences);
        formatter.field("unsubscribe_all", &self.unsubscribe_all);
        formatter.field("attributes_data", &self.attributes_data);
        formatter.finish()
    }
}

/// <p>A request to change the settings for an event destination for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination to modify.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the event destination.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    /// <p>An object that defines the event destination.</p>
    pub event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
}
impl UpdateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination to modify.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name of the event destination.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
    /// <p>An object that defines the event destination.</p>
    pub fn event_destination(
        &self,
    ) -> std::option::Option<&crate::model::EventDestinationDefinition> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for UpdateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
    /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p>
    /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>&gt;Represents a request to create a preview of the MIME content of an email when provided with a template and a set of replacement data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRenderEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    pub template_data: std::option::Option<std::string::String>,
}
impl TestRenderEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    pub fn template_data(&self) -> std::option::Option<&str> {
        self.template_data.as_deref()
    }
}
impl std::fmt::Debug for TestRenderEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRenderEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_data", &self.template_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents a request to send a single formatted email using Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEmailInput {
    /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
    pub from_email_address_identity_arn: std::option::Option<std::string::String>,
    /// <p>An object that contains the recipients of the email message.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    pub reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
    pub feedback_forwarding_email_address: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub feedback_forwarding_email_address_identity_arn: std::option::Option<std::string::String>,
    /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
    pub content: std::option::Option<crate::model::EmailContent>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
    pub email_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The name of the configuration set to use when sending the email.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
    pub list_management_options: std::option::Option<crate::model::ListManagementOptions>,
}
impl SendEmailInput {
    /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified. </p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>
    pub fn from_email_address_identity_arn(&self) -> std::option::Option<&str> {
        self.from_email_address_identity_arn.as_deref()
    }
    /// <p>An object that contains the recipients of the email message.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    pub fn reply_to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.reply_to_addresses.as_deref()
    }
    /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
    pub fn feedback_forwarding_email_address(&self) -> std::option::Option<&str> {
        self.feedback_forwarding_email_address.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub fn feedback_forwarding_email_address_identity_arn(&self) -> std::option::Option<&str> {
        self.feedback_forwarding_email_address_identity_arn
            .as_deref()
    }
    /// <p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::EmailContent> {
        self.content.as_ref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>
    pub fn email_tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.email_tags.as_deref()
    }
    /// <p>The name of the configuration set to use when sending the email.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An object used to specify a list or topic to which an email belongs, which will be used when a contact chooses to unsubscribe.</p>
    pub fn list_management_options(
        &self,
    ) -> std::option::Option<&crate::model::ListManagementOptions> {
        self.list_management_options.as_ref()
    }
}
impl std::fmt::Debug for SendEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEmailInput");
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field(
            "from_email_address_identity_arn",
            &self.from_email_address_identity_arn,
        );
        formatter.field("destination", &self.destination);
        formatter.field("reply_to_addresses", &self.reply_to_addresses);
        formatter.field(
            "feedback_forwarding_email_address",
            &self.feedback_forwarding_email_address,
        );
        formatter.field(
            "feedback_forwarding_email_address_identity_arn",
            &self.feedback_forwarding_email_address_identity_arn,
        );
        formatter.field("content", &self.content);
        formatter.field("email_tags", &self.email_tags);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("list_management_options", &self.list_management_options);
        formatter.finish()
    }
}

/// <p>Represents a request to send a custom verification email to a specified recipient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendCustomVerificationEmailInput {
    /// <p>The email address to verify.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The name of the custom verification email template to use when sending the verification email.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Name of a configuration set to use when sending the verification email.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl SendCustomVerificationEmailInput {
    /// <p>The email address to verify.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The name of the custom verification email template to use when sending the verification email.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Name of a configuration set to use when sending the verification email.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for SendCustomVerificationEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendCustomVerificationEmailInput");
        formatter.field("email_address", &self.email_address);
        formatter.field("template_name", &self.template_name);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to send email messages to multiple destinations using Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBulkEmailInput {
    /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub from_email_address_identity_arn: std::option::Option<std::string::String>,
    /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    pub reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
    pub feedback_forwarding_email_address: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub feedback_forwarding_email_address_identity_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    pub default_email_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>An object that contains the body of the message. You can specify a template message.</p>
    pub default_content: std::option::Option<crate::model::BulkEmailContent>,
    /// <p>The list of bulk email entry objects.</p>
    pub bulk_email_entries: std::option::Option<std::vec::Vec<crate::model::BulkEmailEntry>>,
    /// <p>The name of the configuration set to use when sending the email.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl SendBulkEmailInput {
    /// <p>The email address to use as the "From" address for the email. The address that you specify has to be verified.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub fn from_email_address_identity_arn(&self) -> std::option::Option<&str> {
        self.from_email_address_identity_arn.as_deref()
    }
    /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>
    pub fn reply_to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.reply_to_addresses.as_deref()
    }
    /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
    pub fn feedback_forwarding_email_address(&self) -> std::option::Option<&str> {
        self.feedback_forwarding_email_address.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p>
    /// <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    pub fn feedback_forwarding_email_address_identity_arn(&self) -> std::option::Option<&str> {
        self.feedback_forwarding_email_address_identity_arn
            .as_deref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    pub fn default_email_tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.default_email_tags.as_deref()
    }
    /// <p>An object that contains the body of the message. You can specify a template message.</p>
    pub fn default_content(&self) -> std::option::Option<&crate::model::BulkEmailContent> {
        self.default_content.as_ref()
    }
    /// <p>The list of bulk email entry objects.</p>
    pub fn bulk_email_entries(&self) -> std::option::Option<&[crate::model::BulkEmailEntry]> {
        self.bulk_email_entries.as_deref()
    }
    /// <p>The name of the configuration set to use when sending the email.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for SendBulkEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBulkEmailInput");
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field(
            "from_email_address_identity_arn",
            &self.from_email_address_identity_arn,
        );
        formatter.field("reply_to_addresses", &self.reply_to_addresses);
        formatter.field(
            "feedback_forwarding_email_address",
            &self.feedback_forwarding_email_address,
        );
        formatter.field(
            "feedback_forwarding_email_address_identity_arn",
            &self.feedback_forwarding_email_address_identity_arn,
        );
        formatter.field("default_email_tags", &self.default_email_tags);
        formatter.field("default_content", &self.default_content);
        formatter.field("bulk_email_entries", &self.bulk_email_entries);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>A request to add an email destination to the suppression list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSuppressedDestinationInput {
    /// <p>The email address that should be added to the suppression list for your account.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
    pub reason: std::option::Option<crate::model::SuppressionListReason>,
}
impl PutSuppressedDestinationInput {
    /// <p>The email address that should be added to the suppression list for your account.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The factors that should cause the email address to be added to the suppression list for your account.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::SuppressionListReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for PutSuppressedDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSuppressedDestinationInput");
        formatter.field("email_address", &self.email_address);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

/// <p>A request to configure the custom MAIL FROM domain for a verified identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailIdentityMailFromAttributesInput {
    /// <p>The verified email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
    /// <ul>
    /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
    /// <li> <p>It can't be used to receive email.</p> </li>
    /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
    /// </ul>
    pub mail_from_domain: std::option::Option<std::string::String>,
    /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
    /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
    pub behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
}
impl PutEmailIdentityMailFromAttributesInput {
    /// <p>The verified email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p>
    /// <ul>
    /// <li> <p>It has to be a subdomain of the verified identity.</p> </li>
    /// <li> <p>It can't be used to receive email.</p> </li>
    /// <li> <p>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li>
    /// </ul>
    pub fn mail_from_domain(&self) -> std::option::Option<&str> {
        self.mail_from_domain.as_deref()
    }
    /// <p>The action to take if the required MX record isn't found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
    /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
    pub fn behavior_on_mx_failure(
        &self,
    ) -> std::option::Option<&crate::model::BehaviorOnMxFailure> {
        self.behavior_on_mx_failure.as_ref()
    }
}
impl std::fmt::Debug for PutEmailIdentityMailFromAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailIdentityMailFromAttributesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("mail_from_domain", &self.mail_from_domain);
        formatter.field("behavior_on_mx_failure", &self.behavior_on_mx_failure);
        formatter.finish()
    }
}

/// <p>A request to set the attributes that control how bounce and complaint events are processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailIdentityFeedbackAttributesInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>Sets the feedback forwarding configuration for the identity.</p>
    /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
    /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
    pub email_forwarding_enabled: bool,
}
impl PutEmailIdentityFeedbackAttributesInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>Sets the feedback forwarding configuration for the identity.</p>
    /// <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p>
    /// <p>You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>
    pub fn email_forwarding_enabled(&self) -> bool {
        self.email_forwarding_enabled
    }
}
impl std::fmt::Debug for PutEmailIdentityFeedbackAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailIdentityFeedbackAttributesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("email_forwarding_enabled", &self.email_forwarding_enabled);
        formatter.finish()
    }
}

/// <p>A request to change the DKIM attributes for an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailIdentityDkimSigningAttributesInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
    /// <ul>
    /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
    /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
    /// </ul>
    pub signing_attributes_origin: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
    /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    pub signing_attributes: std::option::Option<crate::model::DkimSigningAttributes>,
}
impl PutEmailIdentityDkimSigningAttributesInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>The method to use to configure DKIM for the identity. There are the following possible values:</p>
    /// <ul>
    /// <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li>
    /// <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li>
    /// </ul>
    pub fn signing_attributes_origin(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningAttributesOrigin> {
        self.signing_attributes_origin.as_ref()
    }
    /// <p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    pub fn signing_attributes(&self) -> std::option::Option<&crate::model::DkimSigningAttributes> {
        self.signing_attributes.as_ref()
    }
}
impl std::fmt::Debug for PutEmailIdentityDkimSigningAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailIdentityDkimSigningAttributesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("signing_attributes_origin", &self.signing_attributes_origin);
        formatter.field("signing_attributes", &self.signing_attributes);
        formatter.finish()
    }
}

/// <p>A request to enable or disable DKIM signing of email that you send from an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailIdentityDkimAttributesInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>Sets the DKIM signing configuration for the identity.</p>
    /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
    pub signing_enabled: bool,
}
impl PutEmailIdentityDkimAttributesInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>Sets the DKIM signing configuration for the identity.</p>
    /// <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>
    pub fn signing_enabled(&self) -> bool {
        self.signing_enabled
    }
}
impl std::fmt::Debug for PutEmailIdentityDkimAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailIdentityDkimAttributesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("signing_enabled", &self.signing_enabled);
        formatter.finish()
    }
}

/// <p>A request to associate a configuration set with an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEmailIdentityConfigurationSetAttributesInput {
    /// <p>The email address or domain to associate with a configuration set.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>The configuration set to associate with an email identity.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl PutEmailIdentityConfigurationSetAttributesInput {
    /// <p>The email address or domain to associate with a configuration set.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>The configuration set to associate with an email identity.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for PutEmailIdentityConfigurationSetAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEmailIdentityConfigurationSetAttributesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p>
/// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDeliverabilityDashboardOptionInput {
    /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
    pub dashboard_enabled: bool,
    /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
    pub subscribed_domains:
        std::option::Option<std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>>,
}
impl PutDeliverabilityDashboardOptionInput {
    /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>
    pub fn dashboard_enabled(&self) -> bool {
        self.dashboard_enabled
    }
    /// <p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>
    pub fn subscribed_domains(
        &self,
    ) -> std::option::Option<&[crate::model::DomainDeliverabilityTrackingOption]> {
        self.subscribed_domains.as_deref()
    }
}
impl std::fmt::Debug for PutDeliverabilityDashboardOptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDeliverabilityDashboardOptionInput");
        formatter.field("dashboard_enabled", &self.dashboard_enabled);
        formatter.field("subscribed_domains", &self.subscribed_domains);
        formatter.finish()
    }
}

/// <p>A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you want to resume the warm-up process for an existing IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDedicatedIpWarmupAttributesInput {
    /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
    pub warmup_percentage: std::option::Option<i32>,
}
impl PutDedicatedIpWarmupAttributesInput {
    /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
    /// <p>The warm-up percentage that you want to associate with the dedicated IP address.</p>
    pub fn warmup_percentage(&self) -> std::option::Option<i32> {
        self.warmup_percentage
    }
}
impl std::fmt::Debug for PutDedicatedIpWarmupAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDedicatedIpWarmupAttributesInput");
        formatter.field("ip", &self.ip);
        formatter.field("warmup_percentage", &self.warmup_percentage);
        formatter.finish()
    }
}

/// <p>A request to move a dedicated IP address to a dedicated IP pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDedicatedIpInPoolInput {
    /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
    pub destination_pool_name: std::option::Option<std::string::String>,
}
impl PutDedicatedIpInPoolInput {
    /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
    /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>
    pub fn destination_pool_name(&self) -> std::option::Option<&str> {
        self.destination_pool_name.as_deref()
    }
}
impl std::fmt::Debug for PutDedicatedIpInPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDedicatedIpInPoolInput");
        formatter.field("ip", &self.ip);
        formatter.field("destination_pool_name", &self.destination_pool_name);
        formatter.finish()
    }
}

/// <p>A request to add a custom domain for tracking open and click events to a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The domain to use to track open and click events.</p>
    pub custom_redirect_domain: std::option::Option<std::string::String>,
}
impl PutConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The domain to use to track open and click events.</p>
    pub fn custom_redirect_domain(&self) -> std::option::Option<&str> {
        self.custom_redirect_domain.as_deref()
    }
}
impl std::fmt::Debug for PutConfigurationSetTrackingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetTrackingOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("custom_redirect_domain", &self.custom_redirect_domain);
        formatter.finish()
    }
}

/// <p>A request to change the account suppression list preferences for a specific configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetSuppressionOptionsInput {
    /// <p>The name of the configuration set to change the suppression list preferences for.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
    /// <ul>
    /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
    /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
    /// </ul>
    pub suppressed_reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
}
impl PutConfigurationSetSuppressionOptionsInput {
    /// <p>The name of the configuration set to change the suppression list preferences for.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
    /// <ul>
    /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
    /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
    /// </ul>
    pub fn suppressed_reasons(
        &self,
    ) -> std::option::Option<&[crate::model::SuppressionListReason]> {
        self.suppressed_reasons.as_deref()
    }
}
impl std::fmt::Debug for PutConfigurationSetSuppressionOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetSuppressionOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("suppressed_reasons", &self.suppressed_reasons);
        formatter.finish()
    }
}

/// <p>A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetSendingOptionsInput {
    /// <p>The name of the configuration set to enable or disable email sending for.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
    pub sending_enabled: bool,
}
impl PutConfigurationSetSendingOptionsInput {
    /// <p>The name of the configuration set to enable or disable email sending for.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>
    pub fn sending_enabled(&self) -> bool {
        self.sending_enabled
    }
}
impl std::fmt::Debug for PutConfigurationSetSendingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetSendingOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("sending_enabled", &self.sending_enabled);
        formatter.finish()
    }
}

/// <p>A request to enable or disable tracking of reputation metrics for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetReputationOptionsInput {
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
    pub reputation_metrics_enabled: bool,
}
impl PutConfigurationSetReputationOptionsInput {
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>
    pub fn reputation_metrics_enabled(&self) -> bool {
        self.reputation_metrics_enabled
    }
}
impl std::fmt::Debug for PutConfigurationSetReputationOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetReputationOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field(
            "reputation_metrics_enabled",
            &self.reputation_metrics_enabled,
        );
        formatter.finish()
    }
}

/// <p>A request to associate a configuration set with a dedicated IP pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetDeliveryOptionsInput {
    /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub tls_policy: std::option::Option<crate::model::TlsPolicy>,
    /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
    pub sending_pool_name: std::option::Option<std::string::String>,
}
impl PutConfigurationSetDeliveryOptionsInput {
    /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub fn tls_policy(&self) -> std::option::Option<&crate::model::TlsPolicy> {
        self.tls_policy.as_ref()
    }
    /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
    pub fn sending_pool_name(&self) -> std::option::Option<&str> {
        self.sending_pool_name.as_deref()
    }
}
impl std::fmt::Debug for PutConfigurationSetDeliveryOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetDeliveryOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tls_policy", &self.tls_policy);
        formatter.field("sending_pool_name", &self.sending_pool_name);
        formatter.finish()
    }
}

/// <p>A request to change your account's suppression preferences.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSuppressionAttributesInput {
    /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
    /// <ul>
    /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
    /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
    /// </ul>
    pub suppressed_reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
}
impl PutAccountSuppressionAttributesInput {
    /// <p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p>
    /// <ul>
    /// <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li>
    /// <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li>
    /// </ul>
    pub fn suppressed_reasons(
        &self,
    ) -> std::option::Option<&[crate::model::SuppressionListReason]> {
        self.suppressed_reasons.as_deref()
    }
}
impl std::fmt::Debug for PutAccountSuppressionAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSuppressionAttributesInput");
        formatter.field("suppressed_reasons", &self.suppressed_reasons);
        formatter.finish()
    }
}

/// <p>A request to change the ability of your account to send email.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSendingAttributesInput {
    /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
    /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
    /// </note>
    pub sending_enabled: bool,
}
impl PutAccountSendingAttributesInput {
    /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note>
    /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation to resume your account's ability to send email.</p>
    /// </note>
    pub fn sending_enabled(&self) -> bool {
        self.sending_enabled
    }
}
impl std::fmt::Debug for PutAccountSendingAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSendingAttributesInput");
        formatter.field("sending_enabled", &self.sending_enabled);
        formatter.finish()
    }
}

/// <p>A request to submit new account details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountDetailsInput {
    /// <p>The type of email your account will send.</p>
    pub mail_type: std::option::Option<crate::model::MailType>,
    /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
    pub website_url: std::option::Option<std::string::String>,
    /// <p>The language you would prefer to be contacted with.</p>
    pub contact_language: std::option::Option<crate::model::ContactLanguage>,
    /// <p>A description of the types of email that you plan to send.</p>
    pub use_case_description: std::option::Option<std::string::String>,
    /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
    pub additional_contact_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
    /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
    /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
    pub production_access_enabled: std::option::Option<bool>,
}
impl PutAccountDetailsInput {
    /// <p>The type of email your account will send.</p>
    pub fn mail_type(&self) -> std::option::Option<&crate::model::MailType> {
        self.mail_type.as_ref()
    }
    /// <p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>
    pub fn website_url(&self) -> std::option::Option<&str> {
        self.website_url.as_deref()
    }
    /// <p>The language you would prefer to be contacted with.</p>
    pub fn contact_language(&self) -> std::option::Option<&crate::model::ContactLanguage> {
        self.contact_language.as_ref()
    }
    /// <p>A description of the types of email that you plan to send.</p>
    pub fn use_case_description(&self) -> std::option::Option<&str> {
        self.use_case_description.as_deref()
    }
    /// <p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>
    pub fn additional_contact_email_addresses(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.additional_contact_email_addresses.as_deref()
    }
    /// <p>Indicates whether or not your account should have production access in the current Amazon Web Services Region.</p>
    /// <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p>
    /// <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>
    pub fn production_access_enabled(&self) -> std::option::Option<bool> {
        self.production_access_enabled
    }
}
impl std::fmt::Debug for PutAccountDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountDetailsInput");
        formatter.field("mail_type", &self.mail_type);
        formatter.field("website_url", &"*** Sensitive Data Redacted ***");
        formatter.field("contact_language", &self.contact_language);
        formatter.field("use_case_description", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "additional_contact_email_addresses",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("production_access_enabled", &self.production_access_enabled);
        formatter.finish()
    }
}

/// <p>A request to enable or disable the automatic IP address warm-up feature.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountDedicatedIpWarmupAttributesInput {
    /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
    pub auto_warmup_enabled: bool,
}
impl PutAccountDedicatedIpWarmupAttributesInput {
    /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>
    pub fn auto_warmup_enabled(&self) -> bool {
        self.auto_warmup_enabled
    }
}
impl std::fmt::Debug for PutAccountDedicatedIpWarmupAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountDedicatedIpWarmupAttributesInput");
        formatter.field("auto_warmup_enabled", &self.auto_warmup_enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p>A request to obtain a list of email destinations that are on the suppression list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuppressedDestinationsInput {
    /// <p>The factors that caused the email address to be added to .</p>
    pub reasons: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
    /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListSuppressedDestinationsInput {
    /// <p>The factors that caused the email address to be added to .</p>
    pub fn reasons(&self) -> std::option::Option<&[crate::model::SuppressionListReason]> {
        self.reasons.as_deref()
    }
    /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
    /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListSuppressedDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuppressedDestinationsInput");
        formatter.field("reasons", &self.reasons);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Represents a request to list all of the import jobs for a data destination within the specified maximum number of import jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImportJobsInput {
    /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
    pub import_destination_type: std::option::Option<crate::model::ImportDestinationType>,
    /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListImportJobsInput {
    /// <p>The destination of the import job, which can be used to list import jobs that have a certain <code>ImportDestinationType</code>.</p>
    pub fn import_destination_type(
        &self,
    ) -> std::option::Option<&crate::model::ImportDestinationType> {
        self.import_destination_type.as_ref()
    }
    /// <p>A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional addresses.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListImportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImportJobsInput");
        formatter.field("import_destination_type", &self.import_destination_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Represents a request to list the email templates present in your Amazon SES account in the current Amazon Web Services Region. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEmailTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListEmailTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListEmailTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEmailTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>A request to list all of the email identities associated with your Amazon Web Services account. This list includes identities that you've already verified, identities that are unverified, and identities that were verified in the past, but are no longer verified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEmailIdentitiesInput {
    /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListEmailIdentitiesInput {
    /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListEmailIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEmailIdentitiesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainDeliverabilityCampaignsInput {
    /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The domain to obtain deliverability data for.</p>
    pub subscribed_domain: std::option::Option<std::string::String>,
    /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListDomainDeliverabilityCampaignsInput {
    /// <p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
    /// <p>The domain to obtain deliverability data for.</p>
    pub fn subscribed_domain(&self) -> std::option::Option<&str> {
        self.subscribed_domain.as_deref()
    }
    /// <p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListDomainDeliverabilityCampaignsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainDeliverabilityCampaignsInput");
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("subscribed_domain", &self.subscribed_domain);
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>A request to list all of the predictive inbox placement tests that you've performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeliverabilityTestReportsInput {
    /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListDeliverabilityTestReportsInput {
    /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListDeliverabilityTestReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeliverabilityTestReportsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>A request to obtain a list of dedicated IP pools.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDedicatedIpPoolsInput {
    /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListDedicatedIpPoolsInput {
    /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListDedicatedIpPoolsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDedicatedIpPoolsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>Represents a request to list the existing custom verification email templates for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomVerificationEmailTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListCustomVerificationEmailTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListCustomVerificationEmailTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomVerificationEmailTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>A filter that can be applied to a list of contacts.</p>
    pub filter: std::option::Option<crate::model::ListContactsFilter>,
    /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
    pub page_size: std::option::Option<i32>,
    /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContactsInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>A filter that can be applied to a list of contacts.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ListContactsFilter> {
        self.filter.as_ref()
    }
    /// <p>The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
    /// <p>A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("filter", &self.filter);
        formatter.field("page_size", &self.page_size);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactListsInput {
    /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
    pub page_size: std::option::Option<i32>,
    /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContactListsInput {
    /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value in subsequent requests to retrieve additional lists.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
    /// <p>A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContactListsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactListsInput");
        formatter.field("page_size", &self.page_size);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>A request to obtain a list of configuration sets for your Amazon SES account in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationSetsInput {
    /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub page_size: std::option::Option<i32>,
}
impl ListConfigurationSetsInput {
    /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for ListConfigurationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationSetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>A request to retrieve information about an email address that's on the suppression list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSuppressedDestinationInput {
    /// <p>The email address that's on the account suppression list.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl GetSuppressedDestinationInput {
    /// <p>The email address that's on the account suppression list.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for GetSuppressedDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSuppressedDestinationInput");
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>Represents a request for information about an import job using the import job ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImportJobInput {
    /// <p>The ID of the import job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetImportJobInput {
    /// <p>The ID of the import job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImportJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

/// <p>Represents a request to display the template object (which includes the subject line, HTML part and text part) for the template you specify.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl GetEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for GetEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

/// <p>A request to return the policies of an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEmailIdentityPoliciesInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
}
impl GetEmailIdentityPoliciesInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
}
impl std::fmt::Debug for GetEmailIdentityPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEmailIdentityPoliciesInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.finish()
    }
}

/// <p>A request to return details about an email identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEmailIdentityInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
}
impl GetEmailIdentityInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
}
impl std::fmt::Debug for GetEmailIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEmailIdentityInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.finish()
    }
}

/// <p>A request to obtain deliverability metrics for a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainStatisticsReportInput {
    /// <p>The domain that you want to obtain deliverability metrics for.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetDomainStatisticsReportInput {
    /// <p>The domain that you want to obtain deliverability metrics for.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
}
impl std::fmt::Debug for GetDomainStatisticsReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainStatisticsReportInput");
        formatter.field("domain", &self.domain);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.finish()
    }
}

/// <p>Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (<code>PutDeliverabilityDashboardOption</code> operation).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainDeliverabilityCampaignInput {
    /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
    pub campaign_id: std::option::Option<std::string::String>,
}
impl GetDomainDeliverabilityCampaignInput {
    /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>
    pub fn campaign_id(&self) -> std::option::Option<&str> {
        self.campaign_id.as_deref()
    }
}
impl std::fmt::Debug for GetDomainDeliverabilityCampaignInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainDeliverabilityCampaignInput");
        formatter.field("campaign_id", &self.campaign_id);
        formatter.finish()
    }
}

/// <p>A request to retrieve the results of a predictive inbox placement test.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeliverabilityTestReportInput {
    /// <p>A unique string that identifies the predictive inbox placement test.</p>
    pub report_id: std::option::Option<std::string::String>,
}
impl GetDeliverabilityTestReportInput {
    /// <p>A unique string that identifies the predictive inbox placement test.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeliverabilityTestReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeliverabilityTestReportInput");
        formatter.field("report_id", &self.report_id);
        formatter.finish()
    }
}

/// <p>Retrieve information about the status of the Deliverability dashboard for your Amazon Web Services account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p>
/// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeliverabilityDashboardOptionsInput {}
impl std::fmt::Debug for GetDeliverabilityDashboardOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeliverabilityDashboardOptionsInput");
        formatter.finish()
    }
}

/// <p>A request to obtain more information about dedicated IP pools.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDedicatedIpsInput {
    /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
    pub pool_name: std::option::Option<std::string::String>,
    /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub page_size: std::option::Option<i32>,
}
impl GetDedicatedIpsInput {
    /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
    pub fn pool_name(&self) -> std::option::Option<&str> {
        self.pool_name.as_deref()
    }
    /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
    pub fn page_size(&self) -> std::option::Option<i32> {
        self.page_size
    }
}
impl std::fmt::Debug for GetDedicatedIpsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDedicatedIpsInput");
        formatter.field("pool_name", &self.pool_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("page_size", &self.page_size);
        formatter.finish()
    }
}

/// <p>A request to obtain more information about a dedicated IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDedicatedIpInput {
    /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
    pub ip: std::option::Option<std::string::String>,
}
impl GetDedicatedIpInput {
    /// <p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
    pub fn ip(&self) -> std::option::Option<&str> {
        self.ip.as_deref()
    }
}
impl std::fmt::Debug for GetDedicatedIpInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDedicatedIpInput");
        formatter.field("ip", &self.ip);
        formatter.finish()
    }
}

/// <p>Represents a request to retrieve an existing custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to retrieve.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl GetCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to retrieve.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for GetCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactListInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
}
impl GetContactListInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
}
impl std::fmt::Debug for GetContactListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactListInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactInput {
    /// <p>The name of the contact list to which the contact belongs.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>The contact's email addres.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl GetContactInput {
    /// <p>The name of the contact list to which the contact belongs.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>The contact's email addres.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for GetContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>A request to obtain information about the event destinations for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationSetEventDestinationsInput {
    /// <p>The name of the configuration set that contains the event destination.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl GetConfigurationSetEventDestinationsInput {
    /// <p>The name of the configuration set that contains the event destination.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for GetConfigurationSetEventDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationSetEventDestinationsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>A request to obtain information about a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigurationSetInput {
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl GetConfigurationSetInput {
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for GetConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlacklistReportsInput {
    /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
    pub blacklist_item_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetBlacklistReportsInput {
    /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>
    pub fn blacklist_item_names(&self) -> std::option::Option<&[std::string::String]> {
        self.blacklist_item_names.as_deref()
    }
}
impl std::fmt::Debug for GetBlacklistReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlacklistReportsInput");
        formatter.field("blacklist_item_names", &self.blacklist_item_names);
        formatter.finish()
    }
}

/// <p>A request to obtain information about the email-sending capabilities of your Amazon SES account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountInput {}
impl std::fmt::Debug for GetAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountInput");
        formatter.finish()
    }
}

/// <p>A request to remove an email address from the suppression list for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSuppressedDestinationInput {
    /// <p>The suppressed email destination to remove from the account suppression list.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl DeleteSuppressedDestinationInput {
    /// <p>The suppressed email destination to remove from the account suppression list.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for DeleteSuppressedDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSuppressedDestinationInput");
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>Represents a request to delete an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEmailTemplateInput {
    /// <p>The name of the template to be deleted.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl DeleteEmailTemplateInput {
    /// <p>The name of the template to be deleted.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub policy_name: std::option::Option<std::string::String>,
}
impl DeleteEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEmailIdentityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEmailIdentityPolicyInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("policy_name", &self.policy_name);
        formatter.finish()
    }
}

/// <p>A request to delete an existing email identity. When you delete an identity, you lose the ability to send email from that identity. You can restore your ability to send email by completing the verification process for the identity again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEmailIdentityInput {
    /// <p>The identity (that is, the email address or domain) to delete.</p>
    pub email_identity: std::option::Option<std::string::String>,
}
impl DeleteEmailIdentityInput {
    /// <p>The identity (that is, the email address or domain) to delete.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
}
impl std::fmt::Debug for DeleteEmailIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEmailIdentityInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.finish()
    }
}

/// <p>A request to delete a dedicated IP pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDedicatedIpPoolInput {
    /// <p>The name of the dedicated IP pool that you want to delete.</p>
    pub pool_name: std::option::Option<std::string::String>,
}
impl DeleteDedicatedIpPoolInput {
    /// <p>The name of the dedicated IP pool that you want to delete.</p>
    pub fn pool_name(&self) -> std::option::Option<&str> {
        self.pool_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDedicatedIpPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDedicatedIpPoolInput");
        formatter.field("pool_name", &self.pool_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete an existing custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to delete.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl DeleteCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to delete.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactListInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
}
impl DeleteContactListInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteContactListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactListInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactInput {
    /// <p>The name of the contact list from which the contact should be removed.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>The contact's email address.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl DeleteContactInput {
    /// <p>The name of the contact list from which the contact should be removed.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>The contact's email address.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for DeleteContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>A request to delete an event destination from a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination to delete.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the event destination to delete.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination to delete.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name of the event destination to delete.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

/// <p>A request to delete a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetInput {
    /// <p>The name of the configuration set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetInput {
    /// <p>The name of the configuration set.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to create an import job from a data source for a data destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImportJobInput {
    /// <p>The destination for the import job.</p>
    pub import_destination: std::option::Option<crate::model::ImportDestination>,
    /// <p>The data source for the import job.</p>
    pub import_data_source: std::option::Option<crate::model::ImportDataSource>,
}
impl CreateImportJobInput {
    /// <p>The destination for the import job.</p>
    pub fn import_destination(&self) -> std::option::Option<&crate::model::ImportDestination> {
        self.import_destination.as_ref()
    }
    /// <p>The data source for the import job.</p>
    pub fn import_data_source(&self) -> std::option::Option<&crate::model::ImportDataSource> {
        self.import_data_source.as_ref()
    }
}
impl std::fmt::Debug for CreateImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImportJobInput");
        formatter.field("import_destination", &self.import_destination);
        formatter.field("import_data_source", &self.import_data_source);
        formatter.finish()
    }
}

/// <p>Represents a request to create an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    pub template_content: std::option::Option<crate::model::EmailTemplateContent>,
}
impl CreateEmailTemplateInput {
    /// <p>The name of the template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>
    pub fn template_content(&self) -> std::option::Option<&crate::model::EmailTemplateContent> {
        self.template_content.as_ref()
    }
}
impl std::fmt::Debug for CreateEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_content", &self.template_content);
        formatter.finish()
    }
}

/// <p>Represents a request to create a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl CreateEmailIdentityPolicyInput {
    /// <p>The email identity.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for CreateEmailIdentityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEmailIdentityPolicyInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>A request to begin the verification process for an email identity (an email address or domain).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEmailIdentityInput {
    /// <p>The email address or domain to verify.</p>
    pub email_identity: std::option::Option<std::string::String>,
    /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
    pub dkim_signing_attributes: std::option::Option<crate::model::DkimSigningAttributes>,
    /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl CreateEmailIdentityInput {
    /// <p>The email address or domain to verify.</p>
    pub fn email_identity(&self) -> std::option::Option<&str> {
        self.email_identity.as_deref()
    }
    /// <p>An array of objects that define the tags (keys and values) to associate with the email identity.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>
    pub fn dkim_signing_attributes(
        &self,
    ) -> std::option::Option<&crate::model::DkimSigningAttributes> {
        self.dkim_signing_attributes.as_ref()
    }
    /// <p>The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. </p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for CreateEmailIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEmailIdentityInput");
        formatter.field("email_identity", &self.email_identity);
        formatter.field("tags", &self.tags);
        formatter.field("dkim_signing_attributes", &self.dkim_signing_attributes);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. We send that message to special email addresses spread across several major email providers around the world. The test takes about 24 hours to complete. When the test is complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeliverabilityTestReportInput {
    /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
    pub report_name: std::option::Option<std::string::String>,
    /// <p>The email address that the predictive inbox placement test email was sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
    pub content: std::option::Option<crate::model::EmailContent>,
    /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDeliverabilityTestReportInput {
    /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>
    pub fn report_name(&self) -> std::option::Option<&str> {
        self.report_name.as_deref()
    }
    /// <p>The email address that the predictive inbox placement test email was sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::EmailContent> {
        self.content.as_ref()
    }
    /// <p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDeliverabilityTestReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeliverabilityTestReportInput");
        formatter.field("report_name", &self.report_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("content", &self.content);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>A request to create a new dedicated IP pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDedicatedIpPoolInput {
    /// <p>The name of the dedicated IP pool.</p>
    pub pool_name: std::option::Option<std::string::String>,
    /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDedicatedIpPoolInput {
    /// <p>The name of the dedicated IP pool.</p>
    pub fn pool_name(&self) -> std::option::Option<&str> {
        self.pool_name.as_deref()
    }
    /// <p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDedicatedIpPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDedicatedIpPoolInput");
        formatter.field("pool_name", &self.pool_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents a request to create a custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    pub template_content: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl CreateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    pub fn template_content(&self) -> std::option::Option<&str> {
        self.template_content.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("template_content", &self.template_content);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactListInput {
    /// <p>The name of the contact list.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    pub topics: std::option::Option<std::vec::Vec<crate::model::Topic>>,
    /// <p>A description of what the contact list is about.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags associated with a contact list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateContactListInput {
    /// <p>The name of the contact list.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>An interest group, theme, or label within a list. A contact list can have multiple topics.</p>
    pub fn topics(&self) -> std::option::Option<&[crate::model::Topic]> {
        self.topics.as_deref()
    }
    /// <p>A description of what the contact list is about.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags associated with a contact list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateContactListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactListInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("topics", &self.topics);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactInput {
    /// <p>The name of the contact list to which the contact should be added.</p>
    pub contact_list_name: std::option::Option<std::string::String>,
    /// <p>The contact's email address.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
    pub topic_preferences: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    pub unsubscribe_all: bool,
    /// <p>The attribute data attached to a contact.</p>
    pub attributes_data: std::option::Option<std::string::String>,
}
impl CreateContactInput {
    /// <p>The name of the contact list to which the contact should be added.</p>
    pub fn contact_list_name(&self) -> std::option::Option<&str> {
        self.contact_list_name.as_deref()
    }
    /// <p>The contact's email address.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
    pub fn topic_preferences(&self) -> std::option::Option<&[crate::model::TopicPreference]> {
        self.topic_preferences.as_deref()
    }
    /// <p>A boolean value status noting if the contact is unsubscribed from all contact list topics.</p>
    pub fn unsubscribe_all(&self) -> bool {
        self.unsubscribe_all
    }
    /// <p>The attribute data attached to a contact.</p>
    pub fn attributes_data(&self) -> std::option::Option<&str> {
        self.attributes_data.as_deref()
    }
}
impl std::fmt::Debug for CreateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactInput");
        formatter.field("contact_list_name", &self.contact_list_name);
        formatter.field("email_address", &self.email_address);
        formatter.field("topic_preferences", &self.topic_preferences);
        formatter.field("unsubscribe_all", &self.unsubscribe_all);
        formatter.field("attributes_data", &self.attributes_data);
        formatter.finish()
    }
}

/// <p>A request to add an event destination to a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set .</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A name that identifies the event destination within the configuration set.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    /// <p>An object that defines the event destination.</p>
    pub event_destination: std::option::Option<crate::model::EventDestinationDefinition>,
}
impl CreateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set .</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A name that identifies the event destination within the configuration set.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
    /// <p>An object that defines the event destination.</p>
    pub fn event_destination(
        &self,
    ) -> std::option::Option<&crate::model::EventDestinationDefinition> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}

/// <p>A request to create a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetInput {
    /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    pub tracking_options: std::option::Option<crate::model::TrackingOptions>,
    /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    pub delivery_options: std::option::Option<crate::model::DeliveryOptions>,
    /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
    pub reputation_options: std::option::Option<crate::model::ReputationOptions>,
    /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
    pub sending_options: std::option::Option<crate::model::SendingOptions>,
    /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An object that contains information about the suppression list preferences for your account.</p>
    pub suppression_options: std::option::Option<crate::model::SuppressionOptions>,
}
impl CreateConfigurationSetInput {
    /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>
    pub fn tracking_options(&self) -> std::option::Option<&crate::model::TrackingOptions> {
        self.tracking_options.as_ref()
    }
    /// <p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>
    pub fn delivery_options(&self) -> std::option::Option<&crate::model::DeliveryOptions> {
        self.delivery_options.as_ref()
    }
    /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>
    pub fn reputation_options(&self) -> std::option::Option<&crate::model::ReputationOptions> {
        self.reputation_options.as_ref()
    }
    /// <p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>
    pub fn sending_options(&self) -> std::option::Option<&crate::model::SendingOptions> {
        self.sending_options.as_ref()
    }
    /// <p>An array of objects that define the tags (keys and values) to associate with the configuration set.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>An object that contains information about the suppression list preferences for your account.</p>
    pub fn suppression_options(&self) -> std::option::Option<&crate::model::SuppressionOptions> {
        self.suppression_options.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tracking_options", &self.tracking_options);
        formatter.field("delivery_options", &self.delivery_options);
        formatter.field("reputation_options", &self.reputation_options);
        formatter.field("sending_options", &self.sending_options);
        formatter.field("tags", &self.tags);
        formatter.field("suppression_options", &self.suppression_options);
        formatter.finish()
    }
}
