// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `SimpleEmailService_v2`.
///
/// This client allows ergonomic access to a `SimpleEmailService_v2`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateConfigurationSet` operation.
    ///
    /// See [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet<C, M, R> {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfigurationSetEventDestination` operation.
    ///
    /// See [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination<C, M, R> {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContact` operation.
    ///
    /// See [`CreateContact`](crate::client::fluent_builders::CreateContact) for more information about the
    /// operation and its arguments.
    pub fn create_contact(&self) -> fluent_builders::CreateContact<C, M, R> {
        fluent_builders::CreateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContactList` operation.
    ///
    /// See [`CreateContactList`](crate::client::fluent_builders::CreateContactList) for more information about the
    /// operation and its arguments.
    pub fn create_contact_list(&self) -> fluent_builders::CreateContactList<C, M, R> {
        fluent_builders::CreateContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomVerificationEmailTemplate` operation.
    ///
    /// See [`CreateCustomVerificationEmailTemplate`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_custom_verification_email_template(
        &self,
    ) -> fluent_builders::CreateCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::CreateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDedicatedIpPool` operation.
    ///
    /// See [`CreateDedicatedIpPool`](crate::client::fluent_builders::CreateDedicatedIpPool) for more information about the
    /// operation and its arguments.
    pub fn create_dedicated_ip_pool(&self) -> fluent_builders::CreateDedicatedIpPool<C, M, R> {
        fluent_builders::CreateDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeliverabilityTestReport` operation.
    ///
    /// See [`CreateDeliverabilityTestReport`](crate::client::fluent_builders::CreateDeliverabilityTestReport) for more information about the
    /// operation and its arguments.
    pub fn create_deliverability_test_report(
        &self,
    ) -> fluent_builders::CreateDeliverabilityTestReport<C, M, R> {
        fluent_builders::CreateDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEmailIdentity` operation.
    ///
    /// See [`CreateEmailIdentity`](crate::client::fluent_builders::CreateEmailIdentity) for more information about the
    /// operation and its arguments.
    pub fn create_email_identity(&self) -> fluent_builders::CreateEmailIdentity<C, M, R> {
        fluent_builders::CreateEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEmailIdentityPolicy` operation.
    ///
    /// See [`CreateEmailIdentityPolicy`](crate::client::fluent_builders::CreateEmailIdentityPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_email_identity_policy(
        &self,
    ) -> fluent_builders::CreateEmailIdentityPolicy<C, M, R> {
        fluent_builders::CreateEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEmailTemplate` operation.
    ///
    /// See [`CreateEmailTemplate`](crate::client::fluent_builders::CreateEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_email_template(&self) -> fluent_builders::CreateEmailTemplate<C, M, R> {
        fluent_builders::CreateEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImportJob` operation.
    ///
    /// See [`CreateImportJob`](crate::client::fluent_builders::CreateImportJob) for more information about the
    /// operation and its arguments.
    pub fn create_import_job(&self) -> fluent_builders::CreateImportJob<C, M, R> {
        fluent_builders::CreateImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationSet` operation.
    ///
    /// See [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet<C, M, R> {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationSetEventDestination` operation.
    ///
    /// See [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination<C, M, R> {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContact` operation.
    ///
    /// See [`DeleteContact`](crate::client::fluent_builders::DeleteContact) for more information about the
    /// operation and its arguments.
    pub fn delete_contact(&self) -> fluent_builders::DeleteContact<C, M, R> {
        fluent_builders::DeleteContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContactList` operation.
    ///
    /// See [`DeleteContactList`](crate::client::fluent_builders::DeleteContactList) for more information about the
    /// operation and its arguments.
    pub fn delete_contact_list(&self) -> fluent_builders::DeleteContactList<C, M, R> {
        fluent_builders::DeleteContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomVerificationEmailTemplate` operation.
    ///
    /// See [`DeleteCustomVerificationEmailTemplate`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_verification_email_template(
        &self,
    ) -> fluent_builders::DeleteCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::DeleteCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDedicatedIpPool` operation.
    ///
    /// See [`DeleteDedicatedIpPool`](crate::client::fluent_builders::DeleteDedicatedIpPool) for more information about the
    /// operation and its arguments.
    pub fn delete_dedicated_ip_pool(&self) -> fluent_builders::DeleteDedicatedIpPool<C, M, R> {
        fluent_builders::DeleteDedicatedIpPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEmailIdentity` operation.
    ///
    /// See [`DeleteEmailIdentity`](crate::client::fluent_builders::DeleteEmailIdentity) for more information about the
    /// operation and its arguments.
    pub fn delete_email_identity(&self) -> fluent_builders::DeleteEmailIdentity<C, M, R> {
        fluent_builders::DeleteEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEmailIdentityPolicy` operation.
    ///
    /// See [`DeleteEmailIdentityPolicy`](crate::client::fluent_builders::DeleteEmailIdentityPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_email_identity_policy(
        &self,
    ) -> fluent_builders::DeleteEmailIdentityPolicy<C, M, R> {
        fluent_builders::DeleteEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEmailTemplate` operation.
    ///
    /// See [`DeleteEmailTemplate`](crate::client::fluent_builders::DeleteEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_email_template(&self) -> fluent_builders::DeleteEmailTemplate<C, M, R> {
        fluent_builders::DeleteEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSuppressedDestination` operation.
    ///
    /// See [`DeleteSuppressedDestination`](crate::client::fluent_builders::DeleteSuppressedDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_suppressed_destination(
        &self,
    ) -> fluent_builders::DeleteSuppressedDestination<C, M, R> {
        fluent_builders::DeleteSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccount` operation.
    ///
    /// See [`GetAccount`](crate::client::fluent_builders::GetAccount) for more information about the
    /// operation and its arguments.
    pub fn get_account(&self) -> fluent_builders::GetAccount<C, M, R> {
        fluent_builders::GetAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlacklistReports` operation.
    ///
    /// See [`GetBlacklistReports`](crate::client::fluent_builders::GetBlacklistReports) for more information about the
    /// operation and its arguments.
    pub fn get_blacklist_reports(&self) -> fluent_builders::GetBlacklistReports<C, M, R> {
        fluent_builders::GetBlacklistReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConfigurationSet` operation.
    ///
    /// See [`GetConfigurationSet`](crate::client::fluent_builders::GetConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn get_configuration_set(&self) -> fluent_builders::GetConfigurationSet<C, M, R> {
        fluent_builders::GetConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConfigurationSetEventDestinations` operation.
    ///
    /// See [`GetConfigurationSetEventDestinations`](crate::client::fluent_builders::GetConfigurationSetEventDestinations) for more information about the
    /// operation and its arguments.
    pub fn get_configuration_set_event_destinations(
        &self,
    ) -> fluent_builders::GetConfigurationSetEventDestinations<C, M, R> {
        fluent_builders::GetConfigurationSetEventDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContact` operation.
    ///
    /// See [`GetContact`](crate::client::fluent_builders::GetContact) for more information about the
    /// operation and its arguments.
    pub fn get_contact(&self) -> fluent_builders::GetContact<C, M, R> {
        fluent_builders::GetContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactList` operation.
    ///
    /// See [`GetContactList`](crate::client::fluent_builders::GetContactList) for more information about the
    /// operation and its arguments.
    pub fn get_contact_list(&self) -> fluent_builders::GetContactList<C, M, R> {
        fluent_builders::GetContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCustomVerificationEmailTemplate` operation.
    ///
    /// See [`GetCustomVerificationEmailTemplate`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_custom_verification_email_template(
        &self,
    ) -> fluent_builders::GetCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::GetCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDedicatedIp` operation.
    ///
    /// See [`GetDedicatedIp`](crate::client::fluent_builders::GetDedicatedIp) for more information about the
    /// operation and its arguments.
    pub fn get_dedicated_ip(&self) -> fluent_builders::GetDedicatedIp<C, M, R> {
        fluent_builders::GetDedicatedIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDedicatedIps` operation.
    ///
    /// See [`GetDedicatedIps`](crate::client::fluent_builders::GetDedicatedIps) for more information about the
    /// operation and its arguments.
    pub fn get_dedicated_ips(&self) -> fluent_builders::GetDedicatedIps<C, M, R> {
        fluent_builders::GetDedicatedIps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeliverabilityDashboardOptions` operation.
    ///
    /// See [`GetDeliverabilityDashboardOptions`](crate::client::fluent_builders::GetDeliverabilityDashboardOptions) for more information about the
    /// operation and its arguments.
    pub fn get_deliverability_dashboard_options(
        &self,
    ) -> fluent_builders::GetDeliverabilityDashboardOptions<C, M, R> {
        fluent_builders::GetDeliverabilityDashboardOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeliverabilityTestReport` operation.
    ///
    /// See [`GetDeliverabilityTestReport`](crate::client::fluent_builders::GetDeliverabilityTestReport) for more information about the
    /// operation and its arguments.
    pub fn get_deliverability_test_report(
        &self,
    ) -> fluent_builders::GetDeliverabilityTestReport<C, M, R> {
        fluent_builders::GetDeliverabilityTestReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainDeliverabilityCampaign` operation.
    ///
    /// See [`GetDomainDeliverabilityCampaign`](crate::client::fluent_builders::GetDomainDeliverabilityCampaign) for more information about the
    /// operation and its arguments.
    pub fn get_domain_deliverability_campaign(
        &self,
    ) -> fluent_builders::GetDomainDeliverabilityCampaign<C, M, R> {
        fluent_builders::GetDomainDeliverabilityCampaign::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainStatisticsReport` operation.
    ///
    /// See [`GetDomainStatisticsReport`](crate::client::fluent_builders::GetDomainStatisticsReport) for more information about the
    /// operation and its arguments.
    pub fn get_domain_statistics_report(
        &self,
    ) -> fluent_builders::GetDomainStatisticsReport<C, M, R> {
        fluent_builders::GetDomainStatisticsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEmailIdentity` operation.
    ///
    /// See [`GetEmailIdentity`](crate::client::fluent_builders::GetEmailIdentity) for more information about the
    /// operation and its arguments.
    pub fn get_email_identity(&self) -> fluent_builders::GetEmailIdentity<C, M, R> {
        fluent_builders::GetEmailIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEmailIdentityPolicies` operation.
    ///
    /// See [`GetEmailIdentityPolicies`](crate::client::fluent_builders::GetEmailIdentityPolicies) for more information about the
    /// operation and its arguments.
    pub fn get_email_identity_policies(
        &self,
    ) -> fluent_builders::GetEmailIdentityPolicies<C, M, R> {
        fluent_builders::GetEmailIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEmailTemplate` operation.
    ///
    /// See [`GetEmailTemplate`](crate::client::fluent_builders::GetEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_email_template(&self) -> fluent_builders::GetEmailTemplate<C, M, R> {
        fluent_builders::GetEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImportJob` operation.
    ///
    /// See [`GetImportJob`](crate::client::fluent_builders::GetImportJob) for more information about the
    /// operation and its arguments.
    pub fn get_import_job(&self) -> fluent_builders::GetImportJob<C, M, R> {
        fluent_builders::GetImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSuppressedDestination` operation.
    ///
    /// See [`GetSuppressedDestination`](crate::client::fluent_builders::GetSuppressedDestination) for more information about the
    /// operation and its arguments.
    pub fn get_suppressed_destination(&self) -> fluent_builders::GetSuppressedDestination<C, M, R> {
        fluent_builders::GetSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurationSets` operation.
    ///
    /// See [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) for more information about the
    /// operation and its arguments.
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets<C, M, R> {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContactLists` operation.
    ///
    /// See [`ListContactLists`](crate::client::fluent_builders::ListContactLists) for more information about the
    /// operation and its arguments.
    pub fn list_contact_lists(&self) -> fluent_builders::ListContactLists<C, M, R> {
        fluent_builders::ListContactLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContacts` operation.
    ///
    /// See [`ListContacts`](crate::client::fluent_builders::ListContacts) for more information about the
    /// operation and its arguments.
    pub fn list_contacts(&self) -> fluent_builders::ListContacts<C, M, R> {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomVerificationEmailTemplates` operation.
    ///
    /// See [`ListCustomVerificationEmailTemplates`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_custom_verification_email_templates(
        &self,
    ) -> fluent_builders::ListCustomVerificationEmailTemplates<C, M, R> {
        fluent_builders::ListCustomVerificationEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDedicatedIpPools` operation.
    ///
    /// See [`ListDedicatedIpPools`](crate::client::fluent_builders::ListDedicatedIpPools) for more information about the
    /// operation and its arguments.
    pub fn list_dedicated_ip_pools(&self) -> fluent_builders::ListDedicatedIpPools<C, M, R> {
        fluent_builders::ListDedicatedIpPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeliverabilityTestReports` operation.
    ///
    /// See [`ListDeliverabilityTestReports`](crate::client::fluent_builders::ListDeliverabilityTestReports) for more information about the
    /// operation and its arguments.
    pub fn list_deliverability_test_reports(
        &self,
    ) -> fluent_builders::ListDeliverabilityTestReports<C, M, R> {
        fluent_builders::ListDeliverabilityTestReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainDeliverabilityCampaigns` operation.
    ///
    /// See [`ListDomainDeliverabilityCampaigns`](crate::client::fluent_builders::ListDomainDeliverabilityCampaigns) for more information about the
    /// operation and its arguments.
    pub fn list_domain_deliverability_campaigns(
        &self,
    ) -> fluent_builders::ListDomainDeliverabilityCampaigns<C, M, R> {
        fluent_builders::ListDomainDeliverabilityCampaigns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEmailIdentities` operation.
    ///
    /// See [`ListEmailIdentities`](crate::client::fluent_builders::ListEmailIdentities) for more information about the
    /// operation and its arguments.
    pub fn list_email_identities(&self) -> fluent_builders::ListEmailIdentities<C, M, R> {
        fluent_builders::ListEmailIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEmailTemplates` operation.
    ///
    /// See [`ListEmailTemplates`](crate::client::fluent_builders::ListEmailTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_email_templates(&self) -> fluent_builders::ListEmailTemplates<C, M, R> {
        fluent_builders::ListEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImportJobs` operation.
    ///
    /// See [`ListImportJobs`](crate::client::fluent_builders::ListImportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_import_jobs(&self) -> fluent_builders::ListImportJobs<C, M, R> {
        fluent_builders::ListImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSuppressedDestinations` operation.
    ///
    /// See [`ListSuppressedDestinations`](crate::client::fluent_builders::ListSuppressedDestinations) for more information about the
    /// operation and its arguments.
    pub fn list_suppressed_destinations(
        &self,
    ) -> fluent_builders::ListSuppressedDestinations<C, M, R> {
        fluent_builders::ListSuppressedDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccountDedicatedIpWarmupAttributes` operation.
    ///
    /// See [`PutAccountDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutAccountDedicatedIpWarmupAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_account_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutAccountDedicatedIpWarmupAttributes<C, M, R> {
        fluent_builders::PutAccountDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccountDetails` operation.
    ///
    /// See [`PutAccountDetails`](crate::client::fluent_builders::PutAccountDetails) for more information about the
    /// operation and its arguments.
    pub fn put_account_details(&self) -> fluent_builders::PutAccountDetails<C, M, R> {
        fluent_builders::PutAccountDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccountSendingAttributes` operation.
    ///
    /// See [`PutAccountSendingAttributes`](crate::client::fluent_builders::PutAccountSendingAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_account_sending_attributes(
        &self,
    ) -> fluent_builders::PutAccountSendingAttributes<C, M, R> {
        fluent_builders::PutAccountSendingAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccountSuppressionAttributes` operation.
    ///
    /// See [`PutAccountSuppressionAttributes`](crate::client::fluent_builders::PutAccountSuppressionAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_account_suppression_attributes(
        &self,
    ) -> fluent_builders::PutAccountSuppressionAttributes<C, M, R> {
        fluent_builders::PutAccountSuppressionAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetDeliveryOptions` operation.
    ///
    /// See [`PutConfigurationSetDeliveryOptions`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_delivery_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetDeliveryOptions<C, M, R> {
        fluent_builders::PutConfigurationSetDeliveryOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetReputationOptions` operation.
    ///
    /// See [`PutConfigurationSetReputationOptions`](crate::client::fluent_builders::PutConfigurationSetReputationOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_reputation_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetReputationOptions<C, M, R> {
        fluent_builders::PutConfigurationSetReputationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetSendingOptions` operation.
    ///
    /// See [`PutConfigurationSetSendingOptions`](crate::client::fluent_builders::PutConfigurationSetSendingOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_sending_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetSendingOptions<C, M, R> {
        fluent_builders::PutConfigurationSetSendingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetSuppressionOptions` operation.
    ///
    /// See [`PutConfigurationSetSuppressionOptions`](crate::client::fluent_builders::PutConfigurationSetSuppressionOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_suppression_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetSuppressionOptions<C, M, R> {
        fluent_builders::PutConfigurationSetSuppressionOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetTrackingOptions` operation.
    ///
    /// See [`PutConfigurationSetTrackingOptions`](crate::client::fluent_builders::PutConfigurationSetTrackingOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetTrackingOptions<C, M, R> {
        fluent_builders::PutConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDedicatedIpInPool` operation.
    ///
    /// See [`PutDedicatedIpInPool`](crate::client::fluent_builders::PutDedicatedIpInPool) for more information about the
    /// operation and its arguments.
    pub fn put_dedicated_ip_in_pool(&self) -> fluent_builders::PutDedicatedIpInPool<C, M, R> {
        fluent_builders::PutDedicatedIpInPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDedicatedIpWarmupAttributes` operation.
    ///
    /// See [`PutDedicatedIpWarmupAttributes`](crate::client::fluent_builders::PutDedicatedIpWarmupAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_dedicated_ip_warmup_attributes(
        &self,
    ) -> fluent_builders::PutDedicatedIpWarmupAttributes<C, M, R> {
        fluent_builders::PutDedicatedIpWarmupAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDeliverabilityDashboardOption` operation.
    ///
    /// See [`PutDeliverabilityDashboardOption`](crate::client::fluent_builders::PutDeliverabilityDashboardOption) for more information about the
    /// operation and its arguments.
    pub fn put_deliverability_dashboard_option(
        &self,
    ) -> fluent_builders::PutDeliverabilityDashboardOption<C, M, R> {
        fluent_builders::PutDeliverabilityDashboardOption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEmailIdentityConfigurationSetAttributes` operation.
    ///
    /// See [`PutEmailIdentityConfigurationSetAttributes`](crate::client::fluent_builders::PutEmailIdentityConfigurationSetAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_email_identity_configuration_set_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityConfigurationSetAttributes<C, M, R> {
        fluent_builders::PutEmailIdentityConfigurationSetAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEmailIdentityDkimAttributes` operation.
    ///
    /// See [`PutEmailIdentityDkimAttributes`](crate::client::fluent_builders::PutEmailIdentityDkimAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_email_identity_dkim_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityDkimAttributes<C, M, R> {
        fluent_builders::PutEmailIdentityDkimAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEmailIdentityDkimSigningAttributes` operation.
    ///
    /// See [`PutEmailIdentityDkimSigningAttributes`](crate::client::fluent_builders::PutEmailIdentityDkimSigningAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_email_identity_dkim_signing_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityDkimSigningAttributes<C, M, R> {
        fluent_builders::PutEmailIdentityDkimSigningAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEmailIdentityFeedbackAttributes` operation.
    ///
    /// See [`PutEmailIdentityFeedbackAttributes`](crate::client::fluent_builders::PutEmailIdentityFeedbackAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_email_identity_feedback_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityFeedbackAttributes<C, M, R> {
        fluent_builders::PutEmailIdentityFeedbackAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEmailIdentityMailFromAttributes` operation.
    ///
    /// See [`PutEmailIdentityMailFromAttributes`](crate::client::fluent_builders::PutEmailIdentityMailFromAttributes) for more information about the
    /// operation and its arguments.
    pub fn put_email_identity_mail_from_attributes(
        &self,
    ) -> fluent_builders::PutEmailIdentityMailFromAttributes<C, M, R> {
        fluent_builders::PutEmailIdentityMailFromAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSuppressedDestination` operation.
    ///
    /// See [`PutSuppressedDestination`](crate::client::fluent_builders::PutSuppressedDestination) for more information about the
    /// operation and its arguments.
    pub fn put_suppressed_destination(&self) -> fluent_builders::PutSuppressedDestination<C, M, R> {
        fluent_builders::PutSuppressedDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendBulkEmail` operation.
    ///
    /// See [`SendBulkEmail`](crate::client::fluent_builders::SendBulkEmail) for more information about the
    /// operation and its arguments.
    pub fn send_bulk_email(&self) -> fluent_builders::SendBulkEmail<C, M, R> {
        fluent_builders::SendBulkEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendCustomVerificationEmail` operation.
    ///
    /// See [`SendCustomVerificationEmail`](crate::client::fluent_builders::SendCustomVerificationEmail) for more information about the
    /// operation and its arguments.
    pub fn send_custom_verification_email(
        &self,
    ) -> fluent_builders::SendCustomVerificationEmail<C, M, R> {
        fluent_builders::SendCustomVerificationEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendEmail` operation.
    ///
    /// See [`SendEmail`](crate::client::fluent_builders::SendEmail) for more information about the
    /// operation and its arguments.
    pub fn send_email(&self) -> fluent_builders::SendEmail<C, M, R> {
        fluent_builders::SendEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestRenderEmailTemplate` operation.
    ///
    /// See [`TestRenderEmailTemplate`](crate::client::fluent_builders::TestRenderEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn test_render_email_template(&self) -> fluent_builders::TestRenderEmailTemplate<C, M, R> {
        fluent_builders::TestRenderEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationSetEventDestination` operation.
    ///
    /// See [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination<C, M, R> {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContact` operation.
    ///
    /// See [`UpdateContact`](crate::client::fluent_builders::UpdateContact) for more information about the
    /// operation and its arguments.
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactList` operation.
    ///
    /// See [`UpdateContactList`](crate::client::fluent_builders::UpdateContactList) for more information about the
    /// operation and its arguments.
    pub fn update_contact_list(&self) -> fluent_builders::UpdateContactList<C, M, R> {
        fluent_builders::UpdateContactList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomVerificationEmailTemplate` operation.
    ///
    /// See [`UpdateCustomVerificationEmailTemplate`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_custom_verification_email_template(
        &self,
    ) -> fluent_builders::UpdateCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::UpdateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEmailIdentityPolicy` operation.
    ///
    /// See [`UpdateEmailIdentityPolicy`](crate::client::fluent_builders::UpdateEmailIdentityPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_email_identity_policy(
        &self,
    ) -> fluent_builders::UpdateEmailIdentityPolicy<C, M, R> {
        fluent_builders::UpdateEmailIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEmailTemplate` operation.
    ///
    /// See [`UpdateEmailTemplate`](crate::client::fluent_builders::UpdateEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_email_template(&self) -> fluent_builders::UpdateEmailTemplate<C, M, R> {
        fluent_builders::UpdateEmailTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Create a configuration set. <i>Configuration sets</i> are groups of
    /// rules that you can apply to the emails that you send. You apply a configuration set to
    /// an email by specifying the name of the configuration set when you call the Amazon SES API v2. When
    /// you apply a configuration set to an email, all of the rules in that configuration set
    /// are applied to the email. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl<C, M, R> CreateConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationSetInputOperationOutputAlias,
                crate::output::CreateConfigurationSetOutput,
                crate::error::CreateConfigurationSetError,
                crate::input::CreateConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric
        /// characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set. The name can contain up to 64 alphanumeric
        /// characters, including letters, numbers, hyphens (-) and underscores (_) only.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send
        /// using the configuration set.</p>
        pub fn tracking_options(mut self, inp: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(inp);
            self
        }
        /// <p>An object that defines the open and click tracking options for emails that you send
        /// using the configuration set.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send
        /// using the configuration set.</p>
        pub fn delivery_options(mut self, inp: crate::model::DeliveryOptions) -> Self {
            self.inner = self.inner.delivery_options(inp);
            self
        }
        /// <p>An object that defines the dedicated IP pool that is used to send emails that you send
        /// using the configuration set.</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.inner = self.inner.set_delivery_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails
        /// that you send that use the configuration set.</p>
        pub fn reputation_options(mut self, inp: crate::model::ReputationOptions) -> Self {
            self.inner = self.inner.reputation_options(inp);
            self
        }
        /// <p>An object that defines whether or not Amazon SES collects reputation metrics for the emails
        /// that you send that use the configuration set.</p>
        pub fn set_reputation_options(
            mut self,
            input: std::option::Option<crate::model::ReputationOptions>,
        ) -> Self {
            self.inner = self.inner.set_reputation_options(input);
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the
        /// configuration set.</p>
        pub fn sending_options(mut self, inp: crate::model::SendingOptions) -> Self {
            self.inner = self.inner.sending_options(inp);
            self
        }
        /// <p>An object that defines whether or not Amazon SES can send email that you send using the
        /// configuration set.</p>
        pub fn set_sending_options(
            mut self,
            input: std::option::Option<crate::model::SendingOptions>,
        ) -> Self {
            self.inner = self.inner.set_sending_options(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the
        /// configuration set.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the
        /// configuration set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your
        /// account.</p>
        pub fn suppression_options(mut self, inp: crate::model::SuppressionOptions) -> Self {
            self.inner = self.inner.suppression_options(inp);
            self
        }
        /// <p>An object that contains information about the suppression list preferences for your
        /// account.</p>
        pub fn set_suppression_options(
            mut self,
            input: std::option::Option<crate::model::SuppressionOptions>,
        ) -> Self {
            self.inner = self.inner.set_suppression_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// <p>Create an event destination. <i>Events</i> include message sends,
    /// deliveries, opens, clicks, bounces, and complaints. <i>Event
    /// destinations</i> are places that you can send information about these events
    /// to. For example, you can send event data to Amazon SNS to receive notifications when you
    /// receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term
    /// storage.</p>
    /// <p>A single configuration set can include more than one event destination.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> CreateConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::CreateConfigurationSetEventDestinationOutput,
                crate::error::CreateConfigurationSetEventDestinationError,
                crate::input::CreateConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set .</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set .</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn event_destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(inp);
            self
        }
        /// <p>A name that identifies the event destination within the configuration set.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(mut self, inp: crate::model::EventDestinationDefinition) -> Self {
            self.inner = self.inner.event_destination(inp);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContact`.
    ///
    /// <p>Creates a contact, which is an end-user who is receiving the email, and adds them to a
    /// contact list.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_input::Builder,
    }
    impl<C, M, R> CreateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactInputOperationOutputAlias,
                crate::output::CreateContactOutput,
                crate::error::CreateContactError,
                crate::input::CreateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list to which the contact should be added.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// Appends an item to `TopicPreferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn topic_preferences(mut self, inp: impl Into<crate::model::TopicPreference>) -> Self {
            self.inner = self.inner.topic_preferences(inp);
            self
        }
        /// <p>The contact's preferences for being opted-in to or opted-out of topics.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.inner = self.inner.set_topic_preferences(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn unsubscribe_all(mut self, inp: bool) -> Self {
            self.inner = self.inner.unsubscribe_all(inp);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unsubscribe_all(input);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_data(inp);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attributes_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactList`.
    ///
    /// <p>Creates a contact list.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContactList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_list_input::Builder,
    }
    impl<C, M, R> CreateContactList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactListInputOperationOutputAlias,
                crate::output::CreateContactListOutput,
                crate::error::CreateContactListError,
                crate::input::CreateContactListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple
        /// topics.</p>
        pub fn topics(mut self, inp: impl Into<crate::model::Topic>) -> Self {
            self.inner = self.inner.topics(inp);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple
        /// topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a contact list.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags associated with a contact list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomVerificationEmailTemplate`.
    ///
    /// <p>Creates a new custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> CreateCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::CreateCustomVerificationEmailTemplateOutput,
                crate::error::CreateCustomVerificationEmailTemplateError,
                crate::input::CreateCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(inp);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDedicatedIpPool`.
    ///
    /// <p>Create a new pool of dedicated IP addresses. A pool can include one or more dedicated
    /// IP addresses that are associated with your Amazon Web Services account. You can associate a pool with
    /// a configuration set. When you send an email that uses that configuration set, the
    /// message is sent from one of the addresses in the associated pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDedicatedIpPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dedicated_ip_pool_input::Builder,
    }
    impl<C, M, R> CreateDedicatedIpPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDedicatedIpPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDedicatedIpPoolInputOperationOutputAlias,
                crate::output::CreateDedicatedIpPoolOutput,
                crate::error::CreateDedicatedIpPoolError,
                crate::input::CreateDedicatedIpPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(inp);
            self
        }
        /// <p>The name of the dedicated IP pool.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An object that defines the tags (keys and values) that you want to associate with the
        /// pool.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An object that defines the tags (keys and values) that you want to associate with the
        /// pool.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeliverabilityTestReport`.
    ///
    /// <p>Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled
    /// by various email providers around the world. When you perform a predictive inbox placement test, you provide a
    /// sample message that contains the content that you plan to send to your customers. Amazon SES
    /// then sends that message to special email addresses spread across several major email
    /// providers. After about 24 hours, the test is complete, and you can use the
    /// <code>GetDeliverabilityTestReport</code> operation to view the results of the
    /// test.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDeliverabilityTestReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deliverability_test_report_input::Builder,
    }
    impl<C, M, R> CreateDeliverabilityTestReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeliverabilityTestReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeliverabilityTestReportInputOperationOutputAlias,
                crate::output::CreateDeliverabilityTestReportOutput,
                crate::error::CreateDeliverabilityTestReportError,
                crate::input::CreateDeliverabilityTestReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the
        /// results.</p>
        pub fn report_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_name(inp);
            self
        }
        /// <p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the
        /// results.</p>
        pub fn set_report_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_name(input);
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address that the predictive inbox placement test email was sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn content(mut self, inp: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) that you want to associate
        /// with the predictive inbox placement test.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) that you want to associate
        /// with the predictive inbox placement test.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailIdentity`.
    ///
    /// <p>Starts the process of verifying an email identity. An <i>identity</i> is
    /// an email address or domain that you use when you send email. Before you can use an
    /// identity to send email, you first have to verify it. By verifying an identity, you
    /// demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
    /// permission to send email from the identity.</p>
    /// <p>When you verify an email address, Amazon SES sends an email to the address. Your email
    /// address is verified as soon as you follow the link in the verification email.
    ///
    /// </p>
    /// <p>When you verify a domain without specifying the <code>DkimSigningAttributes</code>
    /// object, this operation provides a set of DKIM tokens. You can convert these tokens into
    /// CNAME records, which you then add to the DNS configuration for your domain. Your domain
    /// is verified when Amazon SES detects these records in the DNS configuration for your domain.
    /// This verification method is known as <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
    /// <p>Alternatively, you can perform the verification process by providing your own
    /// public-private key pair. This verification method is known as Bring Your Own DKIM
    /// (BYODKIM). To use BYODKIM, your call to the <code>CreateEmailIdentity</code> operation
    /// has to include the <code>DkimSigningAttributes</code> object. When you specify this
    /// object, you provide a selector (a component of the DNS record name that identifies the
    /// public key to use for DKIM authentication) and a private key.</p>
    /// <p>When you verify a domain, this operation provides a set of DKIM tokens, which you can
    /// convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your
    /// domain. Your domain is verified when Amazon SES detects these records in the DNS
    /// configuration for your domain. For some DNS providers, it can take 72 hours or more to
    /// complete the domain verification process.</p>
    /// <p>Additionally, you can associate an existing configuration set with the email identity that you're verifying.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEmailIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_email_identity_input::Builder,
    }
    impl<C, M, R> CreateEmailIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEmailIdentityInputOperationOutputAlias,
                crate::output::CreateEmailIdentityOutput,
                crate::error::CreateEmailIdentityError,
                crate::input::CreateEmailIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address or domain to verify.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email address or domain to verify.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of objects that define the tags (keys and values) to associate with the email
        /// identity.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of objects that define the tags (keys and values) to associate with the email
        /// identity.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your
        /// Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for
        /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an
        /// address.</p>
        pub fn dkim_signing_attributes(mut self, inp: crate::model::DkimSigningAttributes) -> Self {
            self.inner = self.inner.dkim_signing_attributes(inp);
            self
        }
        /// <p>If your request includes this object, Amazon SES configures the identity to use Bring Your
        /// Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for
        /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        /// <p>You can only specify this object if the email identity is a domain, as opposed to an
        /// address.</p>
        pub fn set_dkim_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.inner = self.inner.set_dkim_signing_attributes(input);
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any
        /// configuration set defined in the email sending request takes precedence. </p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The configuration set to use by default when sending from this identity. Note that any
        /// configuration set defined in the email sending request takes precedence. </p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailIdentityPolicy`.
    ///
    /// <p>Creates the specified sending authorization policy for the given identity (an email
    /// address or a domain).</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEmailIdentityPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_email_identity_policy_input::Builder,
    }
    impl<C, M, R> CreateEmailIdentityPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailIdentityPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEmailIdentityPolicyInputOperationOutputAlias,
                crate::output::CreateEmailIdentityPolicyOutput,
                crate::error::CreateEmailIdentityPolicyError,
                crate::input::CreateEmailIdentityPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEmailTemplate`.
    ///
    /// <p>Creates an email template. Email templates enable you to send personalized email to
    /// one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_email_template_input::Builder,
    }
    impl<C, M, R> CreateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEmailTemplateInputOperationOutputAlias,
                crate::output::CreateEmailTemplateOutput,
                crate::error::CreateEmailTemplateError,
                crate::input::CreateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a
        /// text-only part.</p>
        pub fn template_content(mut self, inp: crate::model::EmailTemplateContent) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a
        /// text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImportJob`.
    ///
    /// <p>Creates an import job for a data destination.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_import_job_input::Builder,
    }
    impl<C, M, R> CreateImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImportJobInputOperationOutputAlias,
                crate::output::CreateImportJobOutput,
                crate::error::CreateImportJobError,
                crate::input::CreateImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The destination for the import job.</p>
        pub fn import_destination(mut self, inp: crate::model::ImportDestination) -> Self {
            self.inner = self.inner.import_destination(inp);
            self
        }
        /// <p>The destination for the import job.</p>
        pub fn set_import_destination(
            mut self,
            input: std::option::Option<crate::model::ImportDestination>,
        ) -> Self {
            self.inner = self.inner.set_import_destination(input);
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn import_data_source(mut self, inp: crate::model::ImportDataSource) -> Self {
            self.inner = self.inner.import_data_source(inp);
            self
        }
        /// <p>The data source for the import job.</p>
        pub fn set_import_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.inner = self.inner.set_import_data_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Delete an existing configuration set.</p>
    /// <p>
    /// <i>Configuration sets</i> are groups of rules that you can apply to the
    /// emails you send. You apply a configuration set to an email by including a reference to
    /// the configuration set in the headers of the email. When you apply a configuration set to
    /// an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationSetInputOperationOutputAlias,
                crate::output::DeleteConfigurationSetOutput,
                crate::error::DeleteConfigurationSetError,
                crate::input::DeleteConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// <p>Delete an event destination.</p>
    /// <p>
    /// <i>Events</i> include message sends, deliveries, opens, clicks, bounces,
    /// and complaints. <i>Event destinations</i> are places that you can send
    /// information about these events to. For example, you can send event data to Amazon SNS to
    /// receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to
    /// stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::DeleteConfigurationSetEventDestinationOutput,
                crate::error::DeleteConfigurationSetEventDestinationError,
                crate::input::DeleteConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination to
        /// delete.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that contains the event destination to
        /// delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(inp);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContact`.
    ///
    /// <p>Removes a contact from a contact list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_input::Builder,
    }
    impl<C, M, R> DeleteContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactInputOperationOutputAlias,
                crate::output::DeleteContactOutput,
                crate::error::DeleteContactError,
                crate::input::DeleteContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list from which the contact should be removed.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The contact's email address.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactList`.
    ///
    /// <p>Deletes a contact list and all of the contacts on that list.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContactList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_list_input::Builder,
    }
    impl<C, M, R> DeleteContactList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactListInputOperationOutputAlias,
                crate::output::DeleteContactListOutput,
                crate::error::DeleteContactListError,
                crate::input::DeleteContactListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomVerificationEmailTemplate`.
    ///
    /// <p>Deletes an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> DeleteCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::DeleteCustomVerificationEmailTemplateOutput,
                crate::error::DeleteCustomVerificationEmailTemplateError,
                crate::input::DeleteCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDedicatedIpPool`.
    ///
    /// <p>Delete a dedicated IP pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDedicatedIpPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dedicated_ip_pool_input::Builder,
    }
    impl<C, M, R> DeleteDedicatedIpPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDedicatedIpPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDedicatedIpPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDedicatedIpPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDedicatedIpPoolInputOperationOutputAlias,
                crate::output::DeleteDedicatedIpPoolOutput,
                crate::error::DeleteDedicatedIpPoolError,
                crate::input::DeleteDedicatedIpPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(inp);
            self
        }
        /// <p>The name of the dedicated IP pool that you want to delete.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailIdentity`.
    ///
    /// <p>Deletes an email identity. An identity can be either an email address or a domain
    /// name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEmailIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_identity_input::Builder,
    }
    impl<C, M, R> DeleteEmailIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailIdentityInputOperationOutputAlias,
                crate::output::DeleteEmailIdentityOutput,
                crate::error::DeleteEmailIdentityError,
                crate::input::DeleteEmailIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The identity (that is, the email address or domain) to delete.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailIdentityPolicy`.
    ///
    /// <p>Deletes the specified sending authorization policy for the given identity (an email
    /// address or a domain). This API returns successfully even if a policy with the specified
    /// name does not exist.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEmailIdentityPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_identity_policy_input::Builder,
    }
    impl<C, M, R> DeleteEmailIdentityPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailIdentityPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailIdentityPolicyInputOperationOutputAlias,
                crate::output::DeleteEmailIdentityPolicyOutput,
                crate::error::DeleteEmailIdentityPolicyError,
                crate::input::DeleteEmailIdentityPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEmailTemplate`.
    ///
    /// <p>Deletes an email template.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_email_template_input::Builder,
    }
    impl<C, M, R> DeleteEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEmailTemplateInputOperationOutputAlias,
                crate::output::DeleteEmailTemplateOutput,
                crate::error::DeleteEmailTemplateError,
                crate::input::DeleteEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSuppressedDestination`.
    ///
    /// <p>Removes an email address from the suppression list for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSuppressedDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_suppressed_destination_input::Builder,
    }
    impl<C, M, R> DeleteSuppressedDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSuppressedDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSuppressedDestinationInputOperationOutputAlias,
                crate::output::DeleteSuppressedDestinationOutput,
                crate::error::DeleteSuppressedDestinationError,
                crate::input::DeleteSuppressedDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The suppressed email destination to remove from the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccount`.
    ///
    /// <p>Obtain information about the email-sending status and capabilities of your Amazon SES
    /// account in the current Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_input::Builder,
    }
    impl<C, M, R> GetAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountInputOperationOutputAlias,
                crate::output::GetAccountOutput,
                crate::error::GetAccountError,
                crate::input::GetAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetBlacklistReports`.
    ///
    /// <p>Retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlacklistReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blacklist_reports_input::Builder,
    }
    impl<C, M, R> GetBlacklistReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlacklistReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlacklistReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlacklistReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlacklistReportsInputOperationOutputAlias,
                crate::output::GetBlacklistReportsOutput,
                crate::error::GetBlacklistReportsError,
                crate::input::GetBlacklistReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `BlacklistItemNames`.
        ///
        /// To override the contents of this collection use [`set_blacklist_item_names`](Self::set_blacklist_item_names).
        ///
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can
        /// only specify the dedicated IP addresses that you use to send email using Amazon SES or
        /// Amazon Pinpoint.</p>
        pub fn blacklist_item_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blacklist_item_names(inp);
            self
        }
        /// <p>A list of IP addresses that you want to retrieve blacklist information about. You can
        /// only specify the dedicated IP addresses that you use to send email using Amazon SES or
        /// Amazon Pinpoint.</p>
        pub fn set_blacklist_item_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_blacklist_item_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSet`.
    ///
    /// <p>Get information about an existing configuration set, including the dedicated IP pool
    /// that it's associated with, whether or not it's enabled for sending email, and
    /// more.</p>
    /// <p>
    /// <i>Configuration sets</i> are groups of rules that you can apply to the
    /// emails you send. You apply a configuration set to an email by including a reference to
    /// the configuration set in the headers of the email. When you apply a configuration set to
    /// an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_configuration_set_input::Builder,
    }
    impl<C, M, R> GetConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConfigurationSetInputOperationOutputAlias,
                crate::output::GetConfigurationSetOutput,
                crate::error::GetConfigurationSetError,
                crate::input::GetConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfigurationSetEventDestinations`.
    ///
    /// <p>Retrieve a list of event destinations that are associated with a configuration
    /// set.</p>
    /// <p>
    /// <i>Events</i> include message sends, deliveries, opens, clicks, bounces,
    /// and complaints. <i>Event destinations</i> are places that you can send
    /// information about these events to. For example, you can send event data to Amazon SNS to
    /// receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to
    /// stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConfigurationSetEventDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_configuration_set_event_destinations_input::Builder,
    }
    impl<C, M, R> GetConfigurationSetEventDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConfigurationSetEventDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigurationSetEventDestinationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetConfigurationSetEventDestinationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConfigurationSetEventDestinationsInputOperationOutputAlias,
                crate::output::GetConfigurationSetEventDestinationsOutput,
                crate::error::GetConfigurationSetEventDestinationsError,
                crate::input::GetConfigurationSetEventDestinationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that contains the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContact`.
    ///
    /// <p>Returns a contact from a contact list.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_input::Builder,
    }
    impl<C, M, R> GetContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactInputOperationOutputAlias,
                crate::output::GetContactOutput,
                crate::error::GetContactError,
                crate::input::GetContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list to which the contact belongs.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactList`.
    ///
    /// <p>Returns contact list metadata. It does not return any information about the contacts
    /// present in the list.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_list_input::Builder,
    }
    impl<C, M, R> GetContactList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactListInputOperationOutputAlias,
                crate::output::GetContactListOutput,
                crate::error::GetContactListError,
                crate::input::GetContactListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCustomVerificationEmailTemplate`.
    ///
    /// <p>Returns the custom email verification template for the template name you
    /// specify.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> GetCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::GetCustomVerificationEmailTemplateOutput,
                crate::error::GetCustomVerificationEmailTemplateError,
                crate::input::GetCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIp`.
    ///
    /// <p>Get information about a dedicated IP address, including the name of the dedicated IP
    /// pool that it's associated with, as well information about the automatic warm-up process
    /// for the address.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDedicatedIp<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dedicated_ip_input::Builder,
    }
    impl<C, M, R> GetDedicatedIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDedicatedIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDedicatedIpInputOperationOutputAlias,
                crate::output::GetDedicatedIpOutput,
                crate::error::GetDedicatedIpError,
                crate::input::GetDedicatedIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify
        /// has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(inp);
            self
        }
        /// <p>The IP address that you want to obtain more information about. The value you specify
        /// has to be a dedicated IP address that's assocaited with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDedicatedIps`.
    ///
    /// <p>List the dedicated IP addresses that are associated with your Amazon Web Services
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDedicatedIps<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dedicated_ips_input::Builder,
    }
    impl<C, M, R> GetDedicatedIps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDedicatedIps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDedicatedIpsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDedicatedIpsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDedicatedIpsInputOperationOutputAlias,
                crate::output::GetDedicatedIpsOutput,
                crate::error::GetDedicatedIpsError,
                crate::input::GetDedicatedIpsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pool_name(inp);
            self
        }
        /// <p>The name of the IP pool that the dedicated IP address is associated with.</p>
        pub fn set_pool_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pool_name(input);
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the
        /// position of the dedicated IP pool in the list of IP pools.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the
        /// position of the dedicated IP pool in the list of IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityDashboardOptions`.
    ///
    /// <p>Retrieve information about the status of the Deliverability dashboard for your account. When
    /// the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other
    /// metrics for the domains that you use to send email. You also gain the ability to perform
    /// predictive inbox placement tests.</p>
    ///
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition
    /// to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more
    /// information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeliverabilityDashboardOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deliverability_dashboard_options_input::Builder,
    }
    impl<C, M, R> GetDeliverabilityDashboardOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeliverabilityDashboardOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityDashboardOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityDashboardOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeliverabilityDashboardOptionsInputOperationOutputAlias,
                crate::output::GetDeliverabilityDashboardOptionsOutput,
                crate::error::GetDeliverabilityDashboardOptionsError,
                crate::input::GetDeliverabilityDashboardOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDeliverabilityTestReport`.
    ///
    /// <p>Retrieve the results of a predictive inbox placement test.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDeliverabilityTestReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deliverability_test_report_input::Builder,
    }
    impl<C, M, R> GetDeliverabilityTestReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeliverabilityTestReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeliverabilityTestReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeliverabilityTestReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeliverabilityTestReportInputOperationOutputAlias,
                crate::output::GetDeliverabilityTestReportOutput,
                crate::error::GetDeliverabilityTestReportError,
                crate::input::GetDeliverabilityTestReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn report_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(inp);
            self
        }
        /// <p>A unique string that identifies the predictive inbox placement test.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainDeliverabilityCampaign`.
    ///
    /// <p>Retrieve all the deliverability data for a specific campaign. This data is available
    /// for a campaign only if the campaign sent email by using a domain that the
    /// Deliverability dashboard is enabled for.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainDeliverabilityCampaign<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_deliverability_campaign_input::Builder,
    }
    impl<C, M, R> GetDomainDeliverabilityCampaign<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainDeliverabilityCampaign`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainDeliverabilityCampaignOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainDeliverabilityCampaignError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainDeliverabilityCampaignInputOperationOutputAlias,
                crate::output::GetDomainDeliverabilityCampaignOutput,
                crate::error::GetDomainDeliverabilityCampaignError,
                crate::input::GetDomainDeliverabilityCampaignInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
        /// and assigns this identifier to a campaign.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The unique identifier for the campaign. The Deliverability dashboard automatically generates
        /// and assigns this identifier to a campaign.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainStatisticsReport`.
    ///
    /// <p>Retrieve inbox placement and engagement rates for the domains that you use to send
    /// email.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainStatisticsReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_statistics_report_input::Builder,
    }
    impl<C, M, R> GetDomainStatisticsReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainStatisticsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainStatisticsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainStatisticsReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainStatisticsReportInputOperationOutputAlias,
                crate::output::GetDomainStatisticsReportOutput,
                crate::error::GetDomainStatisticsReportError,
                crate::input::GetDomainStatisticsReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain that you want to obtain deliverability metrics for.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics
        /// for.</p>
        pub fn start_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The first day (in Unix time) that you want to obtain domain deliverability metrics
        /// for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for.
        /// The <code>EndDate</code> that you specify has to be less than or equal to 30 days after
        /// the <code>StartDate</code>.</p>
        pub fn end_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The last day (in Unix time) that you want to obtain domain deliverability metrics for.
        /// The <code>EndDate</code> that you specify has to be less than or equal to 30 days after
        /// the <code>StartDate</code>.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailIdentity`.
    ///
    /// <p>Provides information about a specific identity, including the identity's verification
    /// status, sending authorization policies, its DKIM authentication status, and its custom
    /// Mail-From settings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEmailIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_identity_input::Builder,
    }
    impl<C, M, R> GetEmailIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailIdentityInputOperationOutputAlias,
                crate::output::GetEmailIdentityOutput,
                crate::error::GetEmailIdentityError,
                crate::input::GetEmailIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailIdentityPolicies`.
    ///
    /// <p>Returns the requested sending authorization policies for the given identity (an email
    /// address or a domain). The policies are returned as a map of policy names to policy
    /// contents. You can retrieve a maximum of 20 policies at a time.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEmailIdentityPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_identity_policies_input::Builder,
    }
    impl<C, M, R> GetEmailIdentityPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailIdentityPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailIdentityPoliciesInputOperationOutputAlias,
                crate::output::GetEmailIdentityPoliciesOutput,
                crate::error::GetEmailIdentityPoliciesError,
                crate::input::GetEmailIdentityPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEmailTemplate`.
    ///
    /// <p>Displays the template object (which includes the subject line, HTML part and text
    /// part) for the template you specify.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_email_template_input::Builder,
    }
    impl<C, M, R> GetEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEmailTemplateInputOperationOutputAlias,
                crate::output::GetEmailTemplateOutput,
                crate::error::GetEmailTemplateError,
                crate::input::GetEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImportJob`.
    ///
    /// <p>Provides information about an import job.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_job_input::Builder,
    }
    impl<C, M, R> GetImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportJobInputOperationOutputAlias,
                crate::output::GetImportJobOutput,
                crate::error::GetImportJobError,
                crate::input::GetImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the import job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSuppressedDestination`.
    ///
    /// <p>Retrieves information about a specific email address that's on the suppression list
    /// for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSuppressedDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_suppressed_destination_input::Builder,
    }
    impl<C, M, R> GetSuppressedDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSuppressedDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSuppressedDestinationInputOperationOutputAlias,
                crate::output::GetSuppressedDestinationOutput,
                crate::error::GetSuppressedDestinationError,
                crate::input::GetSuppressedDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that's on the account suppression list.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address that's on the account suppression list.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// <p>List all of the configuration sets associated with your account in the current
    /// region.</p>
    /// <p>
    /// <i>Configuration sets</i> are groups of rules that you can apply to the
    /// emails you send. You apply a configuration set to an email by including a reference to
    /// the configuration set in the headers of the email. When you apply a configuration set to
    /// an email, all of the rules in that configuration set are applied to the email.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurationSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl<C, M, R> ListConfigurationSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationSetsInputOperationOutputAlias,
                crate::output::ListConfigurationSetsOutput,
                crate::error::ListConfigurationSetsError,
                crate::input::ListConfigurationSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position in the list of configuration sets.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position in the list of configuration sets.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListConfigurationSets</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactLists`.
    ///
    /// <p>Lists all of the contact lists available.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContactLists<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_lists_input::Builder,
    }
    impl<C, M, R> ListContactLists<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactListsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactListsInputOperationOutputAlias,
                crate::output::ListContactListsOutput,
                crate::error::ListContactListsError,
                crate::input::ListContactListsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate
        /// results. If additional contact lists exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// lists.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>Maximum number of contact lists to return at once. Use this parameter to paginate
        /// results. If additional contact lists exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// lists.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be
        /// listed. Use the token provided in the Response to use in the subsequent call to
        /// ListContactLists with the same parameters to retrieve the next page of contact
        /// lists.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string token indicating that there might be additional contact lists available to be
        /// listed. Use the token provided in the Response to use in the subsequent call to
        /// ListContactLists with the same parameters to retrieve the next page of contact
        /// lists.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Lists the contacts present in a specific contact list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl<C, M, R> ListContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactsInputOperationOutputAlias,
                crate::output::ListContactsOutput,
                crate::error::ListContactsError,
                crate::input::ListContactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn filter(mut self, inp: crate::model::ListContactsFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A filter that can be applied to a list of contacts.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListContactsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there
        /// are more or less contacts than the value of the PageSize. Use this parameter to
        /// paginate results. If additional contacts exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// contacts.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of contacts that may be returned at once, which is dependent on if there
        /// are more or less contacts than the value of the PageSize. Use this parameter to
        /// paginate results. If additional contacts exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// contacts.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be
        /// listed. Use the token provided in the Response to use in the subsequent call to
        /// ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string token indicating that there might be additional contacts available to be
        /// listed. Use the token provided in the Response to use in the subsequent call to
        /// ListContacts with the same parameters to retrieve the next page of contacts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomVerificationEmailTemplates`.
    ///
    /// <p>Lists the existing custom verification email templates for your account in the current
    /// Amazon Web Services Region.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomVerificationEmailTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_verification_email_templates_input::Builder,
    }
    impl<C, M, R> ListCustomVerificationEmailTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomVerificationEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomVerificationEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomVerificationEmailTemplatesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomVerificationEmailTemplatesInputOperationOutputAlias,
                crate::output::ListCustomVerificationEmailTemplatesOutput,
                crate::error::ListCustomVerificationEmailTemplatesError,
                crate::input::ListCustomVerificationEmailTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to
        /// <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the
        /// list of custom verification email templates.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to
        /// <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the
        /// list of custom verification email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListCustomVerificationEmailTemplates</code>. If the number of results is
        /// larger than the number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListCustomVerificationEmailTemplates</code>. If the number of results is
        /// larger than the number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 50.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDedicatedIpPools`.
    ///
    /// <p>List all of the dedicated IP pools that exist in your Amazon Web Services account in the current
    /// Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDedicatedIpPools<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dedicated_ip_pools_input::Builder,
    }
    impl<C, M, R> ListDedicatedIpPools<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDedicatedIpPools`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDedicatedIpPoolsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDedicatedIpPoolsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDedicatedIpPoolsInputOperationOutputAlias,
                crate::output::ListDedicatedIpPoolsOutput,
                crate::error::ListDedicatedIpPoolsError,
                crate::input::ListDedicatedIpPoolsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate
        /// the position in the list of dedicated IP pools.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate
        /// the position in the list of dedicated IP pools.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>.
        /// If the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeliverabilityTestReports`.
    ///
    /// <p>Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
    /// predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
    /// operation to view the results.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeliverabilityTestReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deliverability_test_reports_input::Builder,
    }
    impl<C, M, R> ListDeliverabilityTestReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeliverabilityTestReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeliverabilityTestReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeliverabilityTestReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeliverabilityTestReportsInputOperationOutputAlias,
                crate::output::ListDeliverabilityTestReportsOutput,
                crate::error::ListDeliverabilityTestReportsError,
                crate::input::ListDeliverabilityTestReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to
        /// indicate the position in the list of predictive inbox placement tests.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to
        /// indicate the position in the list of predictive inbox placement tests.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListDeliverabilityTestReports</code>. If the number of results is larger than
        /// the number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListDeliverabilityTestReports</code>. If the number of results is larger than
        /// the number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainDeliverabilityCampaigns`.
    ///
    /// <p>Retrieve deliverability data for all the campaigns that used a specific domain to send
    /// email during a specified time range. This data is available for a domain only if you
    /// enabled the Deliverability dashboard for the domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomainDeliverabilityCampaigns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domain_deliverability_campaigns_input::Builder,
    }
    impl<C, M, R> ListDomainDeliverabilityCampaigns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainDeliverabilityCampaigns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainDeliverabilityCampaignsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainDeliverabilityCampaignsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainDeliverabilityCampaignsInputOperationOutputAlias,
                crate::output::ListDomainDeliverabilityCampaignsOutput,
                crate::error::ListDomainDeliverabilityCampaignsError,
                crate::input::ListDomainDeliverabilityCampaignsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data
        /// for.</p>
        pub fn start_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The first day, in Unix time format, that you want to obtain deliverability data
        /// for.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for.
        /// This value has to be less than or equal to 30 days after the value of the
        /// <code>StartDate</code> parameter.</p>
        pub fn end_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The last day, in Unix time format, that you want to obtain deliverability data for.
        /// This value has to be less than or equal to 30 days after the value of the
        /// <code>StartDate</code> parameter.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn subscribed_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscribed_domain(inp);
            self
        }
        /// <p>The domain to obtain deliverability data for.</p>
        pub fn set_subscribed_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domain(input);
            self
        }
        /// <p>A token that’s returned from a previous call to the
        /// <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the
        /// position of a campaign in the list of campaigns.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token that’s returned from a previous call to the
        /// <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the
        /// position of a campaign in the list of campaigns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the
        /// <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results
        /// is larger than the number that you specify in this parameter, the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The maximum number of results to include in response to a single call to the
        /// <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results
        /// is larger than the number that you specify in this parameter, the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEmailIdentities`.
    ///
    /// <p>Returns a list of all of the email identities that are associated with your Amazon Web Services
    /// account. An identity can be either an email address or a domain. This operation returns
    /// identities that are verified as well as those that aren't. This operation returns
    /// identities that are associated with Amazon SES and Amazon Pinpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEmailIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_email_identities_input::Builder,
    }
    impl<C, M, R> ListEmailIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEmailIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEmailIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEmailIdentitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEmailIdentitiesInputOperationOutputAlias,
                crate::output::ListEmailIdentitiesOutput,
                crate::error::ListEmailIdentitiesError,
                crate::input::ListEmailIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate
        /// the position in the list of identities.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate
        /// the position in the list of identities.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If
        /// the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If
        /// the number of results is larger than the number you specified in this parameter, then
        /// the response includes a <code>NextToken</code> element, which you can use to obtain
        /// additional results.</p>
        /// <p>The value you specify has to be at least 0, and can be no more than 1000.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEmailTemplates`.
    ///
    /// <p>Lists the email templates present in your Amazon SES account in the current Amazon Web Services
    /// Region.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEmailTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_email_templates_input::Builder,
    }
    impl<C, M, R> ListEmailTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEmailTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEmailTemplatesInputOperationOutputAlias,
                crate::output::ListEmailTemplatesOutput,
                crate::error::ListEmailTemplatesError,
                crate::input::ListEmailTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate
        /// the position in the list of email templates.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate
        /// the position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of
        /// results is larger than the number you specified in this parameter, then the response
        /// includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of
        /// results is larger than the number you specified in this parameter, then the response
        /// includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>
        /// <p>The value you specify has to be at least 1, and can be no more than 10.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImportJobs`.
    ///
    /// <p>Lists all of the import jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_import_jobs_input::Builder,
    }
    impl<C, M, R> ListImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImportJobsInputOperationOutputAlias,
                crate::output::ListImportJobsOutput,
                crate::error::ListImportJobsError,
                crate::input::ListImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The destination of the import job, which can be used to list import jobs that have a
        /// certain <code>ImportDestinationType</code>.</p>
        pub fn import_destination_type(mut self, inp: crate::model::ImportDestinationType) -> Self {
            self.inner = self.inner.import_destination_type(inp);
            self
        }
        /// <p>The destination of the import job, which can be used to list import jobs that have a
        /// certain <code>ImportDestinationType</code>.</p>
        pub fn set_import_destination_type(
            mut self,
            input: std::option::Option<crate::model::ImportDestinationType>,
        ) -> Self {
            self.inner = self.inner.set_import_destination_type(input);
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be
        /// listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the
        /// same parameters to retrieve the next page of import jobs.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string token indicating that there might be additional import jobs available to be
        /// listed. Copy this token to a subsequent call to <code>ListImportJobs</code> with the
        /// same parameters to retrieve the next page of import jobs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate
        /// results. If additional import jobs exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// addresses.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>Maximum number of import jobs to return at once. Use this parameter to paginate
        /// results. If additional import jobs exist beyond the specified limit, the
        /// <code>NextToken</code> element is sent in the response. Use the
        /// <code>NextToken</code> value in subsequent requests to retrieve additional
        /// addresses.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuppressedDestinations`.
    ///
    /// <p>Retrieves a list of email addresses that are on the suppression list for your
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSuppressedDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suppressed_destinations_input::Builder,
    }
    impl<C, M, R> ListSuppressedDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuppressedDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuppressedDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuppressedDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuppressedDestinationsInputOperationOutputAlias,
                crate::output::ListSuppressedDestinationsOutput,
                crate::error::ListSuppressedDestinationsError,
                crate::input::ListSuppressedDestinationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Reasons`.
        ///
        /// To override the contents of this collection use [`set_reasons`](Self::set_reasons).
        ///
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn reasons(mut self, inp: impl Into<crate::model::SuppressionListReason>) -> Self {
            self.inner = self.inner.reasons(inp);
            self
        }
        /// <p>The factors that caused the email address to be added to .</p>
        pub fn set_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_reasons(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes
        /// addresses that were added to the list after a specific date. The date that you specify
        /// should be in Unix time format.</p>
        pub fn start_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes
        /// addresses that were added to the list after a specific date. The date that you specify
        /// should be in Unix time format.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes
        /// addresses that were added to the list before a specific date. The date that you specify
        /// should be in Unix time format.</p>
        pub fn end_date(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>Used to filter the list of suppressed email destinations so that it only includes
        /// addresses that were added to the list before a specific date. The date that you specify
        /// should be in Unix time format.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to
        /// indicate the position in the list of suppressed email addresses.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to
        /// indicate the position in the list of suppressed email addresses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListSuppressedDestinations</code>. If the number of results is larger than the
        /// number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        pub fn page_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.page_size(inp);
            self
        }
        /// <p>The number of results to show in a single call to
        /// <code>ListSuppressedDestinations</code>. If the number of results is larger than the
        /// number you specified in this parameter, then the response includes a
        /// <code>NextToken</code> element, which you can use to obtain additional
        /// results.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieve a list of the tags (keys and values) that are associated with a specified
    /// resource. A <i>tag</i> is a label that you optionally define and associate
    /// with a resource. Each tag consists of a required <i>tag key</i> and an
    /// optional associated <i>tag value</i>. A tag key is a general label that
    /// acts as a category for more specific tag values. A tag value acts as a descriptor within
    /// a tag key.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag
        /// information for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag
        /// information for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountDedicatedIpWarmupAttributes`.
    ///
    /// <p>Enable or disable the automatic warm-up feature for dedicated IP addresses.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAccountDedicatedIpWarmupAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_account_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl<C, M, R> PutAccountDedicatedIpWarmupAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccountDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccountDedicatedIpWarmupAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccountDedicatedIpWarmupAttributesInputOperationOutputAlias,
                crate::output::PutAccountDedicatedIpWarmupAttributesOutput,
                crate::error::PutAccountDedicatedIpWarmupAttributesError,
                crate::input::PutAccountDedicatedIpWarmupAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are
        /// associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code>
        /// to enable the automatic warm-up feature, or set to <code>false</code> to disable
        /// it.</p>
        pub fn auto_warmup_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_warmup_enabled(inp);
            self
        }
        /// <p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are
        /// associated with your Amazon SES account in the current Amazon Web Services Region. Set to <code>true</code>
        /// to enable the automatic warm-up feature, or set to <code>false</code> to disable
        /// it.</p>
        pub fn set_auto_warmup_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_warmup_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountDetails`.
    ///
    /// <p>Update your Amazon SES account details.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAccountDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_account_details_input::Builder,
    }
    impl<C, M, R> PutAccountDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccountDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccountDetailsInputOperationOutputAlias,
                crate::output::PutAccountDetailsOutput,
                crate::error::PutAccountDetailsError,
                crate::input::PutAccountDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of email your account will send.</p>
        pub fn mail_type(mut self, inp: crate::model::MailType) -> Self {
            self.inner = self.inner.mail_type(inp);
            self
        }
        /// <p>The type of email your account will send.</p>
        pub fn set_mail_type(mut self, input: std::option::Option<crate::model::MailType>) -> Self {
            self.inner = self.inner.set_mail_type(input);
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of
        /// content that you plan to send.</p>
        pub fn website_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_url(inp);
            self
        }
        /// <p>The URL of your website. This information helps us better understand the type of
        /// content that you plan to send.</p>
        pub fn set_website_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_website_url(input);
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn contact_language(mut self, inp: crate::model::ContactLanguage) -> Self {
            self.inner = self.inner.contact_language(inp);
            self
        }
        /// <p>The language you would prefer to be contacted with.</p>
        pub fn set_contact_language(
            mut self,
            input: std::option::Option<crate::model::ContactLanguage>,
        ) -> Self {
            self.inner = self.inner.set_contact_language(input);
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn use_case_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.use_case_description(inp);
            self
        }
        /// <p>A description of the types of email that you plan to send.</p>
        pub fn set_use_case_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_use_case_description(input);
            self
        }
        /// Appends an item to `AdditionalContactEmailAddresses`.
        ///
        /// To override the contents of this collection use [`set_additional_contact_email_addresses`](Self::set_additional_contact_email_addresses).
        ///
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES
        /// matters.</p>
        pub fn additional_contact_email_addresses(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_contact_email_addresses(inp);
            self
        }
        /// <p>Additional email addresses that you would like to be notified regarding Amazon SES
        /// matters.</p>
        pub fn set_additional_contact_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_contact_email_addresses(input);
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current
        /// Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the
        /// <i>sandbox</i>. When your account is in the sandbox, you can only send
        /// email to verified identities. Additionally, the maximum number of emails you can send in
        /// a 24-hour period (your sending quota) is 200, and the maximum number of emails you can
        /// send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your
        /// account has production access, you can send email to any address. The sending quota and
        /// maximum sending rate for your account vary based on your specific use case.</p>
        pub fn production_access_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.production_access_enabled(inp);
            self
        }
        /// <p>Indicates whether or not your account should have production access in the current
        /// Amazon Web Services Region.</p>
        /// <p>If the value is <code>false</code>, then your account is in the
        /// <i>sandbox</i>. When your account is in the sandbox, you can only send
        /// email to verified identities. Additionally, the maximum number of emails you can send in
        /// a 24-hour period (your sending quota) is 200, and the maximum number of emails you can
        /// send per second (your maximum sending rate) is 1.</p>
        /// <p>If the value is <code>true</code>, then your account has production access. When your
        /// account has production access, you can send email to any address. The sending quota and
        /// maximum sending rate for your account vary based on your specific use case.</p>
        pub fn set_production_access_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_production_access_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSendingAttributes`.
    ///
    /// <p>Enable or disable the ability of your account to send email.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAccountSendingAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_account_sending_attributes_input::Builder,
    }
    impl<C, M, R> PutAccountSendingAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccountSendingAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSendingAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSendingAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccountSendingAttributesInputOperationOutputAlias,
                crate::output::PutAccountSendingAttributesOutput,
                crate::error::PutAccountSendingAttributesError,
                crate::input::PutAccountSendingAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to
        /// enable email sending, or set to <code>false</code> to disable email sending.</p>
        /// <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation
        /// to resume your account's ability to send email.</p>
        /// </note>
        pub fn sending_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.sending_enabled(inp);
            self
        }
        /// <p>Enables or disables your account's ability to send email. Set to <code>true</code> to
        /// enable email sending, or set to <code>false</code> to disable email sending.</p>
        /// <note>
        /// <p>If Amazon Web Services paused your account's ability to send email, you can't use this operation
        /// to resume your account's ability to send email.</p>
        /// </note>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSuppressionAttributes`.
    ///
    /// <p>Change the settings for the account-level suppression list.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAccountSuppressionAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_account_suppression_attributes_input::Builder,
    }
    impl<C, M, R> PutAccountSuppressionAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccountSuppressionAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSuppressionAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSuppressionAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccountSuppressionAttributesInputOperationOutputAlias,
                crate::output::PutAccountSuppressionAttributesOutput,
                crate::error::PutAccountSuppressionAttributesError,
                crate::input::PutAccountSuppressionAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SuppressedReasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses will be automatically added to
        /// the suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn suppressed_reasons(
            mut self,
            inp: impl Into<crate::model::SuppressionListReason>,
        ) -> Self {
            self.inner = self.inner.suppressed_reasons(inp);
            self
        }
        /// <p>A list that contains the reasons that email addresses will be automatically added to
        /// the suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_suppressed_reasons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetDeliveryOptions`.
    ///
    /// <p>Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools
    /// to create groups of dedicated IP addresses for sending specific types of email.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetDeliveryOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_delivery_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetDeliveryOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetDeliveryOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetDeliveryOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetDeliveryOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetDeliveryOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetDeliveryOptionsOutput,
                crate::error::PutConfigurationSetDeliveryOptionsError,
                crate::input::PutConfigurationSetDeliveryOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to associate with a dedicated IP pool.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, inp: crate::model::TlsPolicy) -> Self {
            self.inner = self.inner.tls_policy(inp);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.inner = self.inner.set_tls_policy(input);
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn sending_pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sending_pool_name(inp);
            self
        }
        /// <p>The name of the dedicated IP pool to associate with the configuration set.</p>
        pub fn set_sending_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sending_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetReputationOptions`.
    ///
    /// <p>Enable or disable collection of reputation metrics for emails that you send using a
    /// particular configuration set in a specific Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetReputationOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_reputation_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetReputationOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetReputationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetReputationOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetReputationOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetReputationOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetReputationOptionsOutput,
                crate::error::PutConfigurationSetReputationOptionsError,
                crate::input::PutConfigurationSetReputationOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
        /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
        /// configuration set.</p>
        pub fn reputation_metrics_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.reputation_metrics_enabled(inp);
            self
        }
        /// <p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration
        /// set. If <code>false</code>, tracking of reputation metrics is disabled for the
        /// configuration set.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reputation_metrics_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetSendingOptions`.
    ///
    /// <p>Enable or disable email sending for messages that use a particular configuration set
    /// in a specific Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetSendingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_sending_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetSendingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetSendingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetSendingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutConfigurationSetSendingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetSendingOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetSendingOptionsOutput,
                crate::error::PutConfigurationSetSendingOptionsError,
                crate::input::PutConfigurationSetSendingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to enable or disable email sending for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
        /// <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn sending_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.sending_enabled(inp);
            self
        }
        /// <p>If <code>true</code>, email sending is enabled for the configuration set. If
        /// <code>false</code>, email sending is disabled for the configuration set.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sending_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetSuppressionOptions`.
    ///
    /// <p>Specify the account suppression list preferences for a configuration set.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetSuppressionOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_suppression_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetSuppressionOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetSuppressionOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetSuppressionOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetSuppressionOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetSuppressionOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetSuppressionOptionsOutput,
                crate::error::PutConfigurationSetSuppressionOptionsError,
                crate::input::PutConfigurationSetSuppressionOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to change the suppression list preferences
        /// for.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to change the suppression list preferences
        /// for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `SuppressedReasons`.
        ///
        /// To override the contents of this collection use [`set_suppressed_reasons`](Self::set_suppressed_reasons).
        ///
        /// <p>A list that contains the reasons that email addresses are automatically added to the
        /// suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn suppressed_reasons(
            mut self,
            inp: impl Into<crate::model::SuppressionListReason>,
        ) -> Self {
            self.inner = self.inner.suppressed_reasons(inp);
            self
        }
        /// <p>A list that contains the reasons that email addresses are automatically added to the
        /// suppression list for your account. This list can contain any or all of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a
        /// complaint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BOUNCE</code> – Amazon SES adds an email address to the suppression
        /// list for your account when a message sent to that address results in a hard
        /// bounce.</p>
        /// </li>
        /// </ul>
        pub fn set_suppressed_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuppressionListReason>>,
        ) -> Self {
            self.inner = self.inner.set_suppressed_reasons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetTrackingOptions`.
    ///
    /// <p>Specify a custom domain to use for open and click tracking elements in email that you
    /// send.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetTrackingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_tracking_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetTrackingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetTrackingOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetTrackingOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetTrackingOptionsOutput,
                crate::error::PutConfigurationSetTrackingOptionsError,
                crate::input::PutConfigurationSetTrackingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn custom_redirect_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_redirect_domain(inp);
            self
        }
        /// <p>The domain to use to track open and click events.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_redirect_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpInPool`.
    ///
    /// <p>Move a dedicated IP address to an existing dedicated IP pool.</p>
    /// <note>
    /// <p>The dedicated IP address that you specify must already exist, and must be
    /// associated with your Amazon Web Services account.
    ///
    /// </p>
    /// <p>The dedicated IP pool you specify must already exist. You can create a new pool by
    /// using the <code>CreateDedicatedIpPool</code> operation.</p>
    ///
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutDedicatedIpInPool<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_dedicated_ip_in_pool_input::Builder,
    }
    impl<C, M, R> PutDedicatedIpInPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDedicatedIpInPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpInPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpInPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDedicatedIpInPoolInputOperationOutputAlias,
                crate::output::PutDedicatedIpInPoolOutput,
                crate::error::PutDedicatedIpInPoolError,
                crate::input::PutDedicatedIpInPoolInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify
        /// has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(inp);
            self
        }
        /// <p>The IP address that you want to move to the dedicated IP pool. The value you specify
        /// has to be a dedicated IP address that's associated with your Amazon Web Services account.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to
        /// specify an IP pool that already exists.</p>
        pub fn destination_pool_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_pool_name(inp);
            self
        }
        /// <p>The name of the IP pool that you want to add the dedicated IP address to. You have to
        /// specify an IP pool that already exists.</p>
        pub fn set_destination_pool_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_pool_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDedicatedIpWarmupAttributes`.
    ///
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct PutDedicatedIpWarmupAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_dedicated_ip_warmup_attributes_input::Builder,
    }
    impl<C, M, R> PutDedicatedIpWarmupAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDedicatedIpWarmupAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDedicatedIpWarmupAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDedicatedIpWarmupAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDedicatedIpWarmupAttributesInputOperationOutputAlias,
                crate::output::PutDedicatedIpWarmupAttributesOutput,
                crate::error::PutDedicatedIpWarmupAttributesError,
                crate::input::PutDedicatedIpWarmupAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip(inp);
            self
        }
        /// <p>The dedicated IP address that you want to update the warm-up attributes for.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip(input);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP
        /// address.</p>
        pub fn warmup_percentage(mut self, inp: i32) -> Self {
            self.inner = self.inner.warmup_percentage(inp);
            self
        }
        /// <p>The warm-up percentage that you want to associate with the dedicated IP
        /// address.</p>
        pub fn set_warmup_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_warmup_percentage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDeliverabilityDashboardOption`.
    ///
    /// <p>Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain
    /// access to reputation, deliverability, and other metrics for the domains that you use to
    /// send email. You also gain the ability to perform predictive inbox placement tests.</p>
    ///
    /// <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition
    /// to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more
    /// information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutDeliverabilityDashboardOption<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_deliverability_dashboard_option_input::Builder,
    }
    impl<C, M, R> PutDeliverabilityDashboardOption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDeliverabilityDashboardOption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDeliverabilityDashboardOptionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDeliverabilityDashboardOptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDeliverabilityDashboardOptionInputOperationOutputAlias,
                crate::output::PutDeliverabilityDashboardOptionOutput,
                crate::error::PutDeliverabilityDashboardOptionError,
                crate::input::PutDeliverabilityDashboardOptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this
        /// value to <code>true</code>.</p>
        pub fn dashboard_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.dashboard_enabled(inp);
            self
        }
        /// <p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this
        /// value to <code>true</code>.</p>
        pub fn set_dashboard_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dashboard_enabled(input);
            self
        }
        /// Appends an item to `SubscribedDomains`.
        ///
        /// To override the contents of this collection use [`set_subscribed_domains`](Self::set_subscribed_domains).
        ///
        /// <p>An array of objects, one for each verified domain that you use to send email and
        /// enabled the Deliverability dashboard for.</p>
        pub fn subscribed_domains(
            mut self,
            inp: impl Into<crate::model::DomainDeliverabilityTrackingOption>,
        ) -> Self {
            self.inner = self.inner.subscribed_domains(inp);
            self
        }
        /// <p>An array of objects, one for each verified domain that you use to send email and
        /// enabled the Deliverability dashboard for.</p>
        pub fn set_subscribed_domains(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DomainDeliverabilityTrackingOption>,
            >,
        ) -> Self {
            self.inner = self.inner.set_subscribed_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityConfigurationSetAttributes`.
    ///
    /// <p>Used to associate a configuration set with an email identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEmailIdentityConfigurationSetAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_email_identity_configuration_set_attributes_input::Builder,
    }
    impl<C, M, R> PutEmailIdentityConfigurationSetAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEmailIdentityConfigurationSetAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityConfigurationSetAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityConfigurationSetAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEmailIdentityConfigurationSetAttributesInputOperationOutputAlias,
                crate::output::PutEmailIdentityConfigurationSetAttributesOutput,
                crate::error::PutEmailIdentityConfigurationSetAttributesError,
                crate::input::PutEmailIdentityConfigurationSetAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email address or domain to associate with a configuration set.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The configuration set to associate with an email identity.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityDkimAttributes`.
    ///
    /// <p>Used to enable or disable DKIM authentication for an email identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEmailIdentityDkimAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_email_identity_dkim_attributes_input::Builder,
    }
    impl<C, M, R> PutEmailIdentityDkimAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEmailIdentityDkimAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityDkimAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEmailIdentityDkimAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEmailIdentityDkimAttributesInputOperationOutputAlias,
                crate::output::PutEmailIdentityDkimAttributesOutput,
                crate::error::PutEmailIdentityDkimAttributesError,
                crate::input::PutEmailIdentityDkimAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the
        /// identity are signed using DKIM. If you set this value to <code>false</code>, your
        /// messages are sent without DKIM signing.</p>
        pub fn signing_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.signing_enabled(inp);
            self
        }
        /// <p>Sets the DKIM signing configuration for the identity.</p>
        /// <p>When you set this value <code>true</code>, then the messages that are sent from the
        /// identity are signed using DKIM. If you set this value to <code>false</code>, your
        /// messages are sent without DKIM signing.</p>
        pub fn set_signing_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_signing_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityDkimSigningAttributes`.
    ///
    /// <p>Used to configure or change the DKIM authentication settings for an email domain
    /// identity. You can use this operation to do any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Update the signing attributes for an identity that uses Bring Your Own DKIM
    /// (BYODKIM).</p>
    /// </li>
    /// <li>
    /// <p>Update the key length that should be used for Easy DKIM.</p>
    /// </li>
    /// <li>
    /// <p>Change from using no DKIM authentication to using Easy DKIM.</p>
    /// </li>
    /// <li>
    /// <p>Change from using no DKIM authentication to using BYODKIM.</p>
    /// </li>
    /// <li>
    /// <p>Change from using Easy DKIM to using BYODKIM.</p>
    /// </li>
    /// <li>
    /// <p>Change from using BYODKIM to using Easy DKIM.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutEmailIdentityDkimSigningAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_email_identity_dkim_signing_attributes_input::Builder,
    }
    impl<C, M, R> PutEmailIdentityDkimSigningAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEmailIdentityDkimSigningAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityDkimSigningAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityDkimSigningAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEmailIdentityDkimSigningAttributesInputOperationOutputAlias,
                crate::output::PutEmailIdentityDkimSigningAttributesOutput,
                crate::error::PutEmailIdentityDkimSigningAttributesError,
                crate::input::PutEmailIdentityDkimSigningAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy
        /// DKIM</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring
        /// Your Own DKIM (BYODKIM).</p>
        /// </li>
        /// </ul>
        pub fn signing_attributes_origin(
            mut self,
            inp: crate::model::DkimSigningAttributesOrigin,
        ) -> Self {
            self.inner = self.inner.signing_attributes_origin(inp);
            self
        }
        /// <p>The method to use to configure DKIM for the identity. There are the following possible
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy
        /// DKIM</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring
        /// Your Own DKIM (BYODKIM).</p>
        /// </li>
        /// </ul>
        pub fn set_signing_attributes_origin(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributesOrigin>,
        ) -> Self {
            self.inner = self.inner.set_signing_attributes_origin(input);
            self
        }
        /// <p>An object that contains information about the private key and selector that you want
        /// to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or,
        /// configures the key length to be used for
        /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn signing_attributes(mut self, inp: crate::model::DkimSigningAttributes) -> Self {
            self.inner = self.inner.signing_attributes(inp);
            self
        }
        /// <p>An object that contains information about the private key and selector that you want
        /// to use to configure DKIM for the identity for Bring Your Own DKIM (BYODKIM) for the identity, or,
        /// configures the key length to be used for
        /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p>
        pub fn set_signing_attributes(
            mut self,
            input: std::option::Option<crate::model::DkimSigningAttributes>,
        ) -> Self {
            self.inner = self.inner.set_signing_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityFeedbackAttributes`.
    ///
    /// <p>Used to enable or disable feedback forwarding for an identity. This setting determines
    /// what happens when an identity is used to send an email that results in a bounce or
    /// complaint event.</p>
    /// <p>If the value is <code>true</code>, you receive email notifications when bounce or
    /// complaint events occur. These notifications are sent to the address that you specified
    /// in the <code>Return-Path</code> header of the original email.</p>
    /// <p>You're required to have a method of tracking bounces and complaints. If you haven't
    /// set up another mechanism for receiving bounce or complaint notifications (for example,
    /// by setting up an event destination), you receive an email notification when these events
    /// occur (even if this setting is disabled).</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEmailIdentityFeedbackAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_email_identity_feedback_attributes_input::Builder,
    }
    impl<C, M, R> PutEmailIdentityFeedbackAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEmailIdentityFeedbackAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityFeedbackAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityFeedbackAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEmailIdentityFeedbackAttributesInputOperationOutputAlias,
                crate::output::PutEmailIdentityFeedbackAttributesOutput,
                crate::error::PutEmailIdentityFeedbackAttributesError,
                crate::input::PutEmailIdentityFeedbackAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or
        /// complaint events occur. These notifications are sent to the address that you specified
        /// in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't
        /// set up another mechanism for receiving bounce or complaint notifications (for example,
        /// by setting up an event destination), you receive an email notification when these events
        /// occur (even if this setting is disabled).</p>
        pub fn email_forwarding_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.email_forwarding_enabled(inp);
            self
        }
        /// <p>Sets the feedback forwarding configuration for the identity.</p>
        /// <p>If the value is <code>true</code>, you receive email notifications when bounce or
        /// complaint events occur. These notifications are sent to the address that you specified
        /// in the <code>Return-Path</code> header of the original email.</p>
        /// <p>You're required to have a method of tracking bounces and complaints. If you haven't
        /// set up another mechanism for receiving bounce or complaint notifications (for example,
        /// by setting up an event destination), you receive an email notification when these events
        /// occur (even if this setting is disabled).</p>
        pub fn set_email_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_email_forwarding_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEmailIdentityMailFromAttributes`.
    ///
    /// <p>Used to enable or disable the custom Mail-From domain configuration for an email
    /// identity.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutEmailIdentityMailFromAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_email_identity_mail_from_attributes_input::Builder,
    }
    impl<C, M, R> PutEmailIdentityMailFromAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEmailIdentityMailFromAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEmailIdentityMailFromAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutEmailIdentityMailFromAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEmailIdentityMailFromAttributesInputOperationOutputAlias,
                crate::output::PutEmailIdentityMailFromAttributesOutput,
                crate::error::PutEmailIdentityMailFromAttributesError,
                crate::input::PutEmailIdentityMailFromAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The verified email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The verified email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It has to be a subdomain of the verified identity.</p>
        /// </li>
        /// <li>
        /// <p>It can't be used to receive email.</p>
        /// </li>
        /// <li>
        /// <p>It can't be used in a "From" address if the MAIL FROM domain is a destination
        /// for feedback forwarding emails.</p>
        /// </li>
        /// </ul>
        pub fn mail_from_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mail_from_domain(inp);
            self
        }
        /// <p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>It has to be a subdomain of the verified identity.</p>
        /// </li>
        /// <li>
        /// <p>It can't be used to receive email.</p>
        /// </li>
        /// <li>
        /// <p>It can't be used in a "From" address if the MAIL FROM domain is a destination
        /// for feedback forwarding emails.</p>
        /// </li>
        /// </ul>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mail_from_domain(input);
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When
        /// you set this value to <code>UseDefaultValue</code>, the mail is sent using
        /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
        /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
        /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
        /// email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
        /// states.</p>
        pub fn behavior_on_mx_failure(mut self, inp: crate::model::BehaviorOnMxFailure) -> Self {
            self.inner = self.inner.behavior_on_mx_failure(inp);
            self
        }
        /// <p>The action to take if the required MX record isn't found when you send an email. When
        /// you set this value to <code>UseDefaultValue</code>, the mail is sent using
        /// <i>amazonses.com</i> as the MAIL FROM domain. When you set this value
        /// to <code>RejectMessage</code>, the Amazon SES API v2 returns a
        /// <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the
        /// email.</p>
        /// <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>
        /// states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.inner = self.inner.set_behavior_on_mx_failure(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSuppressedDestination`.
    ///
    /// <p>Adds an email address to the suppression list for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSuppressedDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_suppressed_destination_input::Builder,
    }
    impl<C, M, R> PutSuppressedDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSuppressedDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSuppressedDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSuppressedDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSuppressedDestinationInputOperationOutputAlias,
                crate::output::PutSuppressedDestinationOutput,
                crate::error::PutSuppressedDestinationError,
                crate::input::PutSuppressedDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that should be added to the suppression list for your
        /// account.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address that should be added to the suppression list for your
        /// account.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list
        /// for your account.</p>
        pub fn reason(mut self, inp: crate::model::SuppressionListReason) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The factors that should cause the email address to be added to the suppression list
        /// for your account.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::SuppressionListReason>,
        ) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBulkEmail`.
    ///
    /// <p>Composes an email message to multiple destinations.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendBulkEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_bulk_email_input::Builder,
    }
    impl<C, M, R> SendBulkEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendBulkEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBulkEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBulkEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendBulkEmailInputOperationOutputAlias,
                crate::output::SendBulkEmailOutput,
                crate::error::SendBulkEmailError,
                crate::input::SendBulkEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to use as the "From" address for the email. The
        /// address that you specify has to be verified.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address to use as the "From" address for the email. The
        /// address that you specify has to be verified.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use sender@example.com, then you would specify the
        /// <code>FromEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.from_email_address_identity_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use sender@example.com, then you would specify the
        /// <code>FromEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address_identity_arn(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the
        /// message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(inp);
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the
        /// message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.feedback_forwarding_email_address(inp);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_forwarding_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FeedbackForwardingEmailAddress</code>
        /// parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use feedback@example.com, then you would specify the
        /// <code>FeedbackForwardingEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .feedback_forwarding_email_address_identity_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FeedbackForwardingEmailAddress</code>
        /// parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use feedback@example.com, then you would specify the
        /// <code>FeedbackForwardingEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_feedback_forwarding_email_address_identity_arn(input);
            self
        }
        /// Appends an item to `DefaultEmailTags`.
        ///
        /// To override the contents of this collection use [`set_default_email_tags`](Self::set_default_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendEmail</code> operation. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events.</p>
        pub fn default_email_tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.default_email_tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendEmail</code> operation. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events.</p>
        pub fn set_default_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_default_email_tags(input);
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template
        /// message.</p>
        pub fn default_content(mut self, inp: crate::model::BulkEmailContent) -> Self {
            self.inner = self.inner.default_content(inp);
            self
        }
        /// <p>An object that contains the body of the message. You can specify a template
        /// message.</p>
        pub fn set_default_content(
            mut self,
            input: std::option::Option<crate::model::BulkEmailContent>,
        ) -> Self {
            self.inner = self.inner.set_default_content(input);
            self
        }
        /// Appends an item to `BulkEmailEntries`.
        ///
        /// To override the contents of this collection use [`set_bulk_email_entries`](Self::set_bulk_email_entries).
        ///
        /// <p>The list of bulk email entry objects.</p>
        pub fn bulk_email_entries(mut self, inp: impl Into<crate::model::BulkEmailEntry>) -> Self {
            self.inner = self.inner.bulk_email_entries(inp);
            self
        }
        /// <p>The list of bulk email entry objects.</p>
        pub fn set_bulk_email_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailEntry>>,
        ) -> Self {
            self.inner = self.inner.set_bulk_email_entries(input);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendCustomVerificationEmail`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current
    /// Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a
    /// customized verification email is sent to the specified address.</p>
    /// <p>To use this operation, you must first create a custom verification email template. For
    /// more information about creating and using custom verification email templates, see
    /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendCustomVerificationEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_custom_verification_email_input::Builder,
    }
    impl<C, M, R> SendCustomVerificationEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendCustomVerificationEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendCustomVerificationEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendCustomVerificationEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendCustomVerificationEmailInputOperationOutputAlias,
                crate::output::SendCustomVerificationEmailOutput,
                crate::error::SendCustomVerificationEmailError,
                crate::input::SendCustomVerificationEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEmail`.
    ///
    /// <p>Sends an email message. You can use the Amazon SES API v2 to send the following types of
    /// messages:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Simple</b> – A standard email message. When
    /// you create this type of message, you specify the sender, the recipient, and the
    /// message body, and Amazon SES assembles the message for you.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Raw</b> – A raw, MIME-formatted email
    /// message. When you send this type of email, you have to specify all of the
    /// message headers, as well as the message body. You can use this message type to
    /// send messages that contain attachments. The message that you specify has to be a
    /// valid MIME message.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Templated</b> – A message that contains
    /// personalization tags. When you send this type of email, Amazon SES API v2 automatically
    /// replaces the tags with values that you specify.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct SendEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_email_input::Builder,
    }
    impl<C, M, R> SendEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendEmailInputOperationOutputAlias,
                crate::output::SendEmailOutput,
                crate::error::SendEmailError,
                crate::input::SendEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to use as the "From" address for the email. The
        /// address that you specify has to be verified.
        /// </p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address to use as the "From" address for the email. The
        /// address that you specify has to be verified.
        /// </p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use sender@example.com, then you would specify the
        /// <code>FromEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the
        /// X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message
        /// content.</p>
        pub fn from_email_address_identity_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.from_email_address_identity_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FromEmailAddress</code> parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use sender@example.com, then you would specify the
        /// <code>FromEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FromEmailAddress</code> to be sender@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the
        /// X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message
        /// content.</p>
        pub fn set_from_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address_identity_arn(input);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn destination(mut self, inp: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>An object that contains the recipients of the email message.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the
        /// message, each Reply-to address receives the reply.</p>
        pub fn reply_to_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(inp);
            self
        }
        /// <p>The "Reply-to" email addresses for the message. When the recipient replies to the
        /// message, each Reply-to address receives the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn feedback_forwarding_email_address(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.feedback_forwarding_email_address(inp);
            self
        }
        /// <p>The address that you want bounce and complaint notifications to be sent to.</p>
        pub fn set_feedback_forwarding_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feedback_forwarding_email_address(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FeedbackForwardingEmailAddress</code>
        /// parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use feedback@example.com, then you would specify the
        /// <code>FeedbackForwardingEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn feedback_forwarding_email_address_identity_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .feedback_forwarding_email_address_identity_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>FeedbackForwardingEmailAddress</code>
        /// parameter.</p>
        /// <p>For example, if the owner of example.com (which has ARN
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that
        /// authorizes you to use feedback@example.com, then you would specify the
        /// <code>FeedbackForwardingEmailAddressIdentityArn</code> to be
        /// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
        /// <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_feedback_forwarding_email_address_identity_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_feedback_forwarding_email_address_identity_arn(input);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message
        /// Raw message or a template Message.</p>
        pub fn content(mut self, inp: crate::model::EmailContent) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>An object that contains the body of the message. You can send either a Simple message
        /// Raw message or a template Message.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::EmailContent>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `EmailTags`.
        ///
        /// To override the contents of this collection use [`set_email_tags`](Self::set_email_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendEmail</code> operation. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events. </p>
        pub fn email_tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.email_tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using the <code>SendEmail</code> operation. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events. </p>
        pub fn set_email_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_email_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when sending the email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be
        /// used when a contact chooses to unsubscribe.</p>
        pub fn list_management_options(mut self, inp: crate::model::ListManagementOptions) -> Self {
            self.inner = self.inner.list_management_options(inp);
            self
        }
        /// <p>An object used to specify a list or topic to which an email belongs, which will be
        /// used when a contact chooses to unsubscribe.</p>
        pub fn set_list_management_options(
            mut self,
            input: std::option::Option<crate::model::ListManagementOptions>,
        ) -> Self {
            self.inner = self.inner.set_list_management_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add one or more tags (keys and values) to a specified resource. A
    /// <i>tag</i> is a label that you optionally define and associate with a
    /// resource. Tags can help you categorize and manage resources in different ways, such as
    /// by purpose, owner, environment, or other criteria. A resource can have as many as 50
    /// tags.</p>
    /// <p>Each tag consists of a required <i>tag key</i> and an
    /// associated <i>tag value</i>, both of which you define. A tag key is a
    /// general label that acts as a category for more specific tag values. A tag value acts as
    /// a descriptor within a tag key.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags
        /// to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tags that you want to add to the resource. A tag consists of a required
        /// tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum
        /// length of a tag key is 128 characters. The maximum length of a tag value is 256
        /// characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRenderEmailTemplate`.
    ///
    /// <p>Creates a preview of the MIME content of an email when provided with a template and a
    /// set of replacement data.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestRenderEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_render_email_template_input::Builder,
    }
    impl<C, M, R> TestRenderEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestRenderEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRenderEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRenderEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestRenderEmailTemplateInputOperationOutputAlias,
                crate::output::TestRenderEmailTemplateOutput,
                crate::error::TestRenderEmailTemplateError,
                crate::input::TestRenderEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn template_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(inp);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove one or more tags (keys and values) from a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more
        /// tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more
        /// tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand. For
        /// example:
        /// <code>/v2/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2</code>
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tags (tag keys) that you want to remove from the resource. When you specify a tag
        /// key, the action removes both that key and its associated tag value.</p>
        /// <p>To remove more than one tag from the resource, append the <code>TagKeys</code>
        /// parameter and argument for each additional tag to remove, separated by an ampersand. For
        /// example:
        /// <code>/v2/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2</code>
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// <p>Update the configuration of an event destination for a configuration set.</p>
    /// <p>
    /// <i>Events</i> include message sends, deliveries, opens, clicks, bounces,
    /// and complaints. <i>Event destinations</i> are places that you can send
    /// information about these events to. For example, you can send event data to Amazon SNS to
    /// receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to
    /// stream data to Amazon S3 for long-term storage.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::UpdateConfigurationSetEventDestinationOutput,
                crate::error::UpdateConfigurationSetEventDestinationError,
                crate::input::UpdateConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination to
        /// modify.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that contains the event destination to
        /// modify.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn event_destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(inp);
            self
        }
        /// <p>The name of the event destination.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn event_destination(mut self, inp: crate::model::EventDestinationDefinition) -> Self {
            self.inner = self.inner.event_destination(inp);
            self
        }
        /// <p>An object that defines the event destination.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestinationDefinition>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>Updates a contact's preferences for a list. It is not necessary to specify all
    /// existing topic preferences in the TopicPreferences object, just the ones that need
    /// updating.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The contact's email addres.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// Appends an item to `TopicPreferences`.
        ///
        /// To override the contents of this collection use [`set_topic_preferences`](Self::set_topic_preferences).
        ///
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn topic_preferences(mut self, inp: impl Into<crate::model::TopicPreference>) -> Self {
            self.inner = self.inner.topic_preferences(inp);
            self
        }
        /// <p>The contact's preference for being opted-in to or opted-out of a topic.</p>
        pub fn set_topic_preferences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicPreference>>,
        ) -> Self {
            self.inner = self.inner.set_topic_preferences(input);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn unsubscribe_all(mut self, inp: bool) -> Self {
            self.inner = self.inner.unsubscribe_all(inp);
            self
        }
        /// <p>A boolean value status noting if the contact is unsubscribed from all contact list
        /// topics.</p>
        pub fn set_unsubscribe_all(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_unsubscribe_all(input);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn attributes_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_data(inp);
            self
        }
        /// <p>The attribute data attached to a contact.</p>
        pub fn set_attributes_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attributes_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactList`.
    ///
    /// <p>Updates contact list metadata. This operation does a complete replacement.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_list_input::Builder,
    }
    impl<C, M, R> UpdateContactList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactListOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactListInputOperationOutputAlias,
                crate::output::UpdateContactListOutput,
                crate::error::UpdateContactListError,
                crate::input::UpdateContactListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the contact list.</p>
        pub fn contact_list_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_list_name(inp);
            self
        }
        /// <p>The name of the contact list.</p>
        pub fn set_contact_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_list_name(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple
        /// topics.</p>
        pub fn topics(mut self, inp: impl Into<crate::model::Topic>) -> Self {
            self.inner = self.inner.topics(inp);
            self
        }
        /// <p>An interest group, theme, or label within a list. A contact list can have multiple
        /// topics.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Topic>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of what the contact list is about.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomVerificationEmailTemplate`.
    ///
    /// <p>Updates an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> UpdateCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::UpdateCustomVerificationEmailTemplateOutput,
                crate::error::UpdateCustomVerificationEmailTemplateError,
                crate::input::UpdateCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(inp);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailIdentityPolicy`.
    ///
    /// <p>Updates the specified sending authorization policy for the given identity (an email
    /// address or a domain). This API returns successfully even if a policy with the specified
    /// name does not exist.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    ///
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEmailIdentityPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_identity_policy_input::Builder,
    }
    impl<C, M, R> UpdateEmailIdentityPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailIdentityPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailIdentityPolicyInputOperationOutputAlias,
                crate::output::UpdateEmailIdentityPolicyOutput,
                crate::error::UpdateEmailIdentityPolicyError,
                crate::input::UpdateEmailIdentityPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email identity.</p>
        pub fn email_identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_identity(inp);
            self
        }
        /// <p>The email identity.</p>
        pub fn set_email_identity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy.</p>
        ///
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEmailTemplate`.
    ///
    /// <p>Updates an email template. Email templates enable you to send personalized email to
    /// one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_email_template_input::Builder,
    }
    impl<C, M, R> UpdateEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEmailTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEmailTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEmailTemplateInputOperationOutputAlias,
                crate::output::UpdateEmailTemplateOutput,
                crate::error::UpdateEmailTemplateError,
                crate::input::UpdateEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a
        /// text-only part.</p>
        pub fn template_content(mut self, inp: crate::model::EmailTemplateContent) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the email template, composed of a subject line, an HTML part, and a
        /// text-only part.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<crate::model::EmailTemplateContent>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
