// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Simple Email Service
///
/// Client for invoking operations on Amazon Simple Email Service. Each operation on Amazon Simple Email Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ses::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ses::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ses::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CloneReceiptRuleSet`](crate::client::fluent_builders::CloneReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::CloneReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::CloneReceiptRuleSet::set_rule_set_name): <p>The name of the rule set to create. The name must:</p>  <ul>   <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>   <li> <p>Start and end with a letter or number.</p> </li>   <li> <p>Contain less than 64 characters.</p> </li>  </ul>
    ///   - [`original_rule_set_name(impl Into<String>)`](crate::client::fluent_builders::CloneReceiptRuleSet::original_rule_set_name) / [`set_original_rule_set_name(Option<String>)`](crate::client::fluent_builders::CloneReceiptRuleSet::set_original_rule_set_name): <p>The name of the rule set to clone.</p>
    /// - On success, responds with [`CloneReceiptRuleSetOutput`](crate::output::CloneReceiptRuleSetOutput)

    /// - On failure, responds with [`SdkError<CloneReceiptRuleSetError>`](crate::error::CloneReceiptRuleSetError)
    pub fn clone_receipt_rule_set(&self) -> fluent_builders::CloneReceiptRuleSet {
        fluent_builders::CloneReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set(ConfigurationSet)`](crate::client::fluent_builders::CreateConfigurationSet::configuration_set) / [`set_configuration_set(Option<ConfigurationSet>)`](crate::client::fluent_builders::CreateConfigurationSet::set_configuration_set): <p>A data structure that contains the name of the configuration set.</p>
    /// - On success, responds with [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetError>`](crate::error::CreateConfigurationSetError)
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that the event destination should be associated with.</p>
    ///   - [`event_destination(EventDestination)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestination>)`](crate::client::fluent_builders::CreateConfigurationSetEventDestination::set_event_destination): <p>An object that describes the AWS service that email sending event information will be published to.</p>
    /// - On success, responds with [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetEventDestinationError>`](crate::error::CreateConfigurationSetEventDestinationError)
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfigurationSetTrackingOptions`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions::set_configuration_set_name): <p>The name of the configuration set that the tracking options should be associated with.</p>
    ///   - [`tracking_options(TrackingOptions)`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions::tracking_options) / [`set_tracking_options(Option<TrackingOptions>)`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions::set_tracking_options): <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// - On success, responds with [`CreateConfigurationSetTrackingOptionsOutput`](crate::output::CreateConfigurationSetTrackingOptionsOutput)

    /// - On failure, responds with [`SdkError<CreateConfigurationSetTrackingOptionsError>`](crate::error::CreateConfigurationSetTrackingOptionsError)
    pub fn create_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::CreateConfigurationSetTrackingOptions {
        fluent_builders::CreateConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomVerificationEmailTemplate`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_subject) / [`set_template_subject(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::template_content) / [`set_template_content(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_template_content): <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    ///   - [`success_redirection_url(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::success_redirection_url) / [`set_success_redirection_url(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(impl Into<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::failure_redirection_url) / [`set_failure_redirection_url(Option<String>)`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate::set_failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On success, responds with [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<CreateCustomVerificationEmailTemplateError>`](crate::error::CreateCustomVerificationEmailTemplateError)
    pub fn create_custom_verification_email_template(
        &self,
    ) -> fluent_builders::CreateCustomVerificationEmailTemplate {
        fluent_builders::CreateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReceiptFilter`](crate::client::fluent_builders::CreateReceiptFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(ReceiptFilter)`](crate::client::fluent_builders::CreateReceiptFilter::filter) / [`set_filter(Option<ReceiptFilter>)`](crate::client::fluent_builders::CreateReceiptFilter::set_filter): <p>A data structure that describes the IP address filter to create, which consists of a name, an IP address range, and whether to allow or block mail from it.</p>
    /// - On success, responds with [`CreateReceiptFilterOutput`](crate::output::CreateReceiptFilterOutput)

    /// - On failure, responds with [`SdkError<CreateReceiptFilterError>`](crate::error::CreateReceiptFilterError)
    pub fn create_receipt_filter(&self) -> fluent_builders::CreateReceiptFilter {
        fluent_builders::CreateReceiptFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReceiptRule`](crate::client::fluent_builders::CreateReceiptRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateReceiptRule::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::CreateReceiptRule::set_rule_set_name): <p>The name of the rule set that the receipt rule will be added to.</p>
    ///   - [`after(impl Into<String>)`](crate::client::fluent_builders::CreateReceiptRule::after) / [`set_after(Option<String>)`](crate::client::fluent_builders::CreateReceiptRule::set_after): <p>The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule will be inserted at the beginning of the rule list.</p>
    ///   - [`rule(ReceiptRule)`](crate::client::fluent_builders::CreateReceiptRule::rule) / [`set_rule(Option<ReceiptRule>)`](crate::client::fluent_builders::CreateReceiptRule::set_rule): <p>A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.</p>
    /// - On success, responds with [`CreateReceiptRuleOutput`](crate::output::CreateReceiptRuleOutput)

    /// - On failure, responds with [`SdkError<CreateReceiptRuleError>`](crate::error::CreateReceiptRuleError)
    pub fn create_receipt_rule(&self) -> fluent_builders::CreateReceiptRule {
        fluent_builders::CreateReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReceiptRuleSet`](crate::client::fluent_builders::CreateReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::CreateReceiptRuleSet::set_rule_set_name): <p>The name of the rule set to create. The name must:</p>  <ul>   <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>   <li> <p>Start and end with a letter or number.</p> </li>   <li> <p>Contain less than 64 characters.</p> </li>  </ul>
    /// - On success, responds with [`CreateReceiptRuleSetOutput`](crate::output::CreateReceiptRuleSetOutput)

    /// - On failure, responds with [`SdkError<CreateReceiptRuleSetError>`](crate::error::CreateReceiptRuleSetError)
    pub fn create_receipt_rule_set(&self) -> fluent_builders::CreateReceiptRuleSet {
        fluent_builders::CreateReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTemplate`](crate::client::fluent_builders::CreateTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template(Template)`](crate::client::fluent_builders::CreateTemplate::template) / [`set_template(Option<Template>)`](crate::client::fluent_builders::CreateTemplate::set_template): <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On success, responds with [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)

    /// - On failure, responds with [`SdkError<CreateTemplateError>`](crate::error::CreateTemplateError)
    pub fn create_template(&self) -> fluent_builders::CreateTemplate {
        fluent_builders::CreateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSet::set_configuration_set_name): <p>The name of the configuration set to delete.</p>
    /// - On success, responds with [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetError>`](crate::error::DeleteConfigurationSetError)
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set from which to delete the event destination.</p>
    ///   - [`event_destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::event_destination_name) / [`set_event_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination::set_event_destination_name): <p>The name of the event destination to delete.</p>
    /// - On success, responds with [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetEventDestinationError>`](crate::error::DeleteConfigurationSetEventDestinationError)
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfigurationSetTrackingOptions`](crate::client::fluent_builders::DeleteConfigurationSetTrackingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteConfigurationSetTrackingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DeleteConfigurationSetTrackingOptions::set_configuration_set_name): <p>The name of the configuration set from which you want to delete the tracking options.</p>
    /// - On success, responds with [`DeleteConfigurationSetTrackingOptionsOutput`](crate::output::DeleteConfigurationSetTrackingOptionsOutput)

    /// - On failure, responds with [`SdkError<DeleteConfigurationSetTrackingOptionsError>`](crate::error::DeleteConfigurationSetTrackingOptionsError)
    pub fn delete_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetTrackingOptions {
        fluent_builders::DeleteConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomVerificationEmailTemplate`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to delete.</p>
    /// - On success, responds with [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomVerificationEmailTemplateError>`](crate::error::DeleteCustomVerificationEmailTemplateError)
    pub fn delete_custom_verification_email_template(
        &self,
    ) -> fluent_builders::DeleteCustomVerificationEmailTemplate {
        fluent_builders::DeleteCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentity`](crate::client::fluent_builders::DeleteIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentity::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::DeleteIdentity::set_identity): <p>The identity to be removed from the list of identities for the AWS Account.</p>
    /// - On success, responds with [`DeleteIdentityOutput`](crate::output::DeleteIdentityOutput)

    /// - On failure, responds with [`SdkError<DeleteIdentityError>`](crate::error::DeleteIdentityError)
    pub fn delete_identity(&self) -> fluent_builders::DeleteIdentity {
        fluent_builders::DeleteIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIdentityPolicy`](crate::client::fluent_builders::DeleteIdentityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityPolicy::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::DeleteIdentityPolicy::set_identity): <p>The identity that is associated with the policy that you want to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>  <p>To successfully call this API, you must own the identity.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DeleteIdentityPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DeleteIdentityPolicy::set_policy_name): <p>The name of the policy to be deleted.</p>
    /// - On success, responds with [`DeleteIdentityPolicyOutput`](crate::output::DeleteIdentityPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteIdentityPolicyError>`](crate::error::DeleteIdentityPolicyError)
    pub fn delete_identity_policy(&self) -> fluent_builders::DeleteIdentityPolicy {
        fluent_builders::DeleteIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReceiptFilter`](crate::client::fluent_builders::DeleteReceiptFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReceiptFilter::filter_name) / [`set_filter_name(Option<String>)`](crate::client::fluent_builders::DeleteReceiptFilter::set_filter_name): <p>The name of the IP address filter to delete.</p>
    /// - On success, responds with [`DeleteReceiptFilterOutput`](crate::output::DeleteReceiptFilterOutput)

    /// - On failure, responds with [`SdkError<DeleteReceiptFilterError>`](crate::error::DeleteReceiptFilterError)
    pub fn delete_receipt_filter(&self) -> fluent_builders::DeleteReceiptFilter {
        fluent_builders::DeleteReceiptFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReceiptRule`](crate::client::fluent_builders::DeleteReceiptRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReceiptRule::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::DeleteReceiptRule::set_rule_set_name): <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReceiptRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DeleteReceiptRule::set_rule_name): <p>The name of the receipt rule to delete.</p>
    /// - On success, responds with [`DeleteReceiptRuleOutput`](crate::output::DeleteReceiptRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteReceiptRuleError>`](crate::error::DeleteReceiptRuleError)
    pub fn delete_receipt_rule(&self) -> fluent_builders::DeleteReceiptRule {
        fluent_builders::DeleteReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReceiptRuleSet`](crate::client::fluent_builders::DeleteReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::DeleteReceiptRuleSet::set_rule_set_name): <p>The name of the receipt rule set to delete.</p>
    /// - On success, responds with [`DeleteReceiptRuleSetOutput`](crate::output::DeleteReceiptRuleSetOutput)

    /// - On failure, responds with [`SdkError<DeleteReceiptRuleSetError>`](crate::error::DeleteReceiptRuleSetError)
    pub fn delete_receipt_rule_set(&self) -> fluent_builders::DeleteReceiptRuleSet {
        fluent_builders::DeleteReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTemplate`](crate::client::fluent_builders::DeleteTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteTemplate::set_template_name): <p>The name of the template to be deleted.</p>
    /// - On success, responds with [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteTemplateError>`](crate::error::DeleteTemplateError)
    pub fn delete_template(&self) -> fluent_builders::DeleteTemplate {
        fluent_builders::DeleteTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVerifiedEmailAddress`](crate::client::fluent_builders::DeleteVerifiedEmailAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::DeleteVerifiedEmailAddress::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::DeleteVerifiedEmailAddress::set_email_address): <p>An email address to be removed from the list of verified addresses.</p>
    /// - On success, responds with [`DeleteVerifiedEmailAddressOutput`](crate::output::DeleteVerifiedEmailAddressOutput)

    /// - On failure, responds with [`SdkError<DeleteVerifiedEmailAddressError>`](crate::error::DeleteVerifiedEmailAddressError)
    pub fn delete_verified_email_address(&self) -> fluent_builders::DeleteVerifiedEmailAddress {
        fluent_builders::DeleteVerifiedEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActiveReceiptRuleSet`](crate::client::fluent_builders::DescribeActiveReceiptRuleSet) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeActiveReceiptRuleSet::send) it.

    /// - On success, responds with [`DescribeActiveReceiptRuleSetOutput`](crate::output::DescribeActiveReceiptRuleSetOutput) with field(s):
    ///   - [`metadata(Option<ReceiptRuleSetMetadata>)`](crate::output::DescribeActiveReceiptRuleSetOutput::metadata): <p>The metadata for the currently active receipt rule set. The metadata consists of the rule set name and a timestamp of when the rule set was created.</p>
    ///   - [`rules(Option<Vec<ReceiptRule>>)`](crate::output::DescribeActiveReceiptRuleSetOutput::rules): <p>The receipt rules that belong to the active rule set.</p>
    /// - On failure, responds with [`SdkError<DescribeActiveReceiptRuleSetError>`](crate::error::DescribeActiveReceiptRuleSetError)
    pub fn describe_active_receipt_rule_set(
        &self,
    ) -> fluent_builders::DescribeActiveReceiptRuleSet {
        fluent_builders::DescribeActiveReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConfigurationSet`](crate::client::fluent_builders::DescribeConfigurationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::DescribeConfigurationSet::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::DescribeConfigurationSet::set_configuration_set_name): <p>The name of the configuration set to describe.</p>
    ///   - [`configuration_set_attribute_names(Vec<ConfigurationSetAttribute>)`](crate::client::fluent_builders::DescribeConfigurationSet::configuration_set_attribute_names) / [`set_configuration_set_attribute_names(Option<Vec<ConfigurationSetAttribute>>)`](crate::client::fluent_builders::DescribeConfigurationSet::set_configuration_set_attribute_names): <p>A list of configuration set attributes to return.</p>
    /// - On success, responds with [`DescribeConfigurationSetOutput`](crate::output::DescribeConfigurationSetOutput) with field(s):
    ///   - [`configuration_set(Option<ConfigurationSet>)`](crate::output::DescribeConfigurationSetOutput::configuration_set): <p>The configuration set object associated with the specified configuration set.</p>
    ///   - [`event_destinations(Option<Vec<EventDestination>>)`](crate::output::DescribeConfigurationSetOutput::event_destinations): <p>A list of event destinations associated with the configuration set. </p>
    ///   - [`tracking_options(Option<TrackingOptions>)`](crate::output::DescribeConfigurationSetOutput::tracking_options): <p>The name of the custom open and click tracking domain associated with the configuration set.</p>
    ///   - [`delivery_options(Option<DeliveryOptions>)`](crate::output::DescribeConfigurationSetOutput::delivery_options): <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).</p>
    ///   - [`reputation_options(Option<ReputationOptions>)`](crate::output::DescribeConfigurationSetOutput::reputation_options): <p>An object that represents the reputation settings for the configuration set. </p>
    /// - On failure, responds with [`SdkError<DescribeConfigurationSetError>`](crate::error::DescribeConfigurationSetError)
    pub fn describe_configuration_set(&self) -> fluent_builders::DescribeConfigurationSet {
        fluent_builders::DescribeConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReceiptRule`](crate::client::fluent_builders::DescribeReceiptRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::DescribeReceiptRule::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::DescribeReceiptRule::set_rule_set_name): <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DescribeReceiptRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DescribeReceiptRule::set_rule_name): <p>The name of the receipt rule.</p>
    /// - On success, responds with [`DescribeReceiptRuleOutput`](crate::output::DescribeReceiptRuleOutput) with field(s):
    ///   - [`rule(Option<ReceiptRule>)`](crate::output::DescribeReceiptRuleOutput::rule): <p>A data structure that contains the specified receipt rule's name, actions, recipients, domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>
    /// - On failure, responds with [`SdkError<DescribeReceiptRuleError>`](crate::error::DescribeReceiptRuleError)
    pub fn describe_receipt_rule(&self) -> fluent_builders::DescribeReceiptRule {
        fluent_builders::DescribeReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReceiptRuleSet`](crate::client::fluent_builders::DescribeReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::DescribeReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::DescribeReceiptRuleSet::set_rule_set_name): <p>The name of the receipt rule set to describe.</p>
    /// - On success, responds with [`DescribeReceiptRuleSetOutput`](crate::output::DescribeReceiptRuleSetOutput) with field(s):
    ///   - [`metadata(Option<ReceiptRuleSetMetadata>)`](crate::output::DescribeReceiptRuleSetOutput::metadata): <p>The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule set was created.</p>
    ///   - [`rules(Option<Vec<ReceiptRule>>)`](crate::output::DescribeReceiptRuleSetOutput::rules): <p>A list of the receipt rules that belong to the specified receipt rule set.</p>
    /// - On failure, responds with [`SdkError<DescribeReceiptRuleSetError>`](crate::error::DescribeReceiptRuleSetError)
    pub fn describe_receipt_rule_set(&self) -> fluent_builders::DescribeReceiptRuleSet {
        fluent_builders::DescribeReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountSendingEnabled`](crate::client::fluent_builders::GetAccountSendingEnabled) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccountSendingEnabled::send) it.

    /// - On success, responds with [`GetAccountSendingEnabledOutput`](crate::output::GetAccountSendingEnabledOutput) with field(s):
    ///   - [`enabled(bool)`](crate::output::GetAccountSendingEnabledOutput::enabled): <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.</p>
    /// - On failure, responds with [`SdkError<GetAccountSendingEnabledError>`](crate::error::GetAccountSendingEnabledError)
    pub fn get_account_sending_enabled(&self) -> fluent_builders::GetAccountSendingEnabled {
        fluent_builders::GetAccountSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCustomVerificationEmailTemplate`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to retrieve.</p>
    /// - On success, responds with [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput) with field(s):
    ///   - [`template_name(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_name): <p>The name of the custom verification email template.</p>
    ///   - [`from_email_address(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::template_content): <p>The content of the custom verification email.</p>
    ///   - [`success_redirection_url(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(Option<String>)`](crate::output::GetCustomVerificationEmailTemplateOutput::failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On failure, responds with [`SdkError<GetCustomVerificationEmailTemplateError>`](crate::error::GetCustomVerificationEmailTemplateError)
    pub fn get_custom_verification_email_template(
        &self,
    ) -> fluent_builders::GetCustomVerificationEmailTemplate {
        fluent_builders::GetCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityDkimAttributes`](crate::client::fluent_builders::GetIdentityDkimAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identities(Vec<String>)`](crate::client::fluent_builders::GetIdentityDkimAttributes::identities) / [`set_identities(Option<Vec<String>>)`](crate::client::fluent_builders::GetIdentityDkimAttributes::set_identities): <p>A list of one or more verified identities - email addresses, domains, or both.</p>
    /// - On success, responds with [`GetIdentityDkimAttributesOutput`](crate::output::GetIdentityDkimAttributesOutput) with field(s):
    ///   - [`dkim_attributes(Option<HashMap<String, IdentityDkimAttributes>>)`](crate::output::GetIdentityDkimAttributesOutput::dkim_attributes): <p>The DKIM attributes for an email address or a domain.</p>
    /// - On failure, responds with [`SdkError<GetIdentityDkimAttributesError>`](crate::error::GetIdentityDkimAttributesError)
    pub fn get_identity_dkim_attributes(&self) -> fluent_builders::GetIdentityDkimAttributes {
        fluent_builders::GetIdentityDkimAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityMailFromDomainAttributes`](crate::client::fluent_builders::GetIdentityMailFromDomainAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identities(Vec<String>)`](crate::client::fluent_builders::GetIdentityMailFromDomainAttributes::identities) / [`set_identities(Option<Vec<String>>)`](crate::client::fluent_builders::GetIdentityMailFromDomainAttributes::set_identities): <p>A list of one or more identities.</p>
    /// - On success, responds with [`GetIdentityMailFromDomainAttributesOutput`](crate::output::GetIdentityMailFromDomainAttributesOutput) with field(s):
    ///   - [`mail_from_domain_attributes(Option<HashMap<String, IdentityMailFromDomainAttributes>>)`](crate::output::GetIdentityMailFromDomainAttributesOutput::mail_from_domain_attributes): <p>A map of identities to custom MAIL FROM attributes.</p>
    /// - On failure, responds with [`SdkError<GetIdentityMailFromDomainAttributesError>`](crate::error::GetIdentityMailFromDomainAttributesError)
    pub fn get_identity_mail_from_domain_attributes(
        &self,
    ) -> fluent_builders::GetIdentityMailFromDomainAttributes {
        fluent_builders::GetIdentityMailFromDomainAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityNotificationAttributes`](crate::client::fluent_builders::GetIdentityNotificationAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identities(Vec<String>)`](crate::client::fluent_builders::GetIdentityNotificationAttributes::identities) / [`set_identities(Option<Vec<String>>)`](crate::client::fluent_builders::GetIdentityNotificationAttributes::set_identities): <p>A list of one or more identities. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// - On success, responds with [`GetIdentityNotificationAttributesOutput`](crate::output::GetIdentityNotificationAttributesOutput) with field(s):
    ///   - [`notification_attributes(Option<HashMap<String, IdentityNotificationAttributes>>)`](crate::output::GetIdentityNotificationAttributesOutput::notification_attributes): <p>A map of Identity to IdentityNotificationAttributes.</p>
    /// - On failure, responds with [`SdkError<GetIdentityNotificationAttributesError>`](crate::error::GetIdentityNotificationAttributesError)
    pub fn get_identity_notification_attributes(
        &self,
    ) -> fluent_builders::GetIdentityNotificationAttributes {
        fluent_builders::GetIdentityNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityPolicies`](crate::client::fluent_builders::GetIdentityPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::GetIdentityPolicies::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::GetIdentityPolicies::set_identity): <p>The identity for which the policies will be retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>  <p>To successfully call this API, you must own the identity.</p>
    ///   - [`policy_names(Vec<String>)`](crate::client::fluent_builders::GetIdentityPolicies::policy_names) / [`set_policy_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetIdentityPolicies::set_policy_names): <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use <code>ListIdentityPolicies</code>.</p>
    /// - On success, responds with [`GetIdentityPoliciesOutput`](crate::output::GetIdentityPoliciesOutput) with field(s):
    ///   - [`policies(Option<HashMap<String, String>>)`](crate::output::GetIdentityPoliciesOutput::policies): <p>A map of policy names to policies.</p>
    /// - On failure, responds with [`SdkError<GetIdentityPoliciesError>`](crate::error::GetIdentityPoliciesError)
    pub fn get_identity_policies(&self) -> fluent_builders::GetIdentityPolicies {
        fluent_builders::GetIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityVerificationAttributes`](crate::client::fluent_builders::GetIdentityVerificationAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identities(Vec<String>)`](crate::client::fluent_builders::GetIdentityVerificationAttributes::identities) / [`set_identities(Option<Vec<String>>)`](crate::client::fluent_builders::GetIdentityVerificationAttributes::set_identities): <p>A list of identities.</p>
    /// - On success, responds with [`GetIdentityVerificationAttributesOutput`](crate::output::GetIdentityVerificationAttributesOutput) with field(s):
    ///   - [`verification_attributes(Option<HashMap<String, IdentityVerificationAttributes>>)`](crate::output::GetIdentityVerificationAttributesOutput::verification_attributes): <p>A map of Identities to IdentityVerificationAttributes objects.</p>
    /// - On failure, responds with [`SdkError<GetIdentityVerificationAttributesError>`](crate::error::GetIdentityVerificationAttributesError)
    pub fn get_identity_verification_attributes(
        &self,
    ) -> fluent_builders::GetIdentityVerificationAttributes {
        fluent_builders::GetIdentityVerificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSendQuota`](crate::client::fluent_builders::GetSendQuota) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetSendQuota::send) it.

    /// - On success, responds with [`GetSendQuotaOutput`](crate::output::GetSendQuotaOutput) with field(s):
    ///   - [`max24_hour_send(f64)`](crate::output::GetSendQuotaOutput::max24_hour_send): <p>The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an unlimited quota.</p>
    ///   - [`max_send_rate(f64)`](crate::output::GetSendQuotaOutput::max_send_rate): <p>The maximum number of emails that Amazon SES can accept from the user's account per second.</p> <note>   <p>The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.</p>  </note>
    ///   - [`sent_last24_hours(f64)`](crate::output::GetSendQuotaOutput::sent_last24_hours): <p>The number of emails sent during the previous 24 hours.</p>
    /// - On failure, responds with [`SdkError<GetSendQuotaError>`](crate::error::GetSendQuotaError)
    pub fn get_send_quota(&self) -> fluent_builders::GetSendQuota {
        fluent_builders::GetSendQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSendStatistics`](crate::client::fluent_builders::GetSendStatistics) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetSendStatistics::send) it.

    /// - On success, responds with [`GetSendStatisticsOutput`](crate::output::GetSendStatisticsOutput) with field(s):
    ///   - [`send_data_points(Option<Vec<SendDataPoint>>)`](crate::output::GetSendStatisticsOutput::send_data_points): <p>A list of data points, each of which represents 15 minutes of activity.</p>
    /// - On failure, responds with [`SdkError<GetSendStatisticsError>`](crate::error::GetSendStatisticsError)
    pub fn get_send_statistics(&self) -> fluent_builders::GetSendStatistics {
        fluent_builders::GetSendStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTemplate`](crate::client::fluent_builders::GetTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::GetTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::GetTemplate::set_template_name): <p>The name of the template you want to retrieve.</p>
    /// - On success, responds with [`GetTemplateOutput`](crate::output::GetTemplateOutput) with field(s):
    ///   - [`template(Option<Template>)`](crate::output::GetTemplateOutput::template): <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On failure, responds with [`SdkError<GetTemplateError>`](crate::error::GetTemplateError)
    pub fn get_template(&self) -> fluent_builders::GetTemplate {
        fluent_builders::GetTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigurationSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigurationSets::set_next_token): <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the configuration set in the configuration set list.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListConfigurationSets::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListConfigurationSets::set_max_items): <p>The number of configuration sets to return.</p>
    /// - On success, responds with [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput) with field(s):
    ///   - [`configuration_sets(Option<Vec<ConfigurationSet>>)`](crate::output::ListConfigurationSetsOutput::configuration_sets): <p>A list of configuration sets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigurationSetsOutput::next_token): <p>A token indicating that there are additional configuration sets available to be listed. Pass this token to successive calls of <code>ListConfigurationSets</code>. </p>
    /// - On failure, responds with [`SdkError<ListConfigurationSetsError>`](crate::error::ListConfigurationSetsError)
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomVerificationEmailTemplates`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::set_next_token): <p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates::set_max_results): <p>The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation will return up to 50 results.</p>
    /// - On success, responds with [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput) with field(s):
    ///   - [`custom_verification_email_templates(Option<Vec<CustomVerificationEmailTemplate>>)`](crate::output::ListCustomVerificationEmailTemplatesOutput::custom_verification_email_templates): <p>A list of the custom verification email templates that exist in your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomVerificationEmailTemplatesOutput::next_token): <p>A token indicating that there are additional custom verification email templates available to be listed. Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 custom verification email templates.</p>
    /// - On failure, responds with [`SdkError<ListCustomVerificationEmailTemplatesError>`](crate::error::ListCustomVerificationEmailTemplatesError)
    pub fn list_custom_verification_email_templates(
        &self,
    ) -> fluent_builders::ListCustomVerificationEmailTemplates {
        fluent_builders::ListCustomVerificationEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentities`](crate::client::fluent_builders::ListIdentities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIdentities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_type(IdentityType)`](crate::client::fluent_builders::ListIdentities::identity_type) / [`set_identity_type(Option<IdentityType>)`](crate::client::fluent_builders::ListIdentities::set_identity_type): <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities will be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentities::set_next_token): <p>The token to use for pagination.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListIdentities::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListIdentities::set_max_items): <p>The maximum number of identities per page. Possible values are 1-1000 inclusive.</p>
    /// - On success, responds with [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput) with field(s):
    ///   - [`identities(Option<Vec<String>>)`](crate::output::ListIdentitiesOutput::identities): <p>A list of identities.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentitiesOutput::next_token): <p>The token used for pagination.</p>
    /// - On failure, responds with [`SdkError<ListIdentitiesError>`](crate::error::ListIdentitiesError)
    pub fn list_identities(&self) -> fluent_builders::ListIdentities {
        fluent_builders::ListIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityPolicies`](crate::client::fluent_builders::ListIdentityPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::ListIdentityPolicies::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::ListIdentityPolicies::set_identity): <p>The identity that is associated with the policy for which the policies will be listed. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>  <p>To successfully call this API, you must own the identity.</p>
    /// - On success, responds with [`ListIdentityPoliciesOutput`](crate::output::ListIdentityPoliciesOutput) with field(s):
    ///   - [`policy_names(Option<Vec<String>>)`](crate::output::ListIdentityPoliciesOutput::policy_names): <p>A list of names of policies that apply to the specified identity.</p>
    /// - On failure, responds with [`SdkError<ListIdentityPoliciesError>`](crate::error::ListIdentityPoliciesError)
    pub fn list_identity_policies(&self) -> fluent_builders::ListIdentityPolicies {
        fluent_builders::ListIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReceiptFilters`](crate::client::fluent_builders::ListReceiptFilters) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListReceiptFilters::send) it.

    /// - On success, responds with [`ListReceiptFiltersOutput`](crate::output::ListReceiptFiltersOutput) with field(s):
    ///   - [`filters(Option<Vec<ReceiptFilter>>)`](crate::output::ListReceiptFiltersOutput::filters): <p>A list of IP address filter data structures, which each consist of a name, an IP address range, and whether to allow or block mail from it.</p>
    /// - On failure, responds with [`SdkError<ListReceiptFiltersError>`](crate::error::ListReceiptFiltersError)
    pub fn list_receipt_filters(&self) -> fluent_builders::ListReceiptFilters {
        fluent_builders::ListReceiptFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReceiptRuleSets`](crate::client::fluent_builders::ListReceiptRuleSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReceiptRuleSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReceiptRuleSets::set_next_token): <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the receipt rule set list.</p>
    /// - On success, responds with [`ListReceiptRuleSetsOutput`](crate::output::ListReceiptRuleSetsOutput) with field(s):
    ///   - [`rule_sets(Option<Vec<ReceiptRuleSetMetadata>>)`](crate::output::ListReceiptRuleSetsOutput::rule_sets): <p>The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the timestamp of when the rule set was created.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReceiptRuleSetsOutput::next_token): <p>A token indicating that there are additional receipt rule sets available to be listed. Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.</p>
    /// - On failure, responds with [`SdkError<ListReceiptRuleSetsError>`](crate::error::ListReceiptRuleSetsError)
    pub fn list_receipt_rule_sets(&self) -> fluent_builders::ListReceiptRuleSets {
        fluent_builders::ListReceiptRuleSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTemplates`](crate::client::fluent_builders::ListTemplates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTemplates::set_next_token): <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the position in the list of email templates.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTemplates::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTemplates::set_max_items): <p>The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return up to 10 results.</p>
    /// - On success, responds with [`ListTemplatesOutput`](crate::output::ListTemplatesOutput) with field(s):
    ///   - [`templates_metadata(Option<Vec<TemplateMetadata>>)`](crate::output::ListTemplatesOutput::templates_metadata): <p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTemplatesOutput::next_token): <p>A token indicating that there are additional email templates available to be listed. Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 email templates.</p>
    /// - On failure, responds with [`SdkError<ListTemplatesError>`](crate::error::ListTemplatesError)
    pub fn list_templates(&self) -> fluent_builders::ListTemplates {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVerifiedEmailAddresses`](crate::client::fluent_builders::ListVerifiedEmailAddresses) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListVerifiedEmailAddresses::send) it.

    /// - On success, responds with [`ListVerifiedEmailAddressesOutput`](crate::output::ListVerifiedEmailAddressesOutput) with field(s):
    ///   - [`verified_email_addresses(Option<Vec<String>>)`](crate::output::ListVerifiedEmailAddressesOutput::verified_email_addresses): <p>A list of email addresses that have been verified.</p>
    /// - On failure, responds with [`SdkError<ListVerifiedEmailAddressesError>`](crate::error::ListVerifiedEmailAddressesError)
    pub fn list_verified_email_addresses(&self) -> fluent_builders::ListVerifiedEmailAddresses {
        fluent_builders::ListVerifiedEmailAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutConfigurationSetDeliveryOptions`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_configuration_set_name): <p>The name of the configuration set that you want to specify the delivery options for.</p>
    ///   - [`delivery_options(DeliveryOptions)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::delivery_options) / [`set_delivery_options(Option<DeliveryOptions>)`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions::set_delivery_options): <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).</p>
    /// - On success, responds with [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)

    /// - On failure, responds with [`SdkError<PutConfigurationSetDeliveryOptionsError>`](crate::error::PutConfigurationSetDeliveryOptionsError)
    pub fn put_configuration_set_delivery_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetDeliveryOptions {
        fluent_builders::PutConfigurationSetDeliveryOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutIdentityPolicy`](crate::client::fluent_builders::PutIdentityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::PutIdentityPolicy::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::PutIdentityPolicy::set_identity): <p>The identity that the policy will apply to. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>  <p>To successfully call this API, you must own the identity.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::PutIdentityPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::PutIdentityPolicy::set_policy_name): <p>The name of the policy.</p>  <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutIdentityPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutIdentityPolicy::set_policy): <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>  <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>. </p>
    /// - On success, responds with [`PutIdentityPolicyOutput`](crate::output::PutIdentityPolicyOutput)

    /// - On failure, responds with [`SdkError<PutIdentityPolicyError>`](crate::error::PutIdentityPolicyError)
    pub fn put_identity_policy(&self) -> fluent_builders::PutIdentityPolicy {
        fluent_builders::PutIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReorderReceiptRuleSet`](crate::client::fluent_builders::ReorderReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::ReorderReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::ReorderReceiptRuleSet::set_rule_set_name): <p>The name of the receipt rule set to reorder.</p>
    ///   - [`rule_names(Vec<String>)`](crate::client::fluent_builders::ReorderReceiptRuleSet::rule_names) / [`set_rule_names(Option<Vec<String>>)`](crate::client::fluent_builders::ReorderReceiptRuleSet::set_rule_names): <p>A list of the specified receipt rule set's receipt rules in the order that you want to put them.</p>
    /// - On success, responds with [`ReorderReceiptRuleSetOutput`](crate::output::ReorderReceiptRuleSetOutput)

    /// - On failure, responds with [`SdkError<ReorderReceiptRuleSetError>`](crate::error::ReorderReceiptRuleSetError)
    pub fn reorder_receipt_rule_set(&self) -> fluent_builders::ReorderReceiptRuleSet {
        fluent_builders::ReorderReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendBounce`](crate::client::fluent_builders::SendBounce) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`original_message_id(impl Into<String>)`](crate::client::fluent_builders::SendBounce::original_message_id) / [`set_original_message_id(Option<String>)`](crate::client::fluent_builders::SendBounce::set_original_message_id): <p>The message ID of the message to be bounced.</p>
    ///   - [`bounce_sender(impl Into<String>)`](crate::client::fluent_builders::SendBounce::bounce_sender) / [`set_bounce_sender(Option<String>)`](crate::client::fluent_builders::SendBounce::set_bounce_sender): <p>The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.</p>
    ///   - [`explanation(impl Into<String>)`](crate::client::fluent_builders::SendBounce::explanation) / [`set_explanation(Option<String>)`](crate::client::fluent_builders::SendBounce::set_explanation): <p>Human-readable text for the bounce message to explain the failure. If not specified, the text will be auto-generated based on the bounced recipient information.</p>
    ///   - [`message_dsn(MessageDsn)`](crate::client::fluent_builders::SendBounce::message_dsn) / [`set_message_dsn(Option<MessageDsn>)`](crate::client::fluent_builders::SendBounce::set_message_dsn): <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
    ///   - [`bounced_recipient_info_list(Vec<BouncedRecipientInfo>)`](crate::client::fluent_builders::SendBounce::bounced_recipient_info_list) / [`set_bounced_recipient_info_list(Option<Vec<BouncedRecipientInfo>>)`](crate::client::fluent_builders::SendBounce::set_bounced_recipient_info_list): <p>A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one <code>BouncedRecipientInfo</code> in the list.</p>
    ///   - [`bounce_sender_arn(impl Into<String>)`](crate::client::fluent_builders::SendBounce::bounce_sender_arn) / [`set_bounce_sender_arn(Option<String>)`](crate::client::fluent_builders::SendBounce::set_bounce_sender_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// - On success, responds with [`SendBounceOutput`](crate::output::SendBounceOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendBounceOutput::message_id): <p>The message ID of the bounce message.</p>
    /// - On failure, responds with [`SdkError<SendBounceError>`](crate::error::SendBounceError)
    pub fn send_bounce(&self) -> fluent_builders::SendBounce {
        fluent_builders::SendBounce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendBulkTemplatedEmail`](crate::client::fluent_builders::SendBulkTemplatedEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_source): <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>  <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>   <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>  </note>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_source_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_reply_to_addresses): <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
    ///   - [`return_path(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::return_path) / [`set_return_path(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_return_path): <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
    ///   - [`return_path_arn(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::return_path_arn) / [`set_return_path_arn(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_return_path_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_configuration_set_name): <p>The name of the configuration set to use when you send an email using <code>SendBulkTemplatedEmail</code>.</p>
    ///   - [`default_tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::default_tags) / [`set_default_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_default_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to a destination using <code>SendBulkTemplatedEmail</code>.</p>
    ///   - [`template(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::template) / [`set_template(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_template): <p>The template to use when sending this email.</p>
    ///   - [`template_arn(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::template_arn) / [`set_template_arn(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_template_arn): <p>The ARN of the template to use when sending this email.</p>
    ///   - [`default_template_data(impl Into<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::default_template_data) / [`set_default_template_data(Option<String>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_default_template_data): <p>A list of replacement values to apply to the template when replacement data is not specified in a Destination object. These values act as a default or fallback option when no other data is available.</p>  <p>The template data is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    ///   - [`destinations(Vec<BulkEmailDestination>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::destinations) / [`set_destinations(Option<Vec<BulkEmailDestination>>)`](crate::client::fluent_builders::SendBulkTemplatedEmail::set_destinations): <p>One or more <code>Destination</code> objects. All of the recipients in a <code>Destination</code> will receive the same version of the email. You can specify up to 50 <code>Destination</code> objects within a <code>Destinations</code> array.</p>
    /// - On success, responds with [`SendBulkTemplatedEmailOutput`](crate::output::SendBulkTemplatedEmailOutput) with field(s):
    ///   - [`status(Option<Vec<BulkEmailDestinationStatus>>)`](crate::output::SendBulkTemplatedEmailOutput::status): <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.</p>
    /// - On failure, responds with [`SdkError<SendBulkTemplatedEmailError>`](crate::error::SendBulkTemplatedEmailError)
    pub fn send_bulk_templated_email(&self) -> fluent_builders::SendBulkTemplatedEmail {
        fluent_builders::SendBulkTemplatedEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendCustomVerificationEmail`](crate::client::fluent_builders::SendCustomVerificationEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_email_address): <p>The email address to verify.</p>
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_template_name): <p>The name of the custom verification email template to use when sending the verification email.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendCustomVerificationEmail::set_configuration_set_name): <p>Name of a configuration set to use when sending the verification email.</p>
    /// - On success, responds with [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendCustomVerificationEmailOutput::message_id): <p>The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.</p>
    /// - On failure, responds with [`SdkError<SendCustomVerificationEmailError>`](crate::error::SendCustomVerificationEmailError)
    pub fn send_custom_verification_email(&self) -> fluent_builders::SendCustomVerificationEmail {
        fluent_builders::SendCustomVerificationEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendEmail`](crate::client::fluent_builders::SendEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::SendEmail::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::SendEmail::set_source): <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>  <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>   <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>  </note>
    ///   - [`destination(Destination)`](crate::client::fluent_builders::SendEmail::destination) / [`set_destination(Option<Destination>)`](crate::client::fluent_builders::SendEmail::set_destination): <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
    ///   - [`message(Message)`](crate::client::fluent_builders::SendEmail::message) / [`set_message(Option<Message>)`](crate::client::fluent_builders::SendEmail::set_message): <p>The message to be sent.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendEmail::set_reply_to_addresses): <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
    ///   - [`return_path(impl Into<String>)`](crate::client::fluent_builders::SendEmail::return_path) / [`set_return_path(Option<String>)`](crate::client::fluent_builders::SendEmail::set_return_path): <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::SendEmail::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::SendEmail::set_source_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`return_path_arn(impl Into<String>)`](crate::client::fluent_builders::SendEmail::return_path_arn) / [`set_return_path_arn(Option<String>)`](crate::client::fluent_builders::SendEmail::set_return_path_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendEmail::tags) / [`set_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendEmail::set_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendEmail::set_configuration_set_name): <p>The name of the configuration set to use when you send an email using <code>SendEmail</code>.</p>
    /// - On success, responds with [`SendEmailOutput`](crate::output::SendEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendEmailOutput::message_id): <p>The unique message identifier returned from the <code>SendEmail</code> action. </p>
    /// - On failure, responds with [`SdkError<SendEmailError>`](crate::error::SendEmailError)
    pub fn send_email(&self) -> fluent_builders::SendEmail {
        fluent_builders::SendEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendRawEmail`](crate::client::fluent_builders::SendRawEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::SendRawEmail::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::SendRawEmail::set_source): <p>The identity's email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)</p> <note>   <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>  </note>  <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled, then bounces and complaints will be sent to this email address. This takes precedence over any Return-Path header that you might include in the raw text of the message.</p>
    ///   - [`destinations(Vec<String>)`](crate::client::fluent_builders::SendRawEmail::destinations) / [`set_destinations(Option<Vec<String>>)`](crate::client::fluent_builders::SendRawEmail::set_destinations): <p>A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.</p>
    ///   - [`raw_message(RawMessage)`](crate::client::fluent_builders::SendRawEmail::raw_message) / [`set_raw_message(Option<RawMessage>)`](crate::client::fluent_builders::SendRawEmail::set_raw_message): <p>The raw email message itself. The message has to meet the following criteria:</p>  <ul>   <li> <p>The message has to contain a header and a body, separated by a blank line.</p> </li>   <li> <p>All of the required header fields must be present in the message.</p> </li>   <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li>   <li> <p>Attachments must be of a content type that Amazon SES supports. For a list on unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment Types</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>   <li> <p>The entire message must be base64-encoded.</p> </li>   <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, we highly recommend that you encode that content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>   <li> <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of text, including the <crlf>     , must not exceed 1,000 characters.    </crlf></p> </li>  </ul>
    ///   - [`from_arn(impl Into<String>)`](crate::client::fluent_builders::SendRawEmail::from_arn) / [`set_from_arn(Option<String>)`](crate::client::fluent_builders::SendRawEmail::set_from_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.</p>  <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code> in the raw message of the email. If you use both the <code>FromArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code> parameter.</p> <note>   <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>  </note>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::SendRawEmail::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::SendRawEmail::set_source_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>  <p>Instead of using this parameter, you can use the X-header <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>SourceArn</code> parameter.</p> <note>   <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>  </note>
    ///   - [`return_path_arn(impl Into<String>)`](crate::client::fluent_builders::SendRawEmail::return_path_arn) / [`set_return_path_arn(Option<String>)`](crate::client::fluent_builders::SendRawEmail::set_return_path_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>  <p>Instead of using this parameter, you can use the X-header <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>ReturnPathArn</code> parameter.</p> <note>   <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>  </note>
    ///   - [`tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendRawEmail::tags) / [`set_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendRawEmail::set_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendRawEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendRawEmail::set_configuration_set_name): <p>The name of the configuration set to use when you send an email using <code>SendRawEmail</code>.</p>
    /// - On success, responds with [`SendRawEmailOutput`](crate::output::SendRawEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendRawEmailOutput::message_id): <p>The unique message identifier returned from the <code>SendRawEmail</code> action. </p>
    /// - On failure, responds with [`SdkError<SendRawEmailError>`](crate::error::SendRawEmailError)
    pub fn send_raw_email(&self) -> fluent_builders::SendRawEmail {
        fluent_builders::SendRawEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendTemplatedEmail`](crate::client::fluent_builders::SendTemplatedEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_source): <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>  <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>   <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>  </note>
    ///   - [`destination(Destination)`](crate::client::fluent_builders::SendTemplatedEmail::destination) / [`set_destination(Option<Destination>)`](crate::client::fluent_builders::SendTemplatedEmail::set_destination): <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination can include up to 50 recipients across these three fields.</p>
    ///   - [`reply_to_addresses(Vec<String>)`](crate::client::fluent_builders::SendTemplatedEmail::reply_to_addresses) / [`set_reply_to_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::SendTemplatedEmail::set_reply_to_addresses): <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
    ///   - [`return_path(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::return_path) / [`set_return_path(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_return_path): <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_source_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`return_path_arn(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::return_path_arn) / [`set_return_path_arn(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_return_path_arn): <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>  <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>  <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    ///   - [`tags(Vec<MessageTag>)`](crate::client::fluent_builders::SendTemplatedEmail::tags) / [`set_tags(Option<Vec<MessageTag>>)`](crate::client::fluent_builders::SendTemplatedEmail::set_tags): <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_configuration_set_name): <p>The name of the configuration set to use when you send an email using <code>SendTemplatedEmail</code>.</p>
    ///   - [`template(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::template) / [`set_template(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_template): <p>The template to use when sending this email.</p>
    ///   - [`template_arn(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::template_arn) / [`set_template_arn(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_template_arn): <p>The ARN of the template to use when sending this email.</p>
    ///   - [`template_data(impl Into<String>)`](crate::client::fluent_builders::SendTemplatedEmail::template_data) / [`set_template_data(Option<String>)`](crate::client::fluent_builders::SendTemplatedEmail::set_template_data): <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    /// - On success, responds with [`SendTemplatedEmailOutput`](crate::output::SendTemplatedEmailOutput) with field(s):
    ///   - [`message_id(Option<String>)`](crate::output::SendTemplatedEmailOutput::message_id): <p>The unique message identifier returned from the <code>SendTemplatedEmail</code> action. </p>
    /// - On failure, responds with [`SdkError<SendTemplatedEmailError>`](crate::error::SendTemplatedEmailError)
    pub fn send_templated_email(&self) -> fluent_builders::SendTemplatedEmail {
        fluent_builders::SendTemplatedEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetActiveReceiptRuleSet`](crate::client::fluent_builders::SetActiveReceiptRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::SetActiveReceiptRuleSet::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::SetActiveReceiptRuleSet::set_rule_set_name): <p>The name of the receipt rule set to make active. Setting this value to null disables all email receiving.</p>
    /// - On success, responds with [`SetActiveReceiptRuleSetOutput`](crate::output::SetActiveReceiptRuleSetOutput)

    /// - On failure, responds with [`SdkError<SetActiveReceiptRuleSetError>`](crate::error::SetActiveReceiptRuleSetError)
    pub fn set_active_receipt_rule_set(&self) -> fluent_builders::SetActiveReceiptRuleSet {
        fluent_builders::SetActiveReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityDkimEnabled`](crate::client::fluent_builders::SetIdentityDkimEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::SetIdentityDkimEnabled::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::SetIdentityDkimEnabled::set_identity): <p>The identity for which DKIM signing should be enabled or disabled.</p>
    ///   - [`dkim_enabled(bool)`](crate::client::fluent_builders::SetIdentityDkimEnabled::dkim_enabled) / [`set_dkim_enabled(bool)`](crate::client::fluent_builders::SetIdentityDkimEnabled::set_dkim_enabled): <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this identity; <code>false</code> to disable it. </p>
    /// - On success, responds with [`SetIdentityDkimEnabledOutput`](crate::output::SetIdentityDkimEnabledOutput)

    /// - On failure, responds with [`SdkError<SetIdentityDkimEnabledError>`](crate::error::SetIdentityDkimEnabledError)
    pub fn set_identity_dkim_enabled(&self) -> fluent_builders::SetIdentityDkimEnabled {
        fluent_builders::SetIdentityDkimEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityFeedbackForwardingEnabled`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled::set_identity): <p>The identity for which to set bounce and complaint notification forwarding. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
    ///   - [`forwarding_enabled(bool)`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled::forwarding_enabled) / [`set_forwarding_enabled(bool)`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled::set_forwarding_enabled): <p>Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.</p>
    /// - On success, responds with [`SetIdentityFeedbackForwardingEnabledOutput`](crate::output::SetIdentityFeedbackForwardingEnabledOutput)

    /// - On failure, responds with [`SdkError<SetIdentityFeedbackForwardingEnabledError>`](crate::error::SetIdentityFeedbackForwardingEnabledError)
    pub fn set_identity_feedback_forwarding_enabled(
        &self,
    ) -> fluent_builders::SetIdentityFeedbackForwardingEnabled {
        fluent_builders::SetIdentityFeedbackForwardingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityHeadersInNotificationsEnabled`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::set_identity): <p>The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
    ///   - [`notification_type(NotificationType)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::notification_type) / [`set_notification_type(Option<NotificationType>)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::set_notification_type): <p>The notification type for which to enable or disable headers in notifications. </p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled::set_enabled): <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of <code>true</code> specifies that Amazon SES will include headers in notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in notifications.</p>  <p>This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS topic.</p>
    /// - On success, responds with [`SetIdentityHeadersInNotificationsEnabledOutput`](crate::output::SetIdentityHeadersInNotificationsEnabledOutput)

    /// - On failure, responds with [`SdkError<SetIdentityHeadersInNotificationsEnabledError>`](crate::error::SetIdentityHeadersInNotificationsEnabledError)
    pub fn set_identity_headers_in_notifications_enabled(
        &self,
    ) -> fluent_builders::SetIdentityHeadersInNotificationsEnabled {
        fluent_builders::SetIdentityHeadersInNotificationsEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityMailFromDomain`](crate::client::fluent_builders::SetIdentityMailFromDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::SetIdentityMailFromDomain::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::SetIdentityMailFromDomain::set_identity): <p>The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.</p>
    ///   - [`mail_from_domain(impl Into<String>)`](crate::client::fluent_builders::SetIdentityMailFromDomain::mail_from_domain) / [`set_mail_from_domain(Option<String>)`](crate::client::fluent_builders::SetIdentityMailFromDomain::set_mail_from_domain): <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for the identity.</p>
    ///   - [`behavior_on_mx_failure(BehaviorOnMxFailure)`](crate::client::fluent_builders::SetIdentityMailFromDomain::behavior_on_mx_failure) / [`set_behavior_on_mx_failure(Option<BehaviorOnMxFailure>)`](crate::client::fluent_builders::SetIdentityMailFromDomain::set_behavior_on_mx_failure): <p>The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>  <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
    /// - On success, responds with [`SetIdentityMailFromDomainOutput`](crate::output::SetIdentityMailFromDomainOutput)

    /// - On failure, responds with [`SdkError<SetIdentityMailFromDomainError>`](crate::error::SetIdentityMailFromDomainError)
    pub fn set_identity_mail_from_domain(&self) -> fluent_builders::SetIdentityMailFromDomain {
        fluent_builders::SetIdentityMailFromDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetIdentityNotificationTopic`](crate::client::fluent_builders::SetIdentityNotificationTopic) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity(impl Into<String>)`](crate::client::fluent_builders::SetIdentityNotificationTopic::identity) / [`set_identity(Option<String>)`](crate::client::fluent_builders::SetIdentityNotificationTopic::set_identity): <p>The identity (email address or domain) that you want to set the Amazon SNS topic for.</p> <important>   <p>You can only specify a verified identity for this parameter.</p>  </important>  <p>You can specify an identity by using its name or by using its Amazon Resource Name (ARN). The following examples are all valid identities: <code>sender@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    ///   - [`notification_type(NotificationType)`](crate::client::fluent_builders::SetIdentityNotificationTopic::notification_type) / [`set_notification_type(Option<NotificationType>)`](crate::client::fluent_builders::SetIdentityNotificationTopic::set_notification_type): <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
    ///   - [`sns_topic(impl Into<String>)`](crate::client::fluent_builders::SetIdentityNotificationTopic::sns_topic) / [`set_sns_topic(Option<String>)`](crate::client::fluent_builders::SetIdentityNotificationTopic::set_sns_topic): <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing is disabled.</p>
    /// - On success, responds with [`SetIdentityNotificationTopicOutput`](crate::output::SetIdentityNotificationTopicOutput)

    /// - On failure, responds with [`SdkError<SetIdentityNotificationTopicError>`](crate::error::SetIdentityNotificationTopicError)
    pub fn set_identity_notification_topic(&self) -> fluent_builders::SetIdentityNotificationTopic {
        fluent_builders::SetIdentityNotificationTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetReceiptRulePosition`](crate::client::fluent_builders::SetReceiptRulePosition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::set_rule_set_name): <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::set_rule_name): <p>The name of the receipt rule to reposition.</p>
    ///   - [`after(impl Into<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::after) / [`set_after(Option<String>)`](crate::client::fluent_builders::SetReceiptRulePosition::set_after): <p>The name of the receipt rule after which to place the specified receipt rule.</p>
    /// - On success, responds with [`SetReceiptRulePositionOutput`](crate::output::SetReceiptRulePositionOutput)

    /// - On failure, responds with [`SdkError<SetReceiptRulePositionError>`](crate::error::SetReceiptRulePositionError)
    pub fn set_receipt_rule_position(&self) -> fluent_builders::SetReceiptRulePosition {
        fluent_builders::SetReceiptRulePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestRenderTemplate`](crate::client::fluent_builders::TestRenderTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::TestRenderTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::TestRenderTemplate::set_template_name): <p>The name of the template that you want to render.</p>
    ///   - [`template_data(impl Into<String>)`](crate::client::fluent_builders::TestRenderTemplate::template_data) / [`set_template_data(Option<String>)`](crate::client::fluent_builders::TestRenderTemplate::set_template_data): <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
    /// - On success, responds with [`TestRenderTemplateOutput`](crate::output::TestRenderTemplateOutput) with field(s):
    ///   - [`rendered_template(Option<String>)`](crate::output::TestRenderTemplateOutput::rendered_template): <p>The complete MIME message rendered by applying the data in the TemplateData parameter to the template specified in the TemplateName parameter.</p>
    /// - On failure, responds with [`SdkError<TestRenderTemplateError>`](crate::error::TestRenderTemplateError)
    pub fn test_render_template(&self) -> fluent_builders::TestRenderTemplate {
        fluent_builders::TestRenderTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccountSendingEnabled`](crate::client::fluent_builders::UpdateAccountSendingEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateAccountSendingEnabled::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::UpdateAccountSendingEnabled::set_enabled): <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.</p>
    /// - On success, responds with [`UpdateAccountSendingEnabledOutput`](crate::output::UpdateAccountSendingEnabledOutput)

    /// - On failure, responds with [`SdkError<UpdateAccountSendingEnabledError>`](crate::error::UpdateAccountSendingEnabledError)
    pub fn update_account_sending_enabled(&self) -> fluent_builders::UpdateAccountSendingEnabled {
        fluent_builders::UpdateAccountSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_configuration_set_name): <p>The name of the configuration set that contains the event destination that you want to update.</p>
    ///   - [`event_destination(EventDestination)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::event_destination) / [`set_event_destination(Option<EventDestination>)`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination::set_event_destination): <p>The event destination object that you want to apply to the specified configuration set.</p>
    /// - On success, responds with [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetEventDestinationError>`](crate::error::UpdateConfigurationSetEventDestinationError)
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetReputationMetricsEnabled`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::set_configuration_set_name): <p>The name of the configuration set that you want to update.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::set_enabled): <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
    /// - On success, responds with [`UpdateConfigurationSetReputationMetricsEnabledOutput`](crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetReputationMetricsEnabledError>`](crate::error::UpdateConfigurationSetReputationMetricsEnabledError)
    pub fn update_configuration_set_reputation_metrics_enabled(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetReputationMetricsEnabled {
        fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetSendingEnabled`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled::set_configuration_set_name): <p>The name of the configuration set that you want to update.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled::set_enabled): <p>Describes whether email sending is enabled or disabled for the configuration set. </p>
    /// - On success, responds with [`UpdateConfigurationSetSendingEnabledOutput`](crate::output::UpdateConfigurationSetSendingEnabledOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetSendingEnabledError>`](crate::error::UpdateConfigurationSetSendingEnabledError)
    pub fn update_configuration_set_sending_enabled(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetSendingEnabled {
        fluent_builders::UpdateConfigurationSetSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfigurationSetTrackingOptions`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions::configuration_set_name) / [`set_configuration_set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions::set_configuration_set_name): <p>The name of the configuration set for which you want to update the custom tracking domain.</p>
    ///   - [`tracking_options(TrackingOptions)`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions::tracking_options) / [`set_tracking_options(Option<TrackingOptions>)`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions::set_tracking_options): <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateConfigurationSetTrackingOptionsOutput`](crate::output::UpdateConfigurationSetTrackingOptionsOutput)

    /// - On failure, responds with [`SdkError<UpdateConfigurationSetTrackingOptionsError>`](crate::error::UpdateConfigurationSetTrackingOptionsError)
    pub fn update_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetTrackingOptions {
        fluent_builders::UpdateConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomVerificationEmailTemplate`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_name): <p>The name of the custom verification email template that you want to update.</p>
    ///   - [`from_email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::from_email_address) / [`set_from_email_address(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_from_email_address): <p>The email address that the custom verification email is sent from.</p>
    ///   - [`template_subject(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_subject) / [`set_template_subject(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_subject): <p>The subject line of the custom verification email.</p>
    ///   - [`template_content(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::template_content) / [`set_template_content(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_template_content): <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
    ///   - [`success_redirection_url(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::success_redirection_url) / [`set_success_redirection_url(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_success_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
    ///   - [`failure_redirection_url(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::failure_redirection_url) / [`set_failure_redirection_url(Option<String>)`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate::set_failure_redirection_url): <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
    /// - On success, responds with [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)

    /// - On failure, responds with [`SdkError<UpdateCustomVerificationEmailTemplateError>`](crate::error::UpdateCustomVerificationEmailTemplateError)
    pub fn update_custom_verification_email_template(
        &self,
    ) -> fluent_builders::UpdateCustomVerificationEmailTemplate {
        fluent_builders::UpdateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReceiptRule`](crate::client::fluent_builders::UpdateReceiptRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateReceiptRule::rule_set_name) / [`set_rule_set_name(Option<String>)`](crate::client::fluent_builders::UpdateReceiptRule::set_rule_set_name): <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    ///   - [`rule(ReceiptRule)`](crate::client::fluent_builders::UpdateReceiptRule::rule) / [`set_rule(Option<ReceiptRule>)`](crate::client::fluent_builders::UpdateReceiptRule::set_rule): <p>A data structure that contains the updated receipt rule information.</p>
    /// - On success, responds with [`UpdateReceiptRuleOutput`](crate::output::UpdateReceiptRuleOutput)

    /// - On failure, responds with [`SdkError<UpdateReceiptRuleError>`](crate::error::UpdateReceiptRuleError)
    pub fn update_receipt_rule(&self) -> fluent_builders::UpdateReceiptRule {
        fluent_builders::UpdateReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTemplate`](crate::client::fluent_builders::UpdateTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template(Template)`](crate::client::fluent_builders::UpdateTemplate::template) / [`set_template(Option<Template>)`](crate::client::fluent_builders::UpdateTemplate::set_template): <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
    /// - On success, responds with [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)

    /// - On failure, responds with [`SdkError<UpdateTemplateError>`](crate::error::UpdateTemplateError)
    pub fn update_template(&self) -> fluent_builders::UpdateTemplate {
        fluent_builders::UpdateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyDomainDkim`](crate::client::fluent_builders::VerifyDomainDkim) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::VerifyDomainDkim::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::VerifyDomainDkim::set_domain): <p>The name of the domain to be verified for Easy DKIM signing.</p>
    /// - On success, responds with [`VerifyDomainDkimOutput`](crate::output::VerifyDomainDkimOutput) with field(s):
    ///   - [`dkim_tokens(Option<Vec<String>>)`](crate::output::VerifyDomainDkimOutput::dkim_tokens): <p>A set of character strings that represent the domain's identity. If the identity is an email address, the tokens represent the domain of that address.</p>  <p>Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to domain identities, not email address identities.)</p>  <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>
    /// - On failure, responds with [`SdkError<VerifyDomainDkimError>`](crate::error::VerifyDomainDkimError)
    pub fn verify_domain_dkim(&self) -> fluent_builders::VerifyDomainDkim {
        fluent_builders::VerifyDomainDkim::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyDomainIdentity`](crate::client::fluent_builders::VerifyDomainIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::VerifyDomainIdentity::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::VerifyDomainIdentity::set_domain): <p>The domain to be verified.</p>
    /// - On success, responds with [`VerifyDomainIdentityOutput`](crate::output::VerifyDomainIdentityOutput) with field(s):
    ///   - [`verification_token(Option<String>)`](crate::output::VerifyDomainIdentityOutput::verification_token): <p>A TXT record that you must place in the DNS settings of the domain to complete domain verification with Amazon SES.</p>  <p>As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, if you still want to verify the domain, you must restart the verification process from the beginning.</p>
    /// - On failure, responds with [`SdkError<VerifyDomainIdentityError>`](crate::error::VerifyDomainIdentityError)
    pub fn verify_domain_identity(&self) -> fluent_builders::VerifyDomainIdentity {
        fluent_builders::VerifyDomainIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyEmailAddress`](crate::client::fluent_builders::VerifyEmailAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::VerifyEmailAddress::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::VerifyEmailAddress::set_email_address): <p>The email address to be verified.</p>
    /// - On success, responds with [`VerifyEmailAddressOutput`](crate::output::VerifyEmailAddressOutput)

    /// - On failure, responds with [`SdkError<VerifyEmailAddressError>`](crate::error::VerifyEmailAddressError)
    pub fn verify_email_address(&self) -> fluent_builders::VerifyEmailAddress {
        fluent_builders::VerifyEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VerifyEmailIdentity`](crate::client::fluent_builders::VerifyEmailIdentity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::VerifyEmailIdentity::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::VerifyEmailIdentity::set_email_address): <p>The email address to be verified.</p>
    /// - On success, responds with [`VerifyEmailIdentityOutput`](crate::output::VerifyEmailIdentityOutput)

    /// - On failure, responds with [`SdkError<VerifyEmailIdentityError>`](crate::error::VerifyEmailIdentityError)
    pub fn verify_email_identity(&self) -> fluent_builders::VerifyEmailIdentity {
        fluent_builders::VerifyEmailIdentity::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CloneReceiptRuleSet`.
    ///
    /// <p>Creates a receipt rule set by cloning an existing one. All receipt rules and configurations are copied to the new receipt rule set and are completely independent of the source rule set.</p>
    /// <p>For information about setting up rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CloneReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::clone_receipt_rule_set_input::Builder,
    }
    impl CloneReceiptRuleSet {
        /// Creates a new `CloneReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CloneReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CloneReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>
        /// <li> <p>Start and end with a letter or number.</p> </li>
        /// <li> <p>Contain less than 64 characters.</p> </li>
        /// </ul>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>
        /// <li> <p>Start and end with a letter or number.</p> </li>
        /// <li> <p>Contain less than 64 characters.</p> </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn original_rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.original_rule_set_name(input.into());
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn set_original_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_original_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Creates a configuration set.</p>
    /// <p>Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl CreateConfigurationSet {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn configuration_set(mut self, input: crate::model::ConfigurationSet) -> Self {
            self.inner = self.inner.configuration_set(input);
            self
        }
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSet>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// <p>Creates a configuration set event destination.</p> <note>
    /// <p>When you create or update an event destination, you must provide one, and only one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).</p>
    /// </note>
    /// <p>An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl CreateConfigurationSetEventDestination {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that the event destination should be associated with.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that the event destination should be associated with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will be published to.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will be published to.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetTrackingOptions`.
    ///
    /// <p>Creates an association between a configuration set and a custom domain for open and click event tracking. </p>
    /// <p>By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfigurationSetTrackingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_configuration_set_tracking_options_input::Builder,
    }
    impl CreateConfigurationSetTrackingOptions {
        /// Creates a new `CreateConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetTrackingOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that the tracking options should be associated with.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that the tracking options should be associated with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomVerificationEmailTemplate`.
    ///
    /// <p>Creates a new custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_verification_email_template_input::Builder,
    }
    impl CreateCustomVerificationEmailTemplate {
        /// Creates a new `CreateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptFilter`.
    ///
    /// <p>Creates a new IP address filter.</p>
    /// <p>For information about setting up IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReceiptFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_receipt_filter_input::Builder,
    }
    impl CreateReceiptFilter {
        /// Creates a new `CreateReceiptFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A data structure that describes the IP address filter to create, which consists of a name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn filter(mut self, input: crate::model::ReceiptFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>A data structure that describes the IP address filter to create, which consists of a name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReceiptFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptRule`.
    ///
    /// <p>Creates a receipt rule.</p>
    /// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReceiptRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_receipt_rule_input::Builder,
    }
    impl CreateReceiptRule {
        /// Creates a new `CreateReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule will be inserted at the beginning of the rule list.</p>
        pub fn after(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after(input.into());
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule will be inserted at the beginning of the rule list.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after(input);
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.</p>
        pub fn rule(mut self, input: crate::model::ReceiptRule) -> Self {
            self.inner = self.inner.rule(input);
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptRuleSet`.
    ///
    /// <p>Creates an empty receipt rule set.</p>
    /// <p>For information about setting up receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_receipt_rule_set_input::Builder,
    }
    impl CreateReceiptRuleSet {
        /// Creates a new `CreateReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>
        /// <li> <p>Start and end with a letter or number.</p> </li>
        /// <li> <p>Contain less than 64 characters.</p> </li>
        /// </ul>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li> <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li>
        /// <li> <p>Start and end with a letter or number.</p> </li>
        /// <li> <p>Contain less than 64 characters.</p> </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplate`.
    ///
    /// <p>Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_template_input::Builder,
    }
    impl CreateTemplate {
        /// Creates a new `CreateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.inner = self.inner.template(input);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl DeleteConfigurationSet {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// <p>Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl DeleteConfigurationSetEventDestination {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetTrackingOptions`.
    ///
    /// <p>Deletes an association between a configuration set and a custom domain for open and click event tracking.</p>
    /// <p>By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p> <note>
    /// <p>Deleting this kind of association will result in emails sent using the specified configuration set to capture open and click events using the standard, Amazon SES-operated domains.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfigurationSetTrackingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_configuration_set_tracking_options_input::Builder,
    }
    impl DeleteConfigurationSetTrackingOptions {
        /// Creates a new `DeleteConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetTrackingOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set from which you want to delete the tracking options.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set from which you want to delete the tracking options.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomVerificationEmailTemplate`.
    ///
    /// <p>Deletes an existing custom verification email template. </p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_verification_email_template_input::Builder,
    }
    impl DeleteCustomVerificationEmailTemplate {
        /// Creates a new `DeleteCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentity`.
    ///
    /// <p>Deletes the specified identity (an email address or a domain) from the list of verified identities.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_identity_input::Builder,
    }
    impl DeleteIdentity {
        /// Creates a new `DeleteIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityPolicy`.
    ///
    /// <p>Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIdentityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_identity_policy_input::Builder,
    }
    impl DeleteIdentityPolicy {
        /// Creates a new `DeleteIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that is associated with the policy that you want to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity that is associated with the policy that you want to delete. You can specify the identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptFilter`.
    ///
    /// <p>Deletes the specified IP address filter.</p>
    /// <p>For information about managing IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReceiptFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_receipt_filter_input::Builder,
    }
    impl DeleteReceiptFilter {
        /// Creates a new `DeleteReceiptFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP address filter to delete.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(input.into());
            self
        }
        /// <p>The name of the IP address filter to delete.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptRule`.
    ///
    /// <p>Deletes the specified receipt rule.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReceiptRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_receipt_rule_input::Builder,
    }
    impl DeleteReceiptRule {
        /// Creates a new `DeleteReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptRuleSet`.
    ///
    /// <p>Deletes the specified receipt rule set and all of the receipt rules it contains.</p> <note>
    /// <p>The currently active rule set cannot be deleted.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_receipt_rule_set_input::Builder,
    }
    impl DeleteReceiptRuleSet {
        /// Creates a new `DeleteReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplate`.
    ///
    /// <p>Deletes an email template.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_template_input::Builder,
    }
    impl DeleteTemplate {
        /// Creates a new `DeleteTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVerifiedEmailAddress`.
    ///
    /// <p>Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses and domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVerifiedEmailAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_verified_email_address_input::Builder,
    }
    impl DeleteVerifiedEmailAddress {
        /// Creates a new `DeleteVerifiedEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVerifiedEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVerifiedEmailAddressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActiveReceiptRuleSet`.
    ///
    /// <p>Returns the metadata and receipt rules for the receipt rule set that is currently active.</p>
    /// <p>For information about setting up receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActiveReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_active_receipt_rule_set_input::Builder,
    }
    impl DescribeActiveReceiptRuleSet {
        /// Creates a new `DescribeActiveReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActiveReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActiveReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationSet`.
    ///
    /// <p>Returns the details of the specified configuration set. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConfigurationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_configuration_set_input::Builder,
    }
    impl DescribeConfigurationSet {
        /// Creates a new `DescribeConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to describe.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to describe.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `ConfigurationSetAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_set_attribute_names`](Self::set_configuration_set_attribute_names).
        ///
        /// <p>A list of configuration set attributes to return.</p>
        pub fn configuration_set_attribute_names(
            mut self,
            input: crate::model::ConfigurationSetAttribute,
        ) -> Self {
            self.inner = self.inner.configuration_set_attribute_names(input);
            self
        }
        /// <p>A list of configuration set attributes to return.</p>
        pub fn set_configuration_set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReceiptRule`.
    ///
    /// <p>Returns the details of the specified receipt rule.</p>
    /// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReceiptRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_receipt_rule_input::Builder,
    }
    impl DescribeReceiptRule {
        /// Creates a new `DescribeReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReceiptRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReceiptRuleSet`.
    ///
    /// <p>Returns the details of the specified receipt rule set.</p>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_receipt_rule_set_input::Builder,
    }
    impl DescribeReceiptRuleSet {
        /// Creates a new `DescribeReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSendingEnabled`.
    ///
    /// <p>Returns the email sending status of the Amazon SES account for the current region.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountSendingEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_sending_enabled_input::Builder,
    }
    impl GetAccountSendingEnabled {
        /// Creates a new `GetAccountSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSendingEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSendingEnabledError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCustomVerificationEmailTemplate`.
    ///
    /// <p>Returns the custom email verification template for the template name you specify.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_custom_verification_email_template_input::Builder,
    }
    impl GetCustomVerificationEmailTemplate {
        /// Creates a new `GetCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityDkimAttributes`.
    ///
    /// <p>Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published.</p>
    /// <p>This operation takes a list of identities as input and returns the following information for each:</p>
    /// <ul>
    /// <li> <p>Whether Easy DKIM signing is enabled or disabled.</p> </li>
    /// <li> <p>A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.</p> </li>
    /// <li> <p>Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is only returned for domain name identities, not for email addresses.</p> </li>
    /// </ul>
    /// <p>This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time.</p>
    /// <p>For more information about creating DNS records using DKIM tokens, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityDkimAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_dkim_attributes_input::Builder,
    }
    impl GetIdentityDkimAttributes {
        /// Creates a new `GetIdentityDkimAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityDkimAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityDkimAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(input.into());
            self
        }
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityMailFromDomainAttributes`.
    ///
    /// <p>Returns the custom MAIL FROM attributes for a list of identities (email addresses : domains).</p>
    /// <p>This operation is throttled at one request per second and can only get custom MAIL FROM attributes for up to 100 identities at a time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityMailFromDomainAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_mail_from_domain_attributes_input::Builder,
    }
    impl GetIdentityMailFromDomainAttributes {
        /// Creates a new `GetIdentityMailFromDomainAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityMailFromDomainAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetIdentityMailFromDomainAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(input.into());
            self
        }
        /// <p>A list of one or more identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityNotificationAttributes`.
    ///
    /// <p>Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.</p>
    /// <p>This operation is throttled at one request per second and can only get notification attributes for up to 100 identities at a time.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityNotificationAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_notification_attributes_input::Builder,
    }
    impl GetIdentityNotificationAttributes {
        /// Creates a new `GetIdentityNotificationAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityNotificationAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityNotificationAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(input.into());
            self
        }
        /// <p>A list of one or more identities. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPolicies`.
    ///
    /// <p>Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_policies_input::Builder,
    }
    impl GetIdentityPolicies {
        /// Creates a new `GetIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// Appends an item to `PolicyNames`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_names(input.into());
            self
        }
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do not know the names of the policies that are attached to the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityVerificationAttributes`.
    ///
    /// <p>Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.</p>
    /// <p>The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, if you still want to verify the email address, you must restart the verification process from the beginning.</p>
    /// <p>For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, if you still want to verify the domain, you must restart the verification process from the beginning.</p>
    /// <p>This operation is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityVerificationAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_verification_attributes_input::Builder,
    }
    impl GetIdentityVerificationAttributes {
        /// Creates a new `GetIdentityVerificationAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityVerificationAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityVerificationAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of identities.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(input.into());
            self
        }
        /// <p>A list of identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSendQuota`.
    ///
    /// <p>Provides the sending limits for the Amazon SES account. </p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSendQuota {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_send_quota_input::Builder,
    }
    impl GetSendQuota {
        /// Creates a new `GetSendQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSendQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSendQuotaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSendStatistics`.
    ///
    /// <p>Provides sending statistics for the current AWS Region. The result is a list of data points, representing the last two weeks of sending activity. Each data point in the list contains statistics for a 15-minute period of time.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSendStatistics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_send_statistics_input::Builder,
    }
    impl GetSendStatistics {
        /// Creates a new `GetSendStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSendStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSendStatisticsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetTemplate`.
    ///
    /// <p>Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_template_input::Builder,
    }
    impl GetTemplate {
        /// Creates a new `GetTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// <p>Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i> </p>
    /// <p>You can execute this operation no more than once per second. This operation will return up to 1,000 configuration sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will also return a NextToken element. You can then execute the <code>ListConfigurationSets</code> operation again, passing the <code>NextToken</code> parameter and the value of the NextToken element to retrieve additional results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigurationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl ListConfigurationSets {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the configuration set in the configuration set list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the configuration set in the configuration set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomVerificationEmailTemplates`.
    ///
    /// <p>Lists the existing custom verification email templates for your account in the current AWS Region.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomVerificationEmailTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_verification_email_templates_input::Builder,
    }
    impl ListCustomVerificationEmailTemplates {
        /// Creates a new `ListCustomVerificationEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomVerificationEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomVerificationEmailTemplatesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomVerificationEmailTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCustomVerificationEmailTemplatesPaginator {
            crate::paginator::ListCustomVerificationEmailTemplatesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation will return up to 50 results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation will return up to 50 results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentities`.
    ///
    /// <p>Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current AWS Region, regardless of verification status.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identities_input::Builder,
    }
    impl ListIdentities {
        /// Creates a new `ListIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIdentitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIdentitiesPaginator {
            crate::paginator::ListIdentitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities will be listed.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(input);
            self
        }
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities will be listed.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000 inclusive.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000 inclusive.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPolicies`.
    ///
    /// <p>Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain). This API returns only a list. If you want the actual policy content, you can use <code>GetIdentityPolicies</code>.</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identity_policies_input::Builder,
    }
    impl ListIdentityPolicies {
        /// Creates a new `ListIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that is associated with the policy for which the policies will be listed. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity that is associated with the policy for which the policies will be listed. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceiptFilters`.
    ///
    /// <p>Lists the IP address filters associated with your AWS account in the current AWS Region.</p>
    /// <p>For information about managing IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReceiptFilters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_receipt_filters_input::Builder,
    }
    impl ListReceiptFilters {
        /// Creates a new `ListReceiptFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceiptFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceiptFiltersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListReceiptRuleSets`.
    ///
    /// <p>Lists the receipt rule sets that exist under your AWS account in the current AWS Region. If there are additional receipt rule sets to be retrieved, you will receive a <code>NextToken</code> that you can provide to the next call to <code>ListReceiptRuleSets</code> to retrieve the additional entries.</p>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReceiptRuleSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_receipt_rule_sets_input::Builder,
    }
    impl ListReceiptRuleSets {
        /// Creates a new `ListReceiptRuleSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceiptRuleSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceiptRuleSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the receipt rule set list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the receipt rule set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Lists the email templates present in your Amazon SES account in the current AWS Region.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl ListTemplates {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return up to 10 results.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return up to 10 results.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVerifiedEmailAddresses`.
    ///
    /// <p>Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses and domains associated with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVerifiedEmailAddresses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_verified_email_addresses_input::Builder,
    }
    impl ListVerifiedEmailAddresses {
        /// Creates a new `ListVerifiedEmailAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVerifiedEmailAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVerifiedEmailAddressesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetDeliveryOptions`.
    ///
    /// <p>Adds or updates the delivery options for a configuration set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutConfigurationSetDeliveryOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_configuration_set_delivery_options_input::Builder,
    }
    impl PutConfigurationSetDeliveryOptions {
        /// Creates a new `PutConfigurationSetDeliveryOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetDeliveryOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetDeliveryOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to specify the delivery options for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to specify the delivery options for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.inner = self.inner.delivery_options(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.inner = self.inner.set_delivery_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIdentityPolicy`.
    ///
    /// <p>Adds or updates a sending authorization policy for the specified identity (an email address or a domain).</p> <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutIdentityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_identity_policy_input::Builder,
    }
    impl PutIdentityPolicy {
        /// Creates a new `PutIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIdentityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that the policy will apply to. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity that the policy will apply to. You can specify an identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReorderReceiptRuleSet`.
    ///
    /// <p>Reorders the receipt rules within a receipt rule set.</p> <note>
    /// <p>All of the rules in the rule set must be represented in this request. That is, this API will return an error if the reorder request doesn't explicitly position all of the rules.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReorderReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reorder_receipt_rule_set_input::Builder,
    }
    impl ReorderReceiptRuleSet {
        /// Creates a new `ReorderReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReorderReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ReorderReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// Appends an item to `RuleNames`.
        ///
        /// To override the contents of this collection use [`set_rule_names`](Self::set_rule_names).
        ///
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to put them.</p>
        pub fn rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_names(input.into());
            self
        }
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to put them.</p>
        pub fn set_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rule_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBounce`.
    ///
    /// <p>Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this API on an email up to 24 hours after you receive it.</p> <note>
    /// <p>You cannot use this API to send generic bounces for mail that was not received by Amazon SES.</p>
    /// </note>
    /// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendBounce {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_bounce_input::Builder,
    }
    impl SendBounce {
        /// Creates a new `SendBounce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBounceOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBounceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The message ID of the message to be bounced.</p>
        pub fn original_message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.original_message_id(input.into());
            self
        }
        /// <p>The message ID of the message to be bounced.</p>
        pub fn set_original_message_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_original_message_id(input);
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.</p>
        pub fn bounce_sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bounce_sender(input.into());
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.</p>
        pub fn set_bounce_sender(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bounce_sender(input);
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified, the text will be auto-generated based on the bounced recipient information.</p>
        pub fn explanation(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.explanation(input.into());
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified, the text will be auto-generated based on the bounced recipient information.</p>
        pub fn set_explanation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_explanation(input);
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn message_dsn(mut self, input: crate::model::MessageDsn) -> Self {
            self.inner = self.inner.message_dsn(input);
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn set_message_dsn(
            mut self,
            input: std::option::Option<crate::model::MessageDsn>,
        ) -> Self {
            self.inner = self.inner.set_message_dsn(input);
            self
        }
        /// Appends an item to `BouncedRecipientInfoList`.
        ///
        /// To override the contents of this collection use [`set_bounced_recipient_info_list`](Self::set_bounced_recipient_info_list).
        ///
        /// <p>A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn bounced_recipient_info_list(
            mut self,
            input: crate::model::BouncedRecipientInfo,
        ) -> Self {
            self.inner = self.inner.bounced_recipient_info_list(input);
            self
        }
        /// <p>A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn set_bounced_recipient_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BouncedRecipientInfo>>,
        ) -> Self {
            self.inner = self.inner.set_bounced_recipient_info_list(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn bounce_sender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bounce_sender_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_bounce_sender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bounce_sender_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBulkTemplatedEmail`.
    ///
    /// <p>Composes an email message to multiple destinations. The message body is created using an email template.</p>
    /// <p>In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your call to the API must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>The call must refer to an existing email template. You can create email templates using the <code>CreateTemplate</code> operation.</p> </li>
    /// <li> <p>The message must be sent from a verified email address or domain.</p> </li>
    /// <li> <p>If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i> </p> </li>
    /// <li> <p>The maximum message size is 10 MB.</p> </li>
    /// <li> <p>Each <code>Destination</code> parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message contains other recipients that are valid.</p> </li>
    /// <li> <p>The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the <code>SendBulkTemplatedEmail</code> operation several times to send the message to each group.</p> </li>
    /// <li> <p>The number of destinations you can contact in a single call to the API may be limited by your account's maximum sending rate.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendBulkTemplatedEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_bulk_templated_email_input::Builder,
    }
    impl SendBulkTemplatedEmail {
        /// Creates a new `SendBulkTemplatedEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBulkTemplatedEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBulkTemplatedEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `DefaultTags`.
        ///
        /// To override the contents of this collection use [`set_default_tags`](Self::set_default_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn default_tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.default_tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_default_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_default_tags(input);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_arn(input.into());
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_arn(input);
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not specified in a Destination object. These values act as a default or fallback option when no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn default_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_template_data(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not specified in a Destination object. These values act as a default or fallback option when no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn set_default_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_template_data(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a <code>Destination</code> will receive the same version of the email. You can specify up to 50 <code>Destination</code> objects within a <code>Destinations</code> array.</p>
        pub fn destinations(mut self, input: crate::model::BulkEmailDestination) -> Self {
            self.inner = self.inner.destinations(input);
            self
        }
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a <code>Destination</code> will receive the same version of the email. You can specify up to 50 <code>Destination</code> objects within a <code>Destinations</code> array.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestination>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendCustomVerificationEmail`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.</p>
    /// <p>To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendCustomVerificationEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_custom_verification_email_input::Builder,
    }
    impl SendCustomVerificationEmail {
        /// Creates a new `SendCustomVerificationEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendCustomVerificationEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendCustomVerificationEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template to use when sending the verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEmail`.
    ///
    /// <p>Composes an email message and immediately queues it for sending. In order to send email using the <code>SendEmail</code> operation, your message must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>The message must be sent from a verified email address or domain. If you attempt to send email using a non-verified address or domain, the operation will result in an "Email address not verified" error. </p> </li>
    /// <li> <p>If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i> </p> </li>
    /// <li> <p>The maximum message size is 10 MB.</p> </li>
    /// <li> <p>The message must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message contains other recipients that are valid.</p> </li>
    /// <li> <p>The message may not include more than 50 recipients, across the To:, CC: and BCC: fields. If you need to send an email message to a larger audience, you can divide your recipient list into groups of 50 or fewer, and then call the <code>SendEmail</code> operation several times to send the message to each group.</p> </li>
    /// </ul> <important>
    /// <p>For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending quota</i>). For more information about sending quotas in Amazon SES, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES Sending Limits</a> in the <i>Amazon SES Developer Guide.</i> </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_email_input::Builder,
    }
    impl SendEmail {
        /// Creates a new `SendEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The message to be sent.</p>
        pub fn message(mut self, input: crate::model::Message) -> Self {
            self.inner = self.inner.message(input);
            self
        }
        /// <p>The message to be sent.</p>
        pub fn set_message(mut self, input: std::option::Option<crate::model::Message>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendRawEmail`.
    ///
    /// <p>Composes an email message and immediately queues it for sending.</p>
    /// <p>This operation is more flexible than the <code>SendEmail</code> API operation. When you use the <code>SendRawEmail</code> operation, you can specify the headers of the message as well as its content. This flexibility is useful, for example, when you want to send a multipart MIME email (such a message that contains both a text and an HTML version). You can also use this operation to send messages that include attachments.</p>
    /// <p>The <code>SendRawEmail</code> operation has the following requirements:</p>
    /// <ul>
    /// <li> <p>You can only send email from <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email addresses or domains</a>. If you try to send email from an address that isn't verified, the operation results in an "Email address not verified" error.</p> </li>
    /// <li> <p>If your account is still in the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES sandbox</a>, you can only send email to other verified addresses in your account, or to addresses that are associated with the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon SES mailbox simulator</a>.</p> </li>
    /// <li> <p>The maximum message size, including attachments, is 10 MB.</p> </li>
    /// <li> <p>Each message has to include at least one recipient address. A recipient address includes any address on the To:, CC:, or BCC: lines.</p> </li>
    /// <li> <p>If you send a single message to more than one recipient address, and one of the recipient addresses isn't in a valid format (that is, it's not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES rejects the entire message, even if the other addresses are valid.</p> </li>
    /// <li> <p>Each message can include up to 50 recipient addresses across the To:, CC:, or BCC: lines. If you need to send a single message to more than 50 recipients, you have to split the list of recipient addresses into groups of less than 50 recipients, and send separate messages to each group.</p> </li>
    /// <li> <p>Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message parts. However, if Amazon SES has to modify the contents of your message (for example, if you use open and click tracking), 8-bit content isn't preserved. For this reason, we highly recommend that you encode all content that isn't 7-bit ASCII. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME Encoding</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>
    /// </ul>
    /// <p>Additionally, keep the following considerations in mind when using the <code>SendRawEmail</code> operation:</p>
    /// <ul>
    /// <li> <p>Although you can customize the message headers when using the <code>SendRawEmail</code> operation, Amazon SES will automatically apply its own <code>Message-ID</code> and <code>Date</code> headers; if you passed these headers when creating the message, they will be overwritten by the values that Amazon SES provides.</p> </li>
    /// <li> <p>If you are using sending authorization to send on behalf of another user, <code>SendRawEmail</code> enables you to specify the cross-account identity for the email's Source, From, and Return-Path parameters in one of two ways: you can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>, and/or <code>ReturnPathArn</code> to the API, or you can include the following X-headers in the header of your raw email:</p>
    /// <ul>
    /// <li> <p> <code>X-SES-SOURCE-ARN</code> </p> </li>
    /// <li> <p> <code>X-SES-FROM-ARN</code> </p> </li>
    /// <li> <p> <code>X-SES-RETURN-PATH-ARN</code> </p> </li>
    /// </ul> <important>
    /// <p>Don't include these X-headers in the DKIM signature. Amazon SES removes these before it sends the email.</p>
    /// </important> <p>If you only specify the <code>SourceIdentityArn</code> parameter, Amazon SES sets the From and Return-Path addresses to the same identity that you specified.</p> <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending Authorization with Amazon SES</a> in the <i>Amazon SES Developer Guide.</i> </p> </li>
    /// <li> <p>For every message that you send, the total number of recipients (including each recipient in the To:, CC: and BCC: fields) is counted against the maximum number of emails you can send in a 24-hour period (your <i>sending quota</i>). For more information about sending quotas in Amazon SES, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES Sending Limits</a> in the <i>Amazon SES Developer Guide.</i> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendRawEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_raw_email_input::Builder,
    }
    impl SendRawEmail {
        /// Creates a new `SendRawEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendRawEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendRawEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled, then bounces and complaints will be sent to this email address. This takes precedence over any Return-Path header that you might include in the raw text of the message.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The identity's email address. If you do not provide a value for this parameter, you must specify a "From" address in the raw text of the message. (You can also specify both.)</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled, then bounces and complaints will be sent to this email address. This takes precedence over any Return-Path header that you might include in the raw text of the message.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.</p>
        pub fn destinations(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destinations(input.into());
            self
        }
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC: addresses.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li> <p>The message has to contain a header and a body, separated by a blank line.</p> </li>
        /// <li> <p>All of the required header fields must be present in the message.</p> </li>
        /// <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li>
        /// <li> <p>Attachments must be of a content type that Amazon SES supports. For a list on unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment Types</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>
        /// <li> <p>The entire message must be base64-encoded.</p> </li>
        /// <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, we highly recommend that you encode that content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>
        /// <li> <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of text, including the <crlf>
        /// , must not exceed 1,000 characters.
        /// </crlf></p> </li>
        /// </ul>
        pub fn raw_message(mut self, input: crate::model::RawMessage) -> Self {
            self.inner = self.inner.raw_message(input);
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li> <p>The message has to contain a header and a body, separated by a blank line.</p> </li>
        /// <li> <p>All of the required header fields must be present in the message.</p> </li>
        /// <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li>
        /// <li> <p>Attachments must be of a content type that Amazon SES supports. For a list on unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment Types</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>
        /// <li> <p>The entire message must be base64-encoded.</p> </li>
        /// <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, we highly recommend that you encode that content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer Guide</i>.</p> </li>
        /// <li> <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of text, including the <crlf>
        /// , must not exceed 1,000 characters.
        /// </crlf></p> </li>
        /// </ul>
        pub fn set_raw_message(
            mut self,
            input: std::option::Option<crate::model::RawMessage>,
        ) -> Self {
            self.inner = self.inner.set_raw_message(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code> in the raw message of the email. If you use both the <code>FromArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn from_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to specify a particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code> in the raw message of the email. If you use both the <code>FromArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_from_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_from_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>SourceArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>SourceArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>ReturnPathArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the value of the <code>ReturnPathArn</code> parameter.</p> <note>
        /// <p>For information about when to use this parameter, see the description of <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendRawEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendRawEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTemplatedEmail`.
    ///
    /// <p>Composes an email message using an email template and immediately queues it for sending.</p>
    /// <p>In order to send email using the <code>SendTemplatedEmail</code> operation, your call to the API must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>The call must refer to an existing email template. You can create email templates using the <code>CreateTemplate</code> operation.</p> </li>
    /// <li> <p>The message must be sent from a verified email address or domain.</p> </li>
    /// <li> <p>If your account is still in the Amazon SES sandbox, you may only send to verified addresses or domains, or to email addresses associated with the Amazon SES Mailbox Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i> </p> </li>
    /// <li> <p>The maximum message size is 10 MB.</p> </li>
    /// <li> <p>Calls to the <code>SendTemplatedEmail</code> operation may only include one <code>Destination</code> parameter. A destination is a set of recipients who will receive the same version of the email. The <code>Destination</code> parameter can include up to 50 recipients, across the To:, CC: and BCC: fields.</p> </li>
    /// <li> <p>The <code>Destination</code> parameter must include at least one recipient email address. The recipient address can be a To: address, a CC: address, or a BCC: address. If a recipient email address is invalid (that is, it is not in the format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire message will be rejected, even if the message contains other recipients that are valid.</p> </li>
    /// </ul> <important>
    /// <p>If your call to the <code>SendTemplatedEmail</code> operation includes all of the required parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon SES can't render the email because the template contains errors, it doesn't send the email. Additionally, because it already accepted the message, Amazon SES doesn't return a message stating that it was unable to send the email.</p>
    /// <p>For these reasons, we highly recommend that you set up Amazon SES to send you notifications when Rendering Failure events occur. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending Personalized Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendTemplatedEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_templated_email_input::Builder,
    }
    impl SendTemplatedEmail {
        /// Creates a new `SendTemplatedEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTemplatedEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTemplatedEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a sending authorization policy, then you must also specify the <code>SourceArn</code> parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the <i>local part</i> of a source email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the <i>domain part</i> of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly name</i>) may contain non-ASCII characters. These characters must be encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word syntax uses the following form: <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination can include up to 50 recipients across these three fields.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination can include up to 50 recipients across these three fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(input.into());
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback forwarding is enabled. If the message cannot be delivered to the recipient, then an error message will be returned from the recipient's ISP; this message will then be forwarded to the email address specified by the <code>ReturnPath</code> parameter. The <code>ReturnPath</code> parameter is never overwritten. This email address must be either individually verified with Amazon SES, or from a domain that has been verified with Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to send for the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to send from <code>user@example.com</code>, then you would specify the <code>SourceArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a policy to it that authorizes you to use <code>feedback@example.com</code>, then you would specify the <code>ReturnPathArn</code> to be <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: crate::model::MessageTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using <code>SendTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_arn(input.into());
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_arn(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetActiveReceiptRuleSet`.
    ///
    /// <p>Sets the specified receipt rule set as the active receipt rule set.</p> <note>
    /// <p>To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to null.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetActiveReceiptRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_active_receipt_rule_set_input::Builder,
    }
    impl SetActiveReceiptRuleSet {
        /// Creates a new `SetActiveReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetActiveReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::SetActiveReceiptRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables all email receiving.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables all email receiving.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityDkimEnabled`.
    ///
    /// <p>Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.</p> <note>
    /// <p>For email addresses (for example, <code>user@example.com</code>), you can only enable DKIM signing if the corresponding domain (in this case, <code>example.com</code>) has been set up to use Easy DKIM.</p>
    /// </note>
    /// <p>You can enable DKIM signing for an identity at any time after you start the verification process for the identity, even if the verification process isn't complete. </p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about Easy DKIM signing, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityDkimEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_dkim_enabled_input::Builder,
    }
    impl SetIdentityDkimEnabled {
        /// Creates a new `SetIdentityDkimEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityDkimEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityDkimEnabledError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn dkim_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.dkim_enabled(input);
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn set_dkim_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dkim_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityFeedbackForwardingEnabled`.
    ///
    /// <p>Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email. Feedback forwarding can only be disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and complaints.</p> <note>
    /// <p>Feedback forwarding does not apply to delivery notifications. Delivery notifications are only available through Amazon SNS.</p>
    /// </note>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityFeedbackForwardingEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_feedback_forwarding_enabled_input::Builder,
    }
    impl SetIdentityFeedbackForwardingEnabled {
        /// Creates a new `SetIdentityFeedbackForwardingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityFeedbackForwardingEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetIdentityFeedbackForwardingEnabledError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.</p>
        pub fn forwarding_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.forwarding_enabled(input);
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email. <code>true</code> specifies that Amazon SES will forward bounce and complaint notifications as email, in addition to any Amazon SNS topic publishing otherwise specified. <code>false</code> specifies that Amazon SES will publish bounce and complaint notifications only through Amazon SNS. This value can only be set to <code>false</code> when Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code> notification types.</p>
        pub fn set_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_forwarding_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityHeadersInNotificationsEnabled`.
    ///
    /// <p>Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityHeadersInNotificationsEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_headers_in_notifications_enabled_input::Builder,
    }
    impl SetIdentityHeadersInNotificationsEnabled {
        /// Creates a new `SetIdentityHeadersInNotificationsEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetIdentityHeadersInNotificationsEnabledError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(input);
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of <code>true</code> specifies that Amazon SES will include headers in notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS topic.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of <code>true</code> specifies that Amazon SES will include headers in notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS topic.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityMailFromDomain`.
    ///
    /// <p>Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).</p> <important>
    /// <p>To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer Guide</a>.</p>
    /// </important>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityMailFromDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_mail_from_domain_input::Builder,
    }
    impl SetIdentityMailFromDomain {
        /// Creates a new `SetIdentityMailFromDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityMailFromDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityMailFromDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for the identity.</p>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mail_from_domain(input.into());
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for the identity.</p>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mail_from_domain(input);
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.inner = self.inner.behavior_on_mx_failure(input);
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.inner = self.inner.set_behavior_on_mx_failure(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityNotificationTopic`.
    ///
    /// <p>Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about feedback notification, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetIdentityNotificationTopic {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_identity_notification_topic_input::Builder,
    }
    impl SetIdentityNotificationTopic {
        /// Creates a new `SetIdentityNotificationTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityNotificationTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityNotificationTopicError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic for.</p> <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name (ARN). The following examples are all valid identities: <code>sender@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(input.into());
            self
        }
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic for.</p> <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name (ARN). The following examples are all valid identities: <code>sender@example.com</code>, <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(input);
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing is disabled.</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing is disabled.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sns_topic(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetReceiptRulePosition`.
    ///
    /// <p>Sets the position of the specified receipt rule in the receipt rule set.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetReceiptRulePosition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_receipt_rule_position_input::Builder,
    }
    impl SetReceiptRulePosition {
        /// Creates a new `SetReceiptRulePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetReceiptRulePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::SetReceiptRulePositionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn after(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after(input.into());
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRenderTemplate`.
    ///
    /// <p>Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestRenderTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_render_template_input::Builder,
    }
    impl TestRenderTemplate {
        /// Creates a new `TestRenderTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRenderTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRenderTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template that you want to render.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the template that you want to render.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSendingEnabled`.
    ///
    /// <p>Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccountSendingEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_account_sending_enabled_input::Builder,
    }
    impl UpdateAccountSendingEnabled {
        /// Creates a new `UpdateAccountSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSendingEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSendingEnabledError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// <p>Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon SES Sending Activity</a> in the <i>Amazon SES Developer Guide.</i> </p> <note>
    /// <p>When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).</p>
    /// </note>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl UpdateConfigurationSetEventDestination {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination that you want to update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration set.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.inner = self.inner.event_destination(input);
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration set.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetReputationMetricsEnabled`.
    ///
    /// <p>Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetReputationMetricsEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder,
    }
    impl UpdateConfigurationSetReputationMetricsEnabled {
        /// Creates a new `UpdateConfigurationSetReputationMetricsEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetReputationMetricsEnabledError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetSendingEnabled`.
    ///
    /// <p>Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetSendingEnabled {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_sending_enabled_input::Builder,
    }
    impl UpdateConfigurationSetSendingEnabled {
        /// Creates a new `UpdateConfigurationSetSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetSendingEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetSendingEnabledError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetTrackingOptions`.
    ///
    /// <p>Modifies an association between a configuration set and a custom domain for open and click event tracking. </p>
    /// <p>By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfigurationSetTrackingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_configuration_set_tracking_options_input::Builder,
    }
    impl UpdateConfigurationSetTrackingOptions {
        /// Creates a new `UpdateConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetTrackingOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set for which you want to update the custom tracking domain.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(input.into());
            self
        }
        /// <p>The name of the configuration set for which you want to update the custom tracking domain.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomVerificationEmailTemplate`.
    ///
    /// <p>Updates an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomVerificationEmailTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_verification_email_template_input::Builder,
    }
    impl UpdateCustomVerificationEmailTemplate {
        /// Creates a new `UpdateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomVerificationEmailTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReceiptRule`.
    ///
    /// <p>Updates a receipt rule.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReceiptRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_receipt_rule_input::Builder,
    }
    impl UpdateReceiptRule {
        /// Creates a new `UpdateReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReceiptRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(input.into());
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn rule(mut self, input: crate::model::ReceiptRule) -> Self {
            self.inner = self.inner.rule(input);
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplate`.
    ///
    /// <p>Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_template_input::Builder,
    }
    impl UpdateTemplate {
        /// Creates a new `UpdateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.inner = self.inner.template(input);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyDomainDkim`.
    ///
    /// <p>Returns a set of DKIM tokens for a domain identity.</p> <important>
    /// <p>When you execute the <code>VerifyDomainDkim</code> operation, the domain that you specify is added to the list of identities that are associated with your account. This is true even if you haven't already associated the domain with your account by using the <code>VerifyDomainIdentity</code> operation. However, you can't send email from the domain until you either successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">verify it</a> or you successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">set up DKIM for it</a>.</p>
    /// </important>
    /// <p>You use the tokens that are generated by this operation to create CNAME records. When Amazon SES detects that you've added these records to the DNS configuration for a domain, you can start sending email from that domain. You can start sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity operation to the DNS configuration for your domain. All email that you send from the domain is authenticated using DKIM.</p>
    /// <p>To create the CNAME records for DKIM authentication, use the following values:</p>
    /// <ul>
    /// <li> <p> <b>Name</b>: <i>token</i>._domainkey.<i>example.com</i> </p> </li>
    /// <li> <p> <b>Type</b>: CNAME</p> </li>
    /// <li> <p> <b>Value</b>: <i>token</i>.dkim.amazonses.com</p> </li>
    /// </ul>
    /// <p>In the preceding example, replace <i>token</i> with one of the tokens that are generated when you execute this operation. Replace <i>example.com</i> with your domain. Repeat this process for each token that's generated by this operation.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyDomainDkim {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::verify_domain_dkim_input::Builder,
    }
    impl VerifyDomainDkim {
        /// Creates a new `VerifyDomainDkim`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyDomainDkimOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyDomainDkimError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyDomainIdentity`.
    ///
    /// <p>Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. For more information about verifying domains, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email Addresses and Domains</a> in the <i>Amazon SES Developer Guide.</i> </p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyDomainIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::verify_domain_identity_input::Builder,
    }
    impl VerifyDomainIdentity {
        /// Creates a new `VerifyDomainIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyDomainIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyDomainIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain to be verified.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The domain to be verified.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyEmailAddress`.
    ///
    /// <p>Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email address.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyEmailAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::verify_email_address_input::Builder,
    }
    impl VerifyEmailAddress {
        /// Creates a new `VerifyEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyEmailAddressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyEmailIdentity`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current AWS region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VerifyEmailIdentity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::verify_email_identity_input::Builder,
    }
    impl VerifyEmailIdentity {
        /// Creates a new `VerifyEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyEmailIdentityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
