// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CloneReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`clone_receipt_rule_set`](crate::client::Client::clone_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::CloneReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CloneReceiptRuleSet {
    _private: (),
}
impl CloneReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`CloneReceiptRuleSetInput`](crate::input::CloneReceiptRuleSetInput)
    pub fn builder() -> crate::input::clone_receipt_rule_set_input::Builder {
        crate::input::clone_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `CloneReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CloneReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::CloneReceiptRuleSetOutput,
        crate::error::CloneReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_clone_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_clone_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set`](crate::client::Client::create_configuration_set).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSet {
    _private: (),
}
impl CreateConfigurationSet {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSet {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetOutput,
        crate::error::CreateConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_response(response)
        }
    }
}

/// Operation shape for `CreateConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set_event_destination`](crate::client::Client::create_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSetEventDestination {
    _private: (),
}
impl CreateConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::create_configuration_set_event_destination_input::Builder {
        crate::input::create_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetEventDestinationOutput,
        crate::error::CreateConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_event_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateConfigurationSetTrackingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_configuration_set_tracking_options`](crate::client::Client::create_configuration_set_tracking_options).
///
/// See [`crate::client::fluent_builders::CreateConfigurationSetTrackingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConfigurationSetTrackingOptions {
    _private: (),
}
impl CreateConfigurationSetTrackingOptions {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetTrackingOptionsInput`](crate::input::CreateConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::create_configuration_set_tracking_options_input::Builder {
        crate::input::create_configuration_set_tracking_options_input::Builder::default()
    }
    /// Creates a new `CreateConfigurationSetTrackingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConfigurationSetTrackingOptions {
    type Output = std::result::Result<
        crate::output::CreateConfigurationSetTrackingOptionsOutput,
        crate::error::CreateConfigurationSetTrackingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_configuration_set_tracking_options_error(response)
        } else {
            crate::operation_deser::parse_create_configuration_set_tracking_options_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateCustomVerificationEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_verification_email_template`](crate::client::Client::create_custom_verification_email_template).
///
/// See [`crate::client::fluent_builders::CreateCustomVerificationEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomVerificationEmailTemplate {
    _private: (),
}
impl CreateCustomVerificationEmailTemplate {
    /// Creates a new builder-style object to manufacture [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::create_custom_verification_email_template_input::Builder {
        crate::input::create_custom_verification_email_template_input::Builder::default()
    }
    /// Creates a new `CreateCustomVerificationEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomVerificationEmailTemplate {
    type Output = std::result::Result<
        crate::output::CreateCustomVerificationEmailTemplateOutput,
        crate::error::CreateCustomVerificationEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_verification_email_template_error(response)
        } else {
            crate::operation_deser::parse_create_custom_verification_email_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateReceiptFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_receipt_filter`](crate::client::Client::create_receipt_filter).
///
/// See [`crate::client::fluent_builders::CreateReceiptFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReceiptFilter {
    _private: (),
}
impl CreateReceiptFilter {
    /// Creates a new builder-style object to manufacture [`CreateReceiptFilterInput`](crate::input::CreateReceiptFilterInput)
    pub fn builder() -> crate::input::create_receipt_filter_input::Builder {
        crate::input::create_receipt_filter_input::Builder::default()
    }
    /// Creates a new `CreateReceiptFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReceiptFilter {
    type Output = std::result::Result<
        crate::output::CreateReceiptFilterOutput,
        crate::error::CreateReceiptFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_receipt_filter_error(response)
        } else {
            crate::operation_deser::parse_create_receipt_filter_response(response)
        }
    }
}

/// Operation shape for `CreateReceiptRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_receipt_rule`](crate::client::Client::create_receipt_rule).
///
/// See [`crate::client::fluent_builders::CreateReceiptRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReceiptRule {
    _private: (),
}
impl CreateReceiptRule {
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleInput`](crate::input::CreateReceiptRuleInput)
    pub fn builder() -> crate::input::create_receipt_rule_input::Builder {
        crate::input::create_receipt_rule_input::Builder::default()
    }
    /// Creates a new `CreateReceiptRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReceiptRule {
    type Output = std::result::Result<
        crate::output::CreateReceiptRuleOutput,
        crate::error::CreateReceiptRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_receipt_rule_error(response)
        } else {
            crate::operation_deser::parse_create_receipt_rule_response(response)
        }
    }
}

/// Operation shape for `CreateReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_receipt_rule_set`](crate::client::Client::create_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::CreateReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReceiptRuleSet {
    _private: (),
}
impl CreateReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleSetInput`](crate::input::CreateReceiptRuleSetInput)
    pub fn builder() -> crate::input::create_receipt_rule_set_input::Builder {
        crate::input::create_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `CreateReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::CreateReceiptRuleSetOutput,
        crate::error::CreateReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_create_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `CreateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_template`](crate::client::Client::create_template).
///
/// See [`crate::client::fluent_builders::CreateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTemplate {
    _private: (),
}
impl CreateTemplate {
    /// Creates a new builder-style object to manufacture [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    pub fn builder() -> crate::input::create_template_input::Builder {
        crate::input::create_template_input::Builder::default()
    }
    /// Creates a new `CreateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTemplate {
    type Output =
        std::result::Result<crate::output::CreateTemplateOutput, crate::error::CreateTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_template_error(response)
        } else {
            crate::operation_deser::parse_create_template_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set`](crate::client::Client::delete_configuration_set).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSet {
    _private: (),
}
impl DeleteConfigurationSet {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSet {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetOutput,
        crate::error::DeleteConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_response(response)
        }
    }
}

/// Operation shape for `DeleteConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set_event_destination`](crate::client::Client::delete_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSetEventDestination {
    _private: (),
}
impl DeleteConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::delete_configuration_set_event_destination_input::Builder {
        crate::input::delete_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetEventDestinationOutput,
        crate::error::DeleteConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_event_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteConfigurationSetTrackingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_configuration_set_tracking_options`](crate::client::Client::delete_configuration_set_tracking_options).
///
/// See [`crate::client::fluent_builders::DeleteConfigurationSetTrackingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConfigurationSetTrackingOptions {
    _private: (),
}
impl DeleteConfigurationSetTrackingOptions {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetTrackingOptionsInput`](crate::input::DeleteConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::delete_configuration_set_tracking_options_input::Builder {
        crate::input::delete_configuration_set_tracking_options_input::Builder::default()
    }
    /// Creates a new `DeleteConfigurationSetTrackingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConfigurationSetTrackingOptions {
    type Output = std::result::Result<
        crate::output::DeleteConfigurationSetTrackingOptionsOutput,
        crate::error::DeleteConfigurationSetTrackingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_configuration_set_tracking_options_error(response)
        } else {
            crate::operation_deser::parse_delete_configuration_set_tracking_options_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteCustomVerificationEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_verification_email_template`](crate::client::Client::delete_custom_verification_email_template).
///
/// See [`crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomVerificationEmailTemplate {
    _private: (),
}
impl DeleteCustomVerificationEmailTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::delete_custom_verification_email_template_input::Builder {
        crate::input::delete_custom_verification_email_template_input::Builder::default()
    }
    /// Creates a new `DeleteCustomVerificationEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomVerificationEmailTemplate {
    type Output = std::result::Result<
        crate::output::DeleteCustomVerificationEmailTemplateOutput,
        crate::error::DeleteCustomVerificationEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_verification_email_template_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_verification_email_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_identity`](crate::client::Client::delete_identity).
///
/// See [`crate::client::fluent_builders::DeleteIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIdentity {
    _private: (),
}
impl DeleteIdentity {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityInput`](crate::input::DeleteIdentityInput)
    pub fn builder() -> crate::input::delete_identity_input::Builder {
        crate::input::delete_identity_input::Builder::default()
    }
    /// Creates a new `DeleteIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIdentity {
    type Output =
        std::result::Result<crate::output::DeleteIdentityOutput, crate::error::DeleteIdentityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_identity_error(response)
        } else {
            crate::operation_deser::parse_delete_identity_response(response)
        }
    }
}

/// Operation shape for `DeleteIdentityPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_identity_policy`](crate::client::Client::delete_identity_policy).
///
/// See [`crate::client::fluent_builders::DeleteIdentityPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIdentityPolicy {
    _private: (),
}
impl DeleteIdentityPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityPolicyInput`](crate::input::DeleteIdentityPolicyInput)
    pub fn builder() -> crate::input::delete_identity_policy_input::Builder {
        crate::input::delete_identity_policy_input::Builder::default()
    }
    /// Creates a new `DeleteIdentityPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIdentityPolicy {
    type Output = std::result::Result<
        crate::output::DeleteIdentityPolicyOutput,
        crate::error::DeleteIdentityPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_identity_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_identity_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteReceiptFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_receipt_filter`](crate::client::Client::delete_receipt_filter).
///
/// See [`crate::client::fluent_builders::DeleteReceiptFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReceiptFilter {
    _private: (),
}
impl DeleteReceiptFilter {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptFilterInput`](crate::input::DeleteReceiptFilterInput)
    pub fn builder() -> crate::input::delete_receipt_filter_input::Builder {
        crate::input::delete_receipt_filter_input::Builder::default()
    }
    /// Creates a new `DeleteReceiptFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReceiptFilter {
    type Output = std::result::Result<
        crate::output::DeleteReceiptFilterOutput,
        crate::error::DeleteReceiptFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_receipt_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_receipt_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteReceiptRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_receipt_rule`](crate::client::Client::delete_receipt_rule).
///
/// See [`crate::client::fluent_builders::DeleteReceiptRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReceiptRule {
    _private: (),
}
impl DeleteReceiptRule {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleInput`](crate::input::DeleteReceiptRuleInput)
    pub fn builder() -> crate::input::delete_receipt_rule_input::Builder {
        crate::input::delete_receipt_rule_input::Builder::default()
    }
    /// Creates a new `DeleteReceiptRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReceiptRule {
    type Output = std::result::Result<
        crate::output::DeleteReceiptRuleOutput,
        crate::error::DeleteReceiptRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_receipt_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_receipt_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_receipt_rule_set`](crate::client::Client::delete_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::DeleteReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReceiptRuleSet {
    _private: (),
}
impl DeleteReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleSetInput`](crate::input::DeleteReceiptRuleSetInput)
    pub fn builder() -> crate::input::delete_receipt_rule_set_input::Builder {
        crate::input::delete_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `DeleteReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::DeleteReceiptRuleSetOutput,
        crate::error::DeleteReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_delete_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `DeleteTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_template`](crate::client::Client::delete_template).
///
/// See [`crate::client::fluent_builders::DeleteTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTemplate {
    _private: (),
}
impl DeleteTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    pub fn builder() -> crate::input::delete_template_input::Builder {
        crate::input::delete_template_input::Builder::default()
    }
    /// Creates a new `DeleteTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTemplate {
    type Output =
        std::result::Result<crate::output::DeleteTemplateOutput, crate::error::DeleteTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_template_error(response)
        } else {
            crate::operation_deser::parse_delete_template_response(response)
        }
    }
}

/// Operation shape for `DeleteVerifiedEmailAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_verified_email_address`](crate::client::Client::delete_verified_email_address).
///
/// See [`crate::client::fluent_builders::DeleteVerifiedEmailAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVerifiedEmailAddress {
    _private: (),
}
impl DeleteVerifiedEmailAddress {
    /// Creates a new builder-style object to manufacture [`DeleteVerifiedEmailAddressInput`](crate::input::DeleteVerifiedEmailAddressInput)
    pub fn builder() -> crate::input::delete_verified_email_address_input::Builder {
        crate::input::delete_verified_email_address_input::Builder::default()
    }
    /// Creates a new `DeleteVerifiedEmailAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVerifiedEmailAddress {
    type Output = std::result::Result<
        crate::output::DeleteVerifiedEmailAddressOutput,
        crate::error::DeleteVerifiedEmailAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_verified_email_address_error(response)
        } else {
            crate::operation_deser::parse_delete_verified_email_address_response(response)
        }
    }
}

/// Operation shape for `DescribeActiveReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_active_receipt_rule_set`](crate::client::Client::describe_active_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::DescribeActiveReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActiveReceiptRuleSet {
    _private: (),
}
impl DescribeActiveReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`DescribeActiveReceiptRuleSetInput`](crate::input::DescribeActiveReceiptRuleSetInput)
    pub fn builder() -> crate::input::describe_active_receipt_rule_set_input::Builder {
        crate::input::describe_active_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `DescribeActiveReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActiveReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::DescribeActiveReceiptRuleSetOutput,
        crate::error::DescribeActiveReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_active_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_describe_active_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `DescribeConfigurationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_configuration_set`](crate::client::Client::describe_configuration_set).
///
/// See [`crate::client::fluent_builders::DescribeConfigurationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConfigurationSet {
    _private: (),
}
impl DescribeConfigurationSet {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetInput`](crate::input::DescribeConfigurationSetInput)
    pub fn builder() -> crate::input::describe_configuration_set_input::Builder {
        crate::input::describe_configuration_set_input::Builder::default()
    }
    /// Creates a new `DescribeConfigurationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConfigurationSet {
    type Output = std::result::Result<
        crate::output::DescribeConfigurationSetOutput,
        crate::error::DescribeConfigurationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_configuration_set_error(response)
        } else {
            crate::operation_deser::parse_describe_configuration_set_response(response)
        }
    }
}

/// Operation shape for `DescribeReceiptRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_receipt_rule`](crate::client::Client::describe_receipt_rule).
///
/// See [`crate::client::fluent_builders::DescribeReceiptRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReceiptRule {
    _private: (),
}
impl DescribeReceiptRule {
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleInput`](crate::input::DescribeReceiptRuleInput)
    pub fn builder() -> crate::input::describe_receipt_rule_input::Builder {
        crate::input::describe_receipt_rule_input::Builder::default()
    }
    /// Creates a new `DescribeReceiptRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReceiptRule {
    type Output = std::result::Result<
        crate::output::DescribeReceiptRuleOutput,
        crate::error::DescribeReceiptRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_receipt_rule_error(response)
        } else {
            crate::operation_deser::parse_describe_receipt_rule_response(response)
        }
    }
}

/// Operation shape for `DescribeReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_receipt_rule_set`](crate::client::Client::describe_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::DescribeReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReceiptRuleSet {
    _private: (),
}
impl DescribeReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleSetInput`](crate::input::DescribeReceiptRuleSetInput)
    pub fn builder() -> crate::input::describe_receipt_rule_set_input::Builder {
        crate::input::describe_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `DescribeReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::DescribeReceiptRuleSetOutput,
        crate::error::DescribeReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_describe_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `GetAccountSendingEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_sending_enabled`](crate::client::Client::get_account_sending_enabled).
///
/// See [`crate::client::fluent_builders::GetAccountSendingEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountSendingEnabled {
    _private: (),
}
impl GetAccountSendingEnabled {
    /// Creates a new builder-style object to manufacture [`GetAccountSendingEnabledInput`](crate::input::GetAccountSendingEnabledInput)
    pub fn builder() -> crate::input::get_account_sending_enabled_input::Builder {
        crate::input::get_account_sending_enabled_input::Builder::default()
    }
    /// Creates a new `GetAccountSendingEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountSendingEnabled {
    type Output = std::result::Result<
        crate::output::GetAccountSendingEnabledOutput,
        crate::error::GetAccountSendingEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_sending_enabled_error(response)
        } else {
            crate::operation_deser::parse_get_account_sending_enabled_response(response)
        }
    }
}

/// Operation shape for `GetCustomVerificationEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_custom_verification_email_template`](crate::client::Client::get_custom_verification_email_template).
///
/// See [`crate::client::fluent_builders::GetCustomVerificationEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCustomVerificationEmailTemplate {
    _private: (),
}
impl GetCustomVerificationEmailTemplate {
    /// Creates a new builder-style object to manufacture [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::get_custom_verification_email_template_input::Builder {
        crate::input::get_custom_verification_email_template_input::Builder::default()
    }
    /// Creates a new `GetCustomVerificationEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCustomVerificationEmailTemplate {
    type Output = std::result::Result<
        crate::output::GetCustomVerificationEmailTemplateOutput,
        crate::error::GetCustomVerificationEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_custom_verification_email_template_error(response)
        } else {
            crate::operation_deser::parse_get_custom_verification_email_template_response(response)
        }
    }
}

/// Operation shape for `GetIdentityDkimAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_dkim_attributes`](crate::client::Client::get_identity_dkim_attributes).
///
/// See [`crate::client::fluent_builders::GetIdentityDkimAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityDkimAttributes {
    _private: (),
}
impl GetIdentityDkimAttributes {
    /// Creates a new builder-style object to manufacture [`GetIdentityDkimAttributesInput`](crate::input::GetIdentityDkimAttributesInput)
    pub fn builder() -> crate::input::get_identity_dkim_attributes_input::Builder {
        crate::input::get_identity_dkim_attributes_input::Builder::default()
    }
    /// Creates a new `GetIdentityDkimAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityDkimAttributes {
    type Output = std::result::Result<
        crate::output::GetIdentityDkimAttributesOutput,
        crate::error::GetIdentityDkimAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_dkim_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_identity_dkim_attributes_response(response)
        }
    }
}

/// Operation shape for `GetIdentityMailFromDomainAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_mail_from_domain_attributes`](crate::client::Client::get_identity_mail_from_domain_attributes).
///
/// See [`crate::client::fluent_builders::GetIdentityMailFromDomainAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityMailFromDomainAttributes {
    _private: (),
}
impl GetIdentityMailFromDomainAttributes {
    /// Creates a new builder-style object to manufacture [`GetIdentityMailFromDomainAttributesInput`](crate::input::GetIdentityMailFromDomainAttributesInput)
    pub fn builder() -> crate::input::get_identity_mail_from_domain_attributes_input::Builder {
        crate::input::get_identity_mail_from_domain_attributes_input::Builder::default()
    }
    /// Creates a new `GetIdentityMailFromDomainAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityMailFromDomainAttributes {
    type Output = std::result::Result<
        crate::output::GetIdentityMailFromDomainAttributesOutput,
        crate::error::GetIdentityMailFromDomainAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_mail_from_domain_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_identity_mail_from_domain_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetIdentityNotificationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_notification_attributes`](crate::client::Client::get_identity_notification_attributes).
///
/// See [`crate::client::fluent_builders::GetIdentityNotificationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityNotificationAttributes {
    _private: (),
}
impl GetIdentityNotificationAttributes {
    /// Creates a new builder-style object to manufacture [`GetIdentityNotificationAttributesInput`](crate::input::GetIdentityNotificationAttributesInput)
    pub fn builder() -> crate::input::get_identity_notification_attributes_input::Builder {
        crate::input::get_identity_notification_attributes_input::Builder::default()
    }
    /// Creates a new `GetIdentityNotificationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityNotificationAttributes {
    type Output = std::result::Result<
        crate::output::GetIdentityNotificationAttributesOutput,
        crate::error::GetIdentityNotificationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_notification_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_identity_notification_attributes_response(response)
        }
    }
}

/// Operation shape for `GetIdentityPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_policies`](crate::client::Client::get_identity_policies).
///
/// See [`crate::client::fluent_builders::GetIdentityPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityPolicies {
    _private: (),
}
impl GetIdentityPolicies {
    /// Creates a new builder-style object to manufacture [`GetIdentityPoliciesInput`](crate::input::GetIdentityPoliciesInput)
    pub fn builder() -> crate::input::get_identity_policies_input::Builder {
        crate::input::get_identity_policies_input::Builder::default()
    }
    /// Creates a new `GetIdentityPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityPolicies {
    type Output = std::result::Result<
        crate::output::GetIdentityPoliciesOutput,
        crate::error::GetIdentityPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_policies_error(response)
        } else {
            crate::operation_deser::parse_get_identity_policies_response(response)
        }
    }
}

/// Operation shape for `GetIdentityVerificationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_identity_verification_attributes`](crate::client::Client::get_identity_verification_attributes).
///
/// See [`crate::client::fluent_builders::GetIdentityVerificationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIdentityVerificationAttributes {
    _private: (),
}
impl GetIdentityVerificationAttributes {
    /// Creates a new builder-style object to manufacture [`GetIdentityVerificationAttributesInput`](crate::input::GetIdentityVerificationAttributesInput)
    pub fn builder() -> crate::input::get_identity_verification_attributes_input::Builder {
        crate::input::get_identity_verification_attributes_input::Builder::default()
    }
    /// Creates a new `GetIdentityVerificationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIdentityVerificationAttributes {
    type Output = std::result::Result<
        crate::output::GetIdentityVerificationAttributesOutput,
        crate::error::GetIdentityVerificationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_identity_verification_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_identity_verification_attributes_response(response)
        }
    }
}

/// Operation shape for `GetSendQuota`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_send_quota`](crate::client::Client::get_send_quota).
///
/// See [`crate::client::fluent_builders::GetSendQuota`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSendQuota {
    _private: (),
}
impl GetSendQuota {
    /// Creates a new builder-style object to manufacture [`GetSendQuotaInput`](crate::input::GetSendQuotaInput)
    pub fn builder() -> crate::input::get_send_quota_input::Builder {
        crate::input::get_send_quota_input::Builder::default()
    }
    /// Creates a new `GetSendQuota` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSendQuota {
    type Output =
        std::result::Result<crate::output::GetSendQuotaOutput, crate::error::GetSendQuotaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_send_quota_error(response)
        } else {
            crate::operation_deser::parse_get_send_quota_response(response)
        }
    }
}

/// Operation shape for `GetSendStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_send_statistics`](crate::client::Client::get_send_statistics).
///
/// See [`crate::client::fluent_builders::GetSendStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSendStatistics {
    _private: (),
}
impl GetSendStatistics {
    /// Creates a new builder-style object to manufacture [`GetSendStatisticsInput`](crate::input::GetSendStatisticsInput)
    pub fn builder() -> crate::input::get_send_statistics_input::Builder {
        crate::input::get_send_statistics_input::Builder::default()
    }
    /// Creates a new `GetSendStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSendStatistics {
    type Output = std::result::Result<
        crate::output::GetSendStatisticsOutput,
        crate::error::GetSendStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_send_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_send_statistics_response(response)
        }
    }
}

/// Operation shape for `GetTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_template`](crate::client::Client::get_template).
///
/// See [`crate::client::fluent_builders::GetTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTemplate {
    _private: (),
}
impl GetTemplate {
    /// Creates a new builder-style object to manufacture [`GetTemplateInput`](crate::input::GetTemplateInput)
    pub fn builder() -> crate::input::get_template_input::Builder {
        crate::input::get_template_input::Builder::default()
    }
    /// Creates a new `GetTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTemplate {
    type Output =
        std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_template_error(response)
        } else {
            crate::operation_deser::parse_get_template_response(response)
        }
    }
}

/// Operation shape for `ListConfigurationSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_configuration_sets`](crate::client::Client::list_configuration_sets).
///
/// See [`crate::client::fluent_builders::ListConfigurationSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConfigurationSets {
    _private: (),
}
impl ListConfigurationSets {
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    pub fn builder() -> crate::input::list_configuration_sets_input::Builder {
        crate::input::list_configuration_sets_input::Builder::default()
    }
    /// Creates a new `ListConfigurationSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConfigurationSets {
    type Output = std::result::Result<
        crate::output::ListConfigurationSetsOutput,
        crate::error::ListConfigurationSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_configuration_sets_error(response)
        } else {
            crate::operation_deser::parse_list_configuration_sets_response(response)
        }
    }
}

/// Operation shape for `ListCustomVerificationEmailTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_verification_email_templates`](crate::client::Client::list_custom_verification_email_templates).
///
/// See [`crate::client::fluent_builders::ListCustomVerificationEmailTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomVerificationEmailTemplates {
    _private: (),
}
impl ListCustomVerificationEmailTemplates {
    /// Creates a new builder-style object to manufacture [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
    pub fn builder() -> crate::input::list_custom_verification_email_templates_input::Builder {
        crate::input::list_custom_verification_email_templates_input::Builder::default()
    }
    /// Creates a new `ListCustomVerificationEmailTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomVerificationEmailTemplates {
    type Output = std::result::Result<
        crate::output::ListCustomVerificationEmailTemplatesOutput,
        crate::error::ListCustomVerificationEmailTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_verification_email_templates_error(response)
        } else {
            crate::operation_deser::parse_list_custom_verification_email_templates_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListIdentities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_identities`](crate::client::Client::list_identities).
///
/// See [`crate::client::fluent_builders::ListIdentities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIdentities {
    _private: (),
}
impl ListIdentities {
    /// Creates a new builder-style object to manufacture [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
    pub fn builder() -> crate::input::list_identities_input::Builder {
        crate::input::list_identities_input::Builder::default()
    }
    /// Creates a new `ListIdentities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIdentities {
    type Output =
        std::result::Result<crate::output::ListIdentitiesOutput, crate::error::ListIdentitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_identities_error(response)
        } else {
            crate::operation_deser::parse_list_identities_response(response)
        }
    }
}

/// Operation shape for `ListIdentityPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_identity_policies`](crate::client::Client::list_identity_policies).
///
/// See [`crate::client::fluent_builders::ListIdentityPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIdentityPolicies {
    _private: (),
}
impl ListIdentityPolicies {
    /// Creates a new builder-style object to manufacture [`ListIdentityPoliciesInput`](crate::input::ListIdentityPoliciesInput)
    pub fn builder() -> crate::input::list_identity_policies_input::Builder {
        crate::input::list_identity_policies_input::Builder::default()
    }
    /// Creates a new `ListIdentityPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIdentityPolicies {
    type Output = std::result::Result<
        crate::output::ListIdentityPoliciesOutput,
        crate::error::ListIdentityPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_identity_policies_error(response)
        } else {
            crate::operation_deser::parse_list_identity_policies_response(response)
        }
    }
}

/// Operation shape for `ListReceiptFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_receipt_filters`](crate::client::Client::list_receipt_filters).
///
/// See [`crate::client::fluent_builders::ListReceiptFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReceiptFilters {
    _private: (),
}
impl ListReceiptFilters {
    /// Creates a new builder-style object to manufacture [`ListReceiptFiltersInput`](crate::input::ListReceiptFiltersInput)
    pub fn builder() -> crate::input::list_receipt_filters_input::Builder {
        crate::input::list_receipt_filters_input::Builder::default()
    }
    /// Creates a new `ListReceiptFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReceiptFilters {
    type Output = std::result::Result<
        crate::output::ListReceiptFiltersOutput,
        crate::error::ListReceiptFiltersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_receipt_filters_error(response)
        } else {
            crate::operation_deser::parse_list_receipt_filters_response(response)
        }
    }
}

/// Operation shape for `ListReceiptRuleSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_receipt_rule_sets`](crate::client::Client::list_receipt_rule_sets).
///
/// See [`crate::client::fluent_builders::ListReceiptRuleSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReceiptRuleSets {
    _private: (),
}
impl ListReceiptRuleSets {
    /// Creates a new builder-style object to manufacture [`ListReceiptRuleSetsInput`](crate::input::ListReceiptRuleSetsInput)
    pub fn builder() -> crate::input::list_receipt_rule_sets_input::Builder {
        crate::input::list_receipt_rule_sets_input::Builder::default()
    }
    /// Creates a new `ListReceiptRuleSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReceiptRuleSets {
    type Output = std::result::Result<
        crate::output::ListReceiptRuleSetsOutput,
        crate::error::ListReceiptRuleSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_receipt_rule_sets_error(response)
        } else {
            crate::operation_deser::parse_list_receipt_rule_sets_response(response)
        }
    }
}

/// Operation shape for `ListTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_templates`](crate::client::Client::list_templates).
///
/// See [`crate::client::fluent_builders::ListTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTemplates {
    _private: (),
}
impl ListTemplates {
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
    /// Creates a new `ListTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTemplates {
    type Output =
        std::result::Result<crate::output::ListTemplatesOutput, crate::error::ListTemplatesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_templates_error(response)
        } else {
            crate::operation_deser::parse_list_templates_response(response)
        }
    }
}

/// Operation shape for `ListVerifiedEmailAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_verified_email_addresses`](crate::client::Client::list_verified_email_addresses).
///
/// See [`crate::client::fluent_builders::ListVerifiedEmailAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVerifiedEmailAddresses {
    _private: (),
}
impl ListVerifiedEmailAddresses {
    /// Creates a new builder-style object to manufacture [`ListVerifiedEmailAddressesInput`](crate::input::ListVerifiedEmailAddressesInput)
    pub fn builder() -> crate::input::list_verified_email_addresses_input::Builder {
        crate::input::list_verified_email_addresses_input::Builder::default()
    }
    /// Creates a new `ListVerifiedEmailAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVerifiedEmailAddresses {
    type Output = std::result::Result<
        crate::output::ListVerifiedEmailAddressesOutput,
        crate::error::ListVerifiedEmailAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_verified_email_addresses_error(response)
        } else {
            crate::operation_deser::parse_list_verified_email_addresses_response(response)
        }
    }
}

/// Operation shape for `PutConfigurationSetDeliveryOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_configuration_set_delivery_options`](crate::client::Client::put_configuration_set_delivery_options).
///
/// See [`crate::client::fluent_builders::PutConfigurationSetDeliveryOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutConfigurationSetDeliveryOptions {
    _private: (),
}
impl PutConfigurationSetDeliveryOptions {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_delivery_options_input::Builder {
        crate::input::put_configuration_set_delivery_options_input::Builder::default()
    }
    /// Creates a new `PutConfigurationSetDeliveryOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutConfigurationSetDeliveryOptions {
    type Output = std::result::Result<
        crate::output::PutConfigurationSetDeliveryOptionsOutput,
        crate::error::PutConfigurationSetDeliveryOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_configuration_set_delivery_options_error(response)
        } else {
            crate::operation_deser::parse_put_configuration_set_delivery_options_response(response)
        }
    }
}

/// Operation shape for `PutIdentityPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_identity_policy`](crate::client::Client::put_identity_policy).
///
/// See [`crate::client::fluent_builders::PutIdentityPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutIdentityPolicy {
    _private: (),
}
impl PutIdentityPolicy {
    /// Creates a new builder-style object to manufacture [`PutIdentityPolicyInput`](crate::input::PutIdentityPolicyInput)
    pub fn builder() -> crate::input::put_identity_policy_input::Builder {
        crate::input::put_identity_policy_input::Builder::default()
    }
    /// Creates a new `PutIdentityPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutIdentityPolicy {
    type Output = std::result::Result<
        crate::output::PutIdentityPolicyOutput,
        crate::error::PutIdentityPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_identity_policy_error(response)
        } else {
            crate::operation_deser::parse_put_identity_policy_response(response)
        }
    }
}

/// Operation shape for `ReorderReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reorder_receipt_rule_set`](crate::client::Client::reorder_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::ReorderReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReorderReceiptRuleSet {
    _private: (),
}
impl ReorderReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`ReorderReceiptRuleSetInput`](crate::input::ReorderReceiptRuleSetInput)
    pub fn builder() -> crate::input::reorder_receipt_rule_set_input::Builder {
        crate::input::reorder_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `ReorderReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReorderReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::ReorderReceiptRuleSetOutput,
        crate::error::ReorderReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reorder_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_reorder_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `SendBounce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_bounce`](crate::client::Client::send_bounce).
///
/// See [`crate::client::fluent_builders::SendBounce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendBounce {
    _private: (),
}
impl SendBounce {
    /// Creates a new builder-style object to manufacture [`SendBounceInput`](crate::input::SendBounceInput)
    pub fn builder() -> crate::input::send_bounce_input::Builder {
        crate::input::send_bounce_input::Builder::default()
    }
    /// Creates a new `SendBounce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendBounce {
    type Output =
        std::result::Result<crate::output::SendBounceOutput, crate::error::SendBounceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_bounce_error(response)
        } else {
            crate::operation_deser::parse_send_bounce_response(response)
        }
    }
}

/// Operation shape for `SendBulkTemplatedEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_bulk_templated_email`](crate::client::Client::send_bulk_templated_email).
///
/// See [`crate::client::fluent_builders::SendBulkTemplatedEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendBulkTemplatedEmail {
    _private: (),
}
impl SendBulkTemplatedEmail {
    /// Creates a new builder-style object to manufacture [`SendBulkTemplatedEmailInput`](crate::input::SendBulkTemplatedEmailInput)
    pub fn builder() -> crate::input::send_bulk_templated_email_input::Builder {
        crate::input::send_bulk_templated_email_input::Builder::default()
    }
    /// Creates a new `SendBulkTemplatedEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendBulkTemplatedEmail {
    type Output = std::result::Result<
        crate::output::SendBulkTemplatedEmailOutput,
        crate::error::SendBulkTemplatedEmailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_bulk_templated_email_error(response)
        } else {
            crate::operation_deser::parse_send_bulk_templated_email_response(response)
        }
    }
}

/// Operation shape for `SendCustomVerificationEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_custom_verification_email`](crate::client::Client::send_custom_verification_email).
///
/// See [`crate::client::fluent_builders::SendCustomVerificationEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendCustomVerificationEmail {
    _private: (),
}
impl SendCustomVerificationEmail {
    /// Creates a new builder-style object to manufacture [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
    pub fn builder() -> crate::input::send_custom_verification_email_input::Builder {
        crate::input::send_custom_verification_email_input::Builder::default()
    }
    /// Creates a new `SendCustomVerificationEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendCustomVerificationEmail {
    type Output = std::result::Result<
        crate::output::SendCustomVerificationEmailOutput,
        crate::error::SendCustomVerificationEmailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_custom_verification_email_error(response)
        } else {
            crate::operation_deser::parse_send_custom_verification_email_response(response)
        }
    }
}

/// Operation shape for `SendEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_email`](crate::client::Client::send_email).
///
/// See [`crate::client::fluent_builders::SendEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendEmail {
    _private: (),
}
impl SendEmail {
    /// Creates a new builder-style object to manufacture [`SendEmailInput`](crate::input::SendEmailInput)
    pub fn builder() -> crate::input::send_email_input::Builder {
        crate::input::send_email_input::Builder::default()
    }
    /// Creates a new `SendEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendEmail {
    type Output = std::result::Result<crate::output::SendEmailOutput, crate::error::SendEmailError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_email_error(response)
        } else {
            crate::operation_deser::parse_send_email_response(response)
        }
    }
}

/// Operation shape for `SendRawEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_raw_email`](crate::client::Client::send_raw_email).
///
/// See [`crate::client::fluent_builders::SendRawEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendRawEmail {
    _private: (),
}
impl SendRawEmail {
    /// Creates a new builder-style object to manufacture [`SendRawEmailInput`](crate::input::SendRawEmailInput)
    pub fn builder() -> crate::input::send_raw_email_input::Builder {
        crate::input::send_raw_email_input::Builder::default()
    }
    /// Creates a new `SendRawEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendRawEmail {
    type Output =
        std::result::Result<crate::output::SendRawEmailOutput, crate::error::SendRawEmailError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_raw_email_error(response)
        } else {
            crate::operation_deser::parse_send_raw_email_response(response)
        }
    }
}

/// Operation shape for `SendTemplatedEmail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_templated_email`](crate::client::Client::send_templated_email).
///
/// See [`crate::client::fluent_builders::SendTemplatedEmail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendTemplatedEmail {
    _private: (),
}
impl SendTemplatedEmail {
    /// Creates a new builder-style object to manufacture [`SendTemplatedEmailInput`](crate::input::SendTemplatedEmailInput)
    pub fn builder() -> crate::input::send_templated_email_input::Builder {
        crate::input::send_templated_email_input::Builder::default()
    }
    /// Creates a new `SendTemplatedEmail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendTemplatedEmail {
    type Output = std::result::Result<
        crate::output::SendTemplatedEmailOutput,
        crate::error::SendTemplatedEmailError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_templated_email_error(response)
        } else {
            crate::operation_deser::parse_send_templated_email_response(response)
        }
    }
}

/// Operation shape for `SetActiveReceiptRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_active_receipt_rule_set`](crate::client::Client::set_active_receipt_rule_set).
///
/// See [`crate::client::fluent_builders::SetActiveReceiptRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetActiveReceiptRuleSet {
    _private: (),
}
impl SetActiveReceiptRuleSet {
    /// Creates a new builder-style object to manufacture [`SetActiveReceiptRuleSetInput`](crate::input::SetActiveReceiptRuleSetInput)
    pub fn builder() -> crate::input::set_active_receipt_rule_set_input::Builder {
        crate::input::set_active_receipt_rule_set_input::Builder::default()
    }
    /// Creates a new `SetActiveReceiptRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetActiveReceiptRuleSet {
    type Output = std::result::Result<
        crate::output::SetActiveReceiptRuleSetOutput,
        crate::error::SetActiveReceiptRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_active_receipt_rule_set_error(response)
        } else {
            crate::operation_deser::parse_set_active_receipt_rule_set_response(response)
        }
    }
}

/// Operation shape for `SetIdentityDkimEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_identity_dkim_enabled`](crate::client::Client::set_identity_dkim_enabled).
///
/// See [`crate::client::fluent_builders::SetIdentityDkimEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIdentityDkimEnabled {
    _private: (),
}
impl SetIdentityDkimEnabled {
    /// Creates a new builder-style object to manufacture [`SetIdentityDkimEnabledInput`](crate::input::SetIdentityDkimEnabledInput)
    pub fn builder() -> crate::input::set_identity_dkim_enabled_input::Builder {
        crate::input::set_identity_dkim_enabled_input::Builder::default()
    }
    /// Creates a new `SetIdentityDkimEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIdentityDkimEnabled {
    type Output = std::result::Result<
        crate::output::SetIdentityDkimEnabledOutput,
        crate::error::SetIdentityDkimEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_identity_dkim_enabled_error(response)
        } else {
            crate::operation_deser::parse_set_identity_dkim_enabled_response(response)
        }
    }
}

/// Operation shape for `SetIdentityFeedbackForwardingEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_identity_feedback_forwarding_enabled`](crate::client::Client::set_identity_feedback_forwarding_enabled).
///
/// See [`crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIdentityFeedbackForwardingEnabled {
    _private: (),
}
impl SetIdentityFeedbackForwardingEnabled {
    /// Creates a new builder-style object to manufacture [`SetIdentityFeedbackForwardingEnabledInput`](crate::input::SetIdentityFeedbackForwardingEnabledInput)
    pub fn builder() -> crate::input::set_identity_feedback_forwarding_enabled_input::Builder {
        crate::input::set_identity_feedback_forwarding_enabled_input::Builder::default()
    }
    /// Creates a new `SetIdentityFeedbackForwardingEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIdentityFeedbackForwardingEnabled {
    type Output = std::result::Result<
        crate::output::SetIdentityFeedbackForwardingEnabledOutput,
        crate::error::SetIdentityFeedbackForwardingEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_identity_feedback_forwarding_enabled_error(response)
        } else {
            crate::operation_deser::parse_set_identity_feedback_forwarding_enabled_response(
                response,
            )
        }
    }
}

/// Operation shape for `SetIdentityHeadersInNotificationsEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_identity_headers_in_notifications_enabled`](crate::client::Client::set_identity_headers_in_notifications_enabled).
///
/// See [`crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIdentityHeadersInNotificationsEnabled {
    _private: (),
}
impl SetIdentityHeadersInNotificationsEnabled {
    /// Creates a new builder-style object to manufacture [`SetIdentityHeadersInNotificationsEnabledInput`](crate::input::SetIdentityHeadersInNotificationsEnabledInput)
    pub fn builder() -> crate::input::set_identity_headers_in_notifications_enabled_input::Builder {
        crate::input::set_identity_headers_in_notifications_enabled_input::Builder::default()
    }
    /// Creates a new `SetIdentityHeadersInNotificationsEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIdentityHeadersInNotificationsEnabled {
    type Output = std::result::Result<
        crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
        crate::error::SetIdentityHeadersInNotificationsEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_identity_headers_in_notifications_enabled_error(
                response,
            )
        } else {
            crate::operation_deser::parse_set_identity_headers_in_notifications_enabled_response(
                response,
            )
        }
    }
}

/// Operation shape for `SetIdentityMailFromDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_identity_mail_from_domain`](crate::client::Client::set_identity_mail_from_domain).
///
/// See [`crate::client::fluent_builders::SetIdentityMailFromDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIdentityMailFromDomain {
    _private: (),
}
impl SetIdentityMailFromDomain {
    /// Creates a new builder-style object to manufacture [`SetIdentityMailFromDomainInput`](crate::input::SetIdentityMailFromDomainInput)
    pub fn builder() -> crate::input::set_identity_mail_from_domain_input::Builder {
        crate::input::set_identity_mail_from_domain_input::Builder::default()
    }
    /// Creates a new `SetIdentityMailFromDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIdentityMailFromDomain {
    type Output = std::result::Result<
        crate::output::SetIdentityMailFromDomainOutput,
        crate::error::SetIdentityMailFromDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_identity_mail_from_domain_error(response)
        } else {
            crate::operation_deser::parse_set_identity_mail_from_domain_response(response)
        }
    }
}

/// Operation shape for `SetIdentityNotificationTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_identity_notification_topic`](crate::client::Client::set_identity_notification_topic).
///
/// See [`crate::client::fluent_builders::SetIdentityNotificationTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIdentityNotificationTopic {
    _private: (),
}
impl SetIdentityNotificationTopic {
    /// Creates a new builder-style object to manufacture [`SetIdentityNotificationTopicInput`](crate::input::SetIdentityNotificationTopicInput)
    pub fn builder() -> crate::input::set_identity_notification_topic_input::Builder {
        crate::input::set_identity_notification_topic_input::Builder::default()
    }
    /// Creates a new `SetIdentityNotificationTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIdentityNotificationTopic {
    type Output = std::result::Result<
        crate::output::SetIdentityNotificationTopicOutput,
        crate::error::SetIdentityNotificationTopicError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_identity_notification_topic_error(response)
        } else {
            crate::operation_deser::parse_set_identity_notification_topic_response(response)
        }
    }
}

/// Operation shape for `SetReceiptRulePosition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_receipt_rule_position`](crate::client::Client::set_receipt_rule_position).
///
/// See [`crate::client::fluent_builders::SetReceiptRulePosition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetReceiptRulePosition {
    _private: (),
}
impl SetReceiptRulePosition {
    /// Creates a new builder-style object to manufacture [`SetReceiptRulePositionInput`](crate::input::SetReceiptRulePositionInput)
    pub fn builder() -> crate::input::set_receipt_rule_position_input::Builder {
        crate::input::set_receipt_rule_position_input::Builder::default()
    }
    /// Creates a new `SetReceiptRulePosition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetReceiptRulePosition {
    type Output = std::result::Result<
        crate::output::SetReceiptRulePositionOutput,
        crate::error::SetReceiptRulePositionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_receipt_rule_position_error(response)
        } else {
            crate::operation_deser::parse_set_receipt_rule_position_response(response)
        }
    }
}

/// Operation shape for `TestRenderTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_render_template`](crate::client::Client::test_render_template).
///
/// See [`crate::client::fluent_builders::TestRenderTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestRenderTemplate {
    _private: (),
}
impl TestRenderTemplate {
    /// Creates a new builder-style object to manufacture [`TestRenderTemplateInput`](crate::input::TestRenderTemplateInput)
    pub fn builder() -> crate::input::test_render_template_input::Builder {
        crate::input::test_render_template_input::Builder::default()
    }
    /// Creates a new `TestRenderTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestRenderTemplate {
    type Output = std::result::Result<
        crate::output::TestRenderTemplateOutput,
        crate::error::TestRenderTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_render_template_error(response)
        } else {
            crate::operation_deser::parse_test_render_template_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountSendingEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_sending_enabled`](crate::client::Client::update_account_sending_enabled).
///
/// See [`crate::client::fluent_builders::UpdateAccountSendingEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountSendingEnabled {
    _private: (),
}
impl UpdateAccountSendingEnabled {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSendingEnabledInput`](crate::input::UpdateAccountSendingEnabledInput)
    pub fn builder() -> crate::input::update_account_sending_enabled_input::Builder {
        crate::input::update_account_sending_enabled_input::Builder::default()
    }
    /// Creates a new `UpdateAccountSendingEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountSendingEnabled {
    type Output = std::result::Result<
        crate::output::UpdateAccountSendingEnabledOutput,
        crate::error::UpdateAccountSendingEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_sending_enabled_error(response)
        } else {
            crate::operation_deser::parse_update_account_sending_enabled_response(response)
        }
    }
}

/// Operation shape for `UpdateConfigurationSetEventDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_set_event_destination`](crate::client::Client::update_configuration_set_event_destination).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationSetEventDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationSetEventDestination {
    _private: (),
}
impl UpdateConfigurationSetEventDestination {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::update_configuration_set_event_destination_input::Builder {
        crate::input::update_configuration_set_event_destination_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationSetEventDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationSetEventDestination {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationSetEventDestinationOutput,
        crate::error::UpdateConfigurationSetEventDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_set_event_destination_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_set_event_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateConfigurationSetReputationMetricsEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_set_reputation_metrics_enabled`](crate::client::Client::update_configuration_set_reputation_metrics_enabled).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationSetReputationMetricsEnabled {
    _private: (),
}
impl UpdateConfigurationSetReputationMetricsEnabled {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetReputationMetricsEnabledInput`](crate::input::UpdateConfigurationSetReputationMetricsEnabledInput)
    pub fn builder(
    ) -> crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder {
        crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationSetReputationMetricsEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for UpdateConfigurationSetReputationMetricsEnabled
{
    type Output = std::result::Result<
        crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput,
        crate::error::UpdateConfigurationSetReputationMetricsEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_set_reputation_metrics_enabled_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_configuration_set_reputation_metrics_enabled_response(response)
        }
    }
}

/// Operation shape for `UpdateConfigurationSetSendingEnabled`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_set_sending_enabled`](crate::client::Client::update_configuration_set_sending_enabled).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationSetSendingEnabled {
    _private: (),
}
impl UpdateConfigurationSetSendingEnabled {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetSendingEnabledInput`](crate::input::UpdateConfigurationSetSendingEnabledInput)
    pub fn builder() -> crate::input::update_configuration_set_sending_enabled_input::Builder {
        crate::input::update_configuration_set_sending_enabled_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationSetSendingEnabled` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationSetSendingEnabled {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationSetSendingEnabledOutput,
        crate::error::UpdateConfigurationSetSendingEnabledError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_set_sending_enabled_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_set_sending_enabled_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateConfigurationSetTrackingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_configuration_set_tracking_options`](crate::client::Client::update_configuration_set_tracking_options).
///
/// See [`crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConfigurationSetTrackingOptions {
    _private: (),
}
impl UpdateConfigurationSetTrackingOptions {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetTrackingOptionsInput`](crate::input::UpdateConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::update_configuration_set_tracking_options_input::Builder {
        crate::input::update_configuration_set_tracking_options_input::Builder::default()
    }
    /// Creates a new `UpdateConfigurationSetTrackingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConfigurationSetTrackingOptions {
    type Output = std::result::Result<
        crate::output::UpdateConfigurationSetTrackingOptionsOutput,
        crate::error::UpdateConfigurationSetTrackingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_configuration_set_tracking_options_error(response)
        } else {
            crate::operation_deser::parse_update_configuration_set_tracking_options_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateCustomVerificationEmailTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_verification_email_template`](crate::client::Client::update_custom_verification_email_template).
///
/// See [`crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomVerificationEmailTemplate {
    _private: (),
}
impl UpdateCustomVerificationEmailTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::update_custom_verification_email_template_input::Builder {
        crate::input::update_custom_verification_email_template_input::Builder::default()
    }
    /// Creates a new `UpdateCustomVerificationEmailTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomVerificationEmailTemplate {
    type Output = std::result::Result<
        crate::output::UpdateCustomVerificationEmailTemplateOutput,
        crate::error::UpdateCustomVerificationEmailTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_verification_email_template_error(response)
        } else {
            crate::operation_deser::parse_update_custom_verification_email_template_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateReceiptRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_receipt_rule`](crate::client::Client::update_receipt_rule).
///
/// See [`crate::client::fluent_builders::UpdateReceiptRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReceiptRule {
    _private: (),
}
impl UpdateReceiptRule {
    /// Creates a new builder-style object to manufacture [`UpdateReceiptRuleInput`](crate::input::UpdateReceiptRuleInput)
    pub fn builder() -> crate::input::update_receipt_rule_input::Builder {
        crate::input::update_receipt_rule_input::Builder::default()
    }
    /// Creates a new `UpdateReceiptRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReceiptRule {
    type Output = std::result::Result<
        crate::output::UpdateReceiptRuleOutput,
        crate::error::UpdateReceiptRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_receipt_rule_error(response)
        } else {
            crate::operation_deser::parse_update_receipt_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_template`](crate::client::Client::update_template).
///
/// See [`crate::client::fluent_builders::UpdateTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTemplate {
    _private: (),
}
impl UpdateTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
    pub fn builder() -> crate::input::update_template_input::Builder {
        crate::input::update_template_input::Builder::default()
    }
    /// Creates a new `UpdateTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTemplate {
    type Output =
        std::result::Result<crate::output::UpdateTemplateOutput, crate::error::UpdateTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_template_error(response)
        } else {
            crate::operation_deser::parse_update_template_response(response)
        }
    }
}

/// Operation shape for `VerifyDomainDkim`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_domain_dkim`](crate::client::Client::verify_domain_dkim).
///
/// See [`crate::client::fluent_builders::VerifyDomainDkim`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyDomainDkim {
    _private: (),
}
impl VerifyDomainDkim {
    /// Creates a new builder-style object to manufacture [`VerifyDomainDkimInput`](crate::input::VerifyDomainDkimInput)
    pub fn builder() -> crate::input::verify_domain_dkim_input::Builder {
        crate::input::verify_domain_dkim_input::Builder::default()
    }
    /// Creates a new `VerifyDomainDkim` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyDomainDkim {
    type Output = std::result::Result<
        crate::output::VerifyDomainDkimOutput,
        crate::error::VerifyDomainDkimError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_domain_dkim_error(response)
        } else {
            crate::operation_deser::parse_verify_domain_dkim_response(response)
        }
    }
}

/// Operation shape for `VerifyDomainIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_domain_identity`](crate::client::Client::verify_domain_identity).
///
/// See [`crate::client::fluent_builders::VerifyDomainIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyDomainIdentity {
    _private: (),
}
impl VerifyDomainIdentity {
    /// Creates a new builder-style object to manufacture [`VerifyDomainIdentityInput`](crate::input::VerifyDomainIdentityInput)
    pub fn builder() -> crate::input::verify_domain_identity_input::Builder {
        crate::input::verify_domain_identity_input::Builder::default()
    }
    /// Creates a new `VerifyDomainIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyDomainIdentity {
    type Output = std::result::Result<
        crate::output::VerifyDomainIdentityOutput,
        crate::error::VerifyDomainIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_domain_identity_error(response)
        } else {
            crate::operation_deser::parse_verify_domain_identity_response(response)
        }
    }
}

/// Operation shape for `VerifyEmailAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_email_address`](crate::client::Client::verify_email_address).
///
/// See [`crate::client::fluent_builders::VerifyEmailAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyEmailAddress {
    _private: (),
}
impl VerifyEmailAddress {
    /// Creates a new builder-style object to manufacture [`VerifyEmailAddressInput`](crate::input::VerifyEmailAddressInput)
    pub fn builder() -> crate::input::verify_email_address_input::Builder {
        crate::input::verify_email_address_input::Builder::default()
    }
    /// Creates a new `VerifyEmailAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyEmailAddress {
    type Output = std::result::Result<
        crate::output::VerifyEmailAddressOutput,
        crate::error::VerifyEmailAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_email_address_error(response)
        } else {
            crate::operation_deser::parse_verify_email_address_response(response)
        }
    }
}

/// Operation shape for `VerifyEmailIdentity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_email_identity`](crate::client::Client::verify_email_identity).
///
/// See [`crate::client::fluent_builders::VerifyEmailIdentity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifyEmailIdentity {
    _private: (),
}
impl VerifyEmailIdentity {
    /// Creates a new builder-style object to manufacture [`VerifyEmailIdentityInput`](crate::input::VerifyEmailIdentityInput)
    pub fn builder() -> crate::input::verify_email_identity_input::Builder {
        crate::input::verify_email_identity_input::Builder::default()
    }
    /// Creates a new `VerifyEmailIdentity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifyEmailIdentity {
    type Output = std::result::Result<
        crate::output::VerifyEmailIdentityOutput,
        crate::error::VerifyEmailIdentityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_email_identity_error(response)
        } else {
            crate::operation_deser::parse_verify_email_identity_response(response)
        }
    }
}
