// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
/// part.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Template {
    /// <p>The name of the template. You will refer to this name when you send email using the
    /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code>
    /// operations.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The subject line of the email.</p>
    pub subject_part: std::option::Option<std::string::String>,
    /// <p>The email body that will be visible to recipients whose email clients do not display
    /// HTML.</p>
    pub text_part: std::option::Option<std::string::String>,
    /// <p>The HTML body of the email.</p>
    pub html_part: std::option::Option<std::string::String>,
}
impl Template {
    /// <p>The name of the template. You will refer to this name when you send email using the
    /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code>
    /// operations.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The subject line of the email.</p>
    pub fn subject_part(&self) -> std::option::Option<&str> {
        self.subject_part.as_deref()
    }
    /// <p>The email body that will be visible to recipients whose email clients do not display
    /// HTML.</p>
    pub fn text_part(&self) -> std::option::Option<&str> {
        self.text_part.as_deref()
    }
    /// <p>The HTML body of the email.</p>
    pub fn html_part(&self) -> std::option::Option<&str> {
        self.html_part.as_deref()
    }
}
impl std::fmt::Debug for Template {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Template");
        formatter.field("template_name", &self.template_name);
        formatter.field("subject_part", &self.subject_part);
        formatter.field("text_part", &self.text_part);
        formatter.field("html_part", &self.html_part);
        formatter.finish()
    }
}
/// See [`Template`](crate::model::Template)
pub mod template {
    /// A builder for [`Template`](crate::model::Template)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) subject_part: std::option::Option<std::string::String>,
        pub(crate) text_part: std::option::Option<std::string::String>,
        pub(crate) html_part: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template. You will refer to this name when you send email using the
        /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code>
        /// operations.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template. You will refer to this name when you send email using the
        /// <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code>
        /// operations.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The subject line of the email.</p>
        pub fn subject_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject_part = Some(input.into());
            self
        }
        /// <p>The subject line of the email.</p>
        pub fn set_subject_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject_part = input;
            self
        }
        /// <p>The email body that will be visible to recipients whose email clients do not display
        /// HTML.</p>
        pub fn text_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.text_part = Some(input.into());
            self
        }
        /// <p>The email body that will be visible to recipients whose email clients do not display
        /// HTML.</p>
        pub fn set_text_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text_part = input;
            self
        }
        /// <p>The HTML body of the email.</p>
        pub fn html_part(mut self, input: impl Into<std::string::String>) -> Self {
            self.html_part = Some(input.into());
            self
        }
        /// <p>The HTML body of the email.</p>
        pub fn set_html_part(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.html_part = input;
            self
        }
        /// Consumes the builder and constructs a [`Template`](crate::model::Template)
        pub fn build(self) -> crate::model::Template {
            crate::model::Template {
                template_name: self.template_name,
                subject_part: self.subject_part,
                text_part: self.text_part,
                html_part: self.html_part,
            }
        }
    }
}
impl Template {
    /// Creates a new builder-style object to manufacture [`Template`](crate::model::Template)
    pub fn builder() -> crate::model::template::Builder {
        crate::model::template::Builder::default()
    }
}

/// <p>Receipt rules enable you to specify which actions Amazon SES should take when it receives
/// mail on behalf of one or more email addresses or domains that you own.</p>
/// <p>Each receipt rule defines a set of email addresses or domains that it applies to. If
/// the email addresses or domains match at least one recipient address of the message,
/// Amazon SES executes all of the receipt rule's actions on the message.</p>
/// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptRule {
    /// <p>The name of the receipt rule. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, the receipt rule is active. The default value is
    /// <code>false</code>.</p>
    pub enabled: bool,
    /// <p>Specifies whether Amazon SES should require that incoming email is delivered over a
    /// connection encrypted with Transport Layer Security (TLS). If this parameter is set to
    /// <code>Require</code>, Amazon SES will bounce emails that are not received over TLS. The
    /// default is <code>Optional</code>.</p>
    pub tls_policy: std::option::Option<crate::model::TlsPolicy>,
    /// <p>The recipient domains and email addresses that the receipt rule applies to. If this
    /// field is not specified, this rule will match all recipients under all verified
    /// domains.</p>
    pub recipients: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An ordered list of actions to perform on messages that match at least one of the
    /// recipient email addresses or domains specified in the receipt rule.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::ReceiptAction>>,
    /// <p>If <code>true</code>, then messages that this receipt rule applies to are scanned for
    /// spam and viruses. The default value is <code>false</code>.</p>
    pub scan_enabled: bool,
}
impl ReceiptRule {
    /// <p>The name of the receipt rule. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If <code>true</code>, the receipt rule is active. The default value is
    /// <code>false</code>.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Specifies whether Amazon SES should require that incoming email is delivered over a
    /// connection encrypted with Transport Layer Security (TLS). If this parameter is set to
    /// <code>Require</code>, Amazon SES will bounce emails that are not received over TLS. The
    /// default is <code>Optional</code>.</p>
    pub fn tls_policy(&self) -> std::option::Option<&crate::model::TlsPolicy> {
        self.tls_policy.as_ref()
    }
    /// <p>The recipient domains and email addresses that the receipt rule applies to. If this
    /// field is not specified, this rule will match all recipients under all verified
    /// domains.</p>
    pub fn recipients(&self) -> std::option::Option<&[std::string::String]> {
        self.recipients.as_deref()
    }
    /// <p>An ordered list of actions to perform on messages that match at least one of the
    /// recipient email addresses or domains specified in the receipt rule.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::ReceiptAction]> {
        self.actions.as_deref()
    }
    /// <p>If <code>true</code>, then messages that this receipt rule applies to are scanned for
    /// spam and viruses. The default value is <code>false</code>.</p>
    pub fn scan_enabled(&self) -> bool {
        self.scan_enabled
    }
}
impl std::fmt::Debug for ReceiptRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptRule");
        formatter.field("name", &self.name);
        formatter.field("enabled", &self.enabled);
        formatter.field("tls_policy", &self.tls_policy);
        formatter.field("recipients", &self.recipients);
        formatter.field("actions", &self.actions);
        formatter.field("scan_enabled", &self.scan_enabled);
        formatter.finish()
    }
}
/// See [`ReceiptRule`](crate::model::ReceiptRule)
pub mod receipt_rule {
    /// A builder for [`ReceiptRule`](crate::model::ReceiptRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tls_policy: std::option::Option<crate::model::TlsPolicy>,
        pub(crate) recipients: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::ReceiptAction>>,
        pub(crate) scan_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the receipt rule. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If <code>true</code>, the receipt rule is active. The default value is
        /// <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, the receipt rule is active. The default value is
        /// <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies whether Amazon SES should require that incoming email is delivered over a
        /// connection encrypted with Transport Layer Security (TLS). If this parameter is set to
        /// <code>Require</code>, Amazon SES will bounce emails that are not received over TLS. The
        /// default is <code>Optional</code>.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.tls_policy = Some(input);
            self
        }
        /// <p>Specifies whether Amazon SES should require that incoming email is delivered over a
        /// connection encrypted with Transport Layer Security (TLS). If this parameter is set to
        /// <code>Require</code>, Amazon SES will bounce emails that are not received over TLS. The
        /// default is <code>Optional</code>.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.tls_policy = input;
            self
        }
        /// Appends an item to `recipients`.
        ///
        /// To override the contents of this collection use [`set_recipients`](Self::set_recipients).
        ///
        /// <p>The recipient domains and email addresses that the receipt rule applies to. If this
        /// field is not specified, this rule will match all recipients under all verified
        /// domains.</p>
        pub fn recipients(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recipients.unwrap_or_default();
            v.push(input.into());
            self.recipients = Some(v);
            self
        }
        /// <p>The recipient domains and email addresses that the receipt rule applies to. If this
        /// field is not specified, this rule will match all recipients under all verified
        /// domains.</p>
        pub fn set_recipients(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recipients = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>An ordered list of actions to perform on messages that match at least one of the
        /// recipient email addresses or domains specified in the receipt rule.</p>
        pub fn actions(mut self, input: impl Into<crate::model::ReceiptAction>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>An ordered list of actions to perform on messages that match at least one of the
        /// recipient email addresses or domains specified in the receipt rule.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReceiptAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>If <code>true</code>, then messages that this receipt rule applies to are scanned for
        /// spam and viruses. The default value is <code>false</code>.</p>
        pub fn scan_enabled(mut self, input: bool) -> Self {
            self.scan_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, then messages that this receipt rule applies to are scanned for
        /// spam and viruses. The default value is <code>false</code>.</p>
        pub fn set_scan_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.scan_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptRule`](crate::model::ReceiptRule)
        pub fn build(self) -> crate::model::ReceiptRule {
            crate::model::ReceiptRule {
                name: self.name,
                enabled: self.enabled.unwrap_or_default(),
                tls_policy: self.tls_policy,
                recipients: self.recipients,
                actions: self.actions,
                scan_enabled: self.scan_enabled.unwrap_or_default(),
            }
        }
    }
}
impl ReceiptRule {
    /// Creates a new builder-style object to manufacture [`ReceiptRule`](crate::model::ReceiptRule)
    pub fn builder() -> crate::model::receipt_rule::Builder {
        crate::model::receipt_rule::Builder::default()
    }
}

/// <p>An action that Amazon SES can take when it receives an email on behalf of one or more email
/// addresses or domains that you own. An instance of this data type can represent only one
/// action.</p>
/// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptAction {
    /// <p>Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
    /// notification to Amazon SNS.</p>
    pub s3_action: std::option::Option<crate::model::S3Action>,
    /// <p>Rejects the received email by returning a bounce response to the sender and,
    /// optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
    pub bounce_action: std::option::Option<crate::model::BounceAction>,
    /// <p>Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
    /// Amazon SNS.</p>
    pub workmail_action: std::option::Option<crate::model::WorkmailAction>,
    /// <p>Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.</p>
    pub lambda_action: std::option::Option<crate::model::LambdaAction>,
    /// <p>Terminates the evaluation of the receipt rule set and optionally publishes a
    /// notification to Amazon SNS.</p>
    pub stop_action: std::option::Option<crate::model::StopAction>,
    /// <p>Adds a header to the received email.</p>
    pub add_header_action: std::option::Option<crate::model::AddHeaderAction>,
    /// <p>Publishes the email content within a notification to Amazon SNS.</p>
    pub sns_action: std::option::Option<crate::model::SnsAction>,
}
impl ReceiptAction {
    /// <p>Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
    /// notification to Amazon SNS.</p>
    pub fn s3_action(&self) -> std::option::Option<&crate::model::S3Action> {
        self.s3_action.as_ref()
    }
    /// <p>Rejects the received email by returning a bounce response to the sender and,
    /// optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
    pub fn bounce_action(&self) -> std::option::Option<&crate::model::BounceAction> {
        self.bounce_action.as_ref()
    }
    /// <p>Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
    /// Amazon SNS.</p>
    pub fn workmail_action(&self) -> std::option::Option<&crate::model::WorkmailAction> {
        self.workmail_action.as_ref()
    }
    /// <p>Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.</p>
    pub fn lambda_action(&self) -> std::option::Option<&crate::model::LambdaAction> {
        self.lambda_action.as_ref()
    }
    /// <p>Terminates the evaluation of the receipt rule set and optionally publishes a
    /// notification to Amazon SNS.</p>
    pub fn stop_action(&self) -> std::option::Option<&crate::model::StopAction> {
        self.stop_action.as_ref()
    }
    /// <p>Adds a header to the received email.</p>
    pub fn add_header_action(&self) -> std::option::Option<&crate::model::AddHeaderAction> {
        self.add_header_action.as_ref()
    }
    /// <p>Publishes the email content within a notification to Amazon SNS.</p>
    pub fn sns_action(&self) -> std::option::Option<&crate::model::SnsAction> {
        self.sns_action.as_ref()
    }
}
impl std::fmt::Debug for ReceiptAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptAction");
        formatter.field("s3_action", &self.s3_action);
        formatter.field("bounce_action", &self.bounce_action);
        formatter.field("workmail_action", &self.workmail_action);
        formatter.field("lambda_action", &self.lambda_action);
        formatter.field("stop_action", &self.stop_action);
        formatter.field("add_header_action", &self.add_header_action);
        formatter.field("sns_action", &self.sns_action);
        formatter.finish()
    }
}
/// See [`ReceiptAction`](crate::model::ReceiptAction)
pub mod receipt_action {
    /// A builder for [`ReceiptAction`](crate::model::ReceiptAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_action: std::option::Option<crate::model::S3Action>,
        pub(crate) bounce_action: std::option::Option<crate::model::BounceAction>,
        pub(crate) workmail_action: std::option::Option<crate::model::WorkmailAction>,
        pub(crate) lambda_action: std::option::Option<crate::model::LambdaAction>,
        pub(crate) stop_action: std::option::Option<crate::model::StopAction>,
        pub(crate) add_header_action: std::option::Option<crate::model::AddHeaderAction>,
        pub(crate) sns_action: std::option::Option<crate::model::SnsAction>,
    }
    impl Builder {
        /// <p>Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
        /// notification to Amazon SNS.</p>
        pub fn s3_action(mut self, input: crate::model::S3Action) -> Self {
            self.s3_action = Some(input);
            self
        }
        /// <p>Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
        /// notification to Amazon SNS.</p>
        pub fn set_s3_action(mut self, input: std::option::Option<crate::model::S3Action>) -> Self {
            self.s3_action = input;
            self
        }
        /// <p>Rejects the received email by returning a bounce response to the sender and,
        /// optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
        pub fn bounce_action(mut self, input: crate::model::BounceAction) -> Self {
            self.bounce_action = Some(input);
            self
        }
        /// <p>Rejects the received email by returning a bounce response to the sender and,
        /// optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
        pub fn set_bounce_action(
            mut self,
            input: std::option::Option<crate::model::BounceAction>,
        ) -> Self {
            self.bounce_action = input;
            self
        }
        /// <p>Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
        /// Amazon SNS.</p>
        pub fn workmail_action(mut self, input: crate::model::WorkmailAction) -> Self {
            self.workmail_action = Some(input);
            self
        }
        /// <p>Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
        /// Amazon SNS.</p>
        pub fn set_workmail_action(
            mut self,
            input: std::option::Option<crate::model::WorkmailAction>,
        ) -> Self {
            self.workmail_action = input;
            self
        }
        /// <p>Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.</p>
        pub fn lambda_action(mut self, input: crate::model::LambdaAction) -> Self {
            self.lambda_action = Some(input);
            self
        }
        /// <p>Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.</p>
        pub fn set_lambda_action(
            mut self,
            input: std::option::Option<crate::model::LambdaAction>,
        ) -> Self {
            self.lambda_action = input;
            self
        }
        /// <p>Terminates the evaluation of the receipt rule set and optionally publishes a
        /// notification to Amazon SNS.</p>
        pub fn stop_action(mut self, input: crate::model::StopAction) -> Self {
            self.stop_action = Some(input);
            self
        }
        /// <p>Terminates the evaluation of the receipt rule set and optionally publishes a
        /// notification to Amazon SNS.</p>
        pub fn set_stop_action(
            mut self,
            input: std::option::Option<crate::model::StopAction>,
        ) -> Self {
            self.stop_action = input;
            self
        }
        /// <p>Adds a header to the received email.</p>
        pub fn add_header_action(mut self, input: crate::model::AddHeaderAction) -> Self {
            self.add_header_action = Some(input);
            self
        }
        /// <p>Adds a header to the received email.</p>
        pub fn set_add_header_action(
            mut self,
            input: std::option::Option<crate::model::AddHeaderAction>,
        ) -> Self {
            self.add_header_action = input;
            self
        }
        /// <p>Publishes the email content within a notification to Amazon SNS.</p>
        pub fn sns_action(mut self, input: crate::model::SnsAction) -> Self {
            self.sns_action = Some(input);
            self
        }
        /// <p>Publishes the email content within a notification to Amazon SNS.</p>
        pub fn set_sns_action(
            mut self,
            input: std::option::Option<crate::model::SnsAction>,
        ) -> Self {
            self.sns_action = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptAction`](crate::model::ReceiptAction)
        pub fn build(self) -> crate::model::ReceiptAction {
            crate::model::ReceiptAction {
                s3_action: self.s3_action,
                bounce_action: self.bounce_action,
                workmail_action: self.workmail_action,
                lambda_action: self.lambda_action,
                stop_action: self.stop_action,
                add_header_action: self.add_header_action,
                sns_action: self.sns_action,
            }
        }
    }
}
impl ReceiptAction {
    /// Creates a new builder-style object to manufacture [`ReceiptAction`](crate::model::ReceiptAction)
    pub fn builder() -> crate::model::receipt_action::Builder {
        crate::model::receipt_action::Builder::default()
    }
}

/// <p>When included in a receipt rule, this action publishes a notification to Amazon Simple Notification Service
/// (Amazon SNS). This action includes a complete copy of the email content in the Amazon SNS
/// notifications. Amazon SNS notifications for all other actions simply provide information
/// about the email. They do not include the email content itself.</p>
/// <p>If you own the Amazon SNS topic, you don't need to do anything to give Amazon SES permission to
/// publish emails to it. However, if you don't own the Amazon SNS topic, you need to attach a
/// policy to the topic to give Amazon SES permissions to access it. For information about giving
/// permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
/// Guide</a>.</p>
/// <important>
/// <p>You can only publish emails that are 150 KB or less (including the header) to
/// Amazon SNS. Larger emails will bounce. If you anticipate emails larger than 150 KB, use
/// the S3 action instead.</p>
/// </important>
/// <p>For information about using a receipt rule to publish an Amazon SNS notification, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example of an Amazon SNS
    /// topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
    /// information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The encoding to use for the email within the Amazon SNS notification. UTF-8 is easier to
    /// use, but may not preserve all special characters when a message was encoded with a
    /// different encoding format. Base64 preserves all special characters. The default value is
    /// UTF-8.</p>
    pub encoding: std::option::Option<crate::model::SnsActionEncoding>,
}
impl SnsAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example of an Amazon SNS
    /// topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
    /// information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The encoding to use for the email within the Amazon SNS notification. UTF-8 is easier to
    /// use, but may not preserve all special characters when a message was encoded with a
    /// different encoding format. Base64 preserves all special characters. The default value is
    /// UTF-8.</p>
    pub fn encoding(&self) -> std::option::Option<&crate::model::SnsActionEncoding> {
        self.encoding.as_ref()
    }
}
impl std::fmt::Debug for SnsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsAction");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("encoding", &self.encoding);
        formatter.finish()
    }
}
/// See [`SnsAction`](crate::model::SnsAction)
pub mod sns_action {
    /// A builder for [`SnsAction`](crate::model::SnsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) encoding: std::option::Option<crate::model::SnsActionEncoding>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example of an Amazon SNS
        /// topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
        /// information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example of an Amazon SNS
        /// topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
        /// information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The encoding to use for the email within the Amazon SNS notification. UTF-8 is easier to
        /// use, but may not preserve all special characters when a message was encoded with a
        /// different encoding format. Base64 preserves all special characters. The default value is
        /// UTF-8.</p>
        pub fn encoding(mut self, input: crate::model::SnsActionEncoding) -> Self {
            self.encoding = Some(input);
            self
        }
        /// <p>The encoding to use for the email within the Amazon SNS notification. UTF-8 is easier to
        /// use, but may not preserve all special characters when a message was encoded with a
        /// different encoding format. Base64 preserves all special characters. The default value is
        /// UTF-8.</p>
        pub fn set_encoding(
            mut self,
            input: std::option::Option<crate::model::SnsActionEncoding>,
        ) -> Self {
            self.encoding = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsAction`](crate::model::SnsAction)
        pub fn build(self) -> crate::model::SnsAction {
            crate::model::SnsAction {
                topic_arn: self.topic_arn,
                encoding: self.encoding,
            }
        }
    }
}
impl SnsAction {
    /// Creates a new builder-style object to manufacture [`SnsAction`](crate::model::SnsAction)
    pub fn builder() -> crate::model::sns_action::Builder {
        crate::model::sns_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnsActionEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Base64,
    #[allow(missing_docs)] // documentation missing in model
    Utf8,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnsActionEncoding {
    fn from(s: &str) -> Self {
        match s {
            "Base64" => SnsActionEncoding::Base64,
            "UTF-8" => SnsActionEncoding::Utf8,
            other => SnsActionEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnsActionEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnsActionEncoding::from(s))
    }
}
impl SnsActionEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnsActionEncoding::Base64 => "Base64",
            SnsActionEncoding::Utf8 => "UTF-8",
            SnsActionEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Base64", "UTF-8"]
    }
}
impl AsRef<str> for SnsActionEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When included in a receipt rule, this action adds a header to the received
/// email.</p>
/// <p>For information about adding a header using a receipt rule, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddHeaderAction {
    /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
    /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
    pub header_name: std::option::Option<std::string::String>,
    /// <p>Must be less than 2048 characters, and must not contain newline characters ("\r" or
    /// "\n").</p>
    pub header_value: std::option::Option<std::string::String>,
}
impl AddHeaderAction {
    /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
    /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
    pub fn header_name(&self) -> std::option::Option<&str> {
        self.header_name.as_deref()
    }
    /// <p>Must be less than 2048 characters, and must not contain newline characters ("\r" or
    /// "\n").</p>
    pub fn header_value(&self) -> std::option::Option<&str> {
        self.header_value.as_deref()
    }
}
impl std::fmt::Debug for AddHeaderAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddHeaderAction");
        formatter.field("header_name", &self.header_name);
        formatter.field("header_value", &self.header_value);
        formatter.finish()
    }
}
/// See [`AddHeaderAction`](crate::model::AddHeaderAction)
pub mod add_header_action {
    /// A builder for [`AddHeaderAction`](crate::model::AddHeaderAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_name: std::option::Option<std::string::String>,
        pub(crate) header_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
        /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
        pub fn header_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_name = Some(input.into());
            self
        }
        /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
        /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
        pub fn set_header_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_name = input;
            self
        }
        /// <p>Must be less than 2048 characters, and must not contain newline characters ("\r" or
        /// "\n").</p>
        pub fn header_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.header_value = Some(input.into());
            self
        }
        /// <p>Must be less than 2048 characters, and must not contain newline characters ("\r" or
        /// "\n").</p>
        pub fn set_header_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.header_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AddHeaderAction`](crate::model::AddHeaderAction)
        pub fn build(self) -> crate::model::AddHeaderAction {
            crate::model::AddHeaderAction {
                header_name: self.header_name,
                header_value: self.header_value,
            }
        }
    }
}
impl AddHeaderAction {
    /// Creates a new builder-style object to manufacture [`AddHeaderAction`](crate::model::AddHeaderAction)
    pub fn builder() -> crate::model::add_header_action::Builder {
        crate::model::add_header_action::Builder::default()
    }
}

/// <p>When included in a receipt rule, this action terminates the evaluation of the receipt
/// rule set and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
/// <p>For information about setting a stop action in a receipt rule, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAction {
    /// <p>The scope of the StopAction. The only acceptable value is <code>RuleSet</code>.</p>
    pub scope: std::option::Option<crate::model::StopScope>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl StopAction {
    /// <p>The scope of the StopAction. The only acceptable value is <code>RuleSet</code>.</p>
    pub fn scope(&self) -> std::option::Option<&crate::model::StopScope> {
        self.scope.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for StopAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAction");
        formatter.field("scope", &self.scope);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`StopAction`](crate::model::StopAction)
pub mod stop_action {
    /// A builder for [`StopAction`](crate::model::StopAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scope: std::option::Option<crate::model::StopScope>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The scope of the StopAction. The only acceptable value is <code>RuleSet</code>.</p>
        pub fn scope(mut self, input: crate::model::StopScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope of the StopAction. The only acceptable value is <code>RuleSet</code>.</p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::StopScope>) -> Self {
            self.scope = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopAction`](crate::model::StopAction)
        pub fn build(self) -> crate::model::StopAction {
            crate::model::StopAction {
                scope: self.scope,
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl StopAction {
    /// Creates a new builder-style object to manufacture [`StopAction`](crate::model::StopAction)
    pub fn builder() -> crate::model::stop_action::Builder {
        crate::model::stop_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StopScope {
    #[allow(missing_docs)] // documentation missing in model
    RuleSet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StopScope {
    fn from(s: &str) -> Self {
        match s {
            "RuleSet" => StopScope::RuleSet,
            other => StopScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StopScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StopScope::from(s))
    }
}
impl StopScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StopScope::RuleSet => "RuleSet",
            StopScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RuleSet"]
    }
}
impl AsRef<str> for StopScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When included in a receipt rule, this action calls an AWS Lambda function and,
/// optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
/// <p>To enable Amazon SES to call your AWS Lambda function or to publish to an Amazon SNS topic of
/// another account, Amazon SES must have permission to access those resources. For information
/// about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
/// Guide</a>.</p>
/// <p>For information about using AWS Lambda actions in receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda
    /// function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>.
    /// For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The invocation type of the AWS Lambda function. An invocation type of
    /// <code>RequestResponse</code> means that the execution of the function will
    /// immediately result in a response, and a value of <code>Event</code> means that the
    /// function will be invoked asynchronously. The default value is <code>Event</code>. For
    /// information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
    /// <important>
    /// <p>There is a 30-second timeout on <code>RequestResponse</code> invocations. You
    /// should use <code>Event</code> invocation in most cases. Use
    /// <code>RequestResponse</code> only when you want to make a mail flow decision,
    /// such as whether to stop the receipt rule or the receipt rule set.</p>
    /// </important>
    pub invocation_type: std::option::Option<crate::model::InvocationType>,
}
impl LambdaAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda
    /// function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>.
    /// For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The invocation type of the AWS Lambda function. An invocation type of
    /// <code>RequestResponse</code> means that the execution of the function will
    /// immediately result in a response, and a value of <code>Event</code> means that the
    /// function will be invoked asynchronously. The default value is <code>Event</code>. For
    /// information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
    /// <important>
    /// <p>There is a 30-second timeout on <code>RequestResponse</code> invocations. You
    /// should use <code>Event</code> invocation in most cases. Use
    /// <code>RequestResponse</code> only when you want to make a mail flow decision,
    /// such as whether to stop the receipt rule or the receipt rule set.</p>
    /// </important>
    pub fn invocation_type(&self) -> std::option::Option<&crate::model::InvocationType> {
        self.invocation_type.as_ref()
    }
}
impl std::fmt::Debug for LambdaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaAction");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("invocation_type", &self.invocation_type);
        formatter.finish()
    }
}
/// See [`LambdaAction`](crate::model::LambdaAction)
pub mod lambda_action {
    /// A builder for [`LambdaAction`](crate::model::LambdaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_type: std::option::Option<crate::model::InvocationType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda
        /// function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>.
        /// For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda
        /// function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>.
        /// For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The invocation type of the AWS Lambda function. An invocation type of
        /// <code>RequestResponse</code> means that the execution of the function will
        /// immediately result in a response, and a value of <code>Event</code> means that the
        /// function will be invoked asynchronously. The default value is <code>Event</code>. For
        /// information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
        /// <important>
        /// <p>There is a 30-second timeout on <code>RequestResponse</code> invocations. You
        /// should use <code>Event</code> invocation in most cases. Use
        /// <code>RequestResponse</code> only when you want to make a mail flow decision,
        /// such as whether to stop the receipt rule or the receipt rule set.</p>
        /// </important>
        pub fn invocation_type(mut self, input: crate::model::InvocationType) -> Self {
            self.invocation_type = Some(input);
            self
        }
        /// <p>The invocation type of the AWS Lambda function. An invocation type of
        /// <code>RequestResponse</code> means that the execution of the function will
        /// immediately result in a response, and a value of <code>Event</code> means that the
        /// function will be invoked asynchronously. The default value is <code>Event</code>. For
        /// information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
        /// <important>
        /// <p>There is a 30-second timeout on <code>RequestResponse</code> invocations. You
        /// should use <code>Event</code> invocation in most cases. Use
        /// <code>RequestResponse</code> only when you want to make a mail flow decision,
        /// such as whether to stop the receipt rule or the receipt rule set.</p>
        /// </important>
        pub fn set_invocation_type(
            mut self,
            input: std::option::Option<crate::model::InvocationType>,
        ) -> Self {
            self.invocation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaAction`](crate::model::LambdaAction)
        pub fn build(self) -> crate::model::LambdaAction {
            crate::model::LambdaAction {
                topic_arn: self.topic_arn,
                function_arn: self.function_arn,
                invocation_type: self.invocation_type,
            }
        }
    }
}
impl LambdaAction {
    /// Creates a new builder-style object to manufacture [`LambdaAction`](crate::model::LambdaAction)
    pub fn builder() -> crate::model::lambda_action::Builder {
        crate::model::lambda_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvocationType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    RequestResponse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvocationType {
    fn from(s: &str) -> Self {
        match s {
            "Event" => InvocationType::Event,
            "RequestResponse" => InvocationType::RequestResponse,
            other => InvocationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvocationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvocationType::from(s))
    }
}
impl InvocationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvocationType::Event => "Event",
            InvocationType::RequestResponse => "RequestResponse",
            InvocationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Event", "RequestResponse"]
    }
}
impl AsRef<str> for InvocationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When included in a receipt rule, this action calls Amazon WorkMail and, optionally,
/// publishes a notification to Amazon Simple Notification Service (Amazon SNS). You will typically not use this action
/// directly because Amazon WorkMail adds the rule automatically during its setup
/// procedure.</p>
/// <p>For information using a receipt rule to call Amazon WorkMail, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkmailAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action
    /// is called. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
    /// organization ARN is
    /// <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>.
    /// For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
    /// Administrator Guide</a>.</p>
    pub organization_arn: std::option::Option<std::string::String>,
}
impl WorkmailAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action
    /// is called. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
    /// organization ARN is
    /// <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>.
    /// For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
    /// Administrator Guide</a>.</p>
    pub fn organization_arn(&self) -> std::option::Option<&str> {
        self.organization_arn.as_deref()
    }
}
impl std::fmt::Debug for WorkmailAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkmailAction");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("organization_arn", &self.organization_arn);
        formatter.finish()
    }
}
/// See [`WorkmailAction`](crate::model::WorkmailAction)
pub mod workmail_action {
    /// A builder for [`WorkmailAction`](crate::model::WorkmailAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) organization_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action
        /// is called. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action
        /// is called. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
        /// organization ARN is
        /// <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>.
        /// For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
        /// Administrator Guide</a>.</p>
        pub fn organization_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
        /// organization ARN is
        /// <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>.
        /// For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
        /// Administrator Guide</a>.</p>
        pub fn set_organization_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkmailAction`](crate::model::WorkmailAction)
        pub fn build(self) -> crate::model::WorkmailAction {
            crate::model::WorkmailAction {
                topic_arn: self.topic_arn,
                organization_arn: self.organization_arn,
            }
        }
    }
}
impl WorkmailAction {
    /// Creates a new builder-style object to manufacture [`WorkmailAction`](crate::model::WorkmailAction)
    pub fn builder() -> crate::model::workmail_action::Builder {
        crate::model::workmail_action::Builder::default()
    }
}

/// <p>When included in a receipt rule, this action rejects the received email by returning a
/// bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service
/// (Amazon SNS).</p>
/// <p>For information about sending a bounce message in response to a received email, see
/// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BounceAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    pub smtp_reply_code: std::option::Option<std::string::String>,
    /// <p>The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>Human-readable text to include in the bounce message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The email address of the sender of the bounced email. This is the address from which
    /// the bounce message will be sent.</p>
    pub sender: std::option::Option<std::string::String>,
}
impl BounceAction {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is
    /// taken. An example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
    pub fn smtp_reply_code(&self) -> std::option::Option<&str> {
        self.smtp_reply_code.as_deref()
    }
    /// <p>The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>Human-readable text to include in the bounce message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The email address of the sender of the bounced email. This is the address from which
    /// the bounce message will be sent.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
}
impl std::fmt::Debug for BounceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BounceAction");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("smtp_reply_code", &self.smtp_reply_code);
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.field("sender", &self.sender);
        formatter.finish()
    }
}
/// See [`BounceAction`](crate::model::BounceAction)
pub mod bounce_action {
    /// A builder for [`BounceAction`](crate::model::BounceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) smtp_reply_code: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is
        /// taken. An example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        pub fn smtp_reply_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.smtp_reply_code = Some(input.into());
            self
        }
        /// <p>The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p>
        pub fn set_smtp_reply_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.smtp_reply_code = input;
            self
        }
        /// <p>The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>Human-readable text to include in the bounce message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Human-readable text to include in the bounce message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The email address of the sender of the bounced email. This is the address from which
        /// the bounce message will be sent.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The email address of the sender of the bounced email. This is the address from which
        /// the bounce message will be sent.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// Consumes the builder and constructs a [`BounceAction`](crate::model::BounceAction)
        pub fn build(self) -> crate::model::BounceAction {
            crate::model::BounceAction {
                topic_arn: self.topic_arn,
                smtp_reply_code: self.smtp_reply_code,
                status_code: self.status_code,
                message: self.message,
                sender: self.sender,
            }
        }
    }
}
impl BounceAction {
    /// Creates a new builder-style object to manufacture [`BounceAction`](crate::model::BounceAction)
    pub fn builder() -> crate::model::bounce_action::Builder {
        crate::model::bounce_action::Builder::default()
    }
}

/// <p>When included in a receipt rule, this action saves the received message to an Amazon Simple Storage Service
/// (Amazon S3) bucket and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).</p>
/// <p>To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS KMS key to encrypt
/// your emails, or publish to an Amazon SNS topic of another account, Amazon SES must have permission
/// to access those resources. For information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
/// Guide</a>.</p>
/// <note>
/// <p>When you save your emails to an Amazon S3 bucket, the maximum email size (including
/// headers) is 30 MB. Emails larger than that will bounce.</p>
/// </note>
/// <p>For information about specifying Amazon S3 actions in receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Action {
    /// <p>The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. An
    /// example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket that incoming email will be saved to.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that
    /// enables you to store similar data under the same directory in a bucket.</p>
    pub object_key_prefix: std::option::Option<std::string::String>,
    /// <p>The customer master key that Amazon SES should use to encrypt your emails before saving
    /// them to the Amazon S3 bucket. You can use the default master key or a custom master key you
    /// created in AWS KMS as follows:</p>
    /// <ul>
    /// <li>
    /// <p>To use the default master key, provide an ARN in the form of
    /// <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code>.
    /// For example, if your AWS account ID is 123456789012 and you want to use the
    /// default master key in the US West (Oregon) region, the ARN of the default master
    /// key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code>. If
    /// you use the default master key, you don't need to perform any extra steps to
    /// give Amazon SES permission to use the key.</p>
    /// </li>
    /// <li>
    /// <p>To use a custom master key you created in AWS KMS, provide the ARN of the
    /// master key and ensure that you add a statement to your key's policy to give
    /// Amazon SES permission to use it. For more information about giving permissions, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a>. If
    /// you do not specify a master key, Amazon SES will not encrypt your emails.</p>
    /// <important>
    /// <p>Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail
    /// is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side
    /// encryption. This means that you must use the Amazon S3 encryption client to decrypt the
    /// email after retrieving it from Amazon S3, as the service has no access to use your AWS
    /// KMS keys for decryption. This encryption client is currently available with the
    /// <a href="http://aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="http://aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more
    /// information about client-side encryption using AWS KMS master keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a>.</p>
    /// </important>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3Action {
    /// <p>The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. An
    /// example of an Amazon SNS topic ARN is
    /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
    /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket that incoming email will be saved to.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that
    /// enables you to store similar data under the same directory in a bucket.</p>
    pub fn object_key_prefix(&self) -> std::option::Option<&str> {
        self.object_key_prefix.as_deref()
    }
    /// <p>The customer master key that Amazon SES should use to encrypt your emails before saving
    /// them to the Amazon S3 bucket. You can use the default master key or a custom master key you
    /// created in AWS KMS as follows:</p>
    /// <ul>
    /// <li>
    /// <p>To use the default master key, provide an ARN in the form of
    /// <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code>.
    /// For example, if your AWS account ID is 123456789012 and you want to use the
    /// default master key in the US West (Oregon) region, the ARN of the default master
    /// key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code>. If
    /// you use the default master key, you don't need to perform any extra steps to
    /// give Amazon SES permission to use the key.</p>
    /// </li>
    /// <li>
    /// <p>To use a custom master key you created in AWS KMS, provide the ARN of the
    /// master key and ensure that you add a statement to your key's policy to give
    /// Amazon SES permission to use it. For more information about giving permissions, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a>. If
    /// you do not specify a master key, Amazon SES will not encrypt your emails.</p>
    /// <important>
    /// <p>Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail
    /// is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side
    /// encryption. This means that you must use the Amazon S3 encryption client to decrypt the
    /// email after retrieving it from Amazon S3, as the service has no access to use your AWS
    /// KMS keys for decryption. This encryption client is currently available with the
    /// <a href="http://aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="http://aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more
    /// information about client-side encryption using AWS KMS master keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a>.</p>
    /// </important>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Action");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("object_key_prefix", &self.object_key_prefix);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3Action`](crate::model::S3Action)
pub mod s3_action {
    /// A builder for [`S3Action`](crate::model::S3Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) object_key_prefix: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. An
        /// example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket. An
        /// example of an Amazon SNS topic ARN is
        /// <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
        /// Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket that incoming email will be saved to.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that incoming email will be saved to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that
        /// enables you to store similar data under the same directory in a bucket.</p>
        pub fn object_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_key_prefix = Some(input.into());
            self
        }
        /// <p>The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory name that
        /// enables you to store similar data under the same directory in a bucket.</p>
        pub fn set_object_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_key_prefix = input;
            self
        }
        /// <p>The customer master key that Amazon SES should use to encrypt your emails before saving
        /// them to the Amazon S3 bucket. You can use the default master key or a custom master key you
        /// created in AWS KMS as follows:</p>
        /// <ul>
        /// <li>
        /// <p>To use the default master key, provide an ARN in the form of
        /// <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code>.
        /// For example, if your AWS account ID is 123456789012 and you want to use the
        /// default master key in the US West (Oregon) region, the ARN of the default master
        /// key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code>. If
        /// you use the default master key, you don't need to perform any extra steps to
        /// give Amazon SES permission to use the key.</p>
        /// </li>
        /// <li>
        /// <p>To use a custom master key you created in AWS KMS, provide the ARN of the
        /// master key and ensure that you add a statement to your key's policy to give
        /// Amazon SES permission to use it. For more information about giving permissions, see
        /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
        /// Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a>. If
        /// you do not specify a master key, Amazon SES will not encrypt your emails.</p>
        /// <important>
        /// <p>Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail
        /// is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side
        /// encryption. This means that you must use the Amazon S3 encryption client to decrypt the
        /// email after retrieving it from Amazon S3, as the service has no access to use your AWS
        /// KMS keys for decryption. This encryption client is currently available with the
        /// <a href="http://aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="http://aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more
        /// information about client-side encryption using AWS KMS master keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a>.</p>
        /// </important>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The customer master key that Amazon SES should use to encrypt your emails before saving
        /// them to the Amazon S3 bucket. You can use the default master key or a custom master key you
        /// created in AWS KMS as follows:</p>
        /// <ul>
        /// <li>
        /// <p>To use the default master key, provide an ARN in the form of
        /// <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code>.
        /// For example, if your AWS account ID is 123456789012 and you want to use the
        /// default master key in the US West (Oregon) region, the ARN of the default master
        /// key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code>. If
        /// you use the default master key, you don't need to perform any extra steps to
        /// give Amazon SES permission to use the key.</p>
        /// </li>
        /// <li>
        /// <p>To use a custom master key you created in AWS KMS, provide the ARN of the
        /// master key and ensure that you add a statement to your key's policy to give
        /// Amazon SES permission to use it. For more information about giving permissions, see
        /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
        /// Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a>. If
        /// you do not specify a master key, Amazon SES will not encrypt your emails.</p>
        /// <important>
        /// <p>Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail
        /// is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side
        /// encryption. This means that you must use the Amazon S3 encryption client to decrypt the
        /// email after retrieving it from Amazon S3, as the service has no access to use your AWS
        /// KMS keys for decryption. This encryption client is currently available with the
        /// <a href="http://aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="http://aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more
        /// information about client-side encryption using AWS KMS master keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a>.</p>
        /// </important>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Action`](crate::model::S3Action)
        pub fn build(self) -> crate::model::S3Action {
            crate::model::S3Action {
                topic_arn: self.topic_arn,
                bucket_name: self.bucket_name,
                object_key_prefix: self.object_key_prefix,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3Action {
    /// Creates a new builder-style object to manufacture [`S3Action`](crate::model::S3Action)
    pub fn builder() -> crate::model::s3_action::Builder {
        crate::model::s3_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TlsPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Require,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TlsPolicy {
    fn from(s: &str) -> Self {
        match s {
            "Optional" => TlsPolicy::Optional,
            "Require" => TlsPolicy::Require,
            other => TlsPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TlsPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TlsPolicy::from(s))
    }
}
impl TlsPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TlsPolicy::Optional => "Optional",
            TlsPolicy::Require => "Require",
            TlsPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Optional", "Require"]
    }
}
impl AsRef<str> for TlsPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
/// domain captures open and click events generated by Amazon SES emails.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
/// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
/// Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackingOptions {
    /// <p>The custom subdomain that will be used to redirect email recipients to the Amazon SES
    /// event tracking domain.</p>
    pub custom_redirect_domain: std::option::Option<std::string::String>,
}
impl TrackingOptions {
    /// <p>The custom subdomain that will be used to redirect email recipients to the Amazon SES
    /// event tracking domain.</p>
    pub fn custom_redirect_domain(&self) -> std::option::Option<&str> {
        self.custom_redirect_domain.as_deref()
    }
}
impl std::fmt::Debug for TrackingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackingOptions");
        formatter.field("custom_redirect_domain", &self.custom_redirect_domain);
        formatter.finish()
    }
}
/// See [`TrackingOptions`](crate::model::TrackingOptions)
pub mod tracking_options {
    /// A builder for [`TrackingOptions`](crate::model::TrackingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_redirect_domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The custom subdomain that will be used to redirect email recipients to the Amazon SES
        /// event tracking domain.</p>
        pub fn custom_redirect_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_redirect_domain = Some(input.into());
            self
        }
        /// <p>The custom subdomain that will be used to redirect email recipients to the Amazon SES
        /// event tracking domain.</p>
        pub fn set_custom_redirect_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_redirect_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackingOptions`](crate::model::TrackingOptions)
        pub fn build(self) -> crate::model::TrackingOptions {
            crate::model::TrackingOptions {
                custom_redirect_domain: self.custom_redirect_domain,
            }
        }
    }
}
impl TrackingOptions {
    /// Creates a new builder-style object to manufacture [`TrackingOptions`](crate::model::TrackingOptions)
    pub fn builder() -> crate::model::tracking_options::Builder {
        crate::model::tracking_options::Builder::default()
    }
}

/// <p>Contains information about the event destination that the specified email sending
/// events will be published to.</p>
/// <note>
/// <p>When you create or update an event destination, you must provide one, and only
/// one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose or Amazon Simple Notification Service (Amazon SNS).</p>
/// </note>
/// <p>Event destinations are associated with configuration sets, which enable you to publish
/// email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about
/// using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestination {
    /// <p>The name of the event destination. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>Sets whether Amazon SES publishes events to this destination when you send an email with
    /// the associated configuration set. Set to <code>true</code> to enable publishing to this
    /// destination; set to <code>false</code> to prevent publishing to this destination. The
    /// default value is <code>false</code>.</p>
    pub enabled: bool,
    /// <p>The type of email sending events to publish to the event destination.</p>
    pub matching_event_types: std::option::Option<std::vec::Vec<crate::model::EventType>>,
    /// <p>An object that contains the delivery stream ARN and the IAM role ARN associated with
    /// an Amazon Kinesis Firehose event destination.</p>
    pub kinesis_firehose_destination: std::option::Option<crate::model::KinesisFirehoseDestination>,
    /// <p>An object that contains the names, default values, and sources of the dimensions
    /// associated with an Amazon CloudWatch event destination.</p>
    pub cloud_watch_destination: std::option::Option<crate::model::CloudWatchDestination>,
    /// <p>An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event
    /// destination.</p>
    pub sns_destination: std::option::Option<crate::model::SnsDestination>,
}
impl EventDestination {
    /// <p>The name of the event destination. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Sets whether Amazon SES publishes events to this destination when you send an email with
    /// the associated configuration set. Set to <code>true</code> to enable publishing to this
    /// destination; set to <code>false</code> to prevent publishing to this destination. The
    /// default value is <code>false</code>.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The type of email sending events to publish to the event destination.</p>
    pub fn matching_event_types(&self) -> std::option::Option<&[crate::model::EventType]> {
        self.matching_event_types.as_deref()
    }
    /// <p>An object that contains the delivery stream ARN and the IAM role ARN associated with
    /// an Amazon Kinesis Firehose event destination.</p>
    pub fn kinesis_firehose_destination(
        &self,
    ) -> std::option::Option<&crate::model::KinesisFirehoseDestination> {
        self.kinesis_firehose_destination.as_ref()
    }
    /// <p>An object that contains the names, default values, and sources of the dimensions
    /// associated with an Amazon CloudWatch event destination.</p>
    pub fn cloud_watch_destination(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchDestination> {
        self.cloud_watch_destination.as_ref()
    }
    /// <p>An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event
    /// destination.</p>
    pub fn sns_destination(&self) -> std::option::Option<&crate::model::SnsDestination> {
        self.sns_destination.as_ref()
    }
}
impl std::fmt::Debug for EventDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestination");
        formatter.field("name", &self.name);
        formatter.field("enabled", &self.enabled);
        formatter.field("matching_event_types", &self.matching_event_types);
        formatter.field(
            "kinesis_firehose_destination",
            &self.kinesis_firehose_destination,
        );
        formatter.field("cloud_watch_destination", &self.cloud_watch_destination);
        formatter.field("sns_destination", &self.sns_destination);
        formatter.finish()
    }
}
/// See [`EventDestination`](crate::model::EventDestination)
pub mod event_destination {
    /// A builder for [`EventDestination`](crate::model::EventDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) matching_event_types:
            std::option::Option<std::vec::Vec<crate::model::EventType>>,
        pub(crate) kinesis_firehose_destination:
            std::option::Option<crate::model::KinesisFirehoseDestination>,
        pub(crate) cloud_watch_destination:
            std::option::Option<crate::model::CloudWatchDestination>,
        pub(crate) sns_destination: std::option::Option<crate::model::SnsDestination>,
    }
    impl Builder {
        /// <p>The name of the event destination. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event destination. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Sets whether Amazon SES publishes events to this destination when you send an email with
        /// the associated configuration set. Set to <code>true</code> to enable publishing to this
        /// destination; set to <code>false</code> to prevent publishing to this destination. The
        /// default value is <code>false</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Sets whether Amazon SES publishes events to this destination when you send an email with
        /// the associated configuration set. Set to <code>true</code> to enable publishing to this
        /// destination; set to <code>false</code> to prevent publishing to this destination. The
        /// default value is <code>false</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `matching_event_types`.
        ///
        /// To override the contents of this collection use [`set_matching_event_types`](Self::set_matching_event_types).
        ///
        /// <p>The type of email sending events to publish to the event destination.</p>
        pub fn matching_event_types(mut self, input: impl Into<crate::model::EventType>) -> Self {
            let mut v = self.matching_event_types.unwrap_or_default();
            v.push(input.into());
            self.matching_event_types = Some(v);
            self
        }
        /// <p>The type of email sending events to publish to the event destination.</p>
        pub fn set_matching_event_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventType>>,
        ) -> Self {
            self.matching_event_types = input;
            self
        }
        /// <p>An object that contains the delivery stream ARN and the IAM role ARN associated with
        /// an Amazon Kinesis Firehose event destination.</p>
        pub fn kinesis_firehose_destination(
            mut self,
            input: crate::model::KinesisFirehoseDestination,
        ) -> Self {
            self.kinesis_firehose_destination = Some(input);
            self
        }
        /// <p>An object that contains the delivery stream ARN and the IAM role ARN associated with
        /// an Amazon Kinesis Firehose event destination.</p>
        pub fn set_kinesis_firehose_destination(
            mut self,
            input: std::option::Option<crate::model::KinesisFirehoseDestination>,
        ) -> Self {
            self.kinesis_firehose_destination = input;
            self
        }
        /// <p>An object that contains the names, default values, and sources of the dimensions
        /// associated with an Amazon CloudWatch event destination.</p>
        pub fn cloud_watch_destination(
            mut self,
            input: crate::model::CloudWatchDestination,
        ) -> Self {
            self.cloud_watch_destination = Some(input);
            self
        }
        /// <p>An object that contains the names, default values, and sources of the dimensions
        /// associated with an Amazon CloudWatch event destination.</p>
        pub fn set_cloud_watch_destination(
            mut self,
            input: std::option::Option<crate::model::CloudWatchDestination>,
        ) -> Self {
            self.cloud_watch_destination = input;
            self
        }
        /// <p>An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event
        /// destination.</p>
        pub fn sns_destination(mut self, input: crate::model::SnsDestination) -> Self {
            self.sns_destination = Some(input);
            self
        }
        /// <p>An object that contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event
        /// destination.</p>
        pub fn set_sns_destination(
            mut self,
            input: std::option::Option<crate::model::SnsDestination>,
        ) -> Self {
            self.sns_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestination`](crate::model::EventDestination)
        pub fn build(self) -> crate::model::EventDestination {
            crate::model::EventDestination {
                name: self.name,
                enabled: self.enabled.unwrap_or_default(),
                matching_event_types: self.matching_event_types,
                kinesis_firehose_destination: self.kinesis_firehose_destination,
                cloud_watch_destination: self.cloud_watch_destination,
                sns_destination: self.sns_destination,
            }
        }
    }
}
impl EventDestination {
    /// Creates a new builder-style object to manufacture [`EventDestination`](crate::model::EventDestination)
    pub fn builder() -> crate::model::event_destination::Builder {
        crate::model::event_destination::Builder::default()
    }
}

/// <p>Contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.</p>
/// <p>Event destinations, such as Amazon SNS, are associated with configuration sets, which
/// enable you to publish email sending events. For information about using configuration
/// sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsDestination {
    /// <p>The ARN of the Amazon SNS topic that email sending events will be published to. An example
    /// of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
    /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SnsDestination {
    /// <p>The ARN of the Amazon SNS topic that email sending events will be published to. An example
    /// of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
    /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsDestination");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`SnsDestination`](crate::model::SnsDestination)
pub mod sns_destination {
    /// A builder for [`SnsDestination`](crate::model::SnsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon SNS topic that email sending events will be published to. An example
        /// of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
        /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon SNS topic that email sending events will be published to. An example
        /// of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
        /// more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsDestination`](crate::model::SnsDestination)
        pub fn build(self) -> crate::model::SnsDestination {
            crate::model::SnsDestination {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl SnsDestination {
    /// Creates a new builder-style object to manufacture [`SnsDestination`](crate::model::SnsDestination)
    pub fn builder() -> crate::model::sns_destination::Builder {
        crate::model::sns_destination::Builder::default()
    }
}

/// <p>Contains information associated with an Amazon CloudWatch event destination to which email
/// sending events are published.</p>
/// <p>Event destinations, such as Amazon CloudWatch, are associated with configuration sets, which
/// enable you to publish email sending events. For information about using configuration
/// sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchDestination {
    /// <p>A list of dimensions upon which to categorize your emails when you publish email
    /// sending events to Amazon CloudWatch.</p>
    pub dimension_configurations:
        std::option::Option<std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>>,
}
impl CloudWatchDestination {
    /// <p>A list of dimensions upon which to categorize your emails when you publish email
    /// sending events to Amazon CloudWatch.</p>
    pub fn dimension_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::CloudWatchDimensionConfiguration]> {
        self.dimension_configurations.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchDestination");
        formatter.field("dimension_configurations", &self.dimension_configurations);
        formatter.finish()
    }
}
/// See [`CloudWatchDestination`](crate::model::CloudWatchDestination)
pub mod cloud_watch_destination {
    /// A builder for [`CloudWatchDestination`](crate::model::CloudWatchDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_configurations:
            std::option::Option<std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `dimension_configurations`.
        ///
        /// To override the contents of this collection use [`set_dimension_configurations`](Self::set_dimension_configurations).
        ///
        /// <p>A list of dimensions upon which to categorize your emails when you publish email
        /// sending events to Amazon CloudWatch.</p>
        pub fn dimension_configurations(
            mut self,
            input: impl Into<crate::model::CloudWatchDimensionConfiguration>,
        ) -> Self {
            let mut v = self.dimension_configurations.unwrap_or_default();
            v.push(input.into());
            self.dimension_configurations = Some(v);
            self
        }
        /// <p>A list of dimensions upon which to categorize your emails when you publish email
        /// sending events to Amazon CloudWatch.</p>
        pub fn set_dimension_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>,
            >,
        ) -> Self {
            self.dimension_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchDestination`](crate::model::CloudWatchDestination)
        pub fn build(self) -> crate::model::CloudWatchDestination {
            crate::model::CloudWatchDestination {
                dimension_configurations: self.dimension_configurations,
            }
        }
    }
}
impl CloudWatchDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchDestination`](crate::model::CloudWatchDestination)
    pub fn builder() -> crate::model::cloud_watch_destination::Builder {
        crate::model::cloud_watch_destination::Builder::default()
    }
}

/// <p>Contains the dimension configuration to use when you publish email sending events to
/// Amazon CloudWatch.</p>
/// <p>For information about publishing email sending events to Amazon CloudWatch, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchDimensionConfiguration {
    /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name
    /// must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub dimension_name: std::option::Option<std::string::String>,
    /// <p>The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. If you
    /// want Amazon SES to use the message tags that you specify using an
    /// <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
    /// <code>SendEmail</code>/<code>SendRawEmail</code> API, choose
    /// <code>messageTag</code>. If you want Amazon SES to use your own email headers, choose
    /// <code>emailHeader</code>.</p>
    pub dimension_value_source: std::option::Option<crate::model::DimensionValueSource>,
    /// <p>The default value of the dimension that is published to Amazon CloudWatch if you do not provide
    /// the value of the dimension when you send an email. The default value must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub default_dimension_value: std::option::Option<std::string::String>,
}
impl CloudWatchDimensionConfiguration {
    /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name
    /// must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn dimension_name(&self) -> std::option::Option<&str> {
        self.dimension_name.as_deref()
    }
    /// <p>The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. If you
    /// want Amazon SES to use the message tags that you specify using an
    /// <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
    /// <code>SendEmail</code>/<code>SendRawEmail</code> API, choose
    /// <code>messageTag</code>. If you want Amazon SES to use your own email headers, choose
    /// <code>emailHeader</code>.</p>
    pub fn dimension_value_source(
        &self,
    ) -> std::option::Option<&crate::model::DimensionValueSource> {
        self.dimension_value_source.as_ref()
    }
    /// <p>The default value of the dimension that is published to Amazon CloudWatch if you do not provide
    /// the value of the dimension when you send an email. The default value must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn default_dimension_value(&self) -> std::option::Option<&str> {
        self.default_dimension_value.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchDimensionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchDimensionConfiguration");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field("dimension_value_source", &self.dimension_value_source);
        formatter.field("default_dimension_value", &self.default_dimension_value);
        formatter.finish()
    }
}
/// See [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
pub mod cloud_watch_dimension_configuration {
    /// A builder for [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name: std::option::Option<std::string::String>,
        pub(crate) dimension_value_source: std::option::Option<crate::model::DimensionValueSource>,
        pub(crate) default_dimension_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name
        /// must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name
        /// must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// <p>The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. If you
        /// want Amazon SES to use the message tags that you specify using an
        /// <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
        /// <code>SendEmail</code>/<code>SendRawEmail</code> API, choose
        /// <code>messageTag</code>. If you want Amazon SES to use your own email headers, choose
        /// <code>emailHeader</code>.</p>
        pub fn dimension_value_source(mut self, input: crate::model::DimensionValueSource) -> Self {
            self.dimension_value_source = Some(input);
            self
        }
        /// <p>The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. If you
        /// want Amazon SES to use the message tags that you specify using an
        /// <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the
        /// <code>SendEmail</code>/<code>SendRawEmail</code> API, choose
        /// <code>messageTag</code>. If you want Amazon SES to use your own email headers, choose
        /// <code>emailHeader</code>.</p>
        pub fn set_dimension_value_source(
            mut self,
            input: std::option::Option<crate::model::DimensionValueSource>,
        ) -> Self {
            self.dimension_value_source = input;
            self
        }
        /// <p>The default value of the dimension that is published to Amazon CloudWatch if you do not provide
        /// the value of the dimension when you send an email. The default value must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn default_dimension_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_dimension_value = Some(input.into());
            self
        }
        /// <p>The default value of the dimension that is published to Amazon CloudWatch if you do not provide
        /// the value of the dimension when you send an email. The default value must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_default_dimension_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_dimension_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
        pub fn build(self) -> crate::model::CloudWatchDimensionConfiguration {
            crate::model::CloudWatchDimensionConfiguration {
                dimension_name: self.dimension_name,
                dimension_value_source: self.dimension_value_source,
                default_dimension_value: self.default_dimension_value,
            }
        }
    }
}
impl CloudWatchDimensionConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudWatchDimensionConfiguration`](crate::model::CloudWatchDimensionConfiguration)
    pub fn builder() -> crate::model::cloud_watch_dimension_configuration::Builder {
        crate::model::cloud_watch_dimension_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DimensionValueSource {
    #[allow(missing_docs)] // documentation missing in model
    EmailHeader,
    #[allow(missing_docs)] // documentation missing in model
    LinkTag,
    #[allow(missing_docs)] // documentation missing in model
    MessageTag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DimensionValueSource {
    fn from(s: &str) -> Self {
        match s {
            "emailHeader" => DimensionValueSource::EmailHeader,
            "linkTag" => DimensionValueSource::LinkTag,
            "messageTag" => DimensionValueSource::MessageTag,
            other => DimensionValueSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DimensionValueSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DimensionValueSource::from(s))
    }
}
impl DimensionValueSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DimensionValueSource::EmailHeader => "emailHeader",
            DimensionValueSource::LinkTag => "linkTag",
            DimensionValueSource::MessageTag => "messageTag",
            DimensionValueSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["emailHeader", "linkTag", "messageTag"]
    }
}
impl AsRef<str> for DimensionValueSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event
/// destination.</p>
/// <p>Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable
/// you to publish email sending events. For information about using configuration sets, see
/// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisFirehoseDestination {
    /// <p>The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
    /// stream.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.</p>
    pub delivery_stream_arn: std::option::Option<std::string::String>,
}
impl KinesisFirehoseDestination {
    /// <p>The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
    /// stream.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.</p>
    pub fn delivery_stream_arn(&self) -> std::option::Option<&str> {
        self.delivery_stream_arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisFirehoseDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisFirehoseDestination");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("delivery_stream_arn", &self.delivery_stream_arn);
        formatter.finish()
    }
}
/// See [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
pub mod kinesis_firehose_destination {
    /// A builder for [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
        /// stream.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
        /// stream.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.</p>
        pub fn delivery_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.</p>
        pub fn set_delivery_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
        pub fn build(self) -> crate::model::KinesisFirehoseDestination {
            crate::model::KinesisFirehoseDestination {
                iam_role_arn: self.iam_role_arn,
                delivery_stream_arn: self.delivery_stream_arn,
            }
        }
    }
}
impl KinesisFirehoseDestination {
    /// Creates a new builder-style object to manufacture [`KinesisFirehoseDestination`](crate::model::KinesisFirehoseDestination)
    pub fn builder() -> crate::model::kinesis_firehose_destination::Builder {
        crate::model::kinesis_firehose_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    Bounce,
    #[allow(missing_docs)] // documentation missing in model
    Click,
    #[allow(missing_docs)] // documentation missing in model
    Complaint,
    #[allow(missing_docs)] // documentation missing in model
    Delivery,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    #[allow(missing_docs)] // documentation missing in model
    RenderingFailure,
    #[allow(missing_docs)] // documentation missing in model
    Send,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "bounce" => EventType::Bounce,
            "click" => EventType::Click,
            "complaint" => EventType::Complaint,
            "delivery" => EventType::Delivery,
            "open" => EventType::Open,
            "reject" => EventType::Reject,
            "renderingFailure" => EventType::RenderingFailure,
            "send" => EventType::Send,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::Bounce => "bounce",
            EventType::Click => "click",
            EventType::Complaint => "complaint",
            EventType::Delivery => "delivery",
            EventType::Open => "open",
            EventType::Reject => "reject",
            EventType::RenderingFailure => "renderingFailure",
            EventType::Send => "send",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "bounce",
            "click",
            "complaint",
            "delivery",
            "open",
            "reject",
            "renderingFailure",
            "send",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationType {
    #[allow(missing_docs)] // documentation missing in model
    Bounce,
    #[allow(missing_docs)] // documentation missing in model
    Complaint,
    #[allow(missing_docs)] // documentation missing in model
    Delivery,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationType {
    fn from(s: &str) -> Self {
        match s {
            "Bounce" => NotificationType::Bounce,
            "Complaint" => NotificationType::Complaint,
            "Delivery" => NotificationType::Delivery,
            other => NotificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationType::from(s))
    }
}
impl NotificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationType::Bounce => "Bounce",
            NotificationType::Complaint => "Complaint",
            NotificationType::Delivery => "Delivery",
            NotificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Bounce", "Complaint", "Delivery"]
    }
}
impl AsRef<str> for NotificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BehaviorOnMxFailure {
    #[allow(missing_docs)] // documentation missing in model
    RejectMessage,
    #[allow(missing_docs)] // documentation missing in model
    UseDefaultValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BehaviorOnMxFailure {
    fn from(s: &str) -> Self {
        match s {
            "RejectMessage" => BehaviorOnMxFailure::RejectMessage,
            "UseDefaultValue" => BehaviorOnMxFailure::UseDefaultValue,
            other => BehaviorOnMxFailure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BehaviorOnMxFailure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BehaviorOnMxFailure::from(s))
    }
}
impl BehaviorOnMxFailure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BehaviorOnMxFailure::RejectMessage => "RejectMessage",
            BehaviorOnMxFailure::UseDefaultValue => "UseDefaultValue",
            BehaviorOnMxFailure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RejectMessage", "UseDefaultValue"]
    }
}
impl AsRef<str> for BehaviorOnMxFailure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the name and value of a tag that you can provide to <code>SendEmail</code> or
/// <code>SendRawEmail</code> to apply to an email.</p>
/// <p>Message tags, which you use with configuration sets, enable you to publish email
/// sending events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageTag {
    /// <p>The name of the tag. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the tag. The value must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl MessageTag {
    /// <p>The name of the tag. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the tag. The value must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 256 characters.</p>
    /// </li>
    /// </ul>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MessageTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageTag");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MessageTag`](crate::model::MessageTag)
pub mod message_tag {
    /// A builder for [`MessageTag`](crate::model::MessageTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tag. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the tag. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the tag. The value must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag. The value must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 256 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageTag`](crate::model::MessageTag)
        pub fn build(self) -> crate::model::MessageTag {
            crate::model::MessageTag {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MessageTag {
    /// Creates a new builder-style object to manufacture [`MessageTag`](crate::model::MessageTag)
    pub fn builder() -> crate::model::message_tag::Builder {
        crate::model::message_tag::Builder::default()
    }
}

/// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
/// fields.</p>
/// <note>
/// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
/// <i>local part</i> of a destination email address (the part of the
/// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
/// characters</a>. If the <i>domain part</i> of an address (the
/// part after the @ sign) contains non-ASCII characters, they must be encoded using
/// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>The recipients to place on the To: line of the message.</p>
    pub to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The recipients to place on the CC: line of the message.</p>
    pub cc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The recipients to place on the BCC: line of the message.</p>
    pub bcc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Destination {
    /// <p>The recipients to place on the To: line of the message.</p>
    pub fn to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.to_addresses.as_deref()
    }
    /// <p>The recipients to place on the CC: line of the message.</p>
    pub fn cc_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.cc_addresses.as_deref()
    }
    /// <p>The recipients to place on the BCC: line of the message.</p>
    pub fn bcc_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.bcc_addresses.as_deref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("to_addresses", &self.to_addresses);
        formatter.field("cc_addresses", &self.cc_addresses);
        formatter.field("bcc_addresses", &self.bcc_addresses);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) bcc_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `to_addresses`.
        ///
        /// To override the contents of this collection use [`set_to_addresses`](Self::set_to_addresses).
        ///
        /// <p>The recipients to place on the To: line of the message.</p>
        pub fn to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.to_addresses.unwrap_or_default();
            v.push(input.into());
            self.to_addresses = Some(v);
            self
        }
        /// <p>The recipients to place on the To: line of the message.</p>
        pub fn set_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.to_addresses = input;
            self
        }
        /// Appends an item to `cc_addresses`.
        ///
        /// To override the contents of this collection use [`set_cc_addresses`](Self::set_cc_addresses).
        ///
        /// <p>The recipients to place on the CC: line of the message.</p>
        pub fn cc_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cc_addresses.unwrap_or_default();
            v.push(input.into());
            self.cc_addresses = Some(v);
            self
        }
        /// <p>The recipients to place on the CC: line of the message.</p>
        pub fn set_cc_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cc_addresses = input;
            self
        }
        /// Appends an item to `bcc_addresses`.
        ///
        /// To override the contents of this collection use [`set_bcc_addresses`](Self::set_bcc_addresses).
        ///
        /// <p>The recipients to place on the BCC: line of the message.</p>
        pub fn bcc_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bcc_addresses.unwrap_or_default();
            v.push(input.into());
            self.bcc_addresses = Some(v);
            self
        }
        /// <p>The recipients to place on the BCC: line of the message.</p>
        pub fn set_bcc_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bcc_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                to_addresses: self.to_addresses,
                cc_addresses: self.cc_addresses,
                bcc_addresses: self.bcc_addresses,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p>Represents the raw data of the message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RawMessage {
    /// <p>The raw data of the message. This data needs to base64-encoded if you are accessing
    /// Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an AWS
    /// SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must
    /// ensure that the message format complies with Internet email standards regarding email
    /// header fields, MIME types, and MIME encoding.</p>
    /// <p>The To:, CC:, and BCC: headers in the raw message can contain a group list.</p>
    /// <p>If you are using <code>SendRawEmail</code> with sending authorization, you can include
    /// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
    /// addresses. For more information, see the documentation for <code>SendRawEmail</code>. </p>
    /// <important>
    /// <p>Do not include these X-headers in the DKIM signature, because they are removed by
    /// Amazon SES before sending the email.</p>
    /// </important>
    /// <p>For more information, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub data: std::option::Option<aws_smithy_types::Blob>,
}
impl RawMessage {
    /// <p>The raw data of the message. This data needs to base64-encoded if you are accessing
    /// Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an AWS
    /// SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must
    /// ensure that the message format complies with Internet email standards regarding email
    /// header fields, MIME types, and MIME encoding.</p>
    /// <p>The To:, CC:, and BCC: headers in the raw message can contain a group list.</p>
    /// <p>If you are using <code>SendRawEmail</code> with sending authorization, you can include
    /// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
    /// addresses. For more information, see the documentation for <code>SendRawEmail</code>. </p>
    /// <important>
    /// <p>Do not include these X-headers in the DKIM signature, because they are removed by
    /// Amazon SES before sending the email.</p>
    /// </important>
    /// <p>For more information, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn data(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.data.as_ref()
    }
}
impl std::fmt::Debug for RawMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RawMessage");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`RawMessage`](crate::model::RawMessage)
pub mod raw_message {
    /// A builder for [`RawMessage`](crate::model::RawMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The raw data of the message. This data needs to base64-encoded if you are accessing
        /// Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an AWS
        /// SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must
        /// ensure that the message format complies with Internet email standards regarding email
        /// header fields, MIME types, and MIME encoding.</p>
        /// <p>The To:, CC:, and BCC: headers in the raw message can contain a group list.</p>
        /// <p>If you are using <code>SendRawEmail</code> with sending authorization, you can include
        /// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
        /// addresses. For more information, see the documentation for <code>SendRawEmail</code>. </p>
        /// <important>
        /// <p>Do not include these X-headers in the DKIM signature, because they are removed by
        /// Amazon SES before sending the email.</p>
        /// </important>
        /// <p>For more information, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn data(mut self, input: aws_smithy_types::Blob) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>The raw data of the message. This data needs to base64-encoded if you are accessing
        /// Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES using an AWS
        /// SDK, the SDK takes care of the base 64-encoding for you. In all cases, the client must
        /// ensure that the message format complies with Internet email standards regarding email
        /// header fields, MIME types, and MIME encoding.</p>
        /// <p>The To:, CC:, and BCC: headers in the raw message can contain a group list.</p>
        /// <p>If you are using <code>SendRawEmail</code> with sending authorization, you can include
        /// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
        /// addresses. For more information, see the documentation for <code>SendRawEmail</code>. </p>
        /// <important>
        /// <p>Do not include these X-headers in the DKIM signature, because they are removed by
        /// Amazon SES before sending the email.</p>
        /// </important>
        /// <p>For more information, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_data(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`RawMessage`](crate::model::RawMessage)
        pub fn build(self) -> crate::model::RawMessage {
            crate::model::RawMessage { data: self.data }
        }
    }
}
impl RawMessage {
    /// Creates a new builder-style object to manufacture [`RawMessage`](crate::model::RawMessage)
    pub fn builder() -> crate::model::raw_message::Builder {
        crate::model::raw_message::Builder::default()
    }
}

/// <p>Represents the message to be sent, composed of a subject and a body.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The subject of the message: A short summary of the content, which will appear in the
    /// recipient's inbox.</p>
    pub subject: std::option::Option<crate::model::Content>,
    /// <p>The message body.</p>
    pub body: std::option::Option<crate::model::Body>,
}
impl Message {
    /// <p>The subject of the message: A short summary of the content, which will appear in the
    /// recipient's inbox.</p>
    pub fn subject(&self) -> std::option::Option<&crate::model::Content> {
        self.subject.as_ref()
    }
    /// <p>The message body.</p>
    pub fn body(&self) -> std::option::Option<&crate::model::Body> {
        self.body.as_ref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("subject", &self.subject);
        formatter.field("body", &self.body);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subject: std::option::Option<crate::model::Content>,
        pub(crate) body: std::option::Option<crate::model::Body>,
    }
    impl Builder {
        /// <p>The subject of the message: A short summary of the content, which will appear in the
        /// recipient's inbox.</p>
        pub fn subject(mut self, input: crate::model::Content) -> Self {
            self.subject = Some(input);
            self
        }
        /// <p>The subject of the message: A short summary of the content, which will appear in the
        /// recipient's inbox.</p>
        pub fn set_subject(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The message body.</p>
        pub fn body(mut self, input: crate::model::Body) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The message body.</p>
        pub fn set_body(mut self, input: std::option::Option<crate::model::Body>) -> Self {
            self.body = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                subject: self.subject,
                body: self.body,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>Represents the body of the message. You can specify text, HTML, or both. If you use
/// both, then the message should display correctly in the widest variety of email
/// clients.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Body {
    /// <p>The content of the message, in text format. Use this for text-based email clients, or
    /// clients on high-latency networks (such as mobile devices).</p>
    pub text: std::option::Option<crate::model::Content>,
    /// <p>The content of the message, in HTML format. Use this for email clients that can
    /// process HTML. You can include clickable links, formatted text, and much more in an HTML
    /// message.</p>
    pub html: std::option::Option<crate::model::Content>,
}
impl Body {
    /// <p>The content of the message, in text format. Use this for text-based email clients, or
    /// clients on high-latency networks (such as mobile devices).</p>
    pub fn text(&self) -> std::option::Option<&crate::model::Content> {
        self.text.as_ref()
    }
    /// <p>The content of the message, in HTML format. Use this for email clients that can
    /// process HTML. You can include clickable links, formatted text, and much more in an HTML
    /// message.</p>
    pub fn html(&self) -> std::option::Option<&crate::model::Content> {
        self.html.as_ref()
    }
}
impl std::fmt::Debug for Body {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Body");
        formatter.field("text", &self.text);
        formatter.field("html", &self.html);
        formatter.finish()
    }
}
/// See [`Body`](crate::model::Body)
pub mod body {
    /// A builder for [`Body`](crate::model::Body)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<crate::model::Content>,
        pub(crate) html: std::option::Option<crate::model::Content>,
    }
    impl Builder {
        /// <p>The content of the message, in text format. Use this for text-based email clients, or
        /// clients on high-latency networks (such as mobile devices).</p>
        pub fn text(mut self, input: crate::model::Content) -> Self {
            self.text = Some(input);
            self
        }
        /// <p>The content of the message, in text format. Use this for text-based email clients, or
        /// clients on high-latency networks (such as mobile devices).</p>
        pub fn set_text(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.text = input;
            self
        }
        /// <p>The content of the message, in HTML format. Use this for email clients that can
        /// process HTML. You can include clickable links, formatted text, and much more in an HTML
        /// message.</p>
        pub fn html(mut self, input: crate::model::Content) -> Self {
            self.html = Some(input);
            self
        }
        /// <p>The content of the message, in HTML format. Use this for email clients that can
        /// process HTML. You can include clickable links, formatted text, and much more in an HTML
        /// message.</p>
        pub fn set_html(mut self, input: std::option::Option<crate::model::Content>) -> Self {
            self.html = input;
            self
        }
        /// Consumes the builder and constructs a [`Body`](crate::model::Body)
        pub fn build(self) -> crate::model::Body {
            crate::model::Body {
                text: self.text,
                html: self.html,
            }
        }
    }
}
impl Body {
    /// Creates a new builder-style object to manufacture [`Body`](crate::model::Body)
    pub fn builder() -> crate::model::body::Builder {
        crate::model::body::Builder::default()
    }
}

/// <p>Represents textual data, plus an optional character set specification.</p>
/// <p>By default, the text must be 7-bit ASCII, due to the constraints of the SMTP protocol.
/// If the text must contain any other characters, then you must also specify a character
/// set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Content {
    /// <p>The textual data of the content.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The character set of the content.</p>
    pub charset: std::option::Option<std::string::String>,
}
impl Content {
    /// <p>The textual data of the content.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The character set of the content.</p>
    pub fn charset(&self) -> std::option::Option<&str> {
        self.charset.as_deref()
    }
}
impl std::fmt::Debug for Content {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Content");
        formatter.field("data", &self.data);
        formatter.field("charset", &self.charset);
        formatter.finish()
    }
}
/// See [`Content`](crate::model::Content)
pub mod content {
    /// A builder for [`Content`](crate::model::Content)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) charset: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The textual data of the content.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The textual data of the content.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The character set of the content.</p>
        pub fn charset(mut self, input: impl Into<std::string::String>) -> Self {
            self.charset = Some(input.into());
            self
        }
        /// <p>The character set of the content.</p>
        pub fn set_charset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.charset = input;
            self
        }
        /// Consumes the builder and constructs a [`Content`](crate::model::Content)
        pub fn build(self) -> crate::model::Content {
            crate::model::Content {
                data: self.data,
                charset: self.charset,
            }
        }
    }
}
impl Content {
    /// Creates a new builder-style object to manufacture [`Content`](crate::model::Content)
    pub fn builder() -> crate::model::content::Builder {
        crate::model::content::Builder::default()
    }
}

/// <p>An object that contains the response from the <code>SendBulkTemplatedEmail</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkEmailDestinationStatus {
    /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    /// <p>Possible values for this parameter include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Success</code>: Amazon SES accepted the message, and will attempt to deliver
    /// it to the recipients.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MessageRejected</code>: The message was rejected because it contained a
    /// virus.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MailFromDomainNotVerified</code>: The sender's email address or domain
    /// was not verified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSetDoesNotExist</code>: The configuration set you specified
    /// does not exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TemplateDoesNotExist</code>: The template you specified does not
    /// exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountSuspended</code>: Your account has been shut down because of
    /// issues related to your email sending practices.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountThrottled</code>: The number of emails you can send has been
    /// reduced because your account has exceeded its allocated sending limit.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountDailyQuotaExceeded</code>: You have reached or exceeded the
    /// maximum number of emails you can send from your account in a 24-hour
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InvalidSendingPoolName</code>: The configuration set you specified
    /// refers to an IP pool that does not exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountSendingPaused</code>: Email sending for the Amazon SES account was
    /// disabled using the <a>UpdateAccountSendingEnabled</a>
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSetSendingPaused</code>: Email sending for this
    /// configuration set was disabled using the <a>UpdateConfigurationSetSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InvalidParameterValue</code>: One or more of the parameters you
    /// specified when calling this operation was invalid. See the error message for
    /// additional information.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TransientFailure</code>: Amazon SES was unable to process your request
    /// because of a temporary issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>: Amazon SES was unable to process your request. See the error
    /// message for additional information.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::BulkEmailStatus>,
    /// <p>A description of an error that prevented a message being sent using the
    /// <code>SendBulkTemplatedEmail</code> operation.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl BulkEmailDestinationStatus {
    /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    /// <p>Possible values for this parameter include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Success</code>: Amazon SES accepted the message, and will attempt to deliver
    /// it to the recipients.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MessageRejected</code>: The message was rejected because it contained a
    /// virus.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MailFromDomainNotVerified</code>: The sender's email address or domain
    /// was not verified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSetDoesNotExist</code>: The configuration set you specified
    /// does not exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TemplateDoesNotExist</code>: The template you specified does not
    /// exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountSuspended</code>: Your account has been shut down because of
    /// issues related to your email sending practices.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountThrottled</code>: The number of emails you can send has been
    /// reduced because your account has exceeded its allocated sending limit.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountDailyQuotaExceeded</code>: You have reached or exceeded the
    /// maximum number of emails you can send from your account in a 24-hour
    /// period.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InvalidSendingPoolName</code>: The configuration set you specified
    /// refers to an IP pool that does not exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountSendingPaused</code>: Email sending for the Amazon SES account was
    /// disabled using the <a>UpdateAccountSendingEnabled</a>
    /// operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfigurationSetSendingPaused</code>: Email sending for this
    /// configuration set was disabled using the <a>UpdateConfigurationSetSendingEnabled</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InvalidParameterValue</code>: One or more of the parameters you
    /// specified when calling this operation was invalid. See the error message for
    /// additional information.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TransientFailure</code>: Amazon SES was unable to process your request
    /// because of a temporary issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>: Amazon SES was unable to process your request. See the error
    /// message for additional information.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::BulkEmailStatus> {
        self.status.as_ref()
    }
    /// <p>A description of an error that prevented a message being sent using the
    /// <code>SendBulkTemplatedEmail</code> operation.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// operation.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for BulkEmailDestinationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkEmailDestinationStatus");
        formatter.field("status", &self.status);
        formatter.field("error", &self.error);
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`BulkEmailDestinationStatus`](crate::model::BulkEmailDestinationStatus)
pub mod bulk_email_destination_status {
    /// A builder for [`BulkEmailDestinationStatus`](crate::model::BulkEmailDestinationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BulkEmailStatus>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        /// <p>Possible values for this parameter include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Success</code>: Amazon SES accepted the message, and will attempt to deliver
        /// it to the recipients.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRejected</code>: The message was rejected because it contained a
        /// virus.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MailFromDomainNotVerified</code>: The sender's email address or domain
        /// was not verified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSetDoesNotExist</code>: The configuration set you specified
        /// does not exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TemplateDoesNotExist</code>: The template you specified does not
        /// exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountSuspended</code>: Your account has been shut down because of
        /// issues related to your email sending practices.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountThrottled</code>: The number of emails you can send has been
        /// reduced because your account has exceeded its allocated sending limit.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountDailyQuotaExceeded</code>: You have reached or exceeded the
        /// maximum number of emails you can send from your account in a 24-hour
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidSendingPoolName</code>: The configuration set you specified
        /// refers to an IP pool that does not exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountSendingPaused</code>: Email sending for the Amazon SES account was
        /// disabled using the <a>UpdateAccountSendingEnabled</a>
        /// operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSetSendingPaused</code>: Email sending for this
        /// configuration set was disabled using the <a>UpdateConfigurationSetSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidParameterValue</code>: One or more of the parameters you
        /// specified when calling this operation was invalid. See the error message for
        /// additional information.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TransientFailure</code>: Amazon SES was unable to process your request
        /// because of a temporary issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Amazon SES was unable to process your request. See the error
        /// message for additional information.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::BulkEmailStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a message sent using the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        /// <p>Possible values for this parameter include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Success</code>: Amazon SES accepted the message, and will attempt to deliver
        /// it to the recipients.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRejected</code>: The message was rejected because it contained a
        /// virus.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MailFromDomainNotVerified</code>: The sender's email address or domain
        /// was not verified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSetDoesNotExist</code>: The configuration set you specified
        /// does not exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TemplateDoesNotExist</code>: The template you specified does not
        /// exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountSuspended</code>: Your account has been shut down because of
        /// issues related to your email sending practices.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountThrottled</code>: The number of emails you can send has been
        /// reduced because your account has exceeded its allocated sending limit.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountDailyQuotaExceeded</code>: You have reached or exceeded the
        /// maximum number of emails you can send from your account in a 24-hour
        /// period.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidSendingPoolName</code>: The configuration set you specified
        /// refers to an IP pool that does not exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountSendingPaused</code>: Email sending for the Amazon SES account was
        /// disabled using the <a>UpdateAccountSendingEnabled</a>
        /// operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfigurationSetSendingPaused</code>: Email sending for this
        /// configuration set was disabled using the <a>UpdateConfigurationSetSendingEnabled</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidParameterValue</code>: One or more of the parameters you
        /// specified when calling this operation was invalid. See the error message for
        /// additional information.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TransientFailure</code>: Amazon SES was unable to process your request
        /// because of a temporary issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>: Amazon SES was unable to process your request. See the error
        /// message for additional information.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BulkEmailStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description of an error that prevented a message being sent using the
        /// <code>SendBulkTemplatedEmail</code> operation.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>A description of an error that prevented a message being sent using the
        /// <code>SendBulkTemplatedEmail</code> operation.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// operation.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkEmailDestinationStatus`](crate::model::BulkEmailDestinationStatus)
        pub fn build(self) -> crate::model::BulkEmailDestinationStatus {
            crate::model::BulkEmailDestinationStatus {
                status: self.status,
                error: self.error,
                message_id: self.message_id,
            }
        }
    }
}
impl BulkEmailDestinationStatus {
    /// Creates a new builder-style object to manufacture [`BulkEmailDestinationStatus`](crate::model::BulkEmailDestinationStatus)
    pub fn builder() -> crate::model::bulk_email_destination_status::Builder {
        crate::model::bulk_email_destination_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BulkEmailStatus {
    #[allow(missing_docs)] // documentation missing in model
    AccountDailyQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AccountSendingPaused,
    #[allow(missing_docs)] // documentation missing in model
    AccountSuspended,
    #[allow(missing_docs)] // documentation missing in model
    AccountThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSetDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationSetSendingPaused,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameterValue,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSendingPoolName,
    #[allow(missing_docs)] // documentation missing in model
    MailFromDomainNotVerified,
    #[allow(missing_docs)] // documentation missing in model
    MessageRejected,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemplateDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    TransientFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BulkEmailStatus {
    fn from(s: &str) -> Self {
        match s {
            "AccountDailyQuotaExceeded" => BulkEmailStatus::AccountDailyQuotaExceeded,
            "AccountSendingPaused" => BulkEmailStatus::AccountSendingPaused,
            "AccountSuspended" => BulkEmailStatus::AccountSuspended,
            "AccountThrottled" => BulkEmailStatus::AccountThrottled,
            "ConfigurationSetDoesNotExist" => BulkEmailStatus::ConfigurationSetDoesNotExist,
            "ConfigurationSetSendingPaused" => BulkEmailStatus::ConfigurationSetSendingPaused,
            "Failed" => BulkEmailStatus::Failed,
            "InvalidParameterValue" => BulkEmailStatus::InvalidParameterValue,
            "InvalidSendingPoolName" => BulkEmailStatus::InvalidSendingPoolName,
            "MailFromDomainNotVerified" => BulkEmailStatus::MailFromDomainNotVerified,
            "MessageRejected" => BulkEmailStatus::MessageRejected,
            "Success" => BulkEmailStatus::Success,
            "TemplateDoesNotExist" => BulkEmailStatus::TemplateDoesNotExist,
            "TransientFailure" => BulkEmailStatus::TransientFailure,
            other => BulkEmailStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BulkEmailStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BulkEmailStatus::from(s))
    }
}
impl BulkEmailStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BulkEmailStatus::AccountDailyQuotaExceeded => "AccountDailyQuotaExceeded",
            BulkEmailStatus::AccountSendingPaused => "AccountSendingPaused",
            BulkEmailStatus::AccountSuspended => "AccountSuspended",
            BulkEmailStatus::AccountThrottled => "AccountThrottled",
            BulkEmailStatus::ConfigurationSetDoesNotExist => "ConfigurationSetDoesNotExist",
            BulkEmailStatus::ConfigurationSetSendingPaused => "ConfigurationSetSendingPaused",
            BulkEmailStatus::Failed => "Failed",
            BulkEmailStatus::InvalidParameterValue => "InvalidParameterValue",
            BulkEmailStatus::InvalidSendingPoolName => "InvalidSendingPoolName",
            BulkEmailStatus::MailFromDomainNotVerified => "MailFromDomainNotVerified",
            BulkEmailStatus::MessageRejected => "MessageRejected",
            BulkEmailStatus::Success => "Success",
            BulkEmailStatus::TemplateDoesNotExist => "TemplateDoesNotExist",
            BulkEmailStatus::TransientFailure => "TransientFailure",
            BulkEmailStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountDailyQuotaExceeded",
            "AccountSendingPaused",
            "AccountSuspended",
            "AccountThrottled",
            "ConfigurationSetDoesNotExist",
            "ConfigurationSetSendingPaused",
            "Failed",
            "InvalidParameterValue",
            "InvalidSendingPoolName",
            "MailFromDomainNotVerified",
            "MessageRejected",
            "Success",
            "TemplateDoesNotExist",
            "TransientFailure",
        ]
    }
}
impl AsRef<str> for BulkEmailStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An array that contains one or more Destinations, as well as the tags and replacement
/// data associated with each of those Destinations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkEmailDestination {
    /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
    /// fields.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a destination email address (the part of the
    /// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
    /// </note>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the
    /// email that you define, so that you can publish email sending events.</p>
    pub replacement_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub replacement_template_data: std::option::Option<std::string::String>,
}
impl BulkEmailDestination {
    /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
    /// fields.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a destination email address (the part of the
    /// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
    /// </note>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the
    /// email that you define, so that you can publish email sending events.</p>
    pub fn replacement_tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.replacement_tags.as_deref()
    }
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub fn replacement_template_data(&self) -> std::option::Option<&str> {
        self.replacement_template_data.as_deref()
    }
}
impl std::fmt::Debug for BulkEmailDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkEmailDestination");
        formatter.field("destination", &self.destination);
        formatter.field("replacement_tags", &self.replacement_tags);
        formatter.field("replacement_template_data", &self.replacement_template_data);
        formatter.finish()
    }
}
/// See [`BulkEmailDestination`](crate::model::BulkEmailDestination)
pub mod bulk_email_destination {
    /// A builder for [`BulkEmailDestination`](crate::model::BulkEmailDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) replacement_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) replacement_template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
        /// fields.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a destination email address (the part of the
        /// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
        /// </note>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Represents the destination of the message, consisting of To:, CC:, and BCC:
        /// fields.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a destination email address (the part of the
        /// email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p>
        /// </note>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Appends an item to `replacement_tags`.
        ///
        /// To override the contents of this collection use [`set_replacement_tags`](Self::set_replacement_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events.</p>
        pub fn replacement_tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.replacement_tags.unwrap_or_default();
            v.push(input.into());
            self.replacement_tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the
        /// email that you define, so that you can publish email sending events.</p>
        pub fn set_replacement_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.replacement_tags = input;
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn replacement_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.replacement_template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_replacement_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replacement_template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkEmailDestination`](crate::model::BulkEmailDestination)
        pub fn build(self) -> crate::model::BulkEmailDestination {
            crate::model::BulkEmailDestination {
                destination: self.destination,
                replacement_tags: self.replacement_tags,
                replacement_template_data: self.replacement_template_data,
            }
        }
    }
}
impl BulkEmailDestination {
    /// Creates a new builder-style object to manufacture [`BulkEmailDestination`](crate::model::BulkEmailDestination)
    pub fn builder() -> crate::model::bulk_email_destination::Builder {
        crate::model::bulk_email_destination::Builder::default()
    }
}

/// <p>Recipient-related information to include in the Delivery Status Notification (DSN)
/// when an email that Amazon SES receives on your behalf bounces.</p>
/// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BouncedRecipientInfo {
    /// <p>The email address of the recipient of the bounced email.</p>
    pub recipient: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to receive
    /// email for the recipient of the bounced email. For more information about sending
    /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub recipient_arn: std::option::Option<std::string::String>,
    /// <p>The reason for the bounce. You must provide either this parameter or
    /// <code>RecipientDsnFields</code>.</p>
    pub bounce_type: std::option::Option<crate::model::BounceType>,
    /// <p>Recipient-related DSN fields, most of which would normally be filled in automatically
    /// when provided with a <code>BounceType</code>. You must provide either this parameter or
    /// <code>BounceType</code>.</p>
    pub recipient_dsn_fields: std::option::Option<crate::model::RecipientDsnFields>,
}
impl BouncedRecipientInfo {
    /// <p>The email address of the recipient of the bounced email.</p>
    pub fn recipient(&self) -> std::option::Option<&str> {
        self.recipient.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to receive
    /// email for the recipient of the bounced email. For more information about sending
    /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn recipient_arn(&self) -> std::option::Option<&str> {
        self.recipient_arn.as_deref()
    }
    /// <p>The reason for the bounce. You must provide either this parameter or
    /// <code>RecipientDsnFields</code>.</p>
    pub fn bounce_type(&self) -> std::option::Option<&crate::model::BounceType> {
        self.bounce_type.as_ref()
    }
    /// <p>Recipient-related DSN fields, most of which would normally be filled in automatically
    /// when provided with a <code>BounceType</code>. You must provide either this parameter or
    /// <code>BounceType</code>.</p>
    pub fn recipient_dsn_fields(&self) -> std::option::Option<&crate::model::RecipientDsnFields> {
        self.recipient_dsn_fields.as_ref()
    }
}
impl std::fmt::Debug for BouncedRecipientInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BouncedRecipientInfo");
        formatter.field("recipient", &self.recipient);
        formatter.field("recipient_arn", &self.recipient_arn);
        formatter.field("bounce_type", &self.bounce_type);
        formatter.field("recipient_dsn_fields", &self.recipient_dsn_fields);
        formatter.finish()
    }
}
/// See [`BouncedRecipientInfo`](crate::model::BouncedRecipientInfo)
pub mod bounced_recipient_info {
    /// A builder for [`BouncedRecipientInfo`](crate::model::BouncedRecipientInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipient: std::option::Option<std::string::String>,
        pub(crate) recipient_arn: std::option::Option<std::string::String>,
        pub(crate) bounce_type: std::option::Option<crate::model::BounceType>,
        pub(crate) recipient_dsn_fields: std::option::Option<crate::model::RecipientDsnFields>,
    }
    impl Builder {
        /// <p>The email address of the recipient of the bounced email.</p>
        pub fn recipient(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipient = Some(input.into());
            self
        }
        /// <p>The email address of the recipient of the bounced email.</p>
        pub fn set_recipient(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipient = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to receive
        /// email for the recipient of the bounced email. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn recipient_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipient_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to receive
        /// email for the recipient of the bounced email. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_recipient_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recipient_arn = input;
            self
        }
        /// <p>The reason for the bounce. You must provide either this parameter or
        /// <code>RecipientDsnFields</code>.</p>
        pub fn bounce_type(mut self, input: crate::model::BounceType) -> Self {
            self.bounce_type = Some(input);
            self
        }
        /// <p>The reason for the bounce. You must provide either this parameter or
        /// <code>RecipientDsnFields</code>.</p>
        pub fn set_bounce_type(
            mut self,
            input: std::option::Option<crate::model::BounceType>,
        ) -> Self {
            self.bounce_type = input;
            self
        }
        /// <p>Recipient-related DSN fields, most of which would normally be filled in automatically
        /// when provided with a <code>BounceType</code>. You must provide either this parameter or
        /// <code>BounceType</code>.</p>
        pub fn recipient_dsn_fields(mut self, input: crate::model::RecipientDsnFields) -> Self {
            self.recipient_dsn_fields = Some(input);
            self
        }
        /// <p>Recipient-related DSN fields, most of which would normally be filled in automatically
        /// when provided with a <code>BounceType</code>. You must provide either this parameter or
        /// <code>BounceType</code>.</p>
        pub fn set_recipient_dsn_fields(
            mut self,
            input: std::option::Option<crate::model::RecipientDsnFields>,
        ) -> Self {
            self.recipient_dsn_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`BouncedRecipientInfo`](crate::model::BouncedRecipientInfo)
        pub fn build(self) -> crate::model::BouncedRecipientInfo {
            crate::model::BouncedRecipientInfo {
                recipient: self.recipient,
                recipient_arn: self.recipient_arn,
                bounce_type: self.bounce_type,
                recipient_dsn_fields: self.recipient_dsn_fields,
            }
        }
    }
}
impl BouncedRecipientInfo {
    /// Creates a new builder-style object to manufacture [`BouncedRecipientInfo`](crate::model::BouncedRecipientInfo)
    pub fn builder() -> crate::model::bounced_recipient_info::Builder {
        crate::model::bounced_recipient_info::Builder::default()
    }
}

/// <p>Recipient-related information to include in the Delivery Status Notification (DSN)
/// when an email that Amazon SES receives on your behalf bounces.</p>
/// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecipientDsnFields {
    /// <p>The email address that the message was ultimately delivered to. This corresponds to
    /// the <code>Final-Recipient</code> in the DSN. If not specified,
    /// <code>FinalRecipient</code> will be set to the <code>Recipient</code> specified in
    /// the <code>BouncedRecipientInfo</code> structure. Either <code>FinalRecipient</code> or
    /// the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the original
    /// bounced message.</p>
    /// <note>
    /// <p>Do not prepend the <code>FinalRecipient</code> email address with <code>rfc
    /// 822;</code>, as described in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.</p>
    /// </note>
    pub final_recipient: std::option::Option<std::string::String>,
    /// <p>The action performed by the reporting mail transfer agent (MTA) as a result of its
    /// attempt to deliver the message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
    pub action: std::option::Option<crate::model::DsnAction>,
    /// <p>The MTA to which the remote MTA attempted to deliver the message, formatted as
    /// specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
    /// (<code>mta-name-type; mta-name</code>). This parameter typically applies only to
    /// propagating synchronous bounces.</p>
    pub remote_mta: std::option::Option<std::string::String>,
    /// <p>The status code that indicates what went wrong. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>An extended explanation of what went wrong; this is usually an SMTP response. See
    /// <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct
    /// formatting of this parameter.</p>
    pub diagnostic_code: std::option::Option<std::string::String>,
    /// <p>The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
    pub last_attempt_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Additional X-headers to include in the DSN.</p>
    pub extension_fields: std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
}
impl RecipientDsnFields {
    /// <p>The email address that the message was ultimately delivered to. This corresponds to
    /// the <code>Final-Recipient</code> in the DSN. If not specified,
    /// <code>FinalRecipient</code> will be set to the <code>Recipient</code> specified in
    /// the <code>BouncedRecipientInfo</code> structure. Either <code>FinalRecipient</code> or
    /// the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the original
    /// bounced message.</p>
    /// <note>
    /// <p>Do not prepend the <code>FinalRecipient</code> email address with <code>rfc
    /// 822;</code>, as described in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.</p>
    /// </note>
    pub fn final_recipient(&self) -> std::option::Option<&str> {
        self.final_recipient.as_deref()
    }
    /// <p>The action performed by the reporting mail transfer agent (MTA) as a result of its
    /// attempt to deliver the message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::DsnAction> {
        self.action.as_ref()
    }
    /// <p>The MTA to which the remote MTA attempted to deliver the message, formatted as
    /// specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
    /// (<code>mta-name-type; mta-name</code>). This parameter typically applies only to
    /// propagating synchronous bounces.</p>
    pub fn remote_mta(&self) -> std::option::Option<&str> {
        self.remote_mta.as_deref()
    }
    /// <p>The status code that indicates what went wrong. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>An extended explanation of what went wrong; this is usually an SMTP response. See
    /// <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct
    /// formatting of this parameter.</p>
    pub fn diagnostic_code(&self) -> std::option::Option<&str> {
        self.diagnostic_code.as_deref()
    }
    /// <p>The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
    pub fn last_attempt_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_attempt_date.as_ref()
    }
    /// <p>Additional X-headers to include in the DSN.</p>
    pub fn extension_fields(&self) -> std::option::Option<&[crate::model::ExtensionField]> {
        self.extension_fields.as_deref()
    }
}
impl std::fmt::Debug for RecipientDsnFields {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecipientDsnFields");
        formatter.field("final_recipient", &self.final_recipient);
        formatter.field("action", &self.action);
        formatter.field("remote_mta", &self.remote_mta);
        formatter.field("status", &self.status);
        formatter.field("diagnostic_code", &self.diagnostic_code);
        formatter.field("last_attempt_date", &self.last_attempt_date);
        formatter.field("extension_fields", &self.extension_fields);
        formatter.finish()
    }
}
/// See [`RecipientDsnFields`](crate::model::RecipientDsnFields)
pub mod recipient_dsn_fields {
    /// A builder for [`RecipientDsnFields`](crate::model::RecipientDsnFields)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) final_recipient: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::DsnAction>,
        pub(crate) remote_mta: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) diagnostic_code: std::option::Option<std::string::String>,
        pub(crate) last_attempt_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) extension_fields:
            std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
    }
    impl Builder {
        /// <p>The email address that the message was ultimately delivered to. This corresponds to
        /// the <code>Final-Recipient</code> in the DSN. If not specified,
        /// <code>FinalRecipient</code> will be set to the <code>Recipient</code> specified in
        /// the <code>BouncedRecipientInfo</code> structure. Either <code>FinalRecipient</code> or
        /// the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the original
        /// bounced message.</p>
        /// <note>
        /// <p>Do not prepend the <code>FinalRecipient</code> email address with <code>rfc
        /// 822;</code>, as described in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.</p>
        /// </note>
        pub fn final_recipient(mut self, input: impl Into<std::string::String>) -> Self {
            self.final_recipient = Some(input.into());
            self
        }
        /// <p>The email address that the message was ultimately delivered to. This corresponds to
        /// the <code>Final-Recipient</code> in the DSN. If not specified,
        /// <code>FinalRecipient</code> will be set to the <code>Recipient</code> specified in
        /// the <code>BouncedRecipientInfo</code> structure. Either <code>FinalRecipient</code> or
        /// the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the original
        /// bounced message.</p>
        /// <note>
        /// <p>Do not prepend the <code>FinalRecipient</code> email address with <code>rfc
        /// 822;</code>, as described in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.</p>
        /// </note>
        pub fn set_final_recipient(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_recipient = input;
            self
        }
        /// <p>The action performed by the reporting mail transfer agent (MTA) as a result of its
        /// attempt to deliver the message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
        pub fn action(mut self, input: crate::model::DsnAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action performed by the reporting mail transfer agent (MTA) as a result of its
        /// attempt to deliver the message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::DsnAction>) -> Self {
            self.action = input;
            self
        }
        /// <p>The MTA to which the remote MTA attempted to deliver the message, formatted as
        /// specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
        /// (<code>mta-name-type; mta-name</code>). This parameter typically applies only to
        /// propagating synchronous bounces.</p>
        pub fn remote_mta(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_mta = Some(input.into());
            self
        }
        /// <p>The MTA to which the remote MTA attempted to deliver the message, formatted as
        /// specified in <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
        /// (<code>mta-name-type; mta-name</code>). This parameter typically applies only to
        /// propagating synchronous bounces.</p>
        pub fn set_remote_mta(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.remote_mta = input;
            self
        }
        /// <p>The status code that indicates what went wrong. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status code that indicates what went wrong. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>An extended explanation of what went wrong; this is usually an SMTP response. See
        /// <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct
        /// formatting of this parameter.</p>
        pub fn diagnostic_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.diagnostic_code = Some(input.into());
            self
        }
        /// <p>An extended explanation of what went wrong; this is usually an SMTP response. See
        /// <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct
        /// formatting of this parameter.</p>
        pub fn set_diagnostic_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.diagnostic_code = input;
            self
        }
        /// <p>The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
        pub fn last_attempt_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_attempt_date = Some(input);
            self
        }
        /// <p>The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
        pub fn set_last_attempt_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_attempt_date = input;
            self
        }
        /// Appends an item to `extension_fields`.
        ///
        /// To override the contents of this collection use [`set_extension_fields`](Self::set_extension_fields).
        ///
        /// <p>Additional X-headers to include in the DSN.</p>
        pub fn extension_fields(mut self, input: impl Into<crate::model::ExtensionField>) -> Self {
            let mut v = self.extension_fields.unwrap_or_default();
            v.push(input.into());
            self.extension_fields = Some(v);
            self
        }
        /// <p>Additional X-headers to include in the DSN.</p>
        pub fn set_extension_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
        ) -> Self {
            self.extension_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`RecipientDsnFields`](crate::model::RecipientDsnFields)
        pub fn build(self) -> crate::model::RecipientDsnFields {
            crate::model::RecipientDsnFields {
                final_recipient: self.final_recipient,
                action: self.action,
                remote_mta: self.remote_mta,
                status: self.status,
                diagnostic_code: self.diagnostic_code,
                last_attempt_date: self.last_attempt_date,
                extension_fields: self.extension_fields,
            }
        }
    }
}
impl RecipientDsnFields {
    /// Creates a new builder-style object to manufacture [`RecipientDsnFields`](crate::model::RecipientDsnFields)
    pub fn builder() -> crate::model::recipient_dsn_fields::Builder {
        crate::model::recipient_dsn_fields::Builder::default()
    }
}

/// <p>Additional X-headers to include in the Delivery Status Notification (DSN) when an
/// email that Amazon SES receives on your behalf bounces.</p>
/// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtensionField {
    /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
    /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the header to add. Must be less than 2048 characters, and must not
    /// contain newline characters ("\r" or "\n").</p>
    pub value: std::option::Option<std::string::String>,
}
impl ExtensionField {
    /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
    /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the header to add. Must be less than 2048 characters, and must not
    /// contain newline characters ("\r" or "\n").</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ExtensionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtensionField");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExtensionField`](crate::model::ExtensionField)
pub mod extension_field {
    /// A builder for [`ExtensionField`](crate::model::ExtensionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
        /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the header to add. Must be between 1 and 50 characters, inclusive, and
        /// consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the header to add. Must be less than 2048 characters, and must not
        /// contain newline characters ("\r" or "\n").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the header to add. Must be less than 2048 characters, and must not
        /// contain newline characters ("\r" or "\n").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtensionField`](crate::model::ExtensionField)
        pub fn build(self) -> crate::model::ExtensionField {
            crate::model::ExtensionField {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ExtensionField {
    /// Creates a new builder-style object to manufacture [`ExtensionField`](crate::model::ExtensionField)
    pub fn builder() -> crate::model::extension_field::Builder {
        crate::model::extension_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DsnAction {
    #[allow(missing_docs)] // documentation missing in model
    Delayed,
    #[allow(missing_docs)] // documentation missing in model
    Delivered,
    #[allow(missing_docs)] // documentation missing in model
    Expanded,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Relayed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DsnAction {
    fn from(s: &str) -> Self {
        match s {
            "delayed" => DsnAction::Delayed,
            "delivered" => DsnAction::Delivered,
            "expanded" => DsnAction::Expanded,
            "failed" => DsnAction::Failed,
            "relayed" => DsnAction::Relayed,
            other => DsnAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DsnAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DsnAction::from(s))
    }
}
impl DsnAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DsnAction::Delayed => "delayed",
            DsnAction::Delivered => "delivered",
            DsnAction::Expanded => "expanded",
            DsnAction::Failed => "failed",
            DsnAction::Relayed => "relayed",
            DsnAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["delayed", "delivered", "expanded", "failed", "relayed"]
    }
}
impl AsRef<str> for DsnAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BounceType {
    #[allow(missing_docs)] // documentation missing in model
    ContentRejected,
    #[allow(missing_docs)] // documentation missing in model
    DoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    ExceededQuota,
    #[allow(missing_docs)] // documentation missing in model
    MessageTooLarge,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryFailure,
    #[allow(missing_docs)] // documentation missing in model
    Undefined,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BounceType {
    fn from(s: &str) -> Self {
        match s {
            "ContentRejected" => BounceType::ContentRejected,
            "DoesNotExist" => BounceType::DoesNotExist,
            "ExceededQuota" => BounceType::ExceededQuota,
            "MessageTooLarge" => BounceType::MessageTooLarge,
            "TemporaryFailure" => BounceType::TemporaryFailure,
            "Undefined" => BounceType::Undefined,
            other => BounceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BounceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BounceType::from(s))
    }
}
impl BounceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BounceType::ContentRejected => "ContentRejected",
            BounceType::DoesNotExist => "DoesNotExist",
            BounceType::ExceededQuota => "ExceededQuota",
            BounceType::MessageTooLarge => "MessageTooLarge",
            BounceType::TemporaryFailure => "TemporaryFailure",
            BounceType::Undefined => "Undefined",
            BounceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ContentRejected",
            "DoesNotExist",
            "ExceededQuota",
            "MessageTooLarge",
            "TemporaryFailure",
            "Undefined",
        ]
    }
}
impl AsRef<str> for BounceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Message-related information to include in the Delivery Status Notification (DSN) when
/// an email that Amazon SES receives on your behalf bounces.</p>
/// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageDsn {
    /// <p>The reporting MTA that attempted to deliver the message, formatted as specified in
    /// <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
    /// (<code>mta-name-type; mta-name</code>). The default value is <code>dns;
    /// inbound-smtp.[region].amazonaws.com</code>.</p>
    pub reporting_mta: std::option::Option<std::string::String>,
    /// <p>When the message was received by the reporting mail transfer agent (MTA), in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
    pub arrival_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Additional X-headers to include in the DSN.</p>
    pub extension_fields: std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
}
impl MessageDsn {
    /// <p>The reporting MTA that attempted to deliver the message, formatted as specified in
    /// <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
    /// (<code>mta-name-type; mta-name</code>). The default value is <code>dns;
    /// inbound-smtp.[region].amazonaws.com</code>.</p>
    pub fn reporting_mta(&self) -> std::option::Option<&str> {
        self.reporting_mta.as_deref()
    }
    /// <p>When the message was received by the reporting mail transfer agent (MTA), in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
    pub fn arrival_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.arrival_date.as_ref()
    }
    /// <p>Additional X-headers to include in the DSN.</p>
    pub fn extension_fields(&self) -> std::option::Option<&[crate::model::ExtensionField]> {
        self.extension_fields.as_deref()
    }
}
impl std::fmt::Debug for MessageDsn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageDsn");
        formatter.field("reporting_mta", &self.reporting_mta);
        formatter.field("arrival_date", &self.arrival_date);
        formatter.field("extension_fields", &self.extension_fields);
        formatter.finish()
    }
}
/// See [`MessageDsn`](crate::model::MessageDsn)
pub mod message_dsn {
    /// A builder for [`MessageDsn`](crate::model::MessageDsn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reporting_mta: std::option::Option<std::string::String>,
        pub(crate) arrival_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) extension_fields:
            std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
    }
    impl Builder {
        /// <p>The reporting MTA that attempted to deliver the message, formatted as specified in
        /// <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
        /// (<code>mta-name-type; mta-name</code>). The default value is <code>dns;
        /// inbound-smtp.[region].amazonaws.com</code>.</p>
        pub fn reporting_mta(mut self, input: impl Into<std::string::String>) -> Self {
            self.reporting_mta = Some(input.into());
            self
        }
        /// <p>The reporting MTA that attempted to deliver the message, formatted as specified in
        /// <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>
        /// (<code>mta-name-type; mta-name</code>). The default value is <code>dns;
        /// inbound-smtp.[region].amazonaws.com</code>.</p>
        pub fn set_reporting_mta(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reporting_mta = input;
            self
        }
        /// <p>When the message was received by the reporting mail transfer agent (MTA), in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
        pub fn arrival_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.arrival_date = Some(input);
            self
        }
        /// <p>When the message was received by the reporting mail transfer agent (MTA), in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a> date-time format.</p>
        pub fn set_arrival_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.arrival_date = input;
            self
        }
        /// Appends an item to `extension_fields`.
        ///
        /// To override the contents of this collection use [`set_extension_fields`](Self::set_extension_fields).
        ///
        /// <p>Additional X-headers to include in the DSN.</p>
        pub fn extension_fields(mut self, input: impl Into<crate::model::ExtensionField>) -> Self {
            let mut v = self.extension_fields.unwrap_or_default();
            v.push(input.into());
            self.extension_fields = Some(v);
            self
        }
        /// <p>Additional X-headers to include in the DSN.</p>
        pub fn set_extension_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtensionField>>,
        ) -> Self {
            self.extension_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageDsn`](crate::model::MessageDsn)
        pub fn build(self) -> crate::model::MessageDsn {
            crate::model::MessageDsn {
                reporting_mta: self.reporting_mta,
                arrival_date: self.arrival_date,
                extension_fields: self.extension_fields,
            }
        }
    }
}
impl MessageDsn {
    /// Creates a new builder-style object to manufacture [`MessageDsn`](crate::model::MessageDsn)
    pub fn builder() -> crate::model::message_dsn::Builder {
        crate::model::message_dsn::Builder::default()
    }
}

/// <p>Specifies whether messages that use the configuration set are required to use
/// Transport Layer Security (TLS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeliveryOptions {
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
    /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
    /// messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub tls_policy: std::option::Option<crate::model::TlsPolicy>,
}
impl DeliveryOptions {
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
    /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
    /// messages can be delivered in plain text if a TLS connection can't be established.</p>
    pub fn tls_policy(&self) -> std::option::Option<&crate::model::TlsPolicy> {
        self.tls_policy.as_ref()
    }
}
impl std::fmt::Debug for DeliveryOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeliveryOptions");
        formatter.field("tls_policy", &self.tls_policy);
        formatter.finish()
    }
}
/// See [`DeliveryOptions`](crate::model::DeliveryOptions)
pub mod delivery_options {
    /// A builder for [`DeliveryOptions`](crate::model::DeliveryOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tls_policy: std::option::Option<crate::model::TlsPolicy>,
    }
    impl Builder {
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn tls_policy(mut self, input: crate::model::TlsPolicy) -> Self {
            self.tls_policy = Some(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only
        /// delivered if a TLS connection can be established. If the value is <code>Optional</code>,
        /// messages can be delivered in plain text if a TLS connection can't be established.</p>
        pub fn set_tls_policy(
            mut self,
            input: std::option::Option<crate::model::TlsPolicy>,
        ) -> Self {
            self.tls_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeliveryOptions`](crate::model::DeliveryOptions)
        pub fn build(self) -> crate::model::DeliveryOptions {
            crate::model::DeliveryOptions {
                tls_policy: self.tls_policy,
            }
        }
    }
}
impl DeliveryOptions {
    /// Creates a new builder-style object to manufacture [`DeliveryOptions`](crate::model::DeliveryOptions)
    pub fn builder() -> crate::model::delivery_options::Builder {
        crate::model::delivery_options::Builder::default()
    }
}

/// <p>Contains information about an email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateMetadata {
    /// <p>The name of the template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time and date the template was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl TemplateMetadata {
    /// <p>The name of the template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time and date the template was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for TemplateMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateMetadata");
        formatter.field("name", &self.name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`TemplateMetadata`](crate::model::TemplateMetadata)
pub mod template_metadata {
    /// A builder for [`TemplateMetadata`](crate::model::TemplateMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time and date the template was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time and date the template was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateMetadata`](crate::model::TemplateMetadata)
        pub fn build(self) -> crate::model::TemplateMetadata {
            crate::model::TemplateMetadata {
                name: self.name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl TemplateMetadata {
    /// Creates a new builder-style object to manufacture [`TemplateMetadata`](crate::model::TemplateMetadata)
    pub fn builder() -> crate::model::template_metadata::Builder {
        crate::model::template_metadata::Builder::default()
    }
}

/// <p>Information about a receipt rule set.</p>
/// <p>A receipt rule set is a collection of rules that specify what Amazon SES should do with
/// mail it receives on behalf of your account's verified domains.</p>
/// <p>For information about setting up receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptRuleSetMetadata {
    /// <p>The name of the receipt rule set. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date and time the receipt rule set was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReceiptRuleSetMetadata {
    /// <p>The name of the receipt rule set. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date and time the receipt rule set was created.</p>
    pub fn created_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ReceiptRuleSetMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptRuleSetMetadata");
        formatter.field("name", &self.name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`ReceiptRuleSetMetadata`](crate::model::ReceiptRuleSetMetadata)
pub mod receipt_rule_set_metadata {
    /// A builder for [`ReceiptRuleSetMetadata`](crate::model::ReceiptRuleSetMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date and time the receipt rule set was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The date and time the receipt rule set was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptRuleSetMetadata`](crate::model::ReceiptRuleSetMetadata)
        pub fn build(self) -> crate::model::ReceiptRuleSetMetadata {
            crate::model::ReceiptRuleSetMetadata {
                name: self.name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl ReceiptRuleSetMetadata {
    /// Creates a new builder-style object to manufacture [`ReceiptRuleSetMetadata`](crate::model::ReceiptRuleSetMetadata)
    pub fn builder() -> crate::model::receipt_rule_set_metadata::Builder {
        crate::model::receipt_rule_set_metadata::Builder::default()
    }
}

/// <p>A receipt IP address filter enables you to specify whether to accept or reject mail
/// originating from an IP address or range of IP addresses.</p>
/// <p>For information about setting up IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptFilter {
    /// <p>The name of the IP address filter. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>A structure that provides the IP addresses to block or allow, and whether to block or
    /// allow incoming mail from them.</p>
    pub ip_filter: std::option::Option<crate::model::ReceiptIpFilter>,
}
impl ReceiptFilter {
    /// <p>The name of the IP address filter. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A structure that provides the IP addresses to block or allow, and whether to block or
    /// allow incoming mail from them.</p>
    pub fn ip_filter(&self) -> std::option::Option<&crate::model::ReceiptIpFilter> {
        self.ip_filter.as_ref()
    }
}
impl std::fmt::Debug for ReceiptFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptFilter");
        formatter.field("name", &self.name);
        formatter.field("ip_filter", &self.ip_filter);
        formatter.finish()
    }
}
/// See [`ReceiptFilter`](crate::model::ReceiptFilter)
pub mod receipt_filter {
    /// A builder for [`ReceiptFilter`](crate::model::ReceiptFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_filter: std::option::Option<crate::model::ReceiptIpFilter>,
    }
    impl Builder {
        /// <p>The name of the IP address filter. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the IP address filter. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A structure that provides the IP addresses to block or allow, and whether to block or
        /// allow incoming mail from them.</p>
        pub fn ip_filter(mut self, input: crate::model::ReceiptIpFilter) -> Self {
            self.ip_filter = Some(input);
            self
        }
        /// <p>A structure that provides the IP addresses to block or allow, and whether to block or
        /// allow incoming mail from them.</p>
        pub fn set_ip_filter(
            mut self,
            input: std::option::Option<crate::model::ReceiptIpFilter>,
        ) -> Self {
            self.ip_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptFilter`](crate::model::ReceiptFilter)
        pub fn build(self) -> crate::model::ReceiptFilter {
            crate::model::ReceiptFilter {
                name: self.name,
                ip_filter: self.ip_filter,
            }
        }
    }
}
impl ReceiptFilter {
    /// Creates a new builder-style object to manufacture [`ReceiptFilter`](crate::model::ReceiptFilter)
    pub fn builder() -> crate::model::receipt_filter::Builder {
        crate::model::receipt_filter::Builder::default()
    }
}

/// <p>A receipt IP address filter enables you to specify whether to accept or reject mail
/// originating from an IP address or range of IP addresses.</p>
/// <p>For information about setting up IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptIpFilter {
    /// <p>Indicates whether to block or allow incoming mail from the specified IP
    /// addresses.</p>
    pub policy: std::option::Option<crate::model::ReceiptFilterPolicy>,
    /// <p>A single IP address or a range of IP addresses that you want to block or allow,
    /// specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single
    /// email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For
    /// more information about CIDR notation, see <a href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl ReceiptIpFilter {
    /// <p>Indicates whether to block or allow incoming mail from the specified IP
    /// addresses.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ReceiptFilterPolicy> {
        self.policy.as_ref()
    }
    /// <p>A single IP address or a range of IP addresses that you want to block or allow,
    /// specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single
    /// email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For
    /// more information about CIDR notation, see <a href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
}
impl std::fmt::Debug for ReceiptIpFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptIpFilter");
        formatter.field("policy", &self.policy);
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}
/// See [`ReceiptIpFilter`](crate::model::ReceiptIpFilter)
pub mod receipt_ip_filter {
    /// A builder for [`ReceiptIpFilter`](crate::model::ReceiptIpFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ReceiptFilterPolicy>,
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether to block or allow incoming mail from the specified IP
        /// addresses.</p>
        pub fn policy(mut self, input: crate::model::ReceiptFilterPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>Indicates whether to block or allow incoming mail from the specified IP
        /// addresses.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ReceiptFilterPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// <p>A single IP address or a range of IP addresses that you want to block or allow,
        /// specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single
        /// email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For
        /// more information about CIDR notation, see <a href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>A single IP address or a range of IP addresses that you want to block or allow,
        /// specified in Classless Inter-Domain Routing (CIDR) notation. An example of a single
        /// email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24. For
        /// more information about CIDR notation, see <a href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptIpFilter`](crate::model::ReceiptIpFilter)
        pub fn build(self) -> crate::model::ReceiptIpFilter {
            crate::model::ReceiptIpFilter {
                policy: self.policy,
                cidr: self.cidr,
            }
        }
    }
}
impl ReceiptIpFilter {
    /// Creates a new builder-style object to manufacture [`ReceiptIpFilter`](crate::model::ReceiptIpFilter)
    pub fn builder() -> crate::model::receipt_ip_filter::Builder {
        crate::model::receipt_ip_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReceiptFilterPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Block,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReceiptFilterPolicy {
    fn from(s: &str) -> Self {
        match s {
            "Allow" => ReceiptFilterPolicy::Allow,
            "Block" => ReceiptFilterPolicy::Block,
            other => ReceiptFilterPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReceiptFilterPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReceiptFilterPolicy::from(s))
    }
}
impl ReceiptFilterPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReceiptFilterPolicy::Allow => "Allow",
            ReceiptFilterPolicy::Block => "Block",
            ReceiptFilterPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Allow", "Block"]
    }
}
impl AsRef<str> for ReceiptFilterPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityType {
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    EmailAddress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityType {
    fn from(s: &str) -> Self {
        match s {
            "Domain" => IdentityType::Domain,
            "EmailAddress" => IdentityType::EmailAddress,
            other => IdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityType::from(s))
    }
}
impl IdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityType::Domain => "Domain",
            IdentityType::EmailAddress => "EmailAddress",
            IdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Domain", "EmailAddress"]
    }
}
impl AsRef<str> for IdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomVerificationEmailTemplate {
    /// <p>The name of the custom verification email template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl CustomVerificationEmailTemplate {
    /// <p>The name of the custom verification email template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for CustomVerificationEmailTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomVerificationEmailTemplate");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}
/// See [`CustomVerificationEmailTemplate`](crate::model::CustomVerificationEmailTemplate)
pub mod custom_verification_email_template {
    /// A builder for [`CustomVerificationEmailTemplate`](crate::model::CustomVerificationEmailTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomVerificationEmailTemplate`](crate::model::CustomVerificationEmailTemplate)
        pub fn build(self) -> crate::model::CustomVerificationEmailTemplate {
            crate::model::CustomVerificationEmailTemplate {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            }
        }
    }
}
impl CustomVerificationEmailTemplate {
    /// Creates a new builder-style object to manufacture [`CustomVerificationEmailTemplate`](crate::model::CustomVerificationEmailTemplate)
    pub fn builder() -> crate::model::custom_verification_email_template::Builder {
        crate::model::custom_verification_email_template::Builder::default()
    }
}

/// <p>The name of the configuration set.</p>
/// <p>Configuration sets let you create groups of rules that you can apply to the emails you
/// send using Amazon SES. For more information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/using-configuration-sets.html">Using Amazon SES Configuration Sets</a> in the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSet {
    /// <p>The name of the configuration set. The name must meet the following
    /// requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes
    /// (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain 64 characters or fewer.</p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
}
impl ConfigurationSet {
    /// <p>The name of the configuration set. The name must meet the following
    /// requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes
    /// (-).</p>
    /// </li>
    /// <li>
    /// <p>Contain 64 characters or fewer.</p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ConfigurationSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSet");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ConfigurationSet`](crate::model::ConfigurationSet)
pub mod configuration_set {
    /// A builder for [`ConfigurationSet`](crate::model::ConfigurationSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set. The name must meet the following
        /// requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes
        /// (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain 64 characters or fewer.</p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set. The name must meet the following
        /// requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes
        /// (-).</p>
        /// </li>
        /// <li>
        /// <p>Contain 64 characters or fewer.</p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSet`](crate::model::ConfigurationSet)
        pub fn build(self) -> crate::model::ConfigurationSet {
            crate::model::ConfigurationSet { name: self.name }
        }
    }
}
impl ConfigurationSet {
    /// Creates a new builder-style object to manufacture [`ConfigurationSet`](crate::model::ConfigurationSet)
    pub fn builder() -> crate::model::configuration_set::Builder {
        crate::model::configuration_set::Builder::default()
    }
}

/// <p>Represents sending statistics data. Each <code>SendDataPoint</code> contains
/// statistics for a 15-minute period of sending activity. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendDataPoint {
    /// <p>Time of the data point.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Number of emails that have been sent.</p>
    pub delivery_attempts: i64,
    /// <p>Number of emails that have bounced.</p>
    pub bounces: i64,
    /// <p>Number of unwanted emails that were rejected by recipients.</p>
    pub complaints: i64,
    /// <p>Number of emails rejected by Amazon SES.</p>
    pub rejects: i64,
}
impl SendDataPoint {
    /// <p>Time of the data point.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>Number of emails that have been sent.</p>
    pub fn delivery_attempts(&self) -> i64 {
        self.delivery_attempts
    }
    /// <p>Number of emails that have bounced.</p>
    pub fn bounces(&self) -> i64 {
        self.bounces
    }
    /// <p>Number of unwanted emails that were rejected by recipients.</p>
    pub fn complaints(&self) -> i64 {
        self.complaints
    }
    /// <p>Number of emails rejected by Amazon SES.</p>
    pub fn rejects(&self) -> i64 {
        self.rejects
    }
}
impl std::fmt::Debug for SendDataPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendDataPoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("delivery_attempts", &self.delivery_attempts);
        formatter.field("bounces", &self.bounces);
        formatter.field("complaints", &self.complaints);
        formatter.field("rejects", &self.rejects);
        formatter.finish()
    }
}
/// See [`SendDataPoint`](crate::model::SendDataPoint)
pub mod send_data_point {
    /// A builder for [`SendDataPoint`](crate::model::SendDataPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) delivery_attempts: std::option::Option<i64>,
        pub(crate) bounces: std::option::Option<i64>,
        pub(crate) complaints: std::option::Option<i64>,
        pub(crate) rejects: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Time of the data point.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time of the data point.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Number of emails that have been sent.</p>
        pub fn delivery_attempts(mut self, input: i64) -> Self {
            self.delivery_attempts = Some(input);
            self
        }
        /// <p>Number of emails that have been sent.</p>
        pub fn set_delivery_attempts(mut self, input: std::option::Option<i64>) -> Self {
            self.delivery_attempts = input;
            self
        }
        /// <p>Number of emails that have bounced.</p>
        pub fn bounces(mut self, input: i64) -> Self {
            self.bounces = Some(input);
            self
        }
        /// <p>Number of emails that have bounced.</p>
        pub fn set_bounces(mut self, input: std::option::Option<i64>) -> Self {
            self.bounces = input;
            self
        }
        /// <p>Number of unwanted emails that were rejected by recipients.</p>
        pub fn complaints(mut self, input: i64) -> Self {
            self.complaints = Some(input);
            self
        }
        /// <p>Number of unwanted emails that were rejected by recipients.</p>
        pub fn set_complaints(mut self, input: std::option::Option<i64>) -> Self {
            self.complaints = input;
            self
        }
        /// <p>Number of emails rejected by Amazon SES.</p>
        pub fn rejects(mut self, input: i64) -> Self {
            self.rejects = Some(input);
            self
        }
        /// <p>Number of emails rejected by Amazon SES.</p>
        pub fn set_rejects(mut self, input: std::option::Option<i64>) -> Self {
            self.rejects = input;
            self
        }
        /// Consumes the builder and constructs a [`SendDataPoint`](crate::model::SendDataPoint)
        pub fn build(self) -> crate::model::SendDataPoint {
            crate::model::SendDataPoint {
                timestamp: self.timestamp,
                delivery_attempts: self.delivery_attempts.unwrap_or_default(),
                bounces: self.bounces.unwrap_or_default(),
                complaints: self.complaints.unwrap_or_default(),
                rejects: self.rejects.unwrap_or_default(),
            }
        }
    }
}
impl SendDataPoint {
    /// Creates a new builder-style object to manufacture [`SendDataPoint`](crate::model::SendDataPoint)
    pub fn builder() -> crate::model::send_data_point::Builder {
        crate::model::send_data_point::Builder::default()
    }
}

/// <p>Represents the verification attributes of a single identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityVerificationAttributes {
    /// <p>The verification status of the identity: "Pending", "Success", "Failed", or
    /// "TemporaryFailure".</p>
    pub verification_status: std::option::Option<crate::model::VerificationStatus>,
    /// <p>The verification token for a domain identity. Null for email address
    /// identities.</p>
    pub verification_token: std::option::Option<std::string::String>,
}
impl IdentityVerificationAttributes {
    /// <p>The verification status of the identity: "Pending", "Success", "Failed", or
    /// "TemporaryFailure".</p>
    pub fn verification_status(&self) -> std::option::Option<&crate::model::VerificationStatus> {
        self.verification_status.as_ref()
    }
    /// <p>The verification token for a domain identity. Null for email address
    /// identities.</p>
    pub fn verification_token(&self) -> std::option::Option<&str> {
        self.verification_token.as_deref()
    }
}
impl std::fmt::Debug for IdentityVerificationAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityVerificationAttributes");
        formatter.field("verification_status", &self.verification_status);
        formatter.field("verification_token", &self.verification_token);
        formatter.finish()
    }
}
/// See [`IdentityVerificationAttributes`](crate::model::IdentityVerificationAttributes)
pub mod identity_verification_attributes {
    /// A builder for [`IdentityVerificationAttributes`](crate::model::IdentityVerificationAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) verification_status: std::option::Option<crate::model::VerificationStatus>,
        pub(crate) verification_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The verification status of the identity: "Pending", "Success", "Failed", or
        /// "TemporaryFailure".</p>
        pub fn verification_status(mut self, input: crate::model::VerificationStatus) -> Self {
            self.verification_status = Some(input);
            self
        }
        /// <p>The verification status of the identity: "Pending", "Success", "Failed", or
        /// "TemporaryFailure".</p>
        pub fn set_verification_status(
            mut self,
            input: std::option::Option<crate::model::VerificationStatus>,
        ) -> Self {
            self.verification_status = input;
            self
        }
        /// <p>The verification token for a domain identity. Null for email address
        /// identities.</p>
        pub fn verification_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.verification_token = Some(input.into());
            self
        }
        /// <p>The verification token for a domain identity. Null for email address
        /// identities.</p>
        pub fn set_verification_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verification_token = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityVerificationAttributes`](crate::model::IdentityVerificationAttributes)
        pub fn build(self) -> crate::model::IdentityVerificationAttributes {
            crate::model::IdentityVerificationAttributes {
                verification_status: self.verification_status,
                verification_token: self.verification_token,
            }
        }
    }
}
impl IdentityVerificationAttributes {
    /// Creates a new builder-style object to manufacture [`IdentityVerificationAttributes`](crate::model::IdentityVerificationAttributes)
    pub fn builder() -> crate::model::identity_verification_attributes::Builder {
        crate::model::identity_verification_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerificationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerificationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => VerificationStatus::Failed,
            "NotStarted" => VerificationStatus::NotStarted,
            "Pending" => VerificationStatus::Pending,
            "Success" => VerificationStatus::Success,
            "TemporaryFailure" => VerificationStatus::TemporaryFailure,
            other => VerificationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerificationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerificationStatus::from(s))
    }
}
impl VerificationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerificationStatus::Failed => "Failed",
            VerificationStatus::NotStarted => "NotStarted",
            VerificationStatus::Pending => "Pending",
            VerificationStatus::Success => "Success",
            VerificationStatus::TemporaryFailure => "TemporaryFailure",
            VerificationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "NotStarted",
            "Pending",
            "Success",
            "TemporaryFailure",
        ]
    }
}
impl AsRef<str> for VerificationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the notification attributes of an identity, including whether an identity
/// has Amazon Simple Notification Service (Amazon SNS) topics set for bounce, complaint, and/or delivery notifications,
/// and whether feedback forwarding is enabled for bounce and complaint
/// notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityNotificationAttributes {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
    /// notifications.</p>
    pub bounce_topic: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
    /// notifications.</p>
    pub complaint_topic: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
    /// notifications.</p>
    pub delivery_topic: std::option::Option<std::string::String>,
    /// <p>Describes whether Amazon SES will forward bounce and complaint notifications as email.
    /// <code>true</code> indicates that Amazon SES will forward bounce and complaint
    /// notifications as email, while <code>false</code> indicates that bounce and complaint
    /// notifications will be published only to the specified bounce and complaint Amazon SNS
    /// topics.</p>
    pub forwarding_enabled: bool,
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include
    /// headers in bounce notifications, and a value of <code>false</code> specifies that Amazon SES
    /// will not include headers in bounce notifications.</p>
    pub headers_in_bounce_notifications_enabled: bool,
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in complaint notifications, and a value of <code>false</code> specifies
    /// that Amazon SES will not include headers in complaint notifications.</p>
    pub headers_in_complaint_notifications_enabled: bool,
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in delivery notifications, and a value of <code>false</code> specifies
    /// that Amazon SES will not include headers in delivery notifications.</p>
    pub headers_in_delivery_notifications_enabled: bool,
}
impl IdentityNotificationAttributes {
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
    /// notifications.</p>
    pub fn bounce_topic(&self) -> std::option::Option<&str> {
        self.bounce_topic.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
    /// notifications.</p>
    pub fn complaint_topic(&self) -> std::option::Option<&str> {
        self.complaint_topic.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
    /// notifications.</p>
    pub fn delivery_topic(&self) -> std::option::Option<&str> {
        self.delivery_topic.as_deref()
    }
    /// <p>Describes whether Amazon SES will forward bounce and complaint notifications as email.
    /// <code>true</code> indicates that Amazon SES will forward bounce and complaint
    /// notifications as email, while <code>false</code> indicates that bounce and complaint
    /// notifications will be published only to the specified bounce and complaint Amazon SNS
    /// topics.</p>
    pub fn forwarding_enabled(&self) -> bool {
        self.forwarding_enabled
    }
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include
    /// headers in bounce notifications, and a value of <code>false</code> specifies that Amazon SES
    /// will not include headers in bounce notifications.</p>
    pub fn headers_in_bounce_notifications_enabled(&self) -> bool {
        self.headers_in_bounce_notifications_enabled
    }
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in complaint notifications, and a value of <code>false</code> specifies
    /// that Amazon SES will not include headers in complaint notifications.</p>
    pub fn headers_in_complaint_notifications_enabled(&self) -> bool {
        self.headers_in_complaint_notifications_enabled
    }
    /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
    /// type <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in delivery notifications, and a value of <code>false</code> specifies
    /// that Amazon SES will not include headers in delivery notifications.</p>
    pub fn headers_in_delivery_notifications_enabled(&self) -> bool {
        self.headers_in_delivery_notifications_enabled
    }
}
impl std::fmt::Debug for IdentityNotificationAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityNotificationAttributes");
        formatter.field("bounce_topic", &self.bounce_topic);
        formatter.field("complaint_topic", &self.complaint_topic);
        formatter.field("delivery_topic", &self.delivery_topic);
        formatter.field("forwarding_enabled", &self.forwarding_enabled);
        formatter.field(
            "headers_in_bounce_notifications_enabled",
            &self.headers_in_bounce_notifications_enabled,
        );
        formatter.field(
            "headers_in_complaint_notifications_enabled",
            &self.headers_in_complaint_notifications_enabled,
        );
        formatter.field(
            "headers_in_delivery_notifications_enabled",
            &self.headers_in_delivery_notifications_enabled,
        );
        formatter.finish()
    }
}
/// See [`IdentityNotificationAttributes`](crate::model::IdentityNotificationAttributes)
pub mod identity_notification_attributes {
    /// A builder for [`IdentityNotificationAttributes`](crate::model::IdentityNotificationAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounce_topic: std::option::Option<std::string::String>,
        pub(crate) complaint_topic: std::option::Option<std::string::String>,
        pub(crate) delivery_topic: std::option::Option<std::string::String>,
        pub(crate) forwarding_enabled: std::option::Option<bool>,
        pub(crate) headers_in_bounce_notifications_enabled: std::option::Option<bool>,
        pub(crate) headers_in_complaint_notifications_enabled: std::option::Option<bool>,
        pub(crate) headers_in_delivery_notifications_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
        /// notifications.</p>
        pub fn bounce_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.bounce_topic = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish bounce
        /// notifications.</p>
        pub fn set_bounce_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bounce_topic = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
        /// notifications.</p>
        pub fn complaint_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.complaint_topic = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish complaint
        /// notifications.</p>
        pub fn set_complaint_topic(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.complaint_topic = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
        /// notifications.</p>
        pub fn delivery_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_topic = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will publish delivery
        /// notifications.</p>
        pub fn set_delivery_topic(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_topic = input;
            self
        }
        /// <p>Describes whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> indicates that Amazon SES will forward bounce and complaint
        /// notifications as email, while <code>false</code> indicates that bounce and complaint
        /// notifications will be published only to the specified bounce and complaint Amazon SNS
        /// topics.</p>
        pub fn forwarding_enabled(mut self, input: bool) -> Self {
            self.forwarding_enabled = Some(input);
            self
        }
        /// <p>Describes whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> indicates that Amazon SES will forward bounce and complaint
        /// notifications as email, while <code>false</code> indicates that bounce and complaint
        /// notifications will be published only to the specified bounce and complaint Amazon SNS
        /// topics.</p>
        pub fn set_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.forwarding_enabled = input;
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include
        /// headers in bounce notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in bounce notifications.</p>
        pub fn headers_in_bounce_notifications_enabled(mut self, input: bool) -> Self {
            self.headers_in_bounce_notifications_enabled = Some(input);
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES will include
        /// headers in bounce notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in bounce notifications.</p>
        pub fn set_headers_in_bounce_notifications_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.headers_in_bounce_notifications_enabled = input;
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in complaint notifications, and a value of <code>false</code> specifies
        /// that Amazon SES will not include headers in complaint notifications.</p>
        pub fn headers_in_complaint_notifications_enabled(mut self, input: bool) -> Self {
            self.headers_in_complaint_notifications_enabled = Some(input);
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in complaint notifications, and a value of <code>false</code> specifies
        /// that Amazon SES will not include headers in complaint notifications.</p>
        pub fn set_headers_in_complaint_notifications_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.headers_in_complaint_notifications_enabled = input;
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in delivery notifications, and a value of <code>false</code> specifies
        /// that Amazon SES will not include headers in delivery notifications.</p>
        pub fn headers_in_delivery_notifications_enabled(mut self, input: bool) -> Self {
            self.headers_in_delivery_notifications_enabled = Some(input);
            self
        }
        /// <p>Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of
        /// type <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in delivery notifications, and a value of <code>false</code> specifies
        /// that Amazon SES will not include headers in delivery notifications.</p>
        pub fn set_headers_in_delivery_notifications_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.headers_in_delivery_notifications_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityNotificationAttributes`](crate::model::IdentityNotificationAttributes)
        pub fn build(self) -> crate::model::IdentityNotificationAttributes {
            crate::model::IdentityNotificationAttributes {
                bounce_topic: self.bounce_topic,
                complaint_topic: self.complaint_topic,
                delivery_topic: self.delivery_topic,
                forwarding_enabled: self.forwarding_enabled.unwrap_or_default(),
                headers_in_bounce_notifications_enabled: self
                    .headers_in_bounce_notifications_enabled
                    .unwrap_or_default(),
                headers_in_complaint_notifications_enabled: self
                    .headers_in_complaint_notifications_enabled
                    .unwrap_or_default(),
                headers_in_delivery_notifications_enabled: self
                    .headers_in_delivery_notifications_enabled
                    .unwrap_or_default(),
            }
        }
    }
}
impl IdentityNotificationAttributes {
    /// Creates a new builder-style object to manufacture [`IdentityNotificationAttributes`](crate::model::IdentityNotificationAttributes)
    pub fn builder() -> crate::model::identity_notification_attributes::Builder {
        crate::model::identity_notification_attributes::Builder::default()
    }
}

/// <p>Represents the custom MAIL FROM domain attributes of a verified identity (email
/// address or domain).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityMailFromDomainAttributes {
    /// <p>The custom MAIL FROM domain that the identity is configured to use.</p>
    pub mail_from_domain: std::option::Option<std::string::String>,
    /// <p>The state that indicates whether Amazon SES has successfully read the MX record required
    /// for custom MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the
    /// specified custom MAIL FROM domain when the verified identity sends an email. All other
    /// states indicate that Amazon SES takes the action described by
    /// <code>BehaviorOnMXFailure</code>.</p>
    pub mail_from_domain_status: std::option::Option<crate::model::CustomMailFromStatus>,
    /// <p>The action that Amazon SES takes if it cannot successfully read the required MX record when
    /// you send an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES
    /// cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as
    /// the MAIL FROM domain. A value of <code>RejectMessage</code> indicates that if Amazon SES
    /// cannot read the required MX record, Amazon SES returns a
    /// <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
    /// <p>The custom MAIL FROM setup states that result in this behavior are
    /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>.</p>
    pub behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
}
impl IdentityMailFromDomainAttributes {
    /// <p>The custom MAIL FROM domain that the identity is configured to use.</p>
    pub fn mail_from_domain(&self) -> std::option::Option<&str> {
        self.mail_from_domain.as_deref()
    }
    /// <p>The state that indicates whether Amazon SES has successfully read the MX record required
    /// for custom MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the
    /// specified custom MAIL FROM domain when the verified identity sends an email. All other
    /// states indicate that Amazon SES takes the action described by
    /// <code>BehaviorOnMXFailure</code>.</p>
    pub fn mail_from_domain_status(
        &self,
    ) -> std::option::Option<&crate::model::CustomMailFromStatus> {
        self.mail_from_domain_status.as_ref()
    }
    /// <p>The action that Amazon SES takes if it cannot successfully read the required MX record when
    /// you send an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES
    /// cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as
    /// the MAIL FROM domain. A value of <code>RejectMessage</code> indicates that if Amazon SES
    /// cannot read the required MX record, Amazon SES returns a
    /// <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
    /// <p>The custom MAIL FROM setup states that result in this behavior are
    /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>.</p>
    pub fn behavior_on_mx_failure(
        &self,
    ) -> std::option::Option<&crate::model::BehaviorOnMxFailure> {
        self.behavior_on_mx_failure.as_ref()
    }
}
impl std::fmt::Debug for IdentityMailFromDomainAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityMailFromDomainAttributes");
        formatter.field("mail_from_domain", &self.mail_from_domain);
        formatter.field("mail_from_domain_status", &self.mail_from_domain_status);
        formatter.field("behavior_on_mx_failure", &self.behavior_on_mx_failure);
        formatter.finish()
    }
}
/// See [`IdentityMailFromDomainAttributes`](crate::model::IdentityMailFromDomainAttributes)
pub mod identity_mail_from_domain_attributes {
    /// A builder for [`IdentityMailFromDomainAttributes`](crate::model::IdentityMailFromDomainAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mail_from_domain: std::option::Option<std::string::String>,
        pub(crate) mail_from_domain_status: std::option::Option<crate::model::CustomMailFromStatus>,
        pub(crate) behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
    }
    impl Builder {
        /// <p>The custom MAIL FROM domain that the identity is configured to use.</p>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.mail_from_domain = Some(input.into());
            self
        }
        /// <p>The custom MAIL FROM domain that the identity is configured to use.</p>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mail_from_domain = input;
            self
        }
        /// <p>The state that indicates whether Amazon SES has successfully read the MX record required
        /// for custom MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the
        /// specified custom MAIL FROM domain when the verified identity sends an email. All other
        /// states indicate that Amazon SES takes the action described by
        /// <code>BehaviorOnMXFailure</code>.</p>
        pub fn mail_from_domain_status(
            mut self,
            input: crate::model::CustomMailFromStatus,
        ) -> Self {
            self.mail_from_domain_status = Some(input);
            self
        }
        /// <p>The state that indicates whether Amazon SES has successfully read the MX record required
        /// for custom MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the
        /// specified custom MAIL FROM domain when the verified identity sends an email. All other
        /// states indicate that Amazon SES takes the action described by
        /// <code>BehaviorOnMXFailure</code>.</p>
        pub fn set_mail_from_domain_status(
            mut self,
            input: std::option::Option<crate::model::CustomMailFromStatus>,
        ) -> Self {
            self.mail_from_domain_status = input;
            self
        }
        /// <p>The action that Amazon SES takes if it cannot successfully read the required MX record when
        /// you send an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES
        /// cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as
        /// the MAIL FROM domain. A value of <code>RejectMessage</code> indicates that if Amazon SES
        /// cannot read the required MX record, Amazon SES returns a
        /// <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
        /// <p>The custom MAIL FROM setup states that result in this behavior are
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.behavior_on_mx_failure = Some(input);
            self
        }
        /// <p>The action that Amazon SES takes if it cannot successfully read the required MX record when
        /// you send an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES
        /// cannot read the required MX record, it uses amazonses.com (or a subdomain of that) as
        /// the MAIL FROM domain. A value of <code>RejectMessage</code> indicates that if Amazon SES
        /// cannot read the required MX record, Amazon SES returns a
        /// <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
        /// <p>The custom MAIL FROM setup states that result in this behavior are
        /// <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code>.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.behavior_on_mx_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityMailFromDomainAttributes`](crate::model::IdentityMailFromDomainAttributes)
        pub fn build(self) -> crate::model::IdentityMailFromDomainAttributes {
            crate::model::IdentityMailFromDomainAttributes {
                mail_from_domain: self.mail_from_domain,
                mail_from_domain_status: self.mail_from_domain_status,
                behavior_on_mx_failure: self.behavior_on_mx_failure,
            }
        }
    }
}
impl IdentityMailFromDomainAttributes {
    /// Creates a new builder-style object to manufacture [`IdentityMailFromDomainAttributes`](crate::model::IdentityMailFromDomainAttributes)
    pub fn builder() -> crate::model::identity_mail_from_domain_attributes::Builder {
        crate::model::identity_mail_from_domain_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomMailFromStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TemporaryFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomMailFromStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => CustomMailFromStatus::Failed,
            "Pending" => CustomMailFromStatus::Pending,
            "Success" => CustomMailFromStatus::Success,
            "TemporaryFailure" => CustomMailFromStatus::TemporaryFailure,
            other => CustomMailFromStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomMailFromStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomMailFromStatus::from(s))
    }
}
impl CustomMailFromStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomMailFromStatus::Failed => "Failed",
            CustomMailFromStatus::Pending => "Pending",
            CustomMailFromStatus::Success => "Success",
            CustomMailFromStatus::TemporaryFailure => "TemporaryFailure",
            CustomMailFromStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Pending", "Success", "TemporaryFailure"]
    }
}
impl AsRef<str> for CustomMailFromStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the DKIM attributes of a verified email address or a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityDkimAttributes {
    /// <p>Is true if DKIM signing is enabled for email sent from the identity. It's false
    /// otherwise. The default value is true.</p>
    pub dkim_enabled: bool,
    /// <p>Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens)
    /// published in the domain name's DNS. (This only applies to domain identities, not email
    /// address identities.)</p>
    pub dkim_verification_status: std::option::Option<crate::model::VerificationStatus>,
    /// <p>A set of character strings that represent the domain's identity. Using these tokens,
    /// you need to create DNS CNAME records that point to DKIM public keys that are hosted by
    /// Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
    /// process might take up to 72 hours. After successful detection, Amazon SES is able to
    /// DKIM-sign email originating from that domain. (This only applies to domain identities,
    /// not email address identities.)</p>
    /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub dkim_tokens: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IdentityDkimAttributes {
    /// <p>Is true if DKIM signing is enabled for email sent from the identity. It's false
    /// otherwise. The default value is true.</p>
    pub fn dkim_enabled(&self) -> bool {
        self.dkim_enabled
    }
    /// <p>Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens)
    /// published in the domain name's DNS. (This only applies to domain identities, not email
    /// address identities.)</p>
    pub fn dkim_verification_status(
        &self,
    ) -> std::option::Option<&crate::model::VerificationStatus> {
        self.dkim_verification_status.as_ref()
    }
    /// <p>A set of character strings that represent the domain's identity. Using these tokens,
    /// you need to create DNS CNAME records that point to DKIM public keys that are hosted by
    /// Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
    /// process might take up to 72 hours. After successful detection, Amazon SES is able to
    /// DKIM-sign email originating from that domain. (This only applies to domain identities,
    /// not email address identities.)</p>
    /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn dkim_tokens(&self) -> std::option::Option<&[std::string::String]> {
        self.dkim_tokens.as_deref()
    }
}
impl std::fmt::Debug for IdentityDkimAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityDkimAttributes");
        formatter.field("dkim_enabled", &self.dkim_enabled);
        formatter.field("dkim_verification_status", &self.dkim_verification_status);
        formatter.field("dkim_tokens", &self.dkim_tokens);
        formatter.finish()
    }
}
/// See [`IdentityDkimAttributes`](crate::model::IdentityDkimAttributes)
pub mod identity_dkim_attributes {
    /// A builder for [`IdentityDkimAttributes`](crate::model::IdentityDkimAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dkim_enabled: std::option::Option<bool>,
        pub(crate) dkim_verification_status: std::option::Option<crate::model::VerificationStatus>,
        pub(crate) dkim_tokens: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Is true if DKIM signing is enabled for email sent from the identity. It's false
        /// otherwise. The default value is true.</p>
        pub fn dkim_enabled(mut self, input: bool) -> Self {
            self.dkim_enabled = Some(input);
            self
        }
        /// <p>Is true if DKIM signing is enabled for email sent from the identity. It's false
        /// otherwise. The default value is true.</p>
        pub fn set_dkim_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.dkim_enabled = input;
            self
        }
        /// <p>Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens)
        /// published in the domain name's DNS. (This only applies to domain identities, not email
        /// address identities.)</p>
        pub fn dkim_verification_status(mut self, input: crate::model::VerificationStatus) -> Self {
            self.dkim_verification_status = Some(input);
            self
        }
        /// <p>Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens)
        /// published in the domain name's DNS. (This only applies to domain identities, not email
        /// address identities.)</p>
        pub fn set_dkim_verification_status(
            mut self,
            input: std::option::Option<crate::model::VerificationStatus>,
        ) -> Self {
            self.dkim_verification_status = input;
            self
        }
        /// Appends an item to `dkim_tokens`.
        ///
        /// To override the contents of this collection use [`set_dkim_tokens`](Self::set_dkim_tokens).
        ///
        /// <p>A set of character strings that represent the domain's identity. Using these tokens,
        /// you need to create DNS CNAME records that point to DKIM public keys that are hosted by
        /// Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
        /// process might take up to 72 hours. After successful detection, Amazon SES is able to
        /// DKIM-sign email originating from that domain. (This only applies to domain identities,
        /// not email address identities.)</p>
        /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn dkim_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dkim_tokens.unwrap_or_default();
            v.push(input.into());
            self.dkim_tokens = Some(v);
            self
        }
        /// <p>A set of character strings that represent the domain's identity. Using these tokens,
        /// you need to create DNS CNAME records that point to DKIM public keys that are hosted by
        /// Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
        /// process might take up to 72 hours. After successful detection, Amazon SES is able to
        /// DKIM-sign email originating from that domain. (This only applies to domain identities,
        /// not email address identities.)</p>
        /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_dkim_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dkim_tokens = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityDkimAttributes`](crate::model::IdentityDkimAttributes)
        pub fn build(self) -> crate::model::IdentityDkimAttributes {
            crate::model::IdentityDkimAttributes {
                dkim_enabled: self.dkim_enabled.unwrap_or_default(),
                dkim_verification_status: self.dkim_verification_status,
                dkim_tokens: self.dkim_tokens,
            }
        }
    }
}
impl IdentityDkimAttributes {
    /// Creates a new builder-style object to manufacture [`IdentityDkimAttributes`](crate::model::IdentityDkimAttributes)
    pub fn builder() -> crate::model::identity_dkim_attributes::Builder {
        crate::model::identity_dkim_attributes::Builder::default()
    }
}

/// <p>Contains information about the reputation settings for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReputationOptions {
    /// <p>Describes whether email sending is enabled or disabled for the configuration set. If
    /// the value is <code>true</code>, then Amazon SES will send emails that use the configuration
    /// set. If the value is <code>false</code>, Amazon SES will not send emails that use the
    /// configuration set. The default value is <code>true</code>. You can change this setting
    /// using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    pub sending_enabled: bool,
    /// <p>Describes whether or not Amazon SES publishes reputation metrics for the configuration set,
    /// such as bounce and complaint rates, to Amazon CloudWatch.</p>
    /// <p>If the value is <code>true</code>, reputation metrics are published. If the value is
    /// <code>false</code>, reputation metrics are not published. The default value is
    /// <code>false</code>.</p>
    pub reputation_metrics_enabled: bool,
    /// <p>The date and time at which the reputation metrics for the configuration set were last
    /// reset. Resetting these metrics is known as a <i>fresh start</i>.</p>
    /// <p>When you disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a> and later re-enable it, the
    /// reputation metrics for the configuration set (but not for the entire Amazon SES account) are
    /// reset.</p>
    /// <p>If email sending for the configuration set has never been disabled and later
    /// re-enabled, the value of this attribute is <code>null</code>.</p>
    pub last_fresh_start: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReputationOptions {
    /// <p>Describes whether email sending is enabled or disabled for the configuration set. If
    /// the value is <code>true</code>, then Amazon SES will send emails that use the configuration
    /// set. If the value is <code>false</code>, Amazon SES will not send emails that use the
    /// configuration set. The default value is <code>true</code>. You can change this setting
    /// using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    pub fn sending_enabled(&self) -> bool {
        self.sending_enabled
    }
    /// <p>Describes whether or not Amazon SES publishes reputation metrics for the configuration set,
    /// such as bounce and complaint rates, to Amazon CloudWatch.</p>
    /// <p>If the value is <code>true</code>, reputation metrics are published. If the value is
    /// <code>false</code>, reputation metrics are not published. The default value is
    /// <code>false</code>.</p>
    pub fn reputation_metrics_enabled(&self) -> bool {
        self.reputation_metrics_enabled
    }
    /// <p>The date and time at which the reputation metrics for the configuration set were last
    /// reset. Resetting these metrics is known as a <i>fresh start</i>.</p>
    /// <p>When you disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a> and later re-enable it, the
    /// reputation metrics for the configuration set (but not for the entire Amazon SES account) are
    /// reset.</p>
    /// <p>If email sending for the configuration set has never been disabled and later
    /// re-enabled, the value of this attribute is <code>null</code>.</p>
    pub fn last_fresh_start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_fresh_start.as_ref()
    }
}
impl std::fmt::Debug for ReputationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReputationOptions");
        formatter.field("sending_enabled", &self.sending_enabled);
        formatter.field(
            "reputation_metrics_enabled",
            &self.reputation_metrics_enabled,
        );
        formatter.field("last_fresh_start", &self.last_fresh_start);
        formatter.finish()
    }
}
/// See [`ReputationOptions`](crate::model::ReputationOptions)
pub mod reputation_options {
    /// A builder for [`ReputationOptions`](crate::model::ReputationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sending_enabled: std::option::Option<bool>,
        pub(crate) reputation_metrics_enabled: std::option::Option<bool>,
        pub(crate) last_fresh_start: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Describes whether email sending is enabled or disabled for the configuration set. If
        /// the value is <code>true</code>, then Amazon SES will send emails that use the configuration
        /// set. If the value is <code>false</code>, Amazon SES will not send emails that use the
        /// configuration set. The default value is <code>true</code>. You can change this setting
        /// using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
        pub fn sending_enabled(mut self, input: bool) -> Self {
            self.sending_enabled = Some(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set. If
        /// the value is <code>true</code>, then Amazon SES will send emails that use the configuration
        /// set. If the value is <code>false</code>, Amazon SES will not send emails that use the
        /// configuration set. The default value is <code>true</code>. You can change this setting
        /// using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
        pub fn set_sending_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.sending_enabled = input;
            self
        }
        /// <p>Describes whether or not Amazon SES publishes reputation metrics for the configuration set,
        /// such as bounce and complaint rates, to Amazon CloudWatch.</p>
        /// <p>If the value is <code>true</code>, reputation metrics are published. If the value is
        /// <code>false</code>, reputation metrics are not published. The default value is
        /// <code>false</code>.</p>
        pub fn reputation_metrics_enabled(mut self, input: bool) -> Self {
            self.reputation_metrics_enabled = Some(input);
            self
        }
        /// <p>Describes whether or not Amazon SES publishes reputation metrics for the configuration set,
        /// such as bounce and complaint rates, to Amazon CloudWatch.</p>
        /// <p>If the value is <code>true</code>, reputation metrics are published. If the value is
        /// <code>false</code>, reputation metrics are not published. The default value is
        /// <code>false</code>.</p>
        pub fn set_reputation_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.reputation_metrics_enabled = input;
            self
        }
        /// <p>The date and time at which the reputation metrics for the configuration set were last
        /// reset. Resetting these metrics is known as a <i>fresh start</i>.</p>
        /// <p>When you disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a> and later re-enable it, the
        /// reputation metrics for the configuration set (but not for the entire Amazon SES account) are
        /// reset.</p>
        /// <p>If email sending for the configuration set has never been disabled and later
        /// re-enabled, the value of this attribute is <code>null</code>.</p>
        pub fn last_fresh_start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_fresh_start = Some(input);
            self
        }
        /// <p>The date and time at which the reputation metrics for the configuration set were last
        /// reset. Resetting these metrics is known as a <i>fresh start</i>.</p>
        /// <p>When you disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a> and later re-enable it, the
        /// reputation metrics for the configuration set (but not for the entire Amazon SES account) are
        /// reset.</p>
        /// <p>If email sending for the configuration set has never been disabled and later
        /// re-enabled, the value of this attribute is <code>null</code>.</p>
        pub fn set_last_fresh_start(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_fresh_start = input;
            self
        }
        /// Consumes the builder and constructs a [`ReputationOptions`](crate::model::ReputationOptions)
        pub fn build(self) -> crate::model::ReputationOptions {
            crate::model::ReputationOptions {
                sending_enabled: self.sending_enabled.unwrap_or_default(),
                reputation_metrics_enabled: self.reputation_metrics_enabled.unwrap_or_default(),
                last_fresh_start: self.last_fresh_start,
            }
        }
    }
}
impl ReputationOptions {
    /// Creates a new builder-style object to manufacture [`ReputationOptions`](crate::model::ReputationOptions)
    pub fn builder() -> crate::model::reputation_options::Builder {
        crate::model::reputation_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationSetAttribute {
    #[allow(missing_docs)] // documentation missing in model
    DeliveryOptions,
    #[allow(missing_docs)] // documentation missing in model
    EventDestinations,
    #[allow(missing_docs)] // documentation missing in model
    ReputationOptions,
    #[allow(missing_docs)] // documentation missing in model
    TrackingOptions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationSetAttribute {
    fn from(s: &str) -> Self {
        match s {
            "deliveryOptions" => ConfigurationSetAttribute::DeliveryOptions,
            "eventDestinations" => ConfigurationSetAttribute::EventDestinations,
            "reputationOptions" => ConfigurationSetAttribute::ReputationOptions,
            "trackingOptions" => ConfigurationSetAttribute::TrackingOptions,
            other => ConfigurationSetAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationSetAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationSetAttribute::from(s))
    }
}
impl ConfigurationSetAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationSetAttribute::DeliveryOptions => "deliveryOptions",
            ConfigurationSetAttribute::EventDestinations => "eventDestinations",
            ConfigurationSetAttribute::ReputationOptions => "reputationOptions",
            ConfigurationSetAttribute::TrackingOptions => "trackingOptions",
            ConfigurationSetAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "deliveryOptions",
            "eventDestinations",
            "reputationOptions",
            "trackingOptions",
        ]
    }
}
impl AsRef<str> for ConfigurationSetAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
