// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `SimpleEmailService`.
///
/// This client allows ergonomic access to a `SimpleEmailService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CloneReceiptRuleSet` operation.
    ///
    /// See [`CloneReceiptRuleSet`](crate::client::fluent_builders::CloneReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn clone_receipt_rule_set(&self) -> fluent_builders::CloneReceiptRuleSet<C, M, R> {
        fluent_builders::CloneReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfigurationSet` operation.
    ///
    /// See [`CreateConfigurationSet`](crate::client::fluent_builders::CreateConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_set(&self) -> fluent_builders::CreateConfigurationSet<C, M, R> {
        fluent_builders::CreateConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfigurationSetEventDestination` operation.
    ///
    /// See [`CreateConfigurationSetEventDestination`](crate::client::fluent_builders::CreateConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::CreateConfigurationSetEventDestination<C, M, R> {
        fluent_builders::CreateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfigurationSetTrackingOptions` operation.
    ///
    /// See [`CreateConfigurationSetTrackingOptions`](crate::client::fluent_builders::CreateConfigurationSetTrackingOptions) for more information about the
    /// operation and its arguments.
    pub fn create_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::CreateConfigurationSetTrackingOptions<C, M, R> {
        fluent_builders::CreateConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomVerificationEmailTemplate` operation.
    ///
    /// See [`CreateCustomVerificationEmailTemplate`](crate::client::fluent_builders::CreateCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_custom_verification_email_template(
        &self,
    ) -> fluent_builders::CreateCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::CreateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReceiptFilter` operation.
    ///
    /// See [`CreateReceiptFilter`](crate::client::fluent_builders::CreateReceiptFilter) for more information about the
    /// operation and its arguments.
    pub fn create_receipt_filter(&self) -> fluent_builders::CreateReceiptFilter<C, M, R> {
        fluent_builders::CreateReceiptFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReceiptRule` operation.
    ///
    /// See [`CreateReceiptRule`](crate::client::fluent_builders::CreateReceiptRule) for more information about the
    /// operation and its arguments.
    pub fn create_receipt_rule(&self) -> fluent_builders::CreateReceiptRule<C, M, R> {
        fluent_builders::CreateReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReceiptRuleSet` operation.
    ///
    /// See [`CreateReceiptRuleSet`](crate::client::fluent_builders::CreateReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn create_receipt_rule_set(&self) -> fluent_builders::CreateReceiptRuleSet<C, M, R> {
        fluent_builders::CreateReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTemplate` operation.
    ///
    /// See [`CreateTemplate`](crate::client::fluent_builders::CreateTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_template(&self) -> fluent_builders::CreateTemplate<C, M, R> {
        fluent_builders::CreateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationSet` operation.
    ///
    /// See [`DeleteConfigurationSet`](crate::client::fluent_builders::DeleteConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_set(&self) -> fluent_builders::DeleteConfigurationSet<C, M, R> {
        fluent_builders::DeleteConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationSetEventDestination` operation.
    ///
    /// See [`DeleteConfigurationSetEventDestination`](crate::client::fluent_builders::DeleteConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetEventDestination<C, M, R> {
        fluent_builders::DeleteConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfigurationSetTrackingOptions` operation.
    ///
    /// See [`DeleteConfigurationSetTrackingOptions`](crate::client::fluent_builders::DeleteConfigurationSetTrackingOptions) for more information about the
    /// operation and its arguments.
    pub fn delete_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::DeleteConfigurationSetTrackingOptions<C, M, R> {
        fluent_builders::DeleteConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomVerificationEmailTemplate` operation.
    ///
    /// See [`DeleteCustomVerificationEmailTemplate`](crate::client::fluent_builders::DeleteCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_verification_email_template(
        &self,
    ) -> fluent_builders::DeleteCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::DeleteCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIdentity` operation.
    ///
    /// See [`DeleteIdentity`](crate::client::fluent_builders::DeleteIdentity) for more information about the
    /// operation and its arguments.
    pub fn delete_identity(&self) -> fluent_builders::DeleteIdentity<C, M, R> {
        fluent_builders::DeleteIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIdentityPolicy` operation.
    ///
    /// See [`DeleteIdentityPolicy`](crate::client::fluent_builders::DeleteIdentityPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_identity_policy(&self) -> fluent_builders::DeleteIdentityPolicy<C, M, R> {
        fluent_builders::DeleteIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReceiptFilter` operation.
    ///
    /// See [`DeleteReceiptFilter`](crate::client::fluent_builders::DeleteReceiptFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_receipt_filter(&self) -> fluent_builders::DeleteReceiptFilter<C, M, R> {
        fluent_builders::DeleteReceiptFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReceiptRule` operation.
    ///
    /// See [`DeleteReceiptRule`](crate::client::fluent_builders::DeleteReceiptRule) for more information about the
    /// operation and its arguments.
    pub fn delete_receipt_rule(&self) -> fluent_builders::DeleteReceiptRule<C, M, R> {
        fluent_builders::DeleteReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReceiptRuleSet` operation.
    ///
    /// See [`DeleteReceiptRuleSet`](crate::client::fluent_builders::DeleteReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn delete_receipt_rule_set(&self) -> fluent_builders::DeleteReceiptRuleSet<C, M, R> {
        fluent_builders::DeleteReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTemplate` operation.
    ///
    /// See [`DeleteTemplate`](crate::client::fluent_builders::DeleteTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_template(&self) -> fluent_builders::DeleteTemplate<C, M, R> {
        fluent_builders::DeleteTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVerifiedEmailAddress` operation.
    ///
    /// See [`DeleteVerifiedEmailAddress`](crate::client::fluent_builders::DeleteVerifiedEmailAddress) for more information about the
    /// operation and its arguments.
    pub fn delete_verified_email_address(
        &self,
    ) -> fluent_builders::DeleteVerifiedEmailAddress<C, M, R> {
        fluent_builders::DeleteVerifiedEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeActiveReceiptRuleSet` operation.
    ///
    /// See [`DescribeActiveReceiptRuleSet`](crate::client::fluent_builders::DescribeActiveReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn describe_active_receipt_rule_set(
        &self,
    ) -> fluent_builders::DescribeActiveReceiptRuleSet<C, M, R> {
        fluent_builders::DescribeActiveReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConfigurationSet` operation.
    ///
    /// See [`DescribeConfigurationSet`](crate::client::fluent_builders::DescribeConfigurationSet) for more information about the
    /// operation and its arguments.
    pub fn describe_configuration_set(&self) -> fluent_builders::DescribeConfigurationSet<C, M, R> {
        fluent_builders::DescribeConfigurationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReceiptRule` operation.
    ///
    /// See [`DescribeReceiptRule`](crate::client::fluent_builders::DescribeReceiptRule) for more information about the
    /// operation and its arguments.
    pub fn describe_receipt_rule(&self) -> fluent_builders::DescribeReceiptRule<C, M, R> {
        fluent_builders::DescribeReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReceiptRuleSet` operation.
    ///
    /// See [`DescribeReceiptRuleSet`](crate::client::fluent_builders::DescribeReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn describe_receipt_rule_set(&self) -> fluent_builders::DescribeReceiptRuleSet<C, M, R> {
        fluent_builders::DescribeReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSendingEnabled` operation.
    ///
    /// See [`GetAccountSendingEnabled`](crate::client::fluent_builders::GetAccountSendingEnabled) for more information about the
    /// operation and its arguments.
    pub fn get_account_sending_enabled(
        &self,
    ) -> fluent_builders::GetAccountSendingEnabled<C, M, R> {
        fluent_builders::GetAccountSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCustomVerificationEmailTemplate` operation.
    ///
    /// See [`GetCustomVerificationEmailTemplate`](crate::client::fluent_builders::GetCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_custom_verification_email_template(
        &self,
    ) -> fluent_builders::GetCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::GetCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityDkimAttributes` operation.
    ///
    /// See [`GetIdentityDkimAttributes`](crate::client::fluent_builders::GetIdentityDkimAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_identity_dkim_attributes(
        &self,
    ) -> fluent_builders::GetIdentityDkimAttributes<C, M, R> {
        fluent_builders::GetIdentityDkimAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityMailFromDomainAttributes` operation.
    ///
    /// See [`GetIdentityMailFromDomainAttributes`](crate::client::fluent_builders::GetIdentityMailFromDomainAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_identity_mail_from_domain_attributes(
        &self,
    ) -> fluent_builders::GetIdentityMailFromDomainAttributes<C, M, R> {
        fluent_builders::GetIdentityMailFromDomainAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityNotificationAttributes` operation.
    ///
    /// See [`GetIdentityNotificationAttributes`](crate::client::fluent_builders::GetIdentityNotificationAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_identity_notification_attributes(
        &self,
    ) -> fluent_builders::GetIdentityNotificationAttributes<C, M, R> {
        fluent_builders::GetIdentityNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityPolicies` operation.
    ///
    /// See [`GetIdentityPolicies`](crate::client::fluent_builders::GetIdentityPolicies) for more information about the
    /// operation and its arguments.
    pub fn get_identity_policies(&self) -> fluent_builders::GetIdentityPolicies<C, M, R> {
        fluent_builders::GetIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIdentityVerificationAttributes` operation.
    ///
    /// See [`GetIdentityVerificationAttributes`](crate::client::fluent_builders::GetIdentityVerificationAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_identity_verification_attributes(
        &self,
    ) -> fluent_builders::GetIdentityVerificationAttributes<C, M, R> {
        fluent_builders::GetIdentityVerificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSendQuota` operation.
    ///
    /// See [`GetSendQuota`](crate::client::fluent_builders::GetSendQuota) for more information about the
    /// operation and its arguments.
    pub fn get_send_quota(&self) -> fluent_builders::GetSendQuota<C, M, R> {
        fluent_builders::GetSendQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSendStatistics` operation.
    ///
    /// See [`GetSendStatistics`](crate::client::fluent_builders::GetSendStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_send_statistics(&self) -> fluent_builders::GetSendStatistics<C, M, R> {
        fluent_builders::GetSendStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTemplate` operation.
    ///
    /// See [`GetTemplate`](crate::client::fluent_builders::GetTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_template(&self) -> fluent_builders::GetTemplate<C, M, R> {
        fluent_builders::GetTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigurationSets` operation.
    ///
    /// See [`ListConfigurationSets`](crate::client::fluent_builders::ListConfigurationSets) for more information about the
    /// operation and its arguments.
    pub fn list_configuration_sets(&self) -> fluent_builders::ListConfigurationSets<C, M, R> {
        fluent_builders::ListConfigurationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomVerificationEmailTemplates` operation.
    ///
    /// See [`ListCustomVerificationEmailTemplates`](crate::client::fluent_builders::ListCustomVerificationEmailTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_custom_verification_email_templates(
        &self,
    ) -> fluent_builders::ListCustomVerificationEmailTemplates<C, M, R> {
        fluent_builders::ListCustomVerificationEmailTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentities` operation.
    ///
    /// See [`ListIdentities`](crate::client::fluent_builders::ListIdentities) for more information about the
    /// operation and its arguments.
    pub fn list_identities(&self) -> fluent_builders::ListIdentities<C, M, R> {
        fluent_builders::ListIdentities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIdentityPolicies` operation.
    ///
    /// See [`ListIdentityPolicies`](crate::client::fluent_builders::ListIdentityPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_identity_policies(&self) -> fluent_builders::ListIdentityPolicies<C, M, R> {
        fluent_builders::ListIdentityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReceiptFilters` operation.
    ///
    /// See [`ListReceiptFilters`](crate::client::fluent_builders::ListReceiptFilters) for more information about the
    /// operation and its arguments.
    pub fn list_receipt_filters(&self) -> fluent_builders::ListReceiptFilters<C, M, R> {
        fluent_builders::ListReceiptFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReceiptRuleSets` operation.
    ///
    /// See [`ListReceiptRuleSets`](crate::client::fluent_builders::ListReceiptRuleSets) for more information about the
    /// operation and its arguments.
    pub fn list_receipt_rule_sets(&self) -> fluent_builders::ListReceiptRuleSets<C, M, R> {
        fluent_builders::ListReceiptRuleSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTemplates` operation.
    ///
    /// See [`ListTemplates`](crate::client::fluent_builders::ListTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_templates(&self) -> fluent_builders::ListTemplates<C, M, R> {
        fluent_builders::ListTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVerifiedEmailAddresses` operation.
    ///
    /// See [`ListVerifiedEmailAddresses`](crate::client::fluent_builders::ListVerifiedEmailAddresses) for more information about the
    /// operation and its arguments.
    pub fn list_verified_email_addresses(
        &self,
    ) -> fluent_builders::ListVerifiedEmailAddresses<C, M, R> {
        fluent_builders::ListVerifiedEmailAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutConfigurationSetDeliveryOptions` operation.
    ///
    /// See [`PutConfigurationSetDeliveryOptions`](crate::client::fluent_builders::PutConfigurationSetDeliveryOptions) for more information about the
    /// operation and its arguments.
    pub fn put_configuration_set_delivery_options(
        &self,
    ) -> fluent_builders::PutConfigurationSetDeliveryOptions<C, M, R> {
        fluent_builders::PutConfigurationSetDeliveryOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutIdentityPolicy` operation.
    ///
    /// See [`PutIdentityPolicy`](crate::client::fluent_builders::PutIdentityPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_identity_policy(&self) -> fluent_builders::PutIdentityPolicy<C, M, R> {
        fluent_builders::PutIdentityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReorderReceiptRuleSet` operation.
    ///
    /// See [`ReorderReceiptRuleSet`](crate::client::fluent_builders::ReorderReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn reorder_receipt_rule_set(&self) -> fluent_builders::ReorderReceiptRuleSet<C, M, R> {
        fluent_builders::ReorderReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendBounce` operation.
    ///
    /// See [`SendBounce`](crate::client::fluent_builders::SendBounce) for more information about the
    /// operation and its arguments.
    pub fn send_bounce(&self) -> fluent_builders::SendBounce<C, M, R> {
        fluent_builders::SendBounce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendBulkTemplatedEmail` operation.
    ///
    /// See [`SendBulkTemplatedEmail`](crate::client::fluent_builders::SendBulkTemplatedEmail) for more information about the
    /// operation and its arguments.
    pub fn send_bulk_templated_email(&self) -> fluent_builders::SendBulkTemplatedEmail<C, M, R> {
        fluent_builders::SendBulkTemplatedEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendCustomVerificationEmail` operation.
    ///
    /// See [`SendCustomVerificationEmail`](crate::client::fluent_builders::SendCustomVerificationEmail) for more information about the
    /// operation and its arguments.
    pub fn send_custom_verification_email(
        &self,
    ) -> fluent_builders::SendCustomVerificationEmail<C, M, R> {
        fluent_builders::SendCustomVerificationEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendEmail` operation.
    ///
    /// See [`SendEmail`](crate::client::fluent_builders::SendEmail) for more information about the
    /// operation and its arguments.
    pub fn send_email(&self) -> fluent_builders::SendEmail<C, M, R> {
        fluent_builders::SendEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendRawEmail` operation.
    ///
    /// See [`SendRawEmail`](crate::client::fluent_builders::SendRawEmail) for more information about the
    /// operation and its arguments.
    pub fn send_raw_email(&self) -> fluent_builders::SendRawEmail<C, M, R> {
        fluent_builders::SendRawEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendTemplatedEmail` operation.
    ///
    /// See [`SendTemplatedEmail`](crate::client::fluent_builders::SendTemplatedEmail) for more information about the
    /// operation and its arguments.
    pub fn send_templated_email(&self) -> fluent_builders::SendTemplatedEmail<C, M, R> {
        fluent_builders::SendTemplatedEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetActiveReceiptRuleSet` operation.
    ///
    /// See [`SetActiveReceiptRuleSet`](crate::client::fluent_builders::SetActiveReceiptRuleSet) for more information about the
    /// operation and its arguments.
    pub fn set_active_receipt_rule_set(&self) -> fluent_builders::SetActiveReceiptRuleSet<C, M, R> {
        fluent_builders::SetActiveReceiptRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityDkimEnabled` operation.
    ///
    /// See [`SetIdentityDkimEnabled`](crate::client::fluent_builders::SetIdentityDkimEnabled) for more information about the
    /// operation and its arguments.
    pub fn set_identity_dkim_enabled(&self) -> fluent_builders::SetIdentityDkimEnabled<C, M, R> {
        fluent_builders::SetIdentityDkimEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityFeedbackForwardingEnabled` operation.
    ///
    /// See [`SetIdentityFeedbackForwardingEnabled`](crate::client::fluent_builders::SetIdentityFeedbackForwardingEnabled) for more information about the
    /// operation and its arguments.
    pub fn set_identity_feedback_forwarding_enabled(
        &self,
    ) -> fluent_builders::SetIdentityFeedbackForwardingEnabled<C, M, R> {
        fluent_builders::SetIdentityFeedbackForwardingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityHeadersInNotificationsEnabled` operation.
    ///
    /// See [`SetIdentityHeadersInNotificationsEnabled`](crate::client::fluent_builders::SetIdentityHeadersInNotificationsEnabled) for more information about the
    /// operation and its arguments.
    pub fn set_identity_headers_in_notifications_enabled(
        &self,
    ) -> fluent_builders::SetIdentityHeadersInNotificationsEnabled<C, M, R> {
        fluent_builders::SetIdentityHeadersInNotificationsEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityMailFromDomain` operation.
    ///
    /// See [`SetIdentityMailFromDomain`](crate::client::fluent_builders::SetIdentityMailFromDomain) for more information about the
    /// operation and its arguments.
    pub fn set_identity_mail_from_domain(
        &self,
    ) -> fluent_builders::SetIdentityMailFromDomain<C, M, R> {
        fluent_builders::SetIdentityMailFromDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIdentityNotificationTopic` operation.
    ///
    /// See [`SetIdentityNotificationTopic`](crate::client::fluent_builders::SetIdentityNotificationTopic) for more information about the
    /// operation and its arguments.
    pub fn set_identity_notification_topic(
        &self,
    ) -> fluent_builders::SetIdentityNotificationTopic<C, M, R> {
        fluent_builders::SetIdentityNotificationTopic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetReceiptRulePosition` operation.
    ///
    /// See [`SetReceiptRulePosition`](crate::client::fluent_builders::SetReceiptRulePosition) for more information about the
    /// operation and its arguments.
    pub fn set_receipt_rule_position(&self) -> fluent_builders::SetReceiptRulePosition<C, M, R> {
        fluent_builders::SetReceiptRulePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestRenderTemplate` operation.
    ///
    /// See [`TestRenderTemplate`](crate::client::fluent_builders::TestRenderTemplate) for more information about the
    /// operation and its arguments.
    pub fn test_render_template(&self) -> fluent_builders::TestRenderTemplate<C, M, R> {
        fluent_builders::TestRenderTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountSendingEnabled` operation.
    ///
    /// See [`UpdateAccountSendingEnabled`](crate::client::fluent_builders::UpdateAccountSendingEnabled) for more information about the
    /// operation and its arguments.
    pub fn update_account_sending_enabled(
        &self,
    ) -> fluent_builders::UpdateAccountSendingEnabled<C, M, R> {
        fluent_builders::UpdateAccountSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationSetEventDestination` operation.
    ///
    /// See [`UpdateConfigurationSetEventDestination`](crate::client::fluent_builders::UpdateConfigurationSetEventDestination) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_set_event_destination(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetEventDestination<C, M, R> {
        fluent_builders::UpdateConfigurationSetEventDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationSetReputationMetricsEnabled` operation.
    ///
    /// See [`UpdateConfigurationSetReputationMetricsEnabled`](crate::client::fluent_builders::UpdateConfigurationSetReputationMetricsEnabled) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_set_reputation_metrics_enabled(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetReputationMetricsEnabled<C, M, R> {
        fluent_builders::UpdateConfigurationSetReputationMetricsEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationSetSendingEnabled` operation.
    ///
    /// See [`UpdateConfigurationSetSendingEnabled`](crate::client::fluent_builders::UpdateConfigurationSetSendingEnabled) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_set_sending_enabled(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetSendingEnabled<C, M, R> {
        fluent_builders::UpdateConfigurationSetSendingEnabled::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfigurationSetTrackingOptions` operation.
    ///
    /// See [`UpdateConfigurationSetTrackingOptions`](crate::client::fluent_builders::UpdateConfigurationSetTrackingOptions) for more information about the
    /// operation and its arguments.
    pub fn update_configuration_set_tracking_options(
        &self,
    ) -> fluent_builders::UpdateConfigurationSetTrackingOptions<C, M, R> {
        fluent_builders::UpdateConfigurationSetTrackingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomVerificationEmailTemplate` operation.
    ///
    /// See [`UpdateCustomVerificationEmailTemplate`](crate::client::fluent_builders::UpdateCustomVerificationEmailTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_custom_verification_email_template(
        &self,
    ) -> fluent_builders::UpdateCustomVerificationEmailTemplate<C, M, R> {
        fluent_builders::UpdateCustomVerificationEmailTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReceiptRule` operation.
    ///
    /// See [`UpdateReceiptRule`](crate::client::fluent_builders::UpdateReceiptRule) for more information about the
    /// operation and its arguments.
    pub fn update_receipt_rule(&self) -> fluent_builders::UpdateReceiptRule<C, M, R> {
        fluent_builders::UpdateReceiptRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTemplate` operation.
    ///
    /// See [`UpdateTemplate`](crate::client::fluent_builders::UpdateTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_template(&self) -> fluent_builders::UpdateTemplate<C, M, R> {
        fluent_builders::UpdateTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VerifyDomainDkim` operation.
    ///
    /// See [`VerifyDomainDkim`](crate::client::fluent_builders::VerifyDomainDkim) for more information about the
    /// operation and its arguments.
    pub fn verify_domain_dkim(&self) -> fluent_builders::VerifyDomainDkim<C, M, R> {
        fluent_builders::VerifyDomainDkim::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VerifyDomainIdentity` operation.
    ///
    /// See [`VerifyDomainIdentity`](crate::client::fluent_builders::VerifyDomainIdentity) for more information about the
    /// operation and its arguments.
    pub fn verify_domain_identity(&self) -> fluent_builders::VerifyDomainIdentity<C, M, R> {
        fluent_builders::VerifyDomainIdentity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VerifyEmailAddress` operation.
    ///
    /// See [`VerifyEmailAddress`](crate::client::fluent_builders::VerifyEmailAddress) for more information about the
    /// operation and its arguments.
    pub fn verify_email_address(&self) -> fluent_builders::VerifyEmailAddress<C, M, R> {
        fluent_builders::VerifyEmailAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VerifyEmailIdentity` operation.
    ///
    /// See [`VerifyEmailIdentity`](crate::client::fluent_builders::VerifyEmailIdentity) for more information about the
    /// operation and its arguments.
    pub fn verify_email_identity(&self) -> fluent_builders::VerifyEmailIdentity<C, M, R> {
        fluent_builders::VerifyEmailIdentity::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CloneReceiptRuleSet`.
    ///
    /// <p>Creates a receipt rule set by cloning an existing one. All receipt rules and
    /// configurations are copied to the new receipt rule set and are completely independent of
    /// the source rule set.</p>
    /// <p>For information about setting up rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CloneReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::clone_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> CloneReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CloneReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CloneReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CloneReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CloneReceiptRuleSetInputOperationOutputAlias,
                crate::output::CloneReceiptRuleSetOutput,
                crate::error::CloneReceiptRuleSetError,
                crate::input::CloneReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn original_rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.original_rule_set_name(inp);
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn set_original_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_original_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSet`.
    ///
    /// <p>Creates a configuration set.</p>
    /// <p>Configuration sets enable you to publish email sending events. For information about
    /// using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_set_input::Builder,
    }
    impl<C, M, R> CreateConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationSetInputOperationOutputAlias,
                crate::output::CreateConfigurationSetOutput,
                crate::error::CreateConfigurationSetError,
                crate::input::CreateConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn configuration_set(mut self, inp: crate::model::ConfigurationSet) -> Self {
            self.inner = self.inner.configuration_set(inp);
            self
        }
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSet>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetEventDestination`.
    ///
    /// <p>Creates a configuration set event destination.</p>
    /// <note>
    /// <p>When you create or update an event destination, you must provide one, and only
    /// one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).</p>
    /// </note>
    /// <p>An event destination is the AWS service to which Amazon SES publishes the email sending
    /// events associated with a configuration set. For information about using configuration
    /// sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> CreateConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::CreateConfigurationSetEventDestinationOutput,
                crate::error::CreateConfigurationSetEventDestinationError,
                crate::input::CreateConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that the event destination should be associated
        /// with.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that the event destination should be associated
        /// with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will
        /// be published to.</p>
        pub fn event_destination(mut self, inp: crate::model::EventDestination) -> Self {
            self.inner = self.inner.event_destination(inp);
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will
        /// be published to.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfigurationSetTrackingOptions`.
    ///
    /// <p>Creates an association between a configuration set and a custom domain for open and
    /// click event tracking. </p>
    /// <p>By default, images and links used for tracking open and click events are hosted on
    /// domains operated by Amazon SES. You can configure a subdomain of your own to handle these
    /// events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfigurationSetTrackingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_configuration_set_tracking_options_input::Builder,
    }
    impl<C, M, R> CreateConfigurationSetTrackingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateConfigurationSetTrackingOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigurationSetTrackingOptionsInputOperationOutputAlias,
                crate::output::CreateConfigurationSetTrackingOptionsOutput,
                crate::error::CreateConfigurationSetTrackingOptionsError,
                crate::input::CreateConfigurationSetTrackingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that the tracking options should be associated
        /// with.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that the tracking options should be associated
        /// with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn tracking_options(mut self, inp: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(inp);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomVerificationEmailTemplate`.
    ///
    /// <p>Creates a new custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> CreateCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::CreateCustomVerificationEmailTemplateOutput,
                crate::error::CreateCustomVerificationEmailTemplateError,
                crate::input::CreateCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(inp);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptFilter`.
    ///
    /// <p>Creates a new IP address filter.</p>
    /// <p>For information about setting up IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReceiptFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_receipt_filter_input::Builder,
    }
    impl<C, M, R> CreateReceiptFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReceiptFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReceiptFilterInputOperationOutputAlias,
                crate::output::CreateReceiptFilterOutput,
                crate::error::CreateReceiptFilterError,
                crate::input::CreateReceiptFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A data structure that describes the IP address filter to create, which consists of a
        /// name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn filter(mut self, inp: crate::model::ReceiptFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A data structure that describes the IP address filter to create, which consists of a
        /// name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReceiptFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptRule`.
    ///
    /// <p>Creates a receipt rule.</p>
    /// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReceiptRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_receipt_rule_input::Builder,
    }
    impl<C, M, R> CreateReceiptRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReceiptRuleInputOperationOutputAlias,
                crate::output::CreateReceiptRuleOutput,
                crate::error::CreateReceiptRuleError,
                crate::input::CreateReceiptRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this
        /// parameter is null, the new rule will be inserted at the beginning of the rule
        /// list.</p>
        pub fn after(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after(inp);
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this
        /// parameter is null, the new rule will be inserted at the beginning of the rule
        /// list.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after(input);
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients,
        /// domains, enabled status, scan status, and TLS policy.</p>
        pub fn rule(mut self, inp: crate::model::ReceiptRule) -> Self {
            self.inner = self.inner.rule(inp);
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients,
        /// domains, enabled status, scan status, and TLS policy.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReceiptRuleSet`.
    ///
    /// <p>Creates an empty receipt rule set.</p>
    /// <p>For information about setting up receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> CreateReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReceiptRuleSetInputOperationOutputAlias,
                crate::output::CreateReceiptRuleSetOutput,
                crate::error::CreateReceiptRuleSetError,
                crate::input::CreateReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTemplate`.
    ///
    /// <p>Creates an email template. Email templates enable you to send personalized email to
    /// one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_template_input::Builder,
    }
    impl<C, M, R> CreateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTemplateInputOperationOutputAlias,
                crate::output::CreateTemplateOutput,
                crate::error::CreateTemplateError,
                crate::input::CreateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn template(mut self, inp: crate::model::Template) -> Self {
            self.inner = self.inner.template(inp);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSet`.
    ///
    /// <p>Deletes a configuration set. Configuration sets enable you to publish email sending
    /// events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_set_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationSetInputOperationOutputAlias,
                crate::output::DeleteConfigurationSetOutput,
                crate::error::DeleteConfigurationSetError,
                crate::input::DeleteConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to delete.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetEventDestination`.
    ///
    /// <p>Deletes a configuration set event destination. Configuration set event destinations
    /// are associated with configuration sets, which enable you to publish email sending
    /// events. For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::DeleteConfigurationSetEventDestinationOutput,
                crate::error::DeleteConfigurationSetEventDestinationError,
                crate::input::DeleteConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_destination_name(inp);
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfigurationSetTrackingOptions`.
    ///
    /// <p>Deletes an association between a configuration set and a custom domain for open and
    /// click event tracking.</p>
    /// <p>By default, images and links used for tracking open and click events are hosted on
    /// domains operated by Amazon SES. You can configure a subdomain of your own to handle these
    /// events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Deleting this kind of association will result in emails sent using the specified
    /// configuration set to capture open and click events using the standard,
    /// Amazon SES-operated domains.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfigurationSetTrackingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_configuration_set_tracking_options_input::Builder,
    }
    impl<C, M, R> DeleteConfigurationSetTrackingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteConfigurationSetTrackingOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigurationSetTrackingOptionsInputOperationOutputAlias,
                crate::output::DeleteConfigurationSetTrackingOptionsOutput,
                crate::error::DeleteConfigurationSetTrackingOptionsError,
                crate::input::DeleteConfigurationSetTrackingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set from which you want to delete the tracking
        /// options.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set from which you want to delete the tracking
        /// options.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomVerificationEmailTemplate`.
    ///
    /// <p>Deletes an existing custom verification email template. </p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> DeleteCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::DeleteCustomVerificationEmailTemplateOutput,
                crate::error::DeleteCustomVerificationEmailTemplateError,
                crate::input::DeleteCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentity`.
    ///
    /// <p>Deletes the specified identity (an email address or a domain) from the list of
    /// verified identities.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_input::Builder,
    }
    impl<C, M, R> DeleteIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityInputOperationOutputAlias,
                crate::output::DeleteIdentityOutput,
                crate::error::DeleteIdentityError,
                crate::input::DeleteIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIdentityPolicy`.
    ///
    /// <p>Deletes the specified sending authorization policy for the given identity (an email
    /// address or a domain). This API returns successfully even if a policy with the specified
    /// name does not exist.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIdentityPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_identity_policy_input::Builder,
    }
    impl<C, M, R> DeleteIdentityPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIdentityPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIdentityPolicyInputOperationOutputAlias,
                crate::output::DeleteIdentityPolicyOutput,
                crate::error::DeleteIdentityPolicyError,
                crate::input::DeleteIdentityPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that is associated with the policy that you want to delete. You can
        /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
        /// Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity that is associated with the policy that you want to delete. You can
        /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
        /// Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptFilter`.
    ///
    /// <p>Deletes the specified IP address filter.</p>
    /// <p>For information about managing IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReceiptFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_receipt_filter_input::Builder,
    }
    impl<C, M, R> DeleteReceiptFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReceiptFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReceiptFilterInputOperationOutputAlias,
                crate::output::DeleteReceiptFilterOutput,
                crate::error::DeleteReceiptFilterError,
                crate::input::DeleteReceiptFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP address filter to delete.</p>
        pub fn filter_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(inp);
            self
        }
        /// <p>The name of the IP address filter to delete.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptRule`.
    ///
    /// <p>Deletes the specified receipt rule.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReceiptRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_receipt_rule_input::Builder,
    }
    impl<C, M, R> DeleteReceiptRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReceiptRuleInputOperationOutputAlias,
                crate::output::DeleteReceiptRuleOutput,
                crate::error::DeleteReceiptRuleError,
                crate::input::DeleteReceiptRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReceiptRuleSet`.
    ///
    /// <p>Deletes the specified receipt rule set and all of the receipt rules it
    /// contains.</p>
    /// <note>
    /// <p>The currently active rule set cannot be deleted.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> DeleteReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReceiptRuleSetInputOperationOutputAlias,
                crate::output::DeleteReceiptRuleSetOutput,
                crate::error::DeleteReceiptRuleSetError,
                crate::input::DeleteReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTemplate`.
    ///
    /// <p>Deletes an email template.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_template_input::Builder,
    }
    impl<C, M, R> DeleteTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTemplateInputOperationOutputAlias,
                crate::output::DeleteTemplateOutput,
                crate::error::DeleteTemplateError,
                crate::input::DeleteTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVerifiedEmailAddress`.
    ///
    /// <p>Deprecated. Use the <code>DeleteIdentity</code> operation to delete email addresses
    /// and domains.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVerifiedEmailAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_verified_email_address_input::Builder,
    }
    impl<C, M, R> DeleteVerifiedEmailAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVerifiedEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVerifiedEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVerifiedEmailAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVerifiedEmailAddressInputOperationOutputAlias,
                crate::output::DeleteVerifiedEmailAddressOutput,
                crate::error::DeleteVerifiedEmailAddressError,
                crate::input::DeleteVerifiedEmailAddressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActiveReceiptRuleSet`.
    ///
    /// <p>Returns the metadata and receipt rules for the receipt rule set that is currently
    /// active.</p>
    /// <p>For information about setting up receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeActiveReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_active_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> DescribeActiveReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActiveReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActiveReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActiveReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActiveReceiptRuleSetInputOperationOutputAlias,
                crate::output::DescribeActiveReceiptRuleSetOutput,
                crate::error::DescribeActiveReceiptRuleSetError,
                crate::input::DescribeActiveReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeConfigurationSet`.
    ///
    /// <p>Returns the details of the specified configuration set. For information about using
    /// configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConfigurationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_configuration_set_input::Builder,
    }
    impl<C, M, R> DescribeConfigurationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConfigurationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConfigurationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConfigurationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConfigurationSetInputOperationOutputAlias,
                crate::output::DescribeConfigurationSetOutput,
                crate::error::DescribeConfigurationSetError,
                crate::input::DescribeConfigurationSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set to describe.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to describe.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `ConfigurationSetAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_configuration_set_attribute_names`](Self::set_configuration_set_attribute_names).
        ///
        /// <p>A list of configuration set attributes to return.</p>
        pub fn configuration_set_attribute_names(
            mut self,
            inp: impl Into<crate::model::ConfigurationSetAttribute>,
        ) -> Self {
            self.inner = self.inner.configuration_set_attribute_names(inp);
            self
        }
        /// <p>A list of configuration set attributes to return.</p>
        pub fn set_configuration_set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReceiptRule`.
    ///
    /// <p>Returns the details of the specified receipt rule.</p>
    /// <p>For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReceiptRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_receipt_rule_input::Builder,
    }
    impl<C, M, R> DescribeReceiptRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReceiptRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReceiptRuleInputOperationOutputAlias,
                crate::output::DescribeReceiptRuleOutput,
                crate::error::DescribeReceiptRuleError,
                crate::input::DescribeReceiptRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReceiptRuleSet`.
    ///
    /// <p>Returns the details of the specified receipt rule set.</p>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> DescribeReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReceiptRuleSetInputOperationOutputAlias,
                crate::output::DescribeReceiptRuleSetOutput,
                crate::error::DescribeReceiptRuleSetError,
                crate::input::DescribeReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSendingEnabled`.
    ///
    /// <p>Returns the email sending status of the Amazon SES account for the current region.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSendingEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_sending_enabled_input::Builder,
    }
    impl<C, M, R> GetAccountSendingEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSendingEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSendingEnabledError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSendingEnabledInputOperationOutputAlias,
                crate::output::GetAccountSendingEnabledOutput,
                crate::error::GetAccountSendingEnabledError,
                crate::input::GetAccountSendingEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCustomVerificationEmailTemplate`.
    ///
    /// <p>Returns the custom email verification template for the template name you
    /// specify.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> GetCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::GetCustomVerificationEmailTemplateOutput,
                crate::error::GetCustomVerificationEmailTemplateError,
                crate::input::GetCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityDkimAttributes`.
    ///
    /// <p>Returns the current status of Easy DKIM signing for an entity. For domain name
    /// identities, this operation also returns the DKIM tokens that are required for Easy DKIM
    /// signing, and whether Amazon SES has successfully verified that these tokens have been
    /// published.</p>
    /// <p>This operation takes a list of identities as input and returns the following
    /// information for each:</p>
    /// <ul>
    /// <li>
    /// <p>Whether Easy DKIM signing is enabled or disabled.</p>
    /// </li>
    /// <li>
    /// <p>A set of DKIM tokens that represent the identity. If the identity is an email
    /// address, the tokens represent the domain of that address.</p>
    /// </li>
    /// <li>
    /// <p>Whether Amazon SES has successfully verified the DKIM tokens published in the
    /// domain's DNS. This information is only returned for domain name identities, not
    /// for email addresses.</p>
    /// </li>
    /// </ul>
    /// <p>This operation is throttled at one request per second and can only get DKIM attributes
    /// for up to 100 identities at a time.</p>
    /// <p>For more information about creating DNS records using DKIM tokens, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityDkimAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_dkim_attributes_input::Builder,
    }
    impl<C, M, R> GetIdentityDkimAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityDkimAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityDkimAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityDkimAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityDkimAttributesInputOperationOutputAlias,
                crate::output::GetIdentityDkimAttributesOutput,
                crate::error::GetIdentityDkimAttributesError,
                crate::input::GetIdentityDkimAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn identities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(inp);
            self
        }
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityMailFromDomainAttributes`.
    ///
    /// <p>Returns the custom MAIL FROM attributes for a list of identities (email addresses :
    /// domains).</p>
    /// <p>This operation is throttled at one request per second and can only get custom MAIL
    /// FROM attributes for up to 100 identities at a time.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityMailFromDomainAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_mail_from_domain_attributes_input::Builder,
    }
    impl<C, M, R> GetIdentityMailFromDomainAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityMailFromDomainAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityMailFromDomainAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetIdentityMailFromDomainAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityMailFromDomainAttributesInputOperationOutputAlias,
                crate::output::GetIdentityMailFromDomainAttributesOutput,
                crate::error::GetIdentityMailFromDomainAttributesError,
                crate::input::GetIdentityMailFromDomainAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities.</p>
        pub fn identities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(inp);
            self
        }
        /// <p>A list of one or more identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityNotificationAttributes`.
    ///
    /// <p>Given a list of verified identities (email addresses and/or domains), returns a
    /// structure describing identity notification attributes.</p>
    /// <p>This operation is throttled at one request per second and can only get notification
    /// attributes for up to 100 identities at a time.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES
    /// Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityNotificationAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_notification_attributes_input::Builder,
    }
    impl<C, M, R> GetIdentityNotificationAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityNotificationAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityNotificationAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityNotificationAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityNotificationAttributesInputOperationOutputAlias,
                crate::output::GetIdentityNotificationAttributesOutput,
                crate::error::GetIdentityNotificationAttributesError,
                crate::input::GetIdentityNotificationAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities. You can specify an identity by using its name or by
        /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(inp);
            self
        }
        /// <p>A list of one or more identities. You can specify an identity by using its name or by
        /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityPolicies`.
    ///
    /// <p>Returns the requested sending authorization policies for the given identity (an email
    /// address or a domain). The policies are returned as a map of policy names to policy
    /// contents. You can retrieve a maximum of 20 policies at a time.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_policies_input::Builder,
    }
    impl<C, M, R> GetIdentityPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityPoliciesInputOperationOutputAlias,
                crate::output::GetIdentityPoliciesOutput,
                crate::error::GetIdentityPoliciesError,
                crate::input::GetIdentityPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by
        /// using its name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by
        /// using its name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// Appends an item to `PolicyNames`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
        /// policies at a time. If you do not know the names of the policies that are attached to
        /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn policy_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_names(inp);
            self
        }
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
        /// policies at a time. If you do not know the names of the policies that are attached to
        /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityVerificationAttributes`.
    ///
    /// <p>Given a list of identities (email addresses and/or domains), returns the verification
    /// status and (for domain identities) the verification token for each identity.</p>
    /// <p>The verification status of an email address is "Pending" until the email address owner
    /// clicks the link within the verification email that Amazon SES sent to that address. If the
    /// email address owner clicks the link within 24 hours, the verification status of the
    /// email address changes to "Success". If the link is not clicked within 24 hours, the
    /// verification status changes to "Failed." In that case, if you still want to verify the
    /// email address, you must restart the verification process from the beginning.</p>
    /// <p>For domain identities, the domain's verification status is "Pending" as Amazon SES searches
    /// for the required TXT record in the DNS settings of the domain. When Amazon SES detects the
    /// record, the domain's verification status changes to "Success". If Amazon SES is unable to
    /// detect the record within 72 hours, the domain's verification status changes to "Failed."
    /// In that case, if you still want to verify the domain, you must restart the verification
    /// process from the beginning.</p>
    /// <p>This operation is throttled at one request per second and can only get verification
    /// attributes for up to 100 identities at a time.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIdentityVerificationAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_identity_verification_attributes_input::Builder,
    }
    impl<C, M, R> GetIdentityVerificationAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIdentityVerificationAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityVerificationAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityVerificationAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIdentityVerificationAttributesInputOperationOutputAlias,
                crate::output::GetIdentityVerificationAttributesOutput,
                crate::error::GetIdentityVerificationAttributesError,
                crate::input::GetIdentityVerificationAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of identities.</p>
        pub fn identities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identities(inp);
            self
        }
        /// <p>A list of identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_identities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSendQuota`.
    ///
    /// <p>Provides the sending limits for the Amazon SES account. </p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSendQuota<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_send_quota_input::Builder,
    }
    impl<C, M, R> GetSendQuota<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSendQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSendQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSendQuotaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSendQuotaInputOperationOutputAlias,
                crate::output::GetSendQuotaOutput,
                crate::error::GetSendQuotaError,
                crate::input::GetSendQuotaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSendStatistics`.
    ///
    /// <p>Provides sending statistics for the current AWS Region. The result is a list of data
    /// points, representing the last two weeks of sending activity. Each data point in the list
    /// contains statistics for a 15-minute period of time.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSendStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_send_statistics_input::Builder,
    }
    impl<C, M, R> GetSendStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSendStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSendStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSendStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSendStatisticsInputOperationOutputAlias,
                crate::output::GetSendStatisticsOutput,
                crate::error::GetSendStatisticsError,
                crate::input::GetSendStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetTemplate`.
    ///
    /// <p>Displays the template object (which includes the Subject line, HTML part and text
    /// part) for the template you specify.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_template_input::Builder,
    }
    impl<C, M, R> GetTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTemplateInputOperationOutputAlias,
                crate::output::GetTemplateOutput,
                crate::error::GetTemplateError,
                crate::input::GetTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template you want to retrieve.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigurationSets`.
    ///
    /// <p>Provides a list of the configuration sets associated with your Amazon SES account in the
    /// current AWS Region. For information about using configuration sets, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon SES Sending Activity</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// <p>You can execute this operation no more than once per second. This operation will
    /// return up to 1,000 configuration sets each time it is run. If your Amazon SES account has
    /// more than 1,000 configuration sets, this operation will also return a NextToken element.
    /// You can then execute the <code>ListConfigurationSets</code> operation again, passing the
    /// <code>NextToken</code> parameter and the value of the NextToken element to retrieve
    /// additional results.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigurationSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configuration_sets_input::Builder,
    }
    impl<C, M, R> ListConfigurationSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigurationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigurationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigurationSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigurationSetsInputOperationOutputAlias,
                crate::output::ListConfigurationSetsOutput,
                crate::error::ListConfigurationSetsError,
                crate::input::ListConfigurationSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position of the configuration set in the configuration set list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position of the configuration set in the configuration set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomVerificationEmailTemplates`.
    ///
    /// <p>Lists the existing custom verification email templates for your account in the current
    /// AWS Region.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomVerificationEmailTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_verification_email_templates_input::Builder,
    }
    impl<C, M, R> ListCustomVerificationEmailTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomVerificationEmailTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomVerificationEmailTemplatesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomVerificationEmailTemplatesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomVerificationEmailTemplatesInputOperationOutputAlias,
                crate::output::ListCustomVerificationEmailTemplatesOutput,
                crate::error::ListCustomVerificationEmailTemplatesError,
                crate::input::ListCustomVerificationEmailTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must
        /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
        /// specify a value less than 1 or greater than 50, the operation will return up to 50
        /// results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must
        /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
        /// specify a value less than 1 or greater than 50, the operation will return up to 50
        /// results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentities`.
    ///
    /// <p>Returns a list containing all of the identities (email addresses and domains) for your
    /// AWS account in the current AWS Region, regardless of verification status.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identities_input::Builder,
    }
    impl<C, M, R> ListIdentities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentitiesInputOperationOutputAlias,
                crate::output::ListIdentitiesOutput,
                crate::error::ListIdentitiesError,
                crate::input::ListIdentitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
        /// If this parameter is omitted, then all identities will be listed.</p>
        pub fn identity_type(mut self, inp: crate::model::IdentityType) -> Self {
            self.inner = self.inner.identity_type(inp);
            self
        }
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
        /// If this parameter is omitted, then all identities will be listed.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.inner = self.inner.set_identity_type(input);
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000
        /// inclusive.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000
        /// inclusive.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityPolicies`.
    ///
    /// <p>Returns a list of sending authorization policies that are attached to the given
    /// identity (an email address or a domain). This API returns only a list. If you want the
    /// actual policy content, you can use <code>GetIdentityPolicies</code>.</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIdentityPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_identity_policies_input::Builder,
    }
    impl<C, M, R> ListIdentityPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIdentityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIdentityPoliciesInputOperationOutputAlias,
                crate::output::ListIdentityPoliciesOutput,
                crate::error::ListIdentityPoliciesError,
                crate::input::ListIdentityPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that is associated with the policy for which the policies will be listed.
        /// You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity that is associated with the policy for which the policies will be listed.
        /// You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceiptFilters`.
    ///
    /// <p>Lists the IP address filters associated with your AWS account in the current AWS
    /// Region.</p>
    /// <p>For information about managing IP address filters, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReceiptFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_receipt_filters_input::Builder,
    }
    impl<C, M, R> ListReceiptFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceiptFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceiptFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceiptFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceiptFiltersInputOperationOutputAlias,
                crate::output::ListReceiptFiltersOutput,
                crate::error::ListReceiptFiltersError,
                crate::input::ListReceiptFiltersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListReceiptRuleSets`.
    ///
    /// <p>Lists the receipt rule sets that exist under your AWS account in the current AWS
    /// Region. If there are additional receipt rule sets to be retrieved, you will receive a
    /// <code>NextToken</code> that you can provide to the next call to
    /// <code>ListReceiptRuleSets</code> to retrieve the additional entries.</p>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReceiptRuleSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_receipt_rule_sets_input::Builder,
    }
    impl<C, M, R> ListReceiptRuleSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceiptRuleSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceiptRuleSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceiptRuleSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceiptRuleSetsInputOperationOutputAlias,
                crate::output::ListReceiptRuleSetsOutput,
                crate::error::ListReceiptRuleSetsError,
                crate::input::ListReceiptRuleSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
        /// the position in the receipt rule set list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
        /// the position in the receipt rule set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTemplates`.
    ///
    /// <p>Lists the email templates present in your Amazon SES account in the current AWS
    /// Region.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_templates_input::Builder,
    }
    impl<C, M, R> ListTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTemplatesInputOperationOutputAlias,
                crate::output::ListTemplatesOutput,
                crate::error::ListTemplatesError,
                crate::input::ListTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
        /// position in the list of email templates.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
        /// position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than
        /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
        /// greater than 10, the operation will return up to 10 results.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than
        /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
        /// greater than 10, the operation will return up to 10 results.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVerifiedEmailAddresses`.
    ///
    /// <p>Deprecated. Use the <code>ListIdentities</code> operation to list the email addresses
    /// and domains associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVerifiedEmailAddresses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_verified_email_addresses_input::Builder,
    }
    impl<C, M, R> ListVerifiedEmailAddresses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVerifiedEmailAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVerifiedEmailAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVerifiedEmailAddressesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVerifiedEmailAddressesInputOperationOutputAlias,
                crate::output::ListVerifiedEmailAddressesOutput,
                crate::error::ListVerifiedEmailAddressesError,
                crate::input::ListVerifiedEmailAddressesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PutConfigurationSetDeliveryOptions`.
    ///
    /// <p>Adds or updates the delivery options for a configuration set.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutConfigurationSetDeliveryOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_configuration_set_delivery_options_input::Builder,
    }
    impl<C, M, R> PutConfigurationSetDeliveryOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutConfigurationSetDeliveryOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutConfigurationSetDeliveryOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutConfigurationSetDeliveryOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutConfigurationSetDeliveryOptionsInputOperationOutputAlias,
                crate::output::PutConfigurationSetDeliveryOptionsOutput,
                crate::error::PutConfigurationSetDeliveryOptionsError,
                crate::input::PutConfigurationSetDeliveryOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to specify the delivery options
        /// for.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that you want to specify the delivery options
        /// for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn delivery_options(mut self, inp: crate::model::DeliveryOptions) -> Self {
            self.inner = self.inner.delivery_options(inp);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.inner = self.inner.set_delivery_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIdentityPolicy`.
    ///
    /// <p>Adds or updates a sending authorization policy for the specified identity (an email
    /// address or a domain).</p>
    /// <note>
    /// <p>This API is for the identity owner only. If you have not verified the identity,
    /// this API will return an error.</p>
    /// </note>
    /// <p>Sending authorization is a feature that enables an identity owner to authorize other
    /// senders to use its identities. For information about using sending authorization, see
    /// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutIdentityPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_identity_policy_input::Builder,
    }
    impl<C, M, R> PutIdentityPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIdentityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIdentityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIdentityPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIdentityPolicyInputOperationOutputAlias,
                crate::output::PutIdentityPolicyOutput,
                crate::error::PutIdentityPolicyError,
                crate::input::PutIdentityPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity that the policy will apply to. You can specify an identity by using its
        /// name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity that the policy will apply to. You can specify an identity by using its
        /// name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>. </p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReorderReceiptRuleSet`.
    ///
    /// <p>Reorders the receipt rules within a receipt rule set.</p>
    /// <note>
    /// <p>All of the rules in the rule set must be represented in this request. That is,
    /// this API will return an error if the reorder request doesn't explicitly position all
    /// of the rules.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct ReorderReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reorder_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> ReorderReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReorderReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReorderReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::ReorderReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReorderReceiptRuleSetInputOperationOutputAlias,
                crate::output::ReorderReceiptRuleSetOutput,
                crate::error::ReorderReceiptRuleSetError,
                crate::input::ReorderReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// Appends an item to `RuleNames`.
        ///
        /// To override the contents of this collection use [`set_rule_names`](Self::set_rule_names).
        ///
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
        /// put them.</p>
        pub fn rule_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_names(inp);
            self
        }
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
        /// put them.</p>
        pub fn set_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rule_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBounce`.
    ///
    /// <p>Generates and sends a bounce message to the sender of an email you received through
    /// Amazon SES. You can only use this API on an email up to 24 hours after you receive it.</p>
    /// <note>
    /// <p>You cannot use this API to send generic bounces for mail that was not received by
    /// Amazon SES.</p>
    /// </note>
    /// <p>For information about receiving email through Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendBounce<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_bounce_input::Builder,
    }
    impl<C, M, R> SendBounce<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendBounce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBounceOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBounceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendBounceInputOperationOutputAlias,
                crate::output::SendBounceOutput,
                crate::error::SendBounceError,
                crate::input::SendBounceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The message ID of the message to be bounced.</p>
        pub fn original_message_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.original_message_id(inp);
            self
        }
        /// <p>The message ID of the message to be bounced.</p>
        pub fn set_original_message_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_original_message_id(input);
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an
        /// identity that you have verified with Amazon SES.</p>
        pub fn bounce_sender(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bounce_sender(inp);
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an
        /// identity that you have verified with Amazon SES.</p>
        pub fn set_bounce_sender(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bounce_sender(input);
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
        /// the text will be auto-generated based on the bounced recipient information.</p>
        pub fn explanation(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.explanation(inp);
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
        /// the text will be auto-generated based on the bounced recipient information.</p>
        pub fn set_explanation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_explanation(input);
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn message_dsn(mut self, inp: crate::model::MessageDsn) -> Self {
            self.inner = self.inner.message_dsn(inp);
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn set_message_dsn(
            mut self,
            input: std::option::Option<crate::model::MessageDsn>,
        ) -> Self {
            self.inner = self.inner.set_message_dsn(input);
            self
        }
        /// Appends an item to `BouncedRecipientInfoList`.
        ///
        /// To override the contents of this collection use [`set_bounced_recipient_info_list`](Self::set_bounced_recipient_info_list).
        ///
        /// <p>A list of recipients of the bounced message, including the information required to
        /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
        /// least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn bounced_recipient_info_list(
            mut self,
            inp: impl Into<crate::model::BouncedRecipientInfo>,
        ) -> Self {
            self.inner = self.inner.bounced_recipient_info_list(inp);
            self
        }
        /// <p>A list of recipients of the bounced message, including the information required to
        /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
        /// least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn set_bounced_recipient_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BouncedRecipientInfo>>,
        ) -> Self {
            self.inner = self.inner.set_bounced_recipient_info_list(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// address in the "From" header of the bounce. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn bounce_sender_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bounce_sender_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// address in the "From" header of the bounce. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_bounce_sender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bounce_sender_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendBulkTemplatedEmail`.
    ///
    /// <p>Composes an email message to multiple destinations. The message body is created using
    /// an email template.</p>
    /// <p>In order to send email using the <code>SendBulkTemplatedEmail</code> operation, your
    /// call to the API must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>The call must refer to an existing email template. You can create email
    /// templates using the <a>CreateTemplate</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The message must be sent from a verified email address or domain.</p>
    /// </li>
    /// <li>
    /// <p>If your account is still in the Amazon SES sandbox, you may only send to verified
    /// addresses or domains, or to email addresses associated with the Amazon SES Mailbox
    /// Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying
    /// Email Addresses and Domains</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>The maximum message size is 10 MB.</p>
    /// </li>
    /// <li>
    /// <p>Each <code>Destination</code> parameter must include at least one recipient
    /// email address. The recipient address can be a To: address, a CC: address, or a
    /// BCC: address. If a recipient email address is invalid (that is, it is not in the
    /// format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the
    /// entire message will be rejected, even if the message contains other recipients
    /// that are valid.</p>
    /// </li>
    /// <li>
    /// <p>The message may not include more than 50 recipients, across the To:, CC: and
    /// BCC: fields. If you need to send an email message to a larger audience, you can
    /// divide your recipient list into groups of 50 or fewer, and then call the
    /// <code>SendBulkTemplatedEmail</code> operation several times to send the
    /// message to each group.</p>
    /// </li>
    /// <li>
    /// <p>The number of destinations you can contact in a single call to the API may be
    /// limited by your account's maximum sending rate.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct SendBulkTemplatedEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_bulk_templated_email_input::Builder,
    }
    impl<C, M, R> SendBulkTemplatedEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendBulkTemplatedEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendBulkTemplatedEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendBulkTemplatedEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendBulkTemplatedEmailInputOperationOutputAlias,
                crate::output::SendBulkTemplatedEmailOutput,
                crate::error::SendBulkTemplatedEmailError,
                crate::input::SendBulkTemplatedEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(inp);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(inp);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendBulkTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// Appends an item to `DefaultTags`.
        ///
        /// To override the contents of this collection use [`set_default_tags`](Self::set_default_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
        /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn default_tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.default_tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
        /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_default_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_default_tags(input);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(inp);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_arn(inp);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_arn(input);
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not
        /// specified in a Destination object. These values act as a default or fallback option when
        /// no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
        /// the keys correspond to replacement tags in the email template.</p>
        pub fn default_template_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_template_data(inp);
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not
        /// specified in a Destination object. These values act as a default or fallback option when
        /// no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
        /// the keys correspond to replacement tags in the email template.</p>
        pub fn set_default_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_template_data(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a
        /// <code>Destination</code> will receive the same version of the email. You can specify
        /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
        /// array.</p>
        pub fn destinations(mut self, inp: impl Into<crate::model::BulkEmailDestination>) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a
        /// <code>Destination</code> will receive the same version of the email. You can specify
        /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
        /// array.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestination>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendCustomVerificationEmail`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current
    /// AWS Region and attempts to verify it. As a result of executing this operation, a
    /// customized verification email is sent to the specified address.</p>
    /// <p>To use this operation, you must first create a custom verification email template. For
    /// more information about creating and using custom verification email templates, see
    /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
    /// Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendCustomVerificationEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_custom_verification_email_input::Builder,
    }
    impl<C, M, R> SendCustomVerificationEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendCustomVerificationEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendCustomVerificationEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendCustomVerificationEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendCustomVerificationEmailInputOperationOutputAlias,
                crate::output::SendCustomVerificationEmailOutput,
                crate::error::SendCustomVerificationEmailError,
                crate::input::SendCustomVerificationEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEmail`.
    ///
    /// <p>Composes an email message and immediately queues it for sending. In order to send
    /// email using the <code>SendEmail</code> operation, your message must meet the following
    /// requirements:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>The message must be sent from a verified email address or domain. If you
    /// attempt to send email using a non-verified address or domain, the operation will
    /// result in an "Email address not verified" error. </p>
    /// </li>
    /// <li>
    /// <p>If your account is still in the Amazon SES sandbox, you may only send to verified
    /// addresses or domains, or to email addresses associated with the Amazon SES Mailbox
    /// Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying
    /// Email Addresses and Domains</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>The maximum message size is 10 MB.</p>
    /// </li>
    /// <li>
    /// <p>The message must include at least one recipient email address. The recipient
    /// address can be a To: address, a CC: address, or a BCC: address. If a recipient
    /// email address is invalid (that is, it is not in the format
    /// <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the entire
    /// message will be rejected, even if the message contains other recipients that are
    /// valid.</p>
    /// </li>
    /// <li>
    /// <p>The message may not include more than 50 recipients, across the To:, CC: and
    /// BCC: fields. If you need to send an email message to a larger audience, you can
    /// divide your recipient list into groups of 50 or fewer, and then call the
    /// <code>SendEmail</code> operation several times to send the message to each
    /// group.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>For every message that you send, the total number of recipients (including each
    /// recipient in the To:, CC: and BCC: fields) is counted against the maximum number of
    /// emails you can send in a 24-hour period (your <i>sending quota</i>).
    /// For more information about sending quotas in Amazon SES, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your Amazon SES
    /// Sending Limits</a> in the <i>Amazon SES Developer Guide.</i>
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct SendEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_email_input::Builder,
    }
    impl<C, M, R> SendEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendEmailInputOperationOutputAlias,
                crate::output::SendEmailOutput,
                crate::error::SendEmailError,
                crate::input::SendEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn destination(mut self, inp: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The message to be sent.</p>
        pub fn message(mut self, inp: crate::model::Message) -> Self {
            self.inner = self.inner.message(inp);
            self
        }
        /// <p>The message to be sent.</p>
        pub fn set_message(mut self, input: std::option::Option<crate::model::Message>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(inp);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(inp);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
        /// define, so that you can publish email sending events.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
        /// define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendEmail</code>.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendRawEmail`.
    ///
    /// <p>Composes an email message and immediately queues it for sending.</p>
    ///
    /// <p>This operation is more flexible than the <code>SendEmail</code> API operation. When
    /// you use the <code>SendRawEmail</code> operation, you can specify the headers of the
    /// message as well as its content. This flexibility is useful, for example, when you want
    /// to send a multipart MIME email (such a message that contains both a text and an HTML
    /// version). You can also use this operation to send messages that include
    /// attachments.</p>
    /// <p>The <code>SendRawEmail</code> operation has the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>You can only send email from <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">verified email addresses or domains</a>. If you try
    /// to send email from an address that isn't verified, the operation results in an
    /// "Email address not verified" error.</p>
    /// </li>
    /// <li>
    /// <p>If your account is still in the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html">Amazon SES sandbox</a>, you can only send email to other
    /// verified addresses in your account, or to addresses that are associated with the
    /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html">Amazon SES mailbox simulator</a>.</p>
    /// </li>
    /// <li>
    /// <p>The maximum message size, including attachments, is 10 MB.</p>
    /// </li>
    /// <li>
    /// <p>Each message has to include at least one recipient address. A recipient
    /// address includes any address on the To:, CC:, or BCC: lines.</p>
    /// </li>
    /// <li>
    /// <p>If you send a single message to more than one recipient address, and one of
    /// the recipient addresses isn't in a valid format (that is, it's not in the format
    /// <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), Amazon SES
    /// rejects the entire message, even if the other addresses are valid.</p>
    /// </li>
    /// <li>
    /// <p>Each message can include up to 50 recipient addresses across the To:, CC:, or
    /// BCC: lines. If you need to send a single message to more than 50 recipients, you
    /// have to split the list of recipient addresses into groups of less than 50
    /// recipients, and send separate messages to each group.</p>
    /// </li>
    /// <li>
    /// <p>Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for MIME message
    /// parts. However, if Amazon SES has to modify the contents of your message (for
    /// example, if you use open and click tracking), 8-bit content isn't preserved. For
    /// this reason, we highly recommend that you encode all content that isn't 7-bit
    /// ASCII. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding">MIME Encoding</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// </li>
    /// </ul>
    ///
    ///
    ///
    /// <p>Additionally, keep the following considerations in mind when using the
    /// <code>SendRawEmail</code> operation:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Although you can customize the message headers when using the
    /// <code>SendRawEmail</code> operation, Amazon SES will automatically apply its own
    /// <code>Message-ID</code> and <code>Date</code> headers; if you passed these
    /// headers when creating the message, they will be overwritten by the values that
    /// Amazon SES provides.</p>
    /// </li>
    /// <li>
    /// <p>If you are using sending authorization to send on behalf of another user,
    /// <code>SendRawEmail</code> enables you to specify the cross-account identity
    /// for the email's Source, From, and Return-Path parameters in one of two ways: you
    /// can pass optional parameters <code>SourceArn</code>, <code>FromArn</code>,
    /// and/or <code>ReturnPathArn</code> to the API, or you can include the following
    /// X-headers in the header of your raw email:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>X-SES-SOURCE-ARN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>X-SES-FROM-ARN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>X-SES-RETURN-PATH-ARN</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>Don't include these X-headers in the DKIM signature. Amazon SES removes these
    /// before it sends the email.</p>
    /// </important>
    /// <p>If you only specify the <code>SourceIdentityArn</code> parameter, Amazon SES sets
    /// the From and Return-Path addresses to the same identity that you
    /// specified.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Using Sending
    /// Authorization with Amazon SES</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For every message that you send, the total number of recipients (including
    /// each recipient in the To:, CC: and BCC: fields) is counted against the maximum
    /// number of emails you can send in a 24-hour period (your <i>sending
    /// quota</i>). For more information about sending quotas in Amazon SES, see
    /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html">Managing Your
    /// Amazon SES Sending Limits</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct SendRawEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_raw_email_input::Builder,
    }
    impl<C, M, R> SendRawEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendRawEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendRawEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendRawEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendRawEmailInputOperationOutputAlias,
                crate::output::SendRawEmailOutput,
                crate::error::SendRawEmailError,
                crate::input::SendRawEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity's email address. If you do not provide a value for this parameter, you
        /// must specify a "From" address in the raw text of the message. (You can also specify
        /// both.)</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        ///
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
        /// then bounces and complaints will be sent to this email address. This takes precedence
        /// over any Return-Path header that you might include in the raw text of the
        /// message.</p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The identity's email address. If you do not provide a value for this parameter, you
        /// must specify a "From" address in the raw text of the message. (You can also specify
        /// both.)</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        ///
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
        /// then bounces and complaints will be sent to this email address. This takes precedence
        /// over any Return-Path header that you might include in the raw text of the
        /// message.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
        /// addresses.</p>
        pub fn destinations(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destinations(inp);
            self
        }
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
        /// addresses.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by a blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
        /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
        /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be base64-encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, we highly recommend that you encode that
        /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
        /// Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
        /// 5321</a>, the maximum length of each line of text, including the
        /// <CRLF>, must not exceed 1,000 characters.</p>
        /// </li>
        /// </ul>
        pub fn raw_message(mut self, inp: crate::model::RawMessage) -> Self {
            self.inner = self.inner.raw_message(inp);
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by a blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
        /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
        /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be base64-encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, we highly recommend that you encode that
        /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
        /// Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
        /// 5321</a>, the maximum length of each line of text, including the
        /// <CRLF>, must not exceed 1,000 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_raw_message(
            mut self,
            input: std::option::Option<crate::model::RawMessage>,
        ) -> Self {
            self.inner = self.inner.set_raw_message(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to specify a
        /// particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
        /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
        /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
        /// parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn from_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to specify a
        /// particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
        /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
        /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
        /// parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_from_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_from_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
        /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>SourceArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
        /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>SourceArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
        /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>ReturnPathArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn return_path_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
        /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>ReturnPathArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
        /// you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
        /// you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendRawEmail</code>.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendRawEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendTemplatedEmail`.
    ///
    /// <p>Composes an email message using an email template and immediately queues it for
    /// sending.</p>
    /// <p>In order to send email using the <code>SendTemplatedEmail</code> operation, your call
    /// to the API must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>The call must refer to an existing email template. You can create email
    /// templates using the <a>CreateTemplate</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>The message must be sent from a verified email address or domain.</p>
    /// </li>
    /// <li>
    /// <p>If your account is still in the Amazon SES sandbox, you may only send to verified
    /// addresses or domains, or to email addresses associated with the Amazon SES Mailbox
    /// Simulator. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying
    /// Email Addresses and Domains</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>The maximum message size is 10 MB.</p>
    /// </li>
    /// <li>
    /// <p>Calls to the <code>SendTemplatedEmail</code> operation may only include one
    /// <code>Destination</code> parameter. A destination is a set of recipients who
    /// will receive the same version of the email. The <code>Destination</code>
    /// parameter can include up to 50 recipients, across the To:, CC: and BCC:
    /// fields.</p>
    /// </li>
    /// <li>
    /// <p>The <code>Destination</code> parameter must include at least one recipient
    /// email address. The recipient address can be a To: address, a CC: address, or a
    /// BCC: address. If a recipient email address is invalid (that is, it is not in the
    /// format <i>UserName@[SubDomain.]Domain.TopLevelDomain</i>), the
    /// entire message will be rejected, even if the message contains other recipients
    /// that are valid.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>If your call to the <code>SendTemplatedEmail</code> operation includes all of the
    /// required parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon SES
    /// can't render the email because the template contains errors, it doesn't send the
    /// email. Additionally, because it already accepted the message, Amazon SES doesn't return a
    /// message stating that it was unable to send the email.</p>
    /// <p>For these reasons, we highly recommend that you set up Amazon SES to send you
    /// notifications when Rendering Failure events occur. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Sending
    /// Personalized Email Using the Amazon SES API</a> in the <i>Amazon Simple Email Service
    /// Developer Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct SendTemplatedEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_templated_email_input::Builder,
    }
    impl<C, M, R> SendTemplatedEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendTemplatedEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendTemplatedEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::SendTemplatedEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendTemplatedEmailInputOperationOutputAlias,
                crate::output::SendTemplatedEmailOutput,
                crate::error::SendTemplatedEmailError,
                crate::input::SendTemplatedEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
        /// can include up to 50 recipients across these three fields.</p>
        pub fn destination(mut self, inp: crate::model::Destination) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
        /// can include up to 50 recipients across these three fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// Appends an item to `ReplyToAddresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reply_to_addresses(inp);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reply_to_addresses(input);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path(inp);
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_return_path(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.return_path_arn(inp);
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_return_path_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
        /// that you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::MessageTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
        /// that you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(inp);
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_arn(inp);
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_arn(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn template_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(inp);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetActiveReceiptRuleSet`.
    ///
    /// <p>Sets the specified receipt rule set as the active receipt rule set.</p>
    /// <note>
    /// <p>To disable your email-receiving through Amazon SES completely, you can call this API
    /// with RuleSetName set to null.</p>
    /// </note>
    /// <p>For information about managing receipt rule sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html">Amazon SES Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetActiveReceiptRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_active_receipt_rule_set_input::Builder,
    }
    impl<C, M, R> SetActiveReceiptRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetActiveReceiptRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetActiveReceiptRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::SetActiveReceiptRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetActiveReceiptRuleSetInputOperationOutputAlias,
                crate::output::SetActiveReceiptRuleSetOutput,
                crate::error::SetActiveReceiptRuleSetError,
                crate::input::SetActiveReceiptRuleSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables
        /// all email receiving.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables
        /// all email receiving.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityDkimEnabled`.
    ///
    /// <p>Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM
    /// signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends
    /// from addresses on that domain. If Easy DKIM signing is enabled for an email address,
    /// then Amazon SES uses DKIM to sign all email it sends from that address.</p>
    /// <note>
    /// <p>For email addresses (for example, <code>user@example.com</code>), you can only
    /// enable DKIM signing if the corresponding domain (in this case,
    /// <code>example.com</code>) has been set up to use Easy DKIM.</p>
    /// </note>
    /// <p>You can enable DKIM signing for an identity at any time after you start the
    /// verification process for the identity, even if the verification process isn't complete. </p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about Easy DKIM signing, go to the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityDkimEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_dkim_enabled_input::Builder,
    }
    impl<C, M, R> SetIdentityDkimEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityDkimEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityDkimEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityDkimEnabledError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityDkimEnabledInputOperationOutputAlias,
                crate::output::SetIdentityDkimEnabledOutput,
                crate::error::SetIdentityDkimEnabledError,
                crate::input::SetIdentityDkimEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
        /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn dkim_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.dkim_enabled(inp);
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
        /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn set_dkim_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dkim_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityFeedbackForwardingEnabled`.
    ///
    /// <p>Given an identity (an email address or a domain), enables or disables whether Amazon SES
    /// forwards bounce and complaint notifications as email. Feedback forwarding can only be
    /// disabled when Amazon Simple Notification Service (Amazon SNS) topics are specified for both bounces and
    /// complaints.</p>
    /// <note>
    /// <p>Feedback forwarding does not apply to delivery notifications. Delivery
    /// notifications are only available through Amazon SNS.</p>
    /// </note>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES
    /// Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityFeedbackForwardingEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_feedback_forwarding_enabled_input::Builder,
    }
    impl<C, M, R> SetIdentityFeedbackForwardingEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityFeedbackForwardingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityFeedbackForwardingEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetIdentityFeedbackForwardingEnabledError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityFeedbackForwardingEnabledInputOperationOutputAlias,
                crate::output::SetIdentityFeedbackForwardingEnabledOutput,
                crate::error::SetIdentityFeedbackForwardingEnabledError,
                crate::input::SetIdentityFeedbackForwardingEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
        /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
        /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
        /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
        /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
        /// notification types.</p>
        pub fn forwarding_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.forwarding_enabled(inp);
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
        /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
        /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
        /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
        /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
        /// notification types.</p>
        pub fn set_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_forwarding_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityHeadersInNotificationsEnabled`.
    ///
    /// <p>Given an identity (an email address or a domain), sets whether Amazon SES includes the
    /// original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified
    /// type.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about using notifications with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES
    /// Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityHeadersInNotificationsEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_headers_in_notifications_enabled_input::Builder,
    }
    impl<C, M, R> SetIdentityHeadersInNotificationsEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityHeadersInNotificationsEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetIdentityHeadersInNotificationsEnabledError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityHeadersInNotificationsEnabledInputOperationOutputAlias,
                crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
                crate::error::SetIdentityHeadersInNotificationsEnabledError,
                crate::input::SetIdentityHeadersInNotificationsEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity for which to enable or disable headers in notifications. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity for which to enable or disable headers in notifications. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn notification_type(mut self, inp: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(inp);
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
        /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
        /// particular Amazon SNS topic.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
        /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
        /// particular Amazon SNS topic.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityMailFromDomain`.
    ///
    /// <p>Enables or disables the custom MAIL FROM domain setup for a verified identity (an
    /// email address or a domain).</p>
    /// <important>
    /// <p>To send emails using the specified MAIL FROM domain, you must add an MX record to
    /// your MAIL FROM domain's DNS settings. If you want your emails to pass Sender Policy
    /// Framework (SPF) checks, you must also add or update an SPF record. For more
    /// information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// </important>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityMailFromDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_mail_from_domain_input::Builder,
    }
    impl<C, M, R> SetIdentityMailFromDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityMailFromDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityMailFromDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityMailFromDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityMailFromDomainInputOperationOutputAlias,
                crate::output::SetIdentityMailFromDomainOutput,
                crate::error::SetIdentityMailFromDomainError,
                crate::input::SetIdentityMailFromDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The verified identity for which you want to enable or disable the specified custom
        /// MAIL FROM domain.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The verified identity for which you want to enable or disable the specified custom
        /// MAIL FROM domain.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
        /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
        /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
        /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
        /// FROM setting for the identity.</p>
        pub fn mail_from_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mail_from_domain(inp);
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
        /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
        /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
        /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
        /// FROM setting for the identity.</p>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mail_from_domain(input);
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
        /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
        /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
        /// <code>RejectMessage</code>, Amazon SES will return a
        /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
        /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
        /// <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, inp: crate::model::BehaviorOnMxFailure) -> Self {
            self.inner = self.inner.behavior_on_mx_failure(inp);
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
        /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
        /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
        /// <code>RejectMessage</code>, Amazon SES will return a
        /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
        /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
        /// <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.inner = self.inner.set_behavior_on_mx_failure(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIdentityNotificationTopic`.
    ///
    /// <p>Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use
    /// this operation, you specify a verified identity, such as an email address or domain.
    /// When you send an email that uses the chosen identity in the Source field, Amazon SES sends
    /// notifications to the topic you specified. You can send bounce, complaint, or delivery
    /// notifications (or any combination of the three) to the Amazon SNS topic that you
    /// specify.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    /// <p>For more information about feedback notification, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer
    /// Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIdentityNotificationTopic<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_identity_notification_topic_input::Builder,
    }
    impl<C, M, R> SetIdentityNotificationTopic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIdentityNotificationTopic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIdentityNotificationTopicOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIdentityNotificationTopicError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIdentityNotificationTopicInputOperationOutputAlias,
                crate::output::SetIdentityNotificationTopicOutput,
                crate::error::SetIdentityNotificationTopicError,
                crate::input::SetIdentityNotificationTopicInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
        /// for.</p>
        /// <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.identity(inp);
            self
        }
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
        /// for.</p>
        /// <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_identity(input);
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn notification_type(mut self, inp: crate::model::NotificationType) -> Self {
            self.inner = self.inner.notification_type(inp);
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.inner = self.inner.set_notification_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
        /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
        /// is disabled.</p>
        pub fn sns_topic(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
        /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
        /// is disabled.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sns_topic(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetReceiptRulePosition`.
    ///
    /// <p>Sets the position of the specified receipt rule in the receipt rule set.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetReceiptRulePosition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_receipt_rule_position_input::Builder,
    }
    impl<C, M, R> SetReceiptRulePosition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetReceiptRulePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetReceiptRulePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::SetReceiptRulePositionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetReceiptRulePositionInputOperationOutputAlias,
                crate::output::SetReceiptRulePositionOutput,
                crate::error::SetReceiptRulePositionError,
                crate::input::SetReceiptRulePositionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(inp);
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn after(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after(inp);
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRenderTemplate`.
    ///
    /// <p>Creates a preview of the MIME content of an email when provided with a template and a
    /// set of replacement data.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestRenderTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_render_template_input::Builder,
    }
    impl<C, M, R> TestRenderTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestRenderTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRenderTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRenderTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestRenderTemplateInputOperationOutputAlias,
                crate::output::TestRenderTemplateOutput,
                crate::error::TestRenderTemplateError,
                crate::input::TestRenderTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template that you want to render.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the template that you want to render.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn template_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_data(inp);
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountSendingEnabled`.
    ///
    /// <p>Enables or disables email sending across your entire Amazon SES account in the current
    /// AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to
    /// temporarily pause email sending across your Amazon SES account in a given AWS Region when
    /// reputation metrics (such as your bounce or complaint rates) reach certain
    /// thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountSendingEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_sending_enabled_input::Builder,
    }
    impl<C, M, R> UpdateAccountSendingEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountSendingEnabledOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountSendingEnabledError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountSendingEnabledInputOperationOutputAlias,
                crate::output::UpdateAccountSendingEnabledOutput,
                crate::error::UpdateAccountSendingEnabledError,
                crate::input::UpdateAccountSendingEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetEventDestination`.
    ///
    /// <p>Updates the event destination of a configuration set. Event destinations are
    /// associated with configuration sets, which enable you to publish email sending events to
    /// Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets,
    /// see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Monitoring Your Amazon SES
    /// Sending Activity</a> in the <i>Amazon SES Developer Guide.</i>
    /// </p>
    /// <note>
    /// <p>When you create or update an event destination, you must provide one, and only
    /// one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service
    /// (Amazon SNS).</p>
    /// </note>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationSetEventDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_set_event_destination_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationSetEventDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationSetEventDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetEventDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetEventDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationSetEventDestinationInputOperationOutputAlias,
                crate::output::UpdateConfigurationSetEventDestinationOutput,
                crate::error::UpdateConfigurationSetEventDestinationError,
                crate::input::UpdateConfigurationSetEventDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that contains the event destination that you want to
        /// update.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that contains the event destination that you want to
        /// update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration
        /// set.</p>
        pub fn event_destination(mut self, inp: crate::model::EventDestination) -> Self {
            self.inner = self.inner.event_destination(inp);
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration
        /// set.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.inner = self.inner.set_event_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetReputationMetricsEnabled`.
    ///
    /// <p>Enables or disables the publishing of reputation metrics for emails sent using a
    /// specific configuration set in a given AWS Region. Reputation metrics include bounce
    /// and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can
    /// create alarms when bounce or complaint rates exceed certain thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationSetReputationMetricsEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationSetReputationMetricsEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationSetReputationMetricsEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput, aws_smithy_http::result::SdkError<crate::error::UpdateConfigurationSetReputationMetricsEnabledError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::UpdateConfigurationSetReputationMetricsEnabledInputOperationOutputAlias,
                                    crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput,
                                    crate::error::UpdateConfigurationSetReputationMetricsEnabledError,
                                    crate::input::UpdateConfigurationSetReputationMetricsEnabledInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
        /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
        /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetSendingEnabled`.
    ///
    /// <p>Enables or disables email sending for messages sent using a specific configuration set
    /// in a given AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms
    /// to temporarily pause email sending for a configuration set when the reputation metrics
    /// for that configuration set (such as your bounce on complaint rate) exceed certain
    /// thresholds.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationSetSendingEnabled<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_set_sending_enabled_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationSetSendingEnabled<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationSetSendingEnabled`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetSendingEnabledOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetSendingEnabledError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationSetSendingEnabledInputOperationOutputAlias,
                crate::output::UpdateConfigurationSetSendingEnabledOutput,
                crate::error::UpdateConfigurationSetSendingEnabledError,
                crate::input::UpdateConfigurationSetSendingEnabledInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set.
        /// </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set.
        /// </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfigurationSetTrackingOptions`.
    ///
    /// <p>Modifies an association between a configuration set and a custom domain for open and
    /// click event tracking. </p>
    /// <p>By default, images and links used for tracking open and click events are hosted on
    /// domains operated by Amazon SES. You can configure a subdomain of your own to handle these
    /// events. For information about using custom domains, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Amazon SES Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfigurationSetTrackingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_configuration_set_tracking_options_input::Builder,
    }
    impl<C, M, R> UpdateConfigurationSetTrackingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfigurationSetTrackingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigurationSetTrackingOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateConfigurationSetTrackingOptionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigurationSetTrackingOptionsInputOperationOutputAlias,
                crate::output::UpdateConfigurationSetTrackingOptionsOutput,
                crate::error::UpdateConfigurationSetTrackingOptionsError,
                crate::input::UpdateConfigurationSetTrackingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration set for which you want to update the custom tracking
        /// domain.</p>
        pub fn configuration_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration_set_name(inp);
            self
        }
        /// <p>The name of the configuration set for which you want to update the custom tracking
        /// domain.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration_set_name(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn tracking_options(mut self, inp: crate::model::TrackingOptions) -> Self {
            self.inner = self.inner.tracking_options(inp);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.inner = self.inner.set_tracking_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomVerificationEmailTemplate`.
    ///
    /// <p>Updates an existing custom verification email template.</p>
    /// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCustomVerificationEmailTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_custom_verification_email_template_input::Builder,
    }
    impl<C, M, R> UpdateCustomVerificationEmailTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCustomVerificationEmailTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomVerificationEmailTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomVerificationEmailTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCustomVerificationEmailTemplateInputOperationOutputAlias,
                crate::output::UpdateCustomVerificationEmailTemplateOutput,
                crate::error::UpdateCustomVerificationEmailTemplateError,
                crate::input::UpdateCustomVerificationEmailTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(inp);
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.from_email_address(inp);
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_from_email_address(input);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_subject(inp);
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_subject(input);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_content(inp);
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_content(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.success_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_success_redirection_url(input);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.failure_redirection_url(inp);
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_failure_redirection_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReceiptRule`.
    ///
    /// <p>Updates a receipt rule.</p>
    /// <p>For information about managing receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html">Amazon SES
    /// Developer Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReceiptRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_receipt_rule_input::Builder,
    }
    impl<C, M, R> UpdateReceiptRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReceiptRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReceiptRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReceiptRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReceiptRuleInputOperationOutputAlias,
                crate::output::UpdateReceiptRuleOutput,
                crate::error::UpdateReceiptRuleError,
                crate::input::UpdateReceiptRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_set_name(inp);
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_set_name(input);
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn rule(mut self, inp: crate::model::ReceiptRule) -> Self {
            self.inner = self.inner.rule(inp);
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTemplate`.
    ///
    /// <p>Updates an email template. Email templates enable you to send personalized email to
    /// one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_template_input::Builder,
    }
    impl<C, M, R> UpdateTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTemplateInputOperationOutputAlias,
                crate::output::UpdateTemplateOutput,
                crate::error::UpdateTemplateError,
                crate::input::UpdateTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn template(mut self, inp: crate::model::Template) -> Self {
            self.inner = self.inner.template(inp);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyDomainDkim`.
    ///
    /// <p>Returns a set of DKIM tokens for a domain identity.</p>
    /// <important>
    /// <p>When you execute the <code>VerifyDomainDkim</code> operation, the domain that you
    /// specify is added to the list of identities that are associated with your account.
    /// This is true even if you haven't already associated the domain with your account by
    /// using the <code>VerifyDomainIdentity</code> operation. However, you can't send email
    /// from the domain until you either successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">verify it</a> or you
    /// successfully <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">set up DKIM for
    /// it</a>.</p>
    /// </important>
    /// <p>You use the tokens that are generated by this operation to create CNAME records. When
    /// Amazon SES detects that you've added these records to the DNS configuration for a domain, you
    /// can start sending email from that domain. You can start sending email even if you
    /// haven't added the TXT record provided by the VerifyDomainIdentity operation to the DNS
    /// configuration for your domain. All email that you send from the domain is authenticated
    /// using DKIM.</p>
    /// <p>To create the CNAME records for DKIM authentication, use the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Name</b>:
    /// <i>token</i>._domainkey.<i>example.com</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Type</b>: CNAME</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Value</b>:
    /// <i>token</i>.dkim.amazonses.com</p>
    /// </li>
    /// </ul>
    /// <p>In the preceding example, replace <i>token</i> with one of the tokens
    /// that are generated when you execute this operation. Replace
    /// <i>example.com</i> with your domain. Repeat this process for each
    /// token that's generated by this operation.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct VerifyDomainDkim<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_domain_dkim_input::Builder,
    }
    impl<C, M, R> VerifyDomainDkim<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyDomainDkim`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyDomainDkimOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyDomainDkimError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyDomainDkimInputOperationOutputAlias,
                crate::output::VerifyDomainDkimOutput,
                crate::error::VerifyDomainDkimError,
                crate::input::VerifyDomainDkimInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyDomainIdentity`.
    ///
    /// <p>Adds a domain to the list of identities for your Amazon SES account in the current AWS
    /// Region and attempts to verify it. For more information about verifying domains, see
    /// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Verifying Email
    /// Addresses and Domains</a> in the <i>Amazon SES Developer
    /// Guide.</i>
    /// </p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct VerifyDomainIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_domain_identity_input::Builder,
    }
    impl<C, M, R> VerifyDomainIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyDomainIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyDomainIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyDomainIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyDomainIdentityInputOperationOutputAlias,
                crate::output::VerifyDomainIdentityOutput,
                crate::error::VerifyDomainIdentityError,
                crate::input::VerifyDomainIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain to be verified.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The domain to be verified.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyEmailAddress`.
    ///
    /// <p>Deprecated. Use the <code>VerifyEmailIdentity</code> operation to verify a new email
    /// address.</p>
    #[derive(std::fmt::Debug)]
    pub struct VerifyEmailAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_email_address_input::Builder,
    }
    impl<C, M, R> VerifyEmailAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyEmailAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyEmailAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyEmailAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyEmailAddressInputOperationOutputAlias,
                crate::output::VerifyEmailAddressOutput,
                crate::error::VerifyEmailAddressError,
                crate::input::VerifyEmailAddressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VerifyEmailIdentity`.
    ///
    /// <p>Adds an email address to the list of identities for your Amazon SES account in the current
    /// AWS region and attempts to verify it. As a result of executing this operation, a
    /// verification email is sent to the specified address.</p>
    /// <p>You can execute this operation no more than once per second.</p>
    #[derive(std::fmt::Debug)]
    pub struct VerifyEmailIdentity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::verify_email_identity_input::Builder,
    }
    impl<C, M, R> VerifyEmailIdentity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VerifyEmailIdentity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VerifyEmailIdentityOutput,
            aws_smithy_http::result::SdkError<crate::error::VerifyEmailIdentityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VerifyEmailIdentityInputOperationOutputAlias,
                crate::output::VerifyEmailIdentityOutput,
                crate::error::VerifyEmailIdentityError,
                crate::input::VerifyEmailIdentityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
