// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyEmailIdentityOutput {}
impl std::fmt::Debug for VerifyEmailIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyEmailIdentityOutput");
        formatter.finish()
    }
}
/// See [`VerifyEmailIdentityOutput`](crate::output::VerifyEmailIdentityOutput)
pub mod verify_email_identity_output {
    /// A builder for [`VerifyEmailIdentityOutput`](crate::output::VerifyEmailIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`VerifyEmailIdentityOutput`](crate::output::VerifyEmailIdentityOutput)
        pub fn build(self) -> crate::output::VerifyEmailIdentityOutput {
            crate::output::VerifyEmailIdentityOutput {}
        }
    }
}
impl VerifyEmailIdentityOutput {
    /// Creates a new builder-style object to manufacture [`VerifyEmailIdentityOutput`](crate::output::VerifyEmailIdentityOutput)
    pub fn builder() -> crate::output::verify_email_identity_output::Builder {
        crate::output::verify_email_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyEmailAddressOutput {}
impl std::fmt::Debug for VerifyEmailAddressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyEmailAddressOutput");
        formatter.finish()
    }
}
/// See [`VerifyEmailAddressOutput`](crate::output::VerifyEmailAddressOutput)
pub mod verify_email_address_output {
    /// A builder for [`VerifyEmailAddressOutput`](crate::output::VerifyEmailAddressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`VerifyEmailAddressOutput`](crate::output::VerifyEmailAddressOutput)
        pub fn build(self) -> crate::output::VerifyEmailAddressOutput {
            crate::output::VerifyEmailAddressOutput {}
        }
    }
}
impl VerifyEmailAddressOutput {
    /// Creates a new builder-style object to manufacture [`VerifyEmailAddressOutput`](crate::output::VerifyEmailAddressOutput)
    pub fn builder() -> crate::output::verify_email_address_output::Builder {
        crate::output::verify_email_address_output::Builder::default()
    }
}

/// <p>Returns a TXT record that you must publish to the DNS server of your domain to
/// complete domain verification with Amazon SES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyDomainIdentityOutput {
    /// <p>A TXT record that you must place in the DNS settings of the domain to complete domain
    /// verification with Amazon SES.</p>
    /// <p>As Amazon SES searches for the TXT record, the domain's verification status is "Pending".
    /// When Amazon SES detects the record, the domain's verification status changes to "Success". If
    /// Amazon SES is unable to detect the record within 72 hours, the domain's verification status
    /// changes to "Failed." In that case, if you still want to verify the domain, you must
    /// restart the verification process from the beginning.</p>
    pub verification_token: std::option::Option<std::string::String>,
}
impl VerifyDomainIdentityOutput {
    /// <p>A TXT record that you must place in the DNS settings of the domain to complete domain
    /// verification with Amazon SES.</p>
    /// <p>As Amazon SES searches for the TXT record, the domain's verification status is "Pending".
    /// When Amazon SES detects the record, the domain's verification status changes to "Success". If
    /// Amazon SES is unable to detect the record within 72 hours, the domain's verification status
    /// changes to "Failed." In that case, if you still want to verify the domain, you must
    /// restart the verification process from the beginning.</p>
    pub fn verification_token(&self) -> std::option::Option<&str> {
        self.verification_token.as_deref()
    }
}
impl std::fmt::Debug for VerifyDomainIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyDomainIdentityOutput");
        formatter.field("verification_token", &self.verification_token);
        formatter.finish()
    }
}
/// See [`VerifyDomainIdentityOutput`](crate::output::VerifyDomainIdentityOutput)
pub mod verify_domain_identity_output {
    /// A builder for [`VerifyDomainIdentityOutput`](crate::output::VerifyDomainIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) verification_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A TXT record that you must place in the DNS settings of the domain to complete domain
        /// verification with Amazon SES.</p>
        /// <p>As Amazon SES searches for the TXT record, the domain's verification status is "Pending".
        /// When Amazon SES detects the record, the domain's verification status changes to "Success". If
        /// Amazon SES is unable to detect the record within 72 hours, the domain's verification status
        /// changes to "Failed." In that case, if you still want to verify the domain, you must
        /// restart the verification process from the beginning.</p>
        pub fn verification_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.verification_token = Some(input.into());
            self
        }
        /// <p>A TXT record that you must place in the DNS settings of the domain to complete domain
        /// verification with Amazon SES.</p>
        /// <p>As Amazon SES searches for the TXT record, the domain's verification status is "Pending".
        /// When Amazon SES detects the record, the domain's verification status changes to "Success". If
        /// Amazon SES is unable to detect the record within 72 hours, the domain's verification status
        /// changes to "Failed." In that case, if you still want to verify the domain, you must
        /// restart the verification process from the beginning.</p>
        pub fn set_verification_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verification_token = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyDomainIdentityOutput`](crate::output::VerifyDomainIdentityOutput)
        pub fn build(self) -> crate::output::VerifyDomainIdentityOutput {
            crate::output::VerifyDomainIdentityOutput {
                verification_token: self.verification_token,
            }
        }
    }
}
impl VerifyDomainIdentityOutput {
    /// Creates a new builder-style object to manufacture [`VerifyDomainIdentityOutput`](crate::output::VerifyDomainIdentityOutput)
    pub fn builder() -> crate::output::verify_domain_identity_output::Builder {
        crate::output::verify_domain_identity_output::Builder::default()
    }
}

/// <p>Returns CNAME records that you must publish to the DNS server of your domain to set up
/// Easy DKIM with Amazon SES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyDomainDkimOutput {
    /// <p>A set of character strings that represent the domain's identity. If the identity is an
    /// email address, the tokens represent the domain of that address.</p>
    /// <p>Using these tokens, you need to create DNS CNAME records that point to DKIM public
    /// keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS
    /// records. This detection process might take up to 72 hours. After successful detection,
    /// Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to
    /// domain identities, not email address identities.)</p>
    /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub dkim_tokens: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VerifyDomainDkimOutput {
    /// <p>A set of character strings that represent the domain's identity. If the identity is an
    /// email address, the tokens represent the domain of that address.</p>
    /// <p>Using these tokens, you need to create DNS CNAME records that point to DKIM public
    /// keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS
    /// records. This detection process might take up to 72 hours. After successful detection,
    /// Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to
    /// domain identities, not email address identities.)</p>
    /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn dkim_tokens(&self) -> std::option::Option<&[std::string::String]> {
        self.dkim_tokens.as_deref()
    }
}
impl std::fmt::Debug for VerifyDomainDkimOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyDomainDkimOutput");
        formatter.field("dkim_tokens", &self.dkim_tokens);
        formatter.finish()
    }
}
/// See [`VerifyDomainDkimOutput`](crate::output::VerifyDomainDkimOutput)
pub mod verify_domain_dkim_output {
    /// A builder for [`VerifyDomainDkimOutput`](crate::output::VerifyDomainDkimOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dkim_tokens: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `dkim_tokens`.
        ///
        /// To override the contents of this collection use [`set_dkim_tokens`](Self::set_dkim_tokens).
        ///
        /// <p>A set of character strings that represent the domain's identity. If the identity is an
        /// email address, the tokens represent the domain of that address.</p>
        /// <p>Using these tokens, you need to create DNS CNAME records that point to DKIM public
        /// keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS
        /// records. This detection process might take up to 72 hours. After successful detection,
        /// Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to
        /// domain identities, not email address identities.)</p>
        /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn dkim_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dkim_tokens.unwrap_or_default();
            v.push(input.into());
            self.dkim_tokens = Some(v);
            self
        }
        /// <p>A set of character strings that represent the domain's identity. If the identity is an
        /// email address, the tokens represent the domain of that address.</p>
        /// <p>Using these tokens, you need to create DNS CNAME records that point to DKIM public
        /// keys that are hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS
        /// records. This detection process might take up to 72 hours. After successful detection,
        /// Amazon SES is able to DKIM-sign email originating from that domain. (This only applies to
        /// domain identities, not email address identities.)</p>
        /// <p>For more information about creating DNS records using DKIM tokens, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_dkim_tokens(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dkim_tokens = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyDomainDkimOutput`](crate::output::VerifyDomainDkimOutput)
        pub fn build(self) -> crate::output::VerifyDomainDkimOutput {
            crate::output::VerifyDomainDkimOutput {
                dkim_tokens: self.dkim_tokens,
            }
        }
    }
}
impl VerifyDomainDkimOutput {
    /// Creates a new builder-style object to manufacture [`VerifyDomainDkimOutput`](crate::output::VerifyDomainDkimOutput)
    pub fn builder() -> crate::output::verify_domain_dkim_output::Builder {
        crate::output::verify_domain_dkim_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplateOutput {}
impl std::fmt::Debug for UpdateTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTemplateOutput");
        formatter.finish()
    }
}
/// See [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
pub mod update_template_output {
    /// A builder for [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
        pub fn build(self) -> crate::output::UpdateTemplateOutput {
            crate::output::UpdateTemplateOutput {}
        }
    }
}
impl UpdateTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTemplateOutput`](crate::output::UpdateTemplateOutput)
    pub fn builder() -> crate::output::update_template_output::Builder {
        crate::output::update_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReceiptRuleOutput {}
impl std::fmt::Debug for UpdateReceiptRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReceiptRuleOutput");
        formatter.finish()
    }
}
/// See [`UpdateReceiptRuleOutput`](crate::output::UpdateReceiptRuleOutput)
pub mod update_receipt_rule_output {
    /// A builder for [`UpdateReceiptRuleOutput`](crate::output::UpdateReceiptRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateReceiptRuleOutput`](crate::output::UpdateReceiptRuleOutput)
        pub fn build(self) -> crate::output::UpdateReceiptRuleOutput {
            crate::output::UpdateReceiptRuleOutput {}
        }
    }
}
impl UpdateReceiptRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReceiptRuleOutput`](crate::output::UpdateReceiptRuleOutput)
    pub fn builder() -> crate::output::update_receipt_rule_output::Builder {
        crate::output::update_receipt_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomVerificationEmailTemplateOutput {}
impl std::fmt::Debug for UpdateCustomVerificationEmailTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomVerificationEmailTemplateOutput");
        formatter.finish()
    }
}
/// See [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)
pub mod update_custom_verification_email_template_output {
    /// A builder for [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)
        pub fn build(self) -> crate::output::UpdateCustomVerificationEmailTemplateOutput {
            crate::output::UpdateCustomVerificationEmailTemplateOutput {}
        }
    }
}
impl UpdateCustomVerificationEmailTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCustomVerificationEmailTemplateOutput`](crate::output::UpdateCustomVerificationEmailTemplateOutput)
    pub fn builder() -> crate::output::update_custom_verification_email_template_output::Builder {
        crate::output::update_custom_verification_email_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetTrackingOptionsOutput {}
impl std::fmt::Debug for UpdateConfigurationSetTrackingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetTrackingOptionsOutput");
        formatter.finish()
    }
}
/// See [`UpdateConfigurationSetTrackingOptionsOutput`](crate::output::UpdateConfigurationSetTrackingOptionsOutput)
pub mod update_configuration_set_tracking_options_output {
    /// A builder for [`UpdateConfigurationSetTrackingOptionsOutput`](crate::output::UpdateConfigurationSetTrackingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConfigurationSetTrackingOptionsOutput`](crate::output::UpdateConfigurationSetTrackingOptionsOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationSetTrackingOptionsOutput {
            crate::output::UpdateConfigurationSetTrackingOptionsOutput {}
        }
    }
}
impl UpdateConfigurationSetTrackingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetTrackingOptionsOutput`](crate::output::UpdateConfigurationSetTrackingOptionsOutput)
    pub fn builder() -> crate::output::update_configuration_set_tracking_options_output::Builder {
        crate::output::update_configuration_set_tracking_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetSendingEnabledOutput {}
impl std::fmt::Debug for UpdateConfigurationSetSendingEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetSendingEnabledOutput");
        formatter.finish()
    }
}
/// See [`UpdateConfigurationSetSendingEnabledOutput`](crate::output::UpdateConfigurationSetSendingEnabledOutput)
pub mod update_configuration_set_sending_enabled_output {
    /// A builder for [`UpdateConfigurationSetSendingEnabledOutput`](crate::output::UpdateConfigurationSetSendingEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConfigurationSetSendingEnabledOutput`](crate::output::UpdateConfigurationSetSendingEnabledOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationSetSendingEnabledOutput {
            crate::output::UpdateConfigurationSetSendingEnabledOutput {}
        }
    }
}
impl UpdateConfigurationSetSendingEnabledOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetSendingEnabledOutput`](crate::output::UpdateConfigurationSetSendingEnabledOutput)
    pub fn builder() -> crate::output::update_configuration_set_sending_enabled_output::Builder {
        crate::output::update_configuration_set_sending_enabled_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetReputationMetricsEnabledOutput {}
impl std::fmt::Debug for UpdateConfigurationSetReputationMetricsEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetReputationMetricsEnabledOutput");
        formatter.finish()
    }
}
/// See [`UpdateConfigurationSetReputationMetricsEnabledOutput`](crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput)
pub mod update_configuration_set_reputation_metrics_enabled_output {
    /// A builder for [`UpdateConfigurationSetReputationMetricsEnabledOutput`](crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConfigurationSetReputationMetricsEnabledOutput`](crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput {
            crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput {}
        }
    }
}
impl UpdateConfigurationSetReputationMetricsEnabledOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetReputationMetricsEnabledOutput`](crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput)
    pub fn builder(
    ) -> crate::output::update_configuration_set_reputation_metrics_enabled_output::Builder {
        crate::output::update_configuration_set_reputation_metrics_enabled_output::Builder::default(
        )
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetEventDestinationOutput {}
impl std::fmt::Debug for UpdateConfigurationSetEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetEventDestinationOutput");
        formatter.finish()
    }
}
/// See [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)
pub mod update_configuration_set_event_destination_output {
    /// A builder for [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)
        pub fn build(self) -> crate::output::UpdateConfigurationSetEventDestinationOutput {
            crate::output::UpdateConfigurationSetEventDestinationOutput {}
        }
    }
}
impl UpdateConfigurationSetEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationOutput`](crate::output::UpdateConfigurationSetEventDestinationOutput)
    pub fn builder() -> crate::output::update_configuration_set_event_destination_output::Builder {
        crate::output::update_configuration_set_event_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountSendingEnabledOutput {}
impl std::fmt::Debug for UpdateAccountSendingEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountSendingEnabledOutput");
        formatter.finish()
    }
}
/// See [`UpdateAccountSendingEnabledOutput`](crate::output::UpdateAccountSendingEnabledOutput)
pub mod update_account_sending_enabled_output {
    /// A builder for [`UpdateAccountSendingEnabledOutput`](crate::output::UpdateAccountSendingEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAccountSendingEnabledOutput`](crate::output::UpdateAccountSendingEnabledOutput)
        pub fn build(self) -> crate::output::UpdateAccountSendingEnabledOutput {
            crate::output::UpdateAccountSendingEnabledOutput {}
        }
    }
}
impl UpdateAccountSendingEnabledOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountSendingEnabledOutput`](crate::output::UpdateAccountSendingEnabledOutput)
    pub fn builder() -> crate::output::update_account_sending_enabled_output::Builder {
        crate::output::update_account_sending_enabled_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRenderTemplateOutput {
    /// <p>The complete MIME message rendered by applying the data in the TemplateData parameter
    /// to the template specified in the TemplateName parameter.</p>
    pub rendered_template: std::option::Option<std::string::String>,
}
impl TestRenderTemplateOutput {
    /// <p>The complete MIME message rendered by applying the data in the TemplateData parameter
    /// to the template specified in the TemplateName parameter.</p>
    pub fn rendered_template(&self) -> std::option::Option<&str> {
        self.rendered_template.as_deref()
    }
}
impl std::fmt::Debug for TestRenderTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRenderTemplateOutput");
        formatter.field("rendered_template", &self.rendered_template);
        formatter.finish()
    }
}
/// See [`TestRenderTemplateOutput`](crate::output::TestRenderTemplateOutput)
pub mod test_render_template_output {
    /// A builder for [`TestRenderTemplateOutput`](crate::output::TestRenderTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rendered_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The complete MIME message rendered by applying the data in the TemplateData parameter
        /// to the template specified in the TemplateName parameter.</p>
        pub fn rendered_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.rendered_template = Some(input.into());
            self
        }
        /// <p>The complete MIME message rendered by applying the data in the TemplateData parameter
        /// to the template specified in the TemplateName parameter.</p>
        pub fn set_rendered_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rendered_template = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRenderTemplateOutput`](crate::output::TestRenderTemplateOutput)
        pub fn build(self) -> crate::output::TestRenderTemplateOutput {
            crate::output::TestRenderTemplateOutput {
                rendered_template: self.rendered_template,
            }
        }
    }
}
impl TestRenderTemplateOutput {
    /// Creates a new builder-style object to manufacture [`TestRenderTemplateOutput`](crate::output::TestRenderTemplateOutput)
    pub fn builder() -> crate::output::test_render_template_output::Builder {
        crate::output::test_render_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetReceiptRulePositionOutput {}
impl std::fmt::Debug for SetReceiptRulePositionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetReceiptRulePositionOutput");
        formatter.finish()
    }
}
/// See [`SetReceiptRulePositionOutput`](crate::output::SetReceiptRulePositionOutput)
pub mod set_receipt_rule_position_output {
    /// A builder for [`SetReceiptRulePositionOutput`](crate::output::SetReceiptRulePositionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetReceiptRulePositionOutput`](crate::output::SetReceiptRulePositionOutput)
        pub fn build(self) -> crate::output::SetReceiptRulePositionOutput {
            crate::output::SetReceiptRulePositionOutput {}
        }
    }
}
impl SetReceiptRulePositionOutput {
    /// Creates a new builder-style object to manufacture [`SetReceiptRulePositionOutput`](crate::output::SetReceiptRulePositionOutput)
    pub fn builder() -> crate::output::set_receipt_rule_position_output::Builder {
        crate::output::set_receipt_rule_position_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityNotificationTopicOutput {}
impl std::fmt::Debug for SetIdentityNotificationTopicOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityNotificationTopicOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityNotificationTopicOutput`](crate::output::SetIdentityNotificationTopicOutput)
pub mod set_identity_notification_topic_output {
    /// A builder for [`SetIdentityNotificationTopicOutput`](crate::output::SetIdentityNotificationTopicOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityNotificationTopicOutput`](crate::output::SetIdentityNotificationTopicOutput)
        pub fn build(self) -> crate::output::SetIdentityNotificationTopicOutput {
            crate::output::SetIdentityNotificationTopicOutput {}
        }
    }
}
impl SetIdentityNotificationTopicOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityNotificationTopicOutput`](crate::output::SetIdentityNotificationTopicOutput)
    pub fn builder() -> crate::output::set_identity_notification_topic_output::Builder {
        crate::output::set_identity_notification_topic_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityMailFromDomainOutput {}
impl std::fmt::Debug for SetIdentityMailFromDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityMailFromDomainOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityMailFromDomainOutput`](crate::output::SetIdentityMailFromDomainOutput)
pub mod set_identity_mail_from_domain_output {
    /// A builder for [`SetIdentityMailFromDomainOutput`](crate::output::SetIdentityMailFromDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityMailFromDomainOutput`](crate::output::SetIdentityMailFromDomainOutput)
        pub fn build(self) -> crate::output::SetIdentityMailFromDomainOutput {
            crate::output::SetIdentityMailFromDomainOutput {}
        }
    }
}
impl SetIdentityMailFromDomainOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityMailFromDomainOutput`](crate::output::SetIdentityMailFromDomainOutput)
    pub fn builder() -> crate::output::set_identity_mail_from_domain_output::Builder {
        crate::output::set_identity_mail_from_domain_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityHeadersInNotificationsEnabledOutput {}
impl std::fmt::Debug for SetIdentityHeadersInNotificationsEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityHeadersInNotificationsEnabledOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityHeadersInNotificationsEnabledOutput`](crate::output::SetIdentityHeadersInNotificationsEnabledOutput)
pub mod set_identity_headers_in_notifications_enabled_output {
    /// A builder for [`SetIdentityHeadersInNotificationsEnabledOutput`](crate::output::SetIdentityHeadersInNotificationsEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityHeadersInNotificationsEnabledOutput`](crate::output::SetIdentityHeadersInNotificationsEnabledOutput)
        pub fn build(self) -> crate::output::SetIdentityHeadersInNotificationsEnabledOutput {
            crate::output::SetIdentityHeadersInNotificationsEnabledOutput {}
        }
    }
}
impl SetIdentityHeadersInNotificationsEnabledOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityHeadersInNotificationsEnabledOutput`](crate::output::SetIdentityHeadersInNotificationsEnabledOutput)
    pub fn builder() -> crate::output::set_identity_headers_in_notifications_enabled_output::Builder
    {
        crate::output::set_identity_headers_in_notifications_enabled_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityFeedbackForwardingEnabledOutput {}
impl std::fmt::Debug for SetIdentityFeedbackForwardingEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityFeedbackForwardingEnabledOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityFeedbackForwardingEnabledOutput`](crate::output::SetIdentityFeedbackForwardingEnabledOutput)
pub mod set_identity_feedback_forwarding_enabled_output {
    /// A builder for [`SetIdentityFeedbackForwardingEnabledOutput`](crate::output::SetIdentityFeedbackForwardingEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityFeedbackForwardingEnabledOutput`](crate::output::SetIdentityFeedbackForwardingEnabledOutput)
        pub fn build(self) -> crate::output::SetIdentityFeedbackForwardingEnabledOutput {
            crate::output::SetIdentityFeedbackForwardingEnabledOutput {}
        }
    }
}
impl SetIdentityFeedbackForwardingEnabledOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityFeedbackForwardingEnabledOutput`](crate::output::SetIdentityFeedbackForwardingEnabledOutput)
    pub fn builder() -> crate::output::set_identity_feedback_forwarding_enabled_output::Builder {
        crate::output::set_identity_feedback_forwarding_enabled_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityDkimEnabledOutput {}
impl std::fmt::Debug for SetIdentityDkimEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityDkimEnabledOutput");
        formatter.finish()
    }
}
/// See [`SetIdentityDkimEnabledOutput`](crate::output::SetIdentityDkimEnabledOutput)
pub mod set_identity_dkim_enabled_output {
    /// A builder for [`SetIdentityDkimEnabledOutput`](crate::output::SetIdentityDkimEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetIdentityDkimEnabledOutput`](crate::output::SetIdentityDkimEnabledOutput)
        pub fn build(self) -> crate::output::SetIdentityDkimEnabledOutput {
            crate::output::SetIdentityDkimEnabledOutput {}
        }
    }
}
impl SetIdentityDkimEnabledOutput {
    /// Creates a new builder-style object to manufacture [`SetIdentityDkimEnabledOutput`](crate::output::SetIdentityDkimEnabledOutput)
    pub fn builder() -> crate::output::set_identity_dkim_enabled_output::Builder {
        crate::output::set_identity_dkim_enabled_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetActiveReceiptRuleSetOutput {}
impl std::fmt::Debug for SetActiveReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetActiveReceiptRuleSetOutput");
        formatter.finish()
    }
}
/// See [`SetActiveReceiptRuleSetOutput`](crate::output::SetActiveReceiptRuleSetOutput)
pub mod set_active_receipt_rule_set_output {
    /// A builder for [`SetActiveReceiptRuleSetOutput`](crate::output::SetActiveReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetActiveReceiptRuleSetOutput`](crate::output::SetActiveReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::SetActiveReceiptRuleSetOutput {
            crate::output::SetActiveReceiptRuleSetOutput {}
        }
    }
}
impl SetActiveReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`SetActiveReceiptRuleSetOutput`](crate::output::SetActiveReceiptRuleSetOutput)
    pub fn builder() -> crate::output::set_active_receipt_rule_set_output::Builder {
        crate::output::set_active_receipt_rule_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTemplatedEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendTemplatedEmail</code>
    /// action. </p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendTemplatedEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendTemplatedEmail</code>
    /// action. </p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendTemplatedEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTemplatedEmailOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendTemplatedEmailOutput`](crate::output::SendTemplatedEmailOutput)
pub mod send_templated_email_output {
    /// A builder for [`SendTemplatedEmailOutput`](crate::output::SendTemplatedEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique message identifier returned from the <code>SendTemplatedEmail</code>
        /// action. </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the <code>SendTemplatedEmail</code>
        /// action. </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTemplatedEmailOutput`](crate::output::SendTemplatedEmailOutput)
        pub fn build(self) -> crate::output::SendTemplatedEmailOutput {
            crate::output::SendTemplatedEmailOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendTemplatedEmailOutput {
    /// Creates a new builder-style object to manufacture [`SendTemplatedEmailOutput`](crate::output::SendTemplatedEmailOutput)
    pub fn builder() -> crate::output::send_templated_email_output::Builder {
        crate::output::send_templated_email_output::Builder::default()
    }
}

/// <p>Represents a unique message ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendRawEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendRawEmail</code> action.
    /// </p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendRawEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendRawEmail</code> action.
    /// </p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendRawEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendRawEmailOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendRawEmailOutput`](crate::output::SendRawEmailOutput)
pub mod send_raw_email_output {
    /// A builder for [`SendRawEmailOutput`](crate::output::SendRawEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique message identifier returned from the <code>SendRawEmail</code> action.
        /// </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the <code>SendRawEmail</code> action.
        /// </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendRawEmailOutput`](crate::output::SendRawEmailOutput)
        pub fn build(self) -> crate::output::SendRawEmailOutput {
            crate::output::SendRawEmailOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendRawEmailOutput {
    /// Creates a new builder-style object to manufacture [`SendRawEmailOutput`](crate::output::SendRawEmailOutput)
    pub fn builder() -> crate::output::send_raw_email_output::Builder {
        crate::output::send_raw_email_output::Builder::default()
    }
}

/// <p>Represents a unique message ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendEmail</code> action. </p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendEmail</code> action. </p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEmailOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendEmailOutput`](crate::output::SendEmailOutput)
pub mod send_email_output {
    /// A builder for [`SendEmailOutput`](crate::output::SendEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique message identifier returned from the <code>SendEmail</code> action. </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the <code>SendEmail</code> action. </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEmailOutput`](crate::output::SendEmailOutput)
        pub fn build(self) -> crate::output::SendEmailOutput {
            crate::output::SendEmailOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendEmailOutput {
    /// Creates a new builder-style object to manufacture [`SendEmailOutput`](crate::output::SendEmailOutput)
    pub fn builder() -> crate::output::send_email_output::Builder {
        crate::output::send_email_output::Builder::default()
    }
}

/// <p>The response received when attempting to send the custom verification email.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendCustomVerificationEmailOutput {
    /// <p>The unique message identifier returned from the
    /// <code>SendCustomVerificationEmail</code> operation.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendCustomVerificationEmailOutput {
    /// <p>The unique message identifier returned from the
    /// <code>SendCustomVerificationEmail</code> operation.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendCustomVerificationEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendCustomVerificationEmailOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput)
pub mod send_custom_verification_email_output {
    /// A builder for [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique message identifier returned from the
        /// <code>SendCustomVerificationEmail</code> operation.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The unique message identifier returned from the
        /// <code>SendCustomVerificationEmail</code> operation.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput)
        pub fn build(self) -> crate::output::SendCustomVerificationEmailOutput {
            crate::output::SendCustomVerificationEmailOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendCustomVerificationEmailOutput {
    /// Creates a new builder-style object to manufacture [`SendCustomVerificationEmailOutput`](crate::output::SendCustomVerificationEmailOutput)
    pub fn builder() -> crate::output::send_custom_verification_email_output::Builder {
        crate::output::send_custom_verification_email_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBulkTemplatedEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// action.</p>
    pub status: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestinationStatus>>,
}
impl SendBulkTemplatedEmailOutput {
    /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
    /// action.</p>
    pub fn status(&self) -> std::option::Option<&[crate::model::BulkEmailDestinationStatus]> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for SendBulkTemplatedEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBulkTemplatedEmailOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SendBulkTemplatedEmailOutput`](crate::output::SendBulkTemplatedEmailOutput)
pub mod send_bulk_templated_email_output {
    /// A builder for [`SendBulkTemplatedEmailOutput`](crate::output::SendBulkTemplatedEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status:
            std::option::Option<std::vec::Vec<crate::model::BulkEmailDestinationStatus>>,
    }
    impl Builder {
        /// Appends an item to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// action.</p>
        pub fn status(
            mut self,
            input: impl Into<crate::model::BulkEmailDestinationStatus>,
        ) -> Self {
            let mut v = self.status.unwrap_or_default();
            v.push(input.into());
            self.status = Some(v);
            self
        }
        /// <p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code>
        /// action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestinationStatus>>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBulkTemplatedEmailOutput`](crate::output::SendBulkTemplatedEmailOutput)
        pub fn build(self) -> crate::output::SendBulkTemplatedEmailOutput {
            crate::output::SendBulkTemplatedEmailOutput {
                status: self.status,
            }
        }
    }
}
impl SendBulkTemplatedEmailOutput {
    /// Creates a new builder-style object to manufacture [`SendBulkTemplatedEmailOutput`](crate::output::SendBulkTemplatedEmailOutput)
    pub fn builder() -> crate::output::send_bulk_templated_email_output::Builder {
        crate::output::send_bulk_templated_email_output::Builder::default()
    }
}

/// <p>Represents a unique message ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBounceOutput {
    /// <p>The message ID of the bounce message.</p>
    pub message_id: std::option::Option<std::string::String>,
}
impl SendBounceOutput {
    /// <p>The message ID of the bounce message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
}
impl std::fmt::Debug for SendBounceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBounceOutput");
        formatter.field("message_id", &self.message_id);
        formatter.finish()
    }
}
/// See [`SendBounceOutput`](crate::output::SendBounceOutput)
pub mod send_bounce_output {
    /// A builder for [`SendBounceOutput`](crate::output::SendBounceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message ID of the bounce message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The message ID of the bounce message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBounceOutput`](crate::output::SendBounceOutput)
        pub fn build(self) -> crate::output::SendBounceOutput {
            crate::output::SendBounceOutput {
                message_id: self.message_id,
            }
        }
    }
}
impl SendBounceOutput {
    /// Creates a new builder-style object to manufacture [`SendBounceOutput`](crate::output::SendBounceOutput)
    pub fn builder() -> crate::output::send_bounce_output::Builder {
        crate::output::send_bounce_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReorderReceiptRuleSetOutput {}
impl std::fmt::Debug for ReorderReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReorderReceiptRuleSetOutput");
        formatter.finish()
    }
}
/// See [`ReorderReceiptRuleSetOutput`](crate::output::ReorderReceiptRuleSetOutput)
pub mod reorder_receipt_rule_set_output {
    /// A builder for [`ReorderReceiptRuleSetOutput`](crate::output::ReorderReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ReorderReceiptRuleSetOutput`](crate::output::ReorderReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::ReorderReceiptRuleSetOutput {
            crate::output::ReorderReceiptRuleSetOutput {}
        }
    }
}
impl ReorderReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`ReorderReceiptRuleSetOutput`](crate::output::ReorderReceiptRuleSetOutput)
    pub fn builder() -> crate::output::reorder_receipt_rule_set_output::Builder {
        crate::output::reorder_receipt_rule_set_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIdentityPolicyOutput {}
impl std::fmt::Debug for PutIdentityPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIdentityPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutIdentityPolicyOutput`](crate::output::PutIdentityPolicyOutput)
pub mod put_identity_policy_output {
    /// A builder for [`PutIdentityPolicyOutput`](crate::output::PutIdentityPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutIdentityPolicyOutput`](crate::output::PutIdentityPolicyOutput)
        pub fn build(self) -> crate::output::PutIdentityPolicyOutput {
            crate::output::PutIdentityPolicyOutput {}
        }
    }
}
impl PutIdentityPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutIdentityPolicyOutput`](crate::output::PutIdentityPolicyOutput)
    pub fn builder() -> crate::output::put_identity_policy_output::Builder {
        crate::output::put_identity_policy_output::Builder::default()
    }
}

/// <p>An HTTP 200 response if the request succeeds, or an error message if the request
/// fails.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetDeliveryOptionsOutput {}
impl std::fmt::Debug for PutConfigurationSetDeliveryOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetDeliveryOptionsOutput");
        formatter.finish()
    }
}
/// See [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)
pub mod put_configuration_set_delivery_options_output {
    /// A builder for [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)
        pub fn build(self) -> crate::output::PutConfigurationSetDeliveryOptionsOutput {
            crate::output::PutConfigurationSetDeliveryOptionsOutput {}
        }
    }
}
impl PutConfigurationSetDeliveryOptionsOutput {
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetDeliveryOptionsOutput`](crate::output::PutConfigurationSetDeliveryOptionsOutput)
    pub fn builder() -> crate::output::put_configuration_set_delivery_options_output::Builder {
        crate::output::put_configuration_set_delivery_options_output::Builder::default()
    }
}

/// <p>A list of email addresses that you have verified with Amazon SES under your AWS
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVerifiedEmailAddressesOutput {
    /// <p>A list of email addresses that have been verified.</p>
    pub verified_email_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListVerifiedEmailAddressesOutput {
    /// <p>A list of email addresses that have been verified.</p>
    pub fn verified_email_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.verified_email_addresses.as_deref()
    }
}
impl std::fmt::Debug for ListVerifiedEmailAddressesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVerifiedEmailAddressesOutput");
        formatter.field("verified_email_addresses", &self.verified_email_addresses);
        formatter.finish()
    }
}
/// See [`ListVerifiedEmailAddressesOutput`](crate::output::ListVerifiedEmailAddressesOutput)
pub mod list_verified_email_addresses_output {
    /// A builder for [`ListVerifiedEmailAddressesOutput`](crate::output::ListVerifiedEmailAddressesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) verified_email_addresses:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `verified_email_addresses`.
        ///
        /// To override the contents of this collection use [`set_verified_email_addresses`](Self::set_verified_email_addresses).
        ///
        /// <p>A list of email addresses that have been verified.</p>
        pub fn verified_email_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.verified_email_addresses.unwrap_or_default();
            v.push(input.into());
            self.verified_email_addresses = Some(v);
            self
        }
        /// <p>A list of email addresses that have been verified.</p>
        pub fn set_verified_email_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.verified_email_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVerifiedEmailAddressesOutput`](crate::output::ListVerifiedEmailAddressesOutput)
        pub fn build(self) -> crate::output::ListVerifiedEmailAddressesOutput {
            crate::output::ListVerifiedEmailAddressesOutput {
                verified_email_addresses: self.verified_email_addresses,
            }
        }
    }
}
impl ListVerifiedEmailAddressesOutput {
    /// Creates a new builder-style object to manufacture [`ListVerifiedEmailAddressesOutput`](crate::output::ListVerifiedEmailAddressesOutput)
    pub fn builder() -> crate::output::list_verified_email_addresses_output::Builder {
        crate::output::list_verified_email_addresses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTemplatesOutput {
    /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
    /// account.</p>
    pub templates_metadata: std::option::Option<std::vec::Vec<crate::model::TemplateMetadata>>,
    /// <p>A token indicating that there are additional email templates available to be listed.
    /// Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next
    /// 50 email templates.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTemplatesOutput {
    /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
    /// account.</p>
    pub fn templates_metadata(&self) -> std::option::Option<&[crate::model::TemplateMetadata]> {
        self.templates_metadata.as_deref()
    }
    /// <p>A token indicating that there are additional email templates available to be listed.
    /// Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next
    /// 50 email templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTemplatesOutput");
        formatter.field("templates_metadata", &self.templates_metadata);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
pub mod list_templates_output {
    /// A builder for [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) templates_metadata:
            std::option::Option<std::vec::Vec<crate::model::TemplateMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `templates_metadata`.
        ///
        /// To override the contents of this collection use [`set_templates_metadata`](Self::set_templates_metadata).
        ///
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn templates_metadata(
            mut self,
            input: impl Into<crate::model::TemplateMetadata>,
        ) -> Self {
            let mut v = self.templates_metadata.unwrap_or_default();
            v.push(input.into());
            self.templates_metadata = Some(v);
            self
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn set_templates_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateMetadata>>,
        ) -> Self {
            self.templates_metadata = input;
            self
        }
        /// <p>A token indicating that there are additional email templates available to be listed.
        /// Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next
        /// 50 email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token indicating that there are additional email templates available to be listed.
        /// Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next
        /// 50 email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
        pub fn build(self) -> crate::output::ListTemplatesOutput {
            crate::output::ListTemplatesOutput {
                templates_metadata: self.templates_metadata,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListTemplatesOutput`](crate::output::ListTemplatesOutput)
    pub fn builder() -> crate::output::list_templates_output::Builder {
        crate::output::list_templates_output::Builder::default()
    }
}

/// <p>A list of receipt rule sets that exist under your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceiptRuleSetsOutput {
    /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
    /// rule set name and the timestamp of when the rule set was created.</p>
    pub rule_sets: std::option::Option<std::vec::Vec<crate::model::ReceiptRuleSetMetadata>>,
    /// <p>A token indicating that there are additional receipt rule sets available to be listed.
    /// Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up
    /// to 100 receipt rule sets at a time.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReceiptRuleSetsOutput {
    /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
    /// rule set name and the timestamp of when the rule set was created.</p>
    pub fn rule_sets(&self) -> std::option::Option<&[crate::model::ReceiptRuleSetMetadata]> {
        self.rule_sets.as_deref()
    }
    /// <p>A token indicating that there are additional receipt rule sets available to be listed.
    /// Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up
    /// to 100 receipt rule sets at a time.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReceiptRuleSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceiptRuleSetsOutput");
        formatter.field("rule_sets", &self.rule_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListReceiptRuleSetsOutput`](crate::output::ListReceiptRuleSetsOutput)
pub mod list_receipt_rule_sets_output {
    /// A builder for [`ListReceiptRuleSetsOutput`](crate::output::ListReceiptRuleSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_sets:
            std::option::Option<std::vec::Vec<crate::model::ReceiptRuleSetMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rule_sets`.
        ///
        /// To override the contents of this collection use [`set_rule_sets`](Self::set_rule_sets).
        ///
        /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
        /// rule set name and the timestamp of when the rule set was created.</p>
        pub fn rule_sets(mut self, input: impl Into<crate::model::ReceiptRuleSetMetadata>) -> Self {
            let mut v = self.rule_sets.unwrap_or_default();
            v.push(input.into());
            self.rule_sets = Some(v);
            self
        }
        /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
        /// rule set name and the timestamp of when the rule set was created.</p>
        pub fn set_rule_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReceiptRuleSetMetadata>>,
        ) -> Self {
            self.rule_sets = input;
            self
        }
        /// <p>A token indicating that there are additional receipt rule sets available to be listed.
        /// Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up
        /// to 100 receipt rule sets at a time.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token indicating that there are additional receipt rule sets available to be listed.
        /// Pass this token to successive calls of <code>ListReceiptRuleSets</code> to retrieve up
        /// to 100 receipt rule sets at a time.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReceiptRuleSetsOutput`](crate::output::ListReceiptRuleSetsOutput)
        pub fn build(self) -> crate::output::ListReceiptRuleSetsOutput {
            crate::output::ListReceiptRuleSetsOutput {
                rule_sets: self.rule_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListReceiptRuleSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListReceiptRuleSetsOutput`](crate::output::ListReceiptRuleSetsOutput)
    pub fn builder() -> crate::output::list_receipt_rule_sets_output::Builder {
        crate::output::list_receipt_rule_sets_output::Builder::default()
    }
}

/// <p>A list of IP address filters that exist under your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceiptFiltersOutput {
    /// <p>A list of IP address filter data structures, which each consist of a name, an IP
    /// address range, and whether to allow or block mail from it.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ReceiptFilter>>,
}
impl ListReceiptFiltersOutput {
    /// <p>A list of IP address filter data structures, which each consist of a name, an IP
    /// address range, and whether to allow or block mail from it.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ReceiptFilter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListReceiptFiltersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceiptFiltersOutput");
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}
/// See [`ListReceiptFiltersOutput`](crate::output::ListReceiptFiltersOutput)
pub mod list_receipt_filters_output {
    /// A builder for [`ListReceiptFiltersOutput`](crate::output::ListReceiptFiltersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ReceiptFilter>>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of IP address filter data structures, which each consist of a name, an IP
        /// address range, and whether to allow or block mail from it.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ReceiptFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A list of IP address filter data structures, which each consist of a name, an IP
        /// address range, and whether to allow or block mail from it.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReceiptFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReceiptFiltersOutput`](crate::output::ListReceiptFiltersOutput)
        pub fn build(self) -> crate::output::ListReceiptFiltersOutput {
            crate::output::ListReceiptFiltersOutput {
                filters: self.filters,
            }
        }
    }
}
impl ListReceiptFiltersOutput {
    /// Creates a new builder-style object to manufacture [`ListReceiptFiltersOutput`](crate::output::ListReceiptFiltersOutput)
    pub fn builder() -> crate::output::list_receipt_filters_output::Builder {
        crate::output::list_receipt_filters_output::Builder::default()
    }
}

/// <p>A list of names of sending authorization policies that apply to an identity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoliciesOutput {
    /// <p>A list of names of policies that apply to the specified identity.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListIdentityPoliciesOutput {
    /// <p>A list of names of policies that apply to the specified identity.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoliciesOutput");
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}
/// See [`ListIdentityPoliciesOutput`](crate::output::ListIdentityPoliciesOutput)
pub mod list_identity_policies_output {
    /// A builder for [`ListIdentityPoliciesOutput`](crate::output::ListIdentityPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of names of policies that apply to the specified identity.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of names of policies that apply to the specified identity.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoliciesOutput`](crate::output::ListIdentityPoliciesOutput)
        pub fn build(self) -> crate::output::ListIdentityPoliciesOutput {
            crate::output::ListIdentityPoliciesOutput {
                policy_names: self.policy_names,
            }
        }
    }
}
impl ListIdentityPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentityPoliciesOutput`](crate::output::ListIdentityPoliciesOutput)
    pub fn builder() -> crate::output::list_identity_policies_output::Builder {
        crate::output::list_identity_policies_output::Builder::default()
    }
}

/// <p>A list of all identities that you have attempted to verify under your AWS account,
/// regardless of verification status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentitiesOutput {
    /// <p>A list of identities.</p>
    pub identities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token used for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIdentitiesOutput {
    /// <p>A list of identities.</p>
    pub fn identities(&self) -> std::option::Option<&[std::string::String]> {
        self.identities.as_deref()
    }
    /// <p>The token used for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIdentitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentitiesOutput");
        formatter.field("identities", &self.identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
pub mod list_identities_output {
    /// A builder for [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of identities.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>A list of identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// <p>The token used for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
        pub fn build(self) -> crate::output::ListIdentitiesOutput {
            crate::output::ListIdentitiesOutput {
                identities: self.identities,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIdentitiesOutput {
    /// Creates a new builder-style object to manufacture [`ListIdentitiesOutput`](crate::output::ListIdentitiesOutput)
    pub fn builder() -> crate::output::list_identities_output::Builder {
        crate::output::list_identities_output::Builder::default()
    }
}

/// <p>A paginated list of custom verification email templates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomVerificationEmailTemplatesOutput {
    /// <p>A list of the custom verification email templates that exist in your account.</p>
    pub custom_verification_email_templates:
        std::option::Option<std::vec::Vec<crate::model::CustomVerificationEmailTemplate>>,
    /// <p>A token indicating that there are additional custom verification email templates
    /// available to be listed. Pass this token to a subsequent call to
    /// <code>ListTemplates</code> to retrieve the next 50 custom verification email
    /// templates.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomVerificationEmailTemplatesOutput {
    /// <p>A list of the custom verification email templates that exist in your account.</p>
    pub fn custom_verification_email_templates(
        &self,
    ) -> std::option::Option<&[crate::model::CustomVerificationEmailTemplate]> {
        self.custom_verification_email_templates.as_deref()
    }
    /// <p>A token indicating that there are additional custom verification email templates
    /// available to be listed. Pass this token to a subsequent call to
    /// <code>ListTemplates</code> to retrieve the next 50 custom verification email
    /// templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomVerificationEmailTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomVerificationEmailTemplatesOutput");
        formatter.field(
            "custom_verification_email_templates",
            &self.custom_verification_email_templates,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput)
pub mod list_custom_verification_email_templates_output {
    /// A builder for [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_verification_email_templates:
            std::option::Option<std::vec::Vec<crate::model::CustomVerificationEmailTemplate>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `custom_verification_email_templates`.
        ///
        /// To override the contents of this collection use [`set_custom_verification_email_templates`](Self::set_custom_verification_email_templates).
        ///
        /// <p>A list of the custom verification email templates that exist in your account.</p>
        pub fn custom_verification_email_templates(
            mut self,
            input: impl Into<crate::model::CustomVerificationEmailTemplate>,
        ) -> Self {
            let mut v = self.custom_verification_email_templates.unwrap_or_default();
            v.push(input.into());
            self.custom_verification_email_templates = Some(v);
            self
        }
        /// <p>A list of the custom verification email templates that exist in your account.</p>
        pub fn set_custom_verification_email_templates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomVerificationEmailTemplate>,
            >,
        ) -> Self {
            self.custom_verification_email_templates = input;
            self
        }
        /// <p>A token indicating that there are additional custom verification email templates
        /// available to be listed. Pass this token to a subsequent call to
        /// <code>ListTemplates</code> to retrieve the next 50 custom verification email
        /// templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token indicating that there are additional custom verification email templates
        /// available to be listed. Pass this token to a subsequent call to
        /// <code>ListTemplates</code> to retrieve the next 50 custom verification email
        /// templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput)
        pub fn build(self) -> crate::output::ListCustomVerificationEmailTemplatesOutput {
            crate::output::ListCustomVerificationEmailTemplatesOutput {
                custom_verification_email_templates: self.custom_verification_email_templates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCustomVerificationEmailTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListCustomVerificationEmailTemplatesOutput`](crate::output::ListCustomVerificationEmailTemplatesOutput)
    pub fn builder() -> crate::output::list_custom_verification_email_templates_output::Builder {
        crate::output::list_custom_verification_email_templates_output::Builder::default()
    }
}

/// <p>A list of configuration sets associated with your AWS account. Configuration sets
/// enable you to publish email sending events. For information about using configuration
/// sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationSetsOutput {
    /// <p>A list of configuration sets.</p>
    pub configuration_sets: std::option::Option<std::vec::Vec<crate::model::ConfigurationSet>>,
    /// <p>A token indicating that there are additional configuration sets available to be
    /// listed. Pass this token to successive calls of <code>ListConfigurationSets</code>.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListConfigurationSetsOutput {
    /// <p>A list of configuration sets.</p>
    pub fn configuration_sets(&self) -> std::option::Option<&[crate::model::ConfigurationSet]> {
        self.configuration_sets.as_deref()
    }
    /// <p>A token indicating that there are additional configuration sets available to be
    /// listed. Pass this token to successive calls of <code>ListConfigurationSets</code>.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListConfigurationSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationSetsOutput");
        formatter.field("configuration_sets", &self.configuration_sets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput)
pub mod list_configuration_sets_output {
    /// A builder for [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_sets:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationSet>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `configuration_sets`.
        ///
        /// To override the contents of this collection use [`set_configuration_sets`](Self::set_configuration_sets).
        ///
        /// <p>A list of configuration sets.</p>
        pub fn configuration_sets(
            mut self,
            input: impl Into<crate::model::ConfigurationSet>,
        ) -> Self {
            let mut v = self.configuration_sets.unwrap_or_default();
            v.push(input.into());
            self.configuration_sets = Some(v);
            self
        }
        /// <p>A list of configuration sets.</p>
        pub fn set_configuration_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSet>>,
        ) -> Self {
            self.configuration_sets = input;
            self
        }
        /// <p>A token indicating that there are additional configuration sets available to be
        /// listed. Pass this token to successive calls of <code>ListConfigurationSets</code>.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token indicating that there are additional configuration sets available to be
        /// listed. Pass this token to successive calls of <code>ListConfigurationSets</code>.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput)
        pub fn build(self) -> crate::output::ListConfigurationSetsOutput {
            crate::output::ListConfigurationSetsOutput {
                configuration_sets: self.configuration_sets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConfigurationSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsOutput`](crate::output::ListConfigurationSetsOutput)
    pub fn builder() -> crate::output::list_configuration_sets_output::Builder {
        crate::output::list_configuration_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTemplateOutput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub template: std::option::Option<crate::model::Template>,
}
impl GetTemplateOutput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
}
impl std::fmt::Debug for GetTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTemplateOutput");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}
/// See [`GetTemplateOutput`](crate::output::GetTemplateOutput)
pub mod get_template_output {
    /// A builder for [`GetTemplateOutput`](crate::output::GetTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemplateOutput`](crate::output::GetTemplateOutput)
        pub fn build(self) -> crate::output::GetTemplateOutput {
            crate::output::GetTemplateOutput {
                template: self.template,
            }
        }
    }
}
impl GetTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetTemplateOutput`](crate::output::GetTemplateOutput)
    pub fn builder() -> crate::output::get_template_output::Builder {
        crate::output::get_template_output::Builder::default()
    }
}

/// <p>Represents a list of data points. This list contains aggregated data from the previous
/// two weeks of your sending activity with Amazon SES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSendStatisticsOutput {
    /// <p>A list of data points, each of which represents 15 minutes of activity.</p>
    pub send_data_points: std::option::Option<std::vec::Vec<crate::model::SendDataPoint>>,
}
impl GetSendStatisticsOutput {
    /// <p>A list of data points, each of which represents 15 minutes of activity.</p>
    pub fn send_data_points(&self) -> std::option::Option<&[crate::model::SendDataPoint]> {
        self.send_data_points.as_deref()
    }
}
impl std::fmt::Debug for GetSendStatisticsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSendStatisticsOutput");
        formatter.field("send_data_points", &self.send_data_points);
        formatter.finish()
    }
}
/// See [`GetSendStatisticsOutput`](crate::output::GetSendStatisticsOutput)
pub mod get_send_statistics_output {
    /// A builder for [`GetSendStatisticsOutput`](crate::output::GetSendStatisticsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) send_data_points:
            std::option::Option<std::vec::Vec<crate::model::SendDataPoint>>,
    }
    impl Builder {
        /// Appends an item to `send_data_points`.
        ///
        /// To override the contents of this collection use [`set_send_data_points`](Self::set_send_data_points).
        ///
        /// <p>A list of data points, each of which represents 15 minutes of activity.</p>
        pub fn send_data_points(mut self, input: impl Into<crate::model::SendDataPoint>) -> Self {
            let mut v = self.send_data_points.unwrap_or_default();
            v.push(input.into());
            self.send_data_points = Some(v);
            self
        }
        /// <p>A list of data points, each of which represents 15 minutes of activity.</p>
        pub fn set_send_data_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SendDataPoint>>,
        ) -> Self {
            self.send_data_points = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSendStatisticsOutput`](crate::output::GetSendStatisticsOutput)
        pub fn build(self) -> crate::output::GetSendStatisticsOutput {
            crate::output::GetSendStatisticsOutput {
                send_data_points: self.send_data_points,
            }
        }
    }
}
impl GetSendStatisticsOutput {
    /// Creates a new builder-style object to manufacture [`GetSendStatisticsOutput`](crate::output::GetSendStatisticsOutput)
    pub fn builder() -> crate::output::get_send_statistics_output::Builder {
        crate::output::get_send_statistics_output::Builder::default()
    }
}

/// <p>Represents your Amazon SES daily sending quota, maximum send rate, and the number of emails
/// you have sent in the last 24 hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSendQuotaOutput {
    /// <p>The maximum number of emails the user is allowed to send in a 24-hour interval. A
    /// value of -1 signifies an unlimited quota.</p>
    pub max24_hour_send: f64,
    /// <p>The maximum number of emails that Amazon SES can accept from the user's account per
    /// second.</p>
    /// <note>
    /// <p>The rate at which Amazon SES accepts the user's messages might be less than the maximum
    /// send rate.</p>
    /// </note>
    pub max_send_rate: f64,
    /// <p>The number of emails sent during the previous 24 hours.</p>
    pub sent_last24_hours: f64,
}
impl GetSendQuotaOutput {
    /// <p>The maximum number of emails the user is allowed to send in a 24-hour interval. A
    /// value of -1 signifies an unlimited quota.</p>
    pub fn max24_hour_send(&self) -> f64 {
        self.max24_hour_send
    }
    /// <p>The maximum number of emails that Amazon SES can accept from the user's account per
    /// second.</p>
    /// <note>
    /// <p>The rate at which Amazon SES accepts the user's messages might be less than the maximum
    /// send rate.</p>
    /// </note>
    pub fn max_send_rate(&self) -> f64 {
        self.max_send_rate
    }
    /// <p>The number of emails sent during the previous 24 hours.</p>
    pub fn sent_last24_hours(&self) -> f64 {
        self.sent_last24_hours
    }
}
impl std::fmt::Debug for GetSendQuotaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSendQuotaOutput");
        formatter.field("max24_hour_send", &self.max24_hour_send);
        formatter.field("max_send_rate", &self.max_send_rate);
        formatter.field("sent_last24_hours", &self.sent_last24_hours);
        formatter.finish()
    }
}
/// See [`GetSendQuotaOutput`](crate::output::GetSendQuotaOutput)
pub mod get_send_quota_output {
    /// A builder for [`GetSendQuotaOutput`](crate::output::GetSendQuotaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max24_hour_send: std::option::Option<f64>,
        pub(crate) max_send_rate: std::option::Option<f64>,
        pub(crate) sent_last24_hours: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum number of emails the user is allowed to send in a 24-hour interval. A
        /// value of -1 signifies an unlimited quota.</p>
        pub fn max24_hour_send(mut self, input: f64) -> Self {
            self.max24_hour_send = Some(input);
            self
        }
        /// <p>The maximum number of emails the user is allowed to send in a 24-hour interval. A
        /// value of -1 signifies an unlimited quota.</p>
        pub fn set_max24_hour_send(mut self, input: std::option::Option<f64>) -> Self {
            self.max24_hour_send = input;
            self
        }
        /// <p>The maximum number of emails that Amazon SES can accept from the user's account per
        /// second.</p>
        /// <note>
        /// <p>The rate at which Amazon SES accepts the user's messages might be less than the maximum
        /// send rate.</p>
        /// </note>
        pub fn max_send_rate(mut self, input: f64) -> Self {
            self.max_send_rate = Some(input);
            self
        }
        /// <p>The maximum number of emails that Amazon SES can accept from the user's account per
        /// second.</p>
        /// <note>
        /// <p>The rate at which Amazon SES accepts the user's messages might be less than the maximum
        /// send rate.</p>
        /// </note>
        pub fn set_max_send_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.max_send_rate = input;
            self
        }
        /// <p>The number of emails sent during the previous 24 hours.</p>
        pub fn sent_last24_hours(mut self, input: f64) -> Self {
            self.sent_last24_hours = Some(input);
            self
        }
        /// <p>The number of emails sent during the previous 24 hours.</p>
        pub fn set_sent_last24_hours(mut self, input: std::option::Option<f64>) -> Self {
            self.sent_last24_hours = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSendQuotaOutput`](crate::output::GetSendQuotaOutput)
        pub fn build(self) -> crate::output::GetSendQuotaOutput {
            crate::output::GetSendQuotaOutput {
                max24_hour_send: self.max24_hour_send.unwrap_or_default(),
                max_send_rate: self.max_send_rate.unwrap_or_default(),
                sent_last24_hours: self.sent_last24_hours.unwrap_or_default(),
            }
        }
    }
}
impl GetSendQuotaOutput {
    /// Creates a new builder-style object to manufacture [`GetSendQuotaOutput`](crate::output::GetSendQuotaOutput)
    pub fn builder() -> crate::output::get_send_quota_output::Builder {
        crate::output::get_send_quota_output::Builder::default()
    }
}

/// <p>The Amazon SES verification status of a list of identities. For domain identities, this
/// response also contains the verification token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityVerificationAttributesOutput {
    /// <p>A map of Identities to IdentityVerificationAttributes objects.</p>
    pub verification_attributes: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::IdentityVerificationAttributes,
        >,
    >,
}
impl GetIdentityVerificationAttributesOutput {
    /// <p>A map of Identities to IdentityVerificationAttributes objects.</p>
    pub fn verification_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::IdentityVerificationAttributes,
        >,
    > {
        self.verification_attributes.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityVerificationAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityVerificationAttributesOutput");
        formatter.field("verification_attributes", &self.verification_attributes);
        formatter.finish()
    }
}
/// See [`GetIdentityVerificationAttributesOutput`](crate::output::GetIdentityVerificationAttributesOutput)
pub mod get_identity_verification_attributes_output {
    /// A builder for [`GetIdentityVerificationAttributesOutput`](crate::output::GetIdentityVerificationAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) verification_attributes: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::IdentityVerificationAttributes,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `verification_attributes`.
        ///
        /// To override the contents of this collection use [`set_verification_attributes`](Self::set_verification_attributes).
        ///
        /// <p>A map of Identities to IdentityVerificationAttributes objects.</p>
        pub fn verification_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IdentityVerificationAttributes>,
        ) -> Self {
            let mut hash_map = self.verification_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.verification_attributes = Some(hash_map);
            self
        }
        /// <p>A map of Identities to IdentityVerificationAttributes objects.</p>
        pub fn set_verification_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::IdentityVerificationAttributes,
                >,
            >,
        ) -> Self {
            self.verification_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityVerificationAttributesOutput`](crate::output::GetIdentityVerificationAttributesOutput)
        pub fn build(self) -> crate::output::GetIdentityVerificationAttributesOutput {
            crate::output::GetIdentityVerificationAttributesOutput {
                verification_attributes: self.verification_attributes,
            }
        }
    }
}
impl GetIdentityVerificationAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityVerificationAttributesOutput`](crate::output::GetIdentityVerificationAttributesOutput)
    pub fn builder() -> crate::output::get_identity_verification_attributes_output::Builder {
        crate::output::get_identity_verification_attributes_output::Builder::default()
    }
}

/// <p>Represents the requested sending authorization policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoliciesOutput {
    /// <p>A map of policy names to policies.</p>
    pub policies:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetIdentityPoliciesOutput {
    /// <p>A map of policy names to policies.</p>
    pub fn policies(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.policies.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`GetIdentityPoliciesOutput`](crate::output::GetIdentityPoliciesOutput)
pub mod get_identity_policies_output {
    /// A builder for [`GetIdentityPoliciesOutput`](crate::output::GetIdentityPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A map of policy names to policies.</p>
        pub fn policies(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.policies.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.policies = Some(hash_map);
            self
        }
        /// <p>A map of policy names to policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoliciesOutput`](crate::output::GetIdentityPoliciesOutput)
        pub fn build(self) -> crate::output::GetIdentityPoliciesOutput {
            crate::output::GetIdentityPoliciesOutput {
                policies: self.policies,
            }
        }
    }
}
impl GetIdentityPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityPoliciesOutput`](crate::output::GetIdentityPoliciesOutput)
    pub fn builder() -> crate::output::get_identity_policies_output::Builder {
        crate::output::get_identity_policies_output::Builder::default()
    }
}

/// <p>Represents the notification attributes for a list of identities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityNotificationAttributesOutput {
    /// <p>A map of Identity to IdentityNotificationAttributes.</p>
    pub notification_attributes: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::IdentityNotificationAttributes,
        >,
    >,
}
impl GetIdentityNotificationAttributesOutput {
    /// <p>A map of Identity to IdentityNotificationAttributes.</p>
    pub fn notification_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::IdentityNotificationAttributes,
        >,
    > {
        self.notification_attributes.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityNotificationAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityNotificationAttributesOutput");
        formatter.field("notification_attributes", &self.notification_attributes);
        formatter.finish()
    }
}
/// See [`GetIdentityNotificationAttributesOutput`](crate::output::GetIdentityNotificationAttributesOutput)
pub mod get_identity_notification_attributes_output {
    /// A builder for [`GetIdentityNotificationAttributesOutput`](crate::output::GetIdentityNotificationAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_attributes: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::IdentityNotificationAttributes,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `notification_attributes`.
        ///
        /// To override the contents of this collection use [`set_notification_attributes`](Self::set_notification_attributes).
        ///
        /// <p>A map of Identity to IdentityNotificationAttributes.</p>
        pub fn notification_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IdentityNotificationAttributes>,
        ) -> Self {
            let mut hash_map = self.notification_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.notification_attributes = Some(hash_map);
            self
        }
        /// <p>A map of Identity to IdentityNotificationAttributes.</p>
        pub fn set_notification_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::IdentityNotificationAttributes,
                >,
            >,
        ) -> Self {
            self.notification_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityNotificationAttributesOutput`](crate::output::GetIdentityNotificationAttributesOutput)
        pub fn build(self) -> crate::output::GetIdentityNotificationAttributesOutput {
            crate::output::GetIdentityNotificationAttributesOutput {
                notification_attributes: self.notification_attributes,
            }
        }
    }
}
impl GetIdentityNotificationAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityNotificationAttributesOutput`](crate::output::GetIdentityNotificationAttributesOutput)
    pub fn builder() -> crate::output::get_identity_notification_attributes_output::Builder {
        crate::output::get_identity_notification_attributes_output::Builder::default()
    }
}

/// <p>Represents the custom MAIL FROM attributes for a list of identities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityMailFromDomainAttributesOutput {
    /// <p>A map of identities to custom MAIL FROM attributes.</p>
    pub mail_from_domain_attributes: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::IdentityMailFromDomainAttributes,
        >,
    >,
}
impl GetIdentityMailFromDomainAttributesOutput {
    /// <p>A map of identities to custom MAIL FROM attributes.</p>
    pub fn mail_from_domain_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::IdentityMailFromDomainAttributes,
        >,
    > {
        self.mail_from_domain_attributes.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityMailFromDomainAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityMailFromDomainAttributesOutput");
        formatter.field(
            "mail_from_domain_attributes",
            &self.mail_from_domain_attributes,
        );
        formatter.finish()
    }
}
/// See [`GetIdentityMailFromDomainAttributesOutput`](crate::output::GetIdentityMailFromDomainAttributesOutput)
pub mod get_identity_mail_from_domain_attributes_output {
    /// A builder for [`GetIdentityMailFromDomainAttributesOutput`](crate::output::GetIdentityMailFromDomainAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mail_from_domain_attributes: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::IdentityMailFromDomainAttributes,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `mail_from_domain_attributes`.
        ///
        /// To override the contents of this collection use [`set_mail_from_domain_attributes`](Self::set_mail_from_domain_attributes).
        ///
        /// <p>A map of identities to custom MAIL FROM attributes.</p>
        pub fn mail_from_domain_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IdentityMailFromDomainAttributes>,
        ) -> Self {
            let mut hash_map = self.mail_from_domain_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.mail_from_domain_attributes = Some(hash_map);
            self
        }
        /// <p>A map of identities to custom MAIL FROM attributes.</p>
        pub fn set_mail_from_domain_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::IdentityMailFromDomainAttributes,
                >,
            >,
        ) -> Self {
            self.mail_from_domain_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityMailFromDomainAttributesOutput`](crate::output::GetIdentityMailFromDomainAttributesOutput)
        pub fn build(self) -> crate::output::GetIdentityMailFromDomainAttributesOutput {
            crate::output::GetIdentityMailFromDomainAttributesOutput {
                mail_from_domain_attributes: self.mail_from_domain_attributes,
            }
        }
    }
}
impl GetIdentityMailFromDomainAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityMailFromDomainAttributesOutput`](crate::output::GetIdentityMailFromDomainAttributesOutput)
    pub fn builder() -> crate::output::get_identity_mail_from_domain_attributes_output::Builder {
        crate::output::get_identity_mail_from_domain_attributes_output::Builder::default()
    }
}

/// <p>Represents the status of Amazon SES Easy DKIM signing for an identity. For domain
/// identities, this response also contains the DKIM tokens that are required for Easy DKIM
/// signing, and whether Amazon SES successfully verified that these tokens were
/// published.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityDkimAttributesOutput {
    /// <p>The DKIM attributes for an email address or a domain.</p>
    pub dkim_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::IdentityDkimAttributes>,
    >,
}
impl GetIdentityDkimAttributesOutput {
    /// <p>The DKIM attributes for an email address or a domain.</p>
    pub fn dkim_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::IdentityDkimAttributes>,
    > {
        self.dkim_attributes.as_ref()
    }
}
impl std::fmt::Debug for GetIdentityDkimAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityDkimAttributesOutput");
        formatter.field("dkim_attributes", &self.dkim_attributes);
        formatter.finish()
    }
}
/// See [`GetIdentityDkimAttributesOutput`](crate::output::GetIdentityDkimAttributesOutput)
pub mod get_identity_dkim_attributes_output {
    /// A builder for [`GetIdentityDkimAttributesOutput`](crate::output::GetIdentityDkimAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dkim_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::IdentityDkimAttributes>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `dkim_attributes`.
        ///
        /// To override the contents of this collection use [`set_dkim_attributes`](Self::set_dkim_attributes).
        ///
        /// <p>The DKIM attributes for an email address or a domain.</p>
        pub fn dkim_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::IdentityDkimAttributes>,
        ) -> Self {
            let mut hash_map = self.dkim_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dkim_attributes = Some(hash_map);
            self
        }
        /// <p>The DKIM attributes for an email address or a domain.</p>
        pub fn set_dkim_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::IdentityDkimAttributes,
                >,
            >,
        ) -> Self {
            self.dkim_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityDkimAttributesOutput`](crate::output::GetIdentityDkimAttributesOutput)
        pub fn build(self) -> crate::output::GetIdentityDkimAttributesOutput {
            crate::output::GetIdentityDkimAttributesOutput {
                dkim_attributes: self.dkim_attributes,
            }
        }
    }
}
impl GetIdentityDkimAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetIdentityDkimAttributesOutput`](crate::output::GetIdentityDkimAttributesOutput)
    pub fn builder() -> crate::output::get_identity_dkim_attributes_output::Builder {
        crate::output::get_identity_dkim_attributes_output::Builder::default()
    }
}

/// <p>The content of the custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomVerificationEmailTemplateOutput {
    /// <p>The name of the custom verification email template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The content of the custom verification email.</p>
    pub template_content: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl GetCustomVerificationEmailTemplateOutput {
    /// <p>The name of the custom verification email template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The content of the custom verification email.</p>
    pub fn template_content(&self) -> std::option::Option<&str> {
        self.template_content.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for GetCustomVerificationEmailTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomVerificationEmailTemplateOutput");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("template_content", &self.template_content);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}
/// See [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput)
pub mod get_custom_verification_email_template_output {
    /// A builder for [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The content of the custom verification email.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_content = Some(input.into());
            self
        }
        /// <p>The content of the custom verification email.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput)
        pub fn build(self) -> crate::output::GetCustomVerificationEmailTemplateOutput {
            crate::output::GetCustomVerificationEmailTemplateOutput {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                template_content: self.template_content,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            }
        }
    }
}
impl GetCustomVerificationEmailTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetCustomVerificationEmailTemplateOutput`](crate::output::GetCustomVerificationEmailTemplateOutput)
    pub fn builder() -> crate::output::get_custom_verification_email_template_output::Builder {
        crate::output::get_custom_verification_email_template_output::Builder::default()
    }
}

/// <p>Represents a request to return the email sending status for your Amazon SES account in the
/// current AWS Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSendingEnabledOutput {
    /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
    /// current AWS Region.</p>
    pub enabled: bool,
}
impl GetAccountSendingEnabledOutput {
    /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
    /// current AWS Region.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for GetAccountSendingEnabledOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSendingEnabledOutput");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`GetAccountSendingEnabledOutput`](crate::output::GetAccountSendingEnabledOutput)
pub mod get_account_sending_enabled_output {
    /// A builder for [`GetAccountSendingEnabledOutput`](crate::output::GetAccountSendingEnabledOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSendingEnabledOutput`](crate::output::GetAccountSendingEnabledOutput)
        pub fn build(self) -> crate::output::GetAccountSendingEnabledOutput {
            crate::output::GetAccountSendingEnabledOutput {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl GetAccountSendingEnabledOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountSendingEnabledOutput`](crate::output::GetAccountSendingEnabledOutput)
    pub fn builder() -> crate::output::get_account_sending_enabled_output::Builder {
        crate::output::get_account_sending_enabled_output::Builder::default()
    }
}

/// <p>Represents the details of the specified receipt rule set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReceiptRuleSetOutput {
    /// <p>The metadata for the receipt rule set, which consists of the rule set name and the
    /// timestamp of when the rule set was created.</p>
    pub metadata: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
    /// <p>A list of the receipt rules that belong to the specified receipt rule set.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
}
impl DescribeReceiptRuleSetOutput {
    /// <p>The metadata for the receipt rule set, which consists of the rule set name and the
    /// timestamp of when the rule set was created.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ReceiptRuleSetMetadata> {
        self.metadata.as_ref()
    }
    /// <p>A list of the receipt rules that belong to the specified receipt rule set.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ReceiptRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for DescribeReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReceiptRuleSetOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`DescribeReceiptRuleSetOutput`](crate::output::DescribeReceiptRuleSetOutput)
pub mod describe_receipt_rule_set_output {
    /// A builder for [`DescribeReceiptRuleSetOutput`](crate::output::DescribeReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
    }
    impl Builder {
        /// <p>The metadata for the receipt rule set, which consists of the rule set name and the
        /// timestamp of when the rule set was created.</p>
        pub fn metadata(mut self, input: crate::model::ReceiptRuleSetMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The metadata for the receipt rule set, which consists of the rule set name and the
        /// timestamp of when the rule set was created.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of the receipt rules that belong to the specified receipt rule set.</p>
        pub fn rules(mut self, input: impl Into<crate::model::ReceiptRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>A list of the receipt rules that belong to the specified receipt rule set.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReceiptRuleSetOutput`](crate::output::DescribeReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::DescribeReceiptRuleSetOutput {
            crate::output::DescribeReceiptRuleSetOutput {
                metadata: self.metadata,
                rules: self.rules,
            }
        }
    }
}
impl DescribeReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleSetOutput`](crate::output::DescribeReceiptRuleSetOutput)
    pub fn builder() -> crate::output::describe_receipt_rule_set_output::Builder {
        crate::output::describe_receipt_rule_set_output::Builder::default()
    }
}

/// <p>Represents the details of a receipt rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReceiptRuleOutput {
    /// <p>A data structure that contains the specified receipt rule's name, actions, recipients,
    /// domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>
    pub rule: std::option::Option<crate::model::ReceiptRule>,
}
impl DescribeReceiptRuleOutput {
    /// <p>A data structure that contains the specified receipt rule's name, actions, recipients,
    /// domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::ReceiptRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for DescribeReceiptRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReceiptRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`DescribeReceiptRuleOutput`](crate::output::DescribeReceiptRuleOutput)
pub mod describe_receipt_rule_output {
    /// A builder for [`DescribeReceiptRuleOutput`](crate::output::DescribeReceiptRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::ReceiptRule>,
    }
    impl Builder {
        /// <p>A data structure that contains the specified receipt rule's name, actions, recipients,
        /// domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>
        pub fn rule(mut self, input: crate::model::ReceiptRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>A data structure that contains the specified receipt rule's name, actions, recipients,
        /// domains, enabled status, scan status, and Transport Layer Security (TLS) policy.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReceiptRuleOutput`](crate::output::DescribeReceiptRuleOutput)
        pub fn build(self) -> crate::output::DescribeReceiptRuleOutput {
            crate::output::DescribeReceiptRuleOutput { rule: self.rule }
        }
    }
}
impl DescribeReceiptRuleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleOutput`](crate::output::DescribeReceiptRuleOutput)
    pub fn builder() -> crate::output::describe_receipt_rule_output::Builder {
        crate::output::describe_receipt_rule_output::Builder::default()
    }
}

/// <p>Represents the details of a configuration set. Configuration sets enable you to
/// publish email sending events. For information about using configuration sets, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSetOutput {
    /// <p>The configuration set object associated with the specified configuration set.</p>
    pub configuration_set: std::option::Option<crate::model::ConfigurationSet>,
    /// <p>A list of event destinations associated with the configuration set. </p>
    pub event_destinations: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
    /// <p>The name of the custom open and click tracking domain associated with the
    /// configuration set.</p>
    pub tracking_options: std::option::Option<crate::model::TrackingOptions>,
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS).</p>
    pub delivery_options: std::option::Option<crate::model::DeliveryOptions>,
    /// <p>An object that represents the reputation settings for the configuration set. </p>
    pub reputation_options: std::option::Option<crate::model::ReputationOptions>,
}
impl DescribeConfigurationSetOutput {
    /// <p>The configuration set object associated with the specified configuration set.</p>
    pub fn configuration_set(&self) -> std::option::Option<&crate::model::ConfigurationSet> {
        self.configuration_set.as_ref()
    }
    /// <p>A list of event destinations associated with the configuration set. </p>
    pub fn event_destinations(&self) -> std::option::Option<&[crate::model::EventDestination]> {
        self.event_destinations.as_deref()
    }
    /// <p>The name of the custom open and click tracking domain associated with the
    /// configuration set.</p>
    pub fn tracking_options(&self) -> std::option::Option<&crate::model::TrackingOptions> {
        self.tracking_options.as_ref()
    }
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS).</p>
    pub fn delivery_options(&self) -> std::option::Option<&crate::model::DeliveryOptions> {
        self.delivery_options.as_ref()
    }
    /// <p>An object that represents the reputation settings for the configuration set. </p>
    pub fn reputation_options(&self) -> std::option::Option<&crate::model::ReputationOptions> {
        self.reputation_options.as_ref()
    }
}
impl std::fmt::Debug for DescribeConfigurationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSetOutput");
        formatter.field("configuration_set", &self.configuration_set);
        formatter.field("event_destinations", &self.event_destinations);
        formatter.field("tracking_options", &self.tracking_options);
        formatter.field("delivery_options", &self.delivery_options);
        formatter.field("reputation_options", &self.reputation_options);
        formatter.finish()
    }
}
/// See [`DescribeConfigurationSetOutput`](crate::output::DescribeConfigurationSetOutput)
pub mod describe_configuration_set_output {
    /// A builder for [`DescribeConfigurationSetOutput`](crate::output::DescribeConfigurationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set: std::option::Option<crate::model::ConfigurationSet>,
        pub(crate) event_destinations:
            std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        pub(crate) tracking_options: std::option::Option<crate::model::TrackingOptions>,
        pub(crate) delivery_options: std::option::Option<crate::model::DeliveryOptions>,
        pub(crate) reputation_options: std::option::Option<crate::model::ReputationOptions>,
    }
    impl Builder {
        /// <p>The configuration set object associated with the specified configuration set.</p>
        pub fn configuration_set(mut self, input: crate::model::ConfigurationSet) -> Self {
            self.configuration_set = Some(input);
            self
        }
        /// <p>The configuration set object associated with the specified configuration set.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSet>,
        ) -> Self {
            self.configuration_set = input;
            self
        }
        /// Appends an item to `event_destinations`.
        ///
        /// To override the contents of this collection use [`set_event_destinations`](Self::set_event_destinations).
        ///
        /// <p>A list of event destinations associated with the configuration set. </p>
        pub fn event_destinations(
            mut self,
            input: impl Into<crate::model::EventDestination>,
        ) -> Self {
            let mut v = self.event_destinations.unwrap_or_default();
            v.push(input.into());
            self.event_destinations = Some(v);
            self
        }
        /// <p>A list of event destinations associated with the configuration set. </p>
        pub fn set_event_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventDestination>>,
        ) -> Self {
            self.event_destinations = input;
            self
        }
        /// <p>The name of the custom open and click tracking domain associated with the
        /// configuration set.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.tracking_options = Some(input);
            self
        }
        /// <p>The name of the custom open and click tracking domain associated with the
        /// configuration set.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.tracking_options = input;
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.delivery_options = Some(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.delivery_options = input;
            self
        }
        /// <p>An object that represents the reputation settings for the configuration set. </p>
        pub fn reputation_options(mut self, input: crate::model::ReputationOptions) -> Self {
            self.reputation_options = Some(input);
            self
        }
        /// <p>An object that represents the reputation settings for the configuration set. </p>
        pub fn set_reputation_options(
            mut self,
            input: std::option::Option<crate::model::ReputationOptions>,
        ) -> Self {
            self.reputation_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSetOutput`](crate::output::DescribeConfigurationSetOutput)
        pub fn build(self) -> crate::output::DescribeConfigurationSetOutput {
            crate::output::DescribeConfigurationSetOutput {
                configuration_set: self.configuration_set,
                event_destinations: self.event_destinations,
                tracking_options: self.tracking_options,
                delivery_options: self.delivery_options,
                reputation_options: self.reputation_options,
            }
        }
    }
}
impl DescribeConfigurationSetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetOutput`](crate::output::DescribeConfigurationSetOutput)
    pub fn builder() -> crate::output::describe_configuration_set_output::Builder {
        crate::output::describe_configuration_set_output::Builder::default()
    }
}

/// <p>Represents the metadata and receipt rules for the receipt rule set that is currently
/// active.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActiveReceiptRuleSetOutput {
    /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
    /// rule set name and a timestamp of when the rule set was created.</p>
    pub metadata: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
    /// <p>The receipt rules that belong to the active rule set.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
}
impl DescribeActiveReceiptRuleSetOutput {
    /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
    /// rule set name and a timestamp of when the rule set was created.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::ReceiptRuleSetMetadata> {
        self.metadata.as_ref()
    }
    /// <p>The receipt rules that belong to the active rule set.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ReceiptRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for DescribeActiveReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActiveReceiptRuleSetOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`DescribeActiveReceiptRuleSetOutput`](crate::output::DescribeActiveReceiptRuleSetOutput)
pub mod describe_active_receipt_rule_set_output {
    /// A builder for [`DescribeActiveReceiptRuleSetOutput`](crate::output::DescribeActiveReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
    }
    impl Builder {
        /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
        /// rule set name and a timestamp of when the rule set was created.</p>
        pub fn metadata(mut self, input: crate::model::ReceiptRuleSetMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The metadata for the currently active receipt rule set. The metadata consists of the
        /// rule set name and a timestamp of when the rule set was created.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ReceiptRuleSetMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The receipt rules that belong to the active rule set.</p>
        pub fn rules(mut self, input: impl Into<crate::model::ReceiptRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>The receipt rules that belong to the active rule set.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReceiptRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActiveReceiptRuleSetOutput`](crate::output::DescribeActiveReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::DescribeActiveReceiptRuleSetOutput {
            crate::output::DescribeActiveReceiptRuleSetOutput {
                metadata: self.metadata,
                rules: self.rules,
            }
        }
    }
}
impl DescribeActiveReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeActiveReceiptRuleSetOutput`](crate::output::DescribeActiveReceiptRuleSetOutput)
    pub fn builder() -> crate::output::describe_active_receipt_rule_set_output::Builder {
        crate::output::describe_active_receipt_rule_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVerifiedEmailAddressOutput {}
impl std::fmt::Debug for DeleteVerifiedEmailAddressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVerifiedEmailAddressOutput");
        formatter.finish()
    }
}
/// See [`DeleteVerifiedEmailAddressOutput`](crate::output::DeleteVerifiedEmailAddressOutput)
pub mod delete_verified_email_address_output {
    /// A builder for [`DeleteVerifiedEmailAddressOutput`](crate::output::DeleteVerifiedEmailAddressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVerifiedEmailAddressOutput`](crate::output::DeleteVerifiedEmailAddressOutput)
        pub fn build(self) -> crate::output::DeleteVerifiedEmailAddressOutput {
            crate::output::DeleteVerifiedEmailAddressOutput {}
        }
    }
}
impl DeleteVerifiedEmailAddressOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVerifiedEmailAddressOutput`](crate::output::DeleteVerifiedEmailAddressOutput)
    pub fn builder() -> crate::output::delete_verified_email_address_output::Builder {
        crate::output::delete_verified_email_address_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTemplateOutput {}
impl std::fmt::Debug for DeleteTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
pub mod delete_template_output {
    /// A builder for [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
        pub fn build(self) -> crate::output::DeleteTemplateOutput {
            crate::output::DeleteTemplateOutput {}
        }
    }
}
impl DeleteTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTemplateOutput`](crate::output::DeleteTemplateOutput)
    pub fn builder() -> crate::output::delete_template_output::Builder {
        crate::output::delete_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptRuleSetOutput {}
impl std::fmt::Debug for DeleteReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptRuleSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteReceiptRuleSetOutput`](crate::output::DeleteReceiptRuleSetOutput)
pub mod delete_receipt_rule_set_output {
    /// A builder for [`DeleteReceiptRuleSetOutput`](crate::output::DeleteReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReceiptRuleSetOutput`](crate::output::DeleteReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::DeleteReceiptRuleSetOutput {
            crate::output::DeleteReceiptRuleSetOutput {}
        }
    }
}
impl DeleteReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleSetOutput`](crate::output::DeleteReceiptRuleSetOutput)
    pub fn builder() -> crate::output::delete_receipt_rule_set_output::Builder {
        crate::output::delete_receipt_rule_set_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptRuleOutput {}
impl std::fmt::Debug for DeleteReceiptRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteReceiptRuleOutput`](crate::output::DeleteReceiptRuleOutput)
pub mod delete_receipt_rule_output {
    /// A builder for [`DeleteReceiptRuleOutput`](crate::output::DeleteReceiptRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReceiptRuleOutput`](crate::output::DeleteReceiptRuleOutput)
        pub fn build(self) -> crate::output::DeleteReceiptRuleOutput {
            crate::output::DeleteReceiptRuleOutput {}
        }
    }
}
impl DeleteReceiptRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleOutput`](crate::output::DeleteReceiptRuleOutput)
    pub fn builder() -> crate::output::delete_receipt_rule_output::Builder {
        crate::output::delete_receipt_rule_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptFilterOutput {}
impl std::fmt::Debug for DeleteReceiptFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptFilterOutput");
        formatter.finish()
    }
}
/// See [`DeleteReceiptFilterOutput`](crate::output::DeleteReceiptFilterOutput)
pub mod delete_receipt_filter_output {
    /// A builder for [`DeleteReceiptFilterOutput`](crate::output::DeleteReceiptFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReceiptFilterOutput`](crate::output::DeleteReceiptFilterOutput)
        pub fn build(self) -> crate::output::DeleteReceiptFilterOutput {
            crate::output::DeleteReceiptFilterOutput {}
        }
    }
}
impl DeleteReceiptFilterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReceiptFilterOutput`](crate::output::DeleteReceiptFilterOutput)
    pub fn builder() -> crate::output::delete_receipt_filter_output::Builder {
        crate::output::delete_receipt_filter_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityPolicyOutput {}
impl std::fmt::Debug for DeleteIdentityPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteIdentityPolicyOutput`](crate::output::DeleteIdentityPolicyOutput)
pub mod delete_identity_policy_output {
    /// A builder for [`DeleteIdentityPolicyOutput`](crate::output::DeleteIdentityPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIdentityPolicyOutput`](crate::output::DeleteIdentityPolicyOutput)
        pub fn build(self) -> crate::output::DeleteIdentityPolicyOutput {
            crate::output::DeleteIdentityPolicyOutput {}
        }
    }
}
impl DeleteIdentityPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityPolicyOutput`](crate::output::DeleteIdentityPolicyOutput)
    pub fn builder() -> crate::output::delete_identity_policy_output::Builder {
        crate::output::delete_identity_policy_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityOutput {}
impl std::fmt::Debug for DeleteIdentityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityOutput");
        formatter.finish()
    }
}
/// See [`DeleteIdentityOutput`](crate::output::DeleteIdentityOutput)
pub mod delete_identity_output {
    /// A builder for [`DeleteIdentityOutput`](crate::output::DeleteIdentityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIdentityOutput`](crate::output::DeleteIdentityOutput)
        pub fn build(self) -> crate::output::DeleteIdentityOutput {
            crate::output::DeleteIdentityOutput {}
        }
    }
}
impl DeleteIdentityOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIdentityOutput`](crate::output::DeleteIdentityOutput)
    pub fn builder() -> crate::output::delete_identity_output::Builder {
        crate::output::delete_identity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomVerificationEmailTemplateOutput {}
impl std::fmt::Debug for DeleteCustomVerificationEmailTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomVerificationEmailTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)
pub mod delete_custom_verification_email_template_output {
    /// A builder for [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)
        pub fn build(self) -> crate::output::DeleteCustomVerificationEmailTemplateOutput {
            crate::output::DeleteCustomVerificationEmailTemplateOutput {}
        }
    }
}
impl DeleteCustomVerificationEmailTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomVerificationEmailTemplateOutput`](crate::output::DeleteCustomVerificationEmailTemplateOutput)
    pub fn builder() -> crate::output::delete_custom_verification_email_template_output::Builder {
        crate::output::delete_custom_verification_email_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetTrackingOptionsOutput {}
impl std::fmt::Debug for DeleteConfigurationSetTrackingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetTrackingOptionsOutput");
        formatter.finish()
    }
}
/// See [`DeleteConfigurationSetTrackingOptionsOutput`](crate::output::DeleteConfigurationSetTrackingOptionsOutput)
pub mod delete_configuration_set_tracking_options_output {
    /// A builder for [`DeleteConfigurationSetTrackingOptionsOutput`](crate::output::DeleteConfigurationSetTrackingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConfigurationSetTrackingOptionsOutput`](crate::output::DeleteConfigurationSetTrackingOptionsOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationSetTrackingOptionsOutput {
            crate::output::DeleteConfigurationSetTrackingOptionsOutput {}
        }
    }
}
impl DeleteConfigurationSetTrackingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetTrackingOptionsOutput`](crate::output::DeleteConfigurationSetTrackingOptionsOutput)
    pub fn builder() -> crate::output::delete_configuration_set_tracking_options_output::Builder {
        crate::output::delete_configuration_set_tracking_options_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetEventDestinationOutput {}
impl std::fmt::Debug for DeleteConfigurationSetEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetEventDestinationOutput");
        formatter.finish()
    }
}
/// See [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)
pub mod delete_configuration_set_event_destination_output {
    /// A builder for [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationSetEventDestinationOutput {
            crate::output::DeleteConfigurationSetEventDestinationOutput {}
        }
    }
}
impl DeleteConfigurationSetEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationOutput`](crate::output::DeleteConfigurationSetEventDestinationOutput)
    pub fn builder() -> crate::output::delete_configuration_set_event_destination_output::Builder {
        crate::output::delete_configuration_set_event_destination_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetOutput {}
impl std::fmt::Debug for DeleteConfigurationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
pub mod delete_configuration_set_output {
    /// A builder for [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
        pub fn build(self) -> crate::output::DeleteConfigurationSetOutput {
            crate::output::DeleteConfigurationSetOutput {}
        }
    }
}
impl DeleteConfigurationSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetOutput`](crate::output::DeleteConfigurationSetOutput)
    pub fn builder() -> crate::output::delete_configuration_set_output::Builder {
        crate::output::delete_configuration_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTemplateOutput {}
impl std::fmt::Debug for CreateTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTemplateOutput");
        formatter.finish()
    }
}
/// See [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
pub mod create_template_output {
    /// A builder for [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
        pub fn build(self) -> crate::output::CreateTemplateOutput {
            crate::output::CreateTemplateOutput {}
        }
    }
}
impl CreateTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateTemplateOutput`](crate::output::CreateTemplateOutput)
    pub fn builder() -> crate::output::create_template_output::Builder {
        crate::output::create_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptRuleSetOutput {}
impl std::fmt::Debug for CreateReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptRuleSetOutput");
        formatter.finish()
    }
}
/// See [`CreateReceiptRuleSetOutput`](crate::output::CreateReceiptRuleSetOutput)
pub mod create_receipt_rule_set_output {
    /// A builder for [`CreateReceiptRuleSetOutput`](crate::output::CreateReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateReceiptRuleSetOutput`](crate::output::CreateReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::CreateReceiptRuleSetOutput {
            crate::output::CreateReceiptRuleSetOutput {}
        }
    }
}
impl CreateReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleSetOutput`](crate::output::CreateReceiptRuleSetOutput)
    pub fn builder() -> crate::output::create_receipt_rule_set_output::Builder {
        crate::output::create_receipt_rule_set_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptRuleOutput {}
impl std::fmt::Debug for CreateReceiptRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptRuleOutput");
        formatter.finish()
    }
}
/// See [`CreateReceiptRuleOutput`](crate::output::CreateReceiptRuleOutput)
pub mod create_receipt_rule_output {
    /// A builder for [`CreateReceiptRuleOutput`](crate::output::CreateReceiptRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateReceiptRuleOutput`](crate::output::CreateReceiptRuleOutput)
        pub fn build(self) -> crate::output::CreateReceiptRuleOutput {
            crate::output::CreateReceiptRuleOutput {}
        }
    }
}
impl CreateReceiptRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleOutput`](crate::output::CreateReceiptRuleOutput)
    pub fn builder() -> crate::output::create_receipt_rule_output::Builder {
        crate::output::create_receipt_rule_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptFilterOutput {}
impl std::fmt::Debug for CreateReceiptFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptFilterOutput");
        formatter.finish()
    }
}
/// See [`CreateReceiptFilterOutput`](crate::output::CreateReceiptFilterOutput)
pub mod create_receipt_filter_output {
    /// A builder for [`CreateReceiptFilterOutput`](crate::output::CreateReceiptFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateReceiptFilterOutput`](crate::output::CreateReceiptFilterOutput)
        pub fn build(self) -> crate::output::CreateReceiptFilterOutput {
            crate::output::CreateReceiptFilterOutput {}
        }
    }
}
impl CreateReceiptFilterOutput {
    /// Creates a new builder-style object to manufacture [`CreateReceiptFilterOutput`](crate::output::CreateReceiptFilterOutput)
    pub fn builder() -> crate::output::create_receipt_filter_output::Builder {
        crate::output::create_receipt_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomVerificationEmailTemplateOutput {}
impl std::fmt::Debug for CreateCustomVerificationEmailTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomVerificationEmailTemplateOutput");
        formatter.finish()
    }
}
/// See [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)
pub mod create_custom_verification_email_template_output {
    /// A builder for [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)
        pub fn build(self) -> crate::output::CreateCustomVerificationEmailTemplateOutput {
            crate::output::CreateCustomVerificationEmailTemplateOutput {}
        }
    }
}
impl CreateCustomVerificationEmailTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomVerificationEmailTemplateOutput`](crate::output::CreateCustomVerificationEmailTemplateOutput)
    pub fn builder() -> crate::output::create_custom_verification_email_template_output::Builder {
        crate::output::create_custom_verification_email_template_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetTrackingOptionsOutput {}
impl std::fmt::Debug for CreateConfigurationSetTrackingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetTrackingOptionsOutput");
        formatter.finish()
    }
}
/// See [`CreateConfigurationSetTrackingOptionsOutput`](crate::output::CreateConfigurationSetTrackingOptionsOutput)
pub mod create_configuration_set_tracking_options_output {
    /// A builder for [`CreateConfigurationSetTrackingOptionsOutput`](crate::output::CreateConfigurationSetTrackingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateConfigurationSetTrackingOptionsOutput`](crate::output::CreateConfigurationSetTrackingOptionsOutput)
        pub fn build(self) -> crate::output::CreateConfigurationSetTrackingOptionsOutput {
            crate::output::CreateConfigurationSetTrackingOptionsOutput {}
        }
    }
}
impl CreateConfigurationSetTrackingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetTrackingOptionsOutput`](crate::output::CreateConfigurationSetTrackingOptionsOutput)
    pub fn builder() -> crate::output::create_configuration_set_tracking_options_output::Builder {
        crate::output::create_configuration_set_tracking_options_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetEventDestinationOutput {}
impl std::fmt::Debug for CreateConfigurationSetEventDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetEventDestinationOutput");
        formatter.finish()
    }
}
/// See [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)
pub mod create_configuration_set_event_destination_output {
    /// A builder for [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)
        pub fn build(self) -> crate::output::CreateConfigurationSetEventDestinationOutput {
            crate::output::CreateConfigurationSetEventDestinationOutput {}
        }
    }
}
impl CreateConfigurationSetEventDestinationOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationOutput`](crate::output::CreateConfigurationSetEventDestinationOutput)
    pub fn builder() -> crate::output::create_configuration_set_event_destination_output::Builder {
        crate::output::create_configuration_set_event_destination_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetOutput {}
impl std::fmt::Debug for CreateConfigurationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetOutput");
        formatter.finish()
    }
}
/// See [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
pub mod create_configuration_set_output {
    /// A builder for [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
        pub fn build(self) -> crate::output::CreateConfigurationSetOutput {
            crate::output::CreateConfigurationSetOutput {}
        }
    }
}
impl CreateConfigurationSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetOutput`](crate::output::CreateConfigurationSetOutput)
    pub fn builder() -> crate::output::create_configuration_set_output::Builder {
        crate::output::create_configuration_set_output::Builder::default()
    }
}

/// <p>An empty element returned on a successful request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloneReceiptRuleSetOutput {}
impl std::fmt::Debug for CloneReceiptRuleSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloneReceiptRuleSetOutput");
        formatter.finish()
    }
}
/// See [`CloneReceiptRuleSetOutput`](crate::output::CloneReceiptRuleSetOutput)
pub mod clone_receipt_rule_set_output {
    /// A builder for [`CloneReceiptRuleSetOutput`](crate::output::CloneReceiptRuleSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CloneReceiptRuleSetOutput`](crate::output::CloneReceiptRuleSetOutput)
        pub fn build(self) -> crate::output::CloneReceiptRuleSetOutput {
            crate::output::CloneReceiptRuleSetOutput {}
        }
    }
}
impl CloneReceiptRuleSetOutput {
    /// Creates a new builder-style object to manufacture [`CloneReceiptRuleSetOutput`](crate::output::CloneReceiptRuleSetOutput)
    pub fn builder() -> crate::output::clone_receipt_rule_set_output::Builder {
        crate::output::clone_receipt_rule_set_output::Builder::default()
    }
}
