// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CloneReceiptRuleSetInput`](crate::input::CloneReceiptRuleSetInput)
pub mod clone_receipt_rule_set_input {
    /// A builder for [`CloneReceiptRuleSetInput`](crate::input::CloneReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) original_rule_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn original_rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the rule set to clone.</p>
        pub fn set_original_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_rule_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloneReceiptRuleSetInput`](crate::input::CloneReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CloneReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CloneReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
                original_rule_set_name: self.original_rule_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CloneReceiptRuleSetInputOperationOutputAlias = crate::operation::CloneReceiptRuleSet;
#[doc(hidden)]
pub type CloneReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CloneReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`CloneReceiptRuleSet`](crate::operation::CloneReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CloneReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CloneReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CloneReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CloneReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_clone_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CloneReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CloneReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CloneReceiptRuleSetInput`](crate::input::CloneReceiptRuleSetInput)
    pub fn builder() -> crate::input::clone_receipt_rule_set_input::Builder {
        crate::input::clone_receipt_rule_set_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
pub mod create_configuration_set_input {
    /// A builder for [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set: std::option::Option<crate::model::ConfigurationSet>,
    }
    impl Builder {
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn configuration_set(mut self, input: crate::model::ConfigurationSet) -> Self {
            self.configuration_set = Some(input);
            self
        }
        /// <p>A data structure that contains the name of the configuration set.</p>
        pub fn set_configuration_set(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSet>,
        ) -> Self {
            self.configuration_set = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetInput {
                configuration_set: self.configuration_set,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationOutputAlias = crate::operation::CreateConfigurationSet;
#[doc(hidden)]
pub type CreateConfigurationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSet`](crate::operation::CreateConfigurationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetInput`](crate::input::CreateConfigurationSetInput)
    pub fn builder() -> crate::input::create_configuration_set_input::Builder {
        crate::input::create_configuration_set_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
pub mod create_configuration_set_event_destination_input {
    /// A builder for [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestination>,
    }
    impl Builder {
        /// <p>The name of the configuration set that the event destination should be associated
        /// with.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that the event destination should be associated
        /// with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will
        /// be published to.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>An object that describes the AWS service that email sending event information will
        /// be published to.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::CreateConfigurationSetEventDestination;
#[doc(hidden)]
pub type CreateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSetEventDestination`](crate::operation::CreateConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set_event_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSetEventDestination",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetEventDestinationInput`](crate::input::CreateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::create_configuration_set_event_destination_input::Builder {
        crate::input::create_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`CreateConfigurationSetTrackingOptionsInput`](crate::input::CreateConfigurationSetTrackingOptionsInput)
pub mod create_configuration_set_tracking_options_input {
    /// A builder for [`CreateConfigurationSetTrackingOptionsInput`](crate::input::CreateConfigurationSetTrackingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tracking_options: std::option::Option<crate::model::TrackingOptions>,
    }
    impl Builder {
        /// <p>The name of the configuration set that the tracking options should be associated
        /// with.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that the tracking options should be associated
        /// with.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.tracking_options = Some(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.tracking_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigurationSetTrackingOptionsInput`](crate::input::CreateConfigurationSetTrackingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigurationSetTrackingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigurationSetTrackingOptionsInput {
                configuration_set_name: self.configuration_set_name,
                tracking_options: self.tracking_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigurationSetTrackingOptionsInputOperationOutputAlias =
    crate::operation::CreateConfigurationSetTrackingOptions;
#[doc(hidden)]
pub type CreateConfigurationSetTrackingOptionsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateConfigurationSetTrackingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfigurationSetTrackingOptions`](crate::operation::CreateConfigurationSetTrackingOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfigurationSetTrackingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigurationSetTrackingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigurationSetTrackingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigurationSetTrackingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_configuration_set_tracking_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfigurationSetTrackingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfigurationSetTrackingOptions",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigurationSetTrackingOptionsInput`](crate::input::CreateConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::create_configuration_set_tracking_options_input::Builder {
        crate::input::create_configuration_set_tracking_options_input::Builder::default()
    }
}

/// See [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
pub mod create_custom_verification_email_template_input {
    /// A builder for [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_content = Some(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                template_content: self.template_content,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::CreateCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type CreateCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomVerificationEmailTemplate`](crate::operation::CreateCustomVerificationEmailTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomVerificationEmailTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomVerificationEmailTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomVerificationEmailTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomVerificationEmailTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_verification_email_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomVerificationEmailTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomVerificationEmailTemplateInput`](crate::input::CreateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::create_custom_verification_email_template_input::Builder {
        crate::input::create_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`CreateReceiptFilterInput`](crate::input::CreateReceiptFilterInput)
pub mod create_receipt_filter_input {
    /// A builder for [`CreateReceiptFilterInput`](crate::input::CreateReceiptFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::ReceiptFilter>,
    }
    impl Builder {
        /// <p>A data structure that describes the IP address filter to create, which consists of a
        /// name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn filter(mut self, input: crate::model::ReceiptFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>A data structure that describes the IP address filter to create, which consists of a
        /// name, an IP address range, and whether to allow or block mail from it.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReceiptFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReceiptFilterInput`](crate::input::CreateReceiptFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReceiptFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReceiptFilterInput {
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReceiptFilterInputOperationOutputAlias = crate::operation::CreateReceiptFilter;
#[doc(hidden)]
pub type CreateReceiptFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReceiptFilterInput {
    /// Consumes the builder and constructs an Operation<[`CreateReceiptFilter`](crate::operation::CreateReceiptFilter)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReceiptFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReceiptFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReceiptFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReceiptFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_receipt_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReceiptFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReceiptFilter",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReceiptFilterInput`](crate::input::CreateReceiptFilterInput)
    pub fn builder() -> crate::input::create_receipt_filter_input::Builder {
        crate::input::create_receipt_filter_input::Builder::default()
    }
}

/// See [`CreateReceiptRuleInput`](crate::input::CreateReceiptRuleInput)
pub mod create_receipt_rule_input {
    /// A builder for [`CreateReceiptRuleInput`](crate::input::CreateReceiptRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) after: std::option::Option<std::string::String>,
        pub(crate) rule: std::option::Option<crate::model::ReceiptRule>,
    }
    impl Builder {
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the rule set that the receipt rule will be added to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this
        /// parameter is null, the new rule will be inserted at the beginning of the rule
        /// list.</p>
        pub fn after(mut self, input: impl Into<std::string::String>) -> Self {
            self.after = Some(input.into());
            self
        }
        /// <p>The name of an existing rule after which the new rule will be placed. If this
        /// parameter is null, the new rule will be inserted at the beginning of the rule
        /// list.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.after = input;
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients,
        /// domains, enabled status, scan status, and TLS policy.</p>
        pub fn rule(mut self, input: crate::model::ReceiptRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>A data structure that contains the specified rule's name, actions, recipients,
        /// domains, enabled status, scan status, and TLS policy.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReceiptRuleInput`](crate::input::CreateReceiptRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReceiptRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReceiptRuleInput {
                rule_set_name: self.rule_set_name,
                after: self.after,
                rule: self.rule,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReceiptRuleInputOperationOutputAlias = crate::operation::CreateReceiptRule;
#[doc(hidden)]
pub type CreateReceiptRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReceiptRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateReceiptRule`](crate::operation::CreateReceiptRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReceiptRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReceiptRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReceiptRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReceiptRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_receipt_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReceiptRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReceiptRule",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleInput`](crate::input::CreateReceiptRuleInput)
    pub fn builder() -> crate::input::create_receipt_rule_input::Builder {
        crate::input::create_receipt_rule_input::Builder::default()
    }
}

/// See [`CreateReceiptRuleSetInput`](crate::input::CreateReceiptRuleSetInput)
pub mod create_receipt_rule_set_input {
    /// A builder for [`CreateReceiptRuleSetInput`](crate::input::CreateReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the rule set to create. The name must:</p>
        /// <ul>
        /// <li>
        /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
        /// underscores (_), or dashes (-).</p>
        /// </li>
        /// <li>
        /// <p>Start and end with a letter or number.</p>
        /// </li>
        /// <li>
        /// <p>Contain less than 64 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReceiptRuleSetInput`](crate::input::CreateReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReceiptRuleSetInputOperationOutputAlias = crate::operation::CreateReceiptRuleSet;
#[doc(hidden)]
pub type CreateReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateReceiptRuleSet`](crate::operation::CreateReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReceiptRuleSetInput`](crate::input::CreateReceiptRuleSetInput)
    pub fn builder() -> crate::input::create_receipt_rule_set_input::Builder {
        crate::input::create_receipt_rule_set_input::Builder::default()
    }
}

/// See [`CreateTemplateInput`](crate::input::CreateTemplateInput)
pub mod create_template_input {
    /// A builder for [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTemplateInput`](crate::input::CreateTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTemplateInput {
                template: self.template,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTemplateInputOperationOutputAlias = crate::operation::CreateTemplate;
#[doc(hidden)]
pub type CreateTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateTemplate`](crate::operation::CreateTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTemplateInput`](crate::input::CreateTemplateInput)
    pub fn builder() -> crate::input::create_template_input::Builder {
        crate::input::create_template_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
pub mod delete_configuration_set_input {
    /// A builder for [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set to delete.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to delete.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationOutputAlias = crate::operation::DeleteConfigurationSet;
#[doc(hidden)]
pub type DeleteConfigurationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSet`](crate::operation::DeleteConfigurationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetInput`](crate::input::DeleteConfigurationSetInput)
    pub fn builder() -> crate::input::delete_configuration_set_input::Builder {
        crate::input::delete_configuration_set_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
pub mod delete_configuration_set_event_destination_input {
    /// A builder for [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set from which to delete the event destination.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>The name of the event destination to delete.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::DeleteConfigurationSetEventDestination;
#[doc(hidden)]
pub type DeleteConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSetEventDestination`](crate::operation::DeleteConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_set_event_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSetEventDestination",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetEventDestinationInput`](crate::input::DeleteConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::delete_configuration_set_event_destination_input::Builder {
        crate::input::delete_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`DeleteConfigurationSetTrackingOptionsInput`](crate::input::DeleteConfigurationSetTrackingOptionsInput)
pub mod delete_configuration_set_tracking_options_input {
    /// A builder for [`DeleteConfigurationSetTrackingOptionsInput`](crate::input::DeleteConfigurationSetTrackingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set from which you want to delete the tracking
        /// options.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set from which you want to delete the tracking
        /// options.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigurationSetTrackingOptionsInput`](crate::input::DeleteConfigurationSetTrackingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigurationSetTrackingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigurationSetTrackingOptionsInput {
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigurationSetTrackingOptionsInputOperationOutputAlias =
    crate::operation::DeleteConfigurationSetTrackingOptions;
#[doc(hidden)]
pub type DeleteConfigurationSetTrackingOptionsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteConfigurationSetTrackingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfigurationSetTrackingOptions`](crate::operation::DeleteConfigurationSetTrackingOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfigurationSetTrackingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigurationSetTrackingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigurationSetTrackingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigurationSetTrackingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_configuration_set_tracking_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfigurationSetTrackingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfigurationSetTrackingOptions",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigurationSetTrackingOptionsInput`](crate::input::DeleteConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::delete_configuration_set_tracking_options_input::Builder {
        crate::input::delete_configuration_set_tracking_options_input::Builder::default()
    }
}

/// See [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
pub mod delete_custom_verification_email_template_input {
    /// A builder for [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::DeleteCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type DeleteCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomVerificationEmailTemplate`](crate::operation::DeleteCustomVerificationEmailTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomVerificationEmailTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomVerificationEmailTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomVerificationEmailTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomVerificationEmailTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_verification_email_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomVerificationEmailTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomVerificationEmailTemplateInput`](crate::input::DeleteCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::delete_custom_verification_email_template_input::Builder {
        crate::input::delete_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`DeleteIdentityInput`](crate::input::DeleteIdentityInput)
pub mod delete_identity_input {
    /// A builder for [`DeleteIdentityInput`](crate::input::DeleteIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentityInput`](crate::input::DeleteIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentityInput {
                identity: self.identity,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentityInputOperationOutputAlias = crate::operation::DeleteIdentity;
#[doc(hidden)]
pub type DeleteIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIdentityInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentity`](crate::operation::DeleteIdentity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_identity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentity",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentityInput`](crate::input::DeleteIdentityInput)
    pub fn builder() -> crate::input::delete_identity_input::Builder {
        crate::input::delete_identity_input::Builder::default()
    }
}

/// See [`DeleteIdentityPolicyInput`](crate::input::DeleteIdentityPolicyInput)
pub mod delete_identity_policy_input {
    /// A builder for [`DeleteIdentityPolicyInput`](crate::input::DeleteIdentityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity that is associated with the policy that you want to delete. You can
        /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
        /// Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity that is associated with the policy that you want to delete. You can
        /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
        /// Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy to be deleted.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIdentityPolicyInput`](crate::input::DeleteIdentityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIdentityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIdentityPolicyInput {
                identity: self.identity,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIdentityPolicyInputOperationOutputAlias = crate::operation::DeleteIdentityPolicy;
#[doc(hidden)]
pub type DeleteIdentityPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIdentityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIdentityPolicy`](crate::operation::DeleteIdentityPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIdentityPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIdentityPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIdentityPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIdentityPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_identity_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIdentityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIdentityPolicy",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIdentityPolicyInput`](crate::input::DeleteIdentityPolicyInput)
    pub fn builder() -> crate::input::delete_identity_policy_input::Builder {
        crate::input::delete_identity_policy_input::Builder::default()
    }
}

/// See [`DeleteReceiptFilterInput`](crate::input::DeleteReceiptFilterInput)
pub mod delete_receipt_filter_input {
    /// A builder for [`DeleteReceiptFilterInput`](crate::input::DeleteReceiptFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IP address filter to delete.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the IP address filter to delete.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReceiptFilterInput`](crate::input::DeleteReceiptFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReceiptFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReceiptFilterInput {
                filter_name: self.filter_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReceiptFilterInputOperationOutputAlias = crate::operation::DeleteReceiptFilter;
#[doc(hidden)]
pub type DeleteReceiptFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReceiptFilterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReceiptFilter`](crate::operation::DeleteReceiptFilter)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReceiptFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReceiptFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReceiptFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReceiptFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_receipt_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReceiptFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReceiptFilter",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReceiptFilterInput`](crate::input::DeleteReceiptFilterInput)
    pub fn builder() -> crate::input::delete_receipt_filter_input::Builder {
        crate::input::delete_receipt_filter_input::Builder::default()
    }
}

/// See [`DeleteReceiptRuleInput`](crate::input::DeleteReceiptRuleInput)
pub mod delete_receipt_rule_input {
    /// A builder for [`DeleteReceiptRuleInput`](crate::input::DeleteReceiptRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule to delete.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReceiptRuleInput`](crate::input::DeleteReceiptRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReceiptRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReceiptRuleInput {
                rule_set_name: self.rule_set_name,
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReceiptRuleInputOperationOutputAlias = crate::operation::DeleteReceiptRule;
#[doc(hidden)]
pub type DeleteReceiptRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReceiptRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReceiptRule`](crate::operation::DeleteReceiptRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReceiptRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReceiptRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReceiptRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReceiptRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_receipt_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReceiptRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReceiptRule",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleInput`](crate::input::DeleteReceiptRuleInput)
    pub fn builder() -> crate::input::delete_receipt_rule_input::Builder {
        crate::input::delete_receipt_rule_input::Builder::default()
    }
}

/// See [`DeleteReceiptRuleSetInput`](crate::input::DeleteReceiptRuleSetInput)
pub mod delete_receipt_rule_set_input {
    /// A builder for [`DeleteReceiptRuleSetInput`](crate::input::DeleteReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set to delete.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReceiptRuleSetInput`](crate::input::DeleteReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReceiptRuleSetInputOperationOutputAlias = crate::operation::DeleteReceiptRuleSet;
#[doc(hidden)]
pub type DeleteReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReceiptRuleSet`](crate::operation::DeleteReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReceiptRuleSetInput`](crate::input::DeleteReceiptRuleSetInput)
    pub fn builder() -> crate::input::delete_receipt_rule_set_input::Builder {
        crate::input::delete_receipt_rule_set_input::Builder::default()
    }
}

/// See [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
pub mod delete_template_input {
    /// A builder for [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template to be deleted.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template to be deleted.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTemplateInputOperationOutputAlias = crate::operation::DeleteTemplate;
#[doc(hidden)]
pub type DeleteTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTemplate`](crate::operation::DeleteTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTemplateInput`](crate::input::DeleteTemplateInput)
    pub fn builder() -> crate::input::delete_template_input::Builder {
        crate::input::delete_template_input::Builder::default()
    }
}

/// See [`DeleteVerifiedEmailAddressInput`](crate::input::DeleteVerifiedEmailAddressInput)
pub mod delete_verified_email_address_input {
    /// A builder for [`DeleteVerifiedEmailAddressInput`](crate::input::DeleteVerifiedEmailAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>An email address to be removed from the list of verified addresses.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVerifiedEmailAddressInput`](crate::input::DeleteVerifiedEmailAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVerifiedEmailAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVerifiedEmailAddressInput {
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVerifiedEmailAddressInputOperationOutputAlias =
    crate::operation::DeleteVerifiedEmailAddress;
#[doc(hidden)]
pub type DeleteVerifiedEmailAddressInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVerifiedEmailAddressInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVerifiedEmailAddress`](crate::operation::DeleteVerifiedEmailAddress)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVerifiedEmailAddress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVerifiedEmailAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVerifiedEmailAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVerifiedEmailAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_verified_email_address(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVerifiedEmailAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVerifiedEmailAddress",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVerifiedEmailAddressInput`](crate::input::DeleteVerifiedEmailAddressInput)
    pub fn builder() -> crate::input::delete_verified_email_address_input::Builder {
        crate::input::delete_verified_email_address_input::Builder::default()
    }
}

/// See [`DescribeActiveReceiptRuleSetInput`](crate::input::DescribeActiveReceiptRuleSetInput)
pub mod describe_active_receipt_rule_set_input {
    /// A builder for [`DescribeActiveReceiptRuleSetInput`](crate::input::DescribeActiveReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeActiveReceiptRuleSetInput`](crate::input::DescribeActiveReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActiveReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActiveReceiptRuleSetInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeActiveReceiptRuleSetInputOperationOutputAlias =
    crate::operation::DescribeActiveReceiptRuleSet;
#[doc(hidden)]
pub type DescribeActiveReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActiveReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActiveReceiptRuleSet`](crate::operation::DescribeActiveReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActiveReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActiveReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActiveReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActiveReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_active_receipt_rule_set(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActiveReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActiveReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActiveReceiptRuleSetInput`](crate::input::DescribeActiveReceiptRuleSetInput)
    pub fn builder() -> crate::input::describe_active_receipt_rule_set_input::Builder {
        crate::input::describe_active_receipt_rule_set_input::Builder::default()
    }
}

/// See [`DescribeConfigurationSetInput`](crate::input::DescribeConfigurationSetInput)
pub mod describe_configuration_set_input {
    /// A builder for [`DescribeConfigurationSetInput`](crate::input::DescribeConfigurationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) configuration_set_attribute_names:
            std::option::Option<std::vec::Vec<crate::model::ConfigurationSetAttribute>>,
    }
    impl Builder {
        /// <p>The name of the configuration set to describe.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to describe.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `configuration_set_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_configuration_set_attribute_names`](Self::set_configuration_set_attribute_names).
        ///
        /// <p>A list of configuration set attributes to return.</p>
        pub fn configuration_set_attribute_names(
            mut self,
            input: impl Into<crate::model::ConfigurationSetAttribute>,
        ) -> Self {
            let mut v = self.configuration_set_attribute_names.unwrap_or_default();
            v.push(input.into());
            self.configuration_set_attribute_names = Some(v);
            self
        }
        /// <p>A list of configuration set attributes to return.</p>
        pub fn set_configuration_set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigurationSetAttribute>>,
        ) -> Self {
            self.configuration_set_attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConfigurationSetInput`](crate::input::DescribeConfigurationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConfigurationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConfigurationSetInput {
                configuration_set_name: self.configuration_set_name,
                configuration_set_attribute_names: self.configuration_set_attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConfigurationSetInputOperationOutputAlias =
    crate::operation::DescribeConfigurationSet;
#[doc(hidden)]
pub type DescribeConfigurationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConfigurationSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConfigurationSet`](crate::operation::DescribeConfigurationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConfigurationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConfigurationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConfigurationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConfigurationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_configuration_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConfigurationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConfigurationSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConfigurationSetInput`](crate::input::DescribeConfigurationSetInput)
    pub fn builder() -> crate::input::describe_configuration_set_input::Builder {
        crate::input::describe_configuration_set_input::Builder::default()
    }
}

/// See [`DescribeReceiptRuleInput`](crate::input::DescribeReceiptRuleInput)
pub mod describe_receipt_rule_input {
    /// A builder for [`DescribeReceiptRuleInput`](crate::input::DescribeReceiptRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReceiptRuleInput`](crate::input::DescribeReceiptRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReceiptRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReceiptRuleInput {
                rule_set_name: self.rule_set_name,
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReceiptRuleInputOperationOutputAlias = crate::operation::DescribeReceiptRule;
#[doc(hidden)]
pub type DescribeReceiptRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReceiptRuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReceiptRule`](crate::operation::DescribeReceiptRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReceiptRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReceiptRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReceiptRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReceiptRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_receipt_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReceiptRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReceiptRule",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleInput`](crate::input::DescribeReceiptRuleInput)
    pub fn builder() -> crate::input::describe_receipt_rule_input::Builder {
        crate::input::describe_receipt_rule_input::Builder::default()
    }
}

/// See [`DescribeReceiptRuleSetInput`](crate::input::DescribeReceiptRuleSetInput)
pub mod describe_receipt_rule_set_input {
    /// A builder for [`DescribeReceiptRuleSetInput`](crate::input::DescribeReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set to describe.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReceiptRuleSetInput`](crate::input::DescribeReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReceiptRuleSetInputOperationOutputAlias = crate::operation::DescribeReceiptRuleSet;
#[doc(hidden)]
pub type DescribeReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReceiptRuleSet`](crate::operation::DescribeReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReceiptRuleSetInput`](crate::input::DescribeReceiptRuleSetInput)
    pub fn builder() -> crate::input::describe_receipt_rule_set_input::Builder {
        crate::input::describe_receipt_rule_set_input::Builder::default()
    }
}

/// See [`GetAccountSendingEnabledInput`](crate::input::GetAccountSendingEnabledInput)
pub mod get_account_sending_enabled_input {
    /// A builder for [`GetAccountSendingEnabledInput`](crate::input::GetAccountSendingEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountSendingEnabledInput`](crate::input::GetAccountSendingEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSendingEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSendingEnabledInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountSendingEnabledInputOperationOutputAlias =
    crate::operation::GetAccountSendingEnabled;
#[doc(hidden)]
pub type GetAccountSendingEnabledInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountSendingEnabledInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSendingEnabled`](crate::operation::GetAccountSendingEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSendingEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountSendingEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountSendingEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountSendingEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_sending_enabled(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSendingEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSendingEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSendingEnabledInput`](crate::input::GetAccountSendingEnabledInput)
    pub fn builder() -> crate::input::get_account_sending_enabled_input::Builder {
        crate::input::get_account_sending_enabled_input::Builder::default()
    }
}

/// See [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
pub mod get_custom_verification_email_template_input {
    /// A builder for [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::GetCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type GetCustomVerificationEmailTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetCustomVerificationEmailTemplate`](crate::operation::GetCustomVerificationEmailTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCustomVerificationEmailTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCustomVerificationEmailTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCustomVerificationEmailTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCustomVerificationEmailTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_custom_verification_email_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCustomVerificationEmailTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCustomVerificationEmailTemplateInput`](crate::input::GetCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::get_custom_verification_email_template_input::Builder {
        crate::input::get_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`GetIdentityDkimAttributesInput`](crate::input::GetIdentityDkimAttributesInput)
pub mod get_identity_dkim_attributes_input {
    /// A builder for [`GetIdentityDkimAttributesInput`](crate::input::GetIdentityDkimAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityDkimAttributesInput`](crate::input::GetIdentityDkimAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityDkimAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityDkimAttributesInput {
                identities: self.identities,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityDkimAttributesInputOperationOutputAlias =
    crate::operation::GetIdentityDkimAttributes;
#[doc(hidden)]
pub type GetIdentityDkimAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityDkimAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityDkimAttributes`](crate::operation::GetIdentityDkimAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityDkimAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityDkimAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityDkimAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityDkimAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_dkim_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityDkimAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityDkimAttributes",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityDkimAttributesInput`](crate::input::GetIdentityDkimAttributesInput)
    pub fn builder() -> crate::input::get_identity_dkim_attributes_input::Builder {
        crate::input::get_identity_dkim_attributes_input::Builder::default()
    }
}

/// See [`GetIdentityMailFromDomainAttributesInput`](crate::input::GetIdentityMailFromDomainAttributesInput)
pub mod get_identity_mail_from_domain_attributes_input {
    /// A builder for [`GetIdentityMailFromDomainAttributesInput`](crate::input::GetIdentityMailFromDomainAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>A list of one or more identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityMailFromDomainAttributesInput`](crate::input::GetIdentityMailFromDomainAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityMailFromDomainAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityMailFromDomainAttributesInput {
                identities: self.identities,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityMailFromDomainAttributesInputOperationOutputAlias =
    crate::operation::GetIdentityMailFromDomainAttributes;
#[doc(hidden)]
pub type GetIdentityMailFromDomainAttributesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetIdentityMailFromDomainAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityMailFromDomainAttributes`](crate::operation::GetIdentityMailFromDomainAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityMailFromDomainAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityMailFromDomainAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityMailFromDomainAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityMailFromDomainAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_mail_from_domain_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityMailFromDomainAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityMailFromDomainAttributes",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityMailFromDomainAttributesInput`](crate::input::GetIdentityMailFromDomainAttributesInput)
    pub fn builder() -> crate::input::get_identity_mail_from_domain_attributes_input::Builder {
        crate::input::get_identity_mail_from_domain_attributes_input::Builder::default()
    }
}

/// See [`GetIdentityNotificationAttributesInput`](crate::input::GetIdentityNotificationAttributesInput)
pub mod get_identity_notification_attributes_input {
    /// A builder for [`GetIdentityNotificationAttributesInput`](crate::input::GetIdentityNotificationAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of one or more identities. You can specify an identity by using its name or by
        /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>A list of one or more identities. You can specify an identity by using its name or by
        /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityNotificationAttributesInput`](crate::input::GetIdentityNotificationAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityNotificationAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityNotificationAttributesInput {
                identities: self.identities,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityNotificationAttributesInputOperationOutputAlias =
    crate::operation::GetIdentityNotificationAttributes;
#[doc(hidden)]
pub type GetIdentityNotificationAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityNotificationAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityNotificationAttributes`](crate::operation::GetIdentityNotificationAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityNotificationAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityNotificationAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityNotificationAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityNotificationAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_notification_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityNotificationAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityNotificationAttributes",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityNotificationAttributesInput`](crate::input::GetIdentityNotificationAttributesInput)
    pub fn builder() -> crate::input::get_identity_notification_attributes_input::Builder {
        crate::input::get_identity_notification_attributes_input::Builder::default()
    }
}

/// See [`GetIdentityPoliciesInput`](crate::input::GetIdentityPoliciesInput)
pub mod get_identity_policies_input {
    /// A builder for [`GetIdentityPoliciesInput`](crate::input::GetIdentityPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by
        /// using its name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity for which the policies will be retrieved. You can specify an identity by
        /// using its name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
        /// policies at a time. If you do not know the names of the policies that are attached to
        /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
        /// policies at a time. If you do not know the names of the policies that are attached to
        /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityPoliciesInput`](crate::input::GetIdentityPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityPoliciesInput {
                identity: self.identity,
                policy_names: self.policy_names,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityPoliciesInputOperationOutputAlias = crate::operation::GetIdentityPolicies;
#[doc(hidden)]
pub type GetIdentityPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityPolicies`](crate::operation::GetIdentityPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_policies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityPolicies",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityPoliciesInput`](crate::input::GetIdentityPoliciesInput)
    pub fn builder() -> crate::input::get_identity_policies_input::Builder {
        crate::input::get_identity_policies_input::Builder::default()
    }
}

/// See [`GetIdentityVerificationAttributesInput`](crate::input::GetIdentityVerificationAttributesInput)
pub mod get_identity_verification_attributes_input {
    /// A builder for [`GetIdentityVerificationAttributesInput`](crate::input::GetIdentityVerificationAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identities: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `identities`.
        ///
        /// To override the contents of this collection use [`set_identities`](Self::set_identities).
        ///
        /// <p>A list of identities.</p>
        pub fn identities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.identities.unwrap_or_default();
            v.push(input.into());
            self.identities = Some(v);
            self
        }
        /// <p>A list of identities.</p>
        pub fn set_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.identities = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityVerificationAttributesInput`](crate::input::GetIdentityVerificationAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityVerificationAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityVerificationAttributesInput {
                identities: self.identities,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityVerificationAttributesInputOperationOutputAlias =
    crate::operation::GetIdentityVerificationAttributes;
#[doc(hidden)]
pub type GetIdentityVerificationAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIdentityVerificationAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityVerificationAttributes`](crate::operation::GetIdentityVerificationAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityVerificationAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIdentityVerificationAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIdentityVerificationAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIdentityVerificationAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_identity_verification_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityVerificationAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityVerificationAttributes",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityVerificationAttributesInput`](crate::input::GetIdentityVerificationAttributesInput)
    pub fn builder() -> crate::input::get_identity_verification_attributes_input::Builder {
        crate::input::get_identity_verification_attributes_input::Builder::default()
    }
}

/// See [`GetSendQuotaInput`](crate::input::GetSendQuotaInput)
pub mod get_send_quota_input {
    /// A builder for [`GetSendQuotaInput`](crate::input::GetSendQuotaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetSendQuotaInput`](crate::input::GetSendQuotaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSendQuotaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSendQuotaInput {})
        }
    }
}
#[doc(hidden)]
pub type GetSendQuotaInputOperationOutputAlias = crate::operation::GetSendQuota;
#[doc(hidden)]
pub type GetSendQuotaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSendQuotaInput {
    /// Consumes the builder and constructs an Operation<[`GetSendQuota`](crate::operation::GetSendQuota)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSendQuota,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSendQuotaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSendQuotaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSendQuotaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_send_quota(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSendQuota::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSendQuota",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSendQuotaInput`](crate::input::GetSendQuotaInput)
    pub fn builder() -> crate::input::get_send_quota_input::Builder {
        crate::input::get_send_quota_input::Builder::default()
    }
}

/// See [`GetSendStatisticsInput`](crate::input::GetSendStatisticsInput)
pub mod get_send_statistics_input {
    /// A builder for [`GetSendStatisticsInput`](crate::input::GetSendStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetSendStatisticsInput`](crate::input::GetSendStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSendStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSendStatisticsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetSendStatisticsInputOperationOutputAlias = crate::operation::GetSendStatistics;
#[doc(hidden)]
pub type GetSendStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSendStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetSendStatistics`](crate::operation::GetSendStatistics)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSendStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSendStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSendStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSendStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_send_statistics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSendStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSendStatistics",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSendStatisticsInput`](crate::input::GetSendStatisticsInput)
    pub fn builder() -> crate::input::get_send_statistics_input::Builder {
        crate::input::get_send_statistics_input::Builder::default()
    }
}

/// See [`GetTemplateInput`](crate::input::GetTemplateInput)
pub mod get_template_input {
    /// A builder for [`GetTemplateInput`](crate::input::GetTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template you want to retrieve.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template you want to retrieve.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTemplateInput`](crate::input::GetTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTemplateInputOperationOutputAlias = crate::operation::GetTemplate;
#[doc(hidden)]
pub type GetTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetTemplate`](crate::operation::GetTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTemplateInput`](crate::input::GetTemplateInput)
    pub fn builder() -> crate::input::get_template_input::Builder {
        crate::input::get_template_input::Builder::default()
    }
}

/// See [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
pub mod list_configuration_sets_input {
    /// A builder for [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position of the configuration set in the configuration set list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
        /// indicate the position of the configuration set in the configuration set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The number of configuration sets to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigurationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigurationSetsInput {
                next_token: self.next_token,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationOutputAlias = crate::operation::ListConfigurationSets;
#[doc(hidden)]
pub type ListConfigurationSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConfigurationSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigurationSets`](crate::operation::ListConfigurationSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigurationSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigurationSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigurationSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigurationSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_configuration_sets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigurationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigurationSets",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigurationSetsInput`](crate::input::ListConfigurationSetsInput)
    pub fn builder() -> crate::input::list_configuration_sets_input::Builder {
        crate::input::list_configuration_sets_input::Builder::default()
    }
}

/// See [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
pub mod list_custom_verification_email_templates_input {
    /// A builder for [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
        /// account.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must
        /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
        /// specify a value less than 1 or greater than 50, the operation will return up to 50
        /// results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of custom verification email templates to return. This value must
        /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
        /// specify a value less than 1 or greater than 50, the operation will return up to 50
        /// results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomVerificationEmailTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomVerificationEmailTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomVerificationEmailTemplatesInputOperationOutputAlias =
    crate::operation::ListCustomVerificationEmailTemplates;
#[doc(hidden)]
pub type ListCustomVerificationEmailTemplatesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListCustomVerificationEmailTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomVerificationEmailTemplates`](crate::operation::ListCustomVerificationEmailTemplates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomVerificationEmailTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomVerificationEmailTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomVerificationEmailTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomVerificationEmailTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_verification_email_templates(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomVerificationEmailTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomVerificationEmailTemplates",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomVerificationEmailTemplatesInput`](crate::input::ListCustomVerificationEmailTemplatesInput)
    pub fn builder() -> crate::input::list_custom_verification_email_templates_input::Builder {
        crate::input::list_custom_verification_email_templates_input::Builder::default()
    }
}

/// See [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
pub mod list_identities_input {
    /// A builder for [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_type: std::option::Option<crate::model::IdentityType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
        /// If this parameter is omitted, then all identities will be listed.</p>
        pub fn identity_type(mut self, input: crate::model::IdentityType) -> Self {
            self.identity_type = Some(input);
            self
        }
        /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
        /// If this parameter is omitted, then all identities will be listed.</p>
        pub fn set_identity_type(
            mut self,
            input: std::option::Option<crate::model::IdentityType>,
        ) -> Self {
            self.identity_type = input;
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use for pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000
        /// inclusive.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of identities per page. Possible values are 1-1000
        /// inclusive.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentitiesInput {
                identity_type: self.identity_type,
                next_token: self.next_token,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentitiesInputOperationOutputAlias = crate::operation::ListIdentities;
#[doc(hidden)]
pub type ListIdentitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIdentitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentities`](crate::operation::ListIdentities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_identities(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentities",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentitiesInput`](crate::input::ListIdentitiesInput)
    pub fn builder() -> crate::input::list_identities_input::Builder {
        crate::input::list_identities_input::Builder::default()
    }
}

/// See [`ListIdentityPoliciesInput`](crate::input::ListIdentityPoliciesInput)
pub mod list_identity_policies_input {
    /// A builder for [`ListIdentityPoliciesInput`](crate::input::ListIdentityPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity that is associated with the policy for which the policies will be listed.
        /// You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity that is associated with the policy for which the policies will be listed.
        /// You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityPoliciesInput`](crate::input::ListIdentityPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityPoliciesInput {
                identity: self.identity,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityPoliciesInputOperationOutputAlias = crate::operation::ListIdentityPolicies;
#[doc(hidden)]
pub type ListIdentityPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIdentityPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityPolicies`](crate::operation::ListIdentityPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIdentityPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIdentityPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIdentityPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_identity_policies(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityPolicies",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityPoliciesInput`](crate::input::ListIdentityPoliciesInput)
    pub fn builder() -> crate::input::list_identity_policies_input::Builder {
        crate::input::list_identity_policies_input::Builder::default()
    }
}

/// See [`ListReceiptFiltersInput`](crate::input::ListReceiptFiltersInput)
pub mod list_receipt_filters_input {
    /// A builder for [`ListReceiptFiltersInput`](crate::input::ListReceiptFiltersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListReceiptFiltersInput`](crate::input::ListReceiptFiltersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReceiptFiltersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReceiptFiltersInput {})
        }
    }
}
#[doc(hidden)]
pub type ListReceiptFiltersInputOperationOutputAlias = crate::operation::ListReceiptFilters;
#[doc(hidden)]
pub type ListReceiptFiltersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReceiptFiltersInput {
    /// Consumes the builder and constructs an Operation<[`ListReceiptFilters`](crate::operation::ListReceiptFilters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReceiptFilters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReceiptFiltersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReceiptFiltersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReceiptFiltersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_receipt_filters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReceiptFilters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReceiptFilters",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReceiptFiltersInput`](crate::input::ListReceiptFiltersInput)
    pub fn builder() -> crate::input::list_receipt_filters_input::Builder {
        crate::input::list_receipt_filters_input::Builder::default()
    }
}

/// See [`ListReceiptRuleSetsInput`](crate::input::ListReceiptRuleSetsInput)
pub mod list_receipt_rule_sets_input {
    /// A builder for [`ListReceiptRuleSetsInput`](crate::input::ListReceiptRuleSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
        /// the position in the receipt rule set list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
        /// the position in the receipt rule set list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReceiptRuleSetsInput`](crate::input::ListReceiptRuleSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReceiptRuleSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReceiptRuleSetsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReceiptRuleSetsInputOperationOutputAlias = crate::operation::ListReceiptRuleSets;
#[doc(hidden)]
pub type ListReceiptRuleSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReceiptRuleSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListReceiptRuleSets`](crate::operation::ListReceiptRuleSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReceiptRuleSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReceiptRuleSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReceiptRuleSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReceiptRuleSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_receipt_rule_sets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReceiptRuleSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReceiptRuleSets",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReceiptRuleSetsInput`](crate::input::ListReceiptRuleSetsInput)
    pub fn builder() -> crate::input::list_receipt_rule_sets_input::Builder {
        crate::input::list_receipt_rule_sets_input::Builder::default()
    }
}

/// See [`ListTemplatesInput`](crate::input::ListTemplatesInput)
pub mod list_templates_input {
    /// A builder for [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
        /// position in the list of email templates.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
        /// position in the list of email templates.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than
        /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
        /// greater than 10, the operation will return up to 10 results.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of templates to return. This value must be at least 1 and less than
        /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
        /// greater than 10, the operation will return up to 10 results.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTemplatesInput`](crate::input::ListTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTemplatesInput {
                next_token: self.next_token,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTemplatesInputOperationOutputAlias = crate::operation::ListTemplates;
#[doc(hidden)]
pub type ListTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListTemplates`](crate::operation::ListTemplates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_templates(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTemplates",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTemplatesInput`](crate::input::ListTemplatesInput)
    pub fn builder() -> crate::input::list_templates_input::Builder {
        crate::input::list_templates_input::Builder::default()
    }
}

/// See [`ListVerifiedEmailAddressesInput`](crate::input::ListVerifiedEmailAddressesInput)
pub mod list_verified_email_addresses_input {
    /// A builder for [`ListVerifiedEmailAddressesInput`](crate::input::ListVerifiedEmailAddressesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListVerifiedEmailAddressesInput`](crate::input::ListVerifiedEmailAddressesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVerifiedEmailAddressesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVerifiedEmailAddressesInput {})
        }
    }
}
#[doc(hidden)]
pub type ListVerifiedEmailAddressesInputOperationOutputAlias =
    crate::operation::ListVerifiedEmailAddresses;
#[doc(hidden)]
pub type ListVerifiedEmailAddressesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVerifiedEmailAddressesInput {
    /// Consumes the builder and constructs an Operation<[`ListVerifiedEmailAddresses`](crate::operation::ListVerifiedEmailAddresses)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVerifiedEmailAddresses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVerifiedEmailAddressesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVerifiedEmailAddressesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVerifiedEmailAddressesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_verified_email_addresses(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVerifiedEmailAddresses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVerifiedEmailAddresses",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVerifiedEmailAddressesInput`](crate::input::ListVerifiedEmailAddressesInput)
    pub fn builder() -> crate::input::list_verified_email_addresses_input::Builder {
        crate::input::list_verified_email_addresses_input::Builder::default()
    }
}

/// See [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
pub mod put_configuration_set_delivery_options_input {
    /// A builder for [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) delivery_options: std::option::Option<crate::model::DeliveryOptions>,
    }
    impl Builder {
        /// <p>The name of the configuration set that you want to specify the delivery options
        /// for.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to specify the delivery options
        /// for.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn delivery_options(mut self, input: crate::model::DeliveryOptions) -> Self {
            self.delivery_options = Some(input);
            self
        }
        /// <p>Specifies whether messages that use the configuration set are required to use
        /// Transport Layer Security (TLS).</p>
        pub fn set_delivery_options(
            mut self,
            input: std::option::Option<crate::model::DeliveryOptions>,
        ) -> Self {
            self.delivery_options = input;
            self
        }
        /// Consumes the builder and constructs a [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutConfigurationSetDeliveryOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutConfigurationSetDeliveryOptionsInput {
                configuration_set_name: self.configuration_set_name,
                delivery_options: self.delivery_options,
            })
        }
    }
}
#[doc(hidden)]
pub type PutConfigurationSetDeliveryOptionsInputOperationOutputAlias =
    crate::operation::PutConfigurationSetDeliveryOptions;
#[doc(hidden)]
pub type PutConfigurationSetDeliveryOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutConfigurationSetDeliveryOptionsInput {
    /// Consumes the builder and constructs an Operation<[`PutConfigurationSetDeliveryOptions`](crate::operation::PutConfigurationSetDeliveryOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutConfigurationSetDeliveryOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutConfigurationSetDeliveryOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutConfigurationSetDeliveryOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutConfigurationSetDeliveryOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_configuration_set_delivery_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutConfigurationSetDeliveryOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutConfigurationSetDeliveryOptions",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutConfigurationSetDeliveryOptionsInput`](crate::input::PutConfigurationSetDeliveryOptionsInput)
    pub fn builder() -> crate::input::put_configuration_set_delivery_options_input::Builder {
        crate::input::put_configuration_set_delivery_options_input::Builder::default()
    }
}

/// See [`PutIdentityPolicyInput`](crate::input::PutIdentityPolicyInput)
pub mod put_identity_policy_input {
    /// A builder for [`PutIdentityPolicyInput`](crate::input::PutIdentityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity that the policy will apply to. You can specify an identity by using its
        /// name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity that the policy will apply to. You can specify an identity by using its
        /// name or by using its Amazon Resource Name (ARN). Examples:
        /// <code>user@example.com</code>, <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        /// <p>To successfully call this API, you must own the identity.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
        /// characters, dashes, and underscores.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
        /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
        /// Guide</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIdentityPolicyInput`](crate::input::PutIdentityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutIdentityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutIdentityPolicyInput {
                identity: self.identity,
                policy_name: self.policy_name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutIdentityPolicyInputOperationOutputAlias = crate::operation::PutIdentityPolicy;
#[doc(hidden)]
pub type PutIdentityPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutIdentityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutIdentityPolicy`](crate::operation::PutIdentityPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutIdentityPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutIdentityPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutIdentityPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutIdentityPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_identity_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutIdentityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutIdentityPolicy",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutIdentityPolicyInput`](crate::input::PutIdentityPolicyInput)
    pub fn builder() -> crate::input::put_identity_policy_input::Builder {
        crate::input::put_identity_policy_input::Builder::default()
    }
}

/// See [`ReorderReceiptRuleSetInput`](crate::input::ReorderReceiptRuleSetInput)
pub mod reorder_receipt_rule_set_input {
    /// A builder for [`ReorderReceiptRuleSetInput`](crate::input::ReorderReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set to reorder.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// Appends an item to `rule_names`.
        ///
        /// To override the contents of this collection use [`set_rule_names`](Self::set_rule_names).
        ///
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
        /// put them.</p>
        pub fn rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rule_names.unwrap_or_default();
            v.push(input.into());
            self.rule_names = Some(v);
            self
        }
        /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
        /// put them.</p>
        pub fn set_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rule_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ReorderReceiptRuleSetInput`](crate::input::ReorderReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ReorderReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ReorderReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
                rule_names: self.rule_names,
            })
        }
    }
}
#[doc(hidden)]
pub type ReorderReceiptRuleSetInputOperationOutputAlias = crate::operation::ReorderReceiptRuleSet;
#[doc(hidden)]
pub type ReorderReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ReorderReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`ReorderReceiptRuleSet`](crate::operation::ReorderReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ReorderReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ReorderReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ReorderReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ReorderReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reorder_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ReorderReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ReorderReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ReorderReceiptRuleSetInput`](crate::input::ReorderReceiptRuleSetInput)
    pub fn builder() -> crate::input::reorder_receipt_rule_set_input::Builder {
        crate::input::reorder_receipt_rule_set_input::Builder::default()
    }
}

/// See [`SendBounceInput`](crate::input::SendBounceInput)
pub mod send_bounce_input {
    /// A builder for [`SendBounceInput`](crate::input::SendBounceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) original_message_id: std::option::Option<std::string::String>,
        pub(crate) bounce_sender: std::option::Option<std::string::String>,
        pub(crate) explanation: std::option::Option<std::string::String>,
        pub(crate) message_dsn: std::option::Option<crate::model::MessageDsn>,
        pub(crate) bounced_recipient_info_list:
            std::option::Option<std::vec::Vec<crate::model::BouncedRecipientInfo>>,
        pub(crate) bounce_sender_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message ID of the message to be bounced.</p>
        pub fn original_message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_message_id = Some(input.into());
            self
        }
        /// <p>The message ID of the message to be bounced.</p>
        pub fn set_original_message_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_message_id = input;
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an
        /// identity that you have verified with Amazon SES.</p>
        pub fn bounce_sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.bounce_sender = Some(input.into());
            self
        }
        /// <p>The address to use in the "From" header of the bounce message. This must be an
        /// identity that you have verified with Amazon SES.</p>
        pub fn set_bounce_sender(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bounce_sender = input;
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
        /// the text will be auto-generated based on the bounced recipient information.</p>
        pub fn explanation(mut self, input: impl Into<std::string::String>) -> Self {
            self.explanation = Some(input.into());
            self
        }
        /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
        /// the text will be auto-generated based on the bounced recipient information.</p>
        pub fn set_explanation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.explanation = input;
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn message_dsn(mut self, input: crate::model::MessageDsn) -> Self {
            self.message_dsn = Some(input);
            self
        }
        /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
        pub fn set_message_dsn(
            mut self,
            input: std::option::Option<crate::model::MessageDsn>,
        ) -> Self {
            self.message_dsn = input;
            self
        }
        /// Appends an item to `bounced_recipient_info_list`.
        ///
        /// To override the contents of this collection use [`set_bounced_recipient_info_list`](Self::set_bounced_recipient_info_list).
        ///
        /// <p>A list of recipients of the bounced message, including the information required to
        /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
        /// least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn bounced_recipient_info_list(
            mut self,
            input: impl Into<crate::model::BouncedRecipientInfo>,
        ) -> Self {
            let mut v = self.bounced_recipient_info_list.unwrap_or_default();
            v.push(input.into());
            self.bounced_recipient_info_list = Some(v);
            self
        }
        /// <p>A list of recipients of the bounced message, including the information required to
        /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
        /// least one <code>BouncedRecipientInfo</code> in the list.</p>
        pub fn set_bounced_recipient_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BouncedRecipientInfo>>,
        ) -> Self {
            self.bounced_recipient_info_list = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// address in the "From" header of the bounce. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn bounce_sender_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bounce_sender_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// address in the "From" header of the bounce. For more information about sending
        /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_bounce_sender_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bounce_sender_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBounceInput`](crate::input::SendBounceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendBounceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendBounceInput {
                original_message_id: self.original_message_id,
                bounce_sender: self.bounce_sender,
                explanation: self.explanation,
                message_dsn: self.message_dsn,
                bounced_recipient_info_list: self.bounced_recipient_info_list,
                bounce_sender_arn: self.bounce_sender_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type SendBounceInputOperationOutputAlias = crate::operation::SendBounce;
#[doc(hidden)]
pub type SendBounceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendBounceInput {
    /// Consumes the builder and constructs an Operation<[`SendBounce`](crate::operation::SendBounce)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendBounce,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendBounceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendBounceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendBounceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_bounce(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendBounce::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendBounce",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendBounceInput`](crate::input::SendBounceInput)
    pub fn builder() -> crate::input::send_bounce_input::Builder {
        crate::input::send_bounce_input::Builder::default()
    }
}

/// See [`SendBulkTemplatedEmailInput`](crate::input::SendBulkTemplatedEmailInput)
pub mod send_bulk_templated_email_input {
    /// A builder for [`SendBulkTemplatedEmailInput`](crate::input::SendBulkTemplatedEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) return_path: std::option::Option<std::string::String>,
        pub(crate) return_path_arn: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) default_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) default_template_data: std::option::Option<std::string::String>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::BulkEmailDestination>>,
    }
    impl Builder {
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Appends an item to `reply_to_addresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reply_to_addresses.unwrap_or_default();
            v.push(input.into());
            self.reply_to_addresses = Some(v);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reply_to_addresses = input;
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path = Some(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.return_path = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.return_path_arn = input;
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendBulkTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Appends an item to `default_tags`.
        ///
        /// To override the contents of this collection use [`set_default_tags`](Self::set_default_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
        /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn default_tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.default_tags.unwrap_or_default();
            v.push(input.into());
            self.default_tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
        /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
        pub fn set_default_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.default_tags = input;
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not
        /// specified in a Destination object. These values act as a default or fallback option when
        /// no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
        /// the keys correspond to replacement tags in the email template.</p>
        pub fn default_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template when replacement data is not
        /// specified in a Destination object. These values act as a default or fallback option when
        /// no other data is available.</p>
        /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
        /// the keys correspond to replacement tags in the email template.</p>
        pub fn set_default_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_template_data = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a
        /// <code>Destination</code> will receive the same version of the email. You can specify
        /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
        /// array.</p>
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::BulkEmailDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// <p>One or more <code>Destination</code> objects. All of the recipients in a
        /// <code>Destination</code> will receive the same version of the email. You can specify
        /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
        /// array.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`SendBulkTemplatedEmailInput`](crate::input::SendBulkTemplatedEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendBulkTemplatedEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendBulkTemplatedEmailInput {
                source: self.source,
                source_arn: self.source_arn,
                reply_to_addresses: self.reply_to_addresses,
                return_path: self.return_path,
                return_path_arn: self.return_path_arn,
                configuration_set_name: self.configuration_set_name,
                default_tags: self.default_tags,
                template: self.template,
                template_arn: self.template_arn,
                default_template_data: self.default_template_data,
                destinations: self.destinations,
            })
        }
    }
}
#[doc(hidden)]
pub type SendBulkTemplatedEmailInputOperationOutputAlias = crate::operation::SendBulkTemplatedEmail;
#[doc(hidden)]
pub type SendBulkTemplatedEmailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendBulkTemplatedEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendBulkTemplatedEmail`](crate::operation::SendBulkTemplatedEmail)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendBulkTemplatedEmail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendBulkTemplatedEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendBulkTemplatedEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendBulkTemplatedEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_bulk_templated_email(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendBulkTemplatedEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendBulkTemplatedEmail",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendBulkTemplatedEmailInput`](crate::input::SendBulkTemplatedEmailInput)
    pub fn builder() -> crate::input::send_bulk_templated_email_input::Builder {
        crate::input::send_bulk_templated_email_input::Builder::default()
    }
}

/// See [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
pub mod send_custom_verification_email_input {
    /// A builder for [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address to verify.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address to verify.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template to use when sending the
        /// verification email.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Name of a configuration set to use when sending the verification email.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendCustomVerificationEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendCustomVerificationEmailInput {
                email_address: self.email_address,
                template_name: self.template_name,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SendCustomVerificationEmailInputOperationOutputAlias =
    crate::operation::SendCustomVerificationEmail;
#[doc(hidden)]
pub type SendCustomVerificationEmailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendCustomVerificationEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendCustomVerificationEmail`](crate::operation::SendCustomVerificationEmail)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendCustomVerificationEmail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendCustomVerificationEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendCustomVerificationEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendCustomVerificationEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_custom_verification_email(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendCustomVerificationEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendCustomVerificationEmail",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendCustomVerificationEmailInput`](crate::input::SendCustomVerificationEmailInput)
    pub fn builder() -> crate::input::send_custom_verification_email_input::Builder {
        crate::input::send_custom_verification_email_input::Builder::default()
    }
}

/// See [`SendEmailInput`](crate::input::SendEmailInput)
pub mod send_email_input {
    /// A builder for [`SendEmailInput`](crate::input::SendEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) message: std::option::Option<crate::model::Message>,
        pub(crate) reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) return_path: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) return_path_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The message to be sent.</p>
        pub fn message(mut self, input: crate::model::Message) -> Self {
            self.message = Some(input);
            self
        }
        /// <p>The message to be sent.</p>
        pub fn set_message(mut self, input: std::option::Option<crate::model::Message>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `reply_to_addresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reply_to_addresses.unwrap_or_default();
            v.push(input.into());
            self.reply_to_addresses = Some(v);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reply_to_addresses = input;
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path = Some(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.return_path = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.return_path_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
        /// define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
        /// define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEmailInput`](crate::input::SendEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SendEmailInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SendEmailInput {
                source: self.source,
                destination: self.destination,
                message: self.message,
                reply_to_addresses: self.reply_to_addresses,
                return_path: self.return_path,
                source_arn: self.source_arn,
                return_path_arn: self.return_path_arn,
                tags: self.tags,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SendEmailInputOperationOutputAlias = crate::operation::SendEmail;
#[doc(hidden)]
pub type SendEmailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendEmail`](crate::operation::SendEmail)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendEmail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_email(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::SendEmail::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "SendEmail",
                    "ses",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendEmailInput`](crate::input::SendEmailInput)
    pub fn builder() -> crate::input::send_email_input::Builder {
        crate::input::send_email_input::Builder::default()
    }
}

/// See [`SendRawEmailInput`](crate::input::SendRawEmailInput)
pub mod send_raw_email_input {
    /// A builder for [`SendRawEmailInput`](crate::input::SendRawEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) raw_message: std::option::Option<crate::model::RawMessage>,
        pub(crate) from_arn: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) return_path_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity's email address. If you do not provide a value for this parameter, you
        /// must specify a "From" address in the raw text of the message. (You can also specify
        /// both.)</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        ///
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
        /// then bounces and complaints will be sent to this email address. This takes precedence
        /// over any Return-Path header that you might include in the raw text of the
        /// message.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The identity's email address. If you do not provide a value for this parameter, you
        /// must specify a "From" address in the raw text of the message. (You can also specify
        /// both.)</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        ///
        /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
        /// then bounces and complaints will be sent to this email address. This takes precedence
        /// over any Return-Path header that you might include in the raw text of the
        /// message.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
        /// addresses.</p>
        pub fn destinations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
        /// addresses.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by a blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
        /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
        /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be base64-encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, we highly recommend that you encode that
        /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
        /// Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
        /// 5321</a>, the maximum length of each line of text, including the
        /// <CRLF>, must not exceed 1,000 characters.</p>
        /// </li>
        /// </ul>
        pub fn raw_message(mut self, input: crate::model::RawMessage) -> Self {
            self.raw_message = Some(input);
            self
        }
        /// <p>The raw email message itself. The message has to meet the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>The message has to contain a header and a body, separated by a blank
        /// line.</p>
        /// </li>
        /// <li>
        /// <p>All of the required header fields must be present in the message.</p>
        /// </li>
        /// <li>
        /// <p>Each part of a multipart MIME message must be formatted properly.</p>
        /// </li>
        /// <li>
        /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
        /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
        /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>The entire message must be base64-encoded.</p>
        /// </li>
        /// <li>
        /// <p>If any of the MIME parts in your message contain content that is outside of
        /// the 7-bit ASCII character range, we highly recommend that you encode that
        /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
        /// Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
        /// 5321</a>, the maximum length of each line of text, including the
        /// <CRLF>, must not exceed 1,000 characters.</p>
        /// </li>
        /// </ul>
        pub fn set_raw_message(
            mut self,
            input: std::option::Option<crate::model::RawMessage>,
        ) -> Self {
            self.raw_message = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to specify a
        /// particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
        /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
        /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
        /// parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn from_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to specify a
        /// particular "From" address in the header of the raw email.</p>
        /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
        /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
        /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
        /// parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_from_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.from_arn = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
        /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>SourceArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
        /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>SourceArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
        /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>ReturnPathArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>Instead of using this parameter, you can use the X-header
        /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
        /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
        /// value of the <code>ReturnPathArn</code> parameter.</p>
        /// <note>
        /// <p>For information about when to use this parameter, see the description of
        /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
        /// </note>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.return_path_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
        /// you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
        /// you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendRawEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendRawEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SendRawEmailInput`](crate::input::SendRawEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendRawEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendRawEmailInput {
                source: self.source,
                destinations: self.destinations,
                raw_message: self.raw_message,
                from_arn: self.from_arn,
                source_arn: self.source_arn,
                return_path_arn: self.return_path_arn,
                tags: self.tags,
                configuration_set_name: self.configuration_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SendRawEmailInputOperationOutputAlias = crate::operation::SendRawEmail;
#[doc(hidden)]
pub type SendRawEmailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendRawEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendRawEmail`](crate::operation::SendRawEmail)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendRawEmail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendRawEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendRawEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendRawEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_send_raw_email(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendRawEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendRawEmail",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendRawEmailInput`](crate::input::SendRawEmailInput)
    pub fn builder() -> crate::input::send_raw_email_input::Builder {
        crate::input::send_raw_email_input::Builder::default()
    }
}

/// See [`SendTemplatedEmailInput`](crate::input::SendTemplatedEmailInput)
pub mod send_templated_email_input {
    /// A builder for [`SendTemplatedEmailInput`](crate::input::SendTemplatedEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) return_path: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) return_path_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The email address that is sending the email. This email address must be either
        /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
        /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
        /// Guide</a>.</p>
        /// <p>If you are sending on behalf of another user and have been permitted to do so by a
        /// sending authorization policy, then you must also specify the <code>SourceArn</code>
        /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
        /// <note>
        /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
        /// <i>local part</i> of a source email address (the part of the email
        /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
        /// characters</a>. If the <i>domain part</i> of an address (the
        /// part after the @ sign) contains non-ASCII characters, they must be encoded using
        /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
        /// name</i>) may contain non-ASCII characters. These characters must be
        /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
        /// syntax uses the following form:
        /// <code>=?charset?encoding?encoded-text?=</code>.</p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
        /// can include up to 50 recipients across these three fields.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
        /// can include up to 50 recipients across these three fields.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Appends an item to `reply_to_addresses`.
        ///
        /// To override the contents of this collection use [`set_reply_to_addresses`](Self::set_reply_to_addresses).
        ///
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn reply_to_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reply_to_addresses.unwrap_or_default();
            v.push(input.into());
            self.reply_to_addresses = Some(v);
            self
        }
        /// <p>The reply-to email address(es) for the message. If the recipient replies to the
        /// message, each reply-to address will receive the reply.</p>
        pub fn set_reply_to_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reply_to_addresses = input;
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn return_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path = Some(input.into());
            self
        }
        /// <p>The email address that bounces and complaints will be forwarded to when feedback
        /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
        /// error message will be returned from the recipient's ISP; this message will then be
        /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
        /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
        /// either individually verified with Amazon SES, or from a domain that has been verified with
        /// Amazon SES. </p>
        pub fn set_return_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.return_path = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to send for
        /// the email address specified in the <code>Source</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
        /// would specify the <code>SourceArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>Source</code> to be <code>user@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn return_path_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.return_path_arn = Some(input.into());
            self
        }
        /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
        /// that is associated with the sending authorization policy that permits you to use the
        /// email address specified in the <code>ReturnPath</code> parameter.</p>
        /// <p>For example, if the owner of <code>example.com</code> (which has ARN
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
        /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
        /// would specify the <code>ReturnPathArn</code> to be
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
        /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
        /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
        /// Guide</a>.</p>
        pub fn set_return_path_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.return_path_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
        /// that you define, so that you can publish email sending events.</p>
        pub fn tags(mut self, input: impl Into<crate::model::MessageTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
        /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
        /// that you define, so that you can publish email sending events.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendTemplatedEmail</code>.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set to use when you send an email using
        /// <code>SendTemplatedEmail</code>.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The template to use when sending this email.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the template to use when sending this email.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`SendTemplatedEmailInput`](crate::input::SendTemplatedEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendTemplatedEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendTemplatedEmailInput {
                source: self.source,
                destination: self.destination,
                reply_to_addresses: self.reply_to_addresses,
                return_path: self.return_path,
                source_arn: self.source_arn,
                return_path_arn: self.return_path_arn,
                tags: self.tags,
                configuration_set_name: self.configuration_set_name,
                template: self.template,
                template_arn: self.template_arn,
                template_data: self.template_data,
            })
        }
    }
}
#[doc(hidden)]
pub type SendTemplatedEmailInputOperationOutputAlias = crate::operation::SendTemplatedEmail;
#[doc(hidden)]
pub type SendTemplatedEmailInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendTemplatedEmailInput {
    /// Consumes the builder and constructs an Operation<[`SendTemplatedEmail`](crate::operation::SendTemplatedEmail)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendTemplatedEmail,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendTemplatedEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendTemplatedEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendTemplatedEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_templated_email(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendTemplatedEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendTemplatedEmail",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendTemplatedEmailInput`](crate::input::SendTemplatedEmailInput)
    pub fn builder() -> crate::input::send_templated_email_input::Builder {
        crate::input::send_templated_email_input::Builder::default()
    }
}

/// See [`SetActiveReceiptRuleSetInput`](crate::input::SetActiveReceiptRuleSetInput)
pub mod set_active_receipt_rule_set_input {
    /// A builder for [`SetActiveReceiptRuleSetInput`](crate::input::SetActiveReceiptRuleSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables
        /// all email receiving.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set to make active. Setting this value to null disables
        /// all email receiving.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SetActiveReceiptRuleSetInput`](crate::input::SetActiveReceiptRuleSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetActiveReceiptRuleSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetActiveReceiptRuleSetInput {
                rule_set_name: self.rule_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type SetActiveReceiptRuleSetInputOperationOutputAlias =
    crate::operation::SetActiveReceiptRuleSet;
#[doc(hidden)]
pub type SetActiveReceiptRuleSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetActiveReceiptRuleSetInput {
    /// Consumes the builder and constructs an Operation<[`SetActiveReceiptRuleSet`](crate::operation::SetActiveReceiptRuleSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetActiveReceiptRuleSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetActiveReceiptRuleSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetActiveReceiptRuleSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetActiveReceiptRuleSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_active_receipt_rule_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetActiveReceiptRuleSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetActiveReceiptRuleSet",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetActiveReceiptRuleSetInput`](crate::input::SetActiveReceiptRuleSetInput)
    pub fn builder() -> crate::input::set_active_receipt_rule_set_input::Builder {
        crate::input::set_active_receipt_rule_set_input::Builder::default()
    }
}

/// See [`SetIdentityDkimEnabledInput`](crate::input::SetIdentityDkimEnabledInput)
pub mod set_identity_dkim_enabled_input {
    /// A builder for [`SetIdentityDkimEnabledInput`](crate::input::SetIdentityDkimEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) dkim_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
        /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn dkim_enabled(mut self, input: bool) -> Self {
            self.dkim_enabled = Some(input);
            self
        }
        /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
        /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
        pub fn set_dkim_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.dkim_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityDkimEnabledInput`](crate::input::SetIdentityDkimEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityDkimEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityDkimEnabledInput {
                identity: self.identity,
                dkim_enabled: self.dkim_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityDkimEnabledInputOperationOutputAlias = crate::operation::SetIdentityDkimEnabled;
#[doc(hidden)]
pub type SetIdentityDkimEnabledInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIdentityDkimEnabledInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityDkimEnabled`](crate::operation::SetIdentityDkimEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityDkimEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityDkimEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityDkimEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityDkimEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_dkim_enabled(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityDkimEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityDkimEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityDkimEnabledInput`](crate::input::SetIdentityDkimEnabledInput)
    pub fn builder() -> crate::input::set_identity_dkim_enabled_input::Builder {
        crate::input::set_identity_dkim_enabled_input::Builder::default()
    }
}

/// See [`SetIdentityFeedbackForwardingEnabledInput`](crate::input::SetIdentityFeedbackForwardingEnabledInput)
pub mod set_identity_feedback_forwarding_enabled_input {
    /// A builder for [`SetIdentityFeedbackForwardingEnabledInput`](crate::input::SetIdentityFeedbackForwardingEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) forwarding_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
        /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
        /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
        /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
        /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
        /// notification types.</p>
        pub fn forwarding_enabled(mut self, input: bool) -> Self {
            self.forwarding_enabled = Some(input);
            self
        }
        /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
        /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
        /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
        /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
        /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
        /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
        /// notification types.</p>
        pub fn set_forwarding_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.forwarding_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityFeedbackForwardingEnabledInput`](crate::input::SetIdentityFeedbackForwardingEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityFeedbackForwardingEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityFeedbackForwardingEnabledInput {
                identity: self.identity,
                forwarding_enabled: self.forwarding_enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityFeedbackForwardingEnabledInputOperationOutputAlias =
    crate::operation::SetIdentityFeedbackForwardingEnabled;
#[doc(hidden)]
pub type SetIdentityFeedbackForwardingEnabledInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl SetIdentityFeedbackForwardingEnabledInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityFeedbackForwardingEnabled`](crate::operation::SetIdentityFeedbackForwardingEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityFeedbackForwardingEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityFeedbackForwardingEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityFeedbackForwardingEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityFeedbackForwardingEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_feedback_forwarding_enabled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityFeedbackForwardingEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityFeedbackForwardingEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityFeedbackForwardingEnabledInput`](crate::input::SetIdentityFeedbackForwardingEnabledInput)
    pub fn builder() -> crate::input::set_identity_feedback_forwarding_enabled_input::Builder {
        crate::input::set_identity_feedback_forwarding_enabled_input::Builder::default()
    }
}

/// See [`SetIdentityHeadersInNotificationsEnabledInput`](crate::input::SetIdentityHeadersInNotificationsEnabledInput)
pub mod set_identity_headers_in_notifications_enabled_input {
    /// A builder for [`SetIdentityHeadersInNotificationsEnabledInput`](crate::input::SetIdentityHeadersInNotificationsEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identity for which to enable or disable headers in notifications. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity for which to enable or disable headers in notifications. Examples:
        /// <code>user@example.com</code>, <code>example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p>The notification type for which to enable or disable headers in notifications. </p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
        /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
        /// particular Amazon SNS topic.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
        /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
        /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
        /// will not include headers in notifications.</p>
        /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
        /// particular Amazon SNS topic.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityHeadersInNotificationsEnabledInput`](crate::input::SetIdentityHeadersInNotificationsEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityHeadersInNotificationsEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::SetIdentityHeadersInNotificationsEnabledInput {
                    identity: self.identity,
                    notification_type: self.notification_type,
                    enabled: self.enabled.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type SetIdentityHeadersInNotificationsEnabledInputOperationOutputAlias =
    crate::operation::SetIdentityHeadersInNotificationsEnabled;
#[doc(hidden)]
pub type SetIdentityHeadersInNotificationsEnabledInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl SetIdentityHeadersInNotificationsEnabledInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityHeadersInNotificationsEnabled`](crate::operation::SetIdentityHeadersInNotificationsEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityHeadersInNotificationsEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityHeadersInNotificationsEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityHeadersInNotificationsEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityHeadersInNotificationsEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_headers_in_notifications_enabled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityHeadersInNotificationsEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityHeadersInNotificationsEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityHeadersInNotificationsEnabledInput`](crate::input::SetIdentityHeadersInNotificationsEnabledInput)
    pub fn builder() -> crate::input::set_identity_headers_in_notifications_enabled_input::Builder {
        crate::input::set_identity_headers_in_notifications_enabled_input::Builder::default()
    }
}

/// See [`SetIdentityMailFromDomainInput`](crate::input::SetIdentityMailFromDomainInput)
pub mod set_identity_mail_from_domain_input {
    /// A builder for [`SetIdentityMailFromDomainInput`](crate::input::SetIdentityMailFromDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) mail_from_domain: std::option::Option<std::string::String>,
        pub(crate) behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
    }
    impl Builder {
        /// <p>The verified identity for which you want to enable or disable the specified custom
        /// MAIL FROM domain.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The verified identity for which you want to enable or disable the specified custom
        /// MAIL FROM domain.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
        /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
        /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
        /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
        /// FROM setting for the identity.</p>
        pub fn mail_from_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.mail_from_domain = Some(input.into());
            self
        }
        /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
        /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
        /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
        /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
        /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
        /// FROM setting for the identity.</p>
        pub fn set_mail_from_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mail_from_domain = input;
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
        /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
        /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
        /// <code>RejectMessage</code>, Amazon SES will return a
        /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
        /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
        /// <code>TemporaryFailure</code> states.</p>
        pub fn behavior_on_mx_failure(mut self, input: crate::model::BehaviorOnMxFailure) -> Self {
            self.behavior_on_mx_failure = Some(input);
            self
        }
        /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
        /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
        /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
        /// <code>RejectMessage</code>, Amazon SES will return a
        /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
        /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
        /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
        /// <code>TemporaryFailure</code> states.</p>
        pub fn set_behavior_on_mx_failure(
            mut self,
            input: std::option::Option<crate::model::BehaviorOnMxFailure>,
        ) -> Self {
            self.behavior_on_mx_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityMailFromDomainInput`](crate::input::SetIdentityMailFromDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityMailFromDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityMailFromDomainInput {
                identity: self.identity,
                mail_from_domain: self.mail_from_domain,
                behavior_on_mx_failure: self.behavior_on_mx_failure,
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityMailFromDomainInputOperationOutputAlias =
    crate::operation::SetIdentityMailFromDomain;
#[doc(hidden)]
pub type SetIdentityMailFromDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIdentityMailFromDomainInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityMailFromDomain`](crate::operation::SetIdentityMailFromDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityMailFromDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityMailFromDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityMailFromDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityMailFromDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_mail_from_domain(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityMailFromDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityMailFromDomain",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityMailFromDomainInput`](crate::input::SetIdentityMailFromDomainInput)
    pub fn builder() -> crate::input::set_identity_mail_from_domain_input::Builder {
        crate::input::set_identity_mail_from_domain_input::Builder::default()
    }
}

/// See [`SetIdentityNotificationTopicInput`](crate::input::SetIdentityNotificationTopicInput)
pub mod set_identity_notification_topic_input {
    /// A builder for [`SetIdentityNotificationTopicInput`](crate::input::SetIdentityNotificationTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
        pub(crate) sns_topic: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
        /// for.</p>
        /// <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn identity(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity = Some(input.into());
            self
        }
        /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
        /// for.</p>
        /// <important>
        /// <p>You can only specify a verified identity for this parameter.</p>
        /// </important>
        /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
        /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
        /// <code>example.com</code>,
        /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
        pub fn set_identity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
        /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
        /// is disabled.</p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
        /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
        /// is disabled.</p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// Consumes the builder and constructs a [`SetIdentityNotificationTopicInput`](crate::input::SetIdentityNotificationTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetIdentityNotificationTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetIdentityNotificationTopicInput {
                identity: self.identity,
                notification_type: self.notification_type,
                sns_topic: self.sns_topic,
            })
        }
    }
}
#[doc(hidden)]
pub type SetIdentityNotificationTopicInputOperationOutputAlias =
    crate::operation::SetIdentityNotificationTopic;
#[doc(hidden)]
pub type SetIdentityNotificationTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetIdentityNotificationTopicInput {
    /// Consumes the builder and constructs an Operation<[`SetIdentityNotificationTopic`](crate::operation::SetIdentityNotificationTopic)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetIdentityNotificationTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetIdentityNotificationTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetIdentityNotificationTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetIdentityNotificationTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_identity_notification_topic(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetIdentityNotificationTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetIdentityNotificationTopic",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetIdentityNotificationTopicInput`](crate::input::SetIdentityNotificationTopicInput)
    pub fn builder() -> crate::input::set_identity_notification_topic_input::Builder {
        crate::input::set_identity_notification_topic_input::Builder::default()
    }
}

/// See [`SetReceiptRulePositionInput`](crate::input::SetReceiptRulePositionInput)
pub mod set_receipt_rule_position_input {
    /// A builder for [`SetReceiptRulePositionInput`](crate::input::SetReceiptRulePositionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) after: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule to reposition.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn after(mut self, input: impl Into<std::string::String>) -> Self {
            self.after = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
        pub fn set_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.after = input;
            self
        }
        /// Consumes the builder and constructs a [`SetReceiptRulePositionInput`](crate::input::SetReceiptRulePositionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetReceiptRulePositionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetReceiptRulePositionInput {
                rule_set_name: self.rule_set_name,
                rule_name: self.rule_name,
                after: self.after,
            })
        }
    }
}
#[doc(hidden)]
pub type SetReceiptRulePositionInputOperationOutputAlias = crate::operation::SetReceiptRulePosition;
#[doc(hidden)]
pub type SetReceiptRulePositionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetReceiptRulePositionInput {
    /// Consumes the builder and constructs an Operation<[`SetReceiptRulePosition`](crate::operation::SetReceiptRulePosition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetReceiptRulePosition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetReceiptRulePositionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetReceiptRulePositionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetReceiptRulePositionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_receipt_rule_position(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetReceiptRulePosition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetReceiptRulePosition",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetReceiptRulePositionInput`](crate::input::SetReceiptRulePositionInput)
    pub fn builder() -> crate::input::set_receipt_rule_position_input::Builder {
        crate::input::set_receipt_rule_position_input::Builder::default()
    }
}

/// See [`TestRenderTemplateInput`](crate::input::TestRenderTemplateInput)
pub mod test_render_template_input {
    /// A builder for [`TestRenderTemplateInput`](crate::input::TestRenderTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template that you want to render.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the template that you want to render.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_data = Some(input.into());
            self
        }
        /// <p>A list of replacement values to apply to the template. This parameter is a JSON
        /// object, typically consisting of key-value pairs in which the keys correspond to
        /// replacement tags in the email template.</p>
        pub fn set_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRenderTemplateInput`](crate::input::TestRenderTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestRenderTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestRenderTemplateInput {
                template_name: self.template_name,
                template_data: self.template_data,
            })
        }
    }
}
#[doc(hidden)]
pub type TestRenderTemplateInputOperationOutputAlias = crate::operation::TestRenderTemplate;
#[doc(hidden)]
pub type TestRenderTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestRenderTemplateInput {
    /// Consumes the builder and constructs an Operation<[`TestRenderTemplate`](crate::operation::TestRenderTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestRenderTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestRenderTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestRenderTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestRenderTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_render_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestRenderTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestRenderTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestRenderTemplateInput`](crate::input::TestRenderTemplateInput)
    pub fn builder() -> crate::input::test_render_template_input::Builder {
        crate::input::test_render_template_input::Builder::default()
    }
}

/// See [`UpdateAccountSendingEnabledInput`](crate::input::UpdateAccountSendingEnabledInput)
pub mod update_account_sending_enabled_input {
    /// A builder for [`UpdateAccountSendingEnabledInput`](crate::input::UpdateAccountSendingEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
        /// current AWS Region.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccountSendingEnabledInput`](crate::input::UpdateAccountSendingEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccountSendingEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccountSendingEnabledInput {
                enabled: self.enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccountSendingEnabledInputOperationOutputAlias =
    crate::operation::UpdateAccountSendingEnabled;
#[doc(hidden)]
pub type UpdateAccountSendingEnabledInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAccountSendingEnabledInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccountSendingEnabled`](crate::operation::UpdateAccountSendingEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccountSendingEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccountSendingEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccountSendingEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccountSendingEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_account_sending_enabled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccountSendingEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccountSendingEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccountSendingEnabledInput`](crate::input::UpdateAccountSendingEnabledInput)
    pub fn builder() -> crate::input::update_account_sending_enabled_input::Builder {
        crate::input::update_account_sending_enabled_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
pub mod update_configuration_set_event_destination_input {
    /// A builder for [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination: std::option::Option<crate::model::EventDestination>,
    }
    impl Builder {
        /// <p>The name of the configuration set that contains the event destination that you want to
        /// update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that contains the event destination that you want to
        /// update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration
        /// set.</p>
        pub fn event_destination(mut self, input: crate::model::EventDestination) -> Self {
            self.event_destination = Some(input);
            self
        }
        /// <p>The event destination object that you want to apply to the specified configuration
        /// set.</p>
        pub fn set_event_destination(
            mut self,
            input: std::option::Option<crate::model::EventDestination>,
        ) -> Self {
            self.event_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetEventDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationSetEventDestinationInput {
                configuration_set_name: self.configuration_set_name,
                event_destination: self.event_destination,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetEventDestination;
#[doc(hidden)]
pub type UpdateConfigurationSetEventDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateConfigurationSetEventDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetEventDestination`](crate::operation::UpdateConfigurationSetEventDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetEventDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationSetEventDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationSetEventDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationSetEventDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_event_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetEventDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetEventDestination",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetEventDestinationInput`](crate::input::UpdateConfigurationSetEventDestinationInput)
    pub fn builder() -> crate::input::update_configuration_set_event_destination_input::Builder {
        crate::input::update_configuration_set_event_destination_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetReputationMetricsEnabledInput`](crate::input::UpdateConfigurationSetReputationMetricsEnabledInput)
pub mod update_configuration_set_reputation_metrics_enabled_input {
    /// A builder for [`UpdateConfigurationSetReputationMetricsEnabledInput`](crate::input::UpdateConfigurationSetReputationMetricsEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
        /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
        /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetReputationMetricsEnabledInput`](crate::input::UpdateConfigurationSetReputationMetricsEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetReputationMetricsEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::UpdateConfigurationSetReputationMetricsEnabledInput {
                    configuration_set_name: self.configuration_set_name,
                    enabled: self.enabled.unwrap_or_default(),
                },
            )
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetReputationMetricsEnabledInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetReputationMetricsEnabled;
#[doc(hidden)]
pub type UpdateConfigurationSetReputationMetricsEnabledInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateConfigurationSetReputationMetricsEnabledInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetReputationMetricsEnabled`](crate::operation::UpdateConfigurationSetReputationMetricsEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetReputationMetricsEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationSetReputationMetricsEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationSetReputationMetricsEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationSetReputationMetricsEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_reputation_metrics_enabled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetReputationMetricsEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetReputationMetricsEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetReputationMetricsEnabledInput`](crate::input::UpdateConfigurationSetReputationMetricsEnabledInput)
    pub fn builder(
    ) -> crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder {
        crate::input::update_configuration_set_reputation_metrics_enabled_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetSendingEnabledInput`](crate::input::UpdateConfigurationSetSendingEnabledInput)
pub mod update_configuration_set_sending_enabled_input {
    /// A builder for [`UpdateConfigurationSetSendingEnabledInput`](crate::input::UpdateConfigurationSetSendingEnabledInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set that you want to update.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set.
        /// </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Describes whether email sending is enabled or disabled for the configuration set.
        /// </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetSendingEnabledInput`](crate::input::UpdateConfigurationSetSendingEnabledInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetSendingEnabledInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationSetSendingEnabledInput {
                configuration_set_name: self.configuration_set_name,
                enabled: self.enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetSendingEnabledInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetSendingEnabled;
#[doc(hidden)]
pub type UpdateConfigurationSetSendingEnabledInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateConfigurationSetSendingEnabledInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetSendingEnabled`](crate::operation::UpdateConfigurationSetSendingEnabled)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetSendingEnabled,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationSetSendingEnabledInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationSetSendingEnabledInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationSetSendingEnabledInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_sending_enabled(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetSendingEnabled::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetSendingEnabled",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetSendingEnabledInput`](crate::input::UpdateConfigurationSetSendingEnabledInput)
    pub fn builder() -> crate::input::update_configuration_set_sending_enabled_input::Builder {
        crate::input::update_configuration_set_sending_enabled_input::Builder::default()
    }
}

/// See [`UpdateConfigurationSetTrackingOptionsInput`](crate::input::UpdateConfigurationSetTrackingOptionsInput)
pub mod update_configuration_set_tracking_options_input {
    /// A builder for [`UpdateConfigurationSetTrackingOptionsInput`](crate::input::UpdateConfigurationSetTrackingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) tracking_options: std::option::Option<crate::model::TrackingOptions>,
    }
    impl Builder {
        /// <p>The name of the configuration set for which you want to update the custom tracking
        /// domain.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set for which you want to update the custom tracking
        /// domain.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn tracking_options(mut self, input: crate::model::TrackingOptions) -> Self {
            self.tracking_options = Some(input);
            self
        }
        /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
        /// domain captures open and click events generated by Amazon SES emails.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
        /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_tracking_options(
            mut self,
            input: std::option::Option<crate::model::TrackingOptions>,
        ) -> Self {
            self.tracking_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigurationSetTrackingOptionsInput`](crate::input::UpdateConfigurationSetTrackingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigurationSetTrackingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigurationSetTrackingOptionsInput {
                configuration_set_name: self.configuration_set_name,
                tracking_options: self.tracking_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigurationSetTrackingOptionsInputOperationOutputAlias =
    crate::operation::UpdateConfigurationSetTrackingOptions;
#[doc(hidden)]
pub type UpdateConfigurationSetTrackingOptionsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateConfigurationSetTrackingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfigurationSetTrackingOptions`](crate::operation::UpdateConfigurationSetTrackingOptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfigurationSetTrackingOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigurationSetTrackingOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigurationSetTrackingOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigurationSetTrackingOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_configuration_set_tracking_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfigurationSetTrackingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfigurationSetTrackingOptions",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigurationSetTrackingOptionsInput`](crate::input::UpdateConfigurationSetTrackingOptionsInput)
    pub fn builder() -> crate::input::update_configuration_set_tracking_options_input::Builder {
        crate::input::update_configuration_set_tracking_options_input::Builder::default()
    }
}

/// See [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
pub mod update_custom_verification_email_template_input {
    /// A builder for [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) template_subject: std::option::Option<std::string::String>,
        pub(crate) template_content: std::option::Option<std::string::String>,
        pub(crate) success_redirection_url: std::option::Option<std::string::String>,
        pub(crate) failure_redirection_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the custom verification email template that you want to update.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>The email address that the custom verification email is sent from.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn template_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_subject = Some(input.into());
            self
        }
        /// <p>The subject line of the custom verification email.</p>
        pub fn set_template_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_subject = input;
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn template_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_content = Some(input.into());
            self
        }
        /// <p>The content of the custom verification email. The total size of the email must be less
        /// than 10 MB. The message body may contain HTML, with some limitations. For more
        /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
        /// Developer Guide</i>.</p>
        pub fn set_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_content = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn success_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is successfully verified.</p>
        pub fn set_success_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_redirection_url = input;
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn failure_redirection_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_redirection_url = Some(input.into());
            self
        }
        /// <p>The URL that the recipient of the verification email is sent to if his or her address
        /// is not successfully verified.</p>
        pub fn set_failure_redirection_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_redirection_url = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomVerificationEmailTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCustomVerificationEmailTemplateInput {
                template_name: self.template_name,
                from_email_address: self.from_email_address,
                template_subject: self.template_subject,
                template_content: self.template_content,
                success_redirection_url: self.success_redirection_url,
                failure_redirection_url: self.failure_redirection_url,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomVerificationEmailTemplateInputOperationOutputAlias =
    crate::operation::UpdateCustomVerificationEmailTemplate;
#[doc(hidden)]
pub type UpdateCustomVerificationEmailTemplateInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateCustomVerificationEmailTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomVerificationEmailTemplate`](crate::operation::UpdateCustomVerificationEmailTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomVerificationEmailTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCustomVerificationEmailTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCustomVerificationEmailTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCustomVerificationEmailTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_custom_verification_email_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomVerificationEmailTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomVerificationEmailTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomVerificationEmailTemplateInput`](crate::input::UpdateCustomVerificationEmailTemplateInput)
    pub fn builder() -> crate::input::update_custom_verification_email_template_input::Builder {
        crate::input::update_custom_verification_email_template_input::Builder::default()
    }
}

/// See [`UpdateReceiptRuleInput`](crate::input::UpdateReceiptRuleInput)
pub mod update_receipt_rule_input {
    /// A builder for [`UpdateReceiptRuleInput`](crate::input::UpdateReceiptRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_set_name: std::option::Option<std::string::String>,
        pub(crate) rule: std::option::Option<crate::model::ReceiptRule>,
    }
    impl Builder {
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn rule_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_set_name = Some(input.into());
            self
        }
        /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
        pub fn set_rule_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_set_name = input;
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn rule(mut self, input: crate::model::ReceiptRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>A data structure that contains the updated receipt rule information.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::ReceiptRule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReceiptRuleInput`](crate::input::UpdateReceiptRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReceiptRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReceiptRuleInput {
                rule_set_name: self.rule_set_name,
                rule: self.rule,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReceiptRuleInputOperationOutputAlias = crate::operation::UpdateReceiptRule;
#[doc(hidden)]
pub type UpdateReceiptRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateReceiptRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReceiptRule`](crate::operation::UpdateReceiptRule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReceiptRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReceiptRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReceiptRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReceiptRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_receipt_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReceiptRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReceiptRule",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReceiptRuleInput`](crate::input::UpdateReceiptRuleInput)
    pub fn builder() -> crate::input::update_receipt_rule_input::Builder {
        crate::input::update_receipt_rule_input::Builder::default()
    }
}

/// See [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
pub mod update_template_input {
    /// A builder for [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<crate::model::Template>,
    }
    impl Builder {
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn template(mut self, input: crate::model::Template) -> Self {
            self.template = Some(input);
            self
        }
        /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
        /// part.</p>
        pub fn set_template(mut self, input: std::option::Option<crate::model::Template>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTemplateInput {
                template: self.template,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTemplateInputOperationOutputAlias = crate::operation::UpdateTemplate;
#[doc(hidden)]
pub type UpdateTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTemplate`](crate::operation::UpdateTemplate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_template(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTemplate",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTemplateInput`](crate::input::UpdateTemplateInput)
    pub fn builder() -> crate::input::update_template_input::Builder {
        crate::input::update_template_input::Builder::default()
    }
}

/// See [`VerifyDomainDkimInput`](crate::input::VerifyDomainDkimInput)
pub mod verify_domain_dkim_input {
    /// A builder for [`VerifyDomainDkimInput`](crate::input::VerifyDomainDkimInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyDomainDkimInput`](crate::input::VerifyDomainDkimInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyDomainDkimInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyDomainDkimInput {
                domain: self.domain,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyDomainDkimInputOperationOutputAlias = crate::operation::VerifyDomainDkim;
#[doc(hidden)]
pub type VerifyDomainDkimInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifyDomainDkimInput {
    /// Consumes the builder and constructs an Operation<[`VerifyDomainDkim`](crate::operation::VerifyDomainDkim)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyDomainDkim,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifyDomainDkimInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifyDomainDkimInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifyDomainDkimInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_verify_domain_dkim(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyDomainDkim::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyDomainDkim",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifyDomainDkimInput`](crate::input::VerifyDomainDkimInput)
    pub fn builder() -> crate::input::verify_domain_dkim_input::Builder {
        crate::input::verify_domain_dkim_input::Builder::default()
    }
}

/// See [`VerifyDomainIdentityInput`](crate::input::VerifyDomainIdentityInput)
pub mod verify_domain_identity_input {
    /// A builder for [`VerifyDomainIdentityInput`](crate::input::VerifyDomainIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain to be verified.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain to be verified.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyDomainIdentityInput`](crate::input::VerifyDomainIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyDomainIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyDomainIdentityInput {
                domain: self.domain,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyDomainIdentityInputOperationOutputAlias = crate::operation::VerifyDomainIdentity;
#[doc(hidden)]
pub type VerifyDomainIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifyDomainIdentityInput {
    /// Consumes the builder and constructs an Operation<[`VerifyDomainIdentity`](crate::operation::VerifyDomainIdentity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyDomainIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifyDomainIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifyDomainIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifyDomainIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_verify_domain_identity(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyDomainIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyDomainIdentity",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifyDomainIdentityInput`](crate::input::VerifyDomainIdentityInput)
    pub fn builder() -> crate::input::verify_domain_identity_input::Builder {
        crate::input::verify_domain_identity_input::Builder::default()
    }
}

/// See [`VerifyEmailAddressInput`](crate::input::VerifyEmailAddressInput)
pub mod verify_email_address_input {
    /// A builder for [`VerifyEmailAddressInput`](crate::input::VerifyEmailAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyEmailAddressInput`](crate::input::VerifyEmailAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyEmailAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyEmailAddressInput {
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyEmailAddressInputOperationOutputAlias = crate::operation::VerifyEmailAddress;
#[doc(hidden)]
pub type VerifyEmailAddressInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifyEmailAddressInput {
    /// Consumes the builder and constructs an Operation<[`VerifyEmailAddress`](crate::operation::VerifyEmailAddress)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyEmailAddress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifyEmailAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifyEmailAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifyEmailAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_verify_email_address(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyEmailAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyEmailAddress",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifyEmailAddressInput`](crate::input::VerifyEmailAddressInput)
    pub fn builder() -> crate::input::verify_email_address_input::Builder {
        crate::input::verify_email_address_input::Builder::default()
    }
}

/// See [`VerifyEmailIdentityInput`](crate::input::VerifyEmailIdentityInput)
pub mod verify_email_identity_input {
    /// A builder for [`VerifyEmailIdentityInput`](crate::input::VerifyEmailIdentityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email address to be verified.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address to be verified.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifyEmailIdentityInput`](crate::input::VerifyEmailIdentityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifyEmailIdentityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifyEmailIdentityInput {
                email_address: self.email_address,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifyEmailIdentityInputOperationOutputAlias = crate::operation::VerifyEmailIdentity;
#[doc(hidden)]
pub type VerifyEmailIdentityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifyEmailIdentityInput {
    /// Consumes the builder and constructs an Operation<[`VerifyEmailIdentity`](crate::operation::VerifyEmailIdentity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifyEmailIdentity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifyEmailIdentityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifyEmailIdentityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifyEmailIdentityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_verify_email_identity(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifyEmailIdentity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifyEmailIdentity",
            "ses",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifyEmailIdentityInput`](crate::input::VerifyEmailIdentityInput)
    pub fn builder() -> crate::input::verify_email_identity_input::Builder {
        crate::input::verify_email_identity_input::Builder::default()
    }
}

/// <p>Represents a request to begin email address verification with Amazon SES. For information
/// about email address verification, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyEmailIdentityInput {
    /// <p>The email address to be verified.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl VerifyEmailIdentityInput {
    /// <p>The email address to be verified.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for VerifyEmailIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyEmailIdentityInput");
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>Represents a request to begin email address verification with Amazon SES. For information
/// about email address verification, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyEmailAddressInput {
    /// <p>The email address to be verified.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl VerifyEmailAddressInput {
    /// <p>The email address to be verified.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for VerifyEmailAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyEmailAddressInput");
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>Represents a request to begin Amazon SES domain verification and to generate the TXT
/// records that you must publish to the DNS server of your domain to complete the
/// verification. For information about domain verification, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyDomainIdentityInput {
    /// <p>The domain to be verified.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl VerifyDomainIdentityInput {
    /// <p>The domain to be verified.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for VerifyDomainIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyDomainIdentityInput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}

/// <p>Represents a request to generate the CNAME records needed to set up Easy DKIM with
/// Amazon SES. For more information about setting up Easy DKIM, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifyDomainDkimInput {
    /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl VerifyDomainDkimInput {
    /// <p>The name of the domain to be verified for Easy DKIM signing.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl std::fmt::Debug for VerifyDomainDkimInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifyDomainDkimInput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTemplateInput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub template: std::option::Option<crate::model::Template>,
}
impl UpdateTemplateInput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
}
impl std::fmt::Debug for UpdateTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTemplateInput");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}

/// <p>Represents a request to update a receipt rule. You use receipt rules to receive email
/// with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReceiptRuleInput {
    /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>A data structure that contains the updated receipt rule information.</p>
    pub rule: std::option::Option<crate::model::ReceiptRule>,
}
impl UpdateReceiptRuleInput {
    /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>A data structure that contains the updated receipt rule information.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::ReceiptRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for UpdateReceiptRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReceiptRuleInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}

/// <p>Represents a request to update an existing custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to update.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The content of the custom verification email. The total size of the email must be less
    /// than 10 MB. The message body may contain HTML, with some limitations. For more
    /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub template_content: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl UpdateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to update.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The content of the custom verification email. The total size of the email must be less
    /// than 10 MB. The message body may contain HTML, with some limitations. For more
    /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub fn template_content(&self) -> std::option::Option<&str> {
        self.template_content.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for UpdateCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("template_content", &self.template_content);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}

/// <p>Represents a request to update the tracking options for a configuration set. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set for which you want to update the custom tracking
    /// domain.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
    /// domain captures open and click events generated by Amazon SES emails.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
    /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub tracking_options: std::option::Option<crate::model::TrackingOptions>,
}
impl UpdateConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set for which you want to update the custom tracking
    /// domain.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
    /// domain captures open and click events generated by Amazon SES emails.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
    /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub fn tracking_options(&self) -> std::option::Option<&crate::model::TrackingOptions> {
        self.tracking_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateConfigurationSetTrackingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetTrackingOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tracking_options", &self.tracking_options);
        formatter.finish()
    }
}

/// <p>Represents a request to enable or disable the email sending capabilities for a
/// specific configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetSendingEnabledInput {
    /// <p>The name of the configuration set that you want to update.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Describes whether email sending is enabled or disabled for the configuration set.
    /// </p>
    pub enabled: bool,
}
impl UpdateConfigurationSetSendingEnabledInput {
    /// <p>The name of the configuration set that you want to update.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>Describes whether email sending is enabled or disabled for the configuration set.
    /// </p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateConfigurationSetSendingEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetSendingEnabledInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

/// <p>Represents a request to modify the reputation metric publishing settings for a
/// configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetReputationMetricsEnabledInput {
    /// <p>The name of the configuration set that you want to update.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
    /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
    pub enabled: bool,
}
impl UpdateConfigurationSetReputationMetricsEnabledInput {
    /// <p>The name of the configuration set that you want to update.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>Describes whether or not Amazon SES will publish reputation metrics for the configuration
    /// set, such as bounce and complaint rates, to Amazon CloudWatch.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateConfigurationSetReputationMetricsEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetReputationMetricsEnabledInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

/// <p>Represents a request to update the event destination of a configuration set.
/// Configuration sets enable you to publish email sending events. For information about
/// using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination that you want to
    /// update.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The event destination object that you want to apply to the specified configuration
    /// set.</p>
    pub event_destination: std::option::Option<crate::model::EventDestination>,
}
impl UpdateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that contains the event destination that you want to
    /// update.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The event destination object that you want to apply to the specified configuration
    /// set.</p>
    pub fn event_destination(&self) -> std::option::Option<&crate::model::EventDestination> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for UpdateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}

/// <p>Represents a request to enable or disable the email sending capabilities for your
/// entire Amazon SES account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountSendingEnabledInput {
    /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
    /// current AWS Region.</p>
    pub enabled: bool,
}
impl UpdateAccountSendingEnabledInput {
    /// <p>Describes whether email sending is enabled or disabled for your Amazon SES account in the
    /// current AWS Region.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateAccountSendingEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountSendingEnabledInput");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRenderTemplateInput {
    /// <p>The name of the template that you want to render.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub template_data: std::option::Option<std::string::String>,
}
impl TestRenderTemplateInput {
    /// <p>The name of the template that you want to render.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub fn template_data(&self) -> std::option::Option<&str> {
        self.template_data.as_deref()
    }
}
impl std::fmt::Debug for TestRenderTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRenderTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_data", &self.template_data);
        formatter.finish()
    }
}

/// <p>Represents a request to set the position of a receipt rule in a receipt rule set. You
/// use receipt rule sets to receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetReceiptRulePositionInput {
    /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the receipt rule to reposition.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
    pub after: std::option::Option<std::string::String>,
}
impl SetReceiptRulePositionInput {
    /// <p>The name of the receipt rule set that contains the receipt rule to reposition.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The name of the receipt rule to reposition.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The name of the receipt rule after which to place the specified receipt rule.</p>
    pub fn after(&self) -> std::option::Option<&str> {
        self.after.as_deref()
    }
}
impl std::fmt::Debug for SetReceiptRulePositionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetReceiptRulePositionInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("after", &self.after);
        formatter.finish()
    }
}

/// <p>Represents a request to specify the Amazon SNS topic to which Amazon SES will publish bounce,
/// complaint, or delivery notifications for emails sent with that identity as the Source.
/// For information about Amazon SES notifications, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityNotificationTopicInput {
    /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
    /// for.</p>
    /// <important>
    /// <p>You can only specify a verified identity for this parameter.</p>
    /// </important>
    /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
    /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
    /// <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
    /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
    /// is disabled.</p>
    pub sns_topic: std::option::Option<std::string::String>,
}
impl SetIdentityNotificationTopicInput {
    /// <p>The identity (email address or domain) that you want to set the Amazon SNS topic
    /// for.</p>
    /// <important>
    /// <p>You can only specify a verified identity for this parameter.</p>
    /// </important>
    /// <p>You can specify an identity by using its name or by using its Amazon Resource Name
    /// (ARN). The following examples are all valid identities: <code>sender@example.com</code>,
    /// <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The type of notifications that will be published to the specified Amazon SNS topic.</p>
    pub fn notification_type(&self) -> std::option::Option<&crate::model::NotificationType> {
        self.notification_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter is omitted from
    /// the request or a null value is passed, <code>SnsTopic</code> is cleared and publishing
    /// is disabled.</p>
    pub fn sns_topic(&self) -> std::option::Option<&str> {
        self.sns_topic.as_deref()
    }
}
impl std::fmt::Debug for SetIdentityNotificationTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityNotificationTopicInput");
        formatter.field("identity", &self.identity);
        formatter.field("notification_type", &self.notification_type);
        formatter.field("sns_topic", &self.sns_topic);
        formatter.finish()
    }
}

/// <p>Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for
/// a verified identity. For information about using a custom MAIL FROM domain, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityMailFromDomainInput {
    /// <p>The verified identity for which you want to enable or disable the specified custom
    /// MAIL FROM domain.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
    /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
    /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
    /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
    /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
    /// FROM setting for the identity.</p>
    pub mail_from_domain: std::option::Option<std::string::String>,
    /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
    /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
    /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
    /// <code>RejectMessage</code>, Amazon SES will return a
    /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
    /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
    /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
    /// <code>TemporaryFailure</code> states.</p>
    pub behavior_on_mx_failure: std::option::Option<crate::model::BehaviorOnMxFailure>,
}
impl SetIdentityMailFromDomainInput {
    /// <p>The verified identity for which you want to enable or disable the specified custom
    /// MAIL FROM domain.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM
    /// domain must 1) be a subdomain of the verified identity, 2) not be used in a "From"
    /// address if the MAIL FROM domain is the destination of email feedback forwarding (for
    /// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
    /// 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
    /// FROM setting for the identity.</p>
    pub fn mail_from_domain(&self) -> std::option::Option<&str> {
        self.mail_from_domain.as_deref()
    }
    /// <p>The action that you want Amazon SES to take if it cannot successfully read the required MX
    /// record when you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will
    /// use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose
    /// <code>RejectMessage</code>, Amazon SES will return a
    /// <code>MailFromDomainNotVerified</code> error and not send the email.</p>
    /// <p>The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL
    /// FROM domain setup is in the <code>Pending</code>, <code>Failed</code>, and
    /// <code>TemporaryFailure</code> states.</p>
    pub fn behavior_on_mx_failure(
        &self,
    ) -> std::option::Option<&crate::model::BehaviorOnMxFailure> {
        self.behavior_on_mx_failure.as_ref()
    }
}
impl std::fmt::Debug for SetIdentityMailFromDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityMailFromDomainInput");
        formatter.field("identity", &self.identity);
        formatter.field("mail_from_domain", &self.mail_from_domain);
        formatter.field("behavior_on_mx_failure", &self.behavior_on_mx_failure);
        formatter.finish()
    }
}

/// <p>Represents a request to set whether Amazon SES includes the original email headers in the
/// Amazon SNS notifications of a specified type. For information about notifications, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityHeadersInNotificationsEnabledInput {
    /// <p>The identity for which to enable or disable headers in notifications. Examples:
    /// <code>user@example.com</code>, <code>example.com</code>.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The notification type for which to enable or disable headers in notifications. </p>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
    /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
    /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
    /// will not include headers in notifications.</p>
    /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
    /// particular Amazon SNS topic.</p>
    pub enabled: bool,
}
impl SetIdentityHeadersInNotificationsEnabledInput {
    /// <p>The identity for which to enable or disable headers in notifications. Examples:
    /// <code>user@example.com</code>, <code>example.com</code>.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The notification type for which to enable or disable headers in notifications. </p>
    pub fn notification_type(&self) -> std::option::Option<&crate::model::NotificationType> {
        self.notification_type.as_ref()
    }
    /// <p>Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
    /// specified notification type. A value of <code>true</code> specifies that Amazon SES will
    /// include headers in notifications, and a value of <code>false</code> specifies that Amazon SES
    /// will not include headers in notifications.</p>
    /// <p>This value can only be set when <code>NotificationType</code> is already set to use a
    /// particular Amazon SNS topic.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for SetIdentityHeadersInNotificationsEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityHeadersInNotificationsEnabledInput");
        formatter.field("identity", &self.identity);
        formatter.field("notification_type", &self.notification_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

/// <p>Represents a request to enable or disable whether Amazon SES forwards you bounce and
/// complaint notifications through email. For information about email feedback forwarding,
/// see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityFeedbackForwardingEnabledInput {
    /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
    /// <code>user@example.com</code>, <code>example.com</code>.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
    /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
    /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
    /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
    /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
    /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
    /// notification types.</p>
    pub forwarding_enabled: bool,
}
impl SetIdentityFeedbackForwardingEnabledInput {
    /// <p>The identity for which to set bounce and complaint notification forwarding. Examples:
    /// <code>user@example.com</code>, <code>example.com</code>.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>Sets whether Amazon SES will forward bounce and complaint notifications as email.
    /// <code>true</code> specifies that Amazon SES will forward bounce and complaint
    /// notifications as email, in addition to any Amazon SNS topic publishing otherwise specified.
    /// <code>false</code> specifies that Amazon SES will publish bounce and complaint
    /// notifications only through Amazon SNS. This value can only be set to <code>false</code> when
    /// Amazon SNS topics are set for both <code>Bounce</code> and <code>Complaint</code>
    /// notification types.</p>
    pub fn forwarding_enabled(&self) -> bool {
        self.forwarding_enabled
    }
}
impl std::fmt::Debug for SetIdentityFeedbackForwardingEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityFeedbackForwardingEnabledInput");
        formatter.field("identity", &self.identity);
        formatter.field("forwarding_enabled", &self.forwarding_enabled);
        formatter.finish()
    }
}

/// <p>Represents a request to enable or disable Amazon SES Easy DKIM signing for an identity. For
/// more information about setting up Easy DKIM, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetIdentityDkimEnabledInput {
    /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
    /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
    pub dkim_enabled: bool,
}
impl SetIdentityDkimEnabledInput {
    /// <p>The identity for which DKIM signing should be enabled or disabled.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>Sets whether DKIM signing is enabled for an identity. Set to <code>true</code> to
    /// enable DKIM signing for this identity; <code>false</code> to disable it. </p>
    pub fn dkim_enabled(&self) -> bool {
        self.dkim_enabled
    }
}
impl std::fmt::Debug for SetIdentityDkimEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetIdentityDkimEnabledInput");
        formatter.field("identity", &self.identity);
        formatter.field("dkim_enabled", &self.dkim_enabled);
        formatter.finish()
    }
}

/// <p>Represents a request to set a receipt rule set as the active receipt rule set. You use
/// receipt rule sets to receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetActiveReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to make active. Setting this value to null disables
    /// all email receiving.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
}
impl SetActiveReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to make active. Setting this value to null disables
    /// all email receiving.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
}
impl std::fmt::Debug for SetActiveReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetActiveReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to send a templated email using Amazon SES. For more information, see
/// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendTemplatedEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub source: std::option::Option<std::string::String>,
    /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
    /// can include up to 50 recipients across these three fields.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub return_path: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub return_path_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
    /// that you define, so that you can publish email sending events.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendTemplatedEmail</code>.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The template to use when sending this email.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The ARN of the template to use when sending this email.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub template_data: std::option::Option<std::string::String>,
}
impl SendTemplatedEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in<a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The destination for this email, composed of To:, CC:, and BCC: fields. A Destination
    /// can include up to 50 recipients across these three fields.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub fn reply_to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.reply_to_addresses.as_deref()
    }
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub fn return_path(&self) -> std::option::Option<&str> {
        self.return_path.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn return_path_arn(&self) -> std::option::Option<&str> {
        self.return_path_arn.as_deref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendTemplatedEmail</code>. Tags correspond to characteristics of the email
    /// that you define, so that you can publish email sending events.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendTemplatedEmail</code>.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The template to use when sending this email.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The ARN of the template to use when sending this email.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>A list of replacement values to apply to the template. This parameter is a JSON
    /// object, typically consisting of key-value pairs in which the keys correspond to
    /// replacement tags in the email template.</p>
    pub fn template_data(&self) -> std::option::Option<&str> {
        self.template_data.as_deref()
    }
}
impl std::fmt::Debug for SendTemplatedEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendTemplatedEmailInput");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("reply_to_addresses", &self.reply_to_addresses);
        formatter.field("return_path", &self.return_path);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("return_path_arn", &self.return_path_arn);
        formatter.field("tags", &self.tags);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("template", &self.template);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_data", &self.template_data);
        formatter.finish()
    }
}

/// <p>Represents a request to send a single raw email using Amazon SES. For more information, see
/// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendRawEmailInput {
    /// <p>The identity's email address. If you do not provide a value for this parameter, you
    /// must specify a "From" address in the raw text of the message. (You can also specify
    /// both.)</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    ///
    /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
    /// then bounces and complaints will be sent to this email address. This takes precedence
    /// over any Return-Path header that you might include in the raw text of the
    /// message.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
    /// addresses.</p>
    pub destinations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The raw email message itself. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by a blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
    /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
    /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>The entire message must be base64-encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, we highly recommend that you encode that
    /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
    /// 5321</a>, the maximum length of each line of text, including the
    /// <CRLF>, must not exceed 1,000 characters.</p>
    /// </li>
    /// </ul>
    pub raw_message: std::option::Option<crate::model::RawMessage>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to specify a
    /// particular "From" address in the header of the raw email.</p>
    /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
    /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
    /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
    /// parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub from_arn: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>Instead of using this parameter, you can use the X-header
    /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
    /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
    /// value of the <code>SourceArn</code> parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>Instead of using this parameter, you can use the X-header
    /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
    /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
    /// value of the <code>ReturnPathArn</code> parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub return_path_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
    /// you define, so that you can publish email sending events.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendRawEmail</code>.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl SendRawEmailInput {
    /// <p>The identity's email address. If you do not provide a value for this parameter, you
    /// must specify a "From" address in the raw text of the message. (You can also specify
    /// both.)</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in<a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    ///
    /// <p>If you specify the <code>Source</code> parameter and have feedback forwarding enabled,
    /// then bounces and complaints will be sent to this email address. This takes precedence
    /// over any Return-Path header that you might include in the raw text of the
    /// message.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>A list of destinations for the message, consisting of To:, CC:, and BCC:
    /// addresses.</p>
    pub fn destinations(&self) -> std::option::Option<&[std::string::String]> {
        self.destinations.as_deref()
    }
    /// <p>The raw email message itself. The message has to meet the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>The message has to contain a header and a body, separated by a blank
    /// line.</p>
    /// </li>
    /// <li>
    /// <p>All of the required header fields must be present in the message.</p>
    /// </li>
    /// <li>
    /// <p>Each part of a multipart MIME message must be formatted properly.</p>
    /// </li>
    /// <li>
    /// <p>Attachments must be of a content type that Amazon SES supports. For a list on
    /// unsupported content types, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html">Unsupported Attachment
    /// Types</a> in the <i>Amazon SES Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>The entire message must be base64-encoded.</p>
    /// </li>
    /// <li>
    /// <p>If any of the MIME parts in your message contain content that is outside of
    /// the 7-bit ASCII character range, we highly recommend that you encode that
    /// content. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html">Sending Raw Email</a> in the <i>Amazon SES Developer
    /// Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC
    /// 5321</a>, the maximum length of each line of text, including the
    /// <CRLF>, must not exceed 1,000 characters.</p>
    /// </li>
    /// </ul>
    pub fn raw_message(&self) -> std::option::Option<&crate::model::RawMessage> {
        self.raw_message.as_ref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to specify a
    /// particular "From" address in the header of the raw email.</p>
    /// <p>Instead of using this parameter, you can use the X-header <code>X-SES-FROM-ARN</code>
    /// in the raw message of the email. If you use both the <code>FromArn</code> parameter and
    /// the corresponding X-header, Amazon SES uses the value of the <code>FromArn</code>
    /// parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub fn from_arn(&self) -> std::option::Option<&str> {
        self.from_arn.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>Instead of using this parameter, you can use the X-header
    /// <code>X-SES-SOURCE-ARN</code> in the raw message of the email. If you use both the
    /// <code>SourceArn</code> parameter and the corresponding X-header, Amazon SES uses the
    /// value of the <code>SourceArn</code> parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>Instead of using this parameter, you can use the X-header
    /// <code>X-SES-RETURN-PATH-ARN</code> in the raw message of the email. If you use both
    /// the <code>ReturnPathArn</code> parameter and the corresponding X-header, Amazon SES uses the
    /// value of the <code>ReturnPathArn</code> parameter.</p>
    /// <note>
    /// <p>For information about when to use this parameter, see the description of
    /// <code>SendRawEmail</code> in this guide, or see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html">Amazon SES Developer Guide</a>.</p>
    /// </note>
    pub fn return_path_arn(&self) -> std::option::Option<&str> {
        self.return_path_arn.as_deref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendRawEmail</code>. Tags correspond to characteristics of the email that
    /// you define, so that you can publish email sending events.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendRawEmail</code>.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for SendRawEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendRawEmailInput");
        formatter.field("source", &self.source);
        formatter.field("destinations", &self.destinations);
        formatter.field("raw_message", &self.raw_message);
        formatter.field("from_arn", &self.from_arn);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("return_path_arn", &self.return_path_arn);
        formatter.field("tags", &self.tags);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to send a single formatted email using Amazon SES. For more
/// information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub source: std::option::Option<std::string::String>,
    /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The message to be sent.</p>
    pub message: std::option::Option<crate::model::Message>,
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub return_path: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub return_path_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
    /// define, so that you can publish email sending events.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendEmail</code>.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl SendEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The destination for this email, composed of To:, CC:, and BCC: fields.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The message to be sent.</p>
    pub fn message(&self) -> std::option::Option<&crate::model::Message> {
        self.message.as_ref()
    }
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub fn reply_to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.reply_to_addresses.as_deref()
    }
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub fn return_path(&self) -> std::option::Option<&str> {
        self.return_path.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn return_path_arn(&self) -> std::option::Option<&str> {
        self.return_path_arn.as_deref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send
    /// using <code>SendEmail</code>. Tags correspond to characteristics of the email that you
    /// define, so that you can publish email sending events.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.tags.as_deref()
    }
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendEmail</code>.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for SendEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEmailInput");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("message", &self.message);
        formatter.field("reply_to_addresses", &self.reply_to_addresses);
        formatter.field("return_path", &self.return_path);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("return_path_arn", &self.return_path_arn);
        formatter.field("tags", &self.tags);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to send a custom verification email to a specified
/// recipient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendCustomVerificationEmailInput {
    /// <p>The email address to verify.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The name of the custom verification email template to use when sending the
    /// verification email.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>Name of a configuration set to use when sending the verification email.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl SendCustomVerificationEmailInput {
    /// <p>The email address to verify.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The name of the custom verification email template to use when sending the
    /// verification email.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>Name of a configuration set to use when sending the verification email.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for SendCustomVerificationEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendCustomVerificationEmailInput");
        formatter.field("email_address", &self.email_address);
        formatter.field("template_name", &self.template_name);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to send a templated email to multiple destinations using Amazon SES.
/// For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBulkTemplatedEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub source: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub reply_to_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub return_path: std::option::Option<std::string::String>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub return_path_arn: std::option::Option<std::string::String>,
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendBulkTemplatedEmail</code>.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
    /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
    pub default_tags: std::option::Option<std::vec::Vec<crate::model::MessageTag>>,
    /// <p>The template to use when sending this email.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The ARN of the template to use when sending this email.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>A list of replacement values to apply to the template when replacement data is not
    /// specified in a Destination object. These values act as a default or fallback option when
    /// no other data is available.</p>
    /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
    /// the keys correspond to replacement tags in the email template.</p>
    pub default_template_data: std::option::Option<std::string::String>,
    /// <p>One or more <code>Destination</code> objects. All of the recipients in a
    /// <code>Destination</code> will receive the same version of the email. You can specify
    /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
    /// array.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::BulkEmailDestination>>,
}
impl SendBulkTemplatedEmailInput {
    /// <p>The email address that is sending the email. This email address must be either
    /// individually verified with Amazon SES, or from a domain that has been verified with Amazon SES.
    /// For information about verifying identities, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
    /// Guide</a>.</p>
    /// <p>If you are sending on behalf of another user and have been permitted to do so by a
    /// sending authorization policy, then you must also specify the <code>SourceArn</code>
    /// parameter. For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
    /// <note>
    /// <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the
    /// <i>local part</i> of a source email address (the part of the email
    /// address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII
    /// characters</a>. If the <i>domain part</i> of an address (the
    /// part after the @ sign) contains non-ASCII characters, they must be encoded using
    /// Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>. The sender name (also known as the <i>friendly
    /// name</i>) may contain non-ASCII characters. These characters must be
    /// encoded using MIME encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>. MIME encoded-word
    /// syntax uses the following form:
    /// <code>=?charset?encoding?encoded-text?=</code>.</p>
    /// </note>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to send for
    /// the email address specified in the <code>Source</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to send from <code>user@example.com</code>, then you
    /// would specify the <code>SourceArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>Source</code> to be <code>user@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The reply-to email address(es) for the message. If the recipient replies to the
    /// message, each reply-to address will receive the reply.</p>
    pub fn reply_to_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.reply_to_addresses.as_deref()
    }
    /// <p>The email address that bounces and complaints will be forwarded to when feedback
    /// forwarding is enabled. If the message cannot be delivered to the recipient, then an
    /// error message will be returned from the recipient's ISP; this message will then be
    /// forwarded to the email address specified by the <code>ReturnPath</code> parameter. The
    /// <code>ReturnPath</code> parameter is never overwritten. This email address must be
    /// either individually verified with Amazon SES, or from a domain that has been verified with
    /// Amazon SES. </p>
    pub fn return_path(&self) -> std::option::Option<&str> {
        self.return_path.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// email address specified in the <code>ReturnPath</code> parameter.</p>
    /// <p>For example, if the owner of <code>example.com</code> (which has ARN
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>) attaches a
    /// policy to it that authorizes you to use <code>feedback@example.com</code>, then you
    /// would specify the <code>ReturnPathArn</code> to be
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>, and the
    /// <code>ReturnPath</code> to be <code>feedback@example.com</code>.</p>
    /// <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn return_path_arn(&self) -> std::option::Option<&str> {
        self.return_path_arn.as_deref()
    }
    /// <p>The name of the configuration set to use when you send an email using
    /// <code>SendBulkTemplatedEmail</code>.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A list of tags, in the form of name/value pairs, to apply to an email that you send to
    /// a destination using <code>SendBulkTemplatedEmail</code>.</p>
    pub fn default_tags(&self) -> std::option::Option<&[crate::model::MessageTag]> {
        self.default_tags.as_deref()
    }
    /// <p>The template to use when sending this email.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The ARN of the template to use when sending this email.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>A list of replacement values to apply to the template when replacement data is not
    /// specified in a Destination object. These values act as a default or fallback option when
    /// no other data is available.</p>
    /// <p>The template data is a JSON object, typically consisting of key-value pairs in which
    /// the keys correspond to replacement tags in the email template.</p>
    pub fn default_template_data(&self) -> std::option::Option<&str> {
        self.default_template_data.as_deref()
    }
    /// <p>One or more <code>Destination</code> objects. All of the recipients in a
    /// <code>Destination</code> will receive the same version of the email. You can specify
    /// up to 50 <code>Destination</code> objects within a <code>Destinations</code>
    /// array.</p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::BulkEmailDestination]> {
        self.destinations.as_deref()
    }
}
impl std::fmt::Debug for SendBulkTemplatedEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBulkTemplatedEmailInput");
        formatter.field("source", &self.source);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("reply_to_addresses", &self.reply_to_addresses);
        formatter.field("return_path", &self.return_path);
        formatter.field("return_path_arn", &self.return_path_arn);
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("default_tags", &self.default_tags);
        formatter.field("template", &self.template);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("default_template_data", &self.default_template_data);
        formatter.field("destinations", &self.destinations);
        formatter.finish()
    }
}

/// <p>Represents a request to send a bounce message to the sender of an email you received
/// through Amazon SES.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendBounceInput {
    /// <p>The message ID of the message to be bounced.</p>
    pub original_message_id: std::option::Option<std::string::String>,
    /// <p>The address to use in the "From" header of the bounce message. This must be an
    /// identity that you have verified with Amazon SES.</p>
    pub bounce_sender: std::option::Option<std::string::String>,
    /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
    /// the text will be auto-generated based on the bounced recipient information.</p>
    pub explanation: std::option::Option<std::string::String>,
    /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
    pub message_dsn: std::option::Option<crate::model::MessageDsn>,
    /// <p>A list of recipients of the bounced message, including the information required to
    /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
    /// least one <code>BouncedRecipientInfo</code> in the list.</p>
    pub bounced_recipient_info_list:
        std::option::Option<std::vec::Vec<crate::model::BouncedRecipientInfo>>,
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// address in the "From" header of the bounce. For more information about sending
    /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub bounce_sender_arn: std::option::Option<std::string::String>,
}
impl SendBounceInput {
    /// <p>The message ID of the message to be bounced.</p>
    pub fn original_message_id(&self) -> std::option::Option<&str> {
        self.original_message_id.as_deref()
    }
    /// <p>The address to use in the "From" header of the bounce message. This must be an
    /// identity that you have verified with Amazon SES.</p>
    pub fn bounce_sender(&self) -> std::option::Option<&str> {
        self.bounce_sender.as_deref()
    }
    /// <p>Human-readable text for the bounce message to explain the failure. If not specified,
    /// the text will be auto-generated based on the bounced recipient information.</p>
    pub fn explanation(&self) -> std::option::Option<&str> {
        self.explanation.as_deref()
    }
    /// <p>Message-related DSN fields. If not specified, Amazon SES will choose the values.</p>
    pub fn message_dsn(&self) -> std::option::Option<&crate::model::MessageDsn> {
        self.message_dsn.as_ref()
    }
    /// <p>A list of recipients of the bounced message, including the information required to
    /// create the Delivery Status Notifications (DSNs) for the recipients. You must specify at
    /// least one <code>BouncedRecipientInfo</code> in the list.</p>
    pub fn bounced_recipient_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::BouncedRecipientInfo]> {
        self.bounced_recipient_info_list.as_deref()
    }
    /// <p>This parameter is used only for sending authorization. It is the ARN of the identity
    /// that is associated with the sending authorization policy that permits you to use the
    /// address in the "From" header of the bounce. For more information about sending
    /// authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
    /// Guide</a>.</p>
    pub fn bounce_sender_arn(&self) -> std::option::Option<&str> {
        self.bounce_sender_arn.as_deref()
    }
}
impl std::fmt::Debug for SendBounceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendBounceInput");
        formatter.field("original_message_id", &self.original_message_id);
        formatter.field("bounce_sender", &self.bounce_sender);
        formatter.field("explanation", &self.explanation);
        formatter.field("message_dsn", &self.message_dsn);
        formatter.field(
            "bounced_recipient_info_list",
            &self.bounced_recipient_info_list,
        );
        formatter.field("bounce_sender_arn", &self.bounce_sender_arn);
        formatter.finish()
    }
}

/// <p>Represents a request to reorder the receipt rules within a receipt rule set. You use
/// receipt rule sets to receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReorderReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to reorder.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
    /// put them.</p>
    pub rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReorderReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to reorder.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>A list of the specified receipt rule set's receipt rules in the order that you want to
    /// put them.</p>
    pub fn rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.rule_names.as_deref()
    }
}
impl std::fmt::Debug for ReorderReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReorderReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_names", &self.rule_names);
        formatter.finish()
    }
}

/// <p>Represents a request to add or update a sending authorization policy for an identity.
/// Sending authorization is an Amazon SES feature that enables you to authorize other senders to
/// use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIdentityPolicyInput {
    /// <p>The identity that the policy will apply to. You can specify an identity by using its
    /// name or by using its Amazon Resource Name (ARN). Examples:
    /// <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
    /// characters, dashes, and underscores.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
    /// Guide</a>. </p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutIdentityPolicyInput {
    /// <p>The identity that the policy will apply to. You can specify an identity by using its
    /// name or by using its Amazon Resource Name (ARN). Examples:
    /// <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The name of the policy.</p>
    /// <p>The policy name cannot exceed 64 characters and can only include alphanumeric
    /// characters, dashes, and underscores.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
    /// <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer
    /// Guide</a>. </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutIdentityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIdentityPolicyInput");
        formatter.field("identity", &self.identity);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

/// <p>A request to modify the delivery options for a configuration set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutConfigurationSetDeliveryOptionsInput {
    /// <p>The name of the configuration set that you want to specify the delivery options
    /// for.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS).</p>
    pub delivery_options: std::option::Option<crate::model::DeliveryOptions>,
}
impl PutConfigurationSetDeliveryOptionsInput {
    /// <p>The name of the configuration set that you want to specify the delivery options
    /// for.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>Specifies whether messages that use the configuration set are required to use
    /// Transport Layer Security (TLS).</p>
    pub fn delivery_options(&self) -> std::option::Option<&crate::model::DeliveryOptions> {
        self.delivery_options.as_ref()
    }
}
impl std::fmt::Debug for PutConfigurationSetDeliveryOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutConfigurationSetDeliveryOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("delivery_options", &self.delivery_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVerifiedEmailAddressesInput {}
impl std::fmt::Debug for ListVerifiedEmailAddressesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVerifiedEmailAddressesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
    /// position in the list of email templates.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of templates to return. This value must be at least 1 and less than
    /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
    /// greater than 10, the operation will return up to 10 results.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTemplatesInput {
    /// <p>A token returned from a previous call to <code>ListTemplates</code> to indicate the
    /// position in the list of email templates.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of templates to return. This value must be at least 1 and less than
    /// or equal to 10. If you do not specify a value, or if you specify a value less than 1 or
    /// greater than 10, the operation will return up to 10 results.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>Represents a request to list the receipt rule sets that exist under your AWS account.
/// You use receipt rule sets to receive email with Amazon SES. For more information, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceiptRuleSetsInput {
    /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
    /// the position in the receipt rule set list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReceiptRuleSetsInput {
    /// <p>A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate
    /// the position in the receipt rule set list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReceiptRuleSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceiptRuleSetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents a request to list the IP address filters that exist under your AWS account.
/// You use IP address filters when you receive email with Amazon SES. For more information, see
/// the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceiptFiltersInput {}
impl std::fmt::Debug for ListReceiptFiltersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceiptFiltersInput");
        formatter.finish()
    }
}

/// <p>Represents a request to return a list of sending authorization policies that are
/// attached to an identity. Sending authorization is an Amazon SES feature that enables you to
/// authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityPoliciesInput {
    /// <p>The identity that is associated with the policy for which the policies will be listed.
    /// You can specify an identity by using its name or by using its Amazon Resource Name
    /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub identity: std::option::Option<std::string::String>,
}
impl ListIdentityPoliciesInput {
    /// <p>The identity that is associated with the policy for which the policies will be listed.
    /// You can specify an identity by using its name or by using its Amazon Resource Name
    /// (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
}
impl std::fmt::Debug for ListIdentityPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityPoliciesInput");
        formatter.field("identity", &self.identity);
        formatter.finish()
    }
}

/// <p>Represents a request to return a list of all identities (email addresses and domains)
/// that you have attempted to verify under your AWS account, regardless of verification
/// status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentitiesInput {
    /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
    /// If this parameter is omitted, then all identities will be listed.</p>
    pub identity_type: std::option::Option<crate::model::IdentityType>,
    /// <p>The token to use for pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of identities per page. Possible values are 1-1000
    /// inclusive.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListIdentitiesInput {
    /// <p>The type of the identities to list. Possible values are "EmailAddress" and "Domain".
    /// If this parameter is omitted, then all identities will be listed.</p>
    pub fn identity_type(&self) -> std::option::Option<&crate::model::IdentityType> {
        self.identity_type.as_ref()
    }
    /// <p>The token to use for pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of identities per page. Possible values are 1-1000
    /// inclusive.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListIdentitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentitiesInput");
        formatter.field("identity_type", &self.identity_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>Represents a request to list the existing custom verification email templates for your
/// account.</p>
/// <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html">Using Custom
/// Verification Email Templates</a> in the <i>Amazon SES Developer
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomVerificationEmailTemplatesInput {
    /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
    /// account.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of custom verification email templates to return. This value must
    /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
    /// specify a value less than 1 or greater than 50, the operation will return up to 50
    /// results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListCustomVerificationEmailTemplatesInput {
    /// <p>An array the contains the name and creation time stamp for each template in your Amazon SES
    /// account.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of custom verification email templates to return. This value must
    /// be at least 1 and less than or equal to 50. If you do not specify a value, or if you
    /// specify a value less than 1 or greater than 50, the operation will return up to 50
    /// results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListCustomVerificationEmailTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomVerificationEmailTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents a request to list the configuration sets associated with your AWS account.
/// Configuration sets enable you to publish email sending events. For information about
/// using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigurationSetsInput {
    /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
    /// indicate the position of the configuration set in the configuration set list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of configuration sets to return.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListConfigurationSetsInput {
    /// <p>A token returned from a previous call to <code>ListConfigurationSets</code> to
    /// indicate the position of the configuration set in the configuration set list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of configuration sets to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListConfigurationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigurationSetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTemplateInput {
    /// <p>The name of the template you want to retrieve.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl GetTemplateInput {
    /// <p>The name of the template you want to retrieve.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for GetTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSendStatisticsInput {}
impl std::fmt::Debug for GetSendStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSendStatisticsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSendQuotaInput {}
impl std::fmt::Debug for GetSendQuotaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSendQuotaInput");
        formatter.finish()
    }
}

/// <p>Represents a request to return the Amazon SES verification status of a list of identities.
/// For domain identities, this request also returns the verification token. For information
/// about verifying identities with Amazon SES, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityVerificationAttributesInput {
    /// <p>A list of identities.</p>
    pub identities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetIdentityVerificationAttributesInput {
    /// <p>A list of identities.</p>
    pub fn identities(&self) -> std::option::Option<&[std::string::String]> {
        self.identities.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityVerificationAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityVerificationAttributesInput");
        formatter.field("identities", &self.identities);
        formatter.finish()
    }
}

/// <p>Represents a request to return the requested sending authorization policies for an
/// identity. Sending authorization is an Amazon SES feature that enables you to authorize other
/// senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityPoliciesInput {
    /// <p>The identity for which the policies will be retrieved. You can specify an identity by
    /// using its name or by using its Amazon Resource Name (ARN). Examples:
    /// <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
    /// policies at a time. If you do not know the names of the policies that are attached to
    /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetIdentityPoliciesInput {
    /// <p>The identity for which the policies will be retrieved. You can specify an identity by
    /// using its name or by using its Amazon Resource Name (ARN). Examples:
    /// <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>A list of the names of policies to be retrieved. You can retrieve a maximum of 20
    /// policies at a time. If you do not know the names of the policies that are attached to
    /// the identity, you can use <code>ListIdentityPolicies</code>.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityPoliciesInput");
        formatter.field("identity", &self.identity);
        formatter.field("policy_names", &self.policy_names);
        formatter.finish()
    }
}

/// <p>Represents a request to return the notification attributes for a list of identities
/// you verified with Amazon SES. For information about Amazon SES notifications, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityNotificationAttributesInput {
    /// <p>A list of one or more identities. You can specify an identity by using its name or by
    /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
    /// <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    pub identities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetIdentityNotificationAttributesInput {
    /// <p>A list of one or more identities. You can specify an identity by using its name or by
    /// using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
    /// <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    pub fn identities(&self) -> std::option::Option<&[std::string::String]> {
        self.identities.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityNotificationAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityNotificationAttributesInput");
        formatter.field("identities", &self.identities);
        formatter.finish()
    }
}

/// <p>Represents a request to return the Amazon SES custom MAIL FROM attributes for a list of
/// identities. For information about using a custom MAIL FROM domain, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityMailFromDomainAttributesInput {
    /// <p>A list of one or more identities.</p>
    pub identities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetIdentityMailFromDomainAttributesInput {
    /// <p>A list of one or more identities.</p>
    pub fn identities(&self) -> std::option::Option<&[std::string::String]> {
        self.identities.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityMailFromDomainAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityMailFromDomainAttributesInput");
        formatter.field("identities", &self.identities);
        formatter.finish()
    }
}

/// <p>Represents a request for the status of Amazon SES Easy DKIM signing for an identity. For
/// domain identities, this request also returns the DKIM tokens that are required for Easy
/// DKIM signing, and whether Amazon SES successfully verified that these tokens were published.
/// For more information about Easy DKIM, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityDkimAttributesInput {
    /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
    pub identities: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetIdentityDkimAttributesInput {
    /// <p>A list of one or more verified identities - email addresses, domains, or both.</p>
    pub fn identities(&self) -> std::option::Option<&[std::string::String]> {
        self.identities.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityDkimAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityDkimAttributesInput");
        formatter.field("identities", &self.identities);
        formatter.finish()
    }
}

/// <p>Represents a request to retrieve an existing custom verification email
/// template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to retrieve.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl GetCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to retrieve.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for GetCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSendingEnabledInput {}
impl std::fmt::Debug for GetAccountSendingEnabledInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSendingEnabledInput");
        formatter.finish()
    }
}

/// <p>Represents a request to return the details of a receipt rule set. You use receipt rule
/// sets to receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to describe.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
}
impl DescribeReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to describe.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to return the details of a receipt rule. You use receipt rules to
/// receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReceiptRuleInput {
    /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the receipt rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
}
impl DescribeReceiptRuleInput {
    /// <p>The name of the receipt rule set that the receipt rule belongs to.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The name of the receipt rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeReceiptRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReceiptRuleInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.finish()
    }
}

/// <p>Represents a request to return the details of a configuration set. Configuration sets
/// enable you to publish email sending events. For information about using configuration
/// sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConfigurationSetInput {
    /// <p>The name of the configuration set to describe.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A list of configuration set attributes to return.</p>
    pub configuration_set_attribute_names:
        std::option::Option<std::vec::Vec<crate::model::ConfigurationSetAttribute>>,
}
impl DescribeConfigurationSetInput {
    /// <p>The name of the configuration set to describe.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A list of configuration set attributes to return.</p>
    pub fn configuration_set_attribute_names(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigurationSetAttribute]> {
        self.configuration_set_attribute_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field(
            "configuration_set_attribute_names",
            &self.configuration_set_attribute_names,
        );
        formatter.finish()
    }
}

/// <p>Represents a request to return the metadata and receipt rules for the receipt rule set
/// that is currently active. You use receipt rule sets to receive email with Amazon SES. For
/// more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActiveReceiptRuleSetInput {}
impl std::fmt::Debug for DescribeActiveReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActiveReceiptRuleSetInput");
        formatter.finish()
    }
}

/// <p>Represents a request to delete an email address from the list of email addresses you
/// have attempted to verify under your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVerifiedEmailAddressInput {
    /// <p>An email address to be removed from the list of verified addresses.</p>
    pub email_address: std::option::Option<std::string::String>,
}
impl DeleteVerifiedEmailAddressInput {
    /// <p>An email address to be removed from the list of verified addresses.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
}
impl std::fmt::Debug for DeleteVerifiedEmailAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVerifiedEmailAddressInput");
        formatter.field("email_address", &self.email_address);
        formatter.finish()
    }
}

/// <p>Represents a request to delete an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTemplateInput {
    /// <p>The name of the template to be deleted.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl DeleteTemplateInput {
    /// <p>The name of the template to be deleted.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a receipt rule set and all of the receipt rules it
/// contains. You use receipt rule sets to receive email with Amazon SES. For more information,
/// see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to delete.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
}
impl DeleteReceiptRuleSetInput {
    /// <p>The name of the receipt rule set to delete.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a receipt rule. You use receipt rules to receive email
/// with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptRuleInput {
    /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the receipt rule to delete.</p>
    pub rule_name: std::option::Option<std::string::String>,
}
impl DeleteReceiptRuleInput {
    /// <p>The name of the receipt rule set that contains the receipt rule to delete.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The name of the receipt rule to delete.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReceiptRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptRuleInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("rule_name", &self.rule_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete an IP address filter. You use IP address filters when
/// you receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReceiptFilterInput {
    /// <p>The name of the IP address filter to delete.</p>
    pub filter_name: std::option::Option<std::string::String>,
}
impl DeleteReceiptFilterInput {
    /// <p>The name of the IP address filter to delete.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReceiptFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReceiptFilterInput");
        formatter.field("filter_name", &self.filter_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a sending authorization policy for an identity. Sending
/// authorization is an Amazon SES feature that enables you to authorize other senders to use
/// your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityPolicyInput {
    /// <p>The identity that is associated with the policy that you want to delete. You can
    /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
    /// Examples: <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub identity: std::option::Option<std::string::String>,
    /// <p>The name of the policy to be deleted.</p>
    pub policy_name: std::option::Option<std::string::String>,
}
impl DeleteIdentityPolicyInput {
    /// <p>The identity that is associated with the policy that you want to delete. You can
    /// specify the identity by using its name or by using its Amazon Resource Name (ARN).
    /// Examples: <code>user@example.com</code>, <code>example.com</code>,
    /// <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
    /// <p>To successfully call this API, you must own the identity.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
    /// <p>The name of the policy to be deleted.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteIdentityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityPolicyInput");
        formatter.field("identity", &self.identity);
        formatter.field("policy_name", &self.policy_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete one of your Amazon SES identities (an email address or
/// domain).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIdentityInput {
    /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
    pub identity: std::option::Option<std::string::String>,
}
impl DeleteIdentityInput {
    /// <p>The identity to be removed from the list of identities for the AWS Account.</p>
    pub fn identity(&self) -> std::option::Option<&str> {
        self.identity.as_deref()
    }
}
impl std::fmt::Debug for DeleteIdentityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIdentityInput");
        formatter.field("identity", &self.identity);
        formatter.finish()
    }
}

/// <p>Represents a request to delete an existing custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to delete.</p>
    pub template_name: std::option::Option<std::string::String>,
}
impl DeleteCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template that you want to delete.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete open and click tracking options in a configuration set.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set from which you want to delete the tracking
    /// options.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set from which you want to delete the tracking
    /// options.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetTrackingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetTrackingOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a configuration set event destination. Configuration
/// set event destinations are associated with configuration sets, which enable you to
/// publish email sending events. For information about using configuration sets, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set from which to delete the event destination.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the event destination to delete.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set from which to delete the event destination.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>The name of the event destination to delete.</p>
    pub fn event_destination_name(&self) -> std::option::Option<&str> {
        self.event_destination_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.finish()
    }
}

/// <p>Represents a request to delete a configuration set. Configuration sets enable you to
/// publish email sending events. For information about using configuration sets, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigurationSetInput {
    /// <p>The name of the configuration set to delete.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
}
impl DeleteConfigurationSetInput {
    /// <p>The name of the configuration set to delete.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigurationSetInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to create an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTemplateInput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub template: std::option::Option<crate::model::Template>,
}
impl CreateTemplateInput {
    /// <p>The content of the email, composed of a subject line, an HTML part, and a text-only
    /// part.</p>
    pub fn template(&self) -> std::option::Option<&crate::model::Template> {
        self.template.as_ref()
    }
}
impl std::fmt::Debug for CreateTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTemplateInput");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}

/// <p>Represents a request to create an empty receipt rule set. You use receipt rule sets to
/// receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptRuleSetInput {
    /// <p>The name of the rule set to create. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub rule_set_name: std::option::Option<std::string::String>,
}
impl CreateReceiptRuleSetInput {
    /// <p>The name of the rule set to create. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
}
impl std::fmt::Debug for CreateReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.finish()
    }
}

/// <p>Represents a request to create a receipt rule. You use receipt rules to receive email
/// with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptRuleInput {
    /// <p>The name of the rule set that the receipt rule will be added to.</p>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The name of an existing rule after which the new rule will be placed. If this
    /// parameter is null, the new rule will be inserted at the beginning of the rule
    /// list.</p>
    pub after: std::option::Option<std::string::String>,
    /// <p>A data structure that contains the specified rule's name, actions, recipients,
    /// domains, enabled status, scan status, and TLS policy.</p>
    pub rule: std::option::Option<crate::model::ReceiptRule>,
}
impl CreateReceiptRuleInput {
    /// <p>The name of the rule set that the receipt rule will be added to.</p>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The name of an existing rule after which the new rule will be placed. If this
    /// parameter is null, the new rule will be inserted at the beginning of the rule
    /// list.</p>
    pub fn after(&self) -> std::option::Option<&str> {
        self.after.as_deref()
    }
    /// <p>A data structure that contains the specified rule's name, actions, recipients,
    /// domains, enabled status, scan status, and TLS policy.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::ReceiptRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for CreateReceiptRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptRuleInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("after", &self.after);
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}

/// <p>Represents a request to create a new IP address filter. You use IP address filters
/// when you receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReceiptFilterInput {
    /// <p>A data structure that describes the IP address filter to create, which consists of a
    /// name, an IP address range, and whether to allow or block mail from it.</p>
    pub filter: std::option::Option<crate::model::ReceiptFilter>,
}
impl CreateReceiptFilterInput {
    /// <p>A data structure that describes the IP address filter to create, which consists of a
    /// name, an IP address range, and whether to allow or block mail from it.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ReceiptFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for CreateReceiptFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReceiptFilterInput");
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

/// <p>Represents a request to create a custom verification email template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The email address that the custom verification email is sent from.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    /// <p>The subject line of the custom verification email.</p>
    pub template_subject: std::option::Option<std::string::String>,
    /// <p>The content of the custom verification email. The total size of the email must be less
    /// than 10 MB. The message body may contain HTML, with some limitations. For more
    /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub template_content: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub success_redirection_url: std::option::Option<std::string::String>,
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub failure_redirection_url: std::option::Option<std::string::String>,
}
impl CreateCustomVerificationEmailTemplateInput {
    /// <p>The name of the custom verification email template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The email address that the custom verification email is sent from.</p>
    pub fn from_email_address(&self) -> std::option::Option<&str> {
        self.from_email_address.as_deref()
    }
    /// <p>The subject line of the custom verification email.</p>
    pub fn template_subject(&self) -> std::option::Option<&str> {
        self.template_subject.as_deref()
    }
    /// <p>The content of the custom verification email. The total size of the email must be less
    /// than 10 MB. The message body may contain HTML, with some limitations. For more
    /// information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub fn template_content(&self) -> std::option::Option<&str> {
        self.template_content.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is successfully verified.</p>
    pub fn success_redirection_url(&self) -> std::option::Option<&str> {
        self.success_redirection_url.as_deref()
    }
    /// <p>The URL that the recipient of the verification email is sent to if his or her address
    /// is not successfully verified.</p>
    pub fn failure_redirection_url(&self) -> std::option::Option<&str> {
        self.failure_redirection_url.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomVerificationEmailTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomVerificationEmailTemplateInput");
        formatter.field("template_name", &self.template_name);
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("template_subject", &self.template_subject);
        formatter.field("template_content", &self.template_content);
        formatter.field("success_redirection_url", &self.success_redirection_url);
        formatter.field("failure_redirection_url", &self.failure_redirection_url);
        formatter.finish()
    }
}

/// <p>Represents a request to create an open and click tracking option object in a
/// configuration set. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set that the tracking options should be associated
    /// with.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
    /// domain captures open and click events generated by Amazon SES emails.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
    /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub tracking_options: std::option::Option<crate::model::TrackingOptions>,
}
impl CreateConfigurationSetTrackingOptionsInput {
    /// <p>The name of the configuration set that the tracking options should be associated
    /// with.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>A domain that is used to redirect email recipients to an Amazon SES-operated domain. This
    /// domain captures open and click events generated by Amazon SES emails.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html">Configuring
    /// Custom Domains to Handle Open and Click Tracking</a> in the <i>Amazon SES
    /// Developer Guide</i>.</p>
    pub fn tracking_options(&self) -> std::option::Option<&crate::model::TrackingOptions> {
        self.tracking_options.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetTrackingOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetTrackingOptionsInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("tracking_options", &self.tracking_options);
        formatter.finish()
    }
}

/// <p>Represents a request to create a configuration set event destination. A configuration
/// set event destination, which can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service
/// in which Amazon SES publishes the email sending events associated with a configuration set.
/// For information about using configuration sets, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that the event destination should be associated
    /// with.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>An object that describes the AWS service that email sending event information will
    /// be published to.</p>
    pub event_destination: std::option::Option<crate::model::EventDestination>,
}
impl CreateConfigurationSetEventDestinationInput {
    /// <p>The name of the configuration set that the event destination should be associated
    /// with.</p>
    pub fn configuration_set_name(&self) -> std::option::Option<&str> {
        self.configuration_set_name.as_deref()
    }
    /// <p>An object that describes the AWS service that email sending event information will
    /// be published to.</p>
    pub fn event_destination(&self) -> std::option::Option<&crate::model::EventDestination> {
        self.event_destination.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetEventDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetEventDestinationInput");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination", &self.event_destination);
        formatter.finish()
    }
}

/// <p>Represents a request to create a configuration set. Configuration sets enable you to
/// publish email sending events. For information about using configuration sets, see the
/// <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigurationSetInput {
    /// <p>A data structure that contains the name of the configuration set.</p>
    pub configuration_set: std::option::Option<crate::model::ConfigurationSet>,
}
impl CreateConfigurationSetInput {
    /// <p>A data structure that contains the name of the configuration set.</p>
    pub fn configuration_set(&self) -> std::option::Option<&crate::model::ConfigurationSet> {
        self.configuration_set.as_ref()
    }
}
impl std::fmt::Debug for CreateConfigurationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigurationSetInput");
        formatter.field("configuration_set", &self.configuration_set);
        formatter.finish()
    }
}

/// <p>Represents a request to create a receipt rule set by cloning an existing one. You use
/// receipt rule sets to receive email with Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloneReceiptRuleSetInput {
    /// <p>The name of the rule set to create. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub rule_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the rule set to clone.</p>
    pub original_rule_set_name: std::option::Option<std::string::String>,
}
impl CloneReceiptRuleSetInput {
    /// <p>The name of the rule set to create. The name must:</p>
    /// <ul>
    /// <li>
    /// <p>This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
    /// underscores (_), or dashes (-).</p>
    /// </li>
    /// <li>
    /// <p>Start and end with a letter or number.</p>
    /// </li>
    /// <li>
    /// <p>Contain less than 64 characters.</p>
    /// </li>
    /// </ul>
    pub fn rule_set_name(&self) -> std::option::Option<&str> {
        self.rule_set_name.as_deref()
    }
    /// <p>The name of the rule set to clone.</p>
    pub fn original_rule_set_name(&self) -> std::option::Option<&str> {
        self.original_rule_set_name.as_deref()
    }
}
impl std::fmt::Debug for CloneReceiptRuleSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloneReceiptRuleSetInput");
        formatter.field("rule_set_name", &self.rule_set_name);
        formatter.field("original_rule_set_name", &self.original_rule_set_name);
        formatter.finish()
    }
}
