// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::already_exists_exception::Builder,
) -> Result<crate::error::already_exists_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#AlreadyExistsException$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.ses#AlreadyExistsException$Name */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_exception::Builder,
) -> Result<crate::error::limit_exceeded_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#LimitExceededException$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::rule_set_does_not_exist_exception::Builder,
) -> Result<
    crate::error::rule_set_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#RuleSetDoesNotExistException$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.ses#RuleSetDoesNotExistException$Name */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_configuration_set_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::configuration_set_already_exists_exception::Builder,
) -> Result<
    crate::error::configuration_set_already_exists_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#ConfigurationSetAlreadyExistsException$ConfigurationSetName */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_6);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#ConfigurationSetAlreadyExistsException$message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_configuration_set_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_configuration_set_exception::Builder,
) -> Result<
    crate::error::invalid_configuration_set_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#InvalidConfigurationSetException$message */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::configuration_set_does_not_exist_exception::Builder,
) -> Result<
    crate::error::configuration_set_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#ConfigurationSetDoesNotExistException$ConfigurationSetName */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_9);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#ConfigurationSetDoesNotExistException$message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_event_destination_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::event_destination_already_exists_exception::Builder,
) -> Result<
    crate::error::event_destination_already_exists_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDestinationName") /* EventDestinationName com.amazonaws.ses#EventDestinationAlreadyExistsException$EventDestinationName */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_destination_name(var_11);
            }
            ,
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#EventDestinationAlreadyExistsException$ConfigurationSetName */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_12);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#EventDestinationAlreadyExistsException$message */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cloud_watch_destination_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cloud_watch_destination_exception::Builder,
) -> Result<
    crate::error::invalid_cloud_watch_destination_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDestinationName") /* EventDestinationName com.amazonaws.ses#InvalidCloudWatchDestinationException$EventDestinationName */ =>  {
                let var_14 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_destination_name(var_14);
            }
            ,
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#InvalidCloudWatchDestinationException$ConfigurationSetName */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_15);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidCloudWatchDestinationException$message */ =>  {
                let var_16 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_firehose_destination_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_firehose_destination_exception::Builder,
) -> Result<
    crate::error::invalid_firehose_destination_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDestinationName") /* EventDestinationName com.amazonaws.ses#InvalidFirehoseDestinationException$EventDestinationName */ =>  {
                let var_17 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_destination_name(var_17);
            }
            ,
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#InvalidFirehoseDestinationException$ConfigurationSetName */ =>  {
                let var_18 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_18);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidFirehoseDestinationException$message */ =>  {
                let var_19 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_19);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_sns_destination_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_sns_destination_exception::Builder,
) -> Result<
    crate::error::invalid_sns_destination_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDestinationName") /* EventDestinationName com.amazonaws.ses#InvalidSNSDestinationException$EventDestinationName */ =>  {
                let var_20 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_destination_name(var_20);
            }
            ,
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#InvalidSNSDestinationException$ConfigurationSetName */ =>  {
                let var_21 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_21);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidSNSDestinationException$message */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_22);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_tracking_options_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_tracking_options_exception::Builder,
) -> Result<
    crate::error::invalid_tracking_options_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#InvalidTrackingOptionsException$message */ =>  {
                let var_23 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_23);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_tracking_options_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::tracking_options_already_exists_exception::Builder,
) -> Result<
    crate::error::tracking_options_already_exists_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#TrackingOptionsAlreadyExistsException$ConfigurationSetName */ =>  {
                let var_24 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_24);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#TrackingOptionsAlreadyExistsException$message */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_25);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_custom_verification_email_invalid_content_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::custom_verification_email_invalid_content_exception::Builder,
) -> Result<
    crate::error::custom_verification_email_invalid_content_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#CustomVerificationEmailInvalidContentException$message */ =>  {
                let var_26 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_26);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_custom_verification_email_template_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::custom_verification_email_template_already_exists_exception::Builder,
) -> Result<
    crate::error::custom_verification_email_template_already_exists_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CustomVerificationEmailTemplateName") /* CustomVerificationEmailTemplateName com.amazonaws.ses#CustomVerificationEmailTemplateAlreadyExistsException$CustomVerificationEmailTemplateName */ =>  {
                let var_27 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_custom_verification_email_template_name(var_27);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#CustomVerificationEmailTemplateAlreadyExistsException$message */ =>  {
                let var_28 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_28);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_from_email_address_not_verified_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::from_email_address_not_verified_exception::Builder,
) -> Result<
    crate::error::from_email_address_not_verified_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FromEmailAddress") /* FromEmailAddress com.amazonaws.ses#FromEmailAddressNotVerifiedException$FromEmailAddress */ =>  {
                let var_29 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_from_email_address(var_29);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#FromEmailAddressNotVerifiedException$message */ =>  {
                let var_30 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_30);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_lambda_function_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_lambda_function_exception::Builder,
) -> Result<
    crate::error::invalid_lambda_function_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FunctionArn") /* FunctionArn com.amazonaws.ses#InvalidLambdaFunctionException$FunctionArn */ =>  {
                let var_31 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_function_arn(var_31);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidLambdaFunctionException$message */ =>  {
                let var_32 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_32);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_s3_configuration_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_s3_configuration_exception::Builder,
) -> Result<
    crate::error::invalid_s3_configuration_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.ses#InvalidS3ConfigurationException$Bucket */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_33);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidS3ConfigurationException$message */ =>  {
                let var_34 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_34);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_sns_topic_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_sns_topic_exception::Builder,
) -> Result<crate::error::invalid_sns_topic_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Topic") /* Topic com.amazonaws.ses#InvalidSnsTopicException$Topic */ =>  {
                let var_35 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic(var_35);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidSnsTopicException$message */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_36);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_rule_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::rule_does_not_exist_exception::Builder,
) -> Result<crate::error::rule_does_not_exist_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#RuleDoesNotExistException$message */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_37);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.ses#RuleDoesNotExistException$Name */ =>  {
                let var_38 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_38);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_template_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_template_exception::Builder,
) -> Result<crate::error::invalid_template_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#InvalidTemplateException$TemplateName */ =>  {
                let var_39 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_39);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidTemplateException$message */ =>  {
                let var_40 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_40);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_event_destination_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::event_destination_does_not_exist_exception::Builder,
) -> Result<
    crate::error::event_destination_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventDestinationName") /* EventDestinationName com.amazonaws.ses#EventDestinationDoesNotExistException$EventDestinationName */ =>  {
                let var_41 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_destination_name(var_41);
            }
            ,
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#EventDestinationDoesNotExistException$ConfigurationSetName */ =>  {
                let var_42 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_42);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#EventDestinationDoesNotExistException$message */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_tracking_options_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::tracking_options_does_not_exist_exception::Builder,
) -> Result<
    crate::error::tracking_options_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#TrackingOptionsDoesNotExistException$ConfigurationSetName */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_44);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#TrackingOptionsDoesNotExistException$message */ =>  {
                let var_45 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_45);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cannot_delete_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::cannot_delete_exception::Builder,
) -> Result<crate::error::cannot_delete_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#CannotDeleteException$message */ =>  {
                let var_46 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_46);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.ses#CannotDeleteException$Name */ =>  {
                let var_47 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_47);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_active_receipt_rule_set(
    inp: &[u8],
    mut builder: crate::output::describe_active_receipt_rule_set_output::Builder,
) -> Result<
    crate::output::describe_active_receipt_rule_set_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeActiveReceiptRuleSetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeActiveReceiptRuleSetResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeActiveReceiptRuleSetResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeActiveReceiptRuleSetResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Metadata") /* Metadata com.amazonaws.ses.synthetic#DescribeActiveReceiptRuleSetOutput$Metadata */ =>  {
                let var_48 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_receipt_rule_set_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metadata(var_48);
            }
            ,
            s if s.matches("Rules") /* Rules com.amazonaws.ses.synthetic#DescribeActiveReceiptRuleSetOutput$Rules */ =>  {
                let var_49 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_receipt_rules_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rules(var_49);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeActiveReceiptRuleSetResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_configuration_set(
    inp: &[u8],
    mut builder: crate::output::describe_configuration_set_output::Builder,
) -> Result<
    crate::output::describe_configuration_set_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeConfigurationSetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeConfigurationSetResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeConfigurationSetResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeConfigurationSetResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ConfigurationSet") /* ConfigurationSet com.amazonaws.ses.synthetic#DescribeConfigurationSetOutput$ConfigurationSet */ =>  {
                let var_50 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_configuration_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration_set(var_50);
            }
            ,
            s if s.matches("EventDestinations") /* EventDestinations com.amazonaws.ses.synthetic#DescribeConfigurationSetOutput$EventDestinations */ =>  {
                let var_51 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_event_destinations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_destinations(var_51);
            }
            ,
            s if s.matches("TrackingOptions") /* TrackingOptions com.amazonaws.ses.synthetic#DescribeConfigurationSetOutput$TrackingOptions */ =>  {
                let var_52 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_tracking_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tracking_options(var_52);
            }
            ,
            s if s.matches("DeliveryOptions") /* DeliveryOptions com.amazonaws.ses.synthetic#DescribeConfigurationSetOutput$DeliveryOptions */ =>  {
                let var_53 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_delivery_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_delivery_options(var_53);
            }
            ,
            s if s.matches("ReputationOptions") /* ReputationOptions com.amazonaws.ses.synthetic#DescribeConfigurationSetOutput$ReputationOptions */ =>  {
                let var_54 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_reputation_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reputation_options(var_54);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeConfigurationSetResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_receipt_rule(
    inp: &[u8],
    mut builder: crate::output::describe_receipt_rule_output::Builder,
) -> Result<crate::output::describe_receipt_rule_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReceiptRuleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReceiptRuleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeReceiptRuleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeReceiptRuleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Rule") /* Rule com.amazonaws.ses.synthetic#DescribeReceiptRuleOutput$Rule */ =>  {
                let var_55 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_receipt_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rule(var_55);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeReceiptRuleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_receipt_rule_set(
    inp: &[u8],
    mut builder: crate::output::describe_receipt_rule_set_output::Builder,
) -> Result<
    crate::output::describe_receipt_rule_set_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReceiptRuleSetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReceiptRuleSetResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeReceiptRuleSetResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeReceiptRuleSetResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Metadata") /* Metadata com.amazonaws.ses.synthetic#DescribeReceiptRuleSetOutput$Metadata */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_receipt_rule_set_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metadata(var_56);
            }
            ,
            s if s.matches("Rules") /* Rules com.amazonaws.ses.synthetic#DescribeReceiptRuleSetOutput$Rules */ =>  {
                let var_57 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_receipt_rules_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rules(var_57);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeReceiptRuleSetResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_account_sending_enabled(
    inp: &[u8],
    mut builder: crate::output::get_account_sending_enabled_output::Builder,
) -> Result<
    crate::output::get_account_sending_enabled_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccountSendingEnabledResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccountSendingEnabledResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetAccountSendingEnabledResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetAccountSendingEnabledResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Enabled") /* Enabled com.amazonaws.ses.synthetic#GetAccountSendingEnabledOutput$Enabled */ =>  {
                let var_58 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_58);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetAccountSendingEnabledResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_custom_verification_email_template_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::custom_verification_email_template_does_not_exist_exception::Builder,
) -> Result<
    crate::error::custom_verification_email_template_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CustomVerificationEmailTemplateName") /* CustomVerificationEmailTemplateName com.amazonaws.ses#CustomVerificationEmailTemplateDoesNotExistException$CustomVerificationEmailTemplateName */ =>  {
                let var_59 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_custom_verification_email_template_name(var_59);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#CustomVerificationEmailTemplateDoesNotExistException$message */ =>  {
                let var_60 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_60);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_custom_verification_email_template(
    inp: &[u8],
    mut builder: crate::output::get_custom_verification_email_template_output::Builder,
) -> Result<
    crate::output::get_custom_verification_email_template_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetCustomVerificationEmailTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetCustomVerificationEmailTemplateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetCustomVerificationEmailTemplateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetCustomVerificationEmailTemplateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$TemplateName */ =>  {
                let var_61 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_61);
            }
            ,
            s if s.matches("FromEmailAddress") /* FromEmailAddress com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$FromEmailAddress */ =>  {
                let var_62 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_from_email_address(var_62);
            }
            ,
            s if s.matches("TemplateSubject") /* TemplateSubject com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$TemplateSubject */ =>  {
                let var_63 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_subject(var_63);
            }
            ,
            s if s.matches("TemplateContent") /* TemplateContent com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$TemplateContent */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_content(var_64);
            }
            ,
            s if s.matches("SuccessRedirectionURL") /* SuccessRedirectionURL com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$SuccessRedirectionURL */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_success_redirection_url(var_65);
            }
            ,
            s if s.matches("FailureRedirectionURL") /* FailureRedirectionURL com.amazonaws.ses.synthetic#GetCustomVerificationEmailTemplateOutput$FailureRedirectionURL */ =>  {
                let var_66 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_redirection_url(var_66);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetCustomVerificationEmailTemplateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_identity_dkim_attributes(
    inp: &[u8],
    mut builder: crate::output::get_identity_dkim_attributes_output::Builder,
) -> Result<
    crate::output::get_identity_dkim_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIdentityDkimAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIdentityDkimAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetIdentityDkimAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetIdentityDkimAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DkimAttributes") /* DkimAttributes com.amazonaws.ses.synthetic#GetIdentityDkimAttributesOutput$DkimAttributes */ =>  {
                let var_67 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_ses_dkim_attributes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dkim_attributes(var_67);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetIdentityDkimAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_identity_mail_from_domain_attributes(
    inp: &[u8],
    mut builder: crate::output::get_identity_mail_from_domain_attributes_output::Builder,
) -> Result<
    crate::output::get_identity_mail_from_domain_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIdentityMailFromDomainAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIdentityMailFromDomainAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetIdentityMailFromDomainAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetIdentityMailFromDomainAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MailFromDomainAttributes") /* MailFromDomainAttributes com.amazonaws.ses.synthetic#GetIdentityMailFromDomainAttributesOutput$MailFromDomainAttributes */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_ses_mail_from_domain_attributes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_mail_from_domain_attributes(var_68);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetIdentityMailFromDomainAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_identity_notification_attributes(
    inp: &[u8],
    mut builder: crate::output::get_identity_notification_attributes_output::Builder,
) -> Result<
    crate::output::get_identity_notification_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIdentityNotificationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIdentityNotificationAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetIdentityNotificationAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetIdentityNotificationAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("NotificationAttributes") /* NotificationAttributes com.amazonaws.ses.synthetic#GetIdentityNotificationAttributesOutput$NotificationAttributes */ =>  {
                let var_69 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_ses_notification_attributes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_notification_attributes(var_69);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetIdentityNotificationAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_identity_policies(
    inp: &[u8],
    mut builder: crate::output::get_identity_policies_output::Builder,
) -> Result<crate::output::get_identity_policies_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIdentityPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIdentityPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetIdentityPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetIdentityPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Policies") /* Policies com.amazonaws.ses.synthetic#GetIdentityPoliciesOutput$Policies */ =>  {
                let var_70 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_ses_policy_map(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policies(var_70);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetIdentityPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_identity_verification_attributes(
    inp: &[u8],
    mut builder: crate::output::get_identity_verification_attributes_output::Builder,
) -> Result<
    crate::output::get_identity_verification_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIdentityVerificationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIdentityVerificationAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetIdentityVerificationAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetIdentityVerificationAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("VerificationAttributes") /* VerificationAttributes com.amazonaws.ses.synthetic#GetIdentityVerificationAttributesOutput$VerificationAttributes */ =>  {
                let var_71 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_ses_verification_attributes(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_verification_attributes(var_71);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetIdentityVerificationAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_send_quota(
    inp: &[u8],
    mut builder: crate::output::get_send_quota_output::Builder,
) -> Result<crate::output::get_send_quota_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSendQuotaResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSendQuotaResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetSendQuotaResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetSendQuotaResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Max24HourSend") /* Max24HourSend com.amazonaws.ses.synthetic#GetSendQuotaOutput$Max24HourSend */ =>  {
                let var_72 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.ses#Max24HourSend`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max24_hour_send(var_72);
            }
            ,
            s if s.matches("MaxSendRate") /* MaxSendRate com.amazonaws.ses.synthetic#GetSendQuotaOutput$MaxSendRate */ =>  {
                let var_73 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.ses#MaxSendRate`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_send_rate(var_73);
            }
            ,
            s if s.matches("SentLast24Hours") /* SentLast24Hours com.amazonaws.ses.synthetic#GetSendQuotaOutput$SentLast24Hours */ =>  {
                let var_74 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.ses#SentLast24Hours`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sent_last24_hours(var_74);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetSendQuotaResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_send_statistics(
    inp: &[u8],
    mut builder: crate::output::get_send_statistics_output::Builder,
) -> Result<crate::output::get_send_statistics_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSendStatisticsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSendStatisticsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetSendStatisticsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetSendStatisticsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SendDataPoints") /* SendDataPoints com.amazonaws.ses.synthetic#GetSendStatisticsOutput$SendDataPoints */ =>  {
                let var_75 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_send_data_point_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_send_data_points(var_75);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetSendStatisticsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_template_does_not_exist_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::template_does_not_exist_exception::Builder,
) -> Result<
    crate::error::template_does_not_exist_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#TemplateDoesNotExistException$TemplateName */ =>  {
                let var_76 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_76);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#TemplateDoesNotExistException$message */ =>  {
                let var_77 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_77);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_template(
    inp: &[u8],
    mut builder: crate::output::get_template_output::Builder,
) -> Result<crate::output::get_template_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTemplateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetTemplateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetTemplateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Template") /* Template com.amazonaws.ses.synthetic#GetTemplateOutput$Template */ =>  {
                let var_78 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_template(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_template(var_78);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetTemplateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_configuration_sets(
    inp: &[u8],
    mut builder: crate::output::list_configuration_sets_output::Builder,
) -> Result<crate::output::list_configuration_sets_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListConfigurationSetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListConfigurationSetsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListConfigurationSetsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListConfigurationSetsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ConfigurationSets") /* ConfigurationSets com.amazonaws.ses.synthetic#ListConfigurationSetsOutput$ConfigurationSets */ =>  {
                let var_79 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_configuration_sets(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration_sets(var_79);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.ses.synthetic#ListConfigurationSetsOutput$NextToken */ =>  {
                let var_80 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_80);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListConfigurationSetsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_custom_verification_email_templates(
    inp: &[u8],
    mut builder: crate::output::list_custom_verification_email_templates_output::Builder,
) -> Result<
    crate::output::list_custom_verification_email_templates_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListCustomVerificationEmailTemplatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListCustomVerificationEmailTemplatesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListCustomVerificationEmailTemplatesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListCustomVerificationEmailTemplatesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("CustomVerificationEmailTemplates") /* CustomVerificationEmailTemplates com.amazonaws.ses.synthetic#ListCustomVerificationEmailTemplatesOutput$CustomVerificationEmailTemplates */ =>  {
                let var_81 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_custom_verification_email_templates(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_custom_verification_email_templates(var_81);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.ses.synthetic#ListCustomVerificationEmailTemplatesOutput$NextToken */ =>  {
                let var_82 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_82);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListCustomVerificationEmailTemplatesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_identities(
    inp: &[u8],
    mut builder: crate::output::list_identities_output::Builder,
) -> Result<crate::output::list_identities_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListIdentitiesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListIdentitiesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListIdentitiesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListIdentitiesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Identities") /* Identities com.amazonaws.ses.synthetic#ListIdentitiesOutput$Identities */ =>  {
                let var_83 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_identity_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_identities(var_83);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.ses.synthetic#ListIdentitiesOutput$NextToken */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_84);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListIdentitiesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_identity_policies(
    inp: &[u8],
    mut builder: crate::output::list_identity_policies_output::Builder,
) -> Result<crate::output::list_identity_policies_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListIdentityPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListIdentityPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListIdentityPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListIdentityPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyNames") /* PolicyNames com.amazonaws.ses.synthetic#ListIdentityPoliciesOutput$PolicyNames */ =>  {
                let var_85 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_policy_name_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_names(var_85);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListIdentityPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_receipt_filters(
    inp: &[u8],
    mut builder: crate::output::list_receipt_filters_output::Builder,
) -> Result<crate::output::list_receipt_filters_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListReceiptFiltersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListReceiptFiltersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListReceiptFiltersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListReceiptFiltersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Filters") /* Filters com.amazonaws.ses.synthetic#ListReceiptFiltersOutput$Filters */ =>  {
                let var_86 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_receipt_filter_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filters(var_86);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListReceiptFiltersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_receipt_rule_sets(
    inp: &[u8],
    mut builder: crate::output::list_receipt_rule_sets_output::Builder,
) -> Result<crate::output::list_receipt_rule_sets_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListReceiptRuleSetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListReceiptRuleSetsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListReceiptRuleSetsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListReceiptRuleSetsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("RuleSets") /* RuleSets com.amazonaws.ses.synthetic#ListReceiptRuleSetsOutput$RuleSets */ =>  {
                let var_87 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_receipt_rule_sets_lists(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rule_sets(var_87);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.ses.synthetic#ListReceiptRuleSetsOutput$NextToken */ =>  {
                let var_88 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_88);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListReceiptRuleSetsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_templates(
    inp: &[u8],
    mut builder: crate::output::list_templates_output::Builder,
) -> Result<crate::output::list_templates_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListTemplatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListTemplatesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListTemplatesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListTemplatesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TemplatesMetadata") /* TemplatesMetadata com.amazonaws.ses.synthetic#ListTemplatesOutput$TemplatesMetadata */ =>  {
                let var_89 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_template_metadata_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_templates_metadata(var_89);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.ses.synthetic#ListTemplatesOutput$NextToken */ =>  {
                let var_90 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_90);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListTemplatesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_verified_email_addresses(
    inp: &[u8],
    mut builder: crate::output::list_verified_email_addresses_output::Builder,
) -> Result<
    crate::output::list_verified_email_addresses_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListVerifiedEmailAddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListVerifiedEmailAddressesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListVerifiedEmailAddressesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListVerifiedEmailAddressesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("VerifiedEmailAddresses") /* VerifiedEmailAddresses com.amazonaws.ses.synthetic#ListVerifiedEmailAddressesOutput$VerifiedEmailAddresses */ =>  {
                let var_91 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_address_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_verified_email_addresses(var_91);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListVerifiedEmailAddressesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_delivery_options_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_delivery_options_exception::Builder,
) -> Result<
    crate::error::invalid_delivery_options_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#InvalidDeliveryOptionsException$message */ =>  {
                let var_92 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_92);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_policy_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_policy_exception::Builder,
) -> Result<crate::error::invalid_policy_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#InvalidPolicyException$message */ =>  {
                let var_93 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_93);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_message_rejected_xml_err(
    inp: &[u8],
    mut builder: crate::error::message_rejected::Builder,
) -> Result<crate::error::message_rejected::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#MessageRejected$message */ =>  {
                let var_94 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_94);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_bounce(
    inp: &[u8],
    mut builder: crate::output::send_bounce_output::Builder,
) -> Result<crate::output::send_bounce_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendBounceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendBounceResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendBounceResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendBounceResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses.synthetic#SendBounceOutput$MessageId */ =>  {
                let var_95 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_95);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendBounceResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_account_sending_paused_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::account_sending_paused_exception::Builder,
) -> Result<crate::error::account_sending_paused_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#AccountSendingPausedException$message */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_configuration_set_sending_paused_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::configuration_set_sending_paused_exception::Builder,
) -> Result<
    crate::error::configuration_set_sending_paused_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConfigurationSetName") /* ConfigurationSetName com.amazonaws.ses#ConfigurationSetSendingPausedException$ConfigurationSetName */ =>  {
                let var_97 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_configuration_set_name(var_97);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#ConfigurationSetSendingPausedException$message */ =>  {
                let var_98 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_98);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_mail_from_domain_not_verified_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::mail_from_domain_not_verified_exception::Builder,
) -> Result<
    crate::error::mail_from_domain_not_verified_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#MailFromDomainNotVerifiedException$message */ =>  {
                let var_99 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_99);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_bulk_templated_email(
    inp: &[u8],
    mut builder: crate::output::send_bulk_templated_email_output::Builder,
) -> Result<
    crate::output::send_bulk_templated_email_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendBulkTemplatedEmailResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendBulkTemplatedEmailResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendBulkTemplatedEmailResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendBulkTemplatedEmailResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.ses.synthetic#SendBulkTemplatedEmailOutput$Status */ =>  {
                let var_100 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_bulk_email_destination_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_100);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendBulkTemplatedEmailResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_production_access_not_granted_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::production_access_not_granted_exception::Builder,
) -> Result<
    crate::error::production_access_not_granted_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.ses#ProductionAccessNotGrantedException$message */ =>  {
                let var_101 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_101);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_custom_verification_email(
    inp: &[u8],
    mut builder: crate::output::send_custom_verification_email_output::Builder,
) -> Result<
    crate::output::send_custom_verification_email_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendCustomVerificationEmailResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendCustomVerificationEmailResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendCustomVerificationEmailResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendCustomVerificationEmailResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses.synthetic#SendCustomVerificationEmailOutput$MessageId */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_102);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendCustomVerificationEmailResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_email(
    inp: &[u8],
    mut builder: crate::output::send_email_output::Builder,
) -> Result<crate::output::send_email_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendEmailResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendEmailResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendEmailResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendEmailResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses.synthetic#SendEmailOutput$MessageId */ =>  {
                let var_103 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_103);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendEmailResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_raw_email(
    inp: &[u8],
    mut builder: crate::output::send_raw_email_output::Builder,
) -> Result<crate::output::send_raw_email_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendRawEmailResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendRawEmailResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendRawEmailResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendRawEmailResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses.synthetic#SendRawEmailOutput$MessageId */ =>  {
                let var_104 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_104);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendRawEmailResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_templated_email(
    inp: &[u8],
    mut builder: crate::output::send_templated_email_output::Builder,
) -> Result<crate::output::send_templated_email_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendTemplatedEmailResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendTemplatedEmailResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendTemplatedEmailResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendTemplatedEmailResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses.synthetic#SendTemplatedEmailOutput$MessageId */ =>  {
                let var_105 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_105);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendTemplatedEmailResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_rendering_parameter_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_rendering_parameter_exception::Builder,
) -> Result<
    crate::error::invalid_rendering_parameter_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#InvalidRenderingParameterException$TemplateName */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_106);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#InvalidRenderingParameterException$message */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_107);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_missing_rendering_attribute_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::missing_rendering_attribute_exception::Builder,
) -> Result<
    crate::error::missing_rendering_attribute_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#MissingRenderingAttributeException$TemplateName */ =>  {
                let var_108 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_108);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.ses#MissingRenderingAttributeException$message */ =>  {
                let var_109 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_109);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_test_render_template(
    inp: &[u8],
    mut builder: crate::output::test_render_template_output::Builder,
) -> Result<crate::output::test_render_template_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("TestRenderTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected TestRenderTemplateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("TestRenderTemplateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected TestRenderTemplateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("RenderedTemplate") /* RenderedTemplate com.amazonaws.ses.synthetic#TestRenderTemplateOutput$RenderedTemplate */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_rendered_template(var_110);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected TestRenderTemplateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_verify_domain_dkim(
    inp: &[u8],
    mut builder: crate::output::verify_domain_dkim_output::Builder,
) -> Result<crate::output::verify_domain_dkim_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("VerifyDomainDkimResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected VerifyDomainDkimResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("VerifyDomainDkimResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected VerifyDomainDkimResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DkimTokens") /* DkimTokens com.amazonaws.ses.synthetic#VerifyDomainDkimOutput$DkimTokens */ =>  {
                let var_111 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_verification_token_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dkim_tokens(var_111);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected VerifyDomainDkimResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_verify_domain_identity(
    inp: &[u8],
    mut builder: crate::output::verify_domain_identity_output::Builder,
) -> Result<crate::output::verify_domain_identity_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("VerifyDomainIdentityResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected VerifyDomainIdentityResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("VerifyDomainIdentityResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected VerifyDomainIdentityResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("VerificationToken") /* VerificationToken com.amazonaws.ses.synthetic#VerifyDomainIdentityOutput$VerificationToken */ =>  {
                let var_112 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_verification_token(var_112);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected VerifyDomainIdentityResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_structure_crate_model_receipt_rule_set_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReceiptRuleSetMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReceiptRuleSetMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#ReceiptRuleSetMetadata$Name */ =>  {
                let var_113 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_113);
            }
            ,
            s if s.matches("CreatedTimestamp") /* CreatedTimestamp com.amazonaws.ses#ReceiptRuleSetMetadata$CreatedTimestamp */ =>  {
                let var_114 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ses#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_created_timestamp(var_114);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_receipt_rules_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReceiptRule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#ReceiptRulesList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_receipt_rule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_configuration_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ConfigurationSet, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ConfigurationSet::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#ConfigurationSet$Name */ =>  {
                let var_115 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_115);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_event_destinations(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventDestination>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#EventDestinations$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event_destination(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_tracking_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TrackingOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TrackingOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CustomRedirectDomain") /* CustomRedirectDomain com.amazonaws.ses#TrackingOptions$CustomRedirectDomain */ =>  {
                let var_116 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_custom_redirect_domain(var_116);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_delivery_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeliveryOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeliveryOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TlsPolicy") /* TlsPolicy com.amazonaws.ses#DeliveryOptions$TlsPolicy */ =>  {
                let var_117 =
                    Some(
                        Result::<crate::model::TlsPolicy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TlsPolicy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_tls_policy(var_117);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_reputation_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReputationOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReputationOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SendingEnabled") /* SendingEnabled com.amazonaws.ses#ReputationOptions$SendingEnabled */ =>  {
                let var_118 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sending_enabled(var_118);
            }
            ,
            s if s.matches("ReputationMetricsEnabled") /* ReputationMetricsEnabled com.amazonaws.ses#ReputationOptions$ReputationMetricsEnabled */ =>  {
                let var_119 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_reputation_metrics_enabled(var_119);
            }
            ,
            s if s.matches("LastFreshStart") /* LastFreshStart com.amazonaws.ses#ReputationOptions$LastFreshStart */ =>  {
                let var_120 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ses#LastFreshStart`)"))
                        ?
                    )
                ;
                builder = builder.set_last_fresh_start(var_120);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_receipt_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReceiptRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReceiptRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#ReceiptRule$Name */ =>  {
                let var_121 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_121);
            }
            ,
            s if s.matches("Enabled") /* Enabled com.amazonaws.ses#ReceiptRule$Enabled */ =>  {
                let var_122 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_122);
            }
            ,
            s if s.matches("TlsPolicy") /* TlsPolicy com.amazonaws.ses#ReceiptRule$TlsPolicy */ =>  {
                let var_123 =
                    Some(
                        Result::<crate::model::TlsPolicy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TlsPolicy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_tls_policy(var_123);
            }
            ,
            s if s.matches("Recipients") /* Recipients com.amazonaws.ses#ReceiptRule$Recipients */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_recipients_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_recipients(var_124);
            }
            ,
            s if s.matches("Actions") /* Actions com.amazonaws.ses#ReceiptRule$Actions */ =>  {
                let var_125 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_receipt_actions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_actions(var_125);
            }
            ,
            s if s.matches("ScanEnabled") /* ScanEnabled com.amazonaws.ses#ReceiptRule$ScanEnabled */ =>  {
                let var_126 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_scan_enabled(var_126);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_ses_dkim_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, crate::model::IdentityDkimAttributes>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_ses_dkim_attributes_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_ses_mail_from_domain_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, crate::model::IdentityMailFromDomainAttributes>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_ses_mail_from_domain_attributes_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_ses_notification_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, crate::model::IdentityNotificationAttributes>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_ses_notification_attributes_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_ses_policy_map(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, std::string::String>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_ses_policy_map_entry(&mut tag, &mut out)?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_ses_verification_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, crate::model::IdentityVerificationAttributes>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_ses_verification_attributes_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_send_data_point_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SendDataPoint>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#SendDataPointList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_send_data_point(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_template(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Template, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Template::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#Template$TemplateName */ =>  {
                let var_127 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_127);
            }
            ,
            s if s.matches("SubjectPart") /* SubjectPart com.amazonaws.ses#Template$SubjectPart */ =>  {
                let var_128 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subject_part(var_128);
            }
            ,
            s if s.matches("TextPart") /* TextPart com.amazonaws.ses#Template$TextPart */ =>  {
                let var_129 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_text_part(var_129);
            }
            ,
            s if s.matches("HtmlPart") /* HtmlPart com.amazonaws.ses#Template$HtmlPart */ =>  {
                let var_130 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_html_part(var_130);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_configuration_sets(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ConfigurationSet>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#ConfigurationSets$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_configuration_set(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_custom_verification_email_templates(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CustomVerificationEmailTemplate>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#CustomVerificationEmailTemplates$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_custom_verification_email_template(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_identity_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#IdentityList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_policy_name_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#PolicyNameList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_receipt_filter_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReceiptFilter>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#ReceiptFilterList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_receipt_filter(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_receipt_rule_sets_lists(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReceiptRuleSetMetadata>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#ReceiptRuleSetsLists$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_receipt_rule_set_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_template_metadata_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::TemplateMetadata>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#TemplateMetadataList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_template_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_address_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#AddressList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_bulk_email_destination_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::BulkEmailDestinationStatus>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#BulkEmailDestinationStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_bulk_email_destination_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_verification_token_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#VerificationTokenList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_event_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#EventDestination$Name */ =>  {
                let var_131 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_131);
            }
            ,
            s if s.matches("Enabled") /* Enabled com.amazonaws.ses#EventDestination$Enabled */ =>  {
                let var_132 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_132);
            }
            ,
            s if s.matches("MatchingEventTypes") /* MatchingEventTypes com.amazonaws.ses#EventDestination$MatchingEventTypes */ =>  {
                let var_133 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_event_types(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_matching_event_types(var_133);
            }
            ,
            s if s.matches("KinesisFirehoseDestination") /* KinesisFirehoseDestination com.amazonaws.ses#EventDestination$KinesisFirehoseDestination */ =>  {
                let var_134 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_kinesis_firehose_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_kinesis_firehose_destination(var_134);
            }
            ,
            s if s.matches("CloudWatchDestination") /* CloudWatchDestination com.amazonaws.ses#EventDestination$CloudWatchDestination */ =>  {
                let var_135 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cloud_watch_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cloud_watch_destination(var_135);
            }
            ,
            s if s.matches("SNSDestination") /* SNSDestination com.amazonaws.ses#EventDestination$SNSDestination */ =>  {
                let var_136 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_sns_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sns_destination(var_136);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_recipients_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#RecipientsList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ses_receipt_actions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReceiptAction>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#ReceiptActionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_receipt_action(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_ses_dkim_attributes_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, crate::model::IdentityDkimAttributes>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::IdentityDkimAttributes> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.ses#DkimAttributes$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.ses#DkimAttributes$value */ =>  {
                v = Some(
                    crate::xml_deser::deser_structure_crate_model_identity_dkim_attributes(&mut tag)
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_ses_mail_from_domain_attributes_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<
        std::string::String,
        crate::model::IdentityMailFromDomainAttributes,
    >,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::IdentityMailFromDomainAttributes> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.ses#MailFromDomainAttributes$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.ses#MailFromDomainAttributes$value */ =>  {
                v = Some(
                    crate::xml_deser::deser_structure_crate_model_identity_mail_from_domain_attributes(&mut tag)
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_ses_notification_attributes_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<
        std::string::String,
        crate::model::IdentityNotificationAttributes,
    >,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::IdentityNotificationAttributes> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.ses#NotificationAttributes$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.ses#NotificationAttributes$value */ =>  {
                v = Some(
                    crate::xml_deser::deser_structure_crate_model_identity_notification_attributes(&mut tag)
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_ses_policy_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.ses#PolicyMap$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.ses#PolicyMap$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_ses_verification_attributes_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<
        std::string::String,
        crate::model::IdentityVerificationAttributes,
    >,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::IdentityVerificationAttributes> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.ses#VerificationAttributes$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.ses#VerificationAttributes$value */ =>  {
                v = Some(
                    crate::xml_deser::deser_structure_crate_model_identity_verification_attributes(&mut tag)
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_send_data_point(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SendDataPoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SendDataPoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Timestamp") /* Timestamp com.amazonaws.ses#SendDataPoint$Timestamp */ =>  {
                let var_137 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ses#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_137);
            }
            ,
            s if s.matches("DeliveryAttempts") /* DeliveryAttempts com.amazonaws.ses#SendDataPoint$DeliveryAttempts */ =>  {
                let var_138 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.ses#Counter`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delivery_attempts(var_138);
            }
            ,
            s if s.matches("Bounces") /* Bounces com.amazonaws.ses#SendDataPoint$Bounces */ =>  {
                let var_139 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.ses#Counter`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bounces(var_139);
            }
            ,
            s if s.matches("Complaints") /* Complaints com.amazonaws.ses#SendDataPoint$Complaints */ =>  {
                let var_140 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.ses#Counter`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_complaints(var_140);
            }
            ,
            s if s.matches("Rejects") /* Rejects com.amazonaws.ses#SendDataPoint$Rejects */ =>  {
                let var_141 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.ses#Counter`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_rejects(var_141);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_custom_verification_email_template(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CustomVerificationEmailTemplate, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CustomVerificationEmailTemplate::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TemplateName") /* TemplateName com.amazonaws.ses#CustomVerificationEmailTemplate$TemplateName */ =>  {
                let var_142 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_name(var_142);
            }
            ,
            s if s.matches("FromEmailAddress") /* FromEmailAddress com.amazonaws.ses#CustomVerificationEmailTemplate$FromEmailAddress */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_from_email_address(var_143);
            }
            ,
            s if s.matches("TemplateSubject") /* TemplateSubject com.amazonaws.ses#CustomVerificationEmailTemplate$TemplateSubject */ =>  {
                let var_144 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_template_subject(var_144);
            }
            ,
            s if s.matches("SuccessRedirectionURL") /* SuccessRedirectionURL com.amazonaws.ses#CustomVerificationEmailTemplate$SuccessRedirectionURL */ =>  {
                let var_145 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_success_redirection_url(var_145);
            }
            ,
            s if s.matches("FailureRedirectionURL") /* FailureRedirectionURL com.amazonaws.ses#CustomVerificationEmailTemplate$FailureRedirectionURL */ =>  {
                let var_146 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_redirection_url(var_146);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_receipt_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReceiptFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReceiptFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#ReceiptFilter$Name */ =>  {
                let var_147 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_147);
            }
            ,
            s if s.matches("IpFilter") /* IpFilter com.amazonaws.ses#ReceiptFilter$IpFilter */ =>  {
                let var_148 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_receipt_ip_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ip_filter(var_148);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_template_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TemplateMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TemplateMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.ses#TemplateMetadata$Name */ =>  {
                let var_149 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_149);
            }
            ,
            s if s.matches("CreatedTimestamp") /* CreatedTimestamp com.amazonaws.ses#TemplateMetadata$CreatedTimestamp */ =>  {
                let var_150 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ses#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_created_timestamp(var_150);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_bulk_email_destination_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::BulkEmailDestinationStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::BulkEmailDestinationStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.ses#BulkEmailDestinationStatus$Status */ =>  {
                let var_151 =
                    Some(
                        Result::<crate::model::BulkEmailStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BulkEmailStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_151);
            }
            ,
            s if s.matches("Error") /* Error com.amazonaws.ses#BulkEmailDestinationStatus$Error */ =>  {
                let var_152 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_error(var_152);
            }
            ,
            s if s.matches("MessageId") /* MessageId com.amazonaws.ses#BulkEmailDestinationStatus$MessageId */ =>  {
                let var_153 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_153);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_event_types(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventType>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#EventTypes$member */ =>  {
                out.push(
                    Result::<crate::model::EventType, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::EventType::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_kinesis_firehose_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::KinesisFirehoseDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::KinesisFirehoseDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IAMRoleARN") /* IAMRoleARN com.amazonaws.ses#KinesisFirehoseDestination$IAMRoleARN */ =>  {
                let var_154 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_iam_role_arn(var_154);
            }
            ,
            s if s.matches("DeliveryStreamARN") /* DeliveryStreamARN com.amazonaws.ses#KinesisFirehoseDestination$DeliveryStreamARN */ =>  {
                let var_155 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delivery_stream_arn(var_155);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cloud_watch_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CloudWatchDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CloudWatchDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DimensionConfigurations") /* DimensionConfigurations com.amazonaws.ses#CloudWatchDestination$DimensionConfigurations */ =>  {
                let var_156 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_cloud_watch_dimension_configurations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dimension_configurations(var_156);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_sns_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SnsDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SnsDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicARN") /* TopicARN com.amazonaws.ses#SNSDestination$TopicARN */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_157);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_receipt_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReceiptAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReceiptAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3Action") /* S3Action com.amazonaws.ses#ReceiptAction$S3Action */ =>  {
                let var_158 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_action(var_158);
            }
            ,
            s if s.matches("BounceAction") /* BounceAction com.amazonaws.ses#ReceiptAction$BounceAction */ =>  {
                let var_159 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_bounce_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bounce_action(var_159);
            }
            ,
            s if s.matches("WorkmailAction") /* WorkmailAction com.amazonaws.ses#ReceiptAction$WorkmailAction */ =>  {
                let var_160 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_workmail_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_workmail_action(var_160);
            }
            ,
            s if s.matches("LambdaAction") /* LambdaAction com.amazonaws.ses#ReceiptAction$LambdaAction */ =>  {
                let var_161 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lambda_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_lambda_action(var_161);
            }
            ,
            s if s.matches("StopAction") /* StopAction com.amazonaws.ses#ReceiptAction$StopAction */ =>  {
                let var_162 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_stop_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_stop_action(var_162);
            }
            ,
            s if s.matches("AddHeaderAction") /* AddHeaderAction com.amazonaws.ses#ReceiptAction$AddHeaderAction */ =>  {
                let var_163 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_add_header_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_add_header_action(var_163);
            }
            ,
            s if s.matches("SNSAction") /* SNSAction com.amazonaws.ses#ReceiptAction$SNSAction */ =>  {
                let var_164 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_sns_action(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sns_action(var_164);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_identity_dkim_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IdentityDkimAttributes, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IdentityDkimAttributes::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DkimEnabled") /* DkimEnabled com.amazonaws.ses#IdentityDkimAttributes$DkimEnabled */ =>  {
                let var_165 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_dkim_enabled(var_165);
            }
            ,
            s if s.matches("DkimVerificationStatus") /* DkimVerificationStatus com.amazonaws.ses#IdentityDkimAttributes$DkimVerificationStatus */ =>  {
                let var_166 =
                    Some(
                        Result::<crate::model::VerificationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VerificationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_dkim_verification_status(var_166);
            }
            ,
            s if s.matches("DkimTokens") /* DkimTokens com.amazonaws.ses#IdentityDkimAttributes$DkimTokens */ =>  {
                let var_167 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ses_verification_token_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dkim_tokens(var_167);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_identity_mail_from_domain_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IdentityMailFromDomainAttributes, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IdentityMailFromDomainAttributes::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MailFromDomain") /* MailFromDomain com.amazonaws.ses#IdentityMailFromDomainAttributes$MailFromDomain */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_mail_from_domain(var_168);
            }
            ,
            s if s.matches("MailFromDomainStatus") /* MailFromDomainStatus com.amazonaws.ses#IdentityMailFromDomainAttributes$MailFromDomainStatus */ =>  {
                let var_169 =
                    Some(
                        Result::<crate::model::CustomMailFromStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CustomMailFromStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mail_from_domain_status(var_169);
            }
            ,
            s if s.matches("BehaviorOnMXFailure") /* BehaviorOnMXFailure com.amazonaws.ses#IdentityMailFromDomainAttributes$BehaviorOnMXFailure */ =>  {
                let var_170 =
                    Some(
                        Result::<crate::model::BehaviorOnMxFailure, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BehaviorOnMxFailure::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_behavior_on_mx_failure(var_170);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_identity_notification_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IdentityNotificationAttributes, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IdentityNotificationAttributes::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BounceTopic") /* BounceTopic com.amazonaws.ses#IdentityNotificationAttributes$BounceTopic */ =>  {
                let var_171 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bounce_topic(var_171);
            }
            ,
            s if s.matches("ComplaintTopic") /* ComplaintTopic com.amazonaws.ses#IdentityNotificationAttributes$ComplaintTopic */ =>  {
                let var_172 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_complaint_topic(var_172);
            }
            ,
            s if s.matches("DeliveryTopic") /* DeliveryTopic com.amazonaws.ses#IdentityNotificationAttributes$DeliveryTopic */ =>  {
                let var_173 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delivery_topic(var_173);
            }
            ,
            s if s.matches("ForwardingEnabled") /* ForwardingEnabled com.amazonaws.ses#IdentityNotificationAttributes$ForwardingEnabled */ =>  {
                let var_174 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_forwarding_enabled(var_174);
            }
            ,
            s if s.matches("HeadersInBounceNotificationsEnabled") /* HeadersInBounceNotificationsEnabled com.amazonaws.ses#IdentityNotificationAttributes$HeadersInBounceNotificationsEnabled */ =>  {
                let var_175 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_headers_in_bounce_notifications_enabled(var_175);
            }
            ,
            s if s.matches("HeadersInComplaintNotificationsEnabled") /* HeadersInComplaintNotificationsEnabled com.amazonaws.ses#IdentityNotificationAttributes$HeadersInComplaintNotificationsEnabled */ =>  {
                let var_176 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_headers_in_complaint_notifications_enabled(var_176);
            }
            ,
            s if s.matches("HeadersInDeliveryNotificationsEnabled") /* HeadersInDeliveryNotificationsEnabled com.amazonaws.ses#IdentityNotificationAttributes$HeadersInDeliveryNotificationsEnabled */ =>  {
                let var_177 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ses#Enabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_headers_in_delivery_notifications_enabled(var_177);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_identity_verification_attributes(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IdentityVerificationAttributes, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IdentityVerificationAttributes::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VerificationStatus") /* VerificationStatus com.amazonaws.ses#IdentityVerificationAttributes$VerificationStatus */ =>  {
                let var_178 =
                    Some(
                        Result::<crate::model::VerificationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VerificationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_verification_status(var_178);
            }
            ,
            s if s.matches("VerificationToken") /* VerificationToken com.amazonaws.ses#IdentityVerificationAttributes$VerificationToken */ =>  {
                let var_179 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_verification_token(var_179);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_receipt_ip_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReceiptIpFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReceiptIpFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.ses#ReceiptIpFilter$Policy */ =>  {
                let var_180 =
                    Some(
                        Result::<crate::model::ReceiptFilterPolicy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReceiptFilterPolicy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_180);
            }
            ,
            s if s.matches("Cidr") /* Cidr com.amazonaws.ses#ReceiptIpFilter$Cidr */ =>  {
                let var_181 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr(var_181);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ses_cloud_watch_dimension_configurations(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CloudWatchDimensionConfiguration>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.ses#CloudWatchDimensionConfigurations$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cloud_watch_dimension_configuration(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_s3_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Action, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Action::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#S3Action$TopicArn */ =>  {
                let var_182 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_182);
            }
            ,
            s if s.matches("BucketName") /* BucketName com.amazonaws.ses#S3Action$BucketName */ =>  {
                let var_183 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_name(var_183);
            }
            ,
            s if s.matches("ObjectKeyPrefix") /* ObjectKeyPrefix com.amazonaws.ses#S3Action$ObjectKeyPrefix */ =>  {
                let var_184 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_key_prefix(var_184);
            }
            ,
            s if s.matches("KmsKeyArn") /* KmsKeyArn com.amazonaws.ses#S3Action$KmsKeyArn */ =>  {
                let var_185 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_arn(var_185);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_bounce_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::BounceAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::BounceAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#BounceAction$TopicArn */ =>  {
                let var_186 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_186);
            }
            ,
            s if s.matches("SmtpReplyCode") /* SmtpReplyCode com.amazonaws.ses#BounceAction$SmtpReplyCode */ =>  {
                let var_187 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_smtp_reply_code(var_187);
            }
            ,
            s if s.matches("StatusCode") /* StatusCode com.amazonaws.ses#BounceAction$StatusCode */ =>  {
                let var_188 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_code(var_188);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.ses#BounceAction$Message */ =>  {
                let var_189 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_189);
            }
            ,
            s if s.matches("Sender") /* Sender com.amazonaws.ses#BounceAction$Sender */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sender(var_190);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_workmail_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::WorkmailAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::WorkmailAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#WorkmailAction$TopicArn */ =>  {
                let var_191 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_191);
            }
            ,
            s if s.matches("OrganizationArn") /* OrganizationArn com.amazonaws.ses#WorkmailAction$OrganizationArn */ =>  {
                let var_192 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_organization_arn(var_192);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lambda_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LambdaAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LambdaAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#LambdaAction$TopicArn */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_193);
            }
            ,
            s if s.matches("FunctionArn") /* FunctionArn com.amazonaws.ses#LambdaAction$FunctionArn */ =>  {
                let var_194 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_function_arn(var_194);
            }
            ,
            s if s.matches("InvocationType") /* InvocationType com.amazonaws.ses#LambdaAction$InvocationType */ =>  {
                let var_195 =
                    Some(
                        Result::<crate::model::InvocationType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InvocationType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_invocation_type(var_195);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_stop_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StopAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StopAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Scope") /* Scope com.amazonaws.ses#StopAction$Scope */ =>  {
                let var_196 =
                    Some(
                        Result::<crate::model::StopScope, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StopScope::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_scope(var_196);
            }
            ,
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#StopAction$TopicArn */ =>  {
                let var_197 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_197);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_add_header_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AddHeaderAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AddHeaderAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HeaderName") /* HeaderName com.amazonaws.ses#AddHeaderAction$HeaderName */ =>  {
                let var_198 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_header_name(var_198);
            }
            ,
            s if s.matches("HeaderValue") /* HeaderValue com.amazonaws.ses#AddHeaderAction$HeaderValue */ =>  {
                let var_199 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_header_value(var_199);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_sns_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SnsAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SnsAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TopicArn") /* TopicArn com.amazonaws.ses#SNSAction$TopicArn */ =>  {
                let var_200 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_200);
            }
            ,
            s if s.matches("Encoding") /* Encoding com.amazonaws.ses#SNSAction$Encoding */ =>  {
                let var_201 =
                    Some(
                        Result::<crate::model::SnsActionEncoding, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SnsActionEncoding::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding(var_201);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cloud_watch_dimension_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CloudWatchDimensionConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CloudWatchDimensionConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DimensionName") /* DimensionName com.amazonaws.ses#CloudWatchDimensionConfiguration$DimensionName */ =>  {
                let var_202 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dimension_name(var_202);
            }
            ,
            s if s.matches("DimensionValueSource") /* DimensionValueSource com.amazonaws.ses#CloudWatchDimensionConfiguration$DimensionValueSource */ =>  {
                let var_203 =
                    Some(
                        Result::<crate::model::DimensionValueSource, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DimensionValueSource::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_dimension_value_source(var_203);
            }
            ,
            s if s.matches("DefaultDimensionValue") /* DefaultDimensionValue com.amazonaws.ses#CloudWatchDimensionConfiguration$DefaultDimensionValue */ =>  {
                let var_204 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_dimension_value(var_204);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
