// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_clone_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CloneReceiptRuleSetOutput,
    crate::error::CloneReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CloneReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CloneReceiptRuleSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => crate::error::CloneReceiptRuleSetError {
            meta: generic,
            kind: crate::error::CloneReceiptRuleSetErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CloneReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CloneReceiptRuleSetError {
            meta: generic,
            kind: crate::error::CloneReceiptRuleSetErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CloneReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::CloneReceiptRuleSetError {
            meta: generic,
            kind: crate::error::CloneReceiptRuleSetErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CloneReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CloneReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_clone_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CloneReceiptRuleSetOutput,
    crate::error::CloneReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::clone_receipt_rule_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetOutput,
    crate::error::CreateConfigurationSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConfigurationSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateConfigurationSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetAlreadyExists" => crate::error::CreateConfigurationSetError { meta: generic, kind: crate::error::CreateConfigurationSetErrorKind::ConfigurationSetAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidConfigurationSet" => crate::error::CreateConfigurationSetError { meta: generic, kind: crate::error::CreateConfigurationSetErrorKind::InvalidConfigurationSetException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_configuration_set_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_configuration_set_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceeded" => crate::error::CreateConfigurationSetError { meta: generic, kind: crate::error::CreateConfigurationSetErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateConfigurationSetError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetOutput,
    crate::error::CreateConfigurationSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_configuration_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_event_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetEventDestinationOutput,
    crate::error::CreateConfigurationSetEventDestinationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateConfigurationSetEventDestinationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDestinationAlreadyExists" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::EventDestinationAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_destination_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_event_destination_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchDestination" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cloud_watch_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidFirehoseDestination" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_firehose_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_firehose_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSNSDestination" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sns_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_sns_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceeded" => crate::error::CreateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::CreateConfigurationSetEventDestinationErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateConfigurationSetEventDestinationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_event_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetEventDestinationOutput,
    crate::error::CreateConfigurationSetEventDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_configuration_set_event_destination_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_tracking_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetTrackingOptionsOutput,
    crate::error::CreateConfigurationSetTrackingOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateConfigurationSetTrackingOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateConfigurationSetTrackingOptionsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::CreateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::CreateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrackingOptions" => crate::error::CreateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::CreateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tracking_options_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tracking_options_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrackingOptionsAlreadyExistsException" => crate::error::CreateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::CreateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tracking_options_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tracking_options_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateConfigurationSetTrackingOptionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_configuration_set_tracking_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateConfigurationSetTrackingOptionsOutput,
    crate::error::CreateConfigurationSetTrackingOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_configuration_set_tracking_options_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_verification_email_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomVerificationEmailTemplateOutput,
    crate::error::CreateCustomVerificationEmailTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomVerificationEmailTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::CreateCustomVerificationEmailTemplateError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomVerificationEmailInvalidContent" => crate::error::CreateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_invalid_content_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_invalid_content_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomVerificationEmailTemplateAlreadyExists" => crate::error::CreateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_template_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_template_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FromEmailAddressNotVerified" => crate::error::CreateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::CreateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::from_email_address_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_from_email_address_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceeded" => crate::error::CreateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::CreateCustomVerificationEmailTemplateErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCustomVerificationEmailTemplateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_verification_email_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomVerificationEmailTemplateOutput,
    crate::error::CreateCustomVerificationEmailTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_custom_verification_email_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_filter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReceiptFilterOutput,
    crate::error::CreateReceiptFilterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReceiptFilterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateReceiptFilterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => crate::error::CreateReceiptFilterError {
            meta: generic,
            kind: crate::error::CreateReceiptFilterErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptFilterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateReceiptFilterError {
            meta: generic,
            kind: crate::error::CreateReceiptFilterErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptFilterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateReceiptFilterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_filter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReceiptFilterOutput,
    crate::error::CreateReceiptFilterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_receipt_filter_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateReceiptRuleOutput, crate::error::CreateReceiptRuleError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReceiptRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateReceiptRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLambdaFunction" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::InvalidLambdaFunctionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_function_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_lambda_function_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidS3Configuration" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::InvalidS3ConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_s3_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_configuration_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSnsTopic" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::InvalidSnsTopicException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_sns_topic_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_sns_topic_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleDoesNotExist" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::RuleDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::CreateReceiptRuleError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateReceiptRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateReceiptRuleOutput, crate::error::CreateReceiptRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_receipt_rule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReceiptRuleSetOutput,
    crate::error::CreateReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateReceiptRuleSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => crate::error::CreateReceiptRuleSetError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleSetErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateReceiptRuleSetError {
            meta: generic,
            kind: crate::error::CreateReceiptRuleSetErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReceiptRuleSetOutput,
    crate::error::CreateReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_receipt_rule_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTemplateOutput, crate::error::CreateTemplateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AlreadyExists" => crate::error::CreateTemplateError {
            meta: generic,
            kind: crate::error::CreateTemplateErrorKind::AlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTemplate" => crate::error::CreateTemplateError {
            meta: generic,
            kind: crate::error::CreateTemplateErrorKind::InvalidTemplateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_template_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_template_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateTemplateError {
            meta: generic,
            kind: crate::error::CreateTemplateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTemplateOutput, crate::error::CreateTemplateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetOutput,
    crate::error::DeleteConfigurationSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConfigurationSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteConfigurationSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::DeleteConfigurationSetError {
            meta: generic,
            kind:
                crate::error::DeleteConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationSetError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteConfigurationSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetOutput,
    crate::error::DeleteConfigurationSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_configuration_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_event_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetEventDestinationOutput,
    crate::error::DeleteConfigurationSetEventDestinationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConfigurationSetEventDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DeleteConfigurationSetEventDestinationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::DeleteConfigurationSetEventDestinationError { meta: generic, kind: crate::error::DeleteConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDestinationDoesNotExist" => crate::error::DeleteConfigurationSetEventDestinationError { meta: generic, kind: crate::error::DeleteConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_destination_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_event_destination_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteConfigurationSetEventDestinationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_event_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetEventDestinationOutput,
    crate::error::DeleteConfigurationSetEventDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_configuration_set_event_destination_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_tracking_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetTrackingOptionsOutput,
    crate::error::DeleteConfigurationSetTrackingOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteConfigurationSetTrackingOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DeleteConfigurationSetTrackingOptionsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::DeleteConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::DeleteConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrackingOptionsDoesNotExistException" => crate::error::DeleteConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::DeleteConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tracking_options_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tracking_options_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteConfigurationSetTrackingOptionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_configuration_set_tracking_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteConfigurationSetTrackingOptionsOutput,
    crate::error::DeleteConfigurationSetTrackingOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_configuration_set_tracking_options_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_verification_email_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomVerificationEmailTemplateOutput,
    crate::error::DeleteCustomVerificationEmailTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomVerificationEmailTemplateError::unhandled)?;
    Err(crate::error::DeleteCustomVerificationEmailTemplateError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_verification_email_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomVerificationEmailTemplateOutput,
    crate::error::DeleteCustomVerificationEmailTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_custom_verification_email_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIdentityOutput, crate::error::DeleteIdentityError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIdentityError::unhandled)?;
    Err(crate::error::DeleteIdentityError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIdentityOutput, crate::error::DeleteIdentityError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_identity_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityPolicyOutput,
    crate::error::DeleteIdentityPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIdentityPolicyError::unhandled)?;
    Err(crate::error::DeleteIdentityPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_identity_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteIdentityPolicyOutput,
    crate::error::DeleteIdentityPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_identity_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_filter_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReceiptFilterOutput,
    crate::error::DeleteReceiptFilterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReceiptFilterError::unhandled)?;
    Err(crate::error::DeleteReceiptFilterError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_filter_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReceiptFilterOutput,
    crate::error::DeleteReceiptFilterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_receipt_filter_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteReceiptRuleOutput, crate::error::DeleteReceiptRuleError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReceiptRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteReceiptRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleSetDoesNotExist" => crate::error::DeleteReceiptRuleError {
            meta: generic,
            kind: crate::error::DeleteReceiptRuleErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReceiptRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteReceiptRuleOutput, crate::error::DeleteReceiptRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_receipt_rule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReceiptRuleSetOutput,
    crate::error::DeleteReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteReceiptRuleSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CannotDelete" => crate::error::DeleteReceiptRuleSetError {
            meta: generic,
            kind: crate::error::DeleteReceiptRuleSetErrorKind::CannotDeleteException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cannot_delete_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cannot_delete_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteReceiptRuleSetOutput,
    crate::error::DeleteReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_receipt_rule_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTemplateOutput, crate::error::DeleteTemplateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTemplateError::unhandled)?;
    Err(crate::error::DeleteTemplateError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTemplateOutput, crate::error::DeleteTemplateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_verified_email_address_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVerifiedEmailAddressOutput,
    crate::error::DeleteVerifiedEmailAddressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVerifiedEmailAddressError::unhandled)?;
    Err(crate::error::DeleteVerifiedEmailAddressError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_verified_email_address_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVerifiedEmailAddressOutput,
    crate::error::DeleteVerifiedEmailAddressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_verified_email_address_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_active_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeActiveReceiptRuleSetOutput,
    crate::error::DescribeActiveReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeActiveReceiptRuleSetError::unhandled)?;
    Err(crate::error::DescribeActiveReceiptRuleSetError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_active_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeActiveReceiptRuleSetOutput,
    crate::error::DescribeActiveReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_active_receipt_rule_set_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_active_receipt_rule_set(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeActiveReceiptRuleSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationSetOutput,
    crate::error::DescribeConfigurationSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeConfigurationSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeConfigurationSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::DescribeConfigurationSetError { meta: generic, kind: crate::error::DescribeConfigurationSetErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeConfigurationSetError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeConfigurationSetError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_configuration_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeConfigurationSetOutput,
    crate::error::DescribeConfigurationSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_configuration_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_configuration_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeConfigurationSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_receipt_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReceiptRuleOutput,
    crate::error::DescribeReceiptRuleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReceiptRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeReceiptRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleDoesNotExist" => crate::error::DescribeReceiptRuleError {
            meta: generic,
            kind: crate::error::DescribeReceiptRuleErrorKind::RuleDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::DescribeReceiptRuleError {
            meta: generic,
            kind: crate::error::DescribeReceiptRuleErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReceiptRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_receipt_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReceiptRuleOutput,
    crate::error::DescribeReceiptRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_receipt_rule_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_receipt_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReceiptRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReceiptRuleSetOutput,
    crate::error::DescribeReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReceiptRuleSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleSetDoesNotExist" => crate::error::DescribeReceiptRuleSetError {
            meta: generic,
            kind: crate::error::DescribeReceiptRuleSetErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReceiptRuleSetOutput,
    crate::error::DescribeReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_receipt_rule_set_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_receipt_rule_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReceiptRuleSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_sending_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountSendingEnabledOutput,
    crate::error::GetAccountSendingEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountSendingEnabledError::unhandled)?;
    Err(crate::error::GetAccountSendingEnabledError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_sending_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountSendingEnabledOutput,
    crate::error::GetAccountSendingEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_account_sending_enabled_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_account_sending_enabled(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccountSendingEnabledError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_custom_verification_email_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCustomVerificationEmailTemplateOutput,
    crate::error::GetCustomVerificationEmailTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCustomVerificationEmailTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetCustomVerificationEmailTemplateError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomVerificationEmailTemplateDoesNotExist" => crate::error::GetCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::GetCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetCustomVerificationEmailTemplateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_custom_verification_email_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCustomVerificationEmailTemplateOutput,
    crate::error::GetCustomVerificationEmailTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_custom_verification_email_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_custom_verification_email_template(response.body().as_ref(), output).map_err(crate::error::GetCustomVerificationEmailTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_dkim_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityDkimAttributesOutput,
    crate::error::GetIdentityDkimAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityDkimAttributesError::unhandled)?;
    Err(crate::error::GetIdentityDkimAttributesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_dkim_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityDkimAttributesOutput,
    crate::error::GetIdentityDkimAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_identity_dkim_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_identity_dkim_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIdentityDkimAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_mail_from_domain_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityMailFromDomainAttributesOutput,
    crate::error::GetIdentityMailFromDomainAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityMailFromDomainAttributesError::unhandled)?;
    Err(crate::error::GetIdentityMailFromDomainAttributesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_mail_from_domain_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityMailFromDomainAttributesOutput,
    crate::error::GetIdentityMailFromDomainAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_identity_mail_from_domain_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_identity_mail_from_domain_attributes(response.body().as_ref(), output).map_err(crate::error::GetIdentityMailFromDomainAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_notification_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityNotificationAttributesOutput,
    crate::error::GetIdentityNotificationAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityNotificationAttributesError::unhandled)?;
    Err(crate::error::GetIdentityNotificationAttributesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_notification_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityNotificationAttributesOutput,
    crate::error::GetIdentityNotificationAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_identity_notification_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_identity_notification_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetIdentityNotificationAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityPoliciesOutput,
    crate::error::GetIdentityPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityPoliciesError::unhandled)?;
    Err(crate::error::GetIdentityPoliciesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityPoliciesOutput,
    crate::error::GetIdentityPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_identity_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_identity_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIdentityPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_verification_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityVerificationAttributesOutput,
    crate::error::GetIdentityVerificationAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIdentityVerificationAttributesError::unhandled)?;
    Err(crate::error::GetIdentityVerificationAttributesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_identity_verification_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetIdentityVerificationAttributesOutput,
    crate::error::GetIdentityVerificationAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_identity_verification_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_identity_verification_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetIdentityVerificationAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_send_quota_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSendQuotaOutput, crate::error::GetSendQuotaError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSendQuotaError::unhandled)?;
    Err(crate::error::GetSendQuotaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_send_quota_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSendQuotaOutput, crate::error::GetSendQuotaError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_send_quota_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_send_quota(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSendQuotaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_send_statistics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSendStatisticsOutput, crate::error::GetSendStatisticsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSendStatisticsError::unhandled)?;
    Err(crate::error::GetSendStatisticsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_send_statistics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSendStatisticsOutput, crate::error::GetSendStatisticsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_send_statistics_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_send_statistics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSendStatisticsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "TemplateDoesNotExist" => crate::error::GetTemplateError {
            meta: generic,
            kind: crate::error::GetTemplateErrorKind::TemplateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTemplateOutput, crate::error::GetTemplateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_configuration_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConfigurationSetsOutput,
    crate::error::ListConfigurationSetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListConfigurationSetsError::unhandled)?;
    Err(crate::error::ListConfigurationSetsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_configuration_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListConfigurationSetsOutput,
    crate::error::ListConfigurationSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_configuration_sets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_configuration_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListConfigurationSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_verification_email_templates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomVerificationEmailTemplatesOutput,
    crate::error::ListCustomVerificationEmailTemplatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomVerificationEmailTemplatesError::unhandled)?;
    Err(crate::error::ListCustomVerificationEmailTemplatesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_verification_email_templates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomVerificationEmailTemplatesOutput,
    crate::error::ListCustomVerificationEmailTemplatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_custom_verification_email_templates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_custom_verification_email_templates(response.body().as_ref(), output).map_err(crate::error::ListCustomVerificationEmailTemplatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIdentitiesOutput, crate::error::ListIdentitiesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIdentitiesError::unhandled)?;
    Err(crate::error::ListIdentitiesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIdentitiesOutput, crate::error::ListIdentitiesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_identities_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_identities(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIdentitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityPoliciesOutput,
    crate::error::ListIdentityPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIdentityPoliciesError::unhandled)?;
    Err(crate::error::ListIdentityPoliciesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_identity_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListIdentityPoliciesOutput,
    crate::error::ListIdentityPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_identity_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_identity_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIdentityPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_receipt_filters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReceiptFiltersOutput,
    crate::error::ListReceiptFiltersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListReceiptFiltersError::unhandled)?;
    Err(crate::error::ListReceiptFiltersError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_receipt_filters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReceiptFiltersOutput,
    crate::error::ListReceiptFiltersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_receipt_filters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_receipt_filters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListReceiptFiltersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_receipt_rule_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReceiptRuleSetsOutput,
    crate::error::ListReceiptRuleSetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListReceiptRuleSetsError::unhandled)?;
    Err(crate::error::ListReceiptRuleSetsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_receipt_rule_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListReceiptRuleSetsOutput,
    crate::error::ListReceiptRuleSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_receipt_rule_sets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_receipt_rule_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListReceiptRuleSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_templates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTemplatesOutput, crate::error::ListTemplatesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTemplatesError::unhandled)?;
    Err(crate::error::ListTemplatesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_templates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTemplatesOutput, crate::error::ListTemplatesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_templates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_templates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTemplatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_verified_email_addresses_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVerifiedEmailAddressesOutput,
    crate::error::ListVerifiedEmailAddressesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVerifiedEmailAddressesError::unhandled)?;
    Err(crate::error::ListVerifiedEmailAddressesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_verified_email_addresses_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVerifiedEmailAddressesOutput,
    crate::error::ListVerifiedEmailAddressesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_verified_email_addresses_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_verified_email_addresses(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVerifiedEmailAddressesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_configuration_set_delivery_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutConfigurationSetDeliveryOptionsOutput,
    crate::error::PutConfigurationSetDeliveryOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutConfigurationSetDeliveryOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutConfigurationSetDeliveryOptionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::PutConfigurationSetDeliveryOptionsError { meta: generic, kind: crate::error::PutConfigurationSetDeliveryOptionsErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutConfigurationSetDeliveryOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDeliveryOptions" => crate::error::PutConfigurationSetDeliveryOptionsError { meta: generic, kind: crate::error::PutConfigurationSetDeliveryOptionsErrorKind::InvalidDeliveryOptionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_delivery_options_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_delivery_options_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutConfigurationSetDeliveryOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutConfigurationSetDeliveryOptionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_configuration_set_delivery_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutConfigurationSetDeliveryOptionsOutput,
    crate::error::PutConfigurationSetDeliveryOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_configuration_set_delivery_options_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_identity_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutIdentityPolicyOutput, crate::error::PutIdentityPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutIdentityPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutIdentityPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidPolicy" => crate::error::PutIdentityPolicyError {
            meta: generic,
            kind: crate::error::PutIdentityPolicyErrorKind::InvalidPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutIdentityPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutIdentityPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_identity_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutIdentityPolicyOutput, crate::error::PutIdentityPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_identity_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reorder_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReorderReceiptRuleSetOutput,
    crate::error::ReorderReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReorderReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReorderReceiptRuleSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleDoesNotExist" => crate::error::ReorderReceiptRuleSetError {
            meta: generic,
            kind: crate::error::ReorderReceiptRuleSetErrorKind::RuleDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ReorderReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::ReorderReceiptRuleSetError {
            meta: generic,
            kind: crate::error::ReorderReceiptRuleSetErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ReorderReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReorderReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reorder_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ReorderReceiptRuleSetOutput,
    crate::error::ReorderReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reorder_receipt_rule_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bounce_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendBounceOutput, crate::error::SendBounceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendBounceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendBounceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "MessageRejected" => crate::error::SendBounceError {
            meta: generic,
            kind: crate::error::SendBounceErrorKind::MessageRejected({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendBounceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendBounceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bounce_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendBounceOutput, crate::error::SendBounceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_bounce_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_bounce(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendBounceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bulk_templated_email_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendBulkTemplatedEmailOutput,
    crate::error::SendBulkTemplatedEmailError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendBulkTemplatedEmailError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccountSendingPausedException" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::AccountSendingPausedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_sending_paused_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_account_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConfigurationSetDoesNotExist" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ConfigurationSetSendingPausedException" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::ConfigurationSetSendingPausedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_sending_paused_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MailFromDomainNotVerifiedException" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::MailFromDomainNotVerifiedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::mail_from_domain_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_mail_from_domain_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MessageRejected" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::MessageRejected({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TemplateDoesNotExist" => crate::error::SendBulkTemplatedEmailError { meta: generic, kind: crate::error::SendBulkTemplatedEmailErrorKind::TemplateDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SendBulkTemplatedEmailError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_bulk_templated_email_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendBulkTemplatedEmailOutput,
    crate::error::SendBulkTemplatedEmailError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_bulk_templated_email_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_bulk_templated_email(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendBulkTemplatedEmailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_custom_verification_email_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendCustomVerificationEmailOutput,
    crate::error::SendCustomVerificationEmailError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendCustomVerificationEmailError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::SendCustomVerificationEmailError { meta: generic, kind: crate::error::SendCustomVerificationEmailErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomVerificationEmailTemplateDoesNotExist" => crate::error::SendCustomVerificationEmailError { meta: generic, kind: crate::error::SendCustomVerificationEmailErrorKind::CustomVerificationEmailTemplateDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FromEmailAddressNotVerified" => crate::error::SendCustomVerificationEmailError { meta: generic, kind: crate::error::SendCustomVerificationEmailErrorKind::FromEmailAddressNotVerifiedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::from_email_address_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_from_email_address_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "MessageRejected" => crate::error::SendCustomVerificationEmailError { meta: generic, kind: crate::error::SendCustomVerificationEmailErrorKind::MessageRejected({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(response.body().as_ref(), output).map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ProductionAccessNotGranted" => crate::error::SendCustomVerificationEmailError { meta: generic, kind: crate::error::SendCustomVerificationEmailErrorKind::ProductionAccessNotGrantedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::production_access_not_granted_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_production_access_not_granted_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::SendCustomVerificationEmailError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_custom_verification_email_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendCustomVerificationEmailOutput,
    crate::error::SendCustomVerificationEmailError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_custom_verification_email_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_custom_verification_email(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendCustomVerificationEmailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_email_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendEmailOutput, crate::error::SendEmailError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendEmailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendEmailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccountSendingPausedException" => crate::error::SendEmailError {
            meta: generic,
            kind: crate::error::SendEmailErrorKind::AccountSendingPausedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_sending_paused_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_account_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConfigurationSetDoesNotExist" => {
            crate::error::SendEmailError {
                meta: generic,
                kind: crate::error::SendEmailErrorKind::ConfigurationSetDoesNotExistException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendEmailError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ConfigurationSetSendingPausedException" => {
            crate::error::SendEmailError {
                meta: generic,
                kind: crate::error::SendEmailErrorKind::ConfigurationSetSendingPausedException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::configuration_set_sending_paused_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_configuration_set_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendEmailError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "MailFromDomainNotVerifiedException" => crate::error::SendEmailError {
            meta: generic,
            kind: crate::error::SendEmailErrorKind::MailFromDomainNotVerifiedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::mail_from_domain_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_mail_from_domain_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MessageRejected" => crate::error::SendEmailError {
            meta: generic,
            kind: crate::error::SendEmailErrorKind::MessageRejected({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendEmailError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_email_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendEmailOutput, crate::error::SendEmailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_email_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_email(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendEmailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_raw_email_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendRawEmailOutput, crate::error::SendRawEmailError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendRawEmailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendRawEmailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccountSendingPausedException" => crate::error::SendRawEmailError {
            meta: generic,
            kind: crate::error::SendRawEmailErrorKind::AccountSendingPausedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_sending_paused_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_account_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendRawEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConfigurationSetDoesNotExist" => {
            crate::error::SendRawEmailError {
                meta: generic,
                kind: crate::error::SendRawEmailErrorKind::ConfigurationSetDoesNotExistException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendRawEmailError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ConfigurationSetSendingPausedException" => crate::error::SendRawEmailError {
            meta: generic,
            kind: crate::error::SendRawEmailErrorKind::ConfigurationSetSendingPausedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::configuration_set_sending_paused_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendRawEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MailFromDomainNotVerifiedException" => crate::error::SendRawEmailError {
            meta: generic,
            kind: crate::error::SendRawEmailErrorKind::MailFromDomainNotVerifiedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::mail_from_domain_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_mail_from_domain_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendRawEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MessageRejected" => crate::error::SendRawEmailError {
            meta: generic,
            kind: crate::error::SendRawEmailErrorKind::MessageRejected({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendRawEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendRawEmailError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_raw_email_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendRawEmailOutput, crate::error::SendRawEmailError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_raw_email_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_raw_email(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendRawEmailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_templated_email_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendTemplatedEmailOutput,
    crate::error::SendTemplatedEmailError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendTemplatedEmailError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendTemplatedEmailError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccountSendingPausedException" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::AccountSendingPausedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_sending_paused_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_account_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConfigurationSetDoesNotExist" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ConfigurationSetSendingPausedException" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::configuration_set_sending_paused_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_configuration_set_sending_paused_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "MailFromDomainNotVerifiedException" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::MailFromDomainNotVerifiedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::mail_from_domain_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_mail_from_domain_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MessageRejected" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::MessageRejected({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::message_rejected::Builder::default();
                    let _ = response;
                    output =
                        crate::xml_deser::deser_structure_crate_error_message_rejected_xml_err(
                            response.body().as_ref(),
                            output,
                        )
                        .map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TemplateDoesNotExist" => crate::error::SendTemplatedEmailError {
            meta: generic,
            kind: crate::error::SendTemplatedEmailErrorKind::TemplateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SendTemplatedEmailError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendTemplatedEmailError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_templated_email_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendTemplatedEmailOutput,
    crate::error::SendTemplatedEmailError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_templated_email_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_templated_email(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendTemplatedEmailError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_active_receipt_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetActiveReceiptRuleSetOutput,
    crate::error::SetActiveReceiptRuleSetError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetActiveReceiptRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetActiveReceiptRuleSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleSetDoesNotExist" => crate::error::SetActiveReceiptRuleSetError {
            meta: generic,
            kind: crate::error::SetActiveReceiptRuleSetErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetActiveReceiptRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetActiveReceiptRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_active_receipt_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetActiveReceiptRuleSetOutput,
    crate::error::SetActiveReceiptRuleSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_active_receipt_rule_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_dkim_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityDkimEnabledOutput,
    crate::error::SetIdentityDkimEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIdentityDkimEnabledError::unhandled)?;
    Err(crate::error::SetIdentityDkimEnabledError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_dkim_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityDkimEnabledOutput,
    crate::error::SetIdentityDkimEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_identity_dkim_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_feedback_forwarding_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityFeedbackForwardingEnabledOutput,
    crate::error::SetIdentityFeedbackForwardingEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIdentityFeedbackForwardingEnabledError::unhandled)?;
    Err(crate::error::SetIdentityFeedbackForwardingEnabledError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_feedback_forwarding_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityFeedbackForwardingEnabledOutput,
    crate::error::SetIdentityFeedbackForwardingEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_identity_feedback_forwarding_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_headers_in_notifications_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
    crate::error::SetIdentityHeadersInNotificationsEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIdentityHeadersInNotificationsEnabledError::unhandled)?;
    Err(crate::error::SetIdentityHeadersInNotificationsEnabledError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_headers_in_notifications_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityHeadersInNotificationsEnabledOutput,
    crate::error::SetIdentityHeadersInNotificationsEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_identity_headers_in_notifications_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_mail_from_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityMailFromDomainOutput,
    crate::error::SetIdentityMailFromDomainError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIdentityMailFromDomainError::unhandled)?;
    Err(crate::error::SetIdentityMailFromDomainError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_mail_from_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityMailFromDomainOutput,
    crate::error::SetIdentityMailFromDomainError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_identity_mail_from_domain_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_notification_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityNotificationTopicOutput,
    crate::error::SetIdentityNotificationTopicError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIdentityNotificationTopicError::unhandled)?;
    Err(crate::error::SetIdentityNotificationTopicError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_identity_notification_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetIdentityNotificationTopicOutput,
    crate::error::SetIdentityNotificationTopicError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_identity_notification_topic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_receipt_rule_position_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetReceiptRulePositionOutput,
    crate::error::SetReceiptRulePositionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetReceiptRulePositionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetReceiptRulePositionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "RuleDoesNotExist" => crate::error::SetReceiptRulePositionError {
            meta: generic,
            kind: crate::error::SetReceiptRulePositionErrorKind::RuleDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetReceiptRulePositionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::SetReceiptRulePositionError {
            meta: generic,
            kind: crate::error::SetReceiptRulePositionErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetReceiptRulePositionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetReceiptRulePositionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_receipt_rule_position_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetReceiptRulePositionOutput,
    crate::error::SetReceiptRulePositionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_receipt_rule_position_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_render_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TestRenderTemplateOutput,
    crate::error::TestRenderTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestRenderTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestRenderTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidRenderingParameter" => crate::error::TestRenderTemplateError {
            meta: generic,
            kind: crate::error::TestRenderTemplateErrorKind::InvalidRenderingParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_rendering_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_rendering_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestRenderTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingRenderingAttribute" => crate::error::TestRenderTemplateError {
            meta: generic,
            kind: crate::error::TestRenderTemplateErrorKind::MissingRenderingAttributeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_rendering_attribute_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_rendering_attribute_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestRenderTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TemplateDoesNotExist" => crate::error::TestRenderTemplateError {
            meta: generic,
            kind: crate::error::TestRenderTemplateErrorKind::TemplateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TestRenderTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TestRenderTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_render_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TestRenderTemplateOutput,
    crate::error::TestRenderTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::test_render_template_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_test_render_template(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TestRenderTemplateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_account_sending_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAccountSendingEnabledOutput,
    crate::error::UpdateAccountSendingEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAccountSendingEnabledError::unhandled)?;
    Err(crate::error::UpdateAccountSendingEnabledError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_account_sending_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAccountSendingEnabledOutput,
    crate::error::UpdateAccountSendingEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_account_sending_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_event_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetEventDestinationOutput,
    crate::error::UpdateConfigurationSetEventDestinationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateConfigurationSetEventDestinationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::UpdateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::UpdateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EventDestinationDoesNotExist" => crate::error::UpdateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::UpdateConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::event_destination_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_event_destination_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCloudWatchDestination" => crate::error::UpdateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::UpdateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cloud_watch_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cloud_watch_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidFirehoseDestination" => crate::error::UpdateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::UpdateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_firehose_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_firehose_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSNSDestination" => crate::error::UpdateConfigurationSetEventDestinationError { meta: generic, kind: crate::error::UpdateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_sns_destination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_sns_destination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetEventDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateConfigurationSetEventDestinationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_event_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetEventDestinationOutput,
    crate::error::UpdateConfigurationSetEventDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_configuration_set_event_destination_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_reputation_metrics_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput,
    crate::error::UpdateConfigurationSetReputationMetricsEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConfigurationSetReputationMetricsEnabledError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateConfigurationSetReputationMetricsEnabledError::unhandled(
                    generic,
                ),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::UpdateConfigurationSetReputationMetricsEnabledError { meta: generic, kind: crate::error::UpdateConfigurationSetReputationMetricsEnabledErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetReputationMetricsEnabledError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateConfigurationSetReputationMetricsEnabledError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_reputation_metrics_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetReputationMetricsEnabledOutput,
    crate::error::UpdateConfigurationSetReputationMetricsEnabledError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::update_configuration_set_reputation_metrics_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_sending_enabled_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetSendingEnabledOutput,
    crate::error::UpdateConfigurationSetSendingEnabledError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConfigurationSetSendingEnabledError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateConfigurationSetSendingEnabledError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::UpdateConfigurationSetSendingEnabledError { meta: generic, kind: crate::error::UpdateConfigurationSetSendingEnabledErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetSendingEnabledError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateConfigurationSetSendingEnabledError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_sending_enabled_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetSendingEnabledOutput,
    crate::error::UpdateConfigurationSetSendingEnabledError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_configuration_set_sending_enabled_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_tracking_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetTrackingOptionsOutput,
    crate::error::UpdateConfigurationSetTrackingOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateConfigurationSetTrackingOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateConfigurationSetTrackingOptionsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConfigurationSetDoesNotExist" => crate::error::UpdateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::UpdateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::configuration_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_configuration_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTrackingOptions" => crate::error::UpdateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::UpdateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tracking_options_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tracking_options_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TrackingOptionsDoesNotExistException" => crate::error::UpdateConfigurationSetTrackingOptionsError { meta: generic, kind: crate::error::UpdateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tracking_options_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tracking_options_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateConfigurationSetTrackingOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateConfigurationSetTrackingOptionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_configuration_set_tracking_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateConfigurationSetTrackingOptionsOutput,
    crate::error::UpdateConfigurationSetTrackingOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_configuration_set_tracking_options_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_verification_email_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomVerificationEmailTemplateOutput,
    crate::error::UpdateCustomVerificationEmailTemplateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomVerificationEmailTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateCustomVerificationEmailTemplateError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomVerificationEmailInvalidContent" => crate::error::UpdateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_invalid_content_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_invalid_content_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomVerificationEmailTemplateDoesNotExist" => crate::error::UpdateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_verification_email_template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_verification_email_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "FromEmailAddressNotVerified" => crate::error::UpdateCustomVerificationEmailTemplateError { meta: generic, kind: crate::error::UpdateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::from_email_address_not_verified_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_from_email_address_not_verified_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomVerificationEmailTemplateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateCustomVerificationEmailTemplateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_verification_email_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomVerificationEmailTemplateOutput,
    crate::error::UpdateCustomVerificationEmailTemplateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_custom_verification_email_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_receipt_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateReceiptRuleOutput, crate::error::UpdateReceiptRuleError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateReceiptRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidLambdaFunction" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::InvalidLambdaFunctionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_lambda_function_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_lambda_function_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidS3Configuration" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::InvalidS3ConfigurationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_s3_configuration_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_configuration_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSnsTopic" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::InvalidSnsTopicException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_sns_topic_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_sns_topic_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleDoesNotExist" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::RuleDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RuleSetDoesNotExist" => crate::error::UpdateReceiptRuleError {
            meta: generic,
            kind: crate::error::UpdateReceiptRuleErrorKind::RuleSetDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::rule_set_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_rule_set_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateReceiptRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateReceiptRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_receipt_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateReceiptRuleOutput, crate::error::UpdateReceiptRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_receipt_rule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_template_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTemplateOutput, crate::error::UpdateTemplateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTemplateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTemplateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTemplate" => crate::error::UpdateTemplateError {
            meta: generic,
            kind: crate::error::UpdateTemplateErrorKind::InvalidTemplateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_template_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_template_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TemplateDoesNotExist" => crate::error::UpdateTemplateError {
            meta: generic,
            kind: crate::error::UpdateTemplateErrorKind::TemplateDoesNotExistException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::template_does_not_exist_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_template_does_not_exist_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateTemplateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTemplateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_template_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTemplateOutput, crate::error::UpdateTemplateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_template_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_domain_dkim_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyDomainDkimOutput, crate::error::VerifyDomainDkimError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyDomainDkimError::unhandled)?;
    Err(crate::error::VerifyDomainDkimError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_domain_dkim_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::VerifyDomainDkimOutput, crate::error::VerifyDomainDkimError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_domain_dkim_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_verify_domain_dkim(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::VerifyDomainDkimError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_domain_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyDomainIdentityOutput,
    crate::error::VerifyDomainIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyDomainIdentityError::unhandled)?;
    Err(crate::error::VerifyDomainIdentityError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_domain_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyDomainIdentityOutput,
    crate::error::VerifyDomainIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_domain_identity_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_verify_domain_identity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::VerifyDomainIdentityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_email_address_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyEmailAddressOutput,
    crate::error::VerifyEmailAddressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyEmailAddressError::unhandled)?;
    Err(crate::error::VerifyEmailAddressError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_email_address_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyEmailAddressOutput,
    crate::error::VerifyEmailAddressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_email_address_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_email_identity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyEmailIdentityOutput,
    crate::error::VerifyEmailIdentityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifyEmailIdentityError::unhandled)?;
    Err(crate::error::VerifyEmailIdentityError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_email_identity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifyEmailIdentityOutput,
    crate::error::VerifyEmailIdentityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_email_identity_output::Builder::default();
        let _ = response;
        output.build()
    })
}
