// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CloneReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CloneReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: CloneReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CloneReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CloneReceiptRuleSetErrorKind {
    /// <p>Indicates that a resource could not be created because of a naming conflict.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CloneReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CloneReceiptRuleSetErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CloneReceiptRuleSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CloneReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            CloneReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CloneReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        CloneReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CloneReceiptRuleSetError {
    /// Creates a new `CloneReceiptRuleSetError`.
    pub fn new(kind: CloneReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CloneReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CloneReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CloneReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CloneReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CloneReceiptRuleSetErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloneReceiptRuleSetErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CloneReceiptRuleSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloneReceiptRuleSetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CloneReceiptRuleSetErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloneReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for CloneReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CloneReceiptRuleSetErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CloneReceiptRuleSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CloneReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            CloneReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetErrorKind {
    /// <p>Indicates that the configuration set could not be created because of a naming
    /// conflict.</p>
    ConfigurationSetAlreadyExistsException(crate::error::ConfigurationSetAlreadyExistsException),
    /// <p>Indicates that the configuration set is invalid. See the error message for
    /// details.</p>
    InvalidConfigurationSetException(crate::error::InvalidConfigurationSetException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetErrorKind::ConfigurationSetAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetErrorKind::InvalidConfigurationSetException(_inner) => {
                _inner.fmt(f)
            }
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetError {
    /// Creates a new `CreateConfigurationSetError`.
    pub fn new(kind: CreateConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::ConfigurationSetAlreadyExistsException`.
    pub fn is_configuration_set_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::ConfigurationSetAlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::InvalidConfigurationSetException`.
    pub fn is_invalid_configuration_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::InvalidConfigurationSetException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetErrorKind::ConfigurationSetAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetErrorKind::InvalidConfigurationSetException(_inner) => {
                Some(_inner)
            }
            CreateConfigurationSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetEventDestinationErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the event destination could not be created because of a naming
    /// conflict.</p>
    EventDestinationAlreadyExistsException(crate::error::EventDestinationAlreadyExistsException),
    /// <p>Indicates that the Amazon CloudWatch destination is invalid. See the error message for
    /// details.</p>
    InvalidCloudWatchDestinationException(crate::error::InvalidCloudWatchDestinationException),
    /// <p>Indicates that the Amazon Kinesis Firehose destination is invalid. See the error
    /// message for details.</p>
    InvalidFirehoseDestinationException(crate::error::InvalidFirehoseDestinationException),
    /// <p>Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is
    /// invalid. See the error message for details.</p>
    InvalidSnsDestinationException(crate::error::InvalidSnsDestinationException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::EventDestinationAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetEventDestinationError {
    /// Creates a new `CreateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: CreateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::EventDestinationAlreadyExistsException`.
    pub fn is_event_destination_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::EventDestinationAlreadyExistsException(
                _
            )
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException`.
    pub fn is_invalid_cloud_watch_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(
                _
            )
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException`.
    pub fn is_invalid_firehose_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException`.
    pub fn is_invalid_sns_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetEventDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::EventDestinationAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::LimitExceededException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigurationSetTrackingOptionsError {
    /// Kind of error that occurred.
    pub kind: CreateConfigurationSetTrackingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigurationSetTrackingOptionsErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the custom domain to be used for open and click tracking redirects is
    /// invalid. This error appears most often in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>When the tracking domain you specified is not verified in Amazon SES.</p>
    /// </li>
    /// <li>
    /// <p>When the tracking domain you specified is not a valid domain or
    /// subdomain.</p>
    /// </li>
    /// </ul>
    InvalidTrackingOptionsException(crate::error::InvalidTrackingOptionsException),
    /// <p>Indicates that the configuration set you specified already contains a TrackingOptions
    /// object.</p>
    TrackingOptionsAlreadyExistsException(crate::error::TrackingOptionsAlreadyExistsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigurationSetTrackingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigurationSetTrackingOptionsError {
    fn code(&self) -> Option<&str> {
        CreateConfigurationSetTrackingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigurationSetTrackingOptionsError {
    /// Creates a new `CreateConfigurationSetTrackingOptionsError`.
    pub fn new(
        kind: CreateConfigurationSetTrackingOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigurationSetTrackingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigurationSetTrackingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException`.
    pub fn is_invalid_tracking_options_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_)
        )
    }
    /// Returns true if the error kind is `CreateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsAlreadyExistsException`.
    pub fn is_tracking_options_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsAlreadyExistsException(
                _
            )
        )
    }
}
impl std::error::Error for CreateConfigurationSetTrackingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            CreateConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomVerificationEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateCustomVerificationEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomVerificationEmailTemplateErrorKind {
    /// <p>Indicates that custom verification email template provided content is invalid.</p>
    CustomVerificationEmailInvalidContentException(
        crate::error::CustomVerificationEmailInvalidContentException,
    ),
    /// <p>Indicates that a custom verification email template with the name you specified
    /// already exists.</p>
    CustomVerificationEmailTemplateAlreadyExistsException(
        crate::error::CustomVerificationEmailTemplateAlreadyExistsException,
    ),
    /// <p>Indicates that the sender address specified for a custom verification email is not
    /// verified, and is therefore not eligible to send the custom verification email. </p>
    FromEmailAddressNotVerifiedException(crate::error::FromEmailAddressNotVerifiedException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomVerificationEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_inner) =>
            _inner.fmt(f)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            _inner.fmt(f)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::LimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomVerificationEmailTemplateError {
    fn code(&self) -> Option<&str> {
        CreateCustomVerificationEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomVerificationEmailTemplateError {
    /// Creates a new `CreateCustomVerificationEmailTemplateError`.
    pub fn new(
        kind: CreateCustomVerificationEmailTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomVerificationEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomVerificationEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException`.
    pub fn is_custom_verification_email_invalid_content_exception(&self) -> bool {
        matches!(&self.kind, CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_))
    }
    /// Returns true if the error kind is `CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateAlreadyExistsException`.
    pub fn is_custom_verification_email_template_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateAlreadyExistsException(_))
    }
    /// Returns true if the error kind is `CreateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException`.
    pub fn is_from_email_address_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `CreateCustomVerificationEmailTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomVerificationEmailTemplateErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateCustomVerificationEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_inner) =>
            Some(_inner)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            Some(_inner)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::LimitExceededException(_inner) =>
            Some(_inner)
            ,
            CreateCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateReceiptFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReceiptFilterError {
    /// Kind of error that occurred.
    pub kind: CreateReceiptFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReceiptFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReceiptFilterErrorKind {
    /// <p>Indicates that a resource could not be created because of a naming conflict.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReceiptFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReceiptFilterErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateReceiptFilterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateReceiptFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReceiptFilterError {
    fn code(&self) -> Option<&str> {
        CreateReceiptFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReceiptFilterError {
    /// Creates a new `CreateReceiptFilterError`.
    pub fn new(kind: CreateReceiptFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReceiptFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReceiptFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReceiptFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReceiptFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateReceiptFilterErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptFilterErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptFilterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptFilterErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateReceiptFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReceiptFilterErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateReceiptFilterErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateReceiptFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReceiptRuleError {
    /// Kind of error that occurred.
    pub kind: CreateReceiptRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReceiptRuleErrorKind {
    /// <p>Indicates that a resource could not be created because of a naming conflict.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could
    /// not execute the provided function, possibly due to permissions issues. For information
    /// about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidLambdaFunctionException(crate::error::InvalidLambdaFunctionException),
    /// <p>Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or
    /// that Amazon SES could not publish to the bucket, possibly due to permissions issues. For
    /// information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidS3ConfigurationException(crate::error::InvalidS3ConfigurationException),
    /// <p>Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not
    /// publish to the topic, possibly due to permissions issues. For information about giving
    /// permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidSnsTopicException(crate::error::InvalidSnsTopicException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the provided receipt rule does not exist.</p>
    RuleDoesNotExistException(crate::error::RuleDoesNotExistException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReceiptRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReceiptRuleErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::InvalidLambdaFunctionException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::InvalidS3ConfigurationException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::InvalidSnsTopicException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            CreateReceiptRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReceiptRuleError {
    fn code(&self) -> Option<&str> {
        CreateReceiptRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReceiptRuleError {
    /// Creates a new `CreateReceiptRuleError`.
    pub fn new(kind: CreateReceiptRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReceiptRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReceiptRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReceiptRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReceiptRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::InvalidLambdaFunctionException`.
    pub fn is_invalid_lambda_function_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::InvalidLambdaFunctionException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::InvalidS3ConfigurationException`.
    pub fn is_invalid_s3_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::InvalidS3ConfigurationException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::InvalidSnsTopicException`.
    pub fn is_invalid_sns_topic_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::InvalidSnsTopicException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::RuleDoesNotExistException`.
    pub fn is_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::RuleDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for CreateReceiptRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReceiptRuleErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::InvalidLambdaFunctionException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::InvalidS3ConfigurationException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::InvalidSnsTopicException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            CreateReceiptRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: CreateReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReceiptRuleSetErrorKind {
    /// <p>Indicates that a resource could not be created because of a naming conflict.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReceiptRuleSetErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateReceiptRuleSetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        CreateReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReceiptRuleSetError {
    /// Creates a new `CreateReceiptRuleSetError`.
    pub fn new(kind: CreateReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateReceiptRuleSetErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleSetErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateReceiptRuleSetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReceiptRuleSetErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReceiptRuleSetErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateReceiptRuleSetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTemplateErrorKind {
    /// <p>Indicates that a resource could not be created because of a naming conflict.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Indicates that the template that you specified could not be rendered. This issue may
    /// occur when a template refers to a partial that does not exist.</p>
    InvalidTemplateException(crate::error::InvalidTemplateException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTemplateErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::InvalidTemplateException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTemplateError {
    fn code(&self) -> Option<&str> {
        CreateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTemplateError {
    /// Creates a new `CreateTemplateError`.
    pub fn new(kind: CreateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTemplateErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns true if the error kind is `CreateTemplateErrorKind::InvalidTemplateException`.
    pub fn is_invalid_template_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::InvalidTemplateException(_)
        )
    }
    /// Returns true if the error kind is `CreateTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTemplateErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTemplateErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateTemplateErrorKind::InvalidTemplateException(_inner) => Some(_inner),
            CreateTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetError {
    /// Creates a new `DeleteConfigurationSetError`.
    pub fn new(kind: DeleteConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationSetErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DeleteConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetEventDestinationErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the event destination does not exist.</p>
    EventDestinationDoesNotExistException(crate::error::EventDestinationDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetEventDestinationError {
    /// Creates a new `DeleteConfigurationSetEventDestinationError`.
    pub fn new(
        kind: DeleteConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException`.
    pub fn is_event_destination_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(
                _
            )
        )
    }
}
impl std::error::Error for DeleteConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DeleteConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DeleteConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigurationSetTrackingOptionsError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigurationSetTrackingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigurationSetTrackingOptionsErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the TrackingOptions object you specified does not exist.</p>
    TrackingOptionsDoesNotExistException(crate::error::TrackingOptionsDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigurationSetTrackingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigurationSetTrackingOptionsError {
    fn code(&self) -> Option<&str> {
        DeleteConfigurationSetTrackingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigurationSetTrackingOptionsError {
    /// Creates a new `DeleteConfigurationSetTrackingOptionsError`.
    pub fn new(
        kind: DeleteConfigurationSetTrackingOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigurationSetTrackingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigurationSetTrackingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `DeleteConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException`.
    pub fn is_tracking_options_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DeleteConfigurationSetTrackingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DeleteConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DeleteConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomVerificationEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomVerificationEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomVerificationEmailTemplateErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomVerificationEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomVerificationEmailTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteCustomVerificationEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomVerificationEmailTemplateError {
    /// Creates a new `DeleteCustomVerificationEmailTemplateError`.
    pub fn new(
        kind: DeleteCustomVerificationEmailTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomVerificationEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomVerificationEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteCustomVerificationEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIdentityError {
    /// Kind of error that occurred.
    pub kind: DeleteIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIdentityErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIdentityError {
    fn code(&self) -> Option<&str> {
        DeleteIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIdentityError {
    /// Creates a new `DeleteIdentityError`.
    pub fn new(kind: DeleteIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIdentityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIdentityPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteIdentityPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIdentityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIdentityPolicyErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIdentityPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIdentityPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIdentityPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteIdentityPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIdentityPolicyError {
    /// Creates a new `DeleteIdentityPolicyError`.
    pub fn new(kind: DeleteIdentityPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIdentityPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIdentityPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIdentityPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIdentityPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteIdentityPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIdentityPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReceiptFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReceiptFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteReceiptFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReceiptFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReceiptFilterErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReceiptFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReceiptFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReceiptFilterError {
    fn code(&self) -> Option<&str> {
        DeleteReceiptFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReceiptFilterError {
    /// Creates a new `DeleteReceiptFilterError`.
    pub fn new(kind: DeleteReceiptFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReceiptFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReceiptFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReceiptFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReceiptFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteReceiptFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReceiptFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReceiptRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteReceiptRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReceiptRuleErrorKind {
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReceiptRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteReceiptRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReceiptRuleError {
    fn code(&self) -> Option<&str> {
        DeleteReceiptRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReceiptRuleError {
    /// Creates a new `DeleteReceiptRuleError`.
    pub fn new(kind: DeleteReceiptRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReceiptRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReceiptRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReceiptRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReceiptRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteReceiptRuleErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReceiptRuleErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DeleteReceiptRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            DeleteReceiptRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: DeleteReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReceiptRuleSetErrorKind {
    /// <p>Indicates that the delete operation could not be completed.</p>
    CannotDeleteException(crate::error::CannotDeleteException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReceiptRuleSetErrorKind::CannotDeleteException(_inner) => _inner.fmt(f),
            DeleteReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        DeleteReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReceiptRuleSetError {
    /// Creates a new `DeleteReceiptRuleSetError`.
    pub fn new(kind: DeleteReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteReceiptRuleSetErrorKind::CannotDeleteException`.
    pub fn is_cannot_delete_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReceiptRuleSetErrorKind::CannotDeleteException(_)
        )
    }
}
impl std::error::Error for DeleteReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReceiptRuleSetErrorKind::CannotDeleteException(_inner) => Some(_inner),
            DeleteReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTemplateErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTemplateError {
    /// Creates a new `DeleteTemplateError`.
    pub fn new(kind: DeleteTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVerifiedEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVerifiedEmailAddressError {
    /// Kind of error that occurred.
    pub kind: DeleteVerifiedEmailAddressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVerifiedEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVerifiedEmailAddressErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVerifiedEmailAddressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVerifiedEmailAddressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVerifiedEmailAddressError {
    fn code(&self) -> Option<&str> {
        DeleteVerifiedEmailAddressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVerifiedEmailAddressError {
    /// Creates a new `DeleteVerifiedEmailAddressError`.
    pub fn new(kind: DeleteVerifiedEmailAddressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVerifiedEmailAddressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVerifiedEmailAddressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVerifiedEmailAddressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVerifiedEmailAddressErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteVerifiedEmailAddressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVerifiedEmailAddressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeActiveReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeActiveReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: DescribeActiveReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeActiveReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeActiveReceiptRuleSetErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeActiveReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeActiveReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeActiveReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        DescribeActiveReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeActiveReceiptRuleSetError {
    /// Creates a new `DescribeActiveReceiptRuleSetError`.
    pub fn new(kind: DescribeActiveReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeActiveReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeActiveReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeActiveReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeActiveReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeActiveReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeActiveReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConfigurationSetError {
    /// Kind of error that occurred.
    pub kind: DescribeConfigurationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConfigurationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConfigurationSetErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConfigurationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeConfigurationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConfigurationSetError {
    fn code(&self) -> Option<&str> {
        DescribeConfigurationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConfigurationSetError {
    /// Creates a new `DescribeConfigurationSetError`.
    pub fn new(kind: DescribeConfigurationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConfigurationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConfigurationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConfigurationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConfigurationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeConfigurationSetErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DescribeConfigurationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConfigurationSetErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeConfigurationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReceiptRuleError {
    /// Kind of error that occurred.
    pub kind: DescribeReceiptRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReceiptRuleErrorKind {
    /// <p>Indicates that the provided receipt rule does not exist.</p>
    RuleDoesNotExistException(crate::error::RuleDoesNotExistException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReceiptRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeReceiptRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReceiptRuleError {
    fn code(&self) -> Option<&str> {
        DescribeReceiptRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReceiptRuleError {
    /// Creates a new `DescribeReceiptRuleError`.
    pub fn new(kind: DescribeReceiptRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReceiptRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReceiptRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReceiptRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReceiptRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeReceiptRuleErrorKind::RuleDoesNotExistException`.
    pub fn is_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReceiptRuleErrorKind::RuleDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `DescribeReceiptRuleErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReceiptRuleErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DescribeReceiptRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => Some(_inner),
            DescribeReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            DescribeReceiptRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: DescribeReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReceiptRuleSetErrorKind {
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        DescribeReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReceiptRuleSetError {
    /// Creates a new `DescribeReceiptRuleSetError`.
    pub fn new(kind: DescribeReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeReceiptRuleSetErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for DescribeReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            DescribeReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSendingEnabledError {
    /// Kind of error that occurred.
    pub kind: GetAccountSendingEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSendingEnabledErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSendingEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSendingEnabledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSendingEnabledError {
    fn code(&self) -> Option<&str> {
        GetAccountSendingEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountSendingEnabledError {
    /// Creates a new `GetAccountSendingEnabledError`.
    pub fn new(kind: GetAccountSendingEnabledErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSendingEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSendingEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSendingEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSendingEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetAccountSendingEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSendingEnabledErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCustomVerificationEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: GetCustomVerificationEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCustomVerificationEmailTemplateErrorKind {
    /// <p>Indicates that a custom verification email template with the name you specified does
    /// not exist.</p>
    CustomVerificationEmailTemplateDoesNotExistException(
        crate::error::CustomVerificationEmailTemplateDoesNotExistException,
    ),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCustomVerificationEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            GetCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCustomVerificationEmailTemplateError {
    fn code(&self) -> Option<&str> {
        GetCustomVerificationEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCustomVerificationEmailTemplateError {
    /// Creates a new `GetCustomVerificationEmailTemplateError`.
    pub fn new(
        kind: GetCustomVerificationEmailTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCustomVerificationEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCustomVerificationEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException`.
    pub fn is_custom_verification_email_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, GetCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_))
    }
}
impl std::error::Error for GetCustomVerificationEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            GetCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetIdentityDkimAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityDkimAttributesError {
    /// Kind of error that occurred.
    pub kind: GetIdentityDkimAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityDkimAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityDkimAttributesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityDkimAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityDkimAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityDkimAttributesError {
    fn code(&self) -> Option<&str> {
        GetIdentityDkimAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityDkimAttributesError {
    /// Creates a new `GetIdentityDkimAttributesError`.
    pub fn new(kind: GetIdentityDkimAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityDkimAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityDkimAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityDkimAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityDkimAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetIdentityDkimAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityDkimAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIdentityMailFromDomainAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityMailFromDomainAttributesError {
    /// Kind of error that occurred.
    pub kind: GetIdentityMailFromDomainAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityMailFromDomainAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityMailFromDomainAttributesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityMailFromDomainAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityMailFromDomainAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityMailFromDomainAttributesError {
    fn code(&self) -> Option<&str> {
        GetIdentityMailFromDomainAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityMailFromDomainAttributesError {
    /// Creates a new `GetIdentityMailFromDomainAttributesError`.
    pub fn new(
        kind: GetIdentityMailFromDomainAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityMailFromDomainAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityMailFromDomainAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityMailFromDomainAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityMailFromDomainAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetIdentityMailFromDomainAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityMailFromDomainAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetIdentityNotificationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityNotificationAttributesError {
    /// Kind of error that occurred.
    pub kind: GetIdentityNotificationAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityNotificationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityNotificationAttributesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityNotificationAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityNotificationAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityNotificationAttributesError {
    fn code(&self) -> Option<&str> {
        GetIdentityNotificationAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityNotificationAttributesError {
    /// Creates a new `GetIdentityNotificationAttributesError`.
    pub fn new(
        kind: GetIdentityNotificationAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityNotificationAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityNotificationAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityNotificationAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityNotificationAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetIdentityNotificationAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityNotificationAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIdentityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityPoliciesError {
    /// Kind of error that occurred.
    pub kind: GetIdentityPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityPoliciesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityPoliciesError {
    fn code(&self) -> Option<&str> {
        GetIdentityPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityPoliciesError {
    /// Creates a new `GetIdentityPoliciesError`.
    pub fn new(kind: GetIdentityPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetIdentityPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIdentityVerificationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIdentityVerificationAttributesError {
    /// Kind of error that occurred.
    pub kind: GetIdentityVerificationAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIdentityVerificationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIdentityVerificationAttributesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIdentityVerificationAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIdentityVerificationAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIdentityVerificationAttributesError {
    fn code(&self) -> Option<&str> {
        GetIdentityVerificationAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIdentityVerificationAttributesError {
    /// Creates a new `GetIdentityVerificationAttributesError`.
    pub fn new(
        kind: GetIdentityVerificationAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIdentityVerificationAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIdentityVerificationAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIdentityVerificationAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIdentityVerificationAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetIdentityVerificationAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIdentityVerificationAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSendQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSendQuotaError {
    /// Kind of error that occurred.
    pub kind: GetSendQuotaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSendQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSendQuotaErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSendQuotaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSendQuotaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSendQuotaError {
    fn code(&self) -> Option<&str> {
        GetSendQuotaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSendQuotaError {
    /// Creates a new `GetSendQuotaError`.
    pub fn new(kind: GetSendQuotaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSendQuotaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSendQuotaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSendQuotaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSendQuotaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetSendQuotaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSendQuotaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSendStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSendStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetSendStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSendStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSendStatisticsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSendStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSendStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSendStatisticsError {
    fn code(&self) -> Option<&str> {
        GetSendStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSendStatisticsError {
    /// Creates a new `GetSendStatisticsError`.
    pub fn new(kind: GetSendStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSendStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSendStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSendStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSendStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetSendStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSendStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTemplateError {
    /// Kind of error that occurred.
    pub kind: GetTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTemplateErrorKind {
    /// <p>Indicates that the Template object you specified does not exist in your Amazon SES
    /// account.</p>
    TemplateDoesNotExistException(crate::error::TemplateDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTemplateErrorKind::TemplateDoesNotExistException(_inner) => _inner.fmt(f),
            GetTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTemplateError {
    fn code(&self) -> Option<&str> {
        GetTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTemplateError {
    /// Creates a new `GetTemplateError`.
    pub fn new(kind: GetTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTemplateErrorKind::TemplateDoesNotExistException`.
    pub fn is_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTemplateErrorKind::TemplateDoesNotExistException(_)
        )
    }
}
impl std::error::Error for GetTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTemplateErrorKind::TemplateDoesNotExistException(_inner) => Some(_inner),
            GetTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigurationSetsError {
    /// Kind of error that occurred.
    pub kind: ListConfigurationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigurationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigurationSetsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigurationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigurationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigurationSetsError {
    fn code(&self) -> Option<&str> {
        ListConfigurationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigurationSetsError {
    /// Creates a new `ListConfigurationSetsError`.
    pub fn new(kind: ListConfigurationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigurationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigurationSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListConfigurationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigurationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomVerificationEmailTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomVerificationEmailTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListCustomVerificationEmailTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomVerificationEmailTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomVerificationEmailTemplatesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomVerificationEmailTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomVerificationEmailTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomVerificationEmailTemplatesError {
    fn code(&self) -> Option<&str> {
        ListCustomVerificationEmailTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomVerificationEmailTemplatesError {
    /// Creates a new `ListCustomVerificationEmailTemplatesError`.
    pub fn new(
        kind: ListCustomVerificationEmailTemplatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomVerificationEmailTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomVerificationEmailTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomVerificationEmailTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomVerificationEmailTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListCustomVerificationEmailTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomVerificationEmailTemplatesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIdentitiesError {
    /// Kind of error that occurred.
    pub kind: ListIdentitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIdentities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIdentitiesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIdentitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIdentitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIdentitiesError {
    fn code(&self) -> Option<&str> {
        ListIdentitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIdentitiesError {
    /// Creates a new `ListIdentitiesError`.
    pub fn new(kind: ListIdentitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIdentitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIdentitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIdentitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIdentitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListIdentitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIdentitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIdentityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIdentityPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListIdentityPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIdentityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIdentityPoliciesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIdentityPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIdentityPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIdentityPoliciesError {
    fn code(&self) -> Option<&str> {
        ListIdentityPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIdentityPoliciesError {
    /// Creates a new `ListIdentityPoliciesError`.
    pub fn new(kind: ListIdentityPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIdentityPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIdentityPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIdentityPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIdentityPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListIdentityPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIdentityPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReceiptFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReceiptFiltersError {
    /// Kind of error that occurred.
    pub kind: ListReceiptFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReceiptFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReceiptFiltersErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReceiptFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReceiptFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReceiptFiltersError {
    fn code(&self) -> Option<&str> {
        ListReceiptFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReceiptFiltersError {
    /// Creates a new `ListReceiptFiltersError`.
    pub fn new(kind: ListReceiptFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReceiptFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReceiptFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReceiptFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReceiptFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListReceiptFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReceiptFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReceiptRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReceiptRuleSetsError {
    /// Kind of error that occurred.
    pub kind: ListReceiptRuleSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReceiptRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReceiptRuleSetsErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReceiptRuleSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReceiptRuleSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReceiptRuleSetsError {
    fn code(&self) -> Option<&str> {
        ListReceiptRuleSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReceiptRuleSetsError {
    /// Creates a new `ListReceiptRuleSetsError`.
    pub fn new(kind: ListReceiptRuleSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReceiptRuleSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReceiptRuleSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReceiptRuleSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReceiptRuleSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListReceiptRuleSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReceiptRuleSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTemplatesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTemplatesError {
    fn code(&self) -> Option<&str> {
        ListTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTemplatesError {
    /// Creates a new `ListTemplatesError`.
    pub fn new(kind: ListTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVerifiedEmailAddresses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVerifiedEmailAddressesError {
    /// Kind of error that occurred.
    pub kind: ListVerifiedEmailAddressesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVerifiedEmailAddresses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVerifiedEmailAddressesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVerifiedEmailAddressesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVerifiedEmailAddressesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVerifiedEmailAddressesError {
    fn code(&self) -> Option<&str> {
        ListVerifiedEmailAddressesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVerifiedEmailAddressesError {
    /// Creates a new `ListVerifiedEmailAddressesError`.
    pub fn new(kind: ListVerifiedEmailAddressesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVerifiedEmailAddressesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVerifiedEmailAddressesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVerifiedEmailAddressesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVerifiedEmailAddressesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListVerifiedEmailAddressesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVerifiedEmailAddressesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutConfigurationSetDeliveryOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutConfigurationSetDeliveryOptionsError {
    /// Kind of error that occurred.
    pub kind: PutConfigurationSetDeliveryOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutConfigurationSetDeliveryOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutConfigurationSetDeliveryOptionsErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that provided delivery option is invalid.</p>
    InvalidDeliveryOptionsException(crate::error::InvalidDeliveryOptionsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutConfigurationSetDeliveryOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutConfigurationSetDeliveryOptionsErrorKind::ConfigurationSetDoesNotExistException(
                _inner,
            ) => _inner.fmt(f),
            PutConfigurationSetDeliveryOptionsErrorKind::InvalidDeliveryOptionsException(
                _inner,
            ) => _inner.fmt(f),
            PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutConfigurationSetDeliveryOptionsError {
    fn code(&self) -> Option<&str> {
        PutConfigurationSetDeliveryOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutConfigurationSetDeliveryOptionsError {
    /// Creates a new `PutConfigurationSetDeliveryOptionsError`.
    pub fn new(
        kind: PutConfigurationSetDeliveryOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutConfigurationSetDeliveryOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutConfigurationSetDeliveryOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutConfigurationSetDeliveryOptionsErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetDeliveryOptionsErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `PutConfigurationSetDeliveryOptionsErrorKind::InvalidDeliveryOptionsException`.
    pub fn is_invalid_delivery_options_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutConfigurationSetDeliveryOptionsErrorKind::InvalidDeliveryOptionsException(_)
        )
    }
}
impl std::error::Error for PutConfigurationSetDeliveryOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutConfigurationSetDeliveryOptionsErrorKind::ConfigurationSetDoesNotExistException(
                _inner,
            ) => Some(_inner),
            PutConfigurationSetDeliveryOptionsErrorKind::InvalidDeliveryOptionsException(
                _inner,
            ) => Some(_inner),
            PutConfigurationSetDeliveryOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutIdentityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutIdentityPolicyError {
    /// Kind of error that occurred.
    pub kind: PutIdentityPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutIdentityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutIdentityPolicyErrorKind {
    /// <p>Indicates that the provided policy is invalid. Check the error stack for more
    /// information about what caused the error.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutIdentityPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutIdentityPolicyErrorKind::InvalidPolicyException(_inner) => _inner.fmt(f),
            PutIdentityPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutIdentityPolicyError {
    fn code(&self) -> Option<&str> {
        PutIdentityPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutIdentityPolicyError {
    /// Creates a new `PutIdentityPolicyError`.
    pub fn new(kind: PutIdentityPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutIdentityPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutIdentityPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutIdentityPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutIdentityPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutIdentityPolicyErrorKind::InvalidPolicyException`.
    pub fn is_invalid_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIdentityPolicyErrorKind::InvalidPolicyException(_)
        )
    }
}
impl std::error::Error for PutIdentityPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutIdentityPolicyErrorKind::InvalidPolicyException(_inner) => Some(_inner),
            PutIdentityPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReorderReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReorderReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: ReorderReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReorderReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReorderReceiptRuleSetErrorKind {
    /// <p>Indicates that the provided receipt rule does not exist.</p>
    RuleDoesNotExistException(crate::error::RuleDoesNotExistException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReorderReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReorderReceiptRuleSetErrorKind::RuleDoesNotExistException(_inner) => _inner.fmt(f),
            ReorderReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            ReorderReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReorderReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        ReorderReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReorderReceiptRuleSetError {
    /// Creates a new `ReorderReceiptRuleSetError`.
    pub fn new(kind: ReorderReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReorderReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReorderReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReorderReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReorderReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ReorderReceiptRuleSetErrorKind::RuleDoesNotExistException`.
    pub fn is_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReorderReceiptRuleSetErrorKind::RuleDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `ReorderReceiptRuleSetErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReorderReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for ReorderReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReorderReceiptRuleSetErrorKind::RuleDoesNotExistException(_inner) => Some(_inner),
            ReorderReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            ReorderReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendBounce` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendBounceError {
    /// Kind of error that occurred.
    pub kind: SendBounceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendBounce` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendBounceErrorKind {
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendBounceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendBounceErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendBounceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendBounceError {
    fn code(&self) -> Option<&str> {
        SendBounceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendBounceError {
    /// Creates a new `SendBounceError`.
    pub fn new(kind: SendBounceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendBounceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendBounceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendBounceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendBounceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendBounceErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(&self.kind, SendBounceErrorKind::MessageRejected(_))
    }
}
impl std::error::Error for SendBounceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendBounceErrorKind::MessageRejected(_inner) => Some(_inner),
            SendBounceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendBulkTemplatedEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendBulkTemplatedEmailError {
    /// Kind of error that occurred.
    pub kind: SendBulkTemplatedEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendBulkTemplatedEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendBulkTemplatedEmailErrorKind {
    /// <p>Indicates that email sending is disabled for your entire Amazon SES account.</p>
    /// <p>You can enable or disable email sending for your Amazon SES account using <a>UpdateAccountSendingEnabled</a>.</p>
    AccountSendingPausedException(crate::error::AccountSendingPausedException),
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that email sending is disabled for the configuration set.</p>
    /// <p>You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    ConfigurationSetSendingPausedException(crate::error::ConfigurationSetSendingPausedException),
    /// <p> Indicates that the message could not be sent because Amazon SES could not read the MX
    /// record required to use the specified MAIL FROM domain. For information about editing the
    /// custom MAIL FROM domain settings for an identity, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
    /// Guide</a>.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>Indicates that the Template object you specified does not exist in your Amazon SES
    /// account.</p>
    TemplateDoesNotExistException(crate::error::TemplateDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendBulkTemplatedEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendBulkTemplatedEmailErrorKind::AccountSendingPausedException(_inner) => _inner.fmt(f),
            SendBulkTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            SendBulkTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => {
                _inner.fmt(f)
            }
            SendBulkTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => {
                _inner.fmt(f)
            }
            SendBulkTemplatedEmailErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendBulkTemplatedEmailErrorKind::TemplateDoesNotExistException(_inner) => _inner.fmt(f),
            SendBulkTemplatedEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendBulkTemplatedEmailError {
    fn code(&self) -> Option<&str> {
        SendBulkTemplatedEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendBulkTemplatedEmailError {
    /// Creates a new `SendBulkTemplatedEmailError`.
    pub fn new(kind: SendBulkTemplatedEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendBulkTemplatedEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendBulkTemplatedEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendBulkTemplatedEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendBulkTemplatedEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::AccountSendingPausedException`.
    pub fn is_account_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::AccountSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::ConfigurationSetSendingPausedException`.
    pub fn is_configuration_set_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::MessageRejected(_)
        )
    }
    /// Returns true if the error kind is `SendBulkTemplatedEmailErrorKind::TemplateDoesNotExistException`.
    pub fn is_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendBulkTemplatedEmailErrorKind::TemplateDoesNotExistException(_)
        )
    }
}
impl std::error::Error for SendBulkTemplatedEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendBulkTemplatedEmailErrorKind::AccountSendingPausedException(_inner) => Some(_inner),
            SendBulkTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                Some(_inner)
            }
            SendBulkTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => {
                Some(_inner)
            }
            SendBulkTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => {
                Some(_inner)
            }
            SendBulkTemplatedEmailErrorKind::MessageRejected(_inner) => Some(_inner),
            SendBulkTemplatedEmailErrorKind::TemplateDoesNotExistException(_inner) => Some(_inner),
            SendBulkTemplatedEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendCustomVerificationEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendCustomVerificationEmailError {
    /// Kind of error that occurred.
    pub kind: SendCustomVerificationEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendCustomVerificationEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendCustomVerificationEmailErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that a custom verification email template with the name you specified does
    /// not exist.</p>
    CustomVerificationEmailTemplateDoesNotExistException(
        crate::error::CustomVerificationEmailTemplateDoesNotExistException,
    ),
    /// <p>Indicates that the sender address specified for a custom verification email is not
    /// verified, and is therefore not eligible to send the custom verification email. </p>
    FromEmailAddressNotVerifiedException(crate::error::FromEmailAddressNotVerifiedException),
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>Indicates that the account has not been granted production access.</p>
    ProductionAccessNotGrantedException(crate::error::ProductionAccessNotGrantedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendCustomVerificationEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendCustomVerificationEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            SendCustomVerificationEmailErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            SendCustomVerificationEmailErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            _inner.fmt(f)
            ,
            SendCustomVerificationEmailErrorKind::MessageRejected(_inner) =>
            _inner.fmt(f)
            ,
            SendCustomVerificationEmailErrorKind::ProductionAccessNotGrantedException(_inner) =>
            _inner.fmt(f)
            ,
            SendCustomVerificationEmailErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendCustomVerificationEmailError {
    fn code(&self) -> Option<&str> {
        SendCustomVerificationEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendCustomVerificationEmailError {
    /// Creates a new `SendCustomVerificationEmailError`.
    pub fn new(kind: SendCustomVerificationEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendCustomVerificationEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendCustomVerificationEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendCustomVerificationEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendCustomVerificationEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendCustomVerificationEmailErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendCustomVerificationEmailErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SendCustomVerificationEmailErrorKind::CustomVerificationEmailTemplateDoesNotExistException`.
    pub fn is_custom_verification_email_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, SendCustomVerificationEmailErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_))
    }
    /// Returns true if the error kind is `SendCustomVerificationEmailErrorKind::FromEmailAddressNotVerifiedException`.
    pub fn is_from_email_address_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendCustomVerificationEmailErrorKind::FromEmailAddressNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `SendCustomVerificationEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(
            &self.kind,
            SendCustomVerificationEmailErrorKind::MessageRejected(_)
        )
    }
    /// Returns true if the error kind is `SendCustomVerificationEmailErrorKind::ProductionAccessNotGrantedException`.
    pub fn is_production_access_not_granted_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendCustomVerificationEmailErrorKind::ProductionAccessNotGrantedException(_)
        )
    }
}
impl std::error::Error for SendCustomVerificationEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendCustomVerificationEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            SendCustomVerificationEmailErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            SendCustomVerificationEmailErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            Some(_inner)
            ,
            SendCustomVerificationEmailErrorKind::MessageRejected(_inner) =>
            Some(_inner)
            ,
            SendCustomVerificationEmailErrorKind::ProductionAccessNotGrantedException(_inner) =>
            Some(_inner)
            ,
            SendCustomVerificationEmailErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SendEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendEmailError {
    /// Kind of error that occurred.
    pub kind: SendEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendEmailErrorKind {
    /// <p>Indicates that email sending is disabled for your entire Amazon SES account.</p>
    /// <p>You can enable or disable email sending for your Amazon SES account using <a>UpdateAccountSendingEnabled</a>.</p>
    AccountSendingPausedException(crate::error::AccountSendingPausedException),
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that email sending is disabled for the configuration set.</p>
    /// <p>You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    ConfigurationSetSendingPausedException(crate::error::ConfigurationSetSendingPausedException),
    /// <p> Indicates that the message could not be sent because Amazon SES could not read the MX
    /// record required to use the specified MAIL FROM domain. For information about editing the
    /// custom MAIL FROM domain settings for an identity, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
    /// Guide</a>.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendEmailErrorKind::AccountSendingPausedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => _inner.fmt(f),
            SendEmailErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendEmailError {
    fn code(&self) -> Option<&str> {
        SendEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendEmailError {
    /// Creates a new `SendEmailError`.
    pub fn new(kind: SendEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendEmailErrorKind::AccountSendingPausedException`.
    pub fn is_account_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendEmailErrorKind::AccountSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendEmailErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendEmailErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SendEmailErrorKind::ConfigurationSetSendingPausedException`.
    pub fn is_configuration_set_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendEmailErrorKind::ConfigurationSetSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendEmailErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `SendEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(&self.kind, SendEmailErrorKind::MessageRejected(_))
    }
}
impl std::error::Error for SendEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendEmailErrorKind::AccountSendingPausedException(_inner) => Some(_inner),
            SendEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => Some(_inner),
            SendEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => Some(_inner),
            SendEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => Some(_inner),
            SendEmailErrorKind::MessageRejected(_inner) => Some(_inner),
            SendEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendRawEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendRawEmailError {
    /// Kind of error that occurred.
    pub kind: SendRawEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendRawEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendRawEmailErrorKind {
    /// <p>Indicates that email sending is disabled for your entire Amazon SES account.</p>
    /// <p>You can enable or disable email sending for your Amazon SES account using <a>UpdateAccountSendingEnabled</a>.</p>
    AccountSendingPausedException(crate::error::AccountSendingPausedException),
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that email sending is disabled for the configuration set.</p>
    /// <p>You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    ConfigurationSetSendingPausedException(crate::error::ConfigurationSetSendingPausedException),
    /// <p> Indicates that the message could not be sent because Amazon SES could not read the MX
    /// record required to use the specified MAIL FROM domain. For information about editing the
    /// custom MAIL FROM domain settings for an identity, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
    /// Guide</a>.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendRawEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendRawEmailErrorKind::AccountSendingPausedException(_inner) => _inner.fmt(f),
            SendRawEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => _inner.fmt(f),
            SendRawEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => _inner.fmt(f),
            SendRawEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => _inner.fmt(f),
            SendRawEmailErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendRawEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendRawEmailError {
    fn code(&self) -> Option<&str> {
        SendRawEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendRawEmailError {
    /// Creates a new `SendRawEmailError`.
    pub fn new(kind: SendRawEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendRawEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendRawEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendRawEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendRawEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendRawEmailErrorKind::AccountSendingPausedException`.
    pub fn is_account_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendRawEmailErrorKind::AccountSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendRawEmailErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendRawEmailErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SendRawEmailErrorKind::ConfigurationSetSendingPausedException`.
    pub fn is_configuration_set_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendRawEmailErrorKind::ConfigurationSetSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendRawEmailErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendRawEmailErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `SendRawEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(&self.kind, SendRawEmailErrorKind::MessageRejected(_))
    }
}
impl std::error::Error for SendRawEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendRawEmailErrorKind::AccountSendingPausedException(_inner) => Some(_inner),
            SendRawEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => Some(_inner),
            SendRawEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => Some(_inner),
            SendRawEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => Some(_inner),
            SendRawEmailErrorKind::MessageRejected(_inner) => Some(_inner),
            SendRawEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendTemplatedEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendTemplatedEmailError {
    /// Kind of error that occurred.
    pub kind: SendTemplatedEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendTemplatedEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendTemplatedEmailErrorKind {
    /// <p>Indicates that email sending is disabled for your entire Amazon SES account.</p>
    /// <p>You can enable or disable email sending for your Amazon SES account using <a>UpdateAccountSendingEnabled</a>.</p>
    AccountSendingPausedException(crate::error::AccountSendingPausedException),
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that email sending is disabled for the configuration set.</p>
    /// <p>You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
    ConfigurationSetSendingPausedException(crate::error::ConfigurationSetSendingPausedException),
    /// <p> Indicates that the message could not be sent because Amazon SES could not read the MX
    /// record required to use the specified MAIL FROM domain. For information about editing the
    /// custom MAIL FROM domain settings for an identity, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
    /// Guide</a>.</p>
    MailFromDomainNotVerifiedException(crate::error::MailFromDomainNotVerifiedException),
    /// <p>Indicates that the action failed, and the message could not be sent. Check the error
    /// stack for more information about what caused the error.</p>
    MessageRejected(crate::error::MessageRejected),
    /// <p>Indicates that the Template object you specified does not exist in your Amazon SES
    /// account.</p>
    TemplateDoesNotExistException(crate::error::TemplateDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendTemplatedEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendTemplatedEmailErrorKind::AccountSendingPausedException(_inner) => _inner.fmt(f),
            SendTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            SendTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => {
                _inner.fmt(f)
            }
            SendTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => {
                _inner.fmt(f)
            }
            SendTemplatedEmailErrorKind::MessageRejected(_inner) => _inner.fmt(f),
            SendTemplatedEmailErrorKind::TemplateDoesNotExistException(_inner) => _inner.fmt(f),
            SendTemplatedEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendTemplatedEmailError {
    fn code(&self) -> Option<&str> {
        SendTemplatedEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendTemplatedEmailError {
    /// Creates a new `SendTemplatedEmailError`.
    pub fn new(kind: SendTemplatedEmailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendTemplatedEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendTemplatedEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendTemplatedEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendTemplatedEmailErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::AccountSendingPausedException`.
    pub fn is_account_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTemplatedEmailErrorKind::AccountSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::ConfigurationSetSendingPausedException`.
    pub fn is_configuration_set_sending_paused_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_)
        )
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::MailFromDomainNotVerifiedException`.
    pub fn is_mail_from_domain_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_)
        )
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::MessageRejected`.
    pub fn is_message_rejected(&self) -> bool {
        matches!(&self.kind, SendTemplatedEmailErrorKind::MessageRejected(_))
    }
    /// Returns true if the error kind is `SendTemplatedEmailErrorKind::TemplateDoesNotExistException`.
    pub fn is_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendTemplatedEmailErrorKind::TemplateDoesNotExistException(_)
        )
    }
}
impl std::error::Error for SendTemplatedEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendTemplatedEmailErrorKind::AccountSendingPausedException(_inner) => Some(_inner),
            SendTemplatedEmailErrorKind::ConfigurationSetDoesNotExistException(_inner) => {
                Some(_inner)
            }
            SendTemplatedEmailErrorKind::ConfigurationSetSendingPausedException(_inner) => {
                Some(_inner)
            }
            SendTemplatedEmailErrorKind::MailFromDomainNotVerifiedException(_inner) => Some(_inner),
            SendTemplatedEmailErrorKind::MessageRejected(_inner) => Some(_inner),
            SendTemplatedEmailErrorKind::TemplateDoesNotExistException(_inner) => Some(_inner),
            SendTemplatedEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetActiveReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetActiveReceiptRuleSetError {
    /// Kind of error that occurred.
    pub kind: SetActiveReceiptRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetActiveReceiptRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetActiveReceiptRuleSetErrorKind {
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetActiveReceiptRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetActiveReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            SetActiveReceiptRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetActiveReceiptRuleSetError {
    fn code(&self) -> Option<&str> {
        SetActiveReceiptRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetActiveReceiptRuleSetError {
    /// Creates a new `SetActiveReceiptRuleSetError`.
    pub fn new(kind: SetActiveReceiptRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetActiveReceiptRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetActiveReceiptRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetActiveReceiptRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetActiveReceiptRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetActiveReceiptRuleSetErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetActiveReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for SetActiveReceiptRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetActiveReceiptRuleSetErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            SetActiveReceiptRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetIdentityDkimEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIdentityDkimEnabledError {
    /// Kind of error that occurred.
    pub kind: SetIdentityDkimEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIdentityDkimEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIdentityDkimEnabledErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIdentityDkimEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIdentityDkimEnabledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIdentityDkimEnabledError {
    fn code(&self) -> Option<&str> {
        SetIdentityDkimEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIdentityDkimEnabledError {
    /// Creates a new `SetIdentityDkimEnabledError`.
    pub fn new(kind: SetIdentityDkimEnabledErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIdentityDkimEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIdentityDkimEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIdentityDkimEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIdentityDkimEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetIdentityDkimEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIdentityDkimEnabledErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetIdentityFeedbackForwardingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIdentityFeedbackForwardingEnabledError {
    /// Kind of error that occurred.
    pub kind: SetIdentityFeedbackForwardingEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIdentityFeedbackForwardingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIdentityFeedbackForwardingEnabledErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIdentityFeedbackForwardingEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIdentityFeedbackForwardingEnabledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIdentityFeedbackForwardingEnabledError {
    fn code(&self) -> Option<&str> {
        SetIdentityFeedbackForwardingEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIdentityFeedbackForwardingEnabledError {
    /// Creates a new `SetIdentityFeedbackForwardingEnabledError`.
    pub fn new(
        kind: SetIdentityFeedbackForwardingEnabledErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIdentityFeedbackForwardingEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIdentityFeedbackForwardingEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIdentityFeedbackForwardingEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIdentityFeedbackForwardingEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetIdentityFeedbackForwardingEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIdentityFeedbackForwardingEnabledErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SetIdentityHeadersInNotificationsEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIdentityHeadersInNotificationsEnabledError {
    /// Kind of error that occurred.
    pub kind: SetIdentityHeadersInNotificationsEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIdentityHeadersInNotificationsEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIdentityHeadersInNotificationsEnabledErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIdentityHeadersInNotificationsEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIdentityHeadersInNotificationsEnabledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIdentityHeadersInNotificationsEnabledError {
    fn code(&self) -> Option<&str> {
        SetIdentityHeadersInNotificationsEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIdentityHeadersInNotificationsEnabledError {
    /// Creates a new `SetIdentityHeadersInNotificationsEnabledError`.
    pub fn new(
        kind: SetIdentityHeadersInNotificationsEnabledErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIdentityHeadersInNotificationsEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIdentityHeadersInNotificationsEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIdentityHeadersInNotificationsEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIdentityHeadersInNotificationsEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetIdentityHeadersInNotificationsEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIdentityHeadersInNotificationsEnabledErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SetIdentityMailFromDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIdentityMailFromDomainError {
    /// Kind of error that occurred.
    pub kind: SetIdentityMailFromDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIdentityMailFromDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIdentityMailFromDomainErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIdentityMailFromDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIdentityMailFromDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIdentityMailFromDomainError {
    fn code(&self) -> Option<&str> {
        SetIdentityMailFromDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIdentityMailFromDomainError {
    /// Creates a new `SetIdentityMailFromDomainError`.
    pub fn new(kind: SetIdentityMailFromDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIdentityMailFromDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIdentityMailFromDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIdentityMailFromDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIdentityMailFromDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetIdentityMailFromDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIdentityMailFromDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetIdentityNotificationTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIdentityNotificationTopicError {
    /// Kind of error that occurred.
    pub kind: SetIdentityNotificationTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIdentityNotificationTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIdentityNotificationTopicErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIdentityNotificationTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIdentityNotificationTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIdentityNotificationTopicError {
    fn code(&self) -> Option<&str> {
        SetIdentityNotificationTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIdentityNotificationTopicError {
    /// Creates a new `SetIdentityNotificationTopicError`.
    pub fn new(kind: SetIdentityNotificationTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIdentityNotificationTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIdentityNotificationTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIdentityNotificationTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIdentityNotificationTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for SetIdentityNotificationTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIdentityNotificationTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetReceiptRulePosition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetReceiptRulePositionError {
    /// Kind of error that occurred.
    pub kind: SetReceiptRulePositionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetReceiptRulePosition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetReceiptRulePositionErrorKind {
    /// <p>Indicates that the provided receipt rule does not exist.</p>
    RuleDoesNotExistException(crate::error::RuleDoesNotExistException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetReceiptRulePositionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetReceiptRulePositionErrorKind::RuleDoesNotExistException(_inner) => _inner.fmt(f),
            SetReceiptRulePositionErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            SetReceiptRulePositionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetReceiptRulePositionError {
    fn code(&self) -> Option<&str> {
        SetReceiptRulePositionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetReceiptRulePositionError {
    /// Creates a new `SetReceiptRulePositionError`.
    pub fn new(kind: SetReceiptRulePositionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetReceiptRulePositionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetReceiptRulePositionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetReceiptRulePositionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetReceiptRulePositionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetReceiptRulePositionErrorKind::RuleDoesNotExistException`.
    pub fn is_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetReceiptRulePositionErrorKind::RuleDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `SetReceiptRulePositionErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetReceiptRulePositionErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for SetReceiptRulePositionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetReceiptRulePositionErrorKind::RuleDoesNotExistException(_inner) => Some(_inner),
            SetReceiptRulePositionErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            SetReceiptRulePositionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestRenderTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestRenderTemplateError {
    /// Kind of error that occurred.
    pub kind: TestRenderTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestRenderTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestRenderTemplateErrorKind {
    /// <p>Indicates that one or more of the replacement values you provided is invalid. This
    /// error may occur when the TemplateData object contains invalid JSON.</p>
    InvalidRenderingParameterException(crate::error::InvalidRenderingParameterException),
    /// <p>Indicates that one or more of the replacement values for the specified template was
    /// not specified. Ensure that the TemplateData object contains references to all of the
    /// replacement tags in the specified template.</p>
    MissingRenderingAttributeException(crate::error::MissingRenderingAttributeException),
    /// <p>Indicates that the Template object you specified does not exist in your Amazon SES
    /// account.</p>
    TemplateDoesNotExistException(crate::error::TemplateDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestRenderTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestRenderTemplateErrorKind::InvalidRenderingParameterException(_inner) => {
                _inner.fmt(f)
            }
            TestRenderTemplateErrorKind::MissingRenderingAttributeException(_inner) => {
                _inner.fmt(f)
            }
            TestRenderTemplateErrorKind::TemplateDoesNotExistException(_inner) => _inner.fmt(f),
            TestRenderTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestRenderTemplateError {
    fn code(&self) -> Option<&str> {
        TestRenderTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestRenderTemplateError {
    /// Creates a new `TestRenderTemplateError`.
    pub fn new(kind: TestRenderTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestRenderTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestRenderTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestRenderTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestRenderTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TestRenderTemplateErrorKind::InvalidRenderingParameterException`.
    pub fn is_invalid_rendering_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRenderTemplateErrorKind::InvalidRenderingParameterException(_)
        )
    }
    /// Returns true if the error kind is `TestRenderTemplateErrorKind::MissingRenderingAttributeException`.
    pub fn is_missing_rendering_attribute_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRenderTemplateErrorKind::MissingRenderingAttributeException(_)
        )
    }
    /// Returns true if the error kind is `TestRenderTemplateErrorKind::TemplateDoesNotExistException`.
    pub fn is_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRenderTemplateErrorKind::TemplateDoesNotExistException(_)
        )
    }
}
impl std::error::Error for TestRenderTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestRenderTemplateErrorKind::InvalidRenderingParameterException(_inner) => Some(_inner),
            TestRenderTemplateErrorKind::MissingRenderingAttributeException(_inner) => Some(_inner),
            TestRenderTemplateErrorKind::TemplateDoesNotExistException(_inner) => Some(_inner),
            TestRenderTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccountSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountSendingEnabledError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountSendingEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccountSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountSendingEnabledErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountSendingEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountSendingEnabledErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountSendingEnabledError {
    fn code(&self) -> Option<&str> {
        UpdateAccountSendingEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccountSendingEnabledError {
    /// Creates a new `UpdateAccountSendingEnabledError`.
    pub fn new(kind: UpdateAccountSendingEnabledErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountSendingEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountSendingEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountSendingEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountSendingEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UpdateAccountSendingEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountSendingEnabledErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetEventDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetEventDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetEventDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetEventDestinationErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the event destination does not exist.</p>
    EventDestinationDoesNotExistException(crate::error::EventDestinationDoesNotExistException),
    /// <p>Indicates that the Amazon CloudWatch destination is invalid. See the error message for
    /// details.</p>
    InvalidCloudWatchDestinationException(crate::error::InvalidCloudWatchDestinationException),
    /// <p>Indicates that the Amazon Kinesis Firehose destination is invalid. See the error
    /// message for details.</p>
    InvalidFirehoseDestinationException(crate::error::InvalidFirehoseDestinationException),
    /// <p>Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is
    /// invalid. See the error message for details.</p>
    InvalidSnsDestinationException(crate::error::InvalidSnsDestinationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetEventDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationSetEventDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetEventDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetEventDestinationError {
    /// Creates a new `UpdateConfigurationSetEventDestinationError`.
    pub fn new(
        kind: UpdateConfigurationSetEventDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetEventDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetEventDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException`.
    pub fn is_event_destination_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException`.
    pub fn is_invalid_cloud_watch_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(
                _
            )
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException`.
    pub fn is_invalid_firehose_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException`.
    pub fn is_invalid_sns_destination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationSetEventDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetEventDestinationErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::EventDestinationDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidCloudWatchDestinationException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidFirehoseDestinationException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::InvalidSnsDestinationException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetEventDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateConfigurationSetReputationMetricsEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetReputationMetricsEnabledError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetReputationMetricsEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetReputationMetricsEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetReputationMetricsEnabledErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetReputationMetricsEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetReputationMetricsEnabledErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetReputationMetricsEnabledErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for UpdateConfigurationSetReputationMetricsEnabledError
{
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetReputationMetricsEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetReputationMetricsEnabledError {
    /// Creates a new `UpdateConfigurationSetReputationMetricsEnabledError`.
    pub fn new(
        kind: UpdateConfigurationSetReputationMetricsEnabledErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetReputationMetricsEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetReputationMetricsEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetReputationMetricsEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetReputationMetricsEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationSetReputationMetricsEnabledErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, UpdateConfigurationSetReputationMetricsEnabledErrorKind::ConfigurationSetDoesNotExistException(_))
    }
}
impl std::error::Error for UpdateConfigurationSetReputationMetricsEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetReputationMetricsEnabledErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetReputationMetricsEnabledErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateConfigurationSetSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetSendingEnabledError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetSendingEnabledErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetSendingEnabled` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetSendingEnabledErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetSendingEnabledError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetSendingEnabledErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetSendingEnabledErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationSetSendingEnabledError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetSendingEnabledError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetSendingEnabledError {
    /// Creates a new `UpdateConfigurationSetSendingEnabledError`.
    pub fn new(
        kind: UpdateConfigurationSetSendingEnabledErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetSendingEnabledError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetSendingEnabledErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetSendingEnabledError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetSendingEnabledErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationSetSendingEnabledErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetSendingEnabledErrorKind::ConfigurationSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationSetSendingEnabledError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetSendingEnabledErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetSendingEnabledErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigurationSetTrackingOptionsError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigurationSetTrackingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfigurationSetTrackingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigurationSetTrackingOptionsErrorKind {
    /// <p>Indicates that the configuration set does not exist.</p>
    ConfigurationSetDoesNotExistException(crate::error::ConfigurationSetDoesNotExistException),
    /// <p>Indicates that the custom domain to be used for open and click tracking redirects is
    /// invalid. This error appears most often in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>When the tracking domain you specified is not verified in Amazon SES.</p>
    /// </li>
    /// <li>
    /// <p>When the tracking domain you specified is not a valid domain or
    /// subdomain.</p>
    /// </li>
    /// </ul>
    InvalidTrackingOptionsException(crate::error::InvalidTrackingOptionsException),
    /// <p>Indicates that the TrackingOptions object you specified does not exist.</p>
    TrackingOptionsDoesNotExistException(crate::error::TrackingOptionsDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigurationSetTrackingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigurationSetTrackingOptionsError {
    fn code(&self) -> Option<&str> {
        UpdateConfigurationSetTrackingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigurationSetTrackingOptionsError {
    /// Creates a new `UpdateConfigurationSetTrackingOptionsError`.
    pub fn new(
        kind: UpdateConfigurationSetTrackingOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigurationSetTrackingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigurationSetTrackingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigurationSetTrackingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException`.
    pub fn is_configuration_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(
                _
            )
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException`.
    pub fn is_invalid_tracking_options_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException`.
    pub fn is_tracking_options_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_)
        )
    }
}
impl std::error::Error for UpdateConfigurationSetTrackingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigurationSetTrackingOptionsErrorKind::ConfigurationSetDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::InvalidTrackingOptionsException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::TrackingOptionsDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateConfigurationSetTrackingOptionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCustomVerificationEmailTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateCustomVerificationEmailTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCustomVerificationEmailTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCustomVerificationEmailTemplateErrorKind {
    /// <p>Indicates that custom verification email template provided content is invalid.</p>
    CustomVerificationEmailInvalidContentException(
        crate::error::CustomVerificationEmailInvalidContentException,
    ),
    /// <p>Indicates that a custom verification email template with the name you specified does
    /// not exist.</p>
    CustomVerificationEmailTemplateDoesNotExistException(
        crate::error::CustomVerificationEmailTemplateDoesNotExistException,
    ),
    /// <p>Indicates that the sender address specified for a custom verification email is not
    /// verified, and is therefore not eligible to send the custom verification email. </p>
    FromEmailAddressNotVerifiedException(crate::error::FromEmailAddressNotVerifiedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCustomVerificationEmailTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCustomVerificationEmailTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateCustomVerificationEmailTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCustomVerificationEmailTemplateError {
    /// Creates a new `UpdateCustomVerificationEmailTemplateError`.
    pub fn new(
        kind: UpdateCustomVerificationEmailTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCustomVerificationEmailTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCustomVerificationEmailTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCustomVerificationEmailTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException`.
    pub fn is_custom_verification_email_invalid_content_exception(&self) -> bool {
        matches!(&self.kind, UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_))
    }
    /// Returns true if the error kind is `UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException`.
    pub fn is_custom_verification_email_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_))
    }
    /// Returns true if the error kind is `UpdateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException`.
    pub fn is_from_email_address_not_verified_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_)
        )
    }
}
impl std::error::Error for UpdateCustomVerificationEmailTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailInvalidContentException(_inner) =>
            Some(_inner)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::CustomVerificationEmailTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::FromEmailAddressNotVerifiedException(_inner) =>
            Some(_inner)
            ,
            UpdateCustomVerificationEmailTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReceiptRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateReceiptRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReceiptRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReceiptRuleErrorKind {
    /// <p>Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could
    /// not execute the provided function, possibly due to permissions issues. For information
    /// about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidLambdaFunctionException(crate::error::InvalidLambdaFunctionException),
    /// <p>Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or
    /// that Amazon SES could not publish to the bucket, possibly due to permissions issues. For
    /// information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidS3ConfigurationException(crate::error::InvalidS3ConfigurationException),
    /// <p>Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not
    /// publish to the topic, possibly due to permissions issues. For information about giving
    /// permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
    /// Developer Guide</a>.</p>
    InvalidSnsTopicException(crate::error::InvalidSnsTopicException),
    /// <p>Indicates that a resource could not be created because of service limits. For a list
    /// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
    /// Guide</a>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Indicates that the provided receipt rule does not exist.</p>
    RuleDoesNotExistException(crate::error::RuleDoesNotExistException),
    /// <p>Indicates that the provided receipt rule set does not exist.</p>
    RuleSetDoesNotExistException(crate::error::RuleSetDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReceiptRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReceiptRuleErrorKind::InvalidLambdaFunctionException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::InvalidS3ConfigurationException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::InvalidSnsTopicException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateReceiptRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReceiptRuleError {
    fn code(&self) -> Option<&str> {
        UpdateReceiptRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReceiptRuleError {
    /// Creates a new `UpdateReceiptRuleError`.
    pub fn new(kind: UpdateReceiptRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReceiptRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReceiptRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReceiptRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReceiptRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::InvalidLambdaFunctionException`.
    pub fn is_invalid_lambda_function_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::InvalidLambdaFunctionException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::InvalidS3ConfigurationException`.
    pub fn is_invalid_s3_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::InvalidS3ConfigurationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::InvalidSnsTopicException`.
    pub fn is_invalid_sns_topic_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::InvalidSnsTopicException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::RuleDoesNotExistException`.
    pub fn is_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::RuleDoesNotExistException(_)
        )
    }
    /// Returns true if the error kind is `UpdateReceiptRuleErrorKind::RuleSetDoesNotExistException`.
    pub fn is_rule_set_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReceiptRuleErrorKind::RuleSetDoesNotExistException(_)
        )
    }
}
impl std::error::Error for UpdateReceiptRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReceiptRuleErrorKind::InvalidLambdaFunctionException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::InvalidS3ConfigurationException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::InvalidSnsTopicException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::RuleDoesNotExistException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::RuleSetDoesNotExistException(_inner) => Some(_inner),
            UpdateReceiptRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTemplateErrorKind {
    /// <p>Indicates that the template that you specified could not be rendered. This issue may
    /// occur when a template refers to a partial that does not exist.</p>
    InvalidTemplateException(crate::error::InvalidTemplateException),
    /// <p>Indicates that the Template object you specified does not exist in your Amazon SES
    /// account.</p>
    TemplateDoesNotExistException(crate::error::TemplateDoesNotExistException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTemplateErrorKind::InvalidTemplateException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::TemplateDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTemplateError {
    /// Creates a new `UpdateTemplateError`.
    pub fn new(kind: UpdateTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTemplateErrorKind::InvalidTemplateException`.
    pub fn is_invalid_template_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::InvalidTemplateException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTemplateErrorKind::TemplateDoesNotExistException`.
    pub fn is_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTemplateErrorKind::TemplateDoesNotExistException(_)
        )
    }
}
impl std::error::Error for UpdateTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTemplateErrorKind::InvalidTemplateException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::TemplateDoesNotExistException(_inner) => Some(_inner),
            UpdateTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyDomainDkim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyDomainDkimError {
    /// Kind of error that occurred.
    pub kind: VerifyDomainDkimErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyDomainDkim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyDomainDkimErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyDomainDkimError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyDomainDkimErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyDomainDkimError {
    fn code(&self) -> Option<&str> {
        VerifyDomainDkimError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyDomainDkimError {
    /// Creates a new `VerifyDomainDkimError`.
    pub fn new(kind: VerifyDomainDkimErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyDomainDkimError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyDomainDkimErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyDomainDkimError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyDomainDkimErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for VerifyDomainDkimError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyDomainDkimErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyDomainIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyDomainIdentityError {
    /// Kind of error that occurred.
    pub kind: VerifyDomainIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyDomainIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyDomainIdentityErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyDomainIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyDomainIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyDomainIdentityError {
    fn code(&self) -> Option<&str> {
        VerifyDomainIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyDomainIdentityError {
    /// Creates a new `VerifyDomainIdentityError`.
    pub fn new(kind: VerifyDomainIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyDomainIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyDomainIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyDomainIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyDomainIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for VerifyDomainIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyDomainIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyEmailAddressError {
    /// Kind of error that occurred.
    pub kind: VerifyEmailAddressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyEmailAddress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyEmailAddressErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyEmailAddressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyEmailAddressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyEmailAddressError {
    fn code(&self) -> Option<&str> {
        VerifyEmailAddressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyEmailAddressError {
    /// Creates a new `VerifyEmailAddressError`.
    pub fn new(kind: VerifyEmailAddressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyEmailAddressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyEmailAddressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyEmailAddressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyEmailAddressErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for VerifyEmailAddressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyEmailAddressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifyEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifyEmailIdentityError {
    /// Kind of error that occurred.
    pub kind: VerifyEmailIdentityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifyEmailIdentity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifyEmailIdentityErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifyEmailIdentityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifyEmailIdentityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifyEmailIdentityError {
    fn code(&self) -> Option<&str> {
        VerifyEmailIdentityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifyEmailIdentityError {
    /// Creates a new `VerifyEmailIdentityError`.
    pub fn new(kind: VerifyEmailIdentityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifyEmailIdentityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifyEmailIdentityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifyEmailIdentityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifyEmailIdentityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for VerifyEmailIdentityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifyEmailIdentityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that the Template object you specified does not exist in your Amazon SES
/// account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateDoesNotExistException {
    #[allow(missing_docs)] // documentation missing in model
    pub template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TemplateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateDoesNotExistException");
        formatter.field("template_name", &self.template_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TemplateDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TemplateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TemplateDoesNotExistException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TemplateDoesNotExistException {}
/// See [`TemplateDoesNotExistException`](crate::error::TemplateDoesNotExistException)
pub mod template_does_not_exist_exception {
    /// A builder for [`TemplateDoesNotExistException`](crate::error::TemplateDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateDoesNotExistException`](crate::error::TemplateDoesNotExistException)
        pub fn build(self) -> crate::error::TemplateDoesNotExistException {
            crate::error::TemplateDoesNotExistException {
                template_name: self.template_name,
                message: self.message,
            }
        }
    }
}
impl TemplateDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`TemplateDoesNotExistException`](crate::error::TemplateDoesNotExistException)
    pub fn builder() -> crate::error::template_does_not_exist_exception::Builder {
        crate::error::template_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that the template that you specified could not be rendered. This issue may
/// occur when a template refers to a partial that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTemplateException {
    #[allow(missing_docs)] // documentation missing in model
    pub template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTemplateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTemplateException");
        formatter.field("template_name", &self.template_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTemplateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTemplateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTemplateException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTemplateException {}
/// See [`InvalidTemplateException`](crate::error::InvalidTemplateException)
pub mod invalid_template_exception {
    /// A builder for [`InvalidTemplateException`](crate::error::InvalidTemplateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTemplateException`](crate::error::InvalidTemplateException)
        pub fn build(self) -> crate::error::InvalidTemplateException {
            crate::error::InvalidTemplateException {
                template_name: self.template_name,
                message: self.message,
            }
        }
    }
}
impl InvalidTemplateException {
    /// Creates a new builder-style object to manufacture [`InvalidTemplateException`](crate::error::InvalidTemplateException)
    pub fn builder() -> crate::error::invalid_template_exception::Builder {
        crate::error::invalid_template_exception::Builder::default()
    }
}

/// <p>Indicates that the provided receipt rule set does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleSetDoesNotExistException {
    /// <p>Indicates that the named receipt rule set does not exist.</p>
    pub name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RuleSetDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleSetDoesNotExistException");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RuleSetDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RuleSetDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RuleSetDoesNotExistException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for RuleSetDoesNotExistException {}
/// See [`RuleSetDoesNotExistException`](crate::error::RuleSetDoesNotExistException)
pub mod rule_set_does_not_exist_exception {
    /// A builder for [`RuleSetDoesNotExistException`](crate::error::RuleSetDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the named receipt rule set does not exist.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Indicates that the named receipt rule set does not exist.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleSetDoesNotExistException`](crate::error::RuleSetDoesNotExistException)
        pub fn build(self) -> crate::error::RuleSetDoesNotExistException {
            crate::error::RuleSetDoesNotExistException {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl RuleSetDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`RuleSetDoesNotExistException`](crate::error::RuleSetDoesNotExistException)
    pub fn builder() -> crate::error::rule_set_does_not_exist_exception::Builder {
        crate::error::rule_set_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that the provided receipt rule does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleDoesNotExistException {
    /// <p>Indicates that the named receipt rule does not exist.</p>
    pub name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RuleDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleDoesNotExistException");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RuleDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RuleDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RuleDoesNotExistException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for RuleDoesNotExistException {}
/// See [`RuleDoesNotExistException`](crate::error::RuleDoesNotExistException)
pub mod rule_does_not_exist_exception {
    /// A builder for [`RuleDoesNotExistException`](crate::error::RuleDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the named receipt rule does not exist.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Indicates that the named receipt rule does not exist.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleDoesNotExistException`](crate::error::RuleDoesNotExistException)
        pub fn build(self) -> crate::error::RuleDoesNotExistException {
            crate::error::RuleDoesNotExistException {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl RuleDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`RuleDoesNotExistException`](crate::error::RuleDoesNotExistException)
    pub fn builder() -> crate::error::rule_does_not_exist_exception::Builder {
        crate::error::rule_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that a resource could not be created because of service limits. For a list
/// of Amazon SES limits, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES could not
/// publish to the topic, possibly due to permissions issues. For information about giving
/// permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnsTopicException {
    /// <p>Indicates that the topic does not exist.</p>
    pub topic: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnsTopicException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnsTopicException");
        formatter.field("topic", &self.topic);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnsTopicException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnsTopicException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSnsTopicException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnsTopicException {}
/// See [`InvalidSnsTopicException`](crate::error::InvalidSnsTopicException)
pub mod invalid_sns_topic_exception {
    /// A builder for [`InvalidSnsTopicException`](crate::error::InvalidSnsTopicException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the topic does not exist.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>Indicates that the topic does not exist.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnsTopicException`](crate::error::InvalidSnsTopicException)
        pub fn build(self) -> crate::error::InvalidSnsTopicException {
            crate::error::InvalidSnsTopicException {
                topic: self.topic,
                message: self.message,
            }
        }
    }
}
impl InvalidSnsTopicException {
    /// Creates a new builder-style object to manufacture [`InvalidSnsTopicException`](crate::error::InvalidSnsTopicException)
    pub fn builder() -> crate::error::invalid_sns_topic_exception::Builder {
        crate::error::invalid_sns_topic_exception::Builder::default()
    }
}

/// <p>Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or
/// that Amazon SES could not publish to the bucket, possibly due to permissions issues. For
/// information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3ConfigurationException {
    /// <p>Indicated that the S3 Bucket was not found.</p>
    pub bucket: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3ConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3ConfigurationException");
        formatter.field("bucket", &self.bucket);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3ConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3ConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3ConfigurationException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3ConfigurationException {}
/// See [`InvalidS3ConfigurationException`](crate::error::InvalidS3ConfigurationException)
pub mod invalid_s3_configuration_exception {
    /// A builder for [`InvalidS3ConfigurationException`](crate::error::InvalidS3ConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicated that the S3 Bucket was not found.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Indicated that the S3 Bucket was not found.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3ConfigurationException`](crate::error::InvalidS3ConfigurationException)
        pub fn build(self) -> crate::error::InvalidS3ConfigurationException {
            crate::error::InvalidS3ConfigurationException {
                bucket: self.bucket,
                message: self.message,
            }
        }
    }
}
impl InvalidS3ConfigurationException {
    /// Creates a new builder-style object to manufacture [`InvalidS3ConfigurationException`](crate::error::InvalidS3ConfigurationException)
    pub fn builder() -> crate::error::invalid_s3_configuration_exception::Builder {
        crate::error::invalid_s3_configuration_exception::Builder::default()
    }
}

/// <p>Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could
/// not execute the provided function, possibly due to permissions issues. For information
/// about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES
/// Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLambdaFunctionException {
    /// <p>Indicates that the ARN of the function was not found.</p>
    pub function_arn: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLambdaFunctionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLambdaFunctionException");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLambdaFunctionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLambdaFunctionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLambdaFunctionException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLambdaFunctionException {}
/// See [`InvalidLambdaFunctionException`](crate::error::InvalidLambdaFunctionException)
pub mod invalid_lambda_function_exception {
    /// A builder for [`InvalidLambdaFunctionException`](crate::error::InvalidLambdaFunctionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the ARN of the function was not found.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>Indicates that the ARN of the function was not found.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLambdaFunctionException`](crate::error::InvalidLambdaFunctionException)
        pub fn build(self) -> crate::error::InvalidLambdaFunctionException {
            crate::error::InvalidLambdaFunctionException {
                function_arn: self.function_arn,
                message: self.message,
            }
        }
    }
}
impl InvalidLambdaFunctionException {
    /// Creates a new builder-style object to manufacture [`InvalidLambdaFunctionException`](crate::error::InvalidLambdaFunctionException)
    pub fn builder() -> crate::error::invalid_lambda_function_exception::Builder {
        crate::error::invalid_lambda_function_exception::Builder::default()
    }
}

/// <p>Indicates that the sender address specified for a custom verification email is not
/// verified, and is therefore not eligible to send the custom verification email. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FromEmailAddressNotVerifiedException {
    /// <p>Indicates that the from email address associated with the custom verification email
    /// template is not verified.</p>
    pub from_email_address: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FromEmailAddressNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FromEmailAddressNotVerifiedException");
        formatter.field("from_email_address", &self.from_email_address);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FromEmailAddressNotVerifiedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FromEmailAddressNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FromEmailAddressNotVerifiedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for FromEmailAddressNotVerifiedException {}
/// See [`FromEmailAddressNotVerifiedException`](crate::error::FromEmailAddressNotVerifiedException)
pub mod from_email_address_not_verified_exception {
    /// A builder for [`FromEmailAddressNotVerifiedException`](crate::error::FromEmailAddressNotVerifiedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_email_address: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the from email address associated with the custom verification email
        /// template is not verified.</p>
        pub fn from_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_email_address = Some(input.into());
            self
        }
        /// <p>Indicates that the from email address associated with the custom verification email
        /// template is not verified.</p>
        pub fn set_from_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_email_address = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FromEmailAddressNotVerifiedException`](crate::error::FromEmailAddressNotVerifiedException)
        pub fn build(self) -> crate::error::FromEmailAddressNotVerifiedException {
            crate::error::FromEmailAddressNotVerifiedException {
                from_email_address: self.from_email_address,
                message: self.message,
            }
        }
    }
}
impl FromEmailAddressNotVerifiedException {
    /// Creates a new builder-style object to manufacture [`FromEmailAddressNotVerifiedException`](crate::error::FromEmailAddressNotVerifiedException)
    pub fn builder() -> crate::error::from_email_address_not_verified_exception::Builder {
        crate::error::from_email_address_not_verified_exception::Builder::default()
    }
}

/// <p>Indicates that a custom verification email template with the name you specified does
/// not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomVerificationEmailTemplateDoesNotExistException {
    /// <p>Indicates that the provided custom verification email template does not exist.</p>
    pub custom_verification_email_template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomVerificationEmailTemplateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomVerificationEmailTemplateDoesNotExistException");
        formatter.field(
            "custom_verification_email_template_name",
            &self.custom_verification_email_template_name,
        );
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomVerificationEmailTemplateDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomVerificationEmailTemplateDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomVerificationEmailTemplateDoesNotExistException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomVerificationEmailTemplateDoesNotExistException {}
/// See [`CustomVerificationEmailTemplateDoesNotExistException`](crate::error::CustomVerificationEmailTemplateDoesNotExistException)
pub mod custom_verification_email_template_does_not_exist_exception {
    /// A builder for [`CustomVerificationEmailTemplateDoesNotExistException`](crate::error::CustomVerificationEmailTemplateDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_verification_email_template_name:
            std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the provided custom verification email template does not exist.</p>
        pub fn custom_verification_email_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_verification_email_template_name = Some(input.into());
            self
        }
        /// <p>Indicates that the provided custom verification email template does not exist.</p>
        pub fn set_custom_verification_email_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_verification_email_template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomVerificationEmailTemplateDoesNotExistException`](crate::error::CustomVerificationEmailTemplateDoesNotExistException)
        pub fn build(self) -> crate::error::CustomVerificationEmailTemplateDoesNotExistException {
            crate::error::CustomVerificationEmailTemplateDoesNotExistException {
                custom_verification_email_template_name: self
                    .custom_verification_email_template_name,
                message: self.message,
            }
        }
    }
}
impl CustomVerificationEmailTemplateDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`CustomVerificationEmailTemplateDoesNotExistException`](crate::error::CustomVerificationEmailTemplateDoesNotExistException)
    pub fn builder(
    ) -> crate::error::custom_verification_email_template_does_not_exist_exception::Builder {
        crate::error::custom_verification_email_template_does_not_exist_exception::Builder::default(
        )
    }
}

/// <p>Indicates that custom verification email template provided content is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomVerificationEmailInvalidContentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomVerificationEmailInvalidContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomVerificationEmailInvalidContentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomVerificationEmailInvalidContentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomVerificationEmailInvalidContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomVerificationEmailInvalidContentException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomVerificationEmailInvalidContentException {}
/// See [`CustomVerificationEmailInvalidContentException`](crate::error::CustomVerificationEmailInvalidContentException)
pub mod custom_verification_email_invalid_content_exception {
    /// A builder for [`CustomVerificationEmailInvalidContentException`](crate::error::CustomVerificationEmailInvalidContentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomVerificationEmailInvalidContentException`](crate::error::CustomVerificationEmailInvalidContentException)
        pub fn build(self) -> crate::error::CustomVerificationEmailInvalidContentException {
            crate::error::CustomVerificationEmailInvalidContentException {
                message: self.message,
            }
        }
    }
}
impl CustomVerificationEmailInvalidContentException {
    /// Creates a new builder-style object to manufacture [`CustomVerificationEmailInvalidContentException`](crate::error::CustomVerificationEmailInvalidContentException)
    pub fn builder() -> crate::error::custom_verification_email_invalid_content_exception::Builder {
        crate::error::custom_verification_email_invalid_content_exception::Builder::default()
    }
}

/// <p>Indicates that the TrackingOptions object you specified does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackingOptionsDoesNotExistException {
    /// <p>Indicates that a TrackingOptions object does not exist in the specified configuration
    /// set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrackingOptionsDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackingOptionsDoesNotExistException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrackingOptionsDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrackingOptionsDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrackingOptionsDoesNotExistException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrackingOptionsDoesNotExistException {}
/// See [`TrackingOptionsDoesNotExistException`](crate::error::TrackingOptionsDoesNotExistException)
pub mod tracking_options_does_not_exist_exception {
    /// A builder for [`TrackingOptionsDoesNotExistException`](crate::error::TrackingOptionsDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that a TrackingOptions object does not exist in the specified configuration
        /// set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that a TrackingOptions object does not exist in the specified configuration
        /// set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackingOptionsDoesNotExistException`](crate::error::TrackingOptionsDoesNotExistException)
        pub fn build(self) -> crate::error::TrackingOptionsDoesNotExistException {
            crate::error::TrackingOptionsDoesNotExistException {
                configuration_set_name: self.configuration_set_name,
                message: self.message,
            }
        }
    }
}
impl TrackingOptionsDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`TrackingOptionsDoesNotExistException`](crate::error::TrackingOptionsDoesNotExistException)
    pub fn builder() -> crate::error::tracking_options_does_not_exist_exception::Builder {
        crate::error::tracking_options_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that the custom domain to be used for open and click tracking redirects is
/// invalid. This error appears most often in the following situations:</p>
/// <ul>
/// <li>
/// <p>When the tracking domain you specified is not verified in Amazon SES.</p>
/// </li>
/// <li>
/// <p>When the tracking domain you specified is not a valid domain or
/// subdomain.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTrackingOptionsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTrackingOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTrackingOptionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTrackingOptionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTrackingOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTrackingOptionsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTrackingOptionsException {}
/// See [`InvalidTrackingOptionsException`](crate::error::InvalidTrackingOptionsException)
pub mod invalid_tracking_options_exception {
    /// A builder for [`InvalidTrackingOptionsException`](crate::error::InvalidTrackingOptionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTrackingOptionsException`](crate::error::InvalidTrackingOptionsException)
        pub fn build(self) -> crate::error::InvalidTrackingOptionsException {
            crate::error::InvalidTrackingOptionsException {
                message: self.message,
            }
        }
    }
}
impl InvalidTrackingOptionsException {
    /// Creates a new builder-style object to manufacture [`InvalidTrackingOptionsException`](crate::error::InvalidTrackingOptionsException)
    pub fn builder() -> crate::error::invalid_tracking_options_exception::Builder {
        crate::error::invalid_tracking_options_exception::Builder::default()
    }
}

/// <p>Indicates that the configuration set does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSetDoesNotExistException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfigurationSetDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSetDoesNotExistException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConfigurationSetDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConfigurationSetDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConfigurationSetDoesNotExistException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConfigurationSetDoesNotExistException {}
/// See [`ConfigurationSetDoesNotExistException`](crate::error::ConfigurationSetDoesNotExistException)
pub mod configuration_set_does_not_exist_exception {
    /// A builder for [`ConfigurationSetDoesNotExistException`](crate::error::ConfigurationSetDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSetDoesNotExistException`](crate::error::ConfigurationSetDoesNotExistException)
        pub fn build(self) -> crate::error::ConfigurationSetDoesNotExistException {
            crate::error::ConfigurationSetDoesNotExistException {
                configuration_set_name: self.configuration_set_name,
                message: self.message,
            }
        }
    }
}
impl ConfigurationSetDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`ConfigurationSetDoesNotExistException`](crate::error::ConfigurationSetDoesNotExistException)
    pub fn builder() -> crate::error::configuration_set_does_not_exist_exception::Builder {
        crate::error::configuration_set_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that the Amazon Simple Notification Service (Amazon SNS) destination is
/// invalid. See the error message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnsDestinationException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Indicates that the event destination does not exist.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnsDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnsDestinationException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnsDestinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnsDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidSnsDestinationException [InvalidSNSDestinationException]"
        )?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnsDestinationException {}
/// See [`InvalidSnsDestinationException`](crate::error::InvalidSnsDestinationException)
pub mod invalid_sns_destination_exception {
    /// A builder for [`InvalidSnsDestinationException`](crate::error::InvalidSnsDestinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnsDestinationException`](crate::error::InvalidSnsDestinationException)
        pub fn build(self) -> crate::error::InvalidSnsDestinationException {
            crate::error::InvalidSnsDestinationException {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                message: self.message,
            }
        }
    }
}
impl InvalidSnsDestinationException {
    /// Creates a new builder-style object to manufacture [`InvalidSnsDestinationException`](crate::error::InvalidSnsDestinationException)
    pub fn builder() -> crate::error::invalid_sns_destination_exception::Builder {
        crate::error::invalid_sns_destination_exception::Builder::default()
    }
}

/// <p>Indicates that the Amazon Kinesis Firehose destination is invalid. See the error
/// message for details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFirehoseDestinationException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Indicates that the event destination does not exist.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFirehoseDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFirehoseDestinationException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFirehoseDestinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFirehoseDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFirehoseDestinationException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFirehoseDestinationException {}
/// See [`InvalidFirehoseDestinationException`](crate::error::InvalidFirehoseDestinationException)
pub mod invalid_firehose_destination_exception {
    /// A builder for [`InvalidFirehoseDestinationException`](crate::error::InvalidFirehoseDestinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFirehoseDestinationException`](crate::error::InvalidFirehoseDestinationException)
        pub fn build(self) -> crate::error::InvalidFirehoseDestinationException {
            crate::error::InvalidFirehoseDestinationException {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                message: self.message,
            }
        }
    }
}
impl InvalidFirehoseDestinationException {
    /// Creates a new builder-style object to manufacture [`InvalidFirehoseDestinationException`](crate::error::InvalidFirehoseDestinationException)
    pub fn builder() -> crate::error::invalid_firehose_destination_exception::Builder {
        crate::error::invalid_firehose_destination_exception::Builder::default()
    }
}

/// <p>Indicates that the Amazon CloudWatch destination is invalid. See the error message for
/// details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCloudWatchDestinationException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Indicates that the event destination does not exist.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCloudWatchDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCloudWatchDestinationException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCloudWatchDestinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCloudWatchDestinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCloudWatchDestinationException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCloudWatchDestinationException {}
/// See [`InvalidCloudWatchDestinationException`](crate::error::InvalidCloudWatchDestinationException)
pub mod invalid_cloud_watch_destination_exception {
    /// A builder for [`InvalidCloudWatchDestinationException`](crate::error::InvalidCloudWatchDestinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCloudWatchDestinationException`](crate::error::InvalidCloudWatchDestinationException)
        pub fn build(self) -> crate::error::InvalidCloudWatchDestinationException {
            crate::error::InvalidCloudWatchDestinationException {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                message: self.message,
            }
        }
    }
}
impl InvalidCloudWatchDestinationException {
    /// Creates a new builder-style object to manufacture [`InvalidCloudWatchDestinationException`](crate::error::InvalidCloudWatchDestinationException)
    pub fn builder() -> crate::error::invalid_cloud_watch_destination_exception::Builder {
        crate::error::invalid_cloud_watch_destination_exception::Builder::default()
    }
}

/// <p>Indicates that the event destination does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestinationDoesNotExistException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Indicates that the event destination does not exist.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDestinationDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestinationDoesNotExistException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDestinationDoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDestinationDoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDestinationDoesNotExistException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDestinationDoesNotExistException {}
/// See [`EventDestinationDoesNotExistException`](crate::error::EventDestinationDoesNotExistException)
pub mod event_destination_does_not_exist_exception {
    /// A builder for [`EventDestinationDoesNotExistException`](crate::error::EventDestinationDoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestinationDoesNotExistException`](crate::error::EventDestinationDoesNotExistException)
        pub fn build(self) -> crate::error::EventDestinationDoesNotExistException {
            crate::error::EventDestinationDoesNotExistException {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                message: self.message,
            }
        }
    }
}
impl EventDestinationDoesNotExistException {
    /// Creates a new builder-style object to manufacture [`EventDestinationDoesNotExistException`](crate::error::EventDestinationDoesNotExistException)
    pub fn builder() -> crate::error::event_destination_does_not_exist_exception::Builder {
        crate::error::event_destination_does_not_exist_exception::Builder::default()
    }
}

/// <p>Indicates that one or more of the replacement values for the specified template was
/// not specified. Ensure that the TemplateData object contains references to all of the
/// replacement tags in the specified template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingRenderingAttributeException {
    #[allow(missing_docs)] // documentation missing in model
    pub template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingRenderingAttributeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingRenderingAttributeException");
        formatter.field("template_name", &self.template_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingRenderingAttributeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingRenderingAttributeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingRenderingAttributeException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingRenderingAttributeException {}
/// See [`MissingRenderingAttributeException`](crate::error::MissingRenderingAttributeException)
pub mod missing_rendering_attribute_exception {
    /// A builder for [`MissingRenderingAttributeException`](crate::error::MissingRenderingAttributeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingRenderingAttributeException`](crate::error::MissingRenderingAttributeException)
        pub fn build(self) -> crate::error::MissingRenderingAttributeException {
            crate::error::MissingRenderingAttributeException {
                template_name: self.template_name,
                message: self.message,
            }
        }
    }
}
impl MissingRenderingAttributeException {
    /// Creates a new builder-style object to manufacture [`MissingRenderingAttributeException`](crate::error::MissingRenderingAttributeException)
    pub fn builder() -> crate::error::missing_rendering_attribute_exception::Builder {
        crate::error::missing_rendering_attribute_exception::Builder::default()
    }
}

/// <p>Indicates that one or more of the replacement values you provided is invalid. This
/// error may occur when the TemplateData object contains invalid JSON.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRenderingParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRenderingParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRenderingParameterException");
        formatter.field("template_name", &self.template_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRenderingParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRenderingParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRenderingParameterException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRenderingParameterException {}
/// See [`InvalidRenderingParameterException`](crate::error::InvalidRenderingParameterException)
pub mod invalid_rendering_parameter_exception {
    /// A builder for [`InvalidRenderingParameterException`](crate::error::InvalidRenderingParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRenderingParameterException`](crate::error::InvalidRenderingParameterException)
        pub fn build(self) -> crate::error::InvalidRenderingParameterException {
            crate::error::InvalidRenderingParameterException {
                template_name: self.template_name,
                message: self.message,
            }
        }
    }
}
impl InvalidRenderingParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidRenderingParameterException`](crate::error::InvalidRenderingParameterException)
    pub fn builder() -> crate::error::invalid_rendering_parameter_exception::Builder {
        crate::error::invalid_rendering_parameter_exception::Builder::default()
    }
}

/// <p>Indicates that the action failed, and the message could not be sent. Check the error
/// stack for more information about what caused the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageRejected {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MessageRejected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageRejected");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MessageRejected {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MessageRejected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MessageRejected")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for MessageRejected {}
/// See [`MessageRejected`](crate::error::MessageRejected)
pub mod message_rejected {
    /// A builder for [`MessageRejected`](crate::error::MessageRejected)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageRejected`](crate::error::MessageRejected)
        pub fn build(self) -> crate::error::MessageRejected {
            crate::error::MessageRejected {
                message: self.message,
            }
        }
    }
}
impl MessageRejected {
    /// Creates a new builder-style object to manufacture [`MessageRejected`](crate::error::MessageRejected)
    pub fn builder() -> crate::error::message_rejected::Builder {
        crate::error::message_rejected::Builder::default()
    }
}

/// <p> Indicates that the message could not be sent because Amazon SES could not read the MX
/// record required to use the specified MAIL FROM domain. For information about editing the
/// custom MAIL FROM domain settings for an identity, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html">Amazon SES Developer
/// Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MailFromDomainNotVerifiedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MailFromDomainNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MailFromDomainNotVerifiedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MailFromDomainNotVerifiedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MailFromDomainNotVerifiedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MailFromDomainNotVerifiedException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for MailFromDomainNotVerifiedException {}
/// See [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
pub mod mail_from_domain_not_verified_exception {
    /// A builder for [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
        pub fn build(self) -> crate::error::MailFromDomainNotVerifiedException {
            crate::error::MailFromDomainNotVerifiedException {
                message: self.message,
            }
        }
    }
}
impl MailFromDomainNotVerifiedException {
    /// Creates a new builder-style object to manufacture [`MailFromDomainNotVerifiedException`](crate::error::MailFromDomainNotVerifiedException)
    pub fn builder() -> crate::error::mail_from_domain_not_verified_exception::Builder {
        crate::error::mail_from_domain_not_verified_exception::Builder::default()
    }
}

/// <p>Indicates that email sending is disabled for the configuration set.</p>
/// <p>You can enable or disable email sending for a configuration set using <a>UpdateConfigurationSetSendingEnabled</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSetSendingPausedException {
    /// <p>The name of the configuration set for which email sending is disabled.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfigurationSetSendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSetSendingPausedException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConfigurationSetSendingPausedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConfigurationSetSendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConfigurationSetSendingPausedException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConfigurationSetSendingPausedException {}
/// See [`ConfigurationSetSendingPausedException`](crate::error::ConfigurationSetSendingPausedException)
pub mod configuration_set_sending_paused_exception {
    /// A builder for [`ConfigurationSetSendingPausedException`](crate::error::ConfigurationSetSendingPausedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration set for which email sending is disabled.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration set for which email sending is disabled.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSetSendingPausedException`](crate::error::ConfigurationSetSendingPausedException)
        pub fn build(self) -> crate::error::ConfigurationSetSendingPausedException {
            crate::error::ConfigurationSetSendingPausedException {
                configuration_set_name: self.configuration_set_name,
                message: self.message,
            }
        }
    }
}
impl ConfigurationSetSendingPausedException {
    /// Creates a new builder-style object to manufacture [`ConfigurationSetSendingPausedException`](crate::error::ConfigurationSetSendingPausedException)
    pub fn builder() -> crate::error::configuration_set_sending_paused_exception::Builder {
        crate::error::configuration_set_sending_paused_exception::Builder::default()
    }
}

/// <p>Indicates that email sending is disabled for your entire Amazon SES account.</p>
/// <p>You can enable or disable email sending for your Amazon SES account using <a>UpdateAccountSendingEnabled</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountSendingPausedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountSendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountSendingPausedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountSendingPausedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountSendingPausedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountSendingPausedException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountSendingPausedException {}
/// See [`AccountSendingPausedException`](crate::error::AccountSendingPausedException)
pub mod account_sending_paused_exception {
    /// A builder for [`AccountSendingPausedException`](crate::error::AccountSendingPausedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountSendingPausedException`](crate::error::AccountSendingPausedException)
        pub fn build(self) -> crate::error::AccountSendingPausedException {
            crate::error::AccountSendingPausedException {
                message: self.message,
            }
        }
    }
}
impl AccountSendingPausedException {
    /// Creates a new builder-style object to manufacture [`AccountSendingPausedException`](crate::error::AccountSendingPausedException)
    pub fn builder() -> crate::error::account_sending_paused_exception::Builder {
        crate::error::account_sending_paused_exception::Builder::default()
    }
}

/// <p>Indicates that the account has not been granted production access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductionAccessNotGrantedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProductionAccessNotGrantedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductionAccessNotGrantedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProductionAccessNotGrantedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProductionAccessNotGrantedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProductionAccessNotGrantedException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProductionAccessNotGrantedException {}
/// See [`ProductionAccessNotGrantedException`](crate::error::ProductionAccessNotGrantedException)
pub mod production_access_not_granted_exception {
    /// A builder for [`ProductionAccessNotGrantedException`](crate::error::ProductionAccessNotGrantedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductionAccessNotGrantedException`](crate::error::ProductionAccessNotGrantedException)
        pub fn build(self) -> crate::error::ProductionAccessNotGrantedException {
            crate::error::ProductionAccessNotGrantedException {
                message: self.message,
            }
        }
    }
}
impl ProductionAccessNotGrantedException {
    /// Creates a new builder-style object to manufacture [`ProductionAccessNotGrantedException`](crate::error::ProductionAccessNotGrantedException)
    pub fn builder() -> crate::error::production_access_not_granted_exception::Builder {
        crate::error::production_access_not_granted_exception::Builder::default()
    }
}

/// <p>Indicates that the provided policy is invalid. Check the error stack for more
/// information about what caused the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPolicyException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPolicyException {}
/// See [`InvalidPolicyException`](crate::error::InvalidPolicyException)
pub mod invalid_policy_exception {
    /// A builder for [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPolicyException`](crate::error::InvalidPolicyException)
        pub fn build(self) -> crate::error::InvalidPolicyException {
            crate::error::InvalidPolicyException {
                message: self.message,
            }
        }
    }
}
impl InvalidPolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    pub fn builder() -> crate::error::invalid_policy_exception::Builder {
        crate::error::invalid_policy_exception::Builder::default()
    }
}

/// <p>Indicates that provided delivery option is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDeliveryOptionsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDeliveryOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDeliveryOptionsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDeliveryOptionsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDeliveryOptionsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDeliveryOptionsException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDeliveryOptionsException {}
/// See [`InvalidDeliveryOptionsException`](crate::error::InvalidDeliveryOptionsException)
pub mod invalid_delivery_options_exception {
    /// A builder for [`InvalidDeliveryOptionsException`](crate::error::InvalidDeliveryOptionsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDeliveryOptionsException`](crate::error::InvalidDeliveryOptionsException)
        pub fn build(self) -> crate::error::InvalidDeliveryOptionsException {
            crate::error::InvalidDeliveryOptionsException {
                message: self.message,
            }
        }
    }
}
impl InvalidDeliveryOptionsException {
    /// Creates a new builder-style object to manufacture [`InvalidDeliveryOptionsException`](crate::error::InvalidDeliveryOptionsException)
    pub fn builder() -> crate::error::invalid_delivery_options_exception::Builder {
        crate::error::invalid_delivery_options_exception::Builder::default()
    }
}

/// <p>Indicates that the delete operation could not be completed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CannotDeleteException {
    /// <p>Indicates that a resource could not be deleted because no resource with the specified
    /// name exists.</p>
    pub name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CannotDeleteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CannotDeleteException");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CannotDeleteException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CannotDeleteException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CannotDeleteException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for CannotDeleteException {}
/// See [`CannotDeleteException`](crate::error::CannotDeleteException)
pub mod cannot_delete_exception {
    /// A builder for [`CannotDeleteException`](crate::error::CannotDeleteException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that a resource could not be deleted because no resource with the specified
        /// name exists.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Indicates that a resource could not be deleted because no resource with the specified
        /// name exists.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CannotDeleteException`](crate::error::CannotDeleteException)
        pub fn build(self) -> crate::error::CannotDeleteException {
            crate::error::CannotDeleteException {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl CannotDeleteException {
    /// Creates a new builder-style object to manufacture [`CannotDeleteException`](crate::error::CannotDeleteException)
    pub fn builder() -> crate::error::cannot_delete_exception::Builder {
        crate::error::cannot_delete_exception::Builder::default()
    }
}

/// <p>Indicates that a resource could not be created because of a naming conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    /// <p>Indicates that a resource could not be created because the resource name already
    /// exists.</p>
    pub name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that a resource could not be created because the resource name already
        /// exists.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Indicates that a resource could not be created because the resource name already
        /// exists.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>Indicates that a custom verification email template with the name you specified
/// already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomVerificationEmailTemplateAlreadyExistsException {
    /// <p>Indicates that the provided custom verification email template with the specified
    /// template name already exists.</p>
    pub custom_verification_email_template_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomVerificationEmailTemplateAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomVerificationEmailTemplateAlreadyExistsException");
        formatter.field(
            "custom_verification_email_template_name",
            &self.custom_verification_email_template_name,
        );
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomVerificationEmailTemplateAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomVerificationEmailTemplateAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomVerificationEmailTemplateAlreadyExistsException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomVerificationEmailTemplateAlreadyExistsException {}
/// See [`CustomVerificationEmailTemplateAlreadyExistsException`](crate::error::CustomVerificationEmailTemplateAlreadyExistsException)
pub mod custom_verification_email_template_already_exists_exception {
    /// A builder for [`CustomVerificationEmailTemplateAlreadyExistsException`](crate::error::CustomVerificationEmailTemplateAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_verification_email_template_name:
            std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the provided custom verification email template with the specified
        /// template name already exists.</p>
        pub fn custom_verification_email_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_verification_email_template_name = Some(input.into());
            self
        }
        /// <p>Indicates that the provided custom verification email template with the specified
        /// template name already exists.</p>
        pub fn set_custom_verification_email_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_verification_email_template_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomVerificationEmailTemplateAlreadyExistsException`](crate::error::CustomVerificationEmailTemplateAlreadyExistsException)
        pub fn build(self) -> crate::error::CustomVerificationEmailTemplateAlreadyExistsException {
            crate::error::CustomVerificationEmailTemplateAlreadyExistsException {
                custom_verification_email_template_name: self
                    .custom_verification_email_template_name,
                message: self.message,
            }
        }
    }
}
impl CustomVerificationEmailTemplateAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`CustomVerificationEmailTemplateAlreadyExistsException`](crate::error::CustomVerificationEmailTemplateAlreadyExistsException)
    pub fn builder(
    ) -> crate::error::custom_verification_email_template_already_exists_exception::Builder {
        crate::error::custom_verification_email_template_already_exists_exception::Builder::default(
        )
    }
}

/// <p>Indicates that the configuration set you specified already contains a TrackingOptions
/// object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackingOptionsAlreadyExistsException {
    /// <p>Indicates that a TrackingOptions object already exists in the specified configuration
    /// set.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrackingOptionsAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackingOptionsAlreadyExistsException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrackingOptionsAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrackingOptionsAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrackingOptionsAlreadyExistsException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrackingOptionsAlreadyExistsException {}
/// See [`TrackingOptionsAlreadyExistsException`](crate::error::TrackingOptionsAlreadyExistsException)
pub mod tracking_options_already_exists_exception {
    /// A builder for [`TrackingOptionsAlreadyExistsException`](crate::error::TrackingOptionsAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that a TrackingOptions object already exists in the specified configuration
        /// set.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that a TrackingOptions object already exists in the specified configuration
        /// set.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackingOptionsAlreadyExistsException`](crate::error::TrackingOptionsAlreadyExistsException)
        pub fn build(self) -> crate::error::TrackingOptionsAlreadyExistsException {
            crate::error::TrackingOptionsAlreadyExistsException {
                configuration_set_name: self.configuration_set_name,
                message: self.message,
            }
        }
    }
}
impl TrackingOptionsAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`TrackingOptionsAlreadyExistsException`](crate::error::TrackingOptionsAlreadyExistsException)
    pub fn builder() -> crate::error::tracking_options_already_exists_exception::Builder {
        crate::error::tracking_options_already_exists_exception::Builder::default()
    }
}

/// <p>Indicates that the event destination could not be created because of a naming
/// conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDestinationAlreadyExistsException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    /// <p>Indicates that the event destination does not exist.</p>
    pub event_destination_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventDestinationAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDestinationAlreadyExistsException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("event_destination_name", &self.event_destination_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventDestinationAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventDestinationAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventDestinationAlreadyExistsException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventDestinationAlreadyExistsException {}
/// See [`EventDestinationAlreadyExistsException`](crate::error::EventDestinationAlreadyExistsException)
pub mod event_destination_already_exists_exception {
    /// A builder for [`EventDestinationAlreadyExistsException`](crate::error::EventDestinationAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) event_destination_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn event_destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_destination_name = Some(input.into());
            self
        }
        /// <p>Indicates that the event destination does not exist.</p>
        pub fn set_event_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_destination_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDestinationAlreadyExistsException`](crate::error::EventDestinationAlreadyExistsException)
        pub fn build(self) -> crate::error::EventDestinationAlreadyExistsException {
            crate::error::EventDestinationAlreadyExistsException {
                configuration_set_name: self.configuration_set_name,
                event_destination_name: self.event_destination_name,
                message: self.message,
            }
        }
    }
}
impl EventDestinationAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EventDestinationAlreadyExistsException`](crate::error::EventDestinationAlreadyExistsException)
    pub fn builder() -> crate::error::event_destination_already_exists_exception::Builder {
        crate::error::event_destination_already_exists_exception::Builder::default()
    }
}

/// <p>Indicates that the configuration set is invalid. See the error message for
/// details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidConfigurationSetException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidConfigurationSetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidConfigurationSetException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidConfigurationSetException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidConfigurationSetException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidConfigurationSetException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidConfigurationSetException {}
/// See [`InvalidConfigurationSetException`](crate::error::InvalidConfigurationSetException)
pub mod invalid_configuration_set_exception {
    /// A builder for [`InvalidConfigurationSetException`](crate::error::InvalidConfigurationSetException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidConfigurationSetException`](crate::error::InvalidConfigurationSetException)
        pub fn build(self) -> crate::error::InvalidConfigurationSetException {
            crate::error::InvalidConfigurationSetException {
                message: self.message,
            }
        }
    }
}
impl InvalidConfigurationSetException {
    /// Creates a new builder-style object to manufacture [`InvalidConfigurationSetException`](crate::error::InvalidConfigurationSetException)
    pub fn builder() -> crate::error::invalid_configuration_set_exception::Builder {
        crate::error::invalid_configuration_set_exception::Builder::default()
    }
}

/// <p>Indicates that the configuration set could not be created because of a naming
/// conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigurationSetAlreadyExistsException {
    /// <p>Indicates that the configuration set does not exist.</p>
    pub configuration_set_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfigurationSetAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigurationSetAlreadyExistsException");
        formatter.field("configuration_set_name", &self.configuration_set_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConfigurationSetAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConfigurationSetAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConfigurationSetAlreadyExistsException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConfigurationSetAlreadyExistsException {}
/// See [`ConfigurationSetAlreadyExistsException`](crate::error::ConfigurationSetAlreadyExistsException)
pub mod configuration_set_already_exists_exception {
    /// A builder for [`ConfigurationSetAlreadyExistsException`](crate::error::ConfigurationSetAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_set_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn configuration_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_set_name = Some(input.into());
            self
        }
        /// <p>Indicates that the configuration set does not exist.</p>
        pub fn set_configuration_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_set_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigurationSetAlreadyExistsException`](crate::error::ConfigurationSetAlreadyExistsException)
        pub fn build(self) -> crate::error::ConfigurationSetAlreadyExistsException {
            crate::error::ConfigurationSetAlreadyExistsException {
                configuration_set_name: self.configuration_set_name,
                message: self.message,
            }
        }
    }
}
impl ConfigurationSetAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ConfigurationSetAlreadyExistsException`](crate::error::ConfigurationSetAlreadyExistsException)
    pub fn builder() -> crate::error::configuration_set_already_exists_exception::Builder {
        crate::error::configuration_set_already_exists_exception::Builder::default()
    }
}
