// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Service Quotas
///
/// Client for invoking operations on Service Quotas. Each operation on Service Quotas is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_servicequotas::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_servicequotas::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_servicequotas::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateServiceQuotaTemplate`](crate::client::fluent_builders::AssociateServiceQuotaTemplate) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::AssociateServiceQuotaTemplate::send) it.

    /// - On success, responds with [`AssociateServiceQuotaTemplateOutput`](crate::output::AssociateServiceQuotaTemplateOutput)

    /// - On failure, responds with [`SdkError<AssociateServiceQuotaTemplateError>`](crate::error::AssociateServiceQuotaTemplateError)
    pub fn associate_service_quota_template(
        &self,
    ) -> fluent_builders::AssociateServiceQuotaTemplate {
        fluent_builders::AssociateServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteServiceQuotaIncreaseRequestFromTemplate`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::set_quota_code): <p>The quota identifier.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::set_aws_region): <p>The AWS Region.</p>
    /// - On success, responds with [`DeleteServiceQuotaIncreaseRequestFromTemplateOutput`](crate::output::DeleteServiceQuotaIncreaseRequestFromTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteServiceQuotaIncreaseRequestFromTemplateError>`](crate::error::DeleteServiceQuotaIncreaseRequestFromTemplateError)
    pub fn delete_service_quota_increase_request_from_template(
        &self,
    ) -> fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate {
        fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateServiceQuotaTemplate`](crate::client::fluent_builders::DisassociateServiceQuotaTemplate) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateServiceQuotaTemplate::send) it.

    /// - On success, responds with [`DisassociateServiceQuotaTemplateOutput`](crate::output::DisassociateServiceQuotaTemplateOutput)

    /// - On failure, responds with [`SdkError<DisassociateServiceQuotaTemplateError>`](crate::error::DisassociateServiceQuotaTemplateError)
    pub fn disassociate_service_quota_template(
        &self,
    ) -> fluent_builders::DisassociateServiceQuotaTemplate {
        fluent_builders::DisassociateServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssociationForServiceQuotaTemplate`](crate::client::fluent_builders::GetAssociationForServiceQuotaTemplate) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAssociationForServiceQuotaTemplate::send) it.

    /// - On success, responds with [`GetAssociationForServiceQuotaTemplateOutput`](crate::output::GetAssociationForServiceQuotaTemplateOutput) with field(s):
    ///   - [`service_quota_template_association_status(Option<ServiceQuotaTemplateAssociationStatus>)`](crate::output::GetAssociationForServiceQuotaTemplateOutput::service_quota_template_association_status): <p>The association status. If the status is <code>ASSOCIATED</code>, the quota increase requests in the template are automatically applied to new accounts in your organization.</p>
    /// - On failure, responds with [`SdkError<GetAssociationForServiceQuotaTemplateError>`](crate::error::GetAssociationForServiceQuotaTemplateError)
    pub fn get_association_for_service_quota_template(
        &self,
    ) -> fluent_builders::GetAssociationForServiceQuotaTemplate {
        fluent_builders::GetAssociationForServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAWSDefaultServiceQuota`](crate::client::fluent_builders::GetAWSDefaultServiceQuota) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::GetAWSDefaultServiceQuota::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::GetAWSDefaultServiceQuota::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::GetAWSDefaultServiceQuota::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::GetAWSDefaultServiceQuota::set_quota_code): <p>The quota identifier.</p>
    /// - On success, responds with [`GetAwsDefaultServiceQuotaOutput`](crate::output::GetAwsDefaultServiceQuotaOutput) with field(s):
    ///   - [`quota(Option<ServiceQuota>)`](crate::output::GetAwsDefaultServiceQuotaOutput::quota): <p>Information about the quota.</p>
    /// - On failure, responds with [`SdkError<GetAWSDefaultServiceQuotaError>`](crate::error::GetAWSDefaultServiceQuotaError)
    pub fn get_aws_default_service_quota(&self) -> fluent_builders::GetAWSDefaultServiceQuota {
        fluent_builders::GetAWSDefaultServiceQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRequestedServiceQuotaChange`](crate::client::fluent_builders::GetRequestedServiceQuotaChange) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_id(impl Into<String>)`](crate::client::fluent_builders::GetRequestedServiceQuotaChange::request_id) / [`set_request_id(Option<String>)`](crate::client::fluent_builders::GetRequestedServiceQuotaChange::set_request_id): <p>The ID of the quota increase request.</p>
    /// - On success, responds with [`GetRequestedServiceQuotaChangeOutput`](crate::output::GetRequestedServiceQuotaChangeOutput) with field(s):
    ///   - [`requested_quota(Option<RequestedServiceQuotaChange>)`](crate::output::GetRequestedServiceQuotaChangeOutput::requested_quota): <p>Information about the quota increase request.</p>
    /// - On failure, responds with [`SdkError<GetRequestedServiceQuotaChangeError>`](crate::error::GetRequestedServiceQuotaChangeError)
    pub fn get_requested_service_quota_change(
        &self,
    ) -> fluent_builders::GetRequestedServiceQuotaChange {
        fluent_builders::GetRequestedServiceQuotaChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceQuota`](crate::client::fluent_builders::GetServiceQuota) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::GetServiceQuota::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::GetServiceQuota::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::GetServiceQuota::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::GetServiceQuota::set_quota_code): <p>The quota identifier.</p>
    /// - On success, responds with [`GetServiceQuotaOutput`](crate::output::GetServiceQuotaOutput) with field(s):
    ///   - [`quota(Option<ServiceQuota>)`](crate::output::GetServiceQuotaOutput::quota): <p>Information about the quota.</p>
    /// - On failure, responds with [`SdkError<GetServiceQuotaError>`](crate::error::GetServiceQuotaError)
    pub fn get_service_quota(&self) -> fluent_builders::GetServiceQuota {
        fluent_builders::GetServiceQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceQuotaIncreaseRequestFromTemplate`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::set_quota_code): <p>The quota identifier.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::set_aws_region): <p>The AWS Region.</p>
    /// - On success, responds with [`GetServiceQuotaIncreaseRequestFromTemplateOutput`](crate::output::GetServiceQuotaIncreaseRequestFromTemplateOutput) with field(s):
    ///   - [`service_quota_increase_request_in_template(Option<ServiceQuotaIncreaseRequestInTemplate>)`](crate::output::GetServiceQuotaIncreaseRequestFromTemplateOutput::service_quota_increase_request_in_template): <p>Information about the quota increase request.</p>
    /// - On failure, responds with [`SdkError<GetServiceQuotaIncreaseRequestFromTemplateError>`](crate::error::GetServiceQuotaIncreaseRequestFromTemplateError)
    pub fn get_service_quota_increase_request_from_template(
        &self,
    ) -> fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate {
        fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAWSDefaultServiceQuotas`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::set_service_code): <p>The service identifier.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListAwsDefaultServiceQuotasOutput`](crate::output::ListAwsDefaultServiceQuotasOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAwsDefaultServiceQuotasOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    ///   - [`quotas(Option<Vec<ServiceQuota>>)`](crate::output::ListAwsDefaultServiceQuotasOutput::quotas): <p>Information about the quotas.</p>
    /// - On failure, responds with [`SdkError<ListAWSDefaultServiceQuotasError>`](crate::error::ListAWSDefaultServiceQuotasError)
    pub fn list_aws_default_service_quotas(&self) -> fluent_builders::ListAWSDefaultServiceQuotas {
        fluent_builders::ListAWSDefaultServiceQuotas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRequestedServiceQuotaChangeHistory`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::set_service_code): <p>The service identifier.</p>
    ///   - [`status(RequestStatus)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::status) / [`set_status(Option<RequestStatus>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::set_status): <p>The status of the quota increase request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListRequestedServiceQuotaChangeHistoryOutput`](crate::output::ListRequestedServiceQuotaChangeHistoryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRequestedServiceQuotaChangeHistoryOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    ///   - [`requested_quotas(Option<Vec<RequestedServiceQuotaChange>>)`](crate::output::ListRequestedServiceQuotaChangeHistoryOutput::requested_quotas): <p>Information about the quota increase requests.</p>
    /// - On failure, responds with [`SdkError<ListRequestedServiceQuotaChangeHistoryError>`](crate::error::ListRequestedServiceQuotaChangeHistoryError)
    pub fn list_requested_service_quota_change_history(
        &self,
    ) -> fluent_builders::ListRequestedServiceQuotaChangeHistory {
        fluent_builders::ListRequestedServiceQuotaChangeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRequestedServiceQuotaChangeHistoryByQuota`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::set_quota_code): <p>The quota identifier.</p>
    ///   - [`status(RequestStatus)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::status) / [`set_status(Option<RequestStatus>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::set_status): <p>The status value of the quota increase request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListRequestedServiceQuotaChangeHistoryByQuotaOutput`](crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    ///   - [`requested_quotas(Option<Vec<RequestedServiceQuotaChange>>)`](crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput::requested_quotas): <p>Information about the quota increase requests.</p>
    /// - On failure, responds with [`SdkError<ListRequestedServiceQuotaChangeHistoryByQuotaError>`](crate::error::ListRequestedServiceQuotaChangeHistoryByQuotaError)
    pub fn list_requested_service_quota_change_history_by_quota(
        &self,
    ) -> fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota {
        fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServiceQuotaIncreaseRequestsInTemplate`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::set_service_code): <p>The service identifier.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::set_aws_region): <p>The AWS Region.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListServiceQuotaIncreaseRequestsInTemplateOutput`](crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput) with field(s):
    ///   - [`service_quota_increase_request_in_template_list(Option<Vec<ServiceQuotaIncreaseRequestInTemplate>>)`](crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput::service_quota_increase_request_in_template_list): <p>Information about the quota increase requests.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListServiceQuotaIncreaseRequestsInTemplateError>`](crate::error::ListServiceQuotaIncreaseRequestsInTemplateError)
    pub fn list_service_quota_increase_requests_in_template(
        &self,
    ) -> fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate {
        fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServiceQuotas`](crate::client::fluent_builders::ListServiceQuotas) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServiceQuotas::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::ListServiceQuotas::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::ListServiceQuotas::set_service_code): <p>The service identifier.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServiceQuotas::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServiceQuotas::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServiceQuotas::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServiceQuotas::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListServiceQuotasOutput`](crate::output::ListServiceQuotasOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListServiceQuotasOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    ///   - [`quotas(Option<Vec<ServiceQuota>>)`](crate::output::ListServiceQuotasOutput::quotas): <p>Information about the quotas.</p>
    /// - On failure, responds with [`SdkError<ListServiceQuotasError>`](crate::error::ListServiceQuotasError)
    pub fn list_service_quotas(&self) -> fluent_builders::ListServiceQuotas {
        fluent_builders::ListServiceQuotas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServices`](crate::client::fluent_builders::ListServices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServices::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServices::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
    /// - On success, responds with [`ListServicesOutput`](crate::output::ListServicesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListServicesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    ///   - [`services(Option<Vec<ServiceInfo>>)`](crate::output::ListServicesOutput::services): <p>Information about the services.</p>
    /// - On failure, responds with [`SdkError<ListServicesError>`](crate::error::ListServicesError)
    pub fn list_services(&self) -> fluent_builders::ListServices {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A complex data type that contains zero or more tag elements.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutServiceQuotaIncreaseRequestIntoTemplate`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::set_quota_code): <p>The quota identifier.</p>
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::set_service_code): <p>The service identifier.</p>
    ///   - [`aws_region(impl Into<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::aws_region) / [`set_aws_region(Option<String>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::set_aws_region): <p>The AWS Region.</p>
    ///   - [`desired_value(f64)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::desired_value) / [`set_desired_value(Option<f64>)`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::set_desired_value): <p>The new, increased value for the quota.</p>
    /// - On success, responds with [`PutServiceQuotaIncreaseRequestIntoTemplateOutput`](crate::output::PutServiceQuotaIncreaseRequestIntoTemplateOutput) with field(s):
    ///   - [`service_quota_increase_request_in_template(Option<ServiceQuotaIncreaseRequestInTemplate>)`](crate::output::PutServiceQuotaIncreaseRequestIntoTemplateOutput::service_quota_increase_request_in_template): <p>Information about the quota increase request.</p>
    /// - On failure, responds with [`SdkError<PutServiceQuotaIncreaseRequestIntoTemplateError>`](crate::error::PutServiceQuotaIncreaseRequestIntoTemplateError)
    pub fn put_service_quota_increase_request_into_template(
        &self,
    ) -> fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate {
        fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RequestServiceQuotaIncrease`](crate::client::fluent_builders::RequestServiceQuotaIncrease) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_code(impl Into<String>)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::service_code) / [`set_service_code(Option<String>)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::set_service_code): <p>The service identifier.</p>
    ///   - [`quota_code(impl Into<String>)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::quota_code) / [`set_quota_code(Option<String>)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::set_quota_code): <p>The quota identifier.</p>
    ///   - [`desired_value(f64)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::desired_value) / [`set_desired_value(Option<f64>)`](crate::client::fluent_builders::RequestServiceQuotaIncrease::set_desired_value): <p>The new, increased value for the quota.</p>
    /// - On success, responds with [`RequestServiceQuotaIncreaseOutput`](crate::output::RequestServiceQuotaIncreaseOutput) with field(s):
    ///   - [`requested_quota(Option<RequestedServiceQuotaChange>)`](crate::output::RequestServiceQuotaIncreaseOutput::requested_quota): <p>Information about the quota increase request.</p>
    /// - On failure, responds with [`SdkError<RequestServiceQuotaIncreaseError>`](crate::error::RequestServiceQuotaIncreaseError)
    pub fn request_service_quota_increase(&self) -> fluent_builders::RequestServiceQuotaIncrease {
        fluent_builders::RequestServiceQuotaIncrease::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags that you want to add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags that you want to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateServiceQuotaTemplate`.
    ///
    /// <p>Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateServiceQuotaTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_service_quota_template_input::Builder,
    }
    impl AssociateServiceQuotaTemplate {
        /// Creates a new `AssociateServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateServiceQuotaTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceQuotaIncreaseRequestFromTemplate`.
    ///
    /// <p>Deletes the quota increase request for the specified quota from your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteServiceQuotaIncreaseRequestFromTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_service_quota_increase_request_from_template_input::Builder,
    }
    impl DeleteServiceQuotaIncreaseRequestFromTemplate {
        /// Creates a new `DeleteServiceQuotaIncreaseRequestFromTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceQuotaIncreaseRequestFromTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteServiceQuotaIncreaseRequestFromTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceQuotaTemplate`.
    ///
    /// <p>Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateServiceQuotaTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_service_quota_template_input::Builder,
    }
    impl DisassociateServiceQuotaTemplate {
        /// Creates a new `DisassociateServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateServiceQuotaTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssociationForServiceQuotaTemplate`.
    ///
    /// <p>Retrieves the status of the association for the quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssociationForServiceQuotaTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_association_for_service_quota_template_input::Builder,
    }
    impl GetAssociationForServiceQuotaTemplate {
        /// Creates a new `GetAssociationForServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssociationForServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAssociationForServiceQuotaTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAWSDefaultServiceQuota`.
    ///
    /// <p>Retrieves the default value for the specified quota. The default value does not reflect any quota increases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAWSDefaultServiceQuota {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_aws_default_service_quota_input::Builder,
    }
    impl GetAWSDefaultServiceQuota {
        /// Creates a new `GetAWSDefaultServiceQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAwsDefaultServiceQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAWSDefaultServiceQuotaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestedServiceQuotaChange`.
    ///
    /// <p>Retrieves information about the specified quota increase request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRequestedServiceQuotaChange {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_requested_service_quota_change_input::Builder,
    }
    impl GetRequestedServiceQuotaChange {
        /// Creates a new `GetRequestedServiceQuotaChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestedServiceQuotaChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestedServiceQuotaChangeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the quota increase request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(input.into());
            self
        }
        /// <p>The ID of the quota increase request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceQuota`.
    ///
    /// <p>Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceQuota {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_quota_input::Builder,
    }
    impl GetServiceQuota {
        /// Creates a new `GetServiceQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceQuotaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceQuotaIncreaseRequestFromTemplate`.
    ///
    /// <p>Retrieves information about the specified quota increase request in your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceQuotaIncreaseRequestFromTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_quota_increase_request_from_template_input::Builder,
    }
    impl GetServiceQuotaIncreaseRequestFromTemplate {
        /// Creates a new `GetServiceQuotaIncreaseRequestFromTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceQuotaIncreaseRequestFromTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetServiceQuotaIncreaseRequestFromTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAWSDefaultServiceQuotas`.
    ///
    /// <p>Lists the default values for the quotas for the specified AWS service. A default value does not reflect any quota increases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAWSDefaultServiceQuotas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aws_default_service_quotas_input::Builder,
    }
    impl ListAWSDefaultServiceQuotas {
        /// Creates a new `ListAWSDefaultServiceQuotas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAwsDefaultServiceQuotasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAWSDefaultServiceQuotasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAwsDefaultServiceQuotasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAwsDefaultServiceQuotasPaginator {
            crate::paginator::ListAwsDefaultServiceQuotasPaginator::new(self.handle, self.inner)
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRequestedServiceQuotaChangeHistory`.
    ///
    /// <p>Retrieves the quota increase requests for the specified service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRequestedServiceQuotaChangeHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_requested_service_quota_change_history_input::Builder,
    }
    impl ListRequestedServiceQuotaChangeHistory {
        /// Creates a new `ListRequestedServiceQuotaChangeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRequestedServiceQuotaChangeHistoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListRequestedServiceQuotaChangeHistoryError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator {
            crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The status of the quota increase request.</p>
        pub fn status(mut self, input: crate::model::RequestStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the quota increase request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RequestStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRequestedServiceQuotaChangeHistoryByQuota`.
    ///
    /// <p>Retrieves the quota increase requests for the specified quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRequestedServiceQuotaChangeHistoryByQuota {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_requested_service_quota_change_history_by_quota_input::Builder,
    }
    impl ListRequestedServiceQuotaChangeHistoryByQuota {
        /// Creates a new `ListRequestedServiceQuotaChangeHistoryByQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListRequestedServiceQuotaChangeHistoryByQuotaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator {
            crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The status value of the quota increase request.</p>
        pub fn status(mut self, input: crate::model::RequestStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status value of the quota increase request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RequestStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceQuotaIncreaseRequestsInTemplate`.
    ///
    /// <p>Lists the quota increase requests in the specified quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceQuotaIncreaseRequestsInTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_service_quota_increase_requests_in_template_input::Builder,
    }
    impl ListServiceQuotaIncreaseRequestsInTemplate {
        /// Creates a new `ListServiceQuotaIncreaseRequestsInTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServiceQuotaIncreaseRequestsInTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator {
            crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceQuotas`.
    ///
    /// <p>Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceQuotas {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_service_quotas_input::Builder,
    }
    impl ListServiceQuotas {
        /// Creates a new `ListServiceQuotas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceQuotasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceQuotasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceQuotasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServiceQuotasPaginator {
            crate::paginator::ListServiceQuotasPaginator::new(self.handle, self.inner)
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Lists the names and codes for the services integrated with Service Quotas.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_services_input::Builder,
    }
    impl ListServices {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServicesPaginator {
            crate::paginator::ListServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags assigned to the specified applied quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutServiceQuotaIncreaseRequestIntoTemplate`.
    ///
    /// <p>Adds a quota increase request to your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutServiceQuotaIncreaseRequestIntoTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_service_quota_increase_request_into_template_input::Builder,
    }
    impl PutServiceQuotaIncreaseRequestIntoTemplate {
        /// Creates a new `PutServiceQuotaIncreaseRequestIntoTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutServiceQuotaIncreaseRequestIntoTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutServiceQuotaIncreaseRequestIntoTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.inner = self.inner.desired_value(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_desired_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestServiceQuotaIncrease`.
    ///
    /// <p>Submits a quota increase request for the specified quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RequestServiceQuotaIncrease {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::request_service_quota_increase_input::Builder,
    }
    impl RequestServiceQuotaIncrease {
        /// Creates a new `RequestServiceQuotaIncrease`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestServiceQuotaIncreaseOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestServiceQuotaIncreaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.inner = self.inner.desired_value(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_desired_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to the specified applied quota. You can include one or more tags to add to the quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified applied quota. You can specify one or more tags to remove.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
