// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Service Quotas
///
/// Client for invoking operations on Service Quotas. Each operation on Service Quotas is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_servicequotas::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_servicequotas::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_servicequotas::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateServiceQuotaTemplate` operation.
    ///
    /// See [`AssociateServiceQuotaTemplate`](crate::client::fluent_builders::AssociateServiceQuotaTemplate) for more information about the
    /// operation and its arguments.
    pub fn associate_service_quota_template(
        &self,
    ) -> fluent_builders::AssociateServiceQuotaTemplate<C, M, R> {
        fluent_builders::AssociateServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceQuotaIncreaseRequestFromTemplate` operation.
    ///
    /// See [`DeleteServiceQuotaIncreaseRequestFromTemplate`](crate::client::fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_service_quota_increase_request_from_template(
        &self,
    ) -> fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate<C, M, R> {
        fluent_builders::DeleteServiceQuotaIncreaseRequestFromTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateServiceQuotaTemplate` operation.
    ///
    /// See [`DisassociateServiceQuotaTemplate`](crate::client::fluent_builders::DisassociateServiceQuotaTemplate) for more information about the
    /// operation and its arguments.
    pub fn disassociate_service_quota_template(
        &self,
    ) -> fluent_builders::DisassociateServiceQuotaTemplate<C, M, R> {
        fluent_builders::DisassociateServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssociationForServiceQuotaTemplate` operation.
    ///
    /// See [`GetAssociationForServiceQuotaTemplate`](crate::client::fluent_builders::GetAssociationForServiceQuotaTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_association_for_service_quota_template(
        &self,
    ) -> fluent_builders::GetAssociationForServiceQuotaTemplate<C, M, R> {
        fluent_builders::GetAssociationForServiceQuotaTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAWSDefaultServiceQuota` operation.
    ///
    /// See [`GetAWSDefaultServiceQuota`](crate::client::fluent_builders::GetAWSDefaultServiceQuota) for more information about the
    /// operation and its arguments.
    pub fn get_aws_default_service_quota(
        &self,
    ) -> fluent_builders::GetAWSDefaultServiceQuota<C, M, R> {
        fluent_builders::GetAWSDefaultServiceQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRequestedServiceQuotaChange` operation.
    ///
    /// See [`GetRequestedServiceQuotaChange`](crate::client::fluent_builders::GetRequestedServiceQuotaChange) for more information about the
    /// operation and its arguments.
    pub fn get_requested_service_quota_change(
        &self,
    ) -> fluent_builders::GetRequestedServiceQuotaChange<C, M, R> {
        fluent_builders::GetRequestedServiceQuotaChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceQuota` operation.
    ///
    /// See [`GetServiceQuota`](crate::client::fluent_builders::GetServiceQuota) for more information about the
    /// operation and its arguments.
    pub fn get_service_quota(&self) -> fluent_builders::GetServiceQuota<C, M, R> {
        fluent_builders::GetServiceQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceQuotaIncreaseRequestFromTemplate` operation.
    ///
    /// See [`GetServiceQuotaIncreaseRequestFromTemplate`](crate::client::fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_service_quota_increase_request_from_template(
        &self,
    ) -> fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate<C, M, R> {
        fluent_builders::GetServiceQuotaIncreaseRequestFromTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAWSDefaultServiceQuotas` operation.
    ///
    /// See [`ListAWSDefaultServiceQuotas`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAWSDefaultServiceQuotas::into_paginator).
    pub fn list_aws_default_service_quotas(
        &self,
    ) -> fluent_builders::ListAWSDefaultServiceQuotas<C, M, R> {
        fluent_builders::ListAWSDefaultServiceQuotas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRequestedServiceQuotaChangeHistory` operation.
    ///
    /// See [`ListRequestedServiceQuotaChangeHistory`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistory::into_paginator).
    pub fn list_requested_service_quota_change_history(
        &self,
    ) -> fluent_builders::ListRequestedServiceQuotaChangeHistory<C, M, R> {
        fluent_builders::ListRequestedServiceQuotaChangeHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRequestedServiceQuotaChangeHistoryByQuota` operation.
    ///
    /// See [`ListRequestedServiceQuotaChangeHistoryByQuota`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::into_paginator).
    pub fn list_requested_service_quota_change_history_by_quota(
        &self,
    ) -> fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota<C, M, R> {
        fluent_builders::ListRequestedServiceQuotaChangeHistoryByQuota::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceQuotaIncreaseRequestsInTemplate` operation.
    ///
    /// See [`ListServiceQuotaIncreaseRequestsInTemplate`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::into_paginator).
    pub fn list_service_quota_increase_requests_in_template(
        &self,
    ) -> fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate<C, M, R> {
        fluent_builders::ListServiceQuotaIncreaseRequestsInTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceQuotas` operation.
    ///
    /// See [`ListServiceQuotas`](crate::client::fluent_builders::ListServiceQuotas) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListServiceQuotas::into_paginator).
    pub fn list_service_quotas(&self) -> fluent_builders::ListServiceQuotas<C, M, R> {
        fluent_builders::ListServiceQuotas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServices` operation.
    ///
    /// See [`ListServices`](crate::client::fluent_builders::ListServices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListServices::into_paginator).
    pub fn list_services(&self) -> fluent_builders::ListServices<C, M, R> {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutServiceQuotaIncreaseRequestIntoTemplate` operation.
    ///
    /// See [`PutServiceQuotaIncreaseRequestIntoTemplate`](crate::client::fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate) for more information about the
    /// operation and its arguments.
    pub fn put_service_quota_increase_request_into_template(
        &self,
    ) -> fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate<C, M, R> {
        fluent_builders::PutServiceQuotaIncreaseRequestIntoTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RequestServiceQuotaIncrease` operation.
    ///
    /// See [`RequestServiceQuotaIncrease`](crate::client::fluent_builders::RequestServiceQuotaIncrease) for more information about the
    /// operation and its arguments.
    pub fn request_service_quota_increase(
        &self,
    ) -> fluent_builders::RequestServiceQuotaIncrease<C, M, R> {
        fluent_builders::RequestServiceQuotaIncrease::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateServiceQuotaTemplate`.
    ///
    /// <p>Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateServiceQuotaTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_service_quota_template_input::Builder,
    }
    impl<C, M, R> AssociateServiceQuotaTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateServiceQuotaTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateServiceQuotaTemplateInputOperationOutputAlias,
                crate::output::AssociateServiceQuotaTemplateOutput,
                crate::error::AssociateServiceQuotaTemplateError,
                crate::input::AssociateServiceQuotaTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceQuotaIncreaseRequestFromTemplate`.
    ///
    /// <p>Deletes the quota increase request for the specified quota from your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteServiceQuotaIncreaseRequestFromTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_quota_increase_request_from_template_input::Builder,
    }
    impl<C, M, R> DeleteServiceQuotaIncreaseRequestFromTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceQuotaIncreaseRequestFromTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DeleteServiceQuotaIncreaseRequestFromTemplateOutput, aws_smithy_http::result::SdkError<crate::error::DeleteServiceQuotaIncreaseRequestFromTemplateError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DeleteServiceQuotaIncreaseRequestFromTemplateInputOperationOutputAlias,
                                    crate::output::DeleteServiceQuotaIncreaseRequestFromTemplateOutput,
                                    crate::error::DeleteServiceQuotaIncreaseRequestFromTemplateError,
                                    crate::input::DeleteServiceQuotaIncreaseRequestFromTemplateInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceQuotaTemplate`.
    ///
    /// <p>Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateServiceQuotaTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_service_quota_template_input::Builder,
    }
    impl<C, M, R> DisassociateServiceQuotaTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateServiceQuotaTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateServiceQuotaTemplateInputOperationOutputAlias,
                crate::output::DisassociateServiceQuotaTemplateOutput,
                crate::error::DisassociateServiceQuotaTemplateError,
                crate::input::DisassociateServiceQuotaTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssociationForServiceQuotaTemplate`.
    ///
    /// <p>Retrieves the status of the association for the quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssociationForServiceQuotaTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_association_for_service_quota_template_input::Builder,
    }
    impl<C, M, R> GetAssociationForServiceQuotaTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssociationForServiceQuotaTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssociationForServiceQuotaTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAssociationForServiceQuotaTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssociationForServiceQuotaTemplateInputOperationOutputAlias,
                crate::output::GetAssociationForServiceQuotaTemplateOutput,
                crate::error::GetAssociationForServiceQuotaTemplateError,
                crate::input::GetAssociationForServiceQuotaTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAWSDefaultServiceQuota`.
    ///
    /// <p>Retrieves the default value for the specified quota. The default value does not reflect any quota increases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAWSDefaultServiceQuota<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_aws_default_service_quota_input::Builder,
    }
    impl<C, M, R> GetAWSDefaultServiceQuota<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAWSDefaultServiceQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAwsDefaultServiceQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAWSDefaultServiceQuotaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAwsDefaultServiceQuotaInputOperationOutputAlias,
                crate::output::GetAwsDefaultServiceQuotaOutput,
                crate::error::GetAWSDefaultServiceQuotaError,
                crate::input::GetAwsDefaultServiceQuotaInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRequestedServiceQuotaChange`.
    ///
    /// <p>Retrieves information about the specified quota increase request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRequestedServiceQuotaChange<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_requested_service_quota_change_input::Builder,
    }
    impl<C, M, R> GetRequestedServiceQuotaChange<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRequestedServiceQuotaChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRequestedServiceQuotaChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRequestedServiceQuotaChangeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRequestedServiceQuotaChangeInputOperationOutputAlias,
                crate::output::GetRequestedServiceQuotaChangeOutput,
                crate::error::GetRequestedServiceQuotaChangeError,
                crate::input::GetRequestedServiceQuotaChangeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the quota increase request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(input.into());
            self
        }
        /// <p>The ID of the quota increase request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceQuota`.
    ///
    /// <p>Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceQuota<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_quota_input::Builder,
    }
    impl<C, M, R> GetServiceQuota<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceQuotaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceQuotaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceQuotaInputOperationOutputAlias,
                crate::output::GetServiceQuotaOutput,
                crate::error::GetServiceQuotaError,
                crate::input::GetServiceQuotaInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceQuotaIncreaseRequestFromTemplate`.
    ///
    /// <p>Retrieves information about the specified quota increase request in your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceQuotaIncreaseRequestFromTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_quota_increase_request_from_template_input::Builder,
    }
    impl<C, M, R> GetServiceQuotaIncreaseRequestFromTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceQuotaIncreaseRequestFromTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceQuotaIncreaseRequestFromTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetServiceQuotaIncreaseRequestFromTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceQuotaIncreaseRequestFromTemplateInputOperationOutputAlias,
                crate::output::GetServiceQuotaIncreaseRequestFromTemplateOutput,
                crate::error::GetServiceQuotaIncreaseRequestFromTemplateError,
                crate::input::GetServiceQuotaIncreaseRequestFromTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAWSDefaultServiceQuotas`.
    ///
    /// <p>Lists the default values for the quotas for the specified AWS service. A default value does not reflect any quota increases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAWSDefaultServiceQuotas<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aws_default_service_quotas_input::Builder,
    }
    impl<C, M, R> ListAWSDefaultServiceQuotas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAWSDefaultServiceQuotas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAwsDefaultServiceQuotasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAWSDefaultServiceQuotasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAwsDefaultServiceQuotasInputOperationOutputAlias,
                crate::output::ListAwsDefaultServiceQuotasOutput,
                crate::error::ListAWSDefaultServiceQuotasError,
                crate::input::ListAwsDefaultServiceQuotasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAwsDefaultServiceQuotasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAwsDefaultServiceQuotasPaginator<C, M, R> {
            crate::paginator::ListAwsDefaultServiceQuotasPaginator::new(self.handle, self.inner)
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRequestedServiceQuotaChangeHistory`.
    ///
    /// <p>Retrieves the quota increase requests for the specified service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRequestedServiceQuotaChangeHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_requested_service_quota_change_history_input::Builder,
    }
    impl<C, M, R> ListRequestedServiceQuotaChangeHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRequestedServiceQuotaChangeHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRequestedServiceQuotaChangeHistoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListRequestedServiceQuotaChangeHistoryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRequestedServiceQuotaChangeHistoryInputOperationOutputAlias,
                crate::output::ListRequestedServiceQuotaChangeHistoryOutput,
                crate::error::ListRequestedServiceQuotaChangeHistoryError,
                crate::input::ListRequestedServiceQuotaChangeHistoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator<C, M, R> {
            crate::paginator::ListRequestedServiceQuotaChangeHistoryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The status of the quota increase request.</p>
        pub fn status(mut self, input: crate::model::RequestStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the quota increase request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RequestStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRequestedServiceQuotaChangeHistoryByQuota`.
    ///
    /// <p>Retrieves the quota increase requests for the specified quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRequestedServiceQuotaChangeHistoryByQuota<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_requested_service_quota_change_history_by_quota_input::Builder,
    }
    impl<C, M, R> ListRequestedServiceQuotaChangeHistoryByQuota<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRequestedServiceQuotaChangeHistoryByQuota`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput, aws_smithy_http::result::SdkError<crate::error::ListRequestedServiceQuotaChangeHistoryByQuotaError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::ListRequestedServiceQuotaChangeHistoryByQuotaInputOperationOutputAlias,
                                    crate::output::ListRequestedServiceQuotaChangeHistoryByQuotaOutput,
                                    crate::error::ListRequestedServiceQuotaChangeHistoryByQuotaError,
                                    crate::input::ListRequestedServiceQuotaChangeHistoryByQuotaInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator<C, M, R>
        {
            crate::paginator::ListRequestedServiceQuotaChangeHistoryByQuotaPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The status value of the quota increase request.</p>
        pub fn status(mut self, input: crate::model::RequestStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status value of the quota increase request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RequestStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceQuotaIncreaseRequestsInTemplate`.
    ///
    /// <p>Lists the quota increase requests in the specified quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceQuotaIncreaseRequestsInTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_quota_increase_requests_in_template_input::Builder,
    }
    impl<C, M, R> ListServiceQuotaIncreaseRequestsInTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceQuotaIncreaseRequestsInTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListServiceQuotaIncreaseRequestsInTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceQuotaIncreaseRequestsInTemplateInputOperationOutputAlias,
                crate::output::ListServiceQuotaIncreaseRequestsInTemplateOutput,
                crate::error::ListServiceQuotaIncreaseRequestsInTemplateError,
                crate::input::ListServiceQuotaIncreaseRequestsInTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator<C, M, R>
        {
            crate::paginator::ListServiceQuotaIncreaseRequestsInTemplatePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceQuotas`.
    ///
    /// <p>Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServiceQuotas<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_quotas_input::Builder,
    }
    impl<C, M, R> ListServiceQuotas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceQuotas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceQuotasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceQuotasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceQuotasInputOperationOutputAlias,
                crate::output::ListServiceQuotasOutput,
                crate::error::ListServiceQuotasError,
                crate::input::ListServiceQuotasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServiceQuotasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServiceQuotasPaginator<C, M, R> {
            crate::paginator::ListServiceQuotasPaginator::new(self.handle, self.inner)
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Lists the names and codes for the services integrated with Service Quotas.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_services_input::Builder,
    }
    impl<C, M, R> ListServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicesInputOperationOutputAlias,
                crate::output::ListServicesOutput,
                crate::error::ListServicesError,
                crate::input::ListServicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServicesPaginator<C, M, R> {
            crate::paginator::ListServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags assigned to the specified applied quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutServiceQuotaIncreaseRequestIntoTemplate`.
    ///
    /// <p>Adds a quota increase request to your quota request template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutServiceQuotaIncreaseRequestIntoTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_service_quota_increase_request_into_template_input::Builder,
    }
    impl<C, M, R> PutServiceQuotaIncreaseRequestIntoTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutServiceQuotaIncreaseRequestIntoTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutServiceQuotaIncreaseRequestIntoTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutServiceQuotaIncreaseRequestIntoTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutServiceQuotaIncreaseRequestIntoTemplateInputOperationOutputAlias,
                crate::output::PutServiceQuotaIncreaseRequestIntoTemplateOutput,
                crate::error::PutServiceQuotaIncreaseRequestIntoTemplateError,
                crate::input::PutServiceQuotaIncreaseRequestIntoTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_region(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_region(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.inner = self.inner.desired_value(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_desired_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RequestServiceQuotaIncrease`.
    ///
    /// <p>Submits a quota increase request for the specified quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RequestServiceQuotaIncrease<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::request_service_quota_increase_input::Builder,
    }
    impl<C, M, R> RequestServiceQuotaIncrease<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RequestServiceQuotaIncrease`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RequestServiceQuotaIncreaseOutput,
            aws_smithy_http::result::SdkError<crate::error::RequestServiceQuotaIncreaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RequestServiceQuotaIncreaseInputOperationOutputAlias,
                crate::output::RequestServiceQuotaIncreaseOutput,
                crate::error::RequestServiceQuotaIncreaseError,
                crate::input::RequestServiceQuotaIncreaseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_code(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_code(input);
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quota_code(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_quota_code(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.inner = self.inner.desired_value(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_desired_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to the specified applied quota. You can include one or more tags to add to the quota.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified applied quota. You can specify one or more tags to remove.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> AWS CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> AWS API operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
