// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A complex data type that contains a tag key and tag value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A string that contains a tag key. The string length should be between 1 and 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A string that contains an optional tag value. The string length should be between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A string that contains a tag key. The string length should be between 1 and 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A string that contains an optional tag value. The string length should be between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that contains a tag key. The string length should be between 1 and 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A string that contains a tag key. The string length should be between 1 and 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A string that contains an optional tag value. The string length should be between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A string that contains an optional tag value. The string length should be between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Information about a quota increase request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestedServiceQuotaChange {
    /// <p>The unique identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The case ID.</p>
    pub case_id: std::option::Option<std::string::String>,
    /// <p>The service identifier.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The service name.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The quota identifier.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The quota name.</p>
    pub quota_name: std::option::Option<std::string::String>,
    /// <p>The new, increased value for the quota.</p>
    pub desired_value: std::option::Option<f64>,
    /// <p>The state of the quota increase request.</p>
    pub status: std::option::Option<crate::model::RequestStatus>,
    /// <p>The date and time when the quota increase request was received and the case ID was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time of the most recent change.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The IAM identity of the requester.</p>
    pub requester: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the quota.</p>
    pub quota_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether the quota is global.</p>
    pub global_quota: bool,
    /// <p>The unit of measurement.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl RequestedServiceQuotaChange {
    /// <p>The unique identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The case ID.</p>
    pub fn case_id(&self) -> std::option::Option<&str> {
        self.case_id.as_deref()
    }
    /// <p>The service identifier.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The quota identifier.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The quota name.</p>
    pub fn quota_name(&self) -> std::option::Option<&str> {
        self.quota_name.as_deref()
    }
    /// <p>The new, increased value for the quota.</p>
    pub fn desired_value(&self) -> std::option::Option<f64> {
        self.desired_value
    }
    /// <p>The state of the quota increase request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RequestStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the quota increase request was received and the case ID was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date and time of the most recent change.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The IAM identity of the requester.</p>
    pub fn requester(&self) -> std::option::Option<&str> {
        self.requester.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the quota.</p>
    pub fn quota_arn(&self) -> std::option::Option<&str> {
        self.quota_arn.as_deref()
    }
    /// <p>Indicates whether the quota is global.</p>
    pub fn global_quota(&self) -> bool {
        self.global_quota
    }
    /// <p>The unit of measurement.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for RequestedServiceQuotaChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestedServiceQuotaChange");
        formatter.field("id", &self.id);
        formatter.field("case_id", &self.case_id);
        formatter.field("service_code", &self.service_code);
        formatter.field("service_name", &self.service_name);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("quota_name", &self.quota_name);
        formatter.field("desired_value", &self.desired_value);
        formatter.field("status", &self.status);
        formatter.field("created", &self.created);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("requester", &self.requester);
        formatter.field("quota_arn", &self.quota_arn);
        formatter.field("global_quota", &self.global_quota);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`RequestedServiceQuotaChange`](crate::model::RequestedServiceQuotaChange)
pub mod requested_service_quota_change {
    /// A builder for [`RequestedServiceQuotaChange`](crate::model::RequestedServiceQuotaChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) case_id: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) quota_name: std::option::Option<std::string::String>,
        pub(crate) desired_value: std::option::Option<f64>,
        pub(crate) status: std::option::Option<crate::model::RequestStatus>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) requester: std::option::Option<std::string::String>,
        pub(crate) quota_arn: std::option::Option<std::string::String>,
        pub(crate) global_quota: std::option::Option<bool>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The case ID.</p>
        pub fn case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.case_id = Some(input.into());
            self
        }
        /// <p>The case ID.</p>
        pub fn set_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.case_id = input;
            self
        }
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The quota name.</p>
        pub fn quota_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_name = Some(input.into());
            self
        }
        /// <p>The quota name.</p>
        pub fn set_quota_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_name = input;
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.desired_value = Some(input);
            self
        }
        /// <p>The new, increased value for the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.desired_value = input;
            self
        }
        /// <p>The state of the quota increase request.</p>
        pub fn status(mut self, input: crate::model::RequestStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The state of the quota increase request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RequestStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the quota increase request was received and the case ID was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time when the quota increase request was received and the case ID was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time of the most recent change.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The date and time of the most recent change.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The IAM identity of the requester.</p>
        pub fn requester(mut self, input: impl Into<std::string::String>) -> Self {
            self.requester = Some(input.into());
            self
        }
        /// <p>The IAM identity of the requester.</p>
        pub fn set_requester(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.requester = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quota.</p>
        pub fn quota_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quota.</p>
        pub fn set_quota_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_arn = input;
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn global_quota(mut self, input: bool) -> Self {
            self.global_quota = Some(input);
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn set_global_quota(mut self, input: std::option::Option<bool>) -> Self {
            self.global_quota = input;
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestedServiceQuotaChange`](crate::model::RequestedServiceQuotaChange)
        pub fn build(self) -> crate::model::RequestedServiceQuotaChange {
            crate::model::RequestedServiceQuotaChange {
                id: self.id,
                case_id: self.case_id,
                service_code: self.service_code,
                service_name: self.service_name,
                quota_code: self.quota_code,
                quota_name: self.quota_name,
                desired_value: self.desired_value,
                status: self.status,
                created: self.created,
                last_updated: self.last_updated,
                requester: self.requester,
                quota_arn: self.quota_arn,
                global_quota: self.global_quota.unwrap_or_default(),
                unit: self.unit,
            }
        }
    }
}
impl RequestedServiceQuotaChange {
    /// Creates a new builder-style object to manufacture [`RequestedServiceQuotaChange`](crate::model::RequestedServiceQuotaChange)
    pub fn builder() -> crate::model::requested_service_quota_change::Builder {
        crate::model::requested_service_quota_change::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    CaseClosed,
    #[allow(missing_docs)] // documentation missing in model
    CaseOpened,
    #[allow(missing_docs)] // documentation missing in model
    Denied,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestStatus {
    fn from(s: &str) -> Self {
        match s {
            "APPROVED" => RequestStatus::Approved,
            "CASE_CLOSED" => RequestStatus::CaseClosed,
            "CASE_OPENED" => RequestStatus::CaseOpened,
            "DENIED" => RequestStatus::Denied,
            "PENDING" => RequestStatus::Pending,
            other => RequestStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestStatus::from(s))
    }
}
impl RequestStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestStatus::Approved => "APPROVED",
            RequestStatus::CaseClosed => "CASE_CLOSED",
            RequestStatus::CaseOpened => "CASE_OPENED",
            RequestStatus::Denied => "DENIED",
            RequestStatus::Pending => "PENDING",
            RequestStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPROVED",
            "CASE_CLOSED",
            "CASE_OPENED",
            "DENIED",
            "PENDING",
        ]
    }
}
impl AsRef<str> for RequestStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a quota increase request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaIncreaseRequestInTemplate {
    /// <p>The service identifier.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The service name.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The quota identifier.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The quota name.</p>
    pub quota_name: std::option::Option<std::string::String>,
    /// <p>The new, increased value of the quota.</p>
    pub desired_value: std::option::Option<f64>,
    /// <p>The AWS Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The unit of measurement.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>Indicates whether the quota is global.</p>
    pub global_quota: bool,
}
impl ServiceQuotaIncreaseRequestInTemplate {
    /// <p>The service identifier.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The quota identifier.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The quota name.</p>
    pub fn quota_name(&self) -> std::option::Option<&str> {
        self.quota_name.as_deref()
    }
    /// <p>The new, increased value of the quota.</p>
    pub fn desired_value(&self) -> std::option::Option<f64> {
        self.desired_value
    }
    /// <p>The AWS Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The unit of measurement.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>Indicates whether the quota is global.</p>
    pub fn global_quota(&self) -> bool {
        self.global_quota
    }
}
impl std::fmt::Debug for ServiceQuotaIncreaseRequestInTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaIncreaseRequestInTemplate");
        formatter.field("service_code", &self.service_code);
        formatter.field("service_name", &self.service_name);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("quota_name", &self.quota_name);
        formatter.field("desired_value", &self.desired_value);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("unit", &self.unit);
        formatter.field("global_quota", &self.global_quota);
        formatter.finish()
    }
}
/// See [`ServiceQuotaIncreaseRequestInTemplate`](crate::model::ServiceQuotaIncreaseRequestInTemplate)
pub mod service_quota_increase_request_in_template {
    /// A builder for [`ServiceQuotaIncreaseRequestInTemplate`](crate::model::ServiceQuotaIncreaseRequestInTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) quota_name: std::option::Option<std::string::String>,
        pub(crate) desired_value: std::option::Option<f64>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) global_quota: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The quota name.</p>
        pub fn quota_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_name = Some(input.into());
            self
        }
        /// <p>The quota name.</p>
        pub fn set_quota_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_name = input;
            self
        }
        /// <p>The new, increased value of the quota.</p>
        pub fn desired_value(mut self, input: f64) -> Self {
            self.desired_value = Some(input);
            self
        }
        /// <p>The new, increased value of the quota.</p>
        pub fn set_desired_value(mut self, input: std::option::Option<f64>) -> Self {
            self.desired_value = input;
            self
        }
        /// <p>The AWS Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The AWS Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn global_quota(mut self, input: bool) -> Self {
            self.global_quota = Some(input);
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn set_global_quota(mut self, input: std::option::Option<bool>) -> Self {
            self.global_quota = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaIncreaseRequestInTemplate`](crate::model::ServiceQuotaIncreaseRequestInTemplate)
        pub fn build(self) -> crate::model::ServiceQuotaIncreaseRequestInTemplate {
            crate::model::ServiceQuotaIncreaseRequestInTemplate {
                service_code: self.service_code,
                service_name: self.service_name,
                quota_code: self.quota_code,
                quota_name: self.quota_name,
                desired_value: self.desired_value,
                aws_region: self.aws_region,
                unit: self.unit,
                global_quota: self.global_quota.unwrap_or_default(),
            }
        }
    }
}
impl ServiceQuotaIncreaseRequestInTemplate {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaIncreaseRequestInTemplate`](crate::model::ServiceQuotaIncreaseRequestInTemplate)
    pub fn builder() -> crate::model::service_quota_increase_request_in_template::Builder {
        crate::model::service_quota_increase_request_in_template::Builder::default()
    }
}

/// <p>Information about a service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceInfo {
    /// <p>The service identifier.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The service name.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl ServiceInfo {
    /// <p>The service identifier.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
}
impl std::fmt::Debug for ServiceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceInfo");
        formatter.field("service_code", &self.service_code);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`ServiceInfo`](crate::model::ServiceInfo)
pub mod service_info {
    /// A builder for [`ServiceInfo`](crate::model::ServiceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceInfo`](crate::model::ServiceInfo)
        pub fn build(self) -> crate::model::ServiceInfo {
            crate::model::ServiceInfo {
                service_code: self.service_code,
                service_name: self.service_name,
            }
        }
    }
}
impl ServiceInfo {
    /// Creates a new builder-style object to manufacture [`ServiceInfo`](crate::model::ServiceInfo)
    pub fn builder() -> crate::model::service_info::Builder {
        crate::model::service_info::Builder::default()
    }
}

/// <p>Information about a quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuota {
    /// <p>The service identifier.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The service name.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the quota.</p>
    pub quota_arn: std::option::Option<std::string::String>,
    /// <p>The quota identifier.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The quota name.</p>
    pub quota_name: std::option::Option<std::string::String>,
    /// <p>The quota value.</p>
    pub value: std::option::Option<f64>,
    /// <p>The unit of measurement.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>Indicates whether the quota value can be increased.</p>
    pub adjustable: bool,
    /// <p>Indicates whether the quota is global.</p>
    pub global_quota: bool,
    /// <p>Information about the measurement.</p>
    pub usage_metric: std::option::Option<crate::model::MetricInfo>,
    /// <p>The period of time.</p>
    pub period: std::option::Option<crate::model::QuotaPeriod>,
    /// <p>The error code and error reason.</p>
    pub error_reason: std::option::Option<crate::model::ErrorReason>,
}
impl ServiceQuota {
    /// <p>The service identifier.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the quota.</p>
    pub fn quota_arn(&self) -> std::option::Option<&str> {
        self.quota_arn.as_deref()
    }
    /// <p>The quota identifier.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The quota name.</p>
    pub fn quota_name(&self) -> std::option::Option<&str> {
        self.quota_name.as_deref()
    }
    /// <p>The quota value.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
    /// <p>The unit of measurement.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>Indicates whether the quota value can be increased.</p>
    pub fn adjustable(&self) -> bool {
        self.adjustable
    }
    /// <p>Indicates whether the quota is global.</p>
    pub fn global_quota(&self) -> bool {
        self.global_quota
    }
    /// <p>Information about the measurement.</p>
    pub fn usage_metric(&self) -> std::option::Option<&crate::model::MetricInfo> {
        self.usage_metric.as_ref()
    }
    /// <p>The period of time.</p>
    pub fn period(&self) -> std::option::Option<&crate::model::QuotaPeriod> {
        self.period.as_ref()
    }
    /// <p>The error code and error reason.</p>
    pub fn error_reason(&self) -> std::option::Option<&crate::model::ErrorReason> {
        self.error_reason.as_ref()
    }
}
impl std::fmt::Debug for ServiceQuota {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuota");
        formatter.field("service_code", &self.service_code);
        formatter.field("service_name", &self.service_name);
        formatter.field("quota_arn", &self.quota_arn);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("quota_name", &self.quota_name);
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.field("adjustable", &self.adjustable);
        formatter.field("global_quota", &self.global_quota);
        formatter.field("usage_metric", &self.usage_metric);
        formatter.field("period", &self.period);
        formatter.field("error_reason", &self.error_reason);
        formatter.finish()
    }
}
/// See [`ServiceQuota`](crate::model::ServiceQuota)
pub mod service_quota {
    /// A builder for [`ServiceQuota`](crate::model::ServiceQuota)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) quota_arn: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) quota_name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) adjustable: std::option::Option<bool>,
        pub(crate) global_quota: std::option::Option<bool>,
        pub(crate) usage_metric: std::option::Option<crate::model::MetricInfo>,
        pub(crate) period: std::option::Option<crate::model::QuotaPeriod>,
        pub(crate) error_reason: std::option::Option<crate::model::ErrorReason>,
    }
    impl Builder {
        /// <p>The service identifier.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service identifier.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quota.</p>
        pub fn quota_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the quota.</p>
        pub fn set_quota_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_arn = input;
            self
        }
        /// <p>The quota identifier.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota identifier.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The quota name.</p>
        pub fn quota_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_name = Some(input.into());
            self
        }
        /// <p>The quota name.</p>
        pub fn set_quota_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_name = input;
            self
        }
        /// <p>The quota value.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The quota value.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measurement.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>Indicates whether the quota value can be increased.</p>
        pub fn adjustable(mut self, input: bool) -> Self {
            self.adjustable = Some(input);
            self
        }
        /// <p>Indicates whether the quota value can be increased.</p>
        pub fn set_adjustable(mut self, input: std::option::Option<bool>) -> Self {
            self.adjustable = input;
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn global_quota(mut self, input: bool) -> Self {
            self.global_quota = Some(input);
            self
        }
        /// <p>Indicates whether the quota is global.</p>
        pub fn set_global_quota(mut self, input: std::option::Option<bool>) -> Self {
            self.global_quota = input;
            self
        }
        /// <p>Information about the measurement.</p>
        pub fn usage_metric(mut self, input: crate::model::MetricInfo) -> Self {
            self.usage_metric = Some(input);
            self
        }
        /// <p>Information about the measurement.</p>
        pub fn set_usage_metric(
            mut self,
            input: std::option::Option<crate::model::MetricInfo>,
        ) -> Self {
            self.usage_metric = input;
            self
        }
        /// <p>The period of time.</p>
        pub fn period(mut self, input: crate::model::QuotaPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The period of time.</p>
        pub fn set_period(mut self, input: std::option::Option<crate::model::QuotaPeriod>) -> Self {
            self.period = input;
            self
        }
        /// <p>The error code and error reason.</p>
        pub fn error_reason(mut self, input: crate::model::ErrorReason) -> Self {
            self.error_reason = Some(input);
            self
        }
        /// <p>The error code and error reason.</p>
        pub fn set_error_reason(
            mut self,
            input: std::option::Option<crate::model::ErrorReason>,
        ) -> Self {
            self.error_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuota`](crate::model::ServiceQuota)
        pub fn build(self) -> crate::model::ServiceQuota {
            crate::model::ServiceQuota {
                service_code: self.service_code,
                service_name: self.service_name,
                quota_arn: self.quota_arn,
                quota_code: self.quota_code,
                quota_name: self.quota_name,
                value: self.value,
                unit: self.unit,
                adjustable: self.adjustable.unwrap_or_default(),
                global_quota: self.global_quota.unwrap_or_default(),
                usage_metric: self.usage_metric,
                period: self.period,
                error_reason: self.error_reason,
            }
        }
    }
}
impl ServiceQuota {
    /// Creates a new builder-style object to manufacture [`ServiceQuota`](crate::model::ServiceQuota)
    pub fn builder() -> crate::model::service_quota::Builder {
        crate::model::service_quota::Builder::default()
    }
}

/// <p>An error that explains why an action did not succeed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorReason {
    /// <p>Service Quotas returns the following error values:</p>
    /// <ul>
    /// <li> <p> <code>DEPENDENCY_ACCESS_DENIED_ERROR</code> - The caller does not have the required permissions to complete the action. To resolve the error, you must have permission to access the service or quota.</p> </li>
    /// <li> <p> <code>DEPENDENCY_THROTTLING_ERROR</code> - The service is throttling Service Quotas.</p> </li>
    /// <li> <p> <code>DEPENDENCY_SERVICE_ERROR</code> - The service is not available.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_NOT_AVAILABLE_ERROR</code> - There was an error in Service Quotas.</p> </li>
    /// </ul>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl ErrorReason {
    /// <p>Service Quotas returns the following error values:</p>
    /// <ul>
    /// <li> <p> <code>DEPENDENCY_ACCESS_DENIED_ERROR</code> - The caller does not have the required permissions to complete the action. To resolve the error, you must have permission to access the service or quota.</p> </li>
    /// <li> <p> <code>DEPENDENCY_THROTTLING_ERROR</code> - The service is throttling Service Quotas.</p> </li>
    /// <li> <p> <code>DEPENDENCY_SERVICE_ERROR</code> - The service is not available.</p> </li>
    /// <li> <p> <code>SERVICE_QUOTA_NOT_AVAILABLE_ERROR</code> - There was an error in Service Quotas.</p> </li>
    /// </ul>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorReason");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ErrorReason`](crate::model::ErrorReason)
pub mod error_reason {
    /// A builder for [`ErrorReason`](crate::model::ErrorReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Service Quotas returns the following error values:</p>
        /// <ul>
        /// <li> <p> <code>DEPENDENCY_ACCESS_DENIED_ERROR</code> - The caller does not have the required permissions to complete the action. To resolve the error, you must have permission to access the service or quota.</p> </li>
        /// <li> <p> <code>DEPENDENCY_THROTTLING_ERROR</code> - The service is throttling Service Quotas.</p> </li>
        /// <li> <p> <code>DEPENDENCY_SERVICE_ERROR</code> - The service is not available.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_NOT_AVAILABLE_ERROR</code> - There was an error in Service Quotas.</p> </li>
        /// </ul>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Service Quotas returns the following error values:</p>
        /// <ul>
        /// <li> <p> <code>DEPENDENCY_ACCESS_DENIED_ERROR</code> - The caller does not have the required permissions to complete the action. To resolve the error, you must have permission to access the service or quota.</p> </li>
        /// <li> <p> <code>DEPENDENCY_THROTTLING_ERROR</code> - The service is throttling Service Quotas.</p> </li>
        /// <li> <p> <code>DEPENDENCY_SERVICE_ERROR</code> - The service is not available.</p> </li>
        /// <li> <p> <code>SERVICE_QUOTA_NOT_AVAILABLE_ERROR</code> - There was an error in Service Quotas.</p> </li>
        /// </ul>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorReason`](crate::model::ErrorReason)
        pub fn build(self) -> crate::model::ErrorReason {
            crate::model::ErrorReason {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl ErrorReason {
    /// Creates a new builder-style object to manufacture [`ErrorReason`](crate::model::ErrorReason)
    pub fn builder() -> crate::model::error_reason::Builder {
        crate::model::error_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    DependencyAccessDeniedError,
    #[allow(missing_docs)] // documentation missing in model
    DependencyServiceError,
    #[allow(missing_docs)] // documentation missing in model
    DependencyThrottlingError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceQuotaNotAvailableError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "DEPENDENCY_ACCESS_DENIED_ERROR" => ErrorCode::DependencyAccessDeniedError,
            "DEPENDENCY_SERVICE_ERROR" => ErrorCode::DependencyServiceError,
            "DEPENDENCY_THROTTLING_ERROR" => ErrorCode::DependencyThrottlingError,
            "SERVICE_QUOTA_NOT_AVAILABLE_ERROR" => ErrorCode::ServiceQuotaNotAvailableError,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::DependencyAccessDeniedError => "DEPENDENCY_ACCESS_DENIED_ERROR",
            ErrorCode::DependencyServiceError => "DEPENDENCY_SERVICE_ERROR",
            ErrorCode::DependencyThrottlingError => "DEPENDENCY_THROTTLING_ERROR",
            ErrorCode::ServiceQuotaNotAvailableError => "SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPENDENCY_ACCESS_DENIED_ERROR",
            "DEPENDENCY_SERVICE_ERROR",
            "DEPENDENCY_THROTTLING_ERROR",
            "SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the quota period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuotaPeriod {
    /// <p>The value.</p>
    pub period_value: std::option::Option<i32>,
    /// <p>The time unit.</p>
    pub period_unit: std::option::Option<crate::model::PeriodUnit>,
}
impl QuotaPeriod {
    /// <p>The value.</p>
    pub fn period_value(&self) -> std::option::Option<i32> {
        self.period_value
    }
    /// <p>The time unit.</p>
    pub fn period_unit(&self) -> std::option::Option<&crate::model::PeriodUnit> {
        self.period_unit.as_ref()
    }
}
impl std::fmt::Debug for QuotaPeriod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuotaPeriod");
        formatter.field("period_value", &self.period_value);
        formatter.field("period_unit", &self.period_unit);
        formatter.finish()
    }
}
/// See [`QuotaPeriod`](crate::model::QuotaPeriod)
pub mod quota_period {
    /// A builder for [`QuotaPeriod`](crate::model::QuotaPeriod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) period_value: std::option::Option<i32>,
        pub(crate) period_unit: std::option::Option<crate::model::PeriodUnit>,
    }
    impl Builder {
        /// <p>The value.</p>
        pub fn period_value(mut self, input: i32) -> Self {
            self.period_value = Some(input);
            self
        }
        /// <p>The value.</p>
        pub fn set_period_value(mut self, input: std::option::Option<i32>) -> Self {
            self.period_value = input;
            self
        }
        /// <p>The time unit.</p>
        pub fn period_unit(mut self, input: crate::model::PeriodUnit) -> Self {
            self.period_unit = Some(input);
            self
        }
        /// <p>The time unit.</p>
        pub fn set_period_unit(
            mut self,
            input: std::option::Option<crate::model::PeriodUnit>,
        ) -> Self {
            self.period_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`QuotaPeriod`](crate::model::QuotaPeriod)
        pub fn build(self) -> crate::model::QuotaPeriod {
            crate::model::QuotaPeriod {
                period_value: self.period_value,
                period_unit: self.period_unit,
            }
        }
    }
}
impl QuotaPeriod {
    /// Creates a new builder-style object to manufacture [`QuotaPeriod`](crate::model::QuotaPeriod)
    pub fn builder() -> crate::model::quota_period::Builder {
        crate::model::quota_period::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PeriodUnit {
    #[allow(missing_docs)] // documentation missing in model
    Day,
    #[allow(missing_docs)] // documentation missing in model
    Hour,
    #[allow(missing_docs)] // documentation missing in model
    Microsecond,
    #[allow(missing_docs)] // documentation missing in model
    Millisecond,
    #[allow(missing_docs)] // documentation missing in model
    Minute,
    #[allow(missing_docs)] // documentation missing in model
    Second,
    #[allow(missing_docs)] // documentation missing in model
    Week,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PeriodUnit {
    fn from(s: &str) -> Self {
        match s {
            "DAY" => PeriodUnit::Day,
            "HOUR" => PeriodUnit::Hour,
            "MICROSECOND" => PeriodUnit::Microsecond,
            "MILLISECOND" => PeriodUnit::Millisecond,
            "MINUTE" => PeriodUnit::Minute,
            "SECOND" => PeriodUnit::Second,
            "WEEK" => PeriodUnit::Week,
            other => PeriodUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PeriodUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PeriodUnit::from(s))
    }
}
impl PeriodUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PeriodUnit::Day => "DAY",
            PeriodUnit::Hour => "HOUR",
            PeriodUnit::Microsecond => "MICROSECOND",
            PeriodUnit::Millisecond => "MILLISECOND",
            PeriodUnit::Minute => "MINUTE",
            PeriodUnit::Second => "SECOND",
            PeriodUnit::Week => "WEEK",
            PeriodUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DAY",
            "HOUR",
            "MICROSECOND",
            "MILLISECOND",
            "MINUTE",
            "SECOND",
            "WEEK",
        ]
    }
}
impl AsRef<str> for PeriodUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the CloudWatch metric that reflects quota usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricInfo {
    /// <p>The namespace of the metric.</p>
    pub metric_namespace: std::option::Option<std::string::String>,
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The metric dimension. This is a name/value pair that is part of the identity of a metric.</p>
    pub metric_dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The metric statistic that we recommend you use when determining quota usage.</p>
    pub metric_statistic_recommendation: std::option::Option<std::string::String>,
}
impl MetricInfo {
    /// <p>The namespace of the metric.</p>
    pub fn metric_namespace(&self) -> std::option::Option<&str> {
        self.metric_namespace.as_deref()
    }
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The metric dimension. This is a name/value pair that is part of the identity of a metric.</p>
    pub fn metric_dimensions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metric_dimensions.as_ref()
    }
    /// <p>The metric statistic that we recommend you use when determining quota usage.</p>
    pub fn metric_statistic_recommendation(&self) -> std::option::Option<&str> {
        self.metric_statistic_recommendation.as_deref()
    }
}
impl std::fmt::Debug for MetricInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricInfo");
        formatter.field("metric_namespace", &self.metric_namespace);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_dimensions", &self.metric_dimensions);
        formatter.field(
            "metric_statistic_recommendation",
            &self.metric_statistic_recommendation,
        );
        formatter.finish()
    }
}
/// See [`MetricInfo`](crate::model::MetricInfo)
pub mod metric_info {
    /// A builder for [`MetricInfo`](crate::model::MetricInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_namespace: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) metric_statistic_recommendation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespace of the metric.</p>
        pub fn metric_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_metric_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_namespace = input;
            self
        }
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Adds a key-value pair to `metric_dimensions`.
        ///
        /// To override the contents of this collection use [`set_metric_dimensions`](Self::set_metric_dimensions).
        ///
        /// <p>The metric dimension. This is a name/value pair that is part of the identity of a metric.</p>
        pub fn metric_dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metric_dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metric_dimensions = Some(hash_map);
            self
        }
        /// <p>The metric dimension. This is a name/value pair that is part of the identity of a metric.</p>
        pub fn set_metric_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metric_dimensions = input;
            self
        }
        /// <p>The metric statistic that we recommend you use when determining quota usage.</p>
        pub fn metric_statistic_recommendation(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.metric_statistic_recommendation = Some(input.into());
            self
        }
        /// <p>The metric statistic that we recommend you use when determining quota usage.</p>
        pub fn set_metric_statistic_recommendation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_statistic_recommendation = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricInfo`](crate::model::MetricInfo)
        pub fn build(self) -> crate::model::MetricInfo {
            crate::model::MetricInfo {
                metric_namespace: self.metric_namespace,
                metric_name: self.metric_name,
                metric_dimensions: self.metric_dimensions,
                metric_statistic_recommendation: self.metric_statistic_recommendation,
            }
        }
    }
}
impl MetricInfo {
    /// Creates a new builder-style object to manufacture [`MetricInfo`](crate::model::MetricInfo)
    pub fn builder() -> crate::model::metric_info::Builder {
        crate::model::metric_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceQuotaTemplateAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Disassociated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceQuotaTemplateAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATED" => ServiceQuotaTemplateAssociationStatus::Associated,
            "DISASSOCIATED" => ServiceQuotaTemplateAssociationStatus::Disassociated,
            other => ServiceQuotaTemplateAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceQuotaTemplateAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceQuotaTemplateAssociationStatus::from(s))
    }
}
impl ServiceQuotaTemplateAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceQuotaTemplateAssociationStatus::Associated => "ASSOCIATED",
            ServiceQuotaTemplateAssociationStatus::Disassociated => "DISASSOCIATED",
            ServiceQuotaTemplateAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASSOCIATED", "DISASSOCIATED"]
    }
}
impl AsRef<str> for ServiceQuotaTemplateAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
