// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateServiceQuotaTemplateError {
    /// Kind of error that occurred.
    pub kind: AssociateServiceQuotaTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateServiceQuotaTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>The organization that your account belongs to is not in All Features mode.</p>
    OrganizationNotInAllFeaturesModeException(
        crate::error::OrganizationNotInAllFeaturesModeException,
    ),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateServiceQuotaTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) => {
                _inner.fmt(f)
            }
            AssociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateServiceQuotaTemplateErrorKind::OrganizationNotInAllFeaturesModeException(
                _inner,
            ) => _inner.fmt(f),
            AssociateServiceQuotaTemplateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AssociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(
                _inner,
            ) => _inner.fmt(f),
            AssociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            AssociateServiceQuotaTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateServiceQuotaTemplateError {
    fn code(&self) -> Option<&str> {
        AssociateServiceQuotaTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateServiceQuotaTemplateError {
    /// Creates a new `AssociateServiceQuotaTemplateError`.
    pub fn new(
        kind: AssociateServiceQuotaTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateServiceQuotaTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateServiceQuotaTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateServiceQuotaTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateServiceQuotaTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::OrganizationNotInAllFeaturesModeException`.
    pub fn is_organization_not_in_all_features_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::OrganizationNotInAllFeaturesModeException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateServiceQuotaTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AssociateServiceQuotaTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) => {
                Some(_inner)
            }
            AssociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) => {
                Some(_inner)
            }
            AssociateServiceQuotaTemplateErrorKind::OrganizationNotInAllFeaturesModeException(
                _inner,
            ) => Some(_inner),
            AssociateServiceQuotaTemplateErrorKind::ServiceException(_inner) => Some(_inner),
            AssociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(
                _inner,
            ) => Some(_inner),
            AssociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            AssociateServiceQuotaTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceQuotaIncreaseRequestFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceQuotaIncreaseRequestFromTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceQuotaIncreaseRequestFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceQuotaIncreaseRequestFromTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DeleteServiceQuotaIncreaseRequestFromTemplateError
{
    fn code(&self) -> Option<&str> {
        DeleteServiceQuotaIncreaseRequestFromTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceQuotaIncreaseRequestFromTemplateError {
    /// Creates a new `DeleteServiceQuotaIncreaseRequestFromTemplateError`.
    pub fn new(
        kind: DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceQuotaIncreaseRequestFromTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceQuotaIncreaseRequestFromTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteServiceQuotaIncreaseRequestFromTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            DeleteServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateServiceQuotaTemplateError {
    /// Kind of error that occurred.
    pub kind: DisassociateServiceQuotaTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateServiceQuotaTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The quota request template is not associated with your organization.</p>
    ServiceQuotaTemplateNotInUseException(crate::error::ServiceQuotaTemplateNotInUseException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateServiceQuotaTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateServiceQuotaTemplateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisassociateServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateServiceQuotaTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateServiceQuotaTemplateError {
    fn code(&self) -> Option<&str> {
        DisassociateServiceQuotaTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateServiceQuotaTemplateError {
    /// Creates a new `DisassociateServiceQuotaTemplateError`.
    pub fn new(
        kind: DisassociateServiceQuotaTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateServiceQuotaTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateServiceQuotaTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateServiceQuotaTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateServiceQuotaTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException`.
    pub fn is_service_quota_template_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateServiceQuotaTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DisassociateServiceQuotaTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(
                _inner,
            ) => Some(_inner),
            DisassociateServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) => {
                Some(_inner)
            }
            DisassociateServiceQuotaTemplateErrorKind::ServiceException(_inner) => Some(_inner),
            DisassociateServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(
                _inner,
            ) => Some(_inner),
            DisassociateServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(
                _inner,
            ) => Some(_inner),
            DisassociateServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DisassociateServiceQuotaTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssociationForServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssociationForServiceQuotaTemplateError {
    /// Kind of error that occurred.
    pub kind: GetAssociationForServiceQuotaTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssociationForServiceQuotaTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssociationForServiceQuotaTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The quota request template is not associated with your organization.</p>
    ServiceQuotaTemplateNotInUseException(crate::error::ServiceQuotaTemplateNotInUseException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssociationForServiceQuotaTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssociationForServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssociationForServiceQuotaTemplateError {
    fn code(&self) -> Option<&str> {
        GetAssociationForServiceQuotaTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssociationForServiceQuotaTemplateError {
    /// Creates a new `GetAssociationForServiceQuotaTemplateError`.
    pub fn new(
        kind: GetAssociationForServiceQuotaTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssociationForServiceQuotaTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssociationForServiceQuotaTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssociationForServiceQuotaTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssociationForServiceQuotaTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException`.
    pub fn is_service_quota_template_not_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetAssociationForServiceQuotaTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssociationForServiceQuotaTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAssociationForServiceQuotaTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssociationForServiceQuotaTemplateErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::ServiceQuotaTemplateNotInUseException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            GetAssociationForServiceQuotaTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAWSDefaultServiceQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAWSDefaultServiceQuotaError {
    /// Kind of error that occurred.
    pub kind: GetAWSDefaultServiceQuotaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAWSDefaultServiceQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAWSDefaultServiceQuotaErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAWSDefaultServiceQuotaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAWSDefaultServiceQuotaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAWSDefaultServiceQuotaErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            GetAWSDefaultServiceQuotaErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            GetAWSDefaultServiceQuotaErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetAWSDefaultServiceQuotaErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAWSDefaultServiceQuotaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAWSDefaultServiceQuotaError {
    fn code(&self) -> Option<&str> {
        GetAWSDefaultServiceQuotaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAWSDefaultServiceQuotaError {
    /// Creates a new `GetAWSDefaultServiceQuotaError`.
    pub fn new(kind: GetAWSDefaultServiceQuotaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAWSDefaultServiceQuotaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAWSDefaultServiceQuotaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAWSDefaultServiceQuotaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAWSDefaultServiceQuotaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAWSDefaultServiceQuotaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSDefaultServiceQuotaErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAWSDefaultServiceQuotaErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSDefaultServiceQuotaErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAWSDefaultServiceQuotaErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSDefaultServiceQuotaErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAWSDefaultServiceQuotaErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSDefaultServiceQuotaErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAWSDefaultServiceQuotaErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAWSDefaultServiceQuotaErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAWSDefaultServiceQuotaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAWSDefaultServiceQuotaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAWSDefaultServiceQuotaErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            GetAWSDefaultServiceQuotaErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            GetAWSDefaultServiceQuotaErrorKind::ServiceException(_inner) => Some(_inner),
            GetAWSDefaultServiceQuotaErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAWSDefaultServiceQuotaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRequestedServiceQuotaChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRequestedServiceQuotaChangeError {
    /// Kind of error that occurred.
    pub kind: GetRequestedServiceQuotaChangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRequestedServiceQuotaChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRequestedServiceQuotaChangeErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRequestedServiceQuotaChangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRequestedServiceQuotaChangeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRequestedServiceQuotaChangeErrorKind::IllegalArgumentException(_inner) => {
                _inner.fmt(f)
            }
            GetRequestedServiceQuotaChangeErrorKind::NoSuchResourceException(_inner) => {
                _inner.fmt(f)
            }
            GetRequestedServiceQuotaChangeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRequestedServiceQuotaChangeErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetRequestedServiceQuotaChangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRequestedServiceQuotaChangeError {
    fn code(&self) -> Option<&str> {
        GetRequestedServiceQuotaChangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRequestedServiceQuotaChangeError {
    /// Creates a new `GetRequestedServiceQuotaChangeError`.
    pub fn new(
        kind: GetRequestedServiceQuotaChangeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRequestedServiceQuotaChangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRequestedServiceQuotaChangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRequestedServiceQuotaChangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRequestedServiceQuotaChangeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRequestedServiceQuotaChangeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestedServiceQuotaChangeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRequestedServiceQuotaChangeErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestedServiceQuotaChangeErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRequestedServiceQuotaChangeErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestedServiceQuotaChangeErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRequestedServiceQuotaChangeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestedServiceQuotaChangeErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRequestedServiceQuotaChangeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRequestedServiceQuotaChangeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetRequestedServiceQuotaChangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRequestedServiceQuotaChangeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRequestedServiceQuotaChangeErrorKind::IllegalArgumentException(_inner) => {
                Some(_inner)
            }
            GetRequestedServiceQuotaChangeErrorKind::NoSuchResourceException(_inner) => {
                Some(_inner)
            }
            GetRequestedServiceQuotaChangeErrorKind::ServiceException(_inner) => Some(_inner),
            GetRequestedServiceQuotaChangeErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            GetRequestedServiceQuotaChangeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceQuotaError {
    /// Kind of error that occurred.
    pub kind: GetServiceQuotaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceQuotaErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceQuotaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceQuotaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceQuotaErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            GetServiceQuotaErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            GetServiceQuotaErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetServiceQuotaErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetServiceQuotaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceQuotaError {
    fn code(&self) -> Option<&str> {
        GetServiceQuotaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceQuotaError {
    /// Creates a new `GetServiceQuotaError`.
    pub fn new(kind: GetServiceQuotaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceQuotaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceQuotaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceQuotaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceQuotaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceQuotaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetServiceQuotaErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetServiceQuotaErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetServiceQuotaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceQuotaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceQuotaErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            GetServiceQuotaErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            GetServiceQuotaErrorKind::ServiceException(_inner) => Some(_inner),
            GetServiceQuotaErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetServiceQuotaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceQuotaIncreaseRequestFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceQuotaIncreaseRequestFromTemplateError {
    /// Kind of error that occurred.
    pub kind: GetServiceQuotaIncreaseRequestFromTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceQuotaIncreaseRequestFromTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceQuotaIncreaseRequestFromTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceQuotaIncreaseRequestFromTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceQuotaIncreaseRequestFromTemplateError {
    fn code(&self) -> Option<&str> {
        GetServiceQuotaIncreaseRequestFromTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceQuotaIncreaseRequestFromTemplateError {
    /// Creates a new `GetServiceQuotaIncreaseRequestFromTemplateError`.
    pub fn new(
        kind: GetServiceQuotaIncreaseRequestFromTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceQuotaIncreaseRequestFromTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceQuotaIncreaseRequestFromTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(&self.kind, GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_))
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(&self.kind, GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_))
    }
    /// Returns `true` if the error kind is `GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetServiceQuotaIncreaseRequestFromTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::IllegalArgumentException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::NoSuchResourceException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            GetServiceQuotaIncreaseRequestFromTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAWSDefaultServiceQuotas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAWSDefaultServiceQuotasError {
    /// Kind of error that occurred.
    pub kind: ListAWSDefaultServiceQuotasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAWSDefaultServiceQuotas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAWSDefaultServiceQuotasErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>Invalid input was provided.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAWSDefaultServiceQuotasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAWSDefaultServiceQuotasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAWSDefaultServiceQuotasErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            ListAWSDefaultServiceQuotasErrorKind::InvalidPaginationTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListAWSDefaultServiceQuotasErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            ListAWSDefaultServiceQuotasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListAWSDefaultServiceQuotasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAWSDefaultServiceQuotasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAWSDefaultServiceQuotasError {
    fn code(&self) -> Option<&str> {
        ListAWSDefaultServiceQuotasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAWSDefaultServiceQuotasError {
    /// Creates a new `ListAWSDefaultServiceQuotasError`.
    pub fn new(kind: ListAWSDefaultServiceQuotasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAWSDefaultServiceQuotasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAWSDefaultServiceQuotasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAWSDefaultServiceQuotasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAWSDefaultServiceQuotasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAWSDefaultServiceQuotasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAWSDefaultServiceQuotasErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListAWSDefaultServiceQuotasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAWSDefaultServiceQuotasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAWSDefaultServiceQuotasErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            ListAWSDefaultServiceQuotasErrorKind::InvalidPaginationTokenException(_inner) => {
                Some(_inner)
            }
            ListAWSDefaultServiceQuotasErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            ListAWSDefaultServiceQuotasErrorKind::ServiceException(_inner) => Some(_inner),
            ListAWSDefaultServiceQuotasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAWSDefaultServiceQuotasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRequestedServiceQuotaChangeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRequestedServiceQuotaChangeHistoryError {
    /// Kind of error that occurred.
    pub kind: ListRequestedServiceQuotaChangeHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRequestedServiceQuotaChangeHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRequestedServiceQuotaChangeHistoryErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>Invalid input was provided.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRequestedServiceQuotaChangeHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRequestedServiceQuotaChangeHistoryErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::IllegalArgumentException(_inner) => {
                _inner.fmt(f)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::InvalidPaginationTokenException(
                _inner,
            ) => _inner.fmt(f),
            ListRequestedServiceQuotaChangeHistoryErrorKind::NoSuchResourceException(_inner) => {
                _inner.fmt(f)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::ServiceException(_inner) => {
                _inner.fmt(f)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRequestedServiceQuotaChangeHistoryError {
    fn code(&self) -> Option<&str> {
        ListRequestedServiceQuotaChangeHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRequestedServiceQuotaChangeHistoryError {
    /// Creates a new `ListRequestedServiceQuotaChangeHistoryError`.
    pub fn new(
        kind: ListRequestedServiceQuotaChangeHistoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRequestedServiceQuotaChangeHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRequestedServiceQuotaChangeHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRequestedServiceQuotaChangeHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRequestedServiceQuotaChangeHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListRequestedServiceQuotaChangeHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRequestedServiceQuotaChangeHistoryErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::IllegalArgumentException(_inner) => {
                Some(_inner)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::InvalidPaginationTokenException(
                _inner,
            ) => Some(_inner),
            ListRequestedServiceQuotaChangeHistoryErrorKind::NoSuchResourceException(_inner) => {
                Some(_inner)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::ServiceException(_inner) => {
                Some(_inner)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListRequestedServiceQuotaChangeHistoryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListRequestedServiceQuotaChangeHistoryByQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRequestedServiceQuotaChangeHistoryByQuotaError {
    /// Kind of error that occurred.
    pub kind: ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRequestedServiceQuotaChangeHistoryByQuota` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>Invalid input was provided.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRequestedServiceQuotaChangeHistoryByQuotaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::IllegalArgumentException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::InvalidPaginationTokenException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::NoSuchResourceException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for ListRequestedServiceQuotaChangeHistoryByQuotaError
{
    fn code(&self) -> Option<&str> {
        ListRequestedServiceQuotaChangeHistoryByQuotaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRequestedServiceQuotaChangeHistoryByQuotaError {
    /// Creates a new `ListRequestedServiceQuotaChangeHistoryByQuotaError`.
    pub fn new(
        kind: ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRequestedServiceQuotaChangeHistoryByQuotaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRequestedServiceQuotaChangeHistoryByQuotaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::InvalidPaginationTokenException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListRequestedServiceQuotaChangeHistoryByQuotaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::IllegalArgumentException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::InvalidPaginationTokenException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::NoSuchResourceException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            ListRequestedServiceQuotaChangeHistoryByQuotaErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListServiceQuotaIncreaseRequestsInTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceQuotaIncreaseRequestsInTemplateError {
    /// Kind of error that occurred.
    pub kind: ListServiceQuotaIncreaseRequestsInTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceQuotaIncreaseRequestsInTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceQuotaIncreaseRequestsInTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceQuotaIncreaseRequestsInTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::IllegalArgumentException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceQuotaIncreaseRequestsInTemplateError {
    fn code(&self) -> Option<&str> {
        ListServiceQuotaIncreaseRequestsInTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceQuotaIncreaseRequestsInTemplateError {
    /// Creates a new `ListServiceQuotaIncreaseRequestsInTemplateError`.
    pub fn new(
        kind: ListServiceQuotaIncreaseRequestsInTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceQuotaIncreaseRequestsInTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceQuotaIncreaseRequestsInTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceQuotaIncreaseRequestsInTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceQuotaIncreaseRequestsInTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(&self.kind, ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AwsServiceAccessNotEnabledException(_))
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::NoAvailableOrganizationException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(&self.kind, ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TemplatesNotAvailableInRegionException(_))
    }
    /// Returns `true` if the error kind is `ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListServiceQuotaIncreaseRequestsInTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::IllegalArgumentException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            ListServiceQuotaIncreaseRequestsInTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListServiceQuotas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceQuotasError {
    /// Kind of error that occurred.
    pub kind: ListServiceQuotasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceQuotas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceQuotasErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>Invalid input was provided.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceQuotasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceQuotasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::InvalidPaginationTokenException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListServiceQuotasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceQuotasError {
    fn code(&self) -> Option<&str> {
        ListServiceQuotasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceQuotasError {
    /// Creates a new `ListServiceQuotasError`.
    pub fn new(kind: ListServiceQuotasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceQuotasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceQuotasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceQuotasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceQuotasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotasErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotasErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotasErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotasErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListServiceQuotasErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListServiceQuotasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceQuotasErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListServiceQuotasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceQuotasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::InvalidPaginationTokenException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::ServiceException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListServiceQuotasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>Invalid input was provided.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::InvalidPaginationTokenException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::InvalidPaginationTokenException`.
    pub fn is_invalid_pagination_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InvalidPaginationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListServicesErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            ListServicesErrorKind::InvalidPaginationTokenException(_inner) => Some(_inner),
            ListServicesErrorKind::ServiceException(_inner) => Some(_inner),
            ListServicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutServiceQuotaIncreaseRequestIntoTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutServiceQuotaIncreaseRequestIntoTemplateError {
    /// Kind of error that occurred.
    pub kind: PutServiceQuotaIncreaseRequestIntoTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutServiceQuotaIncreaseRequestIntoTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutServiceQuotaIncreaseRequestIntoTemplateErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
    AwsServiceAccessNotEnabledException(crate::error::AwsServiceAccessNotEnabledException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The account making this call is not a member of an organization.</p>
    NoAvailableOrganizationException(crate::error::NoAvailableOrganizationException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>
    QuotaExceededException(crate::error::QuotaExceededException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The Service Quotas template is not available in this AWS Region.</p>
    TemplatesNotAvailableInRegionException(crate::error::TemplatesNotAvailableInRegionException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutServiceQuotaIncreaseRequestIntoTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::IllegalArgumentException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoSuchResourceException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::QuotaExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutServiceQuotaIncreaseRequestIntoTemplateError {
    fn code(&self) -> Option<&str> {
        PutServiceQuotaIncreaseRequestIntoTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutServiceQuotaIncreaseRequestIntoTemplateError {
    /// Creates a new `PutServiceQuotaIncreaseRequestIntoTemplateError`.
    pub fn new(
        kind: PutServiceQuotaIncreaseRequestIntoTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutServiceQuotaIncreaseRequestIntoTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutServiceQuotaIncreaseRequestIntoTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AwsServiceAccessNotEnabledException`.
    pub fn is_aws_service_access_not_enabled_exception(&self) -> bool {
        matches!(&self.kind, PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AwsServiceAccessNotEnabledException(_))
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoAvailableOrganizationException`.
    pub fn is_no_available_organization_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoAvailableOrganizationException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::QuotaExceededException`.
    pub fn is_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::QuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TemplatesNotAvailableInRegionException`.
    pub fn is_templates_not_available_in_region_exception(&self) -> bool {
        matches!(&self.kind, PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TemplatesNotAvailableInRegionException(_))
    }
    /// Returns `true` if the error kind is `PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutServiceQuotaIncreaseRequestIntoTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::AwsServiceAccessNotEnabledException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::DependencyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::IllegalArgumentException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoAvailableOrganizationException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::NoSuchResourceException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::QuotaExceededException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TemplatesNotAvailableInRegionException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            PutServiceQuotaIncreaseRequestIntoTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RequestServiceQuotaIncrease` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RequestServiceQuotaIncreaseError {
    /// Kind of error that occurred.
    pub kind: RequestServiceQuotaIncreaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RequestServiceQuotaIncrease` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RequestServiceQuotaIncreaseErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can't perform this action because a dependency does not have access.</p>
    DependencyAccessDeniedException(crate::error::DependencyAccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The resource is in an invalid state.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>
    QuotaExceededException(crate::error::QuotaExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RequestServiceQuotaIncreaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RequestServiceQuotaIncreaseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::DependencyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            RequestServiceQuotaIncreaseErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::InvalidResourceStateException(_inner) => {
                _inner.fmt(f)
            }
            RequestServiceQuotaIncreaseErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::QuotaExceededException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            RequestServiceQuotaIncreaseErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RequestServiceQuotaIncreaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RequestServiceQuotaIncreaseError {
    fn code(&self) -> Option<&str> {
        RequestServiceQuotaIncreaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RequestServiceQuotaIncreaseError {
    /// Creates a new `RequestServiceQuotaIncreaseError`.
    pub fn new(kind: RequestServiceQuotaIncreaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RequestServiceQuotaIncreaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RequestServiceQuotaIncreaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RequestServiceQuotaIncreaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RequestServiceQuotaIncreaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::DependencyAccessDeniedException`.
    pub fn is_dependency_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::DependencyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::QuotaExceededException`.
    pub fn is_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::QuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RequestServiceQuotaIncreaseErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RequestServiceQuotaIncreaseErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RequestServiceQuotaIncreaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RequestServiceQuotaIncreaseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::DependencyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            RequestServiceQuotaIncreaseErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::InvalidResourceStateException(_inner) => {
                Some(_inner)
            }
            RequestServiceQuotaIncreaseErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::QuotaExceededException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            RequestServiceQuotaIncreaseErrorKind::ServiceException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RequestServiceQuotaIncreaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The specified tag is a reserved word and cannot be used.</p>
    TagPolicyViolationException(crate::error::TagPolicyViolationException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>You've exceeded the number of tags allowed for a resource. For more information, see <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag restrictions</a> in the <i>Service Quotas User Guide</i>.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagPolicyViolationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NoSuchResourceException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagPolicyViolationException`.
    pub fn is_tag_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            TagResourceErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::TagPolicyViolationException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have sufficient permission to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Invalid input was provided.</p>
    IllegalArgumentException(crate::error::IllegalArgumentException),
    /// <p>The specified resource does not exist.</p>
    NoSuchResourceException(crate::error::NoSuchResourceException),
    /// <p>Something went wrong.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::IllegalArgumentException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NoSuchResourceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::IllegalArgumentException`.
    pub fn is_illegal_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::IllegalArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NoSuchResourceException`.
    pub fn is_no_such_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::NoSuchResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::IllegalArgumentException(_inner) => Some(_inner),
            UntagResourceErrorKind::NoSuchResourceException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>Something went wrong.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceException {}
/// See [`ServiceException`](crate::error::ServiceException)
pub mod service_exception {
    /// A builder for [`ServiceException`](crate::error::ServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceException`](crate::error::ServiceException)
        pub fn build(self) -> crate::error::ServiceException {
            crate::error::ServiceException {
                message: self.message,
            }
        }
    }
}
impl ServiceException {
    /// Creates a new builder-style object to manufacture [`ServiceException`](crate::error::ServiceException)
    pub fn builder() -> crate::error::service_exception::Builder {
        crate::error::service_exception::Builder::default()
    }
}

/// <p>The specified resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchResourceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchResourceException {}
/// See [`NoSuchResourceException`](crate::error::NoSuchResourceException)
pub mod no_such_resource_exception {
    /// A builder for [`NoSuchResourceException`](crate::error::NoSuchResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchResourceException`](crate::error::NoSuchResourceException)
        pub fn build(self) -> crate::error::NoSuchResourceException {
            crate::error::NoSuchResourceException {
                message: self.message,
            }
        }
    }
}
impl NoSuchResourceException {
    /// Creates a new builder-style object to manufacture [`NoSuchResourceException`](crate::error::NoSuchResourceException)
    pub fn builder() -> crate::error::no_such_resource_exception::Builder {
        crate::error::no_such_resource_exception::Builder::default()
    }
}

/// <p>Invalid input was provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalArgumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalArgumentException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalArgumentException {}
/// See [`IllegalArgumentException`](crate::error::IllegalArgumentException)
pub mod illegal_argument_exception {
    /// A builder for [`IllegalArgumentException`](crate::error::IllegalArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalArgumentException`](crate::error::IllegalArgumentException)
        pub fn build(self) -> crate::error::IllegalArgumentException {
            crate::error::IllegalArgumentException {
                message: self.message,
            }
        }
    }
}
impl IllegalArgumentException {
    /// Creates a new builder-style object to manufacture [`IllegalArgumentException`](crate::error::IllegalArgumentException)
    pub fn builder() -> crate::error::illegal_argument_exception::Builder {
        crate::error::illegal_argument_exception::Builder::default()
    }
}

/// <p>You do not have sufficient permission to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>You've exceeded the number of tags allowed for a resource. For more information, see <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag restrictions</a> in the <i>Service Quotas User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The specified tag is a reserved word and cannot be used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyViolationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagPolicyViolationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagPolicyViolationException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagPolicyViolationException {}
/// See [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
pub mod tag_policy_violation_exception {
    /// A builder for [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
        pub fn build(self) -> crate::error::TagPolicyViolationException {
            crate::error::TagPolicyViolationException {
                message: self.message,
            }
        }
    }
}
impl TagPolicyViolationException {
    /// Creates a new builder-style object to manufacture [`TagPolicyViolationException`](crate::error::TagPolicyViolationException)
    pub fn builder() -> crate::error::tag_policy_violation_exception::Builder {
        crate::error::tag_policy_violation_exception::Builder::default()
    }
}

/// <p>The specified resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QuotaExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for QuotaExceededException {}
/// See [`QuotaExceededException`](crate::error::QuotaExceededException)
pub mod quota_exceeded_exception {
    /// A builder for [`QuotaExceededException`](crate::error::QuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QuotaExceededException`](crate::error::QuotaExceededException)
        pub fn build(self) -> crate::error::QuotaExceededException {
            crate::error::QuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl QuotaExceededException {
    /// Creates a new builder-style object to manufacture [`QuotaExceededException`](crate::error::QuotaExceededException)
    pub fn builder() -> crate::error::quota_exceeded_exception::Builder {
        crate::error::quota_exceeded_exception::Builder::default()
    }
}

/// <p>The resource is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceStateException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceStateException {}
/// See [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
pub mod invalid_resource_state_exception {
    /// A builder for [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
        pub fn build(self) -> crate::error::InvalidResourceStateException {
            crate::error::InvalidResourceStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceStateException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    pub fn builder() -> crate::error::invalid_resource_state_exception::Builder {
        crate::error::invalid_resource_state_exception::Builder::default()
    }
}

/// <p>You can't perform this action because a dependency does not have access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyAccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyAccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyAccessDeniedException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyAccessDeniedException {}
/// See [`DependencyAccessDeniedException`](crate::error::DependencyAccessDeniedException)
pub mod dependency_access_denied_exception {
    /// A builder for [`DependencyAccessDeniedException`](crate::error::DependencyAccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyAccessDeniedException`](crate::error::DependencyAccessDeniedException)
        pub fn build(self) -> crate::error::DependencyAccessDeniedException {
            crate::error::DependencyAccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl DependencyAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`DependencyAccessDeniedException`](crate::error::DependencyAccessDeniedException)
    pub fn builder() -> crate::error::dependency_access_denied_exception::Builder {
        crate::error::dependency_access_denied_exception::Builder::default()
    }
}

/// <p>The Service Quotas template is not available in this AWS Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplatesNotAvailableInRegionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TemplatesNotAvailableInRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplatesNotAvailableInRegionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TemplatesNotAvailableInRegionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TemplatesNotAvailableInRegionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TemplatesNotAvailableInRegionException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for TemplatesNotAvailableInRegionException {}
/// See [`TemplatesNotAvailableInRegionException`](crate::error::TemplatesNotAvailableInRegionException)
pub mod templates_not_available_in_region_exception {
    /// A builder for [`TemplatesNotAvailableInRegionException`](crate::error::TemplatesNotAvailableInRegionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplatesNotAvailableInRegionException`](crate::error::TemplatesNotAvailableInRegionException)
        pub fn build(self) -> crate::error::TemplatesNotAvailableInRegionException {
            crate::error::TemplatesNotAvailableInRegionException {
                message: self.message,
            }
        }
    }
}
impl TemplatesNotAvailableInRegionException {
    /// Creates a new builder-style object to manufacture [`TemplatesNotAvailableInRegionException`](crate::error::TemplatesNotAvailableInRegionException)
    pub fn builder() -> crate::error::templates_not_available_in_region_exception::Builder {
        crate::error::templates_not_available_in_region_exception::Builder::default()
    }
}

/// <p>The account making this call is not a member of an organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoAvailableOrganizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoAvailableOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoAvailableOrganizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoAvailableOrganizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoAvailableOrganizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoAvailableOrganizationException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoAvailableOrganizationException {}
/// See [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
pub mod no_available_organization_exception {
    /// A builder for [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
        pub fn build(self) -> crate::error::NoAvailableOrganizationException {
            crate::error::NoAvailableOrganizationException {
                message: self.message,
            }
        }
    }
}
impl NoAvailableOrganizationException {
    /// Creates a new builder-style object to manufacture [`NoAvailableOrganizationException`](crate::error::NoAvailableOrganizationException)
    pub fn builder() -> crate::error::no_available_organization_exception::Builder {
        crate::error::no_available_organization_exception::Builder::default()
    }
}

/// <p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsServiceAccessNotEnabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsServiceAccessNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsServiceAccessNotEnabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AwsServiceAccessNotEnabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AwsServiceAccessNotEnabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "AwsServiceAccessNotEnabledException [AWSServiceAccessNotEnabledException]"
        )?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for AwsServiceAccessNotEnabledException {}
/// See [`AwsServiceAccessNotEnabledException`](crate::error::AwsServiceAccessNotEnabledException)
pub mod aws_service_access_not_enabled_exception {
    /// A builder for [`AwsServiceAccessNotEnabledException`](crate::error::AwsServiceAccessNotEnabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsServiceAccessNotEnabledException`](crate::error::AwsServiceAccessNotEnabledException)
        pub fn build(self) -> crate::error::AwsServiceAccessNotEnabledException {
            crate::error::AwsServiceAccessNotEnabledException {
                message: self.message,
            }
        }
    }
}
impl AwsServiceAccessNotEnabledException {
    /// Creates a new builder-style object to manufacture [`AwsServiceAccessNotEnabledException`](crate::error::AwsServiceAccessNotEnabledException)
    pub fn builder() -> crate::error::aws_service_access_not_enabled_exception::Builder {
        crate::error::aws_service_access_not_enabled_exception::Builder::default()
    }
}

/// <p>Invalid input was provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationTokenException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationTokenException {}
/// See [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
pub mod invalid_pagination_token_exception {
    /// A builder for [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
        pub fn build(self) -> crate::error::InvalidPaginationTokenException {
            crate::error::InvalidPaginationTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationTokenException`](crate::error::InvalidPaginationTokenException)
    pub fn builder() -> crate::error::invalid_pagination_token_exception::Builder {
        crate::error::invalid_pagination_token_exception::Builder::default()
    }
}

/// <p>The quota request template is not associated with your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaTemplateNotInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaTemplateNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaTemplateNotInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaTemplateNotInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaTemplateNotInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaTemplateNotInUseException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaTemplateNotInUseException {}
/// See [`ServiceQuotaTemplateNotInUseException`](crate::error::ServiceQuotaTemplateNotInUseException)
pub mod service_quota_template_not_in_use_exception {
    /// A builder for [`ServiceQuotaTemplateNotInUseException`](crate::error::ServiceQuotaTemplateNotInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaTemplateNotInUseException`](crate::error::ServiceQuotaTemplateNotInUseException)
        pub fn build(self) -> crate::error::ServiceQuotaTemplateNotInUseException {
            crate::error::ServiceQuotaTemplateNotInUseException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaTemplateNotInUseException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaTemplateNotInUseException`](crate::error::ServiceQuotaTemplateNotInUseException)
    pub fn builder() -> crate::error::service_quota_template_not_in_use_exception::Builder {
        crate::error::service_quota_template_not_in_use_exception::Builder::default()
    }
}

/// <p>The organization that your account belongs to is not in All Features mode.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationNotInAllFeaturesModeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OrganizationNotInAllFeaturesModeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationNotInAllFeaturesModeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OrganizationNotInAllFeaturesModeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OrganizationNotInAllFeaturesModeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OrganizationNotInAllFeaturesModeException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for OrganizationNotInAllFeaturesModeException {}
/// See [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
pub mod organization_not_in_all_features_mode_exception {
    /// A builder for [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
        pub fn build(self) -> crate::error::OrganizationNotInAllFeaturesModeException {
            crate::error::OrganizationNotInAllFeaturesModeException {
                message: self.message,
            }
        }
    }
}
impl OrganizationNotInAllFeaturesModeException {
    /// Creates a new builder-style object to manufacture [`OrganizationNotInAllFeaturesModeException`](crate::error::OrganizationNotInAllFeaturesModeException)
    pub fn builder() -> crate::error::organization_not_in_all_features_mode_exception::Builder {
        crate::error::organization_not_in_all_features_mode_exception::Builder::default()
    }
}
